/*!
 * Font Awesome Pro 6.0.0-alpha1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (factory((global['pro-regular-svg-icons'] = {})));
}(this, (function (exports) { 'use strict';

  var prefix = "far";
  var fa0 = {
    prefix: 'far',
    iconName: '0',
    icon: [320, 512, [], "e089", "M160 32C72 32 0 104 0 192V320C0 408 72 480 160 480S320 408 320 320V192C320 104 248 32 160 32ZM256 320C256 373 213 416 160 416S64 373 64 320V192C64 139 107 96 160 96S256 139 256 192V320Z"]
  };
  var fa1 = {
    prefix: 'far',
    iconName: '1',
    icon: [256, 512, [], "e08a", "M256 448C256 466 242 480 224 480H32C14 480 0 466 0 448S14 416 32 416H96V124L50 155C35 164 15 160 5 146C-4 131 0 111 14 101L110 37C120 31 133 30 143 36C154 41 160 52 160 64V416H224C242 416 256 430 256 448Z"]
  };
  var fa2 = {
    prefix: 'far',
    iconName: '2',
    icon: [320, 512, [], "e08b", "M320 448C320 466 306 480 288 480H32C19 480 7 472 2 459C-3 447 1 433 11 424L212 243C228 227 237 206 237 183C237 160 228 138 211 122C176 87 120 87 85 122L54 151C41 163 21 163 9 150C-3 137 -3 117 10 105L40 76C100 17 196 17 256 76C285 104 301 142 301 183C301 223 285 261 256 289L115 416H288C306 416 320 430 320 448Z"]
  };
  var fa3 = {
    prefix: 'far',
    iconName: '3',
    icon: [320, 512, [], "e08c", "M320 343C320 419 259 480 183 480H105C58 480 16 450 2 406C-4 389 5 371 22 365C39 360 57 369 62 386C68 404 85 416 105 416H183C223 416 256 383 256 343C256 303 223 271 183 271H96C83 271 71 263 66 251S64 225 73 216L194 96H32C14 96 0 82 0 64S14 32 32 32H272C285 32 297 40 302 52C307 64 304 78 295 87L174 207H183C259 207 320 268 320 343Z"]
  };
  var fa4 = {
    prefix: 'far',
    iconName: '4',
    icon: [384, 512, [], "e08d", "M384 320C384 338 370 352 352 352H320V448C320 466 306 480 288 480S256 466 256 448V352H32C21 352 11 346 5 337C-1 327 -2 316 3 306L131 50C139 34 158 28 174 35C190 43 197 62 189 78L84 288H256V160C256 142 270 128 288 128S320 142 320 160V288H352C370 288 384 302 384 320Z"]
  };
  var fa5 = {
    prefix: 'far',
    iconName: '5',
    icon: [320, 512, [], "e08e", "M320 343C320 419 259 480 183 480H105C58 480 16 450 2 406C-4 389 5 371 22 365C39 360 57 369 62 386C68 404 85 416 105 416H183C223 416 256 383 256 343C256 303 223 271 183 271H32C22 271 13 266 7 259C1 252 -1 242 1 233L33 58C35 43 49 32 64 32H256C274 32 288 46 288 64S274 96 256 96H91L70 207H183C259 207 320 268 320 343Z"]
  };
  var fa6 = {
    prefix: 'far',
    iconName: '6',
    icon: [320, 512, [], "e08f", "M316 282C302 225 257 179 200 165C184 161 168 160 153 160L217 84C228 71 226 51 213 39C199 28 179 30 167 43L45 191C16 225 0 269 0 314C0 403 70 478 156 480C157 480 159 480 160 480C208 480 253 459 284 421C316 383 327 332 316 282ZM160 416C107 416 64 373 64 320S107 224 160 224S256 267 256 320S213 416 160 416Z"]
  };
  var fa7 = {
    prefix: 'far',
    iconName: '7',
    icon: [320, 512, [], "e090", "M316 80L92 464C86 474 75 480 64 480C58 480 53 479 48 476C33 467 27 447 36 432L232 96H32C14 96 0 82 0 64S14 32 32 32H288C299 32 310 38 316 48C321 58 321 70 316 80Z"]
  };
  var fa8 = {
    prefix: 'far',
    iconName: '8',
    icon: [320, 512, [], "e091", "M268 249C290 226 304 195 304 160C304 89 247 32 176 32H144C73 32 16 89 16 160C16 195 30 226 52 249C21 273 0 310 0 352C0 423 57 480 128 480H192C263 480 320 423 320 352C320 310 299 273 268 249ZM144 96H176C211 96 240 125 240 160S211 224 176 224H144C109 224 80 195 80 160S109 96 144 96ZM192 416H128C93 416 64 387 64 352S93 288 128 288H192C227 288 256 317 256 352S227 416 192 416Z"]
  };
  var fa9 = {
    prefix: 'far',
    iconName: '9',
    icon: [320, 512, [], "e092", "M4 230C18 287 63 333 120 347C136 351 152 352 167 352L103 428C92 441 94 461 107 473C121 484 141 482 153 469L275 321C304 287 320 243 320 198C320 109 250 34 164 32C163 32 161 32 160 32C112 32 67 53 36 91C4 129 -7 180 4 230ZM160 96C213 96 256 139 256 192S213 288 160 288S64 245 64 192S107 96 160 96Z"]
  };
  var faA = {
    prefix: 'far',
    iconName: 'a',
    icon: [384, 512, [], "e093", "M382 436L222 52C217 40 205 32 192 32S167 40 162 52L2 436C-4 452 3 471 20 478C36 484 55 477 62 460L87 400H297L322 460C328 473 339 480 352 480C356 480 360 479 364 478C381 471 388 452 382 436ZM113 336L192 147L271 336H113Z"]
  };
  var faAbacus = {
    prefix: 'far',
    iconName: 'abacus',
    icon: [576, 512, [], "f640", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM128 264H112C103 264 96 271 96 280V296C96 305 103 312 112 312H128V336H112C103 336 96 343 96 352V368C96 377 103 384 112 384H128V432H64C55 432 48 425 48 416V240H128V264ZM128 128H112C103 128 96 135 96 144V160C96 169 103 176 112 176H128V208H48V96C48 87 55 80 64 80H128V128ZM256 264H240C231 264 224 271 224 280V296C224 305 231 312 240 312H256V336H240C231 336 224 343 224 352V368C224 377 231 384 240 384H256V432H160V384H176C185 384 192 377 192 368V352C192 343 185 336 176 336H160V312H176C185 312 192 305 192 296V280C192 271 185 264 176 264H160V240H256V264ZM256 128H240C231 128 224 135 224 144V160C224 169 231 176 240 176H256V208H160V176H176C185 176 192 169 192 160V144C192 135 185 128 176 128H160V80H256V128ZM416 336H400C391 336 384 343 384 352V368C384 377 391 384 400 384H416V432H288V384H304C313 384 320 377 320 368V352C320 343 313 336 304 336H288V312H304C313 312 320 305 320 296V280C320 271 313 264 304 264H288V240H416V336ZM416 128H400C391 128 384 135 384 144V160C384 169 391 176 400 176H416V208H288V176H304C313 176 320 169 320 160V144C320 135 313 128 304 128H288V80H416V128ZM512 432H448V384H464C473 384 480 377 480 368V352C480 343 473 336 464 336H448V240H528V416C528 425 521 432 512 432ZM528 208H448V176H464C473 176 480 169 480 160V144C480 135 473 128 464 128H448V80H512C521 80 528 87 528 96V208Z"]
  };
  var faAcorn = {
    prefix: 'far',
    iconName: 'acorn',
    icon: [448, 512, [], "f6ae", "M448 153C448 100 405 57 352 57H256C260 50 265 42 273 34C282 25 282 9 273 0S248 -9 239 0C218 21 209 42 204 57H96C43 57 0 100 0 153H0V185C0 203 14 217 32 217H48C48 391 177 450 224 473C257 457 400 402 400 217H416C434 217 448 203 448 185L448 153L448 153ZM224 420C135 376 96 295 96 217H352C352 292 317 375 224 420ZM400 169H48L48 153C48 127 70 105 96 105H352C378 105 400 127 400 153V169Z"]
  };
  var faAddressBook = {
    prefix: 'far',
    iconName: 'address-book',
    icon: [512, 512, [], "f2b9", "M240 288H176C132 288 96 324 96 368C96 377 103 384 112 384H304C313 384 320 377 320 368C320 324 284 288 240 288ZM208 256C243 256 272 227 272 192S243 128 208 128C173 128 144 157 144 192S173 256 208 256ZM464 320H448V416H464C473 416 480 409 480 400V336C480 327 473 320 464 320ZM464 64H448V160H464C473 160 480 153 480 144V80C480 71 473 64 464 64ZM464 192H448V288H464C473 288 480 281 480 272V208C480 199 473 192 464 192ZM352 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H352C387 512 416 483 416 448V64C416 29 387 0 352 0ZM368 448C368 457 361 464 352 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H352C361 48 368 55 368 64V448Z"]
  };
  var faAddressCard = {
    prefix: 'far',
    iconName: 'address-card',
    icon: [576, 512, [], "f2bb", "M208 256C243 256 272 227 272 192C272 157 243 128 208 128S144 157 144 192C144 227 173 256 208 256ZM464 232H368C355 232 344 243 344 256S355 280 368 280H464C477 280 488 269 488 256S477 232 464 232ZM240 288H176C132 288 96 324 96 368C96 377 103 384 112 384H304C313 384 320 377 320 368C320 324 284 288 240 288ZM464 152H368C355 152 344 163 344 176S355 200 368 200H464C477 200 488 189 488 176S477 152 464 152ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM528 416C528 425 521 432 512 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H512C521 80 528 87 528 96V416Z"]
  };
  var faAirConditioner = {
    prefix: 'far',
    iconName: 'air-conditioner',
    icon: [576, 512, [], "f8f4", "M464 128H112C103 128 96 135 96 144V160C96 169 103 176 112 176H464C473 176 480 169 480 160V144C480 135 473 128 464 128ZM512 0H64C29 0 0 29 0 64V192C0 227 29 256 64 256H512C547 256 576 227 576 192V64C576 29 547 0 512 0ZM528 192C528 201 521 208 512 208H64C55 208 48 201 48 192V64C48 55 55 48 64 48H512C521 48 528 55 528 64V192ZM208 424C208 446 190 464 168 464S128 446 128 424C128 408 138 393 153 387C165 382 171 368 166 356C161 343 147 338 135 342C102 356 80 388 80 424C80 473 119 512 168 512S256 473 256 424V288H208V424ZM441 310C429 306 415 311 410 324C405 336 411 350 423 355C438 361 448 376 448 392C448 414 430 432 408 432S368 414 368 392V288H320V392C320 441 359 480 408 480S496 441 496 392C496 356 474 324 441 310Z"]
  };
  var faAirFreshener = {
    prefix: 'far',
    iconName: 'air-freshener',
    icon: [384, 512, [], "f5d0", "M377 306L306 224H342C364 224 376 198 362 182L212 9C206 3 199 0 192 0C185 0 178 3 172 9L22 182C8 198 19 224 41 224H78L7 306C-9 324 4 352 28 352H160V384H80C53 384 32 406 32 432V464C32 490 53 512 80 512H304C331 512 352 490 352 464V432C352 406 331 384 304 384H224V352H356C380 352 393 324 377 306ZM304 432V464H80V432H304ZM72 304L160 202C169 192 162 176 148 176H91L192 60L293 176H236C222 176 215 192 224 202L312 304H72ZM192 112C179 112 168 123 168 136S179 160 192 160C205 160 216 149 216 136S205 112 192 112Z"]
  };
  var faAlarmClock = {
    prefix: 'far',
    iconName: 'alarm-clock',
    icon: [512, 512, [], "f34e", "M96 0C43 0 0 43 0 96C0 115 6 133 15 147L161 26C144 10 121 0 96 0ZM416 0C391 0 368 10 351 26L497 147C506 133 512 115 512 96C512 43 469 0 416 0ZM256 64C132 64 32 164 32 288C32 341 51 390 82 428L39 471C30 480 30 496 39 505C44 510 50 512 56 512S68 510 73 505L116 462C154 493 203 512 256 512S358 493 396 462L439 505C444 510 450 512 456 512S468 510 473 505C482 496 482 480 473 471L430 428C461 390 480 341 480 288C480 164 380 64 256 64ZM256 464C159 464 80 385 80 288S159 112 256 112S432 191 432 288S353 464 256 464ZM280 292V184C280 171 269 160 256 160S232 171 232 184V304C232 312 236 319 242 323L306 371C310 374 315 376 320 376C327 376 334 373 339 366C347 356 345 341 334 333L280 292Z"]
  };
  var faAlarmExclamation = {
    prefix: 'far',
    iconName: 'alarm-exclamation',
    icon: [512, 512, [], "f843", "M96 0C43 0 0 43 0 96C0 115 6 133 15 147L161 26C144 10 121 0 96 0ZM256 64C132 64 32 164 32 288C32 341 51 390 82 428L39 471C30 480 30 496 39 505C44 510 50 512 56 512S68 510 73 505L116 462C154 493 203 512 256 512S358 493 396 462L439 505C444 510 450 512 456 512S468 510 473 505C482 496 482 480 473 471L430 428C461 390 480 341 480 288C480 164 380 64 256 64ZM256 464C159 464 80 385 80 288S159 112 256 112S432 191 432 288S353 464 256 464ZM416 0C391 0 368 10 351 26L497 147C506 133 512 115 512 96C512 43 469 0 416 0ZM256 352C238 352 224 366 224 384S238 416 256 416S288 402 288 384S274 352 256 352ZM256 320C269 320 280 309 280 296V184C280 171 269 160 256 160S232 171 232 184V296C232 309 243 320 256 320Z"]
  };
  var faAlarmPlus = {
    prefix: 'far',
    iconName: 'alarm-plus',
    icon: [512, 512, [], "f844", "M96 0C43 0 0 43 0 96C0 115 6 133 15 147L161 26C144 10 121 0 96 0ZM328 264H280V216C280 203 269 192 256 192S232 203 232 216V264H184C171 264 160 275 160 288S171 312 184 312H232V360C232 373 243 384 256 384S280 373 280 360V312H328C341 312 352 301 352 288S341 264 328 264ZM256 64C132 64 32 164 32 288C32 341 51 390 82 428L39 471C30 480 30 496 39 505C44 510 50 512 56 512S68 510 73 505L116 462C154 493 203 512 256 512S358 493 396 462L439 505C444 510 450 512 456 512S468 510 473 505C482 496 482 480 473 471L430 428C461 390 480 341 480 288C480 164 380 64 256 64ZM256 464C159 464 80 385 80 288S159 112 256 112S432 191 432 288S353 464 256 464ZM416 0C391 0 368 10 351 26L497 147C506 133 512 115 512 96C512 43 469 0 416 0Z"]
  };
  var faAlarmSnooze = {
    prefix: 'far',
    iconName: 'alarm-snooze',
    icon: [512, 512, [], "f845", "M96 0C43 0 0 43 0 96C0 115 6 133 15 147L161 26C144 10 121 0 96 0ZM256 64C132 64 32 164 32 288C32 341 51 390 82 428L39 471C30 480 30 496 39 505C44 510 50 512 56 512S68 510 73 505L116 462C154 493 203 512 256 512S358 493 396 462L439 505C444 510 450 512 456 512S468 510 473 505C482 496 482 480 473 471L430 428C461 390 480 341 480 288C480 164 380 64 256 64ZM256 464C159 464 80 385 80 288S159 112 256 112S432 191 432 288S353 464 256 464ZM416 0C391 0 368 10 351 26L497 147C506 133 512 115 512 96C512 43 469 0 416 0ZM314 336H248L332 231C338 224 339 214 335 206C331 197 323 192 314 192H198C185 192 174 203 174 216S185 240 198 240H264L180 345C174 352 173 362 177 370C181 379 189 384 198 384H314C327 384 338 373 338 360S327 336 314 336Z"]
  };
  var faAlbum = {
    prefix: 'far',
    iconName: 'album',
    icon: [448, 512, [], "f89f", "M224 112C144 112 80 176 80 256S144 400 224 400S368 336 368 256S304 112 224 112ZM224 288C206 288 192 274 192 256S206 224 224 224S256 238 256 256S242 288 224 288ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416Z"]
  };
  var faAlbumCollection = {
    prefix: 'far',
    iconName: 'album-collection',
    icon: [512, 512, [], "f8a0", "M480 24C480 11 469 0 456 0H56C43 0 32 11 32 24V48H480V24ZM496 104C496 91 485 80 472 80H40C27 80 16 91 16 104V128H496V104ZM256 438C330 438 394 395 398 339C401 280 338 230 256 230S111 280 114 339C118 395 182 438 256 438ZM256 320C273 320 286 330 286 342C286 354 272 364 256 364C240 364 226 354 226 342C226 330 239 320 256 320ZM480 160H32C8 160 -1 182 0 195L24 454C27 487 54 512 87 512H425C458 512 485 487 488 454L512 195C513 182 504 160 480 160ZM441 449C440 458 433 464 425 464H87C79 464 72 458 71 449L50 208H463L441 449Z"]
  };
  var faAlicorn = {
    prefix: 'far',
    iconName: 'alicorn',
    icon: [640, 512, [], "f6b0", "M480 96C480 87 473 80 464 80S448 87 448 96S455 112 464 112S480 105 480 96ZM632 48H546L543 45C559 40 572 27 576 10C577 5 573 0 568 0H432C364 0 306 48 292 112H266C227 112 188 98 161 70C157 66 152 64 147 64C137 64 128 72 128 83C128 169 188 246 268 266C278 269 288 261 288 251V234C288 227 284 221 277 219C240 209 208 181 191 146C214 155 239 160 266 160H336V144C336 91 379 48 432 48H483L528 102V168C528 172 525 177 521 178L490 189C488 189 480 192 473 185L448 160H416V240C416 266 403 289 384 304V464H336V320L196 289L168 369L192 464H150L129 376C128 371 128 365 129 360L152 283C129 274 112 251 112 224C112 209 117 195 126 185C117 170 110 155 105 138C97 145 90 152 84 160C37 162 0 201 0 248V296C0 309 11 320 24 320S48 309 48 296V248C48 235 55 224 65 216C65 219 64 221 64 224C64 254 76 282 96 303L83 346C79 360 79 374 82 387L106 487C110 502 123 512 137 512H212C233 512 248 492 243 472L218 371L227 345L288 358V480C288 498 302 512 320 512H400C418 512 432 498 432 480V324C452 302 463 273 464 243C464 242 464 234 464 234C485 241 502 235 505 234L536 224C560 215 576 193 576 168V102C576 97 575 92 573 88L636 63C643 58 640 48 632 48Z"]
  };
  var faAlien = {
    prefix: 'far',
    iconName: 'alien',
    icon: [448, 512, [], "f8f5", "M224 0C100 0 0 88 0 232C0 344 134 457 195 502C212 515 236 515 253 502C314 457 448 344 448 232C448 88 348 0 224 0ZM224 464C114 382 48 295 48 232C48 122 119 48 224 48S400 122 400 232C400 295 334 382 224 464ZM130 224H98C89 224 82 231 82 240C82 284 118 320 162 320H194C203 320 210 313 210 304C210 260 174 224 130 224ZM352 224L322 224C278 224 242 260 242 304C242 313 249 320 258 320H290C334 320 370 284 370 240C370 231 361 224 352 224Z"]
  };
  var faAlien8bit = {
    prefix: 'far',
    iconName: 'alien-8bit',
    icon: [576, 512, [], "f8f6", "M560 128H544C535 128 528 135 528 144V240H480V176C480 167 473 160 464 160H432V96H464C473 96 480 89 480 80V48C480 39 473 32 464 32H448C439 32 432 39 432 48V64H400C391 64 384 71 384 80V128H192V80C192 71 185 64 176 64H144V48C144 39 137 32 128 32H112C103 32 96 39 96 48V80C96 89 103 96 112 96H144V160H112C103 160 96 167 96 176V240H48V144C48 135 41 128 32 128H16C7 128 0 135 0 144V272C0 281 7 288 16 288H64V368C64 377 71 384 80 384H128V464C128 473 135 480 144 480H240C249 480 256 473 256 464V448C256 439 249 432 240 432H176V384H400V432H336C327 432 320 439 320 448V464C320 473 327 480 336 480H432C441 480 448 473 448 464V384H496C505 384 512 377 512 368V288H560C569 288 576 281 576 272V144C576 135 569 128 560 128ZM464 336H112V288H144V208H192V176H384V208H432V288H464V336ZM240 224H208C199 224 192 231 192 240V288C192 297 199 304 208 304H240C249 304 256 297 256 288V240C256 231 249 224 240 224ZM368 224H336C327 224 320 231 320 240V288C320 297 327 304 336 304H368C377 304 384 297 384 288V240C384 231 377 224 368 224Z"]
  };
  var faAlignCenter = {
    prefix: 'far',
    iconName: 'align-center',
    icon: [448, 512, [], "f037", "M120 88H328C341 88 352 77 352 64V64C352 51 341 40 328 40H120C107 40 96 51 96 64V64C96 77 107 88 120 88ZM424 424H24C11 424 0 435 0 448V448C0 461 11 472 24 472H424C437 472 448 461 448 448V448C448 435 437 424 424 424ZM328 344C341 344 352 333 352 320V320C352 307 341 296 328 296H120C107 296 96 307 96 320V320C96 333 107 344 120 344H328ZM424 168H24C11 168 0 179 0 192V192C0 205 11 216 24 216H424C437 216 448 205 448 192V192C448 179 437 168 424 168Z"]
  };
  var faAlignJustify = {
    prefix: 'far',
    iconName: 'align-justify',
    icon: [448, 512, [], "f039", "M424 296H24C11 296 0 307 0 320V320C0 333 11 344 24 344H424C437 344 448 333 448 320V320C448 307 437 296 424 296ZM424 424H24C11 424 0 435 0 448V448C0 461 11 472 24 472H424C437 472 448 461 448 448V448C448 435 437 424 424 424ZM424 168H24C11 168 0 179 0 192V192C0 205 11 216 24 216H424C437 216 448 205 448 192V192C448 179 437 168 424 168ZM424 40H24C11 40 0 51 0 64V64C0 77 11 88 24 88H424C437 88 448 77 448 64V64C448 51 437 40 424 40Z"]
  };
  var faAlignLeft = {
    prefix: 'far',
    iconName: 'align-left',
    icon: [448, 512, [], "f036", "M21 88H267C279 88 288 79 288 67V61C288 49 279 40 267 40H21C9 40 0 49 0 61V67C0 79 9 88 21 88ZM21 344H267C279 344 288 335 288 323V317C288 305 279 296 267 296H21C9 296 0 305 0 317V323C0 335 9 344 21 344ZM424 168H24C11 168 0 179 0 192V192C0 205 11 216 24 216H424C437 216 448 205 448 192V192C448 179 437 168 424 168ZM424 424H24C11 424 0 435 0 448V448C0 461 11 472 24 472H424C437 472 448 461 448 448V448C448 435 437 424 424 424Z"]
  };
  var faAlignRight = {
    prefix: 'far',
    iconName: 'align-right',
    icon: [448, 512, [], "f038", "M424 424H24C11 424 0 435 0 448V448C0 461 11 472 24 472H424C437 472 448 461 448 448V448C448 435 437 424 424 424ZM427 296H181C169 296 160 305 160 317V323C160 335 169 344 181 344H427C439 344 448 335 448 323V317C448 305 439 296 427 296ZM427 40H181C169 40 160 49 160 61V67C160 79 169 88 181 88H427C439 88 448 79 448 67V61C448 49 439 40 427 40ZM424 168H24C11 168 0 179 0 192V192C0 205 11 216 24 216H424C437 216 448 205 448 192V192C448 179 437 168 424 168Z"]
  };
  var faAlignSlash = {
    prefix: 'far',
    iconName: 'align-slash',
    icon: [640, 512, [], "f846", "M120 344H316L254 296H120C107 296 96 307 96 320C96 333 107 344 120 344ZM120 424C107 424 96 435 96 448C96 461 107 472 120 472H479L418 424H120ZM631 469L471 344H520C533 344 544 333 544 320C544 307 533 296 520 296H410L308 216H520C533 216 544 205 544 192C544 179 533 168 520 168H247L145 88H520C533 88 544 77 544 64C544 51 533 40 520 40H120C111 40 103 45 99 53L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469Z"]
  };
  var faAlt = {
    prefix: 'far',
    iconName: 'alt',
    icon: [512, 512, [], "e094", "M488 112C501 112 512 101 512 88S501 64 488 64H384C377 64 369 67 365 73L116 400H24C11 400 0 411 0 424S11 448 24 448H128C135 448 143 445 147 439L396 112H488ZM488 400H344C331 400 320 411 320 424S331 448 344 448H488C501 448 512 437 512 424S501 400 488 400Z"]
  };
  var faAmpGuitar = {
    prefix: 'far',
    iconName: 'amp-guitar',
    icon: [512, 512, [], "f8a1", "M384 336C393 336 400 329 400 320S393 304 384 304S368 311 368 320S375 336 384 336ZM320 336C329 336 336 329 336 320S329 304 320 304S304 311 304 320S311 336 320 336ZM416 384C425 384 432 377 432 368S425 352 416 352S400 359 400 368S407 384 416 384ZM352 384C361 384 368 377 368 368S361 352 352 352S336 359 336 368S343 384 352 384ZM128 400C119 400 112 407 112 416S119 432 128 432S144 425 144 416S137 400 128 400ZM192 400C183 400 176 407 176 416S183 432 192 432S208 425 208 416S201 400 192 400ZM288 384C297 384 304 377 304 368S297 352 288 352S272 359 272 368S279 384 288 384ZM384 400C375 400 368 407 368 416S375 432 384 432S400 425 400 416S393 400 384 400ZM320 400C311 400 304 407 304 416S311 432 320 432S336 425 336 416S329 400 320 400ZM256 400C247 400 240 407 240 416S247 432 256 432S272 425 272 416S265 400 256 400ZM256 336C265 336 272 329 272 320S265 304 256 304S240 311 240 320S247 336 256 336ZM192 152C179 152 168 163 168 176S179 200 192 200S216 189 216 176S205 152 192 152ZM112 152C99 152 88 163 88 176S99 200 112 200S136 189 136 176S125 152 112 152ZM448 80H402C378 53 322 0 256 0S134 53 110 80H64C29 80 0 109 0 144V448C0 483 29 512 64 512H448C483 512 512 483 512 448V144C512 109 483 80 448 80ZM256 48C283 48 310 63 332 80H180C202 63 229 48 256 48ZM464 448C464 457 457 464 448 464H64C55 464 48 457 48 448V272H464V448ZM464 224H48V144C48 135 55 128 64 128H448C457 128 464 135 464 144V224ZM96 384C105 384 112 377 112 368S105 352 96 352S80 359 80 368S87 384 96 384ZM192 336C201 336 208 329 208 320S201 304 192 304S176 311 176 320S183 336 192 336ZM224 384C233 384 240 377 240 368S233 352 224 352S208 359 208 368S215 384 224 384ZM128 336C137 336 144 329 144 320S137 304 128 304S112 311 112 320S119 336 128 336ZM160 384C169 384 176 377 176 368S169 352 160 352S144 359 144 368S151 384 160 384ZM320 152C307 152 296 163 296 176S307 200 320 200S344 189 344 176S333 152 320 152ZM400 152C387 152 376 163 376 176S387 200 400 200S424 189 424 176S413 152 400 152Z"]
  };
  var faAmpersand = {
    prefix: 'far',
    iconName: 'ampersand',
    icon: [384, 512, [], "e095", "M375 426L319 366L379 273C388 259 384 239 369 229C355 220 335 224 325 239L274 317L201 239L253 199C275 182 288 155 288 126C288 74 246 32 193 32H143C90 32 48 74 48 126C48 153 58 179 77 200L107 232L42 282C15 304 0 335 0 369C0 430 50 480 112 480H172C216 480 257 458 282 422C282 422 282 422 282 422C283 422 283 422 283 422L283 421L329 470C335 477 343 480 352 480C360 480 368 477 374 471C387 459 387 439 375 426ZM143 96H193C210 96 224 110 224 126C224 135 220 144 213 149L158 192L124 156C116 148 112 137 112 126C112 110 126 96 143 96ZM229 386C216 405 195 416 172 416H112C85 416 64 395 64 369C64 355 70 341 81 333L151 279L238 373L229 386Z"]
  };
  var faAnchor = {
    prefix: 'far',
    iconName: 'anchor',
    icon: [576, 512, [], "f13d", "M568 310L512 262C503 254 489 254 480 262L424 310C414 318 413 334 422 344C430 354 445 355 456 346L472 333C469 405 409 464 336 464H312V256H360C373 256 384 245 384 232S373 208 360 208H312V156C344 146 368 116 368 80C368 36 332 0 288 0C244 0 208 36 208 80C208 116 232 146 264 156V208H216C203 208 192 219 192 232S203 256 216 256H264V464H240C167 464 107 405 104 333L120 346C125 350 130 352 136 352C143 352 149 349 154 344C163 334 162 318 152 310L96 262C87 254 73 254 64 262L8 310C-2 318 -3 334 6 344C14 354 30 355 40 346L56 332C58 432 140 512 240 512H336C436 512 518 432 520 332L536 346C541 350 546 352 552 352C559 352 565 349 570 344C579 334 578 318 568 310ZM288 48C306 48 320 62 320 80S306 112 288 112S256 98 256 80S270 48 288 48ZM496 312L496 312L496 312H496Z"]
  };
  var faAngel = {
    prefix: 'far',
    iconName: 'angel',
    icon: [576, 512, [], "f779", "M572 453L534 374C527 361 527 345 534 331C550 298 560 294 560 256C560 205 513 160 459 160C434 160 411 170 393 188L321 262C310 258 299 256 288 256S266 258 256 262L183 188C165 170 142 160 117 160C63 160 16 205 16 256C16 294 26 298 43 332C49 345 49 361 43 375L4 453C-10 483 14 512 41 512H535C563 512 586 482 572 453ZM52 464L86 395C99 369 99 337 86 310C80 299 76 291 72 285C65 273 64 271 64 256C64 231 90 208 117 208C129 208 140 213 149 222L214 288C207 295 200 304 196 313L120 464H52ZM174 464L238 335C248 316 267 304 288 304C309 304 328 316 338 335L402 464H174ZM456 464L381 313C376 303 369 295 362 287L427 222C436 213 447 208 459 208C486 208 512 231 512 256C512 271 511 273 504 285C500 291 496 299 490 310C477 337 477 369 490 395L524 464H456ZM208 144C208 188 244 224 288 224S368 188 368 144S332 64 288 64S208 100 208 144ZM320 144C320 162 306 176 288 176S256 162 256 144S270 112 288 112S320 126 320 144ZM177 137H177C178 124 181 112 186 101C175 95 168 88 168 80C168 58 222 40 288 40C354 40 408 58 408 80C408 88 401 95 390 101C395 112 398 124 399 137H399C429 123 448 102 448 80C448 36 376 0 288 0S128 36 128 80C128 102 147 123 177 137Z"]
  };
  var faAngleDown = {
    prefix: 'far',
    iconName: 'angle-down',
    icon: [384, 512, [], "f107", "M361 217L209 361C204 366 198 368 192 368S180 366 175 361L23 217C14 208 13 193 23 184C32 174 47 174 57 183L192 311L327 183C337 174 352 174 361 184C371 193 370 208 361 217Z"]
  };
  var faAngleLeft = {
    prefix: 'far',
    iconName: 'angle-left',
    icon: [256, 512, [], "f104", "M167 425L23 273C18 268 16 262 16 256C16 250 18 244 23 239L167 87C176 78 191 77 200 87C210 96 210 111 201 121L73 256L201 391C210 401 210 416 200 425C191 435 176 434 167 425Z"]
  };
  var faAngleRight = {
    prefix: 'far',
    iconName: 'angle-right',
    icon: [256, 512, [], "f105", "M57 87L201 239C206 244 208 250 208 256C208 262 206 268 201 273L57 425C48 434 33 435 24 425C14 416 13 401 23 391L151 256L23 121C13 111 14 96 24 87C33 77 48 78 57 87Z"]
  };
  var faAngleUp = {
    prefix: 'far',
    iconName: 'angle-up',
    icon: [384, 512, [], "f106", "M23 295L175 151C180 146 186 144 192 144S204 146 209 151L361 295C370 304 371 319 361 328C352 338 337 338 327 329L192 201L57 329C47 338 32 338 23 328C13 319 14 304 23 295Z"]
  };
  var faAnglesDown = {
    prefix: 'far',
    iconName: 'angles-down',
    icon: [384, 512, [], "f103", "M328 270L192 392L56 270C51 266 46 264 40 264C33 264 27 267 22 272C13 282 14 297 24 306L176 442C185 450 199 450 208 442L360 306C370 297 371 282 362 272C353 262 338 261 328 270ZM176 250C185 258 199 258 208 250L360 114C370 105 371 90 362 80C353 70 338 69 328 78L192 200L56 78C51 74 46 72 40 72C33 72 27 75 22 80C13 90 14 105 24 114L176 250Z"]
  };
  var faAnglesLeft = {
    prefix: 'far',
    iconName: 'angles-left',
    icon: [448, 512, [], "f100", "M214 388L92 252L214 116C218 111 220 106 220 100C220 93 217 87 212 82C202 73 187 74 178 84L42 236C34 245 34 259 42 268L178 420C187 430 202 431 212 422C222 413 223 398 214 388ZM234 236C226 245 226 259 234 268L370 420C379 430 394 431 404 422C414 413 415 398 406 388L284 252L406 116C410 111 412 106 412 100C412 93 409 87 404 82C394 73 379 74 370 84L234 236Z"]
  };
  var faAnglesRight = {
    prefix: 'far',
    iconName: 'angles-right',
    icon: [448, 512, [], "f101", "M230 116L352 252L230 388C226 393 224 398 224 404C224 411 227 417 232 422C242 431 257 430 266 420L402 268C410 259 410 245 402 236L266 84C257 74 242 73 232 82C222 91 221 106 230 116ZM210 268C218 259 218 245 210 236L74 84C65 74 50 73 40 82C30 91 29 106 38 116L160 252L38 388C34 393 32 398 32 404C32 411 35 417 40 422C50 431 65 430 74 420L210 268Z"]
  };
  var faAnglesUp = {
    prefix: 'far',
    iconName: 'angles-up',
    icon: [384, 512, [], "f102", "M56 242L192 120L328 242C333 246 338 248 344 248C351 248 357 245 362 240C371 230 370 215 360 206L208 70C199 62 185 62 176 70L24 206C14 215 13 230 22 240C31 250 46 251 56 242ZM208 262C199 254 185 254 176 262L24 398C14 407 13 422 22 432C31 442 46 443 56 434L192 312L328 434C333 438 338 440 344 440C351 440 357 437 362 432C371 422 370 407 360 398L208 262Z"]
  };
  var faAnkh = {
    prefix: 'far',
    iconName: 'ankh',
    icon: [320, 512, [], "f644", "M296 272H227C257 236 282 184 282 137C282 53 227 0 160 0S38 53 38 137C38 184 63 236 93 272H24C11 272 0 283 0 296V296C0 309 11 320 24 320H136V488C136 501 147 512 160 512H160C173 512 184 501 184 488V320H296C309 320 320 309 320 296V296C320 283 309 272 296 272ZM160 48C204 48 234 84 234 137C234 191 184 257 160 270C136 257 86 191 86 137C86 84 116 48 160 48Z"]
  };
  var faAppleCrate = {
    prefix: 'far',
    iconName: 'apple-crate',
    icon: [512, 512, [], "f6b1", "M210 50C222 38 225 18 224 0C211 -1 188 0 174 14C157 30 160 60 161 64C179 65 198 62 210 50ZM402 50C414 38 417 18 415 0C402 -1 380 0 365 14C349 30 352 60 352 64C371 65 390 62 402 50ZM82 192C82 190 82 189 81 188C78 171 80 145 90 130C96 123 102 121 105 120C112 119 133 123 148 132L160 138L172 132C186 124 208 119 215 120C221 121 226 125 230 130C240 145 242 171 239 188C238 190 238 191 238 192H286C289 174 288 152 282 132C282 131 282 131 283 130C288 123 293 121 297 120C304 119 326 123 340 132L352 138L364 132C378 124 400 119 407 120C411 121 416 123 422 130C432 145 434 171 431 188C430 190 430 191 430 192H478C482 165 479 129 461 103C450 87 434 76 415 73H415C397 70 371 76 352 84C333 76 307 70 289 73C276 75 265 81 256 89C247 81 236 75 223 73H223C205 70 179 76 160 84C141 76 115 70 97 73C78 76 62 87 51 103C33 129 30 165 34 192H82ZM480 224H32C14 224 0 238 0 256V480C0 498 14 512 32 512H480C498 512 512 498 512 480V256C512 238 498 224 480 224ZM464 464H48V392H464V464ZM464 344H48V272H464V344ZM96 320C105 320 112 313 112 304S105 288 96 288S80 295 80 304S87 320 96 320ZM416 320C425 320 432 313 432 304S425 288 416 288S400 295 400 304S407 320 416 320ZM96 448C105 448 112 441 112 432S105 416 96 416S80 423 80 432S87 448 96 448ZM416 448C425 448 432 441 432 432S425 416 416 416S400 423 400 432S407 448 416 448Z"]
  };
  var faAppleWhole = {
    prefix: 'far',
    iconName: 'apple-whole',
    icon: [448, 512, [], "f5d1", "M415 178C397 151 371 134 342 129C307 123 256 138 224 153C192 138 141 123 106 129C77 134 51 151 33 178C5 218 -7 280 4 337C19 422 70 512 167 512C181 512 195 508 209 500C218 495 229 495 238 500C253 508 267 512 281 512C378 512 429 422 444 337C455 280 443 218 415 178ZM397 329C393 351 368 464 281 464C276 464 269 462 261 458C250 452 237 448 224 448S198 452 186 458C179 462 172 464 167 464C80 464 55 351 51 329C43 284 51 235 72 205C83 189 97 180 114 177C127 174 168 177 224 207C280 177 321 174 333 177C350 180 365 189 376 205C396 235 405 284 397 329ZM222 112C241 112 274 109 296 88C326 57 319 1 319 1S314 0 306 0C287 0 253 3 232 24C202 55 209 111 209 111S214 112 222 112Z"]
  };
  var faArchway = {
    prefix: 'far',
    iconName: 'archway',
    icon: [576, 512, [], "f557", "M552 48C565 48 576 37 576 24V24C576 11 565 0 552 0H24C11 0 0 11 0 24V24C0 37 11 48 24 48H32V464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H176C185 512 192 505 192 496L192 323C192 274 227 231 275 225C334 217 384 263 384 320V496C384 505 391 512 400 512H552C565 512 576 501 576 488V488C576 475 565 464 552 464H544V48H552ZM496 48V88H80V48H496ZM432 464V320C432 241 367 176 288 176S144 241 144 320V464H80V136H496V464H432Z"]
  };
  var faArrowDown = {
    prefix: 'far',
    iconName: 'arrow-down',
    icon: [448, 512, [], "f063", "M409 297L241 473C237 477 231 480 224 480S211 477 207 473L39 297C29 287 30 272 39 263C49 253 64 254 73 263L200 396V56C200 43 211 32 224 32S248 43 248 56V396L375 263C384 254 399 253 409 263C418 272 418 287 409 297Z"]
  };
  var faArrowDown19 = {
    prefix: 'far',
    iconName: 'arrow-down-1-9',
    icon: [448, 512, [], "f162", "M312 176C299 176 288 187 288 200S299 224 312 224H392C405 224 416 213 416 200S405 176 392 176H376V56C376 47 371 39 364 35C356 31 347 31 340 35L300 59C288 66 285 81 291 92C298 104 313 107 324 101L328 98V176H312ZM168 352C161 352 155 355 150 360L120 394V56C120 43 109 32 96 32C83 32 72 43 72 56V394L42 360C33 350 18 350 8 358C-2 367 -3 383 6 392L78 472C87 483 105 483 114 472L186 392C195 383 194 367 184 358C180 354 174 352 168 352ZM352 256C308 256 272 292 272 336S308 416 352 416C352 416 353 416 353 416C348 422 342 427 336 432L330 437C319 445 317 460 325 470C330 477 337 480 344 480C349 480 354 478 358 475L365 470C407 439 432 389 432 336C432 292 396 256 352 256ZM352 368C334 368 320 354 320 336S334 304 352 304C370 304 384 318 384 336S370 368 352 368Z"]
  };
  var faArrowDown91 = {
    prefix: 'far',
    iconName: 'arrow-down-9-1',
    icon: [448, 512, [], "f886", "M168 352C161 352 155 355 150 360L120 394V56C120 43 109 32 96 32C83 32 72 43 72 56V394L42 360C33 350 18 350 8 358C-2 367 -3 383 6 392L78 472C87 483 105 483 114 472L186 392C195 383 194 367 184 358C180 354 174 352 168 352ZM392 432H376V312C376 303 371 295 364 291C356 287 347 287 340 291L300 315C288 322 285 337 291 348C298 360 313 363 324 357L328 354V432H312C299 432 288 443 288 456S299 480 312 480H392C405 480 416 469 416 456S405 432 392 432ZM352 192C352 192 353 192 353 192C348 198 342 203 336 208L330 213C319 221 317 236 325 246C330 253 337 256 344 256C349 256 354 254 358 251L365 246C407 215 432 165 432 112C432 68 396 32 352 32C308 32 272 68 272 112S308 192 352 192ZM352 80C370 80 384 94 384 112S370 144 352 144C334 144 320 130 320 112S334 80 352 80Z"]
  };
  var faArrowDownAZ = {
    prefix: 'far',
    iconName: 'arrow-down-a-z',
    icon: [448, 512, [], "f15d", "M150 360L120 393V56C120 43 109 32 96 32S72 43 72 56V393L42 360C33 350 18 349 8 358S-3 382 6 392L78 472C83 477 89 480 96 480S109 477 114 472L186 392C195 382 194 367 184 358C174 349 159 350 150 360ZM445 189L373 45C365 29 339 29 331 45L259 189C253 201 257 216 269 221C281 227 296 223 301 211L307 200H397L403 211C407 219 415 224 424 224C428 224 431 223 435 221C447 216 451 201 445 189ZM331 152L352 110L373 152H331ZM408 432H345L427 327C433 319 434 310 430 301C426 293 417 288 408 288H296C283 288 272 299 272 312S283 336 296 336H359L277 441C271 449 270 458 274 467C278 475 287 480 296 480H408C421 480 432 469 432 456S421 432 408 432Z"]
  };
  var faArrowDownArrowUp = {
    prefix: 'far',
    iconName: 'arrow-down-arrow-up',
    icon: [384, 512, [], "f883", "M378 120L306 40C297 30 279 30 270 40L198 120C189 130 190 145 200 154C210 163 225 162 234 152L264 119V456C264 469 275 480 288 480C301 480 312 469 312 456V119L342 152C347 157 353 160 360 160C366 160 371 158 376 154C386 145 387 130 378 120ZM150 360L120 393V56C120 43 109 32 96 32C83 32 72 43 72 56V393L42 360C33 350 18 349 8 358S-3 382 6 392L78 472C83 477 89 480 96 480S109 477 114 472L186 392C195 382 194 367 184 358C174 349 159 350 150 360Z"]
  };
  var faArrowDownBigSmall = {
    prefix: 'far',
    iconName: 'arrow-down-big-small',
    icon: [640, 512, [], "f88c", "M288 352V448C288 466 302 480 320 480H480C498 480 512 466 512 448V352C512 334 498 320 480 320H320C302 320 288 334 288 352ZM336 368H464V432H336V368ZM576 224V64C576 46 562 32 544 32H320C302 32 288 46 288 64V224C288 242 302 256 320 256H544C562 256 576 242 576 224ZM528 208H336V80H528V208ZM142 472C151 483 169 483 178 472L250 392C259 382 258 367 248 358C238 350 223 350 214 360L184 394V56C184 43 173 32 160 32S136 43 136 56V394L106 360C101 355 95 352 88 352C82 352 77 354 72 358C62 367 61 382 70 392L142 472Z"]
  };
  var faArrowDownFromLine = {
    prefix: 'far',
    iconName: 'arrow-down-from-line',
    icon: [384, 512, [], "f345", "M24 80H360C373 80 384 69 384 56S373 32 360 32H24C11 32 0 43 0 56S11 80 24 80ZM303 304L216 396V152C216 139 205 128 192 128S168 139 168 152V396L81 304C77 299 70 296 64 296C58 296 52 298 48 303C38 312 37 327 47 337L175 473C184 482 200 482 209 473L337 337C347 327 346 312 336 303C327 294 312 294 303 304Z"]
  };
  var faArrowDownLeftAndArrowUpRightToCenter = {
    prefix: 'far',
    iconName: 'arrow-down-left-and-arrow-up-right-to-center',
    icon: [512, 512, [], "e096", "M287 237C290 239 293 239 296 239H440C453 239 464 228 464 215S453 191 440 191H354L489 56C498 47 498 32 489 22S464 13 455 22L320 157V71C320 58 309 47 296 47S272 58 272 71V215C272 218 273 221 274 224C276 230 281 235 287 237ZM225 273C222 272 219 271 216 271H72C59 271 48 282 48 295S59 319 72 319H158L23 454C14 464 14 479 23 488S48 498 57 488L192 353V439C192 452 203 463 216 463S240 452 240 439V295C240 292 239 289 238 286C236 280 231 276 225 273Z"]
  };
  var faArrowDownLong = {
    prefix: 'far',
    iconName: 'arrow-down-long',
    icon: [320, 512, [], "f175", "M7 335C12 330 18 328 24 328S36 330 41 335L136 430V24C136 11 147 0 160 0S184 11 184 24V430L279 335C288 326 304 326 313 335S322 360 313 369L177 505C168 514 152 514 143 505L7 369C-2 360 -2 344 7 335Z"]
  };
  var faArrowDownShortWide = {
    prefix: 'far',
    iconName: 'arrow-down-short-wide',
    icon: [512, 512, [], "f884", "M150 360L120 393V56C120 43 109 32 96 32C83 32 72 43 72 56V393L42 360C33 350 18 349 8 358S-3 382 6 392L78 472C83 477 89 480 96 480C103 480 109 477 114 472L186 392C195 382 194 367 184 358C174 349 159 350 150 360ZM488 432H248C235 432 224 443 224 456S235 480 248 480H488C501 480 512 469 512 456S501 432 488 432ZM248 352H424C437 352 448 341 448 328S437 304 424 304H248C235 304 224 315 224 328S235 352 248 352ZM248 224H360C373 224 384 213 384 200S373 176 360 176H248C235 176 224 187 224 200S235 224 248 224ZM248 96H296C309 96 320 85 320 72S309 48 296 48H248C235 48 224 59 224 72S235 96 248 96Z"]
  };
  var faArrowDownSmallBig = {
    prefix: 'far',
    iconName: 'arrow-down-small-big',
    icon: [512, 512, [], "f88d", "M256 192H416C434 192 448 178 448 160V64C448 46 434 32 416 32H256C238 32 224 46 224 64V160C224 178 238 192 256 192ZM272 80H400V144H272V80ZM480 256H256C238 256 224 270 224 288V448C224 466 238 480 256 480H480C498 480 512 466 512 448V288C512 270 498 256 480 256ZM464 432H272V304H464V432ZM78 472C87 483 105 483 114 472L186 392C195 382 194 367 184 358C174 350 159 350 150 360L120 394V56C120 43 109 32 96 32S72 43 72 56V394L42 360C37 355 31 352 24 352C18 352 13 354 8 358C-2 367 -3 382 6 392L78 472Z"]
  };
  var faArrowDownSquareTriangle = {
    prefix: 'far',
    iconName: 'arrow-down-square-triangle',
    icon: [640, 512, [], "f889", "M360 224H504C517 224 528 213 528 200V56C528 43 517 32 504 32H360C347 32 336 43 336 56V200C336 213 347 224 360 224ZM384 80H480V176H384V80ZM540 439L457 302C452 293 442 288 432 288C422 288 413 293 407 302L324 439C313 457 327 480 349 480H515C537 480 551 457 540 439ZM384 432L432 353L480 432H384ZM264 352C257 352 251 355 246 360L216 394V56C216 43 205 32 192 32S168 43 168 56V394L138 360C129 350 114 350 104 358C94 367 93 383 102 392L174 472C183 483 201 483 210 472L282 392C291 383 290 367 280 358C276 354 270 352 264 352Z"]
  };
  var faArrowDownToLine = {
    prefix: 'far',
    iconName: 'arrow-down-to-line',
    icon: [384, 512, [], "f33d", "M360 432H24C11 432 0 443 0 456C0 469 11 480 24 480H360C373 480 384 469 384 456C384 443 373 432 360 432ZM303 208L216 300V56C216 43 205 32 192 32S168 43 168 56V300L81 208C77 203 70 200 64 200C58 200 52 202 48 207C38 216 37 231 47 241L175 377C184 386 200 386 209 377L337 241C347 231 346 216 336 207C327 198 312 198 303 208Z"]
  };
  var faArrowDownToSquare = {
    prefix: 'far',
    iconName: 'arrow-down-to-square',
    icon: [448, 512, [], "e097", "M384 128H344C331 128 320 139 320 152C320 165 331 176 344 176H384C393 176 400 183 400 192V448C400 457 393 464 384 464H64C55 464 48 457 48 448V192C48 183 55 176 64 176H104C117 176 128 165 128 152C128 139 117 128 104 128H64C29 128 0 157 0 192V448C0 483 29 512 64 512H384C419 512 448 483 448 448V192C448 157 419 128 384 128ZM206 376C215 387 233 387 242 376L314 296C323 286 322 271 312 262C302 253 287 254 278 264L248 298V24C248 11 237 0 224 0S200 11 200 24V298L170 264C165 259 159 256 152 256C146 256 141 258 136 262C126 271 125 286 134 296L206 376Z"]
  };
  var faArrowDownTriangleSquare = {
    prefix: 'far',
    iconName: 'arrow-down-triangle-square',
    icon: [448, 512, [], "f888", "M408 288H264C251 288 240 299 240 312V456C240 469 251 480 264 480H408C421 480 432 469 432 456V312C432 299 421 288 408 288ZM384 432H288V336H384V432ZM168 352C161 352 155 355 150 360L120 394V56C120 43 109 32 96 32S72 43 72 56V394L42 360C33 350 18 350 8 358C-2 367 -3 383 6 392L78 472C87 483 105 483 114 472L186 392C195 383 194 367 184 358C180 354 174 352 168 352ZM444 183L361 46C356 37 346 32 336 32C326 32 317 37 311 46L228 183C217 201 231 224 253 224H419C441 224 455 201 444 183ZM288 176L336 97L384 176H288Z"]
  };
  var faArrowDownWideShort = {
    prefix: 'far',
    iconName: 'arrow-down-wide-short',
    icon: [512, 512, [], "f160", "M150 360L120 393V56C120 43 109 32 96 32C83 32 72 43 72 56V393L42 360C33 350 18 349 8 358S-3 382 6 392L78 472C83 477 89 480 96 480C103 480 109 477 114 472L186 392C195 382 194 367 184 358C174 349 159 350 150 360ZM488 48H248C235 48 224 59 224 72S235 96 248 96H488C501 96 512 85 512 72S501 48 488 48ZM424 176H248C235 176 224 187 224 200S235 224 248 224H424C437 224 448 213 448 200S437 176 424 176ZM360 304H248C235 304 224 315 224 328S235 352 248 352H360C373 352 384 341 384 328S373 304 360 304ZM296 432H248C235 432 224 443 224 456S235 480 248 480H296C309 480 320 469 320 456S309 432 296 432Z"]
  };
  var faArrowDownZA = {
    prefix: 'far',
    iconName: 'arrow-down-z-a',
    icon: [448, 512, [], "f881", "M150 360L120 393V56C120 43 109 32 96 32S72 43 72 56V393L42 360C33 350 18 349 8 358S-3 382 6 392L78 472C83 477 89 480 96 480S109 477 114 472L186 392C195 382 194 367 184 358C174 349 159 350 150 360ZM445 445L373 301C365 285 339 285 331 301L259 445C253 457 257 471 269 477C281 483 296 479 301 467L307 456H397L403 467C407 475 415 480 424 480C428 480 431 479 435 477C447 472 451 457 445 445ZM331 408L352 366L373 408H331ZM296 80H359L277 185C271 193 270 202 274 211C278 219 287 224 296 224H408C421 224 432 213 432 200C432 187 421 176 408 176H345L427 71C433 63 434 54 430 45C426 37 417 32 408 32H296C283 32 272 43 272 56S283 80 296 80Z"]
  };
  var faArrowLeft = {
    prefix: 'far',
    iconName: 'arrow-left',
    icon: [448, 512, [], "f060", "M448 256C448 269 437 280 424 280H84L217 407C226 416 227 431 217 441C208 450 193 451 183 441L7 273C3 269 0 263 0 256S3 243 7 239L183 71C193 62 208 62 217 71C227 81 226 96 217 105L84 232H424C437 232 448 243 448 256Z"]
  };
  var faArrowLeftFromLine = {
    prefix: 'far',
    iconName: 'arrow-left-from-line',
    icon: [448, 512, [], "f344", "M400 88V424C400 437 411 448 424 448S448 437 448 424V88C448 75 437 64 424 64S400 75 400 88ZM176 367L84 280H328C341 280 352 269 352 256S341 232 328 232H84L176 145C181 141 184 134 184 128C184 122 182 116 177 112C168 102 153 101 143 111L7 239C-2 248 -2 264 7 273L143 401C153 411 168 410 177 400C186 391 186 376 176 367Z"]
  };
  var faArrowLeftLong = {
    prefix: 'far',
    iconName: 'arrow-left-long',
    icon: [512, 512, [], "f177", "M170 103C175 108 177 114 177 120S175 132 170 137L75 232H481C494 232 505 243 505 256S494 280 481 280H75L170 375C179 384 179 400 170 409S145 418 136 409L0 273C-9 264 -9 248 0 239L136 103C145 94 161 94 170 103Z"]
  };
  var faArrowLeftRotate = {
    prefix: 'far',
    iconName: 'arrow-left-rotate',
    icon: [512, 512, [], "f0e2", "M40 16C53 16 64 27 64 40V142C104 76 176 32 256 32C379 32 480 133 480 256S379 480 256 480C204 480 153 462 113 428C102 420 101 405 110 394C118 384 133 383 143 391C175 418 215 432 256 432C353 432 432 353 432 256S353 80 256 80C189 80 129 118 100 176H200C213 176 224 187 224 200S213 224 200 224H40C27 224 16 213 16 200V40C16 27 27 16 40 16Z"]
  };
  var faArrowLeftToLine = {
    prefix: 'far',
    iconName: 'arrow-left-to-line',
    icon: [448, 512, [], "f33e", "M48 424V88C48 75 37 64 24 64S0 75 0 88V424C0 437 11 448 24 448S48 437 48 424ZM272 367L180 280H424C437 280 448 269 448 256C448 243 437 232 424 232H180L272 145C277 141 280 134 280 128C280 122 278 116 273 112C264 102 249 101 239 111L103 239C94 248 94 264 103 273L239 401C249 411 264 410 273 400C282 391 282 376 272 367Z"]
  };
  var faArrowPointer = {
    prefix: 'far',
    iconName: 'arrow-pointer',
    icon: [320, 512, [], "f245", "M312 279L40 38C35 34 30 32 24 32C21 32 17 33 14 34C6 38 0 47 0 56V426C0 436 6 446 16 449C18 450 21 450 24 450C31 450 38 447 42 442L126 343L184 466C190 478 204 483 216 478L216 478C228 472 233 458 227 445L169 322H296C306 322 315 315 318 306C322 297 319 286 312 279ZM122 273L107 290L48 361V110L233 273H122Z"]
  };
  var faArrowRight = {
    prefix: 'far',
    iconName: 'arrow-right',
    icon: [448, 512, [], "f061", "M265 71L441 239C445 243 448 249 448 256S445 269 441 273L265 441C255 450 240 450 231 441C221 431 222 416 231 407L364 280H24C11 280 0 269 0 256S11 232 24 232H364L231 105C222 96 221 81 231 71C240 62 255 62 265 71Z"]
  };
  var faArrowRightArrowLeft = {
    prefix: 'far',
    iconName: 'arrow-right-arrow-left',
    icon: [512, 512, [], "f0ec", "M488 344H79L154 264C163 255 162 240 152 230C143 221 128 222 118 232L6 352C-2 361 -2 375 6 384L118 504C123 509 130 512 136 512C142 512 148 510 152 506C162 497 163 481 154 472L79 392H488C501 392 512 381 512 368S501 344 488 344ZM24 168H433L358 248C349 257 350 272 360 282C369 291 384 290 394 280L506 160C514 151 514 137 506 128L394 8C389 3 382 0 376 0C370 0 364 2 360 6C350 15 349 31 358 40L433 120H24C11 120 0 131 0 144S11 168 24 168Z"]
  };
  var faArrowRightFromBracket = {
    prefix: 'far',
    iconName: 'arrow-right-from-bracket',
    icon: [512, 512, [], "f08b", "M192 456C192 469 181 480 168 480H96C43 480 0 437 0 384V128C0 75 43 32 96 32H168C181 32 192 43 192 56C192 69 181 80 168 80H96C70 80 48 102 48 128V384C48 410 70 432 96 432H168C181 432 192 443 192 456ZM505 240L377 104C368 94 353 93 344 103C334 112 333 127 343 136L432 232H184C171 232 160 243 160 256S171 280 184 280H432L343 376C333 385 334 400 344 409C348 414 354 416 360 416C366 416 373 413 377 408L505 272C514 263 514 249 505 240Z"]
  };
  var faArrowRightFromLine = {
    prefix: 'far',
    iconName: 'arrow-right-from-line',
    icon: [448, 512, [], "f343", "M48 424V88C48 75 37 64 24 64S0 75 0 88V424C0 437 11 448 24 448S48 437 48 424ZM272 145L364 232H120C107 232 96 243 96 256S107 280 120 280H364L272 367C267 371 264 378 264 384C264 390 266 396 271 400C280 410 295 411 305 401L441 273C450 264 450 248 441 239L305 111C295 101 280 102 271 112C262 121 262 136 272 145Z"]
  };
  var faArrowRightLong = {
    prefix: 'far',
    iconName: 'arrow-right-long',
    icon: [512, 512, [], "f178", "M335 409C330 404 328 398 328 392S330 380 335 375L430 280H24C11 280 0 269 0 256S11 232 24 232H430L335 137C326 128 326 112 335 103S360 94 369 103L505 239C514 248 514 264 505 273L369 409C360 418 344 418 335 409Z"]
  };
  var faArrowRightToBracket = {
    prefix: 'far',
    iconName: 'arrow-right-to-bracket',
    icon: [512, 512, [], "f090", "M512 128V384C512 437 469 480 416 480H344C331 480 320 469 320 456C320 443 331 432 344 432H416C442 432 464 410 464 384V128C464 102 442 80 416 80H344C331 80 320 69 320 56C320 43 331 32 344 32H416C469 32 512 75 512 128ZM345 240L217 104C208 94 193 93 184 103C174 112 173 127 183 136L272 232H24C11 232 0 243 0 256S11 280 24 280H272L183 376C173 385 174 400 184 409C188 414 194 416 200 416C206 416 213 413 217 408L345 272C354 263 354 249 345 240Z"]
  };
  var faArrowRightToLine = {
    prefix: 'far',
    iconName: 'arrow-right-to-line',
    icon: [448, 512, [], "f340", "M400 88V424C400 437 411 448 424 448C437 448 448 437 448 424V88C448 75 437 64 424 64C411 64 400 75 400 88ZM176 145L268 232H24C11 232 0 243 0 256C0 269 11 280 24 280H268L176 367C171 371 168 378 168 384C168 390 170 396 175 400C184 410 199 411 209 401L345 273C354 264 354 248 345 239L209 111C199 101 184 102 175 112C166 121 166 136 176 145Z"]
  };
  var faArrowRotateForward = {
    prefix: 'far',
    iconName: 'arrow-rotate-forward',
    icon: [512, 512, [], "f01e", "M480 40V200C480 213 469 224 456 224H296C283 224 272 213 272 200S283 176 296 176H396C367 118 307 80 240 80C143 80 64 159 64 256S143 432 240 432C281 432 321 418 353 391C363 383 378 384 386 394C395 405 394 420 383 428C343 462 292 480 240 480C117 480 16 379 16 256S117 32 240 32C320 32 392 76 432 142V40C432 27 443 16 456 16S480 27 480 40Z"]
  };
  var faArrowTurnDown = {
    prefix: 'far',
    iconName: 'arrow-turn-down',
    icon: [384, 512, [], "f149", "M337 377L209 505C204 510 198 512 192 512S180 510 175 505L47 377C38 368 38 352 47 343S72 334 81 343L168 430V48H24C11 48 0 37 0 24S11 0 24 0H192C205 0 216 11 216 24V430L303 343C312 334 328 334 337 343S346 368 337 377Z"]
  };
  var faArrowTurnUp = {
    prefix: 'far',
    iconName: 'arrow-turn-up',
    icon: [384, 512, [], "f148", "M337 169C328 178 312 178 303 169L216 82V488C216 501 205 512 192 512H24C11 512 0 501 0 488S11 464 24 464H168V82L81 169C72 178 56 178 47 169S38 144 47 135L175 7C180 2 186 0 192 0S204 2 209 7L337 135C346 144 346 160 337 169Z"]
  };
  var faArrowUp = {
    prefix: 'far',
    iconName: 'arrow-up',
    icon: [448, 512, [], "f062", "M39 215L207 39C211 35 217 32 224 32S237 35 241 39L409 215C418 225 418 240 409 249C399 259 384 258 375 249L248 116V456C248 469 237 480 224 480S200 469 200 456V116L73 249C64 258 49 259 39 249C30 240 29 225 39 215Z"]
  };
  var faArrowUp19 = {
    prefix: 'far',
    iconName: 'arrow-up-1-9',
    icon: [448, 512, [], "f163", "M352 256C308 256 272 292 272 336S308 416 352 416C352 416 353 416 353 416C348 422 342 427 336 432L330 437C319 445 317 460 325 470C330 477 337 480 344 480C349 480 354 478 358 475L365 470C407 439 432 389 432 336C432 292 396 256 352 256ZM352 368C334 368 320 354 320 336S334 304 352 304C370 304 384 318 384 336S370 368 352 368ZM312 176C299 176 288 187 288 200S299 224 312 224H392C405 224 416 213 416 200S405 176 392 176H376V56C376 47 371 39 364 35C356 31 347 31 340 35L300 59C288 66 285 81 291 92C298 104 313 107 324 101L328 98V176H312ZM114 40C105 30 87 30 78 40L6 120C-3 130 -2 145 8 154C18 163 33 162 42 152L72 119V456C72 469 83 480 96 480C109 480 120 469 120 456V119L150 152C155 157 161 160 168 160C174 160 179 158 184 154C194 145 195 130 186 120L114 40Z"]
  };
  var faArrowUp91 = {
    prefix: 'far',
    iconName: 'arrow-up-9-1',
    icon: [448, 512, [], "f887", "M114 40C105 30 87 30 78 40L6 120C-3 130 -2 145 8 154C18 163 33 162 42 152L72 119V456C72 469 83 480 96 480C109 480 120 469 120 456V119L150 152C155 157 161 160 168 160C174 160 179 158 184 154C194 145 195 130 186 120L114 40ZM392 432H376V312C376 303 371 295 364 291C356 287 347 287 340 291L300 315C288 322 285 337 291 348C298 360 313 363 324 357L328 354V432H312C299 432 288 443 288 456S299 480 312 480H392C405 480 416 469 416 456S405 432 392 432ZM352 192C352 192 353 192 353 192C348 198 342 203 336 208L330 213C319 221 317 236 325 246C330 253 337 256 344 256C349 256 354 254 358 251L365 246C407 215 432 165 432 112C432 68 396 32 352 32C308 32 272 68 272 112S308 192 352 192ZM352 80C370 80 384 94 384 112S370 144 352 144C334 144 320 130 320 112S334 80 352 80Z"]
  };
  var faArrowUpAZ = {
    prefix: 'far',
    iconName: 'arrow-up-a-z',
    icon: [448, 512, [], "f15e", "M114 40C105 29 87 29 78 40L6 120C-3 130 -2 145 8 154C18 162 33 162 42 152L72 118V456C72 469 83 480 96 480C109 480 120 469 120 456V118L150 152C155 157 161 160 168 160C174 160 179 158 184 154C194 145 195 130 186 120L114 40ZM445 189L373 45C365 29 339 29 331 45L259 189C253 201 257 215 269 221C281 227 296 222 301 211L307 200H397L402 211C407 219 415 224 424 224C428 224 431 223 435 221C447 215 451 201 445 189ZM331 152L352 109L373 152H331ZM408 432H345L427 327C433 319 434 310 430 301C426 293 417 288 408 288H296C283 288 272 299 272 312C272 325 283 336 296 336H359L277 441C271 449 270 458 274 467C278 475 287 480 296 480H408C421 480 432 469 432 456C432 443 421 432 408 432Z"]
  };
  var faArrowUpArrowDown = {
    prefix: 'far',
    iconName: 'arrow-up-arrow-down',
    icon: [384, 512, [], "e098", "M8 154C13 158 18 160 24 160C31 160 37 157 42 152L72 119V456C72 469 83 480 96 480C109 480 120 469 120 456V119L150 152C159 162 174 163 184 154C194 145 195 130 186 120L114 40C105 30 87 30 78 40L6 120C-3 130 -2 145 8 154ZM200 358C190 367 189 382 198 392L270 472C275 477 281 480 288 480C295 480 301 477 306 472L378 392C387 382 386 367 376 358S351 350 342 360L312 393V56C312 43 301 32 288 32C275 32 264 43 264 56V393L234 360C225 350 210 349 200 358Z"]
  };
  var faArrowUpBigSmall = {
    prefix: 'far',
    iconName: 'arrow-up-big-small',
    icon: [512, 512, [], "f88e", "M224 352V448C224 466 238 480 256 480H416C434 480 448 466 448 448V352C448 334 434 320 416 320H256C238 320 224 334 224 352ZM272 368H400V432H272V368ZM512 224V64C512 46 498 32 480 32H256C238 32 224 46 224 64V224C224 242 238 256 256 256H480C498 256 512 242 512 224ZM464 208H272V80H464V208ZM114 40C105 29 87 29 78 40L6 120C-3 130 -2 145 8 154C18 162 33 162 42 152L72 118V456C72 469 83 480 96 480S120 469 120 456V118L150 152C155 157 161 160 168 160C174 160 179 158 184 154C194 145 195 130 186 120L114 40Z"]
  };
  var faArrowUpFromLine = {
    prefix: 'far',
    iconName: 'arrow-up-from-line',
    icon: [384, 512, [], "f342", "M360 432H24C11 432 0 443 0 456C0 469 11 480 24 480H360C373 480 384 469 384 456C384 443 373 432 360 432ZM81 208L168 116V360C168 373 179 384 192 384S216 373 216 360V116L303 208C307 213 314 216 320 216C326 216 332 214 336 209C346 200 347 185 337 175L209 39C200 30 184 30 175 39L47 175C37 185 38 200 48 209C57 218 72 218 81 208Z"]
  };
  var faArrowUpFromSquare = {
    prefix: 'far',
    iconName: 'arrow-up-from-square',
    icon: [448, 512, [], "e099", "M384 160H376C363 160 352 171 352 184C352 197 363 208 376 208H384C393 208 400 215 400 224V448C400 457 393 464 384 464H64C55 464 48 457 48 448V224C48 215 55 208 64 208H72C85 208 96 197 96 184C96 171 85 160 72 160H64C29 160 0 189 0 224V448C0 483 29 512 64 512H384C419 512 448 483 448 448V224C448 189 419 160 384 160ZM170 120L200 86V328C200 341 211 352 224 352S248 341 248 328V86L278 120C283 125 289 128 296 128C302 128 307 126 312 122C322 113 323 98 314 88L242 8C233 -3 215 -3 206 8L134 88C125 98 126 113 136 122C146 130 161 130 170 120Z"]
  };
  var faArrowUpLong = {
    prefix: 'far',
    iconName: 'arrow-up-long',
    icon: [320, 512, [], "f176", "M313 177C308 182 302 184 296 184S284 182 279 177L184 82V488C184 501 173 512 160 512S136 501 136 488V82L41 177C32 186 16 186 7 177S-2 152 7 143L143 7C152 -2 168 -2 177 7L313 143C322 152 322 168 313 177Z"]
  };
  var faArrowUpRightAndArrowDownLeftFromCenter = {
    prefix: 'far',
    iconName: 'arrow-up-right-and-arrow-down-left-from-center',
    icon: [512, 512, [], "e09a", "M497 2C494 1 491 0 488 0H344C331 0 320 11 320 24S331 48 344 48H430L295 183C286 192 286 208 295 217S320 226 329 217L464 82V168C464 181 475 192 488 192S512 181 512 168V24C512 21 511 18 510 15C508 9 503 4 497 2ZM15 510C18 511 21 512 24 512H168C181 512 192 501 192 488S181 464 168 464H82L217 329C226 320 226 304 217 295S192 286 183 295L48 430V344C48 331 37 320 24 320S0 331 0 344V488C0 491 1 494 2 497C4 503 9 508 15 510Z"]
  };
  var faArrowUpRightFromSquare = {
    prefix: 'far',
    iconName: 'arrow-up-right-from-square',
    icon: [512, 512, [], "f08e", "M392 320C379 320 368 331 368 344V456C368 460 364 464 360 464H56C52 464 48 460 48 456V152C48 148 52 144 56 144H168C181 144 192 133 192 120S181 96 168 96H56C25 96 0 121 0 152V456C0 487 25 512 56 512H360C391 512 416 487 416 456V344C416 331 405 320 392 320ZM488 0H344C331 0 320 11 320 24S331 48 344 48H430L183 295C174 304 174 320 183 329C188 334 194 336 200 336S212 334 217 329L464 82V168C464 181 475 192 488 192S512 181 512 168V24C512 11 501 0 488 0Z"]
  };
  var faArrowUpShortWide = {
    prefix: 'far',
    iconName: 'arrow-up-short-wide',
    icon: [512, 512, [], "f885", "M114 40C105 29 87 29 78 40L6 120C-3 130 -2 145 8 154C18 162 33 162 42 152L72 118V456C72 469 83 480 96 480C109 480 120 469 120 456V118L150 152C155 157 161 160 168 160C174 160 179 158 184 154C194 145 195 130 186 120L114 40ZM488 432H248C235 432 224 443 224 456C224 469 235 480 248 480H488C501 480 512 469 512 456C512 443 501 432 488 432ZM248 352H424C437 352 448 341 448 328C448 315 437 304 424 304H248C235 304 224 315 224 328C224 341 235 352 248 352ZM248 224H360C373 224 384 213 384 200S373 176 360 176H248C235 176 224 187 224 200S235 224 248 224ZM248 96H296C309 96 320 85 320 72S309 48 296 48H248C235 48 224 58 224 72S235 96 248 96Z"]
  };
  var faArrowUpSmallBig = {
    prefix: 'far',
    iconName: 'arrow-up-small-big',
    icon: [512, 512, [], "f88f", "M256 192H416C434 192 448 178 448 160V64C448 46 434 32 416 32H256C238 32 224 46 224 64V160C224 178 238 192 256 192ZM272 80H400V144H272V80ZM480 256H256C238 256 224 270 224 288V448C224 466 238 480 256 480H480C498 480 512 466 512 448V288C512 270 498 256 480 256ZM464 432H272V304H464V432ZM114 40C105 29 87 29 78 40L6 120C-3 130 -2 145 8 154C18 162 33 162 42 152L72 118V456C72 469 83 480 96 480S120 469 120 456V118L150 152C155 157 161 160 168 160C174 160 179 158 184 154C194 145 195 130 186 120L114 40Z"]
  };
  var faArrowUpSquareTriangle = {
    prefix: 'far',
    iconName: 'arrow-up-square-triangle',
    icon: [640, 512, [], "f88b", "M368 224H496C514 224 528 210 528 192V64C528 46 514 32 496 32H368C350 32 336 46 336 64V192C336 210 350 224 368 224ZM384 80H480V176H384V80ZM540 439L457 302C452 293 442 288 432 288S413 293 407 302L324 439C313 457 327 480 349 480H515C537 480 551 457 540 439ZM384 432L432 353L480 432H384ZM210 40C201 29 183 29 174 40L102 120C93 130 94 145 104 154C114 162 129 162 138 152L168 118V456C168 469 179 480 192 480S216 469 216 456V118L246 152C251 157 257 160 264 160C270 160 275 158 280 154C290 145 291 130 282 120L210 40Z"]
  };
  var faArrowUpToLine = {
    prefix: 'far',
    iconName: 'arrow-up-to-line',
    icon: [384, 512, [], "f341", "M24 80H360C373 80 384 69 384 56S373 32 360 32H24C11 32 0 43 0 56S11 80 24 80ZM81 304L168 212V456C168 469 179 480 192 480S216 469 216 456V212L303 304C307 309 314 312 320 312C326 312 332 310 336 305C346 296 347 281 337 271L209 135C200 125 184 125 175 135L47 271C37 281 38 296 48 305C57 314 72 314 81 304Z"]
  };
  var faArrowUpTriangleSquare = {
    prefix: 'far',
    iconName: 'arrow-up-triangle-square',
    icon: [640, 512, [], "f88a", "M210 40C201 30 183 30 174 40L102 120C93 130 94 145 104 154C114 163 129 162 138 152L168 119V456C168 469 179 480 192 480S216 469 216 456V119L246 152C251 157 257 160 264 160C270 160 275 158 280 154C290 145 291 130 282 120L210 40ZM540 183L457 46C452 37 442 32 432 32C422 32 413 37 407 46L324 183C313 201 327 224 349 224H515C537 224 551 201 540 183ZM384 176L432 97L480 176H384ZM504 288H360C347 288 336 299 336 312V456C336 469 347 480 360 480H504C517 480 528 469 528 456V312C528 299 517 288 504 288ZM480 432H384V336H480V432Z"]
  };
  var faArrowUpWideShort = {
    prefix: 'far',
    iconName: 'arrow-up-wide-short',
    icon: [512, 512, [], "f161", "M114 40C105 29 87 29 78 40L6 120C-3 130 -2 145 8 154C18 162 33 162 42 152L72 118V456C72 469 83 480 96 480C109 480 120 469 120 456V118L150 152C155 157 161 160 168 160C174 160 179 158 184 154C194 145 195 130 186 120L114 40ZM488 48H248C235 48 224 58 224 72S235 96 248 96H488C501 96 512 85 512 72S501 48 488 48ZM424 176H248C235 176 224 187 224 200S235 224 248 224H424C437 224 448 213 448 200S437 176 424 176ZM360 304H248C235 304 224 315 224 328C224 341 235 352 248 352H360C373 352 384 341 384 328C384 315 373 304 360 304ZM296 432H248C235 432 224 443 224 456C224 469 235 480 248 480H296C309 480 320 469 320 456C320 443 309 432 296 432Z"]
  };
  var faArrowUpZA = {
    prefix: 'far',
    iconName: 'arrow-up-z-a',
    icon: [448, 512, [], "f882", "M114 40C105 30 87 30 78 40L6 120C-3 130 -2 145 8 154C18 163 33 162 42 152L72 119V456C72 469 83 480 96 480C109 480 120 469 120 456V119L150 152C155 157 161 160 168 160C174 160 179 158 184 154C194 145 195 130 186 120L114 40ZM445 445L373 301C365 285 339 285 331 301L259 445C253 457 257 472 269 477C281 483 296 479 301 467L307 456H397L402 467C407 475 415 480 424 480C428 480 431 479 435 477C447 472 451 457 445 445ZM331 408L352 366L373 408H331ZM296 80H359L277 185C271 193 270 202 274 211C278 219 287 224 296 224H408C421 224 432 213 432 200C432 187 421 176 408 176H345L427 71C433 63 434 54 430 45C426 37 417 32 408 32H296C283 32 272 43 272 56S283 80 296 80Z"]
  };
  var faArrowsLeftRight = {
    prefix: 'far',
    iconName: 'arrows-left-right',
    icon: [512, 512, [], "f07e", "M512 256C512 263 509 269 504 274L400 370C396 374 390 376 384 376C378 376 371 373 366 368C357 359 358 343 368 334L427 280H85L144 334C154 343 155 359 146 368C141 373 134 376 128 376C122 376 116 374 112 370L8 274C3 269 0 263 0 256S3 243 8 238L112 142C122 133 137 134 146 144C155 153 154 169 144 178L85 232H427L368 178C358 169 357 153 366 144C375 134 390 133 400 142L504 238C509 243 512 249 512 256Z"]
  };
  var faArrowsMaximize = {
    prefix: 'far',
    iconName: 'arrows-maximize',
    icon: [448, 512, [], "f31d", "M400 200V114L258 256L400 398V312C400 299 411 288 424 288S448 299 448 312V456C448 459 447 462 446 465C444 471 439 476 433 478C430 479 427 480 424 480H280C267 480 256 469 256 456S267 432 280 432H366L224 290L82 432H168C181 432 192 443 192 456S181 480 168 480H24C21 480 18 479 15 478C9 476 4 471 2 465C1 462 0 459 0 456V312C0 299 11 288 24 288S48 299 48 312V398L190 256L48 114V200C48 213 37 224 24 224S0 213 0 200V56C0 53 1 50 2 47C4 41 9 36 15 34C18 33 21 32 24 32H168C181 32 192 43 192 56S181 80 168 80H82L224 222L366 80H280C267 80 256 69 256 56S267 32 280 32H424C427 32 430 33 433 34C439 36 444 41 446 47C447 50 448 53 448 56V200C448 213 437 224 424 224S400 213 400 200Z"]
  };
  var faArrowsMinimize = {
    prefix: 'far',
    iconName: 'arrows-minimize',
    icon: [512, 512, [], "e09b", "M200 32C187 32 176 43 176 56V142L57 23C48 14 32 14 23 23S14 48 23 57L142 176H56C43 176 32 187 32 200S43 224 56 224H200C203 224 206 223 209 222C215 220 220 215 222 209C223 206 224 203 224 200V56C224 43 213 32 200 32ZM303 222C306 223 309 224 312 224H456C469 224 480 213 480 200S469 176 456 176H370L489 57C498 48 498 32 489 23S464 14 455 23L336 142V56C336 43 325 32 312 32S288 43 288 56V200C288 203 289 206 290 209C292 215 297 220 303 222ZM370 336H456C469 336 480 325 480 312S469 288 456 288H312C309 288 306 289 303 290C297 292 292 297 290 303C289 306 288 309 288 312V456C288 469 299 480 312 480S336 469 336 456V370L455 489C464 498 480 498 489 489S498 464 489 455L370 336ZM209 290C206 289 203 288 200 288H56C43 288 32 299 32 312S43 336 56 336H142L23 455C14 464 14 480 23 489S48 498 57 489L176 370V456C176 469 187 480 200 480S224 469 224 456V312C224 309 223 306 222 303C220 297 215 292 209 290Z"]
  };
  var faArrowsRepeat = {
    prefix: 'far',
    iconName: 'arrows-repeat',
    icon: [512, 512, [], "f364", "M488 232C475 232 464 243 464 256C464 313 417 360 360 360H146L209 297C218 288 218 272 209 263S184 254 175 263L71 367C62 376 62 392 71 401L175 505C180 510 186 512 192 512S204 510 209 505C218 496 218 480 209 471L146 408H360C444 408 512 340 512 256C512 243 501 232 488 232ZM152 152H366L303 215C294 224 294 240 303 249C308 254 314 256 320 256S332 254 337 249L441 145C450 136 450 120 441 111L337 7C328 -2 312 -2 303 7S294 32 303 41L366 104H152C68 104 0 172 0 256C0 269 11 280 24 280S48 269 48 256C48 199 95 152 152 152Z"]
  };
  var faArrowsRepeat1 = {
    prefix: 'far',
    iconName: 'arrows-repeat-1',
    icon: [512, 512, [], "f366", "M488 232C475 232 464 243 464 256C464 313 417 360 360 360H88C78 360 69 366 66 375C63 381 63 387 66 393C67 396 69 399 71 401L175 505C180 510 186 512 192 512S204 510 209 505C218 496 218 480 209 471L146 408H360C444 408 512 340 512 256C512 243 501 232 488 232ZM152 152H424C434 152 443 146 446 137C449 131 449 125 446 119C445 116 443 113 441 111L337 7C328 -2 312 -2 303 7S294 32 303 41L366 104H152C68 104 0 172 0 256C0 269 11 280 24 280S48 269 48 256C48 199 95 152 152 152ZM264 328C277 328 288 317 288 304V216C288 208 284 200 277 196C270 191 261 191 253 195L221 211C209 216 205 231 211 243C216 254 229 259 240 255V304C240 317 251 328 264 328Z"]
  };
  var faArrowsRetweet = {
    prefix: 'far',
    iconName: 'arrows-retweet',
    icon: [640, 512, [], "f361", "M328 368H152V146L215 209C220 214 226 216 232 216S244 214 249 209C258 200 258 184 249 175L145 71C136 62 120 62 111 71L7 175C-2 184 -2 200 7 209S32 218 41 209L104 146V392C104 405 115 416 128 416H328C341 416 352 405 352 392S341 368 328 368ZM633 303C624 294 608 294 599 303L536 366V120C536 107 525 96 512 96H312C299 96 288 107 288 120S299 144 312 144H488V366L425 303C420 298 414 296 408 296S396 298 391 303C382 312 382 328 391 337L495 441C504 450 520 450 529 441L633 337C642 328 642 312 633 303Z"]
  };
  var faArrowsRotate = {
    prefix: 'far',
    iconName: 'arrows-rotate',
    icon: [512, 512, [], "f021", "M455 289C442 285 429 293 425 305C403 380 334 432 256 432C189 432 129 394 100 336H200C213 336 224 325 224 312S213 288 200 288H40C27 288 16 299 16 312V472C16 485 27 496 40 496S64 485 64 472V370C104 436 176 480 256 480C355 480 443 414 471 319C475 306 467 293 455 289ZM472 16C459 16 448 27 448 40V142C408 76 336 32 256 32C157 32 69 98 41 193C37 206 45 219 57 223C70 227 83 219 87 207C109 132 178 80 256 80C323 80 383 118 413 176H312C299 176 288 187 288 200S299 224 312 224H472C485 224 496 213 496 200V40C496 27 485 16 472 16Z"]
  };
  var faArrowsUpDown = {
    prefix: 'far',
    iconName: 'arrows-up-down',
    icon: [320, 512, [], "f07d", "M160 512C153 512 147 509 142 504L46 400C42 396 40 390 40 384C40 378 43 371 48 366C57 357 73 358 82 368L136 427V85L82 144C73 154 57 155 48 146C43 141 40 134 40 128C40 122 42 116 46 112L142 8C147 3 153 0 160 0S173 3 178 8L274 112C283 122 282 137 272 146C263 155 247 154 238 144L184 85V427L238 368C247 358 263 357 272 366C282 375 283 390 274 400L178 504C173 509 167 512 160 512Z"]
  };
  var faArrowsUpDownLeftRight = {
    prefix: 'far',
    iconName: 'arrows-up-down-left-right',
    icon: [512, 512, [], "f047", "M512 248C512 255 509 262 504 266L416 346C412 350 406 352 400 352C393 352 387 350 382 345C373 335 374 320 384 311L426 272H280V418L318 376C327 366 342 366 352 375C362 384 363 399 354 409L274 497C269 502 263 504 256 504S243 502 238 497L158 409C149 399 150 384 160 375C170 366 185 366 194 376L232 418V272H86L128 311C138 320 139 335 130 345C125 350 119 352 112 352C106 352 100 350 96 346L8 266C3 262 0 255 0 248C0 242 3 235 8 231L96 151C106 142 121 142 130 152C139 162 138 177 128 186L86 224H232V78L194 120C185 130 170 131 160 122C150 113 149 98 158 88L238 0C247 -10 265 -10 274 0L354 88C363 98 362 113 352 122C348 126 342 128 336 128C329 128 323 126 318 120L280 78V224H426L384 186C374 177 373 162 382 152C391 142 406 142 416 151L504 231C509 235 512 242 512 248Z"]
  };
  var faAsterisk = {
    prefix: 'far',
    iconName: 'asterisk',
    icon: [448, 512, [], "f069", "M418 368C414 376 406 380 397 380C393 380 389 379 385 377L248 298V456C248 469 237 480 224 480S200 469 200 456V298L63 377C59 379 55 380 51 380C43 380 35 376 30 368C24 357 28 342 39 335L176 256L39 177C28 170 24 155 30 144C37 133 51 129 63 135L200 214V56C200 43 211 32 224 32S248 43 248 56V214L385 135C397 129 412 133 418 144C425 155 421 170 409 177L272 256L409 335C421 342 425 357 418 368Z"]
  };
  var faAt = {
    prefix: 'far',
    iconName: 'at',
    icon: [512, 512, [], "f1fa", "M263 16C197 14 136 38 89 84C42 130 16 191 16 256C16 383 115 487 239 496C248 497 256 489 256 480V464C256 455 249 449 241 448C127 439 41 331 69 210C76 184 88 159 104 138C144 89 200 62 262 64C365 67 448 158 448 265V284C448 309 428 328 404 328S360 309 360 284V164C360 155 353 148 344 148H328C319 148 312 155 312 164V164C294 152 272 144 248 144C186 144 136 194 136 256S186 368 248 368C279 368 307 355 328 335C347 364 383 382 422 375C466 366 496 325 496 281V265C496 132 392 20 263 16ZM248 320C213 320 184 291 184 256S213 192 248 192S312 221 312 256S283 320 248 320Z"]
  };
  var faAtom = {
    prefix: 'far',
    iconName: 'atom',
    icon: [512, 512, [], "f5d2", "M256 224C238 224 224 238 224 256S238 288 256 288C274 288 288 274 288 256C288 238 274 224 256 224ZM471 128C456 100 422 87 378 87C369 87 359 87 350 89C327 34 294 0 256 0S185 34 162 89C153 87 143 87 134 87C90 87 56 100 41 128C22 162 34 209 68 256C34 303 22 350 41 384C56 412 90 425 134 425C143 425 153 425 162 423C185 478 219 512 256 512S327 478 350 423C359 425 369 425 378 425C422 425 456 412 471 384C490 350 478 303 444 256C478 209 490 162 471 128ZM256 48C270 48 288 66 303 98C287 102 271 108 256 114C241 108 225 102 209 98C224 66 242 48 256 48ZM134 377C107 377 87 371 81 360C74 347 81 322 100 293C111 305 124 317 137 327C139 344 142 360 146 376C142 376 138 377 134 377ZM137 185C124 195 111 207 100 219C81 190 74 165 81 152C87 141 107 135 134 135C138 135 142 136 146 136C142 152 139 169 137 185ZM256 464C242 464 224 446 209 414C225 410 241 404 256 398C271 404 287 410 303 414C288 446 270 464 256 464ZM256 352C203 352 160 309 160 256S203 160 256 160S352 203 352 256S309 352 256 352ZM431 360C425 371 405 377 378 377C374 377 370 376 366 376C370 360 373 343 375 327C388 317 401 305 412 293C431 322 438 347 431 360ZM412 219C401 207 388 195 375 185C373 168 370 152 366 136C370 136 374 135 378 135C405 135 425 141 431 152C438 165 431 190 412 219Z"]
  };
  var faAtomSimple = {
    prefix: 'far',
    iconName: 'atom-simple',
    icon: [448, 512, [], "f5d3", "M398 256C451 339 465 417 425 457C364 518 242 441 224 430C206 441 84 518 23 457C-16 417 -4 339 50 256C-4 172 -17 95 23 55C63 16 140 29 224 82C307 29 385 15 425 55S451 172 398 256ZM81 213C110 176 144 142 181 113C140 89 79 67 57 89C40 106 46 154 81 213ZM181 399C144 370 110 336 81 298C46 358 40 406 57 423C74 439 122 433 181 399ZM339 256C306 212 268 173 224 141C180 173 141 212 109 256C143 302 179 337 224 371C269 337 305 301 339 256ZM256 256C256 274 242 288 224 288C206 288 192 274 192 256C192 238 206 224 224 224C242 224 256 238 256 256ZM367 298C338 336 304 370 266 399C326 433 374 439 391 423C408 406 402 358 367 298ZM266 113C304 142 338 176 367 213C402 154 408 106 391 89C369 67 309 89 266 113Z"]
  };
  var faAustralSign = {
    prefix: 'far',
    iconName: 'austral-sign',
    icon: [448, 512, [], "e09c", "M424 320H361L341 271H424C437 271 448 261 448 247C448 234 437 223 424 223H321L246 45C239 28 209 28 202 45L127 223H24C11 223 0 234 0 247C0 261 11 271 24 271H107L87 319H24C11 320 0 330 0 344S11 368 24 368H67L34 447C29 459 34 473 47 478C59 483 73 478 78 465L119 368H329L370 465C374 474 383 480 392 480C395 480 398 479 401 478C414 473 419 459 414 447L381 368H424C437 368 448 357 448 344S437 320 424 320ZM224 117L269 223H179L224 117ZM139 320L159 271H289L309 320H139Z"]
  };
  var faAward = {
    prefix: 'far',
    iconName: 'award',
    icon: [384, 512, [], "f559", "M192 112C148 112 112 148 112 192C112 236 148 272 192 272S272 236 272 192C272 148 236 112 192 112ZM192 224C174 224 160 210 160 192S174 160 192 160S224 174 224 192S210 224 192 224ZM333 307C343 302 353 297 358 288C366 274 358 254 363 238C367 223 384 209 384 192C384 175 367 161 363 146C358 131 366 110 358 96C350 82 328 78 317 67C306 56 302 34 288 26C283 23 277 22 270 22C263 22 257 23 250 23C246 23 242 22 238 21C223 17 209 0 192 0C175 0 161 17 146 21C142 22 138 23 134 23C127 23 121 22 114 22C107 22 101 23 96 26C82 34 78 56 67 67C56 78 34 82 26 96C18 110 26 130 21 146C17 161 0 175 0 192C0 209 17 223 21 238C26 253 18 274 26 288C31 297 42 302 52 307L2 433C-2 441 0 451 6 457C10 463 17 466 24 466C26 466 27 466 29 466L74 457L95 499C99 507 108 512 117 512C117 512 117 512 118 512C127 512 135 506 139 497L185 384H200L245 497C249 506 257 512 266 512C267 512 267 512 267 512C276 512 285 507 289 499L310 457L355 466C357 466 358 466 360 466C367 466 374 463 378 457C384 451 386 441 382 433L333 307ZM314 262C305 267 293 273 283 283C273 293 267 305 262 314C258 314 254 313 250 313C241 313 233 314 225 316C211 320 200 327 192 333C192 333 192 333 192 333C192 333 192 333 192 333C184 327 173 320 159 316C151 314 143 313 134 313C130 313 126 314 122 314C117 305 111 293 101 283C91 273 79 267 70 262C71 253 71 239 68 225C64 211 57 200 51 192C51 192 51 192 51 192C51 192 51 192 51 192C57 184 64 173 68 159C71 145 71 131 70 122C79 117 91 111 101 101C111 91 117 79 122 70C126 70 130 71 134 71C143 71 151 70 159 68C173 64 184 57 192 51C192 51 192 51 192 51C192 51 192 51 192 51C200 57 211 64 225 68C233 70 241 71 250 71C254 71 258 70 262 70C267 79 273 91 283 101C293 111 305 117 314 122C313 131 313 145 316 159C320 173 327 184 333 192C333 192 333 192 333 192C333 192 333 192 333 192C327 200 320 211 316 225C313 239 313 253 314 262Z"]
  };
  var faAxe = {
    prefix: 'far',
    iconName: 'axe',
    icon: [640, 512, [], "f6b2", "M0 435C-13 447 -13 467 0 480L23 503C29 509 37 512 45 512S62 509 68 503L299 271L231 204L0 435ZM516 160L463 107L493 77C506 65 506 44 493 32L471 9C464 3 456 0 448 0S432 3 425 9L396 39L366 9C359 3 351 0 343 0S327 3 321 9L224 106C211 118 211 139 224 151L375 302V416H407C530 416 631 316 631 192V160H516ZM423 367V282L409 268L269 128L343 55L362 73L396 107L482 194L496 208H582C574 292 507 360 423 367Z"]
  };
  var faAxeBattle = {
    prefix: 'far',
    iconName: 'axe-battle',
    icon: [512, 512, [], "f6b3", "M512 176C508 108 481 48 438 5C435 2 431 0 428 0C420 0 414 5 412 14C407 33 381 120 280 120V56C280 43 269 32 256 32S232 43 232 56V120C132 120 106 33 101 14C99 5 92 0 85 0C81 0 78 2 74 5C29 51 0 118 0 192S29 333 74 379C78 382 81 384 85 384C92 384 99 379 101 370C106 351 132 264 232 264V488C232 501 243 512 256 512S280 501 280 488V264C381 264 407 351 412 370C414 379 421 384 428 384C431 384 435 382 438 379C481 337 508 276 512 208L497 192L512 176ZM232 216C161 216 109 250 77 303C58 271 48 232 48 192S58 113 77 81C109 134 161 168 232 168V216ZM462 225C458 254 449 280 436 303C404 250 352 216 280 216V168C351 168 404 135 436 81C449 104 458 130 462 159L430 192L462 225Z"]
  };
  var faB = {
    prefix: 'far',
    iconName: 'b',
    icon: [320, 512, [], "e09d", "M268 249C290 226 304 195 304 160C304 89 247 32 176 32H32C14 32 0 46 0 64V448C0 466 14 480 32 480H192C263 480 320 423 320 352C320 310 299 273 268 249ZM64 96H176C211 96 240 125 240 160S211 224 176 224H64V96ZM192 416H64V288H192C227 288 256 317 256 352S227 416 192 416Z"]
  };
  var faBaby = {
    prefix: 'far',
    iconName: 'baby',
    icon: [384, 512, [], "f77c", "M328 216L371 186C385 176 389 156 378 142C368 127 348 124 334 134L291 164C232 205 152 205 93 164L50 134C36 124 16 127 6 142C-4 156 -1 176 14 186L56 216C74 228 93 238 112 245V331L63 396C54 407 54 424 63 435L111 499C117 508 127 512 136 512C143 512 150 510 155 506C170 495 172 475 162 461L129 417L147 394C158 403 172 408 187 408H198C212 408 226 403 238 394L256 417L223 461C212 475 215 495 229 506C235 510 242 512 248 512C258 512 268 508 274 499L322 435C331 423 331 407 321 396L272 331V245C292 238 310 228 328 216ZM240 333L211 362C207 366 202 368 197 368H187C182 368 177 366 173 362L144 333V312H240V333ZM192 160C236 160 272 124 272 80C272 36 236 0 192 0C148 0 112 36 112 80C112 124 148 160 192 160Z"]
  };
  var faBabyCarriage = {
    prefix: 'far',
    iconName: 'baby-carriage',
    icon: [512, 512, [], "f77d", "M488 96H456C425 96 400 121 400 152V192H293L189 28C180 14 165 4 147 1C130 -2 113 2 100 13C41 60 0 139 0 216C0 266 18 315 60 355C21 365 -7 404 2 448C7 479 32 504 63 510C115 521 160 482 160 432C160 423 158 415 156 407C177 413 200 416 224 416S271 413 292 407C287 424 285 444 297 467C312 493 339 512 369 512C413 511 448 476 448 432C448 395 422 364 388 355C425 320 448 275 448 224V152C448 148 452 144 456 144H488C501 144 512 133 512 120V120C512 107 501 96 488 96ZM80 464C62 464 48 450 48 432C48 414 62 400 80 400S112 414 112 432C112 450 98 464 80 464ZM400 432C400 450 386 464 368 464S336 450 336 432C336 414 350 400 368 400S400 414 400 432ZM224 368C134 368 59 312 49 240H399C389 312 314 368 224 368Z"]
  };
  var faBackpack = {
    prefix: 'far',
    iconName: 'backpack',
    icon: [448, 512, [], "f5d4", "M320 80H312V56C312 25 287 0 256 0H192C161 0 136 25 136 56V80H128C57 80 0 137 0 208V448C0 483 29 512 64 512H384C419 512 448 483 448 448V208C448 137 391 80 320 80ZM184 56C184 52 188 48 192 48H256C260 48 264 52 264 56V80H184V56ZM320 464H128V400H320V464ZM320 352H128V320C128 302 142 288 160 288H288C306 288 320 302 320 320V352ZM400 448C400 457 393 464 384 464H368V320C368 276 332 240 288 240H160C116 240 80 276 80 320V464H64C55 464 48 457 48 448V208C48 164 84 128 128 128H320C364 128 400 164 400 208V448ZM304 160H144C135 160 128 167 128 176V192C128 201 135 208 144 208H304C313 208 320 201 320 192V176C320 167 313 160 304 160Z"]
  };
  var faBackward = {
    prefix: 'far',
    iconName: 'backward',
    icon: [512, 512, [], "f04a", "M224 64C217 64 210 66 203 71L11 231C-4 244 -4 268 11 281L203 441C210 446 217 448 224 448C240 448 256 435 256 416V96C256 77 240 64 224 64ZM208 382L57 256L208 130V382ZM495 68C485 62 473 63 463 69L299 173C288 180 285 195 292 206C299 218 314 221 325 214L464 125V387L325 298C314 291 299 294 292 306C285 317 288 332 299 339L463 443C468 446 474 448 480 448C485 448 491 447 495 444C506 438 512 428 512 416V96C512 84 506 74 495 68Z"]
  };
  var faBackwardFast = {
    prefix: 'far',
    iconName: 'backward-fast',
    icon: [512, 512, [], "f049", "M464 64C457 64 450 66 443 71L272 228V96C272 77 256 64 240 64C233 64 226 66 219 71L48 228V88C48 75 37 64 24 64H24C11 64 0 75 0 88V424C0 437 11 448 24 448C37 448 48 437 48 424V285L219 441C226 446 233 448 240 448C256 448 272 435 272 416V285L443 441C450 446 457 448 464 448C480 448 496 435 496 416V96C496 77 480 64 464 64ZM224 380L88 257L224 132V380ZM448 380L312 257L448 132V380Z"]
  };
  var faBackwardStep = {
    prefix: 'far',
    iconName: 'backward-step',
    icon: [320, 512, [], "f048", "M16 88V424C16 437 27 448 40 448S64 437 64 424V318L237 442C243 446 249 448 256 448C261 448 266 447 271 444C281 439 288 428 288 416V96C288 84 281 73 271 68C266 65 261 64 256 64C249 64 243 66 237 70L64 194V88C64 75 53 64 40 64S16 75 16 88ZM64 253L92 233L240 127V385L92 279L64 259V253Z"]
  };
  var faBacon = {
    prefix: 'far',
    iconName: 'bacon',
    icon: [576, 512, [], "f7e5", "M565 100L487 13C479 4 469 0 459 0C453 0 448 1 443 3L351 46C299 70 257 110 228 163L208 201C181 250 141 288 93 310L24 342C12 348 4 359 1 373C-2 387 2 402 11 412L89 499C97 508 107 512 117 512C123 512 128 511 133 509L226 466C277 442 319 402 348 349L368 311C395 262 435 224 483 202L552 170C564 164 572 153 575 139C578 125 574 110 565 100ZM113 354C171 327 218 282 250 224L270 186C294 142 329 109 371 90L456 50L478 75L408 108C356 132 312 174 283 228L262 265C236 313 197 350 151 372L72 408L50 383L113 354ZM463 158C406 185 358 230 326 288L306 326C282 370 247 403 205 422L120 462L94 433L164 401C217 376 260 335 290 281L311 243C337 195 375 158 422 137L501 100L526 129L463 158Z"]
  };
  var faBacteria = {
    prefix: 'far',
    iconName: 'bacteria',
    icon: [640, 512, [], "e059", "M192 128C183 128 176 135 176 144C176 153 183 160 192 160C201 160 208 153 208 144C208 135 201 128 192 128ZM112 224C103 224 96 231 96 240S103 256 112 256C121 256 128 249 128 240S121 224 112 224ZM400 384C391 384 384 391 384 400S391 416 400 416C409 416 416 409 416 400S409 384 400 384ZM614 231L627 227C637 225 642 215 639 205C636 195 626 191 617 193L604 197C596 183 584 171 569 164L572 150C575 141 569 131 560 129C549 126 540 133 538 141L534 155C532 155 511 153 487 167L478 157C474 153 462 147 452 157C445 163 445 175 452 182L462 192C456 201 451 212 449 224C448 229 447 233 446 238L436 233C427 229 417 233 413 242C408 251 412 261 421 266L430 270C421 284 409 295 395 304L391 295C387 286 377 282 368 286C359 290 355 300 359 309L363 318C359 319 355 320 351 321C338 323 327 328 317 335L306 326C299 320 288 320 281 327C275 335 275 346 283 352L293 362C285 376 281 392 282 409L269 413C259 415 254 425 257 435C260 444 269 449 279 447L292 443C301 457 313 469 327 476L324 490C321 499 327 509 337 511C346 514 356 508 358 499L362 485C369 486 381 485 410 477L414 488C418 497 428 502 437 499C446 495 451 485 448 476L444 465C459 459 474 451 488 442L495 451C501 459 512 461 520 455C527 449 529 438 523 430L516 421C529 410 540 398 551 386L560 392C568 398 580 396 585 389C591 381 589 370 582 364L572 357C581 343 589 329 595 313L606 317C615 320 626 315 629 306C632 297 627 287 618 284L606 280C609 270 611 261 613 251C614 244 614 238 614 231ZM370 440C368 440 366 440 364 440C347 440 331 427 328 410C327 400 329 391 335 383C340 375 349 370 358 368C429 357 485 301 496 230C499 213 514 200 532 200C534 200 536 200 538 201C547 202 556 207 561 215C567 223 569 232 567 242C551 343 471 423 370 440ZM272 226C281 222 285 212 281 203L277 194C281 193 285 192 289 191C302 189 313 184 323 177L334 186C341 192 352 192 359 185C365 177 365 166 357 160L347 150C355 136 359 120 358 103L371 99C381 96 386 87 383 77C380 68 371 62 361 65L348 69C339 55 327 43 313 36L316 22C319 13 313 3 303 1C294 -2 284 4 282 13L278 27C271 26 259 27 230 35L226 24C222 15 212 10 203 13C194 16 189 27 192 36L196 47C181 53 166 61 152 70L145 61C139 53 128 51 120 57C113 63 111 74 117 82L124 91C111 102 100 114 89 126L80 119C72 114 60 115 55 123C49 131 51 142 58 148L68 155C59 169 51 183 45 199L34 195C25 192 14 197 11 206C8 215 13 225 22 228L34 232C31 242 29 251 27 261C26 268 26 274 26 281L13 285C3 287 -2 297 1 307C4 317 14 321 23 319L36 315C44 329 56 341 71 348L68 362C66 369 70 384 85 384C93 384 100 379 102 371L106 357C108 357 129 359 153 345L162 355C166 359 178 365 188 355C195 349 195 337 188 330L178 320C184 311 189 300 191 288C192 283 193 279 194 274L204 279C213 283 223 279 227 270C232 261 228 251 219 246L210 242C219 228 231 217 245 208L249 217C253 226 263 230 272 226ZM143 282C142 288 132 317 102 312C93 310 84 305 79 297C73 289 71 280 72 270C89 169 169 89 270 72C300 67 310 95 311 102C315 122 302 140 282 144C211 155 155 211 143 282Z"]
  };
  var faBacterium = {
    prefix: 'far',
    iconName: 'bacterium',
    icon: [576, 512, [], "e05a", "M543 103C539 90 526 83 513 87L495 92C485 73 468 58 449 48L454 30C457 17 449 4 437 1C424 -2 411 5 408 18L403 35C396 35 388 36 381 37C366 39 352 43 338 47L333 32C329 20 315 13 303 18C290 22 284 36 288 48L293 62C273 71 254 82 235 94L226 81C218 71 203 68 193 76C182 84 180 99 188 109L197 122C180 136 165 152 151 169L138 159C127 152 113 154 105 164C97 175 99 190 110 198L123 207C111 225 101 245 92 265L77 260C65 256 51 262 47 275C43 287 49 300 62 305L77 310C73 322 70 335 68 348C66 357 66 366 67 374L49 380C36 383 29 396 33 409C36 419 46 426 56 426C58 426 60 426 63 425L81 420C91 438 107 454 127 464L122 482C119 495 126 508 139 511C141 512 143 512 145 512C156 512 165 505 168 494L173 476C174 476 176 477 177 477C198 477 218 471 235 460L248 473C253 478 259 480 265 480C271 480 277 478 282 474C291 465 292 450 282 440L269 427C278 414 284 400 286 385C288 378 289 372 291 366L304 371C307 373 310 374 314 374C323 374 331 369 335 360C341 348 336 334 324 329L311 323C324 304 340 289 358 277L364 290C368 299 376 304 386 304C389 304 392 303 395 302C407 297 413 283 407 271L402 258C407 257 412 255 417 255C434 252 449 245 463 235L477 248C481 252 487 254 493 254C499 254 506 251 510 246C519 237 518 222 509 213L495 200C505 182 510 160 509 138L527 132C540 129 547 115 543 103ZM452 181C442 195 427 204 410 207C323 222 254 291 239 379C234 410 207 432 176 432C173 432 169 432 165 431C149 428 134 419 124 405C114 391 110 374 113 357C136 216 248 105 390 81C393 80 397 80 400 80C431 80 458 103 463 133C466 150 462 167 452 181ZM192 288C174 288 160 302 160 320S174 352 192 352S224 338 224 320S210 288 192 288ZM272 184C259 184 248 195 248 208C248 221 259 232 272 232C285 232 296 221 296 208C296 195 285 184 272 184Z"]
  };
  var faBadge = {
    prefix: 'far',
    iconName: 'badge',
    icon: [512, 512, [], "f335", "M256 512C220 512 188 493 169 465C136 472 101 463 75 437C49 411 40 376 47 343C19 324 0 292 0 256S19 188 47 169C40 137 49 101 75 75C101 49 136 40 169 47C188 19 220 0 256 0S324 19 343 47C375 40 411 49 437 75C463 101 472 136 465 169C493 188 512 219 512 256C512 292 493 324 465 343C472 375 463 411 437 437C411 463 376 472 343 465C324 493 292 512 256 512ZM195 404C201 421 211 464 256 464C300 464 310 424 317 404C348 418 375 431 403 403C434 372 413 337 404 317C421 311 464 301 464 256C464 212 424 203 404 195C411 178 435 141 403 109C372 78 337 99 317 108C311 91 301 48 256 48C212 48 202 88 195 108C178 101 141 77 109 109C78 140 99 175 108 195C91 201 48 211 48 256C48 300 88 310 108 317C101 334 77 371 109 403C140 434 174 413 195 404Z"]
  };
  var faBadgeCheck = {
    prefix: 'far',
    iconName: 'badge-check',
    icon: [576, 512, [], "f336", "M544 256C544 219 525 188 497 169C504 136 495 101 469 75C443 49 407 40 375 47C356 19 324 0 288 0S220 19 201 47C168 40 133 49 107 75C81 101 72 137 79 169C51 188 32 220 32 256S51 324 79 343C72 376 81 411 107 437C133 463 168 472 201 465C220 493 252 512 288 512C324 512 356 493 375 465C408 472 443 463 469 437C495 411 504 375 497 343C525 324 544 292 544 256ZM436 317C445 337 466 372 435 403C407 431 380 418 349 404C342 424 332 464 288 464C243 464 233 421 227 404C206 413 172 434 141 403C109 371 132 334 140 317C120 310 80 300 80 256C80 211 123 201 140 195C131 175 110 140 141 109C173 77 210 100 227 108C234 88 244 48 288 48C333 48 343 91 349 108C369 99 404 78 435 109C467 141 443 178 436 195C456 203 496 212 496 256C496 301 453 311 436 317ZM385 183C395 192 395 208 385 217L273 329C269 334 262 336 256 336S244 334 239 329L191 281C182 272 182 256 191 247S216 238 225 247L256 278L351 183C361 174 376 174 385 183Z"]
  };
  var faBadgeDollar = {
    prefix: 'far',
    iconName: 'badge-dollar',
    icon: [576, 512, [], "f645", "M544 256C544 219 525 188 497 169C504 136 495 101 469 75C443 49 407 40 375 47C356 19 324 0 288 0S220 19 201 47C168 40 133 49 107 75C81 101 72 137 79 169C51 188 32 220 32 256S51 324 79 343C72 376 81 411 107 437C133 463 168 472 201 465C220 493 252 512 288 512C324 512 356 493 375 465C408 472 443 463 469 437C495 411 504 375 497 343C525 324 544 292 544 256ZM436 317C445 337 466 372 435 403C407 431 380 418 349 404C342 424 332 464 288 464C243 464 233 421 227 404C206 413 172 434 141 403C109 371 132 334 140 317C120 310 80 300 80 256C80 211 123 201 140 195C131 175 110 140 141 109C173 77 210 100 227 108C234 88 244 48 288 48C333 48 343 91 349 108C369 99 404 78 435 109C467 141 443 178 436 195C456 203 496 212 496 256C496 301 453 311 436 317ZM359 304C355 328 338 344 312 350V360C312 373 302 384 288 384S264 373 264 360V349C255 346 245 343 237 340L232 339C220 334 213 320 218 308C222 295 236 289 248 293L253 295C262 298 272 302 280 303C297 306 311 302 312 296C313 291 313 288 282 279L275 277C257 272 209 258 217 208C221 184 239 168 264 163V152C264 139 275 128 288 128S312 139 312 152V163C318 165 324 166 332 169C345 173 351 187 347 199C343 212 329 219 316 214C308 211 302 210 297 209C280 206 266 210 265 216C264 220 263 224 289 231L295 233C320 240 368 254 359 304Z"]
  };
  var faBadgePercent = {
    prefix: 'far',
    iconName: 'badge-percent',
    icon: [576, 512, [], "f646", "M224 224C242 224 256 210 256 192S242 160 224 160S192 174 192 192S206 224 224 224ZM544 256C544 219 525 188 497 169C504 136 495 101 469 75C443 49 407 40 375 47C356 19 324 0 288 0S220 19 201 47C168 40 133 49 107 75C81 101 72 137 79 169C51 188 32 220 32 256S51 324 79 343C72 376 81 411 107 437C133 463 168 472 201 465C220 493 252 512 288 512C324 512 356 493 375 465C408 472 443 463 469 437C495 411 504 375 497 343C525 324 544 292 544 256ZM436 317C445 337 466 372 435 403C407 431 380 418 349 404C342 424 332 464 288 464C243 464 233 421 227 404C206 413 172 434 141 403C109 371 132 334 140 317C120 310 80 300 80 256C80 211 123 201 140 195C131 175 110 140 141 109C173 77 210 100 227 108C234 88 244 48 288 48C333 48 343 91 349 108C369 99 404 78 435 109C467 141 443 178 436 195C456 203 496 212 496 256C496 301 453 311 436 317ZM352 288C334 288 320 302 320 320S334 352 352 352S384 338 384 320S370 288 352 288ZM369 175C360 166 345 166 335 175L207 303C198 312 198 328 207 337C212 342 218 344 224 344S237 342 241 337L369 209C379 200 379 184 369 175Z"]
  };
  var faBadgeSheriff = {
    prefix: 'far',
    iconName: 'badge-sheriff',
    icon: [512, 512, [], "f8a2", "M440 320C439 320 438 321 437 321L398 256L437 191C438 191 439 192 440 192C460 192 477 177 480 158C482 138 470 119 451 114C432 108 411 118 403 136H327L286 66C292 59 296 50 296 40C296 18 278 0 256 0S216 18 216 40C216 50 220 59 227 67L185 136H109C101 118 80 108 61 114S30 138 32 158C35 177 52 192 72 192C73 192 74 191 75 191L114 256L75 321C74 321 73 320 72 320C52 320 35 335 32 354C30 374 42 393 61 398S101 394 109 376H185L226 446C220 453 216 462 216 472C216 494 234 512 256 512S296 494 296 472C296 462 292 453 285 445L327 376H403C411 394 432 404 451 398C470 393 482 374 480 354C477 335 460 320 440 320ZM313 328C305 328 297 333 292 340L256 401L219 340C215 332 207 328 199 328H127L162 268C167 261 167 251 162 244L127 184H199C207 184 215 179 220 172L256 111L293 172C297 180 305 184 313 184H385L350 244C345 251 345 261 350 268L385 328H313ZM256 208C230 208 208 230 208 256S230 304 256 304S304 282 304 256S282 208 256 208Z"]
  };
  var faBadgerHoney = {
    prefix: 'far',
    iconName: 'badger-honey',
    icon: [640, 512, [], "f6b4", "M622 142C597 128 579 116 552 97C537 87 522 79 507 72C493 67 479 64 466 64C446 64 427 69 410 79C393 89 374 96 355 96H128C57 96 0 153 0 224V240C0 249 7 256 16 256H36C43 286 60 312 82 329L70 362C63 379 62 397 68 417L81 452C86 468 102 480 119 480H183C195 480 207 475 214 465C222 455 225 442 222 430L209 396L231 352H286L305 448C309 466 326 480 345 480H407C419 480 430 475 438 466C446 457 450 444 447 432L422 305C475 273 513 258 541 250L560 288L583 242C606 239 616 239 624 223C631 208 640 187 640 175C640 161 633 149 622 142ZM128 144H355C381 144 407 136 434 121C444 115 455 112 466 112C473 112 481 114 488 117C512 127 521 135 536 144H460C428 144 398 157 367 172L266 233C257 238 247 240 238 240H192C155 240 120 196 113 145C118 145 123 144 128 144ZM585 193C486 206 422 249 368 281C377 326 373 306 398 432H351C329 320 335 354 326 304H201C170 366 177 352 157 394C165 415 162 407 171 432H125L113 403C111 391 113 384 114 379C129 339 123 357 139 313L111 291C97 280 87 264 83 245L74 208H50C54 187 66 170 83 158C94 217 136 272 192 272H238C252 272 266 269 282 262L382 200C409 187 435 176 460 176H477C479 185 486 192 496 192S513 185 515 176H596C592 181 587 189 585 193Z"]
  };
  var faBagShopping = {
    prefix: 'far',
    iconName: 'bag-shopping',
    icon: [448, 512, [], "f290", "M416 160H344V120C344 54 290 0 224 0S104 54 104 120V160H32C14 160 0 174 0 192V432C0 476 36 512 80 512H368C412 512 448 476 448 432V192C448 174 434 160 416 160ZM152 120C152 80 184 48 224 48S296 80 296 120V160H152V120ZM400 432C400 450 386 464 368 464H80C62 464 48 450 48 432V208H104V264C104 277 115 288 128 288S152 277 152 264V208H296V264C296 277 307 288 320 288S344 277 344 264V208H400V432Z"]
  };
  var faBagsShopping = {
    prefix: 'far',
    iconName: 'bags-shopping',
    icon: [576, 512, [], "f847", "M512 256H256C221 256 192 285 192 320V448C192 483 221 512 256 512H512C547 512 576 483 576 448V320C576 285 547 256 512 256ZM480 352C480 405 437 448 384 448S288 405 288 352V344C288 331 299 320 312 320S336 331 336 344V352C336 378 358 400 384 400S432 378 432 352V344C432 331 443 320 456 320S480 331 480 344V352ZM48 416V224C48 215 55 208 64 208H384C393 208 400 215 400 224H448C448 189 419 160 384 160H320V96C320 43 277 0 224 0S128 43 128 96V160H64C29 160 0 189 0 224V416C0 451 29 480 64 480H160V432H64C55 432 48 425 48 416ZM176 96C176 70 198 48 224 48S272 70 272 96V160H176V96Z"]
  };
  var faBahai = {
    prefix: 'far',
    iconName: 'bahai',
    icon: [512, 512, [], "f666", "M496 202L386 187L428 83C433 70 423 57 411 57C408 57 405 58 402 60L308 120L273 13C271 4 263 0 256 0S241 4 239 13L204 120L110 60C107 58 104 57 101 57C89 57 79 70 84 83L126 187L16 202C-2 205 -6 229 10 237L108 290L33 373C22 386 32 404 47 404C48 404 49 404 51 404L159 380L155 493C155 504 164 512 174 512C179 512 184 510 188 505L256 416L324 505C328 510 333 512 338 512C348 512 357 504 357 493L353 380L461 404C463 404 464 404 465 404C480 404 490 386 479 373L404 290L502 237C518 229 514 205 496 202ZM369 322L383 338L363 333L303 320L305 382L306 403L293 386L256 338L219 386L206 403L207 382L209 320L149 333L129 338L143 322L184 276L130 247L112 238L132 235L193 226L170 169L162 149L179 161L231 194L250 135L256 115L262 135L281 194L333 161L350 149L342 169L320 226L380 235L400 238L382 247L328 276L369 322Z"]
  };
  var faBahtSign = {
    prefix: 'far',
    iconName: 'baht-sign',
    icon: [320, 512, [], "e09e", "M261 237C278 219 288 195 288 168C288 111 241 64 184 64H168V24C168 11 157 0 144 0S120 11 120 24V64H24C11 64 0 75 0 88V424C0 437 10 447 22 448C30 449 43 449 59 449C76 449 97 449 120 448V488C120 501 131 512 144 512S168 501 168 488V447C182 447 196 447 210 447C270 446 320 396 320 335C320 293 296 256 261 237ZM184 112C215 112 240 137 240 168S215 224 184 224H168V112H184ZM48 112H120V224H48V112ZM48 401V272H120V400C93 401 67 401 48 401ZM209 399C196 399 182 399 168 399V272H209C244 272 272 300 272 335C272 370 244 398 209 399Z"]
  };
  var faBallPile = {
    prefix: 'far',
    iconName: 'ball-pile',
    icon: [576, 512, [], "f77e", "M480 320C470 320 460 322 450 325C469 308 480 283 480 256C480 203 437 160 384 160C374 160 364 162 354 165C373 148 384 123 384 96C384 43 341 0 288 0S192 43 192 96C192 123 203 148 222 165C212 162 202 160 192 160C139 160 96 203 96 256C96 283 107 308 126 325C116 322 106 320 96 320C43 320 0 363 0 416S43 512 96 512S192 469 192 416C192 389 181 364 162 347C172 350 182 352 192 352S212 350 222 347C203 364 192 389 192 416C192 469 235 512 288 512S384 469 384 416C384 389 373 364 354 347C364 350 374 352 384 352S404 350 414 347C395 364 384 389 384 416C384 469 427 512 480 512S576 469 576 416S533 320 480 320ZM288 48C314 48 336 70 336 96S314 144 288 144S240 122 240 96S262 48 288 48ZM318 325C308 322 298 320 288 320S268 322 258 325C277 308 288 283 288 256S277 204 258 187C268 190 278 192 288 192S308 190 318 187C299 204 288 229 288 256S299 308 318 325ZM96 464C70 464 48 442 48 416S70 368 96 368S144 390 144 416S122 464 96 464ZM192 304C166 304 144 282 144 256S166 208 192 208S240 230 240 256S218 304 192 304ZM288 464C262 464 240 442 240 416S262 368 288 368S336 390 336 416S314 464 288 464ZM384 304C358 304 336 282 336 256S358 208 384 208S432 230 432 256S410 304 384 304ZM480 464C454 464 432 442 432 416S454 368 480 368S528 390 528 416S506 464 480 464Z"]
  };
  var faBallot = {
    prefix: 'far',
    iconName: 'ballot',
    icon: [448, 512, [], "f732", "M128 352H96C87 352 80 359 80 368V400C80 409 87 416 96 416H128C137 416 144 409 144 400V368C144 359 137 352 128 352ZM128 224H96C87 224 80 231 80 240V272C80 281 87 288 96 288H128C137 288 144 281 144 272V240C144 231 137 224 128 224ZM128 96H96C87 96 80 103 80 112V144C80 153 87 160 96 160H128C137 160 144 153 144 144V112C144 103 137 96 128 96ZM384 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H384C419 512 448 483 448 448V64C448 29 419 0 384 0ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H384C393 48 400 55 400 64V448ZM344 104H200C187 104 176 115 176 128S187 152 200 152H344C357 152 368 141 368 128S357 104 344 104ZM344 232H200C187 232 176 243 176 256S187 280 200 280H344C357 280 368 269 368 256S357 232 344 232ZM344 360H200C187 360 176 371 176 384S187 408 200 408H344C357 408 368 397 368 384S357 360 344 360Z"]
  };
  var faBallotCheck = {
    prefix: 'far',
    iconName: 'ballot-check',
    icon: [448, 512, [], "f733", "M128 352H96C87 352 80 359 80 368V400C80 409 87 416 96 416H128C137 416 144 409 144 400V368C144 359 137 352 128 352ZM96 160H128C137 160 144 153 144 144V112C144 103 137 96 128 96H96C87 96 80 103 80 112V144C80 153 87 160 96 160ZM344 360H200C187 360 176 371 176 384S187 408 200 408H344C357 408 368 397 368 384S357 360 344 360ZM171 221C165 214 155 214 149 221L112 257L99 245C93 238 83 238 77 245S70 261 77 267L101 291C104 294 108 296 112 296S120 294 123 291L171 243C178 237 178 227 171 221ZM344 232H232C219 232 208 243 208 256S219 280 232 280H344C357 280 368 269 368 256S357 232 344 232ZM384 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H384C419 512 448 483 448 448V64C448 29 419 0 384 0ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H384C393 48 400 55 400 64V448ZM344 104H200C187 104 176 115 176 128S187 152 200 152H344C357 152 368 141 368 128S357 104 344 104Z"]
  };
  var faBan = {
    prefix: 'far',
    iconName: 'ban',
    icon: [512, 512, [], "f05e", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM64 256C64 212 79 171 105 138L374 407C341 433 300 448 256 448C150 448 64 362 64 256ZM407 374L138 105C171 79 212 64 256 64C362 64 448 150 448 256C448 300 433 341 407 374Z"]
  };
  var faBanBug = {
    prefix: 'far',
    iconName: 'ban-bug',
    icon: [512, 512, [], "f7f9", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256C64 212 79 171 105 138L374 407C341 433 300 448 256 448ZM407 374L334 301C335 300 335 299 335 298L365 304C378 306 383 294 384 291C385 282 380 274 371 272L336 265V247L371 240C380 238 385 230 384 221C382 212 373 206 365 208L335 214C335 214 335 214 335 214C334 210 334 205 332 201C332 201 332 201 332 200C331 196 329 192 327 188C327 188 327 188 327 188L352 174C360 170 362 160 358 152C354 144 344 142 336 146L307 163L307 163C293 151 275 144 256 144C234 144 215 153 201 167L138 105C171 79 212 64 256 64C362 64 448 150 448 256C448 300 433 341 407 374ZM144 304C145 304 146 304 147 304L177 298C178 307 181 316 185 324L160 338C152 342 150 352 154 360C157 365 162 368 168 368C171 368 173 367 176 366L205 349C219 361 237 368 256 368C263 368 269 367 275 365L175 266L141 272C132 274 127 282 128 291C130 299 137 304 144 304Z"]
  };
  var faBanParking = {
    prefix: 'far',
    iconName: 'ban-parking',
    icon: [512, 512, [], "f616", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256C64 220 74 186 91 158L391 392C356 427 309 448 256 448ZM208 188V176H272C298 176 320 198 320 224C320 239 313 253 302 261L208 188ZM421 354L340 291C357 274 368 250 368 224C368 171 325 128 272 128H184C171 128 161 138 160 150L121 120C156 85 203 64 256 64C362 64 448 150 448 256C448 292 438 326 421 354ZM184 384C197 384 208 373 208 360V320H221L160 272V360C160 373 171 384 184 384Z"]
  };
  var faBanSmoking = {
    prefix: 'far',
    iconName: 'ban-smoking',
    icon: [512, 512, [], "f54d", "M112 320H218L122 224H112C103 224 96 231 96 240V304C96 313 103 320 112 320ZM321 128C305 128 292 117 289 102C289 98 285 96 282 96H265C260 96 257 101 257 105C262 136 289 160 321 160C336 160 349 171 352 186C353 190 356 192 360 192H376C381 192 385 187 384 183C379 152 353 128 321 128ZM256 0C115 0 0 115 0 256S115 512 256 512S512 397 512 256S397 0 256 0ZM256 464C141 464 48 371 48 256C48 207 65 162 93 127L385 419C350 447 305 464 256 464ZM290 256H384V288H322L290 256ZM419 385L354 320H400C409 320 416 313 416 304V240C416 231 409 224 400 224H258L127 93C162 65 207 48 256 48C371 48 464 141 464 256C464 305 447 350 419 385Z"]
  };
  var faBandage = {
    prefix: 'far',
    iconName: 'bandage',
    icon: [640, 512, [], "f462", "M576 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H576C611 416 640 387 640 352V160C640 125 611 96 576 96ZM80 368C62 368 48 354 48 336V176C48 158 62 144 80 144H192V368H80ZM272 280C285 280 296 291 296 304S285 328 272 328S248 317 248 304S259 280 272 280ZM248 208C248 195 259 184 272 184S296 195 296 208S285 232 272 232S248 221 248 208ZM344 304C344 291 355 280 368 280S392 291 392 304S381 328 368 328S344 317 344 304ZM368 232C355 232 344 221 344 208S355 184 368 184S392 195 392 208S381 232 368 232ZM592 328C592 350 574 368 552 368H448V144H560C578 144 592 158 592 176V328Z"]
  };
  var faBanjo = {
    prefix: 'far',
    iconName: 'banjo',
    icon: [512, 512, [], "f8a3", "M503 30L473 0C461 -13 440 -13 428 0L382 46C378 50 375 55 373 60L355 114L292 177C271 160 245 150 219 145L218 145C218 130 207 119 192 119C178 119 166 130 166 145V145C140 149 115 159 94 175L93 175C83 165 67 165 57 176C47 185 47 201 56 212L57 212C41 233 31 258 27 284H26C12 284 0 296 0 311C0 325 12 337 26 337H27C31 363 41 388 57 409L56 409C49 416 46 426 49 435C51 444 58 452 68 454C77 456 87 453 93 446L94 446C115 462 140 472 166 476V476C166 491 178 503 192 503C207 503 218 491 218 476V476C244 472 269 462 291 446L291 446C297 453 307 456 316 454C326 452 333 444 335 435C338 426 335 416 328 409L328 409C343 388 353 363 357 337H358C372 337 384 325 384 311C384 296 372 284 358 284H357C353 257 342 232 326 210L389 147L443 130C448 128 452 125 456 121L503 75C515 62 515 42 503 30ZM192 431C126 431 72 377 72 311S126 191 192 191S312 244 312 311C312 377 258 430 192 431ZM151 299C144 293 134 293 128 299L117 311C110 317 110 327 117 333L169 386C176 392 186 392 192 386L203 375C210 368 210 358 203 352L151 299Z"]
  };
  var faBank = {
    prefix: 'far',
    iconName: 'bank',
    icon: [512, 512, [], "f19c", "M488 464H24C11 464 0 475 0 488C0 501 11 512 24 512H488C501 512 512 501 512 488C512 475 501 464 488 464ZM456 432C469 432 480 421 480 408C480 395 469 384 456 384H56C43 384 32 395 32 408C32 421 43 432 56 432H456ZM497 98L265 2C259 -1 253 -1 247 2L15 98C6 102 0 110 0 120V184C0 197 11 208 24 208H64V352H112V208H176V352H224V208H288V352H336V208H400V352H448V208H488C501 208 512 197 512 184V120C512 110 506 102 497 98ZM464 160H301C303 155 304 150 304 144C304 118 282 96 256 96S208 118 208 144C208 150 209 155 211 160H48V136L256 50L464 136V160Z"]
  };
  var faBarcode = {
    prefix: 'far',
    iconName: 'barcode',
    icon: [512, 512, [], "f02a", "M112 32C103 32 96 39 96 48V464C96 473 103 480 112 480C121 480 128 473 128 464V48C128 39 121 32 112 32ZM32 32H16C7 32 0 39 0 48V464C0 473 7 480 16 480H32C41 480 48 473 48 464V48C48 39 41 32 32 32ZM416 32C407 32 400 39 400 48V464C400 473 407 480 416 480S432 473 432 464V48C432 39 425 32 416 32ZM304 32H288C279 32 272 39 272 48V464C272 473 279 480 288 480H304C313 480 320 473 320 464V48C320 39 313 32 304 32ZM496 32H480C471 32 464 39 464 48V464C464 473 471 480 480 480H496C505 480 512 473 512 464V48C512 39 505 32 496 32ZM192 32H176C167 32 160 39 160 48V464C160 473 167 480 176 480H192C201 480 208 473 208 464V48C208 39 201 32 192 32Z"]
  };
  var faBarcodeRead = {
    prefix: 'far',
    iconName: 'barcode-read',
    icon: [576, 512, [], "f464", "M136 0H24C11 0 0 11 0 24V136C0 149 11 160 24 160S48 149 48 136V48H136C149 48 160 37 160 24S149 0 136 0ZM136 464H48V376C48 363 37 352 24 352S0 363 0 376V488C0 501 11 512 24 512H136C149 512 160 501 160 488S149 464 136 464ZM552 352C539 352 528 363 528 376V464H440C427 464 416 475 416 488S427 512 440 512H552C565 512 576 501 576 488V376C576 363 565 352 552 352ZM552 0H440C427 0 416 11 416 24S427 48 440 48H528V136C528 149 539 160 552 160S576 149 576 136V24C576 11 565 0 552 0ZM128 384C137 384 144 377 144 368V144C144 135 137 128 128 128H112C103 128 96 135 96 144V368C96 377 103 384 112 384H128ZM480 368V144C480 135 473 128 464 128C455 128 448 135 448 144V368C448 377 455 384 464 384C473 384 480 377 480 368ZM416 144C416 135 409 128 400 128H384C375 128 368 135 368 144V368C368 377 375 384 384 384H400C409 384 416 377 416 368V144ZM192 128C183 128 176 135 176 144V368C176 377 183 384 192 384C201 384 208 377 208 368V144C208 135 201 128 192 128ZM272 128H256C247 128 240 135 240 144V368C240 377 247 384 256 384H272C281 384 288 377 288 368V144C288 135 281 128 272 128Z"]
  };
  var faBarcodeScan = {
    prefix: 'far',
    iconName: 'barcode-scan',
    icon: [640, 512, [], "f465", "M616 232H24C11 232 0 243 0 256S11 280 24 280H616C629 280 640 269 640 256S629 232 616 232ZM272 48C272 39 265 32 256 32H240C231 32 224 39 224 48V192H272V48ZM384 48C384 39 377 32 368 32H352C343 32 336 39 336 48V192H384V48ZM192 48C192 39 185 32 176 32C167 32 160 39 160 48V192H192V48ZM496 48C496 39 489 32 480 32S464 39 464 48V192H496V48ZM112 48C112 39 105 32 96 32H80C71 32 64 39 64 48V192H112V48ZM576 48C576 39 569 32 560 32H544C535 32 528 39 528 48V192H576V48ZM464 464C464 473 471 480 480 480S496 473 496 464V320H464V464ZM528 464C528 473 535 480 544 480H560C569 480 576 473 576 464V320H528V464ZM64 464C64 473 71 480 80 480H96C105 480 112 473 112 464V320H64V464ZM336 464C336 473 343 480 352 480H368C377 480 384 473 384 464V320H336V464ZM224 464C224 473 231 480 240 480H256C265 480 272 473 272 464V320H224V464ZM160 464C160 473 167 480 176 480C185 480 192 473 192 464V320H160V464Z"]
  };
  var faBars = {
    prefix: 'far',
    iconName: 'bars',
    icon: [448, 512, [], "f0c9", "M424 392H24C11 392 0 403 0 416V416C0 429 11 440 24 440H424C437 440 448 429 448 416V416C448 403 437 392 424 392ZM424 72H24C11 72 0 83 0 96V96C0 109 11 120 24 120H424C437 120 448 109 448 96V96C448 83 437 72 424 72ZM424 232H24C11 232 0 243 0 256V256C0 269 11 280 24 280H424C437 280 448 269 448 256V256C448 243 437 232 424 232Z"]
  };
  var faBarsProgress = {
    prefix: 'far',
    iconName: 'bars-progress',
    icon: [512, 512, [], "f828", "M488 32H24C11 32 0 44 0 59V133C0 148 11 160 24 160H488C501 160 512 148 512 133V59C512 44 501 32 488 32ZM464 112H352V80H464V112ZM488 352H24C11 352 0 364 0 379V453C0 468 11 480 24 480H488C501 480 512 468 512 453V379C512 364 501 352 488 352ZM464 432H288V400H464V432ZM488 192H24C11 192 0 204 0 219V293C0 308 11 320 24 320H488C501 320 512 308 512 293V219C512 204 501 192 488 192ZM464 272H160V240H464V272Z"]
  };
  var faBarsStaggered = {
    prefix: 'far',
    iconName: 'bars-staggered',
    icon: [512, 512, [], "f550", "M424 392H24C11 392 0 403 0 416V416C0 429 11 440 24 440H424C437 440 448 429 448 416V416C448 403 437 392 424 392ZM424 72H24C11 72 0 83 0 96V96C0 109 11 120 24 120H424C437 120 448 109 448 96V96C448 83 437 72 424 72ZM488 232H88C75 232 64 243 64 256V256C64 269 75 280 88 280H488C501 280 512 269 512 256V256C512 243 501 232 488 232Z"]
  };
  var faBaseballBall = {
    prefix: 'far',
    iconName: 'baseball-ball',
    icon: [512, 512, [], "f433", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM300 443C301 440 301 438 302 435C305 422 297 409 284 406C282 405 280 405 278 405C267 405 258 413 255 423C253 431 252 440 250 448C149 445 67 363 64 262C72 260 80 259 87 257C100 254 108 241 105 228C102 217 92 210 82 210C80 210 78 210 76 211C74 211 71 211 69 212C86 141 141 86 212 69C211 72 211 74 210 77C207 90 215 103 228 106C230 107 232 107 234 107C245 107 254 99 257 89C259 81 260 72 262 64C363 67 445 149 448 250C440 252 432 253 425 255C412 258 404 271 407 284C410 295 420 302 431 302C432 302 434 302 436 301C438 301 441 301 443 300C426 371 371 426 300 443ZM200 131C192 131 185 135 180 141C174 150 167 158 159 165C153 171 147 176 140 181C129 189 127 204 135 215C139 221 147 224 154 224C159 224 164 223 168 220C176 214 184 207 192 200C202 191 211 180 219 169C227 159 225 144 214 136C210 133 205 131 200 131ZM358 288C353 288 348 289 344 292C336 298 328 305 320 312C310 321 301 332 293 343C285 353 287 368 298 376C302 379 307 381 312 381C320 381 327 377 332 371C338 362 345 354 353 347C359 341 366 336 372 331C383 323 385 308 377 297C373 291 365 288 358 288Z"]
  };
  var faBaseballBatBall = {
    prefix: 'far',
    iconName: 'baseball-bat-ball',
    icon: [640, 512, [], "f432", "M512 320C459 320 416 363 416 416S459 512 512 512S608 469 608 416S565 320 512 320ZM512 464C485 464 464 442 464 416S485 368 512 368C538 368 560 389 560 416S538 464 512 464ZM626 54L609 32C582 -5 531 -10 497 16L309 152C261 187 217 225 178 270C123 333 72 371 42 392C34 383 19 381 9 389C-1 397 -3 413 5 423L69 503C77 513 92 515 103 507C112 499 114 486 108 476C138 455 190 420 264 388C319 365 371 336 419 301L605 166C641 140 652 90 626 54ZM576 128L391 264C316 317 254 340 229 352L202 314C221 294 262 245 337 191L525 55C538 45 559 46 570 61L583 83C593 97 590 117 576 128Z"]
  };
  var faBasketShopping = {
    prefix: 'far',
    iconName: 'basket-shopping',
    icon: [576, 512, [], "f291", "M552 192H415L359 17C355 4 341 -3 329 1C316 5 309 19 313 31L365 192H211L263 31C267 19 260 5 247 1C235 -3 221 4 217 17L161 192H24C11 192 0 203 0 216C0 229 11 240 24 240H43L88 455C95 488 125 512 159 512H417C451 512 481 488 488 455L533 240H552C565 240 576 229 576 216C576 203 565 192 552 192ZM441 445C438 456 428 464 417 464H159C148 464 138 456 135 445L92 240H145L137 265C133 277 140 291 153 295C155 296 158 296 160 296C170 296 180 290 183 279L196 240H380L393 279C396 290 406 296 416 296C418 296 421 296 423 295C436 291 443 277 439 265L431 240H484L441 445ZM224 320V408C224 417 217 424 208 424S192 417 192 408V320C192 311 199 304 208 304S224 311 224 320ZM304 320V408C304 417 297 424 288 424S272 417 272 408V320C272 311 279 304 288 304S304 311 304 320ZM384 320V408C384 417 377 424 368 424S352 417 352 408V320C352 311 359 304 368 304S384 311 384 320Z"]
  };
  var faBasketShoppingSimple = {
    prefix: 'far',
    iconName: 'basket-shopping-simple',
    icon: [576, 512, [], "e09f", "M552 192H415L359 17C355 4 341 -3 329 1C316 5 309 19 313 31L365 192H211L263 31C267 19 260 5 247 1C235 -3 221 4 217 17L161 192H24C11 192 0 203 0 216C0 229 11 240 24 240H43L88 455C95 488 125 512 159 512H417C451 512 481 488 488 455L533 240H552C565 240 576 229 576 216C576 203 565 192 552 192ZM441 445C438 456 428 464 417 464H159C148 464 138 456 135 445L92 240H145L137 265C133 277 140 291 153 295C155 296 158 296 160 296C170 296 180 290 183 279L196 240H380L393 279C396 290 406 296 416 296C418 296 421 296 423 295C436 291 443 277 439 265L431 240H484L441 445Z"]
  };
  var faBasketballBall = {
    prefix: 'far',
    iconName: 'basketball-ball',
    icon: [512, 512, [], "f434", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM271 65C310 68 345 82 374 105L256 222L222 188C250 154 268 111 271 65ZM188 154L138 105C163 86 191 73 223 67C219 100 207 129 188 154ZM222 256L105 374C82 345 68 310 65 271C111 268 154 250 188 222L222 256ZM256 290L290 324C262 358 244 401 241 447C202 444 167 430 138 407L256 290ZM324 358L374 407C349 426 321 439 289 445C293 412 305 383 324 358ZM290 256L407 138C430 167 444 202 447 241C401 244 358 262 324 290L290 256ZM105 138L154 188C129 207 100 219 67 223C73 191 86 163 105 138ZM407 374L358 324C383 305 412 293 445 289C439 321 426 349 407 374Z"]
  };
  var faBasketballHoop = {
    prefix: 'far',
    iconName: 'basketball-hoop',
    icon: [640, 512, [], "f435", "M633 178C574 72 456 0 320 0S66 72 7 178C2 187 0 198 0 208V326C0 352 15 375 38 385L123 422L117 367L58 341C52 338 48 333 48 326V208C48 205 49 203 49 201C102 107 205 48 320 48S538 107 591 201C591 203 592 205 592 208V326C592 333 588 338 582 341L523 367L517 422L602 385C625 375 640 352 640 326V208C640 198 638 187 633 178ZM528 272V256C528 247 521 240 512 240H128C119 240 112 247 112 256V272C112 281 119 288 128 288H144L168 495C169 502 174 509 182 511C184 512 186 512 188 512C193 512 199 510 202 506L254 452L305 506C309 510 315 512 320 512S331 510 334 506L386 452L437 506C441 510 447 512 452 512C454 512 456 512 458 511C466 509 471 502 472 495L496 288H512C521 288 528 281 528 272ZM357 288L320 327L283 288H357ZM187 315L184 288H219L187 315ZM203 448L196 393L226 424L203 448ZM254 395L209 348L251 313L292 355L254 395ZM320 464L282 424L320 384L358 424L320 464ZM348 355L389 313L431 349L386 395L348 355ZM437 448L414 424L444 393L437 448ZM453 315L421 288H456L453 315ZM480 208V168C480 146 462 128 440 128H200C178 128 160 146 160 168V208H208V176H432V208H480Z"]
  };
  var faBat = {
    prefix: 'far',
    iconName: 'bat',
    icon: [640, 512, [], "f6b5", "M639 287L568 130C563 117 550 110 538 110C532 110 526 112 521 115L416 175L384 64L326 112H314L256 64L224 175L119 115C114 112 108 110 102 110C90 110 77 117 72 130L1 287C-3 298 5 310 17 310C18 310 20 309 22 309L39 304C45 301 52 300 60 300C81 300 102 311 115 329L153 384L166 372C179 360 196 353 213 353C233 353 253 362 266 379L320 448L374 379C387 362 407 353 427 353C444 353 461 360 474 372L487 384L525 329C538 311 559 300 580 300C587 300 595 301 601 303L618 309C620 309 622 310 623 310C635 310 643 298 639 287ZM486 301L476 316C461 309 444 305 427 305C391 305 358 322 336 350L320 370L304 350C282 322 249 305 213 305C196 305 179 309 164 316L154 301C135 273 104 255 69 253L109 164L200 217L254 248L270 188L282 148L283 149L297 160H343L356 149L358 148L369 188L386 248L440 217L531 164L571 253C536 255 505 273 486 301Z"]
  };
  var faBath = {
    prefix: 'far',
    iconName: 'bath',
    icon: [512, 512, [], "f2cd", "M488 256H80V69C80 61 85 53 93 50C101 46 110 48 116 54L119 58C106 85 111 118 133 140L148 155C142 165 143 177 151 185C156 190 162 192 168 192S180 190 185 185L281 89C290 80 290 64 281 55C276 50 271 48 265 48C260 48 255 50 251 52L236 37C214 15 181 10 153 23L152 22C136 7 115 -2 93 1C57 5 32 35 32 69V256H24C11 256 0 267 0 280S11 304 24 304H32V384C32 411 44 437 64 455V488C64 501 75 512 88 512S112 501 112 488V478C117 479 123 480 128 480H384C389 480 395 479 400 478V488C400 501 411 512 424 512S448 501 448 488V455C468 437 480 411 480 384V304H488C501 304 512 293 512 280S501 256 488 256ZM202 71L217 85L181 121L167 106C158 97 158 81 167 71C177 62 193 62 202 71ZM432 384C432 411 410 432 384 432H128C102 432 80 411 80 384V304H432V384Z"]
  };
  var faBatteryBolt = {
    prefix: 'far',
    iconName: 'battery-bolt',
    icon: [576, 512, [], "f376", "M544 192V160C544 125 515 96 480 96H325L305 144H480C489 144 496 151 496 160V352C496 361 489 368 480 368H393L367 416H480C515 416 544 387 544 352V320C562 320 576 306 576 288V224C576 206 562 192 544 192ZM64 368C55 368 48 361 48 352V160C48 151 55 144 64 144H149L169 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H204L230 368H64ZM381 244C376 237 369 232 360 232H219L286 65C291 53 285 39 273 34C261 29 247 35 242 47L162 247C159 254 160 263 164 269S176 280 184 280H319L227 444C221 456 225 470 236 477C240 479 244 480 248 480C256 480 265 476 269 468L381 268C385 260 385 251 381 244Z"]
  };
  var faBatteryEmpty = {
    prefix: 'far',
    iconName: 'battery-empty',
    icon: [576, 512, [], "f244", "M544 192V160C544 125 515 96 480 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H480C515 416 544 387 544 352V320C562 320 576 306 576 288V224C576 206 562 192 544 192ZM496 352C496 361 489 368 480 368H64C55 368 48 361 48 352V160C48 151 55 144 64 144H480C489 144 496 151 496 160V352Z"]
  };
  var faBatteryExclamation = {
    prefix: 'far',
    iconName: 'battery-exclamation',
    icon: [576, 512, [], "e0a0", "M48 352V160C48 151 55 144 64 144H200V96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H192C192 398 198 381 208 368H64C55 368 48 361 48 352ZM544 192V160C544 125 515 96 480 96H344V144H480C489 144 496 151 496 160V352C496 361 489 368 480 368H336C346 381 352 398 352 416H480C515 416 544 387 544 352V320C562 320 576 306 576 288V224C576 206 562 192 544 192ZM272 336C285 336 296 325 296 312V88C296 75 285 64 272 64S248 75 248 88V312C248 325 259 336 272 336ZM272 384C254 384 240 398 240 416C240 434 254 448 272 448S304 434 304 416C304 398 290 384 272 384Z"]
  };
  var faBatteryFull = {
    prefix: 'far',
    iconName: 'battery-full',
    icon: [576, 512, [], "f240", "M96 320H448V192H96V320ZM544 192V160C544 125 515 96 480 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H480C515 416 544 387 544 352V320C562 320 576 306 576 288V224C576 206 562 192 544 192ZM496 352C496 361 489 368 480 368H64C55 368 48 361 48 352V160C48 151 55 144 64 144H480C489 144 496 151 496 160V352Z"]
  };
  var faBatteryHalf = {
    prefix: 'far',
    iconName: 'battery-half',
    icon: [576, 512, [], "f242", "M96 320H288V192H96V320ZM544 192V160C544 125 515 96 480 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H480C515 416 544 387 544 352V320C562 320 576 306 576 288V224C576 206 562 192 544 192ZM496 352C496 361 489 368 480 368H64C55 368 48 361 48 352V160C48 151 55 144 64 144H480C489 144 496 151 496 160V352Z"]
  };
  var faBatteryLow = {
    prefix: 'far',
    iconName: 'battery-low',
    icon: [576, 512, [], "e0a1", "M96 320H144V192H96V320ZM544 192V160C544 125 515 96 480 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H480C515 416 544 387 544 352V320C562 320 576 306 576 288V224C576 206 562 192 544 192ZM496 352C496 361 489 368 480 368H64C55 368 48 361 48 352V160C48 151 55 144 64 144H480C489 144 496 151 496 160V352Z"]
  };
  var faBatteryQuarter = {
    prefix: 'far',
    iconName: 'battery-quarter',
    icon: [576, 512, [], "f243", "M96 320H192V192H96V320ZM544 192V160C544 125 515 96 480 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H480C515 416 544 387 544 352V320C562 320 576 306 576 288V224C576 206 562 192 544 192ZM496 352C496 361 489 368 480 368H64C55 368 48 361 48 352V160C48 151 55 144 64 144H480C489 144 496 151 496 160V352Z"]
  };
  var faBatterySlash = {
    prefix: 'far',
    iconName: 'battery-slash',
    icon: [640, 512, [], "f377", "M631 469L548 405C565 393 576 374 576 352V320C594 320 608 306 608 288V224C608 206 594 192 576 192V160C576 125 547 96 512 96H155L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM528 352C528 361 521 368 512 368H502L216 144H512C521 144 528 151 528 160V352ZM96 368C87 368 80 361 80 352V160C80 160 80 160 80 159L41 129C35 138 32 148 32 160V352C32 387 61 416 96 416H407L346 368H96Z"]
  };
  var faBatteryThreeQuarters = {
    prefix: 'far',
    iconName: 'battery-three-quarters',
    icon: [576, 512, [], "f241", "M96 320H352V192H96V320ZM544 192V160C544 125 515 96 480 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H480C515 416 544 387 544 352V320C562 320 576 306 576 288V224C576 206 562 192 544 192ZM496 352C496 361 489 368 480 368H64C55 368 48 361 48 352V160C48 151 55 144 64 144H480C489 144 496 151 496 160V352Z"]
  };
  var faBed = {
    prefix: 'far',
    iconName: 'bed',
    icon: [640, 512, [], "f236", "M168 304C217 304 256 265 256 216S217 128 168 128S80 167 80 216S119 304 168 304ZM168 176C190 176 208 194 208 216C208 238 190 256 168 256C146 256 128 238 128 216C128 194 146 176 168 176ZM528 128H304C295 128 288 135 288 144V336H48V56C48 43 37 32 24 32H24C11 32 0 43 0 56V456C0 469 11 480 24 480H24C37 480 48 469 48 456V384H592V456C592 469 603 480 616 480L616 480C629 480 640 469 640 456V240C640 178 590 128 528 128ZM592 336H336V176H528C563 176 592 205 592 240V336Z"]
  };
  var faBedBunk = {
    prefix: 'far',
    iconName: 'bed-bunk',
    icon: [576, 512, [], "f8f8", "M152 144C192 144 224 112 224 72S192 0 152 0S80 32 80 72S112 144 152 144ZM152 48C165 48 176 59 176 72S165 96 152 96S128 85 128 72S139 48 152 48ZM464 0H272C263 0 256 7 256 16V160H48V24C48 11 37 0 24 0H24C11 0 0 11 0 24V488C0 501 11 512 24 512H24C37 512 48 501 48 488V464H528V488C528 501 539 512 552 512L552 512C565 512 576 501 576 488V128C576 50 526 0 464 0ZM528 416H304V304H464C499 304 528 333 528 368V416ZM528 276C509 263 487 256 464 256H272C263 256 256 263 256 272V416H48V208H528V276ZM528 160H304V48H464C499 48 528 77 528 112V160ZM152 400C192 400 224 368 224 328S192 256 152 256S80 288 80 328S112 400 152 400ZM152 304C165 304 176 315 176 328S165 352 152 352S128 341 128 328S139 304 152 304Z"]
  };
  var faBedEmpty = {
    prefix: 'far',
    iconName: 'bed-empty',
    icon: [640, 512, [], "f8f9", "M528 160H48V56C48 43 37 32 24 32S0 43 0 56V456C0 469 11 480 24 480S48 469 48 456V384H592V456C592 469 603 480 616 480S640 469 640 456V272C640 210 590 160 528 160ZM592 336H48V208H528C563 208 592 237 592 272V336Z"]
  };
  var faBedFront = {
    prefix: 'far',
    iconName: 'bed-front',
    icon: [512, 512, [], "f8f7", "M80 160C80 142 94 128 112 128H208C226 128 240 142 240 160V192H272V160C272 142 286 128 304 128H400C418 128 432 142 432 160V192H480V96C480 61 451 32 416 32H96C61 32 32 61 32 96V192H80V160ZM448 224H64C29 224 0 253 0 288V456C0 469 11 480 24 480H24C37 480 48 469 48 456V416H464V456C464 469 475 480 488 480L488 480C501 480 512 469 512 456V288C512 253 483 224 448 224ZM464 368H48V288C48 279 55 272 64 272H448C457 272 464 279 464 288V368Z"]
  };
  var faBedPulse = {
    prefix: 'far',
    iconName: 'bed-pulse',
    icon: [640, 512, [], "f487", "M216 96H338L379 172C383 179 391 184 400 184H401C410 184 418 178 422 170L471 65L495 89C500 93 506 96 512 96H616C629 96 640 85 640 72S629 48 616 48H522L481 7C475 1 468 -1 460 0C452 2 446 7 442 14L398 107L373 60C369 53 361 48 352 48H216C203 48 192 59 192 72S203 96 216 96ZM168 336C217 336 256 297 256 248S217 160 168 160S80 199 80 248S119 336 168 336ZM168 208C190 208 208 226 208 248S190 288 168 288C146 288 128 270 128 248S146 208 168 208ZM528 160H488C475 160 464 171 464 184C464 197 475 208 488 208H528C563 208 592 237 592 272V368H336V184C336 171 325 160 312 160S288 171 288 184V368H48V88C48 75 37 64 24 64S0 75 0 88V488C0 501 11 512 24 512S48 501 48 488V416H592V488C592 501 603 512 616 512S640 501 640 488V272C640 210 590 160 528 160Z"]
  };
  var faBee = {
    prefix: 'far',
    iconName: 'bee',
    icon: [576, 512, [], "e0a2", "M448 96H448C420 96 393 106 367 119C368 117 368 114 368 112C368 92 360 73 348 59L379 27C386 21 386 11 379 5S363 -2 357 5L322 40C311 35 300 32 288 32S265 35 254 40L219 5C213 -2 203 -2 197 5S190 21 197 27L228 59C216 73 208 92 208 112C208 114 208 117 209 119C183 106 156 96 128 96H128C57 96 0 146 0 208V208C0 270 57 320 128 320H128C135 320 142 319 149 318C162 418 288 512 288 512S414 418 427 318C434 319 441 320 448 320H448C519 320 576 270 576 208V208C576 146 519 96 448 96ZM196 304H380C380 314 377 325 373 336H203C199 325 196 314 196 304ZM207 256C211 249 216 241 222 235C240 218 263 208 288 208H288C313 208 336 218 354 235C360 241 365 249 369 256H207ZM151 269C143 271 136 272 128 272C84 272 48 243 48 208C48 173 84 144 128 144H128C157 144 189 160 217 180C184 199 160 231 151 269ZM288 449C269 432 247 409 230 384H346C329 409 307 432 288 449ZM448 272C440 272 433 271 425 269C416 231 392 199 359 180C387 160 419 144 448 144H448C492 144 528 173 528 208C528 243 492 272 448 272Z"]
  };
  var faBeerMug = {
    prefix: 'far',
    iconName: 'beer-mug',
    icon: [512, 512, [], "e0a3", "M408 157H368V144C382 125 387 102 382 78C376 48 353 24 324 16C303 11 281 14 263 26C259 28 257 26 256 25C221 -8 163 -8 128 25C127 26 125 28 121 26C103 14 81 11 60 16C31 24 8 48 2 78C-3 102 2 125 16 144V432C16 476 52 512 96 512H288C327 512 360 483 367 446L443 411C475 397 496 366 496 331V245C496 196 457 157 408 157ZM320 432C320 450 306 464 288 464H96C78 464 64 450 64 432V175C84 179 106 176 124 164C125 164 126 164 128 166C145 183 168 192 192 192S239 183 256 166C258 164 260 164 260 164C277 176 299 179 320 175V432ZM328 118C318 130 300 133 287 124C267 110 241 113 223 131C206 147 178 147 161 131C150 121 137 116 124 116C115 116 105 118 97 124C84 133 66 130 56 118C49 109 47 99 49 88C51 76 61 66 72 63C83 60 91 63 96 66C117 80 143 77 161 60C178 44 206 44 223 60C241 77 267 80 288 66C293 63 301 60 312 63C323 66 333 76 335 88C337 99 335 109 328 118ZM448 331C448 347 439 361 424 368L368 392V205H408C430 205 448 223 448 245V331ZM144 240V408C144 417 137 424 128 424S112 417 112 408V240C112 231 119 224 128 224S144 231 144 240ZM208 240V408C208 417 201 424 192 424S176 417 176 408V240C176 231 183 224 192 224S208 231 208 240ZM272 240V408C272 417 265 424 256 424S240 417 240 408V240C240 231 247 224 256 224S272 231 272 240Z"]
  };
  var faBeerMugEmpty = {
    prefix: 'far',
    iconName: 'beer-mug-empty',
    icon: [512, 512, [], "f0fc", "M392 96H352V64C352 46 338 32 320 32H32C14 32 0 46 0 64V400C0 444 36 480 80 480H272C316 480 352 444 352 400V384L427 351C459 337 480 305 480 270V184C480 135 441 96 392 96ZM304 400C304 418 290 432 272 432H80C62 432 48 418 48 400V80H304V400ZM432 270C432 286 423 300 408 307L352 331V144H392C414 144 432 162 432 184V270ZM96 368V144C96 135 103 128 112 128S128 135 128 144V368C128 377 121 384 112 384S96 377 96 368ZM160 368V144C160 135 167 128 176 128S192 135 192 144V368C192 377 185 384 176 384S160 377 160 368ZM224 368V144C224 135 231 128 240 128S256 135 256 144V368C256 377 249 384 240 384S224 377 224 368Z"]
  };
  var faBell = {
    prefix: 'far',
    iconName: 'bell',
    icon: [448, 512, [], "f0f3", "M439 362C420 342 384 310 384 208C384 130 330 68 256 53V32C256 14 242 0 224 0S192 14 192 32V53C118 68 64 130 64 208C64 310 28 342 9 362C3 369 0 377 0 384C0 400 13 416 32 416H416C435 416 448 400 448 384C448 377 445 369 439 362ZM67 368C89 340 112 294 112 209C112 208 112 208 112 208C112 146 162 96 224 96S336 146 336 208C336 208 336 208 336 209C336 294 359 340 381 368H67ZM224 512C259 512 288 483 288 448H160C160 483 189 512 224 512Z"]
  };
  var faBellConcierge = {
    prefix: 'far',
    iconName: 'bell-concierge',
    icon: [512, 512, [], "f562", "M488 400H24C11 400 0 411 0 424C0 437 11 448 24 448H488C501 448 512 437 512 424C512 411 501 400 488 400ZM80 352C80 255 159 176 256 176S432 255 432 352V368H480V352C480 239 397 146 288 130V112H312C325 112 336 101 336 88C336 75 325 64 312 64H200C187 64 176 75 176 88C176 101 187 112 200 112H224V130C115 146 32 239 32 352V368H80V352Z"]
  };
  var faBellExclamation = {
    prefix: 'far',
    iconName: 'bell-exclamation',
    icon: [448, 512, [], "f848", "M224 512C259 512 288 483 288 448H160C160 483 189 512 224 512ZM439 363C420 342 384 311 384 209C384 131 330 69 256 54V33C256 21 250 10 240 4C230 -2 218 -2 208 4C198 10 192 21 192 33V54C118 69 64 131 64 209C64 311 28 342 9 363C3 368 0 376 0 384C0 401 13 416 32 416H416C435 416 448 401 448 384C448 376 445 368 439 363ZM67 368C89 340 112 294 112 209V209C112 147 162 97 224 97S336 147 336 209V209C336 294 359 340 381 368H67ZM224 255C237 255 248 245 248 232V152C248 138 237 128 224 128S200 138 200 152V232C200 245 211 255 224 255ZM224 287C206 287 192 302 192 319S206 351 224 351S256 337 256 319S242 287 224 287Z"]
  };
  var faBellOn = {
    prefix: 'far',
    iconName: 'bell-on',
    icon: [640, 512, [], "f8fa", "M521 101C525 101 529 100 533 98L588 66C600 59 603 44 597 33C590 22 576 18 564 24L509 56C499 62 495 73 498 83C501 94 510 101 521 101ZM112 193C112 179 101 169 88 169H24C11 169 0 179 0 193S11 217 24 217H88C101 217 112 206 112 193ZM52 66L107 98C114 102 124 102 131 98C139 94 143 86 143 77C143 68 139 60 131 56L76 24C68 20 59 20 51 24C44 28 39 36 39 45C39 54 44 62 52 66ZM616 169H552C539 169 528 179 528 193S539 217 552 217H616C629 217 640 206 640 193S629 169 616 169ZM480 209C480 131 426 69 352 54V33C352 21 346 10 336 4C326 -2 314 -2 304 4C294 10 288 21 288 33V54C214 69 160 131 160 209C160 311 124 342 105 363C99 368 96 376 96 384C96 401 109 416 128 416H512C531 416 544 401 544 384C544 376 541 368 535 363C516 342 480 311 480 209ZM163 368C185 340 208 294 208 209C208 209 208 209 208 209C208 147 258 97 320 97S432 147 432 209C432 209 432 209 432 209C432 294 455 340 477 368H163ZM320 512C355 512 384 483 384 448H256C256 483 285 512 320 512Z"]
  };
  var faBellPlus = {
    prefix: 'far',
    iconName: 'bell-plus',
    icon: [448, 512, [], "f849", "M224 512C259 512 288 483 288 448H160C160 483 189 512 224 512ZM439 363C420 342 384 311 384 209C384 131 330 69 256 54V33C256 21 250 10 240 4C230 -2 218 -2 208 4C198 10 192 21 192 33V54C118 69 64 131 64 209C64 311 28 342 9 363C3 368 0 376 0 384C0 401 13 416 32 416H416C435 416 448 401 448 384C448 376 445 368 439 363ZM67 368C89 340 112 294 112 209V209C112 147 162 97 224 97S336 147 336 209V209C336 294 359 340 381 368H67ZM280 216H248V184C248 171 237 160 224 160S200 171 200 184V216H168C155 216 144 227 144 240S155 264 168 264H200V296C200 309 211 320 224 320S248 309 248 296V264H280C293 264 304 253 304 240S293 216 280 216Z"]
  };
  var faBellSchool = {
    prefix: 'far',
    iconName: 'bell-school',
    icon: [512, 512, [], "f5d5", "M464 352C438 352 416 374 416 400C416 416 424 431 437 440C431 454 417 464 400 464H350C351 459 352 454 352 448V358C400 311 426 242 412 167C396 86 331 19 249 4C116 -21 0 80 0 208C0 267 25 320 64 358V448C64 483 93 512 128 512H400C442 512 477 482 486 442C501 434 512 419 512 400C512 374 490 352 464 352ZM304 448C304 457 297 464 288 464H128C119 464 112 457 112 448V392C141 407 173 416 208 416S275 407 304 392V448ZM251 362C130 394 22 286 54 165C68 111 111 68 165 54C286 22 394 130 362 251C348 305 305 348 251 362ZM227 114C159 101 101 159 114 227C121 264 152 295 189 302C257 315 315 257 302 189C295 152 264 121 227 114ZM208 256C182 256 160 234 160 208S182 160 208 160S256 182 256 208S234 256 208 256Z"]
  };
  var faBellSchoolSlash = {
    prefix: 'far',
    iconName: 'bell-school-slash',
    icon: [640, 512, [], "f5d6", "M631 469L570 422C574 415 576 408 576 400C576 374 555 352 528 352C516 352 505 357 497 364L445 323C474 280 487 225 476 167C460 86 395 19 313 4C236 -11 166 17 119 68L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM317 223L246 168C254 163 262 160 272 160C299 160 320 182 320 208C320 213 319 218 317 223ZM426 251C422 267 416 281 407 294L356 254C366 235 371 213 366 189C359 152 328 121 291 114C259 108 229 118 207 137L156 97C176 77 201 61 229 54C350 22 458 130 426 251ZM464 464H414C415 459 416 454 416 448V422L332 357C327 359 321 361 315 362C201 393 98 298 114 185L72 153C67 170 64 189 64 208C64 267 89 320 128 358V448C128 483 157 512 192 512H464C482 512 498 506 512 497L468 463C467 463 466 464 464 464ZM368 448C368 457 361 464 352 464H192C183 464 176 457 176 448V392C205 407 237 416 272 416S339 407 368 392V448Z"]
  };
  var faBellSlash = {
    prefix: 'far',
    iconName: 'bell-slash',
    icon: [640, 512, [], "f1f6", "M631 469L540 398C542 394 544 389 544 384C544 377 541 369 535 362C516 342 480 310 480 208C480 130 426 68 352 53V32C352 14 338 0 320 0S288 14 288 32V53C245 62 210 87 187 121L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM225 151C244 118 279 96 320 96C382 96 432 146 432 208V209C432 264 442 303 455 331L225 151ZM320 512C355 512 384 483 384 448H256C256 483 285 512 320 512ZM163 368C180 346 198 312 205 257L160 221C156 312 123 342 105 362C99 369 96 377 96 384C96 400 109 416 128 416H408L347 368H163Z"]
  };
  var faBells = {
    prefix: 'far',
    iconName: 'bells',
    icon: [640, 512, [], "f77f", "M242 254C214 177 247 93 316 54C307 49 298 44 288 40C219 15 142 51 117 120C117 122 103 160 102 162C73 242 36 257 15 267C-6 278 -5 308 18 316L261 405C269 386 280 359 257 297C248 270 251 279 242 254ZM138 444C166 454 196 444 212 421L97 379C94 407 110 434 138 444ZM502 476C529 466 546 439 543 411L428 453C444 476 474 486 502 476ZM626 299C605 289 567 274 538 194C537 192 523 154 523 152C503 98 452 64 397 64C382 64 367 67 352 72C283 97 247 174 272 243C273 245 287 283 288 286C317 366 297 400 288 422C281 440 294 459 313 459C316 459 319 459 322 458L622 348C643 341 647 311 626 299ZM348 397C354 368 354 327 333 268C331 265 318 230 317 227C309 205 310 182 320 161C330 141 347 125 368 117C378 114 387 112 397 112C433 112 465 135 477 168C478 168 490 202 493 211C514 269 541 300 564 318L348 397Z"]
  };
  var faBezierCurve = {
    prefix: 'far',
    iconName: 'bezier-curve',
    icon: [640, 512, [], "f55b", "M576 176C611 176 640 147 640 112S611 48 576 48C549 48 526 65 517 88H400V64C400 46 386 32 368 32H272C254 32 240 46 240 64V88H123C114 65 91 48 64 48C29 48 0 77 0 112S29 176 64 176C91 176 114 159 123 136H203C139 174 94 242 89 320H64C46 320 32 334 32 352V448C32 466 46 480 64 480H160C178 480 192 466 192 448V352C192 334 178 320 160 320H137C143 253 184 197 242 170C246 182 258 192 272 192H368C382 192 394 182 398 170C456 197 497 253 503 320H480C462 320 448 334 448 352V448C448 466 462 480 480 480H576C594 480 608 466 608 448V352C608 334 594 320 576 320H551C546 242 501 174 437 136H517C526 159 549 176 576 176ZM560 110L561 108C562 101 569 96 576 96C585 96 592 103 592 112S585 128 576 128C569 128 562 123 561 116L560 114V110ZM80 114L79 116C78 123 71 128 64 128C55 128 48 121 48 112S55 96 64 96C71 96 78 101 79 108L80 110V114ZM144 368V432H80V368H144ZM352 144H288V80H352V144ZM560 368V432H496V368H560Z"]
  };
  var faBicycle = {
    prefix: 'far',
    iconName: 'bicycle',
    icon: [640, 512, [], "f206", "M512 224C498 224 485 227 472 231L374 49C368 38 358 32 346 32H311C297 32 287 43 287 56C287 69 297 80 311 80H336L371 144H221L194 106C190 100 182 96 175 96H119C105 96 95 107 95 120C95 133 105 144 119 144H162L184 175L158 228C148 226 138 224 128 224C57 224 0 281 0 352C0 423 57 480 128 480C193 480 246 431 254 368H303C311 368 319 364 323 356L408 213L430 254C402 278 384 313 384 352C384 423 441 480 512 480S640 423 640 352C640 281 583 224 512 224ZM128 432C84 432 48 396 48 352S84 272 128 272C131 272 133 273 135 273L105 333C101 341 102 350 106 357C111 364 118 368 127 368H206C199 404 167 432 128 432ZM165 320L216 220L287 320H165ZM315 276L255 192H365L315 276ZM512 432C468 432 432 396 432 352C432 331 440 312 454 297L478 342C484 354 499 358 511 352L511 352C522 346 527 331 520 319L495 274C501 273 506 272 512 272C556 272 592 308 592 352S556 432 512 432Z"]
  };
  var faBinoculars = {
    prefix: 'far',
    iconName: 'binoculars',
    icon: [512, 512, [], "f1e5", "M416 80H320V48C320 39 327 32 336 32H400C409 32 416 39 416 48V80ZM192 48C192 39 185 32 176 32H112C103 32 96 39 96 48V80H192V48ZM512 432C512 458 491 480 464 480H336C310 480 288 458 288 432V288H224V432C224 458 202 480 176 480H48C21 480 0 458 0 432L0 388C4 258 61 238 64 144C64 126 78 112 96 112L192 112C210 112 224 126 224 144V160H288V144C288 126 302 112 320 112L416 112C434 112 448 126 448 144C451 238 508 258 512 388L512 432ZM176 160H111C107 205 93 237 80 265C64 298 50 329 48 389L48 432L176 432V160ZM464 432L464 388C462 329 448 298 432 265C419 237 405 205 401 160H336V432H464Z"]
  };
  var faBiohazard = {
    prefix: 'far',
    iconName: 'biohazard',
    icon: [576, 512, [], "f780", "M288 112C307 112 324 116 341 122C354 111 364 97 370 81C345 70 317 64 288 64C259 64 231 70 206 81C212 97 222 111 235 122C252 116 269 112 288 112ZM388 396C392 412 400 427 412 439C460 403 491 348 495 285C488 283 481 282 473 282C464 282 455 284 447 287C442 331 421 370 388 396ZM164 439C176 427 184 412 188 396C155 370 133 331 129 287C121 284 112 282 103 282C95 282 88 283 80 285C84 348 116 403 164 439ZM575 283C562 244 536 212 501 191C484 181 465 175 446 171C452 154 456 135 456 115C456 74 442 34 415 3C413 0 408 -1 405 1C402 3 400 7 401 11C406 25 408 37 408 49C408 117 354 172 288 172S168 117 168 49C168 37 170 25 175 11C176 7 174 3 171 1C168 -1 164 0 161 3C135 34 120 74 120 115C120 135 124 154 130 171C111 175 92 181 75 191C40 212 14 244 0 283C-1 287 1 291 4 293C7 295 11 295 14 292C23 281 33 273 43 267C100 233 174 253 207 312C240 370 220 446 163 479C153 486 141 490 127 493C124 494 121 497 121 501C121 505 124 508 127 509C167 517 208 510 243 489C261 479 276 465 288 449C300 465 315 479 333 489C368 510 409 517 448 509C452 508 455 505 455 501C455 497 452 494 449 493C435 490 423 486 413 479C355 446 336 370 369 312C402 253 475 233 533 267C543 273 553 281 562 292C564 295 569 295 572 293C575 291 577 287 575 283ZM288 320C261 320 240 299 240 272C240 246 261 224 288 224C314 224 336 246 336 272C336 299 314 320 288 320Z"]
  };
  var faBitcoinSign = {
    prefix: 'far',
    iconName: 'bitcoin-sign',
    icon: [320, 512, [], "e0a4", "M261 237C278 219 288 195 288 168C288 116 250 73 200 66V24C200 11 189 0 176 0S152 11 152 24V64H104V24C104 11 93 0 80 0S56 11 56 24V64H24C11 64 0 75 0 88V424C0 437 10 447 22 448C29 448 41 449 56 449V488C56 501 67 512 80 512S104 501 104 488V448C117 448 131 448 146 448C148 448 150 448 152 448V488C152 501 163 512 176 512S200 501 200 488V447C203 447 206 447 210 447C270 446 320 396 320 335C320 293 296 256 261 237ZM48 112H184C215 112 240 137 240 168S215 224 184 224H48V112ZM209 399C189 399 166 399 145 400C109 400 72 401 48 401V272H209C244 272 272 300 272 335C272 370 244 398 209 399Z"]
  };
  var faBlanket = {
    prefix: 'far',
    iconName: 'blanket',
    icon: [448, 512, [], "f498", "M448 120C448 71 409 32 360 32H88C39 32 0 71 0 120V368C0 430 50 480 112 480H424C437 480 448 469 448 456S437 432 424 432H112C77 432 48 403 48 368S77 304 112 304H380C391 304 400 313 400 324S391 344 380 344H120C107 344 96 355 96 368S107 392 120 392H380C418 392 448 362 448 324C448 323 448 322 448 321C448 321 448 320 448 320V120ZM380 256H112C88 256 66 264 48 276V120C48 98 66 80 88 80H360C382 80 400 98 400 120V259C394 257 387 256 380 256Z"]
  };
  var faBlender = {
    prefix: 'far',
    iconName: 'blender',
    icon: [512, 512, [], "f517", "M426 330L512 0H48C22 0 0 22 0 48V208C0 234 22 256 48 256H150L156 327C121 341 96 376 96 416V480C96 498 110 512 128 512H448C466 512 480 498 480 480V416C480 378 458 346 426 330ZM48 208V48H132L146 208H48ZM450 48L437 96H304C295 96 288 103 288 112V112C288 121 295 128 304 128H429L412 192H304C295 192 288 199 288 208V208C288 217 295 224 304 224H404L379 320H204L180 48H450ZM432 464H144V416C144 390 166 368 192 368H384C410 368 432 390 432 416V464ZM288 392C275 392 264 403 264 416S275 440 288 440S312 429 312 416S301 392 288 392Z"]
  };
  var faBlenderPhone = {
    prefix: 'far',
    iconName: 'blender-phone',
    icon: [576, 512, [], "f6b6", "M352 392C339 392 328 403 328 416S339 440 352 440C365 440 376 429 376 416S365 392 352 392ZM116 123C123 123 130 119 133 112L159 49C162 42 159 33 152 29L113 5C98 -4 80 0 69 12C-24 116 -23 272 71 374C81 385 100 387 113 379L152 355C159 351 162 342 159 335L133 272C130 265 123 261 116 262L71 266C54 219 53 166 71 118L116 123ZM490 330L576 0H192L220 327C185 341 160 376 160 416V480C160 498 174 512 192 512H512C530 512 544 498 544 480V416C544 378 522 346 490 330ZM514 48L501 96H368C359 96 352 103 352 112C352 121 359 128 368 128H493L476 192H368C359 192 352 199 352 208C352 217 359 224 368 224H468L443 320H268L244 48H514ZM496 464H208V416C208 390 230 368 256 368H448C474 368 496 390 496 416V464Z"]
  };
  var faBlinds = {
    prefix: 'far',
    iconName: 'blinds',
    icon: [512, 512, [], "f8fb", "M495 432C491 420 477 413 464 417C452 421 445 435 449 448L455 464H57L63 448C67 435 60 421 48 417C35 413 21 420 17 432L1 480C-1 488 0 496 5 502S16 512 24 512H488C496 512 503 508 507 502S513 488 511 480L495 432ZM495 304C491 292 477 285 464 289C452 293 445 307 449 320L455 336H57L63 320C67 307 60 293 48 289C35 285 21 292 17 304L1 352C-1 360 0 368 5 374S16 384 24 384H488C496 384 503 380 507 374S513 360 511 352L495 304ZM494 47C504 44 512 35 512 24C512 11 501 0 488 0H24C11 0 0 11 0 24C0 35 8 44 18 47L1 96C-1 104 0 112 5 118S16 128 24 128H144V164C116 174 96 201 96 232C96 272 128 304 168 304C208 304 240 272 240 232C240 201 220 174 192 164V48H444L455 80H224V128H488C496 128 503 124 507 118S513 104 511 96L494 47ZM57 80L68 48H144V80H57ZM168 256C155 256 144 245 144 232S155 208 168 208S192 219 192 232S181 256 168 256ZM495 176C491 164 477 157 464 161C452 165 445 179 449 192L455 208H269C271 216 272 224 272 232S271 248 269 256H488C496 256 503 252 507 246S513 232 511 224L495 176ZM48 161C35 157 21 164 17 176L1 224C-1 232 0 240 5 246S16 256 24 256H67C65 248 64 240 64 232S65 216 67 208H57L63 192C67 179 60 165 48 161Z"]
  };
  var faBlindsOpen = {
    prefix: 'far',
    iconName: 'blinds-open',
    icon: [512, 512, [], "f8fc", "M488 464H24C11 464 0 475 0 488S11 512 24 512H488C501 512 512 501 512 488S501 464 488 464ZM488 160H224V208H488C501 208 512 197 512 184S501 160 488 160ZM24 160C11 160 0 171 0 184S11 208 24 208H144V240C144 241 145 243 145 244C117 254 96 280 96 312C96 352 128 384 168 384S240 352 240 312C240 280 219 254 191 244C191 243 192 241 192 240V48H488C501 48 512 37 512 24S501 0 488 0H24C11 0 0 11 0 24S11 48 24 48H144V160H24ZM168 288C181 288 192 299 192 312S181 336 168 336S144 325 144 312S155 288 168 288ZM488 320H271C270 338 264 354 255 368H488C501 368 512 357 512 344S501 320 488 320ZM24 368H81C72 354 66 338 65 320H24C11 320 0 331 0 344S11 368 24 368Z"]
  };
  var faBlindsRaised = {
    prefix: 'far',
    iconName: 'blinds-raised',
    icon: [512, 512, [], "f8fd", "M494 47C504 44 512 35 512 24C512 11 501 0 488 0H24C11 0 0 11 0 24C0 35 8 44 18 47L1 96C-1 104 0 112 5 118S16 128 24 128H144V208H57L63 192C67 179 60 165 48 161C35 157 21 164 17 176L1 224C-1 232 0 240 5 246S16 256 24 256H144V372C116 382 96 409 96 440C96 480 128 512 168 512S240 480 240 440C240 409 220 382 192 372V48H444L455 80H224V128H488C496 128 503 124 507 118C512 112 513 104 511 96L494 47ZM57 80L68 48H144V80H57ZM168 464C155 464 144 453 144 440S155 416 168 416S192 427 192 440S181 464 168 464ZM495 176C491 164 477 157 464 161C452 165 445 179 449 192L455 208H224V256H488C496 256 503 252 507 246C512 240 513 232 511 224L495 176Z"]
  };
  var faBlog = {
    prefix: 'far',
    iconName: 'blog',
    icon: [512, 512, [], "f781", "M217 0C204 -1 193 10 192 23C191 36 202 47 215 48C347 54 459 165 464 297C465 310 475 320 488 320C488 320 489 320 489 320C502 319 513 308 512 295C505 139 373 7 217 0ZM218 96C205 95 193 105 192 118S201 143 214 144C294 149 363 218 368 298C369 310 379 320 392 320C393 320 393 320 394 320C407 319 417 308 416 294C409 192 320 103 218 96ZM144 224H120C107 224 96 235 96 248C96 261 107 272 120 272H144C197 272 240 315 240 368S197 464 144 464S48 421 48 368V120C48 107 37 96 24 96S0 107 0 120V368C0 447 65 512 144 512S288 447 288 368S223 224 144 224Z"]
  };
  var faBold = {
    prefix: 'far',
    iconName: 'bold',
    icon: [384, 512, [], "f032", "M304 242C306 240 308 238 310 236C333 213 345 183 345 151C344 85 290 32 225 32H24C11 32 0 43 0 56S11 80 24 80H48V432H24C11 432 0 443 0 456S11 480 24 480H240C311 480 368 423 368 352C368 305 342 264 304 242ZM225 80C264 80 297 112 297 151C297 171 290 189 276 203C262 216 244 224 225 224H96V80H225ZM240 432H96V272H240C284 272 320 308 320 352S284 432 240 432Z"]
  };
  var faBolt = {
    prefix: 'far',
    iconName: 'bolt',
    icon: [448, 512, [], "f0e7", "M429 173C425 165 417 160 408 160H243L294 33C297 26 296 17 292 11C287 4 280 0 272 0H96C85 0 75 8 73 19L17 275C15 282 17 289 21 295C26 301 33 304 40 304H195L160 483C158 494 164 505 174 510C177 511 181 512 184 512C191 512 199 509 203 502L427 198C433 191 433 181 429 173ZM228 388L248 285C249 278 247 270 242 265S231 256 224 256H70L115 48H237L186 175C183 182 184 191 188 197C193 204 200 208 208 208H361L228 388Z"]
  };
  var faBomb = {
    prefix: 'far',
    iconName: 'bomb',
    icon: [512, 512, [], "f1e2", "M390 144L403 131C410 125 410 115 403 109C400 106 396 104 392 104S384 106 381 109L368 122L333 86C328 82 323 80 317 80S306 82 302 86L280 109C257 101 233 96 208 96C93 96 0 189 0 304S93 512 208 512S416 419 416 304C416 279 411 255 403 232L426 210C434 201 434 188 426 179L390 144ZM369 198L347 220L358 249C365 267 368 286 368 304C368 392 296 464 208 464S48 392 48 304S120 144 208 144C226 144 245 147 263 154L292 165L314 143L317 139L329 151L357 178L373 195L369 198ZM224 176C145 176 80 241 80 320C80 329 87 336 96 336S112 329 112 320C112 258 162 208 224 208C233 208 240 201 240 192S233 176 224 176ZM509 59L469 43L453 3C451 -1 445 -1 443 3L427 43L387 59C383 61 383 67 387 69L427 85L443 125C445 129 451 129 453 125L469 85L509 69C513 67 513 61 509 59Z"]
  };
  var faBone = {
    prefix: 'far',
    iconName: 'bone',
    icon: [576, 512, [], "f5d7", "M576 190V186C576 143 545 106 503 98C457 89 412 113 396 156C394 162 388 168 383 168H193C188 168 182 162 179 155C165 113 118 89 73 98C31 106 0 143 0 186V190C0 216 12 240 32 256C12 272 0 296 0 322V326C0 369 31 406 73 414C79 415 86 416 92 416C131 416 167 393 180 356C182 350 188 344 193 344H383C388 344 394 350 397 357C412 399 458 423 503 414C545 406 576 369 576 326V322C576 296 564 272 544 256C564 240 576 216 576 190ZM528 190C528 204 519 218 504 224C492 230 484 242 484 256S492 282 504 288L504 288C519 294 528 308 528 322V326C528 346 514 363 494 367C471 372 449 360 442 341C434 319 412 296 383 296H193C164 296 142 319 134 341C127 360 105 372 82 367C62 363 48 346 48 326V322C48 308 57 294 72 287C84 282 92 270 92 256S84 230 72 224C57 218 48 204 48 190V186C48 166 62 149 82 145C85 144 89 144 92 144C111 144 128 155 134 172C142 193 164 216 193 216H383C412 216 434 193 442 171C449 152 471 140 494 145C514 149 528 166 528 186V190Z"]
  };
  var faBoneBreak = {
    prefix: 'far',
    iconName: 'bone-break',
    icon: [640, 512, [], "f5d8", "M408 160C414 160 420 158 425 153L473 105C482 96 482 80 473 71C464 62 448 62 439 71L391 119C382 128 382 144 391 153C396 158 402 160 408 160ZM320 128C333 128 344 117 344 104V24C344 11 333 0 320 0C307 0 296 11 296 24V104C296 117 307 128 320 128ZM215 153C220 158 226 160 232 160S244 158 249 153C258 144 258 128 249 119L201 71C192 62 176 62 167 71S158 96 167 105L215 153ZM582 198C539 182 489 199 466 238C463 243 457 245 452 245L373 227C360 224 347 232 345 245S350 271 363 274L443 292C468 296 495 284 508 262C519 243 543 235 566 243C584 250 595 270 591 289L591 293C588 308 576 320 560 324C546 328 536 339 534 352C532 365 537 379 549 386C562 395 568 410 566 424L565 428C561 448 543 463 522 464C500 464 480 450 476 431L476 429C472 404 451 384 427 380L320 354L215 379C189 384 168 404 164 429L164 431C160 451 140 465 118 464C97 463 79 448 75 428L74 424C72 410 78 395 91 386C103 379 108 365 106 352C104 339 94 328 80 324C64 320 52 308 49 293L49 289C45 270 56 250 75 243C96 235 121 243 132 262C145 284 171 296 199 291L277 274C290 271 298 258 295 245C293 232 280 224 267 227L190 244C183 245 177 243 174 237C151 199 101 182 58 198C17 214 -6 256 2 298L2 302C7 328 24 349 47 362C30 382 22 408 27 433L28 437C36 479 73 510 116 512C163 514 205 482 212 437L212 436C213 431 217 428 225 426L320 403L417 427C423 428 427 431 428 436L428 437C435 480 474 512 520 512C522 512 523 512 524 512C567 510 604 479 612 437L613 433C618 408 610 382 593 362C616 349 633 328 638 302L638 298C646 256 623 214 582 198Z"]
  };
  var faBong = {
    prefix: 'far',
    iconName: 'bong',
    icon: [512, 512, [], "f55c", "M468 212L426 170C417 161 402 161 392 170L392 170C383 180 383 195 392 204L396 208L357 247C345 236 332 226 318 218V48H326C339 48 350 37 350 24V24C350 11 339 0 326 0L118 0C105 0 94 11 94 24V24C94 37 105 48 118 48H126V218C69 251 30 313 30 384C30 427 44 467 68 499C74 506 85 512 94 512H350C359 512 370 506 376 499C400 467 414 427 414 384C414 348 404 314 386 285L430 242L434 246C443 255 458 255 468 246V246C477 236 477 221 468 212ZM150 259L174 246V48H270V246L294 259C319 274 338 295 350 320H93C106 295 125 274 150 259Z"]
  };
  var faBook = {
    prefix: 'far',
    iconName: 'book',
    icon: [448, 512, [], "f02d", "M424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352ZM152 160H328C341 160 352 149 352 136S341 112 328 112H152C139 112 128 123 128 136S139 160 152 160ZM152 240H328C341 240 352 229 352 216S341 192 328 192H152C139 192 128 203 128 216S139 240 152 240Z"]
  };
  var faBookAtlas = {
    prefix: 'far',
    iconName: 'book-atlas',
    icon: [448, 512, [], "f558", "M232 320C298 320 352 266 352 200S298 80 232 80S112 134 112 200S166 320 232 320ZM318 184H284C282 160 278 139 271 122C296 134 313 157 318 184ZM284 216H318C313 243 295 266 271 278C278 261 282 240 284 216ZM232 114C239 123 250 147 252 184H212C214 147 225 123 232 114ZM252 216C250 253 239 277 232 286C225 277 214 253 212 216H252ZM193 122C186 139 182 160 180 184H146C151 157 168 134 193 122ZM180 216C182 240 186 261 193 278C169 266 151 243 146 216H180ZM424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352Z"]
  };
  var faBookBible = {
    prefix: 'far',
    iconName: 'book-bible',
    icon: [448, 512, [], "f647", "M160 208H208V304C208 313 215 320 224 320H256C265 320 272 313 272 304V208H320C329 208 336 201 336 192V160C336 151 329 144 320 144H272V96C272 87 265 80 256 80H224C215 80 208 87 208 96V144H160C151 144 144 151 144 160V192C144 201 151 208 160 208ZM424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352Z"]
  };
  var faBookBlank = {
    prefix: 'far',
    iconName: 'book-blank',
    icon: [448, 512, [], "f5d9", "M424 464H416V400H424C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464ZM48 80C48 62 62 48 80 48H400V352H80C69 352 58 354 48 359V80ZM48 432C48 414 62 400 80 400H368V464H80C62 464 48 450 48 432Z"]
  };
  var faBookFont = {
    prefix: 'far',
    iconName: 'book-font',
    icon: [448, 512, [], "e0a5", "M424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352ZM141 301C153 307 168 303 173 291L191 256H289L306 291C311 299 319 304 328 304C332 304 335 303 339 301C351 296 355 281 349 269L261 93C253 77 227 77 218 93L130 269C125 281 129 296 141 301ZM240 158L265 208H215L240 158Z"]
  };
  var faBookHeart = {
    prefix: 'far',
    iconName: 'book-heart',
    icon: [448, 512, [], "f499", "M424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352ZM230 300C236 305 244 305 250 300L335 214C359 189 358 148 330 125C306 105 271 109 249 131L240 140L231 131C209 109 174 105 150 125C122 148 121 189 145 214L230 300Z"]
  };
  var faBookJournalWhills = {
    prefix: 'far',
    iconName: 'book-journal-whills',
    icon: [448, 512, [], "f66a", "M424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352ZM149 230C151 232 152 235 152 238C151 241 149 243 147 244C144 245 141 245 139 242L119 225C130 279 180 320 240 320S350 279 361 225L341 242C338 246 333 245 330 242C329 240 328 238 328 237C328 234 329 232 331 230L364 202C364 201 364 201 364 200C364 190 362 179 359 169L342 186C338 189 334 189 330 186S327 178 330 175L353 152C342 128 323 109 300 96C299 96 297 96 295 97C295 98 294 99 294 100C294 101 294 102 295 102C301 112 305 123 305 134C305 149 299 162 290 174C288 175 288 177 289 178C301 195 303 216 296 235C288 253 272 267 253 271H252V243L258 250C260 252 263 252 266 252C269 251 271 249 272 246S272 240 270 238L259 228H272C276 228 280 224 280 220S276 212 272 212H259L270 202C273 198 273 193 270 190S262 187 258 190L252 197V100C252 93 247 88 240 88S228 93 228 100V197L222 190C218 187 214 187 210 190S207 198 210 202L221 212H208C204 212 200 216 200 220S204 228 208 228H221L210 238C207 242 207 246 210 250S219 253 222 250L228 243V271H227C208 267 192 253 184 235S179 195 191 178C192 177 192 175 190 174C181 162 175 149 175 134C175 123 179 112 185 102C186 101 186 99 185 97S181 96 180 97C157 109 138 128 127 152L150 175C153 178 153 183 150 186S142 189 138 186L121 169C118 179 116 190 116 200C116 201 116 201 116 202L149 230Z"]
  };
  var faBookMedical = {
    prefix: 'far',
    iconName: 'book-medical',
    icon: [448, 512, [], "f7e6", "M160 224H208V272C208 281 215 288 224 288H256C265 288 272 281 272 272V224H320C329 224 336 217 336 208V176C336 167 329 160 320 160H272V112C272 103 265 96 256 96H224C215 96 208 103 208 112V160H160C151 160 144 167 144 176V208C144 217 151 224 160 224ZM424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352Z"]
  };
  var faBookOpen = {
    prefix: 'far',
    iconName: 'book-open',
    icon: [576, 512, [], "f518", "M541 57C494 40 449 32 411 32C352 33 308 50 288 60C268 50 224 33 165 32C126 31 82 40 35 57C14 64 0 85 0 107V399C0 416 8 431 21 441C35 452 52 455 69 451C187 419 271 474 274 476C279 479 283 480 288 480S297 479 301 476C305 474 389 419 507 451C524 455 541 452 555 441C568 431 576 416 576 399V107C576 85 562 64 541 57ZM264 417C236 405 194 393 143 393C116 393 87 396 57 404C53 405 51 404 50 403C48 402 48 400 48 399V107C48 105 50 103 52 102C93 87 131 80 164 80C211 81 247 94 264 102V417ZM528 399C528 400 528 402 526 403C525 404 523 405 519 404C429 380 354 399 312 417V102C329 94 365 81 412 80C444 80 483 87 524 102C526 103 528 105 528 107V399Z"]
  };
  var faBookOpenCover = {
    prefix: 'far',
    iconName: 'book-open-cover',
    icon: [640, 512, [], "e0a6", "M600 33L592 35V403L320 464L48 403V35L40 33C20 28 0 43 0 64V416C0 431 10 444 25 447L313 511C318 512 322 512 327 511L615 447C630 444 640 431 640 416V64C640 43 620 28 600 33ZM98 375L314 431C316 432 318 432 320 432S324 432 326 431L542 375C553 373 560 363 560 352V24C560 17 557 10 551 6C546 1 539 -1 532 0L320 40L108 0C101 -1 94 1 89 6C83 10 80 17 80 24V352C80 363 87 373 98 375ZM344 84L512 53V333L344 377V84ZM128 53L296 84V377L128 333V53Z"]
  };
  var faBookOpenReader = {
    prefix: 'far',
    iconName: 'book-open-reader',
    icon: [512, 512, [], "f5da", "M460 192C459 192 458 192 458 192C408 195 317 205 256 240C195 205 104 195 54 192C54 192 53 192 52 192C32 192 0 206 0 242V420C0 447 21 469 48 470C83 472 169 479 225 508C231 511 237 512 242 512H270C275 512 281 511 287 508C343 479 429 472 464 470C491 469 512 447 512 420V242C512 206 480 192 460 192ZM232 458C171 433 94 425 51 422C49 422 48 421 48 420L47 242C48 241 51 240 51 240C87 242 176 250 232 281V458ZM464 420C464 421 463 422 461 422C418 425 341 433 280 458V281C335 250 424 242 460 240C461 240 464 241 464 242V420ZM256 192C309 192 352 149 352 96S309 0 256 0S160 43 160 96S203 192 256 192ZM256 48C282 48 304 70 304 96S282 144 256 144S208 122 208 96S230 48 256 48Z"]
  };
  var faBookQuran = {
    prefix: 'far',
    iconName: 'book-quran',
    icon: [448, 512, [], "f687", "M248 271L245 271C206 271 174 239 174 200S206 129 245 129L248 129C255 129 260 124 262 118C263 112 260 105 253 103C241 98 229 96 217 96C159 96 113 143 113 200S159 304 217 304C229 304 241 302 253 298C258 296 262 290 262 285C262 277 256 271 248 271ZM304 172L291 146C290 143 286 143 285 146L272 172L243 176C240 177 239 180 241 183L262 203L257 231C257 234 260 237 262 235L288 222L314 235C316 237 320 234 319 231L314 203L335 183C337 180 336 177 333 176L304 172ZM368 0H24C11 0 0 11 0 24V376C0 389 11 400 24 400H32V464H24C11 464 0 475 0 488S11 512 24 512H368C412 512 448 476 448 432V80C448 36 412 0 368 0ZM368 464H80V400H368C386 400 400 414 400 432S386 464 368 464ZM400 359C390 354 379 352 368 352H48V48H368C386 48 400 62 400 80V359Z"]
  };
  var faBookSkull = {
    prefix: 'far',
    iconName: 'book-skull',
    icon: [448, 512, [], "f6b7", "M192 195V208C192 217 199 224 208 224H272C281 224 288 217 288 208V195C307 183 320 165 320 144C320 109 284 80 240 80S160 109 160 144C160 165 173 183 192 195ZM272 128C281 128 288 135 288 144S281 160 272 160S256 153 256 144S263 128 272 128ZM208 128C217 128 224 135 224 144S217 160 208 160S192 153 192 144S199 128 208 128ZM424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352ZM129 309C131 316 137 320 144 320C146 320 147 320 149 319L240 289L331 319C333 320 334 320 336 320C343 320 349 316 351 309C354 301 349 292 341 289L291 272L341 255C349 252 354 243 351 235C348 227 339 222 331 225L240 255L149 225C141 222 132 227 129 235C126 243 131 252 139 255L189 272L139 289C131 292 126 301 129 309Z"]
  };
  var faBookSparkles = {
    prefix: 'far',
    iconName: 'book-sparkles',
    icon: [448, 512, [], "f6b8", "M424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352ZM160 144L172 174C173 175 175 176 176 176S179 175 180 174L192 144L222 132C223 131 224 129 224 128C224 127 223 125 222 124L192 112L180 82C179 81 177 80 176 80S173 81 172 82L160 112L130 124C129 125 128 127 128 128C128 129 129 131 130 132L160 144ZM208 240L208 240L208 240C208 242 210 245 212 246L261 267L261 267L262 267L282 316C283 318 286 320 288 320L288 320L288 320C288 320 288 320 288 320C290 320 293 318 294 316L315 267L364 246C366 245 368 242 368 240C368 238 366 235 364 234L315 213L294 164C293 162 290 160 288 160C288 160 288 160 288 160L288 160L288 160C286 160 283 162 282 164L262 213L261 213L261 213L212 234C210 235 208 238 208 240Z"]
  };
  var faBookTanakh = {
    prefix: 'far',
    iconName: 'book-tanakh',
    icon: [448, 512, [], "f827", "M307 200L334 154C338 148 338 140 334 134C331 127 324 123 317 123H261L233 77C230 71 223 67 216 67S202 71 199 77L171 123H115C108 123 101 127 97 134C94 140 94 147 98 154L125 200L98 246C94 253 94 260 98 266C101 273 108 277 115 277H171L199 323C202 329 209 332 216 332C223 332 230 329 233 323L261 276H317C324 277 331 273 335 266C338 260 338 252 334 246L307 200ZM310 147L293 177L275 148L310 147ZM216 95L233 123H199L216 95ZM122 147H157L139 177L122 147ZM122 253L139 223L157 253H122ZM216 305L199 277H233L216 305ZM247 253H185L153 200L185 147H247L279 200L247 253ZM275 253L293 223L310 253H275ZM368 0H24C11 0 0 11 0 24V376C0 389 11 400 24 400H32V464H24C11 464 0 475 0 488S11 512 24 512H368C412 512 448 476 448 432V80C448 36 412 0 368 0ZM368 464H80V400H368C386 400 400 414 400 432S386 464 368 464ZM400 359C390 354 379 352 368 352H48V48H368C386 48 400 62 400 80V359Z"]
  };
  var faBookUser = {
    prefix: 'far',
    iconName: 'book-user',
    icon: [448, 512, [], "f7e7", "M424 400C437 400 448 389 448 376V24C448 11 437 0 424 0H80C36 0 0 36 0 80V432C0 476 36 512 80 512H424C437 512 448 501 448 488S437 464 424 464H416V400H424ZM368 464H80C62 464 48 450 48 432S62 400 80 400H368V464ZM400 352H352V336C352 292 316 256 272 256H208C164 256 128 292 128 336V352H80C69 352 58 354 48 359V80C48 62 62 48 80 48H400V352ZM240 224C275 224 304 195 304 160S275 96 240 96S176 125 176 160S205 224 240 224Z"]
  };
  var faBookmark = {
    prefix: 'far',
    iconName: 'bookmark',
    icon: [384, 512, [], "f02e", "M336 0H48C22 0 0 22 0 48V480C0 505 27 520 48 508L192 424L336 508C357 520 384 505 384 480V48C384 22 362 0 336 0ZM336 452L192 368L48 452V54C48 51 51 48 54 48H330C333 48 336 51 336 54V452Z"]
  };
  var faBookmarkSlash = {
    prefix: 'far',
    iconName: 'bookmark-slash',
    icon: [640, 512, [], "e0a7", "M631 469L512 376V48C512 22 491 0 464 0H176C150 0 128 22 128 48V75L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM464 338L176 113V54C176 51 179 48 182 48H458C461 48 464 51 464 54V338ZM320 368L176 452V234L128 197V480C128 505 155 520 176 508L320 424L464 508C480 517 500 510 508 495L425 429L320 368Z"]
  };
  var faBooks = {
    prefix: 'far',
    iconName: 'books',
    icon: [512, 512, [], "f5db", "M510 435L403 35C397 14 378 0 356 0C352 0 348 1 344 2L282 18C276 20 271 22 266 26C258 10 242 0 224 0H160C151 0 143 3 136 7C129 3 121 0 112 0H48C22 0 0 22 0 48V464C0 490 22 512 48 512H112C121 512 129 509 136 505C143 509 151 512 160 512H224C250 512 272 490 272 464V165L356 477C362 498 381 512 402 512C406 512 410 511 415 510L476 494C502 487 517 461 510 435ZM224 48V96H160V48H224ZM160 144H224V368H160V144ZM112 368H48V144H112V368ZM112 48V96H48V48H112ZM48 464V416H112V464H48ZM160 464V416H224V464H160ZM294 65L356 48L356 48L369 94L307 110L294 65ZM319 157L381 140L439 355L377 372L319 157ZM402 464L390 418L452 402L464 447L402 464Z"]
  };
  var faBooksMedical = {
    prefix: 'far',
    iconName: 'books-medical',
    icon: [576, 512, [], "f7e8", "M80 352H112C121 352 128 345 128 336V288H176C185 288 192 281 192 272V240C192 231 185 224 176 224H128V176C128 167 121 160 112 160H80C71 160 64 167 64 176V224H16C7 224 0 231 0 240V272C0 281 7 288 16 288H64V336C64 345 71 352 80 352ZM574 435L467 35C461 14 442 0 420 0C416 0 412 1 408 2L346 18C340 20 335 22 330 26C322 10 306 0 288 0H224C215 0 207 3 200 7C193 3 185 0 176 0H112C86 0 64 22 64 48V104C64 117 75 128 88 128S112 117 112 104V48H176V168C176 181 187 192 200 192S224 181 224 168V144H288V368H224V344C224 331 213 320 200 320S176 331 176 344V464H112V408C112 395 101 384 88 384S64 395 64 408V464C64 490 86 512 112 512H176C185 512 193 509 200 505C207 509 215 512 224 512H288C314 512 336 490 336 464V165L420 477C426 498 445 512 466 512C470 512 474 511 479 510L541 494C566 487 581 461 574 435ZM288 464H224V416H288V464ZM288 96H224V48H288V96ZM358 65L420 48L420 48L433 94L371 110L358 65ZM383 157L445 140L503 355L441 372L383 157ZM466 464L454 418L516 402L528 447L466 464Z"]
  };
  var faBoombox = {
    prefix: 'far',
    iconName: 'boombox',
    icon: [640, 512, [], "f8a5", "M592 162V88C592 39 553 0 504 0H136C87 0 48 39 48 88V162C20 169 0 194 0 224V448C0 483 29 512 64 512H576C611 512 640 483 640 448V224C640 194 620 169 592 162ZM96 88C96 66 114 48 136 48H504C526 48 544 66 544 88V160H448V144C448 135 441 128 432 128H400C391 128 384 135 384 144V160H352V144C352 135 345 128 336 128H304C295 128 288 135 288 144V160H256V144C256 135 249 128 240 128H208C199 128 192 135 192 144V160H96V88ZM592 448C592 457 585 464 576 464H64C55 464 48 457 48 448V224C48 215 55 208 64 208H576C585 208 592 215 592 224V448ZM176 240C123 240 80 283 80 336S123 432 176 432S272 389 272 336S229 240 176 240ZM176 384C150 384 128 362 128 336S150 288 176 288S224 310 224 336S202 384 176 384ZM464 240C411 240 368 283 368 336S411 432 464 432S560 389 560 336S517 240 464 240ZM464 384C438 384 416 362 416 336S438 288 464 288S512 310 512 336S490 384 464 384Z"]
  };
  var faBoot = {
    prefix: 'far',
    iconName: 'boot',
    icon: [512, 512, [], "f782", "M415 264L352 248V144C370 144 384 130 384 112V48C384 22 362 0 336 0H48C22 0 0 22 0 48V467C0 475 3 483 9 489L32 512H96L128 480L160 512H224L256 480L288 512H352L384 480L416 512H480L503 489C509 483 512 475 512 467V388C512 329 472 278 415 264ZM48 48H336V96H48V48ZM464 416H48V144H304V192H240C231 192 224 199 224 208V208C224 217 231 224 240 224H304V256H240C231 256 224 263 224 272V272C224 281 231 288 240 288H314L403 310C439 319 464 351 464 388V416Z"]
  };
  var faBoothCurtain = {
    prefix: 'far',
    iconName: 'booth-curtain',
    icon: [512, 512, [], "f734", "M0 56V488C0 501 11 512 24 512S48 501 48 488V56C48 52 52 48 56 48H112V0H56C25 0 0 25 0 56ZM456 0H144V400C144 435 173 464 208 464C223 464 237 458 248 450C259 458 273 464 288 464S317 458 328 450C339 458 353 464 368 464S397 458 408 450C419 458 433 464 448 464C454 464 459 463 464 462V488C464 501 475 512 488 512S512 501 512 488V56C512 25 487 0 456 0ZM224 400C224 409 217 416 208 416S192 409 192 400V48H224V400ZM304 400C304 409 297 416 288 416S272 409 272 400V48H304V400ZM384 400C384 409 377 416 368 416S352 409 352 400V48H384V400ZM464 400C464 409 457 416 448 416S432 409 432 400V48H456C460 48 464 52 464 56V400Z"]
  };
  var faBorderAll = {
    prefix: 'far',
    iconName: 'border-all',
    icon: [448, 512, [], "f84c", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM200 432H64C55 432 48 425 48 416V280H200V432ZM200 232H48V96C48 87 55 80 64 80H200V232ZM400 416C400 425 393 432 384 432H248V280H400V416ZM400 232H248V80H384C393 80 400 87 400 96V232Z"]
  };
  var faBorderBottom = {
    prefix: 'far',
    iconName: 'border-bottom',
    icon: [448, 512, [], "f84d", "M312 280H328C337 280 344 273 344 264V248C344 239 337 232 328 232H312C303 232 296 239 296 248V264C296 273 303 280 312 280ZM312 88H328C337 88 344 81 344 72V56C344 47 337 40 328 40H312C303 40 296 47 296 56V72C296 81 303 88 312 88ZM216 184H232C241 184 248 177 248 168V152C248 143 241 136 232 136H216C207 136 200 143 200 152V168C200 177 207 184 216 184ZM216 88H232C241 88 248 81 248 72V56C248 47 241 40 232 40H216C207 40 200 47 200 56V72C200 81 207 88 216 88ZM408 184H424C433 184 440 177 440 168V152C440 143 433 136 424 136H408C399 136 392 143 392 152V168C392 177 399 184 408 184ZM408 88H424C433 88 440 81 440 72V56C440 47 433 40 424 40H408C399 40 392 47 392 56V72C392 81 399 88 408 88ZM408 280H424C433 280 440 273 440 264V248C440 239 433 232 424 232H408C399 232 392 239 392 248V264C392 273 399 280 408 280ZM408 376H424C433 376 440 369 440 360V344C440 335 433 328 424 328H408C399 328 392 335 392 344V360C392 369 399 376 408 376ZM120 88H136C145 88 152 81 152 72V56C152 47 145 40 136 40H120C111 40 104 47 104 56V72C104 81 111 88 120 88ZM24 280H40C49 280 56 273 56 264V248C56 239 49 232 40 232H24C15 232 8 239 8 248V264C8 273 15 280 24 280ZM24 376H40C49 376 56 369 56 360V344C56 335 49 328 40 328H24C15 328 8 335 8 344V360C8 369 15 376 24 376ZM24 184H40C49 184 56 177 56 168V152C56 143 49 136 40 136H24C15 136 8 143 8 152V168C8 177 15 184 24 184ZM432 432H16C7 432 0 439 0 448V464C0 473 7 480 16 480H432C441 480 448 473 448 464V448C448 439 441 432 432 432ZM216 376H232C241 376 248 369 248 360V344C248 335 241 328 232 328H216C207 328 200 335 200 344V360C200 369 207 376 216 376ZM216 280H232C241 280 248 273 248 264V248C248 239 241 232 232 232H216C207 232 200 239 200 248V264C200 273 207 280 216 280ZM120 280H136C145 280 152 273 152 264V248C152 239 145 232 136 232H120C111 232 104 239 104 248V264C104 273 111 280 120 280ZM24 88H40C49 88 56 81 56 72V56C56 47 49 40 40 40H24C15 40 8 47 8 56V72C8 81 15 88 24 88Z"]
  };
  var faBorderBottomRight = {
    prefix: 'far',
    iconName: 'border-bottom-right',
    icon: [448, 512, [], "f854", "M216 184H232C241 184 248 177 248 168V152C248 143 241 136 232 136H216C207 136 200 143 200 152V168C200 177 207 184 216 184ZM216 280H232C241 280 248 273 248 264V248C248 239 241 232 232 232H216C207 232 200 239 200 248V264C200 273 207 280 216 280ZM216 376H232C241 376 248 369 248 360V344C248 335 241 328 232 328H216C207 328 200 335 200 344V360C200 369 207 376 216 376ZM312 88H328C337 88 344 81 344 72V56C344 47 337 40 328 40H312C303 40 296 47 296 56V72C296 81 303 88 312 88ZM216 88H232C241 88 248 81 248 72V56C248 47 241 40 232 40H216C207 40 200 47 200 56V72C200 81 207 88 216 88ZM312 280H328C337 280 344 273 344 264V248C344 239 337 232 328 232H312C303 232 296 239 296 248V264C296 273 303 280 312 280ZM24 184H40C49 184 56 177 56 168V152C56 143 49 136 40 136H24C15 136 8 143 8 152V168C8 177 15 184 24 184ZM24 280H40C49 280 56 273 56 264V248C56 239 49 232 40 232H24C15 232 8 239 8 248V264C8 273 15 280 24 280ZM120 88H136C145 88 152 81 152 72V56C152 47 145 40 136 40H120C111 40 104 47 104 56V72C104 81 111 88 120 88ZM24 376H40C49 376 56 369 56 360V344C56 335 49 328 40 328H24C15 328 8 335 8 344V360C8 369 15 376 24 376ZM24 88H40C49 88 56 81 56 72V56C56 47 49 40 40 40H24C15 40 8 47 8 56V72C8 81 15 88 24 88ZM120 280H136C145 280 152 273 152 264V248C152 239 145 232 136 232H120C111 232 104 239 104 248V264C104 273 111 280 120 280ZM432 32H416C407 32 400 39 400 48V416C400 425 393 432 384 432H16C7 432 0 439 0 448V464C0 473 7 480 16 480H384C419 480 448 451 448 416V48C448 39 441 32 432 32Z"]
  };
  var faBorderCenterH = {
    prefix: 'far',
    iconName: 'border-center-h',
    icon: [448, 512, [], "f89c", "M24 88H40C49 88 56 81 56 72V56C56 47 49 40 40 40H24C15 40 8 47 8 56V72C8 81 15 88 24 88ZM40 424H24C15 424 8 431 8 440V456C8 465 15 472 24 472H40C49 472 56 465 56 456V440C56 431 49 424 40 424ZM24 184H40C49 184 56 177 56 168V152C56 143 49 136 40 136H24C15 136 8 143 8 152V168C8 177 15 184 24 184ZM120 88H136C145 88 152 81 152 72V56C152 47 145 40 136 40H120C111 40 104 47 104 56V72C104 81 111 88 120 88ZM216 88H232C241 88 248 81 248 72V56C248 47 241 40 232 40H216C207 40 200 47 200 56V72C200 81 207 88 216 88ZM408 88H424C433 88 440 81 440 72V56C440 47 433 40 424 40H408C399 40 392 47 392 56V72C392 81 399 88 408 88ZM408 184H424C433 184 440 177 440 168V152C440 143 433 136 424 136H408C399 136 392 143 392 152V168C392 177 399 184 408 184ZM312 88H328C337 88 344 81 344 72V56C344 47 337 40 328 40H312C303 40 296 47 296 56V72C296 81 303 88 312 88ZM216 184H232C241 184 248 177 248 168V152C248 143 241 136 232 136H216C207 136 200 143 200 152V168C200 177 207 184 216 184ZM424 424H408C399 424 392 431 392 440V456C392 465 399 472 408 472H424C433 472 440 465 440 456V440C440 431 433 424 424 424ZM424 328H408C399 328 392 335 392 344V360C392 369 399 376 408 376H424C433 376 440 369 440 360V344C440 335 433 328 424 328ZM328 424H312C303 424 296 431 296 440V456C296 465 303 472 312 472H328C337 472 344 465 344 456V440C344 431 337 424 328 424ZM136 424H120C111 424 104 431 104 440V456C104 465 111 472 120 472H136C145 472 152 465 152 456V440C152 431 145 424 136 424ZM232 328H216C207 328 200 335 200 344V360C200 369 207 376 216 376H232C241 376 248 369 248 360V344C248 335 241 328 232 328ZM40 328H24C15 328 8 335 8 344V360C8 369 15 376 24 376H40C49 376 56 369 56 360V344C56 335 49 328 40 328ZM232 424H216C207 424 200 431 200 440V456C200 465 207 472 216 472H232C241 472 248 465 248 456V440C248 431 241 424 232 424ZM432 232H16C7 232 0 239 0 248V264C0 273 7 280 16 280H432C441 280 448 273 448 264V248C448 239 441 232 432 232Z"]
  };
  var faBorderCenterV = {
    prefix: 'far',
    iconName: 'border-center-v',
    icon: [448, 512, [], "f89d", "M136 424H120C111 424 104 431 104 440V456C104 465 111 472 120 472H136C145 472 152 465 152 456V440C152 431 145 424 136 424ZM136 232H120C111 232 104 239 104 248V264C104 273 111 280 120 280H136C145 280 152 273 152 264V248C152 239 145 232 136 232ZM40 40H24C15 40 8 47 8 56V72C8 81 15 88 24 88H40C49 88 56 81 56 72V56C56 47 49 40 40 40ZM136 40H120C111 40 104 47 104 56V72C104 81 111 88 120 88H136C145 88 152 81 152 72V56C152 47 145 40 136 40ZM40 328H24C15 328 8 335 8 344V360C8 369 15 376 24 376H40C49 376 56 369 56 360V344C56 335 49 328 40 328ZM40 136H24C15 136 8 143 8 152V168C8 177 15 184 24 184H40C49 184 56 177 56 168V152C56 143 49 136 40 136ZM40 232H24C15 232 8 239 8 248V264C8 273 15 280 24 280H40C49 280 56 273 56 264V248C56 239 49 232 40 232ZM40 424H24C15 424 8 431 8 440V456C8 465 15 472 24 472H40C49 472 56 465 56 456V440C56 431 49 424 40 424ZM424 424H408C399 424 392 431 392 440V456C392 465 399 472 408 472H424C433 472 440 465 440 456V440C440 431 433 424 424 424ZM424 328H408C399 328 392 335 392 344V360C392 369 399 376 408 376H424C433 376 440 369 440 360V344C440 335 433 328 424 328ZM424 232H408C399 232 392 239 392 248V264C392 273 399 280 408 280H424C433 280 440 273 440 264V248C440 239 433 232 424 232ZM424 136H408C399 136 392 143 392 152V168C392 177 399 184 408 184H424C433 184 440 177 440 168V152C440 143 433 136 424 136ZM424 40H408C399 40 392 47 392 56V72C392 81 399 88 408 88H424C433 88 440 81 440 72V56C440 47 433 40 424 40ZM328 40H312C303 40 296 47 296 56V72C296 81 303 88 312 88H328C337 88 344 81 344 72V56C344 47 337 40 328 40ZM328 424H312C303 424 296 431 296 440V456C296 465 303 472 312 472H328C337 472 344 465 344 456V440C344 431 337 424 328 424ZM328 232H312C303 232 296 239 296 248V264C296 273 303 280 312 280H328C337 280 344 273 344 264V248C344 239 337 232 328 232ZM232 32H216C207 32 200 39 200 48V464C200 473 207 480 216 480H232C241 480 248 473 248 464V48C248 39 241 32 232 32Z"]
  };
  var faBorderInner = {
    prefix: 'far',
    iconName: 'border-inner',
    icon: [448, 512, [], "f84e", "M24 88H40C49 88 56 81 56 72V56C56 47 49 40 40 40H24C15 40 8 47 8 56V72C8 81 15 88 24 88ZM40 424H24C15 424 8 431 8 440V456C8 465 15 472 24 472H40C49 472 56 465 56 456V440C56 431 49 424 40 424ZM24 184H40C49 184 56 177 56 168V152C56 143 49 136 40 136H24C15 136 8 143 8 152V168C8 177 15 184 24 184ZM408 88H424C433 88 440 81 440 72V56C440 47 433 40 424 40H408C399 40 392 47 392 56V72C392 81 399 88 408 88ZM408 184H424C433 184 440 177 440 168V152C440 143 433 136 424 136H408C399 136 392 143 392 152V168C392 177 399 184 408 184ZM312 88H328C337 88 344 81 344 72V56C344 47 337 40 328 40H312C303 40 296 47 296 56V72C296 81 303 88 312 88ZM120 88H136C145 88 152 81 152 72V56C152 47 145 40 136 40H120C111 40 104 47 104 56V72C104 81 111 88 120 88ZM424 424H408C399 424 392 431 392 440V456C392 465 399 472 408 472H424C433 472 440 465 440 456V440C440 431 433 424 424 424ZM424 328H408C399 328 392 335 392 344V360C392 369 399 376 408 376H424C433 376 440 369 440 360V344C440 335 433 328 424 328ZM328 424H312C303 424 296 431 296 440V456C296 465 303 472 312 472H328C337 472 344 465 344 456V440C344 431 337 424 328 424ZM40 328H24C15 328 8 335 8 344V360C8 369 15 376 24 376H40C49 376 56 369 56 360V344C56 335 49 328 40 328ZM136 424H120C111 424 104 431 104 440V456C104 465 111 472 120 472H136C145 472 152 465 152 456V440C152 431 145 424 136 424ZM432 232H248V48C248 39 241 32 232 32H216C207 32 200 39 200 48V232H16C7 232 0 239 0 248V264C0 273 7 280 16 280H200V464C200 473 207 480 216 480H232C241 480 248 473 248 464V280H432C441 280 448 273 448 264V248C448 239 441 232 432 232Z"]
  };
  var faBorderLeft = {
    prefix: 'far',
    iconName: 'border-left',
    icon: [448, 512, [], "f84f", "M232 424H216C207 424 200 431 200 440V456C200 465 207 472 216 472H232C241 472 248 465 248 456V440C248 431 241 424 232 424ZM232 328H216C207 328 200 335 200 344V360C200 369 207 376 216 376H232C241 376 248 369 248 360V344C248 335 241 328 232 328ZM232 136H216C207 136 200 143 200 152V168C200 177 207 184 216 184H232C241 184 248 177 248 168V152C248 143 241 136 232 136ZM136 40H120C111 40 104 47 104 56V72C104 81 111 88 120 88H136C145 88 152 81 152 72V56C152 47 145 40 136 40ZM136 424H120C111 424 104 431 104 440V456C104 465 111 472 120 472H136C145 472 152 465 152 456V440C152 431 145 424 136 424ZM232 40H216C207 40 200 47 200 56V72C200 81 207 88 216 88H232C241 88 248 81 248 72V56C248 47 241 40 232 40ZM136 232H120C111 232 104 239 104 248V264C104 273 111 280 120 280H136C145 280 152 273 152 264V248C152 239 145 232 136 232ZM232 232H216C207 232 200 239 200 248V264C200 273 207 280 216 280H232C241 280 248 273 248 264V248C248 239 241 232 232 232ZM424 136H408C399 136 392 143 392 152V168C392 177 399 184 408 184H424C433 184 440 177 440 168V152C440 143 433 136 424 136ZM424 328H408C399 328 392 335 392 344V360C392 369 399 376 408 376H424C433 376 440 369 440 360V344C440 335 433 328 424 328ZM424 232H408C399 232 392 239 392 248V264C392 273 399 280 408 280H424C433 280 440 273 440 264V248C440 239 433 232 424 232ZM424 40H408C399 40 392 47 392 56V72C392 81 399 88 408 88H424C433 88 440 81 440 72V56C440 47 433 40 424 40ZM424 424H408C399 424 392 431 392 440V456C392 465 399 472 408 472H424C433 472 440 465 440 456V440C440 431 433 424 424 424ZM328 232H312C303 232 296 239 296 248V264C296 273 303 280 312 280H328C337 280 344 273 344 264V248C344 239 337 232 328 232ZM328 40H312C303 40 296 47 296 56V72C296 81 303 88 312 88H328C337 88 344 81 344 72V56C344 47 337 40 328 40ZM328 424H312C303 424 296 431 296 440V456C296 465 303 472 312 472H328C337 472 344 465 344 456V440C344 431 337 424 328 424ZM32 32H16C7 32 0 39 0 48V464C0 473 7 480 16 480H32C41 480 48 473 48 464V48C48 39 41 32 32 32Z"]
  };
  var faBorderNone = {
    prefix: 'far',
    iconName: 'border-none',
    icon: [448, 512, [], "f850", "M136 232H120C111 232 104 239 104 248V264C104 273 111 280 120 280H136C145 280 152 273 152 264V248C152 239 145 232 136 232ZM232 328H216C207 328 200 335 200 344V360C200 369 207 376 216 376H232C241 376 248 369 248 360V344C248 335 241 328 232 328ZM136 40H120C111 40 104 47 104 56V72C104 81 111 88 120 88H136C145 88 152 81 152 72V56C152 47 145 40 136 40ZM40 40H24C15 40 8 47 8 56V72C8 81 15 88 24 88H40C49 88 56 81 56 72V56C56 47 49 40 40 40ZM232 424H216C207 424 200 431 200 440V456C200 465 207 472 216 472H232C241 472 248 465 248 456V440C248 431 241 424 232 424ZM136 424H120C111 424 104 431 104 440V456C104 465 111 472 120 472H136C145 472 152 465 152 456V440C152 431 145 424 136 424ZM40 136H24C15 136 8 143 8 152V168C8 177 15 184 24 184H40C49 184 56 177 56 168V152C56 143 49 136 40 136ZM40 328H24C15 328 8 335 8 344V360C8 369 15 376 24 376H40C49 376 56 369 56 360V344C56 335 49 328 40 328ZM40 424H24C15 424 8 431 8 440V456C8 465 15 472 24 472H40C49 472 56 465 56 456V440C56 431 49 424 40 424ZM40 232H24C15 232 8 239 8 248V264C8 273 15 280 24 280H40C49 280 56 273 56 264V248C56 239 49 232 40 232ZM424 136H408C399 136 392 143 392 152V168C392 177 399 184 408 184H424C433 184 440 177 440 168V152C440 143 433 136 424 136ZM424 424H408C399 424 392 431 392 440V456C392 465 399 472 408 472H424C433 472 440 465 440 456V440C440 431 433 424 424 424ZM232 232H216C207 232 200 239 200 248V264C200 273 207 280 216 280H232C241 280 248 273 248 264V248C248 239 241 232 232 232ZM424 232H408C399 232 392 239 392 248V264C392 273 399 280 408 280H424C433 280 440 273 440 264V248C440 239 433 232 424 232ZM328 40H312C303 40 296 47 296 56V72C296 81 303 88 312 88H328C337 88 344 81 344 72V56C344 47 337 40 328 40ZM424 40H408C399 40 392 47 392 56V72C392 81 399 88 408 88H424C433 88 440 81 440 72V56C440 47 433 40 424 40ZM424 328H408C399 328 392 335 392 344V360C392 369 399 376 408 376H424C433 376 440 369 440 360V344C440 335 433 328 424 328ZM232 40H216C207 40 200 47 200 56V72C200 81 207 88 216 88H232C241 88 248 81 248 72V56C248 47 241 40 232 40ZM328 232H312C303 232 296 239 296 248V264C296 273 303 280 312 280H328C337 280 344 273 344 264V248C344 239 337 232 328 232ZM232 136H216C207 136 200 143 200 152V168C200 177 207 184 216 184H232C241 184 248 177 248 168V152C248 143 241 136 232 136ZM328 424H312C303 424 296 431 296 440V456C296 465 303 472 312 472H328C337 472 344 465 344 456V440C344 431 337 424 328 424Z"]
  };
  var faBorderOuter = {
    prefix: 'far',
    iconName: 'border-outer',
    icon: [448, 512, [], "f851", "M136 232H120C111 232 104 239 104 248V264C104 273 111 280 120 280H136C145 280 152 273 152 264V248C152 239 145 232 136 232ZM232 328H216C207 328 200 335 200 344V360C200 369 207 376 216 376H232C241 376 248 369 248 360V344C248 335 241 328 232 328ZM232 232H216C207 232 200 239 200 248V264C200 273 207 280 216 280H232C241 280 248 273 248 264V248C248 239 241 232 232 232ZM328 232H312C303 232 296 239 296 248V264C296 273 303 280 312 280H328C337 280 344 273 344 264V248C344 239 337 232 328 232ZM232 136H216C207 136 200 143 200 152V168C200 177 207 184 216 184H232C241 184 248 177 248 168V152C248 143 241 136 232 136ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416Z"]
  };
  var faBorderRight = {
    prefix: 'far',
    iconName: 'border-right',
    icon: [448, 512, [], "f852", "M128 232H112C103 232 96 239 96 248V264C96 273 103 280 112 280H128C137 280 144 273 144 264V248C144 239 137 232 128 232ZM32 40H16C7 40 0 47 0 56V72C0 81 7 88 16 88H32C41 88 48 81 48 72V56C48 47 41 40 32 40ZM128 424H112C103 424 96 431 96 440V456C96 465 103 472 112 472H128C137 472 144 465 144 456V440C144 431 137 424 128 424ZM128 40H112C103 40 96 47 96 56V72C96 81 103 88 112 88H128C137 88 144 81 144 72V56C144 47 137 40 128 40ZM32 424H16C7 424 0 431 0 440V456C0 465 7 472 16 472H32C41 472 48 465 48 456V440C48 431 41 424 32 424ZM32 328H16C7 328 0 335 0 344V360C0 369 7 376 16 376H32C41 376 48 369 48 360V344C48 335 41 328 32 328ZM32 136H16C7 136 0 143 0 152V168C0 177 7 184 16 184H32C41 184 48 177 48 168V152C48 143 41 136 32 136ZM32 232H16C7 232 0 239 0 248V264C0 273 7 280 16 280H32C41 280 48 273 48 264V248C48 239 41 232 32 232ZM224 424H208C199 424 192 431 192 440V456C192 465 199 472 208 472H224C233 472 240 465 240 456V440C240 431 233 424 224 424ZM320 232H304C295 232 288 239 288 248V264C288 273 295 280 304 280H320C329 280 336 273 336 264V248C336 239 329 232 320 232ZM320 424H304C295 424 288 431 288 440V456C288 465 295 472 304 472H320C329 472 336 465 336 456V440C336 431 329 424 320 424ZM320 40H304C295 40 288 47 288 56V72C288 81 295 88 304 88H320C329 88 336 81 336 72V56C336 47 329 40 320 40ZM224 328H208C199 328 192 335 192 344V360C192 369 199 376 208 376H224C233 376 240 369 240 360V344C240 335 233 328 224 328ZM224 40H208C199 40 192 47 192 56V72C192 81 199 88 208 88H224C233 88 240 81 240 72V56C240 47 233 40 224 40ZM224 232H208C199 232 192 239 192 248V264C192 273 199 280 208 280H224C233 280 240 273 240 264V248C240 239 233 232 224 232ZM224 136H208C199 136 192 143 192 152V168C192 177 199 184 208 184H224C233 184 240 177 240 168V152C240 143 233 136 224 136ZM424 32H408C399 32 392 39 392 48V464C392 473 399 480 408 480H424C433 480 440 473 440 464V48C440 39 433 32 424 32Z"]
  };
  var faBorderTop = {
    prefix: 'far',
    iconName: 'border-top',
    icon: [448, 512, [], "f855", "M136 424H120C111 424 104 431 104 440V456C104 465 111 472 120 472H136C145 472 152 465 152 456V440C152 431 145 424 136 424ZM232 328H216C207 328 200 335 200 344V360C200 369 207 376 216 376H232C241 376 248 369 248 360V344C248 335 241 328 232 328ZM136 232H120C111 232 104 239 104 248V264C104 273 111 280 120 280H136C145 280 152 273 152 264V248C152 239 145 232 136 232ZM232 424H216C207 424 200 431 200 440V456C200 465 207 472 216 472H232C241 472 248 465 248 456V440C248 431 241 424 232 424ZM40 136H24C15 136 8 143 8 152V168C8 177 15 184 24 184H40C49 184 56 177 56 168V152C56 143 49 136 40 136ZM40 424H24C15 424 8 431 8 440V456C8 465 15 472 24 472H40C49 472 56 465 56 456V440C56 431 49 424 40 424ZM40 232H24C15 232 8 239 8 248V264C8 273 15 280 24 280H40C49 280 56 273 56 264V248C56 239 49 232 40 232ZM40 328H24C15 328 8 335 8 344V360C8 369 15 376 24 376H40C49 376 56 369 56 360V344C56 335 49 328 40 328ZM424 232H408C399 232 392 239 392 248V264C392 273 399 280 408 280H424C433 280 440 273 440 264V248C440 239 433 232 424 232ZM424 424H408C399 424 392 431 392 440V456C392 465 399 472 408 472H424C433 472 440 465 440 456V440C440 431 433 424 424 424ZM424 328H408C399 328 392 335 392 344V360C392 369 399 376 408 376H424C433 376 440 369 440 360V344C440 335 433 328 424 328ZM424 136H408C399 136 392 143 392 152V168C392 177 399 184 408 184H424C433 184 440 177 440 168V152C440 143 433 136 424 136ZM232 232H216C207 232 200 239 200 248V264C200 273 207 280 216 280H232C241 280 248 273 248 264V248C248 239 241 232 232 232ZM328 232H312C303 232 296 239 296 248V264C296 273 303 280 312 280H328C337 280 344 273 344 264V248C344 239 337 232 328 232ZM232 136H216C207 136 200 143 200 152V168C200 177 207 184 216 184H232C241 184 248 177 248 168V152C248 143 241 136 232 136ZM328 424H312C303 424 296 431 296 440V456C296 465 303 472 312 472H328C337 472 344 465 344 456V440C344 431 337 424 328 424ZM432 32H16C7 32 0 39 0 48V64C0 73 7 80 16 80H432C441 80 448 73 448 64V48C448 39 441 32 432 32Z"]
  };
  var faBorderTopLeft = {
    prefix: 'far',
    iconName: 'border-top-left',
    icon: [448, 512, [], "f853", "M232 232H216C207 232 200 239 200 248V264C200 273 207 280 216 280H232C241 280 248 273 248 264V248C248 239 241 232 232 232ZM328 424H312C303 424 296 431 296 440V456C296 465 303 472 312 472H328C337 472 344 465 344 456V440C344 431 337 424 328 424ZM232 136H216C207 136 200 143 200 152V168C200 177 207 184 216 184H232C241 184 248 177 248 168V152C248 143 241 136 232 136ZM136 424H120C111 424 104 431 104 440V456C104 465 111 472 120 472H136C145 472 152 465 152 456V440C152 431 145 424 136 424ZM232 424H216C207 424 200 431 200 440V456C200 465 207 472 216 472H232C241 472 248 465 248 456V440C248 431 241 424 232 424ZM136 232H120C111 232 104 239 104 248V264C104 273 111 280 120 280H136C145 280 152 273 152 264V248C152 239 145 232 136 232ZM232 328H216C207 328 200 335 200 344V360C200 369 207 376 216 376H232C241 376 248 369 248 360V344C248 335 241 328 232 328ZM424 136H408C399 136 392 143 392 152V168C392 177 399 184 408 184H424C433 184 440 177 440 168V152C440 143 433 136 424 136ZM328 232H312C303 232 296 239 296 248V264C296 273 303 280 312 280H328C337 280 344 273 344 264V248C344 239 337 232 328 232ZM424 232H408C399 232 392 239 392 248V264C392 273 399 280 408 280H424C433 280 440 273 440 264V248C440 239 433 232 424 232ZM424 328H408C399 328 392 335 392 344V360C392 369 399 376 408 376H424C433 376 440 369 440 360V344C440 335 433 328 424 328ZM424 424H408C399 424 392 431 392 440V456C392 465 399 472 408 472H424C433 472 440 465 440 456V440C440 431 433 424 424 424ZM432 32H64C29 32 0 61 0 96V464C0 473 7 480 16 480H32C41 480 48 473 48 464V96C48 87 55 80 64 80H432C441 80 448 73 448 64V48C448 39 441 32 432 32Z"]
  };
  var faBowArrow = {
    prefix: 'far',
    iconName: 'bow-arrow',
    icon: [512, 512, [], "f6b9", "M146 287L180 253L80 153C114 129 154 116 197 116C231 116 264 124 293 140L328 105C289 81 244 68 197 68C142 68 89 86 46 119L39 112C32 106 22 106 16 112L5 123C-2 129 -2 140 5 146L146 287ZM493 0L365 26C352 28 348 44 357 52L391 87L140 337L91 321C89 320 78 317 70 326L6 389C-5 400 0 418 14 423L70 442L88 497C91 506 99 511 108 511C113 511 118 509 122 505L186 442C191 436 193 428 191 421L174 371L425 121L459 155C468 164 483 159 486 147L512 19C514 7 504 -2 493 0ZM116 455L101 410L56 395L89 362L134 377L149 422L116 455ZM456 95L417 56L465 47L456 95ZM407 184L372 219C388 248 397 281 397 315C397 358 384 398 359 432L259 332L225 366L367 507C373 514 383 514 389 507L401 496C407 490 407 480 401 473L393 466C427 423 445 371 445 315C445 268 432 223 407 184Z"]
  };
  var faBowlHot = {
    prefix: 'far',
    iconName: 'bowl-hot',
    icon: [512, 512, [], "f823", "M191 146C193 154 199 160 207 160H224C233 160 241 151 240 142C236 114 223 87 203 67C189 53 180 34 177 14C176 6 169 0 161 0H144C140 0 135 2 132 5C129 9 128 13 128 18C132 50 146 80 169 102C181 114 188 130 191 146ZM303 146C304 154 311 160 319 160H336C345 160 353 151 352 142C348 114 335 88 315 67C301 53 292 34 289 14C288 6 281 0 273 0H256C246 0 239 9 240 18C244 50 258 80 281 102C293 114 300 130 303 146ZM480 192H32C14 192 0 206 0 224C0 319 51 401 128 446V480C128 498 142 512 160 512H352C370 512 384 498 384 480V446C461 401 512 319 512 224C512 206 498 192 480 192ZM336 418V464H176V418C109 379 56 331 49 240H463C456 329 405 378 336 418Z"]
  };
  var faBowlingBall = {
    prefix: 'far',
    iconName: 'bowling-ball',
    icon: [512, 512, [], "f436", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM272 208C272 226 258 240 240 240S208 226 208 208S222 176 240 176S272 190 272 208ZM272 112C272 130 258 144 240 144S208 130 208 112S222 80 240 80S272 94 272 112ZM176 176C176 194 162 208 144 208S112 194 112 176S126 144 144 144S176 158 176 176Z"]
  };
  var faBowlingBallPin = {
    prefix: 'far',
    iconName: 'bowling-ball-pin',
    icon: [576, 512, [], "e0a8", "M123 224C108 224 96 236 96 251C96 265 108 277 123 277C137 277 149 265 149 251C149 236 137 224 123 224ZM197 267C183 267 171 279 171 293S183 320 197 320C212 320 224 308 224 293S212 267 197 267ZM197 179C183 179 171 191 171 205S183 232 197 232C212 232 224 220 224 205S212 179 197 179ZM550 258C539 232 529 208 529 186C529 179 532 171 536 161C542 144 549 124 549 95C549 33 506 0 464 0H464C422 0 379 33 379 95C379 124 386 144 392 161C396 171 399 179 399 186C399 194 397 203 394 212C360 143 290 96 208 96C93 96 0 189 0 304S93 512 208 512C273 512 330 483 368 437C374 453 381 467 387 478C397 499 417 512 440 512H488C511 512 531 499 541 479C555 450 576 407 576 354C576 320 563 288 550 258ZM208 464C120 464 48 392 48 304S120 144 208 144S368 216 368 304S296 464 208 464ZM464 48H464C483 48 501 63 501 95C501 115 496 130 491 145C489 150 487 155 486 160H442C441 155 439 150 437 145C432 130 427 115 427 95C427 63 445 48 464 48ZM498 458C496 462 492 464 488 464H440C436 464 432 462 430 457C419 435 407 409 402 378C411 355 416 330 416 304C416 300 416 296 415 293C418 287 420 282 422 276C431 254 441 231 445 208H483C487 231 497 254 506 276C517 303 528 329 528 354C528 396 512 430 498 458Z"]
  };
  var faBowlingPins = {
    prefix: 'far',
    iconName: 'bowling-pins',
    icon: [512, 512, [], "f437", "M470 258C459 232 449 208 449 186C449 179 452 171 456 161C462 144 469 124 469 95C469 33 426 0 384 0H384C342 0 299 33 299 95C299 124 306 144 312 161C316 171 319 179 319 186C319 208 309 232 298 258C285 288 272 320 272 354C272 408 293 450 307 478C317 499 337 512 360 512H408C431 512 451 499 461 479C475 450 496 407 496 354C496 320 483 288 470 258ZM384 48H384C403 48 421 63 421 95C421 115 416 130 411 145C409 150 407 155 406 160H362C361 155 359 150 357 145C352 130 347 115 347 95C347 63 365 48 384 48ZM418 458C416 462 412 464 408 464H360C356 464 352 462 350 457C337 430 320 396 320 354C320 329 331 303 342 276C351 254 361 231 365 208H403C407 231 417 254 426 276C437 303 448 329 448 354C448 396 432 430 418 458ZM193 186C193 179 196 171 200 161C206 144 213 124 213 95C213 33 170 0 128 0H128C86 0 43 33 43 95C43 124 50 144 56 161C60 171 63 179 63 186C63 208 53 232 42 258C29 288 16 320 16 354C16 408 37 450 51 478C61 499 81 512 104 512H152C175 512 195 499 205 479C219 450 240 407 240 354C240 320 227 288 214 258C203 232 193 208 193 186ZM128 48H128C147 48 165 63 165 95C165 115 160 130 155 145C153 150 151 155 150 160H106C105 155 103 150 101 145C96 130 91 115 91 95C91 63 109 48 128 48ZM162 458C160 462 156 464 152 464H104C100 464 96 462 94 457C81 430 64 396 64 354C64 329 75 303 86 276C95 254 105 231 109 208H147C151 231 161 254 170 276C181 303 192 329 192 354C192 396 176 430 162 458Z"]
  };
  var faBox = {
    prefix: 'far',
    iconName: 'box',
    icon: [448, 512, [], "f466", "M440 145L394 65C383 44 362 32 339 32H109C86 32 65 44 54 65L8 145C3 155 0 166 0 177V416C0 451 29 480 64 480H384C419 480 448 451 448 416V177C448 166 445 155 440 145ZM353 88L392 159H247V80H339C344 80 350 83 353 88ZM95 88C98 83 104 80 109 80H199V159H56L95 88ZM384 432H64C55 432 48 425 48 416V207H400V416C400 425 393 432 384 432Z"]
  };
  var faBoxArchive = {
    prefix: 'far',
    iconName: 'box-archive',
    icon: [512, 512, [], "f187", "M464 32H48C22 32 0 54 0 80V144C0 162 14 176 32 176H32V416C32 451 61 480 96 480H416C451 480 480 451 480 416V176H480C498 176 512 162 512 144V80C512 54 490 32 464 32ZM416 432H96C87 432 80 425 80 416V176H432V416C432 425 425 432 416 432ZM464 128H48V80H464V128ZM184 272H328C341 272 352 261 352 248V248C352 235 341 224 328 224H184C171 224 160 235 160 248V248C160 261 171 272 184 272Z"]
  };
  var faBoxBallot = {
    prefix: 'far',
    iconName: 'box-ballot',
    icon: [576, 512, [], "f735", "M520 160H480V208H520C524 208 528 212 528 216V320H48V216C48 212 52 208 56 208H96V160H56C25 160 0 185 0 216V456C0 487 25 512 56 512H520C551 512 576 487 576 456V216C576 185 551 160 520 160ZM528 456C528 460 524 464 520 464H56C52 464 48 460 48 456V368H528V456ZM160 256H416C434 256 448 242 448 224V32C448 14 434 0 416 0H160C142 0 128 14 128 32V224C128 242 142 256 160 256ZM176 48H400V208H176V48Z"]
  };
  var faBoxCheck = {
    prefix: 'far',
    iconName: 'box-check',
    icon: [448, 512, [], "f467", "M183 377C188 382 194 384 200 384S212 382 217 377L313 281C322 272 322 256 313 247S288 238 279 247L200 326L169 295C160 286 144 286 135 295S126 320 135 329L183 377ZM440 145L394 65C383 44 362 32 339 32H109C86 32 65 44 54 65L8 145C3 155 0 166 0 177V416C0 451 29 480 64 480H384C419 480 448 451 448 416V177C448 166 445 155 440 145ZM247 80H339C344 80 350 83 353 88L392 159H247V80ZM95 88C98 83 104 80 109 80H199V159H56L95 88ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V207H400V416Z"]
  };
  var faBoxCircleCheck = {
    prefix: 'far',
    iconName: 'box-circle-check',
    icon: [640, 512, [], "e0a9", "M498 274L424 348L398 322C390 314 378 314 370 322S362 342 370 350L410 390C414 394 419 396 424 396S434 394 438 390L526 302C534 294 534 282 526 274S506 266 498 274ZM448 128C342 128 256 214 256 320S342 512 448 512S640 426 640 320S554 128 448 128ZM448 464C369 464 304 399 304 320S369 176 448 176S592 241 592 320S527 464 448 464ZM64 432C55 432 48 425 48 416V207H255C265 189 278 173 293 159H247V80H339C344 80 350 83 353 88L366 112C381 106 397 101 414 99L394 65C383 44 362 32 339 32H109C86 32 65 44 54 65L8 145C3 155 0 166 0 177V416C0 451 29 480 64 480H291C277 466 264 450 254 432H64ZM95 88C98 83 104 80 109 80H199V159H56L95 88Z"]
  };
  var faBoxDollar = {
    prefix: 'far',
    iconName: 'box-dollar',
    icon: [448, 512, [], "f4a0", "M440 145L394 65C383 44 362 32 339 32H109C86 32 65 44 54 65L8 145C3 155 0 166 0 177V416C0 451 29 480 64 480H384C419 480 448 451 448 416V177C448 166 445 155 440 145ZM247 80H339C344 80 350 83 353 88L392 159H247V80ZM95 88C98 83 104 80 109 80H199V159H56L95 88ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V207H400V416ZM217 359C211 358 203 355 196 352L192 351C184 348 175 352 172 361C169 369 173 378 182 381L185 382C192 385 200 388 208 389V400C208 409 215 416 224 416S240 409 240 400V390C259 386 273 374 276 356C282 320 249 310 228 305L224 303C202 297 203 294 203 289C205 281 218 279 231 281C236 282 241 284 246 286C255 288 264 284 267 276C270 267 265 258 257 255C251 253 246 252 240 251V240C240 231 233 224 224 224S208 231 208 240V250C189 254 175 266 172 284C166 320 200 330 215 334L220 335C245 343 246 345 245 351C243 359 230 361 217 359Z"]
  };
  var faBoxHeart = {
    prefix: 'far',
    iconName: 'box-heart',
    icon: [448, 512, [], "f49d", "M143 325C122 305 123 270 147 251C170 232 201 241 217 256L224 263L231 256C247 240 278 232 301 251C325 270 326 305 305 325L233 397C228 401 220 401 216 397L143 325ZM448 177V416C448 451 419 480 384 480H64C29 480 0 451 0 416V177C0 166 3 155 8 145L54 65C65 44 86 32 109 32H339C362 32 383 44 394 65L440 145C445 155 448 166 448 177ZM247 159H392L352 88C350 83 344 80 339 80H247V159ZM56 159H199V80H109C104 80 98 83 95 88L56 159ZM400 207H48V416C48 425 55 432 64 432H384C393 432 400 425 400 416V207Z"]
  };
  var faBoxOpen = {
    prefix: 'far',
    iconName: 'box-open',
    icon: [640, 512, [], "f49e", "M228 216L320 64L70 32C63 31 56 35 53 41L2 144C-3 153 2 164 12 167L210 223C217 225 224 222 228 216ZM638 144L587 41C584 35 577 31 570 32L320 64L412 216C416 222 423 225 430 223L628 167C638 164 643 153 638 144ZM528 381L344 427V192C344 179 333 168 320 168S296 179 296 192V427L112 381V230L64 217V394C64 408 74 421 88 424L304 478C310 479 315 480 320 480S330 479 335 478L552 424C566 421 576 408 576 394V217L528 230V381Z"]
  };
  var faBoxOpenFull = {
    prefix: 'far',
    iconName: 'box-open-full',
    icon: [640, 512, [], "f49c", "M228 344L320 192L70 160C63 159 56 163 53 169L2 272C-3 281 2 292 12 295L210 351C217 353 224 350 228 344ZM528 413L344 459V320C344 307 333 296 320 296S296 307 296 320V459L112 413V358L64 345V426C64 440 74 453 88 456L304 510C310 511 315 512 320 512S330 511 335 510L552 456C566 453 576 440 576 426V345L528 358V413ZM638 272L587 169C584 163 577 159 570 160L320 192L412 344C416 350 423 353 430 351L628 295C638 292 643 281 638 272ZM194 144C193 139 192 134 192 128C192 93 221 64 256 64S320 93 320 128C320 139 317 150 312 159L320 160L475 140L511 42C514 33 510 24 501 21L446 1C438 -2 428 2 425 11L384 125C382 56 326 0 256 0C185 0 128 57 128 128C128 131 129 133 129 136L194 144Z"]
  };
  var faBoxTaped = {
    prefix: 'far',
    iconName: 'box-taped',
    icon: [448, 512, [], "f49a", "M440 145L394 65C383 44 362 32 339 32H109C86 32 65 44 54 65L8 145C3 155 0 166 0 177V416C0 451 29 480 64 480H384C419 480 448 451 448 416V177C448 166 445 155 440 145ZM353 88L392 159H288L266 80H339C344 80 350 83 353 88ZM95 88C98 83 104 80 109 80H182L160 159H56L95 88ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V207H160V256C160 274 174 288 192 288H256C274 288 288 274 288 256V207H400V416Z"]
  };
  var faBoxTissue = {
    prefix: 'far',
    iconName: 'box-tissue',
    icon: [512, 512, [], "e05b", "M133 320H379C389 320 398 313 402 303L463 111C465 104 464 96 459 90C455 84 448 80 440 80H335C316 80 300 68 294 51C286 28 265 0 208 0H72C65 0 58 3 53 9C49 15 47 22 49 29L110 301C112 312 122 320 133 320ZM208 48C242 48 247 61 249 66C261 103 296 128 335 128H407L361 272H153L102 48H208ZM460 224L445 272H456C460 272 464 276 464 280V368H48V280C48 276 52 272 56 272H71L60 224H56C25 224 0 249 0 280V456C0 487 25 512 56 512H456C487 512 512 487 512 456V280C512 251 489 227 460 224ZM464 456C464 460 460 464 456 464H56C52 464 48 460 48 456V416H464V456Z"]
  };
  var faBoxesStacked = {
    prefix: 'far',
    iconName: 'boxes-stacked',
    icon: [576, 512, [], "f468", "M208 224H368C394 224 416 202 416 176V48C416 22 394 0 368 0H208C182 0 160 22 160 48V176C160 202 182 224 208 224ZM208 48H256V112L288 96L320 112V48H368V176H208V48ZM208 288H48C22 288 0 310 0 336V464C0 490 22 512 48 512H208C234 512 256 490 256 464V336C256 310 234 288 208 288ZM208 464H48V336H96V400L128 384L160 400V336H208V464ZM528 288H368C342 288 320 310 320 336V464C320 490 342 512 368 512H528C554 512 576 490 576 464V336C576 310 554 288 528 288ZM528 464H368V336H416V400L448 384L480 400V336H528V464Z"]
  };
  var faBoxingGlove = {
    prefix: 'far',
    iconName: 'boxing-glove',
    icon: [512, 512, [], "f438", "M418 130C417 130 417 130 416 130C416 130 416 130 416 130V96C416 43 373 0 320 0H128C75 0 32 43 32 96V288C32 315 44 341 64 359V448C64 483 93 512 128 512H320C355 512 384 483 384 448V391L447 327C468 306 480 278 480 248V208C480 170 453 138 418 130ZM432 248C432 265 425 282 413 294L336 371V448C336 457 329 464 320 464H128C119 464 112 457 112 448V338L96 323C86 314 80 301 80 288V96C80 70 102 48 128 48H320C346 48 368 70 368 96V128H344C307 128 275 151 262 184L227 184C196 184 167 171 140 155C129 149 115 152 108 163C101 174 104 189 115 196C150 220 191 232 234 232H258C265 273 301 304 344 304C357 304 368 293 368 280S357 256 344 256C322 256 304 238 304 216S322 176 344 176H400C418 176 432 190 432 208V248ZM285 351C280 344 270 342 263 347L224 373L185 347C178 342 168 344 163 351C158 358 160 368 167 373L195 392L167 411C160 416 158 426 163 433C166 438 171 440 176 440C179 440 182 439 185 437L224 411L263 437C266 439 269 440 272 440C277 440 282 438 285 433C290 426 288 416 281 411L253 392L281 373C288 368 290 358 285 351Z"]
  };
  var faBracketCurly = {
    prefix: 'far',
    iconName: 'bracket-curly',
    icon: [256, 512, [], "e0aa", "M200 32H120C89 32 64 57 64 88V166C64 176 60 186 52 194L7 239C2 243 0 250 0 256C0 262 2 269 7 273L52 318C60 326 64 336 64 346V424C64 455 89 480 120 480H200C213 480 224 469 224 456V456C224 443 213 432 200 432H120C116 432 112 428 112 424V346C112 323 103 301 86 284L58 256L86 228C103 211 112 189 112 166V88C112 84 116 80 120 80H200C213 80 224 69 224 56V56C224 43 213 32 200 32Z"]
  };
  var faBracketRound = {
    prefix: 'far',
    iconName: 'bracket-round',
    icon: [256, 512, [], "e0ab", "M180 435C176 433 80 374 80 256C80 139 176 79 180 77C192 70 195 55 189 44C182 32 167 29 156 35C151 38 32 111 32 256S151 474 156 477C160 479 164 480 168 480C176 480 184 476 189 468C195 457 192 442 180 435Z"]
  };
  var faBracketSquare = {
    prefix: 'far',
    iconName: 'bracket-square',
    icon: [256, 512, [], "e0ac", "M152 32H64C46 32 32 46 32 64V448C32 466 46 480 64 480H152C165 480 176 469 176 456V456C176 443 165 432 152 432H80V80H152C165 80 176 69 176 56V56C176 43 165 32 152 32Z"]
  };
  var faBracketsCurly = {
    prefix: 'far',
    iconName: 'brackets-curly',
    icon: [576, 512, [], "f7ea", "M200 32H120C89 32 64 57 64 88V166C64 176 60 186 52 194L7 239C2 243 0 250 0 256C0 262 2 269 7 273L52 318C60 326 64 336 64 346V424C64 455 89 480 120 480H200C213 480 224 469 224 456V456C224 443 213 432 200 432H120C116 432 112 428 112 424V346C112 323 103 301 86 284L58 256L86 228C103 211 112 189 112 166V88C112 84 116 80 120 80H200C213 80 224 69 224 56V56C224 43 213 32 200 32ZM569 239L524 194C516 186 512 176 512 166V88C512 57 487 32 456 32H376C363 32 352 43 352 56V56C352 69 363 80 376 80H456C460 80 464 84 464 88V166C464 189 473 211 490 228L518 256L490 284C473 301 464 323 464 346V424C464 428 460 432 456 432H376C363 432 352 443 352 456V456C352 469 363 480 376 480H456C487 480 512 455 512 424V346C512 336 516 326 524 318L569 273C574 269 576 262 576 256C576 250 574 243 569 239Z"]
  };
  var faBracketsRound = {
    prefix: 'far',
    iconName: 'brackets-round',
    icon: [512, 512, [], "e0ad", "M148 77C160 70 163 55 157 44C150 32 135 29 124 35C119 38 0 111 0 256S119 474 124 477C128 479 132 480 136 480C144 480 152 476 157 468C163 457 160 442 148 435C144 433 48 374 48 256C48 139 144 79 148 77ZM388 35C377 29 362 32 355 44C349 55 352 70 364 77C368 79 464 138 464 256S368 433 364 435C352 442 349 457 355 468C360 476 368 480 376 480C380 480 384 479 388 477C393 474 512 401 512 256S393 38 388 35Z"]
  };
  var faBracketsSquare = {
    prefix: 'far',
    iconName: 'brackets-square',
    icon: [448, 512, [], "f7e9", "M120 32H32C14 32 0 46 0 64V448C0 466 14 480 32 480H120C133 480 144 469 144 456V456C144 443 133 432 120 432H48V80H120C133 80 144 69 144 56V56C144 43 133 32 120 32ZM416 32H328C315 32 304 43 304 56V56C304 69 315 80 328 80H400V432H328C315 432 304 443 304 456V456C304 469 315 480 328 480H416C434 480 448 466 448 448V64C448 46 434 32 416 32Z"]
  };
  var faBraille = {
    prefix: 'far',
    iconName: 'braille',
    icon: [640, 512, [], "f2a1", "M80 48C45 48 16 77 16 112S45 176 80 176S144 147 144 112S115 48 80 48ZM80 128C71 128 64 121 64 112S71 96 80 96S96 103 96 112S89 128 80 128ZM80 208C45 208 16 237 16 272S45 336 80 336S144 307 144 272S115 208 80 208ZM80 288C71 288 64 281 64 272S71 256 80 256S96 263 96 272S89 288 80 288ZM592 144C610 144 624 130 624 112S610 80 592 80S560 94 560 112S574 144 592 144ZM80 400C62 400 48 414 48 432S62 464 80 464S112 450 112 432S98 400 80 400ZM240 400C222 400 208 414 208 432S222 464 240 464S272 450 272 432S258 400 240 400ZM432 400C414 400 400 414 400 432S414 464 432 464S464 450 464 432S450 400 432 400ZM240 240C222 240 208 254 208 272S222 304 240 304S272 290 272 272S258 240 240 240ZM592 240C574 240 560 254 560 272S574 304 592 304S624 290 624 272S610 240 592 240ZM432 48C397 48 368 77 368 112S397 176 432 176S496 147 496 112S467 48 432 48ZM432 128C423 128 416 121 416 112S423 96 432 96S448 103 448 112S441 128 432 128ZM592 400C574 400 560 414 560 432S574 464 592 464S624 450 624 432S610 400 592 400ZM240 48C205 48 176 77 176 112S205 176 240 176S304 147 304 112S275 48 240 48ZM240 128C231 128 224 121 224 112S231 96 240 96S256 103 256 112S249 128 240 128ZM432 240C414 240 400 254 400 272S414 304 432 304S464 290 464 272S450 240 432 240Z"]
  };
  var faBrain = {
    prefix: 'far',
    iconName: 'brain',
    icon: [512, 512, [], "f5dc", "M512 296C512 268 502 243 485 223C487 216 488 208 488 200C488 168 472 139 447 121C443 93 425 68 401 53C387 22 356 0 320 0C295 0 272 11 256 28C240 11 217 0 192 0C156 0 125 22 111 53C87 68 69 93 65 121C40 139 24 168 24 200C24 208 25 216 27 223C10 243 0 269 0 296C0 326 12 354 32 374C32 375 32 375 32 376C32 423 66 462 111 471C127 496 156 512 188 512C215 512 239 500 256 482C273 500 297 512 324 512C356 512 385 496 401 470C446 462 480 423 480 376C480 375 480 375 480 374C500 354 512 326 512 296ZM232 420C232 444 212 464 188 464C164 464 145 445 144 421C139 423 134 424 128 424C102 424 80 403 80 376C80 368 82 361 86 354C63 344 48 322 48 296C48 269 65 246 89 236C79 228 72 215 72 200C72 175 91 155 115 152C113 147 112 142 112 136C112 112 129 93 152 89C152 89 152 88 152 88C152 66 170 48 192 48S232 66 232 88V420ZM426 354C430 361 432 368 432 376C432 403 410 424 384 424C378 424 373 423 368 421C367 445 348 464 324 464C300 464 280 444 280 420V88C280 66 298 48 320 48S360 66 360 88C360 88 360 89 360 89C383 93 400 112 400 136C400 142 399 147 397 152C421 155 440 175 440 200C440 215 433 228 423 236C447 246 464 269 464 296C464 322 449 344 426 354Z"]
  };
  var faBrainArrowCurvedRight = {
    prefix: 'far',
    iconName: 'brain-arrow-curved-right',
    icon: [640, 512, [], "f677", "M635 340L539 245C529 235 512 242 512 257V304H432C426 304 421 304 415 305C368 312 329 349 322 396C314 443 335 486 370 509C380 516 392 506 388 495C379 468 382 400 448 400H512V447C512 462 529 469 539 459L635 364C642 358 642 346 635 340ZM290 391C291 383 293 375 296 368V82C296 63 311 48 330 48C346 48 359 58 363 74L368 92L391 91C407 91 423 107 423 125C423 130 422 131 417 153L436 160C450 166 479 190 461 226L451 246L471 257C474 259 477 262 480 264V257C480 235 494 216 514 210C514 208 515 207 515 205C515 172 498 142 471 124C470 85 441 52 403 45C390 18 362 0 330 0C307 0 287 9 272 24C256 9 236 0 214 0C182 0 154 18 140 45C102 52 73 85 73 125C46 142 29 172 29 205C29 213 30 221 32 228C12 246 0 272 0 299C0 332 17 362 44 380C44 428 82 466 129 468C145 495 174 512 206 512C232 512 255 501 272 483C285 498 303 507 324 511C296 478 283 435 290 391ZM248 423C248 446 229 464 206 464C173 464 167 434 161 416L140 420C116 424 92 404 92 379C92 376 97 352 97 352L78 344C42 329 37 278 73 258L92 247L83 226C65 191 94 166 108 160L127 153C122 131 121 130 121 126C121 107 136 92 153 91L176 93L181 74C185 59 198 48 214 48C232 48 248 63 248 82V423H248Z"]
  };
  var faBrakeWarning = {
    prefix: 'far',
    iconName: 'brake-warning',
    icon: [640, 512, [], "e0ae", "M320 288C333 288 344 277 344 264V152C344 139 333 128 320 128S296 139 296 152V264C296 277 307 288 320 288ZM320 320C302 320 288 334 288 352C288 370 302 384 320 384S352 370 352 352C352 334 338 320 320 320ZM320 32C196 32 96 132 96 256C96 380 196 480 320 480C444 480 544 380 544 256C544 132 444 32 320 32ZM320 432C223 432 144 353 144 256S223 80 320 80S496 159 496 256S417 432 320 432ZM84 76C73 69 58 72 51 83C18 135 0 194 0 256S18 377 51 429C55 436 63 440 71 440C75 440 80 439 84 436C95 429 98 414 91 403C63 359 48 308 48 256S63 153 91 109C98 98 95 83 84 76ZM589 83C582 72 567 69 556 76C545 83 542 98 549 109C577 153 592 204 592 256S577 359 549 403C542 414 545 429 556 436C560 439 565 440 569 440C577 440 585 436 589 429C622 377 640 318 640 256S622 135 589 83Z"]
  };
  var faBreadLoaf = {
    prefix: 'far',
    iconName: 'bread-loaf',
    icon: [640, 512, [], "f7eb", "M400 32H240C107 32 0 104 0 192C0 227 27 256 60 256H64V448C64 466 78 480 96 480H544C562 480 576 466 576 448V256H580C613 256 640 227 640 192C640 104 533 32 400 32ZM420 208H368V432H112V208H60C54 208 48 202 48 192C48 132 138 80 240 80S432 132 432 192C432 202 426 208 420 208Z"]
  };
  var faBreadSlice = {
    prefix: 'far',
    iconName: 'bread-slice',
    icon: [512, 512, [], "f7ec", "M256 32C132 32 0 96 0 192C0 227 27 256 60 256H64V432C64 458 86 480 112 480H400C426 480 448 458 448 432V256H452C485 256 512 227 512 192C512 96 380 32 256 32ZM452 208H400V432H112V208H60C54 208 48 202 48 192C48 132 154 80 256 80S464 132 464 192C464 202 458 208 452 208Z"]
  };
  var faBriefcase = {
    prefix: 'far',
    iconName: 'briefcase',
    icon: [512, 512, [], "f0b1", "M448 96H384V64C384 29 355 0 320 0H192C157 0 128 29 128 64V96H64C29 96 0 125 0 160V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM192 48H320C329 48 336 55 336 64V96H176V64C176 55 183 48 192 48ZM64 144H448C457 144 464 151 464 160V256H48V160C48 151 55 144 64 144ZM448 432H64C55 432 48 425 48 416V304H192V320C192 338 206 352 224 352H288C306 352 320 338 320 320V304H464V416C464 425 457 432 448 432Z"]
  };
  var faBriefcaseClock = {
    prefix: 'far',
    iconName: 'briefcase-clock',
    icon: [640, 512, [], "f64a", "M496 224C416 224 352 288 352 368S416 512 496 512S640 448 640 368S576 224 496 224ZM544 384H496C487 384 480 377 480 368V304C480 295 487 288 496 288S512 295 512 304V352H544C553 352 560 359 560 368S553 384 544 384ZM64 432C55 432 48 425 48 416V304H192V320C192 338 206 352 224 352H288C306 352 320 338 320 320V304H332C339 286 348 270 360 256H48V160C48 151 55 144 64 144H448C457 144 464 151 464 160V195C474 193 485 192 496 192C501 192 507 192 512 193V160C512 125 483 96 448 96H384V64C384 29 355 0 320 0H192C157 0 128 29 128 64V96H64C29 96 0 125 0 160V416C0 451 29 480 64 480H360C348 466 339 450 332 432H64ZM176 64C176 55 183 48 192 48H320C329 48 336 55 336 64V96H176V64Z"]
  };
  var faBriefcaseMedical = {
    prefix: 'far',
    iconName: 'briefcase-medical',
    icon: [512, 512, [], "f469", "M448 96H384V64C384 29 355 0 320 0H192C157 0 128 29 128 64V96H64C29 96 0 125 0 160V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM176 64C176 55 183 48 192 48H320C329 48 336 55 336 64V96H176V64ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V160C48 151 55 144 64 144H448C457 144 464 151 464 160V416ZM336 256H288V208C288 199 281 192 272 192H240C231 192 224 199 224 208V256H176C167 256 160 263 160 272V304C160 313 167 320 176 320H224V368C224 377 231 384 240 384H272C281 384 288 377 288 368V320H336C345 320 352 313 352 304V272C352 263 345 256 336 256Z"]
  };
  var faBringForward = {
    prefix: 'far',
    iconName: 'bring-forward',
    icon: [512, 512, [], "f856", "M352 288V64C352 29 323 0 288 0H64C29 0 0 29 0 64V288C0 323 29 352 64 352H288C323 352 352 323 352 288ZM448 160H384V208H448C457 208 464 215 464 224V448C464 457 457 464 448 464H224C215 464 208 457 208 448V384H160V448C160 483 189 512 224 512H448C483 512 512 483 512 448V224C512 189 483 160 448 160Z"]
  };
  var faBringFront = {
    prefix: 'far',
    iconName: 'bring-front',
    icon: [640, 512, [], "f857", "M480 352V160C480 125 451 96 416 96H224C189 96 160 125 160 160V352C160 387 189 416 224 416H416C451 416 480 387 480 352ZM48 48H208V64H256V48C256 22 234 0 208 0H48C22 0 0 22 0 48V208C0 234 22 256 48 256H128V208H48V48ZM592 256H512V304H592V464H432V448H384V464C384 490 406 512 432 512H592C618 512 640 490 640 464V304C640 278 618 256 592 256Z"]
  };
  var faBroom = {
    prefix: 'far',
    iconName: 'broom',
    icon: [640, 512, [], "f51a", "M635 9C627 -1 612 -3 601 5L368 187L329 138C324 132 315 132 310 138L252 211C221 212 148 218 100 256C38 305 0 511 0 511C15 512 212 519 272 471C320 433 342 364 350 334L434 294C441 291 443 282 439 276L398 225L631 43C641 35 643 20 635 9ZM242 434C226 447 168 462 59 464C64 445 70 426 75 407L121 371C126 368 122 360 116 361L89 366C103 331 117 303 130 293C157 272 201 262 240 260L300 335C290 366 272 410 242 434ZM366 273L330 290L290 240L315 209C317 206 322 206 324 209L368 264C370 267 369 272 366 273Z"]
  };
  var faBrowser = {
    prefix: 'far',
    iconName: 'browser',
    icon: [512, 512, [], "f37e", "M448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V160H464V416Z"]
  };
  var faBrowsers = {
    prefix: 'far',
    iconName: 'browsers',
    icon: [576, 512, [], "e0af", "M512 0H160C125 0 96 29 96 64V352C96 387 125 416 160 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM528 352C528 361 521 368 512 368H160C151 368 144 361 144 352V128H528V352ZM48 432V96C22 96 0 118 0 144V448C0 483 29 512 64 512H432C458 512 480 490 480 464H80C62 464 48 450 48 432Z"]
  };
  var faBrush = {
    prefix: 'far',
    iconName: 'brush',
    icon: [384, 512, [], "f55d", "M352 0H32C14 0 0 14 0 32V320C0 355 29 384 64 384H128V448C128 483 157 512 192 512S256 483 256 448V384H320C355 384 384 355 384 320V32C384 14 370 0 352 0ZM192 472C179 472 168 461 168 448S179 424 192 424S216 435 216 448S205 472 192 472ZM48 48H96V144C96 153 103 160 112 160S128 153 128 144V48H192V104C192 113 199 120 208 120S224 113 224 104V48H336V288H48V48Z"]
  };
  var faBug = {
    prefix: 'far',
    iconName: 'bug',
    icon: [576, 512, [], "f188", "M520 264H432V197L503 139C513 130 515 115 507 105C498 94 483 93 473 101L401 160H175L103 101C93 93 78 94 69 105C61 115 63 130 73 139L144 197V264H56C43 264 32 275 32 288S43 312 56 312H144V336C144 354 148 372 154 388L71 471C62 480 62 496 71 505C76 510 82 512 88 512S100 510 105 505L180 430C206 460 245 480 288 480S370 460 396 430L471 505C476 510 482 512 488 512S500 510 505 505C514 496 514 480 505 471L422 388C428 372 432 354 432 336V312H520C533 312 544 301 544 288S533 264 520 264ZM384 336C384 381 353 418 312 429V280C312 267 301 256 288 256S264 267 264 280V429C223 418 192 381 192 336V209C192 209 193 208 194 208H382C383 208 384 209 384 209V336ZM216 128C229 128 240 117 240 104V96C240 70 262 48 288 48S336 70 336 96V104C336 117 347 128 360 128S384 117 384 104V96C384 43 341 0 288 0S192 43 192 96V104C192 117 203 128 216 128Z"]
  };
  var faBuilding = {
    prefix: 'far',
    iconName: 'building',
    icon: [448, 512, [], "f1ad", "M128 148V108C128 101 133 96 140 96H180C187 96 192 101 192 108V148C192 155 187 160 180 160H140C133 160 128 155 128 148ZM268 160H308C315 160 320 155 320 148V108C320 101 315 96 308 96H268C261 96 256 101 256 108V148C256 155 261 160 268 160ZM140 256H180C187 256 192 251 192 244V204C192 197 187 192 180 192H140C133 192 128 197 128 204V244C128 251 133 256 140 256ZM268 256H308C315 256 320 251 320 244V204C320 197 315 192 308 192H268C261 192 256 197 256 204V244C256 251 261 256 268 256ZM192 340V300C192 293 187 288 180 288H140C133 288 128 293 128 300V340C128 347 133 352 140 352H180C187 352 192 347 192 340ZM268 352H308C315 352 320 347 320 340V300C320 293 315 288 308 288H268C261 288 256 293 256 300V340C256 347 261 352 268 352ZM448 488L448 488C448 501 437 512 424 512H24C11 512 0 501 0 488V488C0 475 11 464 24 464H31V32C31 14 46 0 63 0H384C402 0 416 14 416 32V464H424C437 464 448 475 448 488ZM79 463L176 464L176 400C176 391 183 384 192 384H256C265 384 272 390 272 399L272 464H368L369 49L80 48L79 463Z"]
  };
  var faBullhorn = {
    prefix: 'far',
    iconName: 'bullhorn',
    icon: [512, 512, [], "f0a1", "M480 185V32C480 23 473 0 448 0C441 0 434 2 428 7L343 75C300 109 247 128 192 128H64C29 128 0 157 0 192V288C0 323 29 352 64 352H82C71 430 116 495 118 498C125 507 134 512 143 512H192C205 512 217 503 222 489C227 475 224 459 215 448C214 448 174 399 186 352H192C247 352 300 371 343 405L428 473C433 477 442 480 448 480C473 480 480 457 480 448V295C499 284 512 264 512 240S499 196 480 185ZM64 304C55 304 48 297 48 288V192C48 183 55 176 64 176H192V304H64ZM432 415L373 367C334 337 288 316 240 308V172C288 164 334 143 373 113L432 65V415Z"]
  };
  var faBullseye = {
    prefix: 'far',
    iconName: 'bullseye',
    icon: [512, 512, [], "f140", "M256 112C176 112 112 176 112 256S176 400 256 400S400 336 400 256S336 112 256 112ZM256 352C203 352 160 309 160 256S203 160 256 160S352 203 352 256S309 352 256 352ZM256 16C123 16 16 123 16 256C16 389 123 496 256 496S496 389 496 256C496 123 389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM256 208C230 208 208 230 208 256S230 304 256 304S304 282 304 256S282 208 256 208Z"]
  };
  var faBullseyeArrow = {
    prefix: 'far',
    iconName: 'bullseye-arrow',
    icon: [512, 512, [], "f648", "M495 107C494 102 489 97 483 96L416 80L400 13C399 7 394 2 389 1C383 -1 377 1 373 5L309 69C305 72 303 78 304 83L317 145L231 231C222 240 222 256 231 265C236 270 242 272 248 272S260 270 265 265L351 179L413 192C414 192 415 192 416 192C420 192 424 190 427 187L491 123C495 119 497 113 495 107ZM240 160C245 160 250 161 255 162L282 135L279 118C266 114 253 112 240 112C160 112 96 176 96 256S160 400 240 400S384 336 384 256C384 243 382 230 378 217L361 214L335 241C335 246 336 251 336 256C336 309 293 352 240 352S144 309 144 256S187 160 240 160ZM450 210C444 216 437 220 429 222C431 233 432 244 432 256C432 362 346 448 240 448S48 362 48 256S134 64 240 64C252 64 263 65 274 67C276 59 280 52 286 46L307 26C285 19 263 16 240 16C107 16 0 123 0 256C0 389 107 496 240 496S480 389 480 256C480 233 477 211 470 189L450 210Z"]
  };
  var faBullseyePointer = {
    prefix: 'far',
    iconName: 'bullseye-pointer',
    icon: [512, 512, [], "f649", "M268 245C264 241 258 239 252 241L28 305C21 306 17 312 16 319C16 326 20 332 26 335L101 367L16 451C4 463 4 484 16 496H16C29 509 49 509 62 496L146 412L178 486C180 492 186 496 192 496C193 496 193 496 193 496C200 496 206 491 208 484L272 260C273 255 272 249 268 245ZM256 16C124 16 16 123 16 256C16 262 17 269 17 275C18 274 19 274 19 274L65 261C65 259 64 258 64 256C64 150 150 64 256 64S448 150 448 256S363 448 256 448C255 448 253 448 252 448L239 493C238 494 238 494 238 495C244 496 250 496 256 496C389 496 496 389 496 256C496 123 389 16 256 16ZM280 349L265 399C341 394 400 332 400 256C400 176 336 112 256 112C180 112 118 172 113 247L164 233C174 191 212 160 256 160C309 160 352 203 352 256C352 301 321 338 280 349Z"]
  };
  var faBurger = {
    prefix: 'far',
    iconName: 'burger',
    icon: [512, 512, [], "f805", "M352 176C361 176 368 169 368 160S361 144 352 144S336 151 336 160S343 176 352 176ZM256 144C265 144 272 137 272 128S265 112 256 112S240 119 240 128S247 144 256 144ZM512 288C512 265 502 243 484 228C484 227 485 227 485 226C499 203 500 174 486 151C442 79 352 32 256 32C160 32 70 79 26 151C12 174 13 203 27 226C27 227 28 227 28 228C-5 256 -10 306 19 339C23 345 28 349 34 353C33 356 32 359 32 362V396C32 442 70 480 116 480H396C443 480 480 442 480 396V362C480 359 479 356 478 353C499 338 512 314 512 288ZM67 175C102 118 176 80 256 80C336 80 410 118 445 175C449 183 449 193 444 201C442 205 437 208 432 208H80C75 208 70 205 67 201C63 193 63 183 67 175ZM432 396C432 416 416 432 396 432H116C96 432 80 416 80 396V371H432V396ZM432 320H80C62 320 48 306 48 288S62 256 80 256H432C450 256 464 270 464 288S450 320 432 320ZM160 176C169 176 176 169 176 160S169 144 160 144S144 151 144 160S151 176 160 176Z"]
  };
  var faBurgerCheese = {
    prefix: 'far',
    iconName: 'burger-cheese',
    icon: [512, 512, [], "f7f1", "M352 176C361 176 368 169 368 160S361 144 352 144S336 151 336 160S343 176 352 176ZM256 144C265 144 272 137 272 128S265 112 256 112S240 119 240 128S247 144 256 144ZM512 288C512 265 502 243 484 228C484 227 485 227 485 226C499 203 500 174 486 151C442 79 352 32 256 32C160 32 70 79 26 151C12 174 13 203 27 226C27 227 28 227 28 228C-5 256 -10 306 19 339C23 345 28 349 34 353C33 356 32 359 32 362V396C32 442 70 480 116 480H396C443 480 480 442 480 396V362C480 359 479 356 478 353C499 338 512 314 512 288ZM67 175C102 118 176 80 256 80C336 80 410 118 445 175C449 183 449 193 444 201C442 205 437 208 432 208H80C75 208 70 205 67 201C63 193 63 183 67 175ZM432 396C432 416 416 432 396 432H116C96 432 80 416 80 396V371H432V396ZM432 320H80C62 320 48 306 48 288S62 256 80 256H224L320 304L416 256H432C450 256 464 270 464 288S450 320 432 320ZM160 176C169 176 176 169 176 160S169 144 160 144S144 151 144 160S151 176 160 176Z"]
  };
  var faBurgerFries = {
    prefix: 'far',
    iconName: 'burger-fries',
    icon: [640, 512, [], "e0b0", "M98 464L65 314C97 338 142 352 192 352C205 352 218 351 230 349C232 345 233 341 235 338C232 325 232 312 233 300C220 302 206 304 192 304C127 304 74 274 65 235C64 228 57 224 50 224H16C11 224 6 226 3 230S-1 239 0 243L54 487C58 502 71 512 86 512H268C255 499 244 482 238 464H98ZM128 258V33L124 13C123 8 119 3 114 1C109 -1 103 0 99 3L70 25C65 28 63 35 64 41L101 238C106 245 116 253 128 258ZM50 192C54 192 57 193 60 194L40 87L21 81C15 79 9 80 5 84C1 88 -1 93 0 99L17 192H50ZM224 269V32C224 26 221 20 215 18L183 2C178 -1 172 -1 168 2C163 5 160 10 160 16V269C181 273 203 273 224 269ZM384 99C385 93 383 88 379 84C374 80 369 79 363 81L346 86L328 188C342 181 356 176 371 171L384 99ZM292 211L320 51C321 45 319 40 315 36C310 32 305 31 299 33L265 43C261 44 258 47 256 51V246C266 233 278 221 292 211ZM448 296C457 296 464 289 464 280S457 264 448 264S432 271 432 280S439 296 448 296ZM528 312C537 312 544 305 544 296S537 280 528 280S512 287 512 296S519 312 528 312ZM368 312C377 312 384 305 384 296S377 280 368 280S352 287 352 296S359 312 368 312ZM640 376C640 363 633 352 624 345C636 321 634 292 619 270C585 223 518 192 448 192C378 192 311 223 277 270C262 292 260 321 272 345C262 352 256 363 256 376C256 387 261 398 269 405C266 412 264 420 264 428C264 474 302 512 348 512H548C594 512 632 474 632 428C632 420 630 412 627 405C635 398 640 387 640 376ZM317 298C339 266 389 240 448 240C507 240 557 266 580 298C585 305 585 315 581 323S569 336 560 336H336C327 336 319 331 315 323S311 305 317 298ZM548 464H348C328 464 312 448 312 428C312 421 317 416 324 416H572C579 416 584 421 584 428C584 448 568 464 548 464Z"]
  };
  var faBurgerGlass = {
    prefix: 'far',
    iconName: 'burger-glass',
    icon: [640, 512, [], "e0b1", "M97 464C88 464 81 458 81 449L62 208H293L293 210C308 199 325 189 343 182L352 34C353 16 338 0 320 0H32C13 0 -1 16 0 34L33 453C35 486 63 512 97 512H262C264 512 266 512 268 511C254 498 244 482 238 464H97ZM49 48H303L296 160H58L49 48ZM528 312C537 312 544 305 544 296S537 280 528 280S512 287 512 296S519 312 528 312ZM640 376C640 363 634 352 624 345C636 321 634 292 619 270C586 223 518 192 448 192C378 192 311 223 277 270C262 292 260 321 272 345C262 352 256 363 256 376C256 387 261 398 269 405C266 412 264 420 264 428C264 474 302 512 348 512H548C594 512 632 474 632 428C632 420 630 412 627 405C635 398 640 387 640 376ZM317 298C339 266 389 240 448 240C507 240 557 266 580 298C585 305 585 315 581 323S569 336 560 336H336C327 336 319 331 315 323S311 305 317 298ZM548 464H348C328 464 312 448 312 428C312 421 317 416 324 416H572C579 416 584 421 584 428C584 448 568 464 548 464ZM448 296C457 296 464 289 464 280S457 264 448 264S432 271 432 280S439 296 448 296ZM368 312C377 312 384 305 384 296S377 280 368 280S352 287 352 296S359 312 368 312Z"]
  };
  var faBurgerSoda = {
    prefix: 'far',
    iconName: 'burger-soda',
    icon: [640, 512, [], "f858", "M110 464L82 176H328C341 176 352 165 352 152C352 139 341 128 328 128H207L227 48H264C277 48 288 37 288 24C288 11 277 0 264 0H221C202 0 186 12 182 30L157 128H24C11 128 0 139 0 152C0 165 11 176 24 176H34L64 482C65 499 79 512 96 512H268C255 499 244 482 238 464H110ZM528 312C537 312 544 305 544 296S537 280 528 280S512 287 512 296S519 312 528 312ZM448 296C457 296 464 289 464 280S457 264 448 264S432 271 432 280S439 296 448 296ZM368 312C377 312 384 305 384 296S377 280 368 280S352 287 352 296S359 312 368 312ZM640 376C640 363 634 352 624 345C636 321 634 292 619 270C586 223 518 192 448 192S311 223 277 270C262 292 260 321 272 345C262 352 256 363 256 376C256 387 261 398 269 405C266 412 264 420 264 428C264 474 302 512 348 512H548C594 512 632 474 632 428C632 420 630 412 627 405C635 398 640 387 640 376ZM317 298C339 266 389 240 448 240S557 266 580 298C585 305 585 315 581 323S569 336 560 336H336C327 336 319 331 315 323S311 305 317 298ZM548 464H348C328 464 312 448 312 428C312 421 317 416 324 416H572C579 416 584 421 584 428C584 448 568 464 548 464Z"]
  };
  var faBurrito = {
    prefix: 'far',
    iconName: 'burrito',
    icon: [512, 512, [], "f7ed", "M512 123C512 91 491 62 460 52C453 32 439 15 419 7C400 -2 377 -2 358 7C317 -11 270 8 252 48L34 267C-11 312 -11 385 34 431L81 478C127 523 200 523 245 478L464 260C504 242 523 195 505 154C510 144 512 134 512 123ZM163 464C145 464 128 457 115 444L68 397C60 388 54 378 51 367C71 373 91 376 112 376C204 376 283 318 314 237C347 229 381 232 412 243L212 444C199 457 182 464 163 464ZM268 100C276 119 280 139 280 160C280 253 205 328 112 328C93 328 74 325 55 318C59 312 63 306 68 300L268 100Z"]
  };
  var faBus = {
    prefix: 'far',
    iconName: 'bus',
    icon: [576, 512, [], "f207", "M520 128H512V80C512 35 413 0 288 0S64 35 64 80V128H56C43 128 32 139 32 152V232C32 245 43 256 56 256H64V416C64 434 78 448 96 448V480C96 498 110 512 128 512S160 498 160 480V448H416V480C416 498 430 512 448 512S480 498 480 480V448C498 448 512 434 512 416V256H520C533 256 544 245 544 232V152C544 139 533 128 520 128ZM112 160H264V224H112V160ZM464 400H112V272H464V400ZM464 224H312V160H464V224ZM464 112H368C368 94 354 80 336 80H240C222 80 208 94 208 112H112V85C126 72 189 48 288 48S450 72 464 85V112ZM176 368C194 368 208 354 208 336S194 304 176 304S144 318 144 336S158 368 176 368ZM400 368C418 368 432 354 432 336S418 304 400 304S368 318 368 336S382 368 400 368Z"]
  };
  var faBusSchool = {
    prefix: 'far',
    iconName: 'bus-school',
    icon: [576, 512, [], "f5dd", "M176 304C158 304 144 318 144 336S158 368 176 368S208 354 208 336S194 304 176 304ZM528 232V152C528 139 517 128 504 128H496V80C496 35 404 0 288 0S80 35 80 80V128H72C59 128 48 139 48 152V232C48 245 59 256 72 256C77 256 48 275 48 320V384C48 414 68 439 96 446V480C96 498 110 512 128 512S160 498 160 480V448H416V480C416 498 430 512 448 512S480 498 480 480V446C508 439 528 414 528 384V320C528 273 498 256 504 256C517 256 528 245 528 232ZM128 84C140 71 197 48 288 48S436 71 448 84V112H368C368 94 354 80 336 80H240C222 80 208 94 208 112H128V84ZM448 160V224H304V160H448ZM128 160H272V224H128V160ZM480 384C480 393 473 400 464 400H112C103 400 96 393 96 384V320C96 294 118 272 144 272H432C458 272 480 294 480 320V384ZM400 304C382 304 368 318 368 336S382 368 400 368S432 354 432 336S418 304 400 304Z"]
  };
  var faBusSimple = {
    prefix: 'far',
    iconName: 'bus-simple',
    icon: [448, 512, [], "f55e", "M336 368C354 368 368 354 368 336S354 304 336 304S304 318 304 336S318 368 336 368ZM112 368C130 368 144 354 144 336S130 304 112 304S80 318 80 336S94 368 112 368ZM448 80C448 35 349 0 224 0S0 35 0 80V416C0 434 14 448 32 448V480C32 498 46 512 64 512S96 498 96 480V448H352V480C352 498 366 512 384 512S416 498 416 480V448C434 448 448 434 448 416V80ZM400 400H48V272H400V400ZM400 224H48V160H400V224ZM400 112H48V85C62 72 125 48 224 48S386 72 400 85V112Z"]
  };
  var faC = {
    prefix: 'far',
    iconName: 'c',
    icon: [384, 512, [], "e0b2", "M219 480C161 480 105 457 64 414C-21 327 -21 185 64 98C105 55 161 32 219 32S333 55 375 98C387 111 387 131 374 143C362 155 341 155 329 143C300 113 261 96 219 96S139 113 110 143C49 205 49 307 110 369C139 399 178 416 219 416S300 399 329 369C341 357 362 357 374 369C387 381 387 401 375 414C333 457 278 480 219 480Z"]
  };
  var faCabinetFiling = {
    prefix: 'far',
    iconName: 'cabinet-filing',
    icon: [448, 512, [], "f64b", "M384 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H384C419 512 448 483 448 448V64C448 29 419 0 384 0ZM384 464H64C55 464 48 457 48 448V280H400V448C400 457 393 464 384 464ZM400 232H48V64C48 55 55 48 64 48H384C393 48 400 55 400 64V232ZM128 168H144C153 168 160 161 160 152V144H288V152C288 161 295 168 304 168H320C329 168 336 161 336 152V128C336 110 322 96 304 96H144C126 96 112 110 112 128V152C112 161 119 168 128 168ZM128 408H144C153 408 160 401 160 392V384H288V392C288 401 295 408 304 408H320C329 408 336 401 336 392V368C336 350 322 336 304 336H144C126 336 112 350 112 368V392C112 401 119 408 128 408Z"]
  };
  var faCableCar = {
    prefix: 'far',
    iconName: 'cable-car',
    icon: [512, 512, [], "e0b3", "M511 58C508 45 494 37 482 41L18 169C5 172 -3 186 1 198C4 209 13 216 24 216C26 216 28 216 30 215L232 160V224H96C61 224 32 253 32 288V448C32 483 61 512 96 512H416C451 512 480 483 480 448V288C480 253 451 224 416 224H280V146L494 87C507 84 515 70 511 58ZM80 288C80 279 87 272 96 272H168V352H80V288ZM432 448C432 457 425 464 416 464H96C87 464 80 457 80 448V400H432V448ZM344 272H416C425 272 432 279 432 288V352H344V272ZM296 272V352H216V272H296ZM192 96C210 96 224 82 224 64C224 46 210 32 192 32S160 46 160 64C160 82 174 96 192 96ZM288 64C306 64 320 50 320 32C320 14 306 0 288 0C270 0 256 14 256 32C256 50 270 64 288 64Z"]
  };
  var faCactus = {
    prefix: 'far',
    iconName: 'cactus',
    icon: [512, 512, [], "f8a7", "M240 130C231 130 224 137 224 146C224 155 231 162 240 162S256 155 256 146C256 137 249 130 240 130ZM272 354C263 354 256 361 256 370C256 379 263 386 272 386S288 379 288 370C288 361 281 354 272 354ZM464 224C438 224 416 246 416 272V336C416 345 409 352 400 352H352V101C352 49 313 3 261 0C259 0 258 0 256 0C203 0 160 43 160 96V224H112C103 224 96 217 96 208V144C96 118 74 96 48 96S0 118 0 144V208C0 270 50 320 112 320H160V480C160 498 174 512 192 512H320C338 512 352 498 352 480V448H400C462 448 512 398 512 336V272C512 246 490 224 464 224ZM304 464H208V96C208 70 230 48 256 48L259 48C284 49 304 73 304 101V464Z"]
  };
  var faCakeCandles = {
    prefix: 'far',
    iconName: 'cake-candles',
    icon: [448, 512, [], "f1fd", "M384 224H376V168C376 155 365 144 352 144S328 155 328 168V224H248V168C248 155 237 144 224 144S200 155 200 168V224H120V168C120 155 109 144 96 144S72 155 72 168V224H64C29 224 0 253 0 288V480C0 498 14 512 32 512H416C434 512 448 498 448 480V288C448 253 419 224 384 224ZM400 464H48V392C66 390 82 382 96 374C113 385 136 395 160 395S207 385 224 374C241 385 264 395 288 395S335 385 352 374C365 382 382 390 400 393V464ZM400 344C387 339 374 331 367 325C358 318 346 318 337 325C327 333 307 347 288 347S249 333 239 325C230 318 218 318 209 325C199 333 179 347 160 347S121 333 111 325C102 318 90 318 81 325C74 331 61 339 48 344V288C48 279 55 272 64 272H384C393 272 400 279 400 288V344ZM352 112C374 112 392 94 392 72S352 0 352 0S312 50 312 72S330 112 352 112ZM224 112C246 112 264 94 264 72S224 0 224 0S184 50 184 72S202 112 224 112ZM96 112C118 112 136 94 136 72S96 0 96 0S56 50 56 72S74 112 96 112Z"]
  };
  var faCalculator = {
    prefix: 'far',
    iconName: 'calculator',
    icon: [384, 512, [], "f1ec", "M192 344C205 344 216 333 216 320S205 296 192 296S168 307 168 320S179 344 192 344ZM192 256C205 256 216 245 216 232S205 208 192 208S168 219 168 232S179 256 192 256ZM280 344C293 344 304 333 304 320S293 296 280 296S256 307 256 320S267 344 280 344ZM280 256C293 256 304 245 304 232S293 208 280 208S256 219 256 232S267 256 280 256ZM280 432C293 432 304 421 304 408S293 384 280 384S256 395 256 408S267 432 280 432ZM104 432H184C197 432 208 421 208 408S197 384 184 384H104C91 384 80 395 80 408S91 432 104 432ZM320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V176H336V448ZM336 128H48V64C48 55 55 48 64 48H320C329 48 336 55 336 64V128ZM104 256C117 256 128 245 128 232S117 208 104 208S80 219 80 232S91 256 104 256ZM104 344C117 344 128 333 128 320S117 296 104 296S80 307 80 320S91 344 104 344Z"]
  };
  var faCalculatorSimple = {
    prefix: 'far',
    iconName: 'calculator-simple',
    icon: [512, 512, [], "f64c", "M169 343C160 334 144 334 135 343L112 366L89 343C80 334 64 334 55 343S46 368 55 377L78 400L55 423C46 432 46 448 55 457C60 462 66 464 72 464S84 462 89 457L112 434L135 457C140 462 146 464 152 464S164 462 169 457C178 448 178 432 169 423L146 400L169 377C178 368 178 352 169 343ZM64 135H160C173 135 184 124 184 111S173 87 160 87H64C51 87 40 98 40 111S51 135 64 135ZM344 136H376V168C376 181 387 192 400 192S424 181 424 168V136H456C469 136 480 125 480 112S469 88 456 88H424V56C424 43 413 32 400 32S376 43 376 56V88H344C331 88 320 99 320 112S331 136 344 136ZM488 232H280V24C280 11 269 0 256 0S232 11 232 24V232H24C11 232 0 243 0 256S11 280 24 280H232V488C232 501 243 512 256 512S280 501 280 488V280H488C501 280 512 269 512 256S501 232 488 232ZM448 416H352C339 416 328 427 328 440S339 464 352 464H448C461 464 472 453 472 440S461 416 448 416ZM448 336H352C339 336 328 347 328 360S339 384 352 384H448C461 384 472 373 472 360S461 336 448 336Z"]
  };
  var faCalendar = {
    prefix: 'far',
    iconName: 'calendar',
    icon: [448, 512, [], "f133", "M384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM384 464H64C55 464 48 457 48 448V192H400V448C400 457 393 464 384 464Z"]
  };
  var faCalendarArrowDown = {
    prefix: 'far',
    iconName: 'calendar-arrow-down',
    icon: [448, 512, [], "e0b4", "M207 425C212 430 218 432 224 432S236 430 241 425L321 345C330 336 330 320 321 311S296 302 287 311L248 350V248C248 235 237 224 224 224S200 235 200 248V350L161 311C152 302 136 302 127 311S118 336 127 345L207 425ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendarArrowUp = {
    prefix: 'far',
    iconName: 'calendar-arrow-up',
    icon: [448, 512, [], "e0b5", "M161 345L200 306V408C200 421 211 432 224 432S248 421 248 408V306L287 345C296 354 312 354 321 345S330 320 321 311L241 231C236 226 230 224 224 224S212 226 207 231L127 311C118 320 118 336 127 345S152 354 161 345ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendarCheck = {
    prefix: 'far',
    iconName: 'calendar-check',
    icon: [448, 512, [], "f274", "M183 409C188 413 194 416 200 416C200 416 201 416 201 416C208 416 214 413 218 408L314 296C323 286 322 270 312 262C302 253 286 254 278 264L199 357L169 327C160 318 144 318 135 327S126 352 135 361L183 409ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendarClock = {
    prefix: 'far',
    iconName: 'calendar-clock',
    icon: [576, 512, [], "e0b6", "M432 224C352 224 288 288 288 368S352 512 432 512S576 448 576 368S512 224 432 224ZM480 384H426C420 384 416 380 416 374V304C416 295 423 288 432 288C441 288 448 295 448 304V352H480C489 352 496 359 496 368S489 384 480 384ZM285 464H64C55 464 48 457 48 448V192H448V128C448 93 419 64 384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H331C313 499 297 483 285 464Z"]
  };
  var faCalendarDay = {
    prefix: 'far',
    iconName: 'calendar-day',
    icon: [448, 512, [], "f783", "M384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448ZM112 384H208C217 384 224 377 224 368V272C224 263 217 256 208 256H112C103 256 96 263 96 272V368C96 377 103 384 112 384Z"]
  };
  var faCalendarDays = {
    prefix: 'far',
    iconName: 'calendar-days',
    icon: [448, 512, [], "f073", "M384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 192V296H248V192H400ZM200 192V296H48V192H200ZM48 448V344H200V464H64C55 464 48 457 48 448ZM384 464H248V344H400V448C400 457 393 464 384 464Z"]
  };
  var faCalendarExclamation = {
    prefix: 'far',
    iconName: 'calendar-exclamation',
    icon: [448, 512, [], "f334", "M224 432C242 432 256 418 256 400S242 368 224 368C206 368 192 382 192 400S206 432 224 432ZM224 336C237 336 248 325 248 312V248C248 235 237 224 224 224S200 235 200 248V312C200 325 211 336 224 336ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendarHeart = {
    prefix: 'far',
    iconName: 'calendar-heart',
    icon: [448, 512, [], "e0b7", "M216 413C220 417 228 417 232 413L301 341C321 320 320 286 298 267C278 250 249 253 231 272L224 279L217 272C199 253 170 250 150 267C128 286 127 320 147 341L216 413ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendarImage = {
    prefix: 'far',
    iconName: 'calendar-image',
    icon: [448, 512, [], "e0b8", "M384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448ZM146 327L99 391C96 395 95 402 98 407C100 413 106 416 112 416H336C342 416 347 413 350 408C353 402 353 396 349 391L264 263C261 259 256 256 251 256S240 259 237 263L184 343L172 327C169 322 164 320 159 320S149 322 146 327ZM128 288C146 288 160 274 160 256S146 224 128 224S96 238 96 256S110 288 128 288Z"]
  };
  var faCalendarLines = {
    prefix: 'far',
    iconName: 'calendar-lines',
    icon: [448, 512, [], "e0b9", "M384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448ZM120 304H328C341 304 352 293 352 280S341 256 328 256H120C107 256 96 267 96 280S107 304 120 304ZM120 400H232C245 400 256 389 256 376S245 352 232 352H120C107 352 96 363 96 376S107 400 120 400Z"]
  };
  var faCalendarMinus = {
    prefix: 'far',
    iconName: 'calendar-minus',
    icon: [448, 512, [], "f272", "M152 352H296C309 352 320 341 320 328S309 304 296 304H152C139 304 128 315 128 328S139 352 152 352ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendarPen = {
    prefix: 'far',
    iconName: 'calendar-pen',
    icon: [448, 512, [], "f333", "M296 296L248 248L267 229C274 222 285 222 292 229L315 252C322 259 322 270 315 277L296 296ZM135 416L183 406C185 406 187 405 189 403L280 313L232 265L141 355C139 357 138 359 138 361L128 409C127 413 131 417 135 416ZM448 128V448C448 483 419 512 384 512H64C29 512 0 483 0 448V128C0 93 29 64 64 64H104V24C104 11 115 0 128 0S152 11 152 24V64H296V24C296 11 307 0 320 0S344 11 344 24V64H384C419 64 448 93 448 128ZM400 192H48V448C48 457 55 464 64 464H384C393 464 400 457 400 448V192Z"]
  };
  var faCalendarPlus = {
    prefix: 'far',
    iconName: 'calendar-plus',
    icon: [448, 512, [], "f271", "M384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448ZM152 352H200V400C200 413 211 424 224 424S248 413 248 400V352H296C309 352 320 341 320 328S309 304 296 304H248V256C248 243 237 232 224 232S200 243 200 256V304H152C139 304 128 315 128 328S139 352 152 352Z"]
  };
  var faCalendarRange = {
    prefix: 'far',
    iconName: 'calendar-range',
    icon: [448, 512, [], "e0ba", "M216 312H328C341 312 352 301 352 288V288C352 275 341 264 328 264H216C203 264 192 275 192 288C192 301 203 312 216 312ZM341 352H299C293 352 288 357 288 363V405C288 411 293 416 299 416H341C347 416 352 411 352 405V363C352 357 347 352 341 352ZM107 320H149C155 320 160 315 160 309V267C160 261 155 256 149 256H107C101 256 96 261 96 267V309C96 315 101 320 107 320ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448ZM120 408H232C245 408 256 397 256 384V384C256 371 245 360 232 360H120C107 360 96 371 96 384C96 397 107 408 120 408Z"]
  };
  var faCalendarStar = {
    prefix: 'far',
    iconName: 'calendar-star',
    icon: [448, 512, [], "f736", "M172 353L163 403C162 412 171 419 179 415L224 391L269 415C277 419 286 412 285 403L276 353L312 318C319 311 315 300 306 299L256 292L234 246C230 238 218 238 214 246L192 292L141 299C132 300 129 311 135 318L172 353ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendarWeek = {
    prefix: 'far',
    iconName: 'calendar-week',
    icon: [448, 512, [], "f784", "M112 352H336C345 352 352 345 352 336V272C352 263 345 256 336 256H112C103 256 96 263 96 272V336C96 345 103 352 112 352ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendarXmark = {
    prefix: 'far',
    iconName: 'calendar-xmark',
    icon: [448, 512, [], "f273", "M156 396C166 405 181 405 190 396L224 362L258 396C267 405 283 405 292 396C301 387 301 371 292 362L258 328L292 294C301 285 301 269 292 260S267 251 258 260L224 294L190 260C181 251 165 251 156 260S147 285 156 294L190 328L156 362C147 371 147 386 156 396ZM384 64H344V24C344 11 333 0 320 0S296 11 296 24V64H152V24C152 11 141 0 128 0S104 11 104 24V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V192H400V448Z"]
  };
  var faCalendars = {
    prefix: 'far',
    iconName: 'calendars',
    icon: [512, 512, [], "e0bb", "M48 432V160C22 160 0 182 0 208V448C0 483 29 512 64 512H368C394 512 416 490 416 464H80C62 464 48 450 48 432ZM448 64H408V24C408 11 397 0 384 0S360 11 360 24V64H248V24C248 11 237 0 224 0S200 11 200 24V64H160C125 64 96 93 96 128V352C96 387 125 416 160 416H448C483 416 512 387 512 352V128C512 93 483 64 448 64ZM464 352C464 361 457 368 448 368H160C151 368 144 361 144 352V192H464V352Z"]
  };
  var faCamcorder = {
    prefix: 'far',
    iconName: 'camcorder',
    icon: [576, 512, [], "f8a8", "M312 240H104C91 240 80 251 80 264S91 288 104 288H312C325 288 336 277 336 264S325 240 312 240ZM558 182C546 175 532 174 519 180L416 227V224C416 189 387 160 352 160H96V120C96 98 114 80 136 80H296C309 80 320 69 320 56S309 32 296 32H136C87 32 48 71 48 120V162C20 169 0 194 0 224V416C0 451 29 480 64 480H352C387 480 416 451 416 416V413L519 460C525 463 530 464 536 464C544 464 551 462 558 458C569 450 576 438 576 424V216C576 202 569 190 558 182ZM368 416C368 425 361 432 352 432H64C55 432 48 425 48 416V224C48 215 55 208 64 208H352C361 208 368 215 368 224V416ZM528 412L416 360V280L528 228V412Z"]
  };
  var faCamera = {
    prefix: 'far',
    iconName: 'camera',
    icon: [512, 512, [], "f030", "M448 96H376L368 74C358 49 334 32 308 32H204C178 32 154 49 144 73L136 96H64C29 96 0 125 0 160V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V160C48 151 55 144 64 144H169L181 113L189 90C192 84 198 80 204 80H308C314 80 320 84 323 90L331 113L343 144H448C457 144 464 151 464 160V416ZM256 176C194 176 144 226 144 288C144 350 194 400 256 400S368 350 368 288C368 226 318 176 256 176ZM256 352C221 352 192 323 192 288C192 253 221 224 256 224S320 253 320 288C320 323 291 352 256 352Z"]
  };
  var faCameraCctv = {
    prefix: 'far',
    iconName: 'camera-cctv',
    icon: [576, 512, [], "f8ac", "M517 169L139 2C135 1 131 0 127 0C116 0 105 6 100 16L4 183C0 191 -1 201 2 210C5 219 12 226 21 229L185 297L143 408H48V376C48 363 37 352 24 352S0 363 0 376V488C0 501 11 512 24 512S48 501 48 488V456H160C170 456 179 450 182 441L230 315L305 347C309 348 313 349 316 349C322 349 328 347 333 344L522 225C545 212 542 178 517 169ZM315 299L55 191L134 52L471 201L315 299ZM575 283C573 279 570 276 566 274L530 258L392 345L512 397C520 401 530 397 534 389L575 296C576 292 576 287 575 283Z"]
  };
  var faCameraMovie = {
    prefix: 'far',
    iconName: 'camera-movie',
    icon: [576, 512, [], "f8a9", "M558 262C546 255 532 254 519 260L435 298C424 282 405 272 384 272H24C11 272 0 283 0 296C0 309 11 320 24 320H66C65 325 64 330 64 336V448C64 483 93 512 128 512H384C410 512 433 496 443 473L519 508C525 511 530 512 536 512C544 512 551 510 558 506C569 498 576 486 576 472V296C576 282 569 270 558 262ZM400 448C400 457 393 464 384 464H128C119 464 112 457 112 448V336C112 327 119 320 128 320H384C393 320 400 327 400 336V448ZM528 459L448 423V345L528 309V459ZM152 240H344C410 240 464 186 464 120C464 54 410 0 344 0C305 0 270 19 248 49C226 19 191 0 152 0C86 0 32 54 32 120C32 186 86 240 152 240ZM344 48C384 48 416 80 416 120S384 192 344 192S272 160 272 120S304 48 344 48ZM152 48C192 48 224 80 224 120S192 192 152 192S80 160 80 120S112 48 152 48Z"]
  };
  var faCameraPolaroid = {
    prefix: 'far',
    iconName: 'camera-polaroid',
    icon: [576, 512, [], "f8aa", "M288 128C244 128 208 164 208 208S244 288 288 288S368 252 368 208C368 164 332 128 288 128ZM288 240C270 240 256 226 256 208S270 176 288 176S320 190 320 208S306 240 288 240ZM565 336L512 256V96C512 61 483 32 448 32H128C93 32 64 61 64 96V256L11 336C4 346 0 359 0 371V416C0 451 29 480 64 480H512C547 480 576 451 576 416V371C576 359 572 346 565 336ZM112 270V96C112 87 119 80 128 80H448C457 80 464 87 464 96V270L508 336H68L112 270ZM512 432H64C55 432 48 425 48 416V384H528V416C528 425 521 432 512 432ZM424 112H392C388 112 384 116 384 120V152C384 156 388 160 392 160H424C428 160 432 156 432 152V120C432 116 428 112 424 112Z"]
  };
  var faCameraRetro = {
    prefix: 'far',
    iconName: 'camera-retro',
    icon: [512, 512, [], "f083", "M448 32H271C261 32 251 34 242 39L192 64H160V48C160 39 153 32 144 32H80C71 32 64 39 64 48V64C29 64 0 93 0 128V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V240H133C130 250 128 261 128 272C128 343 185 400 256 400C327 400 384 343 384 272C384 261 382 250 379 240H464V416ZM176 272C176 228 212 192 256 192S336 228 336 272C336 316 300 352 256 352S176 316 176 272ZM464 192H355C332 163 296 144 256 144C216 144 180 163 157 192H48V128C48 119 55 112 64 112H203L272 80H448C457 80 464 87 464 96V192Z"]
  };
  var faCameraSecurity = {
    prefix: 'far',
    iconName: 'camera-security',
    icon: [448, 512, [], "f8fe", "M384 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H105L68 475C63 482 63 492 67 500C71 507 79 512 88 512H360C369 512 377 507 381 500C385 492 385 482 380 475L343 416H384C419 416 448 387 448 352V64C448 29 419 0 384 0ZM132 464L162 416H286L316 464H132ZM400 352C400 361 393 368 384 368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H384C393 48 400 55 400 64V352ZM224 96C162 96 112 146 112 208S162 320 224 320S336 270 336 208S286 96 224 96ZM224 272C189 272 160 243 160 208S189 144 224 144C259 144 288 173 288 208S259 272 224 272Z"]
  };
  var faCameraViewfinder = {
    prefix: 'far',
    iconName: 'camera-viewfinder',
    icon: [512, 512, [], "e0bc", "M112 176V352C112 370 126 384 144 384H368C386 384 400 370 400 352V176C400 158 386 144 368 144H332L326 128C322 118 313 112 303 112H209C199 112 190 118 186 128L180 144H144C126 144 112 158 112 176ZM160 192H213L225 161L225 160H287L287 161L299 192H352V336H160V192ZM136 432H48V344C48 331 37 320 24 320H24C11 320 0 331 0 344V448C0 466 14 480 32 480H136C149 480 160 469 160 456V456C160 443 149 432 136 432ZM24 192L24 192C37 192 48 181 48 168V80H136C149 80 160 69 160 56V56C160 43 149 32 136 32H32C14 32 0 46 0 64V168C0 181 11 192 24 192ZM480 32H376C363 32 352 43 352 56V56C352 69 363 80 376 80H464V168C464 181 475 192 488 192L488 192C501 192 512 181 512 168V64C512 46 498 32 480 32ZM488 320L488 320C475 320 464 331 464 344V432H376C363 432 352 443 352 456V456C352 469 363 480 376 480H480C498 480 512 466 512 448V344C512 331 501 320 488 320ZM256 224C234 224 216 242 216 264C216 286 234 304 256 304C278 304 296 286 296 264C296 242 278 224 256 224Z"]
  };
  var faCameraWeb = {
    prefix: 'far',
    iconName: 'camera-web',
    icon: [448, 512, [], "f832", "M224 96C158 96 104 150 104 216C104 282 158 336 224 336C290 336 344 282 344 216C344 150 290 96 224 96ZM224 288C184 288 152 256 152 216S184 144 224 144S296 176 296 216S264 288 224 288ZM348 393C403 354 440 289 440 216C440 97 343 0 224 0C105 0 8 97 8 216C8 289 45 354 100 393L37 473C31 480 30 490 34 498C38 507 47 512 56 512H392C401 512 410 507 414 498C418 490 417 480 411 473L348 393ZM105 464L143 416C168 426 195 432 224 432S280 426 305 416L343 464H105ZM224 384C131 384 56 309 56 216C56 123 131 48 224 48C317 48 392 123 392 216C392 309 317 384 224 384Z"]
  };
  var faCameraWebSlash = {
    prefix: 'far',
    iconName: 'camera-web-slash',
    icon: [640, 512, [], "f833", "M631 469L485 355C517 317 536 269 536 216C536 97 439 0 320 0C248 0 185 35 146 89L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM372 266L259 178C272 158 294 144 320 144C360 144 392 176 392 216C392 235 384 253 372 266ZM409 296C428 274 440 247 440 216C440 150 386 96 320 96C279 96 243 117 222 148L184 119C214 76 264 48 320 48C413 48 488 123 488 216C488 258 472 296 447 325L409 296ZM201 464L239 416C264 426 291 432 320 432C350 432 379 426 406 414L360 379C347 382 334 384 320 384C227 384 152 309 152 216C152 216 152 216 152 215L107 180C105 192 104 204 104 216C104 289 141 354 196 393L133 473C127 480 126 490 130 498C134 507 143 512 152 512H530L469 464H201Z"]
  };
  var faCampfire = {
    prefix: 'far',
    iconName: 'campfire',
    icon: [512, 512, [], "f6ba", "M256 320C336 320 400 255 400 176C400 143 367 74 320 32C307 44 295 57 284 70C266 46 245 22 220 0C157 57 112 131 112 176C112 255 176 320 256 320ZM220 68C229 78 238 88 245 98L282 147L318 103C340 133 352 165 352 176C352 229 309 272 256 272C203 272 160 229 160 176C160 157 181 113 220 68ZM496 465L327 404L496 343C509 338 515 324 511 312C506 299 492 293 480 297L256 378L32 297C20 293 6 299 1 312C-3 324 3 338 16 343L186 404L16 465C3 470 -3 484 1 496C5 506 14 512 24 512C27 512 29 512 32 511L256 430L480 511C483 512 485 512 488 512C498 512 507 506 511 496C515 484 509 470 496 465Z"]
  };
  var faCampground = {
    prefix: 'far',
    iconName: 'campground',
    icon: [576, 512, [], "f6bb", "M563 415L319 113L379 39C387 29 385 14 375 5C365 -3 350 -1 341 9L288 75L235 9C226 -1 211 -3 201 5C191 14 189 29 197 39L257 113L13 415C5 426 0 439 0 453C0 485 27 512 59 512H517C549 512 576 485 576 453C576 439 571 426 563 415ZM186 464L288 328L390 464H186ZM517 464H450L307 274C298 262 278 262 269 274L126 464H59C53 464 48 459 48 453C48 450 49 447 51 445L288 151L525 445C527 447 528 450 528 453C528 459 523 464 517 464Z"]
  };
  var faCandleHolder = {
    prefix: 'far',
    iconName: 'candle-holder',
    icon: [448, 512, [], "f6bc", "M372 368C348 369 327 384 315 404C301 427 302 447 308 464H272V272C272 246 250 224 224 224H96C70 224 48 246 48 272V464C43 464 29 464 24 464C11 464 0 475 0 488C0 501 11 512 24 512C24 512 294 512 373 512C408 512 440 489 447 455C456 407 418 366 372 368ZM224 464H96V272H128V328C128 341 139 352 152 352S176 341 176 328V272H224V464ZM376 464C363 464 352 453 352 440S363 416 376 416S400 427 400 440S389 464 376 464ZM160 192C206 192 238 159 238 113C238 83 205 38 160 0C114 38 82 83 82 113C82 159 114 192 160 192ZM160 66C180 88 190 106 190 113C190 124 186 144 160 144S130 124 130 113C130 106 140 88 160 66Z"]
  };
  var faCandyCane = {
    prefix: 'far',
    iconName: 'candy-cane',
    icon: [512, 512, [], "f786", "M497 95C469 37 411 0 346 0C317 0 287 8 261 23L236 39C214 52 207 80 220 102L251 154C263 174 290 183 314 169L339 154C355 144 370 169 354 178L22 375C12 381 4 391 1 403C-2 415 0 428 7 438L37 490C46 503 61 512 77 512C85 512 93 510 100 506L426 312C502 267 533 171 497 95ZM212 383L156 352L220 313L277 345L212 383ZM324 317L268 285L327 250L383 281L324 317ZM395 128C392 124 388 120 384 117V54C414 64 439 86 454 116C456 120 457 124 458 128H395V128ZM336 49V105C320 108 317 112 291 127L262 79C290 63 305 51 336 49ZM108 380L165 412L78 463L49 415L108 380ZM427 251L375 221C393 211 404 198 408 176H463C460 203 447 230 427 251Z"]
  };
  var faCandyCorn = {
    prefix: 'far',
    iconName: 'candy-corn',
    icon: [640, 512, [], "f6bd", "M480 0C314 2 315 39 322 73C352 224 416 416 480 416H480C544 416 608 224 638 72C645 39 646 2 480 0ZM480 366C468 355 451 326 432 282C464 280 496 280 528 282C509 326 492 355 480 366ZM591 63C588 79 584 95 581 110C517 102 443 102 379 110C376 95 372 79 369 63C369 62 369 62 369 61C379 57 408 49 480 48C552 49 581 57 591 61C591 62 591 62 591 63ZM85 206C-31 324 -3 350 24 369C153 454 334 545 379 500H379C424 455 334 274 248 145C229 118 203 90 85 206ZM92 355C78 347 65 338 51 329C50 329 50 328 49 328C54 318 68 292 119 240C171 189 197 175 207 170C207 171 208 171 208 172C217 186 226 199 234 213C183 252 131 304 92 355ZM318 371C336 416 345 449 343 464C328 466 295 457 250 439C271 415 294 392 318 371Z"]
  };
  var faCannabis = {
    prefix: 'far',
    iconName: 'cannabis',
    icon: [512, 512, [], "f55f", "M491 327C489 326 475 318 452 311C496 247 510 184 511 181C514 168 510 155 500 145C491 136 476 133 466 135C465 135 408 147 347 186C336 98 297 32 288 17C274 -4 239 -5 223 18C215 32 176 98 166 186C106 148 50 136 47 135L39 134C29 134 19 138 11 146C2 155 -2 168 1 181C2 184 16 247 60 311C38 318 23 326 21 327C8 334 0 347 0 361C0 375 8 388 20 395C21 395 68 421 132 425C131 428 131 429 131 430C126 443 130 458 140 469C150 479 165 483 178 478C184 477 208 463 232 449V489C232 502 243 513 256 513S280 502 280 489V449C304 463 328 477 334 478C337 479 341 480 345 480C355 480 365 476 372 469C382 459 386 443 382 431C382 430 381 428 380 425C444 421 491 395 491 395C504 388 512 375 512 361C512 347 504 334 491 327ZM359 378C354 378 349 378 344 378L304 377L322 413C323 415 325 418 326 420C314 414 299 405 285 396L280 393V312C280 299 269 288 256 288S232 299 232 312V393L227 396C213 405 198 414 186 420C187 418 189 416 190 413L209 377L168 378C163 378 158 378 153 378C115 378 82 369 63 361C73 357 88 352 106 349L146 341L119 309C80 263 60 212 52 187C77 194 127 213 172 249L211 281V227C211 150 241 85 256 57C271 85 301 150 301 227V281L340 249C386 212 436 194 460 186C452 211 432 263 393 309L366 341L406 349C424 352 439 357 449 361C430 368 397 378 359 378Z"]
  };
  var faCapsules = {
    prefix: 'far',
    iconName: 'capsules',
    icon: [576, 512, [], "f46b", "M554 301L420 121C383 72 313 62 263 99C244 113 231 132 224 153V144C224 82 174 32 112 32S0 82 0 144V368C0 430 50 480 112 480S224 430 224 368V223C228 234 233 245 240 255L374 435C411 485 481 495 531 458C581 421 591 351 554 301ZM176 256H48V144C48 59 176 59 176 144V256ZM346 316L279 227C228 159 331 82 381 150L448 240L346 316Z"]
  };
  var faCar = {
    prefix: 'far',
    iconName: 'car',
    icon: [512, 512, [], "f1b9", "M112 256C94 256 80 270 80 288C80 306 94 320 112 320S144 306 144 288C144 270 130 256 112 256ZM400 256C382 256 368 270 368 288C368 306 382 320 400 320S432 306 432 288C432 270 418 256 400 256ZM463 189L422 87C409 54 377 32 341 32H171C135 32 103 54 90 87L49 189C20 205 0 236 0 272V448C0 466 14 480 32 480S64 466 64 448V400H448V448C448 466 462 480 480 480S512 466 512 448V272C512 236 492 205 463 189ZM134 105C140 90 155 80 171 80H341C357 80 372 90 378 105L406 176H106L134 105ZM464 352H48V272C48 246 70 224 96 224H416C442 224 464 246 464 272V352Z"]
  };
  var faCarBattery = {
    prefix: 'far',
    iconName: 'car-battery',
    icon: [512, 512, [], "f5df", "M448 96H432V80C432 71 425 64 416 64H320C311 64 304 71 304 80V96H208V80C208 71 201 64 192 64H96C87 64 80 71 80 80V96H64C29 96 0 125 0 160V384C0 419 29 448 64 448H448C483 448 512 419 512 384V160C512 125 483 96 448 96ZM464 384C464 393 457 400 448 400H64C55 400 48 393 48 384V160C48 151 55 144 64 144H448C457 144 464 151 464 160V384ZM192 236H96C85 236 76 245 76 256S85 276 96 276H192C203 276 212 267 212 256S203 236 192 236ZM416 236H388V208C388 197 379 188 368 188S348 197 348 208V236H320C309 236 300 245 300 256S309 276 320 276H348V304C348 315 357 324 368 324S388 315 388 304V276H416C427 276 436 267 436 256S427 236 416 236Z"]
  };
  var faCarBuilding = {
    prefix: 'far',
    iconName: 'car-building',
    icon: [640, 512, [], "f859", "M144 192H112C103 192 96 199 96 208V240C96 249 103 256 112 256H144C153 256 160 249 160 240V208C160 199 153 192 144 192ZM144 288H112C103 288 96 295 96 304V336C96 345 103 352 112 352H144C153 352 160 345 160 336V304C160 295 153 288 144 288ZM208 96C199 96 192 103 192 112V144C192 153 199 160 208 160H240C249 160 256 153 256 144V112C256 103 249 96 240 96H208ZM144 96H112C103 96 96 103 96 112V144C96 153 103 160 112 160H144C153 160 160 153 160 144V112C160 103 153 96 144 96ZM304 56V104C304 117 315 128 328 128S352 117 352 104V56C352 25 327 0 296 0H56C25 0 0 25 0 56V456C0 469 11 480 24 480S48 469 48 456V56C48 52 52 48 56 48H296C300 48 304 52 304 56ZM256 212V208C256 199 249 192 240 192H208C199 192 192 199 192 208V240C192 249 199 256 208 256H238L256 212ZM602 284L571 205C560 178 534 160 504 160H360C330 160 304 178 293 205L262 284C239 302 224 329 224 360V480C224 498 238 512 256 512S288 498 288 480V448H576V480C576 498 590 512 608 512S640 498 640 480V360C640 329 625 302 602 284ZM338 223C342 214 350 208 360 208H504C514 208 522 214 526 223L543 264H321L338 223ZM592 400H272V360C272 334 294 312 320 312H544C570 312 592 334 592 360V400ZM528 336C515 336 504 347 504 360C504 373 515 384 528 384S552 373 552 360C552 347 541 336 528 336ZM336 336C323 336 312 347 312 360C312 373 323 384 336 384S360 373 360 360C360 347 349 336 336 336Z"]
  };
  var faCarBump = {
    prefix: 'far',
    iconName: 'car-bump',
    icon: [576, 512, [], "f5e0", "M356 184C340 190 333 208 339 224C346 239 364 247 379 240C395 234 403 216 396 200C390 184 372 177 356 184ZM100 289C85 296 77 314 84 329C90 345 108 352 124 346C140 339 147 321 141 306C134 290 116 283 100 289ZM111 434L451 294L469 336C475 352 493 359 509 353C525 346 532 329 526 313L461 157C448 125 419 105 387 101L314 26C290 1 253 -7 221 6L71 69C39 82 18 113 19 148L20 252C0 278 -6 312 7 344L69 493C76 509 94 516 109 510C125 503 132 485 126 470L111 434ZM89 111L239 49C253 43 270 46 281 58L332 110L66 220L65 147C65 131 74 117 89 111ZM79 398L49 327C40 303 51 276 74 267L358 149C382 140 409 151 419 174L448 245L79 398ZM568 470L523 429C483 392 413 392 373 429L328 470C318 479 317 495 326 504C335 514 351 515 360 506L405 464C427 444 469 444 491 464L536 506C540 510 546 512 552 512C558 512 565 509 570 504C579 495 578 479 568 470Z"]
  };
  var faCarBus = {
    prefix: 'far',
    iconName: 'car-bus',
    icon: [640, 512, [], "f85a", "M48 328V224H251L264 193C266 187 269 181 273 176H216V49C285 53 336 73 336 99V131C344 129 351 128 360 128H384V99C384 26 281 0 192 0S0 26 0 99V328C0 359 25 384 56 384H64V416C64 434 78 448 96 448S128 434 128 416V384H192V352C192 347 192 342 193 336H56C52 336 48 333 48 328ZM48 99C48 73 99 53 168 49V176H48V99ZM602 284L571 205C560 178 534 160 504 160H360C330 160 304 178 293 205L262 284C239 302 224 329 224 360V480C224 498 238 512 256 512S288 498 288 480V448H576V480C576 498 590 512 608 512S640 498 640 480V360C640 329 625 302 602 284ZM338 223C342 214 350 208 360 208H504C514 208 522 214 526 223L543 264H321L338 223ZM592 400H272V360C272 334 294 312 320 312H544C570 312 592 334 592 360V400ZM336 336C323 336 312 347 312 360C312 373 323 384 336 384S360 373 360 360C360 347 349 336 336 336ZM528 336C515 336 504 347 504 360C504 373 515 384 528 384S552 373 552 360C552 347 541 336 528 336ZM80 280C80 293 91 304 104 304S128 293 128 280C128 267 117 256 104 256S80 267 80 280Z"]
  };
  var faCarCrash = {
    prefix: 'far',
    iconName: 'car-crash',
    icon: [640, 512, [], "f5e1", "M102 201L71 192L98 174C110 165 114 148 107 134L94 112L118 120C133 124 149 116 155 102L167 70L172 77C179 88 193 91 205 84C216 77 219 63 212 51L191 17C186 6 175 0 164 0C151 0 140 8 136 19L116 69L66 53C54 50 41 54 33 63C25 73 24 86 30 97L57 144L13 174C3 181 -2 194 1 206C4 218 13 227 23 229L90 247C92 248 94 248 96 248C107 248 116 241 119 230C123 218 115 204 102 201ZM540 289C524 283 506 290 499 306C493 321 500 339 516 346C532 352 550 345 556 329C563 314 555 296 540 289ZM620 252L621 148C622 113 601 82 569 69L419 6C387 -7 350 1 326 26L253 101C221 105 192 125 179 157L114 313C108 329 115 346 131 353C147 359 165 352 171 336L189 294L529 434L514 470C508 485 515 503 531 510C546 516 564 509 571 493L633 344C646 312 640 278 620 252ZM359 58C370 46 387 43 401 49L551 111C566 117 575 131 575 147L574 220L308 110L359 58ZM591 327L561 398L192 245L221 174C231 151 258 140 282 149L566 267C589 276 600 303 591 327ZM284 184C268 177 250 185 244 200C237 216 245 234 261 240C276 247 294 239 301 224C307 208 300 190 284 184Z"]
  };
  var faCarGarage = {
    prefix: 'far',
    iconName: 'car-garage',
    icon: [640, 512, [], "f5e2", "M224 333C211 333 200 344 200 357C200 370 211 381 224 381S248 370 248 357C248 344 237 333 224 333ZM416 333C403 333 392 344 392 357C392 370 403 381 416 381S440 370 440 357C440 344 429 333 416 333ZM490 282L475 243L459 202C448 175 422 157 392 157H248C218 157 192 175 181 202L165 243L150 282C127 299 112 326 112 357V477C112 495 126 509 144 509S176 495 176 477V445H464V477C464 495 478 509 496 509S528 495 528 477V357C528 326 513 299 490 282ZM226 220C230 211 238 205 248 205H392C402 205 411 211 414 220L431 261H209L226 220ZM480 397H160V357C160 331 182 309 208 309H432C458 309 480 331 480 357V397ZM627 160L331 0C324 -4 316 -4 309 0L13 160C1 166 -3 181 3 193S24 209 35 202L320 48L605 202C608 204 612 205 616 205C625 205 633 201 637 193C643 181 639 166 627 160Z"]
  };
  var faCarRear = {
    prefix: 'far',
    iconName: 'car-rear',
    icon: [512, 512, [], "f5de", "M463 189L422 87C409 54 377 32 341 32H171C135 32 103 54 90 87L49 189C20 205 0 236 0 272V336C0 360 13 380 32 391V448C32 466 46 480 64 480S96 466 96 448V400H416V448C416 466 430 480 448 480S480 466 480 448V391C499 380 512 360 512 336V272C512 236 492 205 463 189ZM134 105C140 90 155 80 171 80H341C357 80 372 90 378 105L406 176H106L134 105ZM448 352H320V320C320 302 306 288 288 288H224C206 288 192 302 192 320V352H64C55 352 48 345 48 336V304H88C101 304 112 293 112 280S101 256 88 256H51C58 237 75 224 96 224H416C437 224 454 237 461 256H424C411 256 400 267 400 280S411 304 424 304H464V336C464 345 457 352 448 352Z"]
  };
  var faCarSide = {
    prefix: 'far',
    iconName: 'car-side',
    icon: [640, 512, [], "f5e4", "M520 224L411 88C399 73 381 64 361 64H155C129 64 106 80 96 104L48 226C21 233 0 258 0 288V400C0 418 14 432 32 432H66C73 477 112 512 160 512S247 477 254 432H386C393 477 432 512 480 512S567 477 574 432H608C626 432 640 418 640 400V344C640 278 586 224 520 224ZM272 112H361C366 112 371 114 374 118L459 224H272V112ZM140 122C143 116 149 112 155 112H224V224H100L140 122ZM160 464C134 464 112 442 112 416S134 368 160 368S208 390 208 416S186 464 160 464ZM480 464C454 464 432 442 432 416S454 368 480 368S528 390 528 416S506 464 480 464ZM592 384H570C557 347 522 320 480 320S403 347 390 384H250C237 347 202 320 160 320S83 347 70 384H48V288C48 279 55 272 64 272H520C560 272 592 304 592 344V384Z"]
  };
  var faCarTilt = {
    prefix: 'far',
    iconName: 'car-tilt',
    icon: [640, 512, [], "f5e5", "M616 464H520L569 344C582 312 576 278 556 252L557 148C558 113 537 82 505 69L355 6C323 -7 286 1 262 26L189 101C157 105 128 125 115 157L50 313C44 328 51 346 67 353C83 359 101 352 107 336L125 294L465 434L453 464H24C11 464 0 475 0 488C0 501 11 512 24 512H616C629 512 640 501 640 488C640 475 629 464 616 464ZM295 58C306 46 323 43 337 49L487 111C502 117 511 131 511 147L510 220L244 110L295 58ZM128 245L157 174C167 151 194 140 218 149L502 266C525 276 536 303 526 327L497 398L128 245ZM476 289C460 283 442 290 435 306C429 321 436 339 452 346C468 352 486 345 492 329C499 313 491 295 476 289ZM220 183C204 177 186 184 180 200S181 234 197 240C212 247 230 239 237 224S236 190 220 183Z"]
  };
  var faCarWash = {
    prefix: 'far',
    iconName: 'car-wash',
    icon: [448, 512, [], "f5e6", "M384 128C407 128 427 109 427 85C427 62 384 0 384 0S341 62 341 85C341 109 361 128 384 128ZM64 128C87 128 107 109 107 85C107 62 64 0 64 0S21 62 21 85C21 109 41 128 64 128ZM224 128C247 128 267 109 267 85C267 62 224 0 224 0S181 62 181 85C181 109 201 128 224 128ZM394 284L379 246L363 205C352 178 326 160 296 160H152C122 160 96 178 85 205L69 246L54 284C31 302 16 329 16 360V480C16 498 30 512 48 512S80 498 80 480V448H368V480C368 498 382 512 400 512S432 498 432 480V360C432 329 417 302 394 284ZM130 223C134 214 142 208 152 208H296C306 208 314 214 318 223L335 264H113L130 223ZM384 400H64V360C64 334 86 312 112 312H336C362 312 384 334 384 360V400ZM128 336C115 336 104 347 104 360C104 373 115 384 128 384S152 373 152 360C152 347 141 336 128 336ZM320 336C307 336 296 347 296 360C296 373 307 384 320 384S344 373 344 360C344 347 333 336 320 336Z"]
  };
  var faCarWrench = {
    prefix: 'far',
    iconName: 'car-wrench',
    icon: [512, 512, [], "f5e3", "M426 284L411 246L395 205C384 178 358 160 328 160H184C154 160 128 178 117 205L101 246L86 284C63 302 48 329 48 360V480C48 498 62 512 80 512S112 498 112 480V448H400V480C400 498 414 512 432 512S464 498 464 480V360C464 329 449 302 426 284ZM162 223C166 214 174 208 184 208H328C338 208 346 214 350 223L367 264H145L162 223ZM416 400H96V360C96 334 118 312 144 312H368C394 312 416 334 416 360V400ZM506 112H448L426 80L448 48H506C511 48 514 43 511 39C497 16 472 0 442 0C410 0 382 20 369 48H143C132 23 109 5 81 1C47 -4 17 13 1 39C-2 43 1 48 6 48H64L86 80L64 112H6C1 112 -2 117 1 121C15 144 40 160 70 160C102 160 130 140 143 112H369C380 137 403 155 431 159C465 164 495 147 511 121C514 117 511 112 506 112ZM160 336C147 336 136 347 136 360C136 373 147 384 160 384S184 373 184 360C184 347 173 336 160 336ZM352 336C339 336 328 347 328 360C328 373 339 384 352 384S376 373 376 360C376 347 365 336 352 336Z"]
  };
  var faCaravan = {
    prefix: 'far',
    iconName: 'caravan',
    icon: [640, 512, [], "f8ff", "M616 368H576V192C576 104 504 32 416 32H96C43 32 0 75 0 128V320C0 373 43 416 96 416C96 469 139 512 192 512S288 469 288 416H616C629 416 640 405 640 392V392C640 379 629 368 616 368ZM192 464C166 464 144 442 144 416S166 368 192 368S240 390 240 416S218 464 192 464ZM432 240C423 240 416 247 416 256C416 265 423 272 432 272V368H368V176H432V240ZM528 368H480V168C480 146 462 128 440 128H360C338 128 320 146 320 168V368H275C258 339 227 320 192 320S126 339 109 368H96C70 368 48 346 48 320V128C48 102 70 80 96 80H416C478 80 528 130 528 192V368ZM256 128H128C110 128 96 142 96 160V224C96 242 110 256 128 256H256C274 256 288 242 288 224V160C288 142 274 128 256 128Z"]
  };
  var faCaravanSimple = {
    prefix: 'far',
    iconName: 'caravan-simple',
    icon: [640, 512, [], "e000", "M416 128H352C334 128 320 142 320 160V224C320 242 334 256 352 256H416C434 256 448 242 448 224V160C448 142 434 128 416 128ZM616 368H576V192C576 104 504 32 416 32H96C43 32 0 75 0 128V320C0 373 43 416 96 416C96 469 139 512 192 512S288 469 288 416H616C629 416 640 405 640 392V392C640 379 629 368 616 368ZM192 464C166 464 144 442 144 416S166 368 192 368S240 390 240 416S218 464 192 464ZM528 368H275C258 339 227 320 192 320S126 339 109 368H96C70 368 48 346 48 320V128C48 102 70 80 96 80H416C478 80 528 130 528 192V368ZM256 128H128C110 128 96 142 96 160V224C96 242 110 256 128 256H256C274 256 288 242 288 224V160C288 142 274 128 256 128Z"]
  };
  var faCaretDown = {
    prefix: 'far',
    iconName: 'caret-down',
    icon: [320, 512, [], "f0d7", "M272 176H48C5 176 -16 228 14 258L126 370C145 389 175 389 194 370L306 258C336 228 315 176 272 176ZM160 336L48 224H272L160 336Z"]
  };
  var faCaretLeft = {
    prefix: 'far',
    iconName: 'caret-left',
    icon: [256, 512, [], "f0d9", "M208 368V144C208 101 156 80 126 110L14 222C-5 241 -5 271 14 290L126 402C156 432 208 411 208 368ZM48 256L160 144V368L48 256Z"]
  };
  var faCaretRight = {
    prefix: 'far',
    iconName: 'caret-right',
    icon: [256, 512, [], "f0da", "M0 144V368C0 411 52 432 82 402L194 290C213 271 213 241 194 222L82 110C52 80 0 101 0 144ZM160 256L48 368V144L160 256Z"]
  };
  var faCaretUp = {
    prefix: 'far',
    iconName: 'caret-up',
    icon: [320, 512, [], "f0d8", "M48 336H272C315 336 336 284 306 254L194 142C175 123 145 123 126 142L14 254C-16 284 5 336 48 336ZM160 176L272 288H48L160 176Z"]
  };
  var faCarrot = {
    prefix: 'far',
    iconName: 'carrot',
    icon: [512, 512, [], "f787", "M370 142C392 95 381 38 334 0C290 37 278 90 297 136C283 131 269 128 254 128C206 128 160 155 138 201L2 478C-1 485 -1 492 2 499C7 507 15 512 23 512C27 512 30 511 34 510L311 374C336 362 358 341 371 314C387 282 388 247 377 216C423 234 475 222 512 178C473 131 417 120 370 142ZM328 293C320 310 307 323 290 331L233 359L209 335C200 326 184 326 175 335C166 344 166 360 175 369L187 381L77 435L173 238L207 273C212 278 218 280 224 280C230 280 236 278 241 273C250 264 250 248 241 239L199 198C214 185 233 176 254 176C267 176 279 179 290 184C310 194 324 211 332 231C339 252 337 274 328 293Z"]
  };
  var faCars = {
    prefix: 'far',
    iconName: 'cars',
    icon: [640, 512, [], "f85b", "M88 200C88 213 99 224 112 224S136 213 136 200C136 187 125 176 112 176S88 187 88 200ZM245 240H48V200C48 174 70 152 96 152H294C312 137 335 128 360 128H382C381 127 380 125 378 124L347 45C336 18 310 0 280 0H136C106 0 80 18 69 45L38 124C15 142 0 169 0 200V320C0 338 14 352 32 352S64 338 64 320V288H215C221 280 227 272 235 265L245 240ZM114 63C118 54 126 48 136 48H280C290 48 298 54 302 63L319 104H97L114 63ZM336 336C323 336 312 347 312 360C312 373 323 384 336 384S360 373 360 360C360 347 349 336 336 336ZM528 336C515 336 504 347 504 360C504 373 515 384 528 384S552 373 552 360C552 347 541 336 528 336ZM602 284L571 205C560 178 534 160 504 160H360C330 160 304 178 293 205L262 284C239 302 224 329 224 360V480C224 498 238 512 256 512S288 498 288 480V448H576V480C576 498 590 512 608 512S640 498 640 480V360C640 329 625 302 602 284ZM338 223C342 214 350 208 360 208H504C514 208 522 214 526 223L543 264H321L338 223ZM592 400H272V360C272 334 294 312 320 312H544C570 312 592 334 592 360V400Z"]
  };
  var faCartArrowDown = {
    prefix: 'far',
    iconName: 'cart-arrow-down',
    icon: [576, 512, [], "f218", "M176 416C150 416 128 438 128 464S150 512 176 512S224 490 224 464S202 416 176 416ZM319 201C324 206 330 208 336 208S348 206 353 201L417 137C426 128 426 112 417 103S392 94 383 103L360 126V24C360 11 349 0 336 0S312 11 312 24V126L289 103C280 94 264 94 255 103S246 128 255 137L319 201ZM464 416C438 416 416 438 416 464S438 512 464 512S512 490 512 464S490 416 464 416ZM570 45C563 37 554 32 544 32H448V80H523L477 240H162L131 80H224V32H122L120 20C117 8 108 0 96 0H24C11 0 0 11 0 24C0 37 11 48 24 48H76L136 364C139 376 148 384 160 384H488C501 384 512 373 512 360C512 347 501 336 488 336H180L171 288H489C503 288 516 279 520 265L575 73C578 63 576 53 570 45Z"]
  };
  var faCartFlatbed = {
    prefix: 'far',
    iconName: 'cart-flatbed',
    icon: [640, 512, [], "f474", "M616 400H144V64C144 29 115 0 80 0H24C11 0 0 11 0 24C0 37 11 48 24 48H72C85 48 96 59 96 72V416C96 434 110 448 128 448H163C161 453 160 458 160 464C160 490 182 512 208 512S256 490 256 464C256 458 255 453 253 448H451C449 453 448 458 448 464C448 490 470 512 496 512S544 490 544 464C544 458 543 453 541 448H616C629 448 640 437 640 424C640 411 629 400 616 400ZM256 352H544C579 352 608 323 608 288V96C608 61 579 32 544 32H256C221 32 192 61 192 96V288C192 323 221 352 256 352ZM240 96C240 87 247 80 256 80H336V192L400 160L464 192V80H544C553 80 560 87 560 96V288C560 297 553 304 544 304H256C247 304 240 297 240 288V96Z"]
  };
  var faCartFlatbedBoxes = {
    prefix: 'far',
    iconName: 'cart-flatbed-boxes',
    icon: [640, 512, [], "f475", "M616 400H144V64C144 29 115 0 80 0H24C11 0 0 11 0 24C0 37 11 48 24 48H72C85 48 96 59 96 72V416C96 434 110 448 128 448H163C161 453 160 458 160 464C160 490 182 512 208 512S256 490 256 464C256 458 255 453 253 448H451C449 453 448 458 448 464C448 490 470 512 496 512S544 490 544 464C544 458 543 453 541 448H616C629 448 640 437 640 424C640 411 629 400 616 400ZM256 352H368C383 352 397 347 408 338C419 347 433 352 448 352H544C579 352 608 323 608 288V240C608 209 586 184 558 177C559 172 560 166 560 160V112C560 77 531 48 496 48H448C437 48 427 51 418 56C406 41 388 32 368 32H256C221 32 192 61 192 96V288C192 323 221 352 256 352ZM432 112C432 103 439 96 448 96H496C505 96 512 103 512 112V160C512 169 505 176 496 176H448C439 176 432 169 432 160V112ZM432 240C432 231 439 224 448 224H544C553 224 560 231 560 240V288C560 297 553 304 544 304H448C439 304 432 297 432 288V240ZM240 96C240 87 247 80 256 80H368C377 80 384 87 384 96V288C384 297 377 304 368 304H256C247 304 240 297 240 288V96Z"]
  };
  var faCartFlatbedEmpty = {
    prefix: 'far',
    iconName: 'cart-flatbed-empty',
    icon: [640, 512, [], "f476", "M616 400H144V64C144 29 115 0 80 0H24C11 0 0 11 0 24C0 37 11 48 24 48H72C85 48 96 59 96 72V416C96 434 110 448 128 448H163C161 453 160 458 160 464C160 490 182 512 208 512S256 490 256 464C256 458 255 453 253 448H451C449 453 448 458 448 464C448 490 470 512 496 512S544 490 544 464C544 458 543 453 541 448H616C629 448 640 437 640 424C640 411 629 400 616 400Z"]
  };
  var faCartFlatbedSuitcase = {
    prefix: 'far',
    iconName: 'cart-flatbed-suitcase',
    icon: [640, 512, [], "f59d", "M256 352H544C579 352 608 323 608 288V160C608 125 579 96 544 96H496V64C496 29 467 0 432 0H368C333 0 304 29 304 64V96H256C221 96 192 125 192 160V288C192 323 221 352 256 352ZM512 144H544C553 144 560 151 560 160V288C560 297 553 304 544 304H512V144ZM352 64C352 55 359 48 368 48H432C441 48 448 55 448 64V96H352V64ZM336 144H464V304H336V144ZM240 160C240 151 247 144 256 144H288V304H256C247 304 240 297 240 288V160ZM616 400H144V64C144 29 115 0 80 0H24C11 0 0 11 0 24C0 37 11 48 24 48H72C85 48 96 59 96 72V416C96 434 110 448 128 448H163C161 453 160 458 160 464C160 490 182 512 208 512S256 490 256 464C256 458 255 453 253 448H451C449 453 448 458 448 464C448 490 470 512 496 512S544 490 544 464C544 458 543 453 541 448H616C629 448 640 437 640 424C640 411 629 400 616 400Z"]
  };
  var faCartPlus = {
    prefix: 'far',
    iconName: 'cart-plus',
    icon: [576, 512, [], "f217", "M176 416C150 416 128 438 128 464S150 512 176 512S224 490 224 464S202 416 176 416ZM272 112H312V152C312 165 323 176 336 176S360 165 360 152V112H400C413 112 424 101 424 88S413 64 400 64H360V24C360 11 349 0 336 0S312 11 312 24V64H272C259 64 248 75 248 88S259 112 272 112ZM570 45C563 37 554 32 544 32H480V80H523L477 240H162L131 80H192V32H122L120 20C117 8 108 0 96 0H24C11 0 0 11 0 24C0 37 11 48 24 48H76L136 364C139 376 148 384 160 384H488C501 384 512 373 512 360C512 347 501 336 488 336H180L171 288H489C503 288 516 279 520 265L575 73C578 63 576 53 570 45ZM464 416C438 416 416 438 416 464S438 512 464 512S512 490 512 464S490 416 464 416Z"]
  };
  var faCartShopping = {
    prefix: 'far',
    iconName: 'cart-shopping',
    icon: [576, 512, [], "f07a", "M176 416C150 416 128 438 128 464S150 512 176 512S224 490 224 464S202 416 176 416ZM464 416C438 416 416 438 416 464S438 512 464 512S512 490 512 464S490 416 464 416ZM570 45C563 37 554 32 544 32H122L120 20C117 8 108 0 96 0H24C11 0 0 11 0 24C0 37 11 48 24 48H76L136 364C139 376 148 384 160 384H488C501 384 512 373 512 360C512 347 501 336 488 336H180L171 288H489C503 288 516 279 520 265L575 73C578 63 576 53 570 45ZM477 240H162L131 80H523L477 240Z"]
  };
  var faCasetteBetamax = {
    prefix: 'far',
    iconName: 'casette-betamax',
    icon: [576, 512, [], "f8a4", "M352 384H464C482 384 496 370 496 352V240C496 222 482 208 464 208H352C334 208 320 222 320 240V352C320 370 334 384 352 384ZM368 256H448V336H368V256ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM528 416C528 425 521 432 512 432H64C55 432 48 425 48 416V160H528V416ZM184 400C241 400 288 353 288 296S241 192 184 192S80 239 80 296S127 400 184 400ZM184 240C215 240 240 265 240 296S215 352 184 352S128 327 128 296S153 240 184 240ZM184 320C197 320 208 309 208 296C208 283 197 272 184 272C171 272 160 283 160 296C160 309 171 320 184 320Z"]
  };
  var faCasetteVhs = {
    prefix: 'far',
    iconName: 'casette-vhs',
    icon: [576, 512, [], "f8ec", "M184 384H392C441 384 480 345 480 296S441 208 392 208H184C135 208 96 247 96 296S135 384 184 384ZM400 264C418 264 432 278 432 296S418 328 400 328V264ZM224 256H352V336H224V256ZM176 264V328C158 328 144 314 144 296S158 264 176 264ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM528 416C528 425 521 432 512 432H64C55 432 48 425 48 416V160H528V416Z"]
  };
  var faCashRegister = {
    prefix: 'far',
    iconName: 'cash-register',
    icon: [512, 512, [], "f788", "M232 256C232 247 225 240 216 240H200C191 240 184 247 184 256V272C184 281 191 288 200 288H216C225 288 232 281 232 272V256ZM168 304H152C143 304 136 311 136 320V336C136 345 143 352 152 352H168C177 352 184 345 184 336V320C184 311 177 304 168 304ZM264 304H248C239 304 232 311 232 320V336C232 345 239 352 248 352H264C273 352 280 345 280 336V320C280 311 273 304 264 304ZM136 256C136 247 129 240 120 240H104C95 240 88 247 88 256V272C88 281 95 288 104 288H120C129 288 136 281 136 272V256ZM511 379L488 215C483 183 456 160 425 160H425L200 160V128H288C306 128 320 114 320 96V32C320 14 306 0 288 0H64C47 0 32 14 32 32V96C32 114 47 128 64 128H152V160L88 160H88C56 160 29 183 24 215L1 379C0 382 0 386 0 389V480C0 498 14 512 32 512H480C498 512 512 498 512 480V388C512 385 512 382 511 379ZM80 80V48H272V80H80ZM72 222C73 214 80 208 88 208L152 208H152V208L200 208L425 208C432 208 439 214 440 222L464 384H48L72 222ZM464 464H48V432H464V464ZM328 256C328 247 321 240 312 240H296C287 240 280 247 280 256V272C280 281 287 288 296 288H312C321 288 328 281 328 272V256ZM408 240H392C383 240 376 247 376 256V272C376 281 383 288 392 288H408C417 288 424 281 424 272V256C424 247 417 240 408 240ZM360 304H344C335 304 328 311 328 320V336C328 345 335 352 344 352H360C369 352 376 345 376 336V320C376 311 369 304 360 304Z"]
  };
  var faCassetteTape = {
    prefix: 'far',
    iconName: 'cassette-tape',
    icon: [576, 512, [], "f8ab", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM157 432L176 384H400L419 432H157ZM528 416C528 425 521 432 512 432H468L470 431L438 351C435 342 426 336 416 336H160C150 336 141 342 138 351L106 431L108 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H512C521 80 528 87 528 96V416ZM400 160H176C141 160 112 189 112 224C112 259 141 288 176 288H400C435 288 464 259 464 224C464 189 435 160 400 160ZM176 240C167 240 160 233 160 224S167 208 176 208S192 215 192 224S185 240 176 240ZM338 240H238C239 235 240 230 240 224S239 213 238 208H338C337 213 336 218 336 224S337 235 338 240ZM400 240C391 240 384 233 384 224S391 208 400 208S416 215 416 224S409 240 400 240Z"]
  };
  var faCat = {
    prefix: 'far',
    iconName: 'cat',
    icon: [576, 512, [], "f6be", "M416 128C407 128 400 135 400 144S407 160 416 160S432 153 432 144S425 128 416 128ZM547 4C541 1 535 0 528 0C516 0 505 4 496 12L456 48H440L400 12C386 0 366 -3 349 4C331 12 320 29 320 48V160C320 164 321 168 321 172L274 179C207 190 150 226 112 277V184C112 135 73 96 24 96C11 96 0 107 0 120C0 133 11 144 24 144C47 144 64 164 64 187L64 399C64 473 103 512 152 512H336C345 512 352 505 352 496C352 478 338 464 320 464H304C304 457 303 449 302 442L384 394V464C384 490 406 512 432 512H464C490 512 512 490 512 464V270C550 248 576 207 576 160V48C576 29 565 12 547 4ZM464 464H432V366C432 355 426 344 416 338C406 333 394 333 384 338L287 395C275 370 257 348 234 332C226 327 216 330 211 338L204 351C200 358 202 368 208 373C237 394 255 428 256 464H152C130 464 112 446 112 424C112 325 183 242 282 227L335 219C356 260 399 288 448 288C454 288 459 287 464 286V464ZM528 160C528 204 492 240 448 240S368 204 368 160V48L421 96H475L528 48V160ZM464 144C464 153 471 160 480 160S496 153 496 144S489 128 480 128S464 135 464 144Z"]
  };
  var faCatSpace = {
    prefix: 'far',
    iconName: 'cat-space',
    icon: [640, 512, [], "e001", "M187 85L203 125C204 127 206 128 208 128S212 127 213 125L229 85L269 69C271 68 272 66 272 64S271 60 269 59L229 43L213 3C212 1 210 0 208 0S204 1 203 3L187 43L147 59C145 60 144 62 144 64S145 68 147 69L187 85ZM448 0C351 0 272 79 272 176C272 177 272 179 272 180C206 191 149 226 112 277V184C112 135 73 96 24 96C15 96 7 101 3 108C-1 116 -1 125 3 132C8 140 16 144 25 144C47 143 64 165 64 187V399C64 473 103 512 152 512H336C340 512 344 510 347 507S352 500 352 496C352 478 338 464 320 464H304C304 457 303 449 302 442L384 394V464C384 490 406 512 432 512H464C490 512 512 490 512 464V340C577 314 624 251 624 176C624 79 545 0 448 0ZM448 48C474 48 500 56 521 71L480 112H416L375 71C396 56 422 48 448 48ZM504 176C504 185 497 192 488 192S472 185 472 176S479 160 488 160C492 160 496 162 499 165S504 172 504 176ZM424 176C424 185 417 192 408 192S392 185 392 176S399 160 408 160C412 160 416 162 419 165S424 172 424 176ZM287 395C275 370 257 348 234 332C226 327 216 330 211 338L204 351C200 358 202 368 208 373C237 394 255 428 256 464H152C130 464 112 446 112 424C112 325 182 243 280 227C295 278 333 319 382 339L287 395ZM464 464H432V366C432 361 431 356 428 351C440 352 452 352 464 351V464ZM448 304C377 304 320 247 320 176C320 144 332 115 352 92V176C352 229 395 272 448 272S544 229 544 176V92C564 115 576 144 576 176C576 247 519 304 448 304Z"]
  };
  var faCauldron = {
    prefix: 'far',
    iconName: 'cauldron',
    icon: [448, 512, [], "f6bf", "M160 64C178 64 192 50 192 32S178 0 160 0S128 14 128 32S142 64 160 64ZM424 208C437 208 448 197 448 184C448 171 437 160 424 160H24C11 160 0 171 0 184C0 197 11 208 24 208H45C17 252 0 301 0 340C0 372 12 402 32 428V488C32 501 43 512 56 512S80 501 80 488V472C119 497 169 512 224 512S329 497 368 472V488C368 501 379 512 392 512S416 501 416 488V428C436 402 448 372 448 340C448 301 431 252 403 208H424ZM224 464C127 464 48 408 48 340C48 304 69 251 103 208H345C379 251 400 304 400 340C400 408 321 464 224 464ZM272 128C298 128 320 106 320 80S298 32 272 32S224 54 224 80S246 128 272 128Z"]
  };
  var faCediSign = {
    prefix: 'far',
    iconName: 'cedi-sign',
    icon: [384, 512, [], "e0bd", "M311 352C289 374 262 387 232 390V122C262 125 289 138 311 160C320 169 336 169 345 160C354 151 354 135 345 126C314 95 275 78 232 74V24C232 11 221 0 208 0S184 11 184 24V75C147 81 113 99 86 126C14 198 14 314 86 386C113 413 147 431 184 437V488C184 501 195 512 208 512S232 501 232 488V438C275 434 314 417 345 386C354 377 354 361 345 352C336 343 320 343 311 352ZM120 352C67 299 67 213 120 160C138 142 160 130 184 124V388C160 382 138 370 120 352Z"]
  };
  var faCentSign = {
    prefix: 'far',
    iconName: 'cent-sign',
    icon: [320, 512, [], "e0be", "M313 347C322 357 322 372 313 381C281 411 241 427 200 430C200 431 200 431 200 432V488C200 501 189 512 176 512C163 512 152 501 152 488V432C152 431 152 430 153 429C117 423 82 407 54 381C19 348 0 303 0 256S19 164 54 131C82 105 117 89 153 83C152 82 152 81 152 80V24C152 11 163 0 176 0C189 0 200 11 200 24V80C200 81 200 81 200 82C241 85 281 101 313 131C322 140 323 155 313 165C304 175 289 175 279 166C226 115 140 115 87 166C62 190 48 222 48 256S62 322 87 346C140 397 226 397 279 346C289 337 304 337 313 347Z"]
  };
  var faCertificate = {
    prefix: 'far',
    iconName: 'certificate',
    icon: [512, 512, [], "f0a3", "M474 256L498 233C510 221 515 204 510 188C506 172 493 159 478 155L445 147L454 114C459 99 454 81 442 70C430 58 413 53 397 58L365 67L357 35C353 19 340 6 324 2C308 -3 291 2 280 14L256 38L233 14C221 2 204 -3 188 2C172 6 159 18 155 34L147 67L115 58C99 53 82 58 70 70C58 81 54 99 58 115L67 147L35 155C19 159 6 172 2 188C-3 204 2 221 14 232L38 256L14 279C2 291 -3 308 2 324C6 340 19 353 34 356L67 365L58 397C54 413 58 430 70 442C81 454 99 458 115 454L147 445L155 477C159 494 172 506 188 510C192 511 196 512 200 512C212 512 224 507 232 498L256 474L279 498C291 510 308 515 324 510C340 506 353 494 357 478L365 445L398 454C413 458 431 454 442 442C454 430 459 413 454 397L445 365L477 357C493 353 506 340 510 324S510 291 498 279L474 256ZM310 46L310 46L310 46L310 46ZM198 47L198 47L198 47L198 47ZM46 202L46 202L46 202L46 202ZM47 314L48 314L48 314L47 314ZM202 466L202 466L202 466L202 466ZM314 465L314 464L314 464L314 465ZM385 331L407 407L331 385L311 462L256 405L201 462L181 385L105 407L127 331L50 311L107 256L50 201L127 181L105 105L181 127L201 50L256 107L311 50L331 127L407 105L385 181L462 201L405 256L462 311L385 331ZM464 198L464 198L465 198L464 198ZM466 310L466 310L466 310L466 310Z"]
  };
  var faChair = {
    prefix: 'far',
    iconName: 'chair',
    icon: [448, 512, [], "f6c0", "M445 326L434 294C427 272 407 258 384 256V128C384 57 327 0 256 0H192C121 0 64 57 64 128V256C41 258 21 272 13 294L3 326C-3 343 0 362 11 377C16 384 24 390 32 394V488C32 501 43 512 56 512H56C69 512 80 501 80 488V400H368V488C368 501 379 512 392 512H392C405 512 416 501 416 488V394C424 390 432 384 437 377C448 362 451 343 445 326ZM296 59C320 73 336 98 336 128V256H296V59ZM200 48H248V256H200V48ZM152 59V256H112V128C112 98 128 73 152 59ZM48 342L59 310C60 306 63 304 67 304H381C385 304 388 306 389 310L400 342C401 347 397 352 392 352H56C51 352 47 347 48 342Z"]
  };
  var faChairOffice = {
    prefix: 'far',
    iconName: 'chair-office',
    icon: [448, 512, [], "f6c1", "M402 294C395 272 375 258 352 256V64C352 29 323 0 288 0H160C125 0 96 29 96 64V256C73 258 53 272 46 294L35 326C29 343 32 362 43 377S70 400 88 400H200V464H152C139 464 128 475 128 488C128 501 139 512 152 512H296C309 512 320 501 320 488C320 475 309 464 296 464H248V400H360C378 400 395 391 405 377C416 362 419 343 413 326L402 294ZM144 64C144 55 151 48 160 48H288C297 48 304 55 304 64V256H144V64ZM360 352H88C83 352 79 347 80 342L91 310C92 306 95 304 99 304H349C353 304 356 306 357 310L368 342C369 347 365 352 360 352ZM64 232V152C64 139 53 128 40 128S16 139 16 152V232C16 245 27 256 40 256S64 245 64 232ZM408 128C395 128 384 139 384 152V232C384 245 395 256 408 256S432 245 432 232V152C432 139 421 128 408 128Z"]
  };
  var faChalkboard = {
    prefix: 'far',
    iconName: 'chalkboard',
    icon: [576, 512, [], "f51b", "M552 432H416V384C416 366 402 352 384 352H256C238 352 224 366 224 384V432H24C11 432 0 443 0 456C0 469 11 480 24 480H552C565 480 576 469 576 456C576 443 565 432 552 432ZM368 432H272V400H368V432ZM80 88C80 84 84 80 88 80H488C492 80 496 84 496 88V400H544V88C544 57 519 32 488 32H88C57 32 32 57 32 88V400H80V88Z"]
  };
  var faChalkboardUser = {
    prefix: 'far',
    iconName: 'chalkboard-user',
    icon: [640, 512, [], "f51c", "M192 352H128C57 352 0 409 0 480C0 498 14 512 32 512H288C306 512 320 498 320 480C320 409 263 352 192 352ZM50 464C57 428 89 400 128 400H192C231 400 263 428 270 464H50ZM160 320C213 320 256 277 256 224C256 171 213 128 160 128C107 128 64 171 64 224C64 277 107 320 160 320ZM160 176C186 176 208 198 208 224S186 272 160 272S112 250 112 224S134 176 160 176ZM584 0H216C185 0 160 25 160 56V80C160 93 171 104 184 104S208 93 208 80V56C208 52 212 48 216 48H584C588 48 592 52 592 56V360C592 364 588 368 584 368H528V336C528 318 514 304 496 304H416C398 304 384 318 384 336V368H352C339 368 328 379 328 392S339 416 352 416H584C615 416 640 391 640 360V56C640 25 615 0 584 0Z"]
  };
  var faChampagneGlass = {
    prefix: 'far',
    iconName: 'champagne-glass',
    icon: [256, 512, [], "f79e", "M216 464H152V350C217 338 264 278 255 212L228 27C226 12 212 0 196 0H60C44 0 30 12 28 27L1 212C-8 278 39 338 104 349V464H40C27 464 16 475 16 488C16 501 27 512 40 512H216C229 512 240 501 240 488C240 475 229 464 216 464ZM182 48L194 128H62L74 48H182ZM49 219L55 176H201L207 219C211 250 186 304 128 304C70 304 44 251 49 219Z"]
  };
  var faChampagneGlasses = {
    prefix: 'far',
    iconName: 'champagne-glasses',
    icon: [640, 512, [], "f79f", "M638 423C634 414 626 408 616 408C613 408 610 409 607 410L562 428L520 323C572 289 591 223 561 168L475 16C470 6 459 0 447 0C443 0 439 1 435 2L320 47L205 2C201 1 197 0 193 0C181 0 170 6 165 17L79 168C49 223 68 289 120 323L78 428L33 410C30 409 27 408 24 408C15 408 6 414 2 423C-3 435 3 449 15 454L151 510C154 511 157 512 160 512C169 512 178 506 182 497C187 485 181 471 169 466L123 447L165 341C173 343 181 343 189 343C243 343 291 309 305 256L320 196L320 197L320 196L335 256C349 309 397 343 451 343C459 343 467 343 475 341L517 447L471 466C459 471 453 485 458 497C462 506 471 512 480 512C483 512 486 511 489 510L625 454C637 449 643 435 638 423ZM121 192L147 145L270 198L258 244C233 345 71 282 121 192ZM282 151L171 103L200 52L297 90L282 151ZM343 90L440 52L469 103L358 151L350 117L343 90ZM382 244L370 198L493 145L519 192C570 282 407 345 382 244Z"]
  };
  var faChargingStation = {
    prefix: 'far',
    iconName: 'charging-station',
    icon: [576, 512, [], "f5e7", "M560 128H544V80C544 71 537 64 528 64S512 71 512 80V128H480V80C480 71 473 64 464 64S448 71 448 80V128H432C423 128 416 135 416 144V192C416 228 440 258 472 268V371C472 385 462 397 449 400C431 402 416 389 416 372V344C416 296 376 256 328 256H320V64C320 29 291 0 256 0H96C61 0 32 29 32 64V464H24C11 464 0 475 0 488C0 501 11 512 24 512H328C341 512 352 501 352 488C352 475 341 464 328 464H320V304H328C350 304 368 322 368 344V368C368 408 397 444 437 448C482 452 520 416 520 372V268C552 258 576 228 576 192V144C576 135 569 128 560 128ZM272 464H80V64C80 55 87 48 96 48H256C265 48 272 55 272 64V464ZM528 192C528 210 514 224 496 224S464 210 464 192V176H528V192ZM214 176H171L186 127C190 115 183 101 171 97C158 93 144 100 141 113L115 193C113 200 114 208 119 214C123 220 131 224 138 224H174L142 285C136 297 141 311 152 317C156 319 160 320 163 320C172 320 180 315 185 307L235 211C239 204 239 195 234 188S222 176 214 176Z"]
  };
  var faChartArea = {
    prefix: 'far',
    iconName: 'chart-area',
    icon: [512, 512, [], "f1fe", "M120 384H456C469 384 480 373 480 360V240C480 234 478 229 475 225L403 137C398 132 392 128 385 128C379 128 372 130 367 135L321 181L250 104C245 99 239 96 232 96H232C225 96 219 99 214 104L102 224C98 228 96 234 96 240V360C96 373 107 384 120 384ZM144 249L232 155L302 232C307 237 313 240 319 240C327 240 332 238 337 233L382 188L432 249V336H144V249ZM488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456C512 443 501 432 488 432Z"]
  };
  var faChartBar = {
    prefix: 'far',
    iconName: 'chart-bar',
    icon: [512, 512, [], "f080", "M152 256H296C309 256 320 245 320 232S309 208 296 208H152C139 208 128 219 128 232S139 256 152 256ZM152 160H360C373 160 384 149 384 136S373 112 360 112H152C139 112 128 123 128 136S139 160 152 160ZM152 352H424C437 352 448 341 448 328S437 304 424 304H152C139 304 128 315 128 328S139 352 152 352ZM488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456S501 432 488 432Z"]
  };
  var faChartBullet = {
    prefix: 'far',
    iconName: 'chart-bullet',
    icon: [512, 512, [], "e0bf", "M48 224H160V64H48C22 64 0 86 0 112V176C0 202 22 224 48 224ZM48 112H112V176H48V112ZM464 288H384C384 279 377 272 368 272S352 279 352 288H256V336H352V400H256V448H352C352 457 359 464 368 464S384 457 384 448H464C490 448 512 426 512 400V336C512 310 490 288 464 288ZM464 400H384V336H464V400ZM0 336V400C0 426 22 448 48 448H224V288H48C22 288 0 310 0 336ZM176 400H48V336H176V400ZM464 64H288C288 55 281 48 272 48S256 55 256 64H192V112H256V176H192V224H256C256 233 263 240 272 240S288 233 288 224H464C490 224 512 202 512 176V112C512 86 490 64 464 64ZM464 176H288V112H464V176Z"]
  };
  var faChartCandlestick = {
    prefix: 'far',
    iconName: 'chart-candlestick',
    icon: [512, 512, [], "e0c0", "M400 320H416V368C416 377 423 384 432 384C441 384 448 377 448 368V320H464C473 320 480 313 480 304V208C480 199 473 192 464 192H448V144C448 135 441 128 432 128C423 128 416 135 416 144V192H400C391 192 384 199 384 208V304C384 313 391 320 400 320ZM272 256H288V304C288 313 295 320 304 320C313 320 320 313 320 304V256H336C345 256 352 249 352 240V112C352 103 345 96 336 96H320V48C320 39 313 32 304 32C295 32 288 39 288 48V96H272C263 96 256 103 256 112V240C256 249 263 256 272 256ZM144 320H160V368C160 377 167 384 176 384C185 384 192 377 192 368V320H208C217 320 224 313 224 304V144C224 135 217 128 208 128H192V80C192 71 185 64 176 64C167 64 160 71 160 80V128H144C135 128 128 135 128 144V304C128 313 135 320 144 320ZM488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456S501 432 488 432Z"]
  };
  var faChartColumn = {
    prefix: 'far',
    iconName: 'chart-column',
    icon: [512, 512, [], "e0c1", "M488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456C512 443 501 432 488 432ZM168 352C181 352 192 341 192 328V280C192 267 181 256 168 256S144 267 144 280V328C144 341 155 352 168 352ZM264 352C277 352 288 341 288 328V152C288 139 277 128 264 128S240 139 240 152V328C240 341 251 352 264 352ZM360 352C373 352 384 341 384 328V216C384 203 373 192 360 192S336 203 336 216V328C336 341 347 352 360 352ZM456 352C469 352 480 341 480 328V120C480 107 469 96 456 96S432 107 432 120V328C432 341 443 352 456 352Z"]
  };
  var faChartGantt = {
    prefix: 'far',
    iconName: 'chart-gantt',
    icon: [512, 512, [], "e0c2", "M216 256H360C373 256 384 245 384 232S373 208 360 208H216C203 208 192 219 192 232S203 256 216 256ZM152 160H264C277 160 288 149 288 136S277 112 264 112H152C139 112 128 123 128 136S139 160 152 160ZM376 352H456C469 352 480 341 480 328S469 304 456 304H376C363 304 352 315 352 328S363 352 376 352ZM488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456S501 432 488 432Z"]
  };
  var faChartLine = {
    prefix: 'far',
    iconName: 'chart-line',
    icon: [512, 512, [], "f201", "M145 305L208 242L287 321C292 326 298 328 304 328S316 326 321 321L473 169C482 160 482 144 473 135C464 126 448 126 439 135L304 270L225 191C216 182 200 182 191 191L111 271C102 280 102 296 111 305C120 314 136 314 145 305ZM488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456S501 432 488 432Z"]
  };
  var faChartLineDown = {
    prefix: 'far',
    iconName: 'chart-line-down',
    icon: [512, 512, [], "f64d", "M488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456C512 443 501 432 488 432ZM191 257C200 266 216 266 225 257L304 178L398 272H344C331 272 320 283 320 296S331 320 344 320H456C469 320 480 309 480 296V184C480 171 469 160 456 160S432 171 432 184V238L321 127C312 118 296 118 287 127L208 206L145 143C136 134 120 134 111 143S102 168 111 177L191 257Z"]
  };
  var faChartLineUp = {
    prefix: 'far',
    iconName: 'chart-line-up',
    icon: [512, 512, [], "e0c3", "M488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456C512 443 501 432 488 432ZM145 305L208 242L287 321C292 326 298 328 304 328S316 326 321 321L432 210V264C432 277 443 288 456 288S480 277 480 264V152C480 139 469 128 456 128H344C331 128 320 139 320 152S331 176 344 176H398L304 270L225 191C216 182 200 182 191 191L111 271C102 280 102 296 111 305S136 314 145 305Z"]
  };
  var faChartMixed = {
    prefix: 'far',
    iconName: 'chart-mixed',
    icon: [576, 512, [], "f643", "M208 192C195 192 184 203 184 216V482C184 495 195 506 208 506S232 495 232 482V216C232 203 221 192 208 192ZM48 352C35 352 24 363 24 376V488C24 501 35 512 48 512S72 501 72 488V376C72 363 61 352 48 352ZM528 0C502 0 480 22 480 48C480 50 480 53 481 55L385 131C380 129 374 128 368 128S356 129 351 131L255 55C256 53 256 50 256 48C256 22 234 0 208 0S160 22 160 48C160 52 161 56 162 60L60 162C56 161 52 160 48 160C22 160 0 182 0 208S22 256 48 256S96 234 96 208C96 204 95 200 94 196L196 94C200 95 204 96 208 96C214 96 220 95 225 93L321 169C320 171 320 174 320 176C320 202 342 224 368 224S416 202 416 176C416 174 416 171 415 169L511 93C516 95 522 96 528 96C554 96 576 74 576 48S554 0 528 0ZM368 320C355 320 344 331 344 344V483C344 497 355 507 368 507S392 497 392 483V344C392 331 381 320 368 320ZM528 192C515 192 504 203 504 216V488C504 501 515 512 528 512S552 501 552 488V216C552 203 541 192 528 192Z"]
  };
  var faChartNetwork = {
    prefix: 'far',
    iconName: 'chart-network',
    icon: [640, 512, [], "f78a", "M576 192C611 192 640 163 640 128C640 93 611 64 576 64S512 93 512 128C512 163 541 192 576 192ZM576 384C562 384 548 389 538 397L456 348C461 334 464 319 464 304C464 284 459 266 451 249L494 218C505 210 507 195 499 184C492 174 477 171 466 179L423 210C400 189 370 176 336 176C325 176 315 178 305 180L271 107C281 96 288 81 288 64C288 29 259 0 224 0S160 29 160 64C160 99 189 128 224 128C225 128 226 128 227 128L261 201C229 224 208 261 208 304C208 375 265 432 336 432C374 432 408 415 431 389L513 438C512 441 512 445 512 448C512 483 541 512 576 512S640 483 640 448C640 413 611 384 576 384ZM336 384C292 384 256 348 256 304S292 224 336 224C380 224 416 260 416 304S380 384 336 384ZM152 280H123C114 257 91 240 64 240C29 240 0 269 0 304C0 339 29 368 64 368C91 368 114 351 123 328H152C165 328 176 317 176 304S165 280 152 280Z"]
  };
  var faChartPie = {
    prefix: 'far',
    iconName: 'chart-pie',
    icon: [576, 512, [], "f200", "M512 223C504 104 408 8 289 0C288 0 288 0 288 0C279 0 272 7 272 16V240H496C505 240 513 232 512 223ZM320 192V54C387 71 441 125 458 192H320ZM224 288V51C224 42 217 34 208 34C208 34 207 34 206 35C87 51 -4 156 0 280C4 407 113 512 240 512C241 512 242 512 243 512C293 511 340 495 378 468C386 462 387 451 380 444L224 288ZM242 464H240C139 464 51 379 48 279C45 193 98 118 176 91V308L190 322L316 448C293 458 268 464 242 464ZM528 288H290L448 446C452 449 456 451 460 451C464 451 468 450 471 447C509 410 536 361 544 306C545 296 537 288 528 288Z"]
  };
  var faChartPieSimple = {
    prefix: 'far',
    iconName: 'chart-pie-simple',
    icon: [512, 512, [], "f64e", "M461 288H224V51C224 42 217 34 208 34C208 34 207 34 206 35C87 51 -4 155 0 280C4 404 108 508 232 512C235 512 237 512 240 512C361 512 461 422 477 306C479 296 471 288 461 288ZM240 464C238 464 236 464 234 464C135 461 51 378 48 278C45 193 98 118 176 91V336H421C394 411 322 464 240 464ZM289 0C288 0 288 0 288 0C279 0 272 7 272 16V240H496C505 240 513 232 512 223C504 104 408 8 289 0Z"]
  };
  var faChartPyramid = {
    prefix: 'far',
    iconName: 'chart-pyramid',
    icon: [512, 512, [], "e0c4", "M506 417L293 53C285 39 270 32 256 32S227 39 219 53L6 417C-11 445 10 480 43 480H469C502 480 523 445 506 417ZM256 85L314 184H198L256 85ZM170 232H342L389 312H123L170 232ZM53 432L96 358V360H416V358L459 432H53Z"]
  };
  var faChartRadar = {
    prefix: 'far',
    iconName: 'chart-radar',
    icon: [512, 512, [], "e0c5", "M506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM360 432H152L49 256L152 80H360L463 256L360 432ZM331 282L290 180C293 174 296 167 296 160C296 138 278 120 256 120S216 138 216 160C216 164 217 167 218 170L160 248C160 248 160 248 160 248C138 248 120 266 120 288S138 328 160 328C170 328 179 324 186 318L284 337C291 351 304 360 320 360C342 360 360 342 360 320C360 302 347 287 331 282ZM202 272L250 209L281 288L202 272Z"]
  };
  var faChartScatter = {
    prefix: 'far',
    iconName: 'chart-scatter',
    icon: [512, 512, [], "f7ee", "M288 288C306 288 320 274 320 256C320 238 306 224 288 224S256 238 256 256C256 274 270 288 288 288ZM384 352C402 352 416 338 416 320C416 302 402 288 384 288S352 302 352 320C352 338 366 352 384 352ZM416 160C434 160 448 146 448 128C448 110 434 96 416 96S384 110 384 128C384 146 398 160 416 160ZM488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456C512 443 501 432 488 432ZM192 192C210 192 224 178 224 160C224 142 210 128 192 128S160 142 160 160C160 178 174 192 192 192ZM160 352C178 352 192 338 192 320C192 302 178 288 160 288S128 302 128 320C128 338 142 352 160 352Z"]
  };
  var faChartScatter3d = {
    prefix: 'far',
    iconName: 'chart-scatter-3d',
    icon: [512, 512, [], "e0c6", "M128 192C146 192 160 178 160 160S146 128 128 128S96 142 96 160S110 192 128 192ZM384 96C402 96 416 82 416 64S402 32 384 32S352 46 352 64S366 96 384 96ZM32 96C50 96 64 82 64 64S50 32 32 32S0 46 0 64S14 96 32 96ZM384 288C402 288 416 274 416 256S402 224 384 224S352 238 352 256S366 288 384 288ZM64 256C64 238 50 224 32 224S0 238 0 256S14 288 32 288S64 274 64 256ZM480 128C462 128 448 142 448 160S462 192 480 192S512 178 512 160S498 128 480 128ZM256 416C238 416 224 430 224 448S238 480 256 480S288 466 288 448S274 416 256 416ZM280 277V56C280 43 269 32 256 32S232 43 232 56V277L41 438C30 446 29 461 38 471C46 482 61 483 71 474L256 319L441 474C445 478 451 480 456 480C463 480 470 477 474 471C483 461 482 446 471 438L280 277Z"]
  };
  var faChartScatterBubble = {
    prefix: 'far',
    iconName: 'chart-scatter-bubble',
    icon: [512, 512, [], "e0c7", "M488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456S501 432 488 432ZM384 192C419 192 448 163 448 128S419 64 384 64S320 93 320 128S349 192 384 192ZM384 112C393 112 400 119 400 128S393 144 384 144S368 137 368 128S375 112 384 112ZM352 352C387 352 416 323 416 288S387 224 352 224S288 253 288 288S317 352 352 352ZM352 272C361 272 368 279 368 288S361 304 352 304S336 297 336 288S343 272 352 272ZM176 352C202 352 224 330 224 304S202 256 176 256S128 278 128 304S150 352 176 352ZM240 224C266 224 288 202 288 176S266 128 240 128S192 150 192 176S214 224 240 224Z"]
  };
  var faChartTreeMap = {
    prefix: 'far',
    iconName: 'chart-tree-map',
    icon: [512, 512, [], "e0c8", "M192 272H32C14 272 0 286 0 304V448C0 466 14 480 32 480H192C210 480 224 466 224 448V304C224 286 210 272 192 272ZM176 432H48V320H176V432ZM480 192H288C270 192 256 206 256 224V288C256 306 270 320 288 320H480C498 320 512 306 512 288V224C512 206 498 192 480 192ZM464 272H304V240H464V272ZM480 32H288C270 32 256 46 256 64V128C256 146 270 160 288 160H480C498 160 512 146 512 128V64C512 46 498 32 480 32ZM464 112H304V80H464V112ZM192 32H32C14 32 0 46 0 64V208C0 226 14 240 32 240H192C210 240 224 226 224 208V64C224 46 210 32 192 32ZM176 192H48V80H176V192ZM480 352H288C270 352 256 366 256 384V448C256 466 270 480 288 480H480C498 480 512 466 512 448V384C512 366 498 352 480 352ZM464 432H304V400H464V432Z"]
  };
  var faChartUser = {
    prefix: 'far',
    iconName: 'chart-user',
    icon: [640, 512, [], "f6a3", "M160 320C213 320 256 277 256 224C256 171 213 128 160 128C107 128 64 171 64 224C64 277 107 320 160 320ZM160 176C186 176 208 198 208 224S186 272 160 272S112 250 112 224S134 176 160 176ZM192 352H128C57 352 0 409 0 480C0 498 14 512 32 512H288C306 512 320 498 320 480C320 409 263 352 192 352ZM50 464C57 428 89 400 128 400H192C231 400 263 428 270 464H50ZM584 0H216C185 0 160 25 160 56V80C160 93 171 104 184 104S208 93 208 80V56C208 52 212 48 216 48H584C588 48 592 52 592 56V360C592 364 588 368 584 368H352C339 368 328 379 328 392S339 416 352 416H584C615 416 640 391 640 360V56C640 25 615 0 584 0ZM329 167C320 158 304 158 295 167S286 192 295 201L367 273C372 278 378 280 384 280S396 278 401 273L496 178V200C496 213 507 224 520 224S544 213 544 200V120C544 107 533 96 520 96H440C427 96 416 107 416 120S427 144 440 144H462L384 222L329 167Z"]
  };
  var faChartWaterfall = {
    prefix: 'far',
    iconName: 'chart-waterfall',
    icon: [512, 512, [], "e0c9", "M344 192C357 192 368 181 368 168V88C368 75 357 64 344 64S320 75 320 88V168C320 181 331 192 344 192ZM440 352C453 352 464 341 464 328V88C464 75 453 64 440 64S416 75 416 88V328C416 341 427 352 440 352ZM248 256C261 256 272 245 272 232V152C272 139 261 128 248 128S224 139 224 152V232C224 245 235 256 248 256ZM152 352C165 352 176 341 176 328V248C176 235 165 224 152 224S128 235 128 248V328C128 341 139 352 152 352ZM488 432H48V56C48 43 37 32 24 32S0 43 0 56V448C0 466 14 480 32 480H488C501 480 512 469 512 456S501 432 488 432Z"]
  };
  var faCheck = {
    prefix: 'far',
    iconName: 'check',
    icon: [512, 512, [], "f00c", "M481 129L209 401C204 406 198 408 192 408S180 406 175 401L31 257C22 248 22 232 31 223S56 214 65 223L192 350L447 95C456 86 472 86 481 95S490 120 481 129Z"]
  };
  var faCheckDouble = {
    prefix: 'far',
    iconName: 'check-double',
    icon: [512, 512, [], "f560", "M481 158C472 149 456 149 447 158L192 413L65 286C56 277 40 277 31 286S22 311 31 320L175 464C180 469 186 471 192 471S204 469 209 464L481 192C490 183 490 168 481 158ZM175 240C180 245 186 247 192 247S204 245 209 240L385 64C394 55 394 40 385 30S360 21 351 30L192 189L113 110C104 101 88 101 79 110S70 135 79 144L175 240Z"]
  };
  var faCheese = {
    prefix: 'far',
    iconName: 'cheese',
    icon: [512, 512, [], "f7ef", "M300 32H298C291 32 284 34 279 39L0 256V448C0 466 14 480 32 480H480C498 480 512 466 512 448V256C512 136 418 38 300 32ZM304 80C391 88 459 160 463 248H89L304 80ZM464 432H48V296H464V432Z"]
  };
  var faCheeseSwiss = {
    prefix: 'far',
    iconName: 'cheese-swiss',
    icon: [512, 512, [], "f7f0", "M176 320C150 320 128 341 128 368S150 416 176 416S224 394 224 368S202 320 176 320ZM300 32H298C291 32 284 34 279 39L0 256V448C0 466 14 480 32 480H480C498 480 512 466 512 448V256C512 136 418 38 300 32ZM197 164C205 182 223 193 243 192C263 191 280 177 286 158S286 119 270 107L304 81C391 88 459 160 463 248H409C401 233 385 224 368 224S335 233 327 248H89L197 164ZM464 432H48V296H327C335 311 351 320 368 320S401 311 409 296H464V432Z"]
  };
  var faChess = {
    prefix: 'far',
    iconName: 'chess',
    icon: [512, 512, [], "f439", "M498 279C507 273 512 263 512 253V192C512 174 498 160 480 160H288C270 160 256 174 256 192V253C256 263 262 274 269 278L296 300V374C291 379 288 385 288 392V416L262 435C258 438 256 443 256 448C256 443 254 438 250 435L224 416V392C224 382 217 373 207 370C203 345 201 319 201 294V256H208C217 256 224 249 224 240V224C224 215 217 208 208 208H205L232 128C235 118 232 107 223 101C219 97 213 96 208 96L145 96V64H161C170 64 177 57 177 48V48C177 39 170 32 161 32H145V16C145 7 138 0 129 0H129C120 0 113 7 113 16V32H97C88 32 81 39 81 48V48C81 57 88 64 97 64H113V96L49 96C44 96 39 97 34 101C26 107 22 118 26 128L53 208H48C39 208 32 215 32 224V240C32 249 39 256 48 256H57V294C57 319 54 344 50 369C40 372 32 381 32 392V416L6 435C2 438 0 443 0 448V496C0 505 7 512 16 512H240C249 512 256 505 256 496C256 505 263 512 272 512H496C505 512 512 505 512 496V448C512 443 510 438 506 435L480 416V392C480 385 477 379 472 374V299L498 279ZM176 144L159 193L154 208H103L98 193L82 144H176ZM159 368H99C102 343 105 318 105 294V256H153V294C153 318 155 343 159 368ZM48 464L61 454L80 440V416H176V440L195 454L208 464H48ZM304 464L317 454L336 440V416H432V440L451 454L464 464H304ZM464 245L424 276V368H344V276L304 245V208H336V232H368V208H400V232H432V208H464V245ZM384 288C375 288 368 295 368 304V336H400V304C400 295 393 288 384 288Z"]
  };
  var faChessBishop = {
    prefix: 'far',
    iconName: 'chess-bishop',
    icon: [320, 512, [], "f43a", "M296 464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H296C309 512 320 501 320 488V488C320 475 309 464 296 464ZM0 304C0 356 30 389 64 400V432H112V365L78 354C64 350 48 334 48 304C48 229 114 138 149 102C155 96 165 96 172 102C184 114 206 137 231 183L165 249C159 256 159 266 165 272L176 283C182 290 192 290 199 283L253 229C264 257 272 283 272 304C272 334 256 350 242 354L208 365V432H256V400C290 389 320 356 320 304C320 231 252 107 199 62C213 59 224 47 224 32C224 14 210 0 192 0H128C110 0 96 14 96 32C96 47 107 59 121 62C68 107 0 231 0 304Z"]
  };
  var faChessBishopPiece = {
    prefix: 'far',
    iconName: 'chess-bishop-piece',
    icon: [256, 512, [], "f43b", "M250 435L224 416V392C224 380 215 370 203 369C201 353 200 336 200 320H208C217 320 224 313 224 304V288C224 280 218 274 210 273C224 262 232 243 232 211C232 170 206 111 174 79C184 76 192 67 192 56C192 43 181 32 168 32H88C75 32 64 43 64 56C64 67 72 76 82 79C50 111 24 170 24 211C24 243 32 262 46 273C38 274 32 280 32 288V304C32 313 39 320 48 320H56C56 336 55 353 53 369C41 370 32 380 32 392V416L6 435C2 438 0 443 0 448V496C0 505 7 512 16 512H240C249 512 256 505 256 496V448C256 443 254 438 250 435ZM115 110C118 106 123 104 128 104S138 106 141 110C147 119 153 127 159 137L121 174C119 176 119 178 119 180S119 184 121 186L134 199C136 201 138 201 140 201C142 201 144 201 146 199L174 170C180 186 184 200 184 211V212C184 225 179 238 169 247L160 256V272H96V256L87 247C78 238 72 225 72 212V211C72 186 90 142 115 110ZM155 368H101C103 352 104 336 104 320H152C152 336 153 352 155 368ZM48 464L80 440V416H176V440L208 464H48Z"]
  };
  var faChessBoard = {
    prefix: 'far',
    iconName: 'chess-board',
    icon: [448, 512, [], "f43c", "M64 96V160H128V96H64ZM256 96H192V160H256V96ZM192 416H256V352H192V416ZM64 416H128V352H64V416ZM64 224V288H128V224H64ZM384 288V224H320V288H384ZM384 416V352H320V416H384ZM320 160H384V96H320V160ZM256 224H320V160H256V224ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416ZM192 160H128V224H192V160ZM192 288H256V224H192V288ZM128 288V352H192V288H128ZM256 352H320V288H256V352Z"]
  };
  var faChessClock = {
    prefix: 'far',
    iconName: 'chess-clock',
    icon: [640, 512, [], "f43d", "M576 112H544V104C544 91 533 80 520 80H408C395 80 384 91 384 104V112H200V80H232C245 80 256 69 256 56S245 32 232 32H120C107 32 96 43 96 56S107 80 120 80H152V112H64C29 112 0 141 0 176V416C0 451 29 480 64 480H576C611 480 640 451 640 416V176C640 141 611 112 576 112ZM592 416C592 425 585 432 576 432H64C55 432 48 425 48 416V176C48 167 55 160 64 160H576C585 160 592 167 592 176V416ZM200 192C143 192 96 239 96 296S143 400 200 400S304 353 304 296S257 192 200 192ZM216 288C216 297 209 304 200 304S184 297 184 288V240C184 231 191 224 200 224S216 231 216 240V288ZM366 222C326 263 326 329 366 370C407 410 473 410 514 370C554 329 554 263 514 222C473 182 407 182 366 222ZM491 268L457 302C451 308 441 308 434 302S428 285 434 279L468 245C475 239 485 239 491 245S497 261 491 268Z"]
  };
  var faChessClockFlip = {
    prefix: 'far',
    iconName: 'chess-clock-flip',
    icon: [640, 512, [], "f43e", "M440 192C383 192 336 239 336 296S383 400 440 400S544 353 544 296S497 192 440 192ZM456 288C456 297 449 304 440 304S424 297 424 288V240C424 231 431 224 440 224S456 231 456 240V288ZM0 176L0 416C0 451 29 480 64 480H576C611 480 640 451 640 416V176C640 141 611 112 576 112H488V80H520C533 80 544 69 544 56S533 32 520 32H408C395 32 384 43 384 56S395 80 408 80H440V112H256V104C256 91 245 80 232 80H120C107 80 96 91 96 104V112H64C29 112 0 141 0 176ZM48 176C48 167 55 160 64 160H576C585 160 592 167 592 176V416C592 425 585 432 576 432H64C55 432 48 425 48 416V176ZM126 222C86 263 86 329 126 370C167 410 233 410 274 370C314 329 314 263 274 222C233 182 167 182 126 222ZM251 268L217 302C211 308 201 308 194 302C188 295 188 285 194 279L228 245C235 239 245 239 251 245S257 261 251 268Z"]
  };
  var faChessKing = {
    prefix: 'far',
    iconName: 'chess-king',
    icon: [448, 512, [], "f43f", "M392 464H56C43 464 32 475 32 488V488C32 501 43 512 56 512H392C405 512 416 501 416 488V488C416 475 405 464 392 464ZM437 183C427 168 410 160 392 160H248V104H280C293 104 304 93 304 80V80C304 67 293 56 280 56H248V24C248 11 237 0 224 0H224C211 0 200 11 200 24V56H168C155 56 144 67 144 80V80C144 93 155 104 168 104H200V160H56C38 160 21 169 11 183C0 197 -3 216 3 233L68 432H119L48 218C48 216 48 213 50 211C51 209 53 208 56 208H392C394 208 397 209 398 211C400 213 400 216 400 218L329 432H379L445 233C451 216 448 197 437 183Z"]
  };
  var faChessKingPiece = {
    prefix: 'far',
    iconName: 'chess-king-piece',
    icon: [256, 512, [], "f440", "M250 435L224 416V392C224 382 217 373 207 370C203 345 201 319 201 294V256H208C217 256 224 249 224 240V224C224 215 217 208 208 208H205L232 128C234 120 233 112 229 106C224 100 217 96 209 96H145V64H161C170 64 177 57 177 48V48C177 39 170 32 161 32H145V16C145 7 138 0 129 0H129C120 0 113 7 113 16V32H97C88 32 81 39 81 48V48C81 57 88 64 97 64H113V96H49C41 96 34 100 29 106C24 112 23 120 26 128L53 208H48C39 208 32 215 32 224V240C32 249 39 256 48 256H57V294C57 319 54 344 50 369C40 372 32 381 32 392V416L6 435C2 438 0 443 0 448V496C0 505 7 512 16 512H240C249 512 256 505 256 496V448C256 443 254 438 250 435ZM176 144L154 208H103L82 144H176ZM158 368H99C102 343 105 319 105 294V256H153V294C153 319 155 343 158 368ZM48 464L80 440V416H176V440L208 464H48Z"]
  };
  var faChessKnight = {
    prefix: 'far',
    iconName: 'chess-knight',
    icon: [384, 512, [], "f441", "M44 321L58 327C41 347 32 373 32 400V432H80V400C80 375 94 353 116 341L154 318C168 311 176 298 176 283V224L161 233C156 236 152 240 151 246L143 271C141 279 135 285 128 288L117 292C111 295 103 294 97 292L63 277C54 273 48 263 48 253V141C48 135 50 130 54 127L61 119L50 96C49 94 48 92 48 90C48 84 52 80 58 80H163C250 80 320 150 320 237V432H368V237C368 124 276 32 163 32H58C26 32 0 58 0 90C0 98 2 107 5 115C2 123 0 132 0 141V253C0 282 17 309 44 321ZM80 164C80 175 89 184 100 184C111 184 120 175 120 164S111 144 100 144C89 144 80 153 80 164ZM360 464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H360C373 512 384 501 384 488V488C384 475 373 464 360 464Z"]
  };
  var faChessKnightPiece = {
    prefix: 'far',
    iconName: 'chess-knight-piece',
    icon: [320, 512, [], "f442", "M90 195C95 195 100 192 103 187C105 182 104 175 100 171C96 168 90 166 85 168C79 171 76 176 76 181C76 189 82 195 90 195ZM314 435L288 416V386C298 372 304 356 304 339V233C304 140 228 64 135 64H55C37 64 21 73 10 88C0 102 -3 121 3 138C1 145 0 151 0 158V242C0 268 14 291 37 303C27 318 20 335 17 354C14 375 19 395 32 412V416L6 435C2 438 0 443 0 448V496C0 505 7 512 16 512H304C313 512 320 505 320 496V448C320 443 318 438 314 435ZM55 112H135C202 112 256 166 256 233V339C256 347 253 355 247 361L240 368H65C65 366 64 364 64 362C69 333 86 316 111 305L145 294C154 290 160 281 160 271V223L133 228C129 230 126 233 125 237L120 256C118 262 114 267 108 269S98 274 93 274C90 274 87 273 85 272L60 261C53 258 48 250 48 242V158C48 150 52 147 58 142L49 124C46 118 50 112 55 112ZM48 464L80 440V416H240V440L272 464H48Z"]
  };
  var faChessPawn = {
    prefix: 'far',
    iconName: 'chess-pawn',
    icon: [320, 512, [], "f443", "M296 464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H296C309 512 320 501 320 488V488C320 475 309 464 296 464ZM56 288H80V318C80 358 77 399 57 432H110C125 395 128 355 128 318V288H192V318C192 355 195 395 210 432H263C244 399 240 358 240 318V288H264C277 288 288 277 288 264V264C288 251 277 240 264 240H241C271 212 288 169 277 123C266 78 228 42 183 34C107 20 40 78 40 152C40 187 55 218 79 240H56C43 240 32 251 32 264V264C32 277 43 288 56 288ZM160 80C200 80 232 112 232 152S200 224 160 224S88 192 88 152S120 80 160 80Z"]
  };
  var faChessPawnPiece = {
    prefix: 'far',
    iconName: 'chess-pawn-piece',
    icon: [256, 512, [], "f444", "M250 435L224 416V392C224 379 213 368 200 368H203C201 352 200 336 200 320V288H208C217 288 224 281 224 272V256C224 249 218 242 210 241C219 226 224 210 224 193C224 152 199 116 161 102C123 88 80 99 54 131C28 162 25 206 46 241C38 242 32 249 32 256V272C32 281 39 288 48 288H56V320C56 336 55 352 53 368H56C43 368 32 379 32 392V416L6 435C2 438 0 443 0 448V496C0 505 7 512 16 512H240C249 512 256 505 256 496V448C256 443 254 438 250 435ZM152 288V318C152 335 153 352 154 368H102C103 352 104 335 104 318V288H152ZM128 145C154 145 176 166 176 193S154 240 128 240S80 219 80 193S102 145 128 145ZM48 464L80 440V416H176V440L208 464H48Z"]
  };
  var faChessQueen = {
    prefix: 'far',
    iconName: 'chess-queen',
    icon: [512, 512, [], "f445", "M256 112C287 112 312 87 312 56S287 0 256 0S200 25 200 56S225 112 256 112ZM505 184L476 168C474 166 471 166 468 166C462 166 457 169 454 173C445 185 431 192 416 192C413 192 410 192 407 191C384 187 368 165 368 141C368 134 362 128 355 128H316C310 128 304 132 303 138C298 160 279 176 256 176C233 176 214 160 209 138C208 132 202 128 196 128H157C150 128 144 134 144 141C144 167 125 190 99 192C98 192 97 192 96 192C81 192 67 185 58 173C55 168 50 166 44 166C41 166 38 166 36 168L7 184C0 189 -2 198 2 205L110 432H163L70 236C78 239 87 240 96 240C98 240 100 240 103 240C137 238 166 217 181 187C199 210 227 224 256 224C285 224 313 211 331 188C344 214 369 233 398 238C404 239 410 240 416 240C425 240 434 239 442 237L349 432H402L510 205C514 197 512 189 505 184ZM424 464H88C75 464 64 475 64 488V488C64 501 75 512 88 512H424C437 512 448 501 448 488V488C448 475 437 464 424 464Z"]
  };
  var faChessQueenPiece = {
    prefix: 'far',
    iconName: 'chess-queen-piece',
    icon: [256, 512, [], "f446", "M224 416V392C224 381 216 372 205 369C202 347 200 324 200 302V256H224C233 256 240 249 240 240V224C240 215 233 208 224 208H217L255 103C257 99 256 95 252 93L240 85C237 82 232 83 229 87C215 106 185 96 185 71C185 69 185 67 183 66C182 65 180 64 178 64H159C155 64 153 66 152 69C150 80 140 88 128 88C117 88 107 80 104 69C104 66 101 64 98 64H78C74 64 71 67 71 71C71 96 41 105 27 87C25 83 20 82 16 85L4 93C1 95 -1 99 1 103L40 208H32C24 208 16 215 16 224V240C16 249 24 256 32 256H56V302C56 325 54 347 51 369C40 371 32 381 32 392V416L6 435C2 438 0 443 0 448V496C0 505 7 512 16 512H240C248 512 256 505 256 496V448C256 443 253 438 249 435L224 416ZM93 127C115 139 141 139 163 127C171 134 180 139 190 142L167 208H90L67 142C76 139 86 134 93 127ZM157 368H99C102 346 104 324 104 302V256H152V302C152 324 154 346 157 368ZM48 464L80 440V416H176V440L208 464H48ZM128 56C144 56 156 43 156 28S144 0 128 0C113 0 100 13 100 28S113 56 128 56Z"]
  };
  var faChessRook = {
    prefix: 'far',
    iconName: 'chess-rook',
    icon: [384, 512, [], "f447", "M360 464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H360C373 512 384 501 384 488V488C384 475 373 464 360 464ZM346 32H38C17 32 0 49 0 70V209C0 219 4 227 11 234L48 266C48 314 50 359 36 432H85C98 356 96 310 96 238L48 197V80H112V128H160V80H224V128H272V80H336V197L288 238C288 309 286 357 299 432H348C334 359 336 314 336 266L373 234C380 227 384 219 384 209V70C384 49 367 32 346 32ZM192 224C174 224 160 238 160 256V320H224V256C224 238 210 224 192 224Z"]
  };
  var faChessRookPiece = {
    prefix: 'far',
    iconName: 'chess-rook-piece',
    icon: [320, 512, [], "f448", "M314 435L288 416V392C288 381 280 372 270 369L265 251L291 231C299 225 304 216 304 206V96C304 78 290 64 272 64H48C30 64 16 78 16 96V206C16 216 21 226 29 232L55 252L50 369C40 372 32 381 32 392V416L6 435C2 438 0 443 0 448V496C0 505 7 512 16 512H304C313 512 320 505 320 496V448C320 443 318 438 314 435ZM64 112H104V144H136V112H184V144H216V112H256V198L215 229L222 368H98L105 228L64 198V112ZM48 464L80 440V416H240V440L272 464H48ZM184 248C184 234 174 224 160 224C147 224 137 234 137 248V288H184V248Z"]
  };
  var faChevronDown = {
    prefix: 'far',
    iconName: 'chevron-down',
    icon: [448, 512, [], "f078", "M433 209L241 393C236 398 230 400 224 400S212 398 207 393L15 209C6 200 5 185 15 175C24 166 39 166 49 175L224 343L399 175C409 166 424 166 433 175C443 185 442 200 433 209Z"]
  };
  var faChevronLeft = {
    prefix: 'far',
    iconName: 'chevron-left',
    icon: [320, 512, [], "f053", "M207 465L23 273C18 268 16 262 16 256S18 244 23 239L207 47C216 38 231 37 241 47C250 56 250 71 241 81L73 256L241 431C250 441 250 456 241 465C231 474 216 474 207 465Z"]
  };
  var faChevronRight = {
    prefix: 'far',
    iconName: 'chevron-right',
    icon: [320, 512, [], "f054", "M57 47L241 239C246 244 248 250 248 256S246 268 241 273L57 465C48 474 33 475 23 465C14 456 13 441 23 431L191 256L23 81C13 71 14 56 23 47C33 38 48 38 57 47Z"]
  };
  var faChevronUp = {
    prefix: 'far',
    iconName: 'chevron-up',
    icon: [448, 512, [], "f077", "M15 303L207 119C212 114 218 112 224 112S236 114 241 119L433 303C442 312 443 327 433 337C424 346 409 346 399 337L224 169L49 337C39 346 24 346 15 337C5 327 6 312 15 303Z"]
  };
  var faChevronsDown = {
    prefix: 'far',
    iconName: 'chevrons-down',
    icon: [448, 512, [], "f322", "M207 265C217 274 231 274 241 265L425 89C434 80 435 65 425 55C421 50 414 48 408 48C402 48 396 50 391 55L224 215L57 55C47 46 32 46 23 55S14 80 23 89L207 265ZM408 240C402 240 396 242 391 247L224 407L57 247C47 238 32 238 23 247S14 272 23 281L207 457C217 466 231 466 241 457L425 281C434 272 435 257 425 247C421 242 414 240 408 240Z"]
  };
  var faChevronsLeft = {
    prefix: 'far',
    iconName: 'chevrons-left',
    icon: [448, 512, [], "f323", "M73 256L233 89C242 79 242 64 233 55S208 46 199 55L23 239C14 249 14 263 23 273L199 457C208 466 223 466 233 457C238 453 240 446 240 440C240 434 238 428 233 423L73 256ZM425 423L265 256L425 89C434 79 434 64 425 55S400 46 391 55L215 239C206 249 206 263 215 273L391 457C400 466 415 466 425 457C430 453 432 446 432 440C432 434 430 428 425 423Z"]
  };
  var faChevronsRight = {
    prefix: 'far',
    iconName: 'chevrons-right',
    icon: [448, 512, [], "f324", "M233 239L57 55C48 46 33 45 23 55C18 59 16 66 16 72C16 78 18 84 23 89L183 256L23 423C14 433 14 448 23 457C33 467 48 466 57 457L233 273C242 263 242 249 233 239ZM425 239L249 55C240 46 225 45 215 55C210 59 208 66 208 72C208 78 210 84 215 89L375 256L215 423C206 433 206 448 215 457C225 467 240 466 249 457L425 273C434 263 434 249 425 239Z"]
  };
  var faChevronsUp = {
    prefix: 'far',
    iconName: 'chevrons-up',
    icon: [448, 512, [], "f325", "M57 265L224 105L391 265C396 270 402 272 408 272C414 272 421 270 425 265C434 255 434 240 425 231L241 55C231 46 217 46 207 55L23 231C14 240 13 255 23 265S47 274 57 265ZM241 247C231 238 217 238 207 247L23 423C14 432 13 447 23 457S47 466 57 457L224 297L391 457C396 462 402 464 408 464C414 464 421 462 425 457C435 447 434 432 425 423L241 247Z"]
  };
  var faChild = {
    prefix: 'far',
    iconName: 'child',
    icon: [448, 512, [], "f1ae", "M427 106C420 95 404 93 394 101L325 151C266 194 182 194 123 151L54 101C44 93 28 95 21 106C13 117 15 132 26 139L94 190C105 197 116 204 128 210V488C128 501 139 512 152 512S176 501 176 488V384H272V488C272 501 283 512 296 512S320 501 320 488V210C332 204 343 197 354 190L422 139C433 132 435 117 427 106ZM272 336H176V226C192 230 208 232 224 232S256 230 272 226V336ZM224 144C264 144 296 112 296 72S264 0 224 0S152 32 152 72S184 144 224 144Z"]
  };
  var faChimney = {
    prefix: 'far',
    iconName: 'chimney',
    icon: [448, 512, [], "f78b", "M416 32H32C14 32 0 46 0 64V192C0 210 14 224 32 224V456C32 469 43 480 56 480H56C69 480 80 469 80 456V384H256V456C256 469 267 480 280 480H280C293 480 304 469 304 456V384H368V456C368 469 379 480 392 480H392C405 480 416 469 416 456V224C434 224 448 210 448 192V64C448 46 434 32 416 32ZM160 336H80V224H160V336ZM368 336H208V224H368V336ZM400 176H48V80H400V176Z"]
  };
  var faChurch = {
    prefix: 'far',
    iconName: 'church',
    icon: [640, 512, [], "f51d", "M309 321C278 326 256 356 256 387V480C256 498 270 512 288 512H352C370 512 384 498 384 480V384C384 345 349 314 309 321ZM465 231L344 158V112H392C405 112 416 101 416 88C416 75 405 64 392 64H344V24C344 11 333 0 320 0S296 11 296 24V64H248C235 64 224 75 224 88C224 101 235 112 248 112H296V158L175 231C166 237 160 247 160 258V488C160 501 171 512 184 512S208 501 208 488V267L320 200L432 267V488C432 501 443 512 456 512S480 501 480 488V258C480 247 474 237 465 231ZM93 323L13 363C5 367 0 375 0 384V488C0 501 11 512 24 512S48 501 48 488V399L115 365C127 360 131 345 125 333C120 321 105 317 93 323ZM627 363L547 323C535 317 520 321 515 333C509 345 513 360 525 365L592 399V488C592 501 603 512 616 512S640 501 640 488V384C640 375 635 367 627 363Z"]
  };
  var faCircle = {
    prefix: 'far',
    iconName: 'circle',
    icon: [512, 512, [], "f111", "M256 64C362 64 448 150 448 256S362 448 256 448S64 362 64 256S150 64 256 64M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16L256 16Z"]
  };
  var faCircle0 = {
    prefix: 'far',
    iconName: 'circle-0',
    icon: [512, 512, [], "e0ca", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM256 128C203 128 160 171 160 224V288C160 341 203 384 256 384S352 341 352 288V224C352 171 309 128 256 128ZM304 288C304 314 282 336 256 336S208 314 208 288V224C208 198 230 176 256 176S304 198 304 224V288Z"]
  };
  var faCircle1 = {
    prefix: 'far',
    iconName: 'circle-1',
    icon: [512, 512, [], "e0cb", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM320 336H280V152C280 143 275 135 267 131C260 127 250 127 243 132L191 167C180 174 177 189 184 200C191 211 206 214 217 207L232 197V336H192C179 336 168 347 168 360S179 384 192 384H320C333 384 344 373 344 360S333 336 320 336Z"]
  };
  var faCircle2 = {
    prefix: 'far',
    iconName: 'circle-2',
    icon: [512, 512, [], "e0cc", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM328 336H246L309 279C326 262 336 240 336 216S326 170 309 154C274 120 218 120 183 154L172 164C163 174 162 189 172 198C181 208 196 208 206 199L217 188C233 172 259 172 276 188C283 196 288 206 288 216S283 237 276 244L168 342C161 349 158 359 162 369C165 378 174 384 184 384H328C341 384 352 373 352 360S341 336 328 336Z"]
  };
  var faCircle3 = {
    prefix: 'far',
    iconName: 'circle-3',
    icon: [512, 512, [], "e0cd", "M277 217L328 170C336 163 338 153 334 143C331 134 322 128 312 128H184C171 128 160 139 160 152S171 176 184 176H250L200 222C192 229 190 239 194 249C197 258 206 264 216 264H268C288 264 304 280 304 300S288 336 268 336H223C216 336 209 331 207 324C203 311 189 305 176 309C164 313 157 327 161 339C170 366 195 384 223 384H268C314 384 352 346 352 300C352 257 319 221 277 217ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircle4 = {
    prefix: 'far',
    iconName: 'circle-4',
    icon: [512, 512, [], "e0ce", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM328 272H320V221C320 208 309 197 296 197S272 208 272 221V272H206L254 162C259 149 254 135 241 130C229 125 215 130 210 142L148 286C145 294 146 302 150 309S162 320 170 320H272V360C272 373 283 384 296 384S320 373 320 360V320H328C341 320 352 309 352 296S341 272 328 272Z"]
  };
  var faCircle5 = {
    prefix: 'far',
    iconName: 'circle-5',
    icon: [512, 512, [], "e0cf", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM282 226L220 219L229 176H312C325 176 336 165 336 152S325 128 312 128H209C197 128 187 136 185 148L168 236C167 242 169 249 173 254C177 260 183 263 189 264L277 274C292 276 304 289 304 305C304 322 290 336 273 336H223C216 336 209 331 207 324C203 311 189 305 176 309C164 313 157 327 161 339C170 366 195 384 223 384H273C317 384 352 349 352 305C352 265 322 231 282 226Z"]
  };
  var faCircle6 = {
    prefix: 'far',
    iconName: 'circle-6',
    icon: [640, 512, [], "e0d0", "M346 196L376 170C386 161 387 146 378 136C373 131 367 128 360 128C354 128 349 130 344 134L264 204C252 215 224 247 224 288C224 341 267 384 320 384S416 341 416 288C416 244 386 207 346 196ZM320 336C294 336 272 314 272 288C272 283 273 279 274 274C280 254 299 240 320 240C346 240 368 262 368 288S346 336 320 336ZM320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 448C214 448 128 362 128 256S214 64 320 64S512 150 512 256S426 448 320 448Z"]
  };
  var faCircle7 = {
    prefix: 'far',
    iconName: 'circle-7',
    icon: [512, 512, [], "e0d1", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM328 128H184C171 128 160 139 160 152S171 176 184 176H288L195 349C189 360 193 375 205 381C208 383 212 384 216 384C225 384 233 379 237 371L349 163C353 156 353 147 349 140C344 132 336 128 328 128Z"]
  };
  var faCircle8 = {
    prefix: 'far',
    iconName: 'circle-8',
    icon: [512, 512, [], "e0d2", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM336 200C336 160 304 128 264 128H248C208 128 176 160 176 200C176 216 181 230 190 242C172 257 160 279 160 304C160 348 196 384 240 384H272C316 384 352 348 352 304C352 279 340 257 322 242C331 230 336 216 336 200ZM248 176H264C277 176 288 187 288 200S277 224 264 224H248C235 224 224 213 224 200S235 176 248 176ZM272 336H240C222 336 208 322 208 304S222 272 240 272H272C290 272 304 286 304 304S290 336 272 336Z"]
  };
  var faCircle9 = {
    prefix: 'far',
    iconName: 'circle-9',
    icon: [512, 512, [], "e0d3", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM256 128C203 128 160 171 160 224C160 268 190 305 230 316L200 342C190 351 189 366 198 376C203 381 209 384 216 384C222 384 227 382 232 378L312 308C324 297 352 265 352 224C352 171 309 128 256 128ZM302 238C296 258 277 272 256 272C230 272 208 250 208 224S230 176 256 176S304 198 304 224C304 229 303 233 302 238Z"]
  };
  var faCircleA = {
    prefix: 'far',
    iconName: 'circle-a',
    icon: [512, 512, [], "e0d4", "M278 125C270 108 242 108 234 125L138 334C133 346 138 360 150 366C162 371 176 366 182 354L194 328H318L330 354C334 363 343 368 352 368C355 368 359 367 362 366C374 360 379 346 374 334L278 125ZM216 280L256 192L296 280H216ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleAmpersand = {
    prefix: 'far',
    iconName: 'circle-ampersand',
    icon: [512, 512, [], "e0d5", "M331 315L360 274C367 263 364 248 353 241C342 233 327 236 320 247L298 279L268 246L288 230C302 219 310 203 310 186C310 154 284 128 252 128H229C197 128 171 154 171 186C171 202 177 218 188 230L199 241L169 265C153 278 144 297 144 317C144 354 174 384 211 384H243C267 384 289 374 303 356L322 376C327 381 333 384 340 384C346 384 351 382 356 378C366 369 366 354 358 344L331 315ZM229 176H252C257 176 262 180 262 186C262 189 260 191 258 193L236 211L224 197C221 194 219 190 219 186C219 180 223 176 229 176ZM268 323C263 331 253 336 243 336H211C200 336 192 328 192 317C192 311 195 306 199 302L231 277L270 320L268 323ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleArrowDown = {
    prefix: 'far',
    iconName: 'circle-arrow-down',
    icon: [512, 512, [], "f0ab", "M342 248L280 315V144C280 131 269 120 256 120S232 131 232 144V315L170 248C161 238 145 237 136 246C126 255 125 271 134 280L238 392C243 397 249 400 256 400S269 397 274 392L378 280C387 271 386 255 376 246C367 237 351 238 342 248ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleArrowLeft = {
    prefix: 'far',
    iconName: 'circle-arrow-left',
    icon: [512, 512, [], "f0a8", "M368 232H197L264 170C274 161 275 145 266 136C257 126 241 125 232 134L120 238C115 243 112 249 112 256S115 269 120 274L232 378C241 387 257 386 266 376C275 367 274 351 264 342L197 280H368C381 280 392 269 392 256S381 232 368 232ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleArrowRight = {
    prefix: 'far',
    iconName: 'circle-arrow-right',
    icon: [512, 512, [], "f0a9", "M392 238L280 134C271 125 255 126 246 136C237 145 238 161 248 170L315 232H144C131 232 120 243 120 256S131 280 144 280H315L248 342C238 351 237 367 246 376C255 386 271 387 280 378L392 274C397 269 400 263 400 256S397 243 392 238ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleArrowUp = {
    prefix: 'far',
    iconName: 'circle-arrow-up',
    icon: [512, 512, [], "f0aa", "M274 120C269 115 263 112 256 112S243 115 238 120L134 232C125 241 126 257 136 266C145 275 161 274 170 264L232 197V368C232 381 243 392 256 392S280 381 280 368V197L342 264C351 274 367 275 376 266C386 257 387 241 378 232L274 120ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleB = {
    prefix: 'far',
    iconName: 'circle-b',
    icon: [512, 512, [], "e0d6", "M338 248C347 235 352 220 352 204C352 162 318 128 276 128H184C171 128 160 139 160 152V360C160 373 171 384 184 384H292C334 384 368 350 368 308C368 283 356 262 338 248ZM208 176H276C291 176 304 189 304 204S291 232 276 232H208V176ZM292 336H208V280H292C307 280 320 293 320 308S307 336 292 336ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleBookOpen = {
    prefix: 'far',
    iconName: 'circle-book-open',
    icon: [512, 512, [], "e0d7", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM137 173C131 175 128 180 128 186V342C128 347 134 350 139 348C189 326 228 345 240 352V169C230 165 215 160 196 160C178 160 158 164 137 173ZM375 173C354 164 334 160 316 160C297 160 282 165 272 169V352C284 345 323 326 373 348C378 350 384 347 384 342V186C384 180 381 175 375 173Z"]
  };
  var faCircleBookmark = {
    prefix: 'far',
    iconName: 'circle-bookmark',
    icon: [512, 512, [], "e0d8", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM309 144H203C188 144 176 156 176 171V336C176 349 192 357 202 348L256 304L310 348C320 357 336 349 336 336V171C336 156 324 144 309 144Z"]
  };
  var faCircleC = {
    prefix: 'far',
    iconName: 'circle-c',
    icon: [512, 512, [], "e0d9", "M311 199C320 209 335 209 345 199C354 190 354 175 345 166C297 117 213 117 165 166C116 215 116 297 165 346C189 371 221 384 255 384C255 384 255 384 255 384C289 384 321 371 345 346C354 337 354 322 345 312C335 303 320 303 311 313C296 328 276 336 255 336S214 328 199 313C168 281 168 231 199 199C229 169 281 169 311 199ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleCalendar = {
    prefix: 'far',
    iconName: 'circle-calendar',
    icon: [512, 512, [], "e0da", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM336 160H320V144C320 135 313 128 304 128S288 135 288 144V160H224V144C224 135 217 128 208 128S192 135 192 144V160H176C158 160 144 174 144 192V336C144 354 158 368 176 368H336C354 368 368 354 368 336V192C368 174 354 160 336 160ZM320 320H192V240H320V320Z"]
  };
  var faCircleCamera = {
    prefix: 'far',
    iconName: 'circle-camera',
    icon: [512, 512, [], "e0db", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM352 160H316L310 144C306 134 297 128 287 128H225C215 128 206 134 202 144L196 160H160C142 160 128 174 128 192V320C128 338 142 352 160 352H352C370 352 384 338 384 320V192C384 174 370 160 352 160ZM256 304C230 304 208 282 208 256S230 208 256 208S304 230 304 256S282 304 256 304Z"]
  };
  var faCircleCaretDown = {
    prefix: 'far',
    iconName: 'circle-caret-down',
    icon: [512, 512, [], "f32d", "M352 208H160C150 208 142 214 138 222C134 231 136 241 142 248L238 352C243 357 249 360 256 360S269 357 274 352L370 248C376 241 378 231 374 222C370 214 362 208 352 208ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleCaretLeft = {
    prefix: 'far',
    iconName: 'circle-caret-left',
    icon: [512, 512, [], "f32e", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM290 138C281 134 271 136 264 142L160 238C155 243 152 249 152 256S155 269 160 274L264 370C271 376 281 378 290 374C298 370 304 362 304 352V160C304 150 298 142 290 138Z"]
  };
  var faCircleCaretRight = {
    prefix: 'far',
    iconName: 'circle-caret-right',
    icon: [512, 512, [], "f330", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256C496 123 389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256C448 362 362 448 256 448ZM248 142C241 136 231 134 222 138C214 142 208 150 208 160V352C208 362 214 370 222 374C231 378 241 376 248 370L352 274C357 269 360 263 360 256S357 243 352 238L248 142Z"]
  };
  var faCircleCaretUp = {
    prefix: 'far',
    iconName: 'circle-caret-up',
    icon: [512, 512, [], "f331", "M274 160C269 155 263 152 256 152S243 155 238 160L142 264C136 271 134 281 138 290C142 298 150 304 160 304H352C362 304 370 298 374 290C378 281 376 271 370 264L274 160ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleCheck = {
    prefix: 'far',
    iconName: 'circle-check',
    icon: [512, 512, [], "f058", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM335 175L224 286L177 239C168 230 152 230 143 239S134 264 143 273L207 337C212 342 218 344 224 344S236 342 241 337L369 209C378 200 378 184 369 175S344 166 335 175Z"]
  };
  var faCircleChevronDown = {
    prefix: 'far',
    iconName: 'circle-chevron-down',
    icon: [512, 512, [], "f13a", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM385 207C376 198 360 198 351 207L256 302L161 207C152 198 136 198 127 207S118 232 127 241L239 353C244 358 250 360 256 360S268 358 273 353L385 241C394 232 394 216 385 207Z"]
  };
  var faCircleChevronLeft = {
    prefix: 'far',
    iconName: 'circle-chevron-left',
    icon: [512, 512, [], "f137", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM305 127C296 118 280 118 271 127L159 239C154 244 152 250 152 256S154 268 159 273L271 385C280 394 296 394 305 385S314 360 305 351L210 256L305 161C314 152 314 136 305 127Z"]
  };
  var faCircleChevronRight = {
    prefix: 'far',
    iconName: 'circle-chevron-right',
    icon: [512, 512, [], "f138", "M241 127C232 118 216 118 207 127S198 152 207 161L302 256L207 351C198 360 198 376 207 385S232 394 241 385L353 273C358 268 360 262 360 256S358 244 353 239L241 127ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleChevronUp = {
    prefix: 'far',
    iconName: 'circle-chevron-up',
    icon: [512, 512, [], "f139", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM385 271L273 159C268 154 262 152 256 152S244 154 239 159L127 271C118 280 118 296 127 305S152 314 161 305L256 210L351 305C360 314 376 314 385 305S394 280 385 271Z"]
  };
  var faCircleD = {
    prefix: 'far',
    iconName: 'circle-d',
    icon: [512, 512, [], "e0dc", "M254 128H184C171 128 160 139 160 152V360C160 373 171 384 184 384H254C326 384 384 327 384 256C384 185 326 128 254 128ZM254 336H208V176H254C299 176 336 212 336 256C336 300 299 336 254 336ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleDashed = {
    prefix: 'far',
    iconName: 'circle-dashed',
    icon: [512, 512, [], "e0dd", "M90 124C79 113 61 115 53 128C38 151 28 176 22 203C18 218 30 232 45 232H45C57 232 66 224 69 213C74 192 82 172 93 154C99 144 98 132 90 124L90 124ZM213 443C192 438 172 430 155 419C145 413 132 414 124 422C113 433 115 451 128 459C151 474 176 484 203 490C218 494 232 482 232 467V467C232 455 224 446 213 443ZM443 213C445 224 455 232 466 232H466C481 232 493 218 490 203C484 176 473 151 459 129C451 116 433 114 422 125L422 125C414 133 413 145 419 155C430 173 438 192 443 213ZM69 299C66 288 57 280 45 280H45C30 280 18 294 22 309C28 336 38 361 53 384C61 397 79 399 90 388L90 388C98 380 99 368 93 358C82 340 74 320 69 299ZM388 421C380 413 367 412 358 418C340 430 320 438 299 443C288 445 280 455 280 466V466C280 482 295 493 309 490C336 484 361 473 384 459C397 451 399 432 388 421L388 421ZM203 22C176 28 151 38 128 53C115 61 113 79 124 90C132 98 145 99 155 93C172 82 192 74 213 69C224 66 232 57 232 45C232 30 218 18 203 22ZM466 280H466C455 280 445 288 443 299C438 320 430 339 419 357C413 367 414 379 422 387L422 387C433 398 451 396 459 383C473 361 484 336 490 309C493 294 481 280 466 280ZM309 22C295 19 280 30 280 46V46C280 57 288 67 299 69C320 74 340 82 358 94C367 100 380 99 388 90L388 90C399 80 397 61 384 53C361 39 336 28 309 22Z"]
  };
  var faCircleDollar = {
    prefix: 'far',
    iconName: 'circle-dollar',
    icon: [496, 512, [], "f2e8", "M291 244l-72-21.9c-9-2.8-15.2-12.1-15.2-22.7 0-12.9 9.2-23.4 20.5-23.4h45c7 0 13.8 1.9 19.9 5.4 6.4 3.7 14.3 3.4 19.7-1.6l12-11.3c7.6-7.2 6.3-19.4-2.3-25.2-13.8-9.3-29.9-14.5-46.4-15.1V112c0-8.8-7.2-16-16-16h-16c-8.8 0-16 7.2-16 16v16c-37.6.1-68.2 32.1-68.2 71.4 0 31.5 20.2 59.7 49.2 68.6l72 21.9c9 2.8 15.2 12.1 15.2 22.7 0 12.9-9.2 23.4-20.5 23.4h-45c-7 0-13.8-1.9-19.9-5.4-6.4-3.7-14.3-3.4-19.7 1.6l-12 11.3c-7.6 7.2-6.3 19.4 2.3 25.2 13.8 9.3 29.9 14.5 46.4 15.1V400c0 8.8 7.2 16 16 16h16c8.8 0 16-7.2 16-16v-16c37.6-.1 68.2-32.1 68.2-71.4 0-31.5-20.2-59.7-49.2-68.6zM248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-110.3 0-200-89.7-200-200S137.7 56 248 56s200 89.7 200 200-89.7 200-200 200z"]
  };
  var faCircleDollarToSlot = {
    prefix: 'far',
    iconName: 'circle-dollar-to-slot',
    icon: [512, 512, [], "f4b9", "M280 248C281 243 281 240 249 231L243 229C225 224 176 210 185 160C189 136 207 120 232 114V104C232 91 243 80 256 80S280 91 280 104V115C286 117 292 118 300 121C312 125 319 139 315 152C310 164 297 171 284 166C276 163 269 162 265 161C248 158 233 162 232 168C232 172 231 176 256 183L263 185C288 192 336 206 327 256C323 280 305 296 280 302V312C280 325 269 336 256 336S232 325 232 312V301C223 298 213 295 205 292L200 291C187 286 181 272 185 260S203 241 216 245L221 247C230 250 240 254 247 255C264 258 279 254 280 248ZM48 208C48 93 141 0 256 0S464 93 464 208S371 416 256 416S48 323 48 208ZM96 208C96 296 168 368 256 368S416 296 416 208S344 48 256 48S96 120 96 208ZM461 352C447 352 437 363 437 376S447 400 461 400C462 400 464 402 464 403V456C464 460 460 464 456 464H310H205H56C52 464 48 460 48 456V403C48 402 50 400 51 400C65 400 75 389 75 376S65 352 51 352C23 352 0 375 0 403V456C0 487 25 512 56 512H205H310H456C487 512 512 487 512 456V403C512 375 489 352 461 352Z"]
  };
  var faCircleDot = {
    prefix: 'far',
    iconName: 'circle-dot',
    icon: [512, 512, [], "f192", "M256 16C123 16 16 123 16 256C16 389 123 496 256 496S496 389 496 256C496 123 389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM256 160C203 160 160 203 160 256C160 309 203 352 256 352S352 309 352 256C352 203 309 160 256 160Z"]
  };
  var faCircleDown = {
    prefix: 'far',
    iconName: 'circle-down',
    icon: [512, 512, [], "f358", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM344 240H288L288 152C288 139 277 128 264 128H248C235 128 224 139 224 152L224 240H168C158 240 150 246 146 254C142 263 144 273 150 280L239 376C244 381 250 384 257 384C265 384 270 381 275 376L362 280C368 273 370 263 366 254S354 240 344 240Z"]
  };
  var faCircleE = {
    prefix: 'far',
    iconName: 'circle-e',
    icon: [512, 512, [], "e0de", "M328 176C341 176 352 165 352 152S341 128 328 128H184C171 128 160 139 160 152V360C160 373 171 384 184 384H328C341 384 352 373 352 360S341 336 328 336H208V280H296C309 280 320 269 320 256S309 232 296 232H208V176H328ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleEnvelope = {
    prefix: 'far',
    iconName: 'circle-envelope',
    icon: [512, 512, [], "e0df", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM256 288C254 288 252 288 250 287L128 238V320C128 338 142 352 160 352H352C370 352 384 338 384 320V238L262 287C260 288 258 288 256 288ZM352 160H160C142 160 128 174 128 192V204L256 255L384 204V192C384 174 370 160 352 160Z"]
  };
  var faCircleExclamation = {
    prefix: 'far',
    iconName: 'circle-exclamation',
    icon: [512, 512, [], "f06a", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM256 304C269 304 280 293 280 280V152C280 139 269 128 256 128S232 139 232 152V280C232 293 243 304 256 304ZM256 337C239 337 225 351 225 369C225 386 239 400 256 400S287 386 287 369C287 351 273 337 256 337Z"]
  };
  var faCircleF = {
    prefix: 'far',
    iconName: 'circle-f',
    icon: [512, 512, [], "e0e0", "M328 128H184C171 128 160 139 160 152V360C160 373 171 384 184 384S208 373 208 360V288H296C309 288 320 277 320 264S309 240 296 240H208V176H328C341 176 352 165 352 152S341 128 328 128ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleG = {
    prefix: 'far',
    iconName: 'circle-g',
    icon: [640, 512, [], "e0e1", "M408 128C395 128 384 139 384 152V232H256V152C256 139 245 128 232 128S208 139 208 152V360C208 373 219 384 232 384S256 373 256 360V280H384V360C384 373 395 384 408 384S432 373 432 360V152C432 139 421 128 408 128ZM-1112 240H-1192C-1205 240 -1216 251 -1216 264S-1205 288 -1192 288H-1142C-1146 297 -1152 305 -1159 313C-1190 343 -1242 343 -1273 313C-1304 281 -1304 231 -1273 199C-1242 169 -1192 168 -1160 196C-1150 205 -1135 204 -1126 194C-1117 185 -1118 169 -1128 161C-1179 115 -1259 118 -1306 165C-1356 215 -1356 297 -1306 346C-1282 371 -1250 384 -1216 384S-1150 371 -1126 347C-1106 327 -1093 303 -1088 279C-1088 278 -1088 276 -1088 275V264C-1088 251 -1099 240 -1112 240ZM-1216 16C-1349 16 -1456 123 -1456 256S-1349 496 -1216 496S-976 389 -976 256S-1083 16 -1216 16ZM-1216 448C-1322 448 -1408 362 -1408 256S-1322 64 -1216 64S-1024 150 -1024 256S-1110 448 -1216 448ZM320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 448C214 448 128 362 128 256S214 64 320 64S512 150 512 256S426 448 320 448Z"]
  };
  var faCircleH = {
    prefix: 'far',
    iconName: 'circle-h',
    icon: [640, 512, [], "f47e", "M408 128C395 128 384 139 384 152V232H256V152C256 139 245 128 232 128S208 139 208 152V360C208 373 219 384 232 384S256 373 256 360V280H384V360C384 373 395 384 408 384S432 373 432 360V152C432 139 421 128 408 128ZM-1112 240H-1192C-1205 240 -1216 251 -1216 264S-1205 288 -1192 288H-1142C-1146 297 -1152 305 -1159 313C-1190 343 -1242 343 -1273 313C-1304 281 -1304 231 -1273 199C-1242 169 -1192 168 -1160 196C-1150 205 -1135 204 -1126 194C-1117 185 -1118 169 -1128 161C-1179 115 -1259 118 -1306 165C-1356 215 -1356 297 -1306 346C-1282 371 -1250 384 -1216 384S-1150 371 -1126 347C-1106 327 -1093 303 -1088 279C-1088 278 -1088 276 -1088 275V264C-1088 251 -1099 240 -1112 240ZM-1216 16C-1349 16 -1456 123 -1456 256S-1349 496 -1216 496S-976 389 -976 256S-1083 16 -1216 16ZM-1216 448C-1322 448 -1408 362 -1408 256S-1322 64 -1216 64S-1024 150 -1024 256S-1110 448 -1216 448ZM320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 448C214 448 128 362 128 256S214 64 320 64S512 150 512 256S426 448 320 448Z"]
  };
  var faCircleHalf = {
    prefix: 'far',
    iconName: 'circle-half',
    icon: [512, 512, [], "e0e2", "M224 18C223 18 221 18 220 19C104 36 16 136 16 256S104 476 220 493C221 494 223 494 224 494C242 494 256 479 256 461V51C256 33 242 18 224 18ZM208 442C125 420 64 344 64 256S125 92 208 70V442Z"]
  };
  var faCircleHalfStroke = {
    prefix: 'far',
    iconName: 'circle-half-stroke',
    icon: [512, 512, [], "f042", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448V64C362 64 448 150 448 256S362 448 256 448Z"]
  };
  var faCircleHeart = {
    prefix: 'far',
    iconName: 'circle-heart',
    icon: [512, 512, [], "f4c7", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM362 171C332 146 287 146 256 171C225 146 180 146 150 171C132 186 121 208 120 232C119 255 128 278 144 295L229 381C236 388 246 392 256 392H256C266 392 276 388 283 381L368 295C384 278 393 255 392 232C391 208 380 186 362 171ZM334 261L256 340L178 261C171 254 168 244 168 234C169 224 173 214 181 208C187 203 195 200 202 200C212 200 223 204 230 212L256 237L282 212C295 198 317 196 331 208C339 214 344 224 344 234C344 244 341 254 334 261Z"]
  };
  var faCircleI = {
    prefix: 'far',
    iconName: 'circle-i',
    icon: [512, 512, [], "e0e3", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM328 176C341 176 352 165 352 152S341 128 328 128H184C171 128 160 139 160 152S171 176 184 176H232V336H184C171 336 160 347 160 360S171 384 184 384H328C341 384 352 373 352 360S341 336 328 336H280V176H328Z"]
  };
  var faCircleInfo = {
    prefix: 'far',
    iconName: 'circle-info',
    icon: [512, 512, [], "f05a", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM296 336H280V248C280 235 269 224 256 224H224C211 224 200 235 200 248S211 272 224 272H232V336H216C203 336 192 347 192 360S203 384 216 384H296C309 384 320 373 320 360S309 336 296 336ZM256 192C274 192 288 178 288 160C288 142 274 128 256 128S224 142 224 160C224 178 238 192 256 192Z"]
  };
  var faCircleJ = {
    prefix: 'far',
    iconName: 'circle-j',
    icon: [512, 512, [], "e0e4", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM312 128C299 128 288 139 288 152V291C288 316 266 336 240 336S192 316 192 291V280C192 267 181 256 168 256S144 267 144 280V291C144 342 187 384 240 384S336 342 336 291V152C336 139 325 128 312 128Z"]
  };
  var faCircleK = {
    prefix: 'far',
    iconName: 'circle-k',
    icon: [512, 512, [], "e0e5", "M345 135C336 126 321 126 311 135L208 237V152C208 139 197 128 184 128S160 139 160 152V360C160 373 171 384 184 384S208 373 208 360V304L239 273L308 374C313 380 320 384 328 384C333 384 337 383 342 380C353 372 355 357 348 346L276 242C275 241 274 241 273 240L345 169C354 160 354 145 345 135ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleL = {
    prefix: 'far',
    iconName: 'circle-l',
    icon: [512, 512, [], "e0e6", "M328 336H208V152C208 139 197 128 184 128S160 139 160 152V360C160 373 171 384 184 384H328C341 384 352 373 352 360S341 336 328 336ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleLeft = {
    prefix: 'far',
    iconName: 'circle-left',
    icon: [512, 512, [], "f359", "M360 224L272 224V168C272 158 266 150 258 146C249 142 239 144 232 150L136 239C131 244 128 250 128 257C128 265 131 270 136 275L232 362C239 368 249 370 258 366S272 354 272 344L272 288L360 288C373 288 384 277 384 264V248C384 235 373 224 360 224ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleLocationArrow = {
    prefix: 'far',
    iconName: 'circle-location-arrow',
    icon: [512, 512, [], "f602", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM329 154L133 238C124 242 118 252 120 262C123 273 132 280 142 280H232V370C232 380 239 389 250 392C251 392 253 392 254 392C263 392 271 387 274 379L358 183V183C362 174 360 165 354 158C347 152 338 150 329 154Z"]
  };
  var faCircleM = {
    prefix: 'far',
    iconName: 'circle-m',
    icon: [512, 512, [], "e0e7", "M367 129C357 126 347 130 341 138L256 255L171 138C165 129 154 126 145 129C135 132 128 142 128 152V360C128 373 139 384 152 384S176 373 176 360V226L237 310C246 323 266 323 275 310L336 226V360C336 373 347 384 360 384S384 373 384 360V152C384 142 377 132 367 129ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleMicrophone = {
    prefix: 'far',
    iconName: 'circle-microphone',
    icon: [512, 512, [], "e0e8", "M256 304C283 304 304 283 304 256V144C304 117 283 96 256 96S208 117 208 144V256C208 283 229 304 256 304ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM360 232C347 232 336 243 336 256C336 300 300 336 256 336S176 300 176 256C176 243 165 232 152 232S128 243 128 256C128 318 173 370 232 382V392C232 405 243 416 256 416S280 405 280 392V382C339 370 384 318 384 256C384 243 373 232 360 232Z"]
  };
  var faCircleMicrophoneLines = {
    prefix: 'far',
    iconName: 'circle-microphone-lines',
    icon: [512, 512, [], "e0e9", "M256 304C283 304 304 283 304 256V224H280C276 224 272 220 272 216S276 208 280 208H304V176H280C276 176 272 172 272 168S276 160 280 160H304V144C304 117 283 96 256 96S208 117 208 144V256C208 283 229 304 256 304ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM360 232C347 232 336 243 336 256C336 300 300 336 256 336S176 300 176 256C176 243 165 232 152 232S128 243 128 256C128 318 173 370 232 382V392C232 405 243 416 256 416S280 405 280 392V382C339 370 384 318 384 256C384 243 373 232 360 232Z"]
  };
  var faCircleMinus = {
    prefix: 'far',
    iconName: 'circle-minus',
    icon: [512, 512, [], "f056", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM352 232H160C147 232 136 243 136 256V256C136 269 147 280 160 280H352C365 280 376 269 376 256V256C376 243 365 232 352 232Z"]
  };
  var faCircleN = {
    prefix: 'far',
    iconName: 'circle-n',
    icon: [512, 512, [], "e0ea", "M328 128C315 128 304 139 304 152V283L204 138C198 130 187 126 177 129C167 132 160 142 160 152V360C160 373 171 384 184 384S208 373 208 360V229L308 374C313 380 320 384 328 384C330 384 333 384 335 383C345 380 352 370 352 360V152C352 139 341 128 328 128ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleNotch = {
    prefix: 'far',
    iconName: 'circle-notch',
    icon: [512, 512, [], "f1ce", "M496 256C496 388 388 496 256 496S16 388 16 256C16 150 84 58 185 27C198 23 211 30 215 43C219 55 212 69 199 73C118 98 64 171 64 256C64 362 150 448 256 448S448 362 448 256C448 171 394 98 313 73C300 69 293 55 297 43C301 30 315 23 327 27C428 58 496 150 496 256Z"]
  };
  var faCircleO = {
    prefix: 'far',
    iconName: 'circle-o',
    icon: [512, 512, [], "e0eb", "M256 128C185 128 128 185 128 256S185 384 256 384S384 327 384 256S327 128 256 128ZM256 336C212 336 176 300 176 256S212 176 256 176S336 212 336 256S300 336 256 336ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleP = {
    prefix: 'far',
    iconName: 'circle-p',
    icon: [512, 512, [], "e0ec", "M280 128H184C171 128 160 139 160 152V360C160 373 171 384 184 384S208 373 208 360V304H280C329 304 368 265 368 216S329 128 280 128ZM280 256H208V176H280C302 176 320 194 320 216S302 256 280 256ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleParking = {
    prefix: 'far',
    iconName: 'circle-parking',
    icon: [512, 512, [], "f615", "M272 128H184C171 128 160 139 160 152V360C160 373 171 384 184 384S208 373 208 360V320H272C325 320 368 277 368 224S325 128 272 128ZM272 272H208V176H272C298 176 320 198 320 224S298 272 272 272ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCirclePause = {
    prefix: 'far',
    iconName: 'circle-pause',
    icon: [512, 512, [], "f28b", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM216 160H168C159 160 152 167 152 176V336C152 345 159 352 168 352H216C225 352 232 345 232 336V176C232 167 225 160 216 160ZM344 160H296C287 160 280 167 280 176V336C280 345 287 352 296 352H344C353 352 360 345 360 336V176C360 167 353 160 344 160Z"]
  };
  var faCirclePhone = {
    prefix: 'far',
    iconName: 'circle-phone',
    icon: [512, 512, [], "e0ed", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM375 304L320 280C314 278 306 279 302 285L280 312C245 295 217 267 200 232L227 210C233 206 234 198 232 192L208 137C205 131 198 127 190 128L140 140C133 142 128 148 128 155C128 281 231 384 357 384C364 384 370 379 372 372L384 322C385 314 382 307 375 304Z"]
  };
  var faCirclePhoneFlip = {
    prefix: 'far',
    iconName: 'circle-phone-flip',
    icon: [512, 512, [], "e0ee", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM372 140L322 128C314 127 307 131 304 137L280 192C278 198 279 206 285 210L312 232C295 267 267 295 232 312L210 285C206 279 198 278 192 280L137 304C130 307 127 314 128 322L140 372C142 379 148 384 155 384C281 384 384 281 384 155C384 148 379 142 372 140Z"]
  };
  var faCirclePhoneHangup = {
    prefix: 'far',
    iconName: 'circle-phone-hangup',
    icon: [512, 512, [], "e0ef", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM418 237C329 148 183 148 94 237C89 242 88 250 92 256L119 300C123 306 131 309 138 306L193 284C200 282 204 275 203 268L200 234C236 221 276 221 312 234L309 268C308 275 312 282 319 284L373 306C381 309 389 306 393 300L420 256C424 250 423 242 418 237Z"]
  };
  var faCirclePlay = {
    prefix: 'far',
    iconName: 'circle-play',
    icon: [512, 512, [], "f144", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM216 142C212 139 205 139 200 142C195 145 192 150 192 156V356C192 362 195 367 200 370C203 371 205 372 208 372C211 372 214 371 216 370L376 270C381 267 384 262 384 256S381 245 376 242L216 142Z"]
  };
  var faCirclePlus = {
    prefix: 'far',
    iconName: 'circle-plus',
    icon: [512, 512, [], "f055", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM352 232H280V160C280 147 269 136 256 136H256C243 136 232 147 232 160V232H160C147 232 136 243 136 256V256C136 269 147 280 160 280H232V352C232 365 243 376 256 376H256C269 376 280 365 280 352V280H352C365 280 376 269 376 256V256C376 243 365 232 352 232Z"]
  };
  var faCircleQ = {
    prefix: 'far',
    iconName: 'circle-q',
    icon: [512, 512, [], "e0f0", "M256 128C185 128 128 185 128 256S185 384 256 384C283 384 307 376 328 362L343 377C348 382 354 384 360 384S372 382 377 377C386 368 386 352 377 343L362 328C376 307 384 283 384 256C384 185 327 128 256 128ZM327 293L297 263C288 254 272 254 263 263S254 288 263 297L293 327C282 332 269 336 256 336C212 336 176 300 176 256S212 176 256 176S336 212 336 256C336 269 332 282 327 293ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleQuarter = {
    prefix: 'far',
    iconName: 'circle-quarter',
    icon: [512, 512, [], "e0f1", "M224 18C222 18 221 18 219 19C116 34 34 116 18 220C15 239 31 256 50 256H224C241 256 256 242 256 224V51C256 33 241 18 224 18ZM208 208H70C87 141 141 87 208 70V208Z"]
  };
  var faCircleQuestion = {
    prefix: 'far',
    iconName: 'circle-question',
    icon: [512, 512, [], "f059", "M256 336C238 336 224 350 224 368S238 400 256 400S288 386 288 368S274 336 256 336ZM290 128H238C199 128 168 159 168 198C168 211 179 222 192 222S216 211 216 198C216 186 226 176 238 176H290C302 176 312 186 312 198C312 206 308 213 301 217L244 251C236 256 232 264 232 272V288C232 301 243 312 256 312S280 301 280 288V286L326 258C347 245 360 222 360 198C360 159 329 128 290 128ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleR = {
    prefix: 'far',
    iconName: 'circle-r',
    icon: [512, 512, [], "e0f2", "M368 208C368 164 332 128 288 128H184C171 128 160 139 160 152V360C160 373 171 384 184 384S208 373 208 360V288H254L317 374C321 381 329 384 336 384C341 384 346 383 350 379C361 372 363 357 355 346L311 284C344 274 368 244 368 208ZM288 240H208V176H288C306 176 320 190 320 208S306 240 288 240ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleRadiation = {
    prefix: 'far',
    iconName: 'circle-radiation',
    icon: [512, 512, [], "f7ba", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM226 209L185 142C180 134 168 132 161 138C131 162 110 197 105 237C104 247 111 256 121 256H200C200 236 211 219 226 209ZM256 288C274 288 288 274 288 256S274 224 256 224C238 224 224 238 224 256S238 288 256 288ZM286 303C277 309 267 312 256 312C245 312 235 309 226 303L185 370C179 379 183 389 192 393C211 403 233 408 256 408C279 408 301 403 320 393C329 389 333 378 327 370L286 303ZM351 138C344 132 333 134 327 142L286 209C301 219 312 236 312 256H391C401 256 408 247 407 237C402 197 381 162 351 138Z"]
  };
  var faCircleRight = {
    prefix: 'far',
    iconName: 'circle-right',
    icon: [512, 512, [], "f35a", "M280 150C273 144 263 142 254 146S240 158 240 168L240 224L152 224C139 224 128 235 128 248V264C128 277 139 288 152 288L240 288V344C240 354 246 362 254 366C263 370 273 368 280 362L376 273C381 268 384 262 384 255C384 247 381 242 376 237L280 150ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleS = {
    prefix: 'far',
    iconName: 'circle-s',
    icon: [512, 512, [], "e0f3", "M262 233C212 219 206 212 209 197C210 191 213 186 218 183C226 178 249 170 302 184C314 187 327 179 331 166C334 153 326 140 313 137C260 123 219 125 192 143C175 153 165 169 161 188C150 252 210 268 250 279C300 293 306 300 303 316C302 323 299 327 293 331C275 341 235 336 193 320C181 315 167 321 162 333C157 346 163 360 175 365C194 372 230 384 266 384C284 384 302 381 317 372C335 362 347 345 351 324C362 261 302 244 262 233ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleSort = {
    prefix: 'far',
    iconName: 'circle-sort',
    icon: [512, 512, [], "e030", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM269 117C266 114 261 112 256 112S246 114 243 117L151 209C140 220 148 240 165 240H348C364 240 372 220 361 209L269 117ZM347 272H165C148 272 140 292 151 303L243 395C246 398 251 400 256 400S266 398 269 395L361 303C372 292 364 272 347 272Z"]
  };
  var faCircleSortDown = {
    prefix: 'far',
    iconName: 'circle-sort-down',
    icon: [512, 512, [], "e031", "M347 272H165C148 272 140 292 151 303L243 395C246 398 251 400 256 400S266 398 269 395L361 303C372 292 364 272 347 272ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM269 117C266 114 261 112 256 112S246 114 243 117L151 209C140 220 148 240 165 240H348C364 240 372 220 361 209L269 117ZM197 208L256 150L315 208H197Z"]
  };
  var faCircleSortUp = {
    prefix: 'far',
    iconName: 'circle-sort-up',
    icon: [512, 512, [], "e032", "M361 209L269 117C266 114 261 112 256 112S246 114 243 117L151 209C140 220 148 240 165 240H348C364 240 372 220 361 209ZM496 256C496 123 389 16 256 16S16 123 16 256S123 496 256 496S496 389 496 256ZM448 256C448 362 362 448 256 448S64 362 64 256S150 64 256 64S448 150 448 256ZM361 303C372 292 364 272 348 272H165C148 272 140 292 151 303L243 395C246 398 251 400 256 400S266 398 269 395L361 303ZM315 304L256 362L197 304H315Z"]
  };
  var faCircleStar = {
    prefix: 'far',
    iconName: 'circle-star',
    icon: [512, 512, [], "e0f4", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM391 200L309 188L272 114C269 107 262 104 256 104C250 104 243 107 240 114L203 188L121 200C106 203 100 221 111 231L170 289L156 371C154 383 164 392 174 392C177 392 180 391 182 390L256 351L330 390C332 391 335 392 338 392C348 392 358 383 356 371L342 289L401 231C412 221 406 203 391 200ZM296 266C292 270 291 275 292 281L298 319L263 301C259 298 253 298 249 301L214 319L220 281C221 275 220 270 216 266L188 239L227 234C232 233 236 230 239 225L256 190L273 225C276 230 280 233 285 234L324 239L296 266Z"]
  };
  var faCircleStop = {
    prefix: 'far',
    iconName: 'circle-stop',
    icon: [512, 512, [], "f28d", "M256 16C123 16 16 123 16 256C16 389 123 496 256 496S496 389 496 256C496 123 389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM328 160H184C171 160 160 171 160 184V328C160 341 171 352 184 352H328C341 352 352 341 352 328V184C352 171 341 160 328 160Z"]
  };
  var faCircleT = {
    prefix: 'far',
    iconName: 'circle-t',
    icon: [512, 512, [], "e0f5", "M360 144H152C139 144 128 155 128 168S139 192 152 192H232V360C232 373 243 384 256 384S280 373 280 360V192H360C373 192 384 181 384 168S373 144 360 144ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleThreeQuarters = {
    prefix: 'far',
    iconName: 'circle-three-quarters',
    icon: [512, 512, [], "e0f6", "M461 256H256V51C256 33 241 18 224 18C223 18 221 19 219 19C89 39 -7 163 21 304C39 398 114 473 208 491C224 494 240 496 256 496C376 496 476 408 493 293C496 273 481 256 461 256ZM256 448C243 448 230 447 217 444C142 430 82 370 68 295C57 242 69 189 99 146C125 108 164 81 208 70V256C208 282 230 304 256 304H442C420 387 344 448 256 448Z"]
  };
  var faCircleTrash = {
    prefix: 'far',
    iconName: 'circle-trash',
    icon: [512, 512, [], "e0f7", "M171 362C171 374 182 384 195 384H317C330 384 341 374 341 362L351 208H161L171 362ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM352 144H304L298 132C297 130 294 128 291 128H221C218 128 215 130 214 132L208 144H160C151 144 144 151 144 160C144 169 151 176 160 176H352C361 176 368 169 368 160C368 151 361 144 352 144Z"]
  };
  var faCircleU = {
    prefix: 'far',
    iconName: 'circle-u',
    icon: [512, 512, [], "e0f8", "M344 144C331 144 320 155 320 168V291C320 325 291 352 256 352S192 325 192 291V168C192 155 181 144 168 144S144 155 144 168V291C144 351 194 400 256 400S368 351 368 291V168C368 155 357 144 344 144ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleUp = {
    prefix: 'far',
    iconName: 'circle-up',
    icon: [512, 512, [], "f35b", "M273 136C268 131 262 128 255 128C247 128 242 131 238 136L150 232C144 239 142 249 146 258C150 266 158 272 168 272H224L224 360C224 373 235 384 248 384H264C277 384 288 373 288 360L288 272H344C354 272 362 266 366 258C370 249 368 239 362 232L273 136ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleUser = {
    prefix: 'far',
    iconName: 'circle-user',
    icon: [512, 512, [], "f2bd", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C212 448 171 433 139 408C159 384 190 368 224 368H288C322 368 352 384 373 408C341 433 300 448 256 448ZM407 374C378 341 336 320 288 320H224C176 320 134 341 105 374C79 341 64 300 64 256C64 150 150 64 256 64S448 150 448 256C448 300 433 341 407 374ZM256 112C207 112 168 151 168 200C168 249 207 288 256 288S344 249 344 200C344 151 305 112 256 112ZM256 240C234 240 216 222 216 200C216 178 234 160 256 160S296 178 296 200C296 222 278 240 256 240Z"]
  };
  var faCircleV = {
    prefix: 'far',
    iconName: 'circle-v',
    icon: [512, 512, [], "e0f9", "M371 147C359 141 344 145 339 157L256 322L173 157C168 145 153 141 141 147C129 152 125 167 131 179L235 387C239 395 247 400 256 400S273 395 277 387L381 179C387 167 383 152 371 147ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleVideo = {
    prefix: 'far',
    iconName: 'circle-video',
    icon: [512, 512, [], "e0fa", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM284 176H164C153 176 144 185 144 196V316C144 327 153 336 164 336H284C295 336 304 327 304 316V196C304 185 295 176 284 176ZM380 194L336 225V287L380 318C388 324 400 318 400 307V205C400 194 388 188 380 194Z"]
  };
  var faCircleW = {
    prefix: 'far',
    iconName: 'circle-w',
    icon: [512, 512, [], "e0fb", "M383 145C370 141 357 148 353 161L314 289L279 162C276 151 267 144 256 144S236 151 233 162L198 289L159 161C155 148 142 141 129 145C116 149 109 162 113 175L177 383C180 393 190 400 200 400C211 400 220 393 223 382L256 260L289 382C292 393 301 400 312 400H312C323 400 332 393 335 383L399 175C403 162 396 149 383 145ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleWaveformLines = {
    prefix: 'far',
    iconName: 'circle-waveform-lines',
    icon: [512, 512, [], "e0fc", "M152 192C139 192 128 203 128 216V296C128 309 139 320 152 320S176 309 176 296V216C176 203 165 192 152 192ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM232 128C219 128 208 139 208 152V360C208 373 219 384 232 384S256 373 256 360V152C256 139 245 128 232 128ZM312 176C299 176 288 187 288 200V312C288 325 299 336 312 336S336 325 336 312V200C336 187 325 176 312 176ZM392 216C379 216 368 227 368 240V272C368 285 379 296 392 296S416 285 416 272V240C416 227 405 216 392 216Z"]
  };
  var faCircleX = {
    prefix: 'far',
    iconName: 'circle-x',
    icon: [512, 512, [], "e0fd", "M359 134C349 125 334 126 326 136L256 219L186 137C178 126 163 125 153 134C142 142 141 157 150 167L225 256L150 345C141 355 142 370 152 378C157 382 163 384 168 384C175 384 182 381 186 375L256 293L326 375C330 381 337 384 344 384C349 384 355 382 359 378C370 370 371 355 362 345L287 256L362 167C371 157 370 142 359 134ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleXmark = {
    prefix: 'far',
    iconName: 'circle-xmark',
    icon: [512, 512, [], "f057", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM341 307L290 256L341 205C350 196 350 181 341 171L341 171C331 162 316 162 307 171L256 222L205 171C196 162 181 162 171 171L171 171C162 181 162 196 171 205L222 256L171 307C162 316 162 331 171 341L171 341C181 350 196 350 205 341L256 290L307 341C316 350 331 350 341 341L341 341C350 331 350 316 341 307Z"]
  };
  var faCircleY = {
    prefix: 'far',
    iconName: 'circle-y',
    icon: [512, 512, [], "e0fe", "M342 152L256 252L170 152C162 142 146 141 136 150C126 158 125 174 134 184L232 298V376C232 389 243 400 256 400S280 389 280 376V298L378 184C387 174 386 158 376 150C366 141 350 142 342 152ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCircleZ = {
    prefix: 'far',
    iconName: 'circle-z',
    icon: [512, 512, [], "e0ff", "M328 336H230L348 166C353 158 353 149 349 141C345 133 337 128 328 128H184C171 128 160 139 160 152S171 176 184 176H282L164 346C159 354 159 363 163 371C167 379 175 384 184 384H328C341 384 352 373 352 360S341 336 328 336ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCity = {
    prefix: 'far',
    iconName: 'city',
    icon: [640, 512, [], "f64f", "M244 384H204C197 384 192 389 192 396V436C192 443 197 448 204 448H244C251 448 256 443 256 436V396C256 389 251 384 244 384ZM244 192H204C197 192 192 197 192 204V244C192 251 197 256 204 256H244C251 256 256 251 256 244V204C256 197 251 192 244 192ZM148 192H108C101 192 96 197 96 204V244C96 251 101 256 108 256H148C155 256 160 251 160 244V204C160 197 155 192 148 192ZM148 384H108C101 384 96 389 96 396V436C96 443 101 448 108 448H148C155 448 160 443 160 436V396C160 389 155 384 148 384ZM148 288H108C101 288 96 293 96 300V340C96 347 101 352 108 352H148C155 352 160 347 160 340V300C160 293 155 288 148 288ZM244 288H204C197 288 192 293 192 300V340C192 347 197 352 204 352H244C251 352 256 347 256 340V300C256 293 251 288 244 288ZM532 384H492C485 384 480 389 480 396V436C480 443 485 448 492 448H532C539 448 544 443 544 436V396C544 389 539 384 532 384ZM532 288H492C485 288 480 293 480 300V340C480 347 485 352 492 352H532C539 352 544 347 544 340V300C544 293 539 288 532 288ZM608 192H512V32C512 14 498 0 480 0H288C270 0 256 14 256 32V96H224V24C224 11 213 0 200 0H200C187 0 176 11 176 24V96H112V24C112 11 101 0 88 0H88C75 0 64 11 64 24V96H32C14 96 0 110 0 128V488C0 501 11 512 24 512H24C37 512 48 501 48 488V144H304V48H464V240H592V488C592 501 603 512 616 512L616 512C629 512 640 501 640 488V224C640 206 626 192 608 192ZM404 96H364C357 96 352 101 352 108V148C352 155 357 160 364 160H404C411 160 416 155 416 148V108C416 101 411 96 404 96ZM404 288H364C357 288 352 293 352 300V340C352 347 357 352 364 352H404C411 352 416 347 416 340V300C416 293 411 288 404 288ZM404 192H364C357 192 352 197 352 204V244C352 251 357 256 364 256H404C411 256 416 251 416 244V204C416 197 411 192 404 192Z"]
  };
  var faClarinet = {
    prefix: 'far',
    iconName: 'clarinet',
    icon: [640, 512, [], "f8ad", "M272 232C259 232 248 243 248 256C248 269 259 280 272 280S296 269 296 256C296 243 285 232 272 232ZM368 232C355 232 344 243 344 256C344 269 355 280 368 280S392 269 392 256C392 243 381 232 368 232ZM616 112C611 112 607 113 603 116L537 160H480V128H496C505 128 512 121 512 112V112C512 103 505 96 496 96H240C231 96 224 103 224 112V112C224 121 231 128 240 128H256V160H106C99 160 93 161 86 163L22 185C9 189 0 201 0 215V297C0 311 9 323 22 327L86 349C93 351 99 352 106 352H537L603 396C610 401 619 401 627 397C635 393 640 385 640 376V136C640 123 629 112 616 112ZM384 128H448V160H384V128ZM288 128H352V160H288V128ZM592 331L551 304H104L48 285V227L104 208H551L592 181V331ZM464 232C451 232 440 243 440 256C440 269 451 280 464 280S488 269 488 256C488 243 477 232 464 232Z"]
  };
  var faClawMarks = {
    prefix: 'far',
    iconName: 'claw-marks',
    icon: [512, 512, [], "f6c2", "M7 225C2 222 -2 229 2 233L87 318C93 324 96 332 96 340V384H140C148 384 156 387 162 393L280 510C283 514 290 510 287 505C206 333 64 251 7 225ZM247 30C253 36 256 44 256 52V96H300C308 96 316 99 322 105L375 158C381 164 384 172 384 180V224H428C436 224 444 227 450 233L503 286C507 290 514 286 511 281C430 109 287 27 231 1C226 -2 222 5 226 9L247 30ZM509 466L507 463C453 348 322 134 46 3C32 -3 15 1 6 14C-3 26 -1 44 8 53L152 233V296H214L280 362V424H344L459 504C465 509 472 512 480 512C486 512 493 510 498 506C511 497 515 481 509 466ZM360 376H328V342L234 248H200V216L93 82C277 189 383 335 436 429L360 376Z"]
  };
  var faClipboard = {
    prefix: 'far',
    iconName: 'clipboard',
    icon: [384, 512, [], "f328", "M320 64H270C263 27 231 0 192 0S121 27 114 64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM192 48C205 48 216 59 216 72S205 96 192 96S168 85 168 72S179 48 192 48ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V128C48 119 55 112 64 112H82C81 117 80 122 80 128V144C80 153 87 160 96 160H288C297 160 304 153 304 144V128C304 122 303 117 302 112H320C329 112 336 119 336 128V448Z"]
  };
  var faClipboardCheck = {
    prefix: 'far',
    iconName: 'clipboard-check',
    icon: [384, 512, [], "f46c", "M245 233L173 325L136 294C126 285 110 286 102 296C93 306 94 322 104 330L160 378C165 382 170 384 176 384C177 384 178 384 178 384C185 383 191 380 195 375L283 263C291 252 289 237 279 229C268 221 253 223 245 233ZM320 64H270C263 27 231 0 192 0S121 27 114 64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM192 48C205 48 216 59 216 72S205 96 192 96S168 85 168 72S179 48 192 48ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V128C48 119 55 112 64 112H82C81 117 80 122 80 128V144C80 153 87 160 96 160H288C297 160 304 153 304 144V128C304 122 303 117 302 112H320C329 112 336 119 336 128V448Z"]
  };
  var faClipboardList = {
    prefix: 'far',
    iconName: 'clipboard-list',
    icon: [384, 512, [], "f46d", "M104 248C91 248 80 259 80 272S91 296 104 296C117 296 128 285 128 272S117 248 104 248ZM104 344C91 344 80 355 80 368S91 392 104 392C117 392 128 381 128 368S117 344 104 344ZM288 352H176C167 352 160 359 160 368S167 384 176 384H288C297 384 304 377 304 368S297 352 288 352ZM320 64H270C263 27 231 0 192 0S121 27 114 64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM192 48C205 48 216 59 216 72S205 96 192 96S168 85 168 72S179 48 192 48ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V128C48 119 55 112 64 112H82C81 117 80 122 80 128V144C80 153 87 160 96 160H288C297 160 304 153 304 144V128C304 122 303 117 302 112H320C329 112 336 119 336 128V448ZM288 256H176C167 256 160 263 160 272S167 288 176 288H288C297 288 304 281 304 272S297 256 288 256Z"]
  };
  var faClipboardListCheck = {
    prefix: 'far',
    iconName: 'clipboard-list-check',
    icon: [384, 512, [], "f737", "M320 64H270C263 27 231 0 192 0S121 27 114 64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM192 48C205 48 216 59 216 72S205 96 192 96S168 85 168 72S179 48 192 48ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V128C48 119 55 112 64 112H82C81 117 80 122 80 128V144C80 153 87 160 96 160H288C297 160 304 153 304 144V128C304 122 303 117 302 112H320C329 112 336 119 336 128V448ZM288 256H176C167 256 160 263 160 272S167 288 176 288H288C297 288 304 281 304 272S297 256 288 256ZM288 352H176C167 352 160 359 160 368S167 384 176 384H288C297 384 304 377 304 368S297 352 288 352ZM104 344C91 344 80 355 80 368S91 392 104 392C117 392 128 381 128 368S117 344 104 344ZM108 288C112 288 116 286 119 283L167 235C174 229 174 219 167 213S151 206 145 213L108 249L95 237C89 230 79 230 73 237S66 253 73 259L97 283C100 286 104 288 108 288Z"]
  };
  var faClipboardMedical = {
    prefix: 'far',
    iconName: 'clipboard-medical',
    icon: [384, 512, [], "e100", "M320 64H270C263 27 231 0 192 0S121 27 114 64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM192 48C205 48 216 59 216 72S205 96 192 96S168 85 168 72S179 48 192 48ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V128C48 119 55 112 64 112H82C81 117 80 122 80 128V144C80 153 87 160 96 160H288C297 160 304 153 304 144V128C304 122 303 117 302 112H320C329 112 336 119 336 128V448ZM272 288H224V240C224 231 217 224 208 224H176C167 224 160 231 160 240V288H112C103 288 96 295 96 304V336C96 345 103 352 112 352H160V400C160 409 167 416 176 416H208C217 416 224 409 224 400V352H272C281 352 288 345 288 336V304C288 295 281 288 272 288Z"]
  };
  var faClipboardPrescription = {
    prefix: 'far',
    iconName: 'clipboard-prescription',
    icon: [384, 512, [], "f5e8", "M320 64H270C263 27 231 0 192 0S121 27 114 64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM192 48C205 48 216 59 216 72S205 96 192 96S168 85 168 72S179 48 192 48ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V128C48 119 55 112 64 112H82C81 117 80 122 80 128V144C80 153 87 160 96 160H288C297 160 304 153 304 144V128C304 122 303 117 302 112H320C329 112 336 119 336 128V448ZM294 322C286 314 274 314 266 322L240 348L207 315C224 304 236 286 236 264C236 231 209 204 176 204H104C93 204 84 213 84 224V368C84 379 93 388 104 388S124 379 124 368V324H160L212 376L186 402C178 410 178 422 186 430C190 434 195 436 200 436S210 434 214 430L240 404L266 430C270 434 275 436 280 436S290 434 294 430C302 422 302 410 294 402L268 376L294 350C302 342 302 330 294 322ZM176 284H124V244H176C187 244 196 253 196 264S187 284 176 284Z"]
  };
  var faClipboardUser = {
    prefix: 'far',
    iconName: 'clipboard-user',
    icon: [384, 512, [], "f7f3", "M320 64H270C263 27 231 0 192 0S121 27 114 64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM192 48C205 48 216 59 216 72S205 96 192 96S168 85 168 72S179 48 192 48ZM336 448C336 457 329 464 320 464H318C311 419 272 384 224 384H160C112 384 73 419 66 464H64C55 464 48 457 48 448V128C48 119 55 112 64 112H82C81 117 80 122 80 128V144C80 153 87 160 96 160H288C297 160 304 153 304 144V128C304 122 303 117 302 112H320C329 112 336 119 336 128V448ZM192 224C157 224 128 253 128 288C128 323 157 352 192 352S256 323 256 288C256 253 227 224 192 224Z"]
  };
  var faClock = {
    prefix: 'far',
    iconName: 'clock',
    icon: [512, 512, [], "f017", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM280 260V152C280 139 269 128 256 128S232 139 232 152V272C232 280 236 287 242 291L306 339C310 342 315 344 320 344C327 344 334 341 339 334C347 324 345 309 334 301L280 260Z"]
  };
  var faClockDesk = {
    prefix: 'far',
    iconName: 'clock-desk',
    icon: [448, 512, [], "e101", "M248 228V120C248 107 237 96 224 96S200 107 200 120V240C200 248 204 255 210 259L274 307C278 310 283 312 288 312C295 312 302 309 307 302C315 292 313 277 302 269L248 228ZM224 0C100 0 0 100 0 224C0 228 0 460 0 460C0 489 23 512 52 512H396C425 512 448 489 448 460C448 460 448 228 448 224C448 100 348 0 224 0ZM224 400C127 400 48 321 48 224S127 48 224 48S400 127 400 224S321 400 224 400Z"]
  };
  var faClockRotateLeft = {
    prefix: 'far',
    iconName: 'clock-rotate-left',
    icon: [512, 512, [], "f1da", "M256 32C176 32 104 76 64 142V56C64 43 53 32 40 32S16 43 16 56V200C16 213 27 224 40 224H168C181 224 192 213 192 200S181 176 168 176H100C129 118 189 80 256 80C353 80 432 159 432 256S353 432 256 432C215 432 175 418 143 391C133 383 118 384 110 394C101 405 102 420 113 428C153 462 204 480 256 480C379 480 480 379 480 256S379 32 256 32ZM256 128C243 128 232 139 232 152V272C232 280 236 287 242 292L298 332C302 335 307 336 312 336C319 336 327 333 332 326C339 315 337 300 326 292L280 260V152C280 139 269 128 256 128Z"]
  };
  var faClone = {
    prefix: 'far',
    iconName: 'clone',
    icon: [512, 512, [], "f24d", "M448 0H224C189 0 160 29 160 64V288C160 323 189 352 224 352H448C483 352 512 323 512 288V64C512 29 483 0 448 0ZM464 288C464 297 457 304 448 304H224C215 304 208 297 208 288V64C208 55 215 48 224 48H448C457 48 464 55 464 64V288ZM304 448C304 457 297 464 288 464H64C55 464 48 457 48 448V224C48 215 55 208 64 208H128V160H64C29 160 0 189 0 224V448C0 483 29 512 64 512H288C323 512 352 483 352 448V384H304V448Z"]
  };
  var faClosedCaptioning = {
    prefix: 'far',
    iconName: 'closed-captioning',
    icon: [576, 512, [], "f20a", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM528 416C528 425 521 432 512 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H512C521 80 528 87 528 96V416ZM236 222C246 231 261 231 270 222S280 197 270 188C233 151 172 151 135 188C117 206 107 230 107 256S117 306 135 324C153 343 178 352 203 352C227 352 252 343 270 324C280 314 280 299 270 290C261 281 246 281 236 290C218 309 187 309 169 290C160 281 155 269 155 256S160 231 169 222C187 203 218 203 236 222ZM428 222C438 231 453 231 462 222S472 197 462 188C425 151 364 151 327 188C309 206 299 230 299 256S309 306 327 324C345 343 370 352 395 352S444 343 462 324C472 314 472 299 462 290C453 281 438 281 428 290C410 309 379 309 361 290C352 281 347 269 347 256S352 231 361 222C379 203 410 203 428 222Z"]
  };
  var faCloud = {
    prefix: 'far',
    iconName: 'cloud',
    icon: [640, 512, [], "f0c2", "M543 214C543 212 544 210 544 208C544 146 494 96 432 96C421 96 410 98 399 101C369 60 320 32 264 32C171 32 95 108 96 201C40 221 0 273 0 336C0 416 64 480 144 480H504C579 480 640 419 640 344C640 283 599 231 543 214ZM504 432H144C91 432 48 389 48 336C48 296 74 260 112 246L144 235C144 196 144 201 144 197C145 132 199 80 264 80C302 80 338 98 361 130L381 157L413 147C462 132 498 173 495 212L493 249L529 260C567 272 592 305 592 344C592 393 553 432 504 432Z"]
  };
  var faCloudArrowDown = {
    prefix: 'far',
    iconName: 'cloud-arrow-down',
    icon: [640, 512, [], "f0ed", "M543 214C543 212 544 210 544 208C544 146 494 96 432 96C421 96 410 98 399 101C369 60 320 32 264 32C171 32 95 108 96 201C40 221 0 273 0 336C0 416 64 480 144 480H504C579 480 640 419 640 344C640 283 599 231 543 214ZM504 432H144C91 432 48 389 48 336C48 296 74 260 112 246L144 235C144 196 144 201 144 197C145 132 199 80 264 80C302 80 338 98 361 130L381 157L413 147C462 132 498 173 495 212L493 249L529 260C567 272 592 305 592 344C592 393 553 432 504 432ZM391 271L344 318V192C344 179 333 168 320 168S296 179 296 192V318L249 271C240 262 224 262 215 271S206 296 215 305L303 393C305 395 308 397 311 398C314 399 317 400 320 400S326 399 329 398C332 397 335 395 337 393L425 305C434 296 434 280 425 271S400 262 391 271Z"]
  };
  var faCloudArrowUp = {
    prefix: 'far',
    iconName: 'cloud-arrow-up',
    icon: [640, 512, [], "f0ee", "M543 214C543 212 544 210 544 208C544 146 494 96 432 96C421 96 410 98 399 101C369 60 320 32 264 32C171 32 95 108 96 201C40 221 0 273 0 336C0 416 64 480 144 480H504C579 480 640 419 640 344C640 283 599 231 543 214ZM504 432H144C91 432 48 389 48 336C48 296 74 260 112 246L144 235C144 196 144 201 144 197C145 132 199 80 264 80C302 80 338 98 361 130L381 157L413 147C462 132 498 173 495 212L493 249L529 260C567 272 592 305 592 344C592 393 553 432 504 432ZM337 175C335 173 332 171 329 170C323 167 317 167 311 170C308 171 305 173 303 175L215 263C206 272 206 288 215 297S240 306 249 297L296 250V376C296 389 307 400 320 400S344 389 344 376V250L391 297C396 302 402 304 408 304S420 302 425 297C434 288 434 272 425 263L337 175Z"]
  };
  var faCloudBolt = {
    prefix: 'far',
    iconName: 'cloud-bolt',
    icon: [512, 512, [], "f76c", "M337 288H265L287 211C290 201 283 192 273 192H191C183 192 177 198 176 205L160 335C159 344 166 352 175 352H256L224 494C222 503 229 512 239 512C244 512 249 509 252 505L350 311C356 301 349 288 337 288ZM411 104C397 62 358 32 312 32C298 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 169 0 212C0 271 48 320 108 320H130L136 272H108C75 272 48 245 48 212C48 184 67 160 94 154L115 149C112 120 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272H372C374 274 376 277 378 279C385 292 386 307 380 320H404C464 320 512 271 512 212C512 155 467 108 411 104Z"]
  };
  var faCloudBoltMoon = {
    prefix: 'far',
    iconName: 'cloud-bolt-moon',
    icon: [576, 512, [], "f76d", "M568 224C498 237 433 183 433 113C433 72 455 35 490 15C496 12 495 4 488 2C480 1 471 0 462 0C398 0 345 41 325 98C354 111 377 133 390 162C426 188 448 231 448 276C448 280 448 283 447 286C452 287 457 288 462 288C506 288 547 268 574 235C579 230 574 223 568 224ZM278 336H220L237 271C239 264 234 256 226 256H158C152 256 146 260 146 266L130 386C129 394 134 400 142 400H201L178 497C176 505 182 512 190 512C194 512 198 510 200 506L288 354C293 346 287 336 278 336ZM363 183C351 147 317 120 276 120C273 120 270 120 267 121C245 105 219 96 192 96C140 96 94 127 75 173C31 187 0 228 0 276C0 332 43 378 98 383C98 382 98 381 98 380L104 335C73 333 48 308 48 276C48 243 75 216 108 216C110 216 111 216 113 216C117 176 150 144 192 144C217 144 239 156 254 174C261 170 268 168 276 168C300 168 320 188 320 212C320 214 320 215 319 217C347 223 368 247 368 276C368 305 347 329 320 335C323 346 321 358 316 368L306 384H308C367 384 416 336 416 276C416 237 395 202 363 183Z"]
  };
  var faCloudBoltSun = {
    prefix: 'far',
    iconName: 'cloud-bolt-sun',
    icon: [640, 512, [], "f76e", "M162 251C137 236 120 208 120 176C120 127 159 88 208 88C232 88 253 98 269 113C280 102 292 92 306 85L300 84L287 9C286 1 277 -2 271 2L208 45L145 2C139 -2 130 1 129 9L116 84L41 97C33 98 30 107 34 113L77 176L34 239C30 245 33 254 41 255L116 268L129 343C130 351 139 354 145 350L172 332C165 315 160 296 160 276C160 267 161 259 162 251ZM148 176C148 195 157 212 171 223C184 190 210 163 243 148C246 143 249 139 252 135C241 123 225 116 208 116C175 116 148 143 148 176ZM555 183C543 147 509 120 468 120C465 120 462 120 459 121C437 105 411 96 384 96C332 96 286 127 267 173C223 187 192 228 192 276C192 332 234 377 288 383V382L295 335C264 333 240 307 240 276C240 243 267 216 300 216C302 216 303 216 305 217C309 176 342 144 384 144C409 144 431 156 446 174C453 170 460 168 468 168C492 168 512 188 512 212C512 214 512 215 511 217C539 223 560 247 560 276C560 306 538 330 510 335C513 347 512 359 506 370L498 384H500C560 384 608 336 608 276C608 237 587 202 555 183ZM468 336H410L428 271C430 263 424 256 416 256H348C342 256 337 261 336 266L320 386C319 394 325 400 332 400H391L368 497C366 505 372 512 380 512C384 512 388 510 390 506L478 354C483 346 477 336 468 336Z"]
  };
  var faCloudDrizzle = {
    prefix: 'far',
    iconName: 'cloud-drizzle',
    icon: [512, 512, [], "f738", "M48 360C39 360 32 367 32 376V416C32 425 39 432 48 432S64 425 64 416V376C64 367 57 360 48 360ZM144 440C135 440 128 447 128 456V496C128 505 135 512 144 512S160 505 160 496V456C160 447 153 440 144 440ZM240 360C231 360 224 367 224 376V416C224 425 231 432 240 432S256 425 256 416V376C256 367 249 360 240 360ZM336 440C327 440 320 447 320 456V496C320 505 327 512 336 512S352 505 352 496V456C352 447 345 440 336 440ZM432 360C423 360 416 367 416 376V416C416 425 423 432 432 432S448 425 448 416V376C448 367 441 360 432 360ZM411 104C397 62 358 32 312 32C298 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 169 0 212C0 271 48 320 108 320H404C464 320 512 271 512 212C512 155 467 108 411 104ZM404 272H108C75 272 48 245 48 212C48 184 67 160 94 154L115 149L112 124C112 123 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272Z"]
  };
  var faCloudFog = {
    prefix: 'far',
    iconName: 'cloud-fog',
    icon: [640, 512, [], "f74e", "M200 464H88C75 464 64 475 64 488V488C64 501 75 512 88 512H200C213 512 224 501 224 488V488C224 475 213 464 200 464ZM616 464H296C283 464 272 475 272 488V488C272 501 283 512 296 512H616C629 512 640 501 640 488V488C640 475 629 464 616 464ZM576 400L576 400C576 387 565 376 552 376H24C11 376 0 387 0 400V400C0 413 11 424 24 424H552C565 424 576 413 576 400ZM172 320H468C528 320 576 271 576 212C576 155 531 108 475 104C461 62 422 32 376 32C362 32 349 35 337 40C314 14 282 0 248 0C184 0 132 50 128 113C90 130 64 169 64 212C64 271 112 320 172 320ZM158 154L179 149L176 124C176 123 176 121 176 120C176 80 208 48 248 48C273 48 296 61 309 83L323 105L344 90C353 84 364 80 376 80C405 80 428 102 431 130L434 152H468C501 152 528 179 528 212S501 272 468 272H172C139 272 112 245 112 212C112 184 131 160 158 154Z"]
  };
  var faCloudHail = {
    prefix: 'far',
    iconName: 'cloud-hail',
    icon: [512, 512, [], "f739", "M384 352C366 352 352 366 352 384S366 416 384 416S416 402 416 384S402 352 384 352ZM192 448C174 448 160 462 160 480S174 512 192 512S224 498 224 480S210 448 192 448ZM320 448C302 448 288 462 288 480S302 512 320 512S352 498 352 480S338 448 320 448ZM256 352C238 352 224 366 224 384S238 416 256 416S288 402 288 384S274 352 256 352ZM64 448C46 448 32 462 32 480S46 512 64 512S96 498 96 480S82 448 64 448ZM128 352C110 352 96 366 96 384S110 416 128 416S160 402 160 384S146 352 128 352ZM411 104C397 62 358 32 312 32C298 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 169 0 212C0 271 48 320 108 320H404C464 320 512 271 512 212C512 155 467 108 411 104ZM404 272H108C75 272 48 245 48 212C48 184 67 160 94 154L115 149L112 124C112 123 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272Z"]
  };
  var faCloudHailMixed = {
    prefix: 'far',
    iconName: 'cloud-hail-mixed',
    icon: [512, 512, [], "f73a", "M411 104C397 62 358 32 312 32C298 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 169 0 212C0 271 48 320 108 320H404C464 320 512 271 512 212C512 155 467 108 411 104ZM404 272H108C75 272 48 245 48 212C48 184 67 160 94 154L115 149L112 124C112 123 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272ZM87 370C79 366 70 369 66 377L50 409C46 417 49 426 57 430C59 432 62 432 64 432C70 432 76 429 78 423L94 391C98 383 95 374 87 370ZM471 370C463 366 454 369 450 377L434 409C430 417 433 426 441 430C443 432 446 432 448 432C454 432 460 429 462 423L478 391C482 383 479 374 471 370ZM376 370C368 366 358 368 354 376L290 488C286 496 288 506 296 510C299 511 301 512 304 512C310 512 315 509 318 504L382 392C386 384 384 374 376 370ZM279 370C271 366 262 369 258 377L242 409C238 417 241 426 249 430C251 432 254 432 256 432C262 432 268 429 270 423L286 391C290 383 287 374 279 370ZM184 370C176 366 166 368 162 376L98 488C94 496 96 506 104 510C107 511 109 512 112 512C118 512 123 509 126 504L190 392C194 384 192 374 184 370ZM32 448C14 448 0 462 0 480S14 512 32 512S64 498 64 480S50 448 32 448ZM224 448C206 448 192 462 192 480S206 512 224 512S256 498 256 480S242 448 224 448ZM416 448C398 448 384 462 384 480S398 512 416 512S448 498 448 480S434 448 416 448Z"]
  };
  var faCloudMeatball = {
    prefix: 'far',
    iconName: 'cloud-meatball',
    icon: [576, 512, [], "f73b", "M385 376L368 367L374 349C380 330 366 313 348 313C342 313 340 314 321 320L312 303C302 283 274 283 264 303L255 320C237 314 234 313 228 313C210 313 196 330 202 349L208 367L192 376C171 386 171 414 192 424L208 433L202 451C196 471 211 487 229 487C232 487 241 484 255 480L264 496C274 517 302 517 312 496L321 480C335 484 344 487 347 487C365 487 380 471 373 451L368 433L384 424C405 414 405 386 385 376ZM576 256C576 197 534 146 478 132C469 75 419 32 360 32C347 32 334 34 322 38C294 14 258 0 220 0C138 0 70 64 64 145C25 168 0 210 0 256C0 327 57 384 128 384H146C150 371 158 359 170 351C169 346 169 341 169 336H128C84 336 48 300 48 256C48 223 67 194 98 182L113 176L112 159C112 157 112 156 112 156C112 96 160 48 220 48C250 48 278 60 299 83L311 96L328 88C377 63 431 101 432 151L429 175L454 177C496 180 528 215 528 256C528 300 492 336 448 336H407C407 341 407 346 406 351C418 359 426 371 430 384H448C519 384 576 327 576 256ZM64 416C46 416 32 430 32 448C32 466 46 480 64 480S96 466 96 448C96 430 82 416 64 416ZM512 416C494 416 480 430 480 448C480 466 494 480 512 480S544 466 544 448C544 430 530 416 512 416Z"]
  };
  var faCloudMoon = {
    prefix: 'far',
    iconName: 'cloud-moon',
    icon: [576, 512, [], "f6c3", "M566 261C484 277 408 214 408 132C408 84 434 41 476 17C482 14 480 4 473 3C465 1 451 0 442 0C348 0 272 75 272 168C272 169 272 169 272 170C276 172 279 174 283 176C284 176 286 176 288 176C350 176 404 218 419 277C440 292 456 312 466 334C509 328 547 306 574 274C579 268 574 260 566 261ZM391 296C383 246 340 208 288 208C283 208 278 208 273 209C249 188 217 176 184 176C120 176 66 221 52 281C20 305 0 343 0 384C0 455 57 512 128 512H332C396 512 448 460 448 396C448 354 425 317 391 296ZM332 464H128C84 464 48 428 48 384C48 351 68 323 96 311C97 263 136 224 184 224C215 224 242 240 258 265C267 259 277 256 288 256C319 256 344 281 344 312C344 318 343 323 341 329C374 333 400 362 400 396C400 434 370 464 332 464Z"]
  };
  var faCloudMoonRain = {
    prefix: 'far',
    iconName: 'cloud-moon-rain',
    icon: [576, 512, [], "f73c", "M568 224C498 237 433 183 433 113C433 72 455 35 490 15C496 12 495 4 488 2C480 1 471 0 462 0C398 0 345 41 325 98C354 111 377 133 390 162C426 188 448 231 448 276C448 280 448 283 447 286C452 287 457 288 462 288C506 288 547 268 574 235C579 230 574 223 568 224ZM269 418C261 414 251 416 247 424L210 488C206 496 208 506 216 510C219 511 221 512 224 512C230 512 235 509 238 504L275 440C279 432 276 422 269 418ZM77 418C69 414 59 416 55 424L18 488C14 496 16 506 24 510C27 511 29 512 32 512C38 512 43 509 46 504L83 440C87 432 84 422 77 418ZM173 418C165 414 155 416 151 424L114 488C110 496 112 506 120 510C123 511 125 512 128 512C134 512 139 509 142 504L179 440C183 432 180 422 173 418ZM363 183C351 147 317 120 276 120C273 120 270 120 267 121C245 105 219 96 192 96C140 96 94 127 75 173C31 187 0 228 0 276C0 336 48 384 108 384H308C368 384 416 336 416 276C416 237 395 202 363 183ZM308 336H108C75 336 48 309 48 276S75 216 108 216C110 216 111 216 113 217C117 176 150 144 192 144C217 144 239 156 254 174C261 170 268 168 276 168C300 168 320 188 320 212C320 214 320 215 319 217C347 223 368 247 368 276C368 309 341 336 308 336ZM365 418C357 414 347 416 343 424L306 488C302 496 304 506 312 510C315 511 317 512 320 512C326 512 331 509 334 504L371 440C375 432 372 422 365 418Z"]
  };
  var faCloudMusic = {
    prefix: 'far',
    iconName: 'cloud-music',
    icon: [640, 512, [], "f8ae", "M543 214C543 212 544 210 544 208C544 146 494 96 432 96C421 96 410 98 399 101C369 60 320 32 264 32C171 32 95 108 96 201C40 221 0 273 0 336C0 416 64 480 144 480H504C579 480 640 419 640 344C640 283 599 231 543 214ZM504 432H144C91 432 48 389 48 336C48 296 74 260 112 246L144 235C144 196 144 201 144 197C145 132 199 80 264 80C302 80 338 98 361 130L381 157L413 147C462 132 498 173 495 212L493 249L529 260C567 272 592 305 592 344C592 393 553 432 504 432ZM363 177L235 224C229 226 224 232 224 239V338C219 337 213 336 208 336C182 336 160 350 160 368S182 400 208 400S256 386 256 368V283L352 246V306C347 305 341 304 336 304C310 304 288 318 288 336S310 368 336 368S384 354 384 336V192C384 187 382 182 378 179S368 175 363 177Z"]
  };
  var faCloudRain = {
    prefix: 'far',
    iconName: 'cloud-rain',
    icon: [512, 512, [], "f73d", "M88 374C75 419 48 431 48 462C48 490 70 512 96 512S144 490 144 462C144 431 117 419 104 374C102 366 90 366 88 374ZM248 374C235 419 208 431 208 462C208 490 230 512 256 512S304 490 304 462C304 431 277 419 264 374C262 366 250 366 248 374ZM408 374C395 419 368 431 368 462C368 490 390 512 416 512S464 490 464 462C464 431 437 419 424 374C422 366 410 366 408 374ZM411 104C397 62 358 32 312 32C298 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 169 0 212C0 271 48 320 108 320H404C464 320 512 271 512 212C512 155 467 108 411 104ZM404 272H108C75 272 48 245 48 212C48 184 67 160 94 154L115 149L112 124C112 123 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272Z"]
  };
  var faCloudRainbow = {
    prefix: 'far',
    iconName: 'cloud-rainbow',
    icon: [576, 512, [], "f73e", "M561 48C569 48 576 41 576 32V16C576 7 568 0 559 0C419 6 298 87 236 204C220 196 202 192 184 192C120 192 68 242 64 305C26 322 0 361 0 404C0 463 48 512 108 512H404C464 512 512 463 512 404C512 366 492 332 461 313C485 282 520 261 561 257C569 256 576 249 576 241V225C576 216 568 208 559 209C498 214 445 248 414 297C413 296 412 296 411 296C405 278 395 263 381 251C423 195 487 157 561 152C569 152 576 145 576 137V121C576 111 568 104 559 104C468 110 389 157 339 228C331 225 321 224 312 224C300 224 288 226 277 230C331 126 437 54 561 48ZM312 272C341 272 364 294 367 322L370 344H404C437 344 464 371 464 404S437 464 404 464H108C75 464 48 437 48 404C48 376 67 352 94 346L115 341L112 316C112 315 112 313 112 312C112 272 144 240 184 240C209 240 232 253 245 275L259 297L280 282C289 276 301 272 312 272Z"]
  };
  var faCloudShowers = {
    prefix: 'far',
    iconName: 'cloud-showers',
    icon: [512, 512, [], "f73f", "M48 368C39 368 32 375 32 384V464C32 473 39 480 48 480S64 473 64 464V384C64 375 57 368 48 368ZM144 400C135 400 128 407 128 416V496C128 505 135 512 144 512S160 505 160 496V416C160 407 153 400 144 400ZM240 368C231 368 224 375 224 384V464C224 473 231 480 240 480S256 473 256 464V384C256 375 249 368 240 368ZM336 400C327 400 320 407 320 416V496C320 505 327 512 336 512S352 505 352 496V416C352 407 345 400 336 400ZM432 368C423 368 416 375 416 384V464C416 473 423 480 432 480S448 473 448 464V384C448 375 441 368 432 368ZM411 104C397 62 358 32 312 32C298 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 169 0 212C0 271 48 320 108 320H404C464 320 512 271 512 212C512 155 467 108 411 104ZM404 272H108C75 272 48 245 48 212C48 184 67 160 94 154L115 149L112 124C112 123 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272Z"]
  };
  var faCloudShowersHeavy = {
    prefix: 'far',
    iconName: 'cloud-showers-heavy',
    icon: [512, 512, [], "f740", "M88 370C80 366 71 368 66 376L2 488C-2 496 0 506 8 510C11 511 13 512 16 512C22 512 27 509 30 504L94 392C98 384 96 374 88 370ZM472 370C464 366 455 368 450 376L386 488C382 496 384 506 392 510C395 511 397 512 400 512C406 512 411 509 414 504L478 392C482 384 480 374 472 370ZM376 370C368 366 359 368 354 376L290 488C286 496 288 506 296 510C299 511 301 512 304 512C310 512 315 509 318 504L382 392C386 384 384 374 376 370ZM280 370C272 366 263 368 258 376L194 488C190 496 192 506 200 510C203 511 205 512 208 512C214 512 219 509 222 504L286 392C290 384 288 374 280 370ZM184 370C176 366 167 368 162 376L98 488C94 496 96 506 104 510C107 511 109 512 112 512C118 512 123 509 126 504L190 392C194 384 192 374 184 370ZM411 104C397 62 358 32 312 32C299 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 169 0 212C0 271 48 320 108 320H404C464 320 512 271 512 212C512 155 467 108 411 104ZM404 272H108C75 272 48 245 48 212C48 184 67 160 94 154L115 149L112 124C112 123 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272Z"]
  };
  var faCloudSleet = {
    prefix: 'far',
    iconName: 'cloud-sleet',
    icon: [512, 512, [], "f741", "M512 212C512 155 467 108 411 104C397 62 358 32 312 32C298 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 168 0 212C0 271 48 320 108 320H404C464 320 512 271 512 212ZM48 212C48 184 67 160 94 154L115 149L112 124C112 123 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272H108C75 272 48 245 48 212ZM87 354C79 350 70 353 66 361L2 489C-2 497 1 506 9 510C11 511 14 512 16 512C22 512 28 509 30 503L94 375C98 367 95 358 87 354ZM343 354C335 350 326 353 322 361L258 489C254 497 257 506 265 510C267 511 270 512 272 512C278 512 284 509 286 503L350 375C354 367 351 358 343 354ZM487 384C483 376 473 374 466 378L448 388V368C448 359 441 352 432 352S416 359 416 368V388L398 378C391 374 381 376 377 384C372 392 375 401 382 406L400 416L382 426C375 430 372 440 377 448C381 456 391 458 398 454L416 444V464C416 473 423 480 432 480S448 473 448 464V444L466 454C473 458 483 456 487 448C492 440 489 430 482 426L464 416L482 406C489 401 492 392 487 384ZM231 384C227 376 217 374 210 378L192 388V368C192 359 185 352 176 352S160 359 160 368V388L142 378C135 374 125 376 121 384C116 392 119 401 126 406L144 416L126 426C119 430 116 440 121 448C125 456 135 458 142 454L160 444V464C160 473 167 480 176 480S192 473 192 464V444L210 454C217 458 227 456 231 448C236 440 233 430 226 426L208 416L226 406C233 401 236 392 231 384Z"]
  };
  var faCloudSnow = {
    prefix: 'far',
    iconName: 'cloud-snow',
    icon: [512, 512, [], "f742", "M108 320H404C464 320 512 271 512 212C512 155 467 108 411 104C397 62 358 32 312 32C298 32 285 35 273 40C250 14 218 0 184 0C120 0 68 50 64 113C26 130 0 169 0 212C0 271 48 320 108 320ZM94 154L115 149L112 124C112 123 112 121 112 120C112 80 144 48 184 48C209 48 232 61 245 83L259 105L280 90C289 84 300 80 312 80C341 80 364 102 367 130L370 152H404C437 152 464 179 464 212S437 272 404 272H108C75 272 48 245 48 212C48 184 67 160 94 154ZM311 416C307 408 297 406 290 410L272 420V400C272 391 265 384 256 384C247 384 240 391 240 400V420L222 410C215 406 205 408 201 416S199 433 206 438L224 448L206 458C199 463 196 472 201 480S215 490 222 486L240 476V496C240 505 247 512 256 512C265 512 272 505 272 496V476L290 486C297 490 307 488 311 480C316 472 313 463 306 458L288 448L306 438C313 433 316 424 311 416ZM503 384C499 376 489 374 482 378L464 388V368C464 359 457 352 448 352C439 352 432 359 432 368V388L414 378C407 374 397 376 393 384C388 392 391 401 398 406L416 416L398 426C391 431 388 440 393 448C397 456 407 458 414 454L432 444V464C432 473 439 480 448 480C457 480 464 473 464 464V444L482 454C489 458 499 456 503 448S505 431 498 426L480 416L498 406C505 401 508 392 503 384ZM119 384C115 376 105 374 98 378L80 388V368C80 359 73 352 64 352C55 352 48 359 48 368V388L30 378C23 374 13 376 9 384C4 392 7 401 14 406L32 416L14 426C7 431 4 440 9 448C13 456 23 458 30 454L48 444V464C48 473 55 480 64 480C73 480 80 473 80 464V444L98 454C105 458 115 456 119 448S121 431 114 426L96 416L114 406C121 401 124 392 119 384Z"]
  };
  var faCloudSun = {
    prefix: 'far',
    iconName: 'cloud-sun',
    icon: [640, 512, [], "f6c4", "M128 208C128 246 157 278 192 288C199 278 205 272 215 266C227 230 250 198 279 176C269 147 240 128 208 128C163 128 128 163 128 208ZM96 208C96 147 147 96 208 96C253 96 291 122 307 160C330 150 352 144 375 144C384 144 394 144 403 147L413 134C419 128 413 115 407 115L317 99L301 10C301 0 288 -3 282 3L208 54L135 3C128 -3 115 0 115 10L99 99L10 115C0 115 -3 128 3 134L55 208L3 282C-3 288 0 301 10 301L99 317L115 406C115 416 128 419 135 413L160 394C160 390 160 387 160 384C160 358 167 336 176 314C131 301 96 259 96 208ZM583 298C576 246 531 208 480 208C474 208 471 208 464 208C439 186 410 176 375 176C311 176 256 221 243 282C211 304 192 342 192 384C192 454 250 512 320 512H525C589 512 640 461 640 397C640 355 618 317 583 298ZM525 464H320C275 464 240 429 240 384C240 352 259 323 288 310C288 262 327 224 378 224C410 224 435 240 451 266C458 259 471 256 480 256C512 256 538 282 538 314C538 320 538 326 535 330C567 333 592 362 592 397C592 435 563 464 525 464Z "]
  };
  var faCloudSunRain = {
    prefix: 'far',
    iconName: 'cloud-sun-rain',
    icon: [640, 512, [], "f743", "M148 176C148 195 157 212 171 223C184 190 210 163 243 148C246 143 249 139 252 135C241 123 225 116 208 116C175 116 148 143 148 176ZM162 251C137 236 120 208 120 176C120 127 159 88 208 88C232 88 253 98 269 113C280 102 292 92 306 85L300 84L287 9C286 1 277 -2 271 2L208 45L145 2C139 -2 130 1 129 9L116 84L41 97C33 98 30 107 34 113L77 176L34 239C30 245 33 254 41 255L116 268L129 343C130 351 139 354 145 350L172 332C164 315 160 296 160 276C160 267 161 259 162 251ZM365 418C357 414 347 416 343 424L306 488C302 496 304 506 312 510C315 511 317 512 320 512C325 512 331 509 334 504L371 440C375 432 372 422 365 418ZM269 418C261 414 251 416 247 424L210 488C206 496 208 506 216 510C219 511 221 512 224 512C229 512 235 509 238 504L275 440C279 432 276 422 269 418ZM461 418C453 414 443 416 439 424L402 488C398 496 400 506 408 510C411 511 413 512 416 512C421 512 427 509 430 504L467 440C471 432 468 422 461 418ZM555 183C543 147 509 120 468 120C465 120 462 120 459 121C437 105 411 96 384 96C332 96 286 127 267 173C223 187 192 228 192 276C192 336 240 384 300 384H500C560 384 608 336 608 276C608 237 587 202 555 183ZM500 336H300C267 336 240 309 240 276S267 216 300 216C302 216 303 216 305 217C309 176 342 144 384 144C409 144 431 156 446 174C453 170 460 168 468 168C492 168 512 188 512 212C512 214 512 215 511 217C539 223 560 247 560 276C560 309 533 336 500 336ZM557 418C549 414 539 416 535 424L498 488C494 496 496 506 504 510C507 511 509 512 512 512C517 512 523 509 526 504L563 440C567 432 564 422 557 418Z"]
  };
  var faCloudWord = {
    prefix: 'far',
    iconName: 'cloud-word',
    icon: [640, 512, [], "e102", "M208 352H176C167 352 160 359 160 368C160 377 167 384 176 384H208C217 384 224 377 224 368C224 359 217 352 208 352ZM368 352H272C263 352 256 359 256 368C256 377 263 384 272 384H368C377 384 384 377 384 368C384 359 377 352 368 352ZM288 304C288 295 281 288 272 288H144C135 288 128 295 128 304C128 313 135 320 144 320H272C281 320 288 313 288 304ZM464 352H432C423 352 416 359 416 368C416 377 423 384 432 384H464C473 384 480 377 480 368C480 359 473 352 464 352ZM496 288H336C327 288 320 295 320 304C320 313 327 320 336 320H496C505 320 512 313 512 304C512 295 505 288 496 288ZM543 214C543 212 544 210 544 208C544 146 494 96 432 96C421 96 410 98 399 101C369 60 320 32 264 32C171 32 95 108 96 201C40 221 0 273 0 336C0 416 65 480 144 480H504C579 480 640 419 640 344C640 283 599 231 543 214ZM504 432H144C91 432 48 389 48 336C48 296 74 260 112 246L144 235C144 196 144 201 144 197C145 132 199 80 264 80C302 80 338 98 361 130L381 157L413 147C462 132 498 173 495 212L493 249L529 260C567 272 592 305 592 344C592 393 553 432 504 432Z"]
  };
  var faClouds = {
    prefix: 'far',
    iconName: 'clouds',
    icon: [640, 512, [], "f744", "M539 296C525 254 486 224 440 224C427 224 413 227 401 232C399 230 397 228 395 226C412 207 421 183 421 157C421 100 375 53 317 53C310 53 303 54 297 55C276 22 238 0 197 0C146 0 101 34 86 82C37 90 0 133 0 184C0 241 47 288 104 288H195C194 294 193 299 192 305C154 322 128 361 128 404C128 463 176 512 236 512H532C592 512 640 463 640 404C640 347 595 300 539 296ZM104 240C73 240 48 215 48 184C48 154 72 129 103 128L126 129L129 107C134 74 163 48 197 48C226 48 252 66 262 93L271 117L294 106C302 103 309 101 317 101C348 101 373 126 373 157C373 173 367 188 354 199L353 200C340 195 326 192 312 192C273 192 238 211 216 240H104ZM532 464H236C203 464 176 437 176 404C176 376 195 352 222 346L243 341L240 316C240 315 240 313 240 312C240 272 272 240 312 240C337 240 360 253 373 275L387 297L408 282C417 275 429 272 440 272C469 272 492 294 495 322L498 344H532C565 344 592 371 592 404S565 464 532 464Z"]
  };
  var faCloudsMoon = {
    prefix: 'far',
    iconName: 'clouds-moon',
    icon: [640, 512, [], "f745", "M631 249C552 263 480 204 480 126C480 80 505 39 544 17C551 13 549 4 542 3C534 1 521 0 512 0C443 0 384 43 361 104C393 129 414 167 414 211C414 224 412 236 408 247C445 259 475 285 494 318C500 319 506 320 512 320C562 320 608 298 638 261C643 255 638 247 631 249ZM383 274C379 268 374 263 370 258C377 244 382 228 382 211C382 155 337 109 282 107C258 78 222 59 183 59C143 59 106 78 82 110C35 119 0 161 0 211C0 248 19 280 49 299C21 321 4 354 4 392C4 458 58 512 123 512H362C428 512 481 458 481 392C481 333 439 284 383 274ZM48 211C48 180 73 155 103 155H110C122 127 150 107 183 107C217 107 246 129 257 160C264 157 271 155 278 155C309 155 334 180 334 211C334 219 332 226 329 232C317 227 304 224 290 224C281 224 271 225 262 228C242 215 219 208 195 208C152 208 112 230 89 265C65 259 48 237 48 211ZM362 464H123C84 464 52 432 52 392C52 354 81 324 117 321C124 284 156 256 195 256C219 256 240 267 254 283C265 276 277 272 290 272C320 272 345 293 352 321C355 321 358 320 362 320C401 320 433 352 433 392C433 432 401 464 362 464Z"]
  };
  var faCloudsSun = {
    prefix: 'far',
    iconName: 'clouds-sun',
    icon: [640, 512, [], "f746", "M96 208C96 146 146 96 208 96C245 96 277 114 298 142C306 134 314 127 324 122C328 115 333 109 337 102L317 99L301 10C300 1 289 -3 282 2L208 54L134 2C127 -3 116 1 115 10L99 99L10 115C1 116 -3 127 2 134L54 208L2 282C-3 289 1 300 10 301L99 317L115 406C116 413 124 417 130 415C129 408 128 400 128 392C128 360 138 331 155 306C120 287 96 250 96 208ZM128 208C128 241 148 269 176 281C187 271 200 262 214 255C225 236 241 219 260 206C263 192 269 179 277 168C263 144 237 128 208 128C164 128 128 164 128 208ZM640 237C640 186 602 144 552 138C532 103 494 80 452 80C406 80 366 106 348 146C316 160 293 190 289 225C267 238 248 257 237 280C191 298 160 341 160 392C160 458 214 512 280 512H520C586 512 640 458 640 392C640 360 627 331 607 310C627 292 640 266 640 237ZM520 464H280C240 464 208 432 208 392C208 354 237 324 274 321C281 284 313 256 352 256C376 256 397 267 412 283C422 276 435 272 448 272C478 272 503 293 510 321C513 321 517 320 520 320C560 320 592 352 592 392S560 464 520 464ZM566 281C558 278 550 275 541 274C521 243 486 224 448 224C438 224 429 225 420 228C400 215 376 208 352 208C350 208 348 208 346 209C354 196 368 187 385 186C390 153 418 128 452 128C488 128 517 156 520 191C526 188 533 186 541 186C569 186 592 209 592 237C592 256 581 273 566 281Z"]
  };
  var faClub = {
    prefix: 'far',
    iconName: 'club',
    icon: [512, 512, [], "f327", "M394 160C395 153 396 146 396 138C396 62 333 0 256 0S116 62 116 138C116 146 117 153 118 160C51 174 0 232 0 303C0 383 66 448 147 448C177 448 207 438 232 422V464H184C171 464 160 475 160 488S171 512 184 512H328C341 512 352 501 352 488S341 464 328 464H280V422C305 438 336 448 365 448C446 448 512 383 512 303C512 232 461 174 394 160ZM365 400C332 400 294 380 276 353C275 353 275 353 274 352C273 350 271 349 269 347C268 347 267 346 266 345C263 344 260 343 256 343S249 344 246 345C245 346 244 347 243 347C241 349 239 350 238 352C237 353 237 353 236 353C218 380 180 400 147 400C93 400 48 356 48 303S93 205 145 205C154 206 164 202 169 195C173 188 174 179 171 172C166 161 164 150 164 138C164 89 205 48 256 48S348 89 348 138C348 150 346 161 341 172C338 179 339 188 343 195C348 201 355 205 363 205C364 205 365 205 366 205C420 206 464 249 464 303C464 356 419 400 365 400Z"]
  };
  var faCode = {
    prefix: 'far',
    iconName: 'code',
    icon: [640, 512, [], "f121", "M170 120C160 110 145 109 136 118L8 238C3 243 0 249 0 256S3 269 8 274L136 394C140 398 146 400 152 400C158 400 165 397 170 392C179 383 178 368 168 358L59 256L168 154C178 144 179 129 170 120ZM390 1C378 -3 364 5 361 18L233 482C229 494 237 508 250 511C252 512 254 512 256 512C267 512 276 505 279 494L407 30C411 18 403 4 390 1ZM632 238L504 118C495 109 480 110 470 120C461 129 462 144 472 154L581 256L472 358C462 368 461 383 470 392C475 397 482 400 488 400C494 400 500 398 504 394L632 274C637 269 640 263 640 256S637 243 632 238Z"]
  };
  var faCodeBranch = {
    prefix: 'far',
    iconName: 'code-branch',
    icon: [384, 512, [], "f126", "M384 144C384 100 348 64 304 64S224 100 224 144C224 180 248 211 282 221C281 237 277 249 270 258C255 277 221 280 185 283C157 286 128 289 104 300V156C137 146 160 116 160 80C160 36 124 0 80 0S0 36 0 80C0 116 23 146 56 156V356C23 366 0 396 0 432C0 476 36 512 80 512S160 476 160 432C160 398 139 369 109 357C112 352 117 348 124 344C140 336 164 334 190 331C232 327 280 323 308 288C322 270 329 248 330 220C361 209 384 179 384 144ZM80 48C98 48 112 62 112 80S98 112 80 112S48 98 48 80S62 48 80 48ZM80 464C62 464 48 450 48 432S62 400 80 400S112 414 112 432S98 464 80 464ZM304 176C286 176 272 162 272 144S286 112 304 112S336 126 336 144S322 176 304 176Z"]
  };
  var faCodeCommit = {
    prefix: 'far',
    iconName: 'code-commit',
    icon: [640, 512, [], "f386", "M608 224H477C462 151 397 96 320 96S178 151 163 224H32C14 224 0 238 0 256V256C0 274 14 288 32 288H163C178 361 243 416 320 416S462 361 477 288H608C626 288 640 274 640 256V256C640 238 626 224 608 224ZM399 335C378 356 350 368 320 368S262 356 241 335C220 314 208 286 208 256S220 198 241 177C262 156 290 144 320 144S378 156 399 177C420 198 432 226 432 256S420 314 399 335Z"]
  };
  var faCodeMerge = {
    prefix: 'far',
    iconName: 'code-merge',
    icon: [384, 512, [], "f387", "M304 192C266 192 234 218 226 254C202 250 168 241 142 216C126 201 114 180 109 155C139 143 160 114 160 80C160 36 124 0 80 0S0 36 0 80C0 116 23 146 56 156V356C23 366 0 396 0 432C0 476 36 512 80 512S160 476 160 432C160 396 137 366 104 356V246C106 248 107 249 109 251C148 289 199 300 230 303C242 332 271 352 304 352C348 352 384 316 384 272C384 228 348 192 304 192ZM80 48C98 48 112 62 112 80S98 112 80 112S48 98 48 80S62 48 80 48ZM80 464C62 464 48 450 48 432S62 400 80 400S112 414 112 432S98 464 80 464ZM304 304C286 304 272 290 272 272S286 240 304 240S336 254 336 272S322 304 304 304Z"]
  };
  var faCoffeeBean = {
    prefix: 'far',
    iconName: 'coffee-bean',
    icon: [448, 512, [], "e103", "M436 130C426 107 370 53 353 46C332 36 310 32 287 32C220 32 148 70 94 125C21 197 -23 300 12 382C22 405 78 459 95 466C116 476 138 480 161 480C228 480 300 442 354 387C427 315 471 212 436 130ZM127 159C177 109 236 80 287 80C303 80 319 83 332 89C338 92 346 100 355 108C332 184 286 230 217 242C142 257 87 299 57 364C57 364 57 363 56 363C29 298 72 214 127 159ZM321 353C271 403 212 432 161 432C145 432 129 429 116 423C110 420 102 412 93 404C114 341 158 302 226 290C304 275 360 226 392 149C392 149 392 149 392 149C419 214 376 298 321 353Z"]
  };
  var faCoffeeBeans = {
    prefix: 'far',
    iconName: 'coffee-beans',
    icon: [512, 512, [], "e104", "M170 196C162 193 144 192 127 192C110 192 94 193 88 195C29 217 0 284 0 352C0 418 29 486 86 508C94 511 112 512 129 512C146 512 162 511 168 509C227 487 256 420 256 352C256 286 227 218 170 196ZM111 463C106 463 103 463 102 462C65 447 48 396 48 352C48 311 62 265 94 246C78 290 82 333 108 371C128 401 129 432 111 463ZM167 455C178 417 171 379 147 344C126 313 127 279 149 241C151 241 153 242 154 242C191 257 208 308 208 352C208 391 195 435 167 455ZM456 57C422 23 377 0 334 0C319 0 305 3 291 9C275 16 239 53 234 64C209 119 234 185 280 231C314 265 359 288 402 288C417 288 431 285 445 279C461 272 497 235 502 224C527 169 502 103 456 57ZM425 236C418 238 410 240 402 240C374 240 341 224 314 197C290 173 270 137 273 106C294 141 326 164 367 172C401 178 423 197 436 226C431 230 427 234 425 236ZM376 125C341 118 317 96 303 59C306 56 309 54 311 52C318 50 326 48 334 48C362 48 395 64 422 91C445 114 464 147 464 177C443 150 413 132 376 125Z"]
  };
  var faCoffeePot = {
    prefix: 'far',
    iconName: 'coffee-pot',
    icon: [512, 512, [], "e002", "M428 175L480 32H88C39 32 0 71 0 120V200C0 213 11 224 24 224H24C37 224 48 213 48 200V120C48 98 66 80 88 80H114L148 175C97 215 64 276 64 345C64 396 83 429 114 462C125 474 139 480 155 480L421 480C436 480 451 474 462 463C493 430 512 396 512 345C512 277 480 215 428 175ZM411 80L382 160H194L165 80H411ZM114 320C121 274 148 234 186 208H392C429 234 455 274 462 320H114Z"]
  };
  var faCoffin = {
    prefix: 'far',
    iconName: 'coffin',
    icon: [448, 512, [], "f6c6", "M407 115L299 9C293 3 284 0 276 0H172C164 0 155 3 149 9L41 115C33 123 30 135 33 146L120 488C124 502 137 512 152 512H296C311 512 324 502 328 488L415 146C418 135 415 123 407 115ZM285 464H163L82 143L178 48H270L366 143L285 464Z"]
  };
  var faCoffinCross = {
    prefix: 'far',
    iconName: 'coffin-cross',
    icon: [384, 512, [], "e051", "M375 115L267 9C261 3 252 0 244 0H140C132 0 123 3 117 9L9 115C1 123 -2 135 1 146L88 488C92 502 105 512 120 512H264C279 512 292 502 296 488L383 146C386 135 383 123 375 115ZM253 464H131L50 143L146 48H238L334 143L253 464ZM216 120C216 107 205 96 192 96H192C179 96 168 107 168 120V160H120C107 160 96 171 96 184V184C96 197 107 208 120 208H168V328C168 341 179 352 192 352H192C205 352 216 341 216 328V208H264C277 208 288 197 288 184V184C288 171 277 160 264 160H216V120Z"]
  };
  var faCoin = {
    prefix: 'far',
    iconName: 'coin',
    icon: [512, 512, [], "f85c", "M256 64C115 64 0 129 0 208V320C0 391 115 448 256 448S512 391 512 320V208C512 129 397 64 256 64ZM88 363C62 349 48 333 48 320V292C60 301 74 310 88 316V363ZM184 394C162 391 141 385 120 378V330C141 337 162 343 184 346V394ZM296 398C283 399 270 400 256 400C242 400 229 399 216 398V350C229 351 242 352 256 352C270 352 283 351 296 350V398ZM392 378C371 385 350 391 328 394V346C350 343 371 337 392 330V378ZM464 320C464 333 450 349 424 363V317C438 310 452 301 464 292V320ZM256 304C137 304 48 253 48 208S137 112 256 112S464 163 464 208S375 304 256 304Z"]
  };
  var faCoins = {
    prefix: 'far',
    iconName: 'coins',
    icon: [512, 512, [], "f51e", "M0 216V424C0 482 97 512 192 512S384 482 384 424V216C384 100 0 100 0 216ZM336 424C336 434 286 464 192 464S48 434 48 424V380C85 399 139 408 192 408S299 399 336 380V424ZM336 320C336 330 286 360 192 360S48 330 48 320V276C85 295 139 304 192 304S299 295 336 276V320ZM192 256C98 256 48 226 48 216S98 176 192 176S336 206 336 216S286 256 192 256ZM320 0C239 0 169 21 142 53C133 63 134 78 145 87C155 95 170 94 178 84C193 66 248 48 320 48C414 48 464 78 464 88C464 90 457 102 424 113C412 117 405 131 409 143C413 153 422 160 432 160C435 160 437 159 440 158C449 155 457 152 464 148V192C464 194 457 206 423 217C411 222 404 235 408 248C412 258 421 264 431 264C434 264 436 264 439 263C448 259 457 256 464 252V296C464 298 457 310 424 321C412 325 405 339 409 351C413 361 422 368 432 368C435 368 437 367 440 366C503 345 512 313 512 296V88C512 30 415 0 320 0Z"]
  };
  var faColonSign = {
    prefix: 'far',
    iconName: 'colon-sign',
    icon: [384, 512, [], "e105", "M263 352C246 370 224 381 201 387L257 155C259 157 261 158 263 160C272 169 288 169 297 160C306 151 306 135 297 126C288 117 279 110 269 103L287 30C290 17 283 4 270 1C257 -2 244 6 241 18L225 82C216 79 206 76 196 75L207 30C210 17 203 4 190 1C177 -2 164 6 161 18L147 74C106 79 67 96 38 126C-34 198 -34 314 38 386C46 395 56 403 66 409L48 482C45 495 53 508 66 511C68 512 70 512 72 512C82 512 92 505 95 494L110 430C120 433 129 436 139 437L128 482C125 495 133 508 146 511C148 512 150 512 152 512C163 512 172 505 175 494L189 438C229 433 267 416 297 386C306 377 306 361 297 352C288 343 272 343 263 352ZM72 352C19 299 19 213 72 160C89 142 111 130 135 124L78 358C76 356 74 354 72 352ZM122 384L185 122C195 123 205 125 214 129L151 390C141 389 131 387 122 384Z"]
  };
  var faComet = {
    prefix: 'far',
    iconName: 'comet',
    icon: [512, 512, [], "e003", "M308 264L247 255L220 199C218 195 213 192 208 192C203 192 198 195 196 199L169 255L108 264C102 265 98 268 97 273C95 278 96 283 100 287L144 330L134 391C133 396 135 401 139 404S149 407 153 405L208 376L263 405C267 407 273 407 277 404C281 401 283 396 282 391L272 330L316 287C319 283 321 278 319 273C318 268 314 265 308 264ZM502 10C494 1 481 -2 469 1C441 10 374 31 316 54C312 43 304 35 294 31S272 28 262 33C220 55 116 113 59 170C-20 248 -20 375 59 453C137 532 264 532 342 453C399 396 457 292 479 250C484 240 484 229 481 218C477 208 469 200 458 196C481 138 502 71 511 43C514 31 511 18 502 10ZM431 238C407 282 357 371 308 419C280 448 241 464 201 464C160 464 121 448 93 419C33 360 33 263 93 204C142 154 234 102 274 81C277 89 279 96 285 119L310 108C358 87 418 68 457 55C444 94 425 154 404 202L393 227C422 235 425 236 431 238Z"]
  };
  var faCommand = {
    prefix: 'far',
    iconName: 'command',
    icon: [448, 512, [], "e106", "M352 288H304V224H352C405 224 448 181 448 128S405 32 352 32S256 75 256 128V176H192V128C192 75 149 32 96 32S0 75 0 128S43 224 96 224H144V288H96C43 288 0 331 0 384S43 480 96 480S192 437 192 384V336H256V384C256 437 299 480 352 480S448 437 448 384S405 288 352 288ZM304 128C304 102 326 80 352 80S400 102 400 128S378 176 352 176H304V128ZM144 384C144 410 122 432 96 432S48 410 48 384S70 336 96 336H144V384ZM144 176H96C70 176 48 154 48 128S70 80 96 80S144 102 144 128V176ZM256 288H192V224H256V288ZM352 432C326 432 304 410 304 384V336H352C378 336 400 358 400 384S378 432 352 432Z"]
  };
  var faComment = {
    prefix: 'far',
    iconName: 'comment',
    icon: [512, 512, [], "f075", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80S464 152 464 240S371 400 256 400Z"]
  };
  var faCommentArrowDown = {
    prefix: 'far',
    iconName: 'comment-arrow-down',
    icon: [512, 512, [], "e107", "M319 223L280 262V160C280 147 269 136 256 136S232 147 232 160V262L193 223C188 218 182 216 176 216S164 218 159 223C150 232 150 248 159 257L239 337C248 346 264 346 273 337L353 257C362 248 362 232 353 223S328 214 319 223ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faCommentArrowUp = {
    prefix: 'far',
    iconName: 'comment-arrow-up',
    icon: [512, 512, [], "e108", "M273 143C264 134 248 134 239 143L159 223C150 232 150 248 159 257S184 266 193 257L232 218V320C232 333 243 344 256 344S280 333 280 320V218L319 257C324 262 330 264 336 264S348 262 353 257C362 248 362 232 353 223L273 143ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faCommentCaptions = {
    prefix: 'far',
    iconName: 'comment-captions',
    icon: [512, 512, [], "e109", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80S464 152 464 240S371 400 256 400ZM240 216C240 203 229 192 216 192H120C107 192 96 203 96 216S107 240 120 240H216C229 240 240 229 240 216ZM296 272H216C203 272 192 283 192 296S203 320 216 320H296C309 320 320 309 320 296S309 272 296 272ZM136 272H120C107 272 96 283 96 296S107 320 120 320H136C149 320 160 309 160 296S149 272 136 272ZM392 272H376C363 272 352 283 352 296S363 320 376 320H392C405 320 416 309 416 296S405 272 392 272ZM392 192H296C283 192 272 203 272 216S283 240 296 240H392C405 240 416 229 416 216S405 192 392 192Z"]
  };
  var faCommentCheck = {
    prefix: 'far',
    iconName: 'comment-check',
    icon: [512, 512, [], "f4ac", "M310 168L231 261L201 231C192 222 176 222 167 231S158 256 167 265L215 313C220 317 226 320 232 320C232 320 233 320 233 320C240 320 246 317 250 312L346 200C355 190 354 174 344 166C334 157 318 158 310 168ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faCommentDollar = {
    prefix: 'far',
    iconName: 'comment-dollar',
    icon: [512, 512, [], "f651", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400ZM262 221L256 219C232 212 233 209 234 205C235 197 250 195 264 197C269 198 276 200 281 202C292 205 303 200 307 189C311 179 305 168 295 164C287 161 281 160 276 159V148C276 137 267 128 256 128S236 137 236 148V158C214 163 198 177 194 198C187 241 227 252 245 258L251 259C280 268 279 270 278 275C277 283 262 285 248 283C241 282 232 279 225 276L220 274C210 271 198 276 194 287C191 297 196 309 207 312L211 314C219 317 227 319 236 321V332C236 343 245 352 256 352S276 343 276 332V322C298 317 314 303 318 282C325 239 284 227 262 221Z"]
  };
  var faCommentDots = {
    prefix: 'far',
    iconName: 'comment-dots',
    icon: [512, 512, [], "f4ad", "M144 208C126 208 112 222 112 240S126 272 144 272S176 258 176 240S162 208 144 208ZM256 208C238 208 224 222 224 240S238 272 256 272C274 272 288 258 288 240S274 208 256 208ZM368 208C350 208 336 222 336 240S350 272 368 272C386 272 400 258 400 240S386 208 368 208ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80S464 152 464 240S371 400 256 400Z"]
  };
  var faCommentExclamation = {
    prefix: 'far',
    iconName: 'comment-exclamation',
    icon: [512, 512, [], "f4af", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400ZM256 304C238 304 224 318 224 336S238 368 256 368C274 368 288 354 288 336S274 304 256 304ZM256 272C269 272 280 261 280 248V136C280 123 269 112 256 112S232 123 232 136V248C232 261 243 272 256 272Z"]
  };
  var faCommentImage = {
    prefix: 'far',
    iconName: 'comment-image',
    icon: [512, 512, [], "e10a", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400ZM176 192C194 192 208 178 208 160S194 128 176 128S144 142 144 160S158 192 176 192ZM312 167C309 163 304 160 299 160S288 163 285 167L232 247L220 231C217 226 212 224 207 224S197 226 194 231L147 295C144 299 143 306 146 311C148 317 154 320 160 320H384C390 320 395 317 398 312C401 306 401 300 397 295L312 167Z"]
  };
  var faCommentLines = {
    prefix: 'far',
    iconName: 'comment-lines',
    icon: [512, 512, [], "f4b0", "M264 272H152C139 272 128 283 128 296S139 320 152 320H264C277 320 288 309 288 296S277 272 264 272ZM360 176H152C139 176 128 187 128 200S139 224 152 224H360C373 224 384 213 384 200S373 176 360 176ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faCommentMedical = {
    prefix: 'far',
    iconName: 'comment-medical',
    icon: [512, 512, [], "f7f5", "M336 208H288V160C288 151 281 144 272 144H240C231 144 224 151 224 160V208H176C167 208 160 215 160 224V256C160 265 167 272 176 272H224V320C224 329 231 336 240 336H272C281 336 288 329 288 320V272H336C345 272 352 265 352 256V224C352 215 345 208 336 208ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faCommentMiddle = {
    prefix: 'far',
    iconName: 'comment-middle',
    icon: [512, 512, [], "e10b", "M256 0C115 0 0 93 0 208C0 304 80 385 189 409L238 502C241 509 249 512 256 512S271 509 274 502L323 409C432 385 512 304 512 208C512 93 397 0 256 0ZM313 362L291 366L256 433L221 366L199 362C110 342 48 279 48 208C48 120 141 48 256 48S464 120 464 208C464 279 402 342 313 362Z"]
  };
  var faCommentMiddleTop = {
    prefix: 'far',
    iconName: 'comment-middle-top',
    icon: [512, 512, [], "e10c", "M323 103L274 10C271 3 263 0 256 0S241 3 238 10L189 103C80 127 0 208 0 304C0 419 115 512 256 512S512 419 512 304C512 208 432 127 323 103ZM256 464C141 464 48 392 48 304C48 233 110 170 199 150L221 146L256 79L291 146L313 150C402 170 464 233 464 304C464 392 371 464 256 464Z"]
  };
  var faCommentMinus = {
    prefix: 'far',
    iconName: 'comment-minus',
    icon: [512, 512, [], "f4b1", "M328 216H184C171 216 160 227 160 240S171 264 184 264H328C341 264 352 253 352 240S341 216 328 216ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faCommentMusic = {
    prefix: 'far',
    iconName: 'comment-music',
    icon: [512, 512, [], "f8b0", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 466C6 474 14 480 24 480C85 480 134 454 163 434C193 443 224 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C118 407 98 417 78 423C86 411 92 397 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400ZM331 129L203 176C196 178 192 184 192 191V290C187 289 181 288 176 288C149 288 128 302 128 320S149 352 176 352S224 338 224 320V235L320 198V258C315 257 309 256 304 256C277 256 256 270 256 288S277 320 304 320S352 306 352 288V144C352 139 350 134 345 131S336 127 331 129H331Z"]
  };
  var faCommentPen = {
    prefix: 'far',
    iconName: 'comment-pen',
    icon: [512, 512, [], "f4ae", "M324 149C317 142 306 142 299 149L280 168L328 216L347 197C354 190 354 179 347 172L324 149ZM173 275C171 277 170 279 170 281L160 329C159 333 163 337 167 336L215 326C217 326 219 325 221 323L312 233L264 185L173 275ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faCommentPlus = {
    prefix: 'far',
    iconName: 'comment-plus',
    icon: [512, 512, [], "f4b2", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400ZM328 216H280V168C280 155 269 144 256 144S232 155 232 168V216H184C171 216 160 227 160 240S171 264 184 264H232V312C232 325 243 336 256 336S280 325 280 312V264H328C341 264 352 253 352 240S341 216 328 216Z"]
  };
  var faCommentQuote = {
    prefix: 'far',
    iconName: 'comment-quote',
    icon: [512, 512, [], "e10d", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400ZM216 144H152C139 144 128 155 128 168V216C128 229 139 240 152 240H192V256C192 274 178 288 160 288H156C149 288 144 293 144 300V324C144 331 149 336 156 336H160C204 336 240 300 240 256V168C240 155 229 144 216 144ZM360 144H296C283 144 272 155 272 168V216C272 229 283 240 296 240H336V256C336 274 322 288 304 288H300C293 288 288 293 288 300V324C288 331 293 336 300 336H304C348 336 384 300 384 256V168C384 155 373 144 360 144Z"]
  };
  var faCommentSlash = {
    prefix: 'far',
    iconName: 'comment-slash',
    icon: [640, 512, [], "f4b3", "M631 469L513 376C552 340 576 292 576 240C576 125 461 32 320 32C252 32 191 54 145 89L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM475 347L184 119C221 95 268 80 320 80C435 80 528 152 528 240C528 281 508 318 475 347ZM320 400C293 400 267 396 242 388L219 381L199 394C185 405 166 416 142 423C149 411 156 398 162 383L172 355L152 333C134 314 112 282 112 240C112 223 115 207 122 192L83 161C71 186 64 212 64 240C64 288 84 331 117 366C102 406 71 439 71 439C64 446 62 457 66 465C70 474 78 480 88 480C150 480 198 454 227 434C256 443 287 448 320 448C358 448 393 441 425 430L379 393C360 398 341 400 320 400Z"]
  };
  var faCommentSmile = {
    prefix: 'far',
    iconName: 'comment-smile',
    icon: [512, 512, [], "f4b4", "M326 272C309 292 283 304 256 304C229 304 204 292 186 272C178 262 162 261 152 270C142 278 141 293 150 303C176 334 215 352 256 352S336 334 362 303C371 293 370 278 360 270C350 261 334 262 326 272ZM192 224C210 224 224 210 224 192S210 160 192 160S160 174 160 192S174 224 192 224ZM320 224C338 224 352 210 352 192S338 160 320 160S288 174 288 192S302 224 320 224ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80S464 152 464 240S371 400 256 400Z"]
  };
  var faCommentSms = {
    prefix: 'far',
    iconName: 'comment-sms',
    icon: [512, 512, [], "f7cd", "M302 185C297 183 290 185 287 190L256 231L225 190C222 185 216 183 210 185C204 187 200 192 200 198V282C200 289 207 296 214 296C222 296 228 289 228 282V240L245 262C250 269 262 269 267 262L284 240V282C284 289 290 296 298 296S312 289 312 282V198C312 192 308 187 302 185ZM142 227C132 224 123 222 124 217C125 213 133 211 143 213C146 213 150 215 154 216C161 218 169 214 172 207C174 200 170 192 163 190C158 188 152 186 147 185C120 181 100 192 97 212C92 241 120 249 130 252C142 256 152 258 152 263C151 267 143 269 133 267C127 266 121 264 115 262C107 259 101 263 98 271C96 278 101 286 108 289C114 291 121 294 129 295C132 295 136 296 139 296C161 296 176 285 179 268C184 239 156 231 142 227ZM378 227C369 224 360 222 361 217C361 213 369 211 379 213C383 213 387 215 391 216C398 218 406 214 408 207C411 200 407 192 400 190C394 188 389 186 384 185C357 181 337 192 333 212C328 241 356 249 367 252C379 256 389 258 388 263C387 267 379 269 369 267C364 266 357 264 351 262C344 259 337 263 335 271S337 286 344 289C351 291 358 294 365 295C369 295 372 296 376 296C397 296 412 285 415 268C420 239 393 231 378 227ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faCommentText = {
    prefix: 'far',
    iconName: 'comment-text',
    icon: [512, 512, [], "e10e", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80S464 152 464 240S371 400 256 400ZM344 144H168C155 144 144 155 144 168S155 192 168 192H232V328C232 341 243 352 256 352S280 341 280 328V192H344C357 192 368 181 368 168S357 144 344 144Z"]
  };
  var faCommentXmark = {
    prefix: 'far',
    iconName: 'comment-xmark',
    icon: [512, 512, [], "f4b5", "M324 172C315 163 299 163 290 172L256 206L222 172C213 163 197 163 188 172S179 197 188 206L222 240L188 274C179 283 179 299 188 308S213 317 222 308L256 274L290 308C299 317 315 317 324 308S333 283 324 274L290 240L324 206C333 197 333 181 324 172ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C86 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 400C229 400 203 396 178 388L155 381L135 394C121 405 102 416 78 423C85 411 92 398 98 383L108 355L88 333C70 314 48 282 48 240C48 152 141 80 256 80C371 80 464 152 464 240S371 400 256 400Z"]
  };
  var faComments = {
    prefix: 'far',
    iconName: 'comments',
    icon: [576, 512, [], "f086", "M416 192C416 104 323 32 208 32C102 32 0 98 0 192C0 229 17 263 44 290C29 321 7 345 6 345C0 352 -2 362 2 370S14 384 23 384C77 384 120 364 148 345C149 345 182 352 208 352C323 352 416 280 416 192ZM139 294L122 305C108 314 94 321 79 326C82 322 84 317 87 312L102 280L78 256C64 243 48 221 48 192C48 123 137 80 208 80C295 80 368 131 368 192S295 304 208 304C181 304 164 299 139 294ZM538 412C562 386 576 354 576 320C576 253 522 196 447 172C448 178 448 185 448 192C448 298 340 384 208 384C197 384 187 383 176 382C208 440 282 480 368 480C409 480 447 471 479 455C501 468 531 480 568 480C571 480 574 478 575 475C577 472 576 469 574 466C574 466 551 442 538 412Z"]
  };
  var faCommentsDollar = {
    prefix: 'far',
    iconName: 'comments-dollar',
    icon: [576, 512, [], "f653", "M225 271V262C244 258 258 246 261 228C267 191 232 181 213 176L208 174C188 168 188 165 189 162C190 155 203 153 215 155C220 156 225 157 230 159C239 162 249 158 252 149C255 140 250 130 241 127C235 125 230 123 225 122V113C225 104 217 96 208 96S191 104 191 113V122C172 126 158 138 155 156C149 192 183 203 198 207L203 208C228 216 228 218 227 222C226 229 213 231 201 229C195 228 188 225 181 223L177 222C168 218 158 223 155 232C152 241 157 251 166 254L169 255C176 258 183 260 191 262V271C191 280 199 288 208 288S225 280 225 271ZM538 412C562 386 576 354 576 320C576 253 522 196 447 172C448 178 448 185 448 192C448 298 340 384 208 384C197 384 187 383 176 382C208 440 282 480 368 480C409 480 447 471 479 455C501 468 531 480 568 480C571 480 574 478 575 475C577 472 576 469 574 466C574 466 551 442 538 412ZM416 192C416 104 323 32 208 32C102 32 0 98 0 192C0 229 17 263 44 290C29 321 7 345 6 345C0 352 -2 362 2 370S14 384 23 384C77 384 120 364 148 345C149 345 182 352 208 352C323 352 416 280 416 192ZM139 294L122 305C108 314 94 321 79 326C82 322 84 317 87 312L102 280L78 256C64 243 48 221 48 192C48 123 137 80 208 80C295 80 368 131 368 192S295 304 208 304C181 304 164 299 139 294Z"]
  };
  var faCompactDisc = {
    prefix: 'far',
    iconName: 'compact-disc',
    icon: [512, 512, [], "f51f", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM228 131C236 129 242 121 240 112C238 103 229 98 220 100C161 113 113 161 100 220C98 229 103 238 112 240C113 240 114 240 116 240C123 240 130 235 131 228C142 180 180 142 228 131ZM256 160C203 160 160 203 160 256C160 309 203 352 256 352S352 309 352 256C352 203 309 160 256 160ZM256 280C243 280 232 269 232 256S243 232 256 232S280 243 280 256S269 280 256 280Z"]
  };
  var faCompass = {
    prefix: 'far',
    iconName: 'compass',
    icon: [512, 512, [], "f14e", "M326 143L212 196C206 199 199 206 196 212L144 326C131 353 159 381 186 369L300 316C306 313 313 306 316 300L369 186C381 159 353 131 326 143ZM279 279C266 291 246 291 233 279C221 266 221 246 233 233C246 221 266 221 279 233C291 246 291 266 279 279ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faCompassDrafting = {
    prefix: 'far',
    iconName: 'compass-drafting',
    icon: [512, 512, [], "f568", "M509 476L436 352C422 361 408 369 394 376L467 500C472 508 480 512 488 512C492 512 496 511 500 509C512 502 515 487 509 476ZM503 236C510 225 506 210 495 203C483 197 469 200 462 212C418 285 341 328 256 328C222 328 189 321 159 307L230 188C238 190 247 192 256 192S274 190 282 188L337 279C351 273 365 265 378 256L324 164C341 146 352 122 352 96C352 43 309 0 256 0S160 43 160 96C160 122 171 146 188 164L117 284C91 265 68 241 50 212C43 200 29 197 17 203C6 210 2 225 9 236C31 272 60 302 93 325L3 476C-3 487 0 502 12 509C16 511 20 512 24 512C32 512 40 508 45 500L134 349C172 366 213 376 256 376C358 376 450 324 503 236ZM256 48C282 48 304 70 304 96S282 144 256 144S208 122 208 96S230 48 256 48Z"]
  };
  var faCompassSlash = {
    prefix: 'far',
    iconName: 'compass-slash',
    icon: [640, 512, [], "f5e9", "M631 469L523 384C546 347 560 303 560 256C560 123 453 16 320 16C252 16 191 45 147 90L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM485 354L390 280L432 186C445 159 417 131 390 143L280 194L185 120C220 85 267 64 320 64C426 64 512 150 512 256C512 292 502 326 485 354ZM320 448C214 448 128 362 128 256C128 238 131 220 136 203L96 172C86 198 80 226 80 256C80 389 187 496 320 496C370 496 417 480 456 454L415 422C387 439 355 448 320 448ZM250 369L311 341L230 277L208 326C195 353 223 381 250 369Z"]
  };
  var faCompress = {
    prefix: 'far',
    iconName: 'compress',
    icon: [448, 512, [], "f066", "M136 320H24C11 320 0 331 0 344C0 357 11 368 24 368H112V456C112 469 123 480 136 480S160 469 160 456V344C160 331 149 320 136 320ZM312 192H424C437 192 448 181 448 168C448 155 437 144 424 144H336V56C336 43 325 32 312 32S288 43 288 56V168C288 181 299 192 312 192ZM136 32C123 32 112 43 112 56V144H24C11 144 0 155 0 168C0 181 11 192 24 192H136C149 192 160 181 160 168V56C160 43 149 32 136 32ZM424 320H312C299 320 288 331 288 344V456C288 469 299 480 312 480S336 469 336 456V368H424C437 368 448 357 448 344C448 331 437 320 424 320Z"]
  };
  var faCompressWide = {
    prefix: 'far',
    iconName: 'compress-wide',
    icon: [512, 512, [], "f326", "M376 224H488C501 224 512 213 512 200C512 187 501 176 488 176H400V88C400 75 389 64 376 64S352 75 352 88V200C352 213 363 224 376 224ZM136 288H24C11 288 0 299 0 312C0 325 11 336 24 336H112V424C112 437 123 448 136 448S160 437 160 424V312C160 299 149 288 136 288ZM488 288H376C363 288 352 299 352 312V424C352 437 363 448 376 448S400 437 400 424V336H488C501 336 512 325 512 312C512 299 501 288 488 288ZM136 64C123 64 112 75 112 88V176H24C11 176 0 187 0 200C0 213 11 224 24 224H136C149 224 160 213 160 200V88C160 75 149 64 136 64Z"]
  };
  var faComputerClassic = {
    prefix: 'far',
    iconName: 'computer-classic',
    icon: [448, 512, [], "f8b1", "M384 0H64C29 0 0 29 0 64V368C0 392 13 412 32 423V480C32 498 46 512 64 512H384C402 512 416 498 416 480V423C435 412 448 392 448 368V64C448 29 419 0 384 0ZM368 464H80V432H368V464ZM400 368C400 377 393 384 384 384H64C55 384 48 377 48 368V64C48 55 55 48 64 48H384C393 48 400 55 400 64V368ZM336 80H112C94 80 80 94 80 112V208C80 226 94 240 112 240H336C354 240 368 226 368 208V112C368 94 354 80 336 80ZM120 304C107 304 96 315 96 328C96 341 107 352 120 352S144 341 144 328C144 315 133 304 120 304ZM352 304H224C215 304 208 311 208 320S215 336 224 336H352C361 336 368 329 368 320S361 304 352 304Z"]
  };
  var faComputerMouse = {
    prefix: 'far',
    iconName: 'computer-mouse',
    icon: [384, 512, [], "f8cc", "M224 0H160C72 0 0 72 0 160V352C0 440 72 512 160 512H224C312 512 384 440 384 352V160C384 72 312 0 224 0ZM336 160V176H216V48H224C286 48 336 98 336 160ZM160 48H168V176H48V160C48 98 98 48 160 48ZM224 464H160C98 464 48 414 48 352V224H336V352C336 414 286 464 224 464Z"]
  };
  var faComputerMouseScrollwheel = {
    prefix: 'far',
    iconName: 'computer-mouse-scrollwheel',
    icon: [384, 512, [], "f8cd", "M224 0H160C72 0 0 72 0 160V352C0 440 72 512 160 512H224C312 512 384 440 384 352V160C384 72 312 0 224 0ZM336 352C336 414 286 464 224 464H160C98 464 48 414 48 352V160C48 98 98 48 160 48H224C286 48 336 98 336 160V352ZM192 96C174 96 160 110 160 128V160C160 178 174 192 192 192C210 192 224 178 224 160V128C224 110 210 96 192 96Z"]
  };
  var faComputerSpeaker = {
    prefix: 'far',
    iconName: 'computer-speaker',
    icon: [640, 512, [], "f8b2", "M576 32H384C349 32 320 61 320 96V416C320 451 349 480 384 480H576C611 480 640 451 640 416V96C640 61 611 32 576 32ZM592 416C592 425 585 432 576 432H384C375 432 368 425 368 416V96C368 87 375 80 384 80H576C585 80 592 87 592 96V416ZM0 96V320C0 355 29 384 64 384H288V336H64C55 336 48 329 48 320V96C48 87 55 80 64 80H290C293 62 301 45 313 32H64C29 32 0 61 0 96ZM120 432C107 432 96 443 96 456C96 469 107 480 120 480H313C301 467 293 450 290 432H120ZM480 240C436 240 400 276 400 320C400 364 436 400 480 400C524 400 560 364 560 320C560 276 524 240 480 240ZM480 352C462 352 448 338 448 320S462 288 480 288S512 302 512 320S498 352 480 352ZM480 176C498 176 512 162 512 144S498 112 480 112C462 112 448 126 448 144S462 176 480 176Z"]
  };
  var faContainerStorage = {
    prefix: 'far',
    iconName: 'container-storage',
    icon: [640, 512, [], "f4b7", "M616 432H608V80H616C629 80 640 69 640 56S629 32 616 32H24C11 32 0 43 0 56S11 80 24 80H32V432H24C11 432 0 443 0 456S11 480 24 480H616C629 480 640 469 640 456S629 432 616 432ZM560 432H80V80H560V432ZM192 400C205 400 216 389 216 376V136C216 123 205 112 192 112S168 123 168 136V376C168 389 179 400 192 400ZM320 400C333 400 344 389 344 376V136C344 123 333 112 320 112S296 123 296 136V376C296 389 307 400 320 400ZM448 400C461 400 472 389 472 376V136C472 123 461 112 448 112S424 123 424 136V376C424 389 435 400 448 400Z"]
  };
  var faConveyorBelt = {
    prefix: 'far',
    iconName: 'conveyor-belt',
    icon: [640, 512, [], "f46e", "M128 368C110 368 96 382 96 400S110 432 128 432S160 418 160 400S146 368 128 368ZM528 288H112C50 288 0 338 0 400S50 512 112 512H528C590 512 640 462 640 400S590 288 528 288ZM528 464H112C77 464 48 435 48 400C48 365 77 336 112 336H528C563 336 592 365 592 400C592 435 563 464 528 464ZM512 368C494 368 480 382 480 400S494 432 512 432S544 418 544 400S530 368 512 368ZM320 368C302 368 288 382 288 400S302 432 320 432S352 418 352 400S338 368 320 368ZM192 256H448C483 256 512 227 512 192V64C512 29 483 0 448 0H192C157 0 128 29 128 64V192C128 227 157 256 192 256ZM176 64C176 55 183 48 192 48H256C256 70 256 128 256 128L320 96L384 128V48H448C457 48 464 55 464 64V192C464 201 457 208 448 208H192C183 208 176 201 176 192V64Z"]
  };
  var faConveyorBeltBoxes = {
    prefix: 'far',
    iconName: 'conveyor-belt-boxes',
    icon: [640, 512, [], "f46f", "M128 368C110 368 96 382 96 400S110 432 128 432S160 418 160 400S146 368 128 368ZM160 256H304C319 256 333 250 344 242C355 250 369 256 384 256H480C515 256 544 227 544 192V128C544 93 515 64 480 64H384C378 64 373 65 368 66V64C368 29 339 0 304 0H160C125 0 96 29 96 64V192C96 227 125 256 160 256ZM368 128C368 119 375 112 384 112H480C489 112 496 119 496 128V192C496 201 489 208 480 208H384C375 208 368 201 368 192V128ZM144 64C144 55 151 48 160 48H304C313 48 320 55 320 64V192C320 201 313 208 304 208H160C151 208 144 201 144 192V64ZM512 368C494 368 480 382 480 400S494 432 512 432S544 418 544 400S530 368 512 368ZM320 368C302 368 288 382 288 400S302 432 320 432S352 418 352 400S338 368 320 368ZM528 288H112C50 288 0 338 0 400S50 512 112 512H528C590 512 640 462 640 400S590 288 528 288ZM528 464H112C77 464 48 435 48 400C48 365 77 336 112 336H528C563 336 592 365 592 400C592 435 563 464 528 464Z"]
  };
  var faConveyorBeltEmpty = {
    prefix: 'far',
    iconName: 'conveyor-belt-empty',
    icon: [640, 512, [], "e10f", "M128 368C110 368 96 382 96 400S110 432 128 432S160 418 160 400S146 368 128 368ZM512 368C494 368 480 382 480 400S494 432 512 432S544 418 544 400S530 368 512 368ZM320 368C302 368 288 382 288 400S302 432 320 432S352 418 352 400S338 368 320 368ZM528 288H112C50 288 0 338 0 400S50 512 112 512H528C590 512 640 462 640 400S590 288 528 288ZM528 464H112C77 464 48 435 48 400C48 365 77 336 112 336H528C563 336 592 365 592 400C592 435 563 464 528 464Z"]
  };
  var faCookie = {
    prefix: 'far',
    iconName: 'cookie',
    icon: [576, 512, [], "f563", "M368 304C350 304 336 318 336 336S350 368 368 368S400 354 400 336S386 304 368 304ZM336 144C354 144 368 130 368 112S354 80 336 80S304 94 304 112S318 144 336 144ZM208 176C208 158 194 144 176 144S144 158 144 176S158 208 176 208S208 194 208 176ZM208 304C190 304 176 318 176 336S190 368 208 368S240 354 240 336S226 304 208 304ZM304 208C286 208 272 222 272 240S286 272 304 272S336 258 336 240S322 208 304 208ZM526 239L514 162C510 135 497 109 477 90L422 35C403 15 377 2 350 -2L273 -14C266 -15 259 -16 252 -16C232 -16 211 -11 193 -2L123 34C99 46 78 66 66 91L30 160C18 185 13 214 18 241L30 318C34 345 47 371 67 390L122 445C141 465 167 478 194 482L271 494C278 495 285 496 292 496C312 496 333 491 352 482L421 446C446 434 466 414 479 389L514 320C526 295 531 266 526 239ZM471 298L436 367C427 383 415 396 399 404L330 439C318 445 305 448 292 448C287 448 283 448 278 447L202 435C184 432 168 424 156 411L101 357C88 344 80 328 77 310L65 234C62 216 65 198 73 182L108 113C117 97 129 85 145 76L214 41C226 35 239 32 252 32C257 32 261 32 266 33L342 45C360 48 376 56 389 69L443 123C456 136 464 152 467 170L479 246C482 264 479 282 471 298Z"]
  };
  var faCookieBite = {
    prefix: 'far',
    iconName: 'cookie-bite',
    icon: [512, 512, [], "f564", "M352 320C334 320 320 334 320 352S334 384 352 384S384 370 384 352S370 320 352 320ZM192 192C192 174 178 160 160 160S128 174 128 192S142 224 160 224S192 210 192 192ZM192 320C174 320 160 334 160 352S174 384 192 384C210 384 224 370 224 352S210 320 192 320ZM288 224C270 224 256 238 256 256S270 288 288 288S320 274 320 256S306 224 288 224ZM510 256C441 255 384 198 384 128C314 128 257 71 256 2C250 1 243 0 236 0C216 0 195 5 177 14L107 50C83 62 62 82 50 107L14 176C2 201 -3 230 2 257L14 334C18 361 31 387 51 406L106 461C125 481 151 494 178 498L255 510C262 511 269 512 276 512C296 512 317 507 336 498L405 462C430 450 450 430 462 405L498 336C510 311 515 283 510 256ZM455 314L420 383C412 399 399 411 383 420L314 455C302 461 289 464 276 464C271 464 267 464 263 463L186 451C168 448 152 440 140 427L85 373C72 360 64 344 61 326L49 250C46 232 49 214 57 198L92 129C101 113 113 101 129 92L198 57C204 54 210 52 216 51C234 110 282 156 341 171C357 231 402 279 462 296C460 302 458 308 455 314Z"]
  };
  var faCopy = {
    prefix: 'far',
    iconName: 'copy',
    icon: [512, 512, [], "f0c5", "M503 71L441 9C435 3 427 0 419 0H256C221 0 192 29 192 64L192 320C192 355 221 384 256 384H448C483 384 512 355 512 320V93C512 85 509 77 503 71ZM464 320C464 329 457 336 448 336H256C247 336 240 329 240 320L240 64C240 55 247 48 256 48H384V96C384 114 398 128 416 128H464V320ZM272 448C272 457 265 464 256 464H64C55 464 48 457 48 448L48 192C48 183 55 176 64 176H160V128H64C29 128 0 157 0 192L0 448C0 483 29 512 64 512H256C291 512 320 483 320 448V416H272V448Z"]
  };
  var faCopyright = {
    prefix: 'far',
    iconName: 'copyright',
    icon: [512, 512, [], "f1f9", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM255 176C255 176 255 176 255 176C276 176 296 184 311 199C320 209 335 209 345 200C354 190 354 175 345 166C321 141 289 128 255 128C255 128 255 128 255 128C221 128 189 141 165 166C116 215 116 297 165 346C189 371 221 384 255 384C255 384 255 384 255 384C289 384 321 371 345 346C354 337 354 322 345 312C335 303 320 303 311 313C296 328 276 336 255 336C255 336 255 336 255 336C234 336 214 328 199 313C168 281 168 231 199 199C214 184 234 176 255 176Z"]
  };
  var faCorn = {
    prefix: 'far',
    iconName: 'corn',
    icon: [512, 512, [], "f6c7", "M442 0C440 0 437 0 435 0C423 0 411 3 401 8C397 7 393 7 390 7C383 7 375 8 368 10C359 13 350 17 343 23C334 24 325 26 316 29C307 33 300 39 293 45C284 47 275 50 267 55C259 59 253 65 247 71C238 74 230 78 223 83C218 86 214 91 210 96C205 90 200 84 195 79L174 58C156 40 125 49 120 74L99 181L37 242C-10 289 -12 364 31 414L91 476C119 503 156 516 196 511C226 507 252 492 273 471L331 413L438 392C463 387 472 356 454 338L433 317C428 312 422 307 417 302C420 299 424 296 427 292C432 284 436 276 438 268C445 262 451 255 456 247C461 239 464 231 465 222C472 215 477 208 481 199C485 191 487 181 487 172C493 165 497 156 500 147C503 137 504 126 503 116C508 105 511 94 512 83V81C514 39 484 4 442 0ZM64 380C40 349 43 304 71 276L143 204L161 113C207 159 223 215 210 268C176 280 144 300 117 327L64 380ZM308 369L236 441C205 472 155 472 124 441L98 414L151 361C189 323 237 302 285 302C326 302 366 318 399 351L308 369ZM448 105C454 112 457 123 454 133C451 143 444 150 435 152C440 160 441 170 437 180C433 189 425 195 415 196C420 205 419 214 414 223C409 232 401 237 391 237C395 246 394 256 388 264C384 270 378 272 372 274C345 262 315 255 285 255C277 255 269 255 261 256C266 217 259 177 240 140C241 133 244 126 251 122C260 115 271 116 277 118C278 110 283 101 291 96C305 88 318 95 318 95C320 86 326 78 335 74C347 69 357 72 362 76C365 66 372 59 382 56C385 56 398 52 409 63C433 19 495 81 448 105Z"]
  };
  var faCouch = {
    prefix: 'far',
    iconName: 'couch',
    icon: [640, 512, [], "f4b8", "M576 224C541 224 512 253 512 288H128C128 253 99 224 64 224S0 253 0 288V448C0 466 14 480 32 480H96C114 480 128 466 128 448H512C512 466 526 480 544 480H608C626 480 640 466 640 448V288C640 253 611 224 576 224ZM80 432H48V288C48 279 55 272 64 272S80 279 80 288V432ZM512 400H128V336H512V400ZM592 432H560V288C560 279 567 272 576 272S592 279 592 288V432ZM88 192C101 192 112 181 112 168V152C112 112 144 80 184 80H456C496 80 528 112 528 152V168C528 181 539 192 552 192S576 181 576 168V152C576 86 522 32 456 32H184C118 32 64 86 64 152V168C64 181 75 192 88 192Z"]
  };
  var faCow = {
    prefix: 'far',
    iconName: 'cow',
    icon: [640, 512, [], "f6c8", "M625 238L608 219V176C608 164 595 156 585 162C579 165 574 169 569 173L509 104C491 79 462 64 431 64H112C63 64 24 103 24 152V238C10 250 0 268 0 288V320C40 320 72 288 72 248V152C72 135 83 121 97 115C97 119 96 123 96 128V416C96 434 110 448 128 448H192C210 448 224 434 224 416V376C227 377 229 377 232 378V392C232 401 239 408 248 408C257 408 264 401 264 392V383C267 383 277 383 280 383V392C280 401 287 408 296 408C305 408 312 401 312 392V378C315 377 318 377 320 376V416C320 434 334 448 352 448H416C434 448 448 434 448 416V272L464 288V330C464 342 467 354 474 365L510 420C521 437 541 448 562 448H576C611 448 640 419 640 384V280C640 265 634 250 625 238ZM210 321C217 293 242 272 272 272S327 293 334 321C273 342 272 342 210 321ZM592 384C592 393 585 400 576 400H562C557 400 553 398 550 394L515 339C514 336 513 333 512 330V268L436 192C423 179 400 189 400 207V400H368V336C368 290 330 240 272 240C214 240 176 291 176 336V400H144V128C144 119 151 112 160 112H164C165 114 190 147 190 147C211 176 241 192 272 192H272C303 192 333 176 354 147C354 147 379 114 380 112H431C446 112 461 119 470 132L588 269C591 272 592 276 592 280V384ZM560 304C551 304 544 311 544 320S551 336 560 336S576 329 576 320S569 304 560 304Z"]
  };
  var faCowbell = {
    prefix: 'far',
    iconName: 'cowbell',
    icon: [448, 512, [], "f8b3", "M387 136C382 113 363 96 339 96H321V48C321 22 299 0 273 0H176C150 0 128 22 128 48V96H109C85 96 65 113 61 136L0 474C-3 493 11 512 32 512H416C436 512 451 493 447 474L387 136ZM176 48H272V96H176V48ZM51 464L109 144H339L397 464H51Z"]
  };
  var faCowbellCirclePlus = {
    prefix: 'far',
    iconName: 'cowbell-circle-plus',
    icon: [640, 512, [], "f8b4", "M480 192C392 192 320 264 320 352S392 512 480 512C568 512 640 440 640 352S568 192 480 192ZM544 368H496V416C496 425 489 432 480 432C471 432 464 425 464 416V368H416C407 368 400 361 400 352C400 343 407 336 416 336H464V288C464 279 471 272 480 272C489 272 496 279 496 288V336H544C553 336 560 343 560 352C560 361 553 368 544 368ZM324 464H51L109 144H339L351 210C364 198 379 188 395 180L387 136C382 113 363 96 339 96H321V48C321 22 299 0 273 0H176C150 0 128 22 128 48V96H109C85 96 65 113 61 136L0 474C-3 493 11 512 32 512H374C355 499 338 483 324 464ZM176 48H272V96H176V48Z"]
  };
  var faCreditCard = {
    prefix: 'far',
    iconName: 'credit-card',
    icon: [576, 512, [], "f09d", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM48 96C48 87 55 80 64 80H512C521 80 528 87 528 96V128H48V96ZM528 416C528 425 521 432 512 432H64C55 432 48 425 48 416L48 224H528L528 416ZM120 384H168C181 384 192 373 192 360S181 336 168 336H120C107 336 96 347 96 360S107 384 120 384ZM248 384H360C373 384 384 373 384 360C384 347 373 336 360 336H248C235 336 224 347 224 360C224 373 235 384 248 384Z"]
  };
  var faCreditCardBlank = {
    prefix: 'far',
    iconName: 'credit-card-blank',
    icon: [576, 512, [], "f389", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM528 416C528 425 521 432 512 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H512C521 80 528 87 528 96V416ZM168 336H120C107 336 96 347 96 360S107 384 120 384H168C181 384 192 373 192 360S181 336 168 336ZM360 336H248C235 336 224 347 224 360C224 373 235 384 248 384H360C373 384 384 373 384 360C384 347 373 336 360 336Z"]
  };
  var faCreditCardFront = {
    prefix: 'far',
    iconName: 'credit-card-front',
    icon: [576, 512, [], "f38a", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM528 416C528 425 521 432 512 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H512C521 80 528 87 528 96V416ZM464 128H368C359 128 352 135 352 144V208C352 217 359 224 368 224H464C473 224 480 217 480 208V144C480 135 473 128 464 128ZM168 336H120C107 336 96 347 96 360C96 373 107 384 120 384H168C181 384 192 373 192 360C192 347 181 336 168 336ZM168 256H120C107 256 96 267 96 280C96 293 107 304 120 304H168C181 304 192 293 192 280C192 267 181 256 168 256ZM328 336H248C235 336 224 347 224 360C224 373 235 384 248 384H328C341 384 352 373 352 360C352 347 341 336 328 336ZM328 256H248C235 256 224 267 224 280C224 293 235 304 248 304H328C341 304 352 293 352 280C352 267 341 256 328 256ZM456 256H408C395 256 384 267 384 280C384 293 395 304 408 304H456C469 304 480 293 480 280C480 267 469 256 456 256Z"]
  };
  var faCricketBatBall = {
    prefix: 'far',
    iconName: 'cricket-bat-ball',
    icon: [512, 512, [], "f449", "M408 218L374 184L503 55C515 42 515 22 503 9C496 3 488 0 480 0C472 0 464 3 457 9L328 138L294 104C289 99 281 96 274 96S260 99 255 104L192 167L10 349C3 356 -1 365 0 374C7 447 65 505 138 512C139 512 140 512 141 512C149 512 157 508 163 502L261 405H261L408 257C419 246 419 229 408 218ZM227 371L134 463C91 455 57 421 49 378L176 251V336H261L227 371ZM309 288H224V203L274 152L294 172L311 189L340 218L360 238L309 288ZM432 352C388 352 352 388 352 432C352 476 388 512 432 512S512 476 512 432C512 388 476 352 432 352ZM432 464C414 464 400 450 400 432C400 414 414 400 432 400S464 414 464 432C464 450 450 464 432 464Z"]
  };
  var faCroissant = {
    prefix: 'far',
    iconName: 'croissant',
    icon: [512, 512, [], "f7f6", "M508 168C494 132 468 102 434 84C431 67 422 52 408 42C373 15 330 0 285 0C270 0 255 2 239 6C225 0 209 -2 193 2C99 26 26 99 2 193C-2 208 0 224 6 239C-8 298 5 359 41 407C52 421 66 430 83 433C101 467 131 494 168 508C215 525 263 486 255 436L239 341C241 339 242 338 243 335C262 335 279 327 292 314L314 292C327 279 334 262 335 244C337 243 340 241 342 239L436 255C486 263 525 214 508 168ZM112 382C100 391 86 387 79 378C58 350 48 315 49 280C50 281 51 281 52 282L187 323L112 382ZM185 463C165 455 147 442 135 425C137 423 139 422 142 420L197 377L208 444C209 450 206 456 202 460C197 464 191 465 185 463ZM280 258L258 280C251 287 241 290 232 287L66 236C53 232 45 218 49 205C68 128 128 68 205 49C218 45 232 53 236 66L287 232C290 241 287 251 280 258V258ZM323 188L281 52C281 51 280 50 280 48C282 48 284 48 285 48C319 48 352 59 379 80C387 86 392 100 383 112L323 188ZM444 208L377 197L421 141C422 139 424 137 425 135C442 148 455 165 463 185C465 191 464 197 460 202C456 206 450 209 444 208Z"]
  };
  var faCrop = {
    prefix: 'far',
    iconName: 'crop',
    icon: [512, 512, [], "f125", "M512 408C512 421 501 432 488 432H432V488C432 501 421 512 408 512S384 501 384 488V162L162 384H352V432H120C98 432 80 414 80 392V128H24C11 128 0 117 0 104S11 80 24 80H80V24C80 11 91 0 104 0S128 11 128 24V350L350 128H160V80H398L471 7C480 -2 496 -2 505 7S514 32 505 41L432 114V384H488C501 384 512 395 512 408Z"]
  };
  var faCropSimple = {
    prefix: 'far',
    iconName: 'crop-simple',
    icon: [512, 512, [], "f565", "M488 384H432V120C432 98 414 80 392 80H160V128H384V488C384 501 395 512 408 512S432 501 432 488V432H488C501 432 512 421 512 408S501 384 488 384ZM128 384V24C128 11 117 0 104 0S80 11 80 24V80H24C11 80 0 91 0 104S11 128 24 128H80V392C80 414 98 432 120 432H352V384H128Z"]
  };
  var faCross = {
    prefix: 'far',
    iconName: 'cross',
    icon: [384, 512, [], "f654", "M336 112H272V48C272 22 250 0 224 0H160C134 0 112 22 112 48V112H48C21 112 0 134 0 160V224C0 250 22 272 48 272H112V464C112 490 134 512 160 512H224C250 512 272 490 272 464V272H336C362 272 384 250 384 224V160C384 134 362 112 336 112ZM336 224H224V464H160V224H48V160H160V48H224V160H336V224Z"]
  };
  var faCrosshairs = {
    prefix: 'far',
    iconName: 'crosshairs',
    icon: [512, 512, [], "f05b", "M488 232H471C460 132 380 52 280 41V24C280 11 269 0 256 0H256C243 0 232 11 232 24V41C132 52 52 132 41 232H24C11 232 0 243 0 256V256C0 269 11 280 24 280H41C52 380 132 460 232 471V488C232 501 243 512 256 512H256C269 512 280 501 280 488V471C380 460 460 380 471 280H488C501 280 512 269 512 256V256C512 243 501 232 488 232ZM280 422V392C280 379 269 368 256 368H256C243 368 232 379 232 392V422C158 412 100 354 90 280H120C133 280 144 269 144 256V256C144 243 133 232 120 232H90C100 158 158 100 232 90V120C232 133 243 144 256 144H256C269 144 280 133 280 120V90C354 100 412 158 422 232H392C379 232 368 243 368 256V256C368 269 379 280 392 280H422C412 354 354 412 280 422ZM288 256C288 274 274 288 256 288C238 288 224 274 224 256S238 224 256 224C274 224 288 238 288 256Z"]
  };
  var faCrow = {
    prefix: 'far',
    iconName: 'crow',
    icon: [640, 512, [], "f520", "M544 32H519C502 13 476 0 448 0C395 0 352 43 352 96V126L12 394C5 399 0 408 0 418C0 435 14 448 30 448C35 448 39 447 44 445L165 384H262H263L306 496C309 506 318 512 328 512C331 512 334 511 336 510C349 506 355 492 350 480L315 384H352C354 384 356 384 358 384L359 383L402 496C405 506 414 512 424 512C427 512 430 511 432 510C445 506 451 492 446 479L407 376C486 352 544 279 544 192V112L640 96C640 61 597 32 544 32ZM496 192C496 271 431 336 352 336H274L320 323C368 309 408 276 430 231C434 223 431 214 423 210C415 206 406 209 402 217C383 254 350 281 311 292L166 334L382 164L400 150V96C400 70 422 48 448 48S496 70 496 96V192ZM448 72C435 72 424 83 424 96S435 120 448 120S472 109 472 96S461 72 448 72Z"]
  };
  var faCrown = {
    prefix: 'far',
    iconName: 'crown',
    icon: [576, 512, [], "f521", "M536 96C514 96 496 114 496 136C496 145 500 153 505 160L415 231C409 236 402 238 395 238C383 238 372 232 366 221L309 105C320 98 328 86 328 72C328 50 310 32 288 32S248 50 248 72C248 86 256 98 267 105L210 221C204 232 193 238 181 238C174 238 167 236 161 231L71 160C76 153 80 145 80 136C80 114 62 96 40 96S0 114 0 136S18 176 40 176C40 176 40 176 41 176L91 454C94 469 107 480 123 480H453C469 480 482 469 485 454L535 176C536 176 536 176 536 176C558 176 576 158 576 136S558 96 536 96ZM440 432H136L102 246L131 269C145 280 163 286 181 286C212 286 239 269 253 242L288 171L323 242C337 269 364 286 395 286C413 286 431 280 445 269L474 246L440 432Z"]
  };
  var faCrutch = {
    prefix: 'far',
    iconName: 'crutch',
    icon: [512, 512, [], "f7f7", "M329 256L249 177L321 105L287 71L166 192C154 204 146 219 142 235L114 357L7 464C-2 473 -2 489 7 498C12 503 18 505 24 505S36 503 41 498L148 391L270 363C286 359 301 351 313 339L434 218L400 184L329 256ZM279 306C273 311 267 315 259 316L168 338L189 246C191 238 194 232 200 226L215 211L295 290L279 306ZM505 210C500 215 494 217 488 217S476 215 471 210L348 87C348 87 348 86 347 86L295 34C286 25 286 9 295 0S320 -9 329 0L452 123C452 124 453 124 453 124L505 176C514 185 514 201 505 210Z"]
  };
  var faCrutches = {
    prefix: 'far',
    iconName: 'crutches',
    icon: [640, 512, [], "f7f8", "M457 263L377 184L449 112L415 78L294 199C282 211 274 226 270 242L242 364L135 471C126 480 126 496 135 505C140 510 146 512 152 512S164 510 169 505L276 398L398 370C414 366 429 358 441 346L562 225L528 191L457 263ZM407 313C401 318 395 322 387 323L296 344L317 253C319 245 322 239 328 233L343 218L423 297L407 313ZM633 217C628 222 622 224 616 224S604 222 599 217L476 93C476 93 476 93 475 93L423 41C414 32 414 16 423 7S448 -2 457 7L580 130C580 130 581 130 581 131L633 183C642 192 642 208 633 217ZM55 203L41 217C36 222 30 224 24 224S12 222 7 217C-2 208 -2 192 7 183L59 131C60 131 60 130 60 130L183 7C192 -2 208 -2 217 7S226 32 217 41L202 56L297 151L271 177C269 179 266 182 264 185L168 89L165 93C164 93 164 93 164 93L89 169L223 303L213 348L208 353C205 351 202 349 199 346L55 203ZM505 471C514 480 514 496 505 505C500 510 494 512 488 512S476 510 471 505L374 408L406 401C413 399 420 397 427 393L505 471Z"]
  };
  var faCruzeiroSign = {
    prefix: 'far',
    iconName: 'cruzeiro-sign',
    icon: [384, 512, [], "e110", "M377 380C386 390 386 405 377 414C335 457 280 480 221 480C221 480 221 480 221 480C162 480 106 457 64 414C-21 327 -21 185 64 98C106 55 162 32 221 32C280 32 335 55 377 98C386 107 386 122 377 132C367 141 352 141 343 131C310 98 267 80 221 80C175 80 131 98 99 131C31 200 31 312 99 381C116 398 137 412 160 420V248C160 235 171 224 184 224C195 224 204 232 207 242C219 236 232 232 246 232C281 232 312 252 326 284C331 296 326 310 313 316C301 321 287 315 282 303C276 289 262 280 246 280C225 280 208 297 208 318V431C212 431 216 432 221 432C267 432 310 414 343 381C352 371 367 371 377 380Z"]
  };
  var faCube = {
    prefix: 'far',
    iconName: 'cube',
    icon: [512, 512, [], "f1b2", "M491 85L278 4C271 1 264 0 256 0S241 1 234 4L21 85C8 90 0 102 0 116V396C0 410 8 422 21 427L234 508C241 511 248 512 256 512S271 511 278 508L491 427C504 422 512 410 512 396V116C512 102 504 90 491 85ZM251 49C252 48 254 48 256 48S260 48 261 49L456 123L256 198L56 123L251 49ZM48 172L232 241V456L48 386V172ZM280 456V241L464 172V386L280 456Z"]
  };
  var faCubes = {
    prefix: 'far',
    iconName: 'cubes',
    icon: [576, 512, [], "f1b3", "M555 257L448 216V79C448 65 440 53 427 49L310 4C303 1 296 0 288 0S273 1 266 4L149 49C136 53 128 65 128 79V216L21 257C8 261 0 273 0 287V433C0 447 8 459 21 463L138 508C145 511 152 512 160 512S175 511 182 508L288 468L394 508C401 511 408 512 416 512S431 511 438 508L555 463C568 459 576 447 576 433V287C576 273 568 261 555 257ZM136 456L48 422V338L136 367V456ZM160 325L63 292L154 257L251 294L160 325ZM264 426L184 456V367L264 340V426ZM264 243L182 212C180 211 178 211 176 210V130L264 159V243ZM191 84L283 49C284 48 286 48 288 48S292 48 293 49L385 84L288 117L191 84ZM400 130V210C398 211 396 211 394 212L312 243V159L400 130ZM392 456L312 426V340L392 367V456ZM416 325L325 294L422 257L513 292L416 325ZM528 422L440 456V367L528 338V422Z"]
  };
  var faCupTogo = {
    prefix: 'far',
    iconName: 'cup-togo',
    icon: [448, 512, [], "f6c5", "M424 80H414C414 79 414 78 413 77L381 13C377 5 369 0 360 0H88C79 0 71 5 67 13L35 77C34 78 34 79 34 80H24C11 80 0 91 0 104C0 117 11 128 24 128H424C437 128 448 117 448 104C448 91 437 80 424 80ZM87 80L103 48H345L361 80H87ZM388 160C375 158 362 167 360 180L353 224H95L88 180C86 167 73 158 60 160C47 162 38 175 40 188L88 492C90 503 100 512 112 512H336C348 512 358 503 360 492L408 188C410 175 401 162 388 160ZM315 464H133L120 384H328L315 464Z"]
  };
  var faCurlingStone = {
    prefix: 'far',
    iconName: 'curling-stone',
    icon: [576, 512, [], "f44a", "M480 224C480 189 451 160 416 160H224V120C224 98 242 80 264 80H392C405 80 416 69 416 56S405 32 392 32H264C215 32 176 71 176 120V160H160C125 160 96 189 96 224C43 224 0 267 0 320V384C0 437 43 480 96 480H480C533 480 576 437 576 384V320C576 267 533 224 480 224ZM96 272H480C506 272 528 294 528 320V328H48V320C48 294 70 272 96 272ZM480 432H96C70 432 48 410 48 384V376H528V384C528 410 506 432 480 432Z"]
  };
  var faD = {
    prefix: 'far',
    iconName: 'd',
    icon: [384, 512, [], "e111", "M156 480H32C14 480 0 466 0 448V64C0 46 14 32 32 32H156C282 32 384 133 384 256S282 480 156 480ZM64 416H156C247 416 320 344 320 256S247 96 156 96H64V416Z"]
  };
  var faDagger = {
    prefix: 'far',
    iconName: 'dagger',
    icon: [384, 512, [], "f6cb", "M342 128L216 128V24C216 11 205 0 192 0H192C179 0 168 11 168 24V128L42 128C21 128 2 143 0 164C-2 188 17 208 40 208C59 208 75 194 78 176H112V408L175 503C179 509 186 512 192 512S205 509 209 503L272 408V176H306C309 194 325 208 344 208C367 208 386 188 384 164C382 143 363 128 342 128ZM224 394L192 442L160 394V176H224V394Z"]
  };
  var faDatabase = {
    prefix: 'far',
    iconName: 'database',
    icon: [448, 512, [], "f1c0", "M224 0C100 0 0 36 0 80V432C0 476 100 512 224 512S448 476 448 432V80C448 36 348 0 224 0ZM224 464C125 464 63 440 48 426V353C89 372 153 384 224 384S359 372 400 353V426C385 440 323 464 224 464ZM400 298C385 312 323 336 224 336S63 312 48 298V225C89 244 153 256 224 256S359 244 400 225V298ZM400 170C385 184 323 208 224 208S63 184 48 170V86C63 72 125 48 224 48S385 72 400 86V170Z"]
  };
  var faDeer = {
    prefix: 'far',
    iconName: 'deer',
    icon: [512, 512, [], "f78e", "M384 160C375 160 368 167 368 176C368 185 375 192 384 192S400 185 400 176C400 167 393 160 384 160ZM465 108L397 89C400 86 403 83 405 79L423 52C428 45 426 35 419 30L406 21C398 16 389 18 384 25L366 52C362 58 356 63 350 66L301 90L292 88C300 78 304 65 304 53V16C304 7 297 0 288 0H272C263 0 256 7 256 16V53C256 55 256 56 254 58L241 75L230 71C227 70 224 67 224 64V16C224 7 217 0 208 0H192C183 0 176 7 176 16V64C176 89 193 111 217 118L281 136L266 160H88C39 160 0 199 0 248V312H48V319L38 347C31 364 30 382 35 400L60 482C64 499 80 512 98 512H162C174 512 186 506 194 497C201 487 204 474 201 461L177 381L187 352H240V472C240 494 258 512 280 512H344C366 512 384 494 384 472V295L405 264H448C483 264 512 235 512 200V170C512 142 493 116 465 108ZM464 200C464 209 457 216 448 216H379L336 281V464H288V304H154L126 379L151 464H104L81 387C79 380 80 371 82 364L96 332L96 264H48V248C48 226 66 208 88 208H294L328 149C336 134 353 127 369 131L452 155C459 157 464 163 464 170V200Z"]
  };
  var faDeerRudolph = {
    prefix: 'far',
    iconName: 'deer-rudolph',
    icon: [576, 512, [], "f78f", "M400 160C391 160 384 167 384 176C384 185 391 192 400 192S416 185 416 176C416 167 409 160 400 160ZM536 96C521 96 507 105 501 118C495 114 488 111 481 109L413 89C416 86 419 83 421 79L439 52C444 45 442 35 435 30L422 21C414 16 405 18 400 25L382 52C378 58 372 63 366 66L317 90L316 91L307 89L308 88C316 78 320 65 320 53V16C320 7 313 0 304 0H288C279 0 272 7 272 16V53C272 55 271 56 270 58L257 75L246 71C243 70 240 67 240 64V16C240 7 233 0 224 0H208C199 0 192 7 192 16V64C192 89 209 111 233 118L297 136L282 160H88C39 160 0 199 0 248V312H48V319L38 347C31 364 30 382 35 400L60 482C64 499 80 512 98 512H162C174 512 186 506 194 497C201 487 204 474 201 461L177 381L187 352H256V472C256 494 274 512 296 512H360C382 512 400 494 400 472V302L422 264H464C499 264 528 235 528 200V174C531 175 533 176 536 176C558 176 576 158 576 136S558 96 536 96ZM480 200C480 209 473 216 464 216H394L352 290V464H304V304H154L126 379L151 464H104L81 387C79 380 80 371 82 364L96 332L96 264H48V248C48 226 66 208 88 208H310L344 149C352 134 369 127 385 131L468 155C475 157 480 163 480 170V200Z"]
  };
  var faDeleteLeft = {
    prefix: 'far',
    iconName: 'delete-left',
    icon: [576, 512, [], "f55a", "M503 64H196C179 64 163 71 151 83L0 233C-13 246 -13 266 0 279L151 429C163 441 179 448 196 448H503C538 448 567 419 567 384V128C567 93 538 64 503 64ZM519 384C519 393 511 400 503 400H196C192 400 188 398 185 395L45 256L185 117C188 114 192 112 196 112H503C511 112 519 119 519 128V384ZM424 175C414 166 399 166 390 175L343 222L296 175C286 166 271 166 262 175S252 200 262 209L309 256L262 303C252 312 252 328 262 337C266 342 272 344 279 344S291 342 296 337L343 290L390 337C394 342 400 344 407 344S419 342 424 337C433 328 433 312 424 303L377 256L424 209C433 200 433 184 424 175Z"]
  };
  var faDeleteRight = {
    prefix: 'far',
    iconName: 'delete-right',
    icon: [576, 512, [], "e112", "M0 128V384C0 419 29 448 64 448H371C388 448 404 441 416 429L567 279C579 266 579 246 567 233L416 83C404 71 388 64 371 64H64C29 64 0 93 0 128ZM48 128C48 119 55 112 64 112H371C375 112 379 114 382 117L521 256L382 395C379 398 375 400 371 400H64C55 400 48 393 48 384V128ZM143 209L190 256L143 303C134 312 134 328 143 337C148 342 154 344 160 344S172 342 177 337L224 290L271 337C276 342 282 344 288 344S300 342 305 337C314 328 314 312 305 303L258 256L305 209C314 200 314 184 305 175S280 166 271 175L224 222L177 175C168 166 152 166 143 175S134 200 143 209Z"]
  };
  var faDemocrat = {
    prefix: 'far',
    iconName: 'democrat',
    icon: [640, 512, [], "f747", "M639 221L619 192C594 154 552 130 507 128H288L215 67C226 48 226 24 214 5C210 0 203 -1 199 3L158 44L116 2C112 -1 106 -1 103 4C92 21 93 43 106 60L13 168C-1 185 -4 210 6 230L20 257C29 276 48 288 70 288H101C116 288 130 282 139 273L149 264L176 332V472C176 494 194 512 216 512H288C310 512 328 494 328 472V432H424V472C424 494 442 512 464 512H536C558 512 576 494 576 472V215C577 216 578 217 579 218L599 248C600 250 602 251 604 251C606 252 608 251 610 250L636 232C640 230 641 225 639 221ZM528 464H472V400C472 391 465 384 456 384H296C287 384 280 391 280 400V464H224V352H528V464ZM528 304H215L178 205C174 195 161 191 152 199L106 238C105 239 103 240 101 240H70C66 240 64 238 62 236L49 208C47 205 48 202 50 200L138 96H175L271 176H488C510 176 528 194 528 216V304ZM284 227L275 210C274 207 270 207 268 210L260 227L242 230C238 230 237 234 240 236L253 249L250 267C249 271 253 273 255 272L272 263L288 272C291 273 294 271 294 267L291 249L304 236C306 234 305 230 302 230L284 227ZM379 227L371 210C370 207 366 207 364 210L356 227L338 230C334 230 333 234 335 236L349 249L345 267C345 271 348 273 351 272L368 263L384 272C387 273 390 271 390 267L387 249L400 236C402 234 401 230 398 230L379 227ZM476 227L467 210C466 207 462 207 460 210L452 227L434 230C430 230 429 234 432 236L445 249L442 267C441 271 445 273 447 272L464 263L480 272C483 273 486 271 486 267L483 249L496 236C498 234 497 230 494 230L476 227Z"]
  };
  var faDesktop = {
    prefix: 'far',
    iconName: 'desktop',
    icon: [576, 512, [], "f108", "M512 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H212L203 464H152C139 464 128 475 128 488S139 512 152 512H424C437 512 448 501 448 488S437 464 424 464H373L364 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM324 464H252L261 416H315L324 464ZM528 352C528 361 521 368 512 368H64C55 368 48 361 48 352V304H528V352ZM528 256H48V64C48 55 55 48 64 48H512C521 48 528 55 528 64V256Z"]
  };
  var faDharmachakra = {
    prefix: 'far',
    iconName: 'dharmachakra',
    icon: [512, 512, [], "f655", "M499 232L479 233C474 188 457 148 430 115L445 101C450 96 450 88 445 83L429 67C424 62 416 62 411 67L397 82C364 55 324 38 279 33L280 13C280 6 275 0 268 0H244C237 0 232 6 232 13L233 33C188 38 148 55 115 82L101 67C96 62 88 62 83 67L67 83C62 88 62 96 67 101L82 115C55 148 38 188 33 233L13 232C6 232 0 237 0 244V268C0 275 6 280 13 280L33 279C38 324 55 364 82 397L67 411C62 416 62 424 67 429L83 445C88 450 96 450 101 445L115 430C148 457 188 474 233 479L232 499C232 506 237 512 244 512H268C275 512 280 506 280 499L279 479C324 474 364 457 397 430L411 445C416 450 424 450 429 445L445 429C450 424 450 416 445 411L430 397C457 364 474 324 479 279L499 280C506 280 512 275 512 268V244C512 237 506 232 499 232ZM430 234L350 237C347 224 343 213 336 203L395 148C414 173 426 202 430 234ZM256 304C230 304 208 282 208 256S230 208 256 208S304 230 304 256S282 304 256 304ZM364 117L309 176C299 169 287 165 275 162L278 81C310 86 339 98 364 117ZM234 82L237 162C224 165 213 169 203 176L148 117C173 98 202 86 234 82ZM117 148L176 203C169 213 165 225 162 237L82 234C86 202 98 173 117 148ZM82 278L162 275C165 288 169 299 176 309L117 364C98 339 86 310 82 278ZM148 395L203 336C213 343 225 347 237 350L234 431C202 426 173 414 148 395ZM278 430L275 350C288 347 299 343 309 336L364 395C339 414 310 426 278 430ZM395 364L336 309C343 299 347 287 350 275L431 278C426 310 414 339 395 364Z"]
  };
  var faDiagramStankey = {
    prefix: 'far',
    iconName: 'diagram-stankey',
    icon: [640, 512, [], "e113", "M608 296C608 283 597 272 584 272H56C43 272 32 283 32 296S43 320 56 320H178L267 468C272 476 280 480 288 480H584C597 480 608 469 608 456S597 432 584 432H302L234 320H584C597 320 608 309 608 296ZM56 240H248C256 240 264 236 269 228L358 80H584C597 80 608 69 608 56S597 32 584 32H344C336 32 328 36 323 44L234 192H56C43 192 32 203 32 216S43 240 56 240Z"]
  };
  var faDiagramVenn = {
    prefix: 'far',
    iconName: 'diagram-venn',
    icon: [640, 512, [], "e114", "M416 32C382 32 349 40 320 54C291 40 258 32 224 32C100 32 0 132 0 256S100 480 224 480C258 480 291 472 320 458C349 472 382 480 416 480C540 480 640 380 640 256S540 32 416 32ZM320 109C340 122 358 140 371 160H269C282 140 300 122 320 109ZM224 432C127 432 48 353 48 256S127 80 224 80C240 80 255 82 270 86C222 127 192 188 192 256S222 385 270 426C255 430 240 432 224 432ZM320 403C300 390 282 372 269 352H371C358 372 340 390 320 403ZM388 320H252C246 305 243 289 241 272H399C397 289 394 305 388 320ZM241 240C243 223 247 207 253 192H387C393 207 397 223 399 240H241Z"]
  };
  var faDial = {
    prefix: 'far',
    iconName: 'dial',
    icon: [576, 512, [], "e115", "M32 256C14 256 0 270 0 288C0 306 14 320 32 320S64 306 64 288C64 270 50 256 32 256ZM84 446C72 459 72 479 84 492C97 504 117 504 130 492C142 479 142 459 130 446C117 434 97 434 84 446ZM130 130C142 117 142 97 130 84C117 72 97 72 84 84C72 97 72 117 84 130C97 142 117 142 130 130ZM288 64C306 64 320 50 320 32C320 14 306 0 288 0C270 0 256 14 256 32C256 50 270 64 288 64ZM446 446C434 459 434 479 446 492C459 504 479 504 492 492C504 479 504 459 492 446S459 434 446 446ZM544 256C526 256 512 270 512 288C512 306 526 320 544 320S576 306 576 288C576 270 562 256 544 256ZM446 84C434 97 434 117 446 130C459 142 479 142 492 130C504 117 504 97 492 84C479 72 459 72 446 84ZM175 401C237 464 339 464 401 401S464 237 401 175C339 112 237 112 175 175S112 339 175 401ZM209 209C247 171 305 166 348 194L271 271C262 280 262 296 271 305S296 314 305 305L382 228C410 271 405 329 367 367C324 411 252 411 209 367C165 324 165 252 209 209Z"]
  };
  var faDialHigh = {
    prefix: 'far',
    iconName: 'dial-high',
    icon: [576, 512, [], "e116", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84ZM128 288A160 160 0 1 0 288 128A160 160 0 0 0 128 288ZM288 176A112 112 0 0 1 397 264H288A24 24 0 0 0 288 312H397A112 112 0 1 1 288 176Z"]
  };
  var faDialLow = {
    prefix: 'far',
    iconName: 'dial-low',
    icon: [576, 512, [], "e117", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84ZM448 288A160 160 0 1 0 288 448A160 160 0 0 0 448 288ZM288 400A112 112 0 0 1 179 312H288A24 24 0 0 0 288 264H179A112 112 0 1 1 288 400Z"]
  };
  var faDialMax = {
    prefix: 'far',
    iconName: 'dial-max',
    icon: [576, 512, [], "e118", "M130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM401 175A160 160 0 1 0 401 401A160 160 0 0 0 401 175ZM382 348L305 271A24 24 0 0 0 271 305L348 382A112 112 0 1 1 382 348ZM446 446A32 32 0 1 0 491 446A32 32 0 0 0 446 446Z"]
  };
  var faDialMed = {
    prefix: 'far',
    iconName: 'dial-med',
    icon: [576, 512, [], "e119", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM288 128A160 160 0 1 0 448 288A160 160 0 0 0 288 128ZM288 400A112 112 0 0 1 264 179V288A24 24 0 0 0 312 288V179A112 112 0 0 1 288 400ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446Z"]
  };
  var faDialMedLow = {
    prefix: 'far',
    iconName: 'dial-med-low',
    icon: [576, 512, [], "e11a", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84ZM401 401A160 160 0 1 0 175 401A160 160 0 0 0 401 401ZM209 367A112 112 0 0 1 194 228L271 305A24 24 0 0 0 305 271L228 194A112 112 0 1 1 209 367Z"]
  };
  var faDialMin = {
    prefix: 'far',
    iconName: 'dial-min',
    icon: [576, 512, [], "e11b", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84ZM401 175A160 160 0 1 0 401 401A160 160 0 0 0 401 175ZM367 367A112 112 0 0 1 228 382L305 305A24 24 0 0 0 271 271L194 348A112 112 0 1 1 367 367Z"]
  };
  var faDiamond = {
    prefix: 'far',
    iconName: 'diamond',
    icon: [512, 512, [], "f219", "M496 222L288 14C279 5 267 0 254 0C242 0 230 5 221 14L12 222C-6 241 -6 271 12 290L221 498C230 507 242 512 254 512C267 512 279 507 288 498L496 290C515 271 515 241 496 222ZM255 464L46 256L254 48L462 256L255 464Z"]
  };
  var faDiamondTurnRight = {
    prefix: 'far',
    iconName: 'diamond-turn-right',
    icon: [512, 512, [], "f5eb", "M496 222L288 14C279 5 267 0 254 0C242 0 230 5 221 14L12 222C-6 241 -6 271 12 290L221 498C230 507 242 512 254 512C267 512 279 507 288 498L496 290C515 271 515 241 496 222ZM255 464L46 256L254 48L462 256L255 464ZM301 216H198C185 216 174 227 174 240V312C174 325 185 336 198 336S222 325 222 312V264H301L277 287C268 296 268 312 277 321C282 326 288 328 294 328S307 326 311 321L375 257C385 248 385 232 375 223L311 159C302 150 287 150 277 159S268 184 277 193L301 216Z"]
  };
  var faDice = {
    prefix: 'far',
    iconName: 'dice',
    icon: [640, 512, [], "f522", "M571 192H469C472 202 474 213 474 224C474 249 464 274 446 292L315 423V448C315 483 344 512 379 512H571C606 512 635 483 635 448V256C635 221 606 192 571 192ZM475 376C462 376 451 365 451 352C451 339 462 328 475 328S499 339 499 352C499 365 488 376 475 376ZM424 178L264 19C251 6 235 0 219 0S186 6 173 19L14 178C-11 203 -11 244 14 269L173 429C186 441 202 448 219 448S251 441 264 429L424 269C449 244 449 203 424 178ZM390 235L230 395C226 399 221 400 219 400C216 400 211 399 207 395L48 235C43 231 43 226 43 224S43 217 48 212L207 53C211 49 216 48 219 48S226 49 230 53L390 212C394 217 394 221 394 224S394 231 390 235ZM219 302C213 302 206 304 202 309C192 318 192 333 202 343C206 347 213 350 219 350C225 350 231 347 236 343C245 333 245 318 236 309C231 304 225 302 219 302ZM219 200C213 200 206 202 202 207C192 216 192 231 202 241C206 245 213 248 219 248C225 248 231 245 236 241C245 231 245 216 236 207C231 202 225 200 219 200ZM117 200C111 200 105 202 100 207C90 216 90 231 100 241C105 245 111 248 117 248S129 245 134 241C143 231 143 216 134 207C129 202 123 200 117 200ZM320 200C314 200 308 202 304 207C294 216 294 231 304 241C308 245 314 248 320 248S333 245 337 241C347 231 347 216 337 207C333 202 327 200 320 200ZM219 98C213 98 206 100 202 105C192 114 192 130 202 139C206 144 213 146 219 146C225 146 231 144 236 139C245 130 245 114 236 105C231 100 225 98 219 98Z"]
  };
  var faDiceD10 = {
    prefix: 'far',
    iconName: 'dice-d10',
    icon: [512, 512, [], "f6cd", "M504 261L280 11C274 3 265 0 256 0S239 3 232 11L8 261C-4 274 -2 295 11 306L235 504C241 509 249 512 256 512C264 512 271 509 277 504L501 306C514 295 516 274 504 261ZM256 288L190 244L256 90L322 244L256 288ZM143 232L86 246L183 137L143 232ZM156 278L232 330V438L75 299L156 278ZM280 330L357 278L437 299L280 438V330ZM369 232L329 137L426 246L369 232Z"]
  };
  var faDiceD12 = {
    prefix: 'far',
    iconName: 'dice-d12',
    icon: [512, 512, [], "f6ce", "M509 185L453 74C450 67 445 62 439 59L327 3C322 1 317 0 313 0H199C195 0 190 1 185 3L74 59C67 62 62 67 59 74L3 185C1 190 0 195 0 199V312C0 317 1 322 3 327L59 438C62 445 67 450 73 453L185 509C190 511 195 512 199 512H312C317 512 322 511 327 509L438 453C445 450 450 445 453 439L509 327C511 322 512 317 512 313V199C512 195 511 190 509 185ZM455 185L377 290L280 241V148L421 119L420 115L455 185ZM301 464H211L158 332L256 283L354 332L301 464ZM203 48H309L373 80L256 103L139 80L203 48ZM92 115L91 119L232 148V241L135 290L57 185L92 115ZM48 309V253L107 332L149 437L100 412L48 309ZM412 412L363 437L405 332L464 253V309L412 412Z"]
  };
  var faDiceD20 = {
    prefix: 'far',
    iconName: 'dice-d20',
    icon: [512, 512, [], "f6cf", "M464 116L272 4C262 -1 250 -1 240 4L48 116C38 122 32 133 32 144V368C32 379 38 390 48 396L240 508C250 513 262 513 272 508L464 396C474 390 480 379 480 368V144C480 133 474 122 464 116ZM256 88L329 184H183L256 88ZM256 339L188 232H324L256 339ZM145 254L208 354L125 335L145 254ZM367 254L387 335L304 354L367 254ZM383 177L313 84L419 146L383 177ZM129 177L93 146L199 84L129 177ZM104 220L80 317V198L104 220ZM232 409V447L122 383L232 409ZM280 409L390 383L280 447V409ZM432 317L408 220L432 198V317Z"]
  };
  var faDiceD4 = {
    prefix: 'far',
    iconName: 'dice-d4',
    icon: [512, 512, [], "f6d0", "M505 289L281 12C274 4 265 0 256 0C247 0 237 4 231 12L7 289C-4 303 -2 324 13 334L237 506C242 510 249 512 256 512C263 512 270 510 275 506L499 334C514 324 516 303 505 289ZM232 87V442L55 306L232 87ZM280 442V87L457 306L280 442Z"]
  };
  var faDiceD6 = {
    prefix: 'far',
    iconName: 'dice-d6',
    icon: [448, 512, [], "f6d1", "M432 116L240 4C230 -1 218 -1 208 4L16 116C6 122 0 133 0 144V368C0 379 6 390 16 396L208 508C218 513 230 513 240 508L432 396C442 390 448 379 448 368V144C448 133 442 122 432 116ZM224 51L376 139L224 228L72 139L224 51ZM48 181L200 270V447L48 359V181ZM248 447V270L400 181V359L248 447Z"]
  };
  var faDiceD8 = {
    prefix: 'far',
    iconName: 'dice-d8',
    icon: [512, 512, [], "f6d2", "M502 232L280 10C273 3 265 0 256 0S239 3 232 10L10 232C-3 245 -3 267 10 280L232 502C239 509 247 512 256 512S273 509 280 502L502 280C515 267 515 245 502 232ZM280 78L446 244L280 316V78ZM232 316L66 244L232 78V316ZM232 368V434L116 318L232 368ZM280 368L396 318L280 434V368Z"]
  };
  var faDiceFive = {
    prefix: 'far',
    iconName: 'dice-five',
    icon: [448, 512, [], "f523", "M128 128C110 128 96 142 96 160S110 192 128 192S160 178 160 160S146 128 128 128ZM128 320C110 320 96 334 96 352S110 384 128 384S160 370 160 352S146 320 128 320ZM320 320C302 320 288 334 288 352S302 384 320 384S352 370 352 352S338 320 320 320ZM320 128C302 128 288 142 288 160S302 192 320 192S352 178 352 160S338 128 320 128ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416ZM224 224C206 224 192 238 192 256S206 288 224 288S256 274 256 256S242 224 224 224Z"]
  };
  var faDiceFour = {
    prefix: 'far',
    iconName: 'dice-four',
    icon: [448, 512, [], "f524", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416ZM128 128C110 128 96 142 96 160S110 192 128 192S160 178 160 160S146 128 128 128ZM320 320C302 320 288 334 288 352S302 384 320 384S352 370 352 352S338 320 320 320ZM320 128C302 128 288 142 288 160S302 192 320 192S352 178 352 160S338 128 320 128ZM128 320C110 320 96 334 96 352S110 384 128 384S160 370 160 352S146 320 128 320Z"]
  };
  var faDiceOne = {
    prefix: 'far',
    iconName: 'dice-one',
    icon: [448, 512, [], "f525", "M224 224C206 224 192 238 192 256S206 288 224 288S256 274 256 256S242 224 224 224ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416Z"]
  };
  var faDiceSix = {
    prefix: 'far',
    iconName: 'dice-six',
    icon: [448, 512, [], "f526", "M128 128C110 128 96 142 96 160S110 192 128 192S160 178 160 160S146 128 128 128ZM128 224C110 224 96 238 96 256S110 288 128 288S160 274 160 256S146 224 128 224ZM128 320C110 320 96 334 96 352S110 384 128 384S160 370 160 352S146 320 128 320ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416ZM320 128C302 128 288 142 288 160S302 192 320 192S352 178 352 160S338 128 320 128ZM320 320C302 320 288 334 288 352S302 384 320 384S352 370 352 352S338 320 320 320ZM320 224C302 224 288 238 288 256S302 288 320 288S352 274 352 256S338 224 320 224Z"]
  };
  var faDiceThree = {
    prefix: 'far',
    iconName: 'dice-three',
    icon: [448, 512, [], "f527", "M128 128C110 128 96 142 96 160S110 192 128 192S160 178 160 160S146 128 128 128ZM224 224C206 224 192 238 192 256S206 288 224 288S256 274 256 256S242 224 224 224ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416ZM320 320C302 320 288 334 288 352S302 384 320 384S352 370 352 352S338 320 320 320Z"]
  };
  var faDiceTwo = {
    prefix: 'far',
    iconName: 'dice-two',
    icon: [448, 512, [], "f528", "M128 128C110 128 96 142 96 160S110 192 128 192S160 178 160 160S146 128 128 128ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416ZM320 320C302 320 288 334 288 352S302 384 320 384S352 370 352 352S338 320 320 320Z"]
  };
  var faDiploma = {
    prefix: 'far',
    iconName: 'diploma',
    icon: [640, 512, [], "f5ea", "M539 144H473C478 134 480 123 480 112C480 68 444 32 400 32C368 32 346 47 320 79C294 47 272 32 240 32C196 32 160 68 160 112C160 123 162 134 167 144H96C43 144 0 192 0 272S43 416 96 416L256 382V464C256 467 257 470 258 472C259 472 259 473 259 474C261 475 262 476 264 478C264 478 265 478 265 478C267 479 270 480 272 480C272 480 273 480 273 480C273 480 273 480 274 480C276 479 279 479 282 477L320 448L358 477C361 479 364 479 366 480C367 480 367 480 367 480C367 480 368 480 368 480C370 480 373 479 375 478C375 478 376 478 376 477C378 476 379 475 381 474C381 473 381 472 382 472C383 470 384 467 384 464V382L539 416C595 416 640 352 640 272C640 192 595 144 539 144ZM400 80C418 80 432 95 432 112S418 144 400 144H333C373 83 385 80 400 80ZM240 80C255 80 267 83 307 144H240C222 144 208 129 208 112S222 80 240 80ZM246 335L93 368C73 364 48 327 48 272C48 225 68 192 96 192H241L240 192H256V333L246 335ZM543 368L394 335L384 333V192H400L399 192H539C571 192 592 224 592 272C592 324 567 364 543 368Z"]
  };
  var faDiscDrive = {
    prefix: 'far',
    iconName: 'disc-drive',
    icon: [512, 512, [], "f8b5", "M256 112C177 112 112 177 112 256S177 400 256 400S400 335 400 256S335 112 256 112ZM256 288C238 288 224 274 224 256S238 224 256 224C274 224 288 238 288 256S274 288 256 288ZM488 432H480V96C480 61 451 32 416 32H96C61 32 32 61 32 96V432H24C11 432 0 443 0 456V456C0 469 11 480 24 480H488C501 480 512 469 512 456V456C512 443 501 432 488 432ZM432 432H80V96C80 87 87 80 96 80H416C425 80 432 87 432 96V432Z"]
  };
  var faDisease = {
    prefix: 'far',
    iconName: 'disease',
    icon: [512, 512, [], "f7fa", "M460 180L399 159C389 156 382 149 380 141L365 87C358 62 338 42 310 35C279 27 247 35 225 57L184 99C177 106 165 110 154 109L88 104C55 102 23 118 8 145C-4 168 -2 195 14 217L49 264C53 270 54 277 51 283L25 334C13 357 16 384 32 405C51 430 85 441 118 434L181 421C193 418 205 421 214 427L263 463C278 474 296 480 315 480C328 480 340 477 352 472C378 460 394 438 396 413L400 357C401 350 406 343 415 339L471 310C498 296 514 271 512 243C510 214 490 190 460 180ZM449 267L393 296C369 308 354 329 352 354L348 409C347 420 337 426 332 428C322 433 305 435 291 425L242 388C228 377 209 372 190 372C184 372 178 372 171 374L108 387C91 391 77 384 70 375C65 369 64 362 68 356L94 305C105 282 103 255 87 235L52 188C47 181 47 174 51 168C55 160 67 151 85 152L150 157C175 159 201 150 218 133L260 90C268 81 283 78 297 82C309 84 317 91 319 100L333 154C340 177 358 196 384 205L444 225C456 229 463 237 464 246C465 255 459 262 449 267ZM160 192C142 192 128 206 128 224S142 256 160 256S192 242 192 224S178 192 160 192ZM288 288C270 288 256 302 256 320S270 352 288 352S320 338 320 320S306 288 288 288ZM304 192C295 192 288 199 288 208S295 224 304 224S320 217 320 208S313 192 304 192Z"]
  };
  var faDisplay = {
    prefix: 'far',
    iconName: 'display',
    icon: [576, 512, [], "e11c", "M512 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H212L203 464H152C139 464 128 475 128 488S139 512 152 512H424C437 512 448 501 448 488S437 464 424 464H373L364 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM324 464H252L261 416H315L324 464ZM528 352C528 361 521 368 512 368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H512C521 48 528 55 528 64V352Z"]
  };
  var faDisplayCode = {
    prefix: 'far',
    iconName: 'display-code',
    icon: [576, 512, [], "e11d", "M210 138C202 130 190 130 182 138L134 186C126 194 126 206 134 214L182 262C186 266 191 268 196 268S206 266 210 262C218 254 218 242 210 234L176 200L210 166C218 158 218 146 210 138ZM323 113C313 109 301 115 297 125L241 277C237 287 243 299 253 303C255 304 258 304 260 304C268 304 276 299 279 291L335 139C339 129 333 117 323 113ZM394 138C386 130 374 130 366 138S358 158 366 166L400 200L366 234C358 242 358 254 366 262C370 266 375 268 380 268S390 266 394 262L442 214C450 206 450 194 442 186L394 138ZM512 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H212L203 464H152C139 464 128 475 128 488S139 512 152 512H424C437 512 448 501 448 488S437 464 424 464H373L364 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM252 464L261 416H315L324 464H252ZM528 352C528 361 521 368 512 368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H512C521 48 528 55 528 64V352Z"]
  };
  var faDisplayMedical = {
    prefix: 'far',
    iconName: 'display-medical',
    icon: [576, 512, [], "e11e", "M368 176H320V128C320 119 313 112 304 112H272C263 112 256 119 256 128V176H208C199 176 192 183 192 192V224C192 233 199 240 208 240H256V288C256 297 263 304 272 304H304C313 304 320 297 320 288V240H368C377 240 384 233 384 224V192C384 183 377 176 368 176ZM512 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H212L203 464H152C139 464 128 475 128 488S139 512 152 512H424C437 512 448 501 448 488S437 464 424 464H373L364 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM252 464L261 416H315L324 464H252ZM528 352C528 361 521 368 512 368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H512C521 48 528 55 528 64V352Z"]
  };
  var faDisplaySlash = {
    prefix: 'far',
    iconName: 'display-slash',
    icon: [640, 512, [], "e11f", "M631 469L560 414C588 407 608 382 608 352V64C608 29 579 0 544 0H96C80 0 65 6 53 17L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM560 352C560 361 553 368 544 368H502L94 48C95 48 95 48 96 48H544C553 48 560 55 560 64V352ZM456 464H405L396 416H408L347 368H96C87 368 80 361 80 352V159L32 121V352C32 387 61 416 96 416H244L235 464H184C171 464 160 475 160 488S171 512 184 512H456C469 512 480 501 480 488S469 464 456 464ZM284 464L293 416H347L356 464H284Z"]
  };
  var faDivide = {
    prefix: 'far',
    iconName: 'divide',
    icon: [448, 512, [], "f529", "M408 232H40C27 232 16 243 16 256S27 280 40 280H408C421 280 432 269 432 256S421 232 408 232ZM224 192C259 192 288 163 288 128S259 64 224 64S160 93 160 128S189 192 224 192ZM224 112C233 112 240 119 240 128S233 144 224 144S208 137 208 128S215 112 224 112ZM224 320C189 320 160 349 160 384S189 448 224 448S288 419 288 384S259 320 224 320ZM224 400C215 400 208 393 208 384S215 368 224 368S240 375 240 384S233 400 224 400Z"]
  };
  var faDna = {
    prefix: 'far',
    iconName: 'dna',
    icon: [448, 512, [], "f471", "M32 495C32 503 37 512 47 512H63C71 512 78 506 78 498C78 493 79 487 80 480H367C368 487 369 493 370 498C370 506 377 512 385 512H401C412 512 416 501 416 495C414 466 400 368 307 286C295 296 281 305 266 313C276 321 283 328 291 336H156C176 315 202 295 235 277C392 191 413 56 416 17C416 9 411 0 401 0H385C377 0 370 6 370 14C370 19 369 25 368 32H81C79 25 79 19 78 14C78 6 71 0 63 0H47C37 0 32 9 32 17C35 53 53 170 180 256C53 341 35 459 32 495ZM354 80C349 95 341 111 330 128H118C108 111 100 95 94 80H354ZM224 229C197 213 175 194 157 176H292C274 194 252 212 224 229ZM93 432C99 417 107 401 118 384H329C340 401 348 417 354 432H93Z"]
  };
  var faDoNotEnter = {
    prefix: 'far',
    iconName: 'do-not-enter',
    icon: [512, 512, [], "f5ec", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM376 208H136C123 208 112 219 112 232V280C112 293 123 304 136 304H376C389 304 400 293 400 280V232C400 219 389 208 376 208Z"]
  };
  var faDog = {
    prefix: 'far',
    iconName: 'dog',
    icon: [576, 512, [], "f6d3", "M416 96C407 96 400 103 400 112S407 128 416 128S432 121 432 112S425 96 416 96ZM536 64H487L486 63C476 46 450 32 430 32H360C359 32 359 32 358 32L359 32L331 5C321 -5 304 2 304 16V192H184C153 192 124 204 103 224H91C69 224 47 207 48 185C48 171 37 160 24 160C11 160 0 171 0 184C0 226 30 263 72 270C67 284 64 298 64 312V448C64 483 93 512 128 512H144C179 512 208 483 208 448V384H336V448C336 483 365 512 400 512H416C451 512 480 483 480 448V240H488C537 240 576 201 576 152V104C576 82 558 64 536 64ZM432 448C432 457 425 464 416 464H400C391 464 384 457 384 448V336H160V448C160 457 153 464 144 464H128C119 464 112 457 112 448V312C112 272 144 240 184 240H320L432 269V448ZM528 152C528 174 510 192 488 192H432V219L352 199V88C352 84 356 80 360 80H436C439 80 442 82 443 84L457 112H528V152Z"]
  };
  var faDogLeashed = {
    prefix: 'far',
    iconName: 'dog-leashed',
    icon: [576, 512, [], "f6d4", "M536 64H487L486 63C476 46 450 32 430 32H360C359 32 359 32 358 32L359 32L331 5C321 -5 304 2 304 16V178L70 5C60 -3 45 -1 37 10C29 20 31 35 42 43L242 192H184C153 192 124 204 103 224H91C69 224 47 207 48 185C48 171 37 160 24 160C11 160 0 171 0 184C0 226 30 263 72 270C67 284 64 298 64 312V448C64 483 93 512 128 512H144C179 512 208 483 208 448V384H336V448C336 483 365 512 400 512H416C451 512 480 483 480 448V240H488C537 240 576 201 576 152V104C576 82 558 64 536 64ZM280 336H160V448C160 457 153 464 144 464H128C119 464 112 457 112 448V312C112 272 144 240 184 240H280V336ZM432 448C432 457 425 464 416 464H400C391 464 384 457 384 448V336H328V243L432 269V448ZM528 152C528 174 510 192 488 192H432V219L352 199V88C352 84 356 80 360 80H436C439 80 442 82 443 84L457 112H528V152ZM416 96C407 96 400 103 400 112S407 128 416 128S432 121 432 112S425 96 416 96Z"]
  };
  var faDollarSign = {
    prefix: 'far',
    iconName: 'dollar-sign',
    icon: [320, 512, [], "f155", "M302 358C293 406 248 435 184 439V488C184 501 173 512 160 512S136 501 136 488V438C133 437 130 438 126 437C99 433 70 424 45 416L33 412C20 408 13 395 17 382C21 369 34 362 47 366L59 370C83 378 110 386 133 390C188 397 247 388 255 349C262 313 236 300 154 279L138 275C90 263 1 239 18 154C27 106 72 77 136 73V24C136 11 147 0 160 0S184 11 184 24V74C187 74 190 74 194 75C211 77 231 82 257 90C270 94 277 107 273 120C269 133 256 140 243 136C220 129 202 125 187 122C132 115 73 124 65 163C59 195 79 210 150 229L166 233C230 249 319 272 302 358Z"]
  };
  var faDolly = {
    prefix: 'far',
    iconName: 'dolly',
    icon: [576, 512, [], "f472", "M575 304C570 292 557 285 544 289L528 295L457 106C452 93 442 83 429 77C416 71 402 70 389 75L194 148L151 17C148 7 138 0 128 0H24C11 0 0 11 0 24S11 48 24 48H111L204 335C178 352 160 382 160 416C160 469 203 512 256 512S352 469 352 416C352 413 351 411 351 408L560 335C572 330 579 317 575 304ZM256 464C230 464 208 442 208 416S230 368 256 368S304 390 304 416S282 464 256 464ZM336 363C318 337 289 320 256 320C254 320 252 320 250 321L209 194L299 160L326 232C329 242 338 248 348 248C351 248 354 248 356 246C369 242 375 228 370 216L343 144L406 120C408 120 411 121 412 123L482 311L336 363Z"]
  };
  var faDollyEmpty = {
    prefix: 'far',
    iconName: 'dolly-empty',
    icon: [576, 512, [], "f473", "M575 304C570 292 557 285 544 289L336 363C318 337 289 320 256 320C254 320 252 320 250 321L151 17C148 7 138 0 128 0H24C11 0 0 11 0 24S11 48 24 48H111L204 335C178 352 160 382 160 416C160 469 203 512 256 512S352 469 352 416C352 413 351 411 351 408L560 335C572 330 579 317 575 304ZM256 464C230 464 208 442 208 416S230 368 256 368S304 390 304 416S282 464 256 464Z"]
  };
  var faDolphin = {
    prefix: 'far',
    iconName: 'dolphin',
    icon: [512, 512, [], "e120", "M434 139L429 135C439 115 453 92 472 66C483 51 483 32 471 17C463 6 450 0 436 0C433 0 431 0 428 1C387 7 347 19 310 37C278 15 249 1 206 0C121 2 49 61 34 140C30 163 31 187 37 210L25 219C4 232 -5 257 2 281C10 305 31 320 56 320H392C405 320 416 309 416 296C416 283 405 272 392 272H56C51 272 49 269 48 267C48 265 47 261 51 258C96 229 88 234 95 229C85 204 76 182 82 148C92 93 145 50 206 48C235 49 251 53 306 92C343 74 375 59 425 50C384 108 376 138 372 149C424 193 464 221 464 296C464 368 404 400 344 400H293L264 356C255 343 240 336 225 336H164C150 336 138 344 131 356C126 367 127 381 135 391L159 424L135 457C127 467 126 481 132 492C138 504 150 512 164 512H225C241 512 255 505 265 492L293 448H344C441 448 512 384 512 296C512 204 459 160 434 139ZM225 465L189 464L216 429L219 424L216 419L190 384H225C225 384 225 384 225 384C225 384 225 384 225 384L251 424L225 465ZM136 160C136 173 147 184 160 184S184 173 184 160S173 136 160 136S136 147 136 160Z"]
  };
  var faDongSign = {
    prefix: 'far',
    iconName: 'dong-sign',
    icon: [384, 512, [], "e121", "M192 400C222 400 250 389 272 371V376C272 389 283 400 296 400S320 389 320 376V112H328C341 112 352 101 352 88S341 64 328 64H320V56C320 43 309 32 296 32S272 43 272 56V64H216C203 64 192 75 192 88S203 112 216 112H272V173C250 155 222 144 192 144C121 144 64 201 64 272S121 400 192 400ZM192 192C236 192 272 228 272 272S236 352 192 352S112 316 112 272S148 192 192 192ZM360 432H24C11 432 0 443 0 456S11 480 24 480H360C373 480 384 469 384 456S373 432 360 432Z"]
  };
  var faDoorClosed = {
    prefix: 'far',
    iconName: 'door-closed',
    icon: [576, 512, [], "f52a", "M368 224C350 224 336 238 336 256S350 288 368 288S400 274 400 256S386 224 368 224ZM552 464H480V64C480 29 451 0 416 0H160C125 0 96 29 96 64V464H24C11 464 0 475 0 488C0 501 11 512 24 512H552C565 512 576 501 576 488C576 475 565 464 552 464ZM432 464H144V64C144 55 151 48 160 48H416C425 48 432 55 432 64V464Z"]
  };
  var faDoorOpen = {
    prefix: 'far',
    iconName: 'door-open',
    icon: [576, 512, [], "f52b", "M224 288C237 288 248 274 248 256S237 224 224 224S200 238 200 256S211 288 224 288ZM288 0C286 0 283 0 280 1L88 51C74 54 64 68 64 83V464H24C11 464 0 475 0 488C0 501 11 512 24 512H288C306 512 320 498 320 480V33C320 14 305 0 288 0ZM272 464H112V94L272 53V464ZM552 464H512V128C512 93 483 64 448 64H352V112H448C457 112 464 119 464 128V480C464 498 478 512 496 512H552C565 512 576 501 576 488C576 475 565 464 552 464Z"]
  };
  var faDove = {
    prefix: 'far',
    iconName: 'dove',
    icon: [512, 512, [], "f4ba", "M368 160C368 169 375 176 384 176S400 169 400 160C400 151 393 144 384 144C375 144 368 151 368 160ZM384 64C338 64 299 97 290 140C261 104 241 61 234 14C232 1 215 -5 206 6C181 35 162 71 151 111C149 116 149 122 148 128C122 104 101 75 87 42C81 29 64 29 58 41C42 75 33 113 32 153C31 249 87 316 128 353L14 391C2 394 -4 409 3 420C23 453 72 507 178 512C191 513 195 507 203 503L279 448H320C408 448 480 377 480 288V160L512 64H384ZM197 123C200 113 203 104 207 95C223 133 247 168 276 197C246 190 218 179 192 163C193 149 194 136 197 123ZM432 152V288C432 350 382 400 320 400H264L175 464C122 460 89 442 68 423L222 371C166 325 79 261 80 154C80 145 81 137 82 128C175 249 320 256 336 256V160C336 134 357 112 384 112H445L432 152Z"]
  };
  var faDown = {
    prefix: 'far',
    iconName: 'down',
    icon: [384, 512, [], "f354", "M382 260C377 248 365 240 352 240H272V80C272 54 251 32 224 32H160C134 32 112 54 112 80V240H32C19 240 7 248 2 260C-3 272 0 285 9 295L169 471C176 477 184 480 192 480S208 477 215 471L375 295C384 285 387 272 382 260ZM192 425L71 288H160V80H224V288H313L192 425Z"]
  };
  var faDownFromLine = {
    prefix: 'far',
    iconName: 'down-from-line',
    icon: [384, 512, [], "f349", "M315 240H272V176C272 150 250 128 224 128H160C134 128 112 150 112 176V240H69C27 240 5 289 33 320L169 471C176 477 184 480 192 480S208 477 215 471L351 320C378 289 357 240 315 240ZM192 425L71 288H160V176H224V288H313L192 425ZM360 32H24C11 32 0 43 0 56S11 80 24 80H360C373 80 384 69 384 56S373 32 360 32Z"]
  };
  var faDownLeftAndUpRightToCenter = {
    prefix: 'far',
    iconName: 'down-left-and-up-right-to-center',
    icon: [512, 512, [], "f422", "M489 16C480 7 464 7 455 16L374 97L327 50C321 44 312 41 304 41C300 41 296 42 292 43C280 48 272 60 272 73V209C272 222 283 233 296 233H432C445 233 457 225 462 213C467 201 464 187 455 178L408 131L489 50C498 41 498 25 489 16ZM216 265H80C67 265 55 273 50 285C45 297 48 310 57 320L104 367L23 448C14 457 14 473 23 482S48 491 57 482L138 401L185 448C192 454 200 457 208 457C212 457 216 456 220 455C232 450 240 438 240 425V289C240 276 229 265 216 265Z"]
  };
  var faDownLong = {
    prefix: 'far',
    iconName: 'down-long',
    icon: [320, 512, [], "f309", "M34 366C38 358 46 352 56 352H136V24C136 11 147 0 160 0S184 11 184 24V352H264C274 352 282 358 286 366C290 375 288 385 282 392L178 504C168 515 152 515 142 504L38 392C32 385 30 375 34 366Z"]
  };
  var faDownToLine = {
    prefix: 'far',
    iconName: 'down-to-line',
    icon: [384, 512, [], "f34a", "M170 375C176 381 184 384 192 384S209 381 215 375L351 224C379 193 357 144 315 144H272V80C272 54 251 32 224 32H160C134 32 112 54 112 80V144H69C27 144 6 193 34 224L170 375ZM160 192V80H224V192H314L192 329L71 192H160ZM360 432H24C11 432 0 443 0 456S11 480 24 480H360C373 480 384 469 384 456S373 432 360 432Z"]
  };
  var faDownload = {
    prefix: 'far',
    iconName: 'download',
    icon: [512, 512, [], "f019", "M448 304H394L346 352H448C457 352 464 359 464 368V448C464 457 457 464 448 464H64C55 464 48 457 48 448V368C48 359 55 352 64 352H166L118 304H64C29 304 0 333 0 368V448C0 483 29 512 64 512H448C483 512 512 483 512 448V368C512 333 483 304 448 304ZM432 408C432 395 421 384 408 384S384 395 384 408C384 421 395 432 408 432S432 421 432 408ZM239 369C244 374 250 376 256 376S268 374 273 369L409 233C418 224 418 208 409 199S384 190 375 199L280 294V24C280 11 269 0 256 0S232 11 232 24V294L137 199C128 190 112 190 103 199S94 224 103 233L239 369Z"]
  };
  var faDragon = {
    prefix: 'far',
    iconName: 'dragon',
    icon: [640, 512, [], "f6d5", "M569 266L491 220C484 216 480 210 480 202V192H491L508 208C519 218 532 224 546 224H574C594 224 613 212 622 194L634 167C643 149 641 127 629 111L562 21C552 8 536 0 519 0H304C292 0 280 8 275 19C271 31 273 44 284 55L309 75L290 83C280 88 273 99 273 111C273 123 280 133 292 140L336 157V205L200 107C177 91 145 93 123 111L6 228C-7 238 2 258 18 256L192 224L101 293C91 303 98 320 112 320H352C361 342 373 362 388 380C220 391 81 422 32 433C13 437 0 453 0 472C0 494 18 512 40 512H504C577 512 636 458 640 389C643 337 615 289 569 266ZM504 464H116C195 449 315 430 448 425L522 422L460 381C413 349 384 296 384 238V123L349 110L401 89L351 48H519C521 48 523 49 523 50L591 140C592 142 592 144 591 146L578 173C578 175 576 176 574 176H546C545 176 543 175 542 174L509 144H432V202C432 228 446 251 468 262L545 307L547 308C576 323 594 353 592 386C590 429 550 464 504 464ZM502 110C514 110 524 102 527 91L481 80C477 97 489 109 502 110Z"]
  };
  var faDrawCircle = {
    prefix: 'far',
    iconName: 'draw-circle',
    icon: [512, 512, [], "f5ed", "M512 256C512 226 491 201 463 194C442 125 387 70 318 49C311 21 286 0 256 0S201 21 194 49C125 70 70 125 49 194C21 201 0 226 0 256S21 311 49 318C70 387 125 442 194 463C201 491 226 512 256 512S311 491 318 463C387 442 442 387 463 318C491 311 512 286 512 256ZM448 272C439 272 432 265 432 256C432 247 439 240 448 240S464 247 464 256C464 265 457 272 448 272ZM256 48C265 48 272 55 272 64S265 80 256 80C247 80 240 73 240 64S247 48 256 48ZM64 240C73 240 80 247 80 256C80 265 73 272 64 272S48 265 48 256C48 247 55 240 64 240ZM256 464C247 464 240 457 240 448S247 432 256 432C265 432 272 439 272 448S265 464 256 464ZM310 414C298 396 279 384 256 384S214 396 202 414C153 397 115 359 98 310C116 298 128 279 128 256S116 214 98 202C115 153 153 115 202 98C214 116 233 128 256 128S298 116 310 98C359 115 397 153 414 202C396 214 384 233 384 256S396 298 414 310C397 359 359 397 310 414Z"]
  };
  var faDrawPolygon = {
    prefix: 'far',
    iconName: 'draw-polygon',
    icon: [448, 512, [], "f5ee", "M384 352C381 352 377 353 374 353L339 294C347 284 352 270 352 256C352 242 347 228 339 218L374 159C377 159 381 160 384 160C419 160 448 131 448 96S419 32 384 32C357 32 334 49 325 72H123C114 49 91 32 64 32C29 32 0 61 0 96C0 123 17 146 40 155V357C17 366 0 389 0 416C0 451 29 480 64 480C91 480 114 463 123 440H325C334 463 357 480 384 480C419 480 448 451 448 416S419 352 384 352ZM88 357V155C104 149 117 136 123 120H325C327 125 330 130 333 134L298 193C295 193 291 192 288 192C253 192 224 221 224 256S253 320 288 320C291 320 295 319 298 319L333 378C330 382 327 387 325 392H123C117 376 104 363 88 357ZM288 240C297 240 304 247 304 256C304 265 297 272 288 272S272 265 272 256C272 247 279 240 288 240ZM384 80C393 80 400 87 400 96S393 112 384 112S368 105 368 96S375 80 384 80ZM64 80C73 80 80 87 80 96S73 112 64 112S48 105 48 96S55 80 64 80ZM64 432C55 432 48 425 48 416S55 400 64 400S80 407 80 416S73 432 64 432ZM384 432C375 432 368 425 368 416S375 400 384 400S400 407 400 416S393 432 384 432Z"]
  };
  var faDrawSquare = {
    prefix: 'far',
    iconName: 'draw-square',
    icon: [448, 512, [], "f5ef", "M408 357V155C431 146 448 123 448 96C448 61 419 32 384 32C357 32 334 49 325 72H123C114 49 91 32 64 32C29 32 0 61 0 96C0 123 17 146 40 155V357C17 366 0 389 0 416C0 451 29 480 64 480C91 480 114 463 123 440H325C334 463 357 480 384 480C419 480 448 451 448 416C448 389 431 366 408 357ZM88 357V155C104 149 117 136 123 120H325C331 136 344 149 360 155V357C344 363 331 376 325 392H123C117 376 104 363 88 357ZM384 80C393 80 400 87 400 96S393 112 384 112S368 105 368 96S375 80 384 80ZM64 80C73 80 80 87 80 96S73 112 64 112S48 105 48 96S55 80 64 80ZM64 432C55 432 48 425 48 416S55 400 64 400S80 407 80 416S73 432 64 432ZM384 432C375 432 368 425 368 416S375 400 384 400S400 407 400 416S393 432 384 432Z"]
  };
  var faDreidel = {
    prefix: 'far',
    iconName: 'dreidel',
    icon: [448, 512, [], "f792", "M441 39C432 30 416 30 407 39L295 151L217 74C211 67 202 64 194 64C185 64 176 67 170 74L20 224C7 237 0 254 0 271V413C0 450 30 480 67 480H209C226 480 243 473 256 460L406 310C419 297 419 276 406 263L329 185L441 73C450 64 450 48 441 39ZM222 426C218 430 214 432 209 432H67C57 432 48 423 48 413V271C48 266 50 262 54 258L107 205L275 373L222 426ZM309 339L141 171L193 118L362 287L309 339Z"]
  };
  var faDrone = {
    prefix: 'far',
    iconName: 'drone',
    icon: [512, 512, [], "f85f", "M339 92C349 64 377 45 407 48C437 52 460 75 464 105S448 163 420 173L384 222C389 223 394 224 400 224C462 224 512 174 512 112S462 0 400 0S288 50 288 112C288 118 289 123 290 128L339 92ZM111 368C94 369 80 383 80 400C80 418 94 432 112 432S143 418 144 401L212 352H300L368 401C369 418 383 432 400 432C418 432 432 418 432 400C432 383 418 369 401 368L352 300V212L401 144C418 143 432 129 432 112S418 80 400 80C383 80 369 94 368 111L300 160H212L144 111C143 94 129 80 112 80S80 94 80 112S94 143 111 144L160 212V300L111 368ZM208 208H304V304H208V208ZM400 288C394 288 389 289 384 290L420 339C448 349 467 377 464 407S437 461 407 464C377 467 349 448 339 420L290 384C289 389 288 394 288 400C288 462 338 512 400 512S512 462 512 400S462 288 400 288ZM112 224C118 224 123 223 128 222L92 173C64 163 45 135 48 105C52 75 75 51 105 48C135 45 163 64 173 92L222 128C223 123 224 118 224 112C224 50 174 0 112 0S0 50 0 112S50 224 112 224ZM173 420C163 448 135 467 105 464C75 460 52 437 48 407C45 377 64 349 92 339L128 290C123 289 118 288 112 288C50 288 0 338 0 400S50 512 112 512S224 462 224 400C224 394 223 389 222 384L173 420Z"]
  };
  var faDroneFront = {
    prefix: 'far',
    iconName: 'drone-front',
    icon: [640, 512, [], "f860", "M288 136C288 123 277 112 264 112H166C163 102 154 96 144 96S125 102 122 112H24C11 112 0 123 0 136S11 160 24 160H264C277 160 288 149 288 136ZM472 238L375 209C339 198 301 198 265 209L168 238V192H120V256C120 274 134 288 152 288H198C167 317 148 356 144 398C144 403 145 407 148 411C151 414 155 416 160 416H176C185 416 191 409 192 401C195 370 210 340 234 319L251 336C261 346 274 352 289 352H351C365 352 379 346 389 336L406 319C429 341 444 370 448 401C449 409 455 416 463 416H480C484 416 489 414 492 411C495 407 496 403 496 398C492 356 473 317 442 288H488C506 288 520 274 520 256V192H472L472 238ZM355 302C354 303 353 304 351 304H289C287 304 286 303 285 302L247 264L278 255C306 246 334 246 361 255L393 264L355 302ZM616 112L518 112C515 103 506 96 496 96S477 103 474 113L376 113C363 113 353 124 353 137C353 149 363 160 376 160L617 159C629 159 640 148 640 136C639 123 629 112 616 112Z"]
  };
  var faDroplet = {
    prefix: 'far',
    iconName: 'droplet',
    icon: [384, 512, [], "f043", "M221 22C217 7 205 0 192 0C180 0 167 7 163 22C116 180 16 223 16 334C16 432 95 512 192 512S368 432 368 334C368 222 268 181 221 22ZM192 464C121 464 64 406 64 334C64 291 85 261 116 216C140 182 169 140 192 84C215 140 244 182 268 216C299 261 320 290 320 334C320 406 263 464 192 464ZM208 400C164 400 128 364 128 320C128 311 121 304 112 304S96 311 96 320C96 382 146 432 208 432C217 432 224 425 224 416S217 400 208 400Z"]
  };
  var faDropletDegree = {
    prefix: 'far',
    iconName: 'droplet-degree',
    icon: [448, 512, [], "f748", "M368 32C324 32 288 68 288 112S324 192 368 192S448 156 448 112S412 32 368 32ZM368 144C350 144 336 130 336 112S350 80 368 80S400 94 400 112S386 144 368 144ZM160 32C149 32 137 38 133 51C91 189 0 227 0 324C0 410 72 480 160 480S320 410 320 324C320 226 229 190 187 51C183 39 171 32 160 32ZM272 324C272 384 222 432 160 432S48 384 48 324C48 290 64 267 94 225C115 196 139 162 160 117C181 163 205 197 226 225C256 267 272 290 272 324Z"]
  };
  var faDropletPercent = {
    prefix: 'far',
    iconName: 'droplet-percent',
    icon: [320, 512, [], "f750", "M187 51C183 39 171 32 160 32C149 32 137 38 133 51C91 189 0 227 0 324C0 410 72 480 160 480S320 410 320 324C320 226 229 190 187 51ZM160 432C98 432 48 384 48 324C48 290 64 267 94 225C115 196 139 162 160 117C181 163 205 197 226 225C256 267 272 290 272 324C272 384 222 432 160 432ZM120 304C133 304 144 293 144 280S133 256 120 256S96 267 96 280S107 304 120 304ZM197 261L101 357C94 363 94 373 101 379C104 382 108 384 112 384S120 382 123 379L219 283C226 277 226 267 219 261S203 254 197 261ZM200 336C187 336 176 347 176 360S187 384 200 384S224 373 224 360S213 336 200 336Z"]
  };
  var faDropletSlash = {
    prefix: 'far',
    iconName: 'droplet-slash',
    icon: [640, 512, [], "f5c7", "M631 469L494 362C495 353 496 343 496 334C496 222 396 181 349 22C345 7 333 0 320 0C308 0 295 7 291 22C274 78 251 119 228 154L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L239 223L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM266 183C285 156 304 124 320 84C343 140 372 182 396 216C425 258 445 286 447 325L266 183ZM320 464C249 464 192 406 192 334C192 308 200 286 213 263L175 234C157 264 144 295 144 334C144 432 223 512 320 512C373 512 420 488 452 451L414 421C391 447 357 464 320 464ZM336 432C345 432 352 425 352 416S345 400 336 400C292 400 256 364 256 320C256 311 249 304 240 304S224 311 224 320C224 382 274 432 336 432Z"]
  };
  var faDrum = {
    prefix: 'far',
    iconName: 'drum',
    icon: [512, 512, [], "f569", "M432 122L431 122L501 76C512 69 515 54 508 43C501 32 486 29 475 36L369 106L369 106C320 97 274 96 256 96C213 96 0 101 0 208V368C0 430 115 480 256 480S512 430 512 368V208C512 165 477 138 432 122ZM88 400C62 388 48 375 48 368V279C61 287 74 292 88 297V400ZM232 431C194 429 162 424 136 418V309C172 316 208 319 232 319V431ZM376 418C350 425 318 429 280 431V319C304 319 340 316 376 309V418ZM464 368C464 375 450 388 424 400V297C438 292 451 287 464 279V368ZM256 272C141 272 48 243 48 208C48 173 141 144 256 144C274 144 291 145 307 146L243 188C232 195 229 210 236 221C241 228 248 232 256 232C261 232 265 231 269 228L379 156C430 168 464 187 464 208C464 243 371 272 256 272Z"]
  };
  var faDrumSteelpan = {
    prefix: 'far',
    iconName: 'drum-steelpan',
    icon: [576, 512, [], "f56a", "M288 32C129 32 0 89 0 160V352C0 423 129 480 288 480S576 423 576 352V160C576 89 447 32 288 32ZM288 80C312 80 336 81 358 83L346 128C342 146 316 160 288 160S234 146 230 128L218 83C240 81 264 80 288 80ZM230 175C246 186 267 192 288 192C309 192 330 186 346 176C349 198 357 218 370 235C345 238 317 240 288 240C259 240 231 238 205 235C218 218 227 197 230 175ZM174 90L187 136C197 170 184 206 157 227C91 213 48 188 48 160C48 130 99 103 174 90ZM528 352C528 379 434 432 288 432S48 379 48 352V231C100 265 188 288 288 288S476 265 528 231V352ZM418 227C410 221 402 213 397 204C385 185 381 163 386 142L399 89C475 102 528 129 528 160C528 188 484 213 418 227Z"]
  };
  var faDrumstick = {
    prefix: 'far',
    iconName: 'drumstick',
    icon: [512, 512, [], "f6d6", "M471 58C440 22 395 1 348 0C301 -1 255 17 222 50C195 76 160 119 160 189V278L119 318C110 328 95 329 83 324C56 314 26 323 10 347C-6 371 -3 403 18 423C33 438 54 443 74 438C69 458 74 479 89 494C109 515 141 518 165 502C189 486 198 456 188 429C183 417 184 402 194 393L234 352H262L262 352H323C362 352 396 342 427 321C473 290 504 241 511 188C517 140 503 93 471 58ZM400 281C377 296 352 304 323 304H240C222 304 208 290 208 272V190C208 149 222 117 256 84C313 26 396 45 435 89C497 159 450 248 400 281Z"]
  };
  var faDrumstickBite = {
    prefix: 'far',
    iconName: 'drumstick-bite',
    icon: [512, 512, [], "f6d7", "M471 58C440 22 395 1 348 0C301 -1 255 17 222 50C195 76 160 119 160 189V278L119 318C110 328 95 329 83 324C56 314 26 323 10 347C-6 371 -3 403 18 423C33 438 54 443 74 438C69 458 74 479 89 494C109 515 141 518 165 502C189 486 198 456 188 429C183 417 184 402 194 393L234 352H262L262 352H323C340 352 357 350 374 345C381 343 387 338 390 331C392 324 392 316 388 310C369 276 374 234 400 208C421 187 451 179 482 188C489 190 497 188 503 183C509 179 512 172 512 164C512 124 498 87 471 58ZM366 174C334 206 322 251 332 295C329 299 328 300 325 304H247C222 304 208 290 208 272V190C208 149 222 117 256 84C313 26 396 45 435 89C447 103 456 119 460 136C425 135 391 149 366 174Z"]
  };
  var faDryer = {
    prefix: 'far',
    iconName: 'dryer',
    icon: [448, 512, [], "f861", "M368 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H384C419 512 448 483 448 448V80C448 36 412 0 368 0ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V80C48 62 62 48 80 48H368C386 48 400 62 400 80V448ZM128 104C128 91 117 80 104 80C91 80 80 91 80 104S91 128 104 128C117 128 128 117 128 104ZM184 128C197 128 208 117 208 104S197 80 184 80C171 80 160 91 160 104S171 128 184 128ZM224 160C149 160 88 221 88 296S149 432 224 432S360 371 360 296S299 160 224 160ZM224 384C184 384 150 357 140 320H176C189 320 200 309 200 296S189 272 176 272H140C150 235 184 208 224 208C273 208 312 247 312 296S273 384 224 384Z"]
  };
  var faDryerHeat = {
    prefix: 'far',
    iconName: 'dryer-heat',
    icon: [448, 512, [], "f862", "M368 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H384C419 512 448 483 448 448V80C448 36 412 0 368 0ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V80C48 62 62 48 80 48H368C386 48 400 62 400 80V448ZM128 104C128 91 117 80 104 80C91 80 80 91 80 104S91 128 104 128C117 128 128 117 128 104ZM184 128C197 128 208 117 208 104S197 80 184 80C171 80 160 91 160 104S171 128 184 128ZM224 160C149 160 88 221 88 296S149 432 224 432S360 371 360 296S299 160 224 160ZM219 371C216 374 212 376 208 376S200 374 197 371L190 365C170 345 165 314 178 289C184 276 182 260 171 250L165 243C158 237 158 227 165 221C171 214 181 214 187 221L194 227C214 247 219 278 206 303C200 316 202 332 213 342L219 349C226 355 226 365 219 371ZM283 371C280 374 276 376 272 376S264 374 261 371L254 365C234 345 229 314 242 289C248 276 246 260 235 250L229 243C222 237 222 227 229 221C235 214 245 214 251 221L258 227C278 247 283 278 270 303C264 316 266 332 277 342L283 349C290 355 290 365 283 371Z"]
  };
  var faDuck = {
    prefix: 'far',
    iconName: 'duck',
    icon: [576, 512, [], "f6d8", "M464 240C526 240 576 190 576 128H510C510 125 510 121 509 118C500 78 467 44 427 35C418 33 409 32 400 32C338 32 288 82 288 144L288 232H228C204 232 167 221 154 207C143 196 126 192 111 198C97 204 87 218 87 233C87 324 161 400 248 400C261 400 272 389 272 376S261 352 248 352C194 352 147 309 137 255C163 271 201 280 228 280H312C325 280 336 269 336 256L336 144C336 109 365 80 400 80C405 80 411 81 416 82C439 87 457 106 462 129C470 164 450 191 427 202L400 214L400 295C423 311 435 337 432 364C427 402 393 432 356 432H226C133 432 55 360 48 269C47 256 35 247 22 247C9 248 -1 260 0 273C9 389 108 480 226 480H356C418 480 472 431 479 370C483 334 472 300 448 274V240H464ZM416 144C416 135 409 128 400 128S384 135 384 144S391 160 400 160S416 153 416 144Z"]
  };
  var faDumbbell = {
    prefix: 'far',
    iconName: 'dumbbell',
    icon: [640, 512, [], "f44b", "M608 224L608 224L608 152C608 121 583 96 552 96H520C517 96 515 96 512 97V88C512 57 487 32 456 32H424C393 32 368 57 368 88V224H272V88C272 57 247 32 216 32H184C153 32 128 57 128 88V97C125 96 123 96 120 96H88C57 96 32 121 32 152V224H32C14 224 0 238 0 256V256C0 274 14 288 32 288H32V360C32 391 57 416 88 416H120C123 416 125 416 128 415V424C128 455 153 480 184 480H216C247 480 272 455 272 424V288H368V424C368 455 393 480 424 480H456C487 480 512 455 512 424V415C515 416 517 416 520 416H552C583 416 608 391 608 360V288H608C626 288 640 274 640 256V256C640 238 626 224 608 224ZM120 368H88C84 368 80 364 80 360V152C80 148 84 144 88 144H120C124 144 128 148 128 152V360C128 364 124 368 120 368ZM224 424C224 428 220 432 216 432H184C180 432 176 428 176 424V88C176 84 180 80 184 80H216C220 80 224 84 224 88V424ZM464 424C464 428 460 432 456 432H424C420 432 416 428 416 424V88C416 84 420 80 424 80H456C460 80 464 84 464 88V424ZM560 360C560 364 556 368 552 368H520C516 368 512 364 512 360V152C512 148 516 144 520 144H552C556 144 560 148 560 152V360Z"]
  };
  var faDumpster = {
    prefix: 'far',
    iconName: 'dumpster',
    icon: [576, 512, [], "f793", "M560 160C570 160 578 150 575 140L551 44C550 37 543 32 536 32H437L463 160H560ZM405 32H304V160H430L405 32ZM552 224H540L544 192H32L36 224H24C11 224 0 235 0 248V248C0 261 11 272 24 272H42L64 448V456C64 469 75 480 88 480H88C101 480 112 469 112 456V448H464V456C464 469 475 480 488 480L488 480C501 480 512 469 512 456V448L534 272H552C565 272 576 261 576 248V248C576 235 565 224 552 224ZM470 400H106L86 240H490L470 400ZM16 160H113L139 32H40C33 32 26 37 25 44L1 140C-2 150 6 160 16 160ZM272 32H171L146 160H272V32Z"]
  };
  var faDumpsterFire = {
    prefix: 'far',
    iconName: 'dumpster-fire',
    icon: [640, 512, [], "f794", "M419 104L419 104L405 32H304V160H365C381 141 399 122 419 104ZM461 104C480 120 497 138 512 156C518 150 524 145 530 139L551 120L572 139C573 140 574 141 575 142C575 142 576 141 575 140L551 44C550 37 543 32 536 32H437L449 94L461 104ZM272 32H172L146 160H272V32ZM106 400L86 240H312C320 224 329 208 341 192H32L36 224H24C11 224 0 235 0 248V248C0 261 11 272 24 272H42L64 448V456C64 469 75 480 88 480H88C101 480 112 469 112 456V448H337C324 434 313 418 305 400H106ZM16 160H113L139 32H40C33 32 26 37 25 44L1 140C-2 150 6 160 16 160ZM551 163C536 177 523 190 511 204C491 179 467 152 440 128C370 191 320 272 320 322C320 409 392 480 480 480S640 409 640 322C640 285 603 209 551 163ZM480 432C418 432 368 383 368 322C368 299 393 247 440 195C463 219 471 231 509 281C549 234 548 235 550 233C576 268 592 307 592 322C592 383 542 432 480 432Z"]
  };
  var faDungeon = {
    prefix: 'far',
    iconName: 'dungeon',
    icon: [512, 512, [], "f6d9", "M512 295C512 287 510 279 507 272C510 264 512 255 512 246C510 211 502 177 487 145C482 136 476 129 468 123C466 114 462 105 456 97C435 70 409 48 379 32C371 27 362 25 352 25C352 25 352 25 351 25C344 18 336 13 326 10C303 3 280 0 256 0C232 0 209 3 186 10C176 13 168 18 161 25C161 25 160 25 160 25C150 25 141 27 133 32C103 48 77 70 56 97C50 105 46 114 44 123C36 129 30 136 25 145C10 177 2 211 0 246C0 255 2 264 5 272C2 279 0 287 0 295V353C0 361 2 369 5 376C2 383 0 391 0 399V457C0 487 25 512 55 512H457C487 512 512 487 512 457V399C512 391 510 383 507 376C510 369 512 361 512 353V295ZM112 457C112 461 109 464 105 464H55C51 464 48 461 48 457V399C48 395 51 392 55 392H105C109 392 112 395 112 399V457ZM112 353C112 357 109 360 105 360H55C51 360 48 357 48 353V295C48 291 51 288 55 288H105C109 288 112 291 112 295V353ZM133 204C127 218 123 233 122 249C122 253 119 256 115 256H56C51 256 48 252 48 248C49 219 57 191 69 166C70 163 73 162 75 162C77 162 78 162 79 163L130 195C134 197 135 201 133 204ZM150 171C149 171 147 171 146 170L95 138C91 136 90 130 93 127C110 105 132 87 156 74C157 73 158 73 160 73C163 73 166 75 167 78L189 134C190 137 189 141 186 143C175 150 165 158 156 169C154 170 152 171 150 171ZM208 456C208 460 204 464 200 464H184C180 464 176 460 176 456V203C184 191 195 181 208 173V456ZM272 456C272 460 268 464 264 464H248C244 464 240 460 240 456V162C245 161 250 160 256 160S267 161 272 162V456ZM289 127C288 127 288 127 287 126C276 124 266 122 256 122C246 122 236 124 225 126C224 127 224 127 223 127C220 127 217 125 216 122L194 66C193 62 195 57 199 56C217 51 236 48 256 48S295 51 313 56C317 57 319 62 318 66L296 122C295 125 292 127 289 127ZM336 456C336 460 332 464 328 464H312C308 464 304 460 304 456V173C317 181 328 191 336 203V456ZM362 171C360 171 358 170 356 169C348 159 337 150 326 143C323 141 322 137 323 134L345 78C346 75 349 73 352 73C354 73 355 73 356 74C380 87 402 105 419 127C422 130 421 136 417 138L366 170C365 171 363 171 362 171ZM390 249C389 233 385 218 379 204C377 201 378 197 382 195L433 163C434 162 435 162 437 162C440 162 442 164 444 166C456 191 463 219 464 248C464 252 461 256 456 256H397C393 256 390 253 390 249ZM464 457C464 461 461 464 457 464H407C403 464 400 461 400 457V399C400 395 403 392 407 392H457C461 392 464 395 464 399V457ZM464 353C464 357 461 360 457 360H407C403 360 400 357 400 353V295C400 291 403 288 407 288H457C461 288 464 291 464 295V353Z"]
  };
  var faE = {
    prefix: 'far',
    iconName: 'e',
    icon: [320, 512, [], "e122", "M320 448C320 466 306 480 288 480H32C14 480 0 466 0 448V64C0 46 14 32 32 32H288C306 32 320 46 320 64S306 96 288 96H64V225C66 225 67 224 69 224H224C242 224 256 238 256 256S242 288 224 288H69C67 288 66 287 64 287V416H288C306 416 320 430 320 448Z"]
  };
  var faEar = {
    prefix: 'far',
    iconName: 'ear',
    icon: [384, 512, [], "f5f0", "M192 0C86 0 0 86 0 192V368C0 447 65 512 144 512S288 447 288 368V358C345 325 384 263 384 192C384 86 298 0 192 0ZM264 317L240 330V368C240 421 197 464 144 464S48 421 48 368V192C48 113 113 48 192 48S336 113 336 192C336 243 308 291 264 317ZM200 80H184C127 80 80 127 80 184V232C80 242 86 251 95 254L124 266C128 267 129 271 129 272C129 273 129 277 126 280L89 309C79 318 77 333 85 343C90 349 97 352 104 352C110 352 115 350 119 347L156 317C172 304 179 285 177 265C174 245 161 229 142 221L128 216V184C128 153 153 128 184 128H200C231 128 256 153 256 184C256 197 267 208 280 208S304 197 304 184C304 127 257 80 200 80ZM104 344C104 344 103 344 103 344C104 344 105 344 106 344C106 344 105 344 104 344Z"]
  };
  var faEarDeaf = {
    prefix: 'far',
    iconName: 'ear-deaf',
    icon: [512, 512, [], "f2a4", "M240 57C143 57 64 138 64 238C64 251 75 262 88 262S112 251 112 238C112 165 169 105 240 105S368 165 368 238C368 285 350 329 319 363L313 369L312 377C307 422 270 457 226 457C213 457 202 468 202 481S213 505 226 505C292 505 348 456 359 390C396 348 416 295 416 238C416 138 337 57 240 57ZM151 320L7 464C-2 473 -2 489 7 498C12 503 18 505 24 505S36 503 41 498L185 354C194 345 194 329 185 320S160 311 151 320ZM505 0C496 -9 480 -9 471 0L407 64C398 73 398 89 407 98C412 103 418 105 424 105S436 103 441 98L505 34C514 25 514 9 505 0ZM240 193C262 193 280 211 280 233C280 246 291 257 304 257S328 246 328 233C328 184 289 145 240 145S152 184 152 233C152 246 163 257 176 257S200 246 200 233C200 211 218 193 240 193Z"]
  };
  var faEarListen = {
    prefix: 'far',
    iconName: 'ear-listen',
    icon: [512, 512, [], "f2a2", "M81 367C72 358 56 358 47 367C38 376 38 392 47 401L111 465C116 470 122 472 128 472S140 470 145 465C154 456 154 440 145 431L81 367ZM387 3C375 -3 360 1 355 13C349 25 353 40 365 45C366 46 450 89 464 203C466 215 476 224 488 224C489 224 490 224 491 224C504 222 513 210 512 197C494 58 391 5 387 3ZM24 464C11 464 0 475 0 488S11 512 24 512S48 501 48 488S37 464 24 464ZM168 320C155 320 144 331 144 344C144 357 155 368 168 368S192 357 192 344C192 331 181 320 168 320ZM240 64C143 64 64 145 64 245C64 258 75 269 88 269S112 258 112 245C112 172 169 112 240 112S368 172 368 245C368 292 350 336 319 370L313 376L312 384C307 430 270 464 226 464C213 464 202 475 202 488C202 501 213 512 226 512C292 512 348 463 359 397C396 355 416 302 416 245C416 145 337 64 240 64ZM240 200C262 200 280 218 280 240C280 253 291 264 304 264S328 253 328 240C328 191 289 152 240 152S152 191 152 240C152 253 163 264 176 264S200 253 200 240C200 218 218 200 240 200Z"]
  };
  var faEarMuffs = {
    prefix: 'far',
    iconName: 'ear-muffs',
    icon: [640, 512, [], "f795", "M639 335C639 335 639 335 638 335C636 323 629 313 620 305C619 294 614 283 606 274C598 265 587 259 575 256C568 246 558 238 546 233C540 231 534 230 528 230V208C528 93 435 0 320 0C205 0 112 93 112 208V230C106 230 100 231 94 233C82 238 72 246 65 256C53 259 42 265 34 274C26 283 21 294 20 305C11 313 4 323 1 335C-1 346 0 358 4 368C0 379 -1 391 2 402C5 413 11 423 20 431C21 442 26 453 35 463C43 472 54 478 66 481C73 491 83 498 93 502C105 507 119 508 133 504C142 509 153 512 163 512C197 512 224 486 224 455C224 447 222 440 219 433C222 426 224 419 224 411C224 404 222 396 220 390C222 383 224 375 224 368S222 353 220 346C222 340 224 332 224 325C224 317 222 310 219 303C222 296 224 289 224 281C224 250 197 224 163 224C162 224 161 224 160 224V208C160 120 232 48 320 48S480 120 480 208V224C479 224 478 224 477 224C443 224 416 250 416 281C416 289 418 296 421 303C418 310 416 317 416 325C416 332 418 340 420 346C418 353 416 360 416 368S418 383 420 390C418 396 416 404 416 411C416 419 418 426 421 433C418 440 416 447 416 455C416 486 443 512 477 512C487 512 498 509 507 504C521 508 537 506 545 503C557 499 567 491 574 481C586 478 597 472 606 462C614 453 619 442 620 431C629 423 635 413 638 402C641 391 640 379 636 368C640 358 641 346 639 335ZM176 281C176 283 175 285 173 286C164 296 164 310 173 320C175 322 176 323 176 325C176 327 175 328 174 330C165 339 165 354 174 363C176 365 176 367 176 368S176 371 174 373C165 382 165 397 174 406C175 408 176 409 176 411C176 413 175 415 173 416C164 426 164 440 173 450C175 451 176 453 176 455C176 460 170 464 163 464C158 464 155 462 153 460C149 455 143 453 136 453C132 453 128 454 124 456C119 459 114 459 111 457C107 456 105 454 104 452C101 441 93 435 81 434C77 434 72 433 70 430C68 428 67 426 68 423C70 412 65 401 54 396C51 395 49 393 48 390C48 387 49 385 50 384C58 375 58 361 50 352C49 351 48 349 48 347C49 343 52 341 54 340C65 335 70 324 68 313C67 311 67 309 70 306C72 303 76 302 81 302C91 302 101 295 104 285C105 282 107 280 110 279C116 277 121 279 124 280C133 286 146 284 153 276C155 275 158 272 163 272C170 272 176 276 176 281ZM590 384C591 385 592 387 592 390C591 393 589 395 586 396C575 401 570 412 572 423C573 426 572 428 570 430C568 433 564 434 559 434C547 434 539 441 536 452C535 454 533 456 527 458C527 458 521 459 516 456C506 451 494 452 487 460C485 462 482 464 477 464C470 464 464 460 464 455C464 453 465 451 467 450C476 440 476 426 467 416C465 415 464 413 464 411C464 409 465 408 466 406C475 397 475 382 466 373C464 371 464 369 464 368S464 365 466 363C475 354 475 339 466 330C465 328 464 327 464 325C464 323 465 322 467 320C476 310 476 296 467 286C465 285 464 283 464 281C464 276 470 272 477 272C482 272 485 275 487 276C494 284 507 286 516 280C519 279 524 277 530 279C533 280 535 282 536 285C539 295 549 302 559 302C564 302 568 303 571 306C573 309 573 311 572 313C570 324 575 335 586 340C588 341 591 343 592 346C592 349 591 351 590 352C582 361 582 375 590 384Z"]
  };
  var faEarthAfrica = {
    prefix: 'far',
    iconName: 'earth-africa',
    icon: [512, 512, [], "f57c", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM282 221L268 214C260 210 252 208 243 208H242C230 208 219 212 209 219L182 240C168 250 160 266 160 283V297C160 312 166 326 176 336C186 346 200 352 215 352H241C249 352 256 359 256 367V397C256 410 259 422 264 433C266 436 271 442 276 446C270 447 263 448 256 448C150 448 64 362 64 256S150 64 256 64C267 64 278 65 288 67V80C288 89 281 96 273 96H248C243 96 238 99 235 103L227 115C225 118 222 121 218 122L204 125C197 127 192 133 192 140V145C192 153 199 160 207 160H298C302 160 306 162 309 165L315 172C318 174 322 176 326 176H337C345 176 352 183 352 191C352 198 348 204 341 206L294 222C290 223 286 223 282 221ZM307 441C309 439 311 438 312 436L325 416C332 405 341 396 350 387C353 385 354 382 355 378L359 356C360 353 361 351 362 349L381 324C383 322 384 318 384 315V303C384 295 377 288 369 288H360C355 288 350 285 347 281L334 261C329 253 332 241 342 238L345 237C349 235 354 236 358 239L377 251C381 254 387 254 392 252L408 244C413 242 416 236 416 230V223C416 215 423 208 431 208H442C446 223 448 239 448 256C448 344 388 418 307 441Z"]
  };
  var faEarthAmericas = {
    prefix: 'far',
    iconName: 'earth-americas',
    icon: [512, 512, [], "f57d", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM224 67V70C224 82 211 90 201 84L187 77C199 73 211 69 224 67ZM64 256C64 230 70 205 79 182C90 199 103 218 108 226C113 233 119 240 126 246L127 247C137 256 147 263 159 269C173 276 193 287 208 295C218 300 224 311 224 323V355C224 363 227 371 233 377C248 392 258 416 256 429V448C150 448 64 362 64 256ZM302 441L316 405C318 399 319 393 321 388C322 384 324 380 327 377C330 374 334 370 338 366C347 357 352 345 352 333C352 325 349 317 343 311L329 297C323 291 315 288 307 288H240C231 283 219 256 208 256S187 254 178 249L167 243C163 241 160 237 160 233C160 228 163 223 168 221L199 211C205 209 211 210 215 214L224 222C226 223 228 224 229 224H235C241 224 245 218 242 212L227 181C225 178 226 174 228 172L238 162C240 161 242 160 244 160H253C255 160 257 159 258 158L266 150C269 146 269 142 266 138L262 134C259 130 259 126 262 122L272 112L277 107C283 101 283 91 277 85L256 64H256C331 64 396 108 427 170L422 173C418 175 415 178 412 181L393 211C387 219 387 229 393 237L411 264C414 269 419 273 425 274L446 279C436 359 378 422 302 441Z"]
  };
  var faEarthAsia = {
    prefix: 'far',
    iconName: 'earth-asia',
    icon: [512, 512, [], "f57e", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM415 363C416 362 416 360 416 358V334C416 330 414 325 411 322L399 311C398 309 397 307 397 305V292C397 290 395 288 393 288H387C385 288 384 289 383 291L379 305C378 307 377 308 375 308H371C370 308 368 307 368 306L362 293C361 290 358 288 355 288H343C341 288 340 289 338 290L314 306C313 308 311 309 309 309L270 325C266 326 264 329 264 333V343C264 345 265 347 267 348L279 360C282 363 286 365 290 365H300C302 365 303 365 304 365L326 359C335 357 344 360 351 366L364 379C367 382 371 384 375 384H390C395 384 399 382 402 379L407 374C372 419 317 448 256 448C161 448 82 379 67 288H121C126 288 130 286 133 283L152 264C156 260 162 261 165 266L188 311C190 317 196 320 202 320H208C217 320 224 313 224 304V295C224 290 222 286 219 283L214 278C211 274 211 269 214 266L219 261C222 258 226 256 231 256H231C236 256 242 253 245 248L262 219C264 216 268 217 270 220C271 222 274 224 277 224H280C284 224 288 220 288 216V138C288 132 285 126 279 124L268 118C263 115 262 108 268 104L309 72C389 96 448 169 448 256C448 296 436 333 415 363Z"]
  };
  var faEarthEuropa = {
    prefix: 'far',
    iconName: 'earth-europa',
    icon: [512, 512, [], "f7a2", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM422 352H418C413 352 408 350 405 347L387 330C381 324 373 320 365 320H346L303 283C295 276 285 272 274 272H243C234 272 226 275 219 279L176 305C162 313 154 328 154 344V368C154 382 161 395 172 404L194 421C203 427 219 432 230 432H250C259 432 265 439 266 447C263 447 259 448 256 448C150 448 64 362 64 256C64 156 141 74 239 65L221 78C219 79 218 82 218 84V104C218 109 222 112 226 112H242C246 112 250 109 250 104V96L266 80H287C293 80 298 86 298 92C298 95 297 98 295 100L268 126C267 128 265 129 264 129L224 142C220 144 218 147 218 150C218 157 215 163 211 168L191 188C188 191 186 195 186 199V224C186 233 193 240 202 240H224C230 240 236 237 238 232L248 213C249 210 252 208 255 208H258C263 208 266 212 266 216S270 224 274 224H290C295 224 298 221 298 216V214C298 211 300 208 304 207L335 196C342 194 346 188 346 181V176C346 168 353 160 362 160H399C405 160 410 166 410 172V181C410 187 405 192 399 192H367C364 192 361 194 359 196L349 205C347 207 346 210 346 213C346 219 351 224 357 224H373C376 224 379 226 382 228L391 237C393 239 394 242 394 245V254L382 266C377 271 377 278 381 283L414 316C416 319 421 320 425 320H436C432 332 428 342 422 352ZM186 124C186 118 181 112 175 112C172 112 169 114 167 116L141 141C139 143 138 146 138 149C138 155 143 160 149 160H165C168 160 171 159 173 157L183 148C185 146 186 143 186 140V124Z"]
  };
  var faEclipse = {
    prefix: 'far',
    iconName: 'eclipse',
    icon: [640, 512, [], "f749", "M256 458L204 381L113 399L131 307L54 255L131 203L113 112L204 130L256 53L288 100C299 88 311 78 325 69L290 17C274 -6 238 -6 223 17L182 77L111 63C98 60 84 65 75 74C66 84 61 97 64 110L78 181L18 222C7 230 0 242 0 256C0 269 7 282 18 289L78 330L64 401C61 414 66 427 75 437S98 451 111 448L182 434L223 494C230 505 243 512 256 512S282 505 290 494L324 443C311 434 298 423 287 412L256 458ZM230 207C234 188 241 170 250 153C195 156 152 201 152 256C152 311 195 356 250 359C241 342 234 324 230 305C212 296 200 277 200 256C200 235 212 216 230 207ZM448 64C342 64 256 150 256 256S342 448 448 448C554 448 640 362 640 256S554 64 448 64ZM448 400C369 400 304 335 304 256C304 177 369 112 448 112S592 177 592 256C592 335 527 400 448 400Z"]
  };
  var faEgg = {
    prefix: 'far',
    iconName: 'egg',
    icon: [384, 512, [], "f7fb", "M192 0C86 0 0 214 0 320S86 512 192 512C298 512 384 426 384 320S298 0 192 0ZM192 464C113 464 48 399 48 320C48 203 139 48 192 48S336 203 336 320C336 399 271 464 192 464ZM168 104C161 104 154 107 149 113C114 157 76 239 76 304C76 317 87 328 100 328C114 328 124 317 124 304C124 252 156 181 187 143C195 133 193 118 183 109C179 106 174 104 168 104Z"]
  };
  var faEggFried = {
    prefix: 'far',
    iconName: 'egg-fried',
    icon: [512, 512, [], "f7fc", "M478 150C439 110 378 104 334 68C290 32 256 0 200 0C192 0 184 1 175 2C89 16 64 82 50 159C39 224 -4 286 0 352C5 418 53 481 115 503C133 509 149 512 164 512C229 512 273 461 320 417C364 375 413 379 461 343C517 300 533 202 478 150ZM432 304C416 317 398 323 378 330C350 341 318 352 287 382C281 387 276 392 270 398C234 433 202 464 164 464C154 464 143 462 131 458C87 442 51 395 48 349C46 320 58 288 71 253C82 226 92 198 98 167C111 87 133 58 183 50C189 49 195 48 200 48C233 48 255 65 294 98L303 105C329 126 357 138 383 149C408 160 429 169 444 184L444 185L445 185C463 202 464 226 464 239C462 265 450 291 432 304ZM224 128C162 128 112 178 112 240C112 302 162 352 224 352S336 302 336 240C336 178 286 128 224 128ZM224 200C202 200 184 218 184 240C184 249 177 256 168 256S152 249 152 240C152 201 184 168 224 168C233 168 240 175 240 184C240 193 233 200 224 200V200Z"]
  };
  var faEject = {
    prefix: 'far',
    iconName: 'eject',
    icon: [448, 512, [], "f052", "M48 352H400C442 352 463 302 435 272L259 79C250 69 237 64 224 64C211 64 198 69 189 79L13 272C-15 302 6 352 48 352ZM224 112C224 112 224 112 224 112L224 112L400 304L48 304L224 112ZM424 400H24C11 400 0 411 0 424C0 437 11 448 24 448H424C437 448 448 437 448 424C448 411 437 400 424 400Z"]
  };
  var faElephant = {
    prefix: 'far',
    iconName: 'elephant',
    icon: [640, 512, [], "f6da", "M528 128C519 128 512 135 512 144C512 153 519 160 528 160S544 153 544 144C544 135 537 128 528 128ZM512 32H451C447 28 443 25 439 21C413 1 380 -5 347 4C329 9 313 19 301 32H192C86 32 0 118 0 224V336C0 345 7 352 16 352H32V480C32 498 46 512 64 512H144C162 512 176 498 176 480V407C194 412 242 424 304 407V480C304 498 318 512 336 512H416C434 512 448 498 448 480V288H592V376C592 389 581 400 568 400S544 389 544 376V368C544 359 537 352 528 352H512C503 352 496 359 496 368V373C496 410 523 444 561 448C604 452 640 418 640 376V160C640 89 583 32 512 32ZM400 464H352V344C231 377 241 375 128 344V464H80V304H48V224C48 144 113 80 192 80H275C269 107 273 134 287 157C298 177 316 191 336 200C336 240 363 274 400 284V464ZM592 208C592 226 578 240 560 240H424C402 240 384 222 384 200V163C361 158 342 156 328 133C311 105 321 61 360 50C389 42 415 56 426 80H512C556 80 592 116 592 160V208Z"]
  };
  var faEllipsis = {
    prefix: 'far',
    iconName: 'ellipsis',
    icon: [512, 512, [], "f141", "M400 256C400 282 422 304 448 304S496 282 496 256S474 208 448 208S400 230 400 256ZM112 256C112 230 90 208 64 208S16 230 16 256S38 304 64 304S112 282 112 256ZM304 256C304 230 282 208 256 208S208 230 208 256S230 304 256 304S304 282 304 256Z"]
  };
  var faEllipsisStroke = {
    prefix: 'far',
    iconName: 'ellipsis-stroke',
    icon: [512, 512, [], "f39b", "M256 176C212 176 176 212 176 256S212 336 256 336C300 336 336 300 336 256S300 176 256 176ZM256 288C238 288 224 274 224 256S238 224 256 224S288 238 288 256S274 288 256 288ZM432 176C388 176 352 212 352 256S388 336 432 336C476 336 512 300 512 256S476 176 432 176ZM432 288C414 288 400 274 400 256S414 224 432 224S464 238 464 256S450 288 432 288ZM80 176C36 176 0 212 0 256S36 336 80 336C124 336 160 300 160 256S124 176 80 176ZM80 288C62 288 48 274 48 256S62 224 80 224S112 238 112 256S98 288 80 288Z"]
  };
  var faEllipsisStrokeVertical = {
    prefix: 'far',
    iconName: 'ellipsis-stroke-vertical',
    icon: [256, 512, [], "f39c", "M208 256C208 212 172 176 128 176S48 212 48 256C48 300 84 336 128 336S208 300 208 256ZM96 256C96 238 110 224 128 224S160 238 160 256S146 288 128 288S96 274 96 256ZM208 432C208 388 172 352 128 352S48 388 48 432C48 476 84 512 128 512S208 476 208 432ZM96 432C96 414 110 400 128 400S160 414 160 432S146 464 128 464S96 450 96 432ZM208 80C208 36 172 0 128 0S48 36 48 80C48 124 84 160 128 160S208 124 208 80ZM96 80C96 62 110 48 128 48S160 62 160 80S146 112 128 112S96 98 96 80Z"]
  };
  var faEllipsisVertical = {
    prefix: 'far',
    iconName: 'ellipsis-vertical',
    icon: [128, 512, [], "f142", "M64 112C90 112 112 90 112 64S90 16 64 16S16 38 16 64S38 112 64 112ZM64 400C38 400 16 422 16 448S38 496 64 496S112 474 112 448S90 400 64 400ZM64 208C38 208 16 230 16 256S38 304 64 304S112 282 112 256S90 208 64 208Z"]
  };
  var faEmptySet = {
    prefix: 'far',
    iconName: 'empty-set',
    icon: [512, 512, [], "f656", "M505 0C496 -9 480 -9 471 0L396 75C358 44 309 25 256 25C132 25 32 125 32 249C32 302 51 351 82 389L7 464C-2 473 -2 489 7 498C12 503 18 505 24 505S36 503 41 498L116 423C154 454 203 473 256 473C380 473 480 373 480 249C480 196 461 147 430 109L505 34C514 25 514 9 505 0ZM80 249C80 152 159 73 256 73C296 73 333 86 362 109L116 355C93 326 80 289 80 249ZM432 249C432 346 353 425 256 425C216 425 179 411 150 389L396 143C418 172 432 209 432 249Z"]
  };
  var faEngine = {
    prefix: 'far',
    iconName: 'engine',
    icon: [640, 512, [], "e123", "M192 232A24 24 0 1 0 216 256A24 24 0 0 0 192 232ZM592 192H560A48 48 0 0 0 512 240V256H496V208A16 16 0 0 0 490 196L419 138C410 132 416 128 405 128H312V112H376A24 24 0 0 0 376 64H200A24 24 0 0 0 200 112H264V128H128A48 48 0 0 0 80 176V232H48V152A24 24 0 0 0 0 152V360A24 24 0 0 0 48 360V280H80V336A48 48 0 0 0 128 384H169L219 434A48 48 0 0 0 253 448H448A48 48 0 0 0 496 400V384H512V400A48 48 0 0 0 560 448H592A48 48 0 0 0 640 400V240A48 48 0 0 0 592 192ZM448 400H253L203 350L189 336H128V176H389L448 223ZM592 400H560V336H496V304H560V240H592ZM288 232A24 24 0 1 0 312 256A24 24 0 0 0 288 232ZM360 256A24 24 0 1 0 384 232A24 24 0 0 0 360 256Z"]
  };
  var faEngineWarning = {
    prefix: 'far',
    iconName: 'engine-warning',
    icon: [640, 512, [], "f5f2", "M288 384A32 32 0 1 0 320 416A32 32 0 0 0 288 384ZM288 352A24 24 0 0 0 312 328V216A24 24 0 0 0 264 216V328A24 24 0 0 0 288 352ZM592 192H560A48 48 0 0 0 512 240V256H496V208A16 16 0 0 0 490 196L419 138A48 48 0 0 0 389 128H312V112H376A24 24 0 0 0 376 64H200A24 24 0 0 0 200 112H264V128H128A48 48 0 0 0 80 176V232H48V152A24 24 0 0 0 0 152V360A24 24 0 0 0 48 360V280H80V336A48 48 0 0 0 128 384H169L219 434A48 48 0 0 0 229 441A64 64 0 0 1 234 381L189 336H128V176H389L448 223V400H350A63 63 0 0 1 352 416A64 64 0 0 1 343 448H448A48 48 0 0 0 496 400V384H512V400A48 48 0 0 0 560 448H592A48 48 0 0 0 640 400V240A48 48 0 0 0 592 192ZM592 400H560V336H496V304H560V240H592Z"]
  };
  var faEnvelope = {
    prefix: 'far',
    iconName: 'envelope',
    icon: [512, 512, [], "f0e0", "M448 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H448C483 448 512 419 512 384V128C512 93 483 64 448 64ZM64 112H448C457 112 464 119 464 128V150L297 289C274 308 238 308 215 289L48 150V128C48 119 55 112 64 112ZM448 400H64C55 400 48 393 48 384V213L184 326C204 343 230 352 256 352S308 343 328 326L464 213V384C464 393 457 400 448 400Z"]
  };
  var faEnvelopeDot = {
    prefix: 'far',
    iconName: 'envelope-dot',
    icon: [576, 512, [], "e124", "M480 0C445 0 416 29 416 64C416 99 445 128 480 128S544 99 544 64C544 29 515 0 480 0ZM456 157L297 289C274 308 238 308 215 289L48 150V128C48 119 55 112 64 112H397C389 98 384 82 384 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H448C483 448 512 419 512 384V154C502 158 491 160 480 160C472 160 464 159 456 157ZM464 384C464 393 457 400 448 400H64C55 400 48 393 48 384V213L184 326C204 343 230 352 256 352S308 343 328 326L464 213V384Z"]
  };
  var faEnvelopeOpen = {
    prefix: 'far',
    iconName: 'envelope-open',
    icon: [512, 512, [], "f2b6", "M494 163C469 143 448 128 329 41C313 29 280 0 256 0C256 0 256 0 256 0C256 0 256 0 256 0C232 0 199 29 183 41C64 128 43 143 18 163C7 172 0 186 0 201V448C0 483 29 512 64 512H448C483 512 512 483 512 448V201C512 186 505 172 494 163ZM464 448C464 457 457 464 448 464H64C55 464 48 457 48 448V277L184 390C204 407 230 416 256 416S308 407 328 390L464 277V448ZM464 214L297 353C274 372 238 372 215 353L48 214V208H48L48 201C71 182 90 168 211 80C214 78 218 75 222 72C229 66 247 53 256 49C265 53 283 66 290 72C294 75 298 78 301 80C422 168 441 182 464 201V214Z"]
  };
  var faEnvelopeOpenDollar = {
    prefix: 'far',
    iconName: 'envelope-open-dollar',
    icon: [512, 512, [], "f657", "M257 304C268 304 277 295 277 284V274C300 269 315 255 319 234C327 191 285 179 263 173L257 171C234 164 234 161 235 157C236 149 251 147 265 149C271 150 277 152 283 154C293 157 305 152 308 141C312 131 306 120 296 116C289 113 283 112 277 111V100C277 89 268 80 257 80S237 89 237 100V110C215 115 199 129 195 150C188 193 229 204 246 210L252 211C281 220 281 222 280 227C278 235 263 237 249 235C242 234 234 231 226 228L221 226C211 223 199 228 196 239C192 249 198 261 208 264L212 266C220 269 229 271 237 273V284C237 295 246 304 257 304ZM477 214L477 214C469 214 461 217 454 222L297 353C275 372 237 372 215 353L58 222C51 217 43 214 35 214H35C16 214 0 230 0 249V448C0 483 29 512 64 512H448C483 512 512 483 512 448V249C512 230 496 214 477 214ZM464 448C464 457 457 464 448 464H64C55 464 48 457 48 448V277L184 390C204 407 230 416 256 416S308 407 328 390L464 277V448ZM112 226V56C112 52 116 48 120 48H392C396 48 400 52 400 56V226L434 198C438 194 443 191 448 189V56C448 25 423 0 392 0H120C89 0 64 25 64 56V189C69 191 74 194 78 198L112 226Z"]
  };
  var faEnvelopeOpenText = {
    prefix: 'far',
    iconName: 'envelope-open-text',
    icon: [512, 512, [], "f658", "M477 214L477 214C469 214 461 217 454 222L297 353C275 372 237 372 215 353L58 222C51 217 43 214 35 214H35C16 214 0 230 0 249V448C0 483 29 512 64 512H448C483 512 512 483 512 448V249C512 230 496 214 477 214ZM464 448C464 457 457 464 448 464H64C55 464 48 457 48 448V277L184 390C204 407 230 416 256 416S308 407 328 390L464 277V448ZM112 226V56C112 52 116 48 120 48H392C396 48 400 52 400 56V226L434 198C438 194 443 191 448 189V56C448 25 423 0 392 0H120C89 0 64 25 64 56V189C69 191 74 194 78 198L112 226ZM328 96H184C171 96 160 107 160 120C160 133 171 144 184 144H328C341 144 352 133 352 120C352 107 341 96 328 96ZM328 176H184C171 176 160 187 160 200C160 213 171 224 184 224H328C341 224 352 213 352 200C352 187 341 176 328 176Z"]
  };
  var faEnvelopes = {
    prefix: 'far',
    iconName: 'envelopes',
    icon: [640, 512, [], "e125", "M544 32H192C157 32 128 61 128 96V320C128 355 157 384 192 384H544C579 384 608 355 608 320V96C608 61 579 32 544 32ZM560 320C560 329 553 336 544 336H192C183 336 176 329 176 320V162L296 262C316 279 342 288 368 288S420 279 440 262L560 162V320ZM560 99L409 225C386 244 350 244 327 225L176 99V96C176 87 183 80 192 80H544C553 80 560 87 560 96V99ZM80 400V96C54 96 32 118 32 144V416C32 451 61 480 96 480H464C490 480 512 458 512 432H112C94 432 80 418 80 400Z"]
  };
  var faEnvelopesBulk = {
    prefix: 'far',
    iconName: 'envelopes-bulk',
    icon: [640, 512, [], "f674", "M592 128H272C246 128 224 150 224 176V192H272V176H592V368H416V416H592C618 416 640 394 640 368V176C640 150 618 128 592 128ZM112 48H432V96H480V48C480 22 458 0 432 0H112C86 0 64 22 64 48V192H112V48ZM336 224H48C22 224 0 246 0 272V464C0 490 22 512 48 512H336C362 512 384 490 384 464V272C384 246 362 224 336 224ZM336 464H48V344C62 355 128 402 128 402C142 413 167 432 192 432S242 413 256 402C256 402 322 355 336 344V464ZM336 285C334 287 224 367 219 371C210 377 200 384 192 384C183 384 169 374 161 366C157 364 50 284 48 282V272H336V285ZM496 208V272H560V208H496Z"]
  };
  var faEquals = {
    prefix: 'far',
    iconName: 'equals',
    icon: [448, 512, [], "f52c", "M408 328H40C27 328 16 339 16 352S27 376 40 376H408C421 376 432 365 432 352S421 328 408 328ZM40 184H408C421 184 432 173 432 160S421 136 408 136H40C27 136 16 147 16 160S27 184 40 184Z"]
  };
  var faEraser = {
    prefix: 'far',
    iconName: 'eraser',
    icon: [512, 512, [], "f12d", "M498 260C517 241 517 211 498 192L338 32C319 13 289 13 270 32L14 288C-5 307 -5 337 14 356L110 452C119 461 131 466 144 466L488 466C501 466 512 455 512 442V442C512 429 501 418 488 418L340 418L498 260ZM144 418L48 322L167 203L327 363L272 418H144Z"]
  };
  var faEthernet = {
    prefix: 'far',
    iconName: 'ethernet',
    icon: [512, 512, [], "f796", "M480 192H448V160C448 142 434 128 416 128H384V96C384 78 370 64 352 64H160C142 64 128 78 128 96V128H96C78 128 64 142 64 160V192H32C14 192 0 206 0 224V416C0 434 14 448 32 448H480C498 448 512 434 512 416V224C512 206 498 192 480 192ZM464 400H424V344C424 331 413 320 400 320S376 331 376 344V400H328V344C328 331 317 320 304 320S280 331 280 344V400H232V344C232 331 221 320 208 320S184 331 184 344V400H136V344C136 331 125 320 112 320S88 331 88 344V400H48V240H96C105 240 112 233 112 224V176H160C169 176 176 169 176 160V112H336V160C336 169 343 176 352 176H400V224C400 233 407 240 416 240H464V400Z"]
  };
  var faEuroSign = {
    prefix: 'far',
    iconName: 'euro-sign',
    icon: [384, 512, [], "f153", "M351 447C354 460 346 473 333 475C318 478 302 480 287 480C229 480 172 457 129 414C104 389 87 360 76 328H56C43 328 32 317 32 304S43 280 56 280H66C64 264 64 248 66 232H56C43 232 32 221 32 208C32 195 43 184 56 184H76C87 152 104 123 129 98C183 44 259 21 333 37C346 39 354 52 352 65C349 78 336 86 323 84C265 72 205 90 163 132C148 147 136 165 128 184H280C293 184 304 195 304 208C304 221 293 232 280 232H114C112 248 112 264 114 280H264C277 280 288 291 288 304S277 328 264 328H128C136 347 148 365 163 380C205 422 265 440 323 428C336 426 349 434 351 447Z"]
  };
  var faExclamation = {
    prefix: 'far',
    iconName: 'exclamation',
    icon: [128, 512, [], "f12a", "M64 392C42 392 24 410 24 432S42 472 64 472S104 454 104 432S86 392 64 392ZM64 336C82 336 96 322 96 304V64C96 46 82 32 64 32S32 46 32 64V304C32 322 46 336 64 336Z"]
  };
  var faExpand = {
    prefix: 'far',
    iconName: 'expand',
    icon: [448, 512, [], "f065", "M136 32H24C11 32 0 43 0 56V168C0 181 11 192 24 192C37 192 48 181 48 168V80H136C149 80 160 69 160 56S149 32 136 32ZM424 32H312C299 32 288 43 288 56C288 69 299 80 312 80H400V168C400 181 411 192 424 192S448 181 448 168V56C448 43 437 32 424 32ZM136 432H48V344C48 331 37 320 24 320S0 331 0 344V456C0 469 11 480 24 480H136C149 480 160 469 160 456C160 443 149 432 136 432ZM424 320C411 320 400 331 400 344V432H312C299 432 288 443 288 456S299 480 312 480H424C437 480 448 469 448 456V344C448 331 437 320 424 320Z"]
  };
  var faExpandWide = {
    prefix: 'far',
    iconName: 'expand-wide',
    icon: [512, 512, [], "f320", "M136 400H48V312C48 299 37 288 24 288S0 299 0 312V424C0 437 11 448 24 448H136C149 448 160 437 160 424C160 411 149 400 136 400ZM136 64H24C11 64 0 75 0 88V200C0 213 11 224 24 224C37 224 48 213 48 200V112H136C149 112 160 101 160 88S149 64 136 64ZM488 64H376C363 64 352 75 352 88C352 101 363 112 376 112H464V200C464 213 475 224 488 224S512 213 512 200V88C512 75 501 64 488 64ZM488 288C475 288 464 299 464 312V400H376C363 400 352 411 352 424S363 448 376 448H488C501 448 512 437 512 424V312C512 299 501 288 488 288Z"]
  };
  var faEye = {
    prefix: 'far',
    iconName: 'eye',
    icon: [576, 512, [], "f06e", "M573 239C518 116 411 32 288 32S58 116 3 239C2 243 0 251 0 256C0 261 2 269 3 273C58 396 165 480 288 480S518 396 573 273C574 269 576 261 576 256C576 251 574 243 573 239ZM288 432C189 432 97 365 48 256C97 147 189 80 288 80C387 80 479 147 528 256C479 365 387 432 288 432ZM288 128C217 128 160 185 160 256S217 384 288 384H288C359 384 416 327 416 256V256C416 185 359 128 288 128ZM288 336C244 336 208 300 208 256C208 255 208 255 208 254C213 255 219 256 224 256C259 256 288 227 288 192C288 187 287 181 286 176C287 176 287 176 288 176C332 176 368 212 368 256C368 300 332 336 288 336Z"]
  };
  var faEyeDropper = {
    prefix: 'far',
    iconName: 'eye-dropper',
    icon: [512, 512, [], "f1fb", "M137 435C134 438 130 439 126 439H73V386C73 382 74 378 77 375L219 233L185 199L43 341C31 353 25 369 25 386V431L4 468C-3 479 -1 494 9 503C18 513 33 515 44 508L81 487H126C143 487 159 481 171 469L313 327L279 294L137 435ZM484 28C446 -9 386 -9 348 28L237 139L225 127C216 118 201 118 191 127S182 151 191 161L351 321C356 325 362 328 368 328S380 325 385 321C394 311 394 296 385 287L373 275L484 164C521 126 521 66 484 28Z"]
  };
  var faEyeDropperFull = {
    prefix: 'far',
    iconName: 'eye-dropper-full',
    icon: [512, 512, [], "e126", "M484 28C446 -9 386 -9 348 28L237 139L225 127C216 118 201 118 191 127S182 151 191 161L351 321C356 325 362 328 368 328S380 325 385 321C394 311 394 296 385 287L373 275L484 164C521 126 521 66 484 28ZM43 341C31 353 25 369 25 386V431L4 468C-3 479 -1 494 9 503C18 513 33 515 44 508L81 487H126C143 487 159 481 171 469L313 327L185 199L43 341Z"]
  };
  var faEyeDropperHalf = {
    prefix: 'far',
    iconName: 'eye-dropper-half',
    icon: [512, 512, [], "e127", "M252 320H132L219 233L185 199L43 341C31 353 25 369 25 386V431L4 468C-3 479 -1 494 9 503C18 513 33 515 44 508L81 487H126C143 487 159 481 171 469L313 327L279 294L252 320ZM484 28C446 -9 386 -9 348 28L237 139L225 127C216 118 201 118 191 127S182 151 191 161L351 321C356 325 362 328 368 328S380 325 385 321C394 311 394 296 385 287L373 275L484 164C521 126 521 66 484 28Z"]
  };
  var faEyeEvil = {
    prefix: 'far',
    iconName: 'eye-evil',
    icon: [640, 512, [], "f6db", "M610 218L516 192C530 169 557 128 557 128C566 113 565 96 554 82C543 69 525 63 508 69L406 105C402 104 398 102 394 101L357 24C350 9 336 0 320 0S290 9 283 23L246 101C242 102 238 104 234 105L132 69C115 63 97 69 86 82C75 96 74 113 83 128C83 128 110 169 124 192L30 218C12 222 0 238 0 256S12 290 30 294L124 320C117 331 105 351 83 384C74 399 75 416 86 430C97 443 115 449 132 443L234 407C238 408 242 410 246 411L283 488C290 503 304 512 320 512S350 503 357 489L394 411C398 410 402 408 406 407L508 443C525 449 543 443 554 430C565 416 566 399 557 384C535 351 523 331 516 320L610 295C628 290 640 274 640 256C640 238 628 222 610 218ZM486 278L481 285C477 290 472 296 467 302L456 316L466 331C468 334 490 368 504 390L404 355L395 359C387 363 378 366 370 369L360 372L320 455L280 372L270 369C262 366 253 363 245 359L236 355L136 390C150 368 172 334 174 331L185 316L173 302C168 296 163 290 159 285L154 278L72 256L154 234L159 228C163 222 168 216 173 210L184 197L175 182C173 180 151 145 136 122L236 157L245 153C253 149 262 146 270 143L280 140L320 57L360 140L370 143C378 146 387 149 395 153L404 157L504 122C489 145 467 180 465 182L456 197L467 211C473 216 477 222 481 228L486 234L568 256L486 278ZM391 201C387 201 384 201 380 203C362 209 342 213 320 213C298 213 278 209 259 203C256 201 253 201 249 201C235 201 222 210 219 224C216 238 215 253 218 268C226 310 260 344 302 351C308 352 314 352 320 352C378 352 424 306 424 248C424 241 423 234 422 227C419 212 405 201 391 201ZM320 304C317 304 313 304 310 303C288 300 269 281 265 259C265 257 265 256 264 254C276 258 289 259 302 260L320 288L338 260C351 259 364 258 376 254C372 282 349 304 320 304Z"]
  };
  var faEyeLowVision = {
    prefix: 'far',
    iconName: 'eye-low-vision',
    icon: [640, 512, [], "f2a8", "M631 469L527 388C559 356 585 317 605 273C606 269 608 261 608 256C608 251 606 243 605 239C550 116 443 32 320 32C257 32 199 54 149 92L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM394 284L313 220C317 211 320 202 320 192C320 187 319 181 318 176C319 176 319 176 320 176C364 176 400 212 400 256C400 266 398 275 394 284ZM433 314C442 297 448 277 448 256V256C448 185 391 128 320 128C288 128 259 140 236 160L188 122C228 95 273 80 320 80C419 80 511 147 560 256C542 296 517 330 489 358L433 314ZM37 236L344 479C358 478 372 475 385 472L51 208C46 217 41 226 37 236ZM292 478L38 277C88 389 182 467 292 478ZM67 180L422 460C432 456 443 451 453 445L85 155C79 163 73 172 67 180Z"]
  };
  var faEyeSlash = {
    prefix: 'far',
    iconName: 'eye-slash',
    icon: [640, 512, [], "f070", "M631 469L527 388C559 356 585 317 605 273C606 269 608 261 608 256C608 251 606 243 605 239C550 116 443 32 320 32C257 32 199 54 149 92L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM394 284L313 220C317 211 320 202 320 192C320 187 319 181 318 176C319 176 319 176 320 176C364 176 400 212 400 256C400 266 398 275 394 284ZM433 314C442 297 448 277 448 256V256C448 185 391 128 320 128C288 128 259 140 236 160L188 122C228 95 273 80 320 80C419 80 511 147 560 256C542 296 517 330 489 358L433 314ZM320 384C333 384 346 381 358 378L303 334C279 329 259 313 249 292L193 248C193 251 192 253 192 256C192 327 249 384 320 384H320ZM320 432C221 432 129 365 80 256C91 232 105 210 119 190L81 160C64 184 48 210 35 239C34 243 32 251 32 256C32 261 34 269 35 273C90 396 197 480 320 480C365 480 409 469 448 448L405 414C378 425 349 432 320 432Z"]
  };
  var faF = {
    prefix: 'far',
    iconName: 'f',
    icon: [320, 512, [], "e128", "M320 64C320 82 306 96 288 96H64V224H223C241 224 255 238 255 256S241 288 223 288H64V448C64 466 50 480 32 480S0 466 0 448V64C0 46 14 32 32 32H288C306 32 320 46 320 64Z"]
  };
  var faFaceAngry = {
    prefix: 'far',
    iconName: 'face-angry',
    icon: [512, 512, [], "f556", "M256 312C222 312 191 327 169 353C161 363 162 378 172 386S198 394 206 383C231 354 281 354 306 383C314 393 329 395 340 386C350 378 351 363 343 353C321 327 290 312 256 312ZM407 185C403 172 390 165 377 169L297 193C284 197 277 210 281 223C284 233 294 240 304 240C304 258 318 272 336 272C354 272 368 258 368 240C368 234 366 228 363 223L391 215C404 211 411 198 407 185ZM208 240C218 240 228 233 231 223C235 210 228 197 215 193L135 169C122 165 109 172 105 185C101 198 108 211 121 215L149 224C146 228 144 234 144 240C144 258 158 272 176 272C194 272 208 258 208 240ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceDizzy = {
    prefix: 'far',
    iconName: 'face-dizzy',
    icon: [512, 512, [], "f567", "M222 238C230 230 230 218 222 210L204 192L222 174C230 166 230 154 222 146C214 138 202 138 194 146L176 164L158 146C150 138 138 138 130 146C122 154 122 166 130 174L148 192L130 210C122 218 122 230 130 238C138 246 150 246 158 238L176 220L194 238C202 246 214 246 222 238ZM256 272C221 272 192 301 192 336S221 400 256 400S320 371 320 336S291 272 256 272ZM382 146C374 138 362 138 354 146L336 164L318 146C310 138 298 138 290 146C282 154 282 166 290 174L308 192L290 210C282 218 282 231 290 238C298 246 310 246 318 238L336 221L354 238C362 246 374 246 382 238C390 231 390 218 382 210L364 192L382 174C390 166 390 154 382 146ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceFlushed = {
    prefix: 'far',
    iconName: 'face-flushed',
    icon: [512, 512, [], "f579", "M160 200C147 200 136 211 136 224S147 248 160 248S184 237 184 224S173 200 160 200ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM232 224C232 184 200 152 160 152C120 152 88 184 88 224C88 264 120 296 160 296C200 296 232 264 232 224ZM160 264C138 264 120 246 120 224C120 202 138 184 160 184C182 184 200 202 200 224C200 246 182 264 160 264ZM352 200C339 200 328 211 328 224S339 248 352 248S376 237 376 224S365 200 352 200ZM352 152C312 152 280 184 280 224C280 264 312 296 352 296C392 296 424 264 424 224C424 184 392 152 352 152ZM352 264C330 264 312 246 312 224C312 202 330 184 352 184C374 184 392 202 392 224C392 246 374 264 352 264ZM312 336H200C187 336 176 347 176 360S187 384 200 384H312C325 384 336 373 336 360S325 336 312 336Z"]
  };
  var faFaceFrown = {
    prefix: 'far',
    iconName: 'face-frown',
    icon: [512, 512, [], "f119", "M256 304C216 304 178 322 152 353C144 363 145 378 155 386C166 395 181 394 189 383C206 363 230 352 256 352S306 363 323 383C331 393 346 395 357 386C367 378 368 363 360 353C334 322 296 304 256 304ZM176 240C194 240 208 226 208 208S194 176 176 176C158 176 144 190 144 208S158 240 176 240ZM336 176C318 176 304 190 304 208S318 240 336 240C354 240 368 226 368 208S354 176 336 176ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceFrownOpen = {
    prefix: 'far',
    iconName: 'face-frown-open',
    icon: [512, 512, [], "f57a", "M256 288C220 288 167 309 160 349C158 361 169 371 181 367C212 358 240 352 256 352S300 358 331 367C343 371 354 361 352 349C345 309 292 288 256 288ZM208 208C208 190 194 176 176 176C158 176 144 190 144 208S158 240 176 240C194 240 208 226 208 208ZM336 176C318 176 304 190 304 208S318 240 336 240C354 240 368 226 368 208S354 176 336 176ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceGrimace = {
    prefix: 'far',
    iconName: 'face-grimace',
    icon: [512, 512, [], "f57f", "M336 240C354 240 368 226 368 208S354 176 336 176C318 176 304 190 304 208S318 240 336 240ZM176 240C194 240 208 226 208 208S194 176 176 176C158 176 144 190 144 208S158 240 176 240ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448ZM336 272H176C150 272 128 293 128 320V336C128 362 150 384 176 384H336C362 384 384 362 384 336V320C384 294 362 272 336 272ZM184 352H176C167 352 160 345 160 336V320C160 311 167 304 176 304H184V352ZM240 352H216V304H240V352ZM296 352H272V304H296V352ZM352 336C352 345 345 352 336 352H328V304H336C345 304 352 311 352 320V336Z"]
  };
  var faFaceGrin = {
    prefix: 'far',
    iconName: 'face-grin',
    icon: [640, 512, [], "f580", "M-1296 240C-1278 240 -1264 226 -1264 208S-1278 176 -1296 176C-1314 176 -1328 190 -1328 208S-1314 240 -1296 240ZM-1136 240C-1118 240 -1104 226 -1104 208S-1118 176 -1136 176C-1154 176 -1168 190 -1168 208S-1154 240 -1136 240ZM-1110 305C-1136 313 -1175 318 -1216 318S-1296 313 -1322 305C-1332 302 -1341 310 -1339 320C-1331 367 -1268 400 -1216 400S-1101 367 -1093 320C-1091 310 -1100 302 -1110 305ZM-1216 16C-1349 16 -1456 123 -1456 256S-1349 496 -1216 496S-976 389 -976 256S-1083 16 -1216 16ZM-1216 448C-1322 448 -1408 362 -1408 256S-1322 64 -1216 64S-1024 150 -1024 256S-1110 448 -1216 448ZM320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 448C214 448 128 362 128 256S214 64 320 64S512 150 512 256S426 448 320 448ZM426 305C400 313 361 318 320 318S240 313 214 305C204 302 195 310 197 320C205 367 268 400 320 400S435 367 443 320C445 310 436 302 426 305ZM272 248C285 229 287 211 288 192C288 173 285 155 272 136C264 124 247 125 240 136C227 155 224 173 224 192C224 211 227 229 240 248C248 260 265 259 272 248ZM400 248C413 229 415 211 416 192C416 173 413 155 400 136C392 124 375 125 368 136C355 155 352 173 352 192C352 211 355 229 368 248C376 260 393 259 400 248Z"]
  };
  var faFaceGrinBeam = {
    prefix: 'far',
    iconName: 'face-grin-beam',
    icon: [512, 512, [], "f582", "M362 305C336 313 297 318 256 318S176 313 150 305C141 302 131 310 133 320C141 367 204 400 256 400S371 367 379 320C381 310 372 302 362 305ZM336 152C312 152 283 181 280 223C280 227 282 231 286 232C289 233 293 231 295 228L305 211C312 197 324 189 336 189C348 189 360 197 368 211L377 228C379 232 383 233 386 232C390 231 392 227 392 223C389 181 360 152 336 152ZM144 211C152 197 164 189 176 189C188 189 200 197 207 211L217 228C219 232 223 233 226 232C230 231 232 227 232 223C229 181 200 152 176 152C152 152 123 181 120 223C120 227 122 231 126 232C129 233 133 231 135 228L144 211ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceGrinBeamSweat = {
    prefix: 'far',
    iconName: 'face-grin-beam-sweat',
    icon: [512, 512, [], "f583", "M160 186C172 186 184 194 191 207L201 224C203 228 207 229 210 228C214 227 216 224 216 220C213 178 184 148 160 148C136 148 107 178 104 220C104 223 106 227 110 228C113 229 117 228 119 224L128 207C136 194 148 186 160 186ZM240 396C292 396 355 363 363 316C365 306 356 298 346 301C320 309 281 314 240 314S160 309 134 301C125 298 115 306 117 316C125 363 188 396 240 396ZM376 220C373 178 344 148 320 148C296 148 267 178 264 220C264 223 266 227 270 228C273 229 277 228 279 224L289 207C296 194 308 186 320 186C332 186 344 194 352 207L361 224C363 228 367 229 370 228C374 227 376 224 376 220ZM440 172C430 172 421 170 412 167C425 193 432 222 432 252C432 358 346 444 240 444S48 358 48 252S134 60 240 60C282 60 321 74 353 97C353 94 352 91 352 87C352 76 356 63 364 47C328 25 285 12 240 12C107 12 0 120 0 252S107 492 240 492S480 385 480 252C480 223 474 195 465 168C457 171 449 172 440 172ZM440 140C471 140 496 117 496 87C496 65 463 20 447 0C444 -5 436 -5 433 0C417 20 384 65 384 87C384 117 409 140 440 140Z"]
  };
  var faFaceGrinHearts = {
    prefix: 'far',
    iconName: 'face-grin-hearts',
    icon: [512, 512, [], "f584", "M209 256C213 257 218 254 219 250L239 180C244 159 231 139 210 135C191 132 174 145 168 163L166 170L159 168C141 164 121 173 114 190C107 211 118 232 139 238L209 256ZM362 305C336 313 297 318 256 318S176 313 150 305C141 302 131 310 133 320C141 367 204 400 256 400S371 367 379 320C381 310 372 302 362 305ZM398 190C391 173 371 164 353 168L346 170L344 163C339 145 321 132 302 135C281 139 268 159 273 180L293 250C294 254 299 257 303 256L373 238C394 232 405 211 398 190ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceGrinSquint = {
    prefix: 'far',
    iconName: 'face-grin-squint',
    icon: [512, 512, [], "f585", "M362 305C336 313 297 318 256 318S176 313 150 305C140 302 131 310 133 320C141 367 204 400 256 400S371 367 379 320C381 310 372 302 362 305ZM142 266L222 218C226 216 228 212 228 208S226 200 222 198L142 150C137 147 131 148 127 152C123 157 123 163 127 168L160 208L127 248C123 253 123 259 127 264C131 268 137 270 142 266ZM385 152C381 148 375 147 370 150L290 198C286 200 284 204 284 208S286 216 290 218L370 266C375 270 381 268 385 264C389 259 389 253 385 248L352 208L385 168C389 163 389 157 385 152ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceGrinSquintTears = {
    prefix: 'far',
    iconName: 'face-grin-squint-tears',
    icon: [512, 512, [], "f586", "M300 300C271 329 240 352 216 365C207 370 206 382 214 388C253 416 321 395 358 358C394 321 416 253 388 214C383 206 370 206 365 216C353 240 329 270 300 300ZM208 236C205 233 201 232 197 233L106 256C100 257 97 262 97 268C97 274 102 279 108 279L160 284L165 336C165 342 170 347 176 347H177C182 347 187 344 189 338L211 248C212 243 211 239 208 236ZM248 211L338 189C344 187 348 182 347 176C347 170 342 165 336 165L284 160L279 108C279 102 274 97 268 97C263 97 257 100 256 106L233 197C232 201 233 205 236 208C241 213 248 211 248 211ZM428 155C446 185 456 219 456 256C456 366 366 456 256 456C219 456 185 446 155 428C151 448 147 464 143 476C177 494 215 504 256 504C393 504 504 393 504 256C504 215 494 177 477 143C464 147 449 151 428 155ZM84 357C66 327 56 293 56 256C56 146 146 56 256 56C293 56 327 66 357 84C361 64 365 48 369 36C335 18 297 8 256 8C119 8 8 119 8 256C8 297 18 335 36 369C48 365 64 361 84 357ZM395 128C421 124 479 114 496 97C518 75 517 39 495 17C473 -5 437 -6 415 16C398 33 388 91 384 117C383 123 389 129 395 128ZM117 384C91 388 33 398 16 415C-6 437 -5 473 17 495C39 517 75 518 97 496C114 479 124 421 128 395C129 389 123 383 117 384Z"]
  };
  var faFaceGrinStars = {
    prefix: 'far',
    iconName: 'face-grin-stars',
    icon: [512, 512, [], "f587", "M134 247C133 253 139 258 145 255L176 239L207 255C213 258 219 253 218 247L212 212L238 188C242 183 240 175 233 174L198 169L183 138C180 132 172 132 169 138L154 169L119 174C113 175 110 183 114 188L140 212L134 247ZM362 305C336 313 297 318 256 318S176 313 150 305C141 302 131 310 133 320C141 367 204 400 256 400S371 367 379 320C381 310 372 302 362 305ZM393 174L358 169L343 138C340 132 332 132 329 138L314 169L279 174C272 175 270 183 274 188L300 212L294 247C293 253 299 258 305 255L336 239L367 255C373 258 379 253 378 247L372 212L398 188C402 183 400 175 393 174ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceGrinTears = {
    prefix: 'far',
    iconName: 'face-grin-tears',
    icon: [640, 512, [], "f588", "M320 448C243 448 177 402 146 337C136 373 125 385 121 390C164 454 237 496 320 496C403 496 476 454 519 390C515 385 504 373 494 337C463 402 397 448 320 448ZM115 224L118 224C123 224 127 225 131 226C145 134 224 64 320 64C416 64 495 134 509 226C513 225 517 224 522 224H524L527 224C539 226 549 228 558 230C545 109 444 16 320 16S95 109 82 230C91 228 101 226 113 224L115 224ZM240 189C252 189 264 197 271 211L281 228C283 232 287 233 290 232C294 231 296 227 296 223C293 181 264 152 240 152C216 152 187 181 184 223C184 227 186 231 190 232C193 233 197 231 199 228L209 211C216 197 228 189 240 189ZM320 400C372 400 435 367 443 320C445 310 436 302 426 305C400 313 361 318 320 318S240 313 214 305C205 302 195 310 197 320C205 367 268 400 320 400ZM117 256C91 260 33 270 16 287C-6 309 -5 345 17 367S75 390 97 368C114 351 124 293 128 267C129 261 123 255 117 256ZM456 223C453 181 424 152 400 152C376 152 347 181 344 223C344 227 346 231 350 232C353 233 357 231 359 228L369 211C376 197 388 189 400 189C412 189 424 197 431 211L441 228C443 232 447 233 450 232C454 231 456 227 456 223ZM624 287C607 270 549 260 523 256C517 255 511 261 512 267C516 293 526 351 543 368C565 390 601 389 623 367C645 345 646 309 624 287Z"]
  };
  var faFaceGrinTongue = {
    prefix: 'far',
    iconName: 'face-grin-tongue',
    icon: [512, 512, [], "f589", "M176 176C158 176 144 190 144 208S158 240 176 240C194 240 208 226 208 208S194 176 176 176ZM336 176C318 176 304 190 304 208S318 240 336 240C354 240 368 226 368 208S354 176 336 176ZM256 16C123 16 16 123 16 256C16 367 91 460 193 487C209 502 231 512 255 512H255C280 512 302 502 320 487C421 459 496 366 496 256C496 123 389 16 256 16ZM320 416C320 452 291 481 255 480C220 479 192 450 192 415V364L210 355C225 348 241 357 245 372L247 384C249 393 263 393 265 384L267 372C271 357 287 348 302 355L320 364V416ZM351 422C352 420 352 418 352 416V364C366 352 376 337 379 320C381 310 372 302 362 305C336 313 297 318 256 318S176 313 150 305C140 302 131 310 133 320C136 337 146 352 160 364V415C160 418 160 420 161 422C103 389 64 327 64 256C64 150 150 64 256 64S448 150 448 256C448 327 409 389 351 422Z"]
  };
  var faFaceGrinTongueSquint = {
    prefix: 'far',
    iconName: 'face-grin-tongue-squint',
    icon: [512, 512, [], "f58a", "M142 150C137 147 131 148 127 152C123 157 123 163 127 168L160 208L127 248C123 253 123 259 127 264C131 268 137 270 142 266L222 218C226 216 228 212 228 208S226 200 222 198L142 150ZM256 16C123 16 16 123 16 256C16 367 91 460 193 487C209 502 231 512 255 512H255C280 512 302 502 320 487C421 459 496 366 496 256C496 123 389 16 256 16ZM320 416C320 452 291 481 255 480C220 479 192 450 192 415V364L210 355C225 348 241 357 245 372L247 384C249 393 263 393 265 384L267 372C271 357 287 348 302 355L320 364V416ZM351 422C352 420 352 418 352 416V364C366 352 376 337 379 320C381 310 372 302 362 305C336 313 297 318 256 318S176 313 150 305C140 302 131 310 133 320C136 337 146 352 160 364V415C160 418 160 420 161 422C103 389 64 327 64 256C64 150 150 64 256 64S448 150 448 256C448 327 409 389 351 422ZM385 152C381 148 375 147 370 150L290 198C286 200 284 204 284 208S286 216 290 218L370 266C375 270 381 268 385 264C389 259 389 253 385 248L352 208L385 168C389 163 389 157 385 152Z"]
  };
  var faFaceGrinTongueWink = {
    prefix: 'far',
    iconName: 'face-grin-tongue-wink',
    icon: [512, 512, [], "f58b", "M160 180C134 180 104 197 100 222C99 227 102 232 106 234C111 237 116 236 120 233L129 224C144 211 176 211 190 224L200 233C202 235 208 238 214 234C218 232 221 227 220 222C216 197 186 180 160 180ZM256 16C123 16 16 123 16 256C16 367 91 460 193 487C209 502 231 512 255 512H255C280 512 302 502 320 487C421 459 496 366 496 256C496 123 389 16 256 16ZM320 416C320 452 291 481 255 480C220 479 192 450 192 415V364L210 355C225 348 241 357 245 372L247 384C249 393 263 393 265 384L267 372C271 357 287 348 302 355L320 364V416ZM351 422C352 420 352 418 352 416V364C366 352 376 337 379 320C381 310 372 302 362 305C336 313 297 318 256 318S176 313 150 305C140 302 131 310 133 320C136 337 146 352 160 364V415C160 418 160 420 161 422C103 389 64 327 64 256C64 150 150 64 256 64S448 150 448 256C448 327 409 389 351 422ZM336 184C323 184 312 195 312 208S323 232 336 232C349 232 360 221 360 208S349 184 336 184ZM336 128C292 128 256 164 256 208C256 252 292 288 336 288S416 252 416 208C416 164 380 128 336 128ZM336 256C310 256 288 234 288 208S310 160 336 160C362 160 384 182 384 208S362 256 336 256Z"]
  };
  var faFaceGrinWide = {
    prefix: 'far',
    iconName: 'face-grin-wide',
    icon: [640, 512, [], "f581", "M-1296 240C-1278 240 -1264 226 -1264 208S-1278 176 -1296 176C-1314 176 -1328 190 -1328 208S-1314 240 -1296 240ZM-1136 240C-1118 240 -1104 226 -1104 208S-1118 176 -1136 176C-1154 176 -1168 190 -1168 208S-1154 240 -1136 240ZM-1110 305C-1136 313 -1175 318 -1216 318S-1296 313 -1322 305C-1332 302 -1341 310 -1339 320C-1331 367 -1268 400 -1216 400S-1101 367 -1093 320C-1091 310 -1100 302 -1110 305ZM-1216 16C-1349 16 -1456 123 -1456 256S-1349 496 -1216 496S-976 389 -976 256S-1083 16 -1216 16ZM-1216 448C-1322 448 -1408 362 -1408 256S-1322 64 -1216 64S-1024 150 -1024 256S-1110 448 -1216 448ZM320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 448C214 448 128 362 128 256S214 64 320 64S512 150 512 256S426 448 320 448ZM426 305C400 313 361 318 320 318S240 313 214 305C204 302 195 310 197 320C205 367 268 400 320 400S435 367 443 320C445 310 436 302 426 305ZM272 248C285 229 287 211 288 192C288 173 285 155 272 136C264 124 247 125 240 136C227 155 224 173 224 192C224 211 227 229 240 248C248 260 265 259 272 248ZM400 248C413 229 415 211 416 192C416 173 413 155 400 136C392 124 375 125 368 136C355 155 352 173 352 192C352 211 355 229 368 248C376 260 393 259 400 248Z"]
  };
  var faFaceGrinWink = {
    prefix: 'far',
    iconName: 'face-grin-wink',
    icon: [512, 512, [], "f58c", "M176 240C194 240 208 226 208 208S194 176 176 176S144 190 144 208S158 240 176 240ZM362 305C336 313 297 318 256 318S176 313 150 305C140 302 131 310 133 320C141 367 204 400 256 400S371 367 379 320C381 310 372 302 362 305ZM336 180C310 180 280 197 276 222C274 233 288 240 296 233L306 224C320 211 352 211 366 224L376 233C384 240 398 233 396 222C392 197 362 180 336 180ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceKiss = {
    prefix: 'far',
    iconName: 'face-kiss',
    icon: [512, 512, [], "f596", "M277 344C299 335 312 321 312 308C312 289 283 266 241 264C237 264 233 266 232 270C231 274 233 278 237 279L254 287C267 292 275 300 275 308S267 324 254 330L237 337C231 339 231 349 237 352L254 359C267 364 275 372 275 380S267 396 254 402L237 409C233 411 231 414 232 418C233 422 236 424 240 424H241C283 422 312 400 312 380C312 367 299 353 277 344ZM176 176C158 176 144 190 144 208S158 240 176 240C194 240 208 226 208 208S194 176 176 176ZM336 176C318 176 304 190 304 208S318 240 336 240C354 240 368 226 368 208S354 176 336 176ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceKissBeam = {
    prefix: 'far',
    iconName: 'face-kiss-beam',
    icon: [512, 512, [], "f597", "M176 152C152 152 123 181 120 223C120 227 122 231 126 232C129 233 133 231 135 228L144 211C152 197 164 189 176 189C188 189 200 197 207 211L217 228C219 232 223 233 226 232C230 231 232 227 232 223C229 181 200 152 176 152ZM277 344C299 335 312 321 312 308C312 289 283 266 241 264C237 264 233 266 232 270C231 274 233 278 237 279L254 287C267 292 275 300 275 308S267 324 254 330L237 337C231 339 231 349 237 352L254 359C267 364 275 372 275 380S267 396 254 402L237 409C233 411 231 414 232 418C233 422 236 424 240 424H241C283 422 312 400 312 380C312 367 299 353 277 344ZM336 152C312 152 283 181 280 223C280 227 282 231 286 232C289 233 293 231 295 228L304 211C312 197 324 189 336 189C348 189 360 197 367 211L377 228C379 232 383 233 386 232C390 231 392 227 392 223C389 181 360 152 336 152ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceKissWinkHeart = {
    prefix: 'far',
    iconName: 'face-kiss-wink-heart',
    icon: [512, 512, [], "f598", "M296 308C296 289 267 266 224 264C221 264 217 266 216 270C215 274 217 278 221 279L238 287C251 292 259 300 259 308S251 324 238 330L221 337C215 339 215 349 221 352L238 359C251 364 259 372 259 380S251 396 238 402L221 409C217 411 215 414 216 418C217 422 220 424 224 424H225C267 422 296 400 296 380C296 367 283 353 261 344C283 335 296 321 296 308ZM240 448C134 448 48 362 48 256S134 64 240 64S432 150 432 256C432 274 429 292 424 309C441 314 455 325 465 340C474 314 480 286 480 256C480 123 373 16 240 16S0 123 0 256S107 496 240 496C279 496 316 486 349 470L336 422C308 438 275 448 240 448ZM128 208C128 226 142 240 160 240C178 240 192 226 192 208S178 176 160 176C142 176 128 190 128 208ZM380 222C376 197 346 180 320 180C294 180 264 197 260 222C258 233 272 240 280 233L290 224C304 211 336 211 350 224L360 233C368 240 382 233 380 222ZM509 402C501 382 477 371 455 377L447 379L444 370C438 349 417 334 394 337C369 341 353 366 360 390L383 473C385 478 390 481 396 480L480 458C505 452 518 426 509 402Z"]
  };
  var faFaceLaugh = {
    prefix: 'far',
    iconName: 'face-laugh',
    icon: [512, 512, [], "f599", "M336 224C354 224 368 210 368 192S354 160 336 160C318 160 304 174 304 192S318 224 336 224ZM176 224C194 224 208 210 208 192S194 160 176 160C158 160 144 174 144 192S158 224 176 224ZM370 288H142C133 288 127 295 128 303C136 362 187 408 249 408H263C325 408 376 362 384 303C385 295 379 288 370 288ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceLaughBeam = {
    prefix: 'far',
    iconName: 'face-laugh-beam',
    icon: [512, 512, [], "f59a", "M144 211C152 197 164 189 176 189C188 189 200 197 207 211L217 228C221 235 233 232 232 223C229 181 200 152 176 152C152 152 123 181 120 223C119 232 131 235 135 228L144 211ZM370 288H142C133 288 127 295 128 303C136 362 187 408 249 408H263C325 408 376 362 384 303C385 295 379 288 370 288ZM336 152C312 152 283 181 280 223C279 232 291 235 295 228L304 211C312 197 324 189 336 189C348 189 360 197 367 211L377 228C381 235 392 232 392 223C389 181 360 152 336 152ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceLaughSquint = {
    prefix: 'far',
    iconName: 'face-laugh-squint',
    icon: [512, 512, [], "f59b", "M370 288H142C133 288 127 295 128 303C136 362 187 408 249 408H263C325 408 376 362 384 303C385 295 379 288 370 288ZM142 254L222 206C230 202 230 190 222 186L142 138C131 131 118 145 127 156L160 196L127 236C118 247 131 261 142 254ZM370 138L290 186C282 190 282 202 290 206L370 254C381 261 394 247 385 236L352 196L385 156C394 145 381 131 370 138ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceLaughWink = {
    prefix: 'far',
    iconName: 'face-laugh-wink',
    icon: [512, 512, [], "f59c", "M370 288H142C133 288 127 295 128 303C136 362 187 408 249 408H263C325 408 376 362 384 303C385 295 379 288 370 288ZM176 224C194 224 208 210 208 192S194 160 176 160C158 160 144 174 144 192S158 224 176 224ZM336 164C310 164 280 181 276 206C274 217 288 224 296 217L305 208C320 195 352 195 366 208L376 217C384 224 398 217 396 206C392 181 362 164 336 164ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceMeh = {
    prefix: 'far',
    iconName: 'face-meh',
    icon: [512, 512, [], "f11a", "M176 240C194 240 208 226 208 208S194 176 176 176C158 176 144 190 144 208S158 240 176 240ZM344 320H168C155 320 144 331 144 344S155 368 168 368H344C357 368 368 357 368 344S357 320 344 320ZM336 176C318 176 304 190 304 208S318 240 336 240C354 240 368 226 368 208S354 176 336 176ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceMehBlank = {
    prefix: 'far',
    iconName: 'face-meh-blank',
    icon: [512, 512, [], "f5a4", "M176 176C158 176 144 190 144 208S158 240 176 240C194 240 208 226 208 208S194 176 176 176ZM336 176C318 176 304 190 304 208S318 240 336 240C354 240 368 226 368 208S354 176 336 176ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceRollingEyes = {
    prefix: 'far',
    iconName: 'face-rolling-eyes',
    icon: [512, 512, [], "f5a5", "M344 152C304 152 272 184 272 224S304 296 344 296C384 296 416 264 416 224S384 152 344 152ZM344 264C322 264 304 246 304 224C304 210 311 199 322 192C321 194 320 197 320 200C320 213 331 224 344 224S368 213 368 200C368 197 367 194 366 192C377 199 384 210 384 224C384 246 366 264 344 264ZM240 224C240 184 208 152 168 152C128 152 96 184 96 224S128 296 168 296C208 296 240 264 240 224ZM128 224C128 210 135 199 146 192C145 194 144 197 144 200C144 213 155 224 168 224S192 213 192 200C192 197 191 194 190 192C201 199 208 210 208 224C208 246 190 264 168 264C146 264 128 246 128 224ZM320 352H192C179 352 168 363 168 376S179 400 192 400H320C333 400 344 389 344 376S333 352 320 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceSadCry = {
    prefix: 'far',
    iconName: 'face-sad-cry',
    icon: [512, 512, [], "f5b3", "M214 234C218 232 221 227 220 222C216 197 186 180 160 180S104 197 100 222C100 227 102 232 106 234C111 237 116 236 120 233L130 224C144 211 176 211 191 224L200 233C203 235 208 238 214 234ZM256 272C225 272 200 301 200 336S225 400 256 400S312 371 312 336S287 272 256 272ZM352 180C326 180 296 197 292 222C291 227 294 232 298 234C303 237 308 236 312 233L322 224C336 211 368 211 383 224L392 233C395 235 400 238 406 234C410 232 413 227 412 222C408 197 378 180 352 180ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM400 383V280C400 267 389 256 376 256S352 267 352 280V422C324 438 291 448 256 448S188 438 160 422V280C160 267 149 256 136 256S112 267 112 280V383C82 349 64 305 64 256C64 150 150 64 256 64S448 150 448 256C448 305 430 349 400 383Z"]
  };
  var faFaceSadTear = {
    prefix: 'far',
    iconName: 'face-sad-tear',
    icon: [512, 512, [], "f5b4", "M170 275C159 290 134 325 134 343C134 366 153 384 176 384C199 384 218 366 218 343C218 325 193 290 182 275C179 271 173 271 170 275ZM176 240C194 240 208 226 208 208S194 176 176 176C158 176 144 190 144 208S158 240 176 240ZM264 304C251 304 240 315 240 328S251 352 264 352C288 352 310 362 326 381C334 391 349 393 359 384C370 375 371 360 362 350C338 321 302 304 264 304ZM336 176C318 176 304 190 304 208S318 240 336 240C354 240 368 226 368 208S354 176 336 176ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceSmile = {
    prefix: 'far',
    iconName: 'face-smile',
    icon: [512, 512, [], "f118", "M176 240C194 240 208 226 208 208S194 176 176 176C158 176 144 190 144 208S158 240 176 240ZM336 240C354 240 368 226 368 208S354 176 336 176C318 176 304 190 304 208S318 240 336 240ZM340 313C319 338 288 352 256 352S193 338 172 313C163 302 148 301 138 310C128 318 127 333 135 343C165 379 209 400 256 400S347 379 377 343C385 333 384 318 374 310C364 301 349 302 340 313ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceSmileBeam = {
    prefix: 'far',
    iconName: 'face-smile-beam',
    icon: [512, 512, [], "f5b8", "M144 211C152 197 164 189 176 189C188 189 200 197 207 211L217 228C219 232 223 233 226 232C230 231 232 227 232 223C229 181 200 152 176 152C152 152 123 181 120 223C120 227 122 231 126 232C129 233 133 231 135 228L144 211ZM340 313C319 338 288 352 256 352S193 338 172 313C163 302 148 301 138 310C128 318 127 333 135 343C165 379 209 400 256 400S347 379 377 343C385 333 384 318 374 310C364 301 349 302 340 313ZM336 152C312 152 283 181 280 223C280 227 282 231 286 232C289 233 293 231 295 228L305 211C312 197 324 189 336 189C348 189 360 197 368 211L377 228C379 232 383 233 386 232C390 231 392 227 392 223C389 181 360 152 336 152ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceSmilePlus = {
    prefix: 'far',
    iconName: 'face-smile-plus',
    icon: [640, 512, [], "f5b9", "M224 64C100 64 0 164 0 288C0 412 100 512 224 512S448 412 448 288C448 164 348 64 224 64ZM224 464C127 464 48 385 48 288S127 112 224 112S400 191 400 288S321 464 224 464ZM144 272C162 272 176 258 176 240S162 208 144 208C126 208 112 222 112 240S126 272 144 272ZM304 272C322 272 336 258 336 240S322 208 304 208C286 208 272 222 272 240S286 272 304 272ZM306 329C286 354 255 368 222 368S159 354 138 329C130 318 115 317 105 326C94 334 93 349 102 359C131 395 176 416 222 416S313 395 343 359C352 349 350 334 340 326C330 317 315 318 306 329ZM616 72H568V24C568 11 557 0 544 0S520 11 520 24V72H472C459 72 448 83 448 96S459 120 472 120H520V168C520 181 531 192 544 192S568 181 568 168V120H616C629 120 640 109 640 96S629 72 616 72Z"]
  };
  var faFaceSmileWink = {
    prefix: 'far',
    iconName: 'face-smile-wink',
    icon: [512, 512, [], "f4da", "M340 313C319 338 288 352 256 352S193 338 172 313C163 302 148 301 138 310C128 318 127 333 135 343C165 379 209 400 256 400S347 379 377 343C385 333 384 318 374 310S349 302 340 313ZM176 240C194 240 208 226 208 208S194 176 176 176C158 176 144 190 144 208S158 240 176 240ZM336 180C310 180 280 197 276 222C274 233 288 240 296 233L305 224C320 211 352 211 366 224L376 233C384 240 398 233 396 222C392 197 362 180 336 180ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceSurprise = {
    prefix: 'far',
    iconName: 'face-surprise',
    icon: [512, 512, [], "f5c2", "M256 280C221 280 192 309 192 344S221 408 256 408S320 379 320 344S291 280 256 280ZM208 208C208 190 194 176 176 176C158 176 144 190 144 208S158 240 176 240C194 240 208 226 208 208ZM336 176C318 176 304 190 304 208S318 240 336 240C354 240 368 226 368 208S354 176 336 176ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFaceTired = {
    prefix: 'far',
    iconName: 'face-tired',
    icon: [512, 512, [], "f5c8", "M385 152C381 148 375 147 370 150L290 198C286 200 284 204 284 208S286 216 290 218L370 266C375 270 382 268 385 264C389 259 389 253 385 248L352 208L385 168C389 163 389 157 385 152ZM256 272C211 272 155 310 148 365C147 377 155 387 164 383C186 374 220 368 256 368S326 374 348 383C357 387 365 377 364 365C357 310 301 272 256 272ZM228 208C228 204 226 200 222 198L142 150C137 147 131 148 127 152S123 163 127 168L160 208L127 248C123 253 123 259 127 264C130 268 137 270 142 266L222 218C226 216 228 212 228 208ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 448C150 448 64 362 64 256S150 64 256 64S448 150 448 256S362 448 256 448Z"]
  };
  var faFan = {
    prefix: 'far',
    iconName: 'fan',
    icon: [512, 512, [], "f863", "M256 224C238 224 224 238 224 256S238 288 256 288S288 274 288 256S274 224 256 224ZM512 265V265C501 180 429 116 343 116C329 116 315 117 301 120L309 42C310 31 306 19 297 11S277 -1 265 0C180 11 116 83 116 169C116 183 117 197 120 211L43 203C31 202 19 206 11 215C3 223 -1 235 0 247C11 332 83 396 169 396C183 396 197 395 211 392L203 470C202 481 206 493 215 501C222 508 232 512 242 512C244 512 245 512 247 512C332 501 396 429 396 343C396 329 395 315 392 301L469 309C481 310 493 306 501 297C509 289 513 277 512 265ZM350 249C338 247 329 259 333 270L338 282C344 300 348 321 348 343C348 401 307 450 252 462L263 350C265 338 253 329 242 333L230 338C212 345 191 348 169 348C111 348 62 307 50 252L162 263C174 265 183 253 179 242L174 230C168 211 164 191 164 168C164 111 205 62 260 50L249 162C247 174 259 183 270 179L282 174C300 167 321 164 343 164C401 164 450 205 462 260L350 249Z"]
  };
  var faFanTable = {
    prefix: 'far',
    iconName: 'fan-table',
    icon: [448, 512, [], "e004", "M354 266C359 267 364 266 368 262C372 259 374 254 374 249C374 215 355 184 324 170S256 160 230 182L196 90C193 83 183 74 170 81C150 93 136 112 130 134C121 168 132 221 185 239L122 315C114 326 121 338 127 342C169 366 223 352 247 310C257 292 261 270 257 250L354 266ZM224 240C215 240 208 233 208 224S215 208 224 208S240 215 240 224S233 240 224 240ZM360 464H248V447C360 435 448 340 448 224C448 100 348 0 224 0S0 100 0 224C0 340 88 435 200 447V464H88C75 464 64 475 64 488C64 501 75 512 88 512H360C373 512 384 501 384 488C384 475 373 464 360 464ZM48 224C48 127 127 48 224 48S400 127 400 224S321 400 224 400S48 321 48 224Z"]
  };
  var faFarm = {
    prefix: 'far',
    iconName: 'farm',
    icon: [576, 512, [], "f864", "M400 224H336C327 224 320 231 320 240V304C320 313 327 320 336 320H400C409 320 416 313 416 304V240C416 231 409 224 400 224ZM573 246L517 135C514 129 508 123 502 120L381 67C373 63 363 63 355 67L234 120C229 123 223 128 224 128C222 130 220 133 219 135L163 246C161 251 160 256 160 261V480C160 498 174 512 192 512H544C562 512 576 498 576 480V261C576 256 575 251 573 246ZM528 464H416V416C416 398 402 384 384 384H352C334 384 320 398 320 416V464H208V264L259 162L368 114L477 162L528 264V464ZM136 144H48V112C48 77 77 48 112 48C139 48 162 64 172 89C176 101 190 107 203 102C215 98 221 84 216 71C199 28 158 0 112 0C50 0 0 50 0 112V488C0 501 11 512 24 512S48 501 48 488V192H136C149 192 160 181 160 168S149 144 136 144Z"]
  };
  var faFaucet = {
    prefix: 'far',
    iconName: 'faucet',
    icon: [512, 512, [], "e005", "M512 368V400C512 426 490 448 464 448H400C374 448 352 426 352 400V384H323C300 413 264 432 224 432S148 413 125 384H24C11 384 0 373 0 360C0 347 11 336 24 336H151C163 365 192 384 224 384S285 365 297 336H368C386 336 400 350 400 368V400H464V368C464 315 421 272 368 272H297C285 243 256 224 224 224S163 243 151 272H24C11 272 0 261 0 248C0 235 11 224 24 224H125C143 201 170 184 200 178V148C200 148 81 160 80 160C71 160 64 153 64 143V113C64 103 71 96 80 96C81 96 74 95 200 109V80C200 71 207 64 216 64H232C241 64 248 71 248 80V109C374 95 367 96 368 96C377 96 384 103 384 113V143C384 153 377 160 368 160C367 160 248 148 248 148V178C278 184 305 201 323 224H368C448 224 512 288 512 368Z"]
  };
  var faFaucetDrip = {
    prefix: 'far',
    iconName: 'faucet-drip',
    icon: [512, 512, [], "e006", "M416 480C416 498 430 512 448 512S480 498 480 480S448 416 448 416S416 462 416 480ZM368 160H323C305 137 278 120 248 114V84C248 84 367 96 368 96C377 96 384 89 384 79V49C384 39 377 32 368 32C367 32 374 31 248 45V16C248 7 241 0 232 0H216C207 0 200 7 200 16V45C74 31 81 32 80 32C71 32 64 39 64 49V79C64 89 71 96 80 96C81 96 200 84 200 84V114C170 120 143 137 125 160H24C11 160 0 171 0 184V184C0 197 11 208 24 208H151C163 179 192 160 224 160S285 179 297 208H368C421 208 464 251 464 304V336H400V304C400 286 386 272 368 272H297C285 301 256 320 224 320S163 301 151 272H24C11 272 0 283 0 296V296C0 309 11 320 24 320H125C148 349 184 368 224 368S300 349 323 320H352V336C352 362 374 384 400 384H464C490 384 512 362 512 336V304C512 224 448 160 368 160Z"]
  };
  var faFax = {
    prefix: 'far',
    iconName: 'fax',
    icon: [512, 512, [], "f1ac", "M352 432H384C393 432 400 425 400 416V384C400 375 393 368 384 368H352C343 368 336 375 336 384V416C336 425 343 432 352 432ZM352 336H384C393 336 400 329 400 320V288C400 279 393 272 384 272H352C343 272 336 279 336 288V320C336 329 343 336 352 336ZM256 336H288C297 336 304 329 304 320V288C304 279 297 272 288 272H256C247 272 240 279 240 288V320C240 329 247 336 256 336ZM464 192H176L176 48H398L432 82V160H480V82C480 69 475 57 466 48L432 14C423 5 411 0 398 0H176C150 0 128 22 128 48L128 130C123 129 118 128 112 128H64C29 128 0 157 0 192V448C0 483 29 512 64 512H464C490 512 512 490 512 464V240C512 214 490 192 464 192ZM128 448C128 457 121 464 112 464H64C55 464 48 457 48 448V192C48 183 55 176 64 176H112C121 176 128 183 128 192V448ZM464 464H174C175 459 176 454 176 448V240H464V464ZM256 432H288C297 432 304 425 304 416V384C304 375 297 368 288 368H256C247 368 240 375 240 384V416C240 425 247 432 256 432Z"]
  };
  var faFeather = {
    prefix: 'far',
    iconName: 'feather',
    icon: [512, 512, [], "f52d", "M467 45C438 16 402 0 362 0C315 0 264 22 215 71L129 156C54 232 57 353 73 405L7 471C-2 480 -2 496 7 505C16 514 32 514 41 505L107 439C124 445 149 448 178 448C235 448 306 433 356 383L441 297C532 207 530 107 467 45ZM147 399L194 352H318C273 394 211 400 178 400C166 400 156 400 147 399ZM351 320H226L290 256H414C412 258 410 261 407 263L351 320ZM439 224H322L345 202C354 192 354 177 345 168C335 158 320 158 311 168L114 364C108 319 113 240 163 190C163 190 182 172 249 105C286 68 325 48 362 48C388 48 413 59 433 79C472 118 473 171 439 224Z"]
  };
  var faFeatherPointed = {
    prefix: 'far',
    iconName: 'feather-pointed',
    icon: [512, 512, [], "f56b", "M481 0C480 0 480 0 479 0C362 8 -3 62 75 403L7 471C-2 480 -2 496 7 505C12 510 18 512 24 512S36 510 41 505L109 437C141 444 171 448 199 448C460 448 504 138 512 33C513 15 499 0 481 0ZM199 400C183 400 167 398 150 396L194 352H335C285 392 232 400 199 400ZM380 304H242L290 256H410C401 274 391 290 380 304ZM429 208H338L345 201C354 192 354 176 345 167S320 158 311 167L116 362C105 291 116 234 151 186C224 85 389 57 462 50C456 114 445 165 429 208Z"]
  };
  var faFieldHockeyStickBall = {
    prefix: 'far',
    iconName: 'field-hockey-stick-ball',
    icon: [512, 512, [], "f44c", "M424 336C375 336 336 375 336 424C336 473 375 512 424 512S512 473 512 424C512 375 473 336 424 336ZM424 464C402 464 384 446 384 424S402 384 424 384C446 384 464 402 464 424S446 464 424 464ZM511 59C508 45 500 33 488 25L464 9C440 -7 407 -1 391 23L155 370C151 377 143 378 140 376C135 373 135 368 135 366C135 365 136 363 137 361L146 349C167 318 159 276 129 255C114 244 96 240 79 243C61 247 45 257 35 271L26 284C11 306 2 331 0 357C-4 413 24 466 74 494C95 506 119 512 143 512C146 512 148 512 151 512C197 509 240 485 266 447L503 99C511 87 514 73 511 59ZM227 420C209 446 180 462 149 464C131 465 113 461 98 452C64 434 46 398 48 360C50 343 55 326 66 312L74 299C77 295 82 292 87 291C88 291 89 290 90 290C94 290 98 292 101 294C110 300 112 312 106 321L97 334C91 343 88 353 87 363C86 381 93 405 117 418C142 433 176 424 195 398L368 142L399 166L227 420Z"]
  };
  var faFile = {
    prefix: 'far',
    iconName: 'file',
    icon: [384, 512, [], "f15b", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448C336 457 329 464 320 464Z"]
  };
  var faFileArrowDown = {
    prefix: 'far',
    iconName: 'file-arrow-down',
    icon: [384, 512, [], "f56d", "M216 342V240C216 227 205 216 192 216S168 227 168 240V342L129 303C124 298 118 296 112 296S100 298 95 303C86 312 86 328 95 337L175 417C184 426 200 426 209 417L289 337C298 328 298 312 289 303S264 294 255 303L216 342ZM365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448Z"]
  };
  var faFileArrowUp = {
    prefix: 'far',
    iconName: 'file-arrow-up',
    icon: [384, 512, [], "f574", "M175 223L95 303C86 312 86 328 95 337S120 346 129 337L168 298V400C168 413 179 424 192 424S216 413 216 400V298L255 337C260 342 266 344 272 344S284 342 289 337C298 328 298 312 289 303L209 223C200 214 184 214 175 223ZM365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448Z"]
  };
  var faFileAudio = {
    prefix: 'far',
    iconName: 'file-audio',
    icon: [384, 512, [], "f1c7", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM171 259L136 296H92C85 296 80 301 80 308V364C80 371 85 376 92 376H136L171 413C179 420 192 415 192 404V268C192 257 179 252 171 259ZM235 261C229 267 229 277 235 283C235 284 256 305 256 336C256 367 235 389 235 389C229 395 229 405 235 411C238 414 242 416 246 416S255 414 258 411C259 410 288 381 288 336S259 262 258 261C251 254 241 254 235 261Z"]
  };
  var faFileCertificate = {
    prefix: 'far',
    iconName: 'file-certificate',
    icon: [512, 512, [], "f5f3", "M247 338C255 331 258 320 255 310C250 289 250 292 255 271C258 261 255 250 247 242C233 227 234 230 229 209C226 199 218 191 208 188C188 182 190 184 175 169C168 161 157 158 147 161C126 166 129 166 109 161C99 158 88 161 81 169C66 184 68 182 48 188C38 191 30 199 27 209C22 230 23 227 9 242C1 250 -2 261 1 271C6 292 6 289 1 309C-2 320 1 331 9 338C23 353 22 351 27 371C30 382 38 390 48 393C62 396 60 396 64 398V512L128 480L192 512V398C196 396 194 397 208 393C218 390 226 382 228 372C234 351 233 353 247 338ZM128 352C93 352 64 323 64 288S93 224 128 224S192 253 192 288S163 352 128 352ZM493 93L419 19C407 7 390 0 373 0H192C157 0 128 29 128 64V96L128 133C128 133 150 122 176 132L176 64C176 55 183 48 192 48H352V128C352 146 366 160 384 160H464V448C464 457 457 464 448 464H224V512H448C483 512 512 483 512 448V139C512 122 505 105 493 93Z"]
  };
  var faFileChartColumn = {
    prefix: 'far',
    iconName: 'file-chart-column',
    icon: [384, 512, [], "f659", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM192 256C179 256 168 267 168 280V408C168 421 179 432 192 432S216 421 216 408V280C216 267 205 256 192 256ZM256 408C256 421 267 432 280 432S304 421 304 408V312C304 299 293 288 280 288S256 299 256 312V408ZM104 320C91 320 80 331 80 344V408C80 421 91 432 104 432S128 421 128 408V344C128 331 117 320 104 320Z"]
  };
  var faFileChartPie = {
    prefix: 'far',
    iconName: 'file-chart-pie',
    icon: [384, 512, [], "f65a", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM176 240C123 240 80 283 80 336S123 432 176 432S272 389 272 336H176V240ZM208 304H304C304 251 261 208 208 208V304Z"]
  };
  var faFileCheck = {
    prefix: 'far',
    iconName: 'file-check',
    icon: [384, 512, [], "f316", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM167 325L137 295C128 286 112 286 103 295S94 320 103 329L151 377C156 381 162 384 168 384C168 384 169 384 169 384C176 384 182 381 186 376L282 264C291 254 290 238 280 230C270 221 254 222 246 232L167 325Z"]
  };
  var faFileCode = {
    prefix: 'far',
    iconName: 'file-code',
    icon: [384, 512, [], "f1c9", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM142 258C134 250 122 250 114 258L66 306C58 314 58 326 66 334L114 382C118 386 123 388 128 388S138 386 142 382C150 374 150 362 142 354L108 320L142 286C150 278 150 266 142 258ZM242 258C234 266 234 278 242 286L276 320L242 354C234 362 234 374 242 382C246 386 251 388 256 388S266 386 270 382L318 334C326 326 326 314 318 306L270 258C262 250 250 250 242 258ZM221 205C210 202 199 208 197 219L149 411C146 422 152 433 163 435C165 436 166 436 168 436C177 436 185 430 187 421L235 229C238 218 232 207 221 205Z"]
  };
  var faFileContract = {
    prefix: 'far',
    iconName: 'file-contract',
    icon: [384, 512, [], "f56c", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM96 128H176C185 128 192 121 192 112S185 96 176 96H96C87 96 80 103 80 112S87 128 96 128ZM96 192H176C185 192 192 185 192 176S185 160 176 160H96C87 160 80 167 80 176S87 192 96 192ZM197 363L183 322C179 312 170 305 160 305S141 312 137 322L119 376C118 381 113 384 108 384H96C87 384 80 391 80 400S87 416 96 416H108C127 416 144 404 149 386L160 355L177 405C179 411 184 415 191 416H192C198 416 204 413 206 407L214 392C217 386 222 386 224 386S231 386 234 392C242 407 256 416 273 416H288C297 416 304 409 304 400S297 384 288 384H273C269 384 265 382 263 378C251 354 216 347 197 363Z"]
  };
  var faFileCsv = {
    prefix: 'far',
    iconName: 'file-csv',
    icon: [384, 512, [], "f6dd", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM179 298C178 297 177 296 177 295C177 291 182 288 188 288H192C201 288 208 281 208 272C208 263 201 256 192 256H188C164 256 145 273 145 295C145 305 150 315 159 323L181 342C182 343 183 344 183 345C183 349 178 352 172 352H168C159 352 152 359 152 368C152 377 159 384 168 384H172C196 384 215 367 215 345C215 335 210 325 201 317L179 298ZM112 288C121 288 128 281 128 272C128 263 121 256 112 256C86 256 64 278 64 304V336C64 362 86 384 112 384C121 384 128 377 128 368C128 359 121 352 112 352C103 352 96 345 96 336V304C96 295 103 288 112 288ZM256 272C256 263 249 256 240 256S224 263 224 272V285C224 320 237 354 260 379C263 382 267 384 272 384S281 382 284 379C307 354 320 320 320 285V272C320 263 313 256 304 256S288 263 288 272V285C288 305 282 325 272 342C262 325 256 305 256 285V272Z"]
  };
  var faFileDashedLine = {
    prefix: 'far',
    iconName: 'file-dashed-line',
    icon: [576, 512, [], "f877", "M160 288C160 275 149 264 136 264H24C11 264 0 275 0 288S11 312 24 312H136C149 312 160 301 160 288ZM552 264H440C427 264 416 275 416 288S427 312 440 312H552C565 312 576 301 576 288S565 264 552 264ZM248 264C235 264 224 275 224 288S235 312 248 312H328C341 312 352 301 352 288S341 264 328 264H248ZM144 224L144 64C144 55 151 48 160 48H320V128C320 146 334 160 352 160H432V224H480V139C480 122 473 105 461 93L387 19C375 7 358 0 341 0H160C125 0 96 29 96 64L96 224H144ZM432 448C432 457 425 464 416 464H160C151 464 144 457 144 448L144 352H96L96 448C96 483 125 512 160 512H416C451 512 480 483 480 448V352H432V448Z"]
  };
  var faFileExcel = {
    prefix: 'far',
    iconName: 'file-excel',
    icon: [384, 512, [], "f1c3", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM229 233L192 281L155 233C147 223 132 221 121 229C111 237 109 252 117 263L162 320L117 377C109 388 111 403 121 411C126 414 131 416 136 416C143 416 150 413 155 407L192 359L229 407C234 413 241 416 248 416C253 416 258 414 263 411C273 403 275 388 267 377L222 320L267 263C275 252 273 237 263 229C252 221 237 223 229 233Z"]
  };
  var faFileExclamation = {
    prefix: 'far',
    iconName: 'file-exclamation',
    icon: [384, 512, [], "f31a", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM192 336C205 336 216 325 216 312V216C216 203 205 192 192 192S168 203 168 216V312C168 325 179 336 192 336ZM192 368C174 368 160 382 160 400S174 432 192 432C210 432 224 418 224 400S210 368 192 368Z"]
  };
  var faFileExport = {
    prefix: 'far',
    iconName: 'file-export',
    icon: [576, 512, [], "f56e", "M569 303L489 223C480 214 464 214 455 223S446 248 455 257L494 296H216C203 296 192 307 192 320S203 344 216 344H494L455 383C450 388 448 394 448 400S450 412 455 417C464 426 480 426 489 417L569 337C578 328 578 312 569 303ZM360 384L360 384C347 384 336 395 336 408V448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V232C336 245 347 256 360 256H360C373 256 384 245 384 232V139C384 122 377 105 365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V408C384 395 373 384 360 384Z"]
  };
  var faFileHeart = {
    prefix: 'far',
    iconName: 'file-heart',
    icon: [384, 512, [], "e129", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM199 265L192 272L185 265C166 245 135 242 115 259C91 280 90 316 111 338L184 412C188 417 196 417 200 412L273 338C294 316 293 280 269 259C249 242 218 245 199 265Z"]
  };
  var faFileImage = {
    prefix: 'far',
    iconName: 'file-image',
    icon: [384, 512, [], "f1c5", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM215 292C211 292 206 294 204 298L164 358L152 340C150 336 145 334 141 334C136 334 132 336 129 340L82 410C79 415 79 420 82 425C84 429 89 432 94 432H290C295 432 300 429 302 425C305 420 305 415 302 410L227 298C224 294 220 292 215 292ZM128 288C146 288 160 274 160 256S146 224 128 224S96 238 96 256S110 288 128 288Z"]
  };
  var faFileImport = {
    prefix: 'far',
    iconName: 'file-import',
    icon: [512, 512, [], "f56f", "M263 383C258 388 256 394 256 400S258 412 263 417C272 426 288 426 297 417L377 337C386 328 386 312 377 303L297 223C288 214 272 214 263 223S254 248 263 257L302 296H24C11 296 0 307 0 320S11 344 24 344H302L263 383ZM493 93L419 19C407 7 390 0 373 0H192C157 0 128 29 128 64L128 232C128 245 139 256 152 256S176 245 176 232L176 64C176 55 183 48 192 48H352V128C352 146 366 160 384 160H464V448C464 457 457 464 448 464H192C183 464 176 457 176 448L176 408C176 395 165 384 152 384S128 395 128 408L128 448C128 483 157 512 192 512H448C483 512 512 483 512 448V139C512 122 505 105 493 93Z"]
  };
  var faFileInvoice = {
    prefix: 'far',
    iconName: 'file-invoice',
    icon: [384, 512, [], "f570", "M80 256V320C80 338 94 352 112 352H272C290 352 304 338 304 320V256C304 238 290 224 272 224H112C94 224 80 238 80 256ZM365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM96 128H176C185 128 192 121 192 112S185 96 176 96H96C87 96 80 103 80 112S87 128 96 128ZM96 192H176C185 192 192 185 192 176S185 160 176 160H96C87 160 80 167 80 176S87 192 96 192ZM288 384H208C199 384 192 391 192 400S199 416 208 416H288C297 416 304 409 304 400S297 384 288 384Z"]
  };
  var faFileInvoiceDollar = {
    prefix: 'far',
    iconName: 'file-invoice-dollar',
    icon: [384, 512, [], "f571", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM96 128H176C185 128 192 121 192 112S185 96 176 96H96C87 96 80 103 80 112S87 128 96 128ZM192 176C192 167 185 160 176 160H96C87 160 80 167 80 176S87 192 96 192H176C185 192 192 185 192 176ZM198 309L192 307C168 300 169 297 170 293C171 285 186 283 200 285C205 286 212 288 217 290C228 293 239 288 243 277C246 267 241 256 231 252C223 249 217 248 212 247V240C212 229 203 220 192 220S172 229 172 240V246C150 251 134 265 130 286C123 329 163 340 181 346L187 347C216 356 215 358 214 363C213 371 198 373 184 371C177 370 168 367 161 364L156 362C146 359 134 364 131 375C127 385 132 397 143 400L147 402C155 404 163 407 172 409V416C172 427 181 436 192 436S212 427 212 416V410C234 405 250 391 254 370C261 327 220 315 198 309Z"]
  };
  var faFileLines = {
    prefix: 'far',
    iconName: 'file-lines',
    icon: [384, 512, [], "f15c", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM96 280C96 293 107 304 120 304H264C277 304 288 293 288 280S277 256 264 256H120C107 256 96 267 96 280ZM264 352H120C107 352 96 363 96 376S107 400 120 400H264C277 400 288 389 288 376S277 352 264 352Z"]
  };
  var faFileMagnifyingGlass = {
    prefix: 'far',
    iconName: 'file-magnifying-glass',
    icon: [384, 512, [], "f865", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM176 208C123 208 80 251 80 304S123 400 176 400C194 400 210 395 224 386L271 433C276 438 282 440 288 440S300 438 305 433C314 424 314 408 305 399L258 352C267 338 272 322 272 304C272 251 229 208 176 208ZM176 352C150 352 128 330 128 304S150 256 176 256S224 278 224 304S202 352 176 352Z"]
  };
  var faFileMedical = {
    prefix: 'far',
    iconName: 'file-medical',
    icon: [384, 512, [], "f477", "M224 240C224 231 217 224 208 224H176C167 224 160 231 160 240V288H112C103 288 96 295 96 304V336C96 345 103 352 112 352H160V400C160 409 167 416 176 416H208C217 416 224 409 224 400V352H272C281 352 288 345 288 336V304C288 295 281 288 272 288H224V240ZM365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448Z"]
  };
  var faFileMinus = {
    prefix: 'far',
    iconName: 'file-minus',
    icon: [384, 512, [], "f318", "M96 304C96 317 107 328 120 328H264C277 328 288 317 288 304S277 280 264 280H120C107 280 96 291 96 304ZM365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448Z"]
  };
  var faFileMusic = {
    prefix: 'far',
    iconName: 'file-music',
    icon: [384, 512, [], "f8b6", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM144 255V370C139 369 133 368 128 368C102 368 80 382 80 400S102 432 128 432S176 418 176 400V299L272 262V338C267 337 261 336 256 336C230 336 208 350 208 368S230 400 256 400S304 386 304 368V208C304 203 302 198 298 195S288 191 283 193L155 240C149 242 144 248 144 255Z"]
  };
  var faFilePdf = {
    prefix: 'far',
    iconName: 'file-pdf',
    icon: [384, 512, [], "f1c1", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM202 286C203 283 204 281 205 278C206 272 212 246 212 226C212 207 197 192 179 192C160 192 145 207 145 226C145 226 145 254 159 288C152 307 143 327 134 346C112 356 94 368 81 382C74 388 71 397 71 407C71 425 86 440 105 440C116 440 126 435 132 426C139 416 150 399 163 377C178 371 196 365 216 361C230 371 245 378 262 384C267 386 272 386 277 386C297 386 313 370 313 349C313 329 296 313 276 313H272C269 313 252 314 227 318C217 309 209 298 202 286ZM110 410C107 415 98 413 98 405C98 403 99 402 100 401C109 391 120 384 132 377C122 393 114 405 110 410ZM179 219C182 219 185 222 185 226C185 241 181 260 180 268C172 245 172 227 172 226C172 222 175 219 179 219ZM162 348C169 335 175 320 182 304C188 315 196 325 207 336C193 339 177 343 162 348ZM272 339H276C281 339 286 344 286 350C286 355 282 360 277 360C274 360 272 359 271 359C258 354 248 349 238 343C258 340 272 339 272 339Z"]
  };
  var faFilePen = {
    prefix: 'far',
    iconName: 'file-pen',
    icon: [384, 512, [], "f31c", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM95 361C93 363 92 365 91 368L80 424C79 429 83 433 88 432L144 421C147 420 149 419 151 417L249 319L193 263L95 361ZM215 241L271 297L296 272C307 261 307 244 296 233L279 216C268 205 251 205 240 216L215 241Z"]
  };
  var faFilePlus = {
    prefix: 'far',
    iconName: 'file-plus',
    icon: [384, 512, [], "f319", "M216 232C216 219 205 208 192 208S168 219 168 232V280H120C107 280 96 291 96 304S107 328 120 328H168V376C168 389 179 400 192 400S216 389 216 376V328H264C277 328 288 317 288 304S277 280 264 280H216V232ZM365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448Z"]
  };
  var faFilePowerpoint = {
    prefix: 'far',
    iconName: 'file-powerpoint',
    icon: [384, 512, [], "f1c4", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM200 224H128C119 224 112 231 112 240V408C112 421 123 432 136 432S160 421 160 408V376H204C248 376 284 338 280 293C276 253 240 224 200 224ZM204 328H160V272H204C219 272 232 285 232 300S219 328 204 328Z"]
  };
  var faFilePrescription = {
    prefix: 'far',
    iconName: 'file-prescription',
    icon: [384, 512, [], "f572", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM206 312C229 300 243 275 239 246C235 215 206 192 174 192H96C87 192 80 199 80 208V360C80 373 91 384 104 384H104C117 384 128 373 128 360V320H147L206 379L182 404C172 413 172 428 182 438L182 438C191 447 206 447 216 438L240 413L264 438C274 447 289 447 298 438L298 438C308 428 308 413 298 404L274 379L298 355C308 346 308 330 298 321C289 312 274 312 264 321L240 345L206 312ZM176 272H128V240H176C185 240 192 247 192 256S185 272 176 272Z"]
  };
  var faFileSignature = {
    prefix: 'far',
    iconName: 'file-signature',
    icon: [576, 512, [], "f573", "M48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V254L384 206V139C384 122 377 105 365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C350 512 375 491 382 464H64C55 464 48 457 48 448ZM293 342C290 345 288 349 288 354V384H273C269 384 265 382 263 378C251 354 216 347 197 363L183 322C179 312 170 305 160 305S141 312 137 322L119 376C118 381 113 384 108 384H96C87 384 80 391 80 400S87 416 96 416H108C127 416 144 404 149 386L160 355L177 405C179 411 184 415 191 416H192C198 416 204 413 206 407L214 392C217 386 222 386 224 386S231 386 234 392C242 407 256 416 273 416H350C355 416 359 414 362 411L519 253L451 185L293 342ZM569 167L537 135C527 126 511 126 501 135L473 163L541 231L569 203C578 193 578 177 569 167Z"]
  };
  var faFileSpreadsheet = {
    prefix: 'far',
    iconName: 'file-spreadsheet',
    icon: [384, 512, [], "f65b", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM80 256V384C80 402 94 416 112 416H272C290 416 304 402 304 384V256C304 238 290 224 272 224H112C94 224 80 238 80 256ZM176 384H112V336H176V384ZM208 256H272V304H208V256ZM208 336H272V384H208V336ZM176 304H112V256H176V304Z"]
  };
  var faFileUser = {
    prefix: 'far',
    iconName: 'file-user',
    icon: [384, 512, [], "f65c", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H318C311 419 272 384 224 384H160C112 384 73 419 66 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM192 224C157 224 128 253 128 288C128 323 157 352 192 352S256 323 256 288C256 253 227 224 192 224Z"]
  };
  var faFileVideo = {
    prefix: 'far',
    iconName: 'file-video',
    icon: [384, 512, [], "f1c8", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM240 288C240 270 226 256 208 256H112C94 256 80 270 80 288V384C80 402 94 416 112 416H208C226 416 240 402 240 384V367L284 398C292 404 304 398 304 387V285C304 274 292 268 284 274L240 305V288Z"]
  };
  var faFileWaveform = {
    prefix: 'far',
    iconName: 'file-waveform',
    icon: [448, 512, [], "f478", "M172 381C177 388 184 392 192 392C193 392 193 392 193 392C202 391 210 386 213 379L257 291L267 308C271 315 279 320 288 320H328C341 320 352 309 352 296S341 272 328 272H302L277 228C272 220 265 216 255 216C246 216 238 221 235 229L189 320L164 283C160 276 152 272 144 272H24C11 272 0 283 0 296S11 320 24 320H131L172 381ZM429 93L355 19C343 7 326 0 309 0H128C93 0 64 29 64 64L64 216C64 229 75 240 88 240H88C101 240 112 229 112 216L112 64C112 55 119 48 128 48H288V128C288 146 302 160 320 160H400V448C400 457 393 464 384 464H128C119 464 112 457 112 448L112 376C112 363 101 352 88 352S64 363 64 376L64 448C64 483 93 512 128 512H384C419 512 448 483 448 448V139C448 122 441 105 429 93Z"]
  };
  var faFileWord = {
    prefix: 'far',
    iconName: 'file-word',
    icon: [384, 512, [], "f1c2", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448ZM215 248C211 238 202 232 192 232S173 238 169 248L145 318L119 240C115 228 101 221 88 225C76 229 69 243 73 256L121 400C124 409 134 416 144 416H144C154 416 163 410 167 400L192 328L217 400C221 410 230 416 240 416H240C250 416 260 409 263 400L311 256C315 243 308 229 296 225C283 221 269 228 265 240L239 318L215 248Z"]
  };
  var faFileXmark = {
    prefix: 'far',
    iconName: 'file-xmark',
    icon: [384, 512, [], "f317", "M226 236L192 270L158 236C149 227 133 227 124 236S115 261 124 270L158 304L124 338C115 347 115 363 124 372C129 377 135 379 141 379S153 377 158 372L192 338L226 372C231 377 237 379 243 379S255 377 260 372C269 363 269 347 260 338L226 304L260 270C269 261 269 245 260 236S235 227 226 236ZM365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H224V128C224 146 238 160 256 160H336V448Z"]
  };
  var faFileZipper = {
    prefix: 'far',
    iconName: 'file-zipper',
    icon: [384, 512, [], "f1c6", "M365 93L291 19C279 7 262 0 245 0H64C29 0 0 29 0 64L0 448C0 483 29 512 64 512H320C355 512 384 483 384 448V139C384 122 377 105 365 93ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448L48 64C48 55 55 48 64 48H112V64H176V48H224V128C224 146 238 160 256 160H336V448ZM176 96H112V128H176V96ZM176 160H112V192H176V160ZM176 224H112L81 341C74 380 104 416 144 416C185 416 215 380 207 341L176 224ZM160 368H128C119 368 112 361 112 352S119 336 128 336H160C169 336 176 343 176 352S169 368 160 368Z"]
  };
  var faFiles = {
    prefix: 'far',
    iconName: 'files',
    icon: [448, 512, [], "e12a", "M429 93L355 19C343 7 326 0 309 0H160C125 0 96 29 96 64L96 352C96 387 125 416 160 416H384C419 416 448 387 448 352V139C448 122 441 105 429 93ZM400 352C400 361 393 368 384 368H160C151 368 144 361 144 352L144 64C144 55 151 48 160 48H288V128C288 146 302 160 320 160H400V352ZM48 432V96C22 96 0 118 0 144V448C0 483 29 512 64 512H304C330 512 352 490 352 464H80C62 464 48 450 48 432Z"]
  };
  var faFilesMedical = {
    prefix: 'far',
    iconName: 'files-medical',
    icon: [448, 512, [], "f7fd", "M299 189C299 182 293 176 285 176H259C251 176 245 182 245 189V229H205C198 229 192 235 192 243V269C192 277 198 283 205 283H245V323C245 330 251 336 259 336H285C293 336 299 330 299 323V283H339C346 283 352 277 352 269V243C352 235 346 229 339 229H299V189ZM48 432V96C22 96 0 118 0 144V448C0 483 29 512 64 512H304C330 512 352 490 352 464H80C62 464 48 450 48 432ZM429 93L355 19C343 7 326 0 309 0H160C125 0 96 29 96 64L96 352C96 387 125 416 160 416H384C419 416 448 387 448 352V139C448 122 441 105 429 93ZM400 352C400 361 393 368 384 368H160C151 368 144 361 144 352L144 64C144 55 151 48 160 48H288V128C288 146 302 160 320 160H400V352Z"]
  };
  var faFill = {
    prefix: 'far',
    iconName: 'fill',
    icon: [512, 512, [], "f575", "M503 217L295 9C289 3 281 0 272 0C264 0 256 3 250 9L162 97L76 10C67 1 52 1 42 10L42 10C33 20 33 35 42 44L129 130L28 231C-9 268 -9 329 28 367L145 484C164 503 189 512 213 512C238 512 262 503 281 484L503 262C515 250 515 230 503 217ZM409 288H49C51 279 56 271 62 265L163 164L232 234C242 244 257 244 266 234C276 225 276 210 266 200L197 130L272 55L457 240L409 288Z"]
  };
  var faFillDrip = {
    prefix: 'far',
    iconName: 'fill-drip',
    icon: [576, 512, [], "f576", "M503 217L295 9C289 3 281 0 272 0C264 0 256 3 250 9L162 97L76 10C67 1 52 1 42 10L42 10C33 20 33 35 42 44L129 130L28 231C-9 268 -9 329 28 367L145 484C164 503 189 512 213 512C238 512 262 503 281 484L503 262C515 250 515 230 503 217ZM409 288H49C51 279 56 271 62 265L163 164L232 234C242 244 257 244 266 234S276 210 266 200L197 130L272 55L457 240L409 288ZM525 340C519 330 505 330 499 340C480 370 448 423 448 448C448 483 477 512 512 512S576 483 576 448C576 423 544 370 525 340Z"]
  };
  var faFilm = {
    prefix: 'far',
    iconName: 'film',
    icon: [512, 512, [], "f008", "M448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM112 432H64C55 432 48 425 48 416V344H112V432ZM112 296H48V216H112V296ZM112 168H48V96C48 87 55 80 64 80H112V168ZM352 432H160V280H352V432ZM352 232H160V80H352V232ZM464 416C464 425 457 432 448 432H400V344H464V416ZM464 296H400V216H464V296ZM464 168H400V80H448C457 80 464 87 464 96V168Z"]
  };
  var faFilmCanister = {
    prefix: 'far',
    iconName: 'film-canister',
    icon: [576, 512, [], "f8b7", "M544 128H320V80H328C341 80 352 69 352 56C352 43 341 32 328 32H256V16C256 7 249 0 240 0H112C103 0 96 7 96 16V32H24C11 32 0 43 0 56C0 69 11 80 24 80H32V464H24C11 464 0 475 0 488C0 501 11 512 24 512H328C341 512 352 501 352 488C352 475 341 464 328 464H320V416H480C498 416 512 402 512 384V352C512 334 526 320 544 320S576 306 576 288V160C576 142 562 128 544 128ZM272 464H80V80H272V464ZM440 360C440 369 433 376 424 376H408C399 376 392 369 392 360V344C392 335 399 328 408 328H424C433 328 440 335 440 344V360ZM440 200C440 209 433 216 424 216H408C399 216 392 209 392 200V184C392 175 399 168 408 168H424C433 168 440 175 440 184V200ZM536 200C536 209 529 216 520 216H504C495 216 488 209 488 200V184C488 175 495 168 504 168H520C529 168 536 175 536 184V200Z"]
  };
  var faFilmSimple = {
    prefix: 'far',
    iconName: 'film-simple',
    icon: [512, 512, [], "f3a0", "M448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM112 432H64C55 432 48 425 48 416V344H112V432ZM112 296H48V216H112V296ZM112 168H48V96C48 87 55 80 64 80H112V168ZM352 432H160V80H352V432ZM464 416C464 425 457 432 448 432H400V344H464V416ZM464 296H400V216H464V296ZM464 168H400V80H448C457 80 464 87 464 96V168Z"]
  };
  var faFilms = {
    prefix: 'far',
    iconName: 'films',
    icon: [576, 512, [], "e12b", "M48 400V96C22 96 0 118 0 144V416C0 451 29 480 64 480H432C458 480 480 458 480 432H80C62 432 48 418 48 400ZM512 32H160C125 32 96 61 96 96V320C96 355 125 384 160 384H512C547 384 576 355 576 320V96C576 61 547 32 512 32ZM208 336H160C151 336 144 329 144 320V280H208V336ZM208 232H144V184H208V232ZM208 136H144V96C144 87 151 80 160 80H208V136ZM416 336H256V232H416V336ZM416 184H256V80H416V184ZM528 320C528 329 521 336 512 336H464V280H528V320ZM528 232H464V184H528V232ZM528 136H464V80H512C521 80 528 87 528 96V136Z"]
  };
  var faFilter = {
    prefix: 'far',
    iconName: 'filter',
    icon: [512, 512, [], "f0b0", "M508 59C500 42 484 32 465 32H47C28 32 12 42 4 59C-3 75 -1 93 11 107L176 310V378C176 390 182 402 193 409L275 473C282 478 290 480 297 480C319 480 336 463 336 442V310L502 107C513 93 515 75 508 59ZM295 284C291 290 288 297 288 304V422L224 373V304C224 297 221 290 217 284L51 80H461L295 284Z"]
  };
  var faFilterList = {
    prefix: 'far',
    iconName: 'filter-list',
    icon: [512, 512, [], "e12c", "M440 120H488C501 120 512 109 512 96S501 72 488 72H440C427 72 416 83 416 96S427 120 440 120ZM488 232H344C331 232 320 243 320 256S331 280 344 280H488C501 280 512 269 512 256S501 232 488 232ZM330 64H22C4 64 -7 86 5 100L112 226V368C112 376 116 383 122 388L202 444C207 447 211 448 216 448C228 448 240 438 240 424V226L347 100C359 86 348 64 330 64ZM203 195L192 208V378L160 355V208L149 195L78 112H274L203 195ZM488 392H344C331 392 320 403 320 416S331 440 344 440H488C501 440 512 429 512 416S501 392 488 392Z"]
  };
  var faFilters = {
    prefix: 'far',
    iconName: 'filters',
    icon: [640, 512, [], "e12d", "M256 318V422L192 366V318L51 144H192L178 127C170 118 166 107 163 96H47C28 96 12 106 4 123C-3 139 -1 157 11 171L144 335V378C144 390 150 402 161 409L243 473C250 478 258 480 265 480C287 480 304 463 304 442V335L304 335V282L294 270L256 318ZM636 59C628 42 612 32 593 32H239C220 32 204 42 196 59C189 75 191 93 203 107L336 271V346C336 358 342 370 353 377L435 441C442 446 450 448 457 448C479 448 496 431 496 410V271L630 107C641 93 643 75 636 59ZM448 254V390L384 341V254L243 80H589L448 254Z"]
  };
  var faFingerprint = {
    prefix: 'far',
    iconName: 'fingerprint',
    icon: [512, 512, [], "f577", "M256 246C243 246 232 257 232 270C233 342 224 412 204 482C202 491 207 512 227 512C238 512 248 505 251 494C264 447 282 369 280 270C280 257 269 246 256 246ZM255 164C194 164 151 211 152 265C153 313 148 361 139 408C136 421 144 434 157 436C170 439 183 431 186 418C196 368 201 316 200 265C200 239 220 212 255 212C286 213 312 238 312 268C313 316 309 364 302 411C299 424 308 437 321 439C341 442 348 424 349 419C357 369 361 318 360 267C359 211 312 165 255 164ZM145 145C134 136 119 138 111 148C85 179 71 219 72 260C73 298 70 335 63 372C61 385 69 398 82 400C102 403 109 385 110 381C117 341 121 300 120 259C120 229 129 201 148 178C156 168 155 153 145 145ZM254 82C239 82 223 84 208 87C195 90 187 103 190 116C193 129 206 137 219 134C230 131 242 130 253 130C329 131 391 192 392 265C393 303 391 341 387 378C385 392 395 403 408 405C424 407 433 393 434 384C439 344 441 304 440 264C439 165 355 84 254 82ZM506 204C503 191 491 182 477 185C464 188 456 201 459 214C464 235 464 251 464 276C464 289 474 300 488 300H488C501 300 512 289 512 276C512 254 512 232 506 204ZM466 113C417 44 338 1 253 0C183 -1 119 25 71 73C24 119 -1 181 0 247L0 268C0 281 10 292 23 293C24 293 24 293 24 293C37 293 48 283 48 270L48 246C47 193 67 144 104 107C143 68 196 47 252 48C322 49 387 84 427 140C434 151 449 154 460 146C471 139 474 124 466 113Z"]
  };
  var faFire = {
    prefix: 'far',
    iconName: 'fire',
    icon: [448, 512, [], "f06d", "M323 51C303 71 284 91 267 111C240 74 206 35 168 0C70 91 0 210 0 282C0 409 100 512 224 512S448 409 448 282C448 228 396 118 323 51ZM224 464C127 464 48 382 48 282C48 236 92 148 168 68C190 91 211 115 229 139L265 190L305 142C310 134 316 127 322 121C369 178 400 250 400 282C400 382 321 464 224 464ZM314 243L262 302C262 302 182 199 176 192C133 243 112 273 112 306C112 374 163 416 226 416C252 416 275 408 294 395C337 365 347 306 323 261C320 255 317 249 314 243Z"]
  };
  var faFireExtinguisher = {
    prefix: 'far',
    iconName: 'fire-extinguisher',
    icon: [512, 512, [], "f134", "M503 6C498 1 491 -1 484 0L308 32C296 34 288 44 288 56H200V24C200 11 189 0 176 0S152 11 152 24V56H120C54 56 0 110 0 176C0 189 11 200 24 200S48 189 48 176C48 136 80 104 120 104H152V131C102 142 64 186 64 240V480C64 498 78 512 96 512H256C274 512 288 498 288 480V240C288 186 250 142 200 131V104H288C288 116 296 126 308 128L484 160C485 160 487 160 488 160C494 160 499 158 503 154C509 150 512 143 512 136V24C512 17 509 10 503 6ZM240 464H112V432H240V464ZM240 240V384H112V240C112 205 141 176 176 176C211 176 240 205 240 240Z"]
  };
  var faFireFlame = {
    prefix: 'far',
    iconName: 'fire-flame',
    icon: [384, 512, [], "f6df", "M192 0C80 101 0 221 0 301C0 425 79 512 192 512S384 425 384 301C384 221 304 101 192 0ZM192 464C106 464 48 398 48 301C48 254 93 164 192 66C278 152 336 245 336 301C336 398 278 464 192 464ZM237 240C217 223 198 207 198 182C198 178 196 177 194 176C192 176 189 176 186 179C131 253 216 248 216 302C216 325 197 344 174 344C151 344 132 325 132 302V272C132 270 130 267 128 266C126 266 124 266 122 268C115 274 96 294 96 328C96 376 139 416 192 416S288 376 288 328C288 283 262 261 237 240Z"]
  };
  var faFireFlameCurved = {
    prefix: 'far',
    iconName: 'fire-flame-curved',
    icon: [384, 512, [], "f7e4", "M216 24C216 0 185 -9 172 11C77 158 200 239 200 288C200 310 182 328 160 328C138 328 120 310 120 288V182C120 163 98 151 82 162C31 198 0 257 0 320C0 426 86 512 192 512S384 426 384 320C384 150 216 127 216 24ZM192 464C113 464 48 399 48 320C48 291 57 255 72 232V288C72 337 111 376 160 376S248 337 248 288C248 224 160 168 184 80C224 168 336 202 336 320C336 399 271 464 192 464Z"]
  };
  var faFireFlameSimple = {
    prefix: 'far',
    iconName: 'fire-flame-simple',
    icon: [384, 512, [], "f46a", "M192 0C86 94 0 214 0 298C0 424 79 512 192 512S384 424 384 298C384 214 297 93 192 0ZM192 65C243 116 336 224 336 298C336 328 330 354 321 376C317 302 237 219 192 168C146 219 67 302 63 376C54 354 48 327 48 298C48 224 141 116 192 65ZM174 462C136 455 111 423 111 381C111 360 124 316 192 240C260 317 274 361 274 381C274 423 248 455 210 462C189 465 195 465 174 462Z"]
  };
  var faFireSmoke = {
    prefix: 'far',
    iconName: 'fire-smoke',
    icon: [640, 512, [], "f74b", "M352 200C352 200 282 128 277 122C240 167 222 193 222 223C222 235 224 245 227 254C254 235 286 224 320 224C352 224 384 234 410 253C416 230 414 205 403 183C400 178 397 173 394 167L352 200ZM152 240C168 240 183 243 197 247C194 236 192 225 192 213C192 183 223 123 276 67C291 82 304 98 316 113L352 161L391 115C393 113 395 110 397 108C429 149 448 196 448 213C448 225 446 236 443 247C457 243 472 240 488 240C490 240 492 241 494 241C495 232 496 222 496 213C496 173 455 90 398 39C382 53 367 69 354 84C333 56 306 27 276 0C199 69 144 159 144 213C144 222 145 232 146 241C148 241 150 240 152 240ZM486 282C462 282 438 290 419 305C396 274 359 256 320 256S244 274 221 305C202 290 178 282 154 282C91 282 40 334 40 397S91 512 154 512H486C549 512 600 460 600 397S549 282 486 282ZM486 464H154C117 464 88 434 88 397S117 330 154 330C174 330 194 340 206 357C211 365 220 368 228 367C237 366 245 361 248 353C260 323 289 304 320 304S380 323 392 353C396 361 403 366 412 367C420 368 429 365 434 357C446 340 466 330 486 330C523 330 552 360 552 397S523 464 486 464Z"]
  };
  var faFireplace = {
    prefix: 'far',
    iconName: 'fireplace',
    icon: [640, 512, [], "f79a", "M342 312C328 293 311 274 291 256C241 302 205 361 205 397C205 460 256 512 320 512S435 460 435 397C435 370 409 315 371 282C361 291 351 301 342 312ZM358 449C347 456 334 461 320 461C285 461 256 436 256 397C256 377 268 360 292 330C295 334 340 394 340 394L369 360C371 363 372 367 374 370C387 397 382 431 358 449ZM608 0H32C14 0 0 14 0 32V96C0 114 14 128 32 128V488C32 501 43 512 56 512S80 501 80 488V128H560V488C560 501 571 512 584 512S608 501 608 488V128C626 128 640 114 640 96V32C640 14 626 0 608 0ZM592 72C592 76 588 80 584 80H56C52 80 48 76 48 72V56C48 52 52 48 56 48H584C588 48 592 52 592 56V72ZM318 160C201 161 112 261 112 375V488C112 501 123 512 136 512S160 501 160 488V373C160 286 234 208 320 208C408 208 480 279 480 368V488C480 501 491 512 504 512S528 501 528 488V369C528 253 434 159 318 160Z"]
  };
  var faFish = {
    prefix: 'far',
    iconName: 'fish',
    icon: [576, 512, [], "f578", "M324 64C232 64 160 126 126 162L65 113C52 101 35 100 20 108C5 116 -2 133 1 151L26 256L1 362C-2 379 5 396 20 404C35 412 52 411 64 400L126 350C160 386 232 448 324 448C463 448 576 303 576 256S463 64 324 64ZM324 400C253 400 186 349 148 302L133 284L53 347L75 256L53 165L133 228L148 210C186 163 253 112 324 112C434 112 525 232 528 256C525 280 434 400 324 400ZM416 224C398 224 384 238 384 256C384 274 398 288 416 288S448 274 448 256C448 238 434 224 416 224Z"]
  };
  var faFishCooked = {
    prefix: 'far',
    iconName: 'fish-cooked',
    icon: [576, 512, [], "f7fe", "M324 64C232 64 160 126 126 162L65 113C52 101 35 100 20 108C5 116 -2 133 1 151L26 256L1 362C-2 379 5 396 20 404C35 412 52 411 64 400L126 350C160 386 232 448 324 448C463 448 576 303 576 256S463 64 324 64ZM324 400C253 400 186 349 148 302L133 284L53 347L75 256L53 165L133 228L148 210C186 163 253 112 324 112C434 112 525 232 528 256C525 280 434 400 324 400ZM251 251L315 187C322 181 322 171 315 165C309 158 299 158 293 165L229 229C222 235 222 245 229 251C232 254 236 256 240 256S248 254 251 251ZM427 165C421 158 411 158 405 165L245 325C238 331 238 341 245 347C248 350 252 352 256 352S264 350 267 347L427 187C434 181 434 171 427 165ZM421 261L357 325C350 331 350 341 357 347C360 350 364 352 368 352S376 350 379 347L443 283C450 277 450 267 443 261S427 254 421 261Z"]
  };
  var faFistRaised = {
    prefix: 'far',
    iconName: 'fist-raised',
    icon: [448, 512, [], "f6de", "M400 180V88C400 57 375 32 344 32H320C316 32 311 33 307 34C299 14 279 0 256 0H232C209 0 189 14 181 34C177 33 172 32 168 32H144C121 32 101 46 93 66C89 65 84 64 80 64H56C25 64 0 89 0 120V331C0 371 16 410 45 438L64 458V496C64 505 71 512 80 512H96C105 512 112 505 112 496V438L78 405C59 385 48 358 48 331V271C51 272 53 272 56 272H80C92 272 103 268 112 262C121 268 132 272 144 272H168C180 272 191 268 200 262C204 273 211 283 220 292C224 296 228 299 232 302C214 318 199 338 183 363C177 371 179 383 188 390L196 394C205 401 217 398 223 389C252 345 270 325 306 321C314 320 320 313 320 305V288C320 279 313 272 304 272H287C261 272 240 251 240 225V224C240 215 247 208 256 208H336C371 208 400 237 400 272V320C400 346 390 370 372 388L320 440V496C320 505 327 512 336 512H352C361 512 368 505 368 496V460L406 422C433 395 448 358 448 320V272C448 234 429 201 400 180ZM80 224H56C52 224 48 220 48 216V120C48 116 52 112 56 112H80C84 112 88 116 88 120V216C88 220 84 224 80 224ZM176 216C176 220 172 224 168 224H144C140 224 136 220 136 216V88C136 84 140 80 144 80H168C172 80 176 84 176 88V216ZM224 169V56C224 52 228 48 232 48H256C260 48 264 52 264 56V160H256C244 160 234 163 224 169ZM312 160V88C312 84 316 80 320 80H344C348 80 352 84 352 88V162C347 161 342 160 336 160H312Z"]
  };
  var faFlag = {
    prefix: 'far',
    iconName: 'flag',
    icon: [512, 512, [], "f024", "M476 0C470 0 463 1 457 4C411 25 377 32 349 32C289 32 254 0 185 0H185C151 0 107 8 48 32V24C48 11 37 0 24 0S0 11 0 24V488C0 501 11 512 24 512S48 501 48 488V384C102 360 144 352 181 352C254 352 306 384 379 384C411 384 447 378 491 361C504 356 512 344 512 332V31C512 12 495 0 476 0ZM464 320C434 331 406 336 379 336C349 336 321 329 292 322C260 313 224 304 181 304C138 304 95 313 48 332V84L66 77C113 58 152 48 185 48C213 48 234 55 258 63C284 71 313 80 349 80C385 80 421 72 464 54V320Z"]
  };
  var faFlagCheckered = {
    prefix: 'far',
    iconName: 'flag-checkered',
    icon: [512, 512, [], "f11e", "M476 0C470 0 463 1 457 4C411 25 377 32 349 32C289 32 254 0 185 0H185C151 0 107 8 48 32V24C48 11 37 0 24 0S0 11 0 24V488C0 501 11 512 24 512S48 501 48 488V384C102 360 144 352 181 352C254 352 306 384 379 384C411 384 447 378 491 361C504 356 512 344 512 332V31C512 12 495 0 476 0ZM120 310C97 315 73 322 48 332V284L66 277C86 269 103 263 120 258V310ZM120 209C99 214 75 221 48 232V188L66 181C86 173 103 167 120 162V209ZM120 113C99 118 75 125 48 136V84L66 77C86 69 103 63 120 59V113ZM240 310C222 306 202 304 181 304C177 304 172 305 168 305V249C174 249 180 248 185 248C206 248 223 252 240 257V310ZM240 207C224 203 206 200 185 200H185C180 200 174 201 168 201V153C174 153 180 152 185 152C206 152 223 156 240 161V207ZM240 111C224 107 206 104 185 104H185C180 104 174 105 168 105V49C174 49 180 48 185 48C206 48 223 52 240 57V111ZM360 335C337 333 315 327 292 322C291 321 289 321 288 321V271C306 276 326 280 349 280C353 280 356 279 360 279V335ZM360 231C356 231 353 232 349 232C326 232 307 227 288 221V175C306 180 326 184 349 184C353 184 356 183 360 183V231ZM360 135C356 135 353 136 349 136C326 136 307 131 288 125V71C306 76 326 80 349 80C353 80 356 80 360 80V135ZM464 320C444 327 426 331 408 334V272C426 268 444 262 464 253V320ZM464 202C462 202 459 203 457 204C439 212 423 218 408 222V176C426 172 444 166 464 157V202ZM464 106C462 106 459 107 457 108C439 116 423 122 408 126V72C426 68 444 62 464 54V106Z"]
  };
  var faFlagPennant = {
    prefix: 'far',
    iconName: 'flag-pennant',
    icon: [512, 512, [], "f456", "M496 185L47 20C45 9 36 0 24 0C11 0 0 11 0 24V488C0 501 11 512 24 512S48 501 48 488V396L496 231C506 227 512 218 512 208S506 189 496 185ZM48 345V71L419 208L48 345Z"]
  };
  var faFlagSwallowtail = {
    prefix: 'far',
    iconName: 'flag-swallowtail',
    icon: [512, 512, [], "f74c", "M391 208L506 71C512 64 514 54 510 46S497 32 488 32H48V24C48 11 37 0 24 0S0 11 0 24V488C0 501 11 512 24 512S48 501 48 488V384H488C497 384 506 379 510 370S512 352 506 345L391 208ZM48 336V80H436L342 193C334 201 334 215 342 223L436 336H48Z"]
  };
  var faFlagUsa = {
    prefix: 'far',
    iconName: 'flag-usa',
    icon: [512, 512, [], "f74d", "M476 0C470 0 463 1 457 4C411 25 377 32 349 32C289 32 254 0 185 0H185C151 0 107 8 48 32V24C48 11 37 0 24 0C11 0 0 11 0 24V488C0 501 11 512 24 512C37 512 48 501 48 488V384C102 360 144 352 181 352C254 352 306 384 379 384C411 384 447 378 491 361C504 356 512 344 512 332V31C512 12 495 0 476 0ZM152 32C161 32 168 39 168 48S161 64 152 64S136 57 136 48S143 32 152 32ZM152 88C161 88 168 95 168 104S161 120 152 120S136 113 136 104S143 88 152 88ZM88 48C97 48 104 55 104 64S97 80 88 80S72 73 72 64S79 48 88 48ZM88 112C97 112 104 119 104 128S97 144 88 144S72 137 72 128S79 112 88 112ZM464 320C434 331 406 336 379 336C349 336 321 329 292 322C260 313 224 304 181 304C138 304 95 313 48 332V284L66 277C113 257 152 248 185 248C213 248 234 255 258 262C284 271 313 280 349 280C385 280 421 271 464 253V320ZM464 202C462 202 459 203 457 204C411 225 377 232 349 232C289 232 254 200 185 200H185C151 200 107 208 48 232V188L66 181C113 161 152 152 185 152C213 152 234 159 259 166C284 175 313 184 349 184C385 184 421 175 464 157V202ZM464 106C462 106 459 107 457 108C411 129 377 136 349 136C296 136 263 111 208 105V50C226 52 241 57 259 63C284 71 313 80 349 80C385 80 421 72 464 54V106Z"]
  };
  var faFlashlight = {
    prefix: 'far',
    iconName: 'flashlight',
    icon: [640, 512, [], "f8b8", "M608 96H576C513 96 452 114 400 149L384 160H48C22 160 0 182 0 208V304C0 330 22 352 48 352H384L400 363C452 398 513 416 576 416H608C626 416 640 402 640 384V128C640 110 626 96 608 96ZM544 366C502 361 462 346 427 323L398 304H48V208H398L427 189C462 166 502 151 544 146V366ZM284 232H260C247 232 236 243 236 256C236 269 247 280 260 280H284C297 280 308 269 308 256C308 243 297 232 284 232Z"]
  };
  var faFlask = {
    prefix: 'far',
    iconName: 'flask',
    icon: [448, 512, [], "f0c3", "M437 403L320 215V48H328C341 48 352 37 352 24S341 0 328 0H120C107 0 96 11 96 24S107 48 120 48H128V215L11 404C-18 451 15 512 71 512H377C433 512 466 450 437 403ZM119 320L176 229V48H272V229L329 320H119Z"]
  };
  var faFlaskRoundPoison = {
    prefix: 'far',
    iconName: 'flask-round-poison',
    icon: [448, 512, [], "f6e0", "M320 169V48H328C341 48 352 37 352 24C352 11 341 0 328 0H120C107 0 96 11 96 24C96 37 107 48 120 48H128V168C62 203 16 272 16 352C16 406 36 455 70 492C82 505 99 512 117 512H331C349 512 366 505 378 491C411 455 431 408 432 357C434 277 387 205 320 169ZM343 459C340 462 336 464 331 464H117C112 464 108 462 106 459C79 430 64 392 64 352C64 293 97 238 150 211L176 197V48H272V198L297 211C351 240 385 297 384 355C383 394 368 431 343 459ZM224 256C175 256 135 288 135 327C135 350 149 371 171 384V398C171 408 179 416 189 416H260C269 416 277 408 277 398V384C299 371 313 350 313 327C313 288 273 256 224 256ZM189 345C179 345 171 337 171 327C171 317 179 309 189 309C198 309 206 317 206 327C206 337 198 345 189 345ZM259 345C250 345 242 337 242 327C242 317 250 309 259 309C269 309 277 317 277 327C277 337 269 345 259 345Z"]
  };
  var faFlaskRoundPotion = {
    prefix: 'far',
    iconName: 'flask-round-potion',
    icon: [448, 512, [], "f6e1", "M320 169V48H328C341 48 352 37 352 24C352 11 341 0 328 0H120C107 0 96 11 96 24C96 37 107 48 120 48H128V168C62 203 16 272 16 352C16 406 36 455 70 492C82 505 99 512 117 512H331C349 512 366 505 378 491C411 455 431 408 432 357C434 277 387 205 320 169ZM267 329C207 299 139 297 65 333C72 281 103 235 150 211L176 197V48H272V198L297 211C350 240 384 295 384 352C358 352 317 354 267 329Z"]
  };
  var faFlorinSign = {
    prefix: 'far',
    iconName: 'florin-sign',
    icon: [384, 512, [], "e12e", "M384 56C384 69 373 80 360 80H309C292 80 277 91 271 106L226 232H328C341 232 352 243 352 256S341 280 328 280H209L158 422C145 457 112 480 75 480H24C11 480 0 469 0 456S11 432 24 432H75C92 432 107 421 113 406L158 280H56C43 280 32 269 32 256S43 232 56 232H175L226 90C239 55 272 32 309 32H360C373 32 384 43 384 56Z"]
  };
  var faFlower = {
    prefix: 'far',
    iconName: 'flower',
    icon: [512, 512, [], "f7ff", "M480 170C480 94 418 32 342 32C310 32 280 43 256 62C232 43 202 32 170 32C94 32 32 94 32 170C32 202 43 232 62 256C43 280 32 310 32 342C32 418 94 480 170 480C202 480 232 469 256 450C280 469 310 480 342 480C418 480 480 418 480 342C480 310 469 280 450 256C469 232 480 202 480 170ZM401 274C421 292 432 316 432 342C432 391 391 432 342 432C316 432 292 421 274 401L256 380L238 401C220 421 196 432 170 432C120 432 80 391 80 342C80 316 91 292 111 274L132 256L111 238C91 220 80 196 80 170C80 121 121 80 170 80C196 80 220 91 238 111L256 132L274 111C292 91 316 80 342 80C391 80 432 120 432 170C432 196 421 220 401 238L380 256L401 274ZM256 176C212 176 176 212 176 256S212 336 256 336S336 300 336 256S300 176 256 176ZM256 288C238 288 224 274 224 256S238 224 256 224S288 238 288 256S274 288 256 288Z"]
  };
  var faFlowerDaffodil = {
    prefix: 'far',
    iconName: 'flower-daffodil',
    icon: [512, 512, [], "f800", "M496 288H449C381 288 321 318 280 365V283C317 296 359 283 382 251C406 219 406 176 383 144C394 129 400 110 400 91C400 41 359 0 309 0C290 0 271 6 256 18C241 6 222 0 203 0C153 0 112 41 112 91C112 110 118 129 129 144C118 159 112 178 112 197C112 227 126 254 150 271S204 293 232 283V365C191 318 131 288 63 288H16C7 288 -1 297 0 308C10 422 106 512 224 512H288C406 512 502 422 512 308C513 297 505 288 496 288ZM224 464C144 464 75 410 54 336C129 336 183 368 215 422L240 464H224ZM237 223C227 236 210 242 194 239C177 236 164 223 161 206C157 190 164 173 177 163L203 144L177 125C166 117 160 104 160 91C160 67 179 48 203 48C216 48 229 54 237 65L256 91L275 65C283 54 296 48 309 48C333 48 352 67 352 91C352 104 345 117 335 125L309 144L335 163C345 171 352 184 352 197C352 221 333 240 309 240C296 240 283 234 275 223L256 197L237 223ZM288 464H272L297 422C329 369 382 336 458 336C437 410 368 464 288 464ZM288 144C288 126 274 112 256 112S224 126 224 144S238 176 256 176S288 162 288 144Z"]
  };
  var faFlowerTulip = {
    prefix: 'far',
    iconName: 'flower-tulip',
    icon: [512, 512, [], "f801", "M496 288H449C381 288 321 318 280 365V288C355 287 416 226 416 150V16C416 10 413 5 407 2C402 -1 395 0 391 3L317 57L268 6C265 2 261 0 256 0C251 0 247 2 244 6L195 57L121 3C117 0 110 -1 105 2C99 5 96 10 96 16V150C96 226 157 287 232 288V365C191 318 131 288 63 288H16C7 288 -1 297 0 308C10 422 106 512 224 512H288C406 512 502 422 512 308C513 297 505 288 496 288ZM144 150V78L200 120L256 64L312 120L368 78V150C368 200 328 240 278 240H234C184 240 144 200 144 150ZM224 464C144 464 75 410 54 336C129 336 183 368 215 422L240 464H224ZM288 464H272L297 422C329 369 382 336 458 336C437 410 368 464 288 464Z"]
  };
  var faFlute = {
    prefix: 'far',
    iconName: 'flute',
    icon: [640, 512, [], "f8b9", "M320 232C307 232 296 243 296 256S307 280 320 280S344 269 344 256S333 232 320 232ZM576 160H64C29 160 0 189 0 224V288C0 323 29 352 64 352H576C611 352 640 323 640 288V224C640 189 611 160 576 160ZM96 304H64C55 304 48 297 48 288V224C48 215 55 208 64 208H96V304ZM592 288C592 297 585 304 576 304H144V208H576C585 208 592 215 592 224V288ZM512 232C499 232 488 243 488 256S499 280 512 280S536 269 536 256S525 232 512 232ZM416 232C403 232 392 243 392 256S403 280 416 280S440 269 440 256S429 232 416 232Z"]
  };
  var faFluxCapacitor = {
    prefix: 'far',
    iconName: 'flux-capacitor',
    icon: [448, 512, [], "f8ba", "M448 120V392C448 441 409 480 360 480H88C39 480 0 441 0 392V120C0 71 39 32 88 32H360C409 32 448 71 448 120ZM400 120C400 98 382 80 360 80H88C66 80 48 98 48 120V392C48 414 66 432 88 432H360C382 432 400 414 400 392V120ZM384 176C384 220 348 256 304 256C297 256 290 255 283 253L332 204C339 198 344 185 344 176C344 153 327 136 304 136C295 136 282 141 276 148L224 199L172 148C166 141 153 135 143 135C121 135 103 153 103 175C103 185 109 198 116 204L164 253C158 255 151 256 144 256C100 256 64 220 64 176S100 96 144 96S224 132 224 176C224 132 260 96 304 96S384 132 384 176ZM208 336V263L133 187C130 184 129 180 128 176C128 172 130 168 133 165C136 162 140 160 144 160C148 161 152 162 155 165L224 233L293 165C296 162 300 160 304 160C308 160 312 162 315 165C318 168 320 172 320 176C320 180 318 184 315 187L240 263V336C240 345 233 352 224 352S208 345 208 336ZM304 336C304 380 268 416 224 416S144 380 144 336C144 312 160 282 180 269L184 273V336C184 358 202 376 224 376S264 358 264 336V273L267 269C288 282 304 312 304 336Z"]
  };
  var faFolder = {
    prefix: 'far',
    iconName: 'folder',
    icon: [512, 512, [], "f07b", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V192H48V96C48 87 55 80 64 80ZM448 432H64C55 432 48 425 48 416V240H464V416C464 425 457 432 448 432Z"]
  };
  var faFolderArrowDown = {
    prefix: 'far',
    iconName: 'folder-arrow-down',
    icon: [512, 512, [], "e053", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM319 271L280 310V208C280 195 269 184 256 184S232 195 232 208V310L193 271C184 262 168 262 159 271S150 296 159 305L239 385C244 390 250 392 256 392S268 390 273 385L353 305C362 296 362 280 353 271S328 262 319 271Z"]
  };
  var faFolderArrowUp = {
    prefix: 'far',
    iconName: 'folder-arrow-up',
    icon: [512, 512, [], "e054", "M273 191C264 182 248 182 239 191L159 271C150 280 150 296 159 305S184 314 193 305L232 266V368C232 381 243 392 256 392S280 381 280 368V266L319 305C324 310 330 312 336 312S348 310 353 305C362 296 362 280 353 271L273 191ZM448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416Z"]
  };
  var faFolderBlank = {
    prefix: 'far',
    iconName: 'folder-blank',
    icon: [512, 512, [], "e12f", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416Z"]
  };
  var faFolderBookmark = {
    prefix: 'far',
    iconName: 'folder-bookmark',
    icon: [512, 512, [], "e130", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144V304C256 317 272 325 282 316L336 273L390 316C400 325 416 317 416 304V144H448C457 144 464 151 464 160V416Z"]
  };
  var faFolderGear = {
    prefix: 'far',
    iconName: 'folder-gear',
    icon: [512, 512, [], "e131", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416Z"]
  };
  var faFolderGrid = {
    prefix: 'far',
    iconName: 'folder-grid',
    icon: [512, 512, [], "e132", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM160 240H96C87 240 80 247 80 256V320C80 329 87 336 96 336H160C169 336 176 329 176 320V256C176 247 169 240 160 240ZM288 240H224C215 240 208 247 208 256V320C208 329 215 336 224 336H288C297 336 304 329 304 320V256C304 247 297 240 288 240ZM416 240H352C343 240 336 247 336 256V320C336 329 343 336 352 336H416C425 336 432 329 432 320V256C432 247 425 240 416 240Z"]
  };
  var faFolderHeart = {
    prefix: 'far',
    iconName: 'folder-heart',
    icon: [512, 512, [], "e133", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM264 211L256 220L247 211C226 189 191 185 168 205C141 228 139 269 163 294L246 380C252 385 260 385 266 380L349 294C373 269 371 228 344 205C321 185 286 189 264 211Z"]
  };
  var faFolderImage = {
    prefix: 'far',
    iconName: 'folder-image',
    icon: [512, 512, [], "e134", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM128 240C146 240 160 226 160 208S146 176 128 176S96 190 96 208S110 240 128 240ZM307 215C304 211 299 208 293 208S283 211 280 215L217 309L195 279C192 274 187 272 182 272C177 272 172 274 169 279L99 375C95 379 95 386 98 391C100 397 106 400 112 400H400C406 400 411 397 414 392C417 386 417 380 413 375L307 215Z"]
  };
  var faFolderMagnifyingGlass = {
    prefix: 'far',
    iconName: 'folder-magnifying-glass',
    icon: [512, 512, [], "e135", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM322 320C331 306 336 290 336 272C336 219 293 176 240 176S144 219 144 272S187 368 240 368C258 368 274 363 288 354L335 401C340 406 346 408 352 408S364 406 369 401C378 392 378 376 369 367L322 320ZM240 320C214 320 192 298 192 272S214 224 240 224S288 246 288 272S266 320 240 320Z"]
  };
  var faFolderMedical = {
    prefix: 'far',
    iconName: 'folder-medical',
    icon: [512, 512, [], "e136", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM336 256H288V208C288 199 281 192 272 192H240C231 192 224 199 224 208V256H176C167 256 160 263 160 272V304C160 313 167 320 176 320H224V368C224 377 231 384 240 384H272C281 384 288 377 288 368V320H336C345 320 352 313 352 304V272C352 263 345 256 336 256Z"]
  };
  var faFolderMinus = {
    prefix: 'far',
    iconName: 'folder-minus',
    icon: [512, 512, [], "f65d", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM328 264H184C171 264 160 275 160 288S171 312 184 312H328C341 312 352 301 352 288S341 264 328 264Z"]
  };
  var faFolderMusic = {
    prefix: 'far',
    iconName: 'folder-music',
    icon: [512, 512, [], "e137", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM331 177L203 224C197 226 192 232 192 239V354C187 353 181 352 176 352C150 352 128 366 128 384S150 416 176 416S224 402 224 384V283L320 246V322C315 321 309 320 304 320C278 320 256 334 256 352S278 384 304 384S352 370 352 352V192C352 187 350 182 346 179S336 175 331 177Z"]
  };
  var faFolderOpen = {
    prefix: 'far',
    iconName: 'folder-open',
    icon: [576, 512, [], "f07c", "M573 270L477 462C471 473 460 480 448 480H64C29 480 0 451 0 416V96C0 61 29 32 64 32H182C198 32 215 39 227 51L276 96H416C451 96 480 125 480 160V192H432V160C432 151 425 144 416 144H256L193 85C190 82 186 80 182 80H64C55 80 48 87 48 96V384L119 242C125 231 136 224 148 224H544C568 224 583 249 573 270Z"]
  };
  var faFolderPlus = {
    prefix: 'far',
    iconName: 'folder-plus',
    icon: [512, 512, [], "f65e", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM328 264H280V216C280 203 269 192 256 192S232 203 232 216V264H184C171 264 160 275 160 288S171 312 184 312H232V360C232 373 243 384 256 384S280 373 280 360V312H328C341 312 352 301 352 288S341 264 328 264Z"]
  };
  var faFolderTree = {
    prefix: 'far',
    iconName: 'folder-tree',
    icon: [576, 512, [], "f802", "M544 320H448L404 293C399 290 393 288 387 288H320C302 288 288 302 288 320V480C288 498 302 512 320 512H544C562 512 576 498 576 480V352C576 334 562 320 544 320ZM528 464H336V336H382L423 361C430 366 439 368 448 368H528V464ZM232 160C245 160 256 149 256 136C256 123 245 112 232 112H48V24C48 11 37 0 24 0S0 11 0 24V392C0 423 25 448 56 448H232C245 448 256 437 256 424C256 411 245 400 232 400H56C52 400 48 396 48 392V160H232ZM544 32H448L404 5C399 2 393 0 387 0H320C302 0 288 14 288 32V192C288 210 302 224 320 224H544C562 224 576 210 576 192V64C576 46 562 32 544 32ZM528 176H336V48H382L423 73C430 78 439 80 448 80H528V176Z"]
  };
  var faFolderUser = {
    prefix: 'far',
    iconName: 'folder-user',
    icon: [512, 512, [], "e138", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H382C375 387 336 352 288 352H224C176 352 137 387 130 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM256 192C221 192 192 221 192 256C192 291 221 320 256 320S320 291 320 256C320 221 291 192 256 192Z"]
  };
  var faFolderXmark = {
    prefix: 'far',
    iconName: 'folder-xmark',
    icon: [512, 512, [], "f65f", "M448 96H276L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H182C186 80 190 82 193 85L256 144H448C457 144 464 151 464 160V416ZM324 220C314 211 299 211 290 220L256 254L222 220C213 211 197 211 188 220S179 245 188 254L222 288L188 322C179 331 179 347 188 356C193 361 199 363 205 363S217 361 222 356L256 322L290 356C295 361 301 363 307 363S319 361 324 356C333 347 333 331 324 322L290 288L324 254C333 245 333 230 324 220Z"]
  };
  var faFolders = {
    prefix: 'far',
    iconName: 'folders',
    icon: [640, 512, [], "f660", "M80 400V160C54 160 32 182 32 208V416C32 451 61 480 96 480H464C490 480 512 458 512 432H112C94 432 80 418 80 400ZM544 96H404L355 51C343 39 326 32 310 32H192C157 32 128 61 128 96V320C128 355 157 384 192 384H544C579 384 608 355 608 320V160C608 125 579 96 544 96ZM560 320C560 329 553 336 544 336H192C183 336 176 329 176 320V96C176 87 183 80 192 80H310C314 80 318 82 321 85L384 144H544C553 144 560 151 560 160V320Z"]
  };
  var faFont = {
    prefix: 'far',
    iconName: 'font',
    icon: [448, 512, [], "f031", "M424 432H393L246 47C243 38 234 32 224 32C224 32 224 32 224 32C214 32 205 38 202 47L48 432H24C11 432 0 443 0 456S11 480 24 480H136C149 480 160 469 160 456S149 432 136 432H99L135 344H308L341 432H312C299 432 288 443 288 456S299 480 312 480H424C437 480 448 469 448 456S437 432 424 432ZM154 296L223 122L290 296H154Z"]
  };
  var faFontAwesomeLogoFull = {
    prefix: 'far',
    iconName: 'font-awesome-logo-full',
    icon: [3992, 512, ["Font Awesome"], "f4e6", "M454.6 0H57.4C25.9 0 0 25.9 0 57.4v397.3C0 486.1 25.9 512 57.4 512h397.3c31.4 0 57.4-25.9 57.4-57.4V57.4C512 25.9 486.1 0 454.6 0zm-58.9 324.9c0 4.8-4.1 6.9-8.9 8.9-19.2 8.1-39.7 15.7-61.5 15.7-40.5 0-68.7-44.8-163.2 2.5v51.8c0 30.3-45.7 30.2-45.7 0v-250c-9-7-15-17.9-15-30.3 0-21 17.1-38.2 38.2-38.2 21 0 38.2 17.1 38.2 38.2 0 12.2-5.8 23.2-14.9 30.2v21c37.1-12 65.5-34.4 146.1-3.4 26.6 11.4 68.7-15.7 76.5-15.7 5.5 0 10.3 4.1 10.3 8.9v160.4zm432.9-174.2h-137v70.1H825c39.8 0 40.4 62.2 0 62.2H691.6v105.6c0 45.5-70.7 46.4-70.7 0V128.3c0-22 18-39.8 39.8-39.8h167.8c39.6 0 40.5 62.2.1 62.2zm191.1 23.4c-169.3 0-169.1 252.4 0 252.4 169.9 0 169.9-252.4 0-252.4zm0 196.1c-81.6 0-82.1-139.8 0-139.8 82.5 0 82.4 139.8 0 139.8zm372.4 53.4c-17.5 0-31.4-13.9-31.4-31.4v-117c0-62.4-72.6-52.5-99.1-16.4v133.4c0 41.5-63.3 41.8-63.3 0V208c0-40 63.1-41.6 63.1 0v3.4c43.3-51.6 162.4-60.4 162.4 39.3v141.5c.3 30.4-31.5 31.4-31.7 31.4zm179.7 2.9c-44.3 0-68.3-22.9-68.3-65.8V235.2H1488c-35.6 0-36.7-55.3 0-55.3h15.5v-37.3c0-41.3 63.8-42.1 63.8 0v37.5h24.9c35.4 0 35.7 55.3 0 55.3h-24.9v108.5c0 29.6 26.1 26.3 27.4 26.3 31.4 0 52.6 56.3-22.9 56.3zM1992 123c-19.5-50.2-95.5-50-114.5 0-107.3 275.7-99.5 252.7-99.5 262.8 0 42.8 58.3 51.2 72.1 14.4l13.5-35.9H2006l13 35.9c14.2 37.7 72.1 27.2 72.1-14.4 0-10.1 5.3 6.8-99.1-262.8zm-108.9 179.1l51.7-142.9 51.8 142.9h-103.5zm591.3-85.6l-53.7 176.3c-12.4 41.2-72 41-84 0l-42.3-135.9-42.3 135.9c-12.4 40.9-72 41.2-84.5 0l-54.2-176.3c-12.5-39.4 49.8-56.1 60.2-16.9L2213 342l45.3-139.5c10.9-32.7 59.6-34.7 71.2 0l45.3 139.5 39.3-142.4c10.3-38.3 72.6-23.8 60.3 16.9zm275.4 75.1c0-42.4-33.9-117.5-119.5-117.5-73.2 0-124.4 56.3-124.4 126 0 77.2 55.3 126.4 128.5 126.4 31.7 0 93-11.5 93-39.8 0-18.3-21.1-31.5-39.3-22.4-49.4 26.2-109 8.4-115.9-43.8h148.3c16.3 0 29.3-13.4 29.3-28.9zM2571 277.7c9.5-73.4 113.9-68.6 118.6 0H2571zm316.7 148.8c-31.4 0-81.6-10.5-96.6-31.9-12.4-17 2.5-39.8 21.8-39.8 16.3 0 36.8 22.9 77.7 22.9 27.4 0 40.4-11 40.4-25.8 0-39.8-142.9-7.4-142.9-102 0-40.4 35.3-75.7 98.6-75.7 31.4 0 74.1 9.9 87.6 29.4 10.8 14.8-1.4 36.2-20.9 36.2-15.1 0-26.7-17.3-66.2-17.3-22.9 0-37.8 10.5-37.8 23.8 0 35.9 142.4 6 142.4 103.1-.1 43.7-37.4 77.1-104.1 77.1zm266.8-252.4c-169.3 0-169.1 252.4 0 252.4 170.1 0 169.6-252.4 0-252.4zm0 196.1c-81.8 0-82-139.8 0-139.8 82.5 0 82.4 139.8 0 139.8zm476.9 22V268.7c0-53.8-61.4-45.8-85.7-10.5v134c0 41.3-63.8 42.1-63.8 0V268.7c0-52.1-59.5-47.4-85.7-10.1v133.6c0 41.5-63.3 41.8-63.3 0V208c0-40 63.1-41.6 63.1 0v3.4c9.9-14.4 41.8-37.3 78.6-37.3 35.3 0 57.7 16.4 66.7 43.8 13.9-21.8 45.8-43.8 82.6-43.8 44.3 0 70.7 23.4 70.7 72.7v145.3c.5 17.3-13.5 31.4-31.9 31.4 3.5.1-31.3 1.1-31.3-31.3zM3992 291.6c0-42.4-32.4-117.5-117.9-117.5-73.2 0-127.5 56.3-127.5 126 0 77.2 58.3 126.4 131.6 126.4 31.7 0 91.5-11.5 91.5-39.8 0-18.3-21.1-31.5-39.3-22.4-49.4 26.2-110.5 8.4-117.5-43.8h149.8c16.3 0 29.1-13.4 29.3-28.9zm-180.5-13.9c9.7-74.4 115.9-68.3 120.1 0h-120.1z"]
  };
  var faFontCase = {
    prefix: 'far',
    iconName: 'font-case',
    icon: [640, 512, [], "f866", "M616 128C603 128 592 139 592 152V157C569 139 541 130 511 129C441 129 384 186 384 257V320C384 391 441 448 512 448C542 448 570 437 592 419V424C592 437 603 448 616 448S640 437 640 424V152C640 139 629 128 616 128ZM592 320C592 364 556 400 512 400S432 364 432 320V257C432 213 468 177 512 177H512C533 177 553 185 568 200C584 215 592 235 592 257V320ZM198 78C190 61 162 61 154 78L2 414C-3 426 2 440 14 446C26 451 40 446 46 434L83 352H269L306 434C310 443 319 448 328 448C331 448 335 447 338 446C350 440 355 426 350 414L198 78ZM105 304L176 146L247 304H105Z"]
  };
  var faFootballBall = {
    prefix: 'far',
    iconName: 'football-ball',
    icon: [448, 512, [], "f44e", "M435 79C430 63 418 50 401 46C391 43 352 32 300 32C236 32 154 49 85 117C-26 228 -2 374 13 433C18 449 30 462 47 466C57 469 96 480 148 480C212 480 294 463 363 395C474 284 450 138 435 79ZM399 157L324 82C345 83 367 86 388 92C393 107 397 130 399 157ZM49 355L125 430C103 429 81 426 60 420C56 405 51 382 49 355ZM329 361C291 399 245 421 191 429L51 289C58 243 77 194 119 151C157 113 203 91 257 83L397 223C390 269 371 318 329 361ZM267 277C274 283 274 293 267 299C264 302 260 304 256 304S248 302 245 299L181 235C174 229 174 219 181 213S197 206 203 213L267 277ZM315 229C322 235 322 245 315 251C312 254 308 256 304 256S296 254 293 251L229 187C222 181 222 171 229 165S245 158 251 165L315 229ZM219 325C226 331 226 341 219 347C216 350 212 352 208 352S200 350 197 347L133 283C126 277 126 267 133 261S149 254 155 261L219 325Z"]
  };
  var faFootballHelmet = {
    prefix: 'far',
    iconName: 'football-helmet',
    icon: [512, 512, [], "f44f", "M480 320H338L324 244L461 226C470 225 476 217 475 209C443 62 317 16 240 16C107 16 0 123 0 256C0 312 19 364 52 404C58 412 67 416 77 416H104L190 461C199 466 209 468 219 468C236 468 253 461 265 449C302 412 276 367 270 352H312L322 405C332 458 378 496 432 496H480C489 496 496 489 496 480V336C496 327 489 320 480 320ZM258 320L247 294C239 275 252 253 273 251L292 248L306 320H258ZM318 196L267 203V203L267 203C242 206 221 220 208 242C197 261 194 283 200 304H200L201 309C202 310 202 311 203 312L213 338L224 366L226 370C226 372 227 374 228 376C239 401 238 408 231 415C228 418 224 420 219 420C216 420 214 419 212 418L126 373L116 368H84C61 335 48 297 48 256C48 150 134 64 240 64C292 64 381 90 417 183L318 196ZM464 464H432C399 464 371 445 359 416H464V464ZM464 384H350L344 352H464V384ZM160 312C147 312 136 323 136 336S147 360 160 360S184 349 184 336S173 312 160 312Z"]
  };
  var faFork = {
    prefix: 'far',
    iconName: 'fork',
    icon: [512, 512, [], "f2e3", "M505 145C496 136 480 136 471 146L338 280C319 298 296 297 271 273L82 464L48 429L243 245C217 219 216 194 234 175L367 41C377 32 377 16 367 7C358 -2 343 -2 333 7L200 141C175 167 169 204 183 235L15 394C6 403 0 415 0 428C0 441 5 454 14 463L48 498C57 507 70 512 83 512H83C96 512 109 506 117 497L280 332C310 345 347 339 372 314L505 179C514 170 514 155 505 145ZM334 226C338 230 344 233 351 233C357 233 363 230 368 226L459 133C469 124 468 109 459 99C450 90 434 90 425 99L334 192C324 201 324 216 334 226ZM288 179C292 184 299 186 305 186C311 186 317 184 322 179L413 87C423 78 423 62 413 53C404 44 389 44 379 53L288 146C278 155 278 170 288 179Z"]
  };
  var faForkKnife = {
    prefix: 'far',
    iconName: 'fork-knife',
    icon: [576, 512, [], "f2e6", "M352 179C356 184 363 186 369 186C375 186 381 184 386 179L477 87C487 78 487 62 477 53C468 44 453 44 443 53L352 146C342 155 342 170 352 179ZM398 226C402 230 408 233 415 233C421 233 427 230 432 226L523 133C533 124 532 109 523 99C514 90 498 90 489 99L398 192C388 201 388 216 398 226ZM569 145C560 136 544 136 535 146L402 280C383 298 360 297 335 273L146 464L112 429L307 245C281 219 280 194 298 175L431 41C441 32 441 16 431 7C422 -2 407 -2 397 7L264 141C239 167 233 204 247 235L79 394C70 403 64 415 64 428C64 441 69 454 78 463L112 498C121 507 134 512 147 512H147C160 512 173 506 181 497L344 332C374 345 411 339 436 314L569 179C578 170 578 155 569 145ZM154 279C111 268 80 243 63 204C34 141 53 64 68 49L209 182C212 165 219 148 229 134L105 14C96 5 83 0 70 0H70C56 0 44 5 34 15C0 49 -14 150 19 224C32 253 59 293 115 316L154 279ZM449 344C436 355 420 363 404 367L464 424L427 463L426 463L423 462L341 381L307 415L389 496C397 506 410 512 424 512C424 512 425 512 425 512C438 512 451 507 461 497L497 461C517 441 517 410 497 390L449 344Z"]
  };
  var faForklift = {
    prefix: 'far',
    iconName: 'forklift',
    icon: [640, 512, [], "f47a", "M416 345V237C416 228 414 220 411 212L333 29C325 11 308 0 288 0H144C118 0 96 22 96 48V160H48C22 160 0 182 0 208V416C0 469 43 512 96 512S192 469 192 416H256C256 469 299 512 352 512S448 469 448 416C448 388 435 362 416 345ZM144 48H288L367 231C368 233 368 235 368 237V240H246C237 240 228 237 221 231L144 171V48ZM96 464C70 464 48 442 48 416S70 368 96 368S144 390 144 416S122 464 96 464ZM269 368H179C162 339 131 320 96 320C78 320 62 325 48 333V208H114L192 269C207 281 227 288 246 288H368V322C363 321 358 320 352 320C317 320 286 339 269 368ZM352 464C326 464 304 442 304 416S326 368 352 368S400 390 400 416S378 464 352 464ZM616 400H528V24C528 11 517 0 504 0H504C491 0 480 11 480 24V432C480 441 487 448 496 448H616C629 448 640 437 640 424V424C640 411 629 400 616 400Z"]
  };
  var faForward = {
    prefix: 'far',
    iconName: 'forward',
    icon: [512, 512, [], "f04e", "M256 96V416C256 435 272 448 288 448C295 448 302 446 309 441L501 281C516 268 516 244 501 231L309 71C302 66 295 64 288 64C272 64 256 77 256 96ZM304 130L455 256L304 382V130ZM0 96V416C0 428 6 438 17 444C21 447 27 448 32 448C38 448 44 446 49 443L213 339C224 332 227 317 220 306C213 294 198 291 187 298L48 387V125L187 214C198 221 213 218 220 206C227 195 224 180 213 173L49 69C39 63 27 62 17 68S0 84 0 96Z"]
  };
  var faForwardFast = {
    prefix: 'far',
    iconName: 'forward-fast',
    icon: [512, 512, [], "f050", "M0 96V416C0 435 16 448 32 448C39 448 46 446 53 441L224 285V416C224 435 240 448 256 448C263 448 270 446 277 441L448 285V424C448 437 459 448 472 448C485 448 496 437 496 424V88C496 75 485 64 472 64H472C459 64 448 75 448 88V228L277 71C270 66 263 64 256 64C240 64 224 77 224 96V228L53 71C46 66 39 64 32 64C16 64 0 77 0 96ZM272 132L408 257L272 380V132ZM48 132L184 257L48 380V132Z"]
  };
  var faForwardStep = {
    prefix: 'far',
    iconName: 'forward-step',
    icon: [320, 512, [], "f051", "M264 64C251 64 240 75 240 88V194L67 70C61 66 55 64 48 64C43 64 38 65 33 68C23 73 16 84 16 96V416C16 428 23 439 33 444C38 447 43 448 48 448C55 448 61 446 67 442L240 318V424C240 437 251 448 264 448S288 437 288 424V88C288 75 277 64 264 64ZM240 259L212 279L64 385V127L212 233L240 253V259Z"]
  };
  var faFrancSign = {
    prefix: 'far',
    iconName: 'franc-sign',
    icon: [320, 512, [], "e139", "M320 56C320 69 309 80 296 80H96V192H264C277 192 288 203 288 216S277 240 264 240H96V320H200C213 320 224 331 224 344S213 368 200 368H96V456C96 469 85 480 72 480S48 469 48 456V368H24C11 368 0 357 0 344S11 320 24 320H48V56C48 43 59 32 72 32H296C309 32 320 43 320 56Z"]
  };
  var faFrenchFries = {
    prefix: 'far',
    iconName: 'french-fries',
    icon: [384, 512, [], "f803", "M287 228C288 226 289 225 290 223L320 51C321 45 319 40 315 36C310 32 305 31 299 33L265 43C261 44 258 47 256 51V258C273 250 285 239 287 228ZM224 269V32C224 26 221 20 215 18L183 2C178 -1 172 -1 168 2C163 5 160 10 160 16V269C181 273 203 273 224 269ZM367 192L384 99C385 93 383 88 379 84C374 80 369 79 363 81L346 86L327 193C330 193 332 192 334 192H367ZM17 192H50C54 192 57 193 60 194L40 87L21 81C15 79 9 80 5 84C1 88 -1 93 0 99L17 192ZM101 238C106 245 116 253 128 258V33L124 13C123 8 119 3 114 1C109 -1 103 0 99 3L70 25C65 28 63 35 64 41L101 238ZM368 224H334C327 224 320 228 319 235C310 274 257 304 192 304C127 304 74 274 65 235C64 228 57 224 50 224H16C11 224 6 226 4 230C1 234 -1 239 0 243L54 487C58 502 71 512 86 512H298C313 512 326 502 329 487L384 243C385 239 383 234 380 230C377 226 373 224 368 224ZM285 464H98L65 314C97 338 142 352 192 352S287 338 319 314L285 464Z"]
  };
  var faFrog = {
    prefix: 'far',
    iconName: 'frog',
    icon: [576, 512, [], "f52e", "M576 190C576 169 564 149 546 139C517 123 480 109 460 102C449 62 412 32 368 32C325 32 289 60 277 99C120 121 -1 254 0 417C0 452 29 480 64 480H368C377 480 384 473 384 464C384 446 370 432 352 432H322L341 406C350 393 356 377 358 362L470 480H560C569 480 576 473 576 464C576 446 562 432 544 432H490L392 327L546 241C565 230 576 211 576 190ZM523 199L348 295C341 280 330 265 315 254C276 225 220 225 180 254L146 281C135 289 133 304 141 314C149 325 164 327 174 319L209 293C232 276 264 276 286 293C314 313 320 352 302 379L263 432H64C55 432 48 425 48 417C48 281 149 165 283 147L314 143L323 114C329 94 347 80 368 80C389 80 408 94 414 115L421 139L444 147C462 154 497 167 522 181C526 183 528 186 528 190C528 194 526 197 523 199ZM368 120C355 120 344 131 344 144S355 168 368 168S392 157 392 144S381 120 368 120Z"]
  };
  var faFunction = {
    prefix: 'far',
    iconName: 'function',
    icon: [640, 512, [], "f661", "M200 0H160C111 0 72 40 72 89V185H24C11 185 0 196 0 209C0 223 11 234 24 234H72V395C72 417 54 435 32 435H24C11 435 0 446 0 459S11 483 24 483H32C81 483 120 444 120 395V234H168C181 234 192 223 192 209C192 196 181 185 168 185H120V89C120 66 138 48 160 48H200C213 48 224 38 224 24S213 0 200 0ZM312 137C300 129 284 131 277 144C242 197 224 259 224 322C224 385 242 448 277 501C284 513 300 516 312 507C321 499 324 486 317 475C288 430 272 376 272 322C272 268 288 215 317 169C324 159 321 145 312 137ZM587 144C580 131 564 129 552 137C543 145 540 159 547 169C576 215 592 268 592 322C592 376 576 430 547 475C540 486 543 499 552 507C564 516 580 513 587 501C622 448 640 385 640 322C640 259 622 197 587 144ZM502 252C493 243 478 243 469 252L432 289L395 252C386 243 371 243 362 252C353 261 353 276 362 285L399 322L362 359C353 369 353 383 362 393C371 402 386 402 395 393L432 355L469 393C478 402 493 402 502 393C511 383 511 369 502 359L465 322L502 285C511 276 511 261 502 252Z"]
  };
  var faFunnelCircleDollar = {
    prefix: 'far',
    iconName: 'funnel-circle-dollar',
    icon: [640, 512, [], "f662", "M224 341V272C224 265 221 258 217 252L51 48H461L346 190C371 174 400 164 431 161L501 75C513 61 515 43 508 27C500 10 484 0 465 0H47C28 0 12 10 4 27C-3 43 -1 61 11 75L176 278V346C176 358 182 370 193 377L275 441C276 442 277 442 279 443C266 419 259 394 257 366L224 341ZM448 192C360 192 288 264 288 352S360 512 448 512S608 440 608 352S536 192 448 192ZM506 394C502 414 486 426 464 430V448C464 457 457 464 448 464S432 457 432 448V430C422 428 413 425 404 422L400 420C392 417 387 408 390 400C393 392 403 387 411 390L415 392C423 395 432 398 440 399C455 402 472 399 474 388C476 379 472 376 444 367L438 366C420 360 383 350 390 310C394 290 409 277 432 273V256C432 247 439 240 448 240S464 247 464 256V274C470 275 477 277 485 280C494 283 498 292 495 300C492 308 483 313 475 310C469 308 462 306 456 305C441 302 424 305 422 316C421 322 420 327 447 335L452 337C475 343 513 354 506 394Z"]
  };
  var faFutbolBall = {
    prefix: 'far',
    iconName: 'futbol-ball',
    icon: [512, 512, [], "f1e3", "M178 229L208 320H304L334 229L256 172L178 229ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM417 361L331 360L306 441C290 445 273 448 256 448S222 445 206 441L181 360L95 361C77 333 66 301 64 266L134 216L107 136L107 136C128 109 156 89 188 77C188 77 188 77 188 77L256 128L324 77C324 77 324 77 324 77C356 89 384 109 405 136C405 136 405 136 405 136L378 216L448 266C446 301 435 333 417 361Z"]
  };
  var faG = {
    prefix: 'far',
    iconName: 'g',
    icon: [448, 512, [], "e13a", "M224 480C164 480 108 457 66 414S0 316 0 256S23 140 66 98S164 32 224 32S340 55 382 98C395 110 395 130 382 143S350 155 337 143C307 113 267 96 224 96S141 113 111 143S64 213 64 256S81 339 111 369S181 416 224 416S307 399 337 369C356 350 371 328 379 305H224C206 305 192 291 192 273S206 241 224 241H416C434 241 448 256 448 273V291C448 293 448 295 447 297C440 338 417 380 382 414C340 457 284 480 224 480Z"]
  };
  var faGalaxy = {
    prefix: 'far',
    iconName: 'galaxy',
    icon: [512, 512, [], "e008", "M506 267H506C489 194 428 135 355 120C335 116 314 115 294 117C305 97 323 81 345 71C360 65 369 49 366 32C364 15 351 2 334 1C311 -1 289 0 267 5C194 23 135 84 120 157C116 178 115 198 117 218C97 207 81 189 71 167C65 152 48 143 32 146C15 148 2 162 1 178C-1 201 0 223 6 245C23 318 84 377 157 392C177 396 198 397 218 395C207 415 189 431 167 441C152 447 143 463 146 480C148 497 161 509 178 511C185 512 191 512 198 512C214 512 230 510 245 506C318 489 377 428 392 355C396 334 397 314 395 294C415 305 431 323 441 345C447 360 464 369 480 366C497 364 509 351 511 334C513 311 512 289 506 267ZM366 234C358 233 349 236 344 242C339 249 337 258 340 265C348 291 350 319 345 345C333 402 287 451 224 462C253 438 272 404 278 366C279 358 276 349 270 344C263 339 254 337 247 340C221 348 193 350 167 345C110 334 61 286 50 224C74 253 108 272 146 278C154 279 163 276 168 270C173 263 175 254 172 247C163 221 162 193 167 167C178 110 225 61 288 50C259 74 240 108 234 146C233 154 236 163 242 168C249 173 257 175 265 172C291 164 319 162 345 167C402 178 451 226 462 288C437 259 403 240 366 234ZM256 216C234 216 216 234 216 256C216 278 234 296 256 296S296 278 296 256C296 234 278 216 256 216Z"]
  };
  var faGameBoard = {
    prefix: 'far',
    iconName: 'game-board',
    icon: [448, 512, [], "f867", "M64 96V176H144V96H64ZM64 256V336H144V256H64ZM304 96H224V176H304V96ZM144 416H224V336H144V416ZM384 416V336H304V416H384ZM304 256H384V176H304V256ZM224 176H144V256H224V176ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416ZM224 336H304V256H224V336Z"]
  };
  var faGameBoardSimple = {
    prefix: 'far',
    iconName: 'game-board-simple',
    icon: [448, 512, [], "f868", "M224 400H368V256H224V400ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H384C393 80 400 87 400 96V416ZM80 112V256H224V112H80Z"]
  };
  var faGameConsoleHandheld = {
    prefix: 'far',
    iconName: 'game-console-handheld',
    icon: [384, 512, [], "f8bb", "M320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H256C327 512 384 455 384 384V64C384 29 355 0 320 0ZM336 384C336 428 300 464 256 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H320C329 48 336 55 336 64V384ZM112 240H256C274 240 288 226 288 208V112C288 103 281 96 272 96H112C103 96 96 103 96 112V224C96 233 103 240 112 240ZM160 320H144V304C144 295 137 288 128 288S112 295 112 304V320H96C87 320 80 327 80 336C80 345 87 352 96 352H112V368C112 377 119 384 128 384S144 377 144 368V352H160C169 352 176 345 176 336C176 327 169 320 160 320ZM232 336C219 336 208 347 208 360S219 384 232 384S256 373 256 360S245 336 232 336ZM280 288C267 288 256 299 256 312S267 336 280 336S304 325 304 312S293 288 280 288Z"]
  };
  var faGamepad = {
    prefix: 'far',
    iconName: 'gamepad',
    icon: [640, 512, [], "f11b", "M400 272C382 272 368 286 368 304S382 336 400 336S432 322 432 304S418 272 400 272ZM248 232H216V200C216 187 205 176 192 176C179 176 168 187 168 200V232H136C123 232 112 243 112 256C112 269 123 280 136 280H168V312C168 325 179 336 192 336C205 336 216 325 216 312V280H248C261 280 272 269 272 256C272 243 261 232 248 232ZM464 176C446 176 432 190 432 208S446 240 464 240S496 226 496 208S482 176 464 176ZM448 64H192C86 64 0 150 0 256S86 448 192 448H448C554 448 640 362 640 256S554 64 448 64ZM448 400H192C113 400 48 335 48 256S113 112 192 112H448C527 112 592 177 592 256S527 400 448 400Z"]
  };
  var faGamepadModern = {
    prefix: 'far',
    iconName: 'gamepad-modern',
    icon: [640, 512, [], "f8bc", "M639 317L611 135C603 84 565 43 516 32C387 3 253 3 124 32C74 43 37 84 29 135L1 317C-10 391 47 458 121 458H121C168 458 210 432 230 390L244 362H396L410 390C430 432 472 458 518 458H519C593 458 650 391 639 317ZM574 385C560 401 540 410 518 410C491 410 466 395 453 369L435 332C429 321 418 314 406 314H234C222 314 210 321 205 332L187 369C174 395 149 410 121 410C100 410 80 401 66 385C52 368 45 346 49 324L76 143C81 111 104 86 135 79C257 51 383 51 505 79C536 86 559 111 564 143L591 324C594 346 588 368 574 385ZM400 218C382 218 368 233 368 250S382 282 400 282S432 268 432 250S418 218 400 218ZM248 178H216V146C216 133 205 122 192 122C179 122 168 133 168 146V178H136C123 178 112 189 112 202C112 215 123 226 136 226H168V258C168 271 179 282 192 282C205 282 216 271 216 258V226H248C261 226 272 215 272 202C272 189 261 178 248 178ZM464 122C446 122 432 137 432 154S446 186 464 186C482 186 496 172 496 154S482 122 464 122Z"]
  };
  var faGarage = {
    prefix: 'far',
    iconName: 'garage',
    icon: [640, 512, [], "e009", "M598 113L346 9C330 2 310 2 294 9L42 113C17 124 0 149 0 177V491C0 505 11 515 24 515C37 515 48 505 48 491V177C48 168 53 161 61 158L312 53C317 51 323 51 328 53L579 158C587 161 592 168 592 177V491C592 505 603 515 616 515C629 515 640 505 640 491V177C640 149 623 124 598 113ZM504 195H136C114 195 96 213 96 235V491C96 505 107 515 120 515C133 515 144 505 144 491V371H496V491C496 505 507 515 520 515C533 515 544 505 544 491V235C544 213 526 195 504 195ZM496 323H144V243H496V323ZM360 419H280C267 419 256 430 256 443C256 457 267 467 280 467H360C373 467 384 457 384 443C384 430 373 419 360 419Z"]
  };
  var faGarageCar = {
    prefix: 'far',
    iconName: 'garage-car',
    icon: [640, 512, [], "e00a", "M504 195H136C114 195 96 213 96 235V491C96 505 107 515 120 515C133 515 144 505 144 491V243H496V491C496 505 507 515 520 515C533 515 544 505 544 491V235C544 213 526 195 504 195ZM430 355L414 306C406 283 385 267 361 267H279C255 267 234 283 226 306L210 355C190 365 176 386 176 410V426C176 440 182 453 192 462V491C192 505 203 515 216 515S240 505 240 491V475H400V491C400 505 411 515 424 515S448 505 448 491V462C458 453 464 440 464 426V410C464 386 450 365 430 355ZM271 321C273 318 276 315 279 315H361C364 315 367 318 369 321L377 347H263L271 321ZM416 426C416 427 415 427 414 427L224 426V410C224 402 230 395 238 395H402C410 395 416 402 416 410V426ZM598 113L346 9C330 2 310 2 294 9L42 113C17 124 0 149 0 177V491C0 505 11 515 24 515C37 515 48 505 48 491V177C48 168 53 161 61 158L312 53C317 51 323 51 328 53L579 158C587 161 592 168 592 177V491C592 505 603 515 616 515C629 515 640 505 640 491V177C640 149 623 124 598 113Z"]
  };
  var faGarageOpen = {
    prefix: 'far',
    iconName: 'garage-open',
    icon: [640, 512, [], "e00b", "M598 113L346 9C330 2 310 2 294 9L42 113C17 124 0 149 0 177V491C0 505 11 515 24 515C37 515 48 505 48 491V177C48 168 53 161 61 158L312 53C317 51 323 51 328 53L579 158C587 161 592 168 592 177V491C592 505 603 515 616 515C629 515 640 505 640 491V177C640 149 623 124 598 113ZM504 195H136C114 195 96 213 96 235V491C96 505 107 515 120 515C133 515 144 505 144 491V323H496V491C496 505 507 515 520 515C533 515 544 505 544 491V235C544 213 526 195 504 195ZM496 275H144V243H496V275ZM402 347H238C204 347 176 375 176 410V426C176 440 182 453 192 462V491C192 505 203 515 216 515S240 505 240 491V475H400V491C400 505 411 515 424 515S448 505 448 491V462C458 453 464 440 464 426V410C464 375 436 347 402 347ZM416 426C416 427 415 427 414 427L224 426V410C224 402 230 395 238 395H402C410 395 416 402 416 410V426Z"]
  };
  var faGasPump = {
    prefix: 'far',
    iconName: 'gas-pump',
    icon: [512, 512, [], "f52f", "M493 107L418 32C409 23 393 23 384 32L384 32C375 41 375 57 384 66L416 98V160C416 188 437 211 464 215V376C464 389 453 400 440 400C427 400 416 389 416 376V344C416 295 377 256 328 256H320V64C320 29 291 0 256 0H96C61 0 32 29 32 64V464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H328C341 512 352 501 352 488V488C352 475 341 464 328 464H320V304H328C350 304 368 322 368 344V372C368 410 395 444 433 448C475 452 512 418 512 376V153C512 136 505 119 493 107ZM272 464H80V240H272V464ZM272 192H80V64C80 55 87 48 96 48H256C265 48 272 55 272 64V192Z"]
  };
  var faGasPumpSlash = {
    prefix: 'far',
    iconName: 'gas-pump-slash',
    icon: [640, 512, [], "f5f4", "M392 464H384V398L336 360V464H144V210L96 172V464H88C75 464 64 475 64 488C64 501 75 512 88 512H392C405 512 416 501 416 488C416 475 405 464 392 464ZM631 469L563 416C571 405 576 391 576 376V153C576 136 569 119 557 107L482 32C473 23 457 23 448 32C439 41 439 57 448 66L480 98V160C480 188 501 211 528 215V376C528 380 527 383 525 386L384 276V64C384 29 355 0 320 0H160C129 0 103 22 97 51L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM336 238L144 88V64C144 55 151 48 160 48H320C329 48 336 55 336 64V238Z"]
  };
  var faGauge = {
    prefix: 'far',
    iconName: 'gauge',
    icon: [576, 512, [], "f625", "M176 176C158 176 144 190 144 208S158 240 176 240S208 226 208 208S194 176 176 176ZM128 288C110 288 96 302 96 320S110 352 128 352S160 338 160 320S146 288 128 288ZM416 320C416 338 431 352 448 352S480 338 480 320S466 288 448 288S416 302 416 320ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 368 367 347 351 331L428 213C435 202 432 187 421 180C410 173 395 176 388 187L310 307C303 305 295 304 288 304C239 304 200 343 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432ZM288 128C270 128 256 142 256 160S270 192 288 192S320 178 320 160S306 128 288 128Z"]
  };
  var faGaugeLow = {
    prefix: 'far',
    iconName: 'gauge-low',
    icon: [576, 512, [], "f627", "M288 128C270 128 256 142 256 160S270 192 288 192S320 178 320 160S306 128 288 128ZM96 320C96 338 110 352 128 352S160 338 160 320S146 288 128 288S96 302 96 320ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 343 337 304 288 304C281 304 273 305 266 307L188 187C181 176 166 173 155 180C144 187 141 202 148 213L225 331C210 347 200 368 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432ZM432 208C432 190 418 176 400 176S368 190 368 208S382 240 400 240S432 226 432 208ZM416 320C416 338 431 352 448 352S480 338 480 320S466 288 448 288S416 302 416 320Z"]
  };
  var faGaugeMax = {
    prefix: 'far',
    iconName: 'gauge-max',
    icon: [576, 512, [], "f626", "M176 176C158 176 144 190 144 208S158 240 176 240S208 226 208 208S194 176 176 176ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 386 375 379 374 373L466 334C478 329 483 315 478 303C473 290 459 285 447 290L351 331C335 314 313 304 288 304C239 304 200 343 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432ZM128 288C110 288 96 302 96 320S110 352 128 352S160 338 160 320S146 288 128 288ZM288 128C270 128 256 142 256 160S270 192 288 192S320 178 320 160S306 128 288 128ZM400 176C382 176 368 190 368 208S382 240 400 240S432 226 432 208S418 176 400 176Z"]
  };
  var faGaugeMed = {
    prefix: 'far',
    iconName: 'gauge-med',
    icon: [576, 512, [], "f624", "M128 288C110 288 96 302 96 320S110 352 128 352S160 338 160 320S146 288 128 288ZM176 176C158 176 144 190 144 208S158 240 176 240S208 226 208 208S194 176 176 176ZM432 208C432 190 418 176 400 176S368 190 368 208S382 240 400 240S432 226 432 208ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 352 349 318 312 308V152C312 139 301 128 288 128S264 139 264 152V308C227 318 200 352 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432ZM416 320C416 338 431 352 448 352S480 338 480 320S466 288 448 288S416 302 416 320Z"]
  };
  var faGaugeMin = {
    prefix: 'far',
    iconName: 'gauge-min',
    icon: [576, 512, [], "f628", "M288 128C270 128 256 142 256 160S270 192 288 192S320 178 320 160S306 128 288 128ZM176 176C158 176 144 190 144 208S158 240 176 240S208 226 208 208S194 176 176 176ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 343 337 304 288 304C263 304 241 314 225 331L129 290C117 285 103 290 98 303S98 329 111 334L202 373C201 379 200 386 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432ZM416 320C416 338 431 352 448 352S480 338 480 320S466 288 448 288S416 302 416 320ZM432 208C432 190 418 176 400 176S368 190 368 208S382 240 400 240S432 226 432 208Z"]
  };
  var faGaugeSimple = {
    prefix: 'far',
    iconName: 'gauge-simple',
    icon: [576, 512, [], "f62a", "M288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 368 367 347 351 331L428 213C435 202 432 187 421 180C410 173 395 176 388 187L310 307C303 305 295 304 288 304C239 304 200 343 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432Z"]
  };
  var faGaugeSimpleLow = {
    prefix: 'far',
    iconName: 'gauge-simple-low',
    icon: [576, 512, [], "f62c", "M288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 343 337 304 288 304C281 304 273 305 266 307L188 187C181 176 166 173 155 180C144 187 141 202 148 213L225 331C210 347 200 368 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432Z"]
  };
  var faGaugeSimpleMax = {
    prefix: 'far',
    iconName: 'gauge-simple-max',
    icon: [576, 512, [], "f62b", "M288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 386 375 379 374 373L466 334C478 329 483 315 478 303C473 290 459 285 447 290L351 331C335 314 313 304 288 304C239 304 200 343 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432Z"]
  };
  var faGaugeSimpleMed = {
    prefix: 'far',
    iconName: 'gauge-simple-med',
    icon: [576, 512, [], "f629", "M288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 352 349 318 312 308V152C312 139 301 128 288 128S264 139 264 152V308C227 318 200 352 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432Z"]
  };
  var faGaugeSimpleMin = {
    prefix: 'far',
    iconName: 'gauge-simple-min',
    icon: [576, 512, [], "f62d", "M288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM288 432C266 432 248 414 248 392S266 352 288 352C310 352 328 370 328 392S310 432 288 432ZM500 432H366C372 420 376 406 376 392C376 343 337 304 288 304C263 304 241 314 225 331L129 290C117 285 103 290 98 303S98 329 111 334L202 373C201 379 200 386 200 392C200 406 204 420 210 432H76C58 398 48 359 48 320C48 188 156 80 288 80S528 188 528 320C528 359 518 398 500 432Z"]
  };
  var faGavel = {
    prefix: 'far',
    iconName: 'gavel',
    icon: [512, 512, [], "f0e3", "M505 199C496 190 482 190 472 198L314 40C322 30 322 16 313 7C304 -2 288 -2 279 7L151 135C142 144 142 160 151 169C156 174 162 176 168 176C174 176 179 174 184 170L246 232L175 303L169 297C157 285 137 285 124 297L9 412C-3 425 -3 445 9 457L55 503C67 515 87 515 100 503L215 388C227 375 227 355 215 343L209 337L280 266L342 328C334 338 334 352 343 361C348 366 354 368 360 368S372 366 377 361L505 233C514 224 514 208 505 199ZM376 294L218 136L280 74L438 232L376 294Z"]
  };
  var faGear = {
    prefix: 'far',
    iconName: 'gear',
    icon: [512, 512, [], "f013", "M492 295L459 276C460 263 460 249 459 236L492 217C502 212 506 200 503 190C492 146 469 106 437 75C433 70 426 68 420 68C415 68 411 69 407 71L375 90C364 82 353 76 341 70V32C341 21 333 11 322 9C301 3 278 0 256 0C234 0 212 3 190 9C179 11 172 21 172 32V70C160 76 148 82 138 90L105 71C101 69 97 68 93 68C86 68 80 70 75 75C44 106 21 146 9 190C6 200 11 212 20 217L53 236C52 249 52 263 53 276L20 295C11 300 6 312 9 322C21 366 44 406 75 437C80 442 86 444 93 444C97 444 101 443 105 441L138 422C148 430 160 436 172 442V480C172 491 179 501 190 503C212 509 234 512 256 512C278 512 301 509 322 503C333 501 341 491 341 480V442C353 436 364 430 375 422L407 441C411 443 415 444 420 444C426 444 432 442 437 437C469 406 492 366 503 322C506 312 502 300 492 295ZM415 390C392 376 404 383 372 365C330 395 339 389 293 411V461C260 466 234 463 220 461V411C173 389 183 395 141 365C109 383 118 378 97 390C81 371 69 350 61 327C82 315 72 320 104 302C99 250 99 262 104 210C72 192 82 197 61 185C69 162 81 141 97 122C121 136 108 129 141 147C183 117 173 123 220 101V51C252 46 278 49 293 51V101C339 123 330 117 372 147C406 128 394 134 415 122C431 141 443 162 452 185C431 197 440 192 408 210C413 262 413 250 408 302C440 320 431 315 452 327C443 350 431 371 415 390ZM256 160C203 160 160 203 160 256S203 352 256 352S352 309 352 256S309 160 256 160ZM256 304C230 304 208 282 208 256S230 208 256 208S304 230 304 256S283 304 256 304Z"]
  };
  var faGears = {
    prefix: 'far',
    iconName: 'gears',
    icon: [640, 512, [], "f085", "M307 199L290 189C291 185 291 180 291 176C291 172 291 167 290 163L307 153C318 147 322 134 319 123C312 102 300 82 285 65C277 56 263 54 253 60L236 70C229 65 222 61 214 57V37C214 25 205 15 194 12C171 7 149 7 126 12C115 15 106 25 106 37V57C98 61 91 65 84 70L67 60C57 54 43 56 35 65C20 82 8 102 1 123C-2 134 2 147 13 153L30 163C29 167 29 172 29 176C29 180 29 185 30 189L13 199C2 205 -3 217 1 229C8 250 20 270 35 287C42 296 57 298 67 292L84 282C91 287 98 292 106 295V315C106 327 115 337 126 340C138 342 149 343 160 343S182 342 194 340C205 337 214 327 214 315V295C222 292 229 287 236 282L253 292C263 298 278 296 285 287C300 270 312 250 319 229C323 217 318 205 307 199ZM248 176C248 187 246 198 242 207L277 227C273 236 268 244 263 251L228 231C215 248 196 259 174 263V303C165 304 155 304 146 303V263C124 259 105 248 92 231L57 251C52 244 47 236 43 227L78 207C74 198 72 187 72 176S74 154 78 145L43 125C47 116 52 108 57 101L92 121C105 104 124 93 146 89V49C155 48 165 48 174 49V89C196 93 215 104 228 121L263 101C268 108 273 116 277 125L242 145C246 154 248 165 248 176ZM160 144C142 144 128 158 128 176C128 194 142 208 160 208S192 194 192 176C192 158 178 144 160 144Z"]
  };
  var faGem = {
    prefix: 'far',
    iconName: 'gem',
    icon: [512, 512, [], "f3a5", "M508 196L404 43C399 36 392 32 384 32H128C120 32 113 36 108 43L4 196C-2 206 -1 218 7 226L239 472C243 477 249 480 256 480S269 477 273 472L505 226C513 218 514 206 508 196ZM382 97L447 192H307L382 97ZM256 179L178 80H334L256 179ZM130 97L205 192H65L130 97ZM256 421L85 240H427L256 421Z"]
  };
  var faGenderless = {
    prefix: 'far',
    iconName: 'genderless',
    icon: [384, 512, [], "f22d", "M192 80C95 80 16 159 16 256S95 432 192 432S368 353 368 256S289 80 192 80ZM192 384C121 384 64 327 64 256S121 128 192 128S320 185 320 256S263 384 192 384Z"]
  };
  var faGhost = {
    prefix: 'far',
    iconName: 'ghost',
    icon: [384, 512, [], "f6e2", "M192 0C190 0 188 0 186 0C81 3 0 95 0 200V464C0 474 8 480 16 480C20 480 24 478 27 475L52 457C55 455 58 454 62 454C66 454 71 455 74 459L117 507C120 510 124 512 128 512C132 512 136 510 139 507L180 461C183 458 188 456 192 456S201 458 204 461L245 507C248 510 252 512 256 512C260 512 264 510 267 507L310 459C316 453 325 452 332 457L357 475C360 478 364 480 368 480C376 480 384 474 384 464V192C384 86 298 0 192 0ZM336 407C331 406 327 406 322 406C304 406 286 413 274 427L256 448L240 430C228 416 210 408 192 408S156 416 144 430L128 448L110 427C98 413 80 406 62 406C57 406 53 406 48 407V200C48 118 111 50 187 48L192 48C271 48 336 113 336 192V407ZM128 160C110 160 96 174 96 192S110 224 128 224S160 210 160 192S146 160 128 160ZM256 160C238 160 224 174 224 192S238 224 256 224C274 224 288 210 288 192S274 160 256 160Z"]
  };
  var faGift = {
    prefix: 'far',
    iconName: 'gift',
    icon: [512, 512, [], "f06b", "M448 128H438C450 104 453 74 435 42C419 15 390 0 359 0C318 0 291 22 257 68C223 22 196 0 155 0C123 0 95 15 79 42C61 74 63 104 76 128H64C29 128 0 157 0 192V256C0 274 14 288 32 288V448C32 483 61 512 96 512H416C451 512 480 483 480 448V288C498 288 512 274 512 256V192C512 157 483 128 448 128ZM360 48C382 48 400 66 400 88S382 128 360 128H274C325 51 340 48 360 48ZM154 48C174 48 189 51 240 128H154C132 128 114 110 114 88S132 48 154 48ZM224 464H96C87 464 80 457 80 448V288H224V464ZM432 448C432 457 425 464 416 464H288V288H432V448ZM464 240H48V192C48 183 55 176 64 176H448C457 176 464 183 464 192V240Z"]
  };
  var faGiftCard = {
    prefix: 'far',
    iconName: 'gift-card',
    icon: [576, 512, [], "f663", "M512 128H470C482 104 485 74 467 42C451 15 422 0 391 0C350 0 323 22 289 68C255 22 228 0 187 0C155 0 127 15 111 42C92 74 95 104 108 128H64C29 128 0 157 0 192V448C0 483 29 512 64 512H512C547 512 576 483 576 448V192C576 157 547 128 512 128ZM392 48C414 48 432 66 432 88C432 110 414 128 392 128H306C357 51 372 48 392 48ZM146 88C146 66 164 48 186 48C206 48 221 51 272 128H186C164 128 146 110 146 88ZM222 176L176 222C167 231 167 247 176 256L176 256C185 265 201 265 210 256L288 178L366 256C375 265 391 265 400 256L400 256C409 247 409 232 400 222L354 176H512C521 176 528 183 528 192V320H48V192C48 183 55 176 64 176H222ZM48 448V384H528V448C528 457 521 464 512 464H64C55 464 48 457 48 448Z"]
  };
  var faGifts = {
    prefix: 'far',
    iconName: 'gifts',
    icon: [640, 512, [], "f79c", "M587 225C592 215 592 206 592 200C592 165 565 128 520 128C472 128 444 176 432 203C420 176 392 128 344 128C299 128 272 165 272 200C272 206 272 215 277 225C247 230 224 256 224 288V448C224 483 253 512 288 512H576C611 512 640 483 640 448V288C640 256 617 230 587 225ZM344 176C363 176 380 204 389 224H336C333 223 331 221 329 219C322 213 320 205 320 200C320 191 326 176 344 176ZM408 464H288C279 464 272 457 272 448V392H408V464ZM408 344H272V288C272 279 279 272 288 272H408V344ZM520 176C538 176 544 191 544 200C544 205 542 213 535 219C533 221 531 223 528 224H475C484 204 501 176 520 176ZM592 448C592 457 585 464 576 464H456V392H592V448ZM592 344H456V272H576C585 272 592 279 592 288V344ZM168 464H64C55 464 48 457 48 448V160C48 151 55 144 64 144H232C245 144 256 133 256 120S245 96 232 96H223L244 85C255 79 259 64 253 53C247 41 232 37 221 43L196 57L206 34C211 22 206 8 194 2C182 -3 168 2 162 14L144 54L126 14C120 2 106 -3 94 2C82 8 77 22 82 34L92 57L67 43C56 37 41 41 35 53C29 64 33 79 45 85L65 96H64C29 96 0 125 0 160V448C0 483 29 512 64 512H168C181 512 192 501 192 488S181 464 168 464Z"]
  };
  var faGingerbreadMan = {
    prefix: 'far',
    iconName: 'gingerbread-man',
    icon: [448, 512, [], "f79d", "M192 96C183 96 176 103 176 112S183 128 192 128S208 121 208 112S201 96 192 96ZM224 336C215 336 208 343 208 352S215 368 224 368S240 361 240 352S233 336 224 336ZM447 227C439 180 398 146 349 144C350 138 350 132 350 126C350 92 337 61 313 37C289 13 258 0 224 0S159 13 135 37C111 61 98 92 98 126C98 132 98 138 99 144C50 146 9 180 1 227C-3 256 5 285 24 308C35 321 50 331 66 337L59 345C41 367 32 396 35 424C38 451 51 475 72 491C89 505 111 512 133 512C163 512 191 499 210 476L224 459L238 476C257 499 285 512 315 512C337 512 359 505 377 491C397 475 410 451 413 424C416 395 408 367 390 345L383 337C399 331 413 321 424 308C443 285 451 256 447 227ZM348 295H317C309 295 302 302 302 310C302 313 303 317 305 319L353 376C372 399 370 435 347 453C321 473 290 463 275 445L244 408C239 402 231 399 224 399S209 402 204 408L173 445C158 463 127 473 101 453C78 435 76 399 95 376L143 319C145 317 146 313 146 310C146 302 139 295 131 295H100C33 295 28 192 103 192H163C169 192 172 184 168 180C154 166 146 147 146 126C146 83 181 48 224 48S302 83 302 126C302 147 294 166 280 180C276 184 279 192 285 192H345C420 192 415 295 348 295ZM224 272C215 272 208 279 208 288S215 304 224 304S240 297 240 288S233 272 224 272ZM256 96C247 96 240 103 240 112S247 128 256 128S272 121 272 112S265 96 256 96ZM224 208C215 208 208 215 208 224S215 240 224 240S240 233 240 224S233 208 224 208Z"]
  };
  var faGlass = {
    prefix: 'far',
    iconName: 'glass',
    icon: [384, 512, [], "f804", "M352 0H32C13 0 -1 16 0 34L33 453C35 486 63 512 97 512H294C327 512 356 486 358 452L384 34C385 16 370 0 352 0ZM310 449C309 457 302 464 294 464H97C88 464 81 458 81 449L59 176H327L310 449ZM330 128H56L49 48H335L330 128Z"]
  };
  var faGlassCitrus = {
    prefix: 'far',
    iconName: 'glass-citrus',
    icon: [512, 512, [], "f869", "M368 0C305 0 253 40 233 96H285C302 67 333 48 368 48C421 48 464 91 464 144C464 194 425 235 376 239L372 288C449 286 512 222 512 144C512 65 448 0 368 0ZM320 128H32C23 128 14 132 8 138C2 145 -1 154 0 163L29 454C33 487 60 512 93 512H259C292 512 319 487 323 454L352 163C353 154 350 145 344 138C338 132 329 128 320 128ZM275 450C274 458 267 464 259 464H93C85 464 78 458 77 450L62 304H290L275 450ZM294 256H58L50 176H302L294 256Z"]
  };
  var faGlassEmpty = {
    prefix: 'far',
    iconName: 'glass-empty',
    icon: [384, 512, [], "e13b", "M352 0H32C13 0 -1 16 0 34L33 453C35 486 63 512 97 512H294C327 512 356 486 358 452L384 34C385 16 370 0 352 0ZM310 449C309 457 302 464 294 464H97C88 464 81 458 81 449L49 48H335L310 449Z"]
  };
  var faGlassHalf = {
    prefix: 'far',
    iconName: 'glass-half',
    icon: [384, 512, [], "e13c", "M352 0H32C13 0 -1 16 0 34L33 453C35 486 63 512 97 512H294C327 512 356 486 358 452L384 34C385 16 370 0 352 0ZM335 48L323 240H64L49 48H335ZM294 464H97C88 464 81 458 81 449L68 288H320L310 449C309 457 302 464 294 464Z"]
  };
  var faGlasses = {
    prefix: 'far',
    iconName: 'glasses',
    icon: [576, 512, [], "f530", "M574 280L529 99C523 75 507 55 486 43C464 31 439 29 416 37L400 42C392 44 387 54 390 62L395 77C398 85 407 90 416 87L429 83C440 79 452 79 462 85S479 99 482 110L521 264C499 257 471 252 440 252C400 252 354 261 306 288H270C222 261 177 252 137 252C105 252 78 257 55 264L94 110C97 99 104 90 114 84C124 79 136 79 147 83L160 87C169 90 178 85 181 77L186 62C189 53 184 44 176 42L160 36C137 29 112 31 90 43C69 55 53 75 47 99L2 280C1 285 0 291 0 296V366C0 429 52 480 115 480H152C213 480 263 434 267 375L270 336H306L309 375C313 434 363 480 424 480H461C524 480 576 429 576 366V296C576 291 575 286 574 280ZM219 371C217 405 187 432 152 432H115C78 432 48 402 48 366V318C68 310 99 300 137 300C166 300 196 306 223 318L219 371ZM528 366C528 402 498 432 461 432H424C389 432 359 405 357 371L353 318C381 306 410 300 440 300C477 300 508 310 528 318V366Z"]
  };
  var faGlassesRound = {
    prefix: 'far',
    iconName: 'glasses-round',
    icon: [576, 512, [], "f5f5", "M561 226L529 99C522 72 495 32 443 32C428 32 420 35 400 42C392 44 387 54 390 62L395 77C397 84 404 88 410 88C414 88 415 87 429 83C455 74 477 89 482 110L512 229C491 216 466 208 440 208C385 208 338 241 316 288H260C238 241 191 208 136 208C110 208 85 216 64 229L94 110C99 89 121 74 147 83C161 87 162 88 166 88C172 88 178 84 181 77L186 62C189 53 184 44 176 42C156 35 148 32 133 32C81 32 54 72 47 99L15 226C2 279 0 300 0 344C0 419 61 480 136 480C208 480 267 423 271 352H305C309 423 368 480 440 480C515 480 576 419 576 344C576 300 574 279 561 226ZM136 432C87 432 48 393 48 344S87 256 136 256S224 295 224 344S185 432 136 432ZM440 432C391 432 352 393 352 344S391 256 440 256S528 295 528 344S489 432 440 432Z"]
  };
  var faGlobe = {
    prefix: 'far',
    iconName: 'globe',
    icon: [512, 512, [], "f0ac", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM422 160H373C367 133 358 108 347 87C378 104 404 129 422 160ZM336 256C336 273 335 289 333 304H179C177 289 176 273 176 256S177 223 179 208H333C335 223 336 239 336 256ZM256 448C234 448 205 412 189 352H323C307 412 278 448 256 448ZM189 160C205 100 234 64 256 64S307 100 323 160H189ZM165 87C154 108 145 133 139 160H90C108 129 134 104 165 87ZM70 208H131C129 224 128 240 128 256S129 288 131 304H70C66 289 64 273 64 256S66 223 70 208ZM90 352H139C145 379 154 404 165 425C134 408 108 383 90 352ZM347 425C358 404 367 379 373 352H422C404 383 378 408 347 425ZM442 304H381C383 288 384 272 384 256S383 224 381 208H442C446 223 448 239 448 256S446 289 442 304Z"]
  };
  var faGlobeSnow = {
    prefix: 'far',
    iconName: 'globe-snow',
    icon: [448, 512, [], "f7a3", "M232 80C219 80 208 91 208 104S219 128 232 128S256 117 256 104S245 80 232 80ZM104 160C91 160 80 171 80 184S91 208 104 208S128 197 128 184S117 160 104 160ZM328 144C315 144 304 155 304 168S315 192 328 192S352 181 352 168S341 144 328 144ZM363 399C415 358 448 295 448 224C448 100 348 0 224 0S0 100 0 224C0 295 33 358 85 399L38 461C23 482 38 512 64 512H384C410 512 425 482 410 461L363 399ZM297 384H256V336H314C328 336 336 321 327 311L276 256H291C302 256 308 245 301 237L234 164C229 159 219 159 214 164L147 237C140 245 146 256 157 256H172L121 311C112 321 120 336 134 336H192V384H151C90 356 48 295 48 224C48 127 127 48 224 48S400 127 400 224C400 295 358 356 297 384Z"]
  };
  var faGlobeStand = {
    prefix: 'far',
    iconName: 'globe-stand',
    icon: [448, 512, [], "f5f6", "M208 352C296 352 368 280 368 192S296 32 208 32S48 104 48 192S120 352 208 352ZM208 80C270 80 320 130 320 192S270 304 208 304C146 304 96 254 96 192S146 80 208 80ZM360 464H248V428C361 409 448 311 448 192C448 140 431 90 401 49L409 41C418 32 418 17 409 7C400 -2 385 -3 375 7L351 30C342 39 341 53 350 63C382 98 400 144 400 192C400 298 314 384 208 384C160 384 114 366 79 334C69 326 55 326 46 335L7 375C-2 385 -2 400 7 409C17 418 32 418 41 409L65 385C104 414 151 430 200 431V464H88C75 464 64 475 64 488S75 512 88 512H360C373 512 384 501 384 488S373 464 360 464Z"]
  };
  var faGolfBallTee = {
    prefix: 'far',
    iconName: 'golf-ball-tee',
    icon: [384, 512, [], "f450", "M160 202C165 215 177 224 191 224C209 224 224 209 224 191C224 177 215 165 202 160C211 187 186 211 160 202ZM176 282C181 295 193 304 207 304C225 304 240 289 240 271C240 257 231 245 218 240C227 267 202 291 176 282ZM240 218C245 231 257 240 271 240C289 240 304 225 304 207C304 193 295 181 282 176C291 203 266 227 240 218ZM96 400C96 418 110 432 128 432S160 446 160 464V512H224V464C224 446 238 432 256 432S288 418 288 400V384H96V400ZM192 0C86 0 0 86 0 192C0 255 31 314 82 350C93 357 108 354 116 344C123 333 121 318 110 310C71 283 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 313 283 274 310C263 318 261 333 268 344C273 350 280 354 288 354C293 354 298 352 302 350C353 314 384 255 384 192C384 86 298 0 192 0Z"]
  };
  var faGolfClub = {
    prefix: 'far',
    iconName: 'golf-club',
    icon: [512, 512, [], "f451", "M510 34L313 481C303 501 284 512 264 512H54C24 512 0 488 0 458V310C0 293 8 277 22 267S53 253 70 258L246 308C259 311 267 324 263 337C260 350 246 357 234 354L56 304C53 304 52 304 50 305C49 306 48 308 48 310V336H80C89 336 96 343 96 352S89 368 80 368H48V400H80C89 400 96 407 96 416S89 432 80 432H48V458C48 461 51 464 54 464H264C266 464 268 463 269 461L466 14C471 2 486 -3 498 2C510 7 515 22 510 34Z"]
  };
  var faGopuram = {
    prefix: 'far',
    iconName: 'gopuram',
    icon: [512, 512, [], "f664", "M496 352H480V240C480 231 473 224 464 224H448V144C448 135 441 128 432 128H416V24C416 11 405 0 392 0S368 11 368 24V32H320V24C320 11 309 0 296 0S272 11 272 24V32H240V24C240 11 229 0 216 0S192 11 192 24V32H144V24C144 11 133 0 120 0S96 11 96 24V128H80C71 128 64 135 64 144V224H48C39 224 32 231 32 240V352H16C7 352 0 359 0 368V488C0 501 11 512 24 512H24C37 512 48 501 48 488V400H96V496C96 505 103 512 112 512H112C121 512 128 505 128 496V400H384V496C384 505 391 512 400 512H400C409 512 416 505 416 496V400H464V488C464 501 475 512 488 512L488 512C501 512 512 501 512 488V368C512 359 505 352 496 352ZM144 80H368V128H144V80ZM264 200H248C239 200 232 207 232 216V224H192V176H320V224H280V216C280 207 273 200 264 200ZM112 176H160V224H112V176ZM128 352H80V272H128V352ZM352 352H288V320C288 311 281 304 272 304H240C231 304 224 311 224 320V352H160V272H352V352ZM352 224V176H400V224H352ZM432 352H384V272H432V352ZM288 432H224C215 432 208 439 208 448V496C208 505 215 512 224 512H288C297 512 304 505 304 496V448C304 439 297 432 288 432Z"]
  };
  var faGraduationCap = {
    prefix: 'far',
    iconName: 'graduation-cap',
    icon: [640, 512, [], "f19d", "M624 137L341 36C334 33 327 32 320 32S306 33 299 36L16 137C6 140 0 150 0 160S6 180 16 183L76 205C64 220 56 239 52 259C40 263 32 275 32 288C32 298 37 306 44 312L19 461C17 471 25 480 35 480H93C103 480 111 471 109 461L84 312C91 306 96 298 96 288C96 278 91 269 83 263C88 245 96 229 108 216L299 284C306 287 313 288 320 288S334 287 341 284L624 183C634 180 640 170 640 160S634 140 624 137ZM325 239C321 241 317 240 315 239L176 189L325 143C333 141 338 132 335 123C333 115 324 110 315 113L125 171L94 160L315 81C319 79 323 80 325 81L546 160L325 239ZM452 279L464 391C464 401 414 432 320 432S176 401 176 391L188 279L142 262L128 388C128 449 225 480 320 480S512 449 512 388L498 262L452 279Z"]
  };
  var faGramophone = {
    prefix: 'far',
    iconName: 'gramophone',
    icon: [384, 512, [], "f8bd", "M56 320C61 320 66 318 70 316C110 288 194 239 271 239C283 238 296 240 308 243C320 246 328 257 328 269C328 288 312 304 293 304H184C171 304 160 315 160 328V328C160 341 171 352 184 352H293C339 352 376 315 376 269C376 235 353 206 321 197C237 174 175 65 151 14C146 4 137 -1 127 0C117 1 109 8 106 18L33 290C31 297 32 305 37 311C42 317 49 320 56 320ZM137 89C158 125 187 165 223 195C177 205 131 225 95 245L137 89ZM360 464H352V416C352 398 338 384 320 384H64C46 384 32 398 32 416V464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H360C373 512 384 501 384 488V488C384 475 373 464 360 464ZM304 464H80V432H304V464Z"]
  };
  var faGreaterThan = {
    prefix: 'far',
    iconName: 'greater-than',
    icon: [640, 512, [], "f531", "M466 234L130 74C118 69 104 74 98 86C93 98 98 112 110 118L400 256L110 394C98 400 93 414 98 426C102 435 111 440 120 440C123 440 127 439 130 438L466 278C475 274 480 265 480 256S475 238 466 234ZM-1058 86C-1064 74 -1078 69 -1090 74L-1426 234C-1435 238 -1440 247 -1440 256S-1435 274 -1426 278L-1090 438C-1087 439 -1083 440 -1080 440C-1071 440 -1062 435 -1058 426C-1053 414 -1058 400 -1070 394L-1360 256L-1070 118C-1058 112 -1053 98 -1058 86ZM1634 353C1638 363 1647 368 1656 368C1659 368 1662 367 1665 366L2001 222C2010 218 2016 210 2016 200S2010 182 2001 178L1665 34C1653 29 1639 34 1634 47C1629 59 1634 73 1647 78L1931 200L1647 322C1634 327 1629 341 1634 353ZM2024 432H1624C1611 432 1600 443 1600 456S1611 480 1624 480H2024C2037 480 2048 469 2048 456S2037 432 2024 432Z"]
  };
  var faGreaterThanEqual = {
    prefix: 'far',
    iconName: 'greater-than-equal',
    icon: [640, 512, [], "f532", "M-1038 234L-1374 74C-1386 69 -1400 74 -1406 86C-1411 98 -1406 112 -1394 118L-1104 256L-1394 394C-1406 400 -1411 414 -1406 426C-1402 435 -1393 440 -1384 440C-1381 440 -1377 439 -1374 438L-1038 278C-1029 274 -1024 265 -1024 256S-1029 238 -1038 234ZM-2562 86C-2568 74 -2582 69 -2594 74L-2930 234C-2939 238 -2944 247 -2944 256S-2939 274 -2930 278L-2594 438C-2591 439 -2587 440 -2584 440C-2575 440 -2566 435 -2562 426C-2557 414 -2562 400 -2574 394L-2864 256L-2574 118C-2562 112 -2557 98 -2562 86ZM130 353C134 363 143 368 152 368C155 368 158 367 161 366L497 222C506 218 512 210 512 200S506 182 497 178L161 34C149 29 135 34 130 47C125 59 130 73 143 78L427 200L143 322C130 327 125 341 130 353ZM520 432H120C107 432 96 443 96 456S107 480 120 480H520C533 480 544 469 544 456S533 432 520 432Z"]
  };
  var faGrid = {
    prefix: 'far',
    iconName: 'grid',
    icon: [512, 512, [], "e13d", "M96 192H32C14 192 0 206 0 224V288C0 306 14 320 32 320H96C114 320 128 306 128 288V224C128 206 114 192 96 192ZM80 272H48V240H80V272ZM480 0H416C398 0 384 14 384 32V96C384 114 398 128 416 128H480C498 128 512 114 512 96V32C512 14 498 0 480 0ZM464 80H432V48H464V80ZM288 0H224C206 0 192 14 192 32V96C192 114 206 128 224 128H288C306 128 320 114 320 96V32C320 14 306 0 288 0ZM272 80H240V48H272V80ZM96 384H32C14 384 0 398 0 416V480C0 498 14 512 32 512H96C114 512 128 498 128 480V416C128 398 114 384 96 384ZM80 464H48V432H80V464ZM96 0H32C14 0 0 14 0 32V96C0 114 14 128 32 128H96C114 128 128 114 128 96V32C128 14 114 0 96 0ZM80 80H48V48H80V80ZM288 192H224C206 192 192 206 192 224V288C192 306 206 320 224 320H288C306 320 320 306 320 288V224C320 206 306 192 288 192ZM272 272H240V240H272V272ZM480 384H416C398 384 384 398 384 416V480C384 498 398 512 416 512H480C498 512 512 498 512 480V416C512 398 498 384 480 384ZM464 464H432V432H464V464ZM288 384H224C206 384 192 398 192 416V480C192 498 206 512 224 512H288C306 512 320 498 320 480V416C320 398 306 384 288 384ZM272 464H240V432H272V464ZM480 192H416C398 192 384 206 384 224V288C384 306 398 320 416 320H480C498 320 512 306 512 288V224C512 206 498 192 480 192ZM464 272H432V240H464V272Z"]
  };
  var faGrid2 = {
    prefix: 'far',
    iconName: 'grid-2',
    icon: [512, 512, [], "e13e", "M176 288H48C22 288 0 310 0 336V464C0 490 22 512 48 512H176C202 512 224 490 224 464V336C224 310 202 288 176 288ZM176 464H48V336H176V464ZM176 0H48C22 0 0 22 0 48V176C0 202 22 224 48 224H176C202 224 224 202 224 176V48C224 22 202 0 176 0ZM176 176H48V48H176V176ZM464 288H336C310 288 288 310 288 336V464C288 490 310 512 336 512H464C490 512 512 490 512 464V336C512 310 490 288 464 288ZM464 464H336V336H464V464ZM464 0H336C310 0 288 22 288 48V176C288 202 310 224 336 224H464C490 224 512 202 512 176V48C512 22 490 0 464 0ZM464 176H336V48H464V176Z"]
  };
  var faGrid4 = {
    prefix: 'far',
    iconName: 'grid-4',
    icon: [512, 512, [], "e13f", "M219 0H155C146 0 139 7 139 16V80C139 89 146 96 155 96H219C227 96 235 89 235 80V16C235 7 227 0 219 0ZM219 139H155C146 139 139 146 139 155V219C139 227 146 235 155 235H219C227 235 235 227 235 219V155C235 146 227 139 219 139ZM219 277H155C146 277 139 285 139 293V357C139 366 146 373 155 373H219C227 373 235 366 235 357V293C235 285 227 277 219 277ZM219 416H155C146 416 139 423 139 432V496C139 505 146 512 155 512H219C227 512 235 505 235 496V432C235 423 227 416 219 416ZM80 416H16C7 416 0 423 0 432V496C0 505 7 512 16 512H80C89 512 96 505 96 496V432C96 423 89 416 80 416ZM80 139H16C7 139 0 146 0 155V219C0 227 7 235 16 235H80C89 235 96 227 96 219V155C96 146 89 139 80 139ZM80 277H16C7 277 0 285 0 293V357C0 366 7 373 16 373H80C89 373 96 366 96 357V293C96 285 89 277 80 277ZM80 0H16C7 0 0 7 0 16V80C0 89 7 96 16 96H80C89 96 96 89 96 80V16C96 7 89 0 80 0ZM496 416H432C423 416 416 423 416 432V496C416 505 423 512 432 512H496C505 512 512 505 512 496V432C512 423 505 416 496 416ZM496 277H432C423 277 416 285 416 293V357C416 366 423 373 432 373H496C505 373 512 366 512 357V293C512 285 505 277 496 277ZM496 139H432C423 139 416 146 416 155V219C416 227 423 235 432 235H496C505 235 512 227 512 219V155C512 146 505 139 496 139ZM496 0H432C423 0 416 7 416 16V80C416 89 423 96 432 96H496C505 96 512 89 512 80V16C512 7 505 0 496 0ZM357 139H293C285 139 277 146 277 155V219C277 227 285 235 293 235H357C366 235 373 227 373 219V155C373 146 366 139 357 139ZM357 277H293C285 277 277 285 277 293V357C277 366 285 373 293 373H357C366 373 373 366 373 357V293C373 285 366 277 357 277ZM357 0H293C285 0 277 7 277 16V80C277 89 285 96 293 96H357C366 96 373 89 373 80V16C373 7 366 0 357 0ZM357 416H293C285 416 277 423 277 432V496C277 505 285 512 293 512H357C366 512 373 505 373 496V432C373 423 366 416 357 416Z"]
  };
  var faGrid5 = {
    prefix: 'far',
    iconName: 'grid-5',
    icon: [512, 512, [], "e140", "M168 112H120C116 112 112 116 112 120V168C112 172 116 176 120 176H168C172 176 176 172 176 168V120C176 116 172 112 168 112ZM168 224H120C116 224 112 228 112 232V280C112 284 116 288 120 288H168C172 288 176 284 176 280V232C176 228 172 224 168 224ZM168 336H120C116 336 112 340 112 344V392C112 396 116 400 120 400H168C172 400 176 396 176 392V344C176 340 172 336 168 336ZM280 224H232C228 224 224 228 224 232V280C224 284 228 288 232 288H280C284 288 288 284 288 280V232C288 228 284 224 280 224ZM280 448H232C228 448 224 452 224 456V504C224 508 228 512 232 512H280C284 512 288 508 288 504V456C288 452 284 448 280 448ZM280 336H232C228 336 224 340 224 344V392C224 396 228 400 232 400H280C284 400 288 396 288 392V344C288 340 284 336 280 336ZM168 0H120C116 0 112 4 112 8V56C112 60 116 64 120 64H168C172 64 176 60 176 56V8C176 4 172 0 168 0ZM168 448H120C116 448 112 452 112 456V504C112 508 116 512 120 512H168C172 512 176 508 176 504V456C176 452 172 448 168 448ZM56 448H8C4 448 0 452 0 456V504C0 508 4 512 8 512H56C60 512 64 508 64 504V456C64 452 60 448 56 448ZM56 336H8C4 336 0 340 0 344V392C0 396 4 400 8 400H56C60 400 64 396 64 392V344C64 340 60 336 56 336ZM56 112H8C4 112 0 116 0 120V168C0 172 4 176 8 176H56C60 176 64 172 64 168V120C64 116 60 112 56 112ZM56 0H8C4 0 0 4 0 8V56C0 60 4 64 8 64H56C60 64 64 60 64 56V8C64 4 60 0 56 0ZM56 224H8C4 224 0 228 0 232V280C0 284 4 288 8 288H56C60 288 64 284 64 280V232C64 228 60 224 56 224ZM392 0H344C340 0 336 4 336 8V56C336 60 340 64 344 64H392C396 64 400 60 400 56V8C400 4 396 0 392 0ZM504 448H456C452 448 448 452 448 456V504C448 508 452 512 456 512H504C508 512 512 508 512 504V456C512 452 508 448 504 448ZM504 224H456C452 224 448 228 448 232V280C448 284 452 288 456 288H504C508 288 512 284 512 280V232C512 228 508 224 504 224ZM504 336H456C452 336 448 340 448 344V392C448 396 452 400 456 400H504C508 400 512 396 512 392V344C512 340 508 336 504 336ZM504 0H456C452 0 448 4 448 8V56C448 60 452 64 456 64H504C508 64 512 60 512 56V8C512 4 508 0 504 0ZM504 112H456C452 112 448 116 448 120V168C448 172 452 176 456 176H504C508 176 512 172 512 168V120C512 116 508 112 504 112ZM392 448H344C340 448 336 452 336 456V504C336 508 340 512 344 512H392C396 512 400 508 400 504V456C400 452 396 448 392 448ZM280 0H232C228 0 224 4 224 8V56C224 60 228 64 232 64H280C284 64 288 60 288 56V8C288 4 284 0 280 0ZM392 112H344C340 112 336 116 336 120V168C336 172 340 176 344 176H392C396 176 400 172 400 168V120C400 116 396 112 392 112ZM280 112H232C228 112 224 116 224 120V168C224 172 228 176 232 176H280C284 176 288 172 288 168V120C288 116 284 112 280 112ZM392 336H344C340 336 336 340 336 344V392C336 396 340 400 344 400H392C396 400 400 396 400 392V344C400 340 396 336 392 336ZM392 224H344C340 224 336 228 336 232V280C336 284 340 288 344 288H392C396 288 400 284 400 280V232C400 228 396 224 392 224Z"]
  };
  var faGrip = {
    prefix: 'far',
    iconName: 'grip',
    icon: [448, 512, [], "f58d", "M96 288H32C14 288 0 302 0 320V384C0 402 14 416 32 416H96C114 416 128 402 128 384V320C128 302 114 288 96 288ZM80 368H48V336H80V368ZM96 96H32C14 96 0 110 0 128V192C0 210 14 224 32 224H96C114 224 128 210 128 192V128C128 110 114 96 96 96ZM80 176H48V144H80V176ZM256 288H192C174 288 160 302 160 320V384C160 402 174 416 192 416H256C274 416 288 402 288 384V320C288 302 274 288 256 288ZM240 368H208V336H240V368ZM416 96H352C334 96 320 110 320 128V192C320 210 334 224 352 224H416C434 224 448 210 448 192V128C448 110 434 96 416 96ZM400 176H368V144H400V176ZM416 288H352C334 288 320 302 320 320V384C320 402 334 416 352 416H416C434 416 448 402 448 384V320C448 302 434 288 416 288ZM400 368H368V336H400V368ZM256 96H192C174 96 160 110 160 128V192C160 210 174 224 192 224H256C274 224 288 210 288 192V128C288 110 274 96 256 96ZM240 176H208V144H240V176Z"]
  };
  var faGripLines = {
    prefix: 'far',
    iconName: 'grip-lines',
    icon: [448, 512, [], "f7a4", "M424 168H24C11 168 0 179 0 192V192C0 205 11 216 24 216H424C437 216 448 205 448 192V192C448 179 437 168 424 168ZM424 296H24C11 296 0 307 0 320V320C0 333 11 344 24 344H424C437 344 448 333 448 320V320C448 307 437 296 424 296Z"]
  };
  var faGripLinesVertical = {
    prefix: 'far',
    iconName: 'grip-lines-vertical',
    icon: [256, 512, [], "f7a5", "M64 32L64 32C51 32 40 43 40 56V456C40 469 51 480 64 480H64C77 480 88 469 88 456V56C88 43 77 32 64 32ZM192 32L192 32C179 32 168 43 168 56V456C168 469 179 480 192 480H192C205 480 216 469 216 456V56C216 43 205 32 192 32Z"]
  };
  var faGripVertical = {
    prefix: 'far',
    iconName: 'grip-vertical',
    icon: [320, 512, [], "f58e", "M96 352H32C14 352 0 366 0 384V448C0 466 14 480 32 480H96C114 480 128 466 128 448V384C128 366 114 352 96 352ZM80 432H48V400H80V432ZM288 352H224C206 352 192 366 192 384V448C192 466 206 480 224 480H288C306 480 320 466 320 448V384C320 366 306 352 288 352ZM272 432H240V400H272V432ZM288 32H224C206 32 192 46 192 64V128C192 146 206 160 224 160H288C306 160 320 146 320 128V64C320 46 306 32 288 32ZM272 112H240V80H272V112ZM288 192H224C206 192 192 206 192 224V288C192 306 206 320 224 320H288C306 320 320 306 320 288V224C320 206 306 192 288 192ZM272 272H240V240H272V272ZM96 192H32C14 192 0 206 0 224V288C0 306 14 320 32 320H96C114 320 128 306 128 288V224C128 206 114 192 96 192ZM80 272H48V240H80V272ZM96 32H32C14 32 0 46 0 64V128C0 146 14 160 32 160H96C114 160 128 146 128 128V64C128 46 114 32 96 32ZM80 112H48V80H80V112Z"]
  };
  var faGuaraniSign = {
    prefix: 'far',
    iconName: 'guarani-sign',
    icon: [384, 512, [], "e141", "M344 224H216V113C250 115 283 128 308 154C318 163 333 163 342 154S352 129 342 120C307 85 262 67 216 65V24C216 11 205 0 192 0S168 11 168 24V68C133 76 99 93 72 120C36 156 16 204 16 255C16 306 36 354 72 390C98 416 132 433 168 441V488C168 501 179 512 192 512S216 501 216 488V447C217 447 219 448 220 448C273 448 325 430 361 394C365 389 368 383 368 377V248C368 235 357 224 344 224ZM106 356C79 329 64 293 64 255S79 181 106 154C124 136 145 125 168 118V392C145 385 123 373 106 356ZM320 366C293 390 254 400 216 400V272H320V366Z"]
  };
  var faGuitar = {
    prefix: 'far',
    iconName: 'guitar',
    icon: [640, 512, [], "f7a6", "M503 30L473 0C461 -13 440 -13 428 0L382 46C378 50 375 55 373 60L355 114L319 150C304 137 286 127 267 122C257 120 248 119 238 119C212 119 187 128 169 146C158 156 151 169 147 182C140 203 121 218 101 220C75 223 51 233 32 251C-18 301 -9 390 52 451C86 485 130 503 170 503C201 503 230 492 252 470C270 452 280 428 283 402C284 381 300 363 320 356C334 352 346 344 357 334C382 309 389 272 381 236C376 216 366 199 353 183L389 147L443 130C448 128 452 125 456 121L503 75C515 62 515 42 503 30ZM305 310C267 323 238 358 235 397C230 448 187 455 170 455C140 455 110 441 86 417C62 393 48 362 48 333C48 316 55 273 105 268C145 264 180 236 192 197C203 163 248 155 285 184L220 248C199 242 176 252 165 271C154 290 157 314 173 330C188 346 213 349 232 338C251 326 260 304 254 282L319 218C346 252 341 299 305 310Z"]
  };
  var faGuitarElectric = {
    prefix: 'far',
    iconName: 'guitar-electric',
    icon: [512, 512, [], "f8be", "M511 40C508 20 493 5 473 1C450 -3 451 1 367 55C357 61 352 71 352 82V127L269 210C266 206 265 201 267 197L283 163C291 145 286 123 269 112C253 100 230 102 216 116L181 151C171 161 163 174 159 187C154 199 145 209 134 214L63 246C33 259 9 287 2 321C-5 355 6 390 30 414L98 482C122 506 157 517 191 510C225 503 253 479 266 447L298 378C303 367 313 358 325 353C338 349 351 341 361 331L380 311C397 295 397 268 380 251C363 234 342 240 338 241L316 248C309 250 304 246 302 244L452 95C456 96 460 96 464 96C478 96 492 90 501 79C510 68 514 54 511 40ZM312 289C317 289 323 288 328 286L352 280L332 303C326 309 319 313 312 316C290 324 272 340 262 361L229 432C221 452 204 466 183 471C162 475 141 469 126 454L59 386C43 371 37 350 41 329C46 308 60 291 80 283L151 250C172 240 188 222 196 200C199 193 204 186 209 180L245 144L231 180C221 200 226 224 241 240L275 273C285 283 298 289 312 289ZM135 325C128 319 118 319 112 325L101 336C94 342 94 352 101 359L153 411C160 417 170 417 176 411L187 400C193 394 193 384 187 377L135 325ZM199 261C192 255 182 255 176 261L165 272C158 278 158 288 165 295L217 347C224 353 234 353 240 347L251 336C257 330 257 320 251 313L199 261Z"]
  };
  var faGuitars = {
    prefix: 'far',
    iconName: 'guitars',
    icon: [512, 512, [], "f8bf", "M188 444C173 457 151 464 128 464S83 457 68 444C61 438 48 425 48 407C48 398 52 388 59 380C82 352 86 311 69 278C57 253 86 236 87 235C91 233 97 231 104 230V312C104 325 115 336 128 336C141 336 152 325 152 312V230C159 231 165 233 169 235C185 245 195 262 187 278C170 311 174 352 197 379C199 382 200 384 202 387L225 324C224 316 226 307 229 300C230 300 230 300 230 299C229 295 228 290 226 285C219 271 216 256 216 241V213C215 212 214 210 213 210C207 204 201 199 194 195C182 187 167 183 152 181V127L169 94C171 90 172 85 172 81V26C172 12 160 0 145 0H111C96 0 84 12 84 26V80C84 85 85 89 87 93L104 127V181C89 183 74 187 61 195C55 199 49 204 43 210C28 225 18 245 18 266C18 278 21 290 27 300C35 316 33 336 22 349C8 366 0 385 0 407C0 465 57 512 128 512C156 512 184 504 208 489C199 474 194 457 193 440C191 442 190 443 188 444ZM400 384H336C327 384 320 391 320 400V416C320 425 327 432 336 432H400C409 432 416 425 416 416V400C416 391 409 384 400 384ZM506 401L478 327C472 309 473 289 481 272C486 262 488 251 488 241V212C488 207 486 203 483 199C479 196 475 194 470 194C463 194 456 198 453 204L443 224C437 235 427 238 416 240H392V73C394 72 395 71 397 70C409 58 412 40 406 25C400 10 385 0 368 0C360 0 352 2 346 7C329 18 332 20 314 103C312 112 315 122 321 128L344 151V240H320C309 237 299 231 295 220L282 184C280 178 273 173 266 173C256 173 248 181 248 190V241C248 252 250 262 255 272C263 289 264 309 258 328L231 401C208 454 246 512 304 512H432C489 512 528 453 506 401ZM432 464H304C275 464 268 435 275 420C275 419 272 428 303 344C309 326 311 307 309 288C309 288 426 288 427 288C425 306 427 327 434 344C464 428 461 419 461 420C473 446 448 464 432 464Z"]
  };
  var faH = {
    prefix: 'far',
    iconName: 'h',
    icon: [384, 512, [], "e142", "M384 64V448C384 466 370 480 352 480S320 466 320 448V271H64V448C64 466 50 480 32 480S0 466 0 448V64C0 46 14 32 32 32S64 46 64 64V207H320V64C320 46 334 32 352 32S384 46 384 64Z"]
  };
  var faH1 = {
    prefix: 'far',
    iconName: 'h1',
    icon: [576, 512, [], "f313", "M296 64C283 64 272 75 272 88V224H48V88C48 75 37 64 24 64S0 75 0 88V424C0 437 11 448 24 448S48 437 48 424V272H272V424C272 437 283 448 296 448S320 437 320 424V88C320 75 309 64 296 64ZM552 400H504V88C504 79 499 71 491 67C484 63 474 63 467 68L395 116C384 123 381 138 388 149C395 160 410 163 421 156L456 133V400H408C395 400 384 411 384 424C384 437 395 448 408 448H552C565 448 576 437 576 424C576 411 565 400 552 400Z"]
  };
  var faH2 = {
    prefix: 'far',
    iconName: 'h2',
    icon: [640, 512, [], "f314", "M296 64C283 64 272 75 272 88V224H48V88C48 75 37 64 24 64S0 75 0 88V424C0 437 11 448 24 448S48 437 48 424V272H272V424C272 437 283 448 296 448S320 437 320 424V88C320 75 309 64 296 64ZM616 400H418C426 345 462 298 514 275L583 246C617 231 640 197 640 159C640 107 597 64 545 64C490 64 446 80 415 111C406 120 406 136 415 145S440 154 449 145C471 123 503 112 545 112C571 112 592 133 592 159C592 178 581 194 564 202L495 231C418 264 368 340 368 424C368 437 379 448 392 448H616C629 448 640 437 640 424S629 400 616 400Z"]
  };
  var faH3 = {
    prefix: 'far',
    iconName: 'h3',
    icon: [640, 512, [], "f315", "M296 64C283 64 272 75 272 88V224H48V88C48 75 37 64 24 64S0 75 0 88V424C0 437 11 448 24 448S48 437 48 424V272H272V424C272 437 283 448 296 448S320 437 320 424V88C320 75 309 64 296 64ZM516 208H514L617 105C624 98 626 88 622 79C618 70 610 64 600 64H392C379 64 368 75 368 88S379 112 392 112H542L439 215C432 222 430 232 434 241C438 250 446 256 456 256H516C558 256 592 290 592 332S558 408 516 408C476 408 440 386 421 352C415 340 400 336 389 342C377 348 373 363 379 374C406 425 459 456 516 456C584 456 640 400 640 332S584 208 516 208Z"]
  };
  var faH4 = {
    prefix: 'far',
    iconName: 'h4',
    icon: [640, 512, [], "f86a", "M296 64C283 64 272 75 272 88V224H48V88C48 75 37 64 24 64S0 75 0 88V424C0 437 11 448 24 448S48 437 48 424V272H272V424C272 437 283 448 296 448S320 437 320 424V88C320 75 309 64 296 64ZM616 64C603 64 592 75 592 88V272H432V88C432 75 421 64 408 64S384 75 384 88V296C384 309 395 320 408 320H592V424C592 437 603 448 616 448S640 437 640 424V88C640 75 629 64 616 64Z"]
  };
  var faHammer = {
    prefix: 'far',
    iconName: 'hammer',
    icon: [576, 512, [], "f6e3", "M0 389C-28 417 -28 463 0 491C14 505 32 512 51 512S88 505 102 491L304 259L232 187L0 389ZM550 195L527 172C521 166 511 166 505 172L493 183L464 154C470 133 465 109 448 93L402 47C371 16 330 0 289 0C248 0 207 16 175 47L243 115V134C243 142 245 150 248 158L333 243C341 246 349 248 357 248C362 248 368 247 373 245L402 274L391 286C385 292 385 302 391 309L414 331C420 338 430 338 437 331L550 218C556 211 556 201 550 195ZM448 252L388 192L361 199C352 201 346 195 346 195L296 145C293 143 292 138 292 134V95L251 55C263 50 276 48 289 48C319 48 347 60 368 81L414 127C420 133 418 140 418 142L411 169L471 229L448 252Z"]
  };
  var faHammerWar = {
    prefix: 'far',
    iconName: 'hammer-war',
    icon: [384, 512, [], "f6e4", "M352 32C348 32 357 31 216 54V24C216 11 205 0 192 0H192C179 0 168 11 168 24V54C26 31 36 32 32 32C15 32 0 46 0 64V256C0 274 15 288 32 288C36 288 27 289 168 266V488C168 501 179 512 192 512H192C205 512 216 501 216 488V266C358 289 348 288 352 288C369 288 384 274 384 256V64C384 46 369 32 352 32ZM336 237L192 213L48 237V83L192 107L336 83V237Z"]
  };
  var faHamsa = {
    prefix: 'far',
    iconName: 'hamsa',
    icon: [512, 512, [], "f665", "M256 288C203 288 160 352 160 352S203 416 256 416S352 352 352 352S309 288 256 288ZM256 384C238 384 224 370 224 352S238 320 256 320C274 320 288 334 288 352S274 384 256 384ZM506 283C494 257 467 240 438 240H432V114C432 74 403 39 365 33C361 32 356 32 352 32C342 32 332 34 323 37C311 18 292 5 269 1C265 0 260 0 256 0C228 0 203 15 188 37C184 35 178 34 173 33C169 32 164 32 160 32C116 32 80 68 80 112V240H74C45 240 18 257 6 283C-6 311 0 342 20 364L104 450C142 489 197 512 256 512S370 489 408 450L492 364C512 342 518 311 506 283ZM457 330L374 417C345 447 302 464 256 464S168 447 139 417L55 330C48 323 46 312 50 303C54 294 64 288 74 288H128V112C128 94 142 80 160 80C162 80 164 80 165 81C181 83 192 98 192 114C192 117 192 178 192 208C192 217 199 224 208 224H208C217 224 224 217 224 208C224 172 224 84 224 80C224 62 238 48 256 48C258 48 259 48 261 49C277 51 288 66 288 82C288 86 288 172 288 208C288 217 295 224 304 224H304C313 224 320 217 320 208C319 178 319 116 320 112C320 94 334 80 352 80C356 80 359 81 364 83C376 88 384 101 384 115L384 288H438C448 288 458 294 462 303C466 312 464 323 457 330Z"]
  };
  var faHandDots = {
    prefix: 'far',
    iconName: 'hand-dots',
    icon: [512, 512, [], "f461", "M208 320C199 320 192 327 192 336C192 345 199 352 208 352S224 345 224 336C224 327 217 320 208 320ZM272 400C263 400 256 407 256 416C256 425 263 432 272 432S288 425 288 416C288 407 281 400 272 400ZM272 304C263 304 256 311 256 320C256 329 263 336 272 336S288 329 288 320C288 311 281 304 272 304ZM208 384C199 384 192 391 192 400C192 409 199 416 208 416S224 409 224 400C224 391 217 384 208 384ZM352 400C343 400 336 407 336 416C336 425 343 432 352 432S368 425 368 416C368 407 361 400 352 400ZM320 352C311 352 304 359 304 368C304 377 311 384 320 384S336 377 336 368C336 359 329 352 320 352ZM384 304C375 304 368 311 368 320C368 329 375 336 384 336S400 329 400 320C400 311 393 304 384 304ZM408 79C404 79 400 79 396 80C388 56 368 37 342 32C337 32 333 31 328 31C322 31 315 32 309 34C299 17 282 4 262 0C257 0 253 -1 248 -1H248C229 -1 211 7 197 20C190 27 184 36 181 45C172 41 162 39 152 39C150 39 147 39 145 39C105 44 76 79 80 118L91 221C91 223 91 225 92 227C85 225 79 224 72 224C57 224 43 229 31 237C15 248 4 265 1 283C-2 302 2 322 13 337L82 435C115 483 170 512 228 512H301C399 512 480 430 480 330V151C480 111 448 79 408 79ZM432 330C432 404 373 464 301 464H228C186 464 146 443 121 408L52 310C45 299 47 284 58 276C62 273 67 272 72 272C80 272 87 276 92 282L116 318C120 322 125 324 129 324C138 324 146 318 146 308C144 277 142 247 139 216L128 114C127 100 136 89 150 87C150 87 151 87 152 87C164 87 175 96 176 109L186 227C187 236 188 246 189 255C189 264 197 271 206 271C216 271 224 263 224 253V71C224 58 235 47 248 47C250 47 251 47 253 48C264 50 272 60 272 72V255C272 264 279 271 288 271C297 271 304 264 304 255V103C304 90 315 79 328 79C330 79 331 79 333 80C344 82 352 92 352 104V255C352 264 359 271 368 271C377 271 384 264 384 255V152C384 140 392 130 403 128C405 127 406 127 408 127C421 127 432 138 432 151V330Z"]
  };
  var faHandHeart = {
    prefix: 'far',
    iconName: 'hand-heart',
    icon: [512, 512, [], "f4bc", "M286 317L280 322L274 317C260 302 237 299 222 313C204 328 203 356 219 372L274 429C277 433 283 433 286 429L341 372C357 356 356 328 338 313C323 299 300 302 286 317ZM408 79C404 79 400 79 396 80C388 56 368 37 342 32C337 32 333 31 328 31C322 31 315 32 309 34C299 17 282 4 262 0C257 0 253 -1 248 -1H248C229 -1 211 7 197 20C190 27 184 36 181 45C172 41 162 39 152 39C150 39 147 39 145 39C105 44 76 79 80 118L91 221C91 223 91 225 92 227C85 225 79 224 72 224C57 224 43 229 31 237C15 248 4 265 1 283C-2 302 2 322 13 337L82 435C115 483 170 512 228 512H301C399 512 480 430 480 330V151C480 111 448 79 408 79ZM432 330C432 404 373 464 301 464H228C186 464 146 443 121 408L52 310C45 299 47 284 58 276C62 273 67 272 72 272C80 272 87 276 92 282L116 318C120 322 125 324 129 324C138 324 146 318 146 308C144 277 142 247 139 216L128 114C127 100 136 89 150 87C150 87 151 87 152 87C164 87 175 96 176 109L186 227C187 236 188 246 189 255C189 264 197 271 206 271C216 271 224 263 224 253V71C224 58 235 47 248 47C250 47 251 47 253 48C264 50 272 60 272 72V255C272 264 279 271 288 271C297 271 304 264 304 255V103C304 90 315 79 328 79C330 79 331 79 333 80C344 82 352 92 352 104V255C352 264 359 271 368 271C377 271 384 264 384 255V152C384 140 392 130 403 128C405 127 406 127 408 127C421 127 432 138 432 151V330Z"]
  };
  var faHandHolding = {
    prefix: 'far',
    iconName: 'hand-holding',
    icon: [576, 512, [], "f4bd", "M576 366C575 386 565 405 549 418L448 494C432 506 413 512 393 512H24C11 512 0 501 0 488V488C0 475 11 464 24 464H393C402 464 412 461 419 455L520 380C530 372 531 357 521 349C513 342 501 343 493 349L431 395C424 401 414 404 404 404H270C262 404 256 398 256 390V390C256 382 262 376 270 376H330C360 376 359 336 331 336H187C169 336 151 342 137 353L96 384H24C11 384 0 373 0 360V360C0 347 11 336 24 336H80L108 314C130 297 158 288 187 288H331C369 288 400 318 400 356H403L464 310C483 296 521 286 552 312C568 326 577 345 576 366Z"]
  };
  var faHandHoldingBox = {
    prefix: 'far',
    iconName: 'hand-holding-box',
    icon: [576, 512, [], "f47b", "M552 312C521 286 483 296 464 310L403 356H400C400 318 369 288 331 288H187C158 288 130 297 108 314L80 336H24C11 336 0 347 0 360C0 373 11 384 24 384H96L137 353C151 342 169 336 187 336H331C359 336 360 376 330 376H270C262 376 256 382 256 390V390C256 398 262 404 270 404H404C414 404 424 401 431 395L493 349C501 343 513 342 521 349C531 357 530 372 520 380L419 455C412 461 402 464 393 464H24C11 464 0 475 0 488C0 501 11 512 24 512H393C413 512 432 506 448 494L549 418C565 405 575 386 576 366C577 345 568 326 552 312ZM160 256H416C442 256 464 234 464 208V48C464 22 442 0 416 0H160C134 0 112 22 112 48V208C112 234 134 256 160 256ZM160 48H224V128L288 96L352 128V48H416V208H160V48Z"]
  };
  var faHandHoldingDollar = {
    prefix: 'far',
    iconName: 'hand-holding-dollar',
    icon: [576, 512, [], "f4c0", "M552 312C521 286 483 296 464 310L403 356H400C400 318 369 288 331 288H187C158 288 130 297 108 314L80 336H24C11 336 0 347 0 360C0 373 11 384 24 384H96L137 353C151 342 169 336 187 336H331C359 336 360 376 330 376H270C262 376 256 382 256 390V390C256 398 262 404 270 404H404C414 404 424 401 431 395L493 349C501 343 513 342 521 349C531 357 530 372 520 380L419 455C412 461 402 464 393 464H24C11 464 0 475 0 488C0 501 11 512 24 512H393C413 512 432 506 448 494L549 418C565 405 575 386 576 366C577 345 568 326 552 312ZM279 175C272 174 262 170 253 167L248 165C236 161 222 167 217 180C213 192 220 206 232 211L237 212C245 215 254 218 264 221V232C264 245 275 256 288 256C301 256 312 245 312 232V222C337 216 355 200 359 176C368 126 320 112 295 105L288 103C263 96 264 92 264 88C265 82 280 78 296 81C301 82 308 83 316 86C329 91 342 84 347 71C351 59 344 45 332 41C324 38 318 37 312 35V24C312 11 301 0 288 0C275 0 264 11 264 24V35C239 40 221 56 217 80C208 130 257 144 275 149L281 151C313 160 313 163 312 168C311 174 296 178 279 175Z"]
  };
  var faHandHoldingDroplet = {
    prefix: 'far',
    iconName: 'hand-holding-droplet',
    icon: [576, 512, [], "f4c1", "M552 312C521 286 483 296 464 310L403 356H400C400 318 369 288 331 288H187C158 288 130 297 108 314L80 336H24C11 336 0 347 0 360C0 373 11 384 24 384H96L137 353C151 342 169 336 187 336H331C359 336 360 376 330 376H270C262 376 256 382 256 390V390C256 398 262 404 270 404H404C414 404 424 401 431 395L493 349C501 343 513 342 521 349C531 357 530 372 520 380L419 455C412 461 402 464 393 464H24C11 464 0 475 0 488C0 501 11 512 24 512H393C413 512 432 506 448 494L549 418C565 405 575 386 576 366C577 345 568 326 552 312ZM288 256C341 256 384 214 384 162C384 122 327 41 301 6C298 2 293 0 288 0S278 2 275 6C249 41 192 122 192 162C192 214 235 256 288 256ZM288 71C322 121 335 152 336 162C336 187 314 208 288 208S240 187 240 162C241 152 254 121 288 71Z"]
  };
  var faHandHoldingHeart = {
    prefix: 'far',
    iconName: 'hand-holding-heart',
    icon: [576, 512, [], "f4be", "M552 312C521 286 483 296 464 310L403 356H400C400 318 369 288 331 288H187C158 288 130 297 108 314L80 336H24C11 336 0 347 0 360C0 373 11 384 24 384H96L137 353C151 342 169 336 187 336H331C359 336 360 376 330 376H270C262 376 256 382 256 390V390C256 398 262 404 270 404H404C414 404 424 401 431 395L493 349C501 343 513 342 521 349C531 357 530 372 520 380L419 455C412 461 402 464 393 464H24C11 464 0 475 0 488C0 501 11 512 24 512H393C413 512 432 506 448 494L549 418C565 405 575 386 576 366C577 345 568 326 552 312ZM275 251C282 258 294 258 301 251L410 136C441 103 439 48 404 18C373 -9 327 -4 299 25L288 37L277 25C249 -4 203 -9 172 18C137 48 135 103 166 136L275 251Z"]
  };
  var faHandHoldingMagic = {
    prefix: 'far',
    iconName: 'hand-holding-magic',
    icon: [576, 512, [], "f6e5", "M552 312C521 286 483 296 464 310L403 356H400C400 318 369 288 331 288H187C158 288 130 297 108 314L80 336H24C11 336 0 347 0 360C0 373 11 384 24 384H96L137 353C151 342 169 336 187 336H331C359 336 360 376 330 376H270C262 376 256 382 256 390V390C256 398 262 404 270 404H404C414 404 424 401 431 395L493 349C501 343 513 342 521 349C531 357 530 372 520 380L419 455C412 461 402 464 393 464H24C11 464 0 475 0 488C0 501 11 512 24 512H393C413 512 432 506 448 494L549 418C565 405 575 386 576 366C577 345 568 326 552 312ZM224 208C277 208 320 165 320 112C320 112 288 144 224 144C206 144 192 126 192 112V96C192 78 206 64 224 64H352C370 64 384 78 384 96V112C384 146 366 178 342 203L288 256L306 255C383 251 447 190 448 114V96C448 43 405 0 352 0H224C171 0 128 43 128 96V112C128 163 173 208 224 208Z"]
  };
  var faHandHoldingMedical = {
    prefix: 'far',
    iconName: 'hand-holding-medical',
    icon: [576, 512, [], "e05c", "M552 312C521 286 483 296 464 310L403 356H400C400 318 369 288 331 288H187C158 288 130 297 108 314L80 336H24C11 336 0 347 0 360C0 373 11 384 24 384H96L137 353C151 342 169 336 187 336H331C359 336 360 376 330 376H270C262 376 256 382 256 390V390C256 398 262 404 270 404H404C414 404 424 401 431 395L493 349C501 343 513 342 521 349C531 357 530 372 520 380L419 455C412 461 402 464 393 464H24C11 464 0 475 0 488C0 501 11 512 24 512H393C413 512 432 506 448 494L549 418C565 405 575 386 576 366C577 345 568 326 552 312ZM160 176H224V240C224 249 231 256 240 256H304C313 256 320 249 320 240V176H384C393 176 400 169 400 160V96C400 87 393 80 384 80H320V16C320 7 313 0 304 0H240C231 0 224 7 224 16V80H160C151 80 144 87 144 96V160C144 169 151 176 160 176Z"]
  };
  var faHandHoldingSeedling = {
    prefix: 'far',
    iconName: 'hand-holding-seedling',
    icon: [576, 512, [], "f4bf", "M251 192H264V232C264 245 275 256 288 256H288C301 256 312 245 312 232V192H325C411 192 480 117 480 24V24C480 11 469 0 456 0H419C364 0 315 32 288 79C261 32 213 0 157 0H120C107 0 96 11 96 24V24C96 117 165 192 251 192ZM419 48H430C420 103 377 144 325 144H314C324 89 367 48 419 48ZM157 48C209 48 252 89 262 144H251C199 144 156 103 146 48H157ZM552 312C521 286 483 296 464 310L403 356H400C400 318 369 288 331 288H187C158 288 130 297 108 314L80 336H24C11 336 0 347 0 360V360C0 373 11 384 24 384H96L137 353C151 342 169 336 187 336H331C359 336 360 376 330 376H270C262 376 256 382 256 390V390C256 398 262 404 270 404H404C414 404 424 401 431 395L493 349C501 343 513 342 521 349C531 357 530 372 520 380L419 455C412 461 402 464 393 464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H393C413 512 432 506 448 494L549 418C565 405 575 386 576 366C577 345 568 326 552 312Z"]
  };
  var faHandLizard = {
    prefix: 'far',
    iconName: 'hand-lizard',
    icon: [512, 512, [], "f258", "M512 332V424C512 437 501 448 488 448C475 448 464 437 464 424V332C464 322 461 312 455 304L337 133C327 120 312 112 296 112H53C51 112 48 114 48 116C48 126 51 135 58 141C64 148 73 152 83 152H245C262 152 278 160 288 174C298 188 301 206 295 222L285 252C278 273 258 288 235 288H139C129 288 120 292 114 299C107 305 104 314 104 324C104 326 107 328 109 328H266C271 328 276 330 280 333L358 391C364 396 368 403 368 411V424C368 437 357 448 344 448S320 437 320 424V423L258 376H109C81 376 57 353 56 325C55 303 64 281 79 265C95 249 116 240 139 240H235C237 240 239 239 240 236L250 207C250 205 250 203 249 202C248 201 247 200 245 200H83C60 200 39 191 23 175C8 159 -1 137 0 115C1 87 25 64 53 64H296C328 64 358 80 376 106L495 276C506 293 512 312 512 332Z"]
  };
  var faHandMiddleFinger = {
    prefix: 'far',
    iconName: 'hand-middle-finger',
    icon: [512, 512, [], "f806", "M480 313C480 281 461 252 432 240C429 212 408 188 380 182L363 179C349 177 346 176 339 176C338 176 337 176 336 176V80C336 36 300 0 256 0C253 0 251 0 249 0C207 4 176 39 176 81V176C175 176 174 176 173 176C166 176 161 177 153 179L139 181C105 188 80 219 80 254V258L75 261L60 268C33 282 16 309 16 340V387C16 408 24 428 39 443L66 470C93 497 129 512 168 512H336C415 512 480 447 480 368L480 313ZM336 464H168C142 464 118 454 100 436L73 409C67 403 64 395 64 387V340C64 328 71 317 82 311L96 304V336C96 345 103 352 112 352S128 345 128 336V254C128 241 137 231 149 229C168 225 170 224 173 224C183 224 192 232 192 243C192 250 198 256 205 256H211C218 256 224 250 224 243V81C224 65 236 50 253 48C254 48 255 48 256 48C274 48 288 62 288 80V243C288 250 294 256 301 256H307C314 256 320 250 320 243C320 232 329 224 339 224C342 224 342 224 371 230C378 231 384 238 384 245V272L408 282C422 285 432 298 432 313L432 368C432 421 389 464 336 464Z"]
  };
  var faHandPaper = {
    prefix: 'far',
    iconName: 'hand-paper',
    icon: [512, 512, [], "f256", "M248 47C250 47 251 47 253 48C264 50 272 60 272 72V255C272 264 279 271 288 271C297 271 304 264 304 255V103C304 90 315 79 328 79C330 79 331 79 333 80C344 82 352 92 352 104V255C352 264 359 271 368 271C377 271 384 264 384 255V152C384 140 392 130 403 128C405 127 406 127 408 127C421 127 432 138 432 151V330C432 404 373 464 300 464H228C186 464 146 443 121 408L52 310C45 299 47 284 58 276C62 273 67 272 72 272C80 272 87 276 92 282L116 318C120 322 125 324 129 324C138 324 146 318 145 308C144 277 142 247 139 216L128 114C127 100 136 89 150 87C150 87 151 87 152 87C164 87 175 96 176 109L186 227C187 236 188 246 189 255C189 264 197 271 206 271C216 271 224 263 224 253V71C224 58 235 47 248 47M248 -1L248 -1C229 -1 211 7 197 20C190 27 184 36 181 45C172 41 162 39 152 39C150 39 147 39 145 39C105 44 76 79 80 118L91 221C91 223 91 225 92 227C85 225 79 224 72 224C57 224 43 229 31 237C15 248 4 265 1 283C-2 302 2 322 13 337L82 435C115 483 170 512 228 512H300C399 512 480 430 480 330V151C480 111 448 79 408 79C404 79 400 79 396 80C388 56 368 37 342 32C337 32 333 31 328 31C322 31 315 32 309 34C299 17 282 4 262 0C257 0 253 -1 248 -1L248 -1Z"]
  };
  var faHandPeace = {
    prefix: 'far',
    iconName: 'hand-peace',
    icon: [448, 512, [], "f25b", "M346 196C332 179 311 168 289 168H281L287 79C290 39 260 3 220 0C218 0 217 0 215 0C177 0 145 30 142 69L142 79L141 77C134 58 121 43 103 35C93 30 83 28 73 28C64 28 55 30 47 33C10 47 -9 89 4 127L51 255L32 270C12 287 0 312 0 339V386C0 418 17 448 45 463L100 494C121 506 144 512 168 512H276C353 512 416 447 416 368V270C416 230 385 197 346 196ZM368 368C368 421 327 464 276 464H168C153 464 137 460 124 452L68 421C56 414 48 401 48 386V339C48 327 53 315 63 308L81 292L105 357C108 365 117 370 125 367C133 364 138 354 135 346L50 111C45 98 51 82 64 78C70 75 77 75 82 78C89 81 93 86 96 93L148 240C150 247 158 251 165 250C173 249 178 243 179 235L190 72C191 58 202 47 217 48C230 49 240 62 239 76L230 213C229 219 233 226 240 229C246 231 253 229 258 224C263 219 269 216 276 216H289C300 216 309 223 312 233C315 240 323 245 330 244H343C357 244 368 256 368 270V368Z"]
  };
  var faHandPointDown = {
    prefix: 'far',
    iconName: 'hand-point-down',
    icon: [448, 512, [], "f0a7", "M31 241L64 270V440C64 480 96 512 136 512S208 480 208 440V358H222C237 358 253 353 265 343C269 344 272 344 276 344H289C311 344 332 333 346 316C385 315 416 282 416 242V144C416 65 353 0 276 0H168C144 0 121 6 100 18L45 49C17 64 0 94 0 126V173C0 200 11 225 31 241ZM48 126C48 111 56 98 68 91L124 60C137 52 153 48 168 48H276C327 48 368 91 368 144V242C368 256 357 268 343 268L328 268C322 268 315 272 312 279C309 289 299 296 289 296H276C272 296 268 295 264 293C256 288 247 291 242 298C238 305 230 310 221 310H208C196 310 191 299 191 298C188 291 181 287 173 288C165 290 160 296 160 304V440C160 453 149 464 136 464S112 453 112 440V176C112 167 105 160 96 160S80 167 80 176V220L62 204C53 197 48 185 48 173V126Z"]
  };
  var faHandPointLeft = {
    prefix: 'far',
    iconName: 'hand-point-left',
    icon: [512, 512, [], "f0a5", "M271 95L242 128H72C32 128 0 160 0 200S32 272 72 272H154V286C154 301 159 317 169 329C168 333 168 336 168 340V353C168 375 179 396 196 410C197 449 230 480 270 480H368C447 480 512 417 512 340V232C512 208 506 185 494 164L463 109C448 81 418 64 386 64H339C312 64 287 75 271 95ZM386 112C401 112 414 120 421 132L452 188C460 201 464 217 464 232V340C464 391 421 432 368 432H270C256 432 244 421 244 407L244 392C244 386 240 379 233 376C223 373 216 363 216 353V340C216 336 217 332 219 328C224 320 221 311 214 306C206 302 202 294 202 286V272C202 260 213 255 214 255C221 252 225 245 224 237C222 229 216 224 208 224H72C59 224 48 213 48 200S59 176 72 176H336C345 176 352 169 352 160S345 144 336 144H292L308 126C315 117 327 112 339 112H386Z"]
  };
  var faHandPointRight = {
    prefix: 'far',
    iconName: 'hand-point-right',
    icon: [512, 512, [], "f0a4", "M173 64H126C94 64 64 81 49 109L18 164C6 185 0 208 0 232V340C0 417 65 480 144 480H242C282 480 315 449 316 410C333 396 344 375 344 353V340C344 336 344 333 343 329C353 317 358 301 358 286V272H440C480 272 512 240 512 200S480 128 440 128H270L241 95C225 75 200 64 173 64ZM173 112C185 112 197 117 204 126L220 144H176C167 144 160 151 160 160S167 176 176 176H440C453 176 464 187 464 200S453 224 440 224H304C296 224 290 229 288 237C287 245 291 252 298 255C299 255 310 260 310 272V286C310 294 306 302 298 306C291 311 288 320 293 328C295 332 296 336 296 340V353C296 364 289 373 279 376C272 379 268 386 268 392L268 407C268 421 256 432 242 432H144C91 432 48 391 48 340V232C48 217 52 201 60 188L91 132C98 120 111 112 126 112H173Z"]
  };
  var faHandPointUp = {
    prefix: 'far',
    iconName: 'hand-point-up',
    icon: [448, 512, [], "f0a6", "M0 339V386C0 418 17 448 45 463L100 494C121 506 144 512 168 512H276C353 512 416 447 416 368V270C416 230 385 197 346 196C332 179 311 168 289 168H276C272 168 269 168 265 169C253 159 237 154 222 154H208V72C208 32 176 0 136 0C96 0 64 32 64 72V242L31 271C11 287 0 312 0 339ZM48 339C48 327 53 315 62 308L80 292V336C80 345 87 352 96 352S112 345 112 336V72C112 59 123 48 136 48C149 48 160 59 160 72V208C160 216 165 222 173 224C181 225 188 221 191 214C191 213 196 202 208 202H222C230 202 238 206 242 214C247 221 256 224 264 219C268 217 272 216 276 216H289C300 216 309 223 312 233C315 240 322 244 328 244L343 244C357 244 368 256 368 270V368C368 421 327 464 276 464H168C153 464 137 460 124 452L68 421C56 414 48 401 48 386V339Z"]
  };
  var faHandPointer = {
    prefix: 'far',
    iconName: 'hand-pointer',
    icon: [448, 512, [], "f25a", "M208 288C199 288 192 295 192 304V400C192 409 199 416 208 416S224 409 224 400V304C224 295 217 288 208 288ZM272 288C263 288 256 295 256 304V400C256 409 263 416 272 416S288 409 288 400V304C288 295 281 288 272 288ZM377 201C363 184 342 174 320 174H306C303 174 299 174 295 175C283 165 267 160 251 160H240V72C240 32 208 0 168 0C128 0 96 32 96 72V241C91 238 85 237 80 236C76 236 73 235 70 235C55 235 40 240 28 249C13 261 3 277 1 295C-2 314 3 332 14 347L92 451C121 489 166 512 214 512H323C330 512 336 511 342 509C370 504 395 490 415 469C436 446 448 416 448 384V274C448 235 416 202 377 201ZM400 384C400 404 393 422 380 436C367 450 351 459 330 463C327 464 325 464 323 464H214C181 464 150 448 131 422L52 318C49 314 47 308 48 302C49 296 52 291 57 288C61 285 65 283 70 283C71 283 72 283 73 284C79 284 84 287 87 292L115 330C119 335 127 337 133 335C140 333 144 327 144 320V72C144 59 155 48 168 48C181 48 192 59 192 72V203C192 209 196 215 202 217C207 220 214 219 219 215C223 211 231 208 238 208H251C260 208 268 212 273 220C277 227 287 229 294 225C298 223 302 222 306 222H320C331 222 340 228 344 239C346 245 354 249 361 249H375C389 249 400 260 400 274V384ZM336 288C327 288 320 295 320 304V400C320 409 327 416 336 416S352 409 352 400V304C352 295 345 288 336 288Z"]
  };
  var faHandRock = {
    prefix: 'far',
    iconName: 'hand-rock',
    icon: [512, 512, [], "f255", "M455 113C438 96 415 87 392 87C390 87 388 87 386 87C372 70 351 59 328 59H307C293 42 272 32 249 32H222C199 32 178 43 164 60C163 59 161 59 160 59C112 59 73 98 73 146V170L59 180L33 201C12 217 0 242 0 269V356C0 388 18 417 46 432L103 463C124 474 147 480 171 480H336C383 480 425 452 443 408L467 347C475 327 480 306 480 284L480 174C480 151 471 129 455 113ZM432 284C432 300 429 315 423 329L398 390C388 416 363 432 336 432H171C155 432 140 428 126 421L69 390C56 383 48 370 48 356V269C48 257 53 246 63 238L89 218V272C89 281 96 288 105 288S121 281 121 272V146C121 125 138 107 160 107C165 107 167 108 174 111C176 112 178 113 181 113C183 113 186 112 188 111C192 109 195 105 196 100C199 88 209 80 222 80H249C260 80 270 87 274 98C276 105 282 109 289 109C290 109 292 109 293 109C296 108 298 107 300 107H328C340 107 351 116 353 128C354 132 357 137 361 139C364 140 366 140 369 140C371 140 373 140 375 139C381 136 387 135 392 135C414 135 432 152 432 174L432 284Z"]
  };
  var faHandScissors = {
    prefix: 'far',
    iconName: 'hand-scissors',
    icon: [512, 512, [], "f257", "M270 480H368C447 480 512 417 512 340V232C512 208 506 185 494 164L463 109C448 81 418 64 386 64H339C312 64 287 76 271 96L255 115L127 68C89 55 47 74 33 111C30 119 28 128 28 137C28 147 30 157 35 167C43 185 58 198 77 205L79 206L69 206C30 209 0 241 0 279C0 281 0 282 0 284C3 324 39 354 79 351L168 345V353C168 375 179 396 196 410C197 449 230 480 270 480ZM270 432C256 432 244 421 244 407V394C244 387 240 379 233 376C223 373 216 363 216 353V340C216 333 219 327 224 322C229 317 231 310 228 304C226 297 219 293 213 294L76 303C62 304 49 294 48 281C47 266 58 255 72 254L235 243C243 242 249 237 250 229C251 222 247 214 240 212L93 160C86 157 81 153 78 146C75 141 75 134 78 128C82 115 98 109 111 114L346 199C354 202 364 197 367 189C370 181 365 172 357 169L292 145L307 127C315 117 327 112 339 112H386C401 112 414 120 421 132L453 188C460 201 464 217 464 232V340C464 391 421 432 368 432H270Z"]
  };
  var faHandSparkles = {
    prefix: 'far',
    iconName: 'hand-sparkles',
    icon: [640, 512, [], "e05d", "M640 432C640 430 638 427 636 426L587 405L587 405L566 356C565 354 562 352 560 352C558 352 555 354 554 356L533 405L533 405L484 426C482 427 480 430 480 432L480 432L480 432C480 434 482 437 484 438L533 459L533 459L554 508C555 510 558 512 560 512C562 512 565 510 566 508L587 459L587 459L587 459L636 438C638 437 640 434 640 432L640 432L640 432ZM480 393L509 381L525 343C525 343 525 342 525 341C529 334 536 328 544 324V151C544 111 512 79 472 79C468 79 464 79 460 80C452 56 432 37 406 32C401 32 397 31 392 31C386 31 379 32 373 34C363 17 346 4 326 0C321 0 317 -1 312 -1H312C293 -1 275 7 261 20C254 27 248 36 245 45C236 41 226 39 216 39C214 39 211 39 209 39C169 44 140 79 144 118L155 221C155 223 155 225 156 227C149 225 143 224 136 224C121 224 107 229 95 237C79 248 68 265 65 283C62 302 66 322 77 337L146 435C179 483 234 512 292 512H365C408 512 448 496 479 470L471 467C471 467 470 467 469 467C457 460 448 447 448 433C425 452 396 464 365 464H292C250 464 210 443 185 408L116 310C109 299 111 284 122 276C126 273 131 272 136 272C144 272 151 276 156 282L180 318C184 322 189 324 193 324C202 324 210 318 210 308C208 277 206 247 203 216L192 114C191 100 200 89 214 87C214 87 215 87 216 87C228 87 239 96 240 109L250 227C251 236 252 246 253 255C253 264 261 271 270 271C280 271 288 263 288 253V71C288 58 299 47 312 47C314 47 315 47 317 48C328 50 336 60 336 72V255C336 264 343 271 352 271C361 271 368 264 368 255V103C368 90 379 79 392 79C394 79 395 79 397 80C408 82 416 92 416 104V255C416 264 423 271 432 271C441 271 448 264 448 255V152C448 140 456 130 467 128C469 127 470 127 472 127C485 127 496 138 496 151V330C496 353 490 374 480 393ZM80 192C82 192 85 190 86 188L107 139L107 139L107 139L114 136L113 122C111 111 113 99 115 89L107 85L107 85L86 36C85 34 82 32 80 32C78 32 75 34 74 36L53 85L53 85L4 106C2 107 0 110 0 112L0 112L0 112C0 114 2 117 4 118L53 139L53 139L74 188C75 190 78 192 80 192ZM308 322C307 321 305 320 304 320S301 321 300 322L288 352L258 364C257 365 256 367 256 368C256 369 257 371 258 372L288 384L300 414C301 415 303 416 304 416S307 415 308 414L320 384L350 372C351 371 352 369 352 368C352 367 351 365 350 364L320 352L308 322Z"]
  };
  var faHandSpock = {
    prefix: 'far',
    iconName: 'hand-spock',
    icon: [512, 512, [], "f259", "M501 116C482 85 450 81 435 81C421 30 373 27 364 27C329 27 299 52 292 86L287 109L273 56C264 20 227 -9 184 2C148 12 125 45 129 81C107 83 86 95 74 113C61 131 58 154 64 176L88 258C50 250 25 274 20 280C-8 310 -6 356 23 384L115 470C143 497 181 512 221 512H328C387 512 439 471 452 414L510 172C514 153 511 133 501 116ZM463 161L406 403C397 439 365 464 328 464H221C193 464 167 454 148 435L56 349C31 326 67 288 91 311L143 360C148 365 156 360 156 354C156 330 153 306 146 284L110 162C100 129 150 115 159 147L191 253C196 272 224 264 220 245L177 80C169 47 218 35 227 67L274 251C279 269 303 268 307 251L339 96C346 63 396 72 389 108L360 247C357 265 384 271 388 253L413 149C421 115 471 128 463 161Z"]
  };
  var faHands = {
    prefix: 'far',
    iconName: 'hands',
    icon: [512, 512, [], "f2a7", "M15 383C19 387 22 391 26 394C26 409 32 424 41 435C45 439 48 443 52 446C52 461 58 476 67 487C80 503 99 512 119 512H288C347 512 398 477 421 426L468 380C496 353 511 316 512 276L512 184C512 147 481 117 443 117C442 117 440 118 439 118L420 57C411 28 385 9 356 9C349 9 343 10 336 12C325 4 312 0 298 0C276 0 256 10 243 28C239 33 236 38 234 44C221 49 209 57 201 68C197 73 194 79 192 85C179 89 168 97 159 109C147 126 143 148 150 169L156 187L162 208C161 211 160 214 159 217C159 218 158 220 158 221H94C61 221 33 244 27 276C26 279 26 283 26 287C13 297 4 311 1 328C-3 348 3 368 15 383ZM242 172C236 170 230 169 224 169C216 169 208 170 201 173L196 154C191 139 203 129 215 129C222 129 230 133 233 143L242 172ZM275 103L302 189C302 190 302 190 303 190L257 176L237 114C233 99 245 88 256 88C264 88 272 93 275 103ZM331 199L311 193C314 191 315 188 314 185L279 73C274 58 286 48 298 48C306 48 313 52 317 62L355 186C356 188 359 190 362 190C362 190 363 190 364 190C367 189 369 185 368 182L337 82C332 67 344 57 356 57C363 57 371 61 374 71L423 226L424 185C424 174 433 166 444 165H444C455 165 464 174 464 185V276C464 304 452 328 434 346V340C434 276 393 220 331 199ZM48 337C50 327 59 321 68 321H198C201 321 204 318 204 314S201 308 197 308H93C81 308 72 297 74 285C76 275 85 269 94 269H256L218 255C207 252 202 241 205 231C207 222 215 217 224 217C225 217 227 217 229 218L317 245C358 259 386 297 386 340V366C386 420 342 464 288 464H119C107 464 98 453 100 441C102 431 111 425 120 425H197C201 425 204 422 204 418S201 412 197 412H93C81 412 72 401 74 389C76 379 85 373 94 373H197C201 373 204 370 204 366S201 360 197 360H67C55 360 46 349 48 337Z"]
  };
  var faHandsAslInterpreting = {
    prefix: 'far',
    iconName: 'hands-asl-interpreting',
    icon: [640, 512, [], "f2a3", "M514 112L514 112L425 112C400 114 377 124 358 139C357 135 357 131 356 127C351 112 341 99 327 92C322 89 316 87 310 85C320 65 317 39 302 21C291 9 277 1 261 0C259 0 257 0 256 0C242 0 228 5 217 14L197 32C191 20 181 11 169 6C161 2 153 0 144 0C121 0 99 14 89 35L16 200C5 223 0 248 0 274C0 343 57 400 126 400L215 400C240 398 263 388 282 373C283 377 283 381 284 385C289 400 299 413 313 420C318 423 324 426 330 427C320 447 323 473 338 491C349 503 363 511 379 512C381 512 382 512 384 512C398 512 412 507 423 498L443 480C449 492 459 501 471 506C479 510 487 512 496 512C519 512 541 498 551 477L624 312C635 289 640 264 640 238C640 169 583 112 514 112ZM315 154C313 158 309 162 304 163L209 190L233 198C258 207 277 225 285 249C287 254 287 260 284 265V265C282 269 278 273 273 275C263 278 251 273 248 263C241 246 225 234 207 234C183 234 164 253 164 277C164 301 183 320 207 320C221 320 235 313 243 301C249 292 261 289 270 295C275 298 278 303 279 308C280 313 279 319 276 323C262 344 238 358 214 360L126 360C79 360 40 321 40 274C40 254 44 234 52 216L126 52C130 42 143 37 152 42C157 44 161 48 163 53C165 58 164 64 162 68L127 144L243 45C247 41 252 40 257 40C263 40 268 43 271 47C275 51 276 56 276 62C276 67 273 72 269 75L171 160L293 125C298 123 303 124 308 126C312 129 316 133 317 139C319 144 318 149 315 154ZM588 296L514 460C512 465 508 469 503 471C501 472 498 472 496 472C493 472 490 471 488 470C483 468 479 464 477 459C475 454 476 448 478 444L513 368L397 467C393 471 388 472 383 472C377 472 372 469 369 465C365 461 364 456 364 450C364 445 367 440 371 437L470 352L348 387C342 389 337 388 332 386C328 383 324 379 323 374C321 368 322 363 325 358C327 354 331 350 337 349L431 322L407 314C382 305 363 287 355 263C353 258 353 252 356 247C358 243 362 239 367 237C378 234 389 239 392 249C398 266 415 278 433 278C457 278 476 259 476 235S457 192 433 192C419 192 405 199 397 211C391 220 379 223 369 217C365 214 362 209 361 204C360 199 361 193 364 189C378 168 402 154 426 152L514 152C561 152 600 191 600 238C600 258 596 278 588 296Z"]
  };
  var faHandsBubbles = {
    prefix: 'far',
    iconName: 'hands-bubbles',
    icon: [576, 512, [], "e05e", "M576 192C576 148 540 112 496 112C494 112 491 113 489 113C503 101 512 84 512 64C512 29 483 0 448 0S384 29 384 64S413 128 448 128C448 128 448 128 449 128C429 143 416 166 416 192C416 202 418 212 422 221H386C386 218 384 214 382 208L394 169C400 150 397 129 386 112C378 99 366 89 351 84C350 80 347 75 345 71C336 58 324 49 310 44C308 39 306 35 303 31C292 14 274 3 254 0C251 0 249 0 246 0C232 0 219 4 208 12C204 11 200 10 196 10C194 9 191 9 189 9C159 9 133 28 124 57L105 118C104 118 102 117 101 117C63 117 32 147 32 184L32 276C32 305 41 333 56 356C24 366 0 396 0 432C0 476 36 512 80 512C111 512 138 494 151 468C178 495 215 512 255 512H424C445 512 464 503 477 487C486 476 492 461 492 446C506 435 518 417 518 394C522 391 525 387 529 383C541 368 547 348 543 328C540 311 531 297 518 287C518 277 516 271 515 269C550 261 576 230 576 192ZM448 80C439 80 432 73 432 64S439 48 448 48C457 48 464 55 464 64S457 80 448 80ZM311 143C319 118 356 130 348 154L343 173C336 170 328 169 320 169C314 169 308 170 302 172L311 143ZM307 114L287 176L241 190C242 190 242 190 242 189L269 103C277 77 314 89 307 114ZM80 185C80 174 89 165 100 165H100C111 166 120 174 120 185L121 226L170 71C178 46 215 58 207 83L176 182C175 185 177 189 180 190C181 190 182 190 182 190C185 190 188 188 189 186L227 62C236 37 273 49 265 73L230 185C229 188 230 191 233 193L213 199C151 220 110 276 110 340V346C92 328 80 304 80 276V185ZM80 464C62 464 48 450 48 432C48 414 62 400 80 400C98 400 112 414 112 432C112 450 98 464 80 464ZM477 360H347C343 360 340 363 340 366S343 373 347 373H450C459 373 468 379 470 389C472 401 463 412 451 412H347C343 412 340 415 340 418S343 425 347 425H424C433 425 442 431 444 441C446 453 437 464 425 464H255C202 464 158 420 158 366V340C158 297 186 259 227 245L315 218C317 217 319 217 320 217C329 217 337 222 339 231C342 241 337 252 326 255L288 269H450C459 269 468 275 470 285C472 297 463 308 450 308H346C343 308 340 311 340 314S343 321 346 321H476C485 321 494 327 496 337C498 349 489 360 477 360ZM496 224C478 224 464 210 464 192S478 160 496 160C514 160 528 174 528 192S514 224 496 224Z"]
  };
  var faHandsHolding = {
    prefix: 'far',
    iconName: 'hands-holding',
    icon: [640, 512, [], "f4c2", "M640 173V362C640 387 631 412 615 432L561 503C553 513 538 515 528 507C517 499 515 483 524 473L578 402C587 391 592 377 592 362V169C592 157 584 147 573 144C558 141 544 153 544 168C544 168 544 269 544 301C544 308 541 315 536 321L459 414C455 419 449 422 442 422C437 422 431 419 426 415C419 407 419 394 426 386L475 319C483 308 481 293 471 285C466 281 461 280 456 280C449 280 442 283 437 289L365 383C357 394 352 407 352 421V480C352 497 338 512 320 512C302 512 288 497 288 480V421C288 407 284 394 275 383L203 289C198 283 191 280 184 280C179 280 174 281 169 285C159 293 157 308 165 319L214 386C221 394 221 407 214 415C209 419 203 422 198 422C191 422 185 419 181 414L104 321C99 315 96 308 96 301C96 269 96 168 96 168C96 153 82 141 67 144C56 147 48 157 48 169V362C48 377 53 391 62 402L116 473C125 483 123 499 112 507C102 515 87 513 79 503L25 432C9 412 0 387 0 362V173C0 135 27 100 65 96C108 92 144 126 144 168C144 168 144 207 144 244C156 236 170 232 184 232C206 232 227 242 241 260L313 353C315 357 318 361 320 364C322 361 325 357 327 353L399 260C413 242 434 232 456 232C470 232 484 236 496 244C496 207 496 168 496 168C496 126 532 92 575 96C613 100 640 135 640 173Z"]
  };
  var faHandsHoldingDiamond = {
    prefix: 'far',
    iconName: 'hands-holding-diamond',
    icon: [640, 512, [], "f47c", "M298 237C310 250 330 250 342 237L439 141C451 129 451 109 439 96L342 0C330 -12 310 -12 298 0L201 96C189 109 189 129 201 141L298 237ZM575 87C532 83 496 117 496 159C496 159 496 198 496 235C484 227 470 223 456 223C434 223 413 233 399 251L327 344C325 347 322 351 320 355C318 351 315 347 313 344L241 251C227 233 206 223 184 223C170 223 156 227 144 235C144 197 144 159 144 159C144 117 108 83 65 87C27 91 0 126 0 163V352C0 378 9 403 25 423L79 494C87 504 102 506 112 498C123 490 125 474 116 464L62 393C53 381 48 367 48 353V160C48 148 56 137 67 135C82 132 96 144 96 159C96 159 96 260 96 291C96 299 99 306 104 312L181 404C185 410 191 412 198 412C203 412 209 410 214 405C221 398 221 385 214 376L165 309C157 299 159 284 169 276C174 272 179 271 184 271C191 271 198 274 203 280L275 373C283 385 288 398 288 412V471C288 488 302 503 320 503C338 503 352 488 352 471V412C352 398 356 385 365 373L437 280C442 274 449 271 456 271C461 271 466 272 471 276C481 284 483 299 475 309L426 376C419 385 419 398 426 405C431 410 437 412 442 412C449 412 455 410 459 404L536 312C541 306 544 299 544 291C544 260 544 159 544 159C544 144 558 132 573 135C584 137 592 148 592 160V353C592 367 587 381 578 393L524 464C515 474 517 490 528 498C538 506 553 504 561 494L615 423C631 403 640 378 640 352V163C640 126 613 91 575 87Z"]
  };
  var faHandsHoldingDollar = {
    prefix: 'far',
    iconName: 'hands-holding-dollar',
    icon: [640, 512, [], "f4c5", "M575 96C532 92 496 126 496 168C496 168 496 207 496 244C484 236 470 232 456 232C434 232 413 242 399 260L327 353C325 357 322 361 320 364C318 361 315 357 313 353L241 260C227 242 206 232 184 232C170 232 156 236 144 244C144 207 144 168 144 168C144 126 108 92 65 96C27 100 0 135 0 173V362C0 387 9 412 25 432L79 503C87 513 102 515 112 507C123 499 125 483 116 473L62 402C53 391 48 377 48 362V169C48 157 56 147 67 144C82 141 96 153 96 168C96 168 96 269 96 301C96 308 99 315 104 321L181 414C185 419 191 422 198 422C203 422 209 419 214 415C221 407 221 394 214 386L165 319C157 308 159 293 169 285C174 281 179 280 184 280C191 280 198 283 203 289L275 383C283 394 288 407 288 421V480C288 497 302 512 320 512C338 512 352 497 352 480V421C352 407 356 394 365 383L437 289C442 283 449 280 456 280C461 280 466 281 471 285C481 293 483 308 475 319L426 386C419 394 419 407 426 415C431 419 437 422 442 422C449 422 455 419 459 414L536 321C541 315 544 308 544 301C544 269 544 168 544 168C544 153 558 141 573 144C584 147 592 157 592 169V362C592 377 587 391 578 402L524 473C515 483 517 499 528 507C538 515 553 513 561 503L615 432C631 412 640 387 640 362V173C640 135 613 100 575 96ZM311 175C304 174 294 170 285 167L280 165C268 161 254 167 249 180C245 192 252 206 264 211L269 212C277 215 286 218 296 221V232C296 245 307 256 320 256C333 256 344 245 344 232V222C369 216 387 200 391 176C400 126 352 112 327 105L320 103C295 96 296 92 296 88C297 82 312 78 328 81C333 82 340 83 348 86C361 91 374 84 379 71C383 59 376 45 364 41C356 38 350 37 344 35V24C344 11 333 0 320 0C307 0 296 11 296 24V35C271 40 253 56 249 80C240 130 289 144 307 149L313 151C345 160 345 163 344 168C343 174 328 178 311 175Z"]
  };
  var faHandsHoldingHeart = {
    prefix: 'far',
    iconName: 'hands-holding-heart',
    icon: [640, 512, [], "f4c3", "M575 96C532 92 496 126 496 168C496 168 496 207 496 244C484 236 470 232 456 232C434 232 413 242 399 260L327 353C325 357 322 361 320 364C318 361 315 357 313 353L241 260C227 242 206 232 184 232C170 232 156 236 144 244C144 207 144 168 144 168C144 126 108 92 65 96C27 100 0 135 0 173V362C0 387 9 412 25 432L79 503C87 513 102 515 112 507C123 499 125 483 116 473L62 402C53 391 48 377 48 362V169C48 157 56 147 67 144C82 141 96 153 96 168C96 168 96 269 96 301C96 308 99 315 104 321L181 414C185 419 191 422 198 422C203 422 209 419 214 415C221 407 221 394 214 386L165 319C157 308 159 293 169 285C174 281 179 280 184 280C191 280 198 283 203 289L275 383C283 394 288 407 288 421V480C288 497 302 512 320 512C338 512 352 497 352 480V421C352 407 356 394 365 383L437 289C442 283 449 280 456 280C461 280 466 281 471 285C481 293 483 308 475 319L426 386C419 394 419 407 426 415C431 419 437 422 442 422C449 422 455 419 459 414L536 321C541 315 544 308 544 301C544 269 544 168 544 168C544 153 558 141 573 144C584 147 592 157 592 169V362C592 377 587 391 578 402L524 473C515 483 517 499 528 507C538 515 553 513 561 503L615 432C631 412 640 387 640 362V173C640 135 613 100 575 96ZM307 251C314 258 326 258 333 251L442 136C473 103 471 48 436 18C405 -9 359 -4 331 25L320 37L309 25C281 -4 235 -9 204 18C169 48 167 103 198 136L307 251Z"]
  };
  var faHandsPraying = {
    prefix: 'far',
    iconName: 'hands-praying',
    icon: [640, 512, [], "f684", "M640 488C640 477 633 468 622 465L435 413C382 400 344 352 344 297V228C344 215 355 205 368 205C381 205 392 215 392 228V284C392 293 399 300 408 300H424C433 300 440 293 440 284V208C440 196 437 184 430 174L372 86C366 75 367 61 377 53C388 44 404 47 412 59L502 198C508 208 512 220 512 232V335L610 367C625 371 640 360 640 344V344C640 334 633 324 622 321L560 298V232C560 211 554 190 542 173L453 33C439 13 417 0 392 0C378 0 365 4 353 11C334 23 322 42 320 65C320 67 320 68 320 70C320 68 320 67 319 65C317 42 305 23 286 11C275 4 261 0 248 0C223 0 200 13 187 33L97 173C86 190 80 211 80 232V298L18 321C7 324 0 333 0 344V344C0 360 15 371 30 367L128 335V232C128 220 131 208 138 198L228 59C235 47 252 44 263 53C273 61 274 75 267 86L210 174C203 184 200 196 200 208V284C200 293 207 300 216 300H232C240 300 248 293 248 284V229C248 215 258 205 272 205C285 205 296 215 296 229V297C296 352 258 400 205 413L18 465C7 468 0 477 0 488V488C0 504 15 515 30 511L217 459C261 448 298 420 320 382C342 420 378 448 423 459L610 511C625 515 640 504 640 488V488ZM320 176C308 165 294 158 277 157L307 110C315 98 320 86 320 72C320 86 325 98 332 110L362 157C346 158 331 165 320 176Z"]
  };
  var faHandshake = {
    prefix: 'far',
    iconName: 'handshake',
    icon: [640, 512, [], "f2b5", "M506 128C488 108 445 66 383 57C361 54 338 60 320 75C302 60 279 53 257 57C177 69 127 136 125 139C117 150 119 165 130 173C134 176 139 177 144 177C151 177 159 174 163 168C164 167 203 114 264 104C271 103 279 105 285 109L227 168C215 181 208 197 208 214C208 232 215 248 227 261C240 273 256 280 273 280S307 273 320 261L331 249L455 350C458 352 458 356 456 358L428 394C426 396 423 397 421 395L399 376L373 404C370 407 367 408 366 408C364 408 361 408 359 406L326 379L311 392L308 395C302 402 294 407 285 408C275 409 266 406 260 401L170 320H96V128H0V384H64C76 384 86 377 91 368H152L229 437C244 450 262 456 281 456C284 456 287 456 290 456C303 454 316 450 327 442L328 443C340 453 355 457 371 456C384 454 396 449 404 440C426 448 451 443 466 424L493 388C512 365 508 332 486 313L365 215L374 207C383 198 383 182 374 173C364 164 349 164 340 173L286 227C279 233 268 234 261 227C258 224 256 219 256 214C256 210 258 205 261 202L347 114C355 106 366 103 376 104C436 113 476 167 477 168C480 172 484 174 489 176H544V352C544 370 558 384 576 384H640V128H506ZM48 352C39 352 32 345 32 336C32 327 39 320 48 320S64 327 64 336C64 345 57 352 48 352ZM592 352C583 352 576 345 576 336C576 327 583 320 592 320S608 327 608 336C608 345 601 352 592 352Z"]
  };
  var faHandshakeAngle = {
    prefix: 'far',
    iconName: 'handshake-angle',
    icon: [640, 512, [], "f4c4", "M632 226L509 297C504 315 490 328 472 334V348C472 382 449 412 417 421C408 455 377 480 340 480H224L173 510C165 514 155 512 151 504L143 490C138 482 141 473 149 468L211 432H340C358 432 372 418 372 400V376H396C412 376 424 363 424 348V288H456C460 288 464 284 464 280V248C464 244 460 240 456 240H352V256C352 303 312 340 264 336C222 331 192 293 192 251V209L160 229C150 234 144 245 144 256V318L32 383C24 387 15 385 10 377L2 363C-2 355 0 345 8 341L96 290V256C96 228 111 202 135 187L194 152C199 131 211 113 230 102L263 81C281 70 301 64 322 64H415L524 2C531 -2 541 0 545 8L553 22C558 30 555 39 547 44L428 112H322C310 112 299 115 288 122L255 143C246 148 240 159 240 170V256C240 274 254 288 272 288C290 288 304 274 304 256V192H456C484 192 508 213 511 241L608 184C616 180 626 182 630 190L638 204C642 212 640 221 632 226Z"]
  };
  var faHandshakeSimple = {
    prefix: 'far',
    iconName: 'handshake-simple',
    icon: [640, 512, [], "f4c6", "M640 328C640 341 629 352 616 352L486 352C484 360 481 368 475 375L449 407C433 427 407 433 385 424C372 441 354 448 336 448C321 448 308 443 295 432C263 454 221 453 190 428L105 352L24 352C11 352 0 341 0 328C0 315 11 304 24 304L124 304L221 392C237 405 262 402 276 385L292 366L329 398C331 399 334 400 338 400S344 398 347 395L377 359L401 378C404 381 409 380 412 377L438 345C441 341 440 336 437 333L329 246L320 253C280 290 234 265 219 249C192 220 194 174 223 147L262 112L227 112C210 112 193 119 181 131L138 176L24 176C11 176 0 165 0 152C0 139 11 128 24 128L118 128L144 101C168 77 201 64 235 64H402C436 64 469 77 493 101L519 128L616 128C629 128 640 139 640 152C640 165 629 176 616 176L499 176L451 129C439 118 423 112 406 112L348 112C338 112 329 116 321 123L256 183C246 191 245 207 255 217C263 226 280 225 289 217L344 166C351 160 361 161 367 167L378 179C384 185 383 195 377 201L364 213L467 296C470 298 473 301 475 304L616 304C629 304 640 315 640 328Z"]
  };
  var faHandshakeSimpleSlash = {
    prefix: 'far',
    iconName: 'handshake-simple-slash',
    icon: [640, 512, [], "e05f", "M347 395C345 398 341 400 338 400S331 399 329 398L292 366L276 385C262 402 237 405 221 392L124 304L24 304C11 304 0 315 0 328C0 341 11 352 24 352L105 352L190 428C221 453 263 454 295 432C308 443 321 448 336 448C355 448 372 441 385 424C396 428 409 429 420 426L360 379L347 395ZM616 352C629 352 640 341 640 328C640 315 629 304 616 304H420L336 238L377 201C383 195 384 185 378 179L367 167C361 161 351 160 344 166L298 208L260 179L321 123C329 116 338 112 348 112L406 112C423 112 439 118 451 130L499 176L616 176C629 176 640 165 640 152C640 139 629 128 616 128L519 128L493 101C469 77 436 64 402 64H235C205 64 176 75 153 94L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L118 128L601 507C612 515 627 513 635 503C643 492 641 477 631 469L485 355C485 354 486 353 486 352L616 352ZM222 149L190 124C201 116 214 112 227 112L262 112L223 147C223 148 223 148 222 149ZM24 176L101 176L40 128L24 128C11 128 0 139 0 152C0 165 11 176 24 176Z"]
  };
  var faHandshakeSlash = {
    prefix: 'far',
    iconName: 'handshake-slash',
    icon: [640, 512, [], "e060", "M576 384H640V128H506C488 108 445 66 383 57C361 54 338 60 320 75C302 60 279 53 257 57C217 63 184 83 162 101L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469L340 241L374 207C383 198 383 182 374 173C364 164 349 164 340 173L302 211L274 189L347 114C355 106 366 103 376 104C436 114 476 167 477 168C480 172 484 175 488 176H544V352C544 370 558 384 576 384ZM592 320C601 320 608 327 608 336C608 345 601 352 592 352S576 345 576 336C576 327 583 320 592 320ZM236 159L201 132C217 120 239 108 264 104C271 103 279 105 285 109L236 159ZM373 404C370 407 367 408 366 408C364 408 361 408 359 406L326 379L311 392L308 395C302 402 294 407 285 408C275 409 266 406 260 401L170 320H96V172L40 128H0V384H64C76 384 86 377 91 368H152L229 437C244 450 262 456 281 456C284 456 287 456 290 456C303 454 316 449 327 442L328 443C340 453 355 457 371 456C384 454 396 449 404 440C416 445 428 445 440 441L381 395L373 404ZM48 352C39 352 32 345 32 336C32 327 39 320 48 320S64 327 64 336C64 345 57 352 48 352Z"]
  };
  var faHanukiah = {
    prefix: 'far',
    iconName: 'hanukiah',
    icon: [640, 512, [], "f6e6", "M448 176V296H480V176C480 167 473 160 464 160S448 167 448 176ZM464 128C477 128 488 116 488 101C488 87 464 48 464 48S440 87 440 101C440 116 451 128 464 128ZM320 80C333 80 344 68 344 53C344 39 320 0 320 0S296 39 296 53C296 68 307 80 320 80ZM400 128C413 128 424 116 424 101C424 87 400 48 400 48S376 87 376 101C376 116 387 128 400 128ZM512 176V296H544V176C544 167 537 160 528 160S512 167 512 176ZM616 128C629 128 640 116 640 101C640 87 616 48 616 48S592 87 592 101C592 116 603 128 616 128ZM528 128C541 128 552 116 552 101C552 87 528 48 528 48S504 87 504 101C504 116 515 128 528 128ZM384 176V296H416V176C416 167 409 160 400 160S384 167 384 176ZM24 128C37 128 48 116 48 101C48 87 24 48 24 48S0 87 0 101C0 116 11 128 24 128ZM240 128C253 128 264 116 264 101C264 87 240 48 240 48S216 87 216 101C216 116 227 128 240 128ZM96 176V296H128V176C128 167 121 160 112 160S96 167 96 176ZM616 160C603 160 592 171 592 184V294C592 317 573 336 550 336H344V136C344 123 333 112 320 112S296 123 296 136V336H90C67 336 48 317 48 294V184C48 171 37 160 24 160S0 171 0 184V294C0 344 40 384 90 384H296V464H144C131 464 120 475 120 488C120 501 131 512 144 512H496C509 512 520 501 520 488C520 475 509 464 496 464H344V384H550C600 384 640 344 640 294V184C640 171 629 160 616 160ZM112 128C125 128 136 116 136 101C136 87 112 48 112 48S88 87 88 101C88 116 99 128 112 128ZM224 176V296H256V176C256 167 249 160 240 160S224 167 224 176ZM176 128C189 128 200 116 200 101C200 87 176 48 176 48S152 87 152 101C152 116 163 128 176 128ZM160 176V296H192V176C192 167 185 160 176 160S160 167 160 176Z"]
  };
  var faHardDrive = {
    prefix: 'far',
    iconName: 'hard-drive',
    icon: [512, 512, [], "f0a0", "M304 344C291 344 280 355 280 368C280 381 291 392 304 392C317 392 328 381 328 368C328 355 317 344 304 344ZM448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V320C48 311 55 304 64 304H448C457 304 464 311 464 320V416ZM464 258C459 257 454 256 448 256H64C58 256 53 257 48 258V96C48 87 55 80 64 80H448C457 80 464 87 464 96V258ZM400 344C387 344 376 355 376 368C376 381 387 392 400 392C413 392 424 381 424 368C424 355 413 344 400 344Z"]
  };
  var faHashtag = {
    prefix: 'far',
    iconName: 'hashtag',
    icon: [448, 512, [], "f292", "M424 136H350L364 60C366 47 357 35 344 32C331 30 319 39 316 52L301 136H190L204 60C206 47 197 35 184 32C171 30 159 39 156 52L141 136H56C43 136 32 147 32 160C32 173 43 184 56 184H133L107 328H24C11 328 0 339 0 352C0 365 11 376 24 376H98L84 452C82 465 91 477 104 480C105 480 107 480 108 480C119 480 130 472 132 460L147 376H258L244 452C242 465 251 477 264 480C265 480 267 480 268 480C279 480 290 472 292 460L307 376H392C405 376 416 365 416 352C416 339 405 328 392 328H315L341 184H424C437 184 448 173 448 160C448 147 437 136 424 136ZM267 328H155L181 184H293L267 328Z"]
  };
  var faHatChef = {
    prefix: 'far',
    iconName: 'hat-chef',
    icon: [512, 512, [], "f86b", "M400 448C400 457 393 464 384 464H128C119 464 112 457 112 448V384H64V448C64 483 93 512 128 512H384C419 512 448 483 448 448V384H400V448ZM416 32C395 32 375 39 358 52C335 21 298 0 256 0C214 0 177 21 154 52C137 39 116 32 96 32C81 32 67 35 53 42C20 58 0 91 0 128C0 170 64 352 64 352H448C448 352 512 170 512 128C512 75 469 32 416 32ZM416 304H374L400 163C401 154 396 146 387 144C378 143 370 148 368 157L342 304H272V160C272 151 265 144 256 144S240 151 240 160V304H170L144 157C142 148 134 143 125 144C116 146 111 154 112 163L138 304H96C71 243 48 145 48 128C48 109 58 93 75 85C81 82 88 80 96 80C106 80 116 83 125 90L163 119L192 80C208 60 231 48 256 48C281 48 304 60 320 81L349 119L387 90C396 83 406 80 416 80C442 80 464 102 464 128C464 145 441 243 416 304Z"]
  };
  var faHatCowboy = {
    prefix: 'far',
    iconName: 'hat-cowboy',
    icon: [640, 512, [], "f8c0", "M618 207C594 196 575 211 569 219C567 221 551 245 512 267C496 166 462 32 392 32C374 32 356 39 340 54C328 64 312 64 300 54C284 39 266 32 248 32C178 32 144 166 129 267C92 246 75 224 72 220C61 204 40 199 23 207C4 215 -4 235 2 253C5 261 79 448 320 448S635 261 638 253C644 235 636 215 618 207ZM248 80C254 80 262 83 269 90C299 116 341 116 371 90C379 83 386 80 392 80C410 80 437 137 456 229C378 264 269 268 184 229C203 137 230 80 248 80ZM320 400C184 400 110 333 75 284C116 311 192 342 320 342S524 311 565 284C530 332 456 400 320 400Z"]
  };
  var faHatCowboySide = {
    prefix: 'far',
    iconName: 'hat-cowboy-side',
    icon: [640, 512, [], "f8c1", "M484 198L465 97C462 76 450 57 432 45C415 34 393 29 372 34L210 68C177 75 152 102 149 136L142 196C74 212 20 272 2 356C-3 378 1 400 13 418C26 437 45 448 67 448H559C604 448 640 412 640 367C640 326 602 224 484 198ZM67 400C56 400 45 384 49 366C65 291 116 240 177 240C203 240 229 249 250 267L341 345C366 366 388 385 411 400H67ZM312 256L281 230C255 209 224 196 191 193L197 141C198 128 208 118 220 115L382 81C390 79 399 81 405 85C412 90 417 97 418 105L446 256H312ZM562 399C548 399 534 398 520 395L494 251C573 278 592 350 592 367C592 384 579 398 562 399Z"]
  };
  var faHatSanta = {
    prefix: 'far',
    iconName: 'hat-santa',
    icon: [640, 512, [], "f7a7", "M612 218C614 209 612 200 605 194C599 188 590 185 582 187C572 172 548 172 538 187C530 185 521 188 515 194C508 200 506 209 508 218C501 222 496 231 496 239C496 248 501 257 508 261C506 270 508 279 515 285C522 292 530 294 539 292C543 299 551 304 560 304C569 304 577 299 581 292C588 294 597 293 605 285C612 279 614 270 612 261C619 257 624 249 624 240C624 231 619 222 612 218ZM464 368H471L466 357L390 159C387 150 378 144 368 144C365 144 362 145 359 146C347 150 341 164 346 177L417 363L419 368H93L95 363L170 175C193 117 248 80 310 80C359 80 404 104 433 143L460 182C465 188 472 192 480 192C485 192 490 190 494 188C505 180 507 165 500 154L472 115C435 63 374 32 310 32C229 32 156 81 126 157L46 357L41 368H48C22 368 0 390 0 416V432C0 458 22 480 48 480H464C490 480 512 458 512 432V416C512 390 490 368 464 368ZM481 184C481 184 480 184 480 184C480 184 479 184 479 184C480 184 480 184 481 184Z"]
  };
  var faHatWinter = {
    prefix: 'far',
    iconName: 'hat-winter',
    icon: [512, 512, [], "f7a8", "M195 105C190 115 191 128 199 137C205 142 211 144 218 144C223 144 227 143 231 141C234 152 244 160 256 160S278 152 281 141C285 143 289 144 294 144C301 144 307 142 313 137C321 128 322 115 317 105C328 102 336 92 336 80S328 58 317 55C322 45 321 32 313 23S291 14 281 19C278 8 268 0 256 0S234 8 231 19C221 14 208 15 199 23S190 45 195 55C184 58 176 68 176 80S184 102 195 105ZM480 416H32C14 416 0 430 0 448V480C0 498 14 512 32 512H480C498 512 512 498 512 480V448C512 430 498 416 480 416ZM86 336L128 315L192 347L256 315L320 347L384 315L426 336C432 362 432 382 432 384H480C480 382 478 218 348 139C345 146 341 153 335 159C329 166 321 170 312 173C359 198 387 235 405 271L384 261L320 293L256 261L192 293L128 261L107 271C125 235 153 198 200 173C191 170 183 166 177 159C171 153 167 147 164 139C34 218 32 382 32 384H80C80 382 80 362 86 336Z"]
  };
  var faHatWitch = {
    prefix: 'far',
    iconName: 'hat-witch',
    icon: [576, 512, [], "f6e7", "M256 304C247 304 240 311 240 320V384H336V320C336 311 329 304 320 304H256ZM553 416H23C10 416 0 426 0 439V439C0 445 3 451 8 456C30 476 89 512 166 512H410C486 512 546 476 568 456C573 451 576 445 576 439V439C576 426 566 416 553 416ZM231 200C240 180 256 163 276 152L445 49C448 47 452 48 454 50L525 123C527 125 528 128 527 130L519 150C509 136 492 128 474 128H434C409 128 388 143 380 166L374 185C367 206 368 228 376 248L435 384H489L421 229C417 220 417 210 420 200L426 181C427 178 430 176 434 176L474 176C477 176 481 178 482 181L496 224C499 233 508 240 518 240H519C529 240 538 234 542 225L573 146C580 126 575 104 560 89L489 16C471 -2 442 -5 419 8L251 110C222 127 200 151 187 181L95 384H148L231 200Z"]
  };
  var faHatWizard = {
    prefix: 'far',
    iconName: 'hat-wizard',
    icon: [512, 512, [], "f6e8", "M308 199L283 187L271 162C269 159 265 159 263 162L251 187L226 199C223 201 223 205 226 207L251 219L263 244C265 247 269 247 271 244L283 219L308 207C311 205 311 201 308 199ZM496 448H16C7 448 0 455 0 464C0 490 22 512 48 512H464C490 512 512 490 512 464C512 455 505 448 496 448ZM203 187C211 169 225 154 242 144L361 76L329 172C322 192 323 213 331 231L409 416H461L375 212C372 205 372 196 375 187L426 32C430 22 427 12 419 5C411 -1 400 -2 392 3L219 102C192 117 171 140 159 167L44 416H97L203 187ZM248 328L232 279C229 271 219 271 216 279L200 328L151 344C143 347 143 357 151 360L200 376L208 416H240L248 376L297 360C305 357 305 347 297 344L248 328Z"]
  };
  var faHeadSide = {
    prefix: 'far',
    iconName: 'head-side',
    icon: [512, 512, [], "f6e9", "M384 192C384 174 370 160 352 160S320 174 320 192S334 224 352 224S384 210 384 192ZM509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335V488C64 501 75 512 88 512H88C101 512 112 501 112 488V313L96 299C49 257 33 187 64 127C89 77 143 48 199 48H266C318 48 367 73 397 116C408 132 425 182 437 218C444 237 450 256 456 272H400V384C400 393 393 400 384 400H304V488C304 501 315 512 328 512H328C341 512 352 501 352 488V448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275Z"]
  };
  var faHeadSideBrain = {
    prefix: 'far',
    iconName: 'head-side-brain',
    icon: [512, 512, [], "f808", "M314 192C335 192 352 175 352 155C352 135 335 118 314 118H311C306 103 291 93 275 93C268 93 262 95 256 99C249 88 238 80 224 80S199 88 192 99C186 95 180 93 173 93C152 93 134 110 134 131C113 131 96 148 96 170C96 186 107 200 122 206C122 206 122 207 122 208C122 229 139 246 160 246C164 246 169 245 173 244V294C173 309 184 320 198 320S224 309 224 294V244C228 245 232 246 237 246C258 246 275 229 275 208C275 202 274 197 271 192H314ZM509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335V488C64 501 75 512 88 512C101 512 112 501 112 488V313L96 299C49 257 33 187 64 127C89 77 143 48 199 48H266C318 48 367 73 397 116C408 132 425 182 437 218C444 237 450 256 456 272H400V384C400 393 393 400 384 400H304V488C304 501 315 512 328 512C341 512 352 501 352 488V448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275Z"]
  };
  var faHeadSideCough = {
    prefix: 'far',
    iconName: 'head-side-cough',
    icon: [640, 512, [], "e061", "M480 360C467 360 456 371 456 384S467 408 480 408S504 397 504 384S493 360 480 360ZM477 275C456 228 429 123 404 88C366 34 303 0 234 0H200C96 0 4 80 0 185C-2 244 23 298 64 335V488C64 501 75 512 88 512C101 512 112 501 112 488V313L96 299C49 257 33 187 64 127C89 77 143 48 199 48H234C286 48 335 73 365 116C376 132 393 182 405 218C412 237 418 256 424 272H368V325L312 333C298 335 288 346 288 360S298 385 312 387L368 395V416C368 425 361 432 352 432H272V488C272 501 283 512 296 512C309 512 320 501 320 488V480H352C387 480 416 451 416 416V320H448C471 320 487 296 477 275ZM608 360C595 360 584 371 584 384S595 408 608 408S632 397 632 384S621 360 608 360ZM608 312C621 312 632 301 632 288S621 264 608 264S584 275 584 288S595 312 608 312ZM544 408C531 408 520 419 520 432S531 456 544 456S568 445 568 432S557 408 544 408ZM544 312C531 312 520 323 520 336S531 360 544 360S568 349 568 336S557 312 544 312ZM608 456C595 456 584 467 584 480S595 504 608 504S632 493 632 480S621 456 608 456ZM320 224C338 224 352 210 352 192S338 160 320 160C302 160 288 174 288 192S302 224 320 224Z"]
  };
  var faHeadSideCoughSlash = {
    prefix: 'far',
    iconName: 'head-side-cough-slash',
    icon: [640, 512, [], "e062", "M631 469L441 320H448C471 320 487 296 477 275C456 228 429 123 404 88C366 34 303 0 234 0H200C156 0 115 14 81 38L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM379 272L317 223C318 224 319 224 320 224C338 224 352 210 352 192S338 160 320 160C302 160 288 174 288 192C288 196 289 199 290 202L121 69C144 56 171 48 199 48H234C286 48 335 73 365 116C376 132 393 182 405 218C412 237 418 256 424 272H379ZM58 142L19 111C8 133 1 158 0 184C-2 244 23 298 64 335V488C64 501 75 512 88 512C101 512 112 501 112 488V313L96 299C53 260 36 198 58 142ZM288 360C288 374 298 385 312 387L368 395V416C368 425 361 432 352 432H272V488C272 501 283 512 296 512C309 512 320 501 320 488V480H352C385 480 412 454 415 422L305 335C295 339 288 349 288 360ZM608 312C621 312 632 301 632 288S621 264 608 264S584 275 584 288S595 312 608 312ZM608 408C621 408 632 397 632 384S621 360 608 360S584 371 584 384S595 408 608 408ZM544 360C557 360 568 349 568 336S557 312 544 312S520 323 520 336S531 360 544 360Z"]
  };
  var faHeadSideGoggles = {
    prefix: 'far',
    iconName: 'head-side-goggles',
    icon: [512, 512, [], "f6ea", "M57 240H6C16 277 36 310 64 335V488C64 501 75 512 88 512H88C101 512 112 501 112 488V313L96 299C78 283 65 262 57 240ZM508 272H400V384C400 393 393 400 384 400H304V488C304 501 315 512 328 512S352 501 352 488V448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275C509 274 508 273 508 272ZM480 48H398C362 18 315 0 266 0H200C135 0 75 31 38 80H32C14 80 0 94 0 112V176C0 194 14 208 32 208H216C216 208 216 208 217 208C234 227 259 240 288 240H480C498 240 512 226 512 208V80C512 62 498 48 480 48ZM194 160H48V128H194C193 133 192 138 192 144S193 155 194 160ZM216 80H104C131 60 164 48 199 48H266C271 48 275 48 280 49C255 51 233 62 217 80C216 80 216 80 216 80ZM384 192H288C261 192 240 170 240 144S261 96 288 96H384V192ZM464 192H432V96H464V192Z"]
  };
  var faHeadSideHeadphones = {
    prefix: 'far',
    iconName: 'head-side-headphones',
    icon: [512, 512, [], "f8c2", "M509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335V488C64 501 75 512 88 512C101 512 112 501 112 488V313L96 299C49 257 33 187 64 127C87 81 134 54 184 49V99C134 110 96 154 96 208C96 270 146 320 208 320S320 270 320 208C320 154 282 110 232 99V48H266C318 48 367 73 397 116C408 132 425 182 437 218C444 237 450 256 456 272H400V384C400 393 393 400 384 400H304V488C304 501 315 512 328 512C341 512 352 501 352 488V448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275ZM272 208C272 243 243 272 208 272S144 243 144 208C144 173 173 144 208 144S272 173 272 208ZM176 208C176 226 190 240 208 240S240 226 240 208C240 190 226 176 208 176S176 190 176 208Z"]
  };
  var faHeadSideHeart = {
    prefix: 'far',
    iconName: 'head-side-heart',
    icon: [512, 512, [], "e143", "M509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335V488C64 501 75 512 88 512C101 512 112 501 112 488V313L96 299C49 257 33 187 64 127C89 77 143 48 199 48H266C318 48 367 73 397 116C408 132 425 182 437 218C444 237 450 256 456 272H400V384C400 393 393 400 384 400H304V488C304 501 315 512 328 512C341 512 352 501 352 488V448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275ZM315 123C295 106 265 109 247 128L240 135L233 128C214 109 185 106 165 123C142 142 141 176 161 197L232 269C236 273 244 273 248 269L319 197C339 176 338 142 315 123Z"]
  };
  var faHeadSideMask = {
    prefix: 'far',
    iconName: 'head-side-mask',
    icon: [512, 512, [], "e063", "M352 160C334 160 320 174 320 192S334 224 352 224C370 224 384 210 384 192S370 160 352 160ZM509 275C488 228 461 123 436 88C398 34 335 0 266 0H198C94 0 4 81 0 185C-2 245 23 298 64 335V488C64 501 75 512 88 512S112 501 112 488V313L96 299C68 274 51 238 48 200L224 319V480C224 498 238 512 256 512H371C408 512 441 489 454 454L508 302C513 294 513 284 509 275ZM440 352H336C327 352 320 359 320 368C320 377 327 384 336 384H428L416 416H336C327 416 320 423 320 432C320 441 327 448 336 448H403C396 458 384 464 371 464H272V320H451L440 352ZM240 272L56 147C58 141 60 134 63 128C88 78 142 48 198 48H266C318 48 367 73 397 116C408 132 425 182 437 218C444 237 450 256 456 272H240Z"]
  };
  var faHeadSideMedical = {
    prefix: 'far',
    iconName: 'head-side-medical',
    icon: [512, 512, [], "f809", "M320 208V176C320 167 313 160 304 160H256V112C256 103 249 96 240 96H208C199 96 192 103 192 112V160H144C135 160 128 167 128 176V208C128 217 135 224 144 224H192V272C192 281 199 288 208 288H240C249 288 256 281 256 272V224H304C313 224 320 217 320 208ZM509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335V488C64 501 75 512 88 512C101 512 112 501 112 488V313L96 299C49 257 33 187 64 127C89 77 143 48 199 48H266C318 48 367 73 397 116C408 132 425 182 437 218C444 237 450 256 456 272H400V384C400 393 393 400 384 400H304V488C304 501 315 512 328 512C341 512 352 501 352 488V448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275Z"]
  };
  var faHeadSideVirus = {
    prefix: 'far',
    iconName: 'head-side-virus',
    icon: [512, 512, [], "e064", "M320 303C324 303 328 301 331 299C336 293 336 284 331 278L323 271C305 253 318 222 343 222H354C362 222 368 216 368 208S362 194 354 194H343C318 194 305 163 323 145L331 138C336 132 336 123 331 118C325 112 316 112 310 118L303 125C285 143 254 130 254 105V94C254 86 248 80 240 80S226 86 226 94V105C226 130 195 143 177 125L170 117C164 112 155 112 150 117C144 123 144 132 150 138L157 145C175 163 162 194 137 194H126C118 194 112 200 112 208S118 222 126 222H137C162 222 175 253 157 271L150 278C144 284 144 293 150 298C152 301 156 303 160 303S167 301 170 298L177 291C195 273 226 286 226 311V322C226 330 232 336 240 336S254 330 254 322V311C254 286 285 273 303 291L310 298C313 301 317 303 320 303ZM208 208C199 208 192 201 192 192C192 183 199 176 208 176S224 183 224 192C224 201 217 208 208 208ZM272 240C263 240 256 233 256 224C256 215 263 208 272 208S288 215 288 224C288 233 281 240 272 240ZM509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335V488C64 501 75 512 88 512C101 512 112 501 112 488V313L96 299C49 257 33 187 64 127C89 77 143 48 199 48H266C318 48 367 73 397 116C408 132 425 182 437 218C444 237 450 256 456 272H400V384C400 393 393 400 384 400H304V488C304 501 315 512 328 512C341 512 352 501 352 488V448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275Z"]
  };
  var faHeading = {
    prefix: 'far',
    iconName: 'heading',
    icon: [512, 512, [], "f1dc", "M480 456C480 469 469 480 456 480H344C331 480 320 469 320 456S331 432 344 432H376V280H136V432H168C181 432 192 443 192 456S181 480 168 480H56C43 480 32 469 32 456S43 432 56 432H88V80H56C43 80 32 69 32 56S43 32 56 32H168C181 32 192 43 192 56S181 80 168 80H136V232H376V80H344C331 80 320 69 320 56S331 32 344 32H456C469 32 480 43 480 56S469 80 456 80H424V432H456C469 432 480 443 480 456Z"]
  };
  var faHeadphones = {
    prefix: 'far',
    iconName: 'headphones',
    icon: [512, 512, [], "f025", "M256 32C113 32 5 151 0 288V400C0 401 0 402 0 402C3 446 38 480 82 480C108 480 128 460 128 434V302C128 276 108 256 82 256C71 256 60 258 50 263C62 160 150 80 256 80C362 80 450 160 462 263C452 258 441 256 430 256C404 256 384 276 384 302V434C384 460 404 480 430 480C474 480 509 446 512 402C512 402 512 401 512 400V288C507 151 399 32 256 32ZM80 304V432C62 431 48 416 48 398V338C48 320 62 305 80 304ZM432 432V304C450 305 464 320 464 338V398C464 416 450 431 432 432Z"]
  };
  var faHeadphonesSimple = {
    prefix: 'far',
    iconName: 'headphones-simple',
    icon: [512, 512, [], "f58f", "M160 272H144C109 272 80 301 80 336V416C80 451 109 480 144 480H160C178 480 192 466 192 448V304C192 286 178 272 160 272ZM144 432C135 432 128 425 128 416V336C128 327 135 320 144 320V432ZM256 32C113 32 5 151 0 288V400C0 409 7 416 16 416H32C41 416 48 409 48 400V288C48 173 141 80 256 80C371 80 464 173 464 288V400C464 409 471 416 480 416H496C505 416 512 409 512 400V288C507 151 399 32 256 32ZM368 272H352C334 272 320 286 320 304V448C320 466 334 480 352 480H368C403 480 432 451 432 416V336C432 301 403 272 368 272ZM384 416C384 425 377 432 368 432V320C377 320 384 327 384 336V416Z"]
  };
  var faHeadset = {
    prefix: 'far',
    iconName: 'headset',
    icon: [512, 512, [], "f590", "M256 0C113 0 5 119 0 256V309C0 351 33 384 73 384H91C112 384 128 367 128 347V213C128 193 112 176 91 176H73C70 176 67 177 64 177C95 102 169 48 256 48C343 48 417 102 448 177C445 177 442 176 439 176H421C400 176 384 193 384 213V347C384 367 400 384 421 384H439C448 384 456 382 464 379V400C464 422 446 440 424 440H313C305 426 290 416 272 416H240C214 416 192 438 192 464S214 512 240 512H272C290 512 305 502 313 488H424C473 488 512 449 512 400V256C507 119 399 0 256 0ZM73 224H80V336H73C59 336 48 324 48 309V256C48 254 48 251 48 249C49 235 60 224 73 224ZM439 336H432V224H439C452 224 463 235 464 249C464 251 464 254 464 256V309C464 324 453 336 439 336Z"]
  };
  var faHeart = {
    prefix: 'far',
    iconName: 'heart',
    icon: [512, 512, [], "f004", "M463 63C439 42 409 32 379 32C341 32 303 47 276 76L256 96L236 76C209 47 171 32 133 32C103 32 73 42 49 63C-13 117 -16 213 40 270L233 470C239 477 248 480 256 480C264 480 273 477 279 470L472 270C528 213 525 117 463 63ZM438 237L256 425L74 237C42 204 34 139 80 99C120 65 175 82 202 109C231 140 210 118 256 165C294 126 283 137 310 109C337 82 391 64 432 99C477 139 471 203 438 237Z"]
  };
  var faHeartCrack = {
    prefix: 'far',
    iconName: 'heart-crack',
    icon: [512, 512, [], "f7a9", "M463 63C439 42 409 32 379 32C341 32 303 47 276 76L256 96L236 76C209 47 171 32 133 32C103 32 73 42 49 63C-13 117 -16 213 40 270L233 470C239 477 248 480 256 480C264 480 273 477 279 470L472 270C528 213 525 117 463 63ZM438 237L256 425L74 237C42 204 34 139 80 99C120 65 175 82 202 109C226 134 217 125 237 146L144 208L144 208L144 208L288 352L240 224L336 160L336 160L336 160L336 158L319 102C347 79 395 68 432 99C477 139 471 203 438 237Z"]
  };
  var faHeartHalf = {
    prefix: 'far',
    iconName: 'heart-half',
    icon: [512, 512, [], "e144", "M259 112C259 102 255 92 247 84L239 76C211 47 174 32 136 32C106 32 76 42 52 63C-10 117 -13 213 43 270L236 470C236 470 236 470 236 470C244 479 259 472 259 460C259 393 259 174 259 112ZM211 375L77 237C45 204 37 139 83 99C123 65 178 82 205 109C207 112 209 114 211 116V375Z"]
  };
  var faHeartHalfStroke = {
    prefix: 'far',
    iconName: 'heart-half-stroke',
    icon: [512, 512, [], "e145", "M463 63C439 42 409 32 379 32C341 32 303 47 276 76L256 96L236 76C209 47 171 32 133 32C103 32 73 42 49 63C-13 117 -16 213 40 270L233 470C239 477 248 480 256 480C264 480 273 477 279 470L472 270C528 213 525 117 463 63ZM438 237L256 425V165C256 165 256 165 256 165C294 126 283 137 310 109C337 82 391 64 432 99C477 139 471 203 438 237Z"]
  };
  var faHeartPulse = {
    prefix: 'far',
    iconName: 'heart-pulse',
    icon: [512, 512, [], "f21e", "M256 425L154 320H88L233 470C239 477 248 480 256 480C264 480 273 477 279 470L424 320H357L256 425ZM463 63C439 42 409 32 379 32C341 32 303 47 276 76L256 96L236 76C209 47 171 32 133 32C103 32 73 42 49 63C-13 117 -16 213 40 270L57 288L154 288L184 216L240 343C246 355 263 355 269 343L319 244L341 288L455 288L472 270C528 213 525 117 463 63ZM438 237L419 256H361L333 201C327 189 311 189 305 201L256 299L198 169C192 157 174 157 168 170L132 256H93L74 237C42 204 34 139 80 99C120 65 175 82 202 109C231 140 210 118 256 165C294 126 283 137 310 109C337 82 391 64 432 99C477 139 471 203 438 237Z"]
  };
  var faHeat = {
    prefix: 'far',
    iconName: 'heat',
    icon: [448, 512, [], "e00c", "M48 156V120C48 107 37 96 24 96C11 96 0 107 0 120V156C0 206 19 254 55 289C81 315 96 351 96 388V456C96 469 107 480 120 480C133 480 144 469 144 456V388C144 338 125 290 89 255C63 229 48 193 48 156ZM393 255C367 229 352 193 352 156V120C352 107 341 96 328 96C315 96 304 107 304 120V156C304 206 323 254 359 289C385 315 400 351 400 388V456C400 469 411 480 424 480C437 480 448 469 448 456V388C448 338 429 290 393 255ZM200 156V56C200 43 189 32 176 32C163 32 152 43 152 56V156C152 206 171 254 207 289C233 315 248 351 248 388V456C248 469 259 480 272 480C285 480 296 469 296 456V388C296 338 277 291 241 255C215 229 200 193 200 156Z"]
  };
  var faHelicopter = {
    prefix: 'far',
    iconName: 'helicopter',
    icon: [640, 512, [], "f533", "M316 416H552C567 416 582 409 593 398C604 387 609 371 608 356C598 233 497 136 376 129V48H552C565 48 576 37 576 24C576 11 565 0 552 0H152C139 0 128 11 128 24C128 37 139 48 152 48H328V128H148L112 80C105 70 93 64 80 64H40C28 64 16 70 8 79S-2 102 1 115L32 219C35 228 42 236 51 240L201 300L272 394C282 408 299 416 316 416ZM408 182C490 202 553 273 560 360C560 362 559 364 558 365C557 366 555 368 552 368H408V182ZM76 198L51 112H76L124 176H360V368H316C314 368 312 367 310 365L232 260L76 198ZM633 439C624 430 608 430 599 439C583 455 561 464 539 464H248C235 464 224 475 224 488S235 512 248 512H539C574 512 608 498 633 473C642 464 642 448 633 439Z"]
  };
  var faHelmetBattle = {
    prefix: 'far',
    iconName: 'helmet-battle',
    icon: [576, 512, [], "f6eb", "M32 256C50 256 64 243 64 228V0L1 221C-4 239 11 256 32 256ZM575 221L512 0V228C512 243 526 256 544 256C565 256 580 239 575 221ZM480 211C480 90 288 0 288 0S96 90 96 211C96 294 73 357 65 392C62 406 68 421 81 427L243 506C251 510 261 512 271 512H305C315 512 325 510 333 506L495 427C508 421 515 406 511 391C503 357 480 294 480 211ZM312 462V288L400 256V224H176V256L264 288V462L115 390C116 387 116 384 117 381C128 342 144 284 144 211C144 147 236 83 288 54C340 83 432 147 432 211C432 284 448 342 459 381C460 384 460 387 461 390L312 462Z"]
  };
  var faHelmetSafety = {
    prefix: 'far',
    iconName: 'helmet-safety',
    icon: [576, 512, [], "f807", "M573 377C567 362 553 352 537 352H544V304C544 191 470 95 368 61V56C368 34 350 16 328 16H248C226 16 208 34 208 56V61C106 95 32 191 32 304V352H39C23 352 9 362 3 377C-3 391 0 407 10 419C17 427 82 496 288 496S559 427 566 419C576 407 579 391 573 377ZM80 304C80 218 133 144 208 113V296C208 309 219 320 232 320C245 320 256 309 256 296V64H320V296C320 309 331 320 344 320C357 320 368 309 368 296V113C443 144 496 218 496 304V352H80V304ZM288 448C157 448 90 418 63 400H513C486 418 419 448 288 448Z"]
  };
  var faHexagon = {
    prefix: 'far',
    iconName: 'hexagon',
    icon: [512, 512, [], "f312", "M506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM360 432H152L49 256L152 80H360L463 256L360 432Z"]
  };
  var faHexagonMinus = {
    prefix: 'far',
    iconName: 'hexagon-minus',
    icon: [512, 512, [], "f307", "M506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM360 432H152L49 256L152 80H360L463 256L360 432ZM160 232C147 232 136 243 136 256C136 269 147 280 160 280H352C365 280 376 269 376 256C376 243 365 232 352 232H160Z"]
  };
  var faHexagonPlus = {
    prefix: 'far',
    iconName: 'hexagon-plus',
    icon: [512, 512, [], "f300", "M506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM360 432H152L49 256L152 80H360L463 256L360 432ZM280 232V160C280 147 269 136 256 136S232 147 232 160V232H160C147 232 136 243 136 256C136 269 147 280 160 280H232V352C232 365 243 376 256 376S280 365 280 352V280H352C365 280 376 269 376 256C376 243 365 232 352 232H280Z"]
  };
  var faHexagonXmark = {
    prefix: 'far',
    iconName: 'hexagon-xmark',
    icon: [512, 512, [], "f2ee", "M506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM360 432H152L49 256L152 80H360L463 256L360 432ZM341 171L341 171C331 162 316 162 307 171L256 222L205 171C196 162 181 162 171 171V171C162 181 162 196 171 205L222 256L171 307C162 316 162 331 171 341L171 341C181 350 196 350 205 341L256 290L307 341C316 350 331 350 341 341L341 341C350 331 350 316 341 307L290 256L341 205C350 196 350 181 341 171Z"]
  };
  var faHighlighter = {
    prefix: 'far',
    iconName: 'highlighter',
    icon: [576, 512, [], "f591", "M528 79L465 16C454 5 440 0 426 0C413 0 400 5 390 14L104 262C93 271 89 286 93 300L106 343L72 377C63 386 63 400 71 410L6 475C-7 489 2 512 22 512H94C99 512 103 510 106 507L138 475C147 482 160 481 168 473L202 439L244 452C248 453 252 454 255 454C266 454 276 449 282 441L530 154C550 133 548 100 528 79ZM251 404L188 385L151 422L123 394L160 356L141 293L173 266L279 372L251 404ZM494 123L310 335L209 235L422 50C423 49 425 48 426 48C428 48 429 48 431 50L494 113C497 116 497 120 494 123Z"]
  };
  var faHighlighterLine = {
    prefix: 'far',
    iconName: 'highlighter-line',
    icon: [576, 512, [], "e146", "M552 464H248C235 464 224 475 224 488C224 501 235 512 248 512H552C565 512 576 501 576 488C576 475 565 464 552 464ZM267 429C271 431 274 431 278 431C288 431 298 427 305 419L530 154C549 133 548 100 528 79L465 16C454 5 440 0 426 0C413 0 400 5 390 14L126 239C116 249 111 264 116 277L129 320L72 377C63 386 63 400 71 410L6 475C-7 489 2 512 22 512H94C99 512 103 510 106 507L138 475C147 482 160 481 168 473L224 416L267 429ZM422 50C423 49 425 48 426 48C428 48 429 48 431 50L494 113C497 116 497 120 494 123L332 313L232 212L422 50ZM151 422L123 394L183 334L164 270L195 243L301 349L274 381L211 362L151 422Z"]
  };
  var faHippo = {
    prefix: 'far',
    iconName: 'hippo',
    icon: [640, 512, [], "f6ed", "M559 91C541 93 524 100 510 107C491 81 461 65 429 64C422 45 405 32 384 32H352C325 32 304 54 304 80V84C275 71 243 64 208 64C99 64 0 128 0 224V448C0 466 14 480 32 480H112C130 480 144 466 144 448V407C200 423 247 414 272 407V448C272 466 286 480 304 480H384C402 480 416 466 416 448V304L512 304V336C512 345 519 352 528 352H560C569 352 576 345 576 336V304H589C617 304 640 281 640 252V170C640 126 604 88 559 91ZM368 432H320V345C197 378 206 375 96 345V432H48V235C56 156 132 112 208 112C244 112 277 122 304 139L304 198C304 241 330 278 368 295V432ZM592 256L410 256C378 256 352 230 352 198L352 88C352 84 355 80 360 80H376C380 80 384 84 384 88V119C406 113 418 111 429 112C450 114 469 127 478 147L487 169C542 148 546 140 563 139C581 138 592 156 592 170V256ZM432 160C423 160 416 167 416 176S423 192 432 192C441 192 448 185 448 176S441 160 432 160Z"]
  };
  var faHockeyMask = {
    prefix: 'far',
    iconName: 'hockey-mask',
    icon: [448, 512, [], "f6ee", "M192 416C183 416 176 423 176 432S183 448 192 448C201 448 208 441 208 432S201 416 192 416ZM192 352C183 352 176 359 176 368S183 384 192 384C201 384 208 377 208 368S201 352 192 352ZM272 112C281 112 288 105 288 96S281 80 272 80C263 80 256 87 256 96S263 112 272 112ZM176 112C185 112 192 105 192 96S185 80 176 80S160 87 160 96S167 112 176 112ZM192 288C183 288 176 295 176 304S183 320 192 320C201 320 208 313 208 304S201 288 192 288ZM256 416C247 416 240 423 240 432S247 448 256 448C265 448 272 441 272 432S265 416 256 416ZM256 288C247 288 240 295 240 304S247 320 256 320C265 320 272 313 272 304S265 288 256 288ZM256 352C247 352 240 359 240 368S247 384 256 384C265 384 272 377 272 368S265 352 256 352ZM224 128C215 128 208 135 208 144S215 160 224 160S240 153 240 144S233 128 224 128ZM377 54C335 18 279 0 224 0C168 0 113 18 71 54C7 110 -31 225 33 416C65 512 224 512 224 512S383 512 415 416C479 225 441 110 377 54ZM370 401C353 452 256 464 224 464C198 464 96 453 78 401C31 259 40 146 103 91C134 63 178 48 224 48S314 63 345 91C408 146 417 259 370 401ZM200 208C200 190 186 176 168 176H104C86 176 72 190 72 208C72 243 101 272 136 272S200 243 200 208ZM280 176C262 176 248 190 248 208C248 243 277 272 312 272S376 243 376 208C376 190 362 176 344 176H280Z"]
  };
  var faHockeyPuck = {
    prefix: 'far',
    iconName: 'hockey-puck',
    icon: [512, 512, [], "f453", "M256 64C129 64 0 96 0 178V315C0 402 129 448 256 448S512 402 512 315V184C512 102 383 64 256 64ZM464 315C464 361 369 400 256 400S48 361 48 315V259C88 285 154 304 256 304S424 285 464 259V315ZM256 256C141 256 48 224 48 184C48 150 132 112 256 112S464 150 464 184C464 224 371 256 256 256Z"]
  };
  var faHockeySticks = {
    prefix: 'far',
    iconName: 'hockey-sticks',
    icon: [640, 512, [], "f454", "M593 303H436L411 351L528 352V464L418 464C398 464 379 455 366 441L356 460C352 468 347 476 342 484C362 502 389 512 418 512H593C619 512 640 490 640 464V351C640 324 619 303 593 303ZM593 464H560V351H593V464ZM222 267L249 215L175 70L217 48L275 162L302 110L259 26C251 9 234 0 217 0C210 0 203 2 196 5L154 27C143 33 134 43 130 55C126 67 127 81 133 92L222 267ZM510 55C506 43 497 33 486 27L444 5C437 2 430 0 423 0C406 0 389 9 381 26L240 303H47C21 303 0 324 0 351V464C0 490 21 512 47 512H222C267 512 308 486 328 445L507 92C513 81 514 67 510 55ZM80 464H47V351H80V464ZM286 424C274 448 249 464 222 464L112 464V352L249 351C261 351 272 344 277 334L423 48L465 70L286 424Z"]
  };
  var faHollyBerry = {
    prefix: 'far',
    iconName: 'holly-berry',
    icon: [512, 512, [], "f7aa", "M256 96C283 96 304 74 304 48S283 0 256 0S208 22 208 48S230 96 256 96ZM288 144C288 170 309 192 336 192S384 170 384 144S362 96 336 96S288 117 288 144ZM176 192C203 192 224 170 224 144S203 96 176 96S128 117 128 144S150 192 176 192ZM452 336C438 335 423 332 408 328C401 326 397 319 398 313C402 298 407 285 412 273C421 254 409 232 387 230C310 223 293 192 256 192C218 192 203 223 125 230C103 232 91 254 100 273C106 285 110 298 114 313C115 319 111 326 104 328C89 332 74 335 60 336C41 338 25 359 35 379C49 409 57 443 57 478C57 502 79 512 92 512C98 512 104 511 109 508C142 490 177 479 211 476C233 474 245 452 236 433C231 421 226 408 222 393C216 367 296 367 290 393C286 408 281 421 275 433C267 452 279 474 300 476C335 479 370 490 402 508C408 510 414 512 420 512C433 512 455 502 455 478C455 443 463 409 477 379C487 358 470 338 452 336ZM219 332C187 341 168 373 176 405C178 414 181 423 184 431C157 436 130 444 104 456C102 430 97 405 88 381C98 379 107 377 117 374C149 365 168 333 160 301C158 292 155 283 152 275C179 270 206 261 232 249C234 276 239 301 248 325C239 327 229 329 219 332ZM408 456C382 444 355 436 328 431C331 423 334 414 336 405C343 377 329 348 303 336C301 322 285 301 280 251C280 250 280 250 280 249C306 261 333 270 360 275C357 283 354 292 352 301C344 333 363 365 395 374C405 377 414 379 424 381C415 405 410 430 408 456Z"]
  };
  var faHome = {
    prefix: 'far',
    iconName: 'home',
    icon: [576, 512, [], "f015", "M568 230L304 6C295 -2 281 -2 272 6L8 230C-2 238 -3 253 6 264C14 274 29 275 40 266L64 246V472C64 494 82 512 104 512H200C222 512 240 494 240 472V352H336V472C336 494 354 512 376 512H472C494 512 512 494 512 472V246L536 266C541 270 547 272 552 272C559 272 566 269 570 264C579 253 578 238 568 230ZM464 464H384V344C384 322 366 304 344 304H232C210 304 192 322 192 344V464H112V208C112 207 112 206 111 205L288 55L464 205V464Z"]
  };
  var faHomeHeart = {
    prefix: 'far',
    iconName: 'home-heart',
    icon: [576, 512, [], "f4c9", "M280 240C262 221 231 218 211 235C187 254 186 288 207 309L280 381C284 385 292 385 296 381L369 309C390 288 389 254 365 235C345 218 314 221 295 240L288 247L280 240ZM568 230L304 6C295 -2 281 -2 272 6L8 230C-2 238 -3 253 6 264C14 274 29 275 40 266L64 246V448C64 483 93 512 128 512H448C483 512 512 483 512 448V246L536 266C541 270 547 272 552 272C559 272 566 269 570 264C579 253 578 238 568 230ZM464 448C464 457 457 464 448 464H128C119 464 112 457 112 448V208C112 207 112 206 111 205L288 55L464 205V448Z"]
  };
  var faHomeSimple = {
    prefix: 'far',
    iconName: 'home-simple',
    icon: [576, 512, [], "f80a", "M568 230L304 6C295 -2 281 -2 272 6L8 230C-2 238 -3 253 6 264C14 274 29 275 40 266L64 246V448C64 483 93 512 128 512H448C483 512 512 483 512 448V246L536 266C541 270 547 272 552 272C559 272 566 269 570 264C579 253 578 238 568 230ZM464 208V448C464 457 457 464 448 464H128C119 464 112 457 112 448V208C112 207 112 206 111 205L288 55L465 205C464 206 464 207 464 208Z"]
  };
  var faHomeUser = {
    prefix: 'far',
    iconName: 'home-user',
    icon: [576, 512, [], "e147", "M568 224L304 0C295 -8 281 -8 272 0L8 224C-2 233 -3 248 6 258C14 268 29 269 40 261L64 240V442C64 478 93 506 128 506H448C483 506 512 478 512 442V240L536 261C541 264 547 266 552 266C559 266 566 263 570 258C579 248 578 233 568 224ZM464 442C464 451 457 458 448 458H128C119 458 112 451 112 442V202C112 201 112 200 111 200L288 50L464 199V442ZM224 218C224 254 253 282 288 282S352 254 352 218C352 183 323 154 288 154S224 183 224 218ZM256 314C212 314 176 350 176 394C176 403 183 410 192 410H384C393 410 400 403 400 394C400 350 364 314 320 314H256Z"]
  };
  var faHoodCloak = {
    prefix: 'far',
    iconName: 'hood-cloak',
    icon: [576, 512, [], "f6ef", "M570 461C512 384 512 320 512 320V256C512 172 466 133 411 73L451 34C463 21 454 0 437 0H288C192 0 64 110 64 256V320C64 320 64 384 6 461C-9 482 6 512 32 512H544C570 512 585 482 570 461ZM368 464H208V328C208 284 244 248 288 248C332 248 368 284 368 328V464ZM416 464V328C416 257 359 200 288 200C218 200 160 257 160 328V464H63C111 388 112 327 112 320V256C112 137 219 48 288 48H368L344 72C381 112 379 109 394 125C441 176 464 203 464 256V320C464 327 466 388 514 464H416Z"]
  };
  var faHorizontalRule = {
    prefix: 'far',
    iconName: 'horizontal-rule',
    icon: [640, 512, [], "f86c", "M616 280H24C11 280 0 269 0 256S11 232 24 232H616C629 232 640 243 640 256S629 280 616 280Z"]
  };
  var faHorse = {
    prefix: 'far',
    iconName: 'horse',
    icon: [576, 512, [], "f6f0", "M464 80C455 80 448 87 448 96S455 112 464 112S480 105 480 96S473 80 464 80ZM576 102C576 91 572 80 565 72L543 45C559 40 572 27 576 10C577 5 573 0 568 0L432 0C364 0 306 48 292 112H176C138 112 104 131 84 160C37 162 0 201 0 248V296C0 309 11 320 24 320H24C37 320 48 309 48 296V248C48 235 55 224 65 216C65 219 64 221 64 224C64 254 76 282 96 303L83 346C79 360 79 374 82 387L106 487C110 502 123 512 137 512H212C233 512 248 492 243 472L218 371L227 345L288 358V480C288 498 302 512 320 512H400C418 512 432 498 432 480V324C452 302 463 273 464 243C464 242 464 234 464 234C485 241 502 235 505 234L536 224C560 215 576 193 576 168V102ZM521 178L490 189C488 189 480 192 473 185L448 160H416V240C416 266 403 289 384 304V464H336V320L196 289L167 369L191 464H150L129 376C128 371 128 365 129 360L152 283C129 274 112 251 112 224C112 189 141 160 176 160H336V144C336 91 379 48 432 48H483L528 102V168C528 172 525 177 521 178Z"]
  };
  var faHorseHead = {
    prefix: 'far',
    iconName: 'horse-head',
    icon: [512, 512, [], "f7ab", "M507 269C506 267 435 128 403 103C409 84 410 63 404 41C396 10 362 -8 332 3L167 65C19 118 0 257 0 372V448C0 483 29 512 64 512H296C316 512 334 501 344 484C354 467 354 446 345 428L344 427L344 426L304 364C307 363 305 364 308 363L314 370C328 389 350 400 374 400H401C420 400 438 393 451 380C494 345 488 350 490 348C511 327 518 296 507 269ZM456 314L420 344C415 349 408 352 401 352H374C365 352 357 348 352 341L319 296C300 314 281 328 251 328C216 328 185 307 171 275C168 270 162 266 156 266C152 266 148 268 145 271L133 283C128 288 126 295 130 301C153 347 199 376 251 376C252 376 253 376 255 376L303 452C306 457 302 464 296 464H64C55 464 48 457 48 448V372C48 242 77 148 184 110L348 48C353 46 357 51 358 53C368 91 345 112 330 120C365 127 390 156 405 185L462 286C466 296 464 307 456 314ZM296 176C283 176 272 187 272 200C272 213 283 224 296 224C309 224 320 213 320 200C320 187 309 176 296 176Z"]
  };
  var faHorseSaddle = {
    prefix: 'far',
    iconName: 'horse-saddle',
    icon: [576, 512, [], "f8c3", "M464 80C455 80 448 87 448 96S455 112 464 112S480 105 480 96S473 80 464 80ZM576 102C576 93 571 79 565 72L543 45C559 40 572 26 576 10C576 7 576 5 574 3C573 1 570 0 568 0H432C364 0 306 48 292 112H176C139 112 105 130 84 160C37 162 0 201 0 248V296C0 309 11 320 24 320H24C37 320 48 309 48 296V248C48 235 55 224 65 216C65 218 58 264 96 303L83 346C80 360 79 374 82 387L106 487C110 502 123 512 137 512H212C222 512 231 507 237 500C243 492 246 482 243 472L218 371L227 345L288 358V480C288 498 302 512 320 512H400C418 512 432 498 432 480V324C452 302 463 273 464 243C464 242 464 234 464 234C477 239 492 239 505 234L536 224C560 215 576 193 576 168V102ZM224 295L196 289L168 369L192 464H150L129 376C128 371 128 365 129 360L152 283C126 273 110 247 112 220C114 192 133 169 160 162V176C160 216 187 250 224 260V295ZM208 176V160H288V176C288 198 270 216 248 216C226 216 208 198 208 176ZM521 178L490 189C484 191 477 189 473 185L448 160H416V240C416 265 404 289 384 304V464H336V320L272 306V260C309 250 336 216 336 176V144C336 91 379 48 432 48H483L528 102V168C528 172 525 177 521 178Z"]
  };
  var faHospital = {
    prefix: 'far',
    iconName: 'hospital',
    icon: [448, 512, [], "f0f8", "M424 464H417V64C417 29 388 0 353 0H95C60 0 31 29 31 64V464H24C11 464 0 475 0 488C0 501 11 512 24 512H424C437 512 448 501 448 488C448 475 437 464 424 464ZM369 464H79V64C79 55 87 48 95 48H352C361 48 368 55 368 64V464ZM288 155V133C288 127 283 123 277 123H245V91C245 85 241 80 235 80H213C207 80 203 85 203 91V123H171C165 123 160 127 160 133V155C160 161 165 165 171 165H203V197C203 203 207 208 213 208H235C241 208 245 203 245 197V165H277C283 165 288 161 288 155ZM180 352H140C133 352 128 357 128 364V404C128 411 133 416 140 416H180C187 416 192 411 192 404V364C192 357 187 352 180 352ZM308 352H268C261 352 256 357 256 364V404C256 411 261 416 268 416H308C315 416 320 411 320 404V364C320 357 315 352 308 352ZM180 240H140C133 240 128 245 128 252V292C128 299 133 304 140 304H180C187 304 192 299 192 292V252C192 245 187 240 180 240ZM308 240H268C261 240 256 245 256 252V292C256 299 261 304 268 304H308C315 304 320 299 320 292V252C320 245 315 240 308 240Z"]
  };
  var faHospitalUser = {
    prefix: 'far',
    iconName: 'hospital-user',
    icon: [640, 512, [], "f80d", "M148 240H108C101 240 96 245 96 252V292C96 299 101 304 108 304H148C154 304 160 299 160 292V252C160 245 154 240 148 240ZM148 352H108C101 352 96 357 96 364V404C96 411 101 416 108 416H148C154 416 160 411 160 404V364C160 357 154 352 148 352ZM336 64L336 120C336 133 346 144 360 144S384 133 384 120L384 64C384 29 355 0 320 0H63C28 0 -1 29 -1 64L-1 488C0 501 10 512 23 512C37 512 47 501 47 488L47 64C47 55 54 48 63 48H320C329 48 336 55 336 64ZM256 155V133C256 127 251 123 245 123H213V91C213 85 208 80 202 80H181C175 80 170 85 170 91V123H138C132 123 128 127 128 133V155C128 161 132 165 138 165H170V197C170 203 175 208 181 208H202C208 208 213 203 213 197V165H245C251 165 256 161 256 155ZM276 352H236C229 352 224 357 224 364V404C224 411 229 416 236 416H276C282 416 288 411 288 404V364C288 357 282 352 276 352ZM276 240H236C229 240 224 245 224 252V292C224 299 229 304 236 304H276C282 304 288 299 288 292V252C288 245 282 240 276 240ZM480 320C533 320 576 277 576 224S533 128 480 128S384 171 384 224S426 320 480 320ZM480 176C506 176 528 198 528 224S506 272 480 272S432 250 432 224S453 176 480 176ZM512 352H448C377 352 320 409 320 480C320 498 334 512 352 512H608C625 512 640 498 640 480C640 409 582 352 512 352ZM369 464C377 428 409 400 448 400H512C550 400 582 428 590 464H369Z"]
  };
  var faHospitalWide = {
    prefix: 'far',
    iconName: 'hospital-wide',
    icon: [576, 512, [], "f47d", "M308 384H268C261 384 256 389 256 396V436C256 443 261 448 268 448H308C315 448 320 443 320 436V396C320 389 315 384 308 384ZM308 256H268C261 256 256 261 256 268V308C256 315 261 320 268 320H308C315 320 320 315 320 308V268C320 261 315 256 308 256ZM180 256H140C133 256 128 261 128 268V308C128 315 133 320 140 320H180C187 320 192 315 192 308V268C192 261 187 256 180 256ZM436 256H396C389 256 384 261 384 268V308C384 315 389 320 396 320H436C443 320 448 315 448 308V268C448 261 443 256 436 256ZM341 123H309V91C309 85 305 80 299 80H277C271 80 267 85 267 91V123H235C229 123 224 127 224 133V155C224 161 229 165 235 165H267V197C267 203 271 208 277 208H299C305 208 309 203 309 197V165H341C347 165 352 161 352 155V133C352 127 347 123 341 123ZM180 384H140C133 384 128 389 128 396V436C128 443 133 448 140 448H180C187 448 192 443 192 436V396C192 389 187 384 180 384ZM436 384H396C389 384 384 389 384 396V436C384 443 389 448 396 448H436C443 448 448 443 448 436V396C448 389 443 384 436 384ZM512 96H480L480 64C481 29 452 0 416 0H160C124 0 95 29 96 64L96 96H64C29 96 0 125 0 160V488C0 501 11 512 24 512S48 501 48 488V160C48 151 55 144 64 144H144L144 64C144 55 151 48 160 48H416C425 48 432 55 432 64L432 144H512C521 144 528 151 528 160V488C528 501 539 512 552 512S576 501 576 488V160C576 125 547 96 512 96Z"]
  };
  var faHospitals = {
    prefix: 'far',
    iconName: 'hospitals',
    icon: [640, 512, [], "f80e", "M148 352H108C101 352 96 357 96 364V404C96 411 101 416 108 416H148C155 416 160 411 160 404V364C160 357 155 352 148 352ZM288 0H64C29 0 0 29 0 64L0 488C0 501 11 512 24 512C38 512 48 501 48 488L48 64C48 55 55 48 64 48H288C297 48 304 55 304 64L303 488C303 501 314 512 327 512S351 501 351 488L352 64C352 29 323 0 288 0ZM244 240H204C197 240 192 245 192 252V292C192 299 197 304 204 304H244C251 304 256 299 256 292V252C256 245 251 240 244 240ZM244 352H204C197 352 192 357 192 364V404C192 411 197 416 204 416H244C251 416 256 411 256 404V364C256 357 251 352 244 352ZM148 240H108C101 240 96 245 96 252V292C96 299 101 304 108 304H148C155 304 160 299 160 292V252C160 245 155 240 148 240ZM197 197V165H229C235 165 240 161 240 155V133C240 127 235 123 229 123H197V91C197 85 193 80 187 80H165C159 80 155 85 155 91V123H123C117 123 112 127 112 133V155C112 161 117 165 123 165H155V197C155 203 159 208 165 208H187C193 208 197 203 197 197ZM436 240H396C389 240 384 245 384 252V292C384 299 389 304 396 304H436C443 304 448 299 448 292V252C448 245 443 240 436 240ZM436 352H396C389 352 384 357 384 364V404C384 411 389 416 396 416H436C443 416 448 411 448 404V364C448 357 443 352 436 352ZM532 352H492C485 352 480 357 480 364V404C480 411 485 416 492 416H532C539 416 544 411 544 404V364C544 357 539 352 532 352ZM532 240H492C485 240 480 245 480 252V292C480 299 485 304 492 304H532C539 304 544 299 544 292V252C544 245 539 240 532 240ZM485 197V165H517C523 165 528 161 528 155V133C528 127 523 123 517 123H485V91C485 85 481 80 475 80H453C447 80 443 85 443 91V123H411C405 123 400 127 400 133V155C400 161 405 165 411 165H443V197C443 203 447 208 453 208H475C481 208 485 203 485 197ZM576 0H408C395 0 384 11 384 24C384 37 395 48 408 48H576C585 48 592 55 592 64L591 488C591 501 602 512 615 512S639 501 639 488L640 64C640 29 611 0 576 0Z"]
  };
  var faHotTubPerson = {
    prefix: 'far',
    iconName: 'hot-tub-person',
    icon: [512, 512, [], "f593", "M321 178C322 186 328 192 336 192H352C361 192 369 183 368 174C364 134 346 99 319 77C301 62 290 40 287 14C286 6 279 0 272 0H256C246 0 239 9 240 18C244 58 262 93 289 115C306 130 318 152 321 178ZM417 178C418 186 424 192 432 192H448C457 192 465 183 464 174C460 134 442 99 415 77C397 62 386 40 383 14C382 6 375 0 368 0H352C342 0 335 9 336 18C340 58 358 93 385 115C402 130 414 152 417 178ZM480 256H261L150 173C139 165 126 160 112 160H64C29 160 0 189 0 224V448C0 483 29 512 64 512H448C483 512 512 483 512 448V288C512 270 498 256 480 256ZM48 224C48 215 55 208 64 208H112C115 208 119 209 122 211L181 256H48V224ZM112 464H64C55 464 48 457 48 448V304H112V464ZM232 464H160V304H232V464ZM352 464H280V304H352V464ZM464 448C464 457 457 464 448 464H400V304H464V448ZM64 128C99 128 128 99 128 64C128 29 99 0 64 0S0 29 0 64C0 99 29 128 64 128Z"]
  };
  var faHotdog = {
    prefix: 'far',
    iconName: 'hotdog',
    icon: [512, 512, [], "f80f", "M484 187C502 166 512 141 512 113C512 51 461 0 399 0C372 0 346 10 325 28L322 25C306 9 285 0 263 0C243 0 224 8 210 22L22 210C-8 240 -7 291 25 323L28 325C10 346 0 371 0 399C0 461 51 512 113 512C140 512 166 502 187 484L190 487C206 503 227 512 249 512C269 512 288 504 302 490L490 302C520 272 519 221 487 189L484 187ZM56 244L244 56C254 45 273 44 291 61L61 291C44 273 46 254 56 244ZM456 268L268 456C258 467 239 468 221 451L451 221C468 239 466 258 456 268ZM445 159L159 445C134 470 92 470 67 445S42 378 67 353L353 67C378 42 420 42 445 67S470 134 445 159ZM400 112C390 122 381 123 369 125C364 126 306 128 298 197C293 238 262 239 254 240C248 241 190 244 182 312C181 320 181 350 139 355C125 357 108 359 89 377C84 384 84 393 90 400C96 406 106 406 112 400C123 389 131 388 143 387C148 386 206 384 214 316C215 307 216 277 258 272C264 271 321 269 329 201C334 159 365 158 373 157C387 155 404 153 423 135C429 128 429 118 422 112C416 106 406 106 400 112Z"]
  };
  var faHotel = {
    prefix: 'far',
    iconName: 'hotel',
    icon: [576, 512, [], "f594", "M269 256H307C314 256 320 250 320 243V205C320 198 314 192 307 192H269C262 192 256 198 256 205V243C256 250 262 256 269 256ZM397 160H435C442 160 448 154 448 147V109C448 102 442 96 435 96H397C390 96 384 102 384 109V147C384 154 390 160 397 160ZM397 256H435C442 256 448 250 448 243V205C448 198 442 192 435 192H397C390 192 384 198 384 205V243C384 250 390 256 397 256ZM269 160H307C314 160 320 154 320 147V109C320 102 314 96 307 96H269C262 96 256 102 256 109V147C256 154 262 160 269 160ZM552 464H544V48H552C565 48 576 37 576 24C576 11 565 0 552 0H24C11 0 0 11 0 24C0 37 11 48 24 48H32V464H24C11 464 0 475 0 488C0 501 11 512 24 512H552C565 512 576 501 576 488C576 475 565 464 552 464ZM496 464H336V384H366C376 384 384 375 382 366C374 321 335 288 288 288S202 321 194 366C192 375 200 384 210 384H240V464H80V48H496V464ZM141 256H179C186 256 192 250 192 243V205C192 198 186 192 179 192H141C134 192 128 198 128 205V243C128 250 134 256 141 256ZM141 160H179C186 160 192 154 192 147V109C192 102 186 96 179 96H141C134 96 128 102 128 109V147C128 154 134 160 141 160Z"]
  };
  var faHourglass = {
    prefix: 'far',
    iconName: 'hourglass',
    icon: [384, 512, [], "f254", "M360 464H352V445C352 404 336 366 307 338L226 256L307 174C336 146 352 108 352 67V48H360C373 48 384 37 384 24S373 0 360 0H24C11 0 0 11 0 24S11 48 24 48H32V69C32 108 47 145 73 173L151 256L73 339C47 367 32 404 32 443V464H24C11 464 0 475 0 488S11 512 24 512H360C373 512 384 501 384 488S373 464 360 464ZM99 128C87 111 80 90 80 69V48H304V67C304 89 297 110 284 128H99ZM99 384C102 380 105 375 108 371L188 286L274 371C277 375 281 380 284 384H99Z"]
  };
  var faHourglassEmpty = {
    prefix: 'far',
    iconName: 'hourglass-empty',
    icon: [384, 512, [], "f252", "M360 464H352V445C352 404 336 366 307 338L226 256L307 174C336 146 352 108 352 67V48H360C373 48 384 37 384 24S373 0 360 0H24C11 0 0 11 0 24S11 48 24 48H32V69C32 108 47 145 73 173L151 256L73 339C47 367 32 404 32 443V464H24C11 464 0 475 0 488S11 512 24 512H360C373 512 384 501 384 488S373 464 360 464ZM108 141C90 121 80 96 80 69V48H304V67C304 95 293 121 274 141L188 226L108 141ZM304 464H80V443C80 416 90 391 108 371L188 286L274 371C293 391 304 417 304 445V464Z"]
  };
  var faHourglassEnd = {
    prefix: 'far',
    iconName: 'hourglass-end',
    icon: [384, 512, [], "f253", "M360 464H352V445C352 404 336 366 307 338L226 256L307 174C336 146 352 108 352 67V48H360C373 48 384 37 384 24S373 0 360 0H24C11 0 0 11 0 24S11 48 24 48H32V69C32 108 47 145 73 173L151 256L73 339C47 367 32 404 32 443V464H24C11 464 0 475 0 488S11 512 24 512H360C373 512 384 501 384 488S373 464 360 464ZM108 141C90 121 80 96 80 69V48H304V67C304 95 293 121 274 141L188 226L108 141Z"]
  };
  var faHourglassStart = {
    prefix: 'far',
    iconName: 'hourglass-start',
    icon: [384, 512, [], "f251", "M360 464H352V445C352 404 336 366 307 338L226 256L307 174C336 146 352 108 352 67V48H360C373 48 384 37 384 24S373 0 360 0H24C11 0 0 11 0 24S11 48 24 48H32V69C32 108 47 145 73 173L151 256L73 339C47 367 32 404 32 443V464H24C11 464 0 475 0 488S11 512 24 512H360C373 512 384 501 384 488S373 464 360 464ZM304 464H80V443C80 416 90 391 108 371L188 286L274 371C293 391 304 417 304 445V464Z"]
  };
  var faHouse = {
    prefix: 'far',
    iconName: 'house',
    icon: [576, 512, [], "e00d", "M208 210V290C208 312 226 330 248 330H328C350 330 368 312 368 290V210C368 188 350 170 328 170H248C226 170 208 188 208 210ZM256 218H320V282H256V218ZM568 224L512 177V50C512 37 501 26 488 26S464 37 464 50V136L304 0C295 -8 281 -8 272 0L8 224C-2 233 -3 248 6 258C14 268 29 269 40 261L64 240V442C64 478 93 506 128 506H448C483 506 512 478 512 442V240L536 261C541 264 547 266 552 266C559 266 566 263 570 258C579 248 578 233 568 224ZM464 442C464 451 457 458 448 458H128C119 458 112 451 112 442V202C112 201 112 201 111 200L288 50L464 199V442Z"]
  };
  var faHouseCrack = {
    prefix: 'far',
    iconName: 'house-crack',
    icon: [576, 512, [], "f6f1", "M568 224L512 177V50C512 37 501 26 488 26S464 37 464 50V136L304 0C295 -8 281 -8 272 0L8 224C-2 233 -3 248 6 258C14 268 29 269 40 261L64 240V442C64 478 93 506 128 506H200C213 506 224 496 224 482S213 458 200 458H128C119 458 112 451 112 442V202C112 201 112 201 111 200L288 50L464 199V442C464 451 457 458 448 458H376C363 458 352 469 352 482S363 506 376 506H448C483 506 512 478 512 442V240L536 261C541 264 547 266 552 266C559 266 566 263 570 258C579 248 578 233 568 224ZM264 256C254 248 239 248 230 258C221 268 222 283 232 292L291 345L233 392C223 399 221 413 228 424L276 496C281 503 288 506 296 506C301 506 305 505 309 502C320 495 323 480 316 469L280 415L343 365C348 361 352 354 352 347C352 340 349 333 344 329L264 256Z"]
  };
  var faHouseDay = {
    prefix: 'far',
    iconName: 'house-day',
    icon: [640, 512, [], "e00e", "M352 304V368C352 377 359 384 368 384H432C441 384 448 377 448 368V304C448 295 441 288 432 288H368C359 288 352 295 352 304ZM632 294L576 244V152C576 139 565 128 552 128S528 139 528 152V202L416 102C407 94 393 94 384 102L168 294C158 303 157 318 166 328C175 338 190 339 200 330L224 309V464C224 490 246 512 272 512H528C554 512 576 490 576 464V309L600 330C605 334 610 336 616 336C623 336 629 333 634 328C643 318 642 303 632 294ZM528 464H272V266L400 152L528 266V464ZM128 176C128 202 150 224 176 224S224 202 224 176S202 128 176 128S128 150 128 176ZM122 223C122 223 122 223 121 222C119 220 117 217 115 214C114 213 114 211 113 210C112 208 110 205 109 202C108 200 108 198 107 196C107 194 106 192 105 190C105 185 104 181 104 176C104 136 136 104 176 104S248 136 248 176C248 178 248 179 247 181L273 158L303 64C305 59 304 55 300 52C297 49 293 47 288 49L219 72L187 7C185 2 181 0 176 0S167 2 165 7L133 72L64 49C59 47 55 48 52 52C48 55 47 59 49 64L72 133L7 165C2 167 0 171 0 176S2 185 7 187L72 219L49 288C47 293 48 297 52 301C55 304 59 305 64 303L139 279C141 276 144 273 147 270L172 248C152 246 135 237 122 223Z"]
  };
  var faHouseFlood = {
    prefix: 'far',
    iconName: 'house-flood',
    icon: [576, 512, [], "f74f", "M556 459C535 455 514 443 497 425C488 416 472 416 463 425C443 446 414 458 384 458S325 446 305 425C296 416 280 416 271 425C251 446 222 458 192 458C160 458 124 445 105 425C96 416 80 416 71 425C52 445 39 455 20 459C7 461 -2 473 0 486C3 500 15 508 28 506C54 501 73 489 89 475C117 494 155 506 192 506C227 506 261 495 288 474C342 515 425 515 480 474C500 491 524 502 548 506C549 506 551 506 552 506C563 506 574 498 576 486C578 473 569 461 556 459ZM40 261L64 240V346C64 360 75 370 88 370S112 360 112 346V202C112 201 112 201 111 200L288 50L464 199V346C464 360 475 370 488 370C501 370 512 360 512 346V240L536 261C541 264 547 266 552 266C559 266 566 263 570 258C579 248 578 233 568 224L512 177V50C512 37 501 26 488 26C475 26 464 37 464 50V136L304 0C295 -8 281 -8 272 0L8 224C-2 233 -3 248 6 258C14 268 29 269 40 261ZM248 170C226 170 208 188 208 210V290C208 312 226 330 248 330H328C350 330 368 312 368 290V210C368 188 350 170 328 170H248ZM320 282H256V218H320V282Z"]
  };
  var faHouseHeart = {
    prefix: 'far',
    iconName: 'house-heart',
    icon: [576, 512, [], "e148", "M280 234C262 216 231 213 211 229C187 248 186 283 207 304L280 375C284 379 292 379 296 375L369 304C390 283 389 248 365 229C345 213 314 216 295 234L288 241L280 234ZM568 224L512 177V50C512 37 501 26 488 26S464 37 464 50V136L304 0C295 -8 281 -8 272 0L8 224C-2 233 -3 248 6 258C14 268 29 269 40 261L64 240V442C64 478 93 506 128 506H448C483 506 512 478 512 442V240L536 261C541 264 547 266 552 266C559 266 566 263 570 258C579 248 578 233 568 224ZM464 442C464 451 457 458 448 458H128C119 458 112 451 112 442V202C112 201 112 201 111 200L288 50L464 199V442Z"]
  };
  var faHouseLaptop = {
    prefix: 'far',
    iconName: 'house-laptop',
    icon: [640, 512, [], "e066", "M616 464H592V312C592 290 574 272 552 272H344C322 272 304 290 304 312V464H280C267 464 256 475 256 488S267 512 280 512H616C629 512 640 501 640 488S629 464 616 464ZM544 464H352V320H544V464ZM208 192C199 192 192 199 192 208V272C192 281 199 288 208 288H272C281 288 288 281 288 272V208C288 199 281 192 272 192H208ZM272 368H112V170L240 56L368 170V240H416V213L440 234C445 238 450 240 456 240C463 240 469 237 474 232C483 222 482 207 472 198L416 148V56C416 43 405 32 392 32S368 43 368 56V106L256 6C247 -2 233 -2 224 6L8 198C-2 207 -3 222 6 232C15 242 30 243 40 234L64 213V368C64 395 86 416 112 416H272V368Z"]
  };
  var faHouseMedical = {
    prefix: 'far',
    iconName: 'house-medical',
    icon: [576, 512, [], "f7f2", "M256 202V250H208C199 250 192 258 192 266V298C192 307 199 314 208 314H256V362C256 371 263 378 272 378H304C313 378 320 371 320 362V314H368C377 314 384 307 384 298V266C384 258 377 250 368 250H320V202C320 194 313 186 304 186H272C263 186 256 194 256 202ZM568 224L512 177V50C512 37 501 26 488 26S464 37 464 50V136L304 0C295 -8 281 -8 272 0L8 224C-2 233 -3 248 6 258C14 268 29 269 40 261L64 240V442C64 478 93 506 128 506H448C483 506 512 478 512 442V240L536 261C541 264 547 266 552 266C559 266 566 263 570 258C579 248 578 233 568 224ZM464 442C464 451 457 458 448 458H128C119 458 112 451 112 442V202C112 201 112 201 111 200L288 50L464 199V442Z"]
  };
  var faHouseNight = {
    prefix: 'far',
    iconName: 'house-night',
    icon: [640, 512, [], "e010", "M112 224C146 224 178 209 199 182C200 181 201 178 199 177C198 175 196 174 194 174C152 182 110 159 95 118C80 78 97 33 134 12C136 10 137 8 137 6C136 4 135 2 133 2C126 1 119 0 112 0C50 0 0 50 0 112S50 224 112 224ZM117 363L101 323C100 321 98 320 96 320C94 320 92 321 91 323L75 363L35 379C33 380 32 382 32 384S33 388 35 389L75 405L91 445C92 447 94 448 96 448C98 448 100 447 101 445L117 405L157 389C159 388 160 386 160 384S159 380 157 379L117 363ZM195 69L235 85L251 125C252 127 254 128 256 128C258 128 260 127 261 125L277 85L317 69C319 68 320 66 320 64S319 60 317 59L277 43L261 3C260 1 258 0 256 0C254 0 252 1 251 3L235 43L195 59C193 60 192 62 192 64S193 68 195 69ZM632 294L576 244V152C576 139 565 128 552 128S528 139 528 152V202L416 102C407 94 393 94 384 102L168 294C158 303 157 318 166 328C175 338 190 339 200 330L224 309V464C224 490 246 512 272 512H528C554 512 576 490 576 464V309L600 330C605 334 610 336 616 336C623 336 629 333 634 328C643 318 642 303 632 294ZM528 464H272V266L400 152L528 266V464ZM352 304V368C352 377 359 384 368 384H432C441 384 448 377 448 368V304C448 295 441 288 432 288H368C359 288 352 295 352 304Z"]
  };
  var faHousePersonLeave = {
    prefix: 'far',
    iconName: 'house-person-leave',
    icon: [640, 512, [], "e00f", "M363 390L365 387L372 368H112V170L240 56L344 148C354 138 367 130 381 124L387 122L256 6C247 -2 233 -2 224 6L8 198C-2 207 -3 222 6 232C15 242 30 243 40 234L64 213V376C64 398 82 416 104 416H337L363 390ZM176 192C167 192 160 199 160 208V272C160 281 167 288 176 288H240C249 288 256 281 256 272V208C256 199 249 192 240 192H176ZM528 96C554 96 576 74 576 48S554 0 528 0S480 22 480 48S502 96 528 96ZM633 271L603 242C603 241 602 240 601 239L589 200C574 157 534 128 489 128C454 128 436 137 393 154C372 162 355 178 345 199L331 230C317 258 360 279 374 250L388 220C393 210 401 203 411 199C432 190 444 185 455 182L435 261C431 280 436 300 450 315L529 388C535 394 539 401 541 409L560 494C565 510 580 513 589 512C602 509 610 496 607 483L588 398C584 381 575 365 562 353L508 304L534 199C541 209 541 212 556 254C559 263 563 270 570 277L599 306C621 326 655 294 633 271ZM422 331L394 399C392 404 389 409 385 412L327 471C318 480 318 496 327 505C336 514 352 514 361 505L419 446C428 438 434 428 439 417L458 367C449 358 424 333 422 331Z"]
  };
  var faHousePersonReturn = {
    prefix: 'far',
    iconName: 'house-person-return',
    icon: [640, 512, [], "e011", "M112 170L240 56L356 159C365 146 376 134 389 124L256 6C247 -2 233 -2 224 6L8 198C-2 207 -3 222 6 232C15 242 30 243 40 234L64 213V376C64 398 82 416 104 416H336L341 391C343 383 346 375 350 368H112V170ZM176 192C167 192 160 199 160 208V272C160 281 167 288 176 288H240C249 288 256 281 256 272V208C256 199 249 192 240 192H176ZM432 96C458 96 480 74 480 48S458 0 432 0S384 22 384 48S406 96 432 96ZM525 261L505 182C516 185 528 190 549 199C559 203 567 210 572 220L586 250C600 279 643 258 629 230L615 199C605 178 588 162 567 154C524 137 506 128 471 128C426 128 386 157 371 200L359 239C358 240 358 241 357 242L327 271C305 294 339 326 361 306L390 277C397 270 401 263 404 254C419 212 419 209 426 199L452 304L398 353C385 365 376 381 372 398L353 483C350 496 358 509 371 512C380 513 395 510 400 494L419 409C421 401 425 394 431 388L510 315C524 300 529 280 525 261ZM633 471L575 412C571 408 568 404 566 399L538 331C536 333 511 358 502 367L521 417C526 428 532 438 541 446L599 505C608 514 624 514 633 505C642 496 642 480 633 471Z"]
  };
  var faHouseSignal = {
    prefix: 'far',
    iconName: 'house-signal',
    icon: [640, 512, [], "e012", "M24 224C11 224 0 235 0 248S11 272 24 272C143 272 240 369 240 488C240 501 251 512 264 512S288 501 288 488C288 342 170 224 24 224ZM24 320C11 320 0 331 0 344S11 368 24 368C90 368 144 422 144 488C144 501 155 512 168 512S192 501 192 488C192 395 117 320 24 320ZM24 416C11 416 0 427 0 440S11 464 24 464C37 464 48 475 48 488C48 501 59 512 72 512S96 501 96 488C96 448 64 416 24 416ZM432 288C441 288 448 281 448 272V208C448 199 441 192 432 192H368C359 192 352 199 352 208V272C352 281 359 288 368 288H432ZM632 198L576 148V56C576 43 565 32 552 32S528 43 528 56V106L416 6C407 -2 393 -2 384 6L168 198C158 207 157 222 166 232C175 242 190 243 200 234L224 213V248C224 261 235 272 248 272C261 272 272 261 272 248V170L400 56L528 170V368H344C331 368 320 379 320 392V392C320 405 331 416 344 416H528C554 416 576 394 576 368V213L600 234C605 238 610 240 616 240C623 240 629 237 634 232C643 222 642 207 632 198Z"]
  };
  var faHouseUser = {
    prefix: 'far',
    iconName: 'house-user',
    icon: [576, 512, [], "e065", "M568 224L512 177V50C512 37 501 26 488 26C475 26 464 37 464 50V136L304 0C295 -8 281 -8 272 0L8 224C-2 233 -3 248 6 258C14 268 29 269 40 261L64 240V442C64 478 93 506 128 506H448C483 506 512 478 512 442V240L536 261C541 264 547 266 552 266C559 266 566 263 570 258C579 248 578 233 568 224ZM464 442C464 451 457 458 448 458H128C119 458 112 451 112 442V202C112 201 112 200 111 200L288 50L464 199V442ZM224 218C224 254 253 282 288 282S352 254 352 218C352 183 323 154 288 154S224 183 224 218ZM256 314C212 314 176 350 176 394C176 403 183 410 192 410H384C393 410 400 403 400 394C400 350 364 314 320 314H256Z"]
  };
  var faHryvniaSign = {
    prefix: 'far',
    iconName: 'hryvnia-sign',
    icon: [384, 512, [], "f6f2", "M384 296C384 309 373 320 360 320H147L112 346C100 355 93 369 93 384C93 411 114 432 141 432H198C230 432 260 423 286 405C297 398 312 401 320 412C327 423 324 438 313 445C279 468 239 480 198 480H141C88 480 45 437 45 384C45 360 54 337 70 320H24C11 320 0 309 0 296S11 272 24 272H131L195 224H24C11 224 0 213 0 200S11 176 24 176H259L272 166C284 157 291 143 291 128C291 101 270 80 243 80H186C154 80 124 89 98 107C87 114 72 111 64 100C57 89 60 74 71 67C105 44 145 32 186 32H243C296 32 339 75 339 128C339 145 334 161 325 176H360C373 176 384 187 384 200S373 224 360 224H275L211 272H360C373 272 384 283 384 296Z"]
  };
  var faHurricane = {
    prefix: 'far',
    iconName: 'hurricane',
    icon: [448, 512, [], "f751", "M208 96C195 96 184 107 184 120S195 144 208 144C296 144 368 216 368 304S296 464 208 464C195 464 184 475 184 488S195 512 208 512C323 512 416 419 416 304S323 96 208 96ZM248 392C248 379 237 368 224 368C136 368 64 296 64 208S136 48 224 48C237 48 248 37 248 24S237 0 224 0C109 0 16 93 16 208S109 416 224 416C237 416 248 405 248 392ZM240 256C240 238 226 224 208 224S176 238 176 256C176 274 190 288 208 288S240 274 240 256Z"]
  };
  var faI = {
    prefix: 'far',
    iconName: 'i',
    icon: [320, 512, [], "e149", "M320 448C320 466 306 480 288 480H32C14 480 0 466 0 448S14 416 32 416H128V96H32C14 96 0 82 0 64S14 32 32 32H288C306 32 320 46 320 64S306 96 288 96H192V416H288C306 416 320 430 320 448Z"]
  };
  var faICursor = {
    prefix: 'far',
    iconName: 'i-cursor',
    icon: [256, 512, [], "f246", "M256 488C256 501 245 512 232 512C189 512 151 491 128 458C105 491 67 512 24 512C11 512 0 501 0 488S11 464 24 464C68 464 104 428 104 384V280H72C59 280 48 269 48 256S59 232 72 232H104V128C104 84 68 48 24 48C11 48 0 37 0 24S11 0 24 0C67 0 105 21 128 54C151 21 189 0 232 0C245 0 256 11 256 24S245 48 232 48C188 48 152 84 152 128V232H184C197 232 208 243 208 256S197 280 184 280H152V384C152 428 188 464 232 464C245 464 256 475 256 488Z"]
  };
  var faIceCream = {
    prefix: 'far',
    iconName: 'ice-cream',
    icon: [448, 512, [], "f810", "M381 129C367 56 302 0 224 0S81 56 67 129C26 136 -3 173 0 215C4 256 38 288 80 288H81L174 480C183 500 203 512 224 512S265 500 274 480L367 288H368C410 288 444 256 448 215S422 136 381 129ZM231 459C227 467 221 467 217 459L134 288H314L231 459ZM368 240H80C62 240 48 226 48 208C48 192 59 179 75 177L108 171L114 139C124 86 170 48 224 48S324 86 334 138L340 171L373 177C389 179 400 192 400 208C400 226 386 240 368 240Z"]
  };
  var faIceSkate = {
    prefix: 'far',
    iconName: 'ice-skate',
    icon: [576, 512, [], "f7ac", "M552 416L552 416C539 416 528 427 528 440V440C528 453 517 464 504 464H432V416H448C483 416 512 387 512 352V299C512 255 482 217 439 206L352 184V24C352 11 341 0 328 0H328C315 0 304 11 304 24V32H204C196 32 188 34 181 37L52 88C40 93 32 105 32 118V352C32 387 61 416 96 416V464H24C11 464 0 475 0 488V488C0 501 11 512 24 512H512C547 512 576 483 576 448V440C576 427 565 416 552 416ZM80 352V129L198 81C200 80 202 80 204 80H304V128H240C231 128 224 135 224 144V144C224 153 231 160 240 160H304V192H240C231 192 224 199 224 208V208C224 217 231 224 240 224H314L428 252C449 258 464 277 464 299V352C464 361 457 368 448 368H96C87 368 80 361 80 352ZM144 416H384V464H144V416Z"]
  };
  var faIcicles = {
    prefix: 'far',
    iconName: 'icicles',
    icon: [512, 512, [], "f7ad", "M480 0H32C11 0 -5 21 1 41L81 277C83 284 90 288 96 288S109 284 111 277L140 190L176 372C178 380 185 384 192 384S206 380 207 372L246 181L273 277C275 284 281 288 288 288C294 288 301 284 303 277L341 142L400 499C402 508 409 512 416 512C423 512 430 508 432 499L511 38C515 18 500 0 480 0ZM96 171L54 48H137L96 171ZM199 171L192 206L187 181L160 48H224L199 171ZM295 129L288 153L259 48H318L295 129ZM417 304L389 134L375 48H461L417 304Z"]
  };
  var faIcons = {
    prefix: 'far',
    iconName: 'icons',
    icon: [512, 512, [], "f86d", "M144 344C118 344 96 365 96 392C96 418 118 440 144 440S192 418 192 392C192 365 170 344 144 344ZM102 213C109 220 118 224 128 224C138 224 147 220 154 213L233 134C249 119 257 97 256 75C255 52 244 32 227 18C199 -6 158 -5 128 17C98 -5 57 -6 29 18C12 32 1 52 0 75C-1 97 7 119 23 135L102 213ZM59 54C74 43 93 49 103 58L128 83L153 58C165 46 184 44 197 54C206 62 216 84 199 101L128 171L57 101C48 92 41 70 59 54ZM397 360L430 290C434 282 433 272 428 265C423 258 414 254 406 255C397 256 390 262 386 270L322 408H432L395 476C390 484 391 493 395 500C400 508 408 512 417 512C425 512 433 507 437 499L512 360H397ZM256 288H229L221 273C217 263 207 256 196 256H92C81 256 70 263 66 273L59 288H32C14 288 0 302 0 320V480C0 497 14 512 32 512H256C274 512 288 497 288 480V320C288 302 274 288 256 288ZM240 464H48V336H89L105 304H183L199 336H240V464ZM352 208V68L464 51V130C459 128 453 128 448 128C413 128 384 149 384 176S413 224 448 224S512 202 512 176V32C512 14 498 0 482 0C481 0 479 0 478 0L329 23C315 25 304 39 304 55V162C299 160 293 160 288 160C252 160 224 181 224 208C224 235 252 256 288 256S352 234 352 208Z"]
  };
  var faIdBadge = {
    prefix: 'far',
    iconName: 'id-badge',
    icon: [384, 512, [], "f2c1", "M320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H128V64C128 82 142 96 160 96H224C242 96 256 82 256 64V48H320C329 48 336 55 336 64V448ZM192 288C227 288 256 259 256 224S227 160 192 160C157 160 128 189 128 224S157 288 192 288ZM224 320H160C116 320 80 356 80 400C80 409 87 416 96 416H288C297 416 304 409 304 400C304 356 268 320 224 320Z"]
  };
  var faIdCard = {
    prefix: 'far',
    iconName: 'id-card',
    icon: [576, 512, [], "f2c2", "M368 344H464C477 344 488 333 488 320S477 296 464 296H368C355 296 344 307 344 320S355 344 368 344ZM208 320C243 320 272 291 272 256C272 221 243 192 208 192S144 221 144 256C144 291 173 320 208 320ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM528 416C528 425 521 432 512 432H320C320 388 284 352 240 352H176C132 352 96 388 96 432H64C55 432 48 425 48 416V160H528V416ZM368 264H464C477 264 488 253 488 240S477 216 464 216H368C355 216 344 227 344 240S355 264 368 264Z"]
  };
  var faIdCardClip = {
    prefix: 'far',
    iconName: 'id-card-clip',
    icon: [576, 512, [], "f47f", "M256 128H320C338 128 352 114 352 96V32C352 14 338 0 320 0H256C238 0 224 14 224 32V96C224 114 238 128 256 128ZM288 304C323 304 352 275 352 240C352 205 323 176 288 176S224 205 224 240C224 275 253 304 288 304ZM512 64H384V112H512C521 112 528 119 528 128V448C528 457 521 464 512 464H64C55 464 48 457 48 448V128C48 119 55 112 64 112H192V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H512C547 512 576 483 576 448V128C576 93 547 64 512 64ZM192 432H384C393 432 400 425 400 416C400 372 364 336 320 336H256C212 336 176 372 176 416C176 425 183 432 192 432Z"]
  };
  var faIgloo = {
    prefix: 'far',
    iconName: 'igloo',
    icon: [576, 512, [], "f7ae", "M288 32C128 32 0 160 0 320V448C0 466 14 480 32 480H160C178 480 192 466 192 448V387C192 334 233 289 286 288C287 288 287 288 288 288C341 288 384 331 384 384V448C384 466 398 480 416 480H544C562 480 576 466 576 448V320C576 160 448 32 288 32ZM432 432V384C432 373 430 362 428 352H528V432H432ZM288 240L285 240C231 241 184 274 161 320H128V192H448V320H416C393 273 344 240 288 240ZM144 432H48V352H149C146 363 144 375 144 387V432ZM288 80C299 80 310 81 320 82V160H108C152 111 216 80 288 80ZM352 89C398 101 438 126 468 160H352V89ZM96 192V320H48C48 273 61 229 84 192H96ZM480 320V192H492C515 229 528 273 528 320H480Z"]
  };
  var faImage = {
    prefix: 'far',
    iconName: 'image',
    icon: [512, 512, [], "f03e", "M152 120C126 120 104 142 104 168S126 216 152 216S200 194 200 168S178 120 152 120ZM448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM464 409L327 223C324 219 318 216 312 216C306 216 300 219 297 223L190 368L153 322C150 318 144 315 138 315C132 315 127 318 123 322L48 416C48 416 48 416 48 416V96C48 87 55 80 64 80H448C457 80 464 87 464 96V409Z"]
  };
  var faImageLandscape = {
    prefix: 'far',
    iconName: 'image-landscape',
    icon: [576, 512, [], "e14a", "M512 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H512C547 448 576 419 576 384V128C576 93 547 64 512 64ZM528 384C528 393 521 400 512 400H485L353 202C349 196 342 192 335 192C328 192 321 196 317 202L234 327L204 286C200 281 193 277 187 277S173 281 169 286L86 400H64C55 400 48 393 48 384V128C48 119 55 112 64 112H512C521 112 528 119 528 128V384ZM176 160C158 160 144 174 144 192S158 224 176 224C194 224 208 210 208 192S194 160 176 160Z"]
  };
  var faImagePolaroid = {
    prefix: 'far',
    iconName: 'image-polaroid',
    icon: [448, 512, [], "f8c4", "M112 112C94 112 80 126 80 144S94 176 112 176C130 176 144 162 144 144S130 112 112 112ZM448 96C448 61 419 32 384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416C448 349 448 165 448 96ZM400 416C400 425 393 432 384 432H64C55 432 48 425 48 416V368H400V416ZM400 320H371L275 175C272 171 267 168 261 168C256 168 251 171 248 175L185 269L163 239C160 234 155 232 150 232C145 232 140 234 137 239L78 320H48V96C48 87 55 80 64 80H384C393 80 400 87 400 96V320Z"]
  };
  var faImagePolaroidUser = {
    prefix: 'far',
    iconName: 'image-polaroid-user',
    icon: [448, 512, [], "e14b", "M384 32H64C29 32 0 61 0 96V424C0 459 29 488 64 488H384C419 488 448 459 448 424C448 413 448 96 448 96C448 61 419 32 384 32ZM400 424C400 433 393 440 384 440H64C55 440 48 433 48 424V376H400V424ZM400 328H332C322 296 292 272 256 272H192C156 272 126 296 116 328H48V96C48 87 55 80 64 80H384C393 80 400 87 400 96V328ZM224 112C189 112 160 141 160 176S189 240 224 240S288 211 288 176S259 112 224 112Z"]
  };
  var faImagePortrait = {
    prefix: 'far',
    iconName: 'image-portrait',
    icon: [384, 512, [], "f3e0", "M192 256C227 256 256 227 256 192S227 128 192 128S128 157 128 192S157 256 192 256ZM320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM336 448C336 457 329 464 320 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H320C329 48 336 55 336 64V448ZM224 288H160C116 288 80 324 80 368C80 377 87 384 96 384H288C297 384 304 377 304 368C304 324 268 288 224 288Z"]
  };
  var faImageUser = {
    prefix: 'far',
    iconName: 'image-user',
    icon: [512, 512, [], "e14c", "M448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H448C457 80 464 87 464 96V416ZM256 256C291 256 320 227 320 192S291 128 256 128S192 157 192 192S221 256 256 256ZM288 288H224C180 288 144 324 144 368C144 377 151 384 160 384H352C361 384 368 377 368 368C368 324 332 288 288 288Z"]
  };
  var faImages = {
    prefix: 'far',
    iconName: 'images',
    icon: [576, 512, [], "f302", "M512 32H160C125 32 96 61 96 96V320C96 355 125 384 160 384H512C547 384 576 355 576 320V96C576 61 547 32 512 32ZM528 320C528 329 521 336 512 336H496L387 175C384 171 379 168 373 168C368 168 363 171 360 175L297 269L275 239C272 234 267 232 262 232C257 232 252 234 249 239L176 336H160C151 336 144 329 144 320V96C144 87 151 80 160 80H512C521 80 528 87 528 96V320ZM48 400V96C22 96 0 118 0 144V416C0 451 29 480 64 480H432C458 480 480 458 480 432H80C62 432 48 418 48 400ZM224 112C206 112 192 126 192 144S206 176 224 176C242 176 256 162 256 144S242 112 224 112Z"]
  };
  var faImagesUser = {
    prefix: 'far',
    iconName: 'images-user',
    icon: [576, 512, [], "e14d", "M512 32H160C125 32 96 61 96 96V320C96 355 125 384 160 384H512C547 384 576 355 576 320V96C576 61 547 32 512 32ZM528 320C528 329 521 336 512 336H446C439 299 407 272 368 272H304C265 272 233 299 226 336H160C151 336 144 329 144 320V96C144 87 151 80 160 80H512C521 80 528 87 528 96V320ZM80 432H480C480 458 458 480 432 480H64C29 480 0 451 0 416V144C0 118 22 96 48 96V400C48 418 62 432 80 432ZM400 176C400 211 371 240 336 240S272 211 272 176S301 112 336 112S400 141 400 176Z"]
  };
  var faInbox = {
    prefix: 'far',
    iconName: 'inbox',
    icon: [512, 512, [], "f01c", "M508 305L447 56C443 42 431 32 416 32H96C81 32 69 42 65 56L4 305C1 315 0 325 0 336V416C0 451 29 480 64 480H448C483 480 512 451 512 416V336C512 325 511 315 508 305ZM109 80H403L455 288H368C359 288 351 293 347 301L321 352H191L165 301C161 293 153 288 144 288H57L109 80ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V336H129L155 387C159 395 167 400 176 400H336C345 400 353 395 357 387L383 336H464V416Z"]
  };
  var faInboxFull = {
    prefix: 'far',
    iconName: 'inbox-full',
    icon: [512, 512, [], "e14e", "M508 305L447 56C443 42 431 32 416 32H96C81 32 69 42 65 56L4 305C1 315 0 325 0 336V416C0 451 29 480 64 480H448C483 480 512 451 512 416V336C512 325 511 315 508 305ZM109 80H403L455 288H368C359 288 351 293 347 301L321 352H191L165 301C161 293 153 288 144 288H57L109 80ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V336H129L155 387C159 395 167 400 176 400H336C345 400 353 395 357 387L383 336H464V416ZM184 176H328C341 176 352 165 352 152S341 128 328 128H184C171 128 160 139 160 152S171 176 184 176ZM360 256C373 256 384 245 384 232S373 208 360 208H152C139 208 128 219 128 232S139 256 152 256H360Z"]
  };
  var faInboxIn = {
    prefix: 'far',
    iconName: 'inbox-in',
    icon: [512, 512, [], "f310", "M464 320H368C359 320 351 325 347 333L321 384H191L165 333C161 325 153 320 144 320H32C14 320 0 334 0 352V448C0 483 29 512 64 512H448C483 512 512 483 512 448V368C512 342 490 320 464 320ZM464 448C464 457 457 464 448 464H64C55 464 48 457 48 448V368H129L155 419C159 427 167 432 176 432H336C345 432 353 427 357 419L383 368H464V448ZM238 312C243 317 249 320 256 320S269 317 274 312L378 200C387 191 386 175 376 166C367 157 351 158 342 168L280 235V24C280 11 269 0 256 0S232 11 232 24V235L170 168C161 158 145 157 136 166C126 175 125 191 134 200L238 312Z"]
  };
  var faInboxOut = {
    prefix: 'far',
    iconName: 'inbox-out',
    icon: [512, 512, [], "f311", "M464 313H368C359 313 351 318 347 326L321 377H191L165 326C161 318 153 313 144 313H32C14 313 0 327 0 345V441C0 476 29 505 64 505H448C483 505 512 476 512 441V361C512 334 490 313 464 313ZM464 441C464 450 457 457 448 457H64C55 457 48 450 48 441V361H129L155 411C159 420 167 425 176 425H336C345 425 353 420 357 411L383 361H464V441ZM170 145L232 78V289C232 302 243 313 256 313S280 302 280 289V78L342 145C347 150 354 153 360 153C366 153 372 151 376 146C386 137 387 122 378 112L274 0C264 -9 248 -9 238 0L134 112C125 122 126 137 136 146C145 155 161 155 170 145Z"]
  };
  var faInboxes = {
    prefix: 'far',
    iconName: 'inboxes',
    icon: [512, 512, [], "e14f", "M501 83L446 17C437 6 424 0 410 0H102C88 0 75 6 66 17L11 83C4 91 0 102 0 113V224C0 259 29 288 64 288H448C483 288 512 259 512 224V113C512 102 508 91 501 83ZM102 48H410L450 96H368C359 96 351 101 347 109L321 160H191L165 109C161 101 153 96 144 96H62L102 48ZM464 224C464 233 457 240 448 240H64C55 240 48 233 48 224V144H129L155 195C159 203 167 208 176 208H336C345 208 353 203 357 195L383 144H464V224ZM464 320H368C359 320 351 325 347 333L321 384H191L165 333C161 325 153 320 144 320H32C14 320 0 334 0 352V448C0 483 29 512 64 512H448C483 512 512 483 512 448V368C512 342 490 320 464 320ZM464 448C464 457 457 464 448 464H64C55 464 48 457 48 448V368H129L155 419C159 427 167 432 176 432H336C345 432 353 427 357 419L383 368H464V448Z"]
  };
  var faIndent = {
    prefix: 'far',
    iconName: 'indent',
    icon: [448, 512, [], "f03c", "M9 350C11 351 14 352 16 352C20 352 23 351 26 348L122 268C126 265 128 261 128 256S126 247 122 244L26 164C21 160 15 159 9 162C4 164 0 170 0 176V336C0 342 4 348 9 350ZM424 424H24C11 424 0 435 0 448C0 461 11 472 24 472H424C437 472 448 461 448 448C448 435 437 424 424 424ZM24 88H424C437 88 448 77 448 64C448 51 437 40 424 40H24C11 40 0 51 0 64C0 77 11 88 24 88ZM424 168H216C203 168 192 179 192 192C192 205 203 216 216 216H424C437 216 448 205 448 192C448 179 437 168 424 168ZM424 296H216C203 296 192 307 192 320C192 333 203 344 216 344H424C437 344 448 333 448 320C448 307 437 296 424 296Z"]
  };
  var faIndianRupeeSign = {
    prefix: 'far',
    iconName: 'indian-rupee-sign',
    icon: [320, 512, [], "e150", "M320 176C320 189 309 200 296 200H246C234 268 175 320 104 320H99L262 436C273 444 275 459 268 470C263 477 255 480 248 480C243 480 238 479 234 476L10 316C2 309 -2 299 1 289C4 279 14 272 24 272H104C149 272 186 241 197 200H24C11 200 0 189 0 176S11 152 24 152H197C186 111 149 80 104 80H24C11 80 0 69 0 56S11 32 24 32H296C309 32 320 43 320 56S309 80 296 80H211C228 100 241 125 246 152H296C309 152 320 163 320 176Z"]
  };
  var faIndustry = {
    prefix: 'far',
    iconName: 'industry',
    icon: [512, 512, [], "f275", "M475 132L336 220V152C336 133 315 122 299 132L160 220V80C160 54 138 32 112 32H48C22 32 0 54 0 80V432C0 458 22 480 48 480H464C490 480 512 458 512 432V152C512 133 491 122 475 132ZM464 432H48V80H112V264C112 283 133 294 149 284L288 196V264C288 283 309 294 325 284L464 196V432Z"]
  };
  var faIndustryWindows = {
    prefix: 'far',
    iconName: 'industry-windows',
    icon: [512, 512, [], "f3b3", "M475 132L336 220V152C336 133 315 122 299 132L160 220V80C160 54 138 32 112 32H48C22 32 0 54 0 80V432C0 458 22 480 48 480H464C490 480 512 458 512 432V152C512 133 491 122 475 132ZM464 432H48V80H112V264C112 283 133 294 149 284L288 196V264C288 283 309 294 325 284L464 196V432ZM160 320H112C103 320 96 327 96 336V384C96 393 103 400 112 400H160C169 400 176 393 176 384V336C176 327 169 320 160 320ZM280 320H232C223 320 216 327 216 336V384C216 393 223 400 232 400H280C289 400 296 393 296 384V336C296 327 289 320 280 320ZM352 400H400C409 400 416 393 416 384V336C416 327 409 320 400 320H352C343 320 336 327 336 336V384C336 393 343 400 352 400Z"]
  };
  var faInfinity = {
    prefix: 'far',
    iconName: 'infinity',
    icon: [640, 512, [], "f534", "M484 96C407 96 349 164 320 209C291 164 233 96 156 96C70 96 0 168 0 256S70 416 156 416C233 416 291 348 320 303C349 348 407 416 484 416C570 416 640 344 640 256S570 96 484 96ZM156 368C96 368 48 318 48 256S96 144 156 144C223 144 276 226 293 256C276 286 223 368 156 368ZM484 368C417 368 364 286 347 256C364 226 417 144 484 144C544 144 592 194 592 256S544 368 484 368Z"]
  };
  var faInfo = {
    prefix: 'far',
    iconName: 'info',
    icon: [256, 512, [], "f129", "M200 432H152V200C152 187 141 176 128 176H88C75 176 64 187 64 200S75 224 88 224H104V432H56C43 432 32 443 32 456S43 480 56 480H200C213 480 224 469 224 456S213 432 200 432ZM128 128C154 128 176 106 176 80S154 32 128 32S80 54 80 80S102 128 128 128Z"]
  };
  var faInhaler = {
    prefix: 'far',
    iconName: 'inhaler',
    icon: [576, 512, [], "f5f9", "M128 368C110 368 96 382 96 400C96 418 110 432 128 432S160 418 160 400C160 382 146 368 128 368ZM32 224C14 224 0 238 0 256C0 274 14 288 32 288S64 274 64 256C64 238 50 224 32 224ZM32 320C14 320 0 334 0 352C0 370 14 384 32 384S64 370 64 352C64 334 50 320 32 320ZM32 416C14 416 0 430 0 448C0 466 14 480 32 480S64 466 64 448C64 430 50 416 32 416ZM128 272C110 272 96 286 96 304S110 336 128 336S160 322 160 304S146 272 128 272ZM328 224H224C206 224 192 238 192 256V448C192 466 206 480 224 480H470C483 480 494 471 498 459L540 296L377 132C368 124 353 128 350 140L328 224ZM374 236L382 206L487 310L455 432H240V272H365L374 236ZM555 65L435 33C420 29 404 38 400 53L388 99L536 246L575 100C579 85 570 69 555 65Z"]
  };
  var faInputNumeric = {
    prefix: 'far',
    iconName: 'input-numeric',
    icon: [640, 512, [], "e151", "M576 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM592 384C592 393 585 400 576 400H64C55 400 48 393 48 384V128C48 119 55 112 64 112H576C585 112 592 119 592 128V384ZM200 304H184V176C184 167 177 160 168 160H131C123 160 116 164 111 171C101 187 113 208 131 208H136V304H120C107 304 96 315 96 328C96 341 107 352 120 352H200C213 352 224 341 224 328C224 315 213 304 200 304ZM352 304H320L351 271C369 252 374 224 363 200C353 175 330 160 303 160C280 160 259 174 248 195L243 205C237 217 241 231 253 237C265 243 279 239 285 227L290 218C293 212 298 208 303 208C313 208 318 216 319 219C321 222 323 230 316 238L247 312C240 318 238 329 242 338C246 346 254 352 264 352H352C365 352 376 341 376 328S365 304 352 304Z"]
  };
  var faInputPipe = {
    prefix: 'far',
    iconName: 'input-pipe',
    icon: [640, 512, [], "e152", "M128 160C115 160 104 171 104 184V328C104 341 115 352 128 352S152 341 152 328V184C152 171 141 160 128 160ZM576 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM592 384C592 393 585 400 576 400H64C55 400 48 393 48 384V128C48 119 55 112 64 112H576C585 112 592 119 592 128V384Z"]
  };
  var faInputText = {
    prefix: 'far',
    iconName: 'input-text',
    icon: [640, 512, [], "e153", "M213 172C205 156 179 156 171 172L99 316C93 328 97 342 109 348C121 354 136 350 141 338L147 327H237L242 338C247 346 255 351 264 351C268 351 271 350 275 348C287 342 291 328 285 316L213 172ZM171 279L192 237L213 279H171ZM456 220C456 187 429 160 396 160H344C331 160 320 171 320 184V328C320 341 331 352 344 352H412C445 352 472 325 472 292C472 273 463 257 450 246C454 238 456 229 456 220ZM368 208H396C403 208 408 213 408 220S403 232 396 232H368V208ZM412 304H368V280H412C419 280 424 285 424 292C424 299 419 304 412 304ZM576 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM592 384C592 393 585 400 576 400H64C55 400 48 393 48 384V128C48 119 55 112 64 112H576C585 112 592 119 592 128V384Z"]
  };
  var faIntegral = {
    prefix: 'far',
    iconName: 'integral',
    icon: [384, 512, [], "f667", "M371 118C363 129 348 131 338 123L285 83C282 81 278 80 274 80H271C263 80 257 85 255 92L159 433C152 461 126 480 97 480C80 480 63 473 51 461L15 425C6 416 6 400 15 391S40 382 49 391L85 427C94 436 110 431 113 420L209 79C216 51 242 32 271 32H274C288 32 302 37 313 45L366 85C377 93 379 108 371 118Z"]
  };
  var faIntersection = {
    prefix: 'far',
    iconName: 'intersection',
    icon: [384, 512, [], "f668", "M384 224V456C384 469 373 480 360 480S336 469 336 456V224C336 145 271 80 192 80S48 145 48 224V456C48 469 37 480 24 480S0 469 0 456V224C0 118 86 32 192 32S384 118 384 224Z"]
  };
  var faIslandTropical = {
    prefix: 'far',
    iconName: 'island-tropical',
    icon: [448, 512, [], "f811", "M337 32C314 32 291 38 272 50C250 20 208 0 159 0C95 0 42 35 32 82C31 89 37 96 46 96H80L96 64L115 102C109 111 104 122 101 132C92 160 96 192 122 221C124 223 126 224 128 224C130 224 132 223 134 222L201 153C195 230 168 306 150 352H128C94 352 61 366 37 390C13 415 0 448 0 482C0 499 15 512 32 512H352C369 512 384 499 384 482C385 421 344 370 287 356C309 248 297 139 296 128H368L384 96L400 128H435C439 128 443 126 445 124C447 121 448 117 448 114C440 67 393 32 337 32ZM249 150L250 150C252 186 256 271 239 352H201C221 301 244 226 249 150ZM334 464H50C57 427 90 400 128 400H256C294 400 327 427 334 464Z"]
  };
  var faItalic = {
    prefix: 'far',
    iconName: 'italic',
    icon: [320, 512, [], "f033", "M320 56C320 69 309 80 296 80H244L129 432H200C213 432 224 443 224 456S213 480 200 480H24C11 480 0 469 0 456S11 432 24 432H79L194 80H120C107 80 96 69 96 56S107 32 120 32H296C309 32 320 43 320 56Z"]
  };
  var faJ = {
    prefix: 'far',
    iconName: 'j',
    icon: [320, 512, [], "e154", "M160 480C72 480 0 411 0 326V288C0 270 14 256 32 256S64 270 64 288V326C64 376 107 416 160 416S256 376 256 326V64C256 46 270 32 288 32S320 46 320 64V326C320 411 248 480 160 480Z"]
  };
  var faJackOLantern = {
    prefix: 'far',
    iconName: 'jack-o-lantern',
    icon: [576, 512, [], "f30e", "M495 104C456 67 397 62 352 89V36C352 30 349 24 343 22L304 2C295 -2 285 1 282 10L255 77C245 80 235 84 226 90C181 62 121 67 81 104C29 154 0 221 0 292S29 430 81 480C119 515 177 522 222 496C225 495 227 495 230 496C247 507 267 512 288 512S329 507 346 496C349 495 351 495 353 496C399 522 457 515 495 480C547 430 576 363 576 292S547 154 495 104ZM462 445C439 466 405 470 378 454C360 444 339 445 321 455C302 467 274 467 255 455C237 445 216 444 198 454C171 470 137 466 114 445C72 404 48 350 48 292S72 180 114 139C128 126 145 120 163 120C180 120 197 126 210 138L227 153L243 138C268 114 308 114 333 138L349 153L366 138C393 114 436 114 462 139C504 180 528 234 528 292S504 404 462 445ZM249 272C252 272 254 271 255 269C256 267 256 264 255 262L214 195C212 193 210 192 208 192C205 192 203 193 202 195L161 262C160 264 160 266 161 269C162 271 164 272 167 272H249ZM409 272C412 272 414 271 415 269C416 267 416 264 415 262L374 195C372 193 370 192 368 192C365 192 363 193 362 195L321 262C320 264 320 266 321 269C322 271 324 272 327 272H409ZM446 290C401 317 346 333 288 333V347C288 356 281 363 272 363H256C247 363 240 356 240 347V329C200 323 162 310 130 290C117 283 101 295 106 309C112 326 119 338 125 346C134 359 146 370 160 379C160 370 167 363 176 363H192C201 363 208 371 208 379V401C231 408 258 411 288 411S345 408 368 401V379C368 371 375 363 384 363H400C409 363 416 370 416 379C430 370 442 359 451 346C457 338 464 326 470 309C475 295 459 283 446 290Z"]
  };
  var faJedi = {
    prefix: 'far',
    iconName: 'jedi',
    icon: [576, 512, [], "f669", "M560 241C560 390 438 512 288 512C284 512 279 512 275 512C136 505 22 392 16 254C16 248 16 242 16 235C16 233 16 230 16 227C21 145 63 68 130 20C134 18 139 16 144 16C152 16 160 20 164 27C169 33 169 42 166 49C161 64 158 80 158 96C158 137 177 174 210 199C216 204 220 210 220 218C220 225 217 232 212 237C188 258 175 288 175 319C175 371 210 415 259 427L261 370L240 384C235 387 229 387 225 383C221 379 220 373 223 368L240 339L204 332C198 331 194 326 194 320C194 314 198 309 204 308L241 301L223 272C220 267 221 261 225 257C229 253 236 252 240 256L265 272L276 12C276 5 281 0 288 0C294 0 300 5 300 11L311 272L336 256C340 252 347 253 351 257C353 259 354 262 354 265C354 268 354 270 353 272L335 301L372 308C377 309 381 314 381 320C381 326 377 331 372 332L335 339L353 368C355 373 355 379 351 383C346 387 340 387 336 384L315 370L317 428C358 417 390 384 399 342C407 303 393 263 364 237C358 232 355 225 356 217C356 210 360 204 366 199C399 174 418 137 418 96C418 80 415 64 409 49C405 39 408 28 417 21C425 14 437 14 445 20C513 68 555 144 559 227C560 229 560 232 560 234C560 237 560 239 560 241ZM108 298C102 305 92 306 85 300L69 285C81 347 120 401 174 433C116 376 111 284 161 221C131 190 112 149 110 106C96 124 85 145 77 167L107 197C113 203 113 213 107 219C101 226 91 226 84 219L68 203C66 215 65 227 65 239L106 276C110 279 111 283 112 287C112 291 111 295 108 298ZM507 286L490 300C484 306 474 305 468 298C462 292 463 282 469 276L512 239C512 227 510 214 508 202L491 219C485 225 475 225 469 219C462 213 462 203 469 197L499 167C491 145 480 125 466 106C463 149 445 190 414 221C444 257 455 305 446 352C439 383 424 411 402 433C456 401 494 347 507 286Z"]
  };
  var faJetFighter = {
    prefix: 'far',
    iconName: 'jet-fighter',
    icon: [640, 512, [], "f0fb", "M609 211L487 167C475 162 462 160 449 160H380L298 48H328C341 48 352 37 352 24S341 0 328 0H216C203 0 192 11 192 24V160H190L164 129C155 118 142 112 128 112H79C53 112 31 134 31 160V195C12 201 -1 219 -1 240V272C-1 293 12 311 31 317V352C31 378 53 400 79 400H128C142 400 155 394 164 383L190 352H192V488C192 501 203 512 216 512H328C341 512 352 501 352 488S341 464 328 464H298L380 352H449C462 352 475 350 487 345L609 301C628 294 640 276 640 256S628 218 609 211ZM240 51L321 160H240V51ZM240 461V352H321L240 461ZM471 300C464 303 456 304 449 304H175C170 304 166 306 163 310L128 352H79V280H160C173 280 184 269 184 256S173 232 160 232H79V160H128L163 202C166 206 170 208 175 208H449C456 208 464 209 471 212L592 256L471 300Z"]
  };
  var faJoint = {
    prefix: 'far',
    iconName: 'joint',
    icon: [640, 512, [], "f595", "M471 178C497 193 512 220 512 250V264C512 277 523 288 536 288H536C549 288 560 277 560 264V250C560 206 539 166 504 142C480 125 464 99 464 70V24C464 11 453 0 440 0H440C427 0 416 11 416 24L416 74C416 116 436 156 471 178ZM553 87C548 83 544 77 544 70V24C544 11 533 0 520 0H520C507 0 496 11 496 24L496 72C496 94 508 115 527 127C568 155 592 200 592 250V264C592 277 603 288 616 288H616C629 288 640 277 640 264V250C640 184 608 123 553 87ZM616 352H279C180 352 84 380 0 432C84 484 180 512 279 512H616C629 512 640 501 640 488V376C640 363 629 352 616 352ZM279 464C220 464 162 453 107 432C156 413 209 403 262 401L316 464H279ZM379 464L324 400H421L476 464H379ZM592 464H539L484 400H592V464Z"]
  };
  var faJoystick = {
    prefix: 'far',
    iconName: 'joystick',
    icon: [448, 512, [], "f8c5", "M384 352H248V221C314 207 355 135 327 67C315 38 290 15 259 5C188 -17 120 32 113 100C106 157 144 209 200 221V352H128C128 334 114 320 96 320S64 334 64 352C29 352 0 381 0 416V448C0 483 29 512 64 512H384C419 512 448 483 448 448V416C448 381 419 352 384 352ZM160 112C160 77 189 48 224 48S288 77 288 112C288 147 259 176 224 176S160 147 160 112ZM400 448C400 457 393 464 384 464H64C55 464 48 457 48 448V416C48 407 55 400 64 400H384C393 400 400 407 400 416V448Z"]
  };
  var faJug = {
    prefix: 'far',
    iconName: 'jug',
    icon: [448, 512, [], "f8c6", "M416 168C416 128 384 96 344 96C323 96 303 106 289 122L279 109C274 103 272 96 272 89V48C285 48 296 37 296 24S285 0 272 0H112C99 0 88 11 88 24S99 48 112 48V89C112 96 110 103 105 109L28 205C10 228 0 256 0 285V432C0 476 36 512 80 512H304C348 512 384 476 384 432V285C384 267 380 250 373 234C399 222 416 197 416 168ZM66 235L142 139C154 125 160 107 160 89V48H224V89C224 107 230 125 242 139L318 235C330 249 336 267 336 285V288H48V285C48 267 54 249 66 235ZM304 464H80C62 464 48 450 48 432V416H336V432C336 450 322 464 304 464ZM345 192L321 162C324 151 333 144 344 144C357 144 367 154 368 167C368 180 358 191 345 192Z"]
  };
  var faK = {
    prefix: 'far',
    iconName: 'k',
    icon: [320, 512, [], "e155", "M314 430C324 444 321 464 306 474C301 478 294 480 288 480C278 480 268 475 262 466L128 273L64 339V448C64 466 50 480 32 480S0 466 0 448V64C0 46 14 32 32 32S64 46 64 64V247L265 42C277 29 298 29 310 41C323 53 323 74 311 86L174 227L314 430Z"]
  };
  var faKaaba = {
    prefix: 'far',
    iconName: 'kaaba',
    icon: [576, 512, [], "f66b", "M554 83L318 5C309 2 298 0 288 0S267 2 258 5L22 83C9 88 0 100 0 114V425C0 440 10 453 25 456L267 510C274 511 281 512 288 512S302 511 309 510L551 456C566 453 576 440 576 425V114C576 100 567 88 554 83ZM528 251L468 236C459 234 451 240 448 248C446 257 452 265 460 267L528 284V412L298 463C294 464 287 465 278 463L48 412V285L116 268C124 265 130 257 128 248C125 240 117 234 108 236L48 251V214L277 146C284 143 292 143 300 146L528 214V251ZM528 164L313 100C297 95 279 95 263 100L48 164V125L273 50C278 49 290 46 303 50L528 125V164ZM316 232L396 252C397 252 399 252 400 252C407 252 414 247 416 240C418 231 412 223 404 220L324 200C315 198 307 204 304 212C302 221 308 229 316 232ZM252 200L172 220C164 223 158 231 160 240C162 247 169 252 176 252C177 252 179 252 180 252L260 232C268 229 274 221 272 212C269 204 261 198 252 200Z"]
  };
  var faKazoo = {
    prefix: 'far',
    iconName: 'kazoo',
    icon: [640, 512, [], "f8c7", "M576 128H481C461 118 439 112 416 112S371 118 351 128H242C230 128 218 130 207 133L23 185C10 189 0 202 0 216V296C0 310 10 323 23 327L206 379C218 382 230 384 242 384H351C371 394 393 400 416 400S461 394 481 384H576C611 384 640 355 640 320V192C640 157 611 128 576 128ZM296 336H242C235 336 227 335 220 333L48 284V228L220 179C227 177 234 176 242 176H296C264 224 264 288 296 336ZM416 352C363 352 320 309 320 256S363 160 416 160S512 203 512 256S469 352 416 352ZM592 320C592 329 585 336 576 336H536C568 288 568 224 536 176H576C585 176 592 183 592 192V320ZM466 206C458 198 446 198 438 206L416 228L394 206C386 198 374 198 366 206C358 214 358 226 366 234L388 256L366 278C358 286 358 298 366 306C370 310 375 312 380 312S390 310 394 306L416 284L438 306C442 310 447 312 452 312S462 310 466 306C474 298 474 286 466 278L444 256L466 234C474 226 474 214 466 206Z"]
  };
  var faKerning = {
    prefix: 'far',
    iconName: 'kerning',
    icon: [640, 512, [], "f86f", "M442 2C430 -3 416 2 410 14L202 478C197 490 202 504 214 510C217 511 221 512 224 512C233 512 242 507 246 498L454 34C459 22 454 8 442 2ZM307 99C295 93 280 97 275 109L160 338L45 109C40 97 25 93 13 99C1 104 -3 119 3 131L139 403C143 411 151 416 160 416S177 411 181 403L317 131C323 119 319 104 307 99ZM622 382L502 110C494 93 466 93 458 110L338 382C333 394 338 409 350 414C362 419 377 414 382 402L404 352H556L578 402C582 411 591 416 600 416C603 416 607 415 610 414C622 409 627 394 622 382ZM425 304L480 179L535 304H425Z"]
  };
  var faKey = {
    prefix: 'far',
    iconName: 'key',
    icon: [512, 512, [], "f084", "M329 0C227 0 145 82 145 183C145 194 146 204 148 214L16 347C6 357 0 370 0 384V474C0 495 17 512 38 512H126C147 512 164 495 164 474V454H183C205 454 222 437 222 416V396H250C260 396 270 392 277 385L298 364C412 384 512 295 512 183C512 82 430 0 329 0ZM296 315L283 311L246 348H174V406H116V464H48V384C48 383 49 381 49 380L201 229L197 216C194 205 193 194 193 183C193 109 254 48 328 48S464 109 464 183C464 269 385 337 296 315ZM368 112C350 112 336 126 336 144C336 162 350 176 368 176S400 162 400 144C400 126 386 112 368 112Z"]
  };
  var faKeySkeleton = {
    prefix: 'far',
    iconName: 'key-skeleton',
    icon: [512, 512, [], "f6f3", "M416 0H320C267 0 224 43 224 96V192C224 210 229 226 238 240L7 471C-2 480 -2 496 7 505C12 510 18 512 24 512S36 510 41 505L84 462L122 500C130 508 140 512 150 512S171 508 178 500L228 451C243 435 243 410 228 394L190 356L272 274C286 283 302 288 320 288H416C469 288 512 245 512 192V96C512 43 469 0 416 0ZM150 461L118 428L156 390L188 423L150 461ZM464 192C464 218 442 240 416 240H320C294 240 272 218 272 192V96C272 70 294 48 320 48H416C442 48 464 70 464 96V192ZM394 131C388 131 381 124 381 118C381 97 364 80 342 80C321 80 304 97 304 118C304 140 321 157 342 157C348 157 355 164 355 170C355 191 372 208 394 208C415 208 432 191 432 170S415 131 394 131Z"]
  };
  var faKeyboard = {
    prefix: 'far',
    iconName: 'keyboard',
    icon: [576, 512, [], "f11c", "M512 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H512C547 448 576 419 576 384V128C576 93 547 64 512 64ZM528 384C528 393 521 400 512 400H64C55 400 48 393 48 384V128C48 119 55 112 64 112H512C521 112 528 119 528 128V384ZM140 152H116C109 152 104 157 104 164V188C104 195 109 200 116 200H140C147 200 152 195 152 188V164C152 157 147 152 140 152ZM196 200H220C227 200 232 195 232 188V164C232 157 227 152 220 152H196C189 152 184 157 184 164V188C184 195 189 200 196 200ZM276 200H300C307 200 312 195 312 188V164C312 157 307 152 300 152H276C269 152 264 157 264 164V188C264 195 269 200 276 200ZM356 200H380C387 200 392 195 392 188V164C392 157 387 152 380 152H356C349 152 344 157 344 164V188C344 195 349 200 356 200ZM460 152H436C429 152 424 157 424 164V188C424 195 429 200 436 200H460C467 200 472 195 472 188V164C472 157 467 152 460 152ZM140 232H116C109 232 104 237 104 244V268C104 275 109 280 116 280H140C147 280 152 275 152 268V244C152 237 147 232 140 232ZM196 280H220C227 280 232 275 232 268V244C232 237 227 232 220 232H196C189 232 184 237 184 244V268C184 275 189 280 196 280ZM276 280H300C307 280 312 275 312 268V244C312 237 307 232 300 232H276C269 232 264 237 264 244V268C264 275 269 280 276 280ZM356 280H380C387 280 392 275 392 268V244C392 237 387 232 380 232H356C349 232 344 237 344 244V268C344 275 349 280 356 280ZM460 232H436C429 232 424 237 424 244V268C424 275 429 280 436 280H460C467 280 472 275 472 268V244C472 237 467 232 460 232ZM400 320H176C167 320 160 327 160 336V352C160 361 167 368 176 368H400C409 368 416 361 416 352V336C416 327 409 320 400 320Z"]
  };
  var faKeyboardDown = {
    prefix: 'far',
    iconName: 'keyboard-down',
    icon: [576, 512, [], "e156", "M276 136H300C307 136 312 131 312 124V100C312 93 307 88 300 88H276C269 88 264 93 264 100V124C264 131 269 136 276 136ZM356 136H380C387 136 392 131 392 124V100C392 93 387 88 380 88H356C349 88 344 93 344 100V124C344 131 349 136 356 136ZM196 136H220C227 136 232 131 232 124V100C232 93 227 88 220 88H196C189 88 184 93 184 100V124C184 131 189 136 196 136ZM460 88H436C429 88 424 93 424 100V124C424 131 429 136 436 136H460C467 136 472 131 472 124V100C472 93 467 88 460 88ZM512 0H64C29 0 0 29 0 64V240C0 275 29 304 64 304H512C547 304 576 275 576 240V64C576 29 547 0 512 0ZM528 240C528 249 521 256 512 256H64C55 256 48 249 48 240V64C48 55 55 48 64 48H512C521 48 528 55 528 64V240ZM140 88H116C109 88 104 93 104 100V124C104 131 109 136 116 136H140C147 136 152 131 152 124V100C152 93 147 88 140 88ZM400 176H176C167 176 160 183 160 192V208C160 217 167 224 176 224H400C409 224 416 217 416 208V192C416 183 409 176 400 176ZM374 360L288 453L202 360C193 350 177 349 168 358C158 367 157 383 166 392L270 504C275 509 281 512 288 512S301 509 306 504L410 392C419 383 418 367 408 358C399 349 383 350 374 360Z"]
  };
  var faKeyboardLeft = {
    prefix: 'far',
    iconName: 'keyboard-left',
    icon: [640, 512, [], "e157", "M436 280H460C467 280 472 275 472 268V244C472 237 467 232 460 232H436C429 232 424 237 424 244V268C424 275 429 280 436 280ZM284 232H260C253 232 248 237 248 244V268C248 275 253 280 260 280H284C291 280 296 275 296 268V244C296 237 291 232 284 232ZM356 200H380C387 200 392 195 392 188V164C392 157 387 152 380 152H356C349 152 344 157 344 164V188C344 195 349 200 356 200ZM436 200H460C467 200 472 195 472 188V164C472 157 467 152 460 152H436C429 152 424 157 424 164V188C424 195 429 200 436 200ZM121 159C112 150 96 150 87 159L7 239C-2 248 -2 264 7 273L87 353C92 358 98 360 104 360S116 358 121 353C130 344 130 328 121 319L58 256L121 193C130 184 130 168 121 159ZM356 280H380C387 280 392 275 392 268V244C392 237 387 232 380 232H356C349 232 344 237 344 244V268C344 275 349 280 356 280ZM540 152H516C509 152 504 157 504 164V188C504 195 509 200 516 200H540C547 200 552 195 552 188V164C552 157 547 152 540 152ZM576 64H224C189 64 160 93 160 128V384C160 419 189 448 224 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM592 384C592 393 585 400 576 400H224C215 400 208 393 208 384V128C208 119 215 112 224 112H576C585 112 592 119 592 128V384ZM284 152H260C253 152 248 157 248 164V188C248 195 253 200 260 200H284C291 200 296 195 296 188V164C296 157 291 152 284 152ZM480 320H320C311 320 304 327 304 336V352C304 361 311 368 320 368H480C489 368 496 361 496 352V336C496 327 489 320 480 320ZM540 232H516C509 232 504 237 504 244V268C504 275 509 280 516 280H540C547 280 552 275 552 268V244C552 237 547 232 540 232Z"]
  };
  var faKeynote = {
    prefix: 'far',
    iconName: 'keynote',
    icon: [512, 512, [], "f66c", "M507 258L443 170C439 164 432 160 424 160H144V136C144 101 169 72 202 65C209 74 220 80 232 80H312C334 80 352 62 352 40C352 18 334 0 312 0H232C218 0 207 7 200 18C141 26 96 75 96 136V160H88C80 160 73 164 69 170L5 258C2 262 0 267 0 272V328C0 341 11 352 24 352H232V464H152C139 464 128 475 128 488S139 512 152 512H360C373 512 384 501 384 488S373 464 360 464H280V352H488C501 352 512 341 512 328V272C512 267 510 262 507 258ZM464 304H48V280L100 208H412L464 280V304Z"]
  };
  var faKhanda = {
    prefix: 'far',
    iconName: 'khanda',
    icon: [512, 512, [], "f66d", "M416 66C413 65 411 64 408 64C404 64 399 66 396 69C391 74 391 82 394 88C411 115 420 145 420 176C419 229 393 279 348 308L272 362V342L316 305C320 301 321 295 319 290L311 273C345 254 368 218 368 176C368 135 346 100 313 80L318 69C321 63 319 57 315 53L256 0L197 53C192 57 191 63 193 69L198 80C166 100 144 135 144 176C144 218 167 254 201 273L193 290C191 295 192 301 196 306L240 342V362L163 308C119 279 92 229 92 176C92 145 101 115 117 89C121 82 120 75 115 70C112 66 107 65 103 65C100 65 97 65 95 67C16 110 -22 205 13 296C20 314 31 330 44 345L100 410C103 414 107 416 112 416C114 416 117 415 119 414L199 372L228 392L181 425C179 425 178 424 176 424C163 424 152 435 152 448S163 472 176 472C188 472 198 463 199 451L240 423V453C230 459 224 468 224 480C224 498 238 512 256 512C273 512 288 498 288 480C288 468 281 459 272 453V423L313 451C314 463 324 472 336 472C349 472 360 461 360 448S349 424 336 424C334 424 333 425 331 425L284 392L313 372L392 414C395 415 397 416 400 416C405 416 409 414 412 410L465 349C484 327 499 302 506 274C528 190 489 106 416 66ZM119 360L80 314C70 302 62 290 58 278C50 258 47 237 48 217C59 270 90 317 136 348L139 350L119 360ZM328 176C328 202 314 224 294 237L285 217C277 193 277 166 285 141L297 117C315 130 328 151 328 176ZM184 176C184 151 196 130 215 117L226 141C235 166 235 193 226 217L217 237C197 224 184 202 184 176ZM459 262C455 280 444 299 428 318L392 360L373 350L375 348C421 317 453 270 464 216C465 231 463 246 459 262Z"]
  };
  var faKidneys = {
    prefix: 'far',
    iconName: 'kidneys',
    icon: [640, 512, [], "f5fb", "M273 216L234 196C237 193 240 190 243 187C283 153 298 83 250 32C207 -12 134 -10 89 32C13 101 -17 201 10 294C34 378 102 383 120 383C142 383 190 374 217 326C231 302 234 273 227 246L252 259C254 261 256 263 256 266V488C256 501 267 512 280 512S304 501 304 488V266C304 245 292 226 273 216ZM211 151C200 161 161 193 180 259C192 298 162 326 137 332C103 342 68 322 59 291C32 197 62 117 127 62C154 39 194 43 216 67C239 91 237 129 211 151ZM551 32C506 -10 433 -12 390 32C342 83 357 153 397 187C400 190 403 193 406 196L367 216C348 226 336 245 336 266V488C336 501 347 512 360 512S384 501 384 488V266C384 263 386 261 389 259L413 246C406 273 409 301 423 326C450 374 498 383 520 383C538 383 606 378 630 294C657 201 627 101 551 32ZM581 291C572 322 537 341 503 332C478 326 448 298 460 259C478 193 440 161 429 151C403 129 401 91 424 67C446 43 486 39 513 62C578 117 608 197 581 291Z"]
  };
  var faKipSign = {
    prefix: 'far',
    iconName: 'kip-sign',
    icon: [384, 512, [], "e158", "M384 256C384 269 373 280 360 280H161L344 438C354 446 355 462 346 472C341 477 335 480 328 480C322 480 317 478 312 474L112 301V456C112 469 101 480 88 480S64 469 64 456V280H24C11 280 0 269 0 256C0 243 11 232 24 232H64V56C64 43 75 32 88 32S112 43 112 56V211L312 38C322 29 338 30 346 40C355 50 354 66 344 74L161 232H360C373 232 384 243 384 256Z"]
  };
  var faKitMedical = {
    prefix: 'far',
    iconName: 'kit-medical',
    icon: [576, 512, [], "f479", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM96 432H64C55 432 48 425 48 416V96C48 87 55 80 64 80H96V432ZM432 432H144V80H432V432ZM528 416C528 425 521 432 512 432H480V80H512C521 80 528 87 528 96V416ZM208 288H256V336C256 345 263 352 272 352H304C313 352 320 345 320 336V288H368C377 288 384 281 384 272V240C384 231 377 224 368 224H320V176C320 167 313 160 304 160H272C263 160 256 167 256 176V224H208C199 224 192 231 192 240V272C192 281 199 288 208 288Z"]
  };
  var faKite = {
    prefix: 'far',
    iconName: 'kite',
    icon: [640, 512, [], "f6f4", "M608 0H346C331 0 318 10 314 25C314 25 235 369 235 371L147 459C137 469 120 462 120 448V319L167 349C178 356 192 349 192 337V271C192 259 178 252 167 259L120 289V224C120 175 81 136 32 136H24C11 136 0 147 0 160V160C0 173 11 184 24 184H32C54 184 72 202 72 224V289L25 259C14 252 0 259 0 271V337C0 349 14 356 25 349L72 319V443C72 460 77 476 88 489C114 521 157 517 181 493L269 405C271 405 615 326 615 326C630 322 640 309 640 295V32C640 14 626 0 608 0ZM592 282L288 352L475 165L358 48H592L475 165L592 282Z"]
  };
  var faKiwiBird = {
    prefix: 'far',
    iconName: 'kiwi-bird',
    icon: [576, 512, [], "f535", "M576 218C573 157 518 112 458 112L451 112C398 112 346 98 303 67C272 45 233 32 192 32C80 32 0 122 0 224C0 295 39 357 96 390V456C96 469 107 480 120 480H120C133 480 144 469 144 456V410C159 414 175 416 192 416C197 416 203 415 208 415V456C208 469 219 480 232 480H232C245 480 256 469 256 456V405C271 399 286 392 299 383C343 353 395 336 449 336L464 336C467 336 469 335 471 335L546 472C549 477 554 480 560 480C568 480 576 473 576 464C576 208 576 222 576 218ZM464 288H449C388 288 328 307 270 345C247 360 220 368 192 368C114 368 48 305 48 224C48 140 115 80 192 80C221 80 249 89 273 105C325 141 386 160 448 160H458C495 160 526 187 528 221C530 258 500 288 464 288ZM464 200C451 200 440 211 440 224S451 248 464 248S488 237 488 224S477 200 464 200Z"]
  };
  var faKnife = {
    prefix: 'far',
    iconName: 'knife',
    icon: [512, 512, [], "f2e4", "M478 15C468 5 456 0 442 0H442C429 0 416 5 407 14L15 390C-5 410 -5 441 15 461L51 497C61 507 73 512 87 512C87 512 88 512 88 512C102 512 115 506 123 496L287 334C422 338 474 267 493 224C526 150 512 49 478 15ZM449 204C423 263 366 291 279 286L268 285L89 462L86 463L85 463L48 424L444 49C459 64 478 141 449 204Z"]
  };
  var faKnifeKitchen = {
    prefix: 'far',
    iconName: 'knife-kitchen',
    icon: [576, 512, [], "f6f5", "M566 43L531 9C518 -3 497 -3 484 9L304 183C297 190 297 200 304 206L394 293C399 299 409 299 415 294L438 275C444 269 448 261 448 252V208L566 89C579 76 579 56 566 43ZM443 155C437 162 427 162 421 155S414 139 421 133S437 126 443 133S450 149 443 155ZM507 91C501 98 491 98 485 91S478 75 485 69S501 62 507 69C514 75 514 85 507 91ZM390 335C381 326 366 326 357 335L302 388C251 437 184 464 111 464C102 464 92 463 82 462L284 267C294 258 294 242 284 233C275 224 260 224 251 233L5 470C-4 478 0 492 11 496C44 507 78 512 111 512C194 512 275 481 336 422L390 370C400 360 400 345 390 335L390 335Z"]
  };
  var faL = {
    prefix: 'far',
    iconName: 'l',
    icon: [320, 512, [], "e159", "M256 480H32C14 480 0 466 0 448V64C0 46 14 32 32 32S64 46 64 64V416H256C274 416 288 430 288 448S274 480 256 480Z"]
  };
  var faLambda = {
    prefix: 'far',
    iconName: 'lambda',
    icon: [448, 512, [], "f66e", "M448 456C448 469 437 480 424 480H360C351 480 343 475 339 467L172 158L46 465C42 474 33 480 24 480C21 480 18 479 15 478C3 473 -3 459 2 447L142 103L130 80H24C11 80 0 69 0 56S11 32 24 32H144C153 32 161 37 165 45L374 432H424C437 432 448 443 448 456Z"]
  };
  var faLamp = {
    prefix: 'far',
    iconName: 'lamp',
    icon: [448, 512, [], "f4ca", "M445 238L368 22C363 9 352 0 340 0H121C109 0 99 8 94 20L3 236C-7 260 8 288 30 288H119C95 323 80 366 80 402C80 434 93 466 116 490C129 504 148 512 167 512H280C300 512 319 504 332 490C355 466 368 434 368 402C368 366 353 323 329 288H418C439 288 454 262 445 238ZM320 402C320 423 311 442 297 457C293 462 287 464 280 464H167C161 464 155 462 151 457C137 442 128 423 128 402C128 367 151 314 184 288H264C297 314 320 367 320 402ZM53 240L134 48H326L395 240H53Z"]
  };
  var faLampDesk = {
    prefix: 'far',
    iconName: 'lamp-desk',
    icon: [512, 512, [], "e014", "M393 279C415 294 445 291 464 272C483 253 485 223 470 201L393 279ZM509 86C504 73 491 64 477 64H392L356 29C323 -5 270 -10 232 18C193 46 181 98 203 140L103 239C97 245 95 254 97 263L155 464H24C11 464 0 475 0 488C0 501 11 512 24 512H360C373 512 384 501 384 488C384 475 373 464 360 464H204L147 263L233 177L256 200V285C256 299 265 312 278 317C291 323 306 320 316 310L502 124C512 114 515 99 509 86ZM304 254V180L254 130C236 111 236 82 255 63C273 44 303 44 322 62L372 112H446L304 254Z"]
  };
  var faLampFloor = {
    prefix: 'far',
    iconName: 'lamp-floor',
    icon: [384, 512, [], "e015", "M382 213L311 21C306 8 294 0 281 0H103C89 0 78 8 73 21L2 213C-6 234 10 256 32 256H168V464H88C75 464 64 475 64 488C64 501 75 512 88 512H296C309 512 320 501 320 488C320 475 309 464 296 464H216V256H352C374 256 390 234 382 213ZM55 208L114 48H270L329 208H55Z"]
  };
  var faLandmark = {
    prefix: 'far',
    iconName: 'landmark',
    icon: [512, 512, [], "f66f", "M488 464H24C11 464 0 475 0 488C0 501 11 512 24 512H488C501 512 512 501 512 488C512 475 501 464 488 464ZM497 98L265 2C259 -1 253 -1 247 2L15 98C6 102 0 110 0 120V184C0 197 11 208 24 208H64V352H112V208H176V352H224V208H288V352H336V208H400V352H448V208H488C501 208 512 197 512 184V120C512 110 506 102 497 98ZM464 160H48V136L256 50L464 136V160ZM456 432C469 432 480 421 480 408C480 395 469 384 456 384H56C43 384 32 395 32 408C32 421 43 432 56 432H456Z"]
  };
  var faLandmarkDome = {
    prefix: 'far',
    iconName: 'landmark-dome',
    icon: [512, 512, [], "f752", "M488 464H24C11 464 0 475 0 488C0 501 11 512 24 512H488C501 512 512 501 512 488C512 475 501 464 488 464ZM56 256H64V352H112V256H176V352H224V256H288V352H336V256H400V352H448V256H456C469 256 480 245 480 232C480 219 469 208 456 208H447C440 118 369 45 280 34V24C280 11 269 0 256 0S232 11 232 24V34C143 45 72 118 65 208H56C43 208 32 219 32 232C32 245 43 256 56 256ZM256 80C330 80 390 136 398 208H114C122 136 182 80 256 80ZM56 432H456C469 432 480 421 480 408C480 395 469 384 456 384H56C43 384 32 395 32 408C32 421 43 432 56 432Z"]
  };
  var faLanguage = {
    prefix: 'far',
    iconName: 'language',
    icon: [640, 512, [], "f1ab", "M144 280H176L160 243L144 280ZM532 188H476V180C476 169 467 160 456 160S436 169 436 180V188H380C369 188 360 197 360 208C360 219 369 228 380 228H486C480 242 470 257 456 271C450 264 444 257 439 250C435 245 428 244 423 247L416 251L409 255C403 259 401 267 405 272C411 281 418 290 426 298C418 304 410 310 400 316C395 319 393 327 396 332L404 346C407 352 415 354 421 350C433 343 445 334 456 325C467 334 479 343 491 350C497 354 505 352 508 346L516 332C519 326 517 319 512 316C503 310 494 304 486 298C507 275 522 252 529 228H532C543 228 552 219 552 208C552 197 543 188 532 188ZM576 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM234 350C231 351 227 352 224 352C215 352 206 347 202 338L198 328H122L118 338C113 350 98 355 86 350C74 345 69 330 74 318L138 174C146 157 174 157 182 174L246 318C251 330 246 345 234 350ZM592 384C592 393 585 400 576 400H320V112H576C585 112 592 119 592 128V384Z"]
  };
  var faLaptop = {
    prefix: 'far',
    iconName: 'laptop',
    icon: [640, 512, [], "f109", "M616 352H24C11 352 0 363 0 376V392C0 441 39 480 88 480H552C601 480 640 441 640 392V376C640 363 629 352 616 352ZM552 432H88C69 432 53 418 49 400H591C587 418 571 432 552 432ZM112 88C112 84 116 80 120 80H520C524 80 528 84 528 88V320H576V88C576 57 551 32 520 32H120C89 32 64 57 64 88V320H112V88Z"]
  };
  var faLaptopCode = {
    prefix: 'far',
    iconName: 'laptop-code',
    icon: [640, 512, [], "f5fc", "M616 352H24C11 352 0 363 0 376V392C0 441 39 480 88 480H552C601 480 640 441 640 392V376C640 363 629 352 616 352ZM552 432H88C69 432 53 418 49 400H591C587 418 571 432 552 432ZM112 88C112 84 116 80 120 80H520C524 80 528 84 528 88V320H576V88C576 57 551 32 520 32H120C89 32 64 57 64 88V320H112V88ZM398 262C402 266 407 268 412 268S422 266 426 262L474 214C482 206 482 194 474 186L426 138C418 130 406 130 398 138S390 158 398 166L432 200L398 234C390 242 390 254 398 262ZM242 138C234 130 222 130 214 138L166 186C158 194 158 206 166 214L214 262C218 266 223 268 228 268S238 266 242 262C250 254 250 242 242 234L208 200L242 166C250 158 250 146 242 138ZM329 125L273 277C269 287 275 299 285 303C287 304 290 304 292 304C300 304 308 299 311 291L367 139C371 129 365 117 355 113C345 109 333 115 329 125Z"]
  };
  var faLaptopMedical = {
    prefix: 'far',
    iconName: 'laptop-medical',
    icon: [640, 512, [], "f812", "M112 88C112 84 116 80 120 80H520C524 80 528 84 528 88V320H576V88C576 57 551 32 520 32H120C89 32 64 57 64 88V320H112V88ZM616 352H24C11 352 0 363 0 376V392C0 441 39 480 88 480H552C601 480 640 441 640 392V376C640 363 629 352 616 352ZM552 432H88C69 432 53 418 49 400H591C587 418 571 432 552 432ZM304 320H336C345 320 352 313 352 304V256H400C409 256 416 249 416 240V208C416 199 409 192 400 192H352V144C352 135 345 128 336 128H304C295 128 288 135 288 144V192H240C231 192 224 199 224 208V240C224 249 231 256 240 256H288V304C288 313 295 320 304 320Z"]
  };
  var faLaptopMobile = {
    prefix: 'far',
    iconName: 'laptop-mobile',
    icon: [640, 512, [], "f87a", "M112 64C112 55 119 48 128 48H448C457 48 464 55 464 64V96H512V64C512 29 483 0 448 0H128C93 0 64 29 64 64V320H16C7 320 0 327 0 336C0 362 22 384 48 384H352V320H112V64ZM576 128H448C413 128 384 157 384 192V448C384 483 413 512 448 512H576C611 512 640 483 640 448V192C640 157 611 128 576 128ZM592 448C592 457 585 464 576 464H448C439 464 432 457 432 448V192C432 183 439 176 448 176H576C585 176 592 183 592 192V448Z"]
  };
  var faLaptopSlash = {
    prefix: 'far',
    iconName: 'laptop-slash',
    icon: [640, 512, [], "e15a", "M64 146V320H112V184ZM88 432A40 40 0 0 1 49 400H388L326 352H24A24 24 0 0 0 0 376V392A88 88 0 0 0 88 480H490L428 432ZM640 376A24 24 0 0 0 616 352H481L134 80H520A8 8 0 0 1 528 88V320H576V88A56 56 0 0 0 520 32H120A55 55 0 0 0 87 43L39 5A24 24 0 0 0 9 43L601 507A24 24 0 1 0 631 469L613 455A87 87 0 0 0 640 392ZM574 425L543 400H591A40 40 0 0 1 574 425Z"]
  };
  var faLariSign = {
    prefix: 'far',
    iconName: 'lari-sign',
    icon: [384, 512, [], "e15b", "M384 456C384 469 373 480 360 480H24C11 480 0 469 0 456S11 432 24 432H65C25 397 0 345 0 288C0 208 50 139 120 110V56C120 43 131 32 144 32S168 43 168 56V98C176 97 184 96 192 96C200 96 208 97 216 98V56C216 43 227 32 240 32S264 43 264 56V111C323 134 368 186 381 251C383 264 374 277 362 280C349 282 336 274 333 261C325 218 299 184 264 163V264C264 277 253 288 240 288S216 277 216 264V146C208 145 200 144 192 144C184 144 176 145 168 146V264C168 277 157 288 144 288S120 277 120 264V164C77 189 48 235 48 288C48 367 113 432 192 432H360C373 432 384 443 384 456Z"]
  };
  var faLasso = {
    prefix: 'far',
    iconName: 'lasso',
    icon: [576, 512, [], "f8c8", "M288 0C126 0 0 78 0 179C0 227 30 272 83 305C88 308 92 310 97 313C91 354 132 387 182 383C185 392 187 401 186 410C186 440 159 464 130 464L56 464C43 464 32 475 32 488V488C32 501 43 512 56 512L126 512C186 512 237 463 234 404C234 392 232 380 228 368C233 365 238 360 243 355C258 356 273 357 288 357C450 357 576 279 576 179C576 78 450 0 288 0ZM288 309C277 309 266 309 254 308C247 278 215 256 176 256C156 256 137 262 123 272C118 270 113 267 109 265C70 240 48 210 48 179C48 108 158 48 288 48S528 108 528 179C528 250 418 309 288 309Z"]
  };
  var faLassoSparkles = {
    prefix: 'far',
    iconName: 'lasso-sparkles',
    icon: [576, 512, [], "e15c", "M256 80L256 80L256 80C256 82 258 85 260 86L309 107L309 107L330 156C331 158 334 160 336 160C338 160 341 158 342 156L363 107L363 107L363 107L412 86C414 85 416 82 416 80L416 80L416 80C416 78 414 75 412 74L363 53L363 53L342 4C341 2 338 0 336 0C334 0 331 2 330 4L309 53L309 53L260 74C258 75 256 78 256 80ZM572 426L523 405L502 356C501 354 498 352 496 352C494 352 491 354 490 356L469 405L420 426C418 427 416 430 416 432C416 434 418 437 420 438L469 459L490 508C491 510 494 512 496 512C498 512 501 510 502 508L523 459L572 438C574 437 576 434 576 432C576 430 574 427 572 426ZM576 179C576 98 494 32 379 9L387 29L425 44C439 52 448 65 448 80C448 80 448 81 448 82C497 106 528 141 528 179C528 250 418 309 288 309C277 309 266 309 254 308C247 278 215 256 176 256C156 256 137 262 123 272C118 270 113 267 109 265C70 240 48 210 48 179C48 117 130 64 237 51C240 49 242 47 245 45L285 29L297 0C294 0 291 0 288 0C126 0 0 78 0 179C0 227 30 272 83 305C88 308 92 310 97 313C91 354 132 387 182 383C185 392 187 401 186 410C186 440 159 464 130 464H56C43 464 32 475 32 488C32 501 43 512 56 512H126C186 512 237 463 234 404C234 392 232 380 228 368C233 365 238 360 243 355C258 356 273 357 288 357C450 357 576 279 576 179Z"]
  };
  var faLayers = {
    prefix: 'far',
    iconName: 'layers',
    icon: [512, 512, [], "f5fd", "M26 166L237 253C243 255 250 256 256 256C262 256 269 255 275 252L486 166C502 160 512 145 512 128S502 96 486 90L275 3C263 -1 249 -1 237 4L26 90C10 96 0 111 0 128S10 160 26 166ZM257 48L453 128L255 208L59 128L257 48ZM486 346C474 341 460 346 455 359C451 367 453 376 458 382L255 464L54 382C59 376 61 367 57 359C52 346 38 341 26 346C10 352 0 367 0 384C0 401 10 416 26 422L237 509C243 511 250 512 256 512C262 512 269 511 275 508L486 422C502 416 512 401 512 384C512 367 502 352 486 346ZM486 218C474 212 460 218 455 231C451 239 453 248 458 254L255 336L54 254C59 248 61 239 57 231C52 218 38 212 26 218C10 224 0 239 0 256S10 288 26 294L237 381C243 383 250 384 256 384C262 384 269 383 275 380L486 294C502 288 512 273 512 256S502 224 486 218Z"]
  };
  var faLayersMinus = {
    prefix: 'far',
    iconName: 'layers-minus',
    icon: [512, 512, [], "f5fe", "M486 346C474 340 460 346 455 359C451 367 453 376 458 382L255 464L54 382C59 376 61 367 57 359C52 346 38 340 26 346C10 352 0 367 0 384S10 416 26 422L237 509C243 511 250 512 256 512C262 512 269 511 275 508L486 422C502 416 512 401 512 384S502 352 486 346ZM486 218L275 132C263 127 249 127 237 132L26 218C10 224 0 239 0 256C0 273 10 288 26 294L237 381C243 383 250 384 256 384C262 384 269 383 275 380L486 294C502 288 512 273 512 256C512 239 502 224 486 218ZM255 336L59 256L257 176L453 256L255 336ZM376 104H488C501 104 512 93 512 80S501 56 488 56H376C363 56 352 67 352 80S363 104 376 104Z"]
  };
  var faLayersPlus = {
    prefix: 'far',
    iconName: 'layers-plus',
    icon: [512, 512, [], "f5ff", "M486 346C474 340 460 346 455 359C451 367 453 376 458 382L255 464L54 382C59 376 61 367 57 359C52 346 38 340 26 346C10 352 0 367 0 384S10 416 26 422L237 509C243 511 250 512 256 512C262 512 269 511 275 508L486 422C502 416 512 401 512 384S502 352 486 346ZM486 218L275 132C263 127 249 127 237 132L26 218C10 224 0 239 0 256C0 273 10 288 26 294L237 381C243 383 250 384 256 384C262 384 269 383 275 380L486 294C502 288 512 273 512 256C512 239 502 224 486 218ZM255 336L59 256L257 176L453 256L255 336ZM376 104H408V136C408 149 419 160 432 160S456 149 456 136V104H488C501 104 512 93 512 80S501 56 488 56H456V24C456 11 445 0 432 0S408 11 408 24V56H376C363 56 352 67 352 80S363 104 376 104Z"]
  };
  var faLeaf = {
    prefix: 'far',
    iconName: 'leaf',
    icon: [512, 512, [], "f06c", "M486 40C484 35 479 32 474 32C469 32 464 34 462 39C437 82 391 104 346 104C334 104 323 103 312 100C299 97 286 96 272 96H272C175 96 96 175 96 272C96 281 97 289 98 298C19 367 1 450 0 451C-2 464 6 477 19 480C21 480 22 480 24 480C35 480 45 472 48 461C48 457 61 401 113 348C142 407 202 448 272 448V448H272C295 448 317 443 337 436C442 401 512 293 512 165C512 122 503 77 486 40ZM322 390L320 390L319 391C304 397 288 400 272 400C217 400 170 365 152 316C194 287 251 263 330 256C343 255 353 243 352 230C351 217 339 207 326 208C249 215 190 237 145 264C149 197 204 144 272 144C283 144 292 145 301 147C316 151 331 152 346 152C388 152 428 139 459 114C462 131 464 148 464 165C464 272 407 362 322 390Z"]
  };
  var faLeafHeart = {
    prefix: 'far',
    iconName: 'leaf-heart',
    icon: [512, 512, [], "f4cb", "M486 40C484 35 479 32 474 32C469 32 464 34 462 39C437 82 391 104 346 104C334 104 323 103 312 100C299 97 286 96 272 96H272C175 96 96 175 96 272C96 281 97 289 98 297C18 366 1 448 0 451C-2 464 6 477 19 480C21 480 22 480 24 480C35 480 45 472 48 461C48 460 61 403 114 349C143 408 203 448 272 448V448H272C295 448 317 443 337 436C442 401 512 293 512 165C512 122 503 77 486 40ZM322 390L320 390L319 391C304 397 288 400 272 400C201 400 144 343 144 272C144 201 201 144 272 144C283 144 293 145 301 147C316 151 331 152 346 152C388 152 428 139 459 114C462 131 464 148 464 165C464 272 407 362 322 390ZM303 208L296 215L289 208C270 189 241 186 221 203C198 222 197 256 217 277L288 349C292 353 300 353 304 349L375 277C395 256 394 222 371 203C351 186 321 189 303 208Z"]
  };
  var faLeafMaple = {
    prefix: 'far',
    iconName: 'leaf-maple',
    icon: [512, 512, [], "f6f6", "M512 188C512 174 505 162 493 154C493 154 493 154 493 154L472 142L479 77C481 65 477 53 468 44S448 31 435 33L370 40L358 19C350 7 338 0 324 0C310 -1 297 7 290 18L257 70C257 69 257 69 256 68C246 59 232 55 219 58C217 59 215 60 213 61L207 64L179 33C164 14 131 15 118 32L89 64L82 61C81 60 79 59 77 58C63 55 49 59 39 69C29 78 25 92 28 105L54 232L39 238C24 245 15 259 14 275C14 291 24 305 38 311L127 351L7 471C-2 480 -2 496 7 505C12 510 18 512 24 512S36 510 41 505L161 385L201 474C207 488 221 498 237 498H237C253 497 267 488 274 473L280 458L406 484C420 487 434 483 444 473C453 463 457 449 454 435C453 433 452 431 451 430L448 423L479 395C489 388 494 376 494 364C494 352 489 341 480 334L448 305L452 299C452 297 453 295 454 293C457 280 453 266 444 256C443 255 443 255 442 255L494 222C505 215 512 202 512 188ZM340 263C330 269 326 282 331 293C335 304 347 309 359 306L398 296L397 299C391 309 393 321 402 329L442 364L402 400C393 407 391 419 397 429L399 433L271 407C260 404 249 410 244 421L237 437L200 355C199 353 197 352 196 350L313 233C322 224 322 208 313 199S288 190 279 199L162 316C160 315 159 313 157 312L75 275L91 268C102 263 108 252 105 241L79 113L83 115C93 121 105 118 112 110L148 70L183 110C191 118 203 121 213 115L216 114L206 153C203 165 208 177 219 181C230 186 243 182 249 172L323 55L337 78C342 86 351 90 360 89L431 81L423 152C422 161 426 170 434 175L457 189L340 263Z"]
  };
  var faLeafOak = {
    prefix: 'far',
    iconName: 'leaf-oak',
    icon: [512, 512, [], "f6f7", "M480 145C480 145 479 144 479 144C477 142 475 141 473 140C484 95 466 70 453 58C453 58 453 58 453 58C441 46 416 29 372 39C371 37 369 34 367 32C355 14 336 3 316 0C295 -2 276 5 261 19C252 27 247 36 242 44C239 49 236 53 234 58C218 48 200 45 182 48C161 53 144 66 133 86C119 112 121 138 124 161C115 161 105 162 97 166C79 173 66 188 61 207C57 222 57 239 60 253C63 263 66 272 70 281C72 287 75 293 76 300C79 309 78 312 76 318C68 342 70 367 81 389C82 391 83 392 84 394L7 471C-2 480 -2 496 7 505C12 510 18 512 24 512S36 510 41 505L118 428C120 429 121 430 123 431C145 442 170 444 196 436C200 434 203 433 212 436C219 437 225 440 231 442C240 446 249 450 259 452C266 453 273 454 280 454C288 454 297 453 305 451C324 446 339 433 346 415C350 407 351 398 351 388C374 391 400 393 426 379C446 368 459 351 464 330C467 312 464 294 454 278C459 276 464 273 468 270C476 265 485 260 493 251C507 236 514 216 512 196C509 176 498 157 480 145ZM458 219C455 222 449 226 442 230C433 235 424 240 415 246L407 250C401 254 396 260 395 267C394 274 396 281 400 286L410 299C416 305 418 313 417 320C415 327 411 333 404 337C391 343 376 343 355 340C348 340 341 339 333 338L316 336C307 335 298 340 293 348C288 356 289 366 294 374L298 379C299 381 299 381 300 382C303 388 304 393 302 397C300 402 296 404 292 405C285 406 277 407 270 405C262 403 256 401 249 398C241 395 233 392 225 390C216 387 209 386 203 386C192 386 184 389 179 391C171 393 163 393 155 391L313 233C322 224 322 208 313 199S288 190 279 199L121 357C119 349 119 341 122 332C124 325 129 311 123 287C121 279 117 271 114 263C112 256 109 250 107 242C105 235 106 227 107 220C108 216 111 212 115 210C119 208 124 209 130 212C131 213 132 213 133 214L138 218C146 223 156 224 164 219C172 214 177 205 176 196L174 179C173 171 173 164 172 157C169 136 169 121 176 108C179 101 185 97 192 95C199 94 207 96 213 102L226 112C231 116 239 118 245 117C252 116 258 111 262 105L267 97C272 87 277 78 283 69C286 63 290 57 293 54C300 48 306 48 311 48C317 49 324 53 328 59C330 62 331 64 332 67C340 84 360 92 379 87C391 83 408 81 419 91C419 92 420 92 420 93C421 93 421 93 421 93C431 104 429 121 425 133C420 152 428 172 446 180C448 181 450 182 452 184C452 184 453 184 453 184C459 189 463 195 464 201C464 206 464 212 458 219Z"]
  };
  var faLeft = {
    prefix: 'far',
    iconName: 'left',
    icon: [448, 512, [], "f355", "M220 446C232 441 240 429 240 416V336H400C426 336 448 314 448 288V224C448 198 426 176 400 176H240V96C240 83 232 71 220 66C208 61 195 64 185 73L9 233C3 240 0 248 0 256S3 272 9 279L185 439C195 448 208 451 220 446ZM55 256L192 135V224H400V288H192V377L55 256Z"]
  };
  var faLeftFromLine = {
    prefix: 'far',
    iconName: 'left-from-line',
    icon: [448, 512, [], "f348", "M240 379V336H304C330 336 352 314 352 288V224C352 198 330 176 304 176H240V133C240 91 191 69 160 97L9 233C3 240 0 248 0 256S3 272 9 279L160 415C191 442 240 421 240 379ZM55 256L192 135V224H304V288H192V377L55 256ZM448 424V88C448 75 437 64 424 64S400 75 400 88V424C400 437 411 448 424 448S448 437 448 424Z"]
  };
  var faLeftLong = {
    prefix: 'far',
    iconName: 'left-long',
    icon: [512, 512, [], "f30a", "M146 130C154 134 160 142 160 152V232H488C501 232 512 243 512 256C512 269 501 280 488 280H160V360C160 370 154 378 146 382C137 386 127 384 120 378L8 274C-3 264 -3 248 8 238L120 134C127 128 137 126 146 130Z"]
  };
  var faLeftRight = {
    prefix: 'far',
    iconName: 'left-right',
    icon: [512, 512, [], "f337", "M504 238L392 134C387 130 382 128 376 128C372 128 369 129 366 130C357 134 352 142 352 152V232H160V152C160 142 154 134 145 130C142 129 139 128 136 128C130 128 124 130 119 134L7 238C-2 247 -2 264 7 274L119 378C124 382 130 384 136 384C139 384 142 383 145 382C154 378 160 370 160 360V280H352V360C352 370 357 378 366 382C369 383 372 384 376 384C382 384 387 382 392 378L504 274C514 265 514 247 504 238Z"]
  };
  var faLeftToLine = {
    prefix: 'far',
    iconName: 'left-to-line',
    icon: [448, 512, [], "f34b", "M105 234C99 240 96 248 96 256S99 273 105 279L256 415C287 443 336 421 336 379V336H400C426 336 448 315 448 288V224C448 198 426 176 400 176H336V133C336 91 287 70 256 98L105 234ZM288 224H400V288H288V378L151 256L288 135V224ZM48 424V88C48 75 37 64 24 64S0 75 0 88V424C0 437 11 448 24 448S48 437 48 424Z"]
  };
  var faLemon = {
    prefix: 'far',
    iconName: 'lemon',
    icon: [448, 512, [], "f094", "M440 145C455 118 448 82 423 57C398 32 362 25 335 40C326 45 308 44 287 42C236 38 160 31 80 112C-1 192 6 269 10 319C12 340 13 358 8 367C-7 394 0 430 25 455C41 471 62 480 82 480C93 480 103 477 113 472C122 467 140 468 161 470C211 474 288 481 368 400C449 320 442 243 438 193C436 172 435 154 440 145ZM398 121C386 143 388 169 390 197C394 246 399 302 334 366C270 431 214 426 165 422C137 420 111 418 88 430C82 434 69 432 59 421C48 411 46 398 49 392C62 369 60 343 58 315C54 266 49 210 113 146C162 97 205 88 245 88C258 88 271 89 283 90C311 92 337 94 359 82C366 78 379 81 389 91L389 91C399 101 402 114 398 121ZM240 124C242 133 236 141 228 144C184 155 123 216 112 260C110 267 103 272 96 272C95 272 93 272 92 271C84 269 78 261 81 252C95 196 164 127 220 112C229 110 237 116 240 124Z"]
  };
  var faLessThan = {
    prefix: 'far',
    iconName: 'less-than',
    icon: [640, 512, [], "f536", "M-1070 234L-1406 74C-1418 69 -1432 74 -1438 86C-1443 98 -1438 112 -1426 118L-1136 256L-1426 394C-1438 400 -1443 414 -1438 426C-1434 435 -1425 440 -1416 440C-1413 440 -1409 439 -1406 438L-1070 278C-1061 274 -1056 265 -1056 256S-1061 238 -1070 234ZM-2594 86C-2600 74 -2614 69 -2626 74L-2962 234C-2971 238 -2976 247 -2976 256S-2971 274 -2962 278L-2626 438C-2623 439 -2619 440 -2616 440C-2607 440 -2598 435 -2594 426C-2589 414 -2594 400 -2606 394L-2896 256L-2606 118C-2594 112 -2589 98 -2594 86ZM98 353C102 363 111 368 120 368C123 368 126 367 129 366L465 222C474 218 480 210 480 200S474 182 465 178L129 34C117 29 103 34 98 47C93 59 98 73 111 78L395 200L111 322C98 327 93 341 98 353ZM488 432H88C75 432 64 443 64 456S75 480 88 480H488C501 480 512 469 512 456S501 432 488 432Z"]
  };
  var faLessThanEqual = {
    prefix: 'far',
    iconName: 'less-than-equal',
    icon: [448, 512, [], "f537", "M47 222L383 366C386 367 389 368 392 368C401 368 410 363 414 353C419 341 414 327 401 322L117 200L401 78C414 73 419 59 414 47C409 34 395 29 383 34L47 178C38 182 32 190 32 200S38 218 47 222ZM424 432H24C11 432 0 443 0 456S11 480 24 480H424C437 480 448 469 448 456S437 432 424 432Z"]
  };
  var faLifeRing = {
    prefix: 'far',
    iconName: 'life-ring',
    icon: [512, 512, [], "f1cd", "M442 408C476 366 496 314 496 256S476 146 442 104L449 97C458 88 458 72 449 63S424 54 415 63L408 70C366 36 314 16 256 16S146 36 104 70L97 63C88 54 72 54 63 63S54 88 63 97L70 104C36 146 16 198 16 256S36 366 70 408L63 415C54 424 54 440 63 449C68 454 74 456 80 456S92 454 97 449L104 442C146 476 198 496 256 496S366 476 408 442L415 449C420 454 426 456 432 456S444 454 449 449C458 440 458 424 449 415L442 408ZM448 256C448 300 433 341 407 374L338 304C347 290 352 274 352 256S347 222 338 208L407 138C433 171 448 212 448 256ZM208 256C208 230 230 208 256 208S304 230 304 256S282 304 256 304S208 282 208 256ZM256 64C300 64 341 79 374 105L304 174C290 165 274 160 256 160S222 165 208 174L138 105C171 79 212 64 256 64ZM64 256C64 212 79 171 105 138L174 208C165 222 160 238 160 256S165 290 174 304L105 374C79 341 64 300 64 256ZM256 448C212 448 171 433 138 407L208 338C222 347 238 352 256 352S290 347 304 338L374 407C341 433 300 448 256 448Z"]
  };
  var faLightCeiling = {
    prefix: 'far',
    iconName: 'light-ceiling',
    icon: [512, 512, [], "e016", "M320 448H192C192 483 221 512 256 512S320 483 320 448ZM0 380C-3 399 13 416 32 416H480C499 416 514 399 512 380C495 263 399 172 280 161V24C280 11 269 0 256 0H256C243 0 232 11 232 24V161C113 172 17 263 0 380ZM51 368C73 276 158 208 256 208S439 276 461 368H51Z"]
  };
  var faLightSwitch = {
    prefix: 'far',
    iconName: 'light-switch',
    icon: [384, 512, [], "e017", "M320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM336 448C336 457 329 464 320 464H214C211 454 202 448 192 448S173 454 170 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H170C173 58 182 64 192 64S211 58 214 48H320C329 48 336 55 336 64V448ZM240 96H144C118 96 96 118 96 144V368C96 394 118 416 144 416H240C266 416 288 394 288 368V144C288 118 266 96 240 96ZM240 368H144V280H240V368ZM240 232H144V144H240V232Z"]
  };
  var faLightSwitchOff = {
    prefix: 'far',
    iconName: 'light-switch-off',
    icon: [384, 512, [], "e018", "M320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM336 448C336 457 329 464 320 464H214C211 454 202 448 192 448S173 454 170 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H170C173 58 182 64 192 64S211 58 214 48H320C329 48 336 55 336 64V448ZM240 96H144C118 96 96 118 96 144V368C96 394 118 416 144 416H240C266 416 288 394 288 368V144C288 118 266 96 240 96ZM240 256H144V144H240V256Z"]
  };
  var faLightSwitchOn = {
    prefix: 'far',
    iconName: 'light-switch-on',
    icon: [384, 512, [], "e019", "M320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM336 448C336 457 329 464 320 464H214C211 454 202 448 192 448S173 454 170 464H64C55 464 48 457 48 448V64C48 55 55 48 64 48H170C173 58 182 64 192 64S211 58 214 48H320C329 48 336 55 336 64V448ZM240 96H144C118 96 96 118 96 144V368C96 394 118 416 144 416H240C266 416 288 394 288 368V144C288 118 266 96 240 96ZM240 368H144V272H240V368Z"]
  };
  var faLightbulb = {
    prefix: 'far',
    iconName: 'lightbulb',
    icon: [384, 512, [], "f0eb", "M112 454C112 461 114 467 117 472L134 498C140 506 152 512 161 512H223C232 512 244 506 250 498L267 472C270 468 272 460 272 454L272 416H112L112 454ZM192 0C90 0 16 83 16 176C16 220 32 261 60 292C76 311 102 350 112 383C112 383 112 384 112 384H272C272 384 272 383 272 383C282 350 308 311 324 292C352 261 368 220 368 176C368 79 289 0 192 0ZM288 260C273 278 253 306 239 336H145C131 306 111 278 96 260C75 237 64 207 64 176C64 113 112 48 192 48C263 48 320 105 320 176C320 207 309 237 288 260ZM176 80C132 80 96 116 96 160C96 169 103 176 112 176S128 169 128 160C128 134 150 112 176 112C185 112 192 105 192 96S185 80 176 80Z"]
  };
  var faLightbulbDollar = {
    prefix: 'far',
    iconName: 'lightbulb-dollar',
    icon: [384, 512, [], "f670", "M112 454C112 461 114 467 117 472L134 498C140 506 152 512 161 512H223C232 512 244 506 250 498L267 472C270 468 272 460 272 454L272 416H112L112 454ZM192 0C90 0 16 83 16 176C16 220 32 261 60 292C76 311 102 350 112 383C112 383 112 384 112 384H272C272 384 272 383 272 383C282 350 308 311 324 292C352 261 368 220 368 176C368 79 289 0 192 0ZM288 260C273 278 253 306 239 336H145C131 306 111 278 96 260C75 237 64 207 64 176C64 113 112 48 192 48C263 48 320 105 320 176C320 207 309 237 288 260ZM198 165L192 163C168 156 169 153 170 149C171 141 186 139 200 141C205 142 212 144 217 146C228 149 239 144 243 133C246 123 241 112 231 108C223 105 217 104 212 103V96C212 85 203 76 192 76S172 85 172 96V102C150 107 134 121 130 142C123 185 163 196 181 202L187 203C216 212 215 214 214 219C213 227 198 229 184 227C177 226 168 223 161 220L156 218C146 215 134 220 130 231C127 241 132 253 143 256L147 258C155 261 163 263 172 265V272C172 283 181 292 192 292S212 283 212 272V266C234 261 250 247 254 226C261 183 220 171 198 165Z"]
  };
  var faLightbulbExclamation = {
    prefix: 'far',
    iconName: 'lightbulb-exclamation',
    icon: [384, 512, [], "f671", "M192 88C179 88 168 99 168 112V208C168 221 179 232 192 232S216 221 216 208V112C216 99 205 88 192 88ZM192 256C179 256 168 267 168 280S179 304 192 304C205 304 216 293 216 280S205 256 192 256ZM192 0C90 0 16 83 16 176C16 220 32 261 60 292C76 311 102 350 112 383C112 383 112 384 112 384H272C272 384 272 383 272 383C282 350 308 311 324 292C352 261 368 220 368 176C368 79 289 0 192 0ZM288 260C273 278 253 306 239 336H145C131 306 111 278 96 260C75 237 64 207 64 176C64 113 112 48 192 48C263 48 320 105 320 176C320 207 309 237 288 260ZM112 454C112 461 114 467 117 472L134 498C140 506 152 512 161 512H223C232 512 244 506 250 498L267 472C270 468 272 460 272 454L272 416H112L112 454Z"]
  };
  var faLightbulbOn = {
    prefix: 'far',
    iconName: 'lightbulb-on',
    icon: [640, 512, [], "f672", "M107 287L52 319C44 323 39 331 39 340C39 349 44 357 51 361C59 365 68 365 76 361L131 329C142 322 146 307 140 296C133 285 118 281 107 287ZM131 55L76 23C68 19 59 19 51 23C44 27 39 35 39 44C39 53 44 61 52 65L107 97C114 101 124 101 131 97C139 93 143 85 143 76C143 67 139 59 131 55ZM112 192C112 179 101 168 88 168H24C11 168 0 179 0 192S11 216 24 216H88C101 216 112 205 112 192ZM521 100C525 100 529 99 533 97L588 65C600 58 603 43 597 32C590 21 576 17 564 23L509 55C499 61 495 72 498 82C501 93 510 100 521 100ZM616 168H552C539 168 528 179 528 192S539 216 552 216H616C629 216 640 205 640 192S629 168 616 168ZM588 319L533 287C526 283 516 283 509 287C501 291 497 299 497 308C497 317 501 325 509 329L564 361C576 367 590 363 597 352C603 341 599 326 588 319ZM320 0C218 0 144 83 144 176C144 220 160 261 188 292C204 311 230 350 240 383C240 383 240 384 240 384H400C400 384 400 383 400 383C410 350 436 311 452 292C480 261 496 220 496 176C496 79 417 0 320 0ZM416 260C401 278 381 306 367 336H273C259 306 239 278 224 260C203 237 192 207 192 176C192 113 240 48 320 48C391 48 448 105 448 176C448 207 437 237 416 260ZM240 454C240 461 242 467 245 472L262 498C268 506 280 512 289 512H351C360 512 372 506 378 498L395 472C398 468 400 460 400 454L400 416H240L240 454ZM304 80C260 80 224 116 224 160C224 169 231 176 240 176S256 169 256 160C256 134 278 112 304 112C313 112 320 105 320 96S313 80 304 80Z"]
  };
  var faLightbulbSlash = {
    prefix: 'far',
    iconName: 'lightbulb-slash',
    icon: [640, 512, [], "f673", "M631 469L435 315C441 306 447 298 452 292C480 261 496 220 496 176C496 79 417 0 320 0C247 0 189 43 162 101L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM397 286L200 132C217 86 259 48 320 48C391 48 448 105 448 176C448 207 437 237 416 260C410 267 404 276 397 286ZM306 336H273C265 319 255 303 245 288L148 212C154 242 168 270 188 292C204 311 230 350 240 383C240 383 240 384 240 384H367L306 336ZM240 454C240 461 242 467 245 472L263 498C268 506 280 512 289 512H351C360 512 372 506 378 498L395 472C398 468 400 460 400 454L400 416H240L240 454Z"]
  };
  var faLightsHoliday = {
    prefix: 'far',
    iconName: 'lights-holiday',
    icon: [640, 512, [], "f7b2", "M637 76C630 64 615 61 604 67C540 105 433 128 320 128S100 105 36 67C25 61 10 64 3 76C-3 87 0 102 12 109C46 129 90 145 140 156L118 229C88 230 61 249 52 279C40 317 55 406 86 415C116 424 178 359 190 321C199 291 187 260 163 243L187 166C222 171 258 174 296 175V260C268 270 248 297 248 328C248 368 288 448 320 448C352 448 392 368 392 328C392 297 372 270 344 260V175C382 174 418 171 453 166L477 243C453 260 441 291 450 321C462 359 524 424 554 415C585 406 600 317 588 279C579 249 552 230 522 229L500 156C550 145 594 129 628 109C640 102 643 87 637 76ZM144 307C139 322 119 346 103 359C97 339 93 308 98 293C102 281 115 273 128 277C140 281 148 295 144 307ZM542 293C547 308 543 339 537 359C521 346 501 322 496 307C492 295 500 281 512 277C525 273 538 281 542 293ZM320 390C309 372 296 344 296 328C296 315 307 304 320 304C333 304 344 315 344 328C344 344 332 372 320 390Z"]
  };
  var faLineColumns = {
    prefix: 'far',
    iconName: 'line-columns',
    icon: [512, 512, [], "f870", "M200 168H24C11 168 0 179 0 192V192C0 205 11 216 24 216H200C213 216 224 205 224 192V192C224 179 213 168 200 168ZM200 296H24C11 296 0 307 0 320V320C0 333 11 344 24 344H200C213 344 224 333 224 320V320C224 307 213 296 200 296ZM200 40H24C11 40 0 51 0 64V64C0 77 11 88 24 88H200C213 88 224 77 224 64V64C224 51 213 40 200 40ZM200 424H24C11 424 0 435 0 448V448C0 461 11 472 24 472H200C213 472 224 461 224 448V448C224 435 213 424 200 424ZM488 40H312C299 40 288 51 288 64V64C288 77 299 88 312 88H488C501 88 512 77 512 64V64C512 51 501 40 488 40ZM488 168H312C299 168 288 179 288 192V192C288 205 299 216 312 216H488C501 216 512 205 512 192V192C512 179 501 168 488 168ZM488 424H312C299 424 288 435 288 448V448C288 461 299 472 312 472H488C501 472 512 461 512 448V448C512 435 501 424 488 424ZM488 296H312C299 296 288 307 288 320V320C288 333 299 344 312 344H488C501 344 512 333 512 320V320C512 307 501 296 488 296Z"]
  };
  var faLineHeight = {
    prefix: 'far',
    iconName: 'line-height',
    icon: [576, 512, [], "f871", "M248 120H552C565 120 576 109 576 96C576 83 565 72 552 72H248C235 72 224 83 224 96C224 109 235 120 248 120ZM552 392H248C235 392 224 403 224 416C224 429 235 440 248 440H552C565 440 576 429 576 416C576 403 565 392 552 392ZM552 232H248C235 232 224 243 224 256C224 269 235 280 248 280H552C565 280 576 269 576 256C576 243 565 232 552 232ZM151 145C156 150 162 152 168 152S180 150 185 145C194 136 194 120 185 111L113 39C104 30 88 30 79 39L7 111C-2 120 -2 136 7 145S32 154 41 145L72 114V398L41 367C32 358 16 358 7 367S-2 392 7 401L79 473C84 478 90 480 96 480S108 478 113 473L185 401C194 392 194 376 185 367S160 358 151 367L120 398V114L151 145Z"]
  };
  var faLink = {
    prefix: 'far',
    iconName: 'link',
    icon: [640, 512, [], "f0c1", "M598 0C542 -56 450 -56 394 0L337 57C352 64 365 73 377 85L428 34C447 15 471 6 496 6C521 6 545 15 564 34C601 71 601 132 564 170L451 283C415 319 351 319 315 283C297 265 287 241 287 215C287 197 292 181 301 166C289 156 274 150 257 150C257 150 256 150 255 150C245 170 239 192 239 215C239 253 254 290 281 317C308 344 344 359 383 359C421 359 458 344 485 317L598 204C654 148 654 56 598 0ZM212 394C193 413 169 422 144 422C119 422 95 413 76 394C39 356 39 296 76 258L189 145C225 109 289 109 325 145C343 163 353 187 353 213C353 230 348 247 339 262C351 272 366 278 383 278C383 278 384 278 385 278C395 258 401 236 401 213C401 174 386 138 359 111C332 84 296 69 257 69C219 69 182 84 155 111L42 224C-14 280 -14 372 42 428C98 484 190 484 246 428L303 371C288 364 275 354 263 343L212 394Z"]
  };
  var faLinkHorizontal = {
    prefix: 'far',
    iconName: 'link-horizontal',
    icon: [640, 512, [], "e15d", "M144 304C91 304 48 261 48 208S91 112 144 112H304C357 112 400 155 400 208S357 304 304 304H272C272 323 281 340 294 352H304C383 352 448 287 448 208S383 64 304 64H144C65 64 0 129 0 208S65 352 144 352H167C163 337 160 321 160 304H144ZM496 160H473C477 175 480 191 480 208H496C549 208 592 251 592 304S549 400 496 400H336C283 400 240 357 240 304S283 208 336 208H368C368 189 359 172 346 160H336C257 160 192 225 192 304S257 448 336 448H496C575 448 640 383 640 304S575 160 496 160Z"]
  };
  var faLinkHorizontalSlash = {
    prefix: 'far',
    iconName: 'link-horizontal-slash',
    icon: [640, 512, [], "e15e", "M144 304C91 304 48 261 48 208C48 186 56 166 68 150L30 121C12 145 0 175 0 208C0 287 65 352 144 352H167C163 337 160 321 160 304H144ZM574 424C613 399 640 355 640 304C640 225 575 160 496 160H473C477 175 480 191 480 208H496C549 208 592 251 592 304C592 344 568 378 533 393L414 299C435 275 448 243 448 208C448 129 383 64 304 64H144C135 64 126 65 118 67L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469L574 424ZM377 270L305 214C315 210 325 208 336 208H368C368 189 359 172 346 160H336C309 160 284 168 263 181L175 112H304C357 112 400 155 400 208C400 232 391 253 377 270ZM336 400C283 400 240 357 240 304C240 298 241 292 242 286L201 254C196 270 192 287 192 304C192 383 257 448 336 448H448L387 400H336Z"]
  };
  var faLinkSlash = {
    prefix: 'far',
    iconName: 'link-slash',
    icon: [640, 512, [], "f127", "M212 436C193 455 169 464 144 464C119 464 95 455 76 436C39 399 39 338 76 300L157 220L119 190L42 266C-14 322 -14 414 42 470C98 526 190 526 246 470L303 413C288 406 275 397 263 385L212 436ZM487 356L598 246C654 190 654 98 598 42C542 -14 450 -14 394 42L337 99C352 106 365 115 377 127L428 76C447 57 471 48 496 48C521 48 545 57 564 76C601 113 601 174 564 212L451 325C450 326 450 326 449 327L397 286C400 276 401 266 401 255C401 217 386 180 359 153C332 126 296 111 257 111C235 111 213 117 194 126L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469L487 356ZM239 162C269 156 302 164 325 187C342 204 352 227 353 251L239 162ZM281 359C308 386 344 401 383 401C385 401 386 401 388 401L242 286C248 314 261 339 281 359Z"]
  };
  var faLips = {
    prefix: 'far',
    iconName: 'lips',
    icon: [576, 512, [], "f600", "M568 202C522 125 420 64 376 64C376 64 347 64 288 109C229 64 200 64 200 64C156 64 54 125 8 202C-1 217 -2 236 4 252C30 312 106 448 251 448H325C470 448 546 312 571 252C578 236 577 217 568 202ZM325 400H251C128 400 65 273 49 234C48 231 48 229 49 226C87 164 171 115 198 112C203 114 224 120 259 147L288 170L317 147C352 120 373 114 378 112C405 115 489 164 527 227C528 229 528 231 527 234C511 273 448 400 325 400ZM333 216C319 220 304 222 288 222S257 220 243 216L216 208C144 208 96 236 96 236S160 320 288 320S480 236 480 236S432 208 360 208L333 216Z"]
  };
  var faLiraSign = {
    prefix: 'far',
    iconName: 'lira-sign',
    icon: [320, 512, [], "f195", "M320 456C320 469 309 480 296 480H24C15 480 7 475 3 467C-2 459 -1 449 5 442C26 413 40 379 45 344H24C11 344 0 333 0 320S11 296 24 296H48V248H24C11 248 0 237 0 224S11 200 24 200H48V159C48 89 105 32 175 32C189 32 203 34 216 39L296 65C308 69 315 83 311 96C307 108 293 115 280 111L200 84C192 81 184 80 175 80C132 80 96 116 96 159V200H232C245 200 256 211 256 224S245 248 232 248H96V296H232C245 296 256 307 256 320S245 344 232 344H94C90 375 81 405 67 432H296C309 432 320 443 320 456Z"]
  };
  var faList = {
    prefix: 'far',
    iconName: 'list',
    icon: [512, 512, [], "f03a", "M80 208H16C7 208 0 215 0 224V288C0 297 7 304 16 304H80C89 304 96 297 96 288V224C96 215 89 208 80 208ZM80 368H16C7 368 0 375 0 384V448C0 457 7 464 16 464H80C89 464 96 457 96 448V384C96 375 89 368 80 368ZM80 48H16C7 48 0 55 0 64V128C0 137 7 144 16 144H80C89 144 96 137 96 128V64C96 55 89 48 80 48ZM488 232H184C171 232 160 243 160 256V256C160 269 171 280 184 280H488C501 280 512 269 512 256V256C512 243 501 232 488 232ZM488 72H184C171 72 160 83 160 96V96C160 109 171 120 184 120H488C501 120 512 109 512 96V96C512 83 501 72 488 72ZM488 392H184C171 392 160 403 160 416V416C160 429 171 440 184 440H488C501 440 512 429 512 416V416C512 403 501 392 488 392Z"]
  };
  var faListCheck = {
    prefix: 'far',
    iconName: 'list-check',
    icon: [512, 512, [], "f0ae", "M216 120H488C501 120 512 109 512 96C512 83 501 72 488 72H216C203 72 192 83 192 96C192 109 203 120 216 120ZM48 384C30 384 16 398 16 416C16 434 30 448 48 448S80 434 80 416C80 398 66 384 48 384ZM488 232H216C203 232 192 243 192 256C192 269 203 280 216 280H488C501 280 512 269 512 256C512 243 501 232 488 232ZM488 392H184C171 392 160 403 160 416C160 429 171 440 184 440H488C501 440 512 429 512 416C512 403 501 392 488 392ZM118 40L63 101L41 79C32 70 16 70 7 79S-2 104 7 113L47 153C52 157 58 160 64 160C64 160 64 160 65 160C71 160 77 157 82 152L154 72C163 62 162 47 152 38C142 29 127 30 118 40ZM118 200L63 261L41 239C32 230 16 230 7 239S-2 264 7 273L47 313C52 317 58 320 64 320C64 320 64 320 65 320C71 320 77 317 82 312L154 232C163 222 162 207 152 198C142 189 127 190 118 200Z"]
  };
  var faListDropdown = {
    prefix: 'far',
    iconName: 'list-dropdown',
    icon: [512, 512, [], "e15f", "M128 280H384C397 280 408 269 408 256C408 243 397 232 384 232H128C115 232 104 243 104 256C104 269 115 280 128 280ZM448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM360 96H440C447 96 451 105 446 110L406 150C402 153 398 153 394 150L354 110C350 105 352 96 360 96ZM464 416C464 425 457 432 448 432H64C55 432 48 425 48 416V192H464V416ZM128 376H384C397 376 408 365 408 352C408 339 397 328 384 328H128C115 328 104 339 104 352C104 365 115 376 128 376Z"]
  };
  var faListMusic = {
    prefix: 'far',
    iconName: 'list-music',
    icon: [512, 512, [], "f8c9", "M24 96H264C277 96 288 85 288 72S277 48 264 48H24C11 48 0 59 0 72S11 96 24 96ZM499 6C491 0 480 -2 470 1L358 37C345 41 336 53 336 67V366C318 357 296 352 272 352C210 352 160 388 160 432C160 476 210 512 272 512S384 476 384 432V195L490 162C503 158 512 145 512 131V32C512 22 507 12 499 6ZM272 464C232 464 208 443 208 432C208 421 232 400 272 400S336 421 336 432C336 443 312 464 272 464ZM464 120L384 145V79L464 54V120ZM24 224H264C277 224 288 213 288 200S277 176 264 176H24C11 176 0 187 0 200S11 224 24 224ZM136 304H24C11 304 0 315 0 328S11 352 24 352H136C149 352 160 341 160 328S149 304 136 304Z"]
  };
  var faListOl = {
    prefix: 'far',
    iconName: 'list-ol',
    icon: [512, 512, [], "f0cb", "M120 176H104V48C104 39 97 32 88 32H51C43 32 36 36 31 43L31 43C21 59 33 80 51 80H56V176H40C27 176 16 187 16 200V200C16 213 27 224 40 224H120C133 224 144 213 144 200V200C144 187 133 176 120 176ZM488 392H216C203 392 192 403 192 416V416C192 429 203 440 216 440H488C501 440 512 429 512 416V416C512 403 501 392 488 392ZM120 432H58L59 431C61 425 69 420 81 413C105 399 136 381 136 342C136 295 94 282 69 282C35 282 17 298 7 311C3 315 0 322 10 330L24 341C29 345 35 347 45 337C50 333 56 330 63 330C72 330 82 336 82 348C82 357 72 364 58 373C34 389 0 411 0 459V466C0 475 6 480 15 480H120C133 480 144 469 144 456V456C144 443 133 432 120 432ZM488 72H216C203 72 192 83 192 96V96C192 109 203 120 216 120H488C501 120 512 109 512 96V96C512 83 501 72 488 72ZM488 232H216C203 232 192 243 192 256V256C192 269 203 280 216 280H488C501 280 512 269 512 256V256C512 243 501 232 488 232Z"]
  };
  var faListRadio = {
    prefix: 'far',
    iconName: 'list-radio',
    icon: [512, 512, [], "e160", "M184 120H488C501 120 512 109 512 96S501 72 488 72H184C171 72 160 83 160 96S171 120 184 120ZM488 392H184C171 392 160 403 160 416S171 440 184 440H488C501 440 512 429 512 416S501 392 488 392ZM488 232H184C171 232 160 243 160 256S171 280 184 280H488C501 280 512 269 512 256S501 232 488 232ZM100 43C90 36 77 32 64 32C29 32 0 61 0 96S29 160 64 160C77 160 90 156 100 149C107 144 112 139 117 132C124 122 128 109 128 96S124 70 117 60C112 53 107 48 100 43ZM64 192C29 192 0 221 0 256S29 320 64 320C99 320 128 291 128 256S99 192 64 192ZM64 280C51 280 40 269 40 256C40 243 51 232 64 232C77 232 88 243 88 256C88 269 77 280 64 280ZM64 352C29 352 0 381 0 416S29 480 64 480C99 480 128 451 128 416S99 352 64 352ZM64 440C51 440 40 429 40 416C40 403 51 392 64 392C77 392 88 403 88 416C88 429 77 440 64 440Z"]
  };
  var faListTree = {
    prefix: 'far',
    iconName: 'list-tree',
    icon: [512, 512, [], "e161", "M184 120H488C501 120 512 109 512 96S501 72 488 72H184C171 72 160 83 160 96S171 120 184 120ZM208 208H144C135 208 128 215 128 224V232H72V144H80C89 144 96 137 96 128V64C96 55 89 48 80 48H16C7 48 0 55 0 64V128C0 137 7 144 16 144H24V384C24 415 49 440 80 440H128V448C128 457 135 464 144 464H208C217 464 224 457 224 448V384C224 375 217 368 208 368H144C135 368 128 375 128 384V392H80C76 392 72 388 72 384V280H128V288C128 297 135 304 144 304H208C217 304 224 297 224 288V224C224 215 217 208 208 208ZM488 392H312C299 392 288 403 288 416S299 440 312 440H488C501 440 512 429 512 416S501 392 488 392ZM488 232H312C299 232 288 243 288 256S299 280 312 280H488C501 280 512 269 512 256S501 232 488 232Z"]
  };
  var faListUl = {
    prefix: 'far',
    iconName: 'list-ul',
    icon: [512, 512, [], "f0ca", "M32 224C14 224 0 238 0 256C0 274 14 288 32 288S64 274 64 256C64 238 50 224 32 224ZM32 64C14 64 0 78 0 96C0 114 14 128 32 128S64 114 64 96C64 78 50 64 32 64ZM32 384C14 384 0 398 0 416C0 434 14 448 32 448S64 434 64 416C64 398 50 384 32 384ZM472 72H168C155 72 144 83 144 96V96C144 109 155 120 168 120H472C485 120 496 109 496 96V96C496 83 485 72 472 72ZM472 392H168C155 392 144 403 144 416V416C144 429 155 440 168 440H472C485 440 496 429 496 416V416C496 403 485 392 472 392ZM472 232H168C155 232 144 243 144 256V256C144 269 155 280 168 280H472C485 280 496 269 496 256V256C496 243 485 232 472 232Z"]
  };
  var faLocation = {
    prefix: 'far',
    iconName: 'location',
    icon: [384, 512, [], "f041", "M192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446Z"]
  };
  var faLocationArrow = {
    prefix: 'far',
    iconName: 'location-arrow',
    icon: [448, 512, [], "f124", "M434 46C425 37 412 32 400 32C394 32 388 33 382 36L30 180C9 188 -4 211 1 233C5 256 25 272 48 272H208V432C208 456 227 480 256 480C275 480 293 468 300 450L444 98C452 80 448 60 434 46ZM400 80L256 432V224H208L48 224L400 80L400 80Z"]
  };
  var faLocationCheck = {
    prefix: 'far',
    iconName: 'location-check',
    icon: [384, 512, [], "f606", "M192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446ZM250 136L171 229L133 191C124 182 108 182 99 191S90 216 99 225L155 281C160 285 166 288 172 288C172 288 173 288 173 288C180 288 186 285 190 280L286 168C295 158 294 142 284 134C274 125 258 126 250 136Z"]
  };
  var faLocationCrosshairs = {
    prefix: 'far',
    iconName: 'location-crosshairs',
    icon: [512, 512, [], "f601", "M256 168C207 168 168 207 168 256S207 344 256 344S344 305 344 256S305 168 256 168ZM256 296C234 296 216 278 216 256C216 234 234 216 256 216C278 216 296 234 296 256C296 278 278 296 256 296ZM488 232H446C435 145 367 77 280 66V24C280 11 269 0 256 0H256C243 0 232 11 232 24V66C145 77 77 145 66 232H24C11 232 0 243 0 256V256C0 269 11 280 24 280H66C77 367 145 435 232 446V488C232 501 243 512 256 512H256C269 512 280 501 280 488V446C367 435 435 367 446 280H488C501 280 512 269 512 256V256C512 243 501 232 488 232ZM256 400C177 400 112 335 112 256S177 112 256 112S400 177 400 256S335 400 256 400Z"]
  };
  var faLocationCrosshairsSlash = {
    prefix: 'far',
    iconName: 'location-crosshairs-slash',
    icon: [640, 512, [], "f603", "M631 469L484 354C497 332 507 307 510 280H552C565 280 576 269 576 256C576 243 565 232 552 232H510C499 145 431 77 344 66V24C344 11 333 0 320 0S296 11 296 24V66C253 71 215 91 186 120L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM360 257L310 218C314 217 317 216 320 216C342 216 360 234 360 256C360 256 360 256 360 257ZM446 324L401 289C405 279 408 268 408 256C408 207 369 168 320 168C301 168 283 174 268 185L224 150C249 127 283 112 320 112C399 112 464 177 464 256C464 281 457 304 446 324ZM320 400C241 400 176 335 176 256C176 249 177 243 178 236L136 203C133 212 131 222 130 232H88C75 232 64 243 64 256C64 269 75 280 88 280H130C141 367 209 435 296 446V488C296 501 307 512 320 512S344 501 344 488V446C370 443 394 434 415 422L374 389C357 396 339 400 320 400Z"]
  };
  var faLocationDot = {
    prefix: 'far',
    iconName: 'location-dot',
    icon: [384, 512, [], "f3c5", "M192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446ZM192 112C148 112 112 148 112 192S148 272 192 272C236 272 272 236 272 192S236 112 192 112ZM192 224C174 224 160 210 160 192S174 160 192 160S224 174 224 192S210 224 192 224Z"]
  };
  var faLocationDotSlash = {
    prefix: 'far',
    iconName: 'location-dot-slash',
    icon: [640, 512, [], "f605", "M631 469L457 333C501 268 512 241 512 192C512 86 426 0 320 0C249 0 188 39 155 96L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM320 224C319 224 318 224 317 223L290 202C289 199 288 196 288 192C288 174 302 160 320 160S352 174 352 192S338 224 320 224ZM363 259C385 245 400 220 400 192C400 148 364 112 320 112C285 112 255 135 245 166L193 126C217 80 265 48 320 48C399 48 464 113 464 192C464 227 458 245 419 303L363 259ZM320 446C302 420 287 398 273 378C220 303 196 268 185 242L128 197C129 270 158 296 300 502C305 509 313 512 320 512S335 509 340 502C364 467 384 438 402 412L364 382C351 401 337 422 320 446Z"]
  };
  var faLocationExclamation = {
    prefix: 'far',
    iconName: 'location-exclamation',
    icon: [384, 512, [], "f608", "M192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446ZM192 240C205 240 216 229 216 216V120C216 107 205 96 192 96S168 107 168 120V216C168 229 179 240 192 240ZM192 272C174 272 160 286 160 304C160 322 174 336 192 336S224 322 224 304C224 286 210 272 192 272Z"]
  };
  var faLocationMinus = {
    prefix: 'far',
    iconName: 'location-minus',
    icon: [384, 512, [], "f609", "M192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446ZM256 168H128C115 168 104 179 104 192S115 216 128 216H256C269 216 280 205 280 192S269 168 256 168Z"]
  };
  var faLocationPen = {
    prefix: 'far',
    iconName: 'location-pen',
    icon: [384, 512, [], "f607", "M192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446ZM255 112C250 107 243 104 236 104S221 107 216 112L132 196C128 200 125 205 124 210L112 264C111 268 115 272 119 272C119 272 120 272 120 272C120 272 157 264 174 260C179 259 184 257 187 253C209 231 234 206 272 168C283 157 283 140 272 129L255 112Z"]
  };
  var faLocationPlus = {
    prefix: 'far',
    iconName: 'location-plus',
    icon: [384, 512, [], "f60a", "M256 168H216V128C216 115 205 104 192 104S168 115 168 128V168H128C115 168 104 179 104 192S115 216 128 216H168V256C168 269 179 280 192 280S216 269 216 256V216H256C269 216 280 205 280 192S269 168 256 168ZM192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446Z"]
  };
  var faLocationQuestion = {
    prefix: 'far',
    iconName: 'location-question',
    icon: [384, 512, [], "f60b", "M192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446ZM192 288C174 288 160 302 160 320C160 338 174 352 192 352S224 338 224 320C224 302 210 288 192 288ZM195 80C153 80 118 109 109 148C107 158 114 168 124 168H141C148 168 154 163 156 156C162 140 177 128 195 128C221 128 235 149 235 168C235 184 215 195 184 210C176 215 171 223 171 232V248C171 257 178 264 186 264H203C212 264 219 257 219 248V247C250 230 283 209 283 168C283 125 250 80 195 80Z"]
  };
  var faLocationSlash = {
    prefix: 'far',
    iconName: 'location-slash',
    icon: [640, 512, [], "f60c", "M320 446C302 420 287 398 273 378C220 303 196 268 185 242L128 197C129 270 158 296 300 502C305 509 313 512 320 512S335 509 340 502C364 467 384 438 402 412L364 382C351 401 337 422 320 446ZM631 469L457 333C501 268 512 241 512 192C512 86 426 0 320 0C249 0 188 39 155 96L39 5C34 2 29 0 24 0C17 0 10 3 5 9C-3 20 -1 35 9 43L601 507C612 515 627 513 635 503C643 492 641 477 631 469ZM193 126C217 80 265 48 320 48C399 48 464 113 464 192C464 227 458 245 419 303L193 126Z"]
  };
  var faLocationSmile = {
    prefix: 'far',
    iconName: 'location-smile',
    icon: [384, 512, [], "f60d", "M192 0C86 0 0 86 0 192C0 269 26 291 173 502C178 509 185 512 192 512S206 509 211 502C358 291 384 269 384 192C384 86 298 0 192 0ZM192 446C178 425 165 407 153 390C58 257 48 240 48 192C48 113 113 48 192 48S336 113 336 192C336 240 326 257 231 390C219 407 206 426 192 446ZM136 176C149 176 160 165 160 152S149 128 136 128C123 128 112 139 112 152S123 176 136 176ZM248 176C261 176 272 165 272 152S261 128 248 128S224 139 224 152S235 176 248 176ZM238 227C215 254 169 254 146 227C137 217 122 216 112 225C102 234 101 249 110 259C131 282 161 296 192 296C223 296 253 282 274 259C283 249 282 234 272 225C262 216 247 217 238 227Z"]
  };
  var faLocationTimes = {
    prefix: 'far',
    iconName: 'location-times',
    icon: [384, 512, [], "f60e", "M254 220L226 192L254 164C264 154 264 139 254 130C245 120 230 120 220 130L192 158L164 130C154 120 139 120 130 130C120 139 120 154 130 164L158 192L130 220C120 230 120 245 130 254C139 264 154 264 164 254L192 226L220 254C230 264 245 264 254 254S264 230 254 220ZM192 0C86 0 0 86 0 192C0 269 27 291 172 502C177 509 185 512 192 512S207 509 212 502C357 291 384 269 384 192C384 86 298 0 192 0ZM192 446C174 420 159 398 145 378C58 254 48 239 48 192C48 113 113 48 192 48S336 113 336 192C336 239 326 254 239 378C225 398 210 420 192 446Z"]
  };
  var faLock = {
    prefix: 'far',
    iconName: 'lock',
    icon: [512, 512, [], "f023", "M416 192H384V128C384 57 327 0 256 0S128 57 128 128V192H96C61 192 32 221 32 256V448C32 483 61 512 96 512H416C451 512 480 483 480 448V256C480 221 451 192 416 192ZM176 128C176 84 212 48 256 48S336 84 336 128V192H176V128ZM432 448C432 457 425 464 416 464H96C87 464 80 457 80 448V256C80 247 87 240 96 240H416C425 240 432 247 432 256V448Z"]
  };
  var faLockKeyhole = {
    prefix: 'far',
    iconName: 'lock-keyhole',
    icon: [512, 512, [], "f30d", "M416 192H384V128C384 57 327 0 256 0S128 57 128 128V192H96C61 192 32 221 32 256V448C32 483 61 512 96 512H416C451 512 480 483 480 448V256C480 221 451 192 416 192ZM176 128C176 84 212 48 256 48S336 84 336 128V192H176V128ZM432 448C432 457 425 464 416 464H96C87 464 80 457 80 448V256C80 247 87 240 96 240H416C425 240 432 247 432 256V448ZM256 304C243 304 232 315 232 328V376C232 389 243 400 256 400S280 389 280 376V328C280 315 269 304 256 304Z"]
  };
  var faLockKeyholeOpen = {
    prefix: 'far',
    iconName: 'lock-keyhole-open',
    icon: [576, 512, [], "f3c2", "M432 0C361 0 304 57 304 128V192H64C29 192 0 221 0 256V448C0 483 29 512 64 512H384C419 512 448 483 448 448V256C448 221 419 192 384 192H352V128C352 84 388 48 432 48S512 84 512 128V200C512 213 523 224 536 224S560 213 560 200V128C560 57 503 0 432 0ZM384 240C393 240 400 247 400 256V448C400 457 393 464 384 464H64C55 464 48 457 48 448V256C48 247 55 240 64 240H384ZM224 400C237 400 248 389 248 376V328C248 315 237 304 224 304S200 315 200 328V376C200 389 211 400 224 400Z"]
  };
  var faLockOpen = {
    prefix: 'far',
    iconName: 'lock-open',
    icon: [576, 512, [], "f3c1", "M432 0C361 0 304 57 304 128V192H64C29 192 0 221 0 256V448C0 483 29 512 64 512H384C419 512 448 483 448 448V256C448 221 419 192 384 192H352V128C352 84 388 48 432 48S512 84 512 128V200C512 213 523 224 536 224S560 213 560 200V128C560 57 503 0 432 0ZM384 240C393 240 400 247 400 256V448C400 457 393 464 384 464H64C55 464 48 457 48 448V256C48 247 55 240 64 240H384ZM224 400C237 400 248 389 248 376V328C248 315 237 304 224 304S200 315 200 328V376C200 389 211 400 224 400Z"]
  };
  var faLoveseat = {
    prefix: 'far',
    iconName: 'loveseat',
    icon: [512, 512, [], "f4cc", "M448 224C413 224 384 253 384 288H128C128 253 99 224 64 224C29 224 0 253 0 288V448C0 466 14 480 32 480H96C114 480 128 466 128 448H384C384 466 398 480 416 480H480C498 480 512 466 512 448V288C512 253 483 224 448 224ZM80 432H48V288C48 279 55 272 64 272S80 279 80 288V432ZM384 400H128V336H384V400ZM464 432H432V288C432 279 439 272 448 272S464 279 464 288V432ZM88 192C101 192 112 181 112 168V152C112 112 144 80 184 80H328C368 80 400 112 400 152V168C400 181 411 192 424 192S448 181 448 168V152C448 86 394 32 328 32H184C118 32 64 86 64 152V168C64 181 75 192 88 192Z"]
  };
  var faLuchadorMask = {
    prefix: 'far',
    iconName: 'luchador-mask',
    icon: [448, 512, [], "f455", "M224 0C100 0 0 100 0 224V352C0 440 72 512 160 512H288C376 512 448 440 448 352V224C448 100 348 0 224 0ZM400 352C400 414 350 464 288 464H160C98 464 48 414 48 352V224C48 127 127 48 224 48S400 127 400 224V352ZM226 226C226 226 222 226 221 226C213 188 182 160 144 160H76C69 160 64 165 64 172V203C64 250 100 288 144 288H166C159 300 154 311 151 321C120 326 96 352 96 384C96 419 125 448 161 448H287C322 448 352 419 352 384C352 352 328 326 297 321C294 311 289 300 282 288H304C348 288 384 250 384 203V172C384 165 379 160 372 160H304C266 160 235 188 226 226ZM224 267C244 287 256 305 263 320H185C192 305 204 287 224 267ZM144 256C118 256 96 232 96 203V192H144C170 192 192 216 192 245V254C191 255 191 255 190 256H144ZM288 352C306 352 320 366 320 384S306 416 288 416H160C142 416 128 402 128 384S142 352 160 352H288ZM352 203C352 232 330 256 304 256H258C257 255 257 255 256 254V245C256 216 278 192 304 192H352V203Z"]
  };
  var faLungs = {
    prefix: 'far',
    iconName: 'lungs',
    icon: [640, 512, [], "f604", "M640 420C640 472 594 512 542 512C524 512 518 509 455 493C413 481 384 445 384 404V323L432 357V404C432 423 447 441 468 446C532 463 532 464 542 464C572 464 600 440 590 403C569 326 537 253 494 185C471 149 468 144 454 144C442 144 432 152 432 162V258L502 308C513 316 515 331 508 342C503 349 495 352 488 352C483 352 478 351 474 348L320 237L166 348C162 351 157 352 152 352C145 352 137 349 132 342C125 331 127 316 138 308L208 258V162C208 152 198 144 186 144C172 144 169 149 146 185C103 253 71 326 50 402C40 440 68 464 98 464C108 464 108 463 172 446C193 440 208 423 208 404V357L256 323V404C256 445 227 481 185 493C122 509 116 512 98 512C46 512 0 472 0 420C0 410 1 400 4 390C26 309 60 231 106 159C128 125 142 96 186 96C225 96 256 125 256 162V224L293 198C295 197 296 194 296 192V24C296 11 307 0 320 0S344 11 344 24V192C344 194 345 197 347 198L384 224V162C384 125 415 96 454 96C498 96 512 125 534 159C580 231 614 309 636 390C639 400 640 410 640 420Z"]
  };
  var faLungsVirus = {
    prefix: 'far',
    iconName: 'lungs-virus',
    icon: [640, 512, [], "e067", "M196 444C193 442 192 439 190 437C185 441 179 444 172 446C108 463 108 464 98 464C68 464 40 440 50 403C71 326 103 253 146 185C169 149 172 144 186 144C198 144 208 152 208 162V187C215 183 222 182 229 182C239 182 248 184 256 190V162C256 125 225 96 186 96C142 96 128 125 106 159C60 231 26 309 4 390C1 400 0 410 0 420C0 472 46 512 98 512C116 512 122 509 185 492C206 487 225 474 237 458C235 458 232 459 229 459C217 458 205 454 196 444ZM344 151V24C344 11 333 0 320 0S296 11 296 24V151C303 147 311 144 320 144S337 147 344 151ZM422 422C428 416 428 405 422 399L413 391C393 370 407 336 436 336H448C457 336 464 329 464 320S457 304 448 304H436C407 304 393 270 413 249L422 241C428 235 428 224 422 218S405 212 399 218L391 227C370 247 336 233 336 204V192C336 183 329 176 320 176S304 183 304 192V204C304 233 270 247 249 227L241 218C235 212 224 212 218 218S212 235 218 241L227 249C247 270 233 304 204 304H192C183 304 176 311 176 320S183 336 192 336H204C233 336 247 370 227 391L218 399C212 405 212 416 218 422C221 425 225 426 230 426S238 425 241 422L249 413C270 393 304 407 304 436V448C304 457 311 464 320 464S336 457 336 448V436C336 407 370 393 391 413L399 422C402 425 406 426 411 426S419 425 422 422ZM288 304C279 304 272 297 272 288C272 279 279 272 288 272S304 279 304 288C304 297 297 304 288 304ZM352 368C343 368 336 361 336 352C336 343 343 336 352 336S368 343 368 352C368 361 361 368 352 368ZM636 390C614 309 580 231 534 159C512 125 498 96 454 96C415 96 384 125 384 162V189C392 184 401 181 410 181C418 181 425 183 432 187V162C432 152 442 144 454 144C468 144 471 149 494 185C537 253 569 326 590 402C600 440 572 464 542 464C532 464 532 463 468 446C461 444 455 441 450 437C448 439 447 442 444 444C435 453 423 458 410 458C408 458 405 458 403 458C415 474 434 487 455 492C517 509 524 512 542 512C594 512 640 472 640 420C640 410 639 400 636 390Z"]
  };
  var faM = {
    prefix: 'far',
    iconName: 'm',
    icon: [448, 512, [], "e162", "M416 480C398 480 384 466 384 448V170L251 370C239 388 209 388 197 370L64 170V448C64 466 50 480 32 480S0 466 0 448V64C0 50 9 37 23 33C36 29 51 35 59 46L224 294L389 46C397 35 412 29 425 33C439 37 448 50 448 64V448C448 466 434 480 416 480Z"]
  };
  var faMace = {
    prefix: 'far',
    iconName: 'mace',
    icon: [512, 512, [], "f6f8", "M500 210L419 184C406 139 370 104 325 91L298 11C296 4 292 1 288 0C284 1 280 4 278 11L251 91C206 104 170 139 157 184L76 210C60 215 60 228 76 234L156 261C160 276 167 290 176 302L7 471C-2 480 -2 496 7 505C12 510 18 512 24 512S36 510 41 505L209 336C221 345 234 351 248 356L274 437C277 446 283 449 288 448C293 449 299 446 302 437L328 356C373 342 408 306 420 261L500 234C516 228 516 215 500 210ZM288 312C240 312 200 272 200 224C200 176 240 136 288 136S376 176 376 224C376 272 336 312 288 312ZM288 192C270 192 256 206 256 224S270 256 288 256S320 242 320 224S306 192 288 192Z"]
  };
  var faMagnet = {
    prefix: 'far',
    iconName: 'magnet',
    icon: [448, 512, [], "f076", "M408 32H328C306 32 288 50 288 72V256C288 291 259 320 224 320S160 291 160 256V72C160 50 142 32 120 32H40C18 32 0 50 0 72V256C0 380 100 480 224 480S448 380 448 256V72C448 50 430 32 408 32ZM400 256C400 353 321 432 224 432S48 353 48 256V176H112V256C112 318 162 368 224 368C286 368 336 318 336 256V176H400V256Z"]
  };
  var faMagnifyingGlass = {
    prefix: 'far',
    iconName: 'magnifying-glass',
    icon: [512, 512, [], "f002", "M505 471L371 337C399 302 416 257 416 208C416 93 323 0 208 0S0 93 0 208S93 416 208 416C257 416 302 399 337 371L471 505C476 510 482 512 488 512S500 510 505 505C514 496 514 480 505 471ZM48 208C48 120 120 48 208 48S368 120 368 208S296 368 208 368S48 296 48 208Z"]
  };
  var faMagnifyingGlassDollar = {
    prefix: 'far',
    iconName: 'magnifying-glass-dollar',
    icon: [512, 512, [], "f688", "M505 471L371 337C399 302 416 257 416 208C416 93 323 0 208 0S0 93 0 208S93 416 208 416C257 416 302 399 337 371L471 505C476 510 482 512 488 512S500 510 505 505C514 496 514 480 505 471ZM208 368C120 368 48 296 48 208S120 48 208 48S368 120 368 208S296 368 208 368ZM213 189L207 187C180 179 181 175 182 169C183 159 201 157 217 159C222 160 228 162 236 164C247 168 258 163 262 152C265 142 260 130 249 127C241 124 234 122 228 121V112C228 101 219 92 208 92S188 101 188 112V120C163 125 146 140 142 162C135 207 178 220 196 225L202 227C235 236 235 240 234 247C233 257 215 259 199 257C191 256 182 252 173 249L168 247C158 244 146 249 143 260C139 270 144 281 155 285L160 287C168 290 178 293 188 295V304C188 315 197 324 208 324S228 315 228 304V296C253 291 270 276 274 254C282 208 239 196 213 189Z"]
  };
  var faMagnifyingGlassLocation = {
    prefix: 'far',
    iconName: 'magnifying-glass-location',
    icon: [512, 512, [], "f689", "M208 96C160 96 122 134 122 182C122 221 178 291 200 316C202 319 205 320 208 320S214 319 216 316C238 291 294 221 294 182C294 134 256 96 208 96ZM208 208C190 208 176 194 176 176C176 158 190 144 208 144S240 158 240 176C240 194 226 208 208 208ZM505 471L371 337C399 302 416 257 416 208C416 93 323 0 208 0S0 93 0 208S93 416 208 416C257 416 302 399 337 371L471 505C476 510 482 512 488 512S500 510 505 505C514 496 514 480 505 471ZM208 368C120 368 48 296 48 208S120 48 208 48S368 120 368 208S296 368 208 368Z"]
  };
  var faMagnifyingGlassMinus = {
    prefix: 'far',
    iconName: 'magnifying-glass-minus',
    icon: [512, 512, [], "f010", "M505 471L371 337C399 302 416 257 416 208C416 93 323 0 208 0S0 93 0 208S93 416 208 416C257 416 302 399 337 371L471 505C476 510 482 512 488 512S500 510 505 505C514 496 514 480 505 471ZM208 368C120 368 48 296 48 208S120 48 208 48S368 120 368 208S296 368 208 368ZM280 184H136C123 184 112 195 112 208S123 232 136 232H280C293 232 304 221 304 208S293 184 280 184Z"]
  };
  var faMagnifyingGlassPlus = {
    prefix: 'far',
    iconName: 'magnifying-glass-plus',
    icon: [512, 512, [], "f00e", "M505 471L371 337C399 302 416 257 416 208C416 93 323 0 208 0S0 93 0 208S93 416 208 416C257 416 302 399 337 371L471 505C476 510 482 512 488 512S500 510 505 505C514 496 514 480 505 471ZM208 368C120 368 48 296 48 208S120 48 208 48S368 120 368 208S296 368 208 368ZM280 184H232V136C232 123 221 112 208 112S184 123 184 136V184H136C123 184 112 195 112 208S123 232 136 232H184V280C184 293 195 304 208 304S232 293 232 280V232H280C293 232 304 221 304 208S293 184 280 184Z"]
  };
  var faMailbox = {
    prefix: 'far',
    iconName: 'mailbox',
    icon: [576, 512, [], "f813", "M184 192H104C91 192 80 203 80 216C80 229 91 240 104 240H184C197 240 208 229 208 216C208 203 197 192 184 192ZM432 64H144C65 64 0 129 0 208V416C0 434 14 448 32 448H544C562 448 576 434 576 416V208C576 129 511 64 432 64ZM240 400H48V208C48 155 91 112 144 112S240 155 240 208V400ZM528 400H288V208C288 171 274 138 251 112H432C485 112 528 155 528 208V400ZM464 192H360C347 192 336 203 336 216C336 229 347 240 360 240H416V272C416 281 423 288 432 288H464C473 288 480 281 480 272V208C480 199 473 192 464 192Z"]
  };
  var faManatSign = {
    prefix: 'far',
    iconName: 'manat-sign',
    icon: [384, 512, [], "e163", "M368 272V456C368 469 357 480 344 480S320 469 320 456V272C320 237 306 205 281 180C263 162 241 151 216 146V456C216 469 205 480 192 480S168 469 168 456V147C108 158 64 209 64 272V456C64 469 53 480 40 480S16 469 16 456V272C16 183 82 110 168 98V56C168 43 179 32 192 32S216 43 216 56V98C253 103 287 119 315 146C349 179 368 224 368 272Z"]
  };
  var faMandolin = {
    prefix: 'far',
    iconName: 'mandolin',
    icon: [512, 512, [], "f6f9", "M507 51L461 5C456 -1 448 -1 442 2L378 43C371 47 366 54 364 62L345 133L286 192C97 189 50 237 31 256C-16 303 -9 407 48 464C80 496 127 512 170 512C204 512 235 502 256 481C271 466 324 420 320 226L379 167L450 149C458 146 465 141 470 135L510 71C514 64 513 56 507 51ZM222 447C211 458 192 464 170 464C137 464 103 451 82 430C43 390 39 316 65 290C113 242 221 241 238 241L188 290C167 284 144 293 133 312C122 331 125 356 141 371C156 387 181 390 200 379C219 368 228 345 222 324L271 275C271 290 270 399 222 447Z"]
  };
  var faMap = {
    prefix: 'far',
    iconName: 'map',
    icon: [576, 512, [], "f279", "M554 33L384 96L212 35C206 33 199 32 192 32C185 32 178 33 172 35L20 88C8 93 0 105 0 118V464C0 475 11 483 22 479L192 416L364 477C377 481 391 481 404 477L556 424C568 419 576 407 576 394V48C576 37 565 29 554 33ZM224 90L352 136V422L224 376V90ZM48 418V129L176 84V371L175 371L48 418ZM528 383L400 428V141L401 141L528 94V383Z"]
  };
  var faMapLocation = {
    prefix: 'far',
    iconName: 'map-location',
    icon: [576, 512, [], "f59f", "M300 314C391 182 408 168 408 120C408 54 354 0 288 0C222 0 168 54 168 120C168 168 185 182 276 314C282 322 294 322 300 314ZM554 97L439 140C437 160 430 177 417 199L528 158V415L400 460V226C391 239 381 254 368 272C363 279 358 287 352 295V454L224 408V295C218 287 213 279 208 272C195 254 185 239 176 226V403L175 403L48 450V193L141 161C138 148 136 135 136 120C136 117 137 114 137 111L20 152C8 157 0 169 0 182V496C0 507 11 515 22 511L192 448L364 509C377 513 391 513 404 509L556 456C568 451 576 439 576 426V112C576 101 565 93 554 97Z"]
  };
  var faMapLocationDot = {
    prefix: 'far',
    iconName: 'map-location-dot',
    icon: [576, 512, [], "f5a0", "M300 314C391 182 408 168 408 120C408 54 354 0 288 0C222 0 168 54 168 120C168 168 185 182 276 314C282 322 294 322 300 314ZM248 112C248 90 266 72 288 72S328 90 328 112S310 152 288 152S248 134 248 112ZM554 97L439 140C437 160 430 177 417 199L528 158V415L400 460V226C391 239 381 254 368 272C363 279 358 287 352 295V454L224 408V295C218 287 213 279 208 272C195 254 185 239 176 226V403L175 403L48 450V193L141 161C138 148 136 135 136 120C136 117 137 114 137 111L20 152C8 157 0 169 0 182V496C0 507 11 515 22 511L192 448L364 509C377 513 391 513 404 509L556 456C568 451 576 439 576 426V112C576 101 565 93 554 97Z"]
  };
  var faMapPin = {
    prefix: 'far',
    iconName: 'map-pin',
    icon: [320, 512, [], "f276", "M304 144C304 64 240 0 160 0S16 64 16 144C16 215 68 274 136 286V488C136 501 147 512 160 512S184 501 184 488V286C252 274 304 215 304 144ZM160 240C107 240 64 197 64 144S107 48 160 48C213 48 256 91 256 144S213 240 160 240Z"]
  };
  var faMarker = {
    prefix: 'far',
    iconName: 'marker',
    icon: [512, 512, [], "f5a1", "M486 26C468 9 445 0 422 0C398 0 375 9 358 26L321 63L296 38C275 17 238 17 216 38L111 143C102 152 102 168 111 177C116 182 122 184 128 184S140 182 145 177L250 72C254 68 259 68 262 72L287 97L94 290C42 342 8 411 0 485V485C-1 500 10 512 24 512C30 512 135 505 222 418L486 154C521 119 521 62 486 26ZM188 384C151 421 104 447 53 459C65 408 91 361 128 324L201 251L261 311L188 384ZM452 121L295 277L235 217L391 60C400 52 410 48 422 48S444 52 452 61C460 69 464 79 464 91S460 113 452 121Z"]
  };
  var faMars = {
    prefix: 'far',
    iconName: 'mars',
    icon: [448, 512, [], "f222", "M376 32H264C251 32 240 43 240 56S251 80 264 80H318L234 164C202 141 165 128 128 128C83 128 38 145 3 180C-65 248 -65 360 3 428C38 463 83 480 128 480S218 463 252 428C315 366 320 267 268 198L352 114V168C352 181 363 192 376 192S400 181 400 168V56C400 43 389 32 376 32ZM218 394C194 419 162 432 128 432S62 419 37 394C-12 345 -12 263 37 213C62 189 94 176 128 176S194 189 218 214C218 214 218 214 218 214C218 214 218 214 218 214C268 263 268 345 218 394Z"]
  };
  var faMarsDouble = {
    prefix: 'far',
    iconName: 'mars-double',
    icon: [640, 512, [], "f227", "M568 32H456C443 32 432 43 432 56S443 80 456 80H510L410 180C401 189 401 204 410 213L410 213C460 263 460 345 410 394C386 419 354 432 320 432C311 432 302 431 294 429C288 437 282 444 275 451C269 457 263 463 256 468C276 476 298 480 320 480C365 480 410 463 444 428C507 366 512 267 460 198L544 114V168C544 181 555 192 568 192S592 181 592 168V56C592 43 581 32 568 32ZM268 198L352 114V168C352 181 363 192 376 192C389 192 400 181 400 168V56C400 43 389 32 376 32H264C251 32 240 43 240 56S251 80 264 80H318L234 164C202 141 165 128 128 128C83 128 38 145 3 180C-65 248 -65 360 3 428C38 463 83 480 128 480S218 463 252 428C315 366 320 267 268 198ZM218 394C194 419 162 432 128 432S62 419 37 394C-12 345 -12 263 37 213C62 189 94 176 128 176S194 189 218 214C268 263 268 345 218 394Z"]
  };
  var faMarsStroke = {
    prefix: 'far',
    iconName: 'mars-stroke',
    icon: [512, 512, [], "f229", "M456 0H344C331 0 320 11 320 24S331 48 344 48H398L344 102L313 71C304 62 288 62 279 71S270 96 279 105L310 136L282 164C250 141 213 128 176 128C131 128 86 145 52 180C-17 248 -17 360 52 428C86 463 131 480 176 480S266 463 300 428C363 366 368 267 316 198L344 170L375 201C380 206 386 208 392 208S404 206 409 201C418 192 418 176 409 167L378 136L432 82V136C432 149 443 160 456 160S480 149 480 136V24C480 11 469 0 456 0ZM266 394C242 419 210 432 176 432S110 419 86 394C36 345 36 263 86 213C110 189 142 176 176 176S242 189 266 214C266 214 266 214 266 214C266 214 266 214 266 214C316 263 316 345 266 394Z"]
  };
  var faMarsStrokeRight = {
    prefix: 'far',
    iconName: 'mars-stroke-right',
    icon: [640, 512, [], "f22b", "M601 239L521 159C512 150 497 150 487 159S478 184 487 193L526 232H448V184C448 171 437 160 424 160S400 171 400 184V232H366C354 146 281 80 192 80C95 80 16 159 16 256S95 432 192 432C281 432 354 366 366 280H400V328C400 341 411 352 424 352S448 341 448 328V280H526L487 319C478 328 478 343 487 353C492 358 498 360 504 360S517 358 521 353L601 273C610 264 610 248 601 239ZM192 384C121 384 64 327 64 256S121 128 192 128S320 185 320 256S263 384 192 384Z"]
  };
  var faMarsStrokeUp = {
    prefix: 'far',
    iconName: 'mars-stroke-up',
    icon: [384, 512, [], "f22a", "M216 162V152H248C261 152 272 141 272 128S261 104 248 104H216V72L242 91C246 94 251 96 256 96C263 96 270 93 275 86C283 76 281 61 270 53L206 5C198 -2 186 -2 178 5L114 53C103 61 101 76 109 86C117 97 132 99 142 91L168 72V104H136C123 104 112 115 112 128S123 152 136 152H168V162C82 174 16 247 16 336C16 433 95 512 192 512C289 512 368 433 368 336C368 247 302 174 216 162ZM192 464C121 464 64 407 64 336S121 208 192 208S320 265 320 336S263 464 192 464Z"]
  };
  var faMartiniGlass = {
    prefix: 'far',
    iconName: 'martini-glass',
    icon: [512, 512, [], "f57b", "M280 280L502 58C523 36 508 0 478 0H34C4 0 -11 36 10 58L128 176V176H128L232 280V463L221 464H152C139 464 128 475 128 488S139 512 152 512H360C373 512 384 501 384 488S373 464 360 464H282C280 464 279 463 277 463H280V280ZM444 48L364 128H148L68 48H444ZM256 236L196 176H316L256 236Z"]
  };
  var faMartiniGlassCitrus = {
    prefix: 'far',
    iconName: 'martini-glass-citrus',
    icon: [576, 512, [], "f561", "M576 144C576 223 511 288 432 288C405 288 379 280 357 267L393 231C405 237 418 240 432 240C485 240 528 197 528 144S485 48 432 48C397 48 366 67 349 96H297C317 40 369 0 432 0C511 0 576 65 576 144ZM320 488C320 501 309 512 296 512H277H123H120C107 512 96 501 96 488S107 464 120 464H155H184V347L7 170C-8 154 3 128 25 128H391C413 128 424 154 409 170L232 347V464H245H296C309 464 320 475 320 488ZM208 303L335 176H81L208 303Z"]
  };
  var faMartiniGlassEmpty = {
    prefix: 'far',
    iconName: 'martini-glass-empty',
    icon: [512, 512, [], "f000", "M280 280L502 58C523 36 508 0 478 0H34C4 0 -11 36 10 58L232 280V463L221 464H152C139 464 128 475 128 488S139 512 152 512H360C373 512 384 501 384 488S373 464 360 464H282C280 464 279 463 277 463H280V280ZM256 236L68 48H444L256 236Z"]
  };
  var faMask = {
    prefix: 'far',
    iconName: 'mask',
    icon: [576, 512, [], "f6fa", "M288 64C40 64 0 182 0 273C0 379 79 448 176 448C203 448 227 441 242 411L262 371C268 359 278 352 288 352C298 352 308 359 314 371L334 411C349 441 373 448 400 448C497 448 576 379 576 273C576 182 536 64 288 64ZM400 400C382 400 380 397 377 390L357 349C343 322 318 305 290 304L288 304L286 304C258 305 233 322 219 350L199 390C196 397 194 400 176 400C101 400 48 348 48 273C48 229 48 112 288 112S528 229 528 273C528 348 475 400 400 400ZM160 192C125 192 96 221 96 256S125 320 160 320C195 320 224 291 224 256S195 192 160 192ZM416 192C381 192 352 221 352 256S381 320 416 320C451 320 480 291 480 256S451 192 416 192Z"]
  };
  var faMasksTheater = {
    prefix: 'far',
    iconName: 'masks-theater',
    icon: [640, 512, [], "f630", "M207 245C171 255 147 286 149 319C161 306 178 295 199 288L207 245ZM193 157C193 153 191 149 189 145C181 154 169 161 154 164C139 166 125 164 115 158C114 162 114 166 115 170C118 192 139 207 161 203C183 199 197 178 193 157ZM80 298L48 118C47 110 50 102 57 99C117 66 185 48 253 48C262 48 270 48 279 49C288 44 299 40 310 38C329 35 348 33 367 33C357 19 342 8 325 6C301 2 277 0 253 0C177 0 101 19 33 57C9 70 -4 98 1 126L33 306C47 386 169 448 237 448C241 448 244 447 247 447C235 432 224 415 216 398C163 387 88 343 80 298ZM373 224C388 226 400 233 408 242C410 239 412 235 412 231C416 209 402 188 380 185S337 195 333 217C333 221 333 225 333 229C344 223 358 221 373 224ZM607 120C562 95 514 78 465 70C416 61 365 60 315 68C287 73 266 95 261 123L229 303C214 390 324 500 387 511S592 457 607 370L639 190C644 161 631 133 607 120ZM560 361C550 419 436 470 396 463C356 456 266 369 276 311L308 131C309 123 315 117 322 116C367 109 412 109 457 117C501 125 544 140 583 162C590 165 593 173 592 181L560 361ZM506 207C484 203 463 217 460 239C459 243 459 247 459 251C470 246 484 244 499 246C514 249 526 256 534 265C536 261 538 257 538 253C542 231 528 211 506 207ZM417 341C374 334 338 313 318 287C313 341 351 391 407 400C462 410 515 377 529 324C501 342 460 349 417 341Z"]
  };
  var faMaximize = {
    prefix: 'far',
    iconName: 'maximize',
    icon: [448, 512, [], "f31e", "M428 290C416 285 403 288 393 297L346 344L258 256L346 168L393 215C399 221 408 224 416 224C420 224 424 223 428 222C440 217 448 205 448 192V56C448 43 437 32 424 32H288C275 32 263 40 258 52C253 64 256 77 265 87L312 134L224 222L136 134L183 87C189 81 192 72 192 64C192 60 191 56 190 52C185 40 173 32 160 32H24C11 32 0 43 0 56V192C0 205 8 217 20 222C32 227 45 224 55 215L102 168L190 256L102 344L55 297C49 291 40 288 32 288C28 288 24 289 20 290C8 295 0 307 0 320V456C0 469 11 480 24 480H160C173 480 185 472 190 460C195 448 192 435 183 425L136 378L224 290L312 378L265 425C259 432 256 440 256 448C256 452 257 456 258 460C263 472 275 480 288 480H424C437 480 448 469 448 456V320C448 307 440 295 428 290Z"]
  };
  var faMeat = {
    prefix: 'far',
    iconName: 'meat',
    icon: [512, 512, [], "f814", "M444 68C399 24 345 0 299 0C260 0 237 19 230 26C192 64 128 140 128 209V282L128 282V310L119 318C110 328 95 329 83 324C56 314 26 323 10 347C-6 371 -3 403 18 423C33 438 54 443 74 438C69 458 74 479 89 494C109 515 141 518 165 502C189 486 198 456 188 429C183 417 184 402 194 393L202 384H230L230 384H303C385 384 484 289 493 273C531 223 511 135 444 68ZM303 336H208C190 336 176 322 176 304V209C176 187 188 158 208 127C217 166 240 206 273 239C306 272 347 295 385 304C354 324 326 336 303 336ZM453 248C429 271 363 261 307 205C253 151 240 84 264 60C288 36 354 47 410 102C464 156 477 224 453 248ZM332 127C322 137 326 157 341 172C355 186 375 190 385 180C395 171 391 151 376 136C362 121 342 117 332 127Z"]
  };
  var faMedal = {
    prefix: 'far',
    iconName: 'medal',
    icon: [512, 512, [], "f5a2", "M342 290L290 282L266 234C264 230 260 228 256 228S248 230 246 234L222 282L170 290C160 291 157 303 163 309L201 346L193 398C191 406 197 412 204 412C206 412 207 411 209 410L256 386L303 411C305 412 306 412 308 412C315 412 321 406 320 398L311 346L349 309C355 303 352 291 342 290ZM256 144C154 144 72 226 72 328S154 512 256 512S440 430 440 328S358 144 256 144ZM256 464C181 464 120 403 120 328S181 192 256 192S392 253 392 328S331 464 256 464ZM136 149L69 48H138L182 125C198 120 214 116 231 114L173 12C169 5 161 0 152 0H24C15 0 7 5 3 13C-1 20 -1 30 4 37L99 180C110 168 122 158 136 149ZM509 13C505 5 497 0 488 0H360C351 0 343 5 339 12L281 114C298 116 314 120 330 125L374 48H443L376 149C390 158 402 168 413 180L508 37C513 30 513 20 509 13Z"]
  };
  var faMegaphone = {
    prefix: 'far',
    iconName: 'megaphone',
    icon: [576, 512, [], "f675", "M552 32C539 32 528 43 528 56V60L47 195C45 184 35 176 24 176C11 176 0 187 0 200V312C0 325 11 336 24 336C35 336 45 328 47 317L168 351C163 363 160 375 160 388C160 439 201 480 252 480C298 480 337 445 343 400L528 452V456C528 469 539 480 552 480C565 480 576 469 576 456V56C576 43 565 32 552 32ZM296 388C296 412 276 432 252 432S208 412 208 388C208 380 211 371 215 364L296 387C296 387 296 388 296 388ZM48 268V244L528 109V403L48 268Z"]
  };
  var faMemory = {
    prefix: 'far',
    iconName: 'memory',
    icon: [576, 512, [], "f538", "M576 163V112C576 86 554 64 528 64H48C22 64 0 86 0 112V163C19 170 32 187 32 208S19 246 0 253V416C0 434 14 448 32 448H544C562 448 576 434 576 416V253C557 246 544 229 544 208S557 170 576 163ZM528 400H472C472 387 461 376 448 376S424 387 424 400H392C392 387 381 376 368 376S344 387 344 400H312C312 387 301 376 288 376S264 387 264 400H232C232 387 221 376 208 376S184 387 184 400H152C152 387 141 376 128 376S104 387 104 400H48V352H528V400ZM528 137C508 155 496 180 496 208C496 236 508 261 528 279V304H48V279C68 261 80 236 80 208C80 180 68 155 48 137V112H528V137ZM160 272C173 272 184 261 184 248V168C184 155 173 144 160 144S136 155 136 168V248C136 261 147 272 160 272ZM288 272C301 272 312 261 312 248V168C312 155 301 144 288 144S264 155 264 168V248C264 261 275 272 288 272ZM416 272C429 272 440 261 440 248V168C440 155 429 144 416 144S392 155 392 168V248C392 261 403 272 416 272Z"]
  };
  var faMenorah = {
    prefix: 'far',
    iconName: 'menorah',
    icon: [640, 512, [], "f676", "M416 96C434 96 448 82 448 64S416 0 416 0S384 46 384 64S398 96 416 96ZM512 128C499 128 488 139 488 152V288H536V152C536 139 525 128 512 128ZM608 96C626 96 640 82 640 64S608 0 608 0S576 46 576 64S590 96 608 96ZM512 96C530 96 544 82 544 64S512 0 512 0S480 46 480 64S494 96 512 96ZM320 96C338 96 352 82 352 64S320 0 320 0S288 46 288 64S302 96 320 96ZM416 128C403 128 392 139 392 152V288H440V152C440 139 429 128 416 128ZM32 96C50 96 64 82 64 64S32 0 32 0S0 46 0 64S14 96 32 96ZM616 128C603 128 592 139 592 152V280C592 302 574 320 552 320H344V152C344 139 333 128 320 128S296 139 296 152V320H88C66 320 48 302 48 280V152C48 139 37 128 24 128S0 139 0 152V280C0 329 39 368 88 368H296V464H152C139 464 128 475 128 488C128 501 139 512 152 512H488C501 512 512 501 512 488C512 475 501 464 488 464H344V368H552C601 368 640 329 640 280V152C640 139 629 128 616 128ZM224 96C242 96 256 82 256 64S224 0 224 0S192 46 192 64S206 96 224 96ZM128 128C115 128 104 139 104 152V288H152V152C152 139 141 128 128 128ZM128 96C146 96 160 82 160 64S128 0 128 0S96 46 96 64S110 96 128 96ZM224 128C211 128 200 139 200 152V288H248V152C248 139 237 128 224 128Z"]
  };
  var faMercury = {
    prefix: 'far',
    iconName: 'mercury',
    icon: [384, 512, [], "f223", "M368 224C368 158 331 100 278 70C290 62 303 52 314 40C323 31 322 15 312 6C303 -3 287 -2 278 8C230 60 154 60 106 8C97 -2 81 -3 72 6C62 15 61 31 70 40C81 52 94 62 106 70C53 100 16 158 16 224C16 313 82 386 168 398V424H136C123 424 112 435 112 448C112 461 123 472 136 472H168V488C168 501 179 512 192 512S216 501 216 488V472H248C261 472 272 461 272 448C272 435 261 424 248 424H216V398C302 386 368 313 368 224ZM64 224C64 153 121 96 192 96S320 153 320 224S263 352 192 352S64 295 64 224Z"]
  };
  var faMessage = {
    prefix: 'far',
    iconName: 'message',
    icon: [512, 512, [], "f27a", "M448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageArrowDown = {
    prefix: 'far',
    iconName: 'message-arrow-down',
    icon: [512, 512, [], "e164", "M321 191L282 230V128C282 115 271 104 258 104S234 115 234 128V230L194 191C190 186 184 184 178 184S165 186 161 191C151 200 151 216 161 225L241 305C250 314 265 314 274 305L354 225C364 216 364 200 354 191S330 182 321 191ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageArrowUp = {
    prefix: 'far',
    iconName: 'message-arrow-up',
    icon: [512, 512, [], "e165", "M274 111C265 102 250 102 241 111L161 191C151 200 151 216 161 225S185 234 194 225L234 186V288C234 301 244 312 258 312S282 301 282 288V186L321 225C325 230 331 232 338 232S350 230 354 225C364 216 364 200 354 191L274 111ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageCaptions = {
    prefix: 'far',
    iconName: 'message-captions',
    icon: [512, 512, [], "e166", "M136 272H120C107 272 96 283 96 296S107 320 120 320H136C149 320 160 309 160 296S149 272 136 272ZM296 272H216C203 272 192 283 192 296S203 320 216 320H296C309 320 320 309 320 296S309 272 296 272ZM120 240H216C229 240 240 229 240 216S229 192 216 192H120C107 192 96 203 96 216S107 240 120 240ZM392 272H376C363 272 352 283 352 296S363 320 376 320H392C405 320 416 309 416 296S405 272 392 272ZM392 192H296C283 192 272 203 272 216S283 240 296 240H392C405 240 416 229 416 216S405 192 392 192ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageCheck = {
    prefix: 'far',
    iconName: 'message-check',
    icon: [512, 512, [], "f4a2", "M311 136L232 229L202 199C193 190 178 190 169 199S159 224 169 233L217 281C221 285 227 288 234 288C234 288 234 288 234 288C241 288 247 285 252 280L348 168C356 158 355 142 345 134C335 125 320 126 311 136ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageDollar = {
    prefix: 'far',
    iconName: 'message-dollar',
    icon: [512, 512, [], "f650", "M262 186L256 184C229 176 230 173 230 167C232 158 249 156 265 159C271 160 278 162 285 164C297 168 310 162 314 150C318 138 312 125 300 121C292 118 285 116 279 115V103C279 90 269 80 256 80S233 90 233 103V114C208 120 190 136 185 160C177 209 223 222 243 228L250 230C283 240 283 243 282 249C280 257 263 260 247 257C239 256 229 252 220 249L215 247C203 243 190 249 186 261C181 273 188 286 200 291L204 292C213 295 223 299 233 301V313C233 326 243 336 256 336S279 326 279 313V301C304 296 322 280 327 256C335 207 288 193 262 186ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageDots = {
    prefix: 'far',
    iconName: 'message-dots',
    icon: [512, 512, [], "f4a3", "M146 176C128 176 114 190 114 208S128 240 146 240S178 226 178 208S163 176 146 176ZM258 176C240 176 226 190 226 208S240 240 258 240C275 240 290 226 290 208S275 176 258 176ZM370 176C352 176 338 190 338 208S352 240 370 240S402 226 402 208S387 176 370 176ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageExclamation = {
    prefix: 'far',
    iconName: 'message-exclamation',
    icon: [512, 512, [], "f4a5", "M258 272C240 272 226 286 226 304S240 336 258 336C275 336 290 322 290 304S275 272 258 272ZM258 240C271 240 282 229 282 216V104C282 91 271 80 258 80S234 91 234 104V216C234 229 244 240 258 240ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageImage = {
    prefix: 'far',
    iconName: 'message-image',
    icon: [512, 512, [], "e167", "M176 160C194 160 208 146 208 128S194 96 176 96S144 110 144 128S158 160 176 160ZM312 135C309 131 304 128 299 128S288 131 285 135L232 215L220 199C217 194 212 192 207 192S197 194 194 199L147 263C144 267 143 274 146 279C148 285 154 288 160 288H384C390 288 395 285 398 280C401 274 401 268 397 263L312 135ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageLines = {
    prefix: 'far',
    iconName: 'message-lines',
    icon: [512, 512, [], "f4a6", "M360 144H152C139 144 128 155 128 168S139 192 152 192H360C373 192 384 181 384 168S373 144 360 144ZM264 240H152C139 240 128 251 128 264S139 288 152 288H264C277 288 288 277 288 264S277 240 264 240ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageMedical = {
    prefix: 'far',
    iconName: 'message-medical',
    icon: [512, 512, [], "f7f4", "M336 176H288V128C288 119 281 112 272 112H240C231 112 224 119 224 128V176H176C167 176 160 183 160 192V224C160 233 167 240 176 240H224V288C224 297 231 304 240 304H272C281 304 288 297 288 288V240H336C345 240 352 233 352 224V192C352 183 345 176 336 176ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageMiddle = {
    prefix: 'far',
    iconName: 'message-middle',
    icon: [512, 512, [], "e168", "M448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H176L243 506C246 510 251 512 256 512S266 510 269 506L336 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H312L256 443L200 368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageMiddleTop = {
    prefix: 'far',
    iconName: 'message-middle-top',
    icon: [512, 512, [], "e169", "M448 96H336L269 6C266 2 261 0 256 0S246 2 243 6L176 96H64C29 96 0 125 0 160V448C0 483 29 512 64 512H448C483 512 512 483 512 448V160C512 125 483 96 448 96ZM464 448C464 457 457 464 448 464H64C55 464 48 457 48 448V160C48 151 55 144 64 144H200L256 69L312 144H448C457 144 464 151 464 160V448Z"]
  };
  var faMessageMinus = {
    prefix: 'far',
    iconName: 'message-minus',
    icon: [512, 512, [], "f4a7", "M328 184H184C171 184 160 195 160 208S171 232 184 232H328C341 232 352 221 352 208S341 184 328 184ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageMusic = {
    prefix: 'far',
    iconName: 'message-music',
    icon: [512, 512, [], "f8af", "M331 97H331L203 144C197 146 192 152 192 159V258C187 257 181 256 176 256C150 256 128 270 128 288S150 320 176 320S224 306 224 288V203L320 166V226C315 225 309 224 304 224C278 224 256 238 256 256S278 288 304 288S352 274 352 256V112C352 107 350 102 346 99S336 95 331 97ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessagePen = {
    prefix: 'far',
    iconName: 'message-pen',
    icon: [512, 512, [], "f4a4", "M326 117C319 110 307 110 300 117L282 136L330 184L348 165C355 158 355 147 348 140L326 117ZM174 243C173 245 172 247 171 249L162 297C161 301 164 305 169 304L216 294C219 294 221 293 222 291L313 201L265 153L174 243ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessagePlus = {
    prefix: 'far',
    iconName: 'message-plus',
    icon: [512, 512, [], "f4a8", "M328 184H280V136C280 123 269 112 256 112S232 123 232 136V184H184C171 184 160 195 160 208S171 232 184 232H232V280C232 293 243 304 256 304S280 293 280 280V232H328C341 232 352 221 352 208S341 184 328 184ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageQoute = {
    prefix: 'far',
    iconName: 'message-qoute',
    icon: [512, 512, [], "e16a", "M216 112H152C139 112 128 123 128 136V184C128 197 139 208 152 208H192V224C192 242 178 256 160 256H156C149 256 144 261 144 268V292C144 299 149 304 156 304H160C204 304 240 268 240 224V136C240 123 229 112 216 112ZM360 112H296C283 112 272 123 272 136V184C272 197 283 208 296 208H336V224C336 242 322 256 304 256H300C293 256 288 261 288 268V292C288 299 293 304 300 304H304C348 304 384 268 384 224V136C384 123 373 112 360 112ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageSlash = {
    prefix: 'far',
    iconName: 'message-slash',
    icon: [640, 512, [], "f4a9", "M631 469L548 405C565 393 576 374 576 352V64C576 29 547 0 512 0H128C105 0 84 13 73 32L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM528 352C528 361 521 368 512 368H502L112 63C113 55 120 48 128 48H512C521 48 528 55 528 64V352ZM272 428V368H128C119 368 112 361 112 352V184L64 146V352C64 387 93 416 128 416H224V500C224 510 235 515 243 510L368 416H408L349 370L272 428Z"]
  };
  var faMessageSmile = {
    prefix: 'far',
    iconName: 'message-smile',
    icon: [512, 512, [], "f4aa", "M320 192C338 192 352 178 352 160S338 128 320 128S288 142 288 160S302 192 320 192ZM192 192C210 192 224 178 224 160S210 128 192 128S160 142 160 160S174 192 192 192ZM326 240C309 260 283 272 256 272C229 272 204 260 186 240C178 230 162 229 152 238C142 246 141 261 150 271C176 302 215 320 256 320C297 320 336 302 362 271C371 261 370 246 360 238C350 229 334 230 326 240ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageText = {
    prefix: 'far',
    iconName: 'message-text',
    icon: [512, 512, [], "e16b", "M344 112H168C155 112 144 123 144 136S155 160 168 160H232V296C232 309 243 320 256 320S280 309 280 296V160H344C357 160 368 149 368 136S357 112 344 112ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessageXmark = {
    prefix: 'far',
    iconName: 'message-xmark',
    icon: [512, 512, [], "f4ab", "M324 140C314 131 299 131 290 140L256 174L222 140C213 131 197 131 188 140S179 165 188 174L222 208L188 242C179 251 179 267 188 276S213 285 222 276L256 242L290 276C299 285 315 285 324 276S333 251 324 242L290 208L324 174C333 165 333 149 324 140ZM448 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H160V500C160 510 171 515 179 510L304 416H448C483 416 512 387 512 352V64C512 29 483 0 448 0ZM464 352C464 361 457 368 448 368H288L208 428V368H64C55 368 48 361 48 352V64C48 55 55 48 64 48H448C457 48 464 55 464 64V352Z"]
  };
  var faMessages = {
    prefix: 'far',
    iconName: 'messages',
    icon: [576, 512, [], "f4b6", "M352 320C387 320 416 291 416 256V64C416 29 387 0 352 0H64C29 0 0 29 0 64V256C0 291 29 320 64 320H96V372C96 379 102 384 108 384C110 384 113 383 115 382L224 320H352ZM200 278L144 310V272H64C55 272 48 265 48 256V64C48 55 55 48 64 48H352C361 48 368 55 368 64V256C368 265 361 272 352 272H211L200 278ZM512 160H448V256C448 309 405 352 352 352H232L192 375V384C192 419 221 448 256 448H382L465 510C471 515 480 510 480 502V448H512C547 448 576 419 576 384V224C576 189 547 160 512 160Z"]
  };
  var faMessagesDollar = {
    prefix: 'far',
    iconName: 'messages-dollar',
    icon: [576, 512, [], "f652", "M512 160H448V256C448 309 405 352 352 352H232L192 375V384C192 419 221 448 256 448H382L465 510C471 515 480 510 480 502V448H512C547 448 576 419 576 384V224C576 189 547 160 512 160ZM352 320C387 320 416 291 416 256V64C416 29 387 0 352 0H64C29 0 0 29 0 64V256C0 291 29 320 64 320H96V372C96 379 102 384 108 384C110 384 113 383 115 382L224 320H352ZM200 278L144 310V272H64C55 272 48 265 48 256V64C48 55 55 48 64 48H352C361 48 368 55 368 64V256C368 265 361 272 352 272H211L200 278ZM213 143L208 142C188 136 188 133 189 130C190 123 203 121 215 123C220 124 225 125 230 127C239 130 249 126 252 117C255 108 250 98 241 95C235 93 230 91 225 90V81C225 72 217 64 208 64S191 72 191 81V90C172 94 158 106 155 124C149 160 183 171 198 175L203 176C228 184 228 186 227 190C226 197 213 199 201 197C195 196 188 193 181 191L177 190C168 186 158 191 155 200C152 209 157 219 166 222L169 223C176 226 183 228 191 230V239C191 248 199 256 208 256S225 248 225 239V230C244 226 258 214 261 196C267 159 232 149 213 143Z"]
  };
  var faMeteor = {
    prefix: 'far',
    iconName: 'meteor',
    icon: [512, 512, [], "f753", "M511 43C502 71 481 137 458 196C469 200 477 208 481 218C484 229 484 240 479 250C457 292 399 396 342 453C264 532 137 532 59 453C-20 375 -20 248 59 170C116 113 220 55 262 33C272 28 283 28 294 31S312 43 316 54C374 31 441 10 469 1C481 -2 494 1 502 10C511 18 514 31 511 43ZM393 227L404 202C425 154 444 94 457 55C418 68 358 87 310 108L285 119L278 93C277 89 275 85 274 81C234 102 142 154 93 204C33 263 33 360 93 419C121 448 160 464 200 464C241 464 280 448 308 419C357 371 407 282 431 238C427 237 423 236 419 234L393 227ZM312 312C312 374 262 424 200 424S88 374 88 312S138 200 200 200C262 200 312 250 312 312ZM200 288C200 275 189 264 176 264S152 275 152 288S163 312 176 312C182 312 189 309 193 305C197 300 200 294 200 288ZM232 360C232 351 225 344 216 344C207 344 200 351 200 360S207 376 216 376C225 376 232 369 232 360Z"]
  };
  var faMicrochip = {
    prefix: 'far',
    iconName: 'microchip',
    icon: [512, 512, [], "f2db", "M320 160H192C174 160 160 174 160 192V320C160 338 174 352 192 352H320C338 352 352 338 352 320V192C352 174 338 160 320 160ZM304 304H208V208H304V304ZM488 280C501 280 512 269 512 256S501 232 488 232H448V184H488C501 184 512 173 512 160S501 136 488 136H448V128C448 93 419 64 384 64H376V24C376 11 365 0 352 0S328 11 328 24V64H280V24C280 11 269 0 256 0S232 11 232 24V64H184V24C184 11 173 0 160 0S136 11 136 24V64H128C93 64 64 93 64 128V136H24C11 136 0 147 0 160S11 184 24 184H64V232H24C11 232 0 243 0 256S11 280 24 280H64V328H24C11 328 0 339 0 352S11 376 24 376H64V384C64 419 93 448 128 448H136V488C136 501 147 512 160 512S184 501 184 488V448H232V488C232 501 243 512 256 512S280 501 280 488V448H328V488C328 501 339 512 352 512S376 501 376 488V448H384C419 448 448 419 448 384V376H488C501 376 512 365 512 352S501 328 488 328H448V280H488ZM400 384C400 393 393 400 384 400H128C119 400 112 393 112 384V128C112 119 119 112 128 112H384C393 112 400 119 400 128V384Z"]
  };
  var faMicrophone = {
    prefix: 'far',
    iconName: 'microphone',
    icon: [384, 512, [], "f130", "M344 192L344 192C331 192 320 203 320 216V256C320 331 255 391 179 383C113 377 64 317 64 250V216C64 203 53 192 40 192H40C27 192 16 203 16 216V248C16 338 80 418 168 430V464H120C107 464 96 475 96 488V488C96 501 107 512 120 512H264C277 512 288 501 288 488V488C288 475 277 464 264 464H216V430C302 418 368 345 368 256V216C368 203 357 192 344 192ZM192 352C245 352 288 309 288 256V96C288 43 245 0 192 0S96 43 96 96V256C96 309 139 352 192 352ZM144 96C144 70 166 48 192 48S240 70 240 96V256C240 282 218 304 192 304S144 282 144 256V96Z"]
  };
  var faMicrophoneLines = {
    prefix: 'far',
    iconName: 'microphone-lines',
    icon: [384, 512, [], "f3c9", "M192 352C245 352 288 309 288 256V96C288 43 245 0 192 0S96 43 96 96V256C96 309 139 352 192 352ZM144 96C144 70 166 48 192 48S240 70 240 96H208C199 96 192 103 192 112S199 128 208 128H240V160H208C199 160 192 167 192 176S199 192 208 192H240V224H208C199 224 192 231 192 240S199 256 208 256H240C240 282 218 304 192 304S144 282 144 256V96ZM344 192C331 192 320 203 320 216V256C320 331 255 391 179 383C113 377 64 317 64 250V216C64 203 53 192 40 192S16 203 16 216V248C16 338 80 418 168 430V464H120C107 464 96 475 96 488C96 501 107 512 120 512H264C277 512 288 501 288 488C288 475 277 464 264 464H216V430C302 418 368 345 368 256V216C368 203 357 192 344 192Z"]
  };
  var faMicrophoneLinesSlash = {
    prefix: 'far',
    iconName: 'microphone-lines-slash',
    icon: [640, 512, [], "f539", "M631 469L471 344C487 318 496 288 496 256V216C496 203 485 192 472 192S448 203 448 216V256C448 277 442 297 433 314L407 294C413 282 416 270 416 256V96C416 43 373 0 320 0S224 43 224 96V150L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM336 128H368V160H336C327 160 320 167 320 176S327 192 336 192H368V256C368 258 367 260 367 262L272 188V96C272 70 294 48 320 48S368 70 368 96H336C327 96 320 103 320 112S327 128 336 128ZM392 464H344V430C365 427 384 421 402 411L359 378C343 383 325 385 307 383C241 377 192 317 192 250V247L145 210C145 212 144 214 144 216V248C144 338 208 418 296 430V464H248C235 464 224 475 224 488C224 501 235 512 248 512H392C405 512 416 501 416 488C416 475 405 464 392 464Z"]
  };
  var faMicrophoneSlash = {
    prefix: 'far',
    iconName: 'microphone-slash',
    icon: [640, 512, [], "f131", "M631 469L471 344C487 318 496 288 496 256V216C496 203 485 192 472 192S448 203 448 216V256C448 277 442 297 433 314L407 294C413 282 416 270 416 256V96C416 43 373 0 320 0S224 43 224 96V150L39 5C28 -3 13 -1 5 9C-3 20 -1 35 9 43L601 507C606 510 611 512 616 512C623 512 630 509 635 503C643 492 641 477 631 469ZM368 256C368 258 367 260 367 262L272 188V96C272 70 294 48 320 48S368 70 368 96V256ZM392 464H344V430C365 427 384 421 402 411L359 378C343 383 325 385 307 383C241 377 192 317 192 250V247L145 210C145 212 144 214 144 216V248C144 338 208 418 296 430V464H248C235 464 224 475 224 488C224 501 235 512 248 512H392C405 512 416 501 416 488C416 475 405 464 392 464Z"]
  };
  var faMicrophoneStand = {
    prefix: 'far',
    iconName: 'microphone-stand',
    icon: [512, 512, [], "f8cb", "M476 36C429 -12 352 -12 304 36L276 64C253 87 240 118 240 149L12 407C-5 426 -4 455 14 473L39 498C57 516 86 517 105 500L232 387V488C232 501 243 512 256 512H256C269 512 280 501 280 488V345L363 272C394 272 425 259 448 236L476 208C524 160 524 83 476 36ZM73 464L48 439L261 198L314 251L73 464ZM362 224C359 224 357 224 354 223L289 158C287 137 293 117 307 101L411 205C397 217 380 224 362 224ZM445 171L341 67C370 41 415 42 442 70C470 97 471 142 445 171Z"]
  };
  var faMicroscope = {
    prefix: 'far',
    iconName: 'microscope',
    icon: [512, 512, [], "f610", "M488 464H447C487 429 512 377 512 320C512 214 426 128 320 128V176C399 176 464 241 464 320S399 464 320 464H24C11 464 0 475 0 488C0 501 11 512 24 512H488C501 512 512 501 512 488C512 475 501 464 488 464ZM120 432H296C309 432 320 421 320 408C320 395 309 384 296 384H120C107 384 96 395 96 408C96 421 107 432 120 432ZM160 320H176V336C176 345 183 352 192 352H224C233 352 240 345 240 336V320H256C274 320 288 306 288 288V64C288 46 274 32 256 32C256 14 242 0 224 0H192C174 0 160 14 160 32C142 32 128 46 128 64V288C128 306 142 320 160 320ZM176 80H240V272H176V80Z"]
  };
  var faMicrowave = {
    prefix: 'far',
    iconName: 'microwave',
    icon: [576, 512, [], "e01b", "M384 128H128C110 128 96 142 96 160V320C96 338 110 352 128 352H384C402 352 416 338 416 320V160C416 142 402 128 384 128ZM472 224C459 224 448 235 448 248C448 261 459 272 472 272S496 261 496 248C496 235 485 224 472 224ZM512 32H64C29 32 0 61 0 96V384C0 419 29 448 64 448V456C64 469 75 480 88 480S112 469 112 456V448H464V456C464 469 475 480 488 480S512 469 512 456V448C547 448 576 419 576 384V96C576 61 547 32 512 32ZM528 384C528 393 521 400 512 400H64C55 400 48 393 48 384V96C48 87 55 80 64 80H512C521 80 528 87 528 96V384ZM472 144C459 144 448 155 448 168C448 181 459 192 472 192S496 181 496 168C496 155 485 144 472 144Z"]
  };
  var faMillSign = {
    prefix: 'far',
    iconName: 'mill-sign',
    icon: [384, 512, [], "e16c", "M384 204V424C384 437 373 448 360 448S336 437 336 424V204C336 171 309 144 276 144C270 144 264 145 258 147L216 259V424C216 437 205 448 192 448S168 437 168 424V386L126 496C123 506 114 512 104 512C101 512 98 511 96 510C83 506 77 492 82 480L168 250V204C168 171 141 144 108 144S48 171 48 204V424C48 437 37 448 24 448S0 437 0 424V120C0 107 11 96 24 96C35 96 45 104 47 115C64 103 85 96 108 96C142 96 172 112 192 137C200 127 209 119 220 112L256 15C261 3 275 -3 287 1C300 6 306 20 301 32L277 96C336 97 384 145 384 204Z"]
  };
  var faMinimize = {
    prefix: 'far',
    iconName: 'minimize',
    icon: [512, 512, [], "f78c", "M312 224H448C461 224 473 216 478 204C483 192 480 178 471 169L424 122L505 41C514 32 514 16 505 7S480 -2 471 7L390 88L343 41C337 35 328 32 320 32C316 32 312 33 308 34C296 39 288 51 288 64V200C288 213 299 224 312 224ZM200 288H64C51 288 39 296 34 308C29 320 32 333 41 343L88 390L7 471C-2 480 -2 496 7 505C12 510 18 512 24 512S36 510 41 505L122 424L169 471C176 477 184 480 192 480C196 480 200 479 204 478C216 473 224 461 224 448V312C224 299 213 288 200 288ZM204 34C200 33 196 32 192 32C184 32 176 35 169 41L122 88L41 7C32 -2 16 -2 7 7S-2 32 7 41L88 122L41 169C35 175 32 184 32 192C32 196 33 200 34 204C39 216 51 224 64 224H200C213 224 224 213 224 200V64C224 51 216 39 204 34ZM424 390L471 343C480 333 482 320 478 308C473 296 461 288 448 288H312C299 288 288 299 288 312V448C288 461 296 473 308 478C312 479 316 480 320 480C328 480 337 477 343 471L390 424L471 505C476 510 482 512 488 512S500 510 505 505C514 496 514 480 505 471L424 390Z"]
  };
  var faMinus = {
    prefix: 'far',
    iconName: 'minus',
    icon: [448, 512, [], "f068", "M432 256C432 269 421 280 408 280H40C27 280 16 269 16 256S27 232 40 232H408C421 232 432 243 432 256Z"]
  };
  var faMistletoe = {
    prefix: 'far',
    iconName: 'mistletoe',
    icon: [576, 512, [], "f7b4", "M542 229C516 203 452 191 411 185L312 86V80H312V24C312 11 301 0 288 0S264 11 264 24V51C264 52 264 52 264 52V86L165 185C124 191 60 203 34 229C-6 269 -11 329 22 362C36 377 56 384 77 384C104 384 132 373 155 350C169 335 180 308 187 280C193 285 200 288 208 288C226 288 240 274 240 256S226 224 208 224C204 224 201 225 198 226C198 224 198 222 199 219L264 154V282C236 315 192 371 192 410C192 466 235 512 288 512C341 512 384 466 384 410C384 371 340 315 312 282V154L377 219C383 260 395 324 421 350C444 372 472 384 499 384C520 384 539 377 554 362C587 329 582 269 542 229ZM121 316C108 329 92 336 77 336C71 336 62 335 56 328C42 314 47 284 68 263C78 253 111 243 148 236C141 273 131 306 121 316ZM336 410C336 440 314 464 288 464C261 464 240 440 240 410C240 396 260 362 288 328C315 362 336 396 336 410ZM520 328C514 335 505 336 499 336C484 336 468 329 455 316C445 306 435 273 428 236C465 243 498 253 508 263C529 284 534 314 520 328ZM352 64C352 46 366 32 384 32C402 32 416 46 416 64C416 82 402 96 384 96C366 96 352 82 352 64Z"]
  };
  var faMitten = {
    prefix: 'far',
    iconName: 'mitten',
    icon: [448, 512, [], "f7b5", "M417 185C401 172 381 165 361 165C346 165 332 168 319 175L307 120C290 50 228 0 155 0C144 0 132 1 120 4C37 23 -15 107 4 190L55 384H104L51 180C38 122 74 64 131 51C139 49 147 48 155 48C206 48 249 82 260 131L293 273L331 227C339 218 350 213 361 213C370 213 379 216 386 222C402 235 405 260 391 276L301 384H364L428 307C459 270 454 215 417 185ZM352 416H64C46 416 32 430 32 448V480C32 498 46 512 64 512H352C370 512 384 498 384 480V448C384 430 370 416 352 416Z"]
  };
  var faMobile = {
    prefix: 'far',
    iconName: 'mobile',
    icon: [384, 512, [], "f3ce", "M304 0H80C45 0 16 29 16 64V448C16 483 45 512 80 512H304C339 512 368 483 368 448V64C368 29 339 0 304 0ZM320 448C320 457 313 464 304 464H80C71 464 64 457 64 448V64C64 55 71 48 80 48H304C313 48 320 55 320 64V448ZM224 400H160C151 400 144 407 144 416S151 432 160 432H224C233 432 240 425 240 416S233 400 224 400Z"]
  };
  var faMobileButton = {
    prefix: 'far',
    iconName: 'mobile-button',
    icon: [384, 512, [], "f10b", "M304 0H80C45 0 16 29 16 64V448C16 483 45 512 80 512H304C339 512 368 483 368 448V64C368 29 339 0 304 0ZM320 448C320 457 313 464 304 464H80C71 464 64 457 64 448V64C64 55 71 48 80 48H304C313 48 320 55 320 64V448ZM192 392C179 392 168 403 168 416C168 429 179 440 192 440S216 429 216 416C216 403 205 392 192 392Z"]
  };
  var faMobileNotch = {
    prefix: 'far',
    iconName: 'mobile-notch',
    icon: [384, 512, [], "e16d", "M240 400H144C135 400 128 407 128 416S135 432 144 432H240C249 432 256 425 256 416S249 400 240 400ZM304 0H80C45 0 16 29 16 64V448C16 483 45 512 80 512H304C339 512 368 483 368 448V64C368 29 339 0 304 0ZM320 448C320 457 313 464 304 464H80C71 464 64 457 64 448V64C64 55 71 48 80 48H128V80C128 89 135 96 144 96H240C249 96 256 89 256 80V48H304C313 48 320 55 320 64V448Z"]
  };
  var faMobileScreen = {
    prefix: 'far',
    iconName: 'mobile-screen',
    icon: [384, 512, [], "f3cf", "M304 0H80C45 0 16 29 16 64V448C16 483 45 512 80 512H304C339 512 368 483 368 448V64C368 29 339 0 304 0ZM320 448C320 457 313 464 304 464H80C71 464 64 457 64 448V368H320V448ZM320 320H64V64C64 55 71 48 80 48H304C313 48 320 55 320 64V320ZM160 432H224C233 432 240 425 240 416S233 400 224 400H160C151 400 144 407 144 416S151 432 160 432Z"]
  };
  var faMobileScreenButton = {
    prefix: 'far',
    iconName: 'mobile-screen-button',
    icon: [384, 512, [], "f3cd", "M304 0H80C45 0 16 29 16 64V448C16 483 45 512 80 512H304C339 512 368 483 368 448V64C368 29 339 0 304 0ZM320 448C320 457 313 464 304 464H80C71 464 64 457 64 448V368H320V448ZM320 320H64V64C64 55 71 48 80 48H304C313 48 320 55 320 64V320ZM192 440C205 440 216 429 216 416C216 403 205 392 192 392S168 403 168 416C168 429 179 440 192 440Z"]
  };
  var faMoneyBill = {
    prefix: 'far',
    iconName: 'money-bill',
    icon: [576, 512, [], "f0d6", "M512 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H512C547 448 576 419 576 384V128C576 93 547 64 512 64ZM528 336C493 336 464 365 464 400H112C112 365 83 336 48 336V176C83 176 112 147 112 112H464C464 147 493 176 528 176V336ZM368 256C368 309 332 352 288 352S208 309 208 256C208 203 244 160 288 160S368 203 368 256Z"]
  };
  var faMoneyBill1 = {
    prefix: 'far',
    iconName: 'money-bill-1',
    icon: [576, 512, [], "f3d1", "M336 300V324C336 330 330 336 324 336H252C246 336 240 330 240 324V300C240 294 246 288 252 288H264V224H252C248 224 244 222 242 218C240 214 239 210 241 206L254 183C256 179 259 176 264 176H300C306 176 312 182 312 188V288H324C330 288 336 294 336 300ZM576 128V384C576 419 547 448 512 448H64C29 448 0 419 0 384V128C0 93 29 64 64 64H512C547 64 576 93 576 128ZM528 176C493 176 464 147 464 112H112C112 147 83 176 48 176V336C83 336 112 365 112 400H464C464 365 493 336 528 336V176Z"]
  };
  var faMoneyBill1Wave = {
    prefix: 'far',
    iconName: 'money-bill-1-wave',
    icon: [576, 512, [], "f53b", "M336 300V324C336 330 330 336 324 336H252C246 336 240 330 240 324V300C240 294 246 288 252 288H264V224H252C248 224 244 222 242 218C240 214 239 210 241 206L254 183C256 179 259 176 264 176H300C306 176 312 182 312 188V288H324C330 288 336 294 336 300ZM576 102V386C576 414 553 438 525 438C520 438 514 437 509 435C487 428 465 424 440 424C393 424 345 437 294 451C243 465 190 480 136 480C97 480 63 473 30 458C12 450 0 431 0 410V126C0 97 23 74 51 74C56 74 62 75 67 77C89 84 111 88 136 88C183 88 231 75 282 61C333 47 386 32 440 32C479 32 513 39 546 54C564 62 576 81 576 102ZM528 151C496 147 472 121 472 88C472 86 472 84 473 83C462 81 452 80 440 80C393 80 345 93 294 107C243 121 190 136 136 136C126 136 118 134 109 134C101 160 77 178 48 178V361C80 365 104 391 104 424C104 426 104 428 103 429C114 431 124 432 136 432C183 432 231 419 282 405C333 391 386 376 440 376C452 376 463 378 474 379C482 356 503 339 528 337V151Z"]
  };
  var faMoneyBillSimple = {
    prefix: 'far',
    iconName: 'money-bill-simple',
    icon: [576, 512, [], "e16e", "M512 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H512C547 448 576 419 576 384V128C576 93 547 64 512 64ZM528 384C528 393 521 400 512 400H64C55 400 48 393 48 384V128C48 119 55 112 64 112H512C521 112 528 119 528 128V384ZM368 256C368 309 332 352 288 352S208 309 208 256C208 203 244 160 288 160S368 203 368 256Z"]
  };
  var faMoneyBillSimpleWave = {
    prefix: 'far',
    iconName: 'money-bill-simple-wave',
    icon: [576, 512, [], "e16f", "M546 54C513 39 479 32 440 32C386 32 333 47 282 61C231 75 183 88 136 88C111 88 89 84 67 77C62 75 56 74 51 74C23 74 0 97 0 126V410C0 431 12 450 30 458C63 473 97 480 136 480C190 480 243 465 294 451C345 437 393 424 440 424C465 424 487 428 509 435C514 437 520 438 525 438C553 438 576 415 576 386V102C576 81 564 62 546 54ZM528 386C528 389 526 390 525 390C498 381 470 376 440 376C386 376 333 391 282 405C231 419 183 432 136 432C104 432 76 426 50 414C49 414 48 412 48 410V126C48 123 49 122 51 122C51 122 51 122 51 122C78 131 106 136 136 136C190 136 243 121 294 107C345 93 393 80 440 80C472 80 500 86 526 98C527 98 528 100 528 102V386ZM368 256C368 309 332 352 288 352S208 309 208 256C208 203 244 160 288 160S368 203 368 256Z"]
  };
  var faMoneyBillWave = {
    prefix: 'far',
    iconName: 'money-bill-wave',
    icon: [576, 512, [], "f53a", "M368 256C368 309 332 352 288 352S208 309 208 256C208 203 244 160 288 160S368 203 368 256ZM576 102V386C576 414 553 438 525 438C520 438 514 437 509 435C487 428 465 424 440 424C393 424 345 437 294 451C243 465 190 480 136 480C97 480 63 473 30 458C12 450 0 431 0 410V126C0 97 23 74 51 74C56 74 62 75 67 77C89 84 111 88 136 88C183 88 231 75 282 61C333 47 386 32 440 32C479 32 513 39 546 54C564 62 576 81 576 102ZM440 376C452 376 463 378 474 379C482 356 503 339 528 337V151C496 147 472 121 472 88C472 86 472 84 473 83C462 81 452 80 440 80C393 80 345 93 294 107C243 121 190 136 136 136C126 136 118 134 109 134C101 160 77 178 48 178V361C80 365 104 391 104 424C104 426 104 428 103 429C114 431 124 432 136 432C183 432 231 419 282 405C333 391 386 376 440 376Z"]
  };
  var faMoneyBills = {
    prefix: 'far',
    iconName: 'money-bills',
    icon: [640, 512, [], "e170", "M80 432H544C544 458 522 480 496 480H64C29 480 0 451 0 416V144C0 118 22 96 48 96V400C48 418 62 432 80 432ZM368 112C324 112 288 155 288 208S324 304 368 304C412 304 448 261 448 208S412 112 368 112ZM640 96V320C640 355 611 384 576 384H160C125 384 96 355 96 320V96C96 61 125 32 160 32H576C611 32 640 61 640 96ZM592 273V143C589 144 587 144 584 144C553 144 528 119 528 88C528 85 529 83 529 80H207C207 83 208 85 208 88C208 119 183 144 152 144C149 144 147 144 144 143V273C147 272 149 272 152 272C183 272 208 297 208 328C208 331 207 333 207 336H529C529 333 528 331 528 328C528 297 553 272 584 272C587 272 589 272 592 273Z"]
  };
  var faMoneyBillsSimple = {
    prefix: 'far',
    iconName: 'money-bills-simple',
    icon: [640, 512, [], "e171", "M80 432H544C544 458 522 480 496 480H64C29 480 0 451 0 416V144C0 118 22 96 48 96V400C48 418 62 432 80 432ZM640 96V320C640 355 611 384 576 384H160C125 384 96 355 96 320V96C96 61 125 32 160 32H576C611 32 640 61 640 96ZM592 96C592 87 585 80 576 80H160C151 80 144 87 144 96V320C144 329 151 336 160 336H576C585 336 592 329 592 320V96ZM368 112C324 112 288 155 288 208S324 304 368 304C412 304 448 261 448 208S412 112 368 112Z"]
  };
  var faMoneyCheck = {
    prefix: 'far',
    iconName: 'money-check',
    icon: [576, 512, [], "f53c", "M512 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H512C547 448 576 419 576 384V128C576 93 547 64 512 64ZM528 384C528 393 521 400 512 400H64C55 400 48 393 48 384V128C48 119 55 112 64 112H512C521 112 528 119 528 128V384ZM264 208H120C107 208 96 219 96 232S107 256 120 256H264C277 256 288 245 288 232S277 208 264 208ZM232 304H120C107 304 96 315 96 328S107 352 120 352H232C245 352 256 341 256 328S245 304 232 304ZM456 304H408C395 304 384 315 384 328S395 352 408 352H456C469 352 480 341 480 328S469 304 456 304ZM448 160H384C366 160 352 174 352 192V224C352 242 366 256 384 256H448C466 256 480 242 480 224V192C480 174 466 160 448 160Z"]
  };
  var faMoneyCheckDollar = {
    prefix: 'far',
    iconName: 'money-check-dollar',
    icon: [576, 512, [], "f53d", "M149 237L144 235C120 228 121 225 122 221C123 213 138 211 152 213C157 214 163 216 169 218C180 222 191 216 195 206C198 195 193 184 182 180C175 178 170 176 164 175V164C164 153 155 144 144 144S124 153 124 164V174C102 179 86 193 82 214C75 257 115 268 133 274L138 275C168 284 167 286 166 291C165 299 150 301 136 299C129 298 120 295 112 292L108 290C98 287 86 292 83 302S84 324 95 328L99 329C107 332 115 335 124 337V348C124 359 133 368 144 368S164 359 164 348V337C186 333 202 319 206 298C213 255 172 243 149 237ZM512 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H512C547 448 576 419 576 384V128C576 93 547 64 512 64ZM528 384C528 393 521 400 512 400H64C55 400 48 393 48 384V128C48 119 55 112 64 112H512C521 112 528 119 528 128V384ZM456 184H280C267 184 256 195 256 208S267 232 280 232H456C469 232 480 221 480 208S469 184 456 184ZM328 280H280C267 280 256 291 256 304S267 328 280 328H328C341 328 352 317 352 304S341 280 328 280ZM456 280H408C395 280 384 291 384 304S395 328 408 328H456C469 328 480 317 480 304S469 280 456 280Z"]
  };
  var faMoneyCheckDollarPen = {
    prefix: 'far',
    iconName: 'money-check-dollar-pen',
    icon: [640, 512, [], "f873", "M581 140L573 148L545 176C553 177 560 184 560 192V448C560 457 553 464 544 464H96C87 464 80 457 80 448V192C80 183 87 176 96 176H323C326 170 330 164 334 160L366 128H96C61 128 32 157 32 192V448C32 483 61 512 96 512H544C579 512 608 483 608 448V192C608 171 597 152 581 140ZM601 75C610 65 610 49 601 39L569 7C564 2 557 0 551 0S538 2 533 7L505 35L573 103L601 75ZM352 194V256H414C419 256 423 254 426 251L551 125L483 57L357 182C354 185 352 189 352 194ZM280 400H488C501 400 512 389 512 376S501 352 488 352H280C267 352 256 363 256 376S267 400 280 400ZM280 288H296C309 288 320 277 320 264S309 240 296 240H280C267 240 256 251 256 264S267 288 280 288ZM176 432C187 432 196 423 196 412V401C218 397 234 383 238 362C245 319 204 307 181 301L176 299C152 292 153 289 154 285C155 277 170 275 184 277C189 278 195 280 201 282C212 286 223 280 227 270C230 259 225 248 214 244C207 242 202 240 196 239V228C196 217 187 208 176 208S156 217 156 228V238C134 243 118 257 114 278C107 321 147 332 165 338L170 339C200 348 199 350 198 355C197 363 182 36