/*!
 * Font Awesome Pro 6.0.0-alpha1 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (factory((global['pro-light-svg-icons'] = {})));
}(this, (function (exports) { 'use strict';

  var prefix = "fal";
  var fa0 = {
    prefix: 'fal',
    iconName: '0',
    icon: [320, 512, [], "e089", "M160 32C72 32 0 104 0 192V320C0 408 72 480 160 480S320 408 320 320V192C320 104 248 32 160 32ZM288 320C288 391 231 448 160 448S32 391 32 320V192C32 121 89 64 160 64S288 121 288 192V320Z"]
  };
  var fa1 = {
    prefix: 'fal',
    iconName: '1',
    icon: [256, 512, [], "e08a", "M256 464C256 473 249 480 240 480H16C7 480 0 473 0 464S7 448 16 448H112V79L57 117C50 122 40 120 35 113C30 106 32 96 39 91L119 35C124 31 130 31 135 34C141 37 144 42 144 48V448H240C249 448 256 455 256 464Z"]
  };
  var fa2 = {
    prefix: 'fal',
    iconName: '2',
    icon: [320, 512, [], "e08b", "M320 464C320 473 313 480 304 480H16C9 480 3 476 1 470C-1 464 0 457 5 452L218 258C264 218 270 150 231 104C212 81 184 67 154 64C125 62 96 72 73 91L41 119C34 125 24 125 18 118C12 111 13 101 20 95L52 67C81 42 119 30 157 32C196 35 230 54 255 83C305 143 298 230 240 282L57 448H304C313 448 320 455 320 464Z"]
  };
  var fa3 = {
    prefix: 'fal',
    iconName: '3',
    icon: [320, 512, [], "e08c", "M320 352C320 423 263 480 192 480H93C51 480 14 453 1 414C-2 405 3 396 11 393C19 390 28 395 31 403C40 430 65 448 93 448H192C245 448 288 405 288 352S245 256 192 256H80C73 256 67 252 65 246C63 240 64 233 69 228L247 64H16C7 64 0 57 0 48S7 32 16 32H288C295 32 301 36 303 42C305 48 304 55 299 60L121 224H192C263 224 320 281 320 352Z"]
  };
  var fa4 = {
    prefix: 'fal',
    iconName: '4',
    icon: [384, 512, [], "e08d", "M384 336C384 345 377 352 368 352H320V464C320 473 313 480 304 480S288 473 288 464V352H16C10 352 5 349 2 344C-1 340 -1 334 2 329L146 41C150 33 159 30 167 34C175 38 178 47 174 55L42 320H288V144C288 135 295 128 304 128S320 135 320 144V320H368C377 320 384 327 384 336Z"]
  };
  var fa5 = {
    prefix: 'fal',
    iconName: '5',
    icon: [320, 512, [], "e08e", "M320 352C320 423 263 480 192 480H95C52 480 14 453 1 412C-2 404 3 395 11 392C19 389 28 394 31 402C40 430 66 448 95 448H192C245 448 288 405 288 352S245 256 192 256H16C11 256 6 254 3 250S-1 241 1 236L49 44C50 37 57 32 64 32H272C281 32 288 39 288 48S281 64 272 64H77L37 224H192C263 224 320 281 320 352Z"]
  };
  var fa6 = {
    prefix: 'fal',
    iconName: '6',
    icon: [320, 512, [], "e08f", "M0 320C0 408 72 480 160 480S320 408 320 320S248 160 160 160C147 160 135 162 124 165L220 59C226 52 225 42 219 36C216 33 212 32 208 32C204 32 199 34 196 37C52 196 0 239 0 320ZM288 320C288 391 231 448 160 448S32 391 32 320S89 192 160 192S288 249 288 320Z"]
  };
  var fa7 = {
    prefix: 'fal',
    iconName: '7',
    icon: [320, 512, [], "e090", "M318 56L62 472C59 477 53 480 48 480C45 480 42 479 40 478C32 473 30 463 34 456L275 64H16C7 64 0 57 0 48S7 32 16 32H304C310 32 315 35 318 40C321 45 321 51 318 56Z"]
  };
  var fa8 = {
    prefix: 'fal',
    iconName: '8',
    icon: [320, 512, [], "e091", "M251 252C283 230 304 193 304 152C304 86 250 32 184 32H136C70 32 16 86 16 152C16 193 37 230 69 252C29 271 0 312 0 360C0 426 54 480 120 480H200C266 480 320 426 320 360C320 312 291 271 251 252ZM48 152C48 103 87 64 136 64H184C233 64 272 103 272 152S233 240 184 240H136C87 240 48 201 48 152ZM200 448H120C71 448 32 409 32 360S71 272 120 272H200C249 272 288 311 288 360S249 448 200 448Z"]
  };
  var fa9 = {
    prefix: 'fal',
    iconName: '9',
    icon: [320, 512, [], "e092", "M320 192C320 104 248 32 160 32S0 104 0 192S72 352 160 352C173 352 185 350 196 347L100 453C94 460 95 470 101 476C104 479 108 480 112 480C116 480 121 478 124 475C268 316 320 273 320 192ZM32 192C32 121 89 64 160 64S288 121 288 192S231 320 160 320S32 263 32 192Z"]
  };
  var faA = {
    prefix: 'fal',
    iconName: 'a',
    icon: [384, 512, [], "e093", "M383 458L207 41C202 29 182 29 177 41L1 458C-2 466 2 475 10 479C18 482 27 478 31 470L67 384H317L353 470C356 476 362 480 368 480C370 480 372 480 374 479C382 475 386 466 383 458ZM81 352L192 88L303 352H81Z"]
  };
  var faAbacus = {
    prefix: 'fal',
    iconName: 'abacus',
    icon: [576, 512, [], "f640", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM512 64C530 64 544 78 544 96V192H448V160H464C473 160 480 153 480 144S473 128 464 128H448V64H512ZM416 64V128H400C391 128 384 135 384 144S391 160 400 160H416V192H288V160H304C313 160 320 153 320 144S313 128 304 128H288V64H416ZM256 64V128H240C231 128 224 135 224 144S231 160 240 160H256V192H160V160H176C185 160 192 153 192 144S185 128 176 128H160V64H256ZM32 96C32 78 46 64 64 64H128V128H112C103 128 96 135 96 144S103 160 112 160H128V192H32V96ZM64 448C46 448 32 434 32 416V224H128V288H112C103 288 96 295 96 304S103 320 112 320H128V352H112C103 352 96 359 96 368S103 384 112 384H128V448H64ZM160 448V384H176C185 384 192 377 192 368S185 352 176 352H160V320H176C185 320 192 313 192 304S185 288 176 288H160V224H256V288H240C231 288 224 295 224 304S231 320 240 320H256V352H240C231 352 224 359 224 368S231 384 240 384H256V448H160ZM288 448V384H304C313 384 320 377 320 368S313 352 304 352H288V320H304C313 320 320 313 320 304S313 288 304 288H288V224H416V352H400C391 352 384 359 384 368S391 384 400 384H416V448H288ZM544 416C544 434 530 448 512 448H448V384H464C473 384 480 377 480 368S473 352 464 352H448V224H544V416Z"]
  };
  var faAcorn = {
    prefix: 'fal',
    iconName: 'acorn',
    icon: [448, 512, [], "f6ae", "M352 64H245C250 50 257 38 267 27C274 21 274 11 267 5S251 -1 245 5C228 21 217 42 212 64H96C43 64 0 107 0 160V176C0 194 14 208 32 208V224C32 322 87 412 175 456L224 480L273 456C361 412 416 322 416 224V208C434 208 448 194 448 176V160C448 107 405 64 352 64ZM384 224C384 311 336 388 259 427L224 444L189 427C112 388 64 311 64 224V208H384V224ZM416 176H32V160C32 125 61 96 96 96H352C387 96 416 125 416 160V176Z"]
  };
  var faAddressBook = {
    prefix: 'fal',
    iconName: 'address-book',
    icon: [512, 512, [], "f2b9", "M240 288H176C132 288 96 324 96 368C96 377 103 384 112 384C121 384 128 377 128 368C128 342 150 320 176 320H240C266 320 288 342 288 368C288 377 295 384 304 384C313 384 320 377 320 368C320 324 284 288 240 288ZM464 192H448V288H464C473 288 480 281 480 272V208C480 199 473 192 464 192ZM208 256C243 256 272 227 272 192S243 128 208 128S144 157 144 192S173 256 208 256ZM208 160C226 160 240 174 240 192S226 224 208 224S176 210 176 192S190 160 208 160ZM464 320H448V416H464C473 416 480 409 480 400V336C480 327 473 320 464 320ZM464 64H448V160H464C473 160 480 153 480 144V80C480 71 473 64 464 64ZM352 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H352C387 512 416 483 416 448V64C416 29 387 0 352 0ZM384 448C384 466 370 480 352 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H352C370 32 384 46 384 64V448Z"]
  };
  var faAddressCard = {
    prefix: 'fal',
    iconName: 'address-card',
    icon: [576, 512, [], "f2bb", "M480 288H352C343 288 336 295 336 304S343 320 352 320H480C489 320 496 313 496 304S489 288 480 288ZM192 256C227 256 256 227 256 192S227 128 192 128S128 157 128 192S157 256 192 256ZM192 160C210 160 224 174 224 192S210 224 192 224S160 210 160 192S174 160 192 160ZM224 288H160C116 288 80 324 80 368C80 377 87 384 96 384S112 377 112 368C112 342 134 320 160 320H224C250 320 272 342 272 368C272 377 279 384 288 384S304 377 304 368C304 324 268 288 224 288ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H512C530 64 544 78 544 96V416ZM480 224H352C343 224 336 231 336 240S343 256 352 256H480C489 256 496 249 496 240S489 224 480 224ZM480 160H352C343 160 336 167 336 176S343 192 352 192H480C489 192 496 185 496 176S489 160 480 160Z"]
  };
  var faAirConditioner = {
    prefix: 'fal',
    iconName: 'air-conditioner',
    icon: [576, 512, [], "f8f4", "M224 416C224 451 195 480 160 480C134 480 112 458 112 432S134 384 160 384C169 384 176 377 176 368S169 352 160 352C116 352 80 388 80 432S116 512 160 512C213 512 256 469 256 416V288H224V416ZM416 320C407 320 400 327 400 336S407 352 416 352C442 352 464 374 464 400S442 448 416 448C381 448 352 419 352 384V288H320V384C320 437 363 480 416 480C460 480 496 444 496 400S460 320 416 320ZM512 0H64C29 0 0 29 0 64V192C0 227 29 256 64 256H512C547 256 576 227 576 192V64C576 29 547 0 512 0ZM544 192C544 210 530 224 512 224H64C46 224 32 210 32 192V64C32 46 46 32 64 32H512C530 32 544 46 544 64V192ZM464 128H112C103 128 96 135 96 144S103 160 112 160H464C473 160 480 153 480 144S473 128 464 128Z"]
  };
  var faAirFreshener = {
    prefix: 'fal',
    iconName: 'air-freshener',
    icon: [384, 512, [], "f5d0", "M192 88C179 88 168 99 168 112S179 136 192 136S216 125 216 112S205 88 192 88ZM376 330L301 240H339C352 240 363 233 368 221C374 210 372 198 364 188L217 11C211 4 202 0 192 0S173 4 167 11L20 188C12 198 10 210 16 221C21 233 32 240 45 240H83L8 330C-1 340 -2 353 3 365C9 377 20 384 34 384H176V416H64C46 416 32 430 32 448V480C32 498 46 512 64 512H320C338 512 352 498 352 480V448C352 430 338 416 320 416H208V384H350C364 384 375 377 381 365C386 353 385 340 376 330ZM320 448V480H64V448H320ZM32 351L129 234C138 223 130 208 117 208L44 209L192 32L340 209L267 208C254 208 246 223 255 234L352 351H32Z"]
  };
  var faAlarmClock = {
    prefix: 'fal',
    iconName: 'alarm-clock',
    icon: [512, 512, [], "f34e", "M41 151C46 146 47 137 43 131C36 121 32 108 32 95C32 78 39 62 51 50C72 29 107 26 131 42C138 46 146 45 151 40C158 33 157 21 149 15C112 -9 60 -5 28 27C10 46 0 70 0 95C0 115 6 133 16 149C22 157 34 158 41 151L41 151ZM485 28C466 10 442 0 417 0C397 0 379 6 363 16C355 22 354 34 361 41C366 46 375 47 381 43C391 36 404 32 417 32C434 32 450 39 462 51C483 72 486 107 470 131C466 138 467 146 472 151C479 158 491 157 497 149C521 112 517 60 485 28ZM231 65C128 77 45 160 33 263C26 329 48 389 87 435L40 481C34 488 34 498 40 504V504C46 510 56 510 63 504L109 457C149 491 200 512 256 512S363 491 403 457L449 504C456 510 466 510 472 504V504C478 498 478 488 472 481L425 435C459 395 480 344 480 288C480 156 366 51 231 65ZM256 480C150 480 64 394 64 288S150 96 256 96S448 182 448 288S362 480 256 480ZM272 296V176C272 167 265 160 256 160S240 167 240 176V304C240 309 242 314 246 317L310 365C313 367 317 368 320 368C325 368 330 366 333 362C338 355 337 345 330 339L272 296Z"]
  };
  var faAlarmExclamation = {
    prefix: 'fal',
    iconName: 'alarm-exclamation',
    icon: [512, 512, [], "f843", "M41 151C46 146 47 137 43 131C36 121 32 108 32 95C32 78 39 62 51 50C72 29 107 26 131 42C138 46 146 45 151 40C158 33 157 21 149 15C112 -9 60 -5 28 27C10 46 0 70 0 95C0 115 6 133 16 149C22 157 34 158 41 151L41 151ZM485 28C466 10 442 0 417 0C397 0 379 6 363 16C355 22 354 34 361 41C366 46 375 47 381 43C391 36 404 32 417 32C434 32 450 39 462 51C483 72 486 107 470 131C466 138 467 146 472 151C479 158 491 157 497 149C521 112 517 60 485 28ZM231 65C128 77 45 160 33 263C26 329 48 389 87 435L40 481C34 488 34 498 40 504V504C46 510 56 510 63 504L109 457C149 491 200 512 256 512S363 491 403 457L449 504C456 510 466 510 472 504V504C478 498 478 488 472 481L425 435C459 395 480 344 480 288C480 156 366 51 231 65ZM256 480C150 480 64 394 64 288S150 96 256 96S448 182 448 288S362 480 256 480ZM256 336C265 336 272 329 272 320V176C272 167 265 160 256 160S240 167 240 176V320C240 329 247 336 256 336ZM256 360C243 360 232 371 232 384C232 397 243 408 256 408S280 397 280 384C280 371 269 360 256 360Z"]
  };
  var faAlarmPlus = {
    prefix: 'fal',
    iconName: 'alarm-plus',
    icon: [512, 512, [], "f844", "M41 151C46 146 47 137 43 131C36 121 32 108 32 95C32 78 39 62 51 50C72 29 107 26 131 42C138 46 146 45 151 40C158 33 157 21 149 15C112 -9 60 -5 28 27C10 46 0 70 0 95C0 115 6 133 16 149C22 157 34 158 41 151L41 151ZM231 65C128 77 45 160 33 263C26 329 48 389 87 435L40 481C34 488 34 498 40 504V504C46 510 56 510 63 504L109 457C149 491 200 512 256 512S363 491 403 457L449 504C456 510 466 510 472 504V504C478 498 478 488 472 481L425 435C459 395 480 344 480 288C480 156 366 51 231 65ZM256 480C150 480 64 394 64 288S150 96 256 96S448 182 448 288S362 480 256 480ZM485 28C466 10 442 0 417 0C397 0 379 6 363 16C355 22 354 34 361 41C366 46 375 47 381 43C391 36 404 32 417 32C434 32 450 39 462 51C483 72 486 107 470 131C466 138 467 146 472 151C479 158 491 157 497 149C521 112 517 60 485 28ZM352 272H272V192C272 183 265 176 256 176S240 183 240 192V272H160C151 272 144 279 144 288S151 304 160 304H240V384C240 393 247 400 256 400S272 393 272 384V304H352C361 304 368 297 368 288S361 272 352 272Z"]
  };
  var faAlarmSnooze = {
    prefix: 'fal',
    iconName: 'alarm-snooze',
    icon: [512, 512, [], "f845", "M41 151C46 146 47 137 43 131C36 121 32 108 32 95C32 78 39 62 51 50C72 29 107 26 131 42C138 46 146 45 151 40C158 33 157 21 149 15C112 -9 60 -5 28 27C10 46 0 70 0 95C0 115 6 133 16 149C22 157 34 158 41 151L41 151ZM231 65C128 77 45 160 33 263C26 329 48 389 87 435L40 481C34 488 34 498 40 504V504C46 510 56 510 63 504L109 457C149 491 200 512 256 512S363 491 403 457L449 504C456 510 466 510 472 504V504C478 498 478 488 472 481L425 435C459 395 480 344 480 288C480 156 366 51 231 65ZM256 480C150 480 64 394 64 288S150 96 256 96S448 182 448 288S362 480 256 480ZM485 28C466 10 442 0 417 0C397 0 379 6 363 16C355 22 354 34 361 41C366 46 375 47 381 43C391 36 404 32 417 32C434 32 450 39 462 51C483 72 486 107 470 131C466 138 467 146 472 151C479 158 491 157 497 149C521 112 517 60 485 28ZM320 352H225L333 218C336 213 337 207 334 201C332 196 326 192 320 192H192C183 192 176 199 176 208S183 224 192 224H287L179 358C176 363 175 369 178 375C180 380 186 384 192 384H320C329 384 336 377 336 368S329 352 320 352Z"]
  };
  var faAlbum = {
    prefix: 'fal',
    iconName: 'album',
    icon: [448, 512, [], "f89f", "M224 232C211 232 200 243 200 256S211 280 224 280S248 269 248 256S237 232 224 232ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM224 96C136 96 64 168 64 256S136 416 224 416S384 344 384 256S312 96 224 96ZM224 384C153 384 96 327 96 256C96 185 153 128 224 128S352 185 352 256C352 327 295 384 224 384Z"]
  };
  var faAlbumCollection = {
    prefix: 'fal',
    iconName: 'album-collection',
    icon: [512, 512, [], "f8a0", "M499 143C490 133 479 128 466 128H46C33 128 22 133 13 143C4 153 -1 167 0 180L25 468C27 493 46 512 70 512H441C465 512 485 493 487 468L512 180C513 166 508 153 499 143ZM455 466C455 474 449 480 441 480H70C63 480 57 474 57 466L32 178C32 173 33 168 36 164C38 163 41 160 46 160H466C470 160 473 162 476 164C479 168 480 173 480 178L455 466ZM256 299C241 299 230 309 230 322S242 344 256 344C270 344 282 334 282 322C282 310 271 299 256 299ZM256 192C163 192 92 254 96 326C101 395 172 448 256 448S411 395 416 326C420 254 349 192 256 192ZM256 416C189 416 131 375 128 324C126 297 140 277 151 265C176 239 214 224 256 224C298 224 336 239 361 265C372 277 385 297 384 324C381 375 323 416 256 416ZM48 32H464C473 32 480 25 480 16S473 0 464 0H48C39 0 32 7 32 16S39 32 48 32ZM32 96H480C489 96 496 89 496 80S489 64 480 64H32C23 64 16 71 16 80S23 96 32 96Z"]
  };
  var faAlicorn = {
    prefix: 'fal',
    iconName: 'alicorn',
    icon: [640, 512, [], "f6b0", "M632 64H535L535 64C541 54 544 42 543 30C543 13 528 0 511 0L400 0C331 0 275 55 272 124C237 115 209 89 191 47C187 38 178 32 168 32C157 32 149 37 145 46C134 70 128 95 128 121C128 196 185 265 261 283C265 284 270 281 271 277L274 261C274 257 272 253 268 252C206 237 160 182 160 121C160 105 163 89 168 74C197 130 244 160 304 160V128C304 75 347 32 400 32H511C511 45 503 57 492 62L512 86V180C512 187 508 193 501 195L476 204C466 207 460 201 457 198L432 160L384 144V244C384 271 371 294 352 310V464C352 473 345 480 336 480H304C295 480 288 473 288 464V319L184 295L151 385L170 460C173 470 165 480 155 480H131C123 480 117 475 115 468L97 392C96 387 96 381 97 376L125 283C107 270 96 250 96 227C96 211 102 197 111 186C106 175 102 164 99 152C91 159 84 167 79 176C35 177 0 212 0 256V304C0 313 7 320 16 320S32 313 32 304V256C32 234 46 217 66 210C65 216 64 222 64 227C64 252 73 275 89 293L67 367C63 378 63 389 66 400L84 475C89 497 108 512 131 512H155C186 512 209 483 201 452L185 387L204 333L256 344V464C256 490 278 512 304 512H336C362 512 384 490 384 464V324C405 302 416 274 416 244V194L430 216C450 244 481 236 486 234L511 226C531 219 544 201 544 180V115L636 79C643 74 640 64 632 64ZM464 96C464 87 457 80 448 80S432 87 432 96S439 112 448 112S464 105 464 96Z"]
  };
  var faAlien = {
    prefix: 'fal',
    iconName: 'alien',
    icon: [448, 512, [], "f8f5", "M224 0C100 0 0 88 0 232C0 344 134 457 195 502C212 515 236 515 253 502C314 457 448 344 448 232C448 88 348 0 224 0ZM234 477C228 481 220 481 214 477C171 445 32 333 32 232C32 114 111 32 224 32S416 114 416 232C416 333 277 445 234 477ZM368 212H320C276 212 240 248 240 292V304C240 313 247 320 256 320H304C348 320 384 284 384 240V228C384 219 377 212 368 212ZM304 288H272C274 263 295 244 320 244H352C350 269 329 288 304 288ZM128 212H80C71 212 64 219 64 228V240C64 284 100 320 144 320H192C201 320 208 313 208 304V292C208 248 172 212 128 212ZM144 288C119 288 98 269 96 244H128C153 244 174 263 176 288H144Z"]
  };
  var faAlien8bit = {
    prefix: 'fal',
    iconName: 'alien-8bit',
    icon: [576, 512, [], "f8f6", "M192 320H224V224H192V320ZM352 320H384V224H352V320ZM544 112H512C494 112 480 126 480 144V160H416V128H448C466 128 480 114 480 96V64C480 46 466 32 448 32H416C398 32 384 46 384 64H352C334 64 320 78 320 96V128H256V96C256 78 242 64 224 64H192C192 46 178 32 160 32H128C110 32 96 46 96 64V96C96 114 110 128 128 128H160V160H96V144C96 126 82 112 64 112H32C14 112 0 126 0 144V288C0 306 14 320 32 320H64V352C64 370 78 384 96 384H128V448C128 466 142 480 160 480H240C258 480 272 466 272 448V416C272 398 258 384 240 384H336C318 384 304 398 304 416V448C304 466 318 480 336 480H416C434 480 448 466 448 448V384H480C498 384 512 370 512 352V320H544C562 320 576 306 576 288V144C576 126 562 112 544 112ZM416 64H448V96H416V64ZM128 96V64H160V96H128ZM240 448H160V384H192V416H240V448ZM416 448H336V416H384V384H416V448ZM544 288H480V352H96V288H32V144H64V256H96V192H192V96H224V160H352V96H384V192H480V256H512V144H544V288Z"]
  };
  var faAlignCenter = {
    prefix: 'fal',
    iconName: 'align-center',
    icon: [448, 512, [], "f037", "M16 208H432C441 208 448 201 448 192S441 176 432 176H16C7 176 0 183 0 192S7 208 16 208ZM112 80H336C345 80 352 73 352 64S345 48 336 48H112C103 48 96 55 96 64S103 80 112 80ZM432 432H16C7 432 0 439 0 448S7 464 16 464H432C441 464 448 457 448 448S441 432 432 432ZM112 304C103 304 96 311 96 320S103 336 112 336H336C345 336 352 329 352 320S345 304 336 304H112Z"]
  };
  var faAlignJustify = {
    prefix: 'fal',
    iconName: 'align-justify',
    icon: [448, 512, [], "f039", "M432 432H16C7 432 0 439 0 448S7 464 16 464H432C441 464 448 457 448 448S441 432 432 432ZM16 80H432C441 80 448 73 448 64S441 48 432 48H16C7 48 0 55 0 64S7 80 16 80ZM432 176H16C7 176 0 183 0 192S7 208 16 208H432C441 208 448 201 448 192S441 176 432 176ZM432 304H16C7 304 0 311 0 320S7 336 16 336H432C441 336 448 329 448 320S441 304 432 304Z"]
  };
  var faAlignLeft = {
    prefix: 'fal',
    iconName: 'align-left',
    icon: [448, 512, [], "f036", "M16 208H432C441 208 448 201 448 192S441 176 432 176H16C7 176 0 183 0 192S7 208 16 208ZM16 80H272C281 80 288 73 288 64S281 48 272 48H16C7 48 0 55 0 64S7 80 16 80ZM16 336H272C281 336 288 329 288 320S281 304 272 304H16C7 304 0 311 0 320S7 336 16 336ZM432 432H16C7 432 0 439 0 448S7 464 16 464H432C441 464 448 457 448 448S441 432 432 432Z"]
  };
  var faAlignRight = {
    prefix: 'fal',
    iconName: 'align-right',
    icon: [448, 512, [], "f038", "M176 80H432C441 80 448 73 448 64S441 48 432 48H176C167 48 160 55 160 64S167 80 176 80ZM432 432H16C7 432 0 439 0 448S7 464 16 464H432C441 464 448 457 448 448S441 432 432 432ZM432 176H16C7 176 0 183 0 192S7 208 16 208H432C441 208 448 201 448 192S441 176 432 176ZM432 304H176C167 304 160 311 160 320S167 336 176 336H432C441 336 448 329 448 320S441 304 432 304Z"]
  };
  var faAlignSlash = {
    prefix: 'fal',
    iconName: 'align-slash',
    icon: [640, 512, [], "f846", "M528 304H484L525 336H528C537 336 544 329 544 320C544 311 537 304 528 304ZM528 80C537 80 544 73 544 64C544 55 537 48 528 48H160L200 80H528ZM528 176H322L363 208H528C537 208 544 201 544 192C544 183 537 176 528 176ZM112 336H318L278 304H112C103 304 96 311 96 320C96 329 103 336 112 336ZM112 432C103 432 96 439 96 448C96 457 103 464 112 464H480L440 432H112ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483ZM112 208H156L115 176H112C103 176 96 183 96 192C96 201 103 208 112 208Z"]
  };
  var faAlt = {
    prefix: 'fal',
    iconName: 'alt',
    icon: [512, 512, [], "e094", "M496 96C505 96 512 89 512 80S505 64 496 64H384C379 64 374 66 371 71L120 416H16C7 416 0 423 0 432S7 448 16 448H128C133 448 138 446 141 441L392 96H496ZM496 416H336C327 416 320 423 320 432S327 448 336 448H496C505 448 512 441 512 432S505 416 496 416Z"]
  };
  var faAmpGuitar = {
    prefix: 'fal',
    iconName: 'amp-guitar',
    icon: [512, 512, [], "f8a1", "M416 352C425 352 432 345 432 336S425 320 416 320S400 327 400 336S407 352 416 352ZM352 352C361 352 368 345 368 336S361 320 352 320S336 327 336 336S343 352 352 352ZM384 400C393 400 400 393 400 384S393 368 384 368S368 375 368 384S375 400 384 400ZM288 352C297 352 304 345 304 336S297 320 288 320S272 327 272 336S279 352 288 352ZM320 400C329 400 336 393 336 384S329 368 320 368S304 375 304 384S311 400 320 400ZM160 416C151 416 144 423 144 432S151 448 160 448S176 441 176 432S169 416 160 416ZM416 416C407 416 400 423 400 432S407 448 416 448S432 441 432 432S425 416 416 416ZM224 416C215 416 208 423 208 432S215 448 224 448S240 441 240 432S233 416 224 416ZM256 400C265 400 272 393 272 384S265 368 256 368S240 375 240 384S247 400 256 400ZM288 416C279 416 272 423 272 432S279 448 288 448S304 441 304 432S297 416 288 416ZM352 416C343 416 336 423 336 432S343 448 352 448S368 441 368 432S361 416 352 416ZM224 352C233 352 240 345 240 336S233 320 224 320S208 327 208 336S215 352 224 352ZM464 64H387C358 36 310 0 256 0S154 36 125 64H48C22 64 0 86 0 112V464C0 490 22 512 48 512H464C490 512 512 490 512 464V112C512 86 490 64 464 64ZM256 32C286 32 315 47 338 64H174C197 47 226 32 256 32ZM480 464C480 473 473 480 464 480H48C39 480 32 473 32 464V288H480V464ZM480 256H32V112C32 103 39 96 48 96H464C473 96 480 103 480 112V256ZM96 352C105 352 112 345 112 336S105 320 96 320S80 327 80 336S87 352 96 352ZM96 448C105 448 112 441 112 432S105 416 96 416S80 423 80 432S87 448 96 448ZM160 352C169 352 176 345 176 336S169 320 160 320S144 327 144 336S151 352 160 352ZM192 400C201 400 208 393 208 384S201 368 192 368S176 375 176 384S183 400 192 400ZM128 400C137 400 144 393 144 384S137 368 128 368S112 375 112 384S119 400 128 400ZM96 152C83 152 72 163 72 176S83 200 96 200C109 200 120 189 120 176S109 152 96 152ZM192 152C179 152 168 163 168 176S179 200 192 200C205 200 216 189 216 176S205 152 192 152ZM320 152C307 152 296 163 296 176S307 200 320 200C333 200 344 189 344 176S333 152 320 152ZM416 152C403 152 392 163 392 176S403 200 416 200C429 200 440 189 440 176S429 152 416 152Z"]
  };
  var faAmpersand = {
    prefix: 'fal',
    iconName: 'ampersand',
    icon: [384, 512, [], "e095", "M380 453L308 379L381 274C386 267 384 257 377 252C370 247 360 249 355 256L286 355L170 236L240 180C260 164 272 141 272 115C272 69 234 32 187 32H133C86 32 48 69 48 115C48 140 57 164 75 182L123 232L39 299C14 319 0 347 0 378C0 434 47 480 104 480H170C212 480 252 460 275 426L289 405L356 475C360 478 364 480 368 480C372 480 376 479 379 476C385 469 386 459 380 453ZM98 160C86 148 80 132 80 115C80 87 104 64 133 64H187C216 64 240 87 240 115C240 131 233 145 220 155L148 212L98 160ZM249 407C231 433 202 448 170 448H104C64 448 32 417 32 378C32 357 42 338 59 324L145 256L267 382L249 407Z"]
  };
  var faAnchor = {
    prefix: 'fal',
    iconName: 'anchor',
    icon: [576, 512, [], "f13d", "M571 325L507 261C501 254 491 254 485 261L421 325C414 331 414 341 421 347S437 354 443 347L480 311V336C480 415 415 480 336 480H304V224H368C377 224 384 217 384 208S377 192 368 192H304V158C340 151 368 119 368 80C368 36 332 0 288 0S208 36 208 80C208 119 235 151 272 158V192H208C199 192 192 199 192 208S199 224 208 224H272V480H240C161 480 96 415 96 336V311L133 347C136 350 140 352 144 352S152 350 155 347C162 341 162 331 155 325L91 261C85 254 75 254 69 261L5 325C-2 331 -2 341 5 347S21 354 27 347L64 311V336C64 433 143 512 240 512H336C433 512 512 433 512 336V311L549 347C552 350 556 352 560 352S568 350 571 347C578 341 578 331 571 325ZM240 80C240 54 262 32 288 32S336 54 336 80S314 128 288 128S240 106 240 80Z"]
  };
  var faAngel = {
    prefix: 'fal',
    iconName: 'angel',
    icon: [576, 512, [], "f779", "M208 144C208 188 244 224 288 224S368 188 368 144S332 64 288 64S208 100 208 144ZM336 144C336 170 314 192 288 192S240 170 240 144S261 96 288 96S336 118 336 144ZM573 465L534 386C527 370 527 352 534 336C551 302 560 299 560 264C560 217 517 176 468 176C445 176 423 185 407 202L339 270C324 261 306 256 288 256S252 261 237 270L169 202C153 185 131 176 108 176C59 176 16 217 16 264C16 299 25 302 42 336C49 351 49 370 42 386L4 465C-8 489 11 512 33 512H543C566 512 584 488 573 465ZM33 480L70 400C82 375 82 346 70 322C53 285 48 290 48 264C48 235 77 208 109 208C123 208 136 214 146 224L211 290C205 297 200 305 195 313L112 480H33ZM148 480L224 328C236 303 261 288 288 288C315 288 340 303 352 328L428 480H148ZM464 480V480L381 313C376 305 371 297 364 290L430 224C440 214 453 208 467 208C499 208 528 235 528 264C528 290 523 285 505 322C493 346 493 375 505 400L543 480H464ZM186 123C192 117 192 107 185 101C179 94 176 88 176 82C176 58 224 32 288 32S400 58 400 82C400 88 397 94 390 101C384 107 384 117 390 123C394 126 398 128 402 128C406 128 410 126 413 123C425 111 432 97 432 82C432 36 369 0 288 0S144 36 144 82C144 97 151 111 163 123C169 130 179 130 186 123Z"]
  };
  var faAngleDown = {
    prefix: 'fal',
    iconName: 'angle-down',
    icon: [384, 512, [], "f107", "M363 204L203 348C197 353 187 353 181 348L21 204C15 198 14 188 20 181C26 174 36 174 43 180L192 314L341 180C348 174 358 175 364 181C370 188 369 198 363 204Z"]
  };
  var faAngleLeft = {
    prefix: 'fal',
    iconName: 'angle-left',
    icon: [256, 512, [], "f104", "M204 405C210 412 209 422 203 428C196 434 186 433 180 427L36 267C31 261 31 251 36 245L180 85C186 79 196 78 203 84C210 90 209 100 204 107L70 256L204 405Z"]
  };
  var faAngleRight = {
    prefix: 'fal',
    iconName: 'angle-right',
    icon: [256, 512, [], "f105", "M204 267L60 427C54 433 44 434 37 428C30 422 31 412 36 405L170 256L36 107C30 100 31 90 37 84C44 78 54 79 60 85L204 245C209 251 209 261 204 267Z"]
  };
  var faAngleUp = {
    prefix: 'fal',
    iconName: 'angle-up',
    icon: [384, 512, [], "f106", "M364 331C358 338 348 338 341 332L192 198L43 332C36 338 26 337 20 331C14 324 15 314 21 308L181 164C187 159 197 159 203 164L363 308C369 314 370 324 364 331Z"]
  };
  var faAnglesDown = {
    prefix: 'fal',
    iconName: 'angles-down',
    icon: [384, 512, [], "f103", "M181 252C187 257 197 257 203 252L363 108C369 102 370 92 364 85C358 79 348 78 341 84L192 218L43 84C37 78 26 78 20 85C14 92 15 102 21 108L181 252ZM341 276L192 410L43 276C37 270 26 270 20 277C14 284 15 294 21 300L181 444C187 449 197 449 203 444L363 300C369 294 370 284 364 277C358 271 348 270 341 276Z"]
  };
  var faAnglesLeft = {
    prefix: 'fal',
    iconName: 'angles-left',
    icon: [448, 512, [], "f100", "M203 84C196 78 186 79 180 85L36 245C31 251 31 261 36 267L180 427C186 433 196 434 203 428C209 422 210 412 204 405L70 256L204 107C210 101 210 90 203 84ZM262 256L396 107C402 100 402 90 395 84C388 78 378 79 372 85L228 245C223 251 223 261 228 267L372 427C378 433 388 434 395 428C401 422 402 412 396 405L262 256Z"]
  };
  var faAnglesRight = {
    prefix: 'fal',
    iconName: 'angles-right',
    icon: [448, 512, [], "f101", "M60 85C54 79 44 78 37 84C31 90 30 100 36 107L170 256L36 405C31 412 30 422 37 428C44 434 54 433 60 427L204 267C209 261 209 251 204 245L60 85ZM396 245L252 85C246 79 236 78 229 84C223 90 222 100 228 107L362 256L228 405C223 412 222 422 229 428C236 434 246 433 252 427L396 267C401 261 401 251 396 245Z"]
  };
  var faAnglesUp = {
    prefix: 'fal',
    iconName: 'angles-up',
    icon: [384, 512, [], "f102", "M43 236L192 102L341 236C348 242 358 242 364 235C370 228 369 218 363 212L203 68C197 63 187 63 181 68L21 212C15 218 14 228 20 235C26 241 36 242 43 236ZM203 260C197 255 187 255 181 260L21 404C15 410 14 420 20 427C26 433 36 434 43 428L192 294L341 428C348 434 358 434 364 427C370 420 369 410 363 404L203 260Z"]
  };
  var faAnkh = {
    prefix: 'fal',
    iconName: 'ankh',
    icon: [320, 512, [], "f644", "M304 288H215C252 252 288 192 288 137C288 53 231 0 160 0S32 53 32 137C32 192 68 252 105 288H16C7 288 0 295 0 304S7 320 16 320H144V496C144 505 151 512 160 512S176 505 176 496V320H304C313 320 320 313 320 304S313 288 304 288ZM160 288H160C139 286 64 209 64 137C64 75 103 32 160 32S256 75 256 137C256 209 181 286 160 288Z"]
  };
  var faAppleCrate = {
    prefix: 'fal',
    iconName: 'apple-crate',
    icon: [512, 512, [], "f6b1", "M336 126L352 135V135L352 135L352 135V135L368 126C422 96 435 123 435 123C447 140 450 171 446 192H478C489 121 450 44 352 98C328 85 308 80 290 80C299 90 305 102 310 115C317 117 326 120 336 126ZM432 288C423 288 416 295 416 304S423 320 432 320S448 313 448 304S441 288 432 288ZM66 192C62 171 65 140 77 123C77 123 90 96 144 126L160 135V135L160 135L160 135V135L176 126C230 96 243 123 243 123C255 140 258 171 254 192H286C297 121 258 44 160 98C62 44 23 121 34 192H66ZM368 64C372 64 376 62 379 59L411 27C418 21 418 11 411 5S395 -2 389 5L357 37C350 43 350 53 357 59C360 62 364 64 368 64ZM176 64C180 64 184 62 187 59L219 27C226 21 226 11 219 5S203 -2 197 5L165 37C158 43 158 53 165 59C168 62 172 64 176 64ZM80 288C71 288 64 295 64 304S71 320 80 320S96 313 96 304S89 288 80 288ZM432 448C441 448 448 441 448 432S441 416 432 416S416 423 416 432S423 448 432 448ZM472 224H470V224H436V224H279V224H244V224H76V224H41V224H40C18 224 0 242 0 264V472C0 494 18 512 40 512H472C494 512 512 494 512 472V264C512 242 494 224 472 224ZM480 464C480 473 473 480 464 480H48C39 480 32 473 32 464V384H480V464ZM480 352H32V272C32 263 39 256 48 256H464C473 256 480 263 480 272V352ZM80 448C89 448 96 441 96 432S89 416 80 416S64 423 64 432S71 448 80 448Z"]
  };
  var faAppleWhole = {
    prefix: 'fal',
    iconName: 'apple-whole',
    icon: [448, 512, [], "f5d1", "M207 127C207 127 212 128 220 128C238 128 272 125 294 102C326 71 320 17 319 15C318 7 313 2 305 1C305 1 250 -7 218 26C186 57 192 111 193 113C194 121 199 126 207 127ZM240 48C253 35 276 33 288 32C287 47 284 68 272 80C259 93 236 96 224 96C225 81 228 60 240 48ZM351 129C347 128 342 128 337 128C301 128 250 146 224 160C199 146 147 128 111 128C106 128 101 128 97 129C16 144 -11 254 4 335C18 416 65 512 160 512C173 512 185 507 195 502C204 497 214 494 224 494C234 494 244 497 253 502C263 507 275 512 288 512C383 512 430 416 444 335C459 254 433 144 351 129ZM413 329C408 354 382 480 288 480C272 480 260 462 224 462C188 462 176 480 160 480C67 480 40 354 35 329C29 292 32 251 44 218C53 195 70 166 102 161C132 156 188 177 208 188C213 191 219 192 224 192S235 191 240 188C259 177 316 156 346 161C378 166 395 195 404 218C416 251 419 292 413 329Z"]
  };
  var faArchway = {
    prefix: 'fal',
    iconName: 'archway',
    icon: [576, 512, [], "f557", "M560 480H544V32H560C569 32 576 25 576 16S569 0 560 0H16C7 0 0 7 0 16S7 32 16 32H32V480H16C7 480 0 487 0 496S7 512 16 512H176C185 512 192 505 192 496V323C192 270 233 225 286 224C340 223 384 266 384 320V496C384 505 391 512 400 512H560C569 512 576 505 576 496S569 480 560 480ZM512 480H416V320C416 249 359 192 288 192S160 249 160 320V480H64V128H512V480ZM512 96H64V32H512V96Z"]
  };
  var faArrowDown = {
    prefix: 'fal',
    iconName: 'arrow-down',
    icon: [448, 512, [], "f063", "M5 245C8 242 12 240 16 240S24 242 27 245L208 425V48C208 39 215 32 224 32S240 39 240 48V425L421 245C427 238 437 238 443 245S450 261 443 267L235 475C229 482 219 482 213 475L5 267C-2 261 -2 251 5 245Z"]
  };
  var faArrowDown19 = {
    prefix: 'fal',
    iconName: 'arrow-down-1-9',
    icon: [448, 512, [], "f162", "M164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358ZM352 256C308 256 272 292 272 336S308 416 352 416C369 416 384 411 397 402C389 428 365 448 336 448C327 448 320 455 320 464S327 480 336 480C389 480 432 437 432 384V336C432 292 396 256 352 256ZM352 384C326 384 304 362 304 336S326 288 352 288S400 310 400 336S378 384 352 384ZM304 224H400C409 224 416 217 416 208S409 192 400 192H368V48C368 39 361 32 352 32H320C311 32 304 39 304 48S311 64 320 64H336V192H304C295 192 288 199 288 208S295 224 304 224Z"]
  };
  var faArrowDown91 = {
    prefix: 'fal',
    iconName: 'arrow-down-9-1',
    icon: [448, 512, [], "f886", "M164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358ZM352 32C308 32 272 68 272 112S308 192 352 192C369 192 384 187 397 178C389 204 365 224 336 224C327 224 320 231 320 240S327 256 336 256C389 256 432 213 432 160V112C432 68 396 32 352 32ZM352 160C326 160 304 138 304 112S326 64 352 64S400 86 400 112S378 160 352 160ZM400 448H368V304C368 295 361 288 352 288H320C311 288 304 295 304 304S311 320 320 320H336V448H304C295 448 288 455 288 464S295 480 304 480H400C409 480 416 473 416 464S409 448 400 448Z"]
  };
  var faArrowDownAZ = {
    prefix: 'fal',
    iconName: 'arrow-down-a-z',
    icon: [448, 512, [], "f15d", "M164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358ZM446 201L366 41C361 30 343 30 338 41L258 201C254 209 257 218 265 222C273 226 282 223 286 215L298 192H406L418 215C421 221 430 227 439 222C447 218 450 209 446 201ZM314 160L352 84L390 160H314ZM416 448H321L429 314C432 309 433 303 430 297C428 292 422 288 416 288H288C279 288 272 295 272 304S279 320 288 320H383L276 454C272 459 271 465 274 471C276 476 282 480 288 480H416C425 480 432 473 432 464S425 448 416 448Z"]
  };
  var faArrowDownArrowUp = {
    prefix: 'fal',
    iconName: 'arrow-down-arrow-up',
    icon: [384, 512, [], "f883", "M380 134L300 38C297 34 293 32 288 32S279 34 276 38L196 134C190 141 191 151 198 156C205 162 215 161 220 154L272 92V464C272 473 279 480 288 480S304 473 304 464V92L356 154C361 161 371 162 378 156C385 151 386 141 380 134ZM164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358Z"]
  };
  var faArrowDownBigSmall = {
    prefix: 'fal',
    iconName: 'arrow-down-big-small',
    icon: [640, 512, [], "f88c", "M228 358L176 420V48C176 39 169 32 160 32S144 39 144 48V420L92 358C87 351 77 350 70 356C63 361 62 371 68 378L148 474C151 478 155 480 160 480S169 478 172 474L252 378C258 371 257 361 250 356C243 350 233 351 228 358ZM480 320H352C334 320 320 334 320 352V448C320 466 334 480 352 480H480C498 480 512 466 512 448V352C512 334 498 320 480 320ZM480 448H352V352H480V448ZM544 32H352C334 32 320 46 320 64V224C320 242 334 256 352 256H544C562 256 576 242 576 224V64C576 46 562 32 544 32ZM544 224H352V64H544V224Z"]
  };
  var faArrowDownFromLine = {
    prefix: 'fal',
    iconName: 'arrow-down-from-line',
    icon: [384, 512, [], "f345", "M325 309L208 425V128C208 119 201 112 192 112S176 119 176 128V425L59 309C53 302 43 302 37 309S30 325 37 331L181 475C184 478 188 480 192 480S200 478 203 475L347 331C354 325 354 315 347 309S331 302 325 309ZM368 32H16C7 32 0 39 0 48S7 64 16 64H368C377 64 384 57 384 48S377 32 368 32Z"]
  };
  var faArrowDownLeftAndArrowUpRightToCenter = {
    prefix: 'fal',
    iconName: 'arrow-down-left-and-arrow-up-right-to-center',
    icon: [512, 512, [], "e096", "M208 283H48C39 283 32 290 32 299S39 315 48 315H169L21 464C14 470 14 480 21 487S37 493 43 487L192 338V459C192 468 199 475 208 475S224 468 224 459V299C224 290 217 283 208 283ZM491 16C485 10 475 10 469 16L320 165V43C320 34 313 27 304 27S288 34 288 43V203C288 212 295 219 304 219H464C473 219 480 212 480 203S473 187 464 187H343L491 39C498 32 498 22 491 16Z"]
  };
  var faArrowDownLong = {
    prefix: 'fal',
    iconName: 'arrow-down-long',
    icon: [320, 512, [], "f175", "M315 363L171 507C168 510 164 512 160 512S152 510 149 507L5 363C-2 357 -2 347 5 341S21 334 27 341L144 457V16C144 7 151 0 160 0S176 7 176 16V457L293 341C299 334 309 334 315 341S322 357 315 363Z"]
  };
  var faArrowDownShortWide = {
    prefix: 'fal',
    iconName: 'arrow-down-short-wide',
    icon: [512, 512, [], "f884", "M164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358ZM512 448C512 439 505 432 496 432H240C231 432 224 439 224 448S231 464 240 464H496C505 464 512 457 512 448ZM448 320C448 311 441 304 432 304H240C231 304 224 311 224 320S231 336 240 336H432C441 336 448 329 448 320ZM384 192C384 183 377 176 368 176H240C231 176 224 183 224 192S231 208 240 208H368C377 208 384 201 384 192ZM320 64C320 55 313 48 304 48H240C231 48 224 55 224 64S231 80 240 80H304C313 80 320 73 320 64Z"]
  };
  var faArrowDownSmallBig = {
    prefix: 'fal',
    iconName: 'arrow-down-small-big',
    icon: [512, 512, [], "f88d", "M164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358ZM288 192H416C434 192 448 178 448 160V64C448 46 434 32 416 32H288C270 32 256 46 256 64V160C256 178 270 192 288 192ZM288 64H416V160H288V64ZM480 256H288C270 256 256 270 256 288V448C256 466 270 480 288 480H480C498 480 512 466 512 448V288C512 270 498 256 480 256ZM480 448H288V288H480V448Z"]
  };
  var faArrowDownSquareTriangle = {
    prefix: 'fal',
    iconName: 'arrow-down-square-triangle',
    icon: [640, 512, [], "f889", "M260 358L208 420V48C208 39 201 32 192 32S176 39 176 48V420L124 358C119 351 109 350 102 356C95 361 94 371 100 378L180 474C183 478 187 480 192 480S201 478 204 474L284 378C290 371 289 361 282 356C275 350 265 351 260 358ZM540 439L457 302C451 293 442 288 432 288S413 293 407 302L324 439C313 457 327 480 349 480H515C537 480 551 457 540 439ZM356 448L432 322L508 448H356ZM360 224H504C517 224 528 213 528 200V56C528 43 517 32 504 32H360C347 32 336 43 336 56V200C336 213 347 224 360 224ZM368 64H496V192H368V64Z"]
  };
  var faArrowDownToLine = {
    prefix: 'fal',
    iconName: 'arrow-down-to-line',
    icon: [384, 512, [], "f33d", "M181 395C184 398 188 400 192 400S200 398 203 395L347 251C354 245 354 235 347 229S331 222 325 229L208 345V48C208 39 201 32 192 32S176 39 176 48V345L59 229C53 222 43 222 37 229S30 245 37 251L181 395ZM368 448H16C7 448 0 455 0 464S7 480 16 480H368C377 480 384 473 384 464S377 448 368 448Z"]
  };
  var faArrowDownToSquare = {
    prefix: 'fal',
    iconName: 'arrow-down-to-square',
    icon: [448, 512, [], "e097", "M400 128H336C327 128 320 135 320 144S327 160 336 160H400C409 160 416 167 416 176V464C416 473 409 480 400 480H48C39 480 32 473 32 464V176C32 167 39 160 48 160H112C121 160 128 153 128 144S121 128 112 128H48C22 128 0 150 0 176V464C0 490 22 512 48 512H400C426 512 448 490 448 464V176C448 150 426 128 400 128ZM117 261C110 267 110 277 117 283L213 379C216 382 220 384 224 384S232 382 235 379L331 283C338 277 338 267 331 261S315 254 309 261L240 329V16C240 7 233 0 224 0S208 7 208 16V329L139 261C133 254 123 254 117 261Z"]
  };
  var faArrowDownTriangleSquare = {
    prefix: 'fal',
    iconName: 'arrow-down-triangle-square',
    icon: [448, 512, [], "f888", "M164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358ZM444 183L361 46C355 37 346 32 336 32S317 37 311 46L228 183C217 201 231 224 253 224H419C441 224 455 201 444 183ZM260 192L336 66L412 192H260ZM408 288H264C251 288 240 299 240 312V456C240 469 251 480 264 480H408C421 480 432 469 432 456V312C432 299 421 288 408 288ZM400 448H272V320H400V448Z"]
  };
  var faArrowDownWideShort = {
    prefix: 'fal',
    iconName: 'arrow-down-wide-short',
    icon: [512, 512, [], "f160", "M164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358ZM496 48H240C231 48 224 55 224 64S231 80 240 80H496C505 80 512 73 512 64S505 48 496 48ZM432 176H240C231 176 224 183 224 192S231 208 240 208H432C441 208 448 201 448 192S441 176 432 176ZM368 304H240C231 304 224 311 224 320S231 336 240 336H368C377 336 384 329 384 320S377 304 368 304ZM304 432H240C231 432 224 439 224 448S231 464 240 464H304C313 464 320 457 320 448S313 432 304 432Z"]
  };
  var faArrowDownZA = {
    prefix: 'fal',
    iconName: 'arrow-down-z-a',
    icon: [448, 512, [], "f881", "M164 358L112 420V48C112 39 105 32 96 32S80 39 80 48V420L28 358C23 351 13 350 6 356C-1 361 -2 371 4 378L84 474C87 478 91 480 96 480S105 478 108 474L188 378C194 371 193 361 186 356C179 350 169 351 164 358ZM288 64H383L276 198C272 203 271 209 274 215C276 220 282 224 288 224H416C425 224 432 217 432 208S425 192 416 192H321L429 58C432 53 433 47 430 41C428 36 422 32 416 32H288C279 32 272 39 272 48C272 57 279 64 288 64ZM446 457L366 297C361 286 343 286 338 297L258 457C254 465 257 474 265 478C273 482 282 479 286 471L298 448H406L418 471C421 477 430 483 439 478C447 474 450 465 446 457ZM314 416L352 340L390 416H314Z"]
  };
  var faArrowLeft = {
    prefix: 'fal',
    iconName: 'arrow-left',
    icon: [448, 512, [], "f060", "M448 256C448 265 441 272 432 272H55L235 453C242 459 242 469 235 475S219 482 213 475L5 267C-2 261 -2 251 5 245L213 37C219 30 229 30 235 37C238 40 240 44 240 48S238 56 235 59L55 240H432C441 240 448 247 448 256Z"]
  };
  var faArrowLeftFromLine = {
    prefix: 'fal',
    iconName: 'arrow-left-from-line',
    icon: [448, 512, [], "f344", "M352 240H55L171 123C178 117 178 107 171 101S155 94 149 101L5 245C2 248 0 252 0 256S2 264 5 267L149 411C155 418 165 418 171 411S178 395 171 389L55 272H352C361 272 368 265 368 256S361 240 352 240ZM432 64C423 64 416 71 416 80V432C416 441 423 448 432 448S448 441 448 432V80C448 71 441 64 432 64Z"]
  };
  var faArrowLeftLong = {
    prefix: 'fal',
    iconName: 'arrow-left-long',
    icon: [512, 512, [], "f177", "M149 411L5 267C2 264 0 260 0 256S2 248 5 245L149 101C155 94 165 94 171 101S178 117 171 123L55 240H496C505 240 512 247 512 256S505 272 496 272H55L171 389C178 395 178 405 171 411S155 418 149 411Z"]
  };
  var faArrowLeftRotate = {
    prefix: 'fal',
    iconName: 'arrow-left-rotate',
    icon: [512, 512, [], "f0e2", "M480 256C480 379 380 480 256 480C187 480 122 449 79 394C74 387 75 377 82 371C89 366 99 367 105 374C141 421 197 448 256 448C362 448 448 362 448 256S362 64 256 64C187 64 125 101 90 160H176C185 160 192 167 192 176S185 192 176 192H48C39 192 32 185 32 176V48C32 39 39 32 48 32S64 39 64 48V142C104 74 177 32 256 32C380 32 480 133 480 256Z"]
  };
  var faArrowLeftToLine = {
    prefix: 'fal',
    iconName: 'arrow-left-to-line',
    icon: [448, 512, [], "f33e", "M432 240H135L251 123C258 117 258 107 251 101S235 94 229 101L85 245C82 248 80 252 80 256S82 264 85 267L229 411C235 418 245 418 251 411S258 395 251 389L135 272H432C441 272 448 265 448 256S441 240 432 240ZM16 64C7 64 0 71 0 80V432C0 441 7 448 16 448S32 441 32 432V80C32 71 25 64 16 64Z"]
  };
  var faArrowPointer = {
    prefix: 'fal',
    iconName: 'arrow-pointer',
    icon: [320, 512, [], "f245", "M312 278L40 38C35 34 30 32 24 32C21 32 17 33 14 34C6 38 0 47 0 56V424C0 434 6 443 16 447C18 448 21 448 24 448C31 448 38 445 42 440L132 333L193 470C196 476 202 480 208 480C210 480 212 480 214 479C223 475 226 466 223 458L162 320H296C306 320 315 314 318 304C322 295 319 285 312 278ZM129 288L120 299L32 402V74L275 288H129Z"]
  };
  var faArrowRight = {
    prefix: 'fal',
    iconName: 'arrow-right',
    icon: [448, 512, [], "f061", "M443 267L235 475C229 482 219 482 213 475C210 472 208 468 208 464S210 456 213 453L393 272H16C7 272 0 265 0 256S7 240 16 240H393L213 59C206 53 206 43 213 37S229 30 235 37L443 245C450 251 450 261 443 267Z"]
  };
  var faArrowRightArrowLeft = {
    prefix: 'fal',
    iconName: 'arrow-right-arrow-left',
    icon: [512, 512, [], "f0ec", "M16 160H457L357 261C350 267 350 277 357 283S373 290 379 283L507 155C510 152 512 148 512 144S510 136 507 133L379 5C373 -2 363 -2 357 5S350 21 357 27L457 128H16C7 128 0 135 0 144S7 160 16 160ZM496 352H55L155 251C162 245 162 235 155 229S139 222 133 229L5 357C2 360 0 364 0 368S2 376 5 379L133 507C139 514 149 514 155 507S162 491 155 485L55 384H496C505 384 512 377 512 368S505 352 496 352Z"]
  };
  var faArrowRightFromBracket = {
    prefix: 'fal',
    iconName: 'arrow-right-from-bracket',
    icon: [512, 512, [], "f08b", "M507 245L363 101C357 94 347 94 341 101S334 117 341 123L457 240H176C167 240 160 247 160 256S167 272 176 272H457L341 389C334 395 334 405 341 411S357 418 363 411L507 267C510 264 512 260 512 256S510 248 507 245ZM176 448H80C54 448 32 426 32 400V112C32 86 54 64 80 64H176C185 64 192 57 192 48S185 32 176 32H80C36 32 0 68 0 112V400C0 444 36 480 80 480H176C185 480 192 473 192 464S185 448 176 448Z"]
  };
  var faArrowRightFromLine = {
    prefix: 'fal',
    iconName: 'arrow-right-from-line',
    icon: [448, 512, [], "f343", "M443 245L299 101C293 94 283 94 277 101S270 117 277 123L393 240H96C87 240 80 247 80 256S87 272 96 272H393L277 389C270 395 270 405 277 411S293 418 299 411L443 267C446 264 448 260 448 256S446 248 443 245ZM16 64C7 64 0 71 0 80V432C0 441 7 448 16 448S32 441 32 432V80C32 71 25 64 16 64Z"]
  };
  var faArrowRightLong = {
    prefix: 'fal',
    iconName: 'arrow-right-long',
    icon: [512, 512, [], "f178", "M363 101L507 245C510 248 512 252 512 256S510 264 507 267L363 411C357 418 347 418 341 411S334 395 341 389L457 272H16C7 272 0 265 0 256S7 240 16 240H457L341 123C334 117 334 107 341 101S357 94 363 101Z"]
  };
  var faArrowRightToBracket = {
    prefix: 'fal',
    iconName: 'arrow-right-to-bracket',
    icon: [512, 512, [], "f090", "M352 256C352 252 350 248 347 245L203 101C197 94 187 94 181 101S174 117 181 123L297 240H16C7 240 0 247 0 256S7 272 16 272H297L181 389C174 395 174 405 181 411S197 418 203 411L347 267C350 264 352 260 352 256ZM432 32H336C327 32 320 39 320 48S327 64 336 64H432C458 64 480 86 480 112V400C480 426 458 448 432 448H336C327 448 320 455 320 464S327 480 336 480H432C476 480 512 444 512 400V112C512 68 476 32 432 32Z"]
  };
  var faArrowRightToLine = {
    prefix: 'fal',
    iconName: 'arrow-right-to-line',
    icon: [448, 512, [], "f340", "M432 64C423 64 416 71 416 80V432C416 441 423 448 432 448S448 441 448 432V80C448 71 441 64 432 64ZM219 101C213 94 203 94 197 101S190 117 197 123L313 240H16C7 240 0 247 0 256S7 272 16 272H313L197 389C190 395 190 405 197 411S213 418 219 411L363 267C366 264 368 260 368 256S366 248 363 245L219 101Z"]
  };
  var faArrowRotateForward = {
    prefix: 'fal',
    iconName: 'arrow-rotate-forward',
    icon: [512, 512, [], "f01e", "M256 32C335 32 408 74 448 142V48C448 39 455 32 464 32S480 39 480 48V176C480 185 473 192 464 192H336C327 192 320 185 320 176S327 160 336 160H422C387 101 325 64 256 64C150 64 64 150 64 256S150 448 256 448C315 448 371 421 407 374C413 367 423 366 430 371C437 377 438 387 433 394C390 449 325 480 256 480C132 480 32 379 32 256S132 32 256 32Z"]
  };
  var faArrowTurnDown = {
    prefix: 'fal',
    iconName: 'arrow-turn-down',
    icon: [384, 512, [], "f149", "M347 363L203 507C200 510 196 512 192 512S184 510 181 507L37 363C30 357 30 347 37 341S53 334 59 341L176 457V80C176 54 154 32 128 32H16C7 32 0 25 0 16S7 0 16 0H128C172 0 208 36 208 80V457L325 341C331 334 341 334 347 341S354 357 347 363Z"]
  };
  var faArrowTurnUp = {
    prefix: 'fal',
    iconName: 'arrow-turn-up',
    icon: [384, 512, [], "f148", "M347 171C341 178 331 178 325 171L208 55V432C208 476 172 512 128 512H16C7 512 0 505 0 496S7 480 16 480H128C154 480 176 458 176 432V55L59 171C53 178 43 178 37 171S30 155 37 149L181 5C184 2 188 0 192 0C196 0 200 2 203 5L347 149C354 155 354 165 347 171Z"]
  };
  var faArrowUp = {
    prefix: 'fal',
    iconName: 'arrow-up',
    icon: [448, 512, [], "f062", "M443 267C440 270 436 272 432 272S424 270 421 267L240 87V464C240 473 233 480 224 480S208 473 208 464V87L27 267C21 274 11 274 5 267S-2 251 5 245L213 37C219 30 229 30 235 37L443 245C450 251 450 261 443 267Z"]
  };
  var faArrowUp19 = {
    prefix: 'fal',
    iconName: 'arrow-up-1-9',
    icon: [448, 512, [], "f163", "M108 38C105 34 101 32 96 32S87 34 84 38L4 134C-2 141 -1 151 6 156C13 162 23 161 28 154L80 92V464C80 473 87 480 96 480S112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38ZM352 256C308 256 272 292 272 336S308 416 352 416C369 416 384 411 397 402C389 428 365 448 336 448C327 448 320 455 320 464S327 480 336 480C389 480 432 437 432 384V336C432 292 396 256 352 256ZM352 384C326 384 304 362 304 336S326 288 352 288S400 310 400 336S378 384 352 384ZM304 224H400C409 224 416 217 416 208S409 192 400 192H368V48C368 39 361 32 352 32H320C311 32 304 39 304 48S311 64 320 64H336V192H304C295 192 288 199 288 208S295 224 304 224Z"]
  };
  var faArrowUp91 = {
    prefix: 'fal',
    iconName: 'arrow-up-9-1',
    icon: [448, 512, [], "f887", "M108 38C105 34 101 32 96 32S87 34 84 38L4 134C-2 141 -1 151 6 156C13 162 23 161 28 154L80 92V464C80 473 87 480 96 480S112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38ZM352 32C308 32 272 68 272 112S308 192 352 192C369 192 384 187 397 178C389 204 365 224 336 224C327 224 320 231 320 240S327 256 336 256C389 256 432 213 432 160V112C432 68 396 32 352 32ZM352 160C326 160 304 138 304 112S326 64 352 64S400 86 400 112S378 160 352 160ZM400 448H368V304C368 295 361 288 352 288H320C311 288 304 295 304 304S311 320 320 320H336V448H304C295 448 288 455 288 464S295 480 304 480H400C409 480 416 473 416 464S409 448 400 448Z"]
  };
  var faArrowUpAZ = {
    prefix: 'fal',
    iconName: 'arrow-up-a-z',
    icon: [448, 512, [], "f15e", "M108 38C105 34 101 32 96 32S87 34 84 38L4 134C-2 141 -1 151 6 156C13 162 23 161 28 154L80 92V464C80 473 87 480 96 480S112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38ZM446 200L366 40C361 29 343 29 338 40L258 200C254 208 257 218 265 222C273 226 282 223 286 215L298 192H406L418 215C421 221 430 227 439 222C447 218 450 208 446 200ZM314 159L352 83L390 159H314ZM416 448H321L428 314C432 309 433 302 430 297C428 291 422 288 416 288H288C279 288 272 295 272 304S279 320 288 320H383L275 454C272 459 271 465 274 471C276 476 282 480 288 480H416C425 480 432 473 432 464C432 455 425 448 416 448Z"]
  };
  var faArrowUpArrowDown = {
    prefix: 'fal',
    iconName: 'arrow-up-arrow-down',
    icon: [384, 512, [], "e098", "M6 156C13 162 23 161 28 154L80 92V464C80 473 87 480 96 480S112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38C105 34 101 32 96 32S87 34 84 38L4 134C-2 141 -1 151 6 156ZM198 356C191 361 190 371 196 378L276 474C279 478 283 480 288 480S297 478 300 474L380 378C386 371 385 361 378 356C371 350 361 351 356 358L304 420V48C304 39 297 32 288 32S272 39 272 48V420L220 358C215 351 205 350 198 356Z"]
  };
  var faArrowUpBigSmall = {
    prefix: 'fal',
    iconName: 'arrow-up-big-small',
    icon: [512, 512, [], "f88e", "M108 38C105 34 101 32 96 32S87 34 84 38L4 134C-2 141 -1 151 6 156C13 162 23 161 28 154L80 92V464C80 473 87 480 96 480S112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38ZM416 320H288C270 320 256 334 256 352V448C256 466 270 480 288 480H416C434 480 448 466 448 448V352C448 334 434 320 416 320ZM416 448H288V352H416V448ZM480 32H288C270 32 256 46 256 64V224C256 242 270 256 288 256H480C498 256 512 242 512 224V64C512 46 498 32 480 32ZM480 224H288V64H480V224Z"]
  };
  var faArrowUpFromLine = {
    prefix: 'fal',
    iconName: 'arrow-up-from-line',
    icon: [384, 512, [], "f342", "M59 203L176 87V384C176 393 183 400 192 400S208 393 208 384V87L325 203C331 210 341 210 347 203S354 187 347 181L203 37C200 34 196 32 192 32S184 34 181 37L37 181C30 187 30 197 37 203S53 210 59 203ZM368 448H16C7 448 0 455 0 464S7 480 16 480H368C377 480 384 473 384 464S377 448 368 448Z"]
  };
  var faArrowUpFromSquare = {
    prefix: 'fal',
    iconName: 'arrow-up-from-square',
    icon: [448, 512, [], "e099", "M400 160H368C359 160 352 167 352 176S359 192 368 192H400C409 192 416 199 416 208V464C416 473 409 480 400 480H48C39 480 32 473 32 464V208C32 199 39 192 48 192H80C89 192 96 185 96 176S89 160 80 160H48C22 160 0 182 0 208V464C0 490 22 512 48 512H400C426 512 448 490 448 464V208C448 182 426 160 400 160ZM139 123L208 55V336C208 345 215 352 224 352S240 345 240 336V55L309 123C312 126 316 128 320 128S328 126 331 123C338 117 338 107 331 101L235 5C229 -2 219 -2 213 5L117 101C110 107 110 117 117 123S133 130 139 123Z"]
  };
  var faArrowUpLong = {
    prefix: 'fal',
    iconName: 'arrow-up-long',
    icon: [320, 512, [], "f176", "M5 149L149 5C152 2 156 0 160 0S168 2 171 5L315 149C322 155 322 165 315 171S299 178 293 171L176 55V496C176 505 169 512 160 512S144 505 144 496V55L27 171C21 178 11 178 5 171S-2 155 5 149Z"]
  };
  var faArrowUpRightAndArrowDownLeftFromCenter = {
    prefix: 'fal',
    iconName: 'arrow-up-right-and-arrow-down-left-from-center',
    icon: [512, 512, [], "e09a", "M496 0H336C327 0 320 7 320 16S327 32 336 32H457L293 197C286 203 286 213 293 219S309 226 315 219L480 55V176C480 185 487 192 496 192S512 185 512 176V16C512 7 505 0 496 0ZM197 293L32 457V336C32 327 25 320 16 320S0 327 0 336V496C0 505 7 512 16 512H176C185 512 192 505 192 496S185 480 176 480H55L219 315C226 309 226 299 219 293S203 286 197 293Z"]
  };
  var faArrowUpRightFromSquare = {
    prefix: 'fal',
    iconName: 'arrow-up-right-from-square',
    icon: [512, 512, [], "f08e", "M400 288C391 288 384 295 384 304V448C384 466 370 480 352 480H64C46 480 32 466 32 448V160C32 142 46 128 64 128H176C185 128 192 121 192 112S185 96 176 96H64C29 96 0 125 0 160V448C0 483 29 512 64 512H352C387 512 416 483 416 448V304C416 295 409 288 400 288ZM496 0H336C327 0 320 7 320 16S327 32 336 32H457L181 309C174 315 174 325 181 331C184 334 188 336 192 336S200 334 203 331L480 55V176C480 185 487 192 496 192S512 185 512 176V16C512 7 505 0 496 0Z"]
  };
  var faArrowUpShortWide = {
    prefix: 'fal',
    iconName: 'arrow-up-short-wide',
    icon: [512, 512, [], "f885", "M28 154L80 92V464C80 473 87 480 96 480S112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38C105 34 101 32 96 32S87 34 84 38L4 134C-2 141 -1 151 6 156C13 162 23 161 28 154ZM512 448C512 439 505 432 496 432H240C231 432 224 439 224 448S231 464 240 464H496C505 464 512 457 512 448ZM448 320C448 311 441 304 432 304H240C231 304 224 311 224 320S231 336 240 336H432C441 336 448 329 448 320ZM384 192C384 183 377 176 368 176H240C231 176 224 183 224 192S231 208 240 208H368C377 208 384 201 384 192ZM320 64C320 55 313 48 304 48H240C231 48 224 55 224 64S231 80 240 80H304C313 80 320 73 320 64Z"]
  };
  var faArrowUpSmallBig = {
    prefix: 'fal',
    iconName: 'arrow-up-small-big',
    icon: [512, 512, [], "f88f", "M108 38C105 34 101 32 96 32S87 34 84 38L4 134C-2 141 -1 151 6 156C13 162 23 161 28 154L80 92V464C80 473 87 480 96 480S112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38ZM288 192H416C434 192 448 178 448 160V64C448 46 434 32 416 32H288C270 32 256 46 256 64V160C256 178 270 192 288 192ZM288 64H416V160H288V64ZM480 256H288C270 256 256 270 256 288V448C256 466 270 480 288 480H480C498 480 512 466 512 448V288C512 270 498 256 480 256ZM480 448H288V288H480V448Z"]
  };
  var faArrowUpSquareTriangle = {
    prefix: 'fal',
    iconName: 'arrow-up-square-triangle',
    icon: [640, 512, [], "f88b", "M204 38C201 34 197 32 192 32S183 34 180 38L100 134C94 141 95 151 102 156C109 162 119 161 124 154L176 92V464C176 473 183 480 192 480S208 473 208 464V92L260 154C265 161 275 162 282 156C289 151 290 141 284 134L204 38ZM360 224H504C517 224 528 213 528 200V56C528 43 517 32 504 32H360C347 32 336 43 336 56V200C336 213 347 224 360 224ZM368 64H496V192H368V64ZM540 439L457 302C451 293 442 288 432 288S413 293 407 302L324 439C313 457 327 480 349 480H515C537 480 551 457 540 439ZM356 448L432 322L508 448H356Z"]
  };
  var faArrowUpToLine = {
    prefix: 'fal',
    iconName: 'arrow-up-to-line',
    icon: [384, 512, [], "f341", "M203 117C200 114 196 112 192 112S184 114 181 117L37 261C30 267 30 277 37 283S53 290 59 283L176 167V464C176 473 183 480 192 480S208 473 208 464V167L325 283C331 290 341 290 347 283S354 267 347 261L203 117ZM368 32H16C7 32 0 39 0 48S7 64 16 64H368C377 64 384 57 384 48S377 32 368 32Z"]
  };
  var faArrowUpTriangleSquare = {
    prefix: 'fal',
    iconName: 'arrow-up-triangle-square',
    icon: [640, 512, [], "f88a", "M204 38C201 34 197 32 192 32S183 34 180 38L100 134C94 141 95 151 102 156C109 162 119 161 124 154L176 92V464C176 473 183 480 192 480S208 473 208 464V92L260 154C265 161 275 162 282 156C289 151 290 141 284 134L204 38ZM504 288H360C347 288 336 299 336 312V456C336 469 347 480 360 480H504C517 480 528 469 528 456V312C528 299 517 288 504 288ZM496 448H368V320H496V448ZM540 183L457 46C451 37 442 32 432 32S413 37 407 46L324 183C313 201 327 224 349 224H515C537 224 551 201 540 183ZM356 192L432 66L508 192H356Z"]
  };
  var faArrowUpWideShort = {
    prefix: 'fal',
    iconName: 'arrow-up-wide-short',
    icon: [512, 512, [], "f161", "M28 154L80 92V464C80 473 87 480 96 480S112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38C105 34 101 32 96 32S87 34 84 38L4 134C-2 141 -1 151 6 156C13 162 23 161 28 154ZM496 48H240C231 48 224 55 224 64S231 80 240 80H496C505 80 512 73 512 64S505 48 496 48ZM432 176H240C231 176 224 183 224 192S231 208 240 208H432C441 208 448 201 448 192S441 176 432 176ZM368 304H240C231 304 224 311 224 320S231 336 240 336H368C377 336 384 329 384 320S377 304 368 304ZM304 432H240C231 432 224 439 224 448S231 464 240 464H304C313 464 320 457 320 448S313 432 304 432Z"]
  };
  var faArrowUpZA = {
    prefix: 'fal',
    iconName: 'arrow-up-z-a',
    icon: [448, 512, [], "f882", "M108 38C105 34 101 32 96 32C91 32 87 34 84 38L4 134C-2 141 -1 151 6 156C13 162 23 161 28 154L80 92V464C80 473 87 480 96 480C105 480 112 473 112 464V92L164 154C169 161 179 162 186 156C193 151 194 141 188 134L108 38ZM288 64H383L275 198C272 203 271 209 274 215C276 220 282 224 288 224H416C425 224 432 217 432 208S425 192 416 192H321L429 58C432 53 433 47 430 41C428 36 422 32 416 32H288C279 32 272 39 272 48C272 57 279 64 288 64ZM446 457L366 297C361 286 343 286 338 297L258 457C254 465 257 474 265 478C273 482 282 479 286 471L298 448H406L418 471C421 477 430 483 439 478C447 474 450 465 446 457ZM314 416L352 340L390 416H314Z"]
  };
  var faArrowsLeftRight = {
    prefix: 'fal',
    iconName: 'arrows-left-right',
    icon: [512, 512, [], "f07e", "M507 267L395 379C392 382 388 384 384 384S376 382 373 379C366 373 366 363 373 357L457 272H55L139 357C146 363 146 373 139 379C136 382 132 384 128 384S120 382 117 379L5 267C-2 261 -2 251 5 245L117 133C123 126 133 126 139 133S146 149 139 155L55 240H457L373 155C366 149 366 139 373 133S389 126 395 133L507 245C514 251 514 261 507 267Z"]
  };
  var faArrowsMaximize = {
    prefix: 'fal',
    iconName: 'arrows-maximize',
    icon: [448, 512, [], "f31d", "M416 176V87L247 256L416 425V336C416 327 423 320 432 320S448 327 448 336V464C448 473 441 480 432 480H304C295 480 288 473 288 464S295 448 304 448H393L224 279L55 448H144C153 448 160 455 160 464S153 480 144 480H16C7 480 0 473 0 464V336C0 327 7 320 16 320S32 327 32 336V425L201 256L32 87V176C32 185 25 192 16 192S0 185 0 176V48C0 39 7 32 16 32H144C153 32 160 39 160 48S153 64 144 64H55L224 233L393 64H304C295 64 288 57 288 48S295 32 304 32H432C441 32 448 39 448 48V176C448 185 441 192 432 192S416 185 416 176Z"]
  };
  var faArrowsMinimize = {
    prefix: 'fal',
    iconName: 'arrows-minimize',
    icon: [512, 512, [], "e09b", "M208 288H48C39 288 32 295 32 304S39 320 48 320H169L21 469C14 475 14 485 21 491S37 497 43 491L192 343V464C192 473 199 480 208 480S224 473 224 464V304C224 295 217 288 208 288ZM304 224H464C473 224 480 217 480 208S473 192 464 192H343L491 43C498 37 498 27 491 21S475 14 469 21L320 169V48C320 39 313 32 304 32S288 39 288 48V208C288 217 295 224 304 224ZM343 320H464C473 320 480 313 480 304S473 288 464 288H304C295 288 288 295 288 304V464C288 473 295 480 304 480S320 473 320 464V343L469 491C475 497 485 497 491 491S498 475 491 469L343 320ZM208 32C199 32 192 39 192 48V169L43 21C37 14 27 14 21 21S14 37 21 43L169 192H48C39 192 32 199 32 208S39 224 48 224H208C217 224 224 217 224 208V48C224 39 217 32 208 32Z"]
  };
  var faArrowsRepeat = {
    prefix: 'fal',
    iconName: 'arrows-repeat',
    icon: [512, 512, [], "f364", "M176 112H388L326 164C319 169 318 179 324 186C327 190 331 192 336 192C340 192 343 191 346 188L442 108C446 105 448 101 448 96S446 87 442 84L346 4C339 -2 329 -1 324 6C318 13 319 23 326 28L388 80H176C79 80 0 159 0 256C0 265 7 272 16 272S32 265 32 256C32 177 97 112 176 112ZM496 240C487 240 480 247 480 256C480 335 415 400 336 400H124L186 348C193 343 194 333 188 326C183 319 173 318 166 324L70 404C66 407 64 411 64 416S66 425 70 428L166 508C169 511 172 512 176 512C181 512 185 510 188 506C194 499 193 489 186 484L124 432H336C433 432 512 353 512 256C512 247 505 240 496 240Z"]
  };
  var faArrowsRepeat1 = {
    prefix: 'fal',
    iconName: 'arrows-repeat-1',
    icon: [512, 512, [], "f366", "M176 112H388L326 164C319 169 318 179 324 186C327 190 331 192 336 192C340 192 343 191 346 188L442 108C446 105 448 101 448 96S446 87 442 84L346 4C339 -2 329 -1 324 6C318 13 319 23 326 28L388 80H176C79 80 0 159 0 256C0 265 7 272 16 272S32 265 32 256C32 177 97 112 176 112ZM272 320C281 320 288 313 288 304V208C288 199 281 192 272 192H240C231 192 224 199 224 208S231 224 240 224H256V304C256 313 263 320 272 320ZM496 240C487 240 480 247 480 256C480 335 415 400 336 400H124L186 348C193 343 194 333 188 326C183 319 173 318 166 324L70 404C66 407 64 411 64 416S66 425 70 428L166 508C169 511 172 512 176 512C181 512 185 510 188 506C194 499 193 489 186 484L124 432H336C433 432 512 353 512 256C512 247 505 240 496 240Z"]
  };
  var faArrowsRetweet = {
    prefix: 'fal',
    iconName: 'arrows-retweet',
    icon: [640, 512, [], "f361", "M336 368H144V119L229 203C232 206 236 208 240 208S248 206 251 203C258 197 258 187 251 181L139 69C133 62 123 62 117 69L5 181C-2 187 -2 197 5 203S21 210 27 203L112 119V384C112 393 119 400 128 400H336C345 400 352 393 352 384S345 368 336 368ZM635 309C629 302 619 302 613 309L528 393V128C528 119 521 112 512 112H304C295 112 288 119 288 128S295 144 304 144H496V393L411 309C405 302 395 302 389 309S382 325 389 331L501 443C504 446 508 448 512 448S520 446 523 443L635 331C642 325 642 315 635 309Z"]
  };
  var faArrowsRotate = {
    prefix: 'fal',
    iconName: 'arrows-rotate',
    icon: [512, 512, [], "f021", "M464 32C455 32 448 39 448 48V177C416 100 341 48 256 48C154 48 68 121 51 221C49 230 55 238 64 240C65 240 66 240 67 240C74 240 81 234 82 227C97 142 170 80 256 80C328 80 393 125 420 192H304C295 192 288 199 288 208S295 224 304 224H464C473 224 480 217 480 208V48C480 39 473 32 464 32ZM448 272C439 271 431 277 430 285C415 370 342 432 256 432C184 432 119 387 92 320H208C217 320 224 313 224 304S217 288 208 288H48C39 288 32 295 32 304V464C32 473 39 480 48 480S64 473 64 464V335C96 412 171 464 256 464C358 464 444 391 461 291C463 282 457 274 448 272Z"]
  };
  var faArrowsUpDown = {
    prefix: 'fal',
    iconName: 'arrows-up-down',
    icon: [320, 512, [], "f07d", "M171 5L283 117C286 120 288 124 288 128S286 136 283 139C277 146 267 146 261 139L176 55V457L261 373C267 366 277 366 283 373C286 376 288 380 288 384S286 392 283 395L171 507C165 514 155 514 149 507L37 395C30 389 30 379 37 373S53 366 59 373L144 457V55L59 139C53 146 43 146 37 139S30 123 37 117L149 5C155 -2 165 -2 171 5Z"]
  };
  var faArrowsUpDownLeftRight = {
    prefix: 'fal',
    iconName: 'arrows-up-down-left-right',
    icon: [512, 512, [], "f047", "M512 256C512 260 510 264 507 267L427 347C421 354 411 354 405 347S398 331 405 325L457 272H272V457L325 405C331 398 341 398 347 405S354 421 347 427L267 507C264 510 260 512 256 512S248 510 245 507L165 427C158 421 158 411 165 405S181 398 187 405L240 457V272H55L107 325C114 331 114 341 107 347S91 354 85 347L5 267C2 264 0 260 0 256S2 248 5 245L85 165C91 158 101 158 107 165S114 181 107 187L55 240H240V55L187 107C181 114 171 114 165 107S158 91 165 85L245 5C248 2 252 0 256 0S264 2 267 5L347 85C354 91 354 101 347 107S331 114 325 107L272 55V240H457L405 187C398 181 398 171 405 165S421 158 427 165L507 245C510 248 512 252 512 256Z"]
  };
  var faAsterisk = {
    prefix: 'fal',
    iconName: 'asterisk',
    icon: [448, 512, [], "f069", "M414 368C411 373 405 376 400 376C397 376 394 375 392 374L240 284V464C240 473 233 480 224 480S208 473 208 464V284L56 374C54 375 51 376 48 376C43 376 37 373 34 368C30 360 32 351 40 346L193 256L40 166C32 161 30 151 34 144C39 136 49 134 56 138L208 228V48C208 39 215 32 224 32S240 39 240 48V228L392 138C400 134 409 136 414 144C418 151 416 161 408 166L255 256L408 346C416 351 418 361 414 368Z"]
  };
  var faAt = {
    prefix: 'fal',
    iconName: 'at',
    icon: [512, 512, [], "f1fa", "M260 16C117 14 3 141 17 283C29 401 119 488 239 496C248 497 256 489 256 480C256 471 249 465 241 464C135 457 55 378 48 271C41 152 131 51 251 48C370 45 464 138 464 256V279C464 305 446 329 421 335C384 343 352 315 352 280V160C352 151 345 144 336 144C327 144 320 151 320 160V178C295 152 258 139 218 146C174 155 138 191 130 236C117 306 171 368 240 368C277 368 310 350 331 321C347 352 381 373 419 368C464 362 496 322 496 277V256C496 123 393 18 260 16ZM240 336C196 336 160 300 160 256S196 176 240 176S320 212 320 256S284 336 240 336Z"]
  };
  var faAtom = {
    prefix: 'fal',
    iconName: 'atom',
    icon: [512, 512, [], "f5d2", "M445 256C460 236 472 215 477 196C483 173 481 153 471 136C452 105 410 93 357 97C334 38 298 0 256 0S178 38 155 97C102 93 60 105 42 136C31 153 29 173 35 196C41 215 52 236 67 256C52 276 41 297 35 316C29 339 31 359 41 376C57 403 91 416 135 416C141 416 148 414 155 414C178 474 214 512 256 512S334 474 357 414C364 415 371 416 378 416C421 416 455 403 471 376C481 359 483 339 477 316C472 297 460 276 445 256ZM69 360C63 350 63 338 66 324C70 310 78 296 89 281C102 295 117 308 132 319C135 341 139 362 145 383C107 385 79 377 69 360ZM128 275C122 269 115 262 109 256C115 250 122 243 128 237C128 243 128 250 128 256S128 269 128 275ZM132 193C117 204 102 217 89 231C78 216 70 201 66 188C63 174 63 162 69 152C78 137 102 128 134 128C137 128 141 129 145 129C139 150 135 171 132 193ZM344 167C335 162 327 157 318 152C312 148 305 145 299 141C311 138 323 135 335 133C338 142 342 157 344 167ZM256 32C280 32 306 58 324 102C301 107 278 114 256 122C234 114 211 107 188 102C207 58 232 32 256 32ZM177 133C189 135 201 138 213 141C207 145 201 148 194 151C185 157 177 162 168 167C170 157 174 142 177 133ZM168 345C177 350 185 355 194 360C201 364 208 367 214 370C202 374 190 377 177 379C173 368 171 357 168 345ZM256 480C232 480 206 454 188 410C211 405 234 398 256 389C278 398 301 405 324 410C306 454 280 480 256 480ZM335 379C323 377 310 374 298 370C305 367 311 364 318 360C327 355 335 350 344 345C341 357 338 369 335 379ZM350 302C335 313 319 323 302 333C287 341 272 349 256 355C240 349 225 341 210 333C193 323 177 313 162 302C161 287 160 272 160 256S161 225 162 210C177 199 193 189 210 180C225 171 240 163 256 157C272 163 287 171 302 179C319 189 335 199 350 210C351 225 352 240 352 256S351 287 350 302ZM378 128C410 128 434 137 443 152C449 162 449 174 446 188C442 201 434 216 423 231C410 217 395 204 380 193C377 171 373 150 367 129C371 129 375 128 378 128ZM384 237C390 243 397 250 403 256C397 262 390 269 384 275C384 269 384 262 384 256S384 243 384 237ZM443 360C433 377 405 385 368 383C373 362 378 341 380 319C395 308 410 295 423 281C434 296 442 310 446 324C450 338 449 350 443 360ZM256 232C243 232 232 243 232 256S243 280 256 280S280 269 280 256S269 232 256 232Z"]
  };
  var faAtomSimple = {
    prefix: 'fal',
    iconName: 'atom-simple',
    icon: [448, 512, [], "f5d3", "M427 54C400 27 354 25 296 48C272 57 248 71 224 87C200 71 176 57 153 48C94 25 48 27 21 54C-17 92 -2 171 54 256C-2 341 -17 420 21 458C36 473 56 480 80 480C101 480 126 475 153 464C176 455 200 441 224 425C248 441 272 455 295 464C322 475 347 480 368 480C392 480 412 473 427 458C465 420 450 340 394 256C450 171 465 92 427 54ZM307 78C352 60 387 59 404 76C427 99 417 158 374 228C357 205 338 183 317 163C297 143 275 124 252 107C271 95 290 85 307 78ZM44 76C52 68 64 64 80 64C97 64 118 69 141 78C159 85 177 95 196 107C150 141 109 182 74 228C31 158 21 99 44 76ZM141 434C96 452 61 453 44 436C21 413 31 354 74 284C91 307 110 329 131 349C151 369 173 388 196 405C177 417 158 427 141 434ZM153 327C131 305 111 281 93 256C111 231 131 207 153 185C175 163 199 143 224 125C249 143 273 163 295 185C317 207 337 231 355 256C337 281 317 305 295 327C273 349 249 369 224 387C199 369 175 349 153 327ZM404 436C387 453 352 452 307 434C290 427 271 417 252 405C275 388 297 369 317 349C338 329 357 307 374 284C417 354 427 413 404 436ZM224 232C211 232 200 243 200 256C200 269 211 280 224 280C230 280 237 278 241 273S248 262 248 256C248 243 237 232 224 232Z"]
  };
  var faAustralSign = {
    prefix: 'fal',
    iconName: 'austral-sign',
    icon: [448, 512, [], "e09c", "M432 320H356L329 256H432C441 256 448 249 448 240S441 224 432 224H316L239 42C234 30 214 30 209 42L132 224H16C7 224 0 231 0 240S7 256 16 256H119L92 320H16C7 320 0 327 0 336S7 352 16 352H78L33 458C30 466 34 475 42 479C50 482 59 478 63 470L113 352H335L385 470C388 476 394 480 400 480C402 480 404 480 406 479C414 475 418 466 415 458L370 352H432C441 352 448 345 448 336S441 320 432 320ZM224 89L281 224H167L224 89ZM126 320L153 256H295L322 320H126Z"]
  };
  var faAward = {
    prefix: 'fal',
    iconName: 'award',
    icon: [384, 512, [], "f559", "M288 358C302 350 306 328 317 317C328 306 350 302 358 288C366 274 358 254 363 238C367 223 384 209 384 192C384 175 367 161 363 146C358 131 366 110 358 96C350 82 328 78 317 67C306 56 302 34 288 26C274 18 253 26 238 21C223 17 209 0 192 0C175 0 161 17 146 21C130 26 110 18 96 26C82 34 78 56 67 67C56 78 34 82 26 96C18 110 26 130 21 146C17 161 0 175 0 192C0 209 17 223 21 238C26 253 18 274 26 288C34 302 56 306 67 317C78 328 82 350 96 358C110 366 131 358 146 363C161 367 175 384 192 384C209 384 223 367 238 363C253 358 274 366 288 358ZM192 352C184 348 171 336 155 332C138 327 122 330 112 330C107 322 102 306 90 294C78 282 62 277 54 272C54 262 57 246 52 229C48 213 36 200 32 192C36 184 48 171 52 154C57 138 54 122 54 112C62 107 78 102 90 90C102 78 107 62 112 54C121 54 138 57 154 52C171 48 184 37 192 32C200 36 213 48 230 52C246 57 262 54 272 54C277 62 282 78 294 90C306 102 322 107 330 112C330 122 327 138 332 155C336 171 348 184 352 192C348 200 336 213 332 230C327 246 330 262 330 272C322 277 306 282 294 294C282 306 277 322 272 330C263 330 246 327 230 332C213 336 200 348 192 352ZM280 192C280 143 241 104 192 104S104 143 104 192C104 241 143 280 192 280S280 241 280 192ZM192 248C161 248 136 223 136 192C136 161 161 136 192 136S248 161 248 192C248 223 223 248 192 248ZM357 370C354 362 345 358 337 361C328 364 324 374 328 382L352 443L304 437L280 479L255 418C251 409 242 406 234 409C226 412 222 422 225 430L250 491C255 503 267 511 281 512C294 512 306 505 312 493L322 473L343 477C356 480 368 475 376 466C384 456 386 443 382 431L357 370ZM150 409C142 406 132 409 129 418L104 479L80 437L32 443L32 443L56 382C60 374 56 364 47 361C39 358 30 362 27 370L2 431C-2 443 0 456 8 466C16 475 28 480 40 477L62 473L72 493C78 505 90 512 104 512H104C117 511 129 503 134 491L159 430C162 422 158 412 150 409Z"]
  };
  var faAxe = {
    prefix: 'fal',
    iconName: 'axe',
    icon: [640, 512, [], "f6b2", "M57 480L23 446L246 223L223 200L0 423C-13 436 -13 456 0 469L34 503C40 509 48 512 57 512C65 512 73 509 79 503L302 280L280 257L57 480ZM516 160L469 113L493 89C506 76 506 56 493 43L459 9C453 3 445 0 437 0C428 0 420 3 414 9L390 34L366 9C359 3 351 0 343 0C335 0 327 3 321 9L224 106C211 118 211 139 224 151L375 302V416H407C530 416 631 316 631 192V160H516ZM437 32L471 66L446 90L413 56L437 32ZM407 384V289L247 129L343 32L503 192H599C599 298 513 384 407 384Z"]
  };
  var faAxeBattle = {
    prefix: 'fal',
    iconName: 'axe-battle',
    icon: [512, 512, [], "f6b3", "M101 14C99 5 92 0 85 0C81 0 77 2 74 5C29 51 0 118 0 192S29 333 74 379C77 382 81 384 85 384C92 384 99 379 101 370C114 315 156 273 208 266V233C117 246 86 318 79 335C49 296 32 245 32 192S49 88 79 49C86 66 117 138 208 151V118C156 111 114 69 101 14ZM512 161C505 99 477 44 438 5C435 2 431 0 427 0C420 0 413 5 411 14C398 69 356 111 304 118V151C395 138 426 66 433 49C455 77 470 112 476 150L457 170L435 192L457 214L476 234C470 272 455 307 433 336C426 318 395 246 304 233V266C356 273 398 315 411 370C413 379 420 384 427 384C431 384 435 382 438 379C477 340 505 285 512 223L480 192L512 161ZM256 32C247 32 240 39 240 48V496C240 505 247 512 256 512S272 505 272 496V48C272 39 265 32 256 32Z"]
  };
  var faB = {
    prefix: 'fal',
    iconName: 'b',
    icon: [320, 512, [], "e09d", "M242 234C270 214 288 181 288 144C288 82 238 32 176 32H16C7 32 0 39 0 48V464C0 473 7 480 16 480H192C263 480 320 423 320 352C320 299 288 254 242 234ZM32 64H176C220 64 256 100 256 144S220 224 176 224H32V64ZM192 448H32V256H192C245 256 288 299 288 352S245 448 192 448Z"]
  };
  var faBaby = {
    prefix: 'fal',
    iconName: 'baby',
    icon: [384, 512, [], "f77c", "M374 160C357 135 322 128 296 146L260 171C227 193 173 204 124 171L88 146C62 128 27 135 10 160C-8 186 -1 221 24 238L61 263C72 271 83 277 96 283V305L42 362C23 379 18 408 32 431L70 487C80 502 98 512 117 512C127 512 136 509 145 504C158 497 197 464 147 408L165 396C183 402 206 401 219 396L237 408C187 464 226 496 239 504C248 509 257 512 267 512C286 512 304 502 314 487L352 431C366 408 361 380 342 362L288 306V283C301 277 312 271 323 263L360 238C385 221 392 186 374 160ZM137 444C144 455 140 470 129 477C118 483 103 480 96 468L59 415C53 405 56 391 65 384L104 343C104 344 131 371 140 381L111 408L137 444ZM220 359C207 372 177 371 164 359L128 323V304H256V323L220 359ZM319 384C328 391 331 405 325 415L288 468C281 480 266 483 255 477C244 470 240 455 247 444L273 408L244 381C253 371 280 344 280 343L319 384ZM342 212L305 237C293 245 279 252 266 258C260 260 256 266 256 272H128C128 266 124 260 118 258C105 252 91 245 79 237L42 212C16 194 44 154 70 172L106 197C108 198 190 258 278 197L314 172C340 154 368 194 342 212ZM192 160C236 160 272 124 272 80C272 36 236 0 192 0C148 0 112 36 112 80C112 124 148 160 192 160ZM192 32C218 32 240 54 240 80C240 106 218 128 192 128C166 128 144 106 144 80C144 54 166 32 192 32Z"]
  };
  var faBabyCarriage = {
    prefix: 'fal',
    iconName: 'baby-carriage',
    icon: [512, 512, [], "f77d", "M496 96H464C438 96 416 118 416 144V192H281L174 25C166 12 153 3 138 1C123 -2 108 2 97 11C35 60 0 132 0 208V224C0 291 40 350 101 385C99 384 98 384 96 384C56 384 24 421 34 463C39 486 58 505 81 510C123 520 160 488 160 448C160 430 152 414 140 402C166 411 194 416 224 416S282 411 308 402C292 417 284 440 290 464C296 487 314 505 336 510C378 520 416 488 416 448C416 413 387 384 352 384C350 384 349 384 347 385C408 350 448 291 448 224V144C448 135 455 128 464 128H496C505 128 512 121 512 112C512 103 505 96 496 96ZM117 36C123 31 129 32 133 32C139 33 144 37 147 42L243 192H33C37 132 67 76 117 36ZM96 480C78 480 64 466 64 448S78 416 96 416S128 430 128 448S114 480 96 480ZM352 416C370 416 384 430 384 448S370 480 352 480S320 466 320 448S334 416 352 416ZM224 384C118 384 32 312 32 224H416C416 312 330 384 224 384Z"]
  };
  var faBackpack = {
    prefix: 'fal',
    iconName: 'backpack',
    icon: [448, 512, [], "f5d4", "M320 64H304V48C304 22 282 0 256 0H192C166 0 144 22 144 48V64H128C57 64 0 121 0 192V448C0 483 29 512 64 512H384C419 512 448 483 448 448V192C448 121 391 64 320 64ZM176 48C176 39 183 32 192 32H256C265 32 272 39 272 48V64H176V48ZM336 480H112V384H336V480ZM336 352H112V320C112 302 126 288 144 288H304C322 288 336 302 336 320V352ZM416 448C416 466 402 480 384 480H368V320C368 285 339 256 304 256H144C109 256 80 285 80 320V480H64C46 480 32 466 32 448V192C32 139 75 96 128 96H320C373 96 416 139 416 192V448ZM304 160H144C135 160 128 167 128 176V176C128 185 135 192 144 192H304C313 192 320 185 320 176V176C320 167 313 160 304 160Z"]
  };
  var faBackward = {
    prefix: 'fal',
    iconName: 'backward',
    icon: [512, 512, [], "f04a", "M481 64C475 64 468 66 462 71L310 196C303 202 302 212 308 219C313 226 323 227 330 221L480 96V416L330 291C323 285 313 286 308 293C302 300 303 310 310 316L462 441C468 446 475 448 481 448C498 448 512 435 512 416V96C512 77 498 64 481 64ZM225 64C219 64 212 66 206 71L12 231C4 237 0 246 0 256S4 275 12 281L206 441C212 446 219 448 225 448C236 448 256 440 256 416V96C256 72 236 64 225 64ZM224 416L33 256L224 96V416Z"]
  };
  var faBackwardFast = {
    prefix: 'fal',
    iconName: 'backward-fast',
    icon: [512, 512, [], "f049", "M225 64C219 64 212 66 206 71L32 214V80C32 71 25 64 16 64S0 71 0 80V432C0 441 7 448 16 448S32 441 32 432V298L206 441C212 446 219 448 225 448C236 448 256 440 256 416V96C256 72 236 64 225 64ZM224 416L33 256L224 96V416ZM481 64C475 64 468 66 462 71L310 196C303 202 302 212 308 219C313 226 323 227 330 221L480 96V416L330 291C323 285 313 286 308 293C302 300 303 310 310 316L462 441C468 446 475 448 481 448C498 448 512 435 512 416V96C512 77 498 64 481 64Z"]
  };
  var faBackwardStep = {
    prefix: 'fal',
    iconName: 'backward-step',
    icon: [320, 512, [], "f048", "M257 64C251 64 244 66 238 71L64 214V80C64 71 57 64 48 64S32 71 32 80V432C32 441 39 448 48 448S64 441 64 432V298L238 441C244 446 251 448 257 448C268 448 288 440 288 416V96C288 72 268 64 257 64ZM256 416L65 256L256 96V416Z"]
  };
  var faBacon = {
    prefix: 'fal',
    iconName: 'bacon',
    icon: [576, 512, [], "f7e5", "M565 100L487 13C479 4 469 0 459 0C453 0 448 1 443 3L351 46C299 70 257 110 228 163L208 201C181 250 141 288 93 310L24 342C12 348 4 359 1 373C-2 387 2 402 11 412L89 499C97 508 107 512 117 512C123 512 128 511 133 509L226 466C277 442 319 402 348 349L368 311C395 262 435 224 483 202L552 170C564 164 572 153 575 139C578 125 574 110 565 100ZM35 391C30 385 32 374 38 371L106 340C161 314 205 272 236 216L256 178C282 132 319 96 364 75L457 32C457 32 460 31 463 34L494 68L408 108C356 132 312 174 283 228L262 265C236 313 197 350 151 372L57 415L35 391ZM538 141L470 172C415 198 371 240 340 296L320 334C294 380 257 416 212 437L119 480C117 481 114 479 113 478L79 440L164 401C217 376 260 335 290 281L311 243C337 195 375 158 422 137L516 93L541 121C546 127 544 138 538 141Z"]
  };
  var faBacteria = {
    prefix: 'fal',
    iconName: 'bacteria',
    icon: [640, 512, [], "e059", "M208 128C199 128 192 135 192 144C192 153 199 160 208 160S224 153 224 144C224 135 217 128 208 128ZM128 200C115 200 104 211 104 224S115 248 128 248C141 248 152 237 152 224S141 200 128 200ZM616 231L627 227C637 225 642 215 639 205C636 195 626 191 617 193L606 197C598 182 585 169 569 161L572 150C575 141 569 131 560 129C549 126 540 133 538 141L535 152C534 152 533 152 532 152C515 152 500 157 486 166L478 157C474 153 462 147 452 157C445 163 445 175 452 182L461 191C455 200 451 211 449 222C448 228 447 233 445 238L436 233C427 229 417 233 413 242C408 251 412 261 421 266L430 270C415 292 395 303 395 304L391 295C387 286 377 282 368 286C359 290 355 300 359 309L363 318C358 319 354 320 350 321C338 323 326 328 316 335L306 326C299 320 288 320 281 327C275 335 275 346 283 352L292 361C284 375 280 392 281 409L269 413C259 416 254 425 257 435C260 444 269 450 279 447L290 443C298 459 311 471 327 479L324 490C321 499 327 509 336 511C346 514 356 508 358 499L361 488C367 488 372 488 378 487C389 485 400 482 411 479L414 488C418 497 428 502 437 499C446 496 451 485 448 476L444 466C460 460 474 452 488 443L495 451C500 459 512 461 520 455C527 449 529 438 523 430L517 421C529 411 541 399 552 386L560 392C568 398 580 397 585 389C591 381 589 370 581 364L573 357C581 343 589 329 596 313L606 317C615 320 625 315 629 306C632 297 627 287 618 284L607 280C610 270 613 260 615 250C616 243 616 237 616 231ZM583 245C565 353 481 437 373 455C370 456 367 456 364 456C339 456 317 437 313 413C310 399 314 385 322 374S342 355 355 353C420 342 470 292 481 227C485 202 506 184 532 184C558 184 571 202 574 206C582 217 586 231 583 245ZM416 360C403 360 392 371 392 384C392 397 403 408 416 408C429 408 440 397 440 384C440 371 429 360 416 360ZM272 226C281 222 285 212 281 203L277 194C282 193 286 192 290 191C302 189 314 184 324 177L334 186C341 192 352 192 359 185C365 177 365 166 357 160L348 151C356 137 360 120 359 103L371 99C381 96 386 87 383 77C380 68 371 62 361 65L350 69C341 53 329 41 313 33L316 22C319 13 313 3 303 1C294 -2 284 4 282 13L279 24C273 24 268 24 262 25C251 27 240 30 229 33L226 24C222 15 212 10 203 13C194 16 189 27 192 36L196 46C180 52 166 60 152 69L145 61C139 53 128 51 120 57C113 63 111 74 117 82L123 91C111 101 99 113 88 126L79 120C72 114 60 115 55 123C49 131 51 142 58 148L67 155C58 168 51 183 44 198L34 195C25 192 14 197 11 206C8 215 13 225 22 228L33 232C30 242 27 252 25 262C24 269 24 275 24 281L13 285C3 287 -2 297 1 307C4 317 14 321 23 319L34 315C42 330 55 343 71 351L68 362C66 369 70 384 85 384C93 384 100 379 102 371L105 360C106 360 107 360 108 360C125 360 140 355 154 346L162 355C166 359 178 365 188 355C195 348 195 337 188 330L179 321C185 312 189 301 191 290C192 284 193 279 195 274L204 278C213 283 223 279 227 270C232 261 228 251 219 246L210 242C225 220 245 209 245 208L249 217C253 226 263 230 272 226ZM159 285C155 310 134 328 108 328C105 328 102 328 99 327C86 325 74 318 66 306S54 281 57 267C75 159 159 75 268 57C310 49 326 90 327 99C330 113 326 127 318 138S298 157 285 159C220 170 170 220 159 285Z"]
  };
  var faBacterium = {
    prefix: 'fal',
    iconName: 'bacterium',
    icon: [576, 512, [], "e05a", "M543 100C541 93 532 87 523 89L500 96C482 56 446 42 445 42L451 20C453 10 445 0 435 0C428 0 421 5 419 12L414 33C410 33 405 32 398 32C393 32 388 32 381 34C364 36 348 40 332 45L326 27C323 19 314 15 305 18C297 21 292 30 295 38L302 56C275 66 251 80 228 95L217 80C211 73 201 72 194 77C186 82 185 93 190 100L202 115C180 132 160 152 143 174L128 163C120 158 110 159 105 166C99 174 101 184 108 189L124 200C109 223 96 248 86 274L67 268C55 264 48 273 46 278C43 286 48 295 56 298L75 305C71 319 67 334 65 350C63 362 63 373 65 385L43 391C34 394 29 403 32 412C34 421 44 425 52 422L74 416C85 440 105 459 130 470L124 492C121 502 129 512 140 512C147 512 154 507 156 500L161 479C166 479 171 480 175 480C198 480 220 473 238 460L252 474C256 478 267 483 276 475C282 469 282 458 276 452L262 438C274 424 283 406 286 386C287 378 290 369 292 361L307 368C315 371 325 368 329 360C333 352 329 342 321 338L306 332C321 307 342 286 367 273L373 288C377 295 387 299 395 296C403 292 407 283 403 274L397 260C404 258 411 256 418 254C439 251 458 241 473 228L488 242C495 248 506 247 511 240C517 234 517 224 510 218L494 203C508 181 515 155 510 127L532 120C541 118 546 109 543 100ZM413 223C332 236 268 301 254 381C246 430 193 463 143 441C125 433 111 419 103 402C70 333 164 102 386 65C397 63 449 61 471 109C505 183 435 219 413 223ZM191 272C165 272 143 294 143 320S165 368 191 368S239 346 239 320S218 272 191 272ZM191 336C182 336 175 329 175 320S182 304 191 304S207 311 207 320S200 336 191 336ZM271 184C258 184 247 195 247 208S258 232 271 232C285 232 295 221 295 208S285 184 271 184Z"]
  };
  var faBadge = {
    prefix: 'fal',
    iconName: 'badge',
    icon: [512, 512, [], "f335", "M256 512C221 512 188 493 170 462C138 471 102 463 75 437C50 412 41 375 50 342C19 324 0 291 0 256S19 188 50 170C41 137 50 100 75 75S137 41 170 50C188 19 221 0 256 0S324 19 342 50C375 41 412 50 437 75S471 137 462 170C493 188 512 221 512 256S493 324 462 342C471 375 462 412 437 437C411 463 374 471 342 462C324 493 291 512 256 512ZM188 421C191 430 204 480 256 480C307 480 320 433 324 421C357 436 386 443 414 414C450 378 426 336 421 324C430 321 480 308 480 256C480 205 433 192 421 188C425 178 451 134 414 98C378 62 336 86 324 91C321 82 308 32 256 32C205 32 192 79 188 91C178 87 134 61 98 98C62 134 86 176 91 188C82 191 32 204 32 256C32 307 79 320 91 324C87 334 61 378 98 414C126 443 155 436 188 421Z"]
  };
  var faBadgeCheck = {
    prefix: 'fal',
    iconName: 'badge-check',
    icon: [576, 512, [], "f336", "M544 256C544 221 525 188 494 170C503 137 494 100 469 75S407 41 374 50C356 19 323 0 288 0S220 19 202 50C169 41 132 50 107 75S73 137 82 170C51 188 32 221 32 256S51 324 82 342C73 375 82 412 107 437C134 463 170 471 202 462C220 493 253 512 288 512S356 493 374 462C406 471 443 463 469 437C494 412 503 375 494 342C525 324 544 291 544 256ZM453 324C458 336 482 378 446 414C418 443 389 436 356 421C352 433 339 480 288 480C236 480 223 430 220 421C187 436 158 443 130 414C93 378 119 334 123 324C111 320 64 307 64 256C64 204 114 191 123 188C118 176 94 134 130 98C166 61 210 87 220 91C224 79 237 32 288 32C340 32 353 82 356 91C368 86 410 62 446 98C483 134 457 178 453 188C465 192 512 205 512 256C512 308 462 321 453 324ZM357 191L261 287L219 245C213 238 203 238 197 245S190 261 197 267L250 321C253 324 257 325 261 325S270 324 273 321L379 214C386 208 386 198 379 191S363 185 357 191Z"]
  };
  var faBadgeDollar = {
    prefix: 'fal',
    iconName: 'badge-dollar',
    icon: [576, 512, [], "f645", "M544 256C544 221 525 188 494 170C503 137 494 100 469 75S407 41 374 50C356 19 323 0 288 0S220 19 202 50C169 41 132 50 107 75S73 137 82 170C51 188 32 221 32 256S51 324 82 342C73 375 82 412 107 437C134 463 170 471 202 462C220 493 253 512 288 512S356 493 374 462C406 471 443 463 469 437C494 412 503 375 494 342C525 324 544 291 544 256ZM453 324C458 336 482 378 446 414C418 443 389 436 356 421C352 433 339 480 288 480C236 480 223 430 220 421C187 436 158 443 130 414C93 378 119 334 123 324C111 320 64 307 64 256C64 204 114 191 123 188C118 176 94 134 130 98C166 61 210 87 220 91C224 79 237 32 288 32C340 32 353 82 356 91C368 86 410 62 446 98C483 134 457 178 453 188C465 192 512 205 512 256C512 308 462 321 453 324ZM292 241L285 239C251 229 246 222 248 210C251 194 277 190 300 193C306 194 314 196 325 200C333 202 342 198 345 190C348 181 343 172 335 169C323 165 312 163 304 162V144C304 135 297 128 288 128S272 135 272 144V161C242 164 221 180 217 205C209 250 254 263 276 269L284 271C322 282 330 287 328 302C325 318 300 322 276 319C268 318 263 316 237 308C229 305 220 309 217 318C214 326 219 335 227 338C256 348 263 349 272 351V368C272 377 279 384 288 384S304 377 304 368V351C334 348 355 332 359 307C367 261 322 249 292 241Z"]
  };
  var faBadgePercent = {
    prefix: 'fal',
    iconName: 'badge-percent',
    icon: [576, 512, [], "f646", "M544 256C544 221 525 188 494 170C503 137 494 100 469 75S407 41 374 50C356 19 323 0 288 0S220 19 202 50C169 41 132 50 107 75S73 137 82 170C51 188 32 221 32 256S51 324 82 342C73 375 82 412 107 437C134 463 170 471 202 462C220 493 253 512 288 512S356 493 374 462C406 471 443 463 469 437C494 412 503 375 494 342C525 324 544 291 544 256ZM453 324C458 336 482 378 446 414C418 443 389 436 356 421C352 433 339 480 288 480C236 480 223 430 220 421C187 436 158 443 130 414C93 378 119 334 123 324C111 320 64 307 64 256C64 204 114 191 123 188C118 176 94 134 130 98C166 61 210 87 220 91C224 79 237 32 288 32C340 32 353 82 356 91C368 86 410 62 446 98C483 134 457 178 453 188C465 192 512 205 512 256C512 308 462 321 453 324ZM357 165L197 325C190 331 190 341 197 347C200 350 204 352 208 352S216 350 219 347L379 187C386 181 386 171 379 165S363 158 357 165ZM224 216C237 216 248 205 248 192S237 168 224 168C211 168 200 179 200 192S211 216 224 216ZM352 296C339 296 328 307 328 320S339 344 352 344C365 344 376 333 376 320S365 296 352 296Z"]
  };
  var faBadgeSheriff = {
    prefix: 'fal',
    iconName: 'badge-sheriff',
    icon: [512, 512, [], "f8a2", "M420 284C420 284 419 284 418 284L401 256L418 228C419 228 420 228 420 228C454 228 482 201 482 166S454 105 420 105C399 105 379 116 368 134H328L306 98C314 87 318 75 318 62C318 28 290 0 256 0S194 28 194 62C194 75 198 87 206 98L184 134H145C134 116 114 105 92 105C58 105 30 132 30 166S58 228 92 228C93 228 93 228 94 228L111 256L94 284C93 284 93 284 92 284C58 284 30 311 30 346S58 407 92 407C114 407 134 396 145 378H184L206 414C198 425 194 437 194 450C194 484 222 512 256 512S318 484 318 450C318 437 314 425 306 414L328 378H368C379 396 399 407 420 407C455 407 482 380 482 346S454 284 420 284ZM420 375C410 375 400 370 395 361L386 346H310L301 361L279 398L268 416L280 433C284 438 286 444 286 450C286 467 273 480 256 480S226 467 226 450C226 444 228 438 232 433L244 416L233 398L211 361L202 346H127L117 361C112 370 102 375 92 375C75 375 62 362 62 346C62 329 75 316 93 316H93L112 317L122 300L138 272L148 256L122 212L111 195L92 196C75 196 62 183 62 166C62 150 75 137 92 137C102 137 112 142 117 151L127 166H202L211 151L233 114L244 96L232 79C228 74 226 68 226 62C226 45 240 32 256 32S286 45 286 62C286 68 284 74 280 79L268 96L279 114L301 151L310 166H386L395 151C400 142 410 137 420 137C437 137 450 150 450 166C450 183 437 196 420 196H420L400 195L391 212L364 256L374 272L391 300L401 317L420 316C437 316 450 329 450 346S437 375 420 375ZM256 184C216 184 184 216 184 256S216 328 256 328S328 296 328 256S296 184 256 184ZM256 296C234 296 216 278 216 256C216 234 234 216 256 216S296 234 296 256C296 278 278 296 256 296Z"]
  };
  var faBadgerHoney = {
    prefix: 'fal',
    iconName: 'badger-honey',
    icon: [640, 512, [], "f6b4", "M622 142L619 141C599 130 579 117 560 103C501 60 466 64 466 64C446 64 427 69 410 79C393 89 374 96 355 96H128C57 96 0 153 0 224V240C0 249 7 256 16 256H36C39 267 46 303 90 336L66 388C63 396 63 404 66 412L91 470C94 476 100 480 106 480H158C182 480 197 456 187 435L175 408L208 352H282L302 454C305 469 319 480 334 480H380C401 480 416 462 412 442L389 326C434 296 490 265 541 250L560 288L583 242C636 238 640 179 640 175C640 161 633 149 622 142ZM128 128H355C378 128 402 121 426 107C438 100 452 96 466 96C469 96 492 94 536 125C541 129 546 132 552 136H460C429 136 400 146 369 157L268 203C258 206 248 208 238 208H192C147 208 113 167 112 130C117 129 123 128 128 128ZM353 311L381 448H334L308 320H190L139 406L158 448H117L96 400L129 325L109 310C89 295 74 279 67 249L61 224H32C32 188 52 157 81 141C88 195 137 240 192 240H238C252 240 266 238 280 233L380 187C408 177 434 168 460 168H480C478 171 476 175 476 180C476 191 485 200 496 200S516 191 516 180C516 175 514 171 512 168H602C606 170 608 171 608 175C603 249 587 154 353 311Z"]
  };
  var faBagShopping = {
    prefix: 'fal',
    iconName: 'bag-shopping',
    icon: [448, 512, [], "f290", "M416 128H320V96C320 43 277 0 224 0C171 0 128 43 128 96V128H32C14 128 0 142 0 160V416C0 469 43 512 96 512H352C405 512 448 469 448 416V160C448 142 434 128 416 128ZM160 96C160 61 189 32 224 32C259 32 288 61 288 96V128H160V96ZM416 416C416 451 387 480 352 480H96C61 480 32 451 32 416V160H128V240C128 249 135 256 144 256S160 249 160 240V160H288V240C288 249 295 256 304 256S320 249 320 240V160H416V416Z"]
  };
  var faBagsShopping = {
    prefix: 'fal',
    iconName: 'bags-shopping',
    icon: [576, 512, [], "f847", "M528 256H240C214 256 192 278 192 304V464C192 490 214 512 240 512H528C554 512 576 490 576 464V304C576 278 554 256 528 256ZM544 464C544 473 537 480 528 480H240C231 480 224 473 224 464V304C224 295 231 288 240 288H528C537 288 544 295 544 304V464ZM144 448H48C39 448 32 441 32 432V208C32 199 39 192 48 192H400C409 192 416 199 416 208C416 217 423 224 432 224S448 217 448 208C448 182 426 160 400 160H320V96C320 43 277 0 224 0S128 43 128 96V160H48C22 160 0 182 0 208V432C0 458 22 480 48 480H144C153 480 160 473 160 464S153 448 144 448ZM160 96C160 61 189 32 224 32S288 61 288 96V160H160V96ZM464 320C455 320 448 327 448 336V352C448 387 419 416 384 416S320 387 320 352V336C320 327 313 320 304 320S288 327 288 336V352C288 405 331 448 384 448S480 405 480 352V336C480 327 473 320 464 320Z"]
  };
  var faBahai = {
    prefix: 'fal',
    iconName: 'bahai',
    icon: [512, 512, [], "f666", "M511 217C509 203 498 192 484 190H483L401 178L432 100C438 86 434 71 422 61C411 52 396 51 384 59L313 104L288 23C283 9 271 0 256 0S229 9 224 23L199 104L128 59C116 51 101 52 89 61C78 71 74 86 80 100L111 178L28 190C14 192 3 203 1 217C-2 232 5 245 18 253L92 292L35 355C26 365 24 379 30 391C35 403 47 411 60 411C62 411 64 411 67 410L149 393L146 477C145 486 148 495 155 502C168 516 193 515 205 499L256 432L307 499C313 507 323 512 333 512C342 512 351 508 357 502C364 495 367 486 366 477L363 392L445 410C459 413 473 407 481 394C488 382 486 366 477 355L420 292L494 252C507 246 514 232 511 217ZM387 274C378 279 376 291 383 298L452 379L350 357C340 355 330 363 331 373L333 479L269 396C262 388 250 388 243 396L177 478L181 373C182 363 173 355 162 357L59 377L129 298C136 291 134 279 125 274L32 224L136 207C146 206 153 195 149 185L111 86L199 142C208 148 220 143 223 133L257 33L289 133C292 144 304 148 313 142L403 88L363 185C359 195 366 206 376 207L480 224L387 274Z"]
  };
  var faBahtSign = {
    prefix: 'fal',
    iconName: 'baht-sign',
    icon: [320, 512, [], "e09e", "M253 234C274 216 288 190 288 160C288 107 245 64 192 64H160V16C160 7 153 0 144 0S128 7 128 16V64H16C7 64 0 71 0 80V432C0 441 7 448 16 448H128V496C128 505 135 512 144 512S160 505 160 496V448H208C270 448 320 398 320 336C320 290 292 251 253 234ZM192 96C227 96 256 125 256 160S227 224 192 224H160V96H192ZM32 96H128V224H32V96ZM32 416V256H128V416H32ZM208 416H160V256H208C252 256 288 292 288 336S252 416 208 416Z"]
  };
  var faBallPile = {
    prefix: 'fal',
    iconName: 'ball-pile',
    icon: [576, 512, [], "f77e", "M480 320C470 320 460 322 450 325C469 308 480 283 480 256C480 203 437 160 384 160C374 160 364 162 354 165C373 148 384 123 384 96C384 43 341 0 288 0S192 43 192 96C192 123 203 148 222 165C212 162 202 160 192 160C139 160 96 203 96 256C96 283 107 308 126 325C116 322 106 320 96 320C43 320 0 363 0 416S43 512 96 512S192 469 192 416C192 389 181 364 162 347C172 350 182 352 192 352S212 350 222 347C203 364 192 389 192 416C192 469 235 512 288 512S384 469 384 416C384 389 373 364 354 347C364 350 374 352 384 352S404 350 414 347C395 364 384 389 384 416C384 469 427 512 480 512S576 469 576 416S533 320 480 320ZM288 32C323 32 352 61 352 96S323 160 288 160S224 131 224 96S253 32 288 32ZM318 325C308 322 298 320 288 320S268 322 258 325C277 308 288 283 288 256S277 204 258 187C268 190 278 192 288 192S308 190 318 187C299 204 288 229 288 256S299 308 318 325ZM96 480C61 480 32 451 32 416S61 352 96 352S160 381 160 416S131 480 96 480ZM192 320C157 320 128 291 128 256S157 192 192 192S256 221 256 256S227 320 192 320ZM288 480C253 480 224 451 224 416S253 352 288 352S352 381 352 416S323 480 288 480ZM384 320C349 320 320 291 320 256S349 192 384 192S448 221 448 256S419 320 384 320ZM480 480C445 480 416 451 416 416S445 352 480 352S544 381 544 416S515 480 480 480Z"]
  };
  var faBallot = {
    prefix: 'fal',
    iconName: 'ballot',
    icon: [448, 512, [], "f732", "M96 232C83 232 72 243 72 256C72 269 83 280 96 280C109 280 120 269 120 256C120 243 109 232 96 232ZM96 360C83 360 72 371 72 384C72 397 83 408 96 408C109 408 120 397 120 384C120 371 109 360 96 360ZM96 104C83 104 72 115 72 128C72 141 83 152 96 152C109 152 120 141 120 128C120 115 109 104 96 104ZM384 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H384C419 512 448 483 448 448V64C448 29 419 0 384 0ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H384C402 32 416 46 416 64V448ZM352 368H176C167 368 160 375 160 384S167 400 176 400H352C361 400 368 393 368 384S361 368 352 368ZM352 112H176C167 112 160 119 160 128S167 144 176 144H352C361 144 368 137 368 128S361 112 352 112ZM352 240H176C167 240 160 247 160 256S167 272 176 272H352C361 272 368 265 368 256S361 240 352 240Z"]
  };
  var faBallotCheck = {
    prefix: 'fal',
    iconName: 'ballot-check',
    icon: [448, 512, [], "f733", "M96 360C83 360 72 371 72 384C72 397 83 408 96 408C109 408 120 397 120 384C120 371 109 360 96 360ZM352 368H176C167 368 160 375 160 384S167 400 176 400H352C361 400 368 393 368 384S361 368 352 368ZM101 288C105 288 110 286 113 283L171 225C178 218 178 208 171 202S155 196 149 202L101 249L91 239C85 233 75 233 69 239S62 256 69 262L90 283C93 286 97 288 101 288ZM96 152C109 152 120 141 120 128C120 115 109 104 96 104C83 104 72 115 72 128C72 141 83 152 96 152ZM352 240H208C199 240 192 247 192 256S199 272 208 272H352C361 272 368 265 368 256S361 240 352 240ZM384 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H384C419 512 448 483 448 448V64C448 29 419 0 384 0ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H384C402 32 416 46 416 64V448ZM352 112H176C167 112 160 119 160 128S167 144 176 144H352C361 144 368 137 368 128S361 112 352 112Z"]
  };
  var faBan = {
    prefix: 'fal',
    iconName: 'ban',
    icon: [512, 512, [], "f05e", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM464 256C464 308 445 355 414 391L121 98C157 67 204 48 256 48C371 48 464 141 464 256ZM48 256C48 204 67 157 98 121L391 414C355 445 308 464 256 464C141 464 48 371 48 256Z"]
  };
  var faBanBug = {
    prefix: 'fal',
    iconName: 'ban-bug',
    icon: [512, 512, [], "f7f9", "M130 312L176 305C176 312 177 319 179 325L135 355C128 360 126 370 131 377C134 382 143 387 153 381L194 354C209 372 231 384 256 384C272 384 288 379 302 370L278 346C271 350 264 352 256 352C230 352 208 330 208 304V276L176 244V273L126 280C117 281 111 290 112 298C114 312 127 312 130 312ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256C48 204 67 157 98 121L391 414C355 445 308 464 256 464ZM212 189C221 168 243 157 266 161C288 166 304 185 304 208V281L212 189ZM414 391L335 313C335 310 336 308 336 305L382 312C384 312 398 312 400 298C401 290 395 281 386 280L336 273V247L386 240C392 239 397 235 399 230C401 225 400 218 397 214C393 209 387 207 382 208L336 215C336 197 335 193 333 187L377 157C384 152 386 142 381 135C376 128 366 126 359 131L318 158C303 140 281 128 256 128C227 128 203 143 189 166L121 98C157 67 204 48 256 48C371 48 464 141 464 256C464 308 445 355 414 391Z"]
  };
  var faBanParking = {
    prefix: 'fal',
    iconName: 'ban-parking',
    icon: [512, 512, [], "f616", "M192 384C201 384 208 377 208 368V320H252L220 288H208V276L176 244V368C176 377 183 384 192 384ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256C48 204 67 157 98 121L391 414C355 445 308 464 256 464ZM208 185V160H288C323 160 352 189 352 224C352 253 333 276 307 285L208 185ZM414 391L332 309C363 293 384 261 384 224C384 171 341 128 288 128H208C192 128 180 140 177 154L121 98C157 67 204 48 256 48C371 48 464 141 464 256C464 308 445 355 414 391Z"]
  };
  var faBanSmoking = {
    prefix: 'fal',
    iconName: 'ban-smoking',
    icon: [512, 512, [], "f54d", "M256 0C115 0 0 115 0 256S115 512 256 512S512 397 512 256S397 0 256 0ZM256 480C133 480 32 379 32 256C32 200 53 149 87 110L201 224H128C110 224 96 238 96 256V288C96 306 110 320 128 320H297L402 425C363 459 312 480 256 480ZM233 256L265 288H128V256H233ZM425 402L342 319C348 317 352 311 352 304C352 295 345 288 336 288H311L279 256H336C345 256 352 249 352 240S345 224 336 224H247L110 87C149 53 200 32 256 32C379 32 480 133 480 256C480 312 459 363 425 402ZM400 224C391 224 384 231 384 240V304C384 313 391 320 400 320S416 313 416 304V240C416 231 409 224 400 224ZM399 193C408 193 415 186 415 177C415 142 383 113 345 113H310C299 113 288 109 281 101C275 95 272 88 272 80L272 78L272 78C270 70 264 64 256 64H256C247 64 240 71 240 80C240 96 246 112 258 124C271 137 290 145 310 145H345C366 145 383 159 383 177C383 186 390 193 399 193Z"]
  };
  var faBandage = {
    prefix: 'fal',
    iconName: 'bandage',
    icon: [640, 512, [], "f462", "M560 96H80C36 96 0 132 0 176V336C0 380 36 416 80 416H560C604 416 640 380 640 336V176C640 132 604 96 560 96ZM160 384H80C54 384 32 362 32 336V176C32 150 54 128 80 128H160V384ZM448 384H192V128H448V384ZM608 336C608 362 586 384 560 384H480V128H560C586 128 608 150 608 176V336ZM272 228C283 228 292 219 292 208S283 188 272 188S252 197 252 208S261 228 272 228ZM368 228C379 228 388 219 388 208S379 188 368 188S348 197 348 208S357 228 368 228ZM272 324C283 324 292 315 292 304S283 284 272 284S252 293 252 304S261 324 272 324ZM368 324C379 324 388 315 388 304S379 284 368 284S348 293 348 304S357 324 368 324Z"]
  };
  var faBanjo = {
    prefix: 'fal',
    iconName: 'banjo',
    icon: [512, 512, [], "f8a3", "M147 317C141 310 131 310 125 317S118 333 125 339L173 387C176 390 180 392 184 392S192 390 195 387C202 381 202 371 195 365L147 317ZM501 37L475 11C468 4 458 0 449 0H449C439 0 429 4 422 11L381 55C378 58 376 62 375 67L363 126L298 191C273 170 242 157 208 154V144C208 135 201 128 192 128S176 135 176 144V154C142 157 111 170 86 191L79 184C73 178 62 178 56 184C50 190 50 201 56 207L63 214C42 239 29 270 26 304H16C7 304 0 311 0 320S7 336 16 336H26C29 370 42 401 63 426L56 433C50 439 50 450 56 456C62 462 73 462 79 456L86 449C111 470 142 483 176 486V496C176 505 183 512 192 512S208 505 208 496V486C242 483 273 470 298 449L305 456C311 462 322 462 328 456C334 450 334 439 328 433L321 426C342 401 355 370 358 336H368C377 336 384 329 384 320S377 304 368 304H358C355 270 342 239 321 214L386 149L445 137C450 136 454 134 457 131L501 89C516 75 516 52 501 37ZM328 320C328 395 267 456 192 456S56 395 56 320S117 184 192 184S328 245 328 320ZM479 66L437 106L399 113L406 75L445 34C448 31 451 32 452 33L479 60C480 62 480 65 479 66Z"]
  };
  var faBank = {
    prefix: 'fal',
    iconName: 'bank',
    icon: [512, 512, [], "f19c", "M496 480H16C7 480 0 487 0 496C0 505 7 512 16 512H496C505 512 512 505 512 496C512 487 505 480 496 480ZM472 448C481 448 488 441 488 432C488 423 481 416 472 416H40C31 416 24 423 24 432C24 441 31 448 40 448H472ZM497 98L265 2C262 1 259 0 256 0S250 1 247 2L15 98C6 102 0 110 0 120V168C0 181 11 192 24 192H64V352C55 352 48 359 48 368C48 377 55 384 64 384H448C457 384 464 377 464 368C464 359 457 352 448 352V192H488C501 192 512 181 512 168V120C512 110 506 102 497 98ZM176 352H96V192H176V352ZM304 352H208V192H304V352ZM232 136C232 123 243 112 256 112S280 123 280 136S269 160 256 160S232 149 232 136ZM416 352H336V192H416V352ZM480 160H306C310 153 312 145 312 136C312 105 287 80 256 80S200 105 200 136C200 145 202 153 206 160H32V125L256 33L480 125V160Z"]
  };
  var faBarcode = {
    prefix: 'fal',
    iconName: 'barcode',
    icon: [512, 512, [], "f02a", "M496 32C487 32 480 39 480 48V464C480 473 487 480 496 480S512 473 512 464V48C512 39 505 32 496 32ZM400 32C391 32 384 39 384 48V464C384 473 391 480 400 480S416 473 416 464V48C416 39 409 32 400 32ZM304 32C295 32 288 39 288 48V464C288 473 295 480 304 480S320 473 320 464V48C320 39 313 32 304 32ZM240 32C231 32 224 39 224 48V464C224 473 231 480 240 480S256 473 256 464V48C256 39 249 32 240 32ZM144 32C135 32 128 39 128 48V464C128 473 135 480 144 480S160 473 160 464V48C160 39 153 32 144 32ZM80 32C71 32 64 39 64 48V464C64 473 71 480 80 480S96 473 96 464V48C96 39 89 32 80 32ZM16 32C7 32 0 39 0 48V464C0 473 7 480 16 480S32 473 32 464V48C32 39 25 32 16 32Z"]
  };
  var faBarcodeRead = {
    prefix: 'fal',
    iconName: 'barcode-read',
    icon: [576, 512, [], "f464", "M208 128C199 128 192 135 192 144V368C192 377 199 384 208 384S224 377 224 368V144C224 135 217 128 208 128ZM432 384C441 384 448 377 448 368V144C448 135 441 128 432 128S416 135 416 144V368C416 377 423 384 432 384ZM272 128C263 128 256 135 256 144V368C256 377 263 384 272 384S288 377 288 368V144C288 135 281 128 272 128ZM352 128C343 128 336 135 336 144V368C336 377 343 384 352 384S368 377 368 368V144C368 135 361 128 352 128ZM144 128C135 128 128 135 128 144V368C128 377 135 384 144 384S160 377 160 368V144C160 135 153 128 144 128ZM144 0H16C7 0 0 7 0 16V144C0 153 7 160 16 160S32 153 32 144V32H144C153 32 160 25 160 16S153 0 144 0ZM560 0H432C423 0 416 7 416 16S423 32 432 32H544V144C544 153 551 160 560 160S576 153 576 144V16C576 7 569 0 560 0ZM560 352C551 352 544 359 544 368V480H432C423 480 416 487 416 496S423 512 432 512H560C569 512 576 505 576 496V368C576 359 569 352 560 352ZM144 480H32V368C32 359 25 352 16 352S0 359 0 368V496C0 505 7 512 16 512H144C153 512 160 505 160 496S153 480 144 480Z"]
  };
  var faBarcodeScan = {
    prefix: 'fal',
    iconName: 'barcode-scan',
    icon: [640, 512, [], "f465", "M624 240H16C7 240 0 247 0 256S7 272 16 272H624C633 272 640 265 640 256S633 240 624 240ZM96 48C96 39 89 32 80 32S64 39 64 48V192H96V48ZM160 48C160 39 153 32 144 32S128 39 128 48V192H160V48ZM320 48C320 39 313 32 304 32S288 39 288 48V192H320V48ZM384 48C384 39 377 32 368 32S352 39 352 48V192H384V48ZM576 48C576 39 569 32 560 32S544 39 544 48V192H576V48ZM480 48C480 39 473 32 464 32S448 39 448 48V192H480V48ZM224 48C224 39 217 32 208 32S192 39 192 48V192H224V48ZM352 464C352 473 359 480 368 480S384 473 384 464V320H352V464ZM64 464C64 473 71 480 80 480S96 473 96 464V320H64V464ZM544 464C544 473 551 480 560 480S576 473 576 464V320H544V464ZM448 464C448 473 455 480 464 480S480 473 480 464V320H448V464ZM128 464C128 473 135 480 144 480S160 473 160 464V320H128V464ZM288 464C288 473 295 480 304 480S320 473 320 464V320H288V464ZM192 464C192 473 199 480 208 480S224 473 224 464V320H192V464Z"]
  };
  var faBars = {
    prefix: 'fal',
    iconName: 'bars',
    icon: [448, 512, [], "f0c9", "M16 112H432C441 112 448 105 448 96S441 80 432 80H16C7 80 0 87 0 96S7 112 16 112ZM432 240H16C7 240 0 247 0 256S7 272 16 272H432C441 272 448 265 448 256S441 240 432 240ZM432 400H16C7 400 0 407 0 416S7 432 16 432H432C441 432 448 425 448 416S441 400 432 400Z"]
  };
  var faBarsProgress = {
    prefix: 'fal',
    iconName: 'bars-progress',
    icon: [512, 512, [], "f828", "M480 32H32C14 32 0 46 0 64V128C0 146 14 160 32 160H480C498 160 512 146 512 128V64C512 46 498 32 480 32ZM352 128H32V64H352V128ZM480 128H384V64H480V128ZM480 192H32C14 192 0 206 0 224V288C0 306 14 320 32 320H480C498 320 512 306 512 288V224C512 206 498 192 480 192ZM128 288H32V224H128V288ZM480 288H160V224H480V288ZM480 352H32C14 352 0 366 0 384V448C0 466 14 480 32 480H480C498 480 512 466 512 448V384C512 366 498 352 480 352ZM256 448H32V384H256V448ZM480 448H288V384H480V448Z"]
  };
  var faBarsStaggered = {
    prefix: 'fal',
    iconName: 'bars-staggered',
    icon: [512, 512, [], "f550", "M16 112H432C441 112 448 105 448 96S441 80 432 80H16C7 80 0 87 0 96S7 112 16 112ZM496 240H80C71 240 64 247 64 256S71 272 80 272H496C505 272 512 265 512 256S505 240 496 240ZM432 400H16C7 400 0 407 0 416S7 432 16 432H432C441 432 448 425 448 416S441 400 432 400Z"]
  };
  var faBaseballBall = {
    prefix: 'fal',
    iconName: 'baseball-ball',
    icon: [512, 512, [], "f433", "M366 267C323 288 288 323 267 366C263 376 269 387 279 389L279 389C286 390 293 386 296 380C314 343 343 314 380 296C387 293 390 286 389 279L389 279C387 269 376 263 366 267ZM233 123L233 123C226 122 219 126 216 132C198 169 169 198 132 216C126 219 122 226 123 233L123 233C125 243 136 249 146 245C189 224 224 189 245 146C249 136 243 125 233 123ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM280 463C279 460 279 458 279 455C279 449 279 443 280 437C281 428 275 421 267 419C258 418 249 424 248 433C248 440 247 448 247 455C247 458 247 461 248 464C140 459 53 372 48 264C51 265 54 265 57 265C64 265 72 265 79 264C88 263 94 254 93 245C91 237 84 231 75 232C69 233 63 233 57 233C54 233 52 233 49 232C60 137 137 60 232 49C233 52 233 54 233 57C233 63 233 69 232 75C231 84 237 91 245 93C254 94 263 88 264 79C265 72 265 64 265 57C265 54 265 51 264 48C372 53 459 140 464 248C461 247 458 247 455 247C448 247 440 247 433 248C424 249 418 258 419 267C421 275 428 281 437 280C443 279 449 279 455 279C458 279 460 279 463 280C452 375 375 452 280 463Z"]
  };
  var faBaseballBatBall = {
    prefix: 'fal',
    iconName: 'baseball-bat-ball',
    icon: [640, 512, [], "f432", "M627 60L604 28C581 -3 539 -8 510 13L308 160C262 193 220 231 183 273C154 307 111 352 53 394L31 410C31 409 20 392 6 404C-1 409 -2 419 3 426L67 506C73 513 83 514 90 509C91 508 103 499 90 483L108 470C174 422 231 397 263 383C315 361 365 333 410 300L613 154C642 132 649 90 627 60ZM70 458L51 435C80 414 123 384 176 329L209 373C141 406 99 437 70 458ZM594 128C347 307 351 310 234 361L195 308C280 213 282 218 529 39C544 28 566 30 578 46L601 79C613 95 609 116 594 128ZM496 352C452 352 416 388 416 432C416 476 452 512 496 512S576 476 576 432C576 388 540 352 496 352ZM496 480C470 480 448 458 448 432C448 406 470 384 496 384C523 384 544 406 544 432C544 458 523 480 496 480Z"]
  };
  var faBasketShopping = {
    prefix: 'fal',
    iconName: 'basket-shopping',
    icon: [576, 512, [], "f291", "M176 320C167 320 160 327 160 336V432C160 441 167 448 176 448C185 448 192 441 192 432V336C192 327 185 320 176 320ZM288 320C279 320 272 327 272 336V432C272 441 279 448 288 448C297 448 304 441 304 432V336C304 327 297 320 288 320ZM400 320C391 320 384 327 384 336V432C384 441 391 448 400 448C409 448 416 441 416 432V336C416 327 409 320 400 320ZM560 192H419L351 10C348 2 339 -2 330 1C322 4 318 13 321 22L385 192H191L255 22C258 13 254 4 246 1C237 -2 228 2 225 10L157 192H16C7 192 0 199 0 208C0 217 7 224 16 224H32L85 462C91 491 117 512 147 512H429C459 512 485 491 491 462L544 224H560C569 224 576 217 576 208C576 199 569 192 560 192ZM460 455C457 470 444 480 429 480H147C132 480 119 470 116 455L65 224H145L129 266C126 275 130 284 138 287C140 288 142 288 144 288C150 288 157 284 159 278L179 224H397L417 278C419 284 426 288 432 288C434 288 436 288 438 287C446 284 450 275 447 266L431 224H511L460 455Z"]
  };
  var faBasketShoppingSimple = {
    prefix: 'fal',
    iconName: 'basket-shopping-simple',
    icon: [576, 512, [], "e09f", "M560 192H419L351 10C348 2 339 -2 330 1C322 4 318 13 321 22L385 192H191L255 22C258 13 254 4 246 1C237 -2 228 2 225 10L157 192H16C7 192 0 199 0 208C0 217 7 224 16 224H32L85 462C91 491 117 512 147 512H429C459 512 485 491 491 462L544 224H560C569 224 576 217 576 208C576 199 569 192 560 192ZM460 455C457 470 444 480 429 480H147C132 480 119 470 116 455L65 224H145L129 266C126 275 130 284 138 287C140 288 142 288 144 288C150 288 157 284 159 278L179 224H397L417 278C419 284 426 288 432 288C434 288 436 288 438 287C446 284 450 275 447 266L431 224H511L460 455Z"]
  };
  var faBasketballBall = {
    prefix: 'fal',
    iconName: 'basketball-ball',
    icon: [512, 512, [], "f434", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM464 256C413 258 367 278 331 309L279 256L414 121C445 157 464 204 464 256C464 256 464 256 464 256ZM391 414C363 438 327 455 289 461C291 420 306 383 331 354L391 414ZM391 98L256 233L203 181C234 145 254 99 256 48C256 48 256 48 256 48C308 48 355 67 391 98ZM121 98C149 74 185 57 223 51C221 92 206 129 181 158L121 98ZM98 121L158 181C129 206 92 221 51 223C57 185 74 149 98 121ZM48 256C99 254 145 234 181 203L233 256L98 391C67 355 48 308 48 256C48 256 48 256 48 256ZM121 414L256 279L309 331C278 367 258 413 256 464C256 464 256 464 256 464C204 464 157 445 121 414ZM414 391L354 331C383 306 420 291 461 289C455 327 438 363 414 391Z"]
  };
  var faBasketballHoop = {
    prefix: 'fal',
    iconName: 'basketball-hoop',
    icon: [640, 512, [], "f435", "M631 176C573 71 455 0 320 0S67 71 9 176C3 186 0 197 0 208V326C0 352 15 375 38 385L105 414C117 419 129 410 128 398C127 392 123 387 118 385L51 355C40 350 32 339 32 326V208C32 202 33 197 35 193C91 94 200 32 320 32S549 94 605 193C607 197 608 202 608 208V326C608 339 600 350 589 355L522 385C517 387 513 392 512 398C511 410 523 419 535 414L602 385C625 375 640 352 640 326V208C640 197 637 186 631 176ZM464 208C473 208 480 201 480 192V160C480 142 466 128 448 128H192C174 128 160 142 160 160V192C160 201 167 208 176 208C185 208 192 201 192 192V160H448V192C448 201 455 208 464 208ZM528 256C528 247 521 240 512 240H128C119 240 112 247 112 256S119 272 128 272H147L172 498C173 504 177 509 182 511C184 512 186 512 188 512C192 512 195 511 198 508L253 461L310 508C313 511 316 512 320 512S327 511 330 508L387 461L442 508C445 511 448 512 452 512C454 512 456 512 458 511C463 509 467 504 468 498L493 272H512C521 272 528 265 528 256ZM439 464L407 437C401 432 394 429 387 429C379 429 372 432 366 437L320 475L274 437C268 432 261 429 253 429C246 429 239 432 233 437L201 464L179 272H461L439 464ZM240 344C253 344 264 333 264 320C264 307 253 296 240 296C227 296 216 307 216 320C216 333 227 344 240 344ZM256 384C256 397 267 408 280 408C293 408 304 397 304 384C304 371 293 360 280 360C267 360 256 371 256 384ZM336 384C336 397 347 408 360 408C373 408 384 397 384 384C384 371 373 360 360 360C347 360 336 371 336 384ZM400 344C413 344 424 333 424 320C424 307 413 296 400 296C387 296 376 307 376 320C376 333 387 344 400 344ZM320 344C333 344 344 333 344 320C344 307 333 296 320 296C307 296 296 307 296 320C296 333 307 344 320 344Z"]
  };
  var faBat = {
    prefix: 'fal',
    iconName: 'bat',
    icon: [640, 512, [], "f6b5", "M639 287L568 130C563 117 550 110 538 110C532 110 526 112 521 115L416 175L384 64L334 112H306L256 64L224 175L119 115C114 112 108 110 102 110C90 110 77 117 72 130L1 287C-4 300 8 313 22 309L39 304C45 301 52 300 60 300C81 300 102 311 115 329L153 384L166 372C179 360 196 353 213 353C233 353 253 362 266 379L320 448L374 379C387 362 407 353 427 353C444 353 461 360 474 372L487 384L525 329C538 311 559 300 580 300C587 300 595 301 601 303L618 309C632 313 644 300 639 287ZM581 268C547 268 516 284 497 311L480 336C464 326 446 322 427 322C395 322 366 336 347 360L320 395L293 360C274 335 245 322 213 322C194 322 176 326 160 336L143 311C124 284 93 268 59 268C55 268 50 269 46 269L102 142L246 225L272 125L293 144H347L368 125L394 225L538 142L594 269C590 269 585 268 581 268Z"]
  };
  var faBath = {
    prefix: 'fal',
    iconName: 'bath',
    icon: [512, 512, [], "f2cd", "M464 320C455 320 448 327 448 336V368C448 412 412 448 368 448H144C100 448 64 412 64 368V336C64 327 57 320 48 320S32 327 32 336V368C32 398 44 426 64 446V496C64 505 71 512 80 512C89 512 96 505 96 496V469C111 476 127 480 144 480H368C385 480 401 476 416 469V496C416 505 423 512 432 512C441 512 448 505 448 496V446C468 426 480 398 480 368V336C480 327 473 320 464 320ZM496 256H64V61C64 45 77 32 93 32C101 32 109 35 114 41L139 66C122 94 125 131 149 156L162 169C159 175 160 182 165 187C168 190 172 192 176 192S184 190 187 187L283 91C290 85 290 75 283 69C278 64 271 63 265 66L252 53C238 39 219 32 200 32C187 32 174 36 162 43L137 18C125 6 110 0 93 0C59 0 32 27 32 61V256H16C7 256 0 263 0 272S7 288 16 288H496C505 288 512 281 512 272S505 256 496 256ZM172 76C179 68 190 64 200 64S221 68 229 76L241 88L184 145L172 133C156 117 156 92 172 76Z"]
  };
  var faBatteryBolt = {
    prefix: 'fal',
    iconName: 'battery-bolt',
    icon: [576, 512, [], "f376", "M208 384H64C46 384 32 370 32 352V160C32 142 46 128 64 128H144C153 128 160 121 160 112C160 103 153 96 144 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H208C217 416 224 409 224 400C224 391 217 384 208 384ZM560 192C551 192 544 199 544 208V304C544 313 551 320 560 320S576 313 576 304V208C576 199 569 192 560 192ZM448 96H336C327 96 320 103 320 112C320 121 327 128 336 128H448C466 128 480 142 480 160V352C480 370 466 384 448 384H368C359 384 352 391 352 400C352 409 359 416 368 416H448C483 416 512 387 512 352V160C512 125 483 96 448 96ZM382 248C379 243 374 240 368 240H199L271 54C274 46 270 36 262 33C253 30 244 34 241 42L161 250C159 255 160 261 163 265C166 269 171 272 176 272H341L242 456C238 464 241 474 248 478C251 479 253 480 256 480C262 480 267 477 270 472L382 264C385 259 385 253 382 248Z"]
  };
  var faBatteryEmpty = {
    prefix: 'fal',
    iconName: 'battery-empty',
    icon: [576, 512, [], "f244", "M448 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H448C483 416 512 387 512 352V160C512 125 483 96 448 96ZM480 352C480 370 466 384 448 384H64C46 384 32 370 32 352V160C32 142 46 128 64 128H448C466 128 480 142 480 160V352ZM560 192C551 192 544 199 544 208V304C544 313 551 320 560 320S576 313 576 304V208C576 199 569 192 560 192Z"]
  };
  var faBatteryExclamation = {
    prefix: 'fal',
    iconName: 'battery-exclamation',
    icon: [576, 512, [], "e0a0", "M272 336C281 336 288 329 288 320V80C288 71 281 64 272 64C263 64 256 71 256 80V320C256 329 263 336 272 336ZM272 368C254 368 240 382 240 400C240 418 254 432 272 432S304 418 304 400C304 382 290 368 272 368ZM64 128H176C185 128 192 121 192 112C192 103 185 96 176 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H176C185 416 192 409 192 400C192 391 185 384 176 384H64C46 384 32 370 32 352V160C32 142 46 128 64 128ZM560 192C551 192 544 199 544 208V304C544 313 551 320 560 320S576 313 576 304V208C576 199 569 192 560 192ZM448 96H368C359 96 352 103 352 112C352 121 359 128 368 128H448C466 128 480 142 480 160V352C480 370 466 384 448 384H368C359 384 352 391 352 400C352 409 359 416 368 416H448C483 416 512 387 512 352V160C512 125 483 96 448 96Z"]
  };
  var faBatteryFull = {
    prefix: 'fal',
    iconName: 'battery-full',
    icon: [576, 512, [], "f240", "M448 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H448C483 416 512 387 512 352V160C512 125 483 96 448 96ZM480 352C480 370 466 384 448 384H64C46 384 32 370 32 352V160C32 142 46 128 64 128H448C466 128 480 142 480 160V352ZM416 160H96C78 160 64 174 64 192V320C64 338 78 352 96 352H416C434 352 448 338 448 320V192C448 174 434 160 416 160ZM416 320H96V192H416V320ZM560 192C551 192 544 199 544 208V304C544 313 551 320 560 320S576 313 576 304V208C576 199 569 192 560 192Z"]
  };
  var faBatteryHalf = {
    prefix: 'fal',
    iconName: 'battery-half',
    icon: [576, 512, [], "f242", "M560 192C551 192 544 199 544 208V304C544 313 551 320 560 320S576 313 576 304V208C576 199 569 192 560 192ZM448 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H448C483 416 512 387 512 352V160C512 125 483 96 448 96ZM480 352C480 370 466 384 448 384H64C46 384 32 370 32 352V160C32 142 46 128 64 128H448C466 128 480 142 480 160V352ZM256 160H96C78 160 64 174 64 192V320C64 338 78 352 96 352H256C274 352 288 338 288 320V192C288 174 274 160 256 160ZM256 320H96V192H256V320Z"]
  };
  var faBatteryLow = {
    prefix: 'fal',
    iconName: 'battery-low',
    icon: [576, 512, [], "e0a1", "M560 192C551 192 544 199 544 208V304C544 313 551 320 560 320S576 313 576 304V208C576 199 569 192 560 192ZM448 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H448C483 416 512 387 512 352V160C512 125 483 96 448 96ZM480 352C480 370 466 384 448 384H64C46 384 32 370 32 352V160C32 142 46 128 64 128H448C466 128 480 142 480 160V352ZM112 160H96C78 160 64 174 64 192V320C64 338 78 352 96 352H112C130 352 144 338 144 320V192C144 174 130 160 112 160ZM112 320H96V192H112V320Z"]
  };
  var faBatteryQuarter = {
    prefix: 'fal',
    iconName: 'battery-quarter',
    icon: [576, 512, [], "f243", "M560 192C551 192 544 199 544 208V304C544 313 551 320 560 320S576 313 576 304V208C576 199 569 192 560 192ZM448 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H448C483 416 512 387 512 352V160C512 125 483 96 448 96ZM480 352C480 370 466 384 448 384H64C46 384 32 370 32 352V160C32 142 46 128 64 128H448C466 128 480 142 480 160V352ZM160 160H96C78 160 64 174 64 192V320C64 338 78 352 96 352H160C178 352 192 338 192 320V192C192 174 178 160 160 160ZM160 320H96V192H160V320Z"]
  };
  var faBatterySlash = {
    prefix: 'fal',
    iconName: 'battery-slash',
    icon: [640, 512, [], "f377", "M592 320C601 320 608 313 608 304V208C608 199 601 192 592 192S576 199 576 208V304C576 313 583 320 592 320ZM480 128C498 128 512 142 512 160V326L544 351V160C544 125 515 96 480 96H221L261 128H480ZM96 384C78 384 64 370 64 352V160C64 153 67 146 71 141L46 121C37 132 32 145 32 160V352C32 387 61 416 96 416H419L379 384H96ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483Z"]
  };
  var faBatteryThreeQuarters = {
    prefix: 'fal',
    iconName: 'battery-three-quarters',
    icon: [576, 512, [], "f241", "M320 160H96C78 160 64 174 64 192V320C64 338 78 352 96 352H320C338 352 352 338 352 320V192C352 174 338 160 320 160ZM320 320H96V192H320V320ZM448 96H64C29 96 0 125 0 160V352C0 387 29 416 64 416H448C483 416 512 387 512 352V160C512 125 483 96 448 96ZM480 352C480 370 466 384 448 384H64C46 384 32 370 32 352V160C32 142 46 128 64 128H448C466 128 480 142 480 160V352ZM560 192C551 192 544 199 544 208V304C544 313 551 320 560 320S576 313 576 304V208C576 199 569 192 560 192Z"]
  };
  var faBed = {
    prefix: 'fal',
    iconName: 'bed',
    icon: [640, 512, [], "f236", "M528 128H272C263 128 256 135 256 144V320H32V48C32 39 25 32 16 32S0 39 0 48V464C0 473 7 480 16 480S32 473 32 464V416H608V464C608 473 615 480 624 480S640 473 640 464V240C640 178 590 128 528 128ZM608 384H32V352H608V384ZM608 320H288V160H528C572 160 608 196 608 240V320ZM144 288C188 288 224 252 224 208S188 128 144 128S64 164 64 208S100 288 144 288ZM144 160C170 160 192 182 192 208S170 256 144 256S96 234 96 208S118 160 144 160Z"]
  };
  var faBedBunk = {
    prefix: 'fal',
    iconName: 'bed-bunk',
    icon: [576, 512, [], "f8f8", "M128 128C163 128 192 99 192 64S163 0 128 0S64 29 64 64S93 128 128 128ZM128 32C146 32 160 46 160 64S146 96 128 96S96 82 96 64S110 32 128 32ZM128 384C163 384 192 355 192 320S163 256 128 256S64 285 64 320S93 384 128 384ZM128 288C146 288 160 302 160 320S146 352 128 352S96 338 96 320S110 288 128 288ZM464 0H240C231 0 224 7 224 16V160H32V16C32 7 25 0 16 0S0 7 0 16V496C0 505 7 512 16 512S32 505 32 496V448H544V496C544 505 551 512 560 512S576 505 576 496V112C576 50 526 0 464 0ZM544 416H256V288H464C508 288 544 324 544 368V416ZM544 290C523 268 494 256 464 256H240C231 256 224 263 224 272V416H32V192H544V290ZM544 160H256V32H464C508 32 544 68 544 112V160Z"]
  };
  var faBedEmpty = {
    prefix: 'fal',
    iconName: 'bed-empty',
    icon: [640, 512, [], "f8f9", "M528 192H32V48C32 39 25 32 16 32S0 39 0 48V464C0 473 7 480 16 480S32 473 32 464V416H608V464C608 473 615 480 624 480S640 473 640 464V304C640 242 590 192 528 192ZM608 384H32V352H608V384ZM608 320H32V224H528C572 224 608 260 608 304V320Z"]
  };
  var faBedFront = {
    prefix: 'fal',
    iconName: 'bed-front',
    icon: [512, 512, [], "f8f7", "M480 240V96C480 61 451 32 416 32H96C61 32 32 61 32 96V240C13 255 0 278 0 304V464C0 473 7 480 16 480S32 473 32 464V416H480V464C480 473 487 480 496 480S512 473 512 464V304C512 278 499 255 480 240ZM432 224H272V192C272 174 286 160 304 160H416C434 160 448 174 448 192V226C443 225 437 224 432 224ZM96 64H416C434 64 448 78 448 96V137C439 131 428 128 416 128H304C285 128 268 137 256 150C244 137 227 128 208 128H96C84 128 73 131 64 137V96C64 78 78 64 96 64ZM64 192C64 174 78 160 96 160H208C226 160 240 174 240 192V224H80C75 224 69 225 64 226V192ZM480 384H32V304C32 278 54 256 80 256H432C458 256 480 278 480 304V384Z"]
  };
  var faBedPulse = {
    prefix: 'fal',
    iconName: 'bed-pulse',
    icon: [640, 512, [], "f487", "M208 96H342L386 183C388 189 394 192 400 192H401C407 192 413 188 415 182L466 55L482 87C484 93 490 96 496 96H624C633 96 640 89 640 80S633 64 624 64H506L478 9C475 3 470 -1 463 0C457 0 451 4 449 10L398 137L366 73C364 67 358 64 352 64H208C199 64 192 71 192 80S199 96 208 96ZM144 320C188 320 224 284 224 240S188 160 144 160S64 196 64 240S100 320 144 320ZM144 192C170 192 192 214 192 240S170 288 144 288S96 266 96 240S118 192 144 192ZM528 160H480C471 160 464 167 464 176C464 185 471 192 480 192H528C572 192 608 228 608 272V352H288V192H320C329 192 336 185 336 176C336 167 329 160 320 160H272C263 160 256 167 256 176V352H32V81C32 73 27 66 19 64C9 63 0 70 0 80V495C0 503 5 510 13 512C23 513 32 506 32 496V448H608V495C608 503 613 510 621 512C631 513 640 506 640 496V272C640 210 590 160 528 160ZM608 416H32V384H608V416Z"]
  };
  var faBee = {
    prefix: 'fal',
    iconName: 'bee',
    icon: [576, 512, [], "e0a2", "M448 96H448C420 96 393 105 367 119C368 116 368 114 368 112C368 92 360 73 348 59L379 28C384 22 386 13 381 7C375 -1 364 -2 357 5L322 40C311 35 300 32 288 32S265 35 254 40L220 5C214 0 205 -2 199 3C190 9 190 20 197 27L228 59C216 73 208 92 208 112C208 114 208 116 209 119C183 105 156 96 128 96H128C57 96 0 146 0 208V208C0 259 39 302 92 315C102 318 112 310 112 300V300C112 292 107 286 100 284C61 274 32 244 32 208C32 164 75 128 128 128H128C163 128 201 148 232 171C182 193 147 243 147 301V301C147 406 288 512 288 512S429 406 429 301V301C429 243 394 193 344 172C375 148 413 128 448 128H448C501 128 544 164 544 208C544 244 515 274 476 284C469 286 464 292 464 300V300C464 310 474 318 484 315C537 302 576 259 576 208V208C576 146 519 96 448 96ZM336 112C336 138 314 160 288 160S240 138 240 112S262 64 288 64S336 86 336 112ZM234 416C226 406 218 395 210 384H366C358 395 350 406 342 416H234ZM192 352C187 341 184 331 182 320H394C392 331 389 341 384 352H192ZM396 288H180C182 277 185 266 189 256H387C391 266 394 277 396 288ZM264 448H312C304 456 295 464 288 471C281 464 272 456 264 448ZM365 224H211C211 224 211 224 211 224C232 203 259 192 288 192H288C317 192 344 203 365 224C365 224 365 224 365 224Z"]
  };
  var faBeerMug = {
    prefix: 'fal',
    iconName: 'beer-mug',
    icon: [512, 512, [], "e0a3", "M240 208V400C240 409 247 416 256 416S272 409 272 400V208C272 199 265 192 256 192S240 199 240 208ZM99 133C112 125 128 130 138 138C152 152 171 160 192 160S232 152 247 138C256 130 272 125 285 133C295 140 307 144 320 144C360 144 391 108 383 66C378 43 359 24 336 18C331 17 325 16 320 16C308 16 297 19 287 25C274 33 258 32 246 22C232 8 213 0 192 0S152 8 138 22C126 32 110 33 97 25C87 19 76 16 64 16H64C59 16 53 17 48 18C25 24 6 43 1 66C-7 108 24 144 64 144C77 144 89 140 99 133ZM33 73C37 52 62 41 80 53C91 59 103 62 115 62C132 62 147 56 159 45C178 28 206 28 225 45C237 56 252 62 269 62C281 62 293 59 304 52C322 41 347 52 351 73C354 86 348 96 345 100C321 129 299 97 270 97C254 97 237 103 225 115C206 132 178 132 159 115C147 103 131 97 114 97C102 97 91 100 81 107C58 122 27 102 33 73ZM176 208V400C176 409 183 416 192 416S208 409 208 400V208C208 199 201 192 192 192S176 199 176 208ZM416 160H352C343 160 336 167 336 176V416C336 451 307 480 272 480H112C77 480 48 451 48 416V176C48 167 41 160 32 160S16 167 16 176V416C16 469 59 512 112 512H272C315 512 351 483 363 444L452 400C479 386 496 359 496 328V240C496 196 460 160 416 160ZM464 328C464 347 454 363 437 371L368 406V192H416C442 192 464 214 464 240V328ZM112 208V400C112 409 119 416 128 416S144 409 144 400V208C144 199 137 192 128 192S112 199 112 208Z"]
  };
  var faBeerMugEmpty = {
    prefix: 'fal',
    iconName: 'beer-mug-empty',
    icon: [512, 512, [], "f0fc", "M112 128C103 128 96 135 96 144V368C96 377 103 384 112 384S128 377 128 368V144C128 135 121 128 112 128ZM240 128C231 128 224 135 224 144V368C224 377 231 384 240 384S256 377 256 368V144C256 135 249 128 240 128ZM176 128C167 128 160 135 160 144V368C160 377 167 384 176 384S192 377 192 368V144C192 135 185 128 176 128ZM400 96H352V80C352 54 330 32 304 32H48C22 32 0 54 0 80V384C0 437 43 480 96 480H256C309 480 352 437 352 384V378L436 336C463 322 480 295 480 264V176C480 132 444 96 400 96ZM320 384C320 419 291 448 256 448H96C61 448 32 419 32 384V80C32 71 39 64 48 64H304C313 64 320 71 320 80V384ZM448 264C448 283 438 299 421 307L352 342V128H400C426 128 448 150 448 176V264Z"]
  };
  var faBell = {
    prefix: 'fal',
    iconName: 'bell',
    icon: [448, 512, [], "f0f3", "M433 335C405 308 384 280 384 186C384 106 321 41 240 34V16C240 7 233 0 224 0S208 7 208 16V34C127 41 64 106 64 186C64 280 43 308 15 335C1 348 -4 368 3 386C11 404 28 416 48 416H400C420 416 437 404 445 386C452 368 447 348 433 335ZM400 384H48C34 384 27 367 37 358C71 325 96 288 96 186C96 118 153 64 224 64S352 118 352 186C352 287 376 325 411 358C421 368 414 384 400 384ZM272 448C265 448 258 452 255 459C251 471 238 480 224 480S197 471 193 459C190 452 183 448 176 448H176C165 448 157 458 161 468C169 493 195 512 224 512C253 512 279 493 287 468C290 458 283 448 272 448Z"]
  };
  var faBellConcierge = {
    prefix: 'fal',
    iconName: 'bell-concierge',
    icon: [512, 512, [], "f562", "M48 384C57 384 64 377 64 368C64 262 150 176 256 176S448 262 448 368C448 377 455 384 464 384S480 377 480 368C480 250 388 153 272 145V96H304C313 96 320 89 320 80S313 64 304 64H208C199 64 192 71 192 80S199 96 208 96H240V145C124 153 32 250 32 368C32 377 39 384 48 384ZM496 416H16C7 416 0 423 0 432S7 448 16 448H496C505 448 512 441 512 432S505 416 496 416Z"]
  };
  var faBellExclamation = {
    prefix: 'fal',
    iconName: 'bell-exclamation',
    icon: [448, 512, [], "f848", "M272 448C265 448 258 452 255 459C251 471 238 480 224 480S197 471 193 459C190 452 183 448 176 448H176C165 448 157 458 161 468C169 493 195 512 224 512C253 512 279 493 287 468C290 458 283 448 272 448ZM433 335C405 308 384 280 384 186C384 106 321 41 240 34V16C240 7 233 0 224 0S208 7 208 16V34C127 41 64 106 64 186C64 280 43 308 15 335C1 348 -4 368 3 386C11 404 28 416 48 416H400C420 416 437 404 445 386C452 368 447 348 433 335ZM400 384H48C34 384 27 367 37 358C71 325 96 288 96 186C96 118 153 64 224 64S352 118 352 186C352 287 376 325 411 358C421 368 414 384 400 384ZM224 256C233 256 240 249 240 240V128C240 119 233 112 224 112S208 119 208 128V240C208 249 215 256 224 256ZM224 280C211 280 200 291 200 304C200 317 211 328 224 328S248 317 248 304C248 291 237 280 224 280Z"]
  };
  var faBellOn = {
    prefix: 'fal',
    iconName: 'bell-on',
    icon: [640, 512, [], "f8fa", "M41 30L105 62C107 63 110 64 112 64C119 64 126 59 128 52C129 45 126 37 119 34L55 2C47 -2 38 1 34 9C30 17 33 26 41 30ZM528 64C530 64 533 63 535 62L599 30C607 26 610 17 606 9C602 1 593 -2 585 2L521 34C514 37 511 44 512 52C514 59 521 64 528 64ZM80 160H16C7 160 0 167 0 176S7 192 16 192H80C89 192 96 185 96 176S89 160 80 160ZM624 160H560C551 160 544 167 544 176S551 192 560 192H624C633 192 640 185 640 176S633 160 624 160ZM368 448C361 448 354 452 351 459C347 471 334 480 320 480S293 471 289 459C286 452 279 448 272 448H272C261 448 253 458 257 468C265 493 291 512 320 512C349 512 375 493 383 468C386 458 379 448 368 448ZM480 186C480 106 417 41 336 34V16C336 7 329 0 320 0S304 7 304 16V34C223 41 160 106 160 186C160 280 139 308 111 335C97 348 92 368 99 386C107 404 124 416 144 416H496C516 416 533 404 541 386C548 368 543 348 529 335C501 308 480 280 480 186ZM496 384H144C130 384 123 367 133 358C167 325 192 288 192 186C192 118 249 64 320 64S448 118 448 186C448 287 472 325 507 358C517 368 510 384 496 384Z"]
  };
  var faBellPlus = {
    prefix: 'fal',
    iconName: 'bell-plus',
    icon: [448, 512, [], "f849", "M433 335C405 308 384 280 384 186C384 106 321 41 240 34V16C240 7 233 0 224 0S208 7 208 16V34C127 41 64 106 64 186C64 280 43 308 15 335C1 348 -4 368 3 386C11 404 28 416 48 416H400C420 416 437 404 445 386C452 368 447 348 433 335ZM400 384H48C34 384 27 367 37 358C71 325 96 288 96 186C96 118 153 64 224 64S352 118 352 186C352 287 376 325 411 358C421 368 414 384 400 384ZM272 448C265 448 258 452 255 459C251 471 238 480 224 480S197 471 193 459C190 452 183 448 176 448H176C165 448 157 458 161 468C169 493 195 512 224 512C253 512 279 493 287 468C290 458 283 448 272 448ZM288 224H240V176C240 167 233 160 224 160S208 167 208 176V224H160C151 224 144 231 144 240S151 256 160 256H208V304C208 313 215 320 224 320S240 313 240 304V256H288C297 256 304 249 304 240S297 224 288 224Z"]
  };
  var faBellSchool = {
    prefix: 'fal',
    iconName: 'bell-school',
    icon: [512, 512, [], "f5d5", "M464 352C438 352 416 374 416 400C416 420 429 437 446 445C441 465 422 480 400 480H352V358C400 312 426 244 413 169C398 87 332 20 250 4C117 -22 0 79 0 208C0 267 25 320 64 358V448C64 483 93 512 128 512H400C439 512 472 483 479 446C498 439 512 421 512 400C512 374 490 352 464 352ZM320 448C320 466 306 480 288 480H128C110 480 96 466 96 448V383C128 404 167 416 208 416S288 404 320 383V448ZM208 384C111 384 32 305 32 208S111 32 208 32S384 111 384 208S305 384 208 384ZM464 416C455 416 448 409 448 400S455 384 464 384S480 391 480 400S473 416 464 416ZM208 128C164 128 128 164 128 208S164 288 208 288S288 252 288 208S252 128 208 128ZM208 256C182 256 160 234 160 208S182 160 208 160S256 182 256 208S234 256 208 256Z"]
  };
  var faBellSchoolSlash = {
    prefix: 'fal',
    iconName: 'bell-school-slash',
    icon: [640, 512, [], "f5d6", "M272 32C369 32 448 111 448 208C448 229 444 249 438 267L464 288C479 252 484 212 477 169C462 87 396 20 314 4C253 -8 195 7 150 40L176 61C204 43 237 32 272 32ZM262 129L351 199C347 159 313 128 272 128C269 128 266 129 262 129ZM464 480H416V413L384 388V448C384 466 370 480 352 480H192C174 480 160 466 160 448V383C192 404 231 416 272 416C312 416 349 405 380 385L353 364C329 377 301 384 272 384C175 384 96 305 96 208C96 193 98 179 102 165L74 144C68 164 64 186 64 208C64 267 89 320 128 358V448C128 483 157 512 192 512H464C484 512 502 505 516 492L490 472C482 477 474 480 464 480ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483Z"]
  };
  var faBellSlash = {
    prefix: 'fal',
    iconName: 'bell-slash',
    icon: [640, 512, [], "f1f6", "M638 488C637 486 636 485 634 483L26 3C23 1 20 0 17 0C16 0 16 0 15 0C14 0 12 0 11 1C10 1 9 1 9 2C7 3 5 4 3 6C2 8 1 10 1 12C0 14 0 16 0 18C0 20 1 22 2 24C3 25 4 27 6 28L614 509C617 511 621 512 624 512C629 512 633 510 637 506C639 502 640 498 640 494C640 492 639 490 638 488ZM320 64C391 64 448 118 448 186C448 229 453 261 461 285C461 285 533 338 529 335C501 308 480 280 480 186C480 106 417 41 336 34V16C336 7 329 0 320 0S304 7 304 16V34C264 37 229 55 203 82L228 102C251 79 284 64 320 64ZM368 448C361 448 354 452 351 459C347 471 334 480 320 480S293 471 289 459C286 452 279 448 272 448H272C261 448 253 458 257 468C265 493 291 512 320 512C349 512 375 493 383 468C386 458 379 448 368 448ZM144 384C130 384 123 367 133 358C161 331 183 300 189 234L159 211C156 285 136 311 111 335C97 348 92 368 99 386C107 404 124 416 144 416H419L379 384H144Z"]
  };
  var faBells = {
    prefix: 'fal',
    iconName: 'bells',
    icon: [640, 512, [], "f77f", "M205 404C197 399 187 401 182 408C175 419 162 424 150 420C138 416 130 404 131 392C131 383 124 375 115 375C107 374 99 381 99 390C97 417 115 442 140 450C146 452 152 453 159 453C178 453 198 443 209 426C214 419 212 409 205 404ZM261 366L37 293C33 292 32 289 32 286C32 285 32 281 36 279L40 277C60 266 94 247 118 173C119 171 129 137 130 135C139 109 157 88 181 75C206 63 233 61 260 69C267 71 274 74 280 78C288 83 297 80 302 72C306 65 304 55 296 51C288 46 279 42 270 39C235 28 199 30 166 47C134 63 111 91 100 125C99 127 88 162 87 164C67 225 41 239 24 249L20 251C7 258 -1 274 0 289C2 305 12 318 27 323L251 396C253 397 254 397 256 397C263 397 269 393 271 386C274 377 269 368 261 366ZM618 275L615 274C597 265 570 252 548 190C547 187 535 155 534 153C509 83 431 47 361 72C327 85 300 109 285 142C269 175 268 211 280 245C281 247 294 281 294 283C316 344 305 371 297 389L295 393C289 407 292 424 303 435C310 444 321 448 331 448C336 448 341 447 345 446L614 348C629 343 639 329 640 313C641 297 633 283 618 275ZM603 318L334 415C330 417 328 415 326 414C325 413 323 410 324 405L326 401C335 380 351 345 324 272C323 269 311 236 310 234C301 208 302 180 314 156C325 131 346 112 372 102C383 98 395 96 407 96C449 96 489 122 504 164C505 165 517 200 518 202C545 275 580 292 601 302L604 304C607 305 608 308 608 311C608 313 606 317 603 318ZM534 400C525 401 519 409 520 417C521 430 513 442 501 446C489 451 476 446 468 436C463 429 453 427 446 432C439 437 437 447 442 455C454 471 473 480 492 480C499 480 505 479 512 476C537 467 554 442 551 415C551 406 543 399 534 400Z"]
  };
  var faBezierCurve = {
    prefix: 'fal',
    iconName: 'bezier-curve',
    icon: [640, 512, [], "f55b", "M576 208C611 208 640 179 640 144C640 109 611 80 576 80C546 80 521 100 514 128H400V112C400 86 378 64 352 64H288C262 64 240 86 240 112V128H126C119 100 94 80 64 80C29 80 0 109 0 144C0 179 29 208 64 208C94 208 119 188 126 160H205C158 188 122 234 105 288H80C54 288 32 310 32 336V400C32 426 54 448 80 448H144C170 448 192 426 192 400V336C192 310 170 288 144 288H139C157 239 193 199 240 178C241 203 262 224 288 224H352C378 224 399 203 400 178C447 199 483 239 501 288H496C470 288 448 310 448 336V400C448 426 470 448 496 448H560C586 448 608 426 608 400V336C608 310 586 288 560 288H535C518 234 482 188 435 160H514C521 188 546 208 576 208ZM576 112C594 112 608 126 608 144S594 176 576 176S544 162 544 144S558 112 576 112ZM64 176C46 176 32 162 32 144S46 112 64 112S96 126 96 144S82 176 64 176ZM144 320C153 320 160 327 160 336V400C160 409 153 416 144 416H80C71 416 64 409 64 400V336C64 327 71 320 80 320H144ZM368 176C368 185 361 192 352 192H288C279 192 272 185 272 176V112C272 103 279 96 288 96H352C361 96 368 103 368 112V176ZM560 320C569 320 576 327 576 336V400C576 409 569 416 560 416H496C487 416 480 409 480 400V336C480 327 487 320 496 320H560Z"]
  };
  var faBicycle = {
    prefix: 'fal',
    iconName: 'bicycle',
    icon: [640, 512, [], "f206", "M512 224C496 224 481 227 467 233L366 41C363 35 358 32 352 32H304C295 32 288 39 288 48S295 64 304 64H342L393 160H226L189 103C187 99 181 96 176 96H112C103 96 96 103 96 112S103 128 112 128H167L202 182L175 233C160 227 145 224 128 224C57 224 0 281 0 352C0 423 57 480 128 480C193 480 246 431 254 368H320C326 368 331 365 334 360L417 207L439 247C406 270 384 309 384 352C384 423 441 480 512 480C583 480 640 423 640 352C640 281 583 224 512 224ZM128 448C75 448 32 405 32 352C32 299 75 256 128 256C139 256 149 258 159 262L114 344C108 355 116 368 128 368H222C215 413 175 448 128 448ZM155 336L222 213L301 336H155ZM324 312L246 192H389L324 312ZM512 448C459 448 416 405 416 352C416 321 431 294 454 276L498 359C508 378 536 364 526 345L482 261C492 258 502 256 512 256C565 256 608 299 608 352C608 405 565 448 512 448Z"]
  };
  var faBinoculars = {
    prefix: 'fal',
    iconName: 'binoculars',
    icon: [512, 512, [], "f1e5", "M112 64H208C217 64 224 57 224 48S217 32 208 32H112C103 32 96 39 96 48S103 64 112 64ZM304 64H400C409 64 416 57 416 48S409 32 400 32H304C295 32 288 39 288 48S295 64 304 64ZM512 404C508 274 451 222 448 128C448 110 434 96 416 96H96C78 96 64 110 64 128C61 222 4 274 0 404L0 432C0 458 22 480 48 480H176C202 480 224 458 224 432V288H288V432C288 458 310 480 336 480H464C490 480 512 458 512 432L512 404ZM192 432C192 441 185 448 176 448H48C39 448 32 441 32 432L32 405C34 340 50 296 66 254C80 216 95 177 96 128H192V432ZM288 256H224V128H288V256ZM464 448H336C327 448 320 441 320 432V128H416L416 129C417 177 432 216 446 254C462 296 478 340 480 404L480 432C480 441 473 448 464 448Z"]
  };
  var faBiohazard = {
    prefix: 'fal',
    iconName: 'biohazard',
    icon: [576, 512, [], "f780", "M288 248C275 248 264 259 264 272C264 285 275 296 288 296S312 285 312 272C312 259 301 248 288 248ZM288 96C306 96 323 99 339 104C346 95 350 85 352 74C332 68 310 64 288 64C266 64 244 68 224 74C226 85 231 95 237 104C253 99 270 96 288 96ZM407 401C413 410 420 418 430 424C463 393 485 352 493 306C484 301 473 298 463 298C462 298 462 299 462 299C456 339 436 375 407 401ZM575 277C561 236 533 202 497 181C485 174 472 168 457 165C461 151 463 137 463 124C463 82 447 41 420 8C413 0 400 -3 390 3C381 9 376 21 380 31C384 42 385 53 385 62C385 117 342 161 288 161C234 161 191 117 191 62C191 53 193 42 196 31C200 20 195 9 186 3C176 -2 163 0 156 8C129 41 113 82 113 124C113 137 115 151 119 165C104 169 91 174 79 181C43 202 15 236 1 277C-2 287 2 299 12 305C21 310 34 308 41 300C49 291 57 284 65 280C87 266 113 263 138 270C163 276 184 293 198 316C224 363 208 424 162 452C154 456 144 460 133 462C122 465 114 474 114 486S122 507 133 509C144 511 155 512 166 512C197 512 227 504 253 488C266 481 277 472 288 461C299 472 310 481 323 488C359 510 401 517 443 509C454 507 461 497 462 486C462 474 454 465 443 462C432 460 422 456 414 452C367 424 351 363 378 316C391 293 412 276 438 270C463 263 489 266 511 280C519 284 527 291 535 300C542 308 555 310 564 305C574 299 578 287 575 277ZM430 239C396 248 368 270 351 300C315 363 336 443 398 479C398 479 398 479 398 479C377 478 357 471 339 461C325 452 312 441 301 427L288 411L276 427C264 441 251 452 237 461C219 471 199 478 178 479C178 479 178 479 178 479C240 443 261 363 226 300C208 270 180 248 146 239C135 236 124 234 113 234C91 234 69 240 49 252C61 234 77 220 95 209C109 201 124 195 142 192L160 189L154 171C148 155 145 139 145 124C145 103 150 82 159 63C159 135 217 193 288 193C359 193 417 135 417 63C426 82 431 103 431 124C431 139 428 154 422 171L416 189L435 192C452 195 468 201 481 209C500 220 515 234 527 252C497 235 463 230 430 239ZM169 401C140 374 121 339 114 298C114 298 114 298 113 298C103 298 92 301 83 306C91 352 114 393 146 424C156 418 163 410 169 401Z"]
  };
  var faBitcoinSign = {
    prefix: 'fal',
    iconName: 'bitcoin-sign',
    icon: [320, 512, [], "e0a4", "M253 234C274 216 288 190 288 160C288 107 245 64 192 64V16C192 7 185 0 176 0S160 7 160 16V64H96V16C96 7 89 0 80 0S64 7 64 16V64H16C7 64 0 71 0 80V432C0 441 7 448 16 448H64V496C64 505 71 512 80 512S96 505 96 496V448H160V496C160 505 167 512 176 512S192 505 192 496V448H208C270 448 320 398 320 336C320 290 292 251 253 234ZM32 96H192C227 96 256 125 256 160S227 224 192 224H32V96ZM208 416H32V256H208C252 256 288 292 288 336S252 416 208 416Z"]
  };
  var faBlanket = {
    prefix: 'fal',
    iconName: 'blanket',
    icon: [448, 512, [], "f498", "M392 368H96C87 368 80 375 80 384S87 400 96 400H392C423 400 448 375 448 344V112C448 68 412 32 368 32H80C36 32 0 68 0 112V384C0 437 43 480 96 480H432C441 480 448 473 448 464S441 448 432 448H96C61 448 32 419 32 384S61 320 96 320H392C405 320 416 331 416 344S405 368 392 368ZM392 288H96C71 288 49 298 32 313V112C32 86 54 64 80 64H368C394 64 416 86 416 112V294C409 290 401 288 392 288Z"]
  };
  var faBlender = {
    prefix: 'fal',
    iconName: 'blender',
    icon: [512, 512, [], "f517", "M288 400C275 400 264 411 264 424S275 448 288 448S312 437 312 424S301 400 288 400ZM471 0H48C22 0 0 22 0 48V208C0 234 22 256 48 256H150L158 342C122 356 96 391 96 432V480C96 498 110 512 128 512H448C466 512 480 498 480 480V432C480 393 456 359 422 344L502 40C507 20 492 0 471 0ZM48 224C39 224 32 217 32 208V48C32 39 39 32 48 32H131L147 224H48ZM448 432V480H128V432C128 397 157 368 192 368H384C419 368 448 397 448 432ZM454 96H304C295 96 288 103 288 112S295 128 304 128H446L429 192H304C295 192 288 199 288 208S295 224 304 224H421L391 336H189L163 32H471L454 96Z"]
  };
  var faBlenderPhone = {
    prefix: 'fal',
    iconName: 'blender-phone',
    icon: [576, 512, [], "f6b6", "M535 0H227C208 0 193 16 195 35L222 343C186 356 160 391 160 432V480C160 498 174 512 192 512H512C530 512 544 498 544 480V432C544 393 520 359 486 344L566 40C571 20 556 0 535 0ZM512 432V480H192V432C192 397 221 368 256 368H448C483 368 512 397 512 432ZM518 96H368C359 96 352 103 352 112S359 128 368 128H510L493 192H368C359 192 352 199 352 208S359 224 368 224H485L455 336H253L227 32H535L518 96ZM176 317L153 259C148 246 135 238 121 240L92 243C82 210 82 175 92 142L121 144C134 146 148 138 153 125L176 67C182 53 177 37 164 29L128 7C108 -5 83 -1 67 16C-23 118 -22 270 69 370C78 379 90 384 103 384C112 384 120 382 128 377L164 355C177 347 182 331 176 317ZM111 350C106 353 97 353 93 349C12 260 12 127 91 38C95 34 99 32 103 32C106 32 109 33 111 34L147 55L124 113L70 107L66 119C48 166 48 218 66 265L70 277L123 271L146 328L111 350ZM352 400C339 400 328 411 328 424S339 448 352 448S376 437 376 424S365 400 352 400Z"]
  };
  var faBlinds = {
    prefix: 'fal',
    iconName: 'blinds',
    icon: [512, 512, [], "f8fb", "M496 0H16C7 0 0 7 0 16V80C0 89 7 96 16 96H128V192H37L48 148C50 138 42 128 32 128H32C25 128 18 133 16 140L1 204C-2 214 5 224 16 224H128V259C114 264 104 274 99 288H37L40 276C42 266 34 256 24 256C17 256 10 261 8 268L1 300C-2 310 5 320 16 320H99C108 346 138 360 165 348C175 343 183 335 188 325C200 298 186 268 160 259V96H496C505 96 512 89 512 80V16C512 7 505 0 496 0ZM144 320C135 320 128 313 128 304S135 288 144 288S160 295 160 304S153 320 144 320ZM480 64H32V32H480V64ZM504 460C502 453 495 448 488 448C478 448 470 458 472 468L475 480H37L40 468C42 458 34 448 24 448C17 448 10 453 8 460L1 492C-2 502 5 512 16 512H496C507 512 514 502 511 492L504 460ZM504 364C502 357 495 352 488 352C478 352 470 362 472 372L475 384H37L40 372C42 362 34 352 24 352C17 352 10 357 8 364L1 396C-2 406 5 416 16 416H496C507 416 514 406 511 396L504 364ZM496 140C494 133 487 128 480 128H480C470 128 462 138 464 148L475 192H192V224H496C507 224 514 214 511 204L496 140ZM504 268C502 261 495 256 488 256C478 256 470 266 472 276L475 288H222C224 298 224 310 222 320H496C507 320 514 310 511 300L504 268Z"]
  };
  var faBlindsOpen = {
    prefix: 'fal',
    iconName: 'blinds-open',
    icon: [512, 512, [], "f8fc", "M496 480H16C7 480 0 487 0 496S7 512 16 512H496C505 512 512 505 512 496S505 480 496 480ZM16 352H80C73 343 68 332 66 320H16C7 320 0 327 0 336S7 352 16 352ZM496 320H222C220 332 215 343 208 352H496C505 352 512 345 512 336S505 320 496 320ZM496 0H16C7 0 0 7 0 16V80C0 89 7 96 16 96H128V160H16C7 160 0 167 0 176S7 192 16 192H128V259C106 267 93 289 97 312C101 335 121 352 144 352S187 335 191 312C195 289 182 267 160 259V96H496C505 96 512 89 512 80V16C512 7 505 0 496 0ZM144 320C135 320 128 313 128 304S135 288 144 288S160 295 160 304S153 320 144 320ZM480 64H32V32H480V64ZM496 160H192V192H496C505 192 512 185 512 176S505 160 496 160Z"]
  };
  var faBlindsRaised = {
    prefix: 'fal',
    iconName: 'blinds-raised',
    icon: [512, 512, [], "f8fd", "M496 0H16C7 0 0 7 0 16V80C0 89 7 96 16 96H128V160H37L40 148C42 138 34 128 24 128C17 128 10 133 9 140L1 172C-2 182 5 192 16 192H128V256H37L40 244C42 234 34 224 24 224C17 224 10 229 9 236L1 268C-2 278 5 288 16 288H128V419C106 427 93 449 97 472C101 495 121 512 144 512S187 495 191 472C195 449 182 427 160 419V96H496C505 96 512 89 512 80V16C512 7 505 0 496 0ZM144 480C135 480 128 473 128 464S135 448 144 448S160 455 160 464S153 480 144 480ZM480 64H32V32H480V64ZM504 236C502 229 495 224 488 224C478 224 470 234 472 244L476 256H192V288H496C507 288 514 278 511 268L504 236ZM504 140C502 133 495 128 488 128C478 128 470 138 472 148L476 160H192V192H496C507 192 514 182 511 172L504 140Z"]
  };
  var faBlog = {
    prefix: 'fal',
    iconName: 'blog',
    icon: [512, 512, [], "f781", "M160 224C151 224 144 231 144 240S151 256 160 256C213 256 256 299 256 352S213 448 160 448S64 405 64 352V112C64 103 57 96 48 96S32 103 32 112V352C32 423 89 480 160 480S288 423 288 352S231 224 160 224ZM208 32C199 32 192 39 192 48S199 64 208 64C340 64 448 172 448 304C448 313 455 320 464 320S480 313 480 304C480 154 358 32 208 32ZM208 128C199 128 192 135 192 144S199 160 208 160C287 160 352 225 352 304C352 313 359 320 368 320S384 313 384 304C384 207 305 128 208 128Z"]
  };
  var faBold = {
    prefix: 'fal',
    iconName: 'bold',
    icon: [384, 512, [], "f032", "M292 244C319 222 336 189 336 152C336 86 282 32 216 32H16C7 32 0 39 0 48S7 64 16 64H32V448H16C7 448 0 455 0 464S7 480 16 480H264C330 480 384 426 384 360C384 304 345 257 292 244ZM216 64C265 64 304 103 304 152S265 240 216 240H64V64H216ZM264 448H64V272H264C313 272 352 311 352 360S313 448 264 448Z"]
  };
  var faBolt = {
    prefix: 'fal',
    iconName: 'bolt',
    icon: [448, 512, [], "f0e7", "M384 160H239L286 44C294 23 279 0 256 0H96C80 0 67 12 64 27L32 251C30 271 45 288 64 288H214L161 471C156 489 168 512 192 512C202 512 213 507 219 498L411 210C425 188 409 160 384 160ZM192 480L256 256L64 256L96 32H256L192 192H384L192 480Z"]
  };
  var faBomb = {
    prefix: 'fal',
    iconName: 'bomb',
    icon: [512, 512, [], "f1e2", "M208 160C129 160 64 225 64 304C64 313 71 320 80 320S96 313 96 304C96 242 146 192 208 192C217 192 224 185 224 176S217 160 208 160ZM390 144L403 131C410 125 410 115 403 109C397 102 387 102 381 109L368 122L333 86C328 82 323 80 317 80S306 82 302 86L280 109C257 101 233 96 208 96C93 96 0 189 0 304S93 512 208 512S416 419 416 304C416 279 411 255 403 232L426 210C434 201 434 188 426 179L390 144ZM384 304C384 401 305 480 208 480S32 401 32 304S111 128 208 128C242 128 264 137 288 146L317 116L396 195L366 224C375 250 384 270 384 304ZM496 48H464V16C464 7 457 0 448 0S432 7 432 16V48H400C391 48 384 55 384 64S391 80 400 80H432V112C432 121 439 128 448 128S464 121 464 112V80H496C505 80 512 73 512 64S505 48 496 48Z"]
  };
  var faBone = {
    prefix: 'fal',
    iconName: 'bone',
    icon: [576, 512, [], "f5d7", "M537 256C565 238 576 212 576 179C576 133 538 96 491 96C455 96 422 119 411 153C403 175 404 176 392 176H184C172 176 173 175 165 153C154 119 121 96 85 96C38 96 0 133 0 179C0 212 11 238 39 256C11 274 0 300 0 333C0 379 38 416 85 416C121 416 154 393 165 359C173 337 172 336 184 336H392C404 336 403 337 411 359C422 393 455 416 491 416C538 416 576 379 576 333C576 300 565 274 537 256ZM491 384C468 384 448 370 441 349C432 322 425 304 392 304H184C151 304 144 322 135 349C128 370 108 384 85 384C56 384 32 361 32 333C32 310 39 291 61 281V281C71 276 77 266 77 256S71 236 61 231V231C39 221 32 202 32 179C32 151 56 128 85 128C108 128 128 142 135 163C144 190 151 208 184 208H392C425 208 432 190 441 163C448 142 468 128 491 128C520 128 544 151 544 179C544 202 537 221 515 231V231C505 236 499 246 499 256S505 276 515 281V281C537 291 544 310 544 333C544 361 520 384 491 384Z"]
  };
  var faBoneBreak = {
    prefix: 'fal',
    iconName: 'bone-break',
    icon: [640, 512, [], "f5d8", "M278 359L209 378C177 385 173 405 170 433C168 455 151 473 129 478C101 485 72 467 66 440C61 416 64 397 83 382L83 382C92 375 96 364 93 354C91 343 83 335 73 333L73 333C49 327 38 311 33 288C27 260 45 232 74 226C96 221 119 230 130 249C145 274 156 290 188 283L274 264C282 262 288 253 286 245C284 236 276 230 267 232L181 251C170 254 170 253 158 232C139 202 102 186 67 194C21 204 -8 249 2 294C9 327 25 351 57 362C33 386 28 414 35 446C45 492 90 520 136 510C171 502 198 472 202 436C205 413 204 412 215 409L285 390C294 388 299 380 298 371C296 362 287 357 278 359ZM573 194C538 186 501 202 482 232C470 253 470 254 459 251L373 232C364 230 356 236 354 245C352 253 358 262 366 264L452 283C484 290 495 274 510 249C521 230 544 221 566 226C595 232 613 260 607 288C602 311 591 327 567 333L567 333C557 335 549 343 547 354C544 364 548 375 557 382L557 382C576 397 579 416 574 440C567 467 539 485 511 478C489 473 472 455 470 433C467 405 463 385 431 378L362 359C353 357 344 362 342 371V371C340 380 346 388 355 390L424 409C436 412 435 413 438 437C442 472 469 502 504 510C550 520 595 492 605 446C612 414 607 386 583 362C615 351 631 327 638 294C648 249 619 204 573 194ZM320 0C311 0 304 7 304 16V112C304 121 311 128 320 128S336 121 336 112V16C336 7 329 0 320 0ZM229 155C232 158 236 160 240 160S248 158 251 155C258 149 258 139 251 133L187 69C181 62 171 62 165 69S158 85 165 91L229 155ZM400 160C404 160 408 158 411 155L475 91C482 85 482 75 475 69S459 62 453 69L389 133C382 139 382 149 389 155C392 158 396 160 400 160Z"]
  };
  var faBong = {
    prefix: 'fal',
    iconName: 'bong',
    icon: [512, 512, [], "f55c", "M475 229L411 165C405 158 395 158 389 165S382 181 389 187L409 208L364 253C351 239 337 227 320 218V80C320 71 313 64 304 64S288 71 288 80V236L304 246C334 263 357 289 370 320H78C91 289 114 263 144 246L160 236V80C160 71 153 64 144 64S128 71 128 80V218C71 251 32 313 32 384C32 427 46 467 70 499C76 506 87 512 96 512H352C361 512 372 506 378 499C402 467 416 427 416 384C416 345 404 309 384 279L432 231L453 251C459 258 469 258 475 251C482 245 482 235 475 229ZM352 480H97C75 452 64 419 64 384C64 373 66 362 68 352H380C382 362 384 373 384 384C384 419 373 453 352 480ZM112 32H336C345 32 352 25 352 16V16C352 7 345 0 336 0H112C103 0 96 7 96 16V16C96 25 103 32 112 32Z"]
  };
  var faBook = {
    prefix: 'fal',
    iconName: 'book',
    icon: [448, 512, [], "f02d", "M448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM32 80C32 54 54 32 80 32H96V384H64C52 384 41 387 32 393V80ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H128V32H400C409 32 416 39 416 48V368C416 377 409 384 400 384ZM352 128H192C183 128 176 135 176 144S183 160 192 160H352C361 160 368 153 368 144S361 128 352 128ZM352 224H192C183 224 176 231 176 240S183 256 192 256H352C361 256 368 249 368 240S361 224 352 224Z"]
  };
  var faBookAtlas = {
    prefix: 'fal',
    iconName: 'book-atlas',
    icon: [448, 512, [], "f558", "M224 80C153 80 96 137 96 208S153 336 224 336S352 279 352 208S295 80 224 80ZM130 224H169C170 251 175 275 183 294C155 281 135 255 130 224ZM169 192H130C135 161 155 135 183 122C175 141 170 165 169 192ZM224 303C216 295 203 268 201 224H247C245 268 232 295 224 303ZM201 192C203 148 216 121 224 113C232 121 245 148 247 192H201ZM265 294C273 275 278 251 279 224H318C313 255 293 281 265 294ZM279 192C278 165 273 141 265 122C293 135 313 161 318 192H279ZM448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384Z"]
  };
  var faBookBible = {
    prefix: 'fal',
    iconName: 'book-bible',
    icon: [448, 512, [], "f647", "M448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384ZM304 144H240V80C240 71 233 64 224 64S208 71 208 80V144H144C135 144 128 151 128 160S135 176 144 176H208V304C208 313 215 320 224 320S240 313 240 304V176H304C313 176 320 169 320 160S313 144 304 144Z"]
  };
  var faBookBlank = {
    prefix: 'fal',
    iconName: 'book-blank',
    icon: [448, 512, [], "f5d9", "M448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM32 80C32 54 54 32 80 32H96V384H64C52 384 41 387 32 393V80ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H128V32H400C409 32 416 39 416 48V368C416 377 409 384 400 384Z"]
  };
  var faBookFont = {
    prefix: 'fal',
    iconName: 'book-font',
    icon: [448, 512, [], "e0a5", "M448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384ZM238 105C233 94 215 94 210 105L114 297C110 305 113 314 121 318C129 322 138 319 142 311L170 256H278L306 311C309 317 314 320 320 320C322 320 325 319 327 318C335 314 338 305 334 297L238 105ZM186 224L224 148L262 224H186Z"]
  };
  var faBookHeart = {
    prefix: 'fal',
    iconName: 'book-heart',
    icon: [448, 512, [], "f499", "M224 140C181 97 148 114 134 125C106 148 105 189 130 214L214 300C220 305 228 305 234 300L319 214C343 189 342 148 314 125C300 114 267 97 224 140ZM296 192L224 264L152 192C142 181 140 162 154 150C168 138 185 146 193 154L224 185L255 154C263 146 280 138 294 150C308 162 306 181 296 192ZM448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384Z"]
  };
  var faBookJournalWhills = {
    prefix: 'fal',
    iconName: 'book-journal-whills',
    icon: [448, 512, [], "f66a", "M308 85C303 83 297 83 294 87C290 91 289 97 292 102C308 128 302 162 278 181C276 183 274 186 274 190C274 193 275 196 277 198C290 212 295 231 290 249S270 281 252 285V259L258 266C261 269 266 269 270 266S273 258 270 254L259 244H272C276 244 280 240 280 236S276 228 272 228H259L270 218C273 214 273 210 270 206S262 203 258 206L252 213V84C252 77 247 72 240 72S228 77 228 84V213L222 206C218 203 214 203 210 206S207 214 210 218L221 228H208C204 228 200 232 200 236S204 244 208 244H221L210 254C207 258 207 262 210 266S219 269 222 266L228 259V285C210 281 195 267 190 249S190 212 202 198C205 196 206 193 206 190C206 186 204 183 201 181C177 162 172 128 188 102C189 100 190 98 190 96C190 93 189 90 186 87C183 83 177 83 172 85C127 110 100 157 100 207C100 284 163 347 240 347S380 284 380 207C380 157 352 110 308 85ZM330 198C334 201 338 201 342 198L354 185C355 193 356 200 356 207C356 212 355 216 354 221L331 242C329 244 327 247 328 250C329 252 331 255 333 256C336 256 339 256 341 254L348 248C331 292 290 323 240 323S149 292 132 248L139 254C142 257 147 257 150 253C151 252 152 250 152 247S151 243 149 242L126 221C125 216 124 212 124 207C124 200 125 193 126 185L138 198C142 201 146 201 150 198S153 190 150 186L131 168C137 153 145 140 155 129C155 130 155 132 155 134C155 155 163 176 178 191C156 223 161 266 190 291C218 317 262 317 290 291C319 266 324 223 302 191C317 176 325 155 325 134C325 132 325 130 325 129C335 140 343 153 349 168L330 186C327 190 327 194 330 198ZM448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384Z"]
  };
  var faBookMedical = {
    prefix: 'fal',
    iconName: 'book-medical',
    icon: [448, 512, [], "f7e6", "M448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384ZM320 160H272V112C272 103 265 96 256 96H224C215 96 208 103 208 112V160H160C151 160 144 167 144 176V208C144 217 151 224 160 224H208V272C208 281 215 288 224 288H256C265 288 272 281 272 272V224H320C329 224 336 217 336 208V176C336 167 329 160 320 160Z"]
  };
  var faBookOpen = {
    prefix: 'fal',
    iconName: 'book-open',
    icon: [576, 512, [], "f518", "M541 57C495 40 451 33 411 32C352 33 309 50 288 60C267 50 224 33 165 32C125 32 80 40 35 57C14 64 0 84 0 107V410C0 424 7 438 19 446C31 455 46 457 60 453C178 417 269 472 274 475C278 478 281 480 288 480C295 480 298 478 302 475C313 469 400 418 516 453C530 457 545 455 557 446C569 438 576 424 576 410V107C576 84 562 64 541 57ZM272 438C247 426 201 409 142 409C114 409 83 413 50 422C46 424 41 423 38 420C34 418 32 414 32 410V107C32 98 38 90 46 87C88 72 128 64 164 64C216 65 254 79 272 88V438ZM544 410C544 414 542 418 538 420C535 423 530 424 526 423C424 392 341 420 304 438V88C322 79 360 65 411 64C447 64 488 71 530 87H530C538 90 544 98 544 107V410Z"]
  };
  var faBookOpenCover = {
    prefix: 'fal',
    iconName: 'book-open-cover',
    icon: [640, 512, [], "e0a6", "M89 398L306 446C311 447 315 448 320 448S329 447 334 446L551 398C566 395 576 382 576 367V40C576 17 558 0 537 0C536 0 536 0 536 0C533 0 523 2 320 33C117 2 107 0 104 0C104 0 104 0 103 0C82 0 64 17 64 40V367C64 382 74 395 89 398ZM336 63L454 45C510 36 531 33 537 32H537C540 32 544 35 544 40L544 367L336 413V63ZM96 40C96 37 97 35 98 34C99 33 100 32 103 32C109 33 130 36 186 45L304 63V413L96 367V40ZM624 32C615 32 608 39 608 48V384C608 406 592 426 569 431L320 480L71 431C48 426 32 406 32 384V48C32 39 25 32 16 32S0 39 0 48V384C0 422 27 455 65 462L317 512C318 512 319 512 320 512S322 512 323 512L575 462C613 455 640 422 640 384V48C640 39 633 32 624 32Z"]
  };
  var faBookOpenReader = {
    prefix: 'fal',
    iconName: 'book-open-reader',
    icon: [512, 512, [], "f5da", "M460 192C459 192 458 192 458 192C408 195 317 205 256 240C195 205 104 195 54 192C54 192 53 192 52 192C32 192 0 206 0 242V420C0 447 21 469 48 470C83 472 169 479 225 508C230 510 235 511 240 512V512H242C242 512 242 512 242 512H270C270 512 270 512 270 512H272V512C277 511 282 510 287 508C343 479 429 472 464 470C491 469 512 447 512 420V242C512 206 480 192 460 192ZM240 479C240 479 240 479 240 479C180 449 95 441 50 438C40 438 32 430 32 420V242C32 236 34 232 38 229C42 226 48 224 52 224C89 226 182 235 240 267V479ZM480 420C480 430 472 438 462 438C417 441 332 449 272 479C272 479 272 479 272 479V267C330 235 423 226 459 224H460C460 224 480 225 480 242V420ZM256 192C309 192 352 149 352 96S309 0 256 0S160 43 160 96S203 192 256 192ZM256 32C291 32 320 61 320 96S291 160 256 160S192 131 192 96S221 32 256 32Z"]
  };
  var faBookQuran = {
    prefix: 'fal',
    iconName: 'book-quran',
    icon: [448, 512, [], "f687", "M368 0H48C22 0 0 22 0 48V368C0 389 13 406 32 413V480H16C7 480 0 487 0 496S7 512 16 512H384C419 512 448 483 448 448V80C448 36 412 0 368 0ZM384 480H64V416H384C402 416 416 430 416 448S402 480 384 480ZM416 393C407 387 396 384 384 384H48C39 384 32 377 32 368V48C32 39 39 32 48 32H368C394 32 416 54 416 80V393ZM354 179L331 176L321 155C316 144 298 144 293 155L282 176L260 179C254 180 249 184 247 190C245 196 247 202 251 207L267 223L263 245C262 251 265 257 270 261C275 264 281 265 287 262L307 251L327 262C333 265 339 264 344 261C349 257 352 251 351 245L347 222L363 206C367 202 369 196 367 190C365 184 360 180 354 179ZM323 214L327 236L307 225L287 236L291 214L275 198L297 195L307 175L317 195L339 198L323 214ZM284 294L280 294C234 294 197 257 197 211C197 166 234 128 280 128L284 129C293 129 301 122 303 114C305 104 299 95 291 92C276 87 261 84 246 84C176 84 119 141 119 211S176 338 246 338C261 338 276 336 290 330C298 328 303 321 303 313C303 302 295 294 284 294ZM143 211C143 154 189 108 246 108C248 108 250 108 252 108C206 121 173 162 173 211C173 260 206 302 252 314C193 318 143 270 143 211Z"]
  };
  var faBookSkull = {
    prefix: 'fal',
    iconName: 'book-skull',
    icon: [448, 512, [], "f6b7", "M248 160C257 160 264 153 264 144S257 128 248 128S232 135 232 144S239 160 248 160ZM200 160C209 160 216 153 216 144S209 128 200 128S184 135 184 144S191 160 200 160ZM160 203V216C160 229 171 240 184 240H264C277 240 288 229 288 216V203C308 188 320 167 320 144C320 100 277 64 224 64S128 100 128 144C128 167 140 188 160 203ZM224 96C259 96 288 118 288 144C288 158 279 172 264 181L256 186V208H192V186L184 181C169 172 160 158 160 144C160 118 189 96 224 96ZM448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384ZM351 251C348 242 339 238 331 241L224 279L117 241C109 238 100 242 97 251C94 259 98 268 107 271L176 296L107 321C98 324 94 333 97 341C99 348 105 352 112 352C114 352 116 352 117 351L224 313L331 351C332 352 334 352 336 352C343 352 349 348 351 341C354 333 350 324 341 321L272 296L341 271C350 268 354 259 351 251Z"]
  };
  var faBookSparkles = {
    prefix: 'fal',
    iconName: 'book-sparkles',
    icon: [448, 512, [], "f6b8", "M448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384ZM352 224H304V176C304 167 297 160 288 160S272 167 272 176V224H224C215 224 208 231 208 240S215 256 224 256H272V304C272 313 279 320 288 320S304 313 304 304V256H352C361 256 368 249 368 240S361 224 352 224ZM224 128C224 119 217 112 208 112H176V80C176 71 169 64 160 64S144 71 144 80V112H112C103 112 96 119 96 128S103 144 112 144H144V176C144 185 151 192 160 192S176 185 176 176V144H208C217 144 224 137 224 128Z"]
  };
  var faBookTanakh = {
    prefix: 'fal',
    iconName: 'book-tanakh',
    icon: [448, 512, [], "f827", "M368 0H48C22 0 0 22 0 48V368C0 389 13 406 32 413V480H16C7 480 0 487 0 496S7 512 16 512H384C419 512 448 483 448 448V80C448 36 412 0 368 0ZM384 480H64V416H384C402 416 416 430 416 448S402 480 384 480ZM416 393C407 387 396 384 384 384H48C39 384 32 377 32 368V48C32 39 39 32 48 32H368C394 32 416 54 416 80V393ZM315 208L342 162C346 156 346 148 342 142C339 135 332 131 325 131H269L241 85C237 79 231 75 224 75C217 75 210 79 207 85L179 131H123C116 131 109 135 105 142C102 148 102 155 106 162L133 208L106 254C102 261 102 268 106 274C109 281 116 285 123 285H179L207 331C210 337 217 340 224 340C231 340 238 337 241 331L269 284H325C332 285 339 281 343 274C346 268 346 260 342 254L315 208ZM318 155L301 185L283 156L318 155ZM224 103L241 131H207L224 103ZM130 155H165L147 185L130 155ZM130 261L147 231L165 261H130ZM224 313L207 285H241L224 313ZM255 261H193L161 208L193 155H255L287 208L255 261ZM283 261L301 231L318 261H283Z"]
  };
  var faBookUser = {
    prefix: 'fal',
    iconName: 'book-user',
    icon: [448, 512, [], "f7e7", "M448 368V48C448 22 426 0 400 0H80C36 0 0 36 0 80V448C0 483 29 512 64 512H432C441 512 448 505 448 496S441 480 432 480H416V413C435 406 448 389 448 368ZM384 480H64C46 480 32 466 32 448S46 416 64 416H384V480ZM400 384H64C52 384 41 387 32 393V80C32 54 54 32 80 32H400C409 32 416 39 416 48V368C416 377 409 384 400 384ZM256 240H192C148 240 112 276 112 320C112 329 119 336 128 336S144 329 144 320C144 294 166 272 192 272H256C282 272 304 294 304 320C304 329 311 336 320 336S336 329 336 320C336 276 300 240 256 240ZM224 208C259 208 288 179 288 144S259 80 224 80S160 109 160 144S189 208 224 208ZM224 112C242 112 256 126 256 144S242 176 224 176S192 162 192 144S206 112 224 112Z"]
  };
  var faBookmark = {
    prefix: 'fal',
    iconName: 'bookmark',
    icon: [384, 512, [], "f02e", "M320 0H64C29 0 0 29 0 64V496C0 502 3 507 8 510C13 513 20 513 25 509L192 403L359 510C362 511 365 512 368 512C371 512 373 511 376 510C381 507 384 502 384 496V64C384 29 355 0 320 0ZM352 467L201 370C198 369 195 368 192 368S186 369 183 370L32 467V64C32 46 46 32 64 32H320C338 32 352 46 352 64V467Z"]
  };
  var faBookmarkSlash = {
    prefix: 'fal',
    iconName: 'bookmark-slash',
    icon: [640, 512, [], "e0a7", "M192 32H448C466 32 480 46 480 64V301L512 326V64C512 29 483 0 448 0H192C169 0 149 12 138 31L163 51C168 40 179 32 192 32ZM320 368C317 368 314 369 311 370L160 467V211L128 186V496C128 502 131 507 136 510C141 513 148 513 153 509L320 403L487 510C490 511 493 512 496 512C499 512 501 511 504 510C509 507 512 502 512 496V492L329 370C326 369 323 368 320 368ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483Z"]
  };
  var faBooks = {
    prefix: 'fal',
    iconName: 'books',
    icon: [512, 512, [], "f5db", "M510 435L403 35C397 14 378 0 356 0C352 0 348 1 344 2L282 18C281 18 280 19 278 20C270 8 256 0 240 0H176C164 0 153 5 144 12C135 5 124 0 112 0H48C22 0 0 22 0 48V464C0 490 22 512 48 512H112C124 512 135 507 144 500C153 507 164 512 176 512H240C266 512 288 490 288 464V225L356 477C362 498 381 512 402 512C406 512 410 511 415 510L476 494C502 487 517 461 510 435ZM32 48C32 39 39 32 48 32H112C121 32 128 39 128 48V96H32V48ZM32 128H128V384H32V128ZM112 480H48C39 480 32 473 32 464V416H128V464C128 473 121 480 112 480ZM256 464C256 473 249 480 240 480H176C167 480 160 473 160 464V416H256V464ZM256 384H160V128H256V384ZM256 96H160V48C160 39 167 32 176 32H240C249 32 256 39 256 48V96ZM288 102V50C289 50 289 49 290 49L352 33C354 32 355 32 356 32C364 32 370 37 372 44L384 90L291 115L288 102ZM366 391L300 145L392 121L459 367L366 391ZM478 456C477 458 474 461 468 463L406 479C405 480 404 480 402 480C395 480 389 475 387 468L374 422L467 397L479 444C481 449 479 453 478 456Z"]
  };
  var faBooksMedical = {
    prefix: 'fal',
    iconName: 'books-medical',
    icon: [576, 512, [], "f7e8", "M64 336C64 345 71 352 80 352H112C121 352 128 345 128 336V288H176C185 288 192 281 192 272V240C192 231 185 224 176 224H128V176C128 167 121 160 112 160H80C71 160 64 167 64 176V224H16C7 224 0 231 0 240V272C0 281 7 288 16 288H64V336ZM574 435L467 35C461 14 442 0 420 0C416 0 412 1 408 2L346 18C345 18 344 19 342 20C334 8 320 0 304 0H240C228 0 217 5 208 12C199 5 188 0 176 0H112C86 0 64 22 64 48V112C64 121 71 128 80 128H192V176C192 185 199 192 208 192S224 185 224 176V128H320V384H224V336C224 327 217 320 208 320S192 327 192 336V384H80C71 384 64 391 64 400V464C64 490 86 512 112 512H176C188 512 199 507 208 500C217 507 228 512 240 512H304C330 512 352 490 352 464V225L420 477C426 498 445 512 466 512C470 512 474 511 479 510L540 494C566 487 581 461 574 435ZM192 96H96V48C96 39 103 32 112 32H176C185 32 192 39 192 48V96ZM192 464C192 473 185 480 176 480H112C103 480 96 473 96 464V416H192V464ZM320 464C320 473 313 480 304 480H240C231 480 224 473 224 464V416H320V464ZM320 96H224V48C224 39 231 32 240 32H304C313 32 320 39 320 48V96ZM352 102V50C353 50 353 49 354 49L416 33C418 32 419 32 420 32C428 32 434 37 436 44L448 90L355 115L352 102ZM430 391L364 145L456 121L523 367L430 391ZM542 456C541 458 538 461 532 463L470 479C469 480 468 480 466 480C459 480 453 475 451 468L438 422L531 397L543 444C545 449 543 453 542 456Z"]
  };
  var faBoombox = {
    prefix: 'fal',
    iconName: 'boombox',
    icon: [640, 512, [], "f8a5", "M576 160V80C576 36 540 0 496 0H144C100 0 64 36 64 80V160C29 160 0 189 0 224V448C0 483 29 512 64 512H576C611 512 640 483 640 448V224C640 189 611 160 576 160ZM96 80C96 54 118 32 144 32H496C522 32 544 54 544 80V160H96V80ZM608 448C608 466 594 480 576 480H64C46 480 32 466 32 448V224C32 206 46 192 64 192H576C594 192 608 206 608 224V448ZM176 224C114 224 64 274 64 336S114 448 176 448S288 398 288 336S238 224 176 224ZM176 416C132 416 96 380 96 336S132 256 176 256S256 292 256 336S220 416 176 416ZM464 224C402 224 352 274 352 336S402 448 464 448S576 398 576 336S526 224 464 224ZM464 416C420 416 384 380 384 336S420 256 464 256S544 292 544 336S508 416 464 416ZM240 96H208C199 96 192 103 192 112S199 128 208 128H240C249 128 256 121 256 112S249 96 240 96ZM432 96H400C391 96 384 103 384 112S391 128 400 128H432C441 128 448 121 448 112S441 96 432 96ZM336 96H304C295 96 288 103 288 112S295 128 304 128H336C345 128 352 121 352 112S345 96 336 96Z"]
  };
  var faBoot = {
    prefix: 'fal',
    iconName: 'boot',
    icon: [512, 512, [], "f782", "M415 248L352 232V192C352 174 338 160 320 160H240C231 160 224 167 224 176S231 192 240 192H320V224H240C231 224 224 231 224 240S231 256 240 256H320L407 279C450 290 480 328 480 372V384H32V128H352C370 128 384 114 384 96V32C384 14 370 0 352 0H32C14 0 0 14 0 32V467C0 475 3 483 9 489L23 503C29 509 37 512 45 512H83C91 512 99 509 105 503L128 480L151 503C157 509 165 512 173 512H211C219 512 227 509 233 503L256 480L279 503C285 509 293 512 301 512H339C347 512 355 509 361 503L384 480L407 503C413 509 421 512 429 512H467C475 512 483 509 489 503L503 489C509 483 512 475 512 467V372C512 313 472 262 415 248ZM32 32H352V96H32V32ZM480 467L467 480H429L407 457C401 451 393 448 384 448S367 451 361 457L339 480H301L279 457C273 451 265 448 256 448S239 451 233 457L211 480H173L151 457C145 451 137 448 128 448S111 451 105 457L83 480H45L32 467V416H480V467Z"]
  };
  var faBoothCurtain = {
    prefix: 'fal',
    iconName: 'booth-curtain',
    icon: [512, 512, [], "f734", "M0 32V496C0 505 7 512 16 512H16C25 512 32 505 32 496V32H96L96 382C96 417 123 447 159 448C179 448 196 440 208 426C220 439 237 448 256 448S292 439 304 426C316 439 333 448 352 448S388 439 400 426C412 439 429 448 448 448C460 448 470 445 480 439V496C480 505 487 512 496 512L496 512C505 512 512 505 512 496V32C512 14 498 0 480 0H32C14 0 0 14 0 32ZM416 32H480V384C480 402 466 416 448 416C430 416 416 402 416 384V32ZM320 32H384V384C384 402 370 416 352 416S320 402 320 384V32ZM224 32H288V384C288 402 274 416 256 416S224 402 224 384V32ZM128 32H192V384C192 402 178 416 160 416S128 402 128 384V32Z"]
  };
  var faBorderAll = {
    prefix: 'fal',
    iconName: 'border-all',
    icon: [448, 512, [], "f84c", "M400 32H48C22 32 0 54 0 80V432C0 458 22 480 48 480H400C426 480 448 458 448 432V80C448 54 426 32 400 32ZM32 80C32 71 39 64 48 64H208V240H32V80ZM48 448C39 448 32 441 32 432V272H208V448H48ZM416 432C416 441 409 448 400 448H240V272H416V432ZM416 240H240V64H400C409 64 416 71 416 80V240Z"]
  };
  var faBorderBottom = {
    prefix: 'fal',
    iconName: 'border-bottom',
    icon: [448, 512, [], "f84d", "M224 88C237 88 248 77 248 64C248 51 237 40 224 40S200 51 200 64C200 77 211 88 224 88ZM224 184C237 184 248 173 248 160C248 147 237 136 224 136S200 147 200 160C200 173 211 184 224 184ZM320 88C333 88 344 77 344 64C344 51 333 40 320 40S296 51 296 64C296 77 307 88 320 88ZM416 376C429 376 440 365 440 352C440 339 429 328 416 328S392 339 392 352C392 365 403 376 416 376ZM320 280C333 280 344 269 344 256C344 243 333 232 320 232S296 243 296 256C296 269 307 280 320 280ZM416 88C429 88 440 77 440 64C440 51 429 40 416 40S392 51 392 64C392 77 403 88 416 88ZM416 280C429 280 440 269 440 256C440 243 429 232 416 232S392 243 392 256C392 269 403 280 416 280ZM416 184C429 184 440 173 440 160C440 147 429 136 416 136S392 147 392 160C392 173 403 184 416 184ZM32 376C45 376 56 365 56 352C56 339 45 328 32 328S8 339 8 352C8 365 19 376 32 376ZM32 88C45 88 56 77 56 64C56 51 45 40 32 40S8 51 8 64C8 77 19 88 32 88ZM32 280C45 280 56 269 56 256C56 243 45 232 32 232S8 243 8 256C8 269 19 280 32 280ZM32 184C45 184 56 173 56 160C56 147 45 136 32 136S8 147 8 160C8 173 19 184 32 184ZM432 448H16C7 448 0 455 0 464S7 480 16 480H432C441 480 448 473 448 464S441 448 432 448ZM128 280C141 280 152 269 152 256C152 243 141 232 128 232S104 243 104 256C104 269 115 280 128 280ZM224 376C237 376 248 365 248 352C248 339 237 328 224 328S200 339 200 352C200 365 211 376 224 376ZM224 280C237 280 248 269 248 256C248 243 237 232 224 232S200 243 200 256C200 269 211 280 224 280ZM128 88C141 88 152 77 152 64C152 51 141 40 128 40S104 51 104 64C104 77 115 88 128 88Z"]
  };
  var faBorderBottomRight = {
    prefix: 'fal',
    iconName: 'border-bottom-right',
    icon: [448, 512, [], "f854", "M128 88C141 88 152 77 152 64C152 51 141 40 128 40S104 51 104 64C104 77 115 88 128 88ZM32 88C45 88 56 77 56 64C56 51 45 40 32 40S8 51 8 64C8 77 19 88 32 88ZM224 88C237 88 248 77 248 64C248 51 237 40 224 40S200 51 200 64C200 77 211 88 224 88ZM320 88C333 88 344 77 344 64C344 51 333 40 320 40S296 51 296 64C296 77 307 88 320 88ZM32 184C45 184 56 173 56 160C56 147 45 136 32 136S8 147 8 160C8 173 19 184 32 184ZM32 376C45 376 56 365 56 352C56 339 45 328 32 328S8 339 8 352C8 365 19 376 32 376ZM32 280C45 280 56 269 56 256C56 243 45 232 32 232S8 243 8 256C8 269 19 280 32 280ZM432 32C423 32 416 39 416 48V432C416 441 409 448 400 448H16C7 448 0 455 0 464S7 480 16 480H400C426 480 448 458 448 432V48C448 39 441 32 432 32Z"]
  };
  var faBorderCenterH = {
    prefix: 'fal',
    iconName: 'border-center-h',
    icon: [448, 512, [], "f89c", "M416 88C429 88 440 77 440 64C440 51 429 40 416 40S392 51 392 64C392 77 403 88 416 88ZM128 88C141 88 152 77 152 64C152 51 141 40 128 40S104 51 104 64C104 77 115 88 128 88ZM32 184C45 184 56 173 56 160C56 147 45 136 32 136S8 147 8 160C8 173 19 184 32 184ZM32 424C19 424 8 435 8 448C8 461 19 472 32 472S56 461 56 448C56 435 45 424 32 424ZM32 88C45 88 56 77 56 64C56 51 45 40 32 40S8 51 8 64C8 77 19 88 32 88ZM224 88C237 88 248 77 248 64C248 51 237 40 224 40S200 51 200 64C200 77 211 88 224 88ZM416 184C429 184 440 173 440 160C440 147 429 136 416 136S392 147 392 160C392 173 403 184 416 184ZM320 88C333 88 344 77 344 64C344 51 333 40 320 40S296 51 296 64C296 77 307 88 320 88ZM224 184C237 184 248 173 248 160C248 147 237 136 224 136S200 147 200 160C200 173 211 184 224 184ZM416 424C403 424 392 435 392 448C392 461 403 472 416 472S440 461 440 448C440 435 429 424 416 424ZM320 424C307 424 296 435 296 448C296 461 307 472 320 472S344 461 344 448C344 435 333 424 320 424ZM416 328C403 328 392 339 392 352C392 365 403 376 416 376S440 365 440 352C440 339 429 328 416 328ZM432 240H16C7 240 0 247 0 256S7 272 16 272H432C441 272 448 265 448 256S441 240 432 240ZM224 328C211 328 200 339 200 352C200 365 211 376 224 376S248 365 248 352C248 339 237 328 224 328ZM32 328C19 328 8 339 8 352C8 365 19 376 32 376S56 365 56 352C56 339 45 328 32 328ZM128 424C115 424 104 435 104 448C104 461 115 472 128 472S152 461 152 448C152 435 141 424 128 424ZM224 424C211 424 200 435 200 448C200 461 211 472 224 472S248 461 248 448C248 435 237 424 224 424Z"]
  };
  var faBorderCenterV = {
    prefix: 'fal',
    iconName: 'border-center-v',
    icon: [448, 512, [], "f89d", "M128 232C115 232 104 243 104 256C104 269 115 280 128 280S152 269 152 256C152 243 141 232 128 232ZM32 136C19 136 8 147 8 160C8 173 19 184 32 184S56 173 56 160C56 147 45 136 32 136ZM32 40C19 40 8 51 8 64C8 77 19 88 32 88S56 77 56 64C56 51 45 40 32 40ZM128 424C115 424 104 435 104 448C104 461 115 472 128 472S152 461 152 448C152 435 141 424 128 424ZM32 232C19 232 8 243 8 256C8 269 19 280 32 280S56 269 56 256C56 243 45 232 32 232ZM32 328C19 328 8 339 8 352C8 365 19 376 32 376S56 365 56 352C56 339 45 328 32 328ZM416 88C429 88 440 77 440 64C440 51 429 40 416 40S392 51 392 64C392 77 403 88 416 88ZM32 424C19 424 8 435 8 448C8 461 19 472 32 472S56 461 56 448C56 435 45 424 32 424ZM416 136C403 136 392 147 392 160C392 173 403 184 416 184S440 173 440 160C440 147 429 136 416 136ZM416 328C403 328 392 339 392 352C392 365 403 376 416 376S440 365 440 352C440 339 429 328 416 328ZM320 40C307 40 296 51 296 64C296 77 307 88 320 88S344 77 344 64C344 51 333 40 320 40ZM416 424C403 424 392 435 392 448C392 461 403 472 416 472S440 461 440 448C440 435 429 424 416 424ZM128 40C115 40 104 51 104 64C104 77 115 88 128 88S152 77 152 64C152 51 141 40 128 40ZM416 232C403 232 392 243 392 256C392 269 403 280 416 280S440 269 440 256C440 243 429 232 416 232ZM320 232C307 232 296 243 296 256C296 269 307 280 320 280S344 269 344 256C344 243 333 232 320 232ZM320 424C307 424 296 435 296 448C296 461 307 472 320 472S344 461 344 448C344 435 333 424 320 424ZM224 32C215 32 208 39 208 48V464C208 473 215 480 224 480S240 473 240 464V48C240 39 233 32 224 32Z"]
  };
  var faBorderInner = {
    prefix: 'fal',
    iconName: 'border-inner',
    icon: [448, 512, [], "f84e", "M128 88C141 88 152 77 152 64C152 51 141 40 128 40S104 51 104 64C104 77 115 88 128 88ZM32 88C45 88 56 77 56 64C56 51 45 40 32 40S8 51 8 64C8 77 19 88 32 88ZM32 184C45 184 56 173 56 160C56 147 45 136 32 136S8 147 8 160C8 173 19 184 32 184ZM416 88C429 88 440 77 440 64C440 51 429 40 416 40S392 51 392 64C392 77 403 88 416 88ZM416 184C429 184 440 173 440 160C440 147 429 136 416 136S392 147 392 160C392 173 403 184 416 184ZM320 88C333 88 344 77 344 64C344 51 333 40 320 40S296 51 296 64C296 77 307 88 320 88ZM32 424C19 424 8 435 8 448C8 461 19 472 32 472S56 461 56 448C56 435 45 424 32 424ZM416 328C403 328 392 339 392 352C392 365 403 376 416 376S440 365 440 352C440 339 429 328 416 328ZM416 424C403 424 392 435 392 448C392 461 403 472 416 472S440 461 440 448C440 435 429 424 416 424ZM320 424C307 424 296 435 296 448C296 461 307 472 320 472S344 461 344 448C344 435 333 424 320 424ZM128 424C115 424 104 435 104 448C104 461 115 472 128 472S152 461 152 448C152 435 141 424 128 424ZM32 328C19 328 8 339 8 352C8 365 19 376 32 376S56 365 56 352C56 339 45 328 32 328ZM432 240H240V48C240 39 233 32 224 32S208 39 208 48V240H16C7 240 0 247 0 256S7 272 16 272H208V464C208 473 215 480 224 480S240 473 240 464V272H432C441 272 448 265 448 256S441 240 432 240Z"]
  };
  var faBorderLeft = {
    prefix: 'fal',
    iconName: 'border-left',
    icon: [448, 512, [], "f84f", "M128 40C115 40 104 51 104 64C104 77 115 88 128 88S152 77 152 64C152 51 141 40 128 40ZM224 424C211 424 200 435 200 448C200 461 211 472 224 472S248 461 248 448C248 435 237 424 224 424ZM224 328C211 328 200 339 200 352C200 365 211 376 224 376S248 365 248 352C248 339 237 328 224 328ZM224 232C211 232 200 243 200 256C200 269 211 280 224 280S248 269 248 256C248 243 237 232 224 232ZM416 88C429 88 440 77 440 64C440 51 429 40 416 40S392 51 392 64C392 77 403 88 416 88ZM224 136C211 136 200 147 200 160C200 173 211 184 224 184S248 173 248 160C248 147 237 136 224 136ZM128 232C115 232 104 243 104 256C104 269 115 280 128 280S152 269 152 256C152 243 141 232 128 232ZM128 424C115 424 104 435 104 448C104 461 115 472 128 472S152 461 152 448C152 435 141 424 128 424ZM416 136C403 136 392 147 392 160C392 173 403 184 416 184S440 173 440 160C440 147 429 136 416 136ZM416 424C403 424 392 435 392 448C392 461 403 472 416 472S440 461 440 448C440 435 429 424 416 424ZM416 328C403 328 392 339 392 352C392 365 403 376 416 376S440 365 440 352C440 339 429 328 416 328ZM416 232C403 232 392 243 392 256C392 269 403 280 416 280S440 269 440 256C440 243 429 232 416 232ZM320 232C307 232 296 243 296 256C296 269 307 280 320 280S344 269 344 256C344 243 333 232 320 232ZM320 40C307 40 296 51 296 64C296 77 307 88 320 88S344 77 344 64C344 51 333 40 320 40ZM320 424C307 424 296 435 296 448C296 461 307 472 320 472S344 461 344 448C344 435 333 424 320 424ZM224 40C211 40 200 51 200 64C200 77 211 88 224 88S248 77 248 64C248 51 237 40 224 40ZM16 32C7 32 0 39 0 48V464C0 473 7 480 16 480S32 473 32 464V48C32 39 25 32 16 32Z"]
  };
  var faBorderNone = {
    prefix: 'fal',
    iconName: 'border-none',
    icon: [448, 512, [], "f850", "M128 232C115 232 104 243 104 256C104 269 115 280 128 280S152 269 152 256C152 243 141 232 128 232ZM32 40C19 40 8 51 8 64C8 77 19 88 32 88S56 77 56 64C56 51 45 40 32 40ZM128 424C115 424 104 435 104 448C104 461 115 472 128 472S152 461 152 448C152 435 141 424 128 424ZM128 40C115 40 104 51 104 64C104 77 115 88 128 88S152 77 152 64C152 51 141 40 128 40ZM224 328C211 328 200 339 200 352C200 365 211 376 224 376S248 365 248 352C248 339 237 328 224 328ZM416 88C429 88 440 77 440 64C440 51 429 40 416 40S392 51 392 64C392 77 403 88 416 88ZM32 424C19 424 8 435 8 448C8 461 19 472 32 472S56 461 56 448C56 435 45 424 32 424ZM32 328C19 328 8 339 8 352C8 365 19 376 32 376S56 365 56 352C56 339 45 328 32 328ZM32 136C19 136 8 147 8 160C8 173 19 184 32 184S56 173 56 160C56 147 45 136 32 136ZM32 232C19 232 8 243 8 256C8 269 19 280 32 280S56 269 56 256C56 243 45 232 32 232ZM224 424C211 424 200 435 200 448C200 461 211 472 224 472S248 461 248 448C248 435 237 424 224 424ZM416 328C403 328 392 339 392 352C392 365 403 376 416 376S440 365 440 352C440 339 429 328 416 328ZM416 424C403 424 392 435 392 448C392 461 403 472 416 472S440 461 440 448C440 435 429 424 416 424ZM416 232C403 232 392 243 392 256C392 269 403 280 416 280S440 269 440 256C440 243 429 232 416 232ZM320 40C307 40 296 51 296 64C296 77 307 88 320 88S344 77 344 64C344 51 333 40 320 40ZM224 232C211 232 200 243 200 256C200 269 211 280 224 280S248 269 248 256C248 243 237 232 224 232ZM416 136C403 136 392 147 392 160C392 173 403 184 416 184S440 173 440 160C440 147 429 136 416 136ZM224 40C211 40 200 51 200 64C200 77 211 88 224 88S248 77 248 64C248 51 237 40 224 40ZM320 232C307 232 296 243 296 256C296 269 307 280 320 280S344 269 344 256C344 243 333 232 320 232ZM224 136C211 136 200 147 200 160C200 173 211 184 224 184S248 173 248 160C248 147 237 136 224 136ZM320 424C307 424 296 435 296 448C296 461 307 472 320 472S344 461 344 448C344 435 333 424 320 424Z"]
  };
  var faBorderOuter = {
    prefix: 'fal',
    iconName: 'border-outer',
    icon: [448, 512, [], "f851", "M224 328C211 328 200 339 200 352C200 365 211 376 224 376S248 365 248 352C248 339 237 328 224 328ZM128 232C115 232 104 243 104 256C104 269 115 280 128 280S152 269 152 256C152 243 141 232 128 232ZM224 232C211 232 200 243 200 256C200 269 211 280 224 280S248 269 248 256C248 243 237 232 224 232ZM320 232C307 232 296 243 296 256C296 269 307 280 320 280S344 269 344 256C344 243 333 232 320 232ZM224 136C211 136 200 147 200 160C200 173 211 184 224 184S248 173 248 160C248 147 237 136 224 136ZM400 32H48C22 32 0 54 0 80V432C0 458 22 480 48 480H400C426 480 448 458 448 432V80C448 54 426 32 400 32ZM416 432C416 441 409 448 400 448H48C39 448 32 441 32 432V80C32 71 39 64 48 64H400C409 64 416 71 416 80V432Z"]
  };
  var faBorderRight = {
    prefix: 'fal',
    iconName: 'border-right',
    icon: [448, 512, [], "f852", "M120 40C107 40 96 51 96 64C96 77 107 88 120 88S144 77 144 64C144 51 133 40 120 40ZM24 136C11 136 0 147 0 160C0 173 11 184 24 184S48 173 48 160C48 147 37 136 24 136ZM120 424C107 424 96 435 96 448C96 461 107 472 120 472S144 461 144 448C144 435 133 424 120 424ZM120 232C107 232 96 243 96 256C96 269 107 280 120 280S144 269 144 256C144 243 133 232 120 232ZM24 40C11 40 0 51 0 64C0 77 11 88 24 88S48 77 48 64C48 51 37 40 24 40ZM24 424C11 424 0 435 0 448C0 461 11 472 24 472S48 461 48 448C48 435 37 424 24 424ZM24 328C11 328 0 339 0 352C0 365 11 376 24 376S48 365 48 352C48 339 37 328 24 328ZM24 232C11 232 0 243 0 256C0 269 11 280 24 280S48 269 48 256C48 243 37 232 24 232ZM216 328C203 328 192 339 192 352C192 365 203 376 216 376S240 365 240 352C240 339 229 328 216 328ZM216 40C203 40 192 51 192 64C192 77 203 88 216 88S240 77 240 64C240 51 229 40 216 40ZM312 232C299 232 288 243 288 256C288 269 299 280 312 280S336 269 336 256C336 243 325 232 312 232ZM216 424C203 424 192 435 192 448C192 461 203 472 216 472S240 461 240 448C240 435 229 424 216 424ZM312 40C299 40 288 51 288 64C288 77 299 88 312 88S336 77 336 64C336 51 325 40 312 40ZM312 424C299 424 288 435 288 448C288 461 299 472 312 472S336 461 336 448C336 435 325 424 312 424ZM216 232C203 232 192 243 192 256C192 269 203 280 216 280S240 269 240 256C240 243 229 232 216 232ZM216 136C203 136 192 147 192 160C192 173 203 184 216 184S240 173 240 160C240 147 229 136 216 136ZM424 32C415 32 408 39 408 48V464C408 473 415 480 424 480S440 473 440 464V48C440 39 433 32 424 32Z"]
  };
  var faBorderTop = {
    prefix: 'fal',
    iconName: 'border-top',
    icon: [448, 512, [], "f855", "M128 424C115 424 104 435 104 448S115 472 128 472C141 472 152 461 152 448S141 424 128 424ZM224 328C211 328 200 339 200 352S211 376 224 376C237 376 248 365 248 352S237 328 224 328ZM32 136C19 136 8 147 8 160S19 184 32 184C45 184 56 173 56 160S45 136 32 136ZM224 424C211 424 200 435 200 448S211 472 224 472C237 472 248 461 248 448S237 424 224 424ZM128 232C115 232 104 243 104 256S115 280 128 280C141 280 152 269 152 256S141 232 128 232ZM432 32H16C7 32 0 39 0 48S7 64 16 64H432C441 64 448 57 448 48S441 32 432 32ZM32 328C19 328 8 339 8 352S19 376 32 376C45 376 56 365 56 352S45 328 32 328ZM32 232C19 232 8 243 8 256S19 280 32 280C45 280 56 269 56 256S45 232 32 232ZM32 424C19 424 8 435 8 448S19 472 32 472C45 472 56 461 56 448S45 424 32 424ZM416 328C403 328 392 339 392 352S403 376 416 376C429 376 440 365 440 352S429 328 416 328ZM416 232C403 232 392 243 392 256S403 280 416 280C429 280 440 269 440 256S429 232 416 232ZM416 424C403 424 392 435 392 448S403 472 416 472C429 472 440 461 440 448S429 424 416 424ZM416 136C403 136 392 147 392 160S403 184 416 184C429 184 440 173 440 160S429 136 416 136ZM320 424C307 424 296 435 296 448S307 472 320 472C333 472 344 461 344 448S333 424 320 424ZM224 136C211 136 200 147 200 160S211 184 224 184C237 184 248 173 248 160S237 136 224 136ZM224 232C211 232 200 243 200 256S211 280 224 280C237 280 248 269 248 256S237 232 224 232ZM320 232C307 232 296 243 296 256S307 280 320 280C333 280 344 269 344 256S333 232 320 232Z"]
  };
  var faBorderTopLeft = {
    prefix: 'fal',
    iconName: 'border-top-left',
    icon: [448, 512, [], "f853", "M416 424C403 424 392 435 392 448C392 461 403 472 416 472S440 461 440 448C440 435 429 424 416 424ZM224 424C211 424 200 435 200 448C200 461 211 472 224 472S248 461 248 448C248 435 237 424 224 424ZM128 424C115 424 104 435 104 448C104 461 115 472 128 472S152 461 152 448C152 435 141 424 128 424ZM320 424C307 424 296 435 296 448C296 461 307 472 320 472S344 461 344 448C344 435 333 424 320 424ZM416 328C403 328 392 339 392 352C392 365 403 376 416 376S440 365 440 352C440 339 429 328 416 328ZM416 136C403 136 392 147 392 160C392 173 403 184 416 184S440 173 440 160C440 147 429 136 416 136ZM416 232C403 232 392 243 392 256C392 269 403 280 416 280S440 269 440 256C440 243 429 232 416 232ZM432 32H48C22 32 0 54 0 80V464C0 473 7 480 16 480S32 473 32 464V80C32 71 39 64 48 64H432C441 64 448 57 448 48S441 32 432 32Z"]
  };
  var faBowArrow = {
    prefix: 'fal',
    iconName: 'bow-arrow',
    icon: [512, 512, [], "f6b9", "M496 0C495 0 494 0 493 0L365 26C352 29 348 44 357 53L397 93L144 345L91 321C83 319 75 321 70 326L6 390C-5 401 0 419 14 424L70 442L88 498C91 507 99 512 108 512C113 512 118 510 122 506L186 442C191 437 193 429 191 421L167 368L419 115L459 155C463 158 467 160 470 160C477 160 484 155 486 147L512 19C514 9 506 0 496 0ZM113 470L100 432L95 417L80 412L42 399L87 354L136 376L158 425L113 470ZM461 111L401 52L475 37L461 111ZM149 267C152 270 156 272 160 272S168 270 171 267C178 261 178 251 171 245L64 137C137 86 235 82 311 130C319 135 329 133 334 125C338 118 336 108 329 103C240 47 125 52 40 114L27 101C21 94 11 94 5 101S-2 117 5 123L149 267ZM409 183C404 176 394 174 387 178C379 183 377 193 382 201C430 277 427 375 375 448L267 341C261 334 251 334 245 341S238 357 245 363L389 507C392 510 396 512 400 512S408 510 411 507C418 501 418 491 411 485L398 472C460 387 465 272 409 183Z"]
  };
  var faBowlHot = {
    prefix: 'fal',
    iconName: 'bowl-hot',
    icon: [512, 512, [], "f823", "M169 94C183 101 192 116 192 132V144C192 153 199 160 208 160S224 153 224 144V132C224 104 208 78 183 66C169 59 160 44 160 28V16C160 7 153 0 144 0S128 7 128 16V28C128 56 144 82 169 94ZM297 94C311 101 320 116 320 132V144C320 153 327 160 336 160S352 153 352 144V132C352 104 336 78 311 66C297 59 288 44 288 28V16C288 7 281 0 272 0S256 7 256 16V28C256 56 272 82 297 94ZM480 192H32C14 192 0 206 0 224C0 319 51 401 128 446V480C128 498 142 512 160 512H352C370 512 384 498 384 480V446C461 401 512 319 512 224C512 206 498 192 480 192ZM352 427V480H160V427C28 350 32 241 32 224H480C480 242 483 351 352 427Z"]
  };
  var faBowlingBall = {
    prefix: 'fal',
    iconName: 'bowling-ball',
    icon: [512, 512, [], "f436", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM144 152C131 152 120 163 120 176C120 189 131 200 144 200C157 200 168 189 168 176C168 163 157 152 144 152ZM240 184C227 184 216 195 216 208C216 221 227 232 240 232C253 232 264 221 264 208C264 195 253 184 240 184ZM240 88C227 88 216 99 216 112C216 125 227 136 240 136C253 136 264 125 264 112C264 99 253 88 240 88Z"]
  };
  var faBowlingBallPin = {
    prefix: 'fal',
    iconName: 'bowling-ball-pin',
    icon: [576, 512, [], "e0a8", "M120 224C107 224 96 235 96 248S107 272 120 272C133 272 144 261 144 248S133 224 120 224ZM200 240C187 240 176 251 176 264S187 288 200 288S224 277 224 264S213 240 200 240ZM200 160C187 160 176 171 176 184S187 208 200 208S224 197 224 184S213 160 200 160ZM208 96C93 96 0 189 0 304S93 512 208 512S416 419 416 304S323 96 208 96ZM208 480C111 480 32 401 32 304S111 128 208 128S384 207 384 304S305 480 208 480ZM549 265C536 235 525 208 525 181C525 170 529 160 533 148C539 132 547 111 547 84C547 29 509 0 472 0C435 0 397 29 397 84C397 111 405 132 411 148C415 160 419 170 419 181C419 184 419 186 419 189C427 205 434 222 439 240C445 224 449 208 450 192H494C496 221 508 250 520 277C532 307 544 334 544 361C544 406 526 442 511 473C508 477 504 480 499 480H445C440 480 436 477 433 471C426 459 419 444 413 428C407 439 399 449 391 459C396 469 401 478 405 487C413 502 428 512 445 512H499C516 512 531 502 540 485C555 455 576 414 576 361C576 328 562 296 549 265ZM495 160H449C442 135 429 116 429 84C429 48 451 32 472 32C493 32 515 48 515 84C515 116 502 135 495 160Z"]
  };
  var faBowlingPins = {
    prefix: 'fal',
    iconName: 'bowling-pins',
    icon: [512, 512, [], "f437", "M461 265C448 235 437 208 437 181C437 170 441 160 445 148C451 132 459 111 459 84C459 29 421 0 384 0C347 0 309 29 309 84C309 111 317 132 323 148C327 160 331 170 331 181C331 208 320 235 307 265C294 296 280 328 280 361C280 414 301 456 317 487C325 502 340 512 357 512H411C428 512 443 502 452 485C467 455 488 414 488 361C488 328 474 296 461 265ZM384 32C405 32 427 48 427 84C427 116 414 135 407 160H361C354 135 341 116 341 84C341 48 363 32 384 32ZM423 473C420 477 416 480 411 480H357C352 480 348 477 345 471C330 443 312 407 312 361C312 334 324 307 336 277C348 250 360 221 362 192H406C408 221 420 250 432 277C444 307 456 334 456 361C456 406 438 442 423 473ZM181 181C181 170 185 160 189 148C195 132 203 111 203 84C203 29 165 0 128 0C91 0 53 29 53 84C53 111 61 132 67 148C71 160 75 170 75 181C75 208 64 235 51 265C38 296 24 328 24 361C24 414 45 456 61 487C69 502 84 512 101 512H155C172 512 187 502 196 485C211 455 232 414 232 361C232 328 218 296 205 265C193 235 181 208 181 181ZM128 32C149 32 171 48 171 84C171 116 158 135 151 160H105C98 135 85 116 85 84C85 48 107 32 128 32ZM167 473C164 477 160 480 155 480H101C96 480 92 477 89 471C74 443 56 407 56 361C56 334 68 307 80 277C92 250 104 221 106 192H150C152 221 164 250 176 277C188 307 200 334 200 361C200 406 182 442 167 473Z"]
  };
  var faBox = {
    prefix: 'fal',
    iconName: 'box',
    icon: [448, 512, [], "f466", "M443 162L391 59C383 42 366 32 348 32H100C82 32 65 42 57 59L5 162C2 169 0 176 0 184V416C0 451 29 480 64 480H384C419 480 448 451 448 416V184C448 176 446 169 443 162ZM240 64H348C354 64 360 67 363 73L406 160H240V64ZM85 73C88 67 94 64 100 64H208V160H42L85 73ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V192H416V416Z"]
  };
  var faBoxArchive = {
    prefix: 'fal',
    iconName: 'box-archive',
    icon: [512, 512, [], "f187", "M464 32H48C22 32 0 54 0 80V144C0 153 7 160 16 160H32V416C32 451 61 480 96 480H416C451 480 480 451 480 416V160H496C505 160 512 153 512 144V80C512 54 490 32 464 32ZM448 416C448 434 434 448 416 448H96C78 448 64 434 64 416V160H448V416ZM480 128H32V80C32 71 39 64 48 64H464C473 64 480 71 480 80V128ZM176 256H336C345 256 352 249 352 240S345 224 336 224H176C167 224 160 231 160 240S167 256 176 256Z"]
  };
  var faBoxBallot = {
    prefix: 'fal',
    iconName: 'box-ballot',
    icon: [576, 512, [], "f735", "M528 160H496C487 160 480 167 480 176S487 192 496 192H528C537 192 544 199 544 208V320H32V208C32 199 39 192 48 192H80C89 192 96 185 96 176S89 160 80 160H48C22 160 0 182 0 208V464C0 490 22 512 48 512H528C554 512 576 490 576 464V208C576 182 554 160 528 160ZM544 464C544 473 537 480 528 480H48C39 480 32 473 32 464V352H544V464ZM144 256H432C441 256 448 249 448 240V48C448 22 426 0 400 0H176C150 0 128 22 128 48V240C128 249 135 256 144 256ZM160 48C160 39 167 32 176 32H400C409 32 416 39 416 48V224H160V48Z"]
  };
  var faBoxCheck = {
    prefix: 'fal',
    iconName: 'box-check',
    icon: [448, 512, [], "f467", "M443 162L391 59C383 42 366 32 348 32H100C82 32 65 42 57 59L5 162C2 169 0 176 0 184V416C0 451 29 480 64 480H384C419 480 448 451 448 416V184C448 176 446 169 443 162ZM240 64H348C354 64 360 67 363 73L406 160H240V64ZM85 73C88 67 94 64 100 64H208V160H42L85 73ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V192H416V416ZM186 379C189 382 193 384 197 384S206 382 209 379L315 273C322 266 322 256 315 250S299 244 293 250L197 345L155 303C149 297 139 297 133 303S126 320 133 326L186 379Z"]
  };
  var faBoxCircleCheck = {
    prefix: 'fal',
    iconName: 'box-circle-check',
    icon: [640, 512, [], "e0a9", "M448 128C342 128 256 214 256 320S342 512 448 512S640 426 640 320S554 128 448 128ZM448 480C360 480 288 408 288 320S360 160 448 160S608 232 608 320S536 480 448 480ZM517 258L421 353L379 311C373 305 363 305 357 311S350 328 357 334L410 387C413 390 417 392 421 392S430 390 433 387L539 281C546 274 546 264 539 258S523 252 517 258ZM64 448C46 448 32 434 32 416V192H264C272 181 281 170 291 160H240V64H348C354 64 360 67 363 73L379 107C390 103 401 101 411 99L391 59C383 42 366 32 348 32H100C82 32 65 42 57 59L5 162C2 169 0 176 0 184V416C0 451 29 480 64 480H291C281 470 272 459 264 448H64ZM85 73C88 67 94 64 100 64H208V160H42L85 73Z"]
  };
  var faBoxDollar = {
    prefix: 'fal',
    iconName: 'box-dollar',
    icon: [448, 512, [], "f4a0", "M215 367C207 366 197 363 189 360L184 358C176 355 167 360 164 368S166 386 174 388L178 390C188 393 198 397 208 398C208 399 208 399 208 400V408C208 417 215 424 224 424S240 417 240 408V400C240 399 240 399 240 398C263 395 280 382 284 362C291 322 253 311 228 305L222 303C194 295 194 290 195 284C198 273 216 270 233 273C239 274 246 276 253 278C261 281 270 276 273 268C276 259 271 250 263 248C254 245 246 243 240 242V232C240 223 233 216 224 216S208 223 208 232V241C184 245 168 258 164 278C157 318 195 329 214 334L220 335C250 344 254 347 252 356C250 367 232 370 215 367ZM443 162L391 59C383 42 366 32 348 32H100C82 32 65 42 57 59L5 162C2 169 0 176 0 184V416C0 451 29 480 64 480H384C419 480 448 451 448 416V184C448 176 446 169 443 162ZM240 64H348C354 64 360 67 363 73L406 160H240V64ZM85 73C88 67 94 64 100 64H208V160H42L85 73ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V192H416V416Z"]
  };
  var faBoxHeart = {
    prefix: 'fal',
    iconName: 'box-heart',
    icon: [448, 512, [], "f49d", "M214 412C220 417 228 417 234 412L319 326C343 301 342 260 314 237C300 226 267 209 224 252C181 209 148 226 134 237C106 260 105 301 130 326L214 412ZM154 262C168 250 185 258 193 266L224 297L255 266C263 258 280 250 294 262C308 274 306 293 296 304L224 376L152 304C142 293 140 274 154 262ZM443 162L391 59C383 42 366 32 348 32H100C82 32 65 42 57 59L5 162C2 169 0 176 0 184V416C0 451 29 480 64 480H384C419 480 448 451 448 416V184C448 176 446 169 443 162ZM240 64H348C354 64 360 67 363 73L406 160H240V64ZM85 73C88 67 94 64 100 64H208V160H42L85 73ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V192H416V416Z"]
  };
  var faBoxOpen = {
    prefix: 'fal',
    iconName: 'box-open',
    icon: [640, 512, [], "f49e", "M560 224C551 224 544 231 544 240V378C544 385 539 391 532 393L336 445V224C336 215 329 208 320 208S304 215 304 224V445L108 393C101 391 96 385 96 378V240C96 231 89 224 80 224S64 231 64 240V378C64 399 79 418 100 424L299 477C306 479 313 480 320 480S334 479 341 477L540 424C561 418 576 399 576 378V240C576 231 569 224 560 224ZM639 154L591 42C588 35 581 31 574 32L320 64L66 32C59 31 52 35 49 42L1 154C-1 158 0 163 2 167C4 171 8 175 12 176L220 224C222 224 223 224 224 224C229 224 234 222 237 218L320 107L403 218C406 222 411 224 416 224C417 224 418 224 420 224L628 176C632 175 636 171 638 167C640 163 641 158 639 154ZM217 190L38 149L74 65L291 92L217 190ZM423 190L349 92L566 65L602 149L423 190Z"]
  };
  var faBoxOpenFull = {
    prefix: 'fal',
    iconName: 'box-open-full',
    icon: [640, 512, [], "f49c", "M560 352C551 352 544 359 544 368V410C544 417 539 423 532 425L336 477V352C336 343 329 336 320 336S304 343 304 352V477L108 425C101 423 96 417 96 410V368C96 359 89 352 80 352S64 359 64 368V410C64 431 79 450 100 456L299 509C306 511 313 512 320 512S334 511 341 509L540 456C561 450 576 431 576 410V368C576 359 569 352 560 352ZM639 282L591 170C588 163 581 159 574 160L320 192L66 160C59 159 52 163 49 170L1 282C-1 286 0 291 2 295C4 299 8 303 12 304L220 352C222 352 223 352 224 352C229 352 234 350 237 346L320 235L403 346C406 350 411 352 416 352C417 352 418 352 420 352L628 304C632 303 636 299 638 295C640 291 641 286 639 282ZM217 318L38 277L74 193L291 220L217 318ZM423 318L349 220L566 193L602 277L423 318ZM144 144C153 144 160 137 160 128C160 75 203 32 256 32S352 75 352 128C352 137 359 144 368 144S384 137 384 128C384 57 327 0 256 0S128 57 128 128C128 137 135 144 144 144ZM443 143C445 144 446 144 448 144C455 144 461 140 463 133L495 37C498 29 493 20 485 17C477 14 468 19 465 27L433 123C430 131 435 140 443 143Z"]
  };
  var faBoxTaped = {
    prefix: 'fal',
    iconName: 'box-taped',
    icon: [448, 512, [], "f49a", "M443 162L391 59C383 42 366 32 348 32H100C82 32 65 42 57 59L5 162C2 169 0 176 0 184V416C0 451 29 480 64 480H384C419 480 448 451 448 416V184C448 176 446 169 443 162ZM348 64C354 64 360 67 363 73L406 160H288L288 158L274 64H348ZM192 160L206 64H242L256 160H192ZM256 192V288H192L192 192H256ZM85 73C88 67 94 64 100 64H174L160 160H42L85 73ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V192H160V304C160 313 167 320 176 320H272C281 320 288 313 288 304L288 192H416V416Z"]
  };
  var faBoxTissue = {
    prefix: 'fal',
    iconName: 'box-tissue',
    icon: [512, 512, [], "e05b", "M144 320H368C378 320 387 313 391 303L447 128C449 120 448 112 443 106C439 100 432 96 424 96H339C319 96 301 83 295 64C282 26 246 0 205 0H88C81 0 74 3 69 9C65 15 63 22 65 29L121 301C123 312 133 320 144 320ZM205 32C232 32 256 49 264 75C275 107 305 128 339 128H413L362 288H151L98 32H205ZM464 224H448C439 224 432 231 432 240S439 256 448 256H464C473 256 480 263 480 272V384H32V272C32 263 39 256 48 256H64C73 256 80 249 80 240S73 224 64 224H48C22 224 0 246 0 272V464C0 490 22 512 48 512H464C490 512 512 490 512 464V272C512 246 490 224 464 224ZM480 464C480 473 473 480 464 480H48C39 480 32 473 32 464V416H480V464Z"]
  };
  var faBoxesStacked = {
    prefix: 'fal',
    iconName: 'boxes-stacked',
    icon: [576, 512, [], "f468", "M208 224H368C394 224 416 202 416 176V48C416 22 394 0 368 0H208C182 0 160 22 160 48V176C160 202 182 224 208 224ZM272 32H304V86L295 82C291 79 285 79 281 82L272 86V32ZM192 48C192 39 199 32 208 32H240V112C240 118 243 123 248 126S258 129 263 126L288 114L313 126C315 127 318 128 320 128C323 128 326 127 328 126C333 123 336 118 336 112V32H368C377 32 384 39 384 48V176C384 185 377 192 368 192H208C199 192 192 185 192 176V48ZM208 288H48C22 288 0 310 0 336V464C0 490 22 512 48 512H208C234 512 256 490 256 464V336C256 310 234 288 208 288ZM112 320H144V374L135 370C131 367 125 367 121 370L112 374V320ZM224 464C224 473 217 480 208 480H48C39 480 32 473 32 464V336C32 327 39 320 48 320H80V400C80 406 83 411 88 414S98 417 103 414L128 402L153 414C155 415 158 416 160 416C163 416 166 415 168 414C173 411 176 406 176 400V320H208C217 320 224 327 224 336V464ZM528 288H368C342 288 320 310 320 336V464C320 490 342 512 368 512H528C554 512 576 490 576 464V336C576 310 554 288 528 288ZM432 320H464V374L455 370C451 367 445 367 441 370L432 374V320ZM544 464C544 473 537 480 528 480H368C359 480 352 473 352 464V336C352 327 359 320 368 320H400V400C400 406 403 411 408 414S418 417 423 414L448 402L473 414C475 415 478 416 480 416C483 416 486 415 488 414C493 411 496 406 496 400V320H528C537 320 544 327 544 336V464Z"]
  };
  var faBoxingGlove = {
    prefix: 'fal',
    iconName: 'boxing-glove',
    icon: [512, 512, [], "f438", "M416 130V96C416 43 373 0 320 0H128C75 0 32 43 32 96V288C32 315 44 341 64 359V448C64 483 93 512 128 512H320C355 512 384 483 384 448V391L447 327C468 306 480 278 480 248V208C480 169 452 137 416 130ZM448 248C448 270 440 290 425 305L352 377V448C352 466 338 480 320 480H128C110 480 96 466 96 448V344L90 339C73 327 64 308 64 288V96C64 61 93 32 128 32H320C355 32 384 61 384 96V128H368C329 128 297 156 290 192H218C183 192 150 182 121 163C114 158 104 160 99 167C94 174 96 184 103 189C137 212 177 224 218 224H290C297 260 329 288 368 288C377 288 384 281 384 272S377 256 368 256C342 256 320 234 320 208S342 160 368 160H400C426 160 448 182 448 208V248ZM285 343C280 336 270 334 263 339L224 365L185 339C177 334 168 336 163 343C158 350 160 360 167 365L195 384L167 403C160 408 158 418 163 425C166 430 175 436 185 429L224 403L263 429C273 436 282 430 285 425C290 418 288 408 281 403L253 384L281 365C288 360 290 350 285 343Z"]
  };
  var faBracketCurly = {
    prefix: 'fal',
    iconName: 'bracket-curly',
    icon: [256, 512, [], "e0aa", "M96 152V112C96 86 118 64 144 64H208C217 64 224 57 224 48S217 32 208 32H144C100 32 64 68 64 112V152C64 190 43 225 9 242C3 244 0 250 0 256S3 268 9 270C43 287 64 322 64 360V400C64 444 100 480 144 480H208C217 480 224 473 224 464S217 448 208 448H144C118 448 96 426 96 400V360C96 319 77 281 46 256C77 231 96 193 96 152Z"]
  };
  var faBracketRound = {
    prefix: 'fal',
    iconName: 'bracket-round',
    icon: [256, 512, [], "e0ab", "M64 256C64 128 150 64 153 61C161 56 162 46 157 39C152 31 142 30 135 35C130 38 32 111 32 256S130 474 135 477C137 479 141 480 144 480C149 480 154 478 157 473C162 466 161 456 153 451C150 448 64 384 64 256Z"]
  };
  var faBracketSquare = {
    prefix: 'fal',
    iconName: 'bracket-square',
    icon: [256, 512, [], "e0ac", "M80 64H176C185 64 192 57 192 48S185 32 176 32H80C54 32 32 54 32 80V432C32 458 54 480 80 480H176C185 480 192 473 192 464S185 448 176 448H80C71 448 64 441 64 432V80C64 71 71 64 80 64Z"]
  };
  var faBracketsCurly = {
    prefix: 'fal',
    iconName: 'brackets-curly',
    icon: [576, 512, [], "f7ea", "M96 152V112C96 86 118 64 144 64H208C217 64 224 57 224 48S217 32 208 32H144C100 32 64 68 64 112V152C64 190 43 225 9 242C3 244 0 250 0 256S3 268 9 270C43 287 64 322 64 360V400C64 444 100 480 144 480H208C217 480 224 473 224 464S217 448 208 448H144C118 448 96 426 96 400V360C96 319 77 281 46 256C77 231 96 193 96 152ZM567 242C533 225 512 190 512 152V112C512 68 476 32 432 32H368C359 32 352 39 352 48S359 64 368 64H432C458 64 480 86 480 112V152C480 193 499 231 530 256C499 281 480 319 480 360V400C480 426 458 448 432 448H368C359 448 352 455 352 464S359 480 368 480H432C476 480 512 444 512 400V360C512 322 533 287 567 270C573 268 576 262 576 256S573 244 567 242Z"]
  };
  var faBracketsRound = {
    prefix: 'fal',
    iconName: 'brackets-round',
    icon: [512, 512, [], "e0ad", "M121 61C129 56 130 46 125 39C120 31 110 30 103 35C98 38 0 111 0 256S98 474 103 477C105 479 109 480 112 480C117 480 122 478 125 473C130 466 129 456 121 451C118 448 32 384 32 256S118 64 121 61ZM409 35C402 30 392 31 387 39C382 46 383 56 391 61C394 64 480 128 480 256S394 448 391 451C383 456 382 466 387 473C390 478 395 480 400 480C403 480 407 479 409 477C414 474 512 401 512 256S414 38 409 35Z"]
  };
  var faBracketsSquare = {
    prefix: 'fal',
    iconName: 'brackets-square',
    icon: [448, 512, [], "f7e9", "M400 32H304C295 32 288 39 288 48S295 64 304 64H400C409 64 416 71 416 80V432C416 441 409 448 400 448H304C295 448 288 455 288 464S295 480 304 480H400C426 480 448 458 448 432V80C448 54 426 32 400 32ZM48 64H144C153 64 160 57 160 48S153 32 144 32H48C22 32 0 54 0 80V432C0 458 22 480 48 480H144C153 480 160 473 160 464S153 448 144 448H48C39 448 32 441 32 432V80C32 71 39 64 48 64Z"]
  };
  var faBraille = {
    prefix: 'fal',
    iconName: 'braille',
    icon: [640, 512, [], "f2a1", "M80 48C45 48 16 77 16 112S45 176 80 176S144 147 144 112S115 48 80 48ZM80 144C62 144 48 130 48 112S62 80 80 80S112 94 112 112S98 144 80 144ZM240 48C205 48 176 77 176 112S205 176 240 176S304 147 304 112S275 48 240 48ZM240 144C222 144 208 130 208 112S222 80 240 80S272 94 272 112S258 144 240 144ZM432 48C397 48 368 77 368 112S397 176 432 176S496 147 496 112S467 48 432 48ZM432 144C414 144 400 130 400 112S414 80 432 80S464 94 464 112S450 144 432 144ZM80 208C45 208 16 237 16 272S45 336 80 336S144 307 144 272S115 208 80 208ZM80 304C62 304 48 290 48 272S62 240 80 240S112 254 112 272S98 304 80 304ZM80 408C67 408 56 419 56 432C56 445 67 456 80 456S104 445 104 432C104 419 93 408 80 408ZM240 408C227 408 216 419 216 432C216 445 227 456 240 456S264 445 264 432C264 419 253 408 240 408ZM432 408C419 408 408 419 408 432C408 445 419 456 432 456S456 445 456 432C456 419 445 408 432 408ZM592 408C579 408 568 419 568 432C568 445 579 456 592 456S616 445 616 432C616 419 605 408 592 408ZM240 248C227 248 216 259 216 272C216 285 227 296 240 296S264 285 264 272C264 259 253 248 240 248ZM432 248C419 248 408 259 408 272C408 285 419 296 432 296S456 285 456 272C456 259 445 248 432 248ZM592 248C579 248 568 259 568 272C568 285 579 296 592 296S616 285 616 272C616 259 605 248 592 248ZM592 136C605 136 616 125 616 112C616 99 605 88 592 88S568 99 568 112C568 125 579 136 592 136Z"]
  };
  var faBrain = {
    prefix: 'fal',
    iconName: 'brain',
    icon: [512, 512, [], "f5dc", "M512 288C512 264 503 241 487 224C488 220 488 216 488 212C488 182 472 156 448 141C448 140 448 140 448 140C448 109 432 81 406 67C398 29 364 0 324 0C296 0 271 14 256 35C241 14 216 0 188 0C148 0 114 29 106 67C82 80 67 105 64 132C40 147 24 174 24 204C24 210 25 217 26 223C10 240 0 263 0 288C0 317 13 343 33 361C32 366 32 371 32 376C32 424 71 463 119 464C131 492 159 512 192 512C218 512 241 499 256 480C271 499 294 512 320 512C353 512 381 492 393 464C441 463 480 424 480 376C480 371 480 366 479 361C499 343 512 317 512 288ZM240 432C240 458 218 480 192 480S144 458 144 432C144 430 144 428 145 426C137 430 129 432 120 432C89 432 64 407 64 376C64 365 67 356 72 347C49 338 32 315 32 288C32 264 45 244 65 233C59 224 56 215 56 204C56 179 74 158 98 153C97 149 96 144 96 139C96 115 113 94 136 89C136 87 136 86 136 84C136 55 159 32 188 32S240 55 240 84V432ZM440 347C445 356 448 365 448 376C448 407 423 432 392 432C383 432 375 430 367 426C368 428 368 430 368 432C368 458 346 480 320 480S272 458 272 432V84C272 55 295 32 324 32S376 55 376 84C376 86 376 87 376 89C399 94 416 115 416 139C416 147 414 154 411 161C437 164 456 186 456 212C456 220 454 228 451 234C468 246 480 266 480 288C480 315 463 338 440 347Z"]
  };
  var faBrainArrowCurvedRight = {
    prefix: 'fal',
    iconName: 'brain-arrow-curved-right',
    icon: [640, 512, [], "f677", "M224 32C252 34 273 59 273 87V289C273 298 280 305 289 305S305 298 305 289V87C305 59 326 34 354 32C385 31 410 55 410 84C410 86 409 87 409 89C432 94 450 115 450 140C450 148 448 155 445 161C465 164 481 178 487 197C489 204 495 209 502 209C513 209 521 198 518 188C512 169 499 152 482 141C482 141 482 140 482 140C482 109 465 82 440 67C432 29 398 0 357 0C329 0 304 14 289 35C274 14 249 0 221 0C180 0 146 29 138 67C115 81 99 105 97 133C72 148 56 175 56 205C56 211 57 217 58 223C42 241 32 264 32 289C32 318 45 344 66 362C65 367 64 372 64 377C64 426 103 465 151 466C161 488 181 505 205 511C215 514 225 506 225 496V496C225 488 219 482 212 480C192 475 177 456 177 434C177 432 177 430 177 428C164 434 149 436 132 430C117 424 104 411 99 394C94 377 97 361 104 349C81 339 64 316 64 289C64 265 77 244 97 233C91 225 88 215 88 205C88 179 106 158 130 154C129 149 128 145 128 140C128 115 146 94 169 89C169 87 169 86 169 84C169 55 193 31 224 32ZM603 341L507 245C501 238 491 238 485 245S478 261 485 267L553 336H352C308 336 272 372 272 416V496C272 505 279 512 288 512S304 505 304 496V416C304 390 326 368 352 368H553L485 437C478 443 478 453 485 459C488 462 492 464 496 464S504 462 507 459L603 363C610 357 610 347 603 341Z"]
  };
  var faBrakeWarning = {
    prefix: 'fal',
    iconName: 'brake-warning',
    icon: [640, 512, [], "e0ae", "M320 32C196 32 96 132 96 256S196 480 320 480C444 480 544 380 544 256S444 32 320 32ZM320 448C214 448 128 362 128 256S214 64 320 64S512 150 512 256S426 448 320 448ZM320 328C307 328 296 339 296 352S307 376 320 376C333 376 344 365 344 352S333 328 320 328ZM320 288C329 288 336 281 336 272V144C336 135 329 128 320 128S304 135 304 144V272C304 281 311 288 320 288ZM90 68C83 62 73 63 68 70C24 122 0 188 0 256S24 390 68 442C71 446 75 448 80 448C84 448 87 447 90 444C97 439 98 429 92 422C53 375 32 316 32 256S53 137 92 90C98 83 97 73 90 68ZM572 70C567 63 557 62 550 68C543 73 542 83 548 90C587 137 608 196 608 256S587 375 548 422C542 429 543 439 550 444C553 447 556 448 560 448C565 448 569 446 572 442C616 390 640 324 640 256S616 122 572 70Z"]
  };
  var faBreadLoaf = {
    prefix: 'fal',
    iconName: 'bread-loaf',
    icon: [640, 512, [], "f7eb", "M400 32H240C107 32 0 104 0 192C0 227 31 256 64 256V448C64 466 78 480 96 480H544C562 480 576 466 576 448V256C609 256 640 227 640 192C640 104 533 32 400 32ZM384 240V448H96V240C96 231 89 224 80 224H64C49 224 32 210 32 192C32 123 127 64 240 64S448 123 448 192C448 210 435 224 420 224H400C391 224 384 231 384 240ZM544 448H416V256H544V448ZM580 224H472C477 214 480 203 480 192C480 140 442 93 383 64H400C513 64 608 123 608 192C608 210 595 224 580 224Z"]
  };
  var faBreadSlice = {
    prefix: 'fal',
    iconName: 'bread-slice',
    icon: [512, 512, [], "f7ec", "M256 32C103 32 0 115 0 193C0 228 27 253 64 256V434C64 459 85 480 110 480H402C427 480 448 459 448 434V256C485 253 512 228 512 193C512 115 409 32 256 32ZM443 224C428 224 416 236 416 251V434C416 442 410 448 402 448H110C102 448 96 442 96 434V251C96 236 84 224 69 224C47 224 32 212 32 193C32 140 112 64 256 64S480 140 480 193C480 212 465 224 443 224Z"]
  };
  var faBriefcase = {
    prefix: 'fal',
    iconName: 'briefcase',
    icon: [512, 512, [], "f0b1", "M448 96H384V48C384 22 362 0 336 0H176C150 0 128 22 128 48V96H64C29 96 0 125 0 160V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM160 48C160 39 167 32 176 32H336C345 32 352 39 352 48V96H160V48ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V288H176V352C176 361 183 368 192 368H320C329 368 336 361 336 352V288H480V416ZM208 336V288H304V336H208ZM480 256H32V160C32 142 46 128 64 128H448C466 128 480 142 480 160V256Z"]
  };
  var faBriefcaseClock = {
    prefix: 'fal',
    iconName: 'briefcase-clock',
    icon: [640, 512, [], "f64a", "M496 224C416 224 352 288 352 368S416 512 496 512S640 448 640 368S576 224 496 224ZM496 480C434 480 384 430 384 368S434 256 496 256S608 306 608 368S558 480 496 480ZM544 352H512V304C512 295 505 288 496 288S480 295 480 304V368C480 377 487 384 496 384H544C553 384 560 377 560 368S553 352 544 352ZM336 448H64C46 448 32 434 32 416V288H176V352C176 361 183 368 192 368H304C313 368 320 361 320 352S313 336 304 336H208V288H336C345 288 352 281 352 272S345 256 336 256H32V160C32 142 46 128 64 128H448C466 128 480 142 480 160V176C480 185 487 192 496 192S512 185 512 176V160C512 125 483 96 448 96H384V48C384 22 362 0 336 0H176C150 0 128 22 128 48V96H64C29 96 0 125 0 160V416C0 451 29 480 64 480H336C345 480 352 473 352 464S345 448 336 448ZM160 48C160 39 167 32 176 32H336C345 32 352 39 352 48V96H160V48Z"]
  };
  var faBriefcaseMedical = {
    prefix: 'fal',
    iconName: 'briefcase-medical',
    icon: [512, 512, [], "f469", "M448 96H384V48C384 22 362 0 336 0H176C150 0 128 22 128 48V96H64C29 96 0 125 0 160V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM160 48C160 39 167 32 176 32H336C345 32 352 39 352 48V96H160V48ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V160C32 142 46 128 64 128H448C466 128 480 142 480 160V416ZM336 256H288V208C288 199 281 192 272 192H240C231 192 224 199 224 208V256H176C167 256 160 263 160 272V304C160 313 167 320 176 320H224V368C224 377 231 384 240 384H272C281 384 288 377 288 368V320H336C345 320 352 313 352 304V272C352 263 345 256 336 256Z"]
  };
  var faBringForward = {
    prefix: 'fal',
    iconName: 'bring-forward',
    icon: [512, 512, [], "f856", "M416 416H256V400C256 391 249 384 240 384H240C231 384 224 391 224 400V432C224 441 231 448 240 448H432C441 448 448 441 448 432V240C448 231 441 224 432 224H400C391 224 384 231 384 240V240C384 249 391 256 400 256H416V416ZM352 288V64C352 29 323 0 288 0H64C29 0 0 29 0 64V288C0 323 29 352 64 352H288C323 352 352 323 352 288ZM32 288V64C32 46 46 32 64 32H288C306 32 320 46 320 64V288C320 306 306 320 288 320H64C46 320 32 306 32 288ZM448 160H400C391 160 384 167 384 176V176C384 185 391 192 400 192H448C466 192 480 206 480 224V448C480 466 466 480 448 480H224C206 480 192 466 192 448V400C192 391 185 384 176 384H176C167 384 160 391 160 400V448C160 483 189 512 224 512H448C483 512 512 483 512 448V224C512 189 483 160 448 160Z"]
  };
  var faBringFront = {
    prefix: 'fal',
    iconName: 'bring-front',
    icon: [640, 512, [], "f857", "M112 224H64C46 224 32 210 32 192V64C32 46 46 32 64 32H192C206 32 218 41 222 53C225 60 231 64 239 64H239C249 64 256 54 253 44C245 19 220 0 192 0H64C29 0 0 29 0 64V192C0 227 29 256 64 256H112C121 256 128 249 128 240S121 224 112 224ZM480 352V160C480 125 451 96 416 96H224C189 96 160 125 160 160V352C160 387 189 416 224 416H416C451 416 480 387 480 352ZM192 352V160C192 142 206 128 224 128H416C434 128 448 142 448 160V352C448 370 434 384 416 384H224C206 384 192 370 192 352ZM160 79C160 71 153 64 145 64H80C71 64 64 71 64 80V176C64 185 71 192 80 192H113C121 192 128 185 128 177V175C128 167 121 160 113 160H96V96H145C153 96 160 89 160 81V79ZM576 256H528C519 256 512 263 512 272S519 288 528 288H576C594 288 608 302 608 320V448C608 466 594 480 576 480H448C434 480 422 471 418 459C415 452 409 448 401 448H401C391 448 384 458 387 468C395 493 420 512 448 512H576C611 512 640 483 640 448V320C640 285 611 256 576 256ZM480 433C480 441 487 448 495 448H560C569 448 576 441 576 432V336C576 327 569 320 560 320H527C519 320 512 327 512 335V337C512 345 519 352 527 352H544V416H495C487 416 480 423 480 431V433Z"]
  };
  var faBroom = {
    prefix: 'fal',
    iconName: 'broom',
    icon: [640, 512, [], "f51a", "M636 6C631 -1 621 -2 614 3L382 189L342 138C342 138 341 138 341 138C330 123 306 125 297 143L273 194C271 200 272 206 275 211L356 314C358 315 363 322 372 320L427 308C446 304 454 281 442 266L402 214L634 28C641 23 642 13 636 6ZM412 278L375 286L307 199L322 165L412 278ZM304 332C304 333 290 415 242 452C207 480 94 481 35 479C36 472 38 463 40 454L122 360C136 343 119 319 98 326L78 333C90 306 101 294 108 288C156 251 241 256 242 256C264 257 265 226 244 224C240 224 146 219 89 263C69 278 51 308 35 355C31 367 43 380 56 375L71 370L14 436C12 438 11 440 10 443C4 471 0 492 0 492C-2 504 8 510 15 510C21 511 45 512 75 512C136 512 224 507 262 477C319 433 335 341 336 337C339 317 308 311 304 332Z"]
  };
  var faBrowser = {
    prefix: 'fal',
    iconName: 'browser',
    icon: [512, 512, [], "f37e", "M448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM32 96C32 78 46 64 64 64H128V128H32V96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V160H480V416ZM480 128H160V64H448C466 64 480 78 480 96V128Z"]
  };
  var faBrowsers = {
    prefix: 'fal',
    iconName: 'browsers',
    icon: [576, 512, [], "e0af", "M464 480H96C61 480 32 451 32 416V112C32 103 25 96 16 96S0 103 0 112V416C0 469 43 512 96 512H464C473 512 480 505 480 496S473 480 464 480ZM512 0H160C125 0 96 29 96 64V352C96 387 125 416 160 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM128 64C128 46 142 32 160 32H224V96H128V64ZM544 352C544 370 530 384 512 384H160C142 384 128 370 128 352V128H544V352ZM544 96H256V32H512C530 32 544 46 544 64V96Z"]
  };
  var faBrush = {
    prefix: 'fal',
    iconName: 'brush',
    icon: [384, 512, [], "f55d", "M320 0H64C29 0 0 29 0 64V288C0 341 43 384 96 384H128V445C128 477 150 506 181 511C221 518 256 487 256 448V384H288C341 384 384 341 384 288V64C384 29 355 0 320 0ZM288 352H224V448C224 466 210 480 192 480S160 466 160 448V352H96C61 352 32 323 32 288H352C352 323 323 352 288 352ZM352 256H32V64C32 46 46 32 64 32H96V144C96 153 103 160 112 160S128 153 128 144V32H192V112C192 121 199 128 208 128S224 121 224 112V32H320C338 32 352 46 352 64V256Z"]
  };
  var faBug = {
    prefix: 'fal',
    iconName: 'bug',
    icon: [576, 512, [], "f188", "M224 96C224 61 253 32 288 32S352 61 352 96V128H384V96C384 43 341 0 288 0S192 43 192 96V128H224V96ZM528 272H432V184L506 125C513 119 514 109 508 102C503 95 493 94 486 100L410 160H166L90 99C83 94 73 95 67 102C62 109 63 119 70 124L144 184V272H48C39 272 32 279 32 288S39 304 48 304H144V352C144 369 147 385 153 400L69 485C62 491 62 501 69 507C72 510 76 512 80 512S88 510 91 507L170 429C193 460 230 480 272 480H304C346 480 383 460 406 429L485 507C488 510 492 512 496 512S504 510 507 507C514 501 514 491 507 485L423 400C429 385 432 369 432 352V304H528C537 304 544 297 544 288S537 272 528 272ZM400 352C400 405 357 448 304 448V240C304 231 297 224 288 224S272 231 272 240V448C219 448 176 405 176 352V192H400V352Z"]
  };
  var faBuilding = {
    prefix: 'fal',
    iconName: 'building',
    icon: [448, 512, [], "f1ad", "M432 480H416V48C416 22 394 0 368 0H80C54 0 32 22 32 48V480H16C7 480 0 487 0 496S7 512 16 512H176C185 512 192 505 192 496V384H256V496C256 505 263 512 272 512H432C441 512 448 505 448 496S441 480 432 480ZM384 480H288V384C288 366 274 352 256 352H192C174 352 160 366 160 384V480H64V48C64 39 71 32 80 32H368C377 32 384 39 384 48V480ZM192 80H128C119 80 112 87 112 96V160C112 169 119 176 128 176H192C201 176 208 169 208 160V96C208 87 201 80 192 80ZM176 144H144V112H176V144ZM320 80H256C247 80 240 87 240 96V160C240 169 247 176 256 176H320C329 176 336 169 336 160V96C336 87 329 80 320 80ZM304 144H272V112H304V144ZM192 208H128C119 208 112 215 112 224V288C112 297 119 304 128 304H192C201 304 208 297 208 288V224C208 215 201 208 192 208ZM176 272H144V240H176V272ZM320 208H256C247 208 240 215 240 224V288C240 297 247 304 256 304H320C329 304 336 297 336 288V224C336 215 329 208 320 208ZM304 272H272V240H304V272Z"]
  };
  var faBullhorn = {
    prefix: 'fal',
    iconName: 'bullhorn',
    icon: [512, 512, [], "f0a1", "M416 0C409 0 402 2 396 7L311 75C268 109 215 128 160 128H64C29 128 0 157 0 192V288C0 323 29 352 64 352H160C215 352 268 371 311 405L396 473C401 477 410 480 416 480C441 480 448 457 448 448V32C448 23 441 0 416 0ZM160 320H64C46 320 32 306 32 288V192C32 174 46 160 64 160H160V320ZM416 448L331 380C291 348 243 328 192 322V158C243 152 291 132 331 100L416 32C416 32 416 32 416 32C416 32 416 32 416 32L416 32L416 447C416 447 416 448 416 448ZM192 384C191 375 184 368 175 368C166 368 159 376 160 384C161 422 188 455 188 455C192 459 193 466 191 472C189 477 186 480 182 480H131C128 480 126 478 124 476C123 474 95 434 96 384C96 376 89 368 80 368C72 368 64 375 64 384C63 443 94 489 98 494C106 506 118 512 131 512H182C200 512 215 501 221 483C227 466 224 447 213 435C213 434 192 409 192 384ZM496 192C487 192 480 199 480 208V272C480 281 487 288 496 288S512 281 512 272V208C512 199 505 192 496 192Z"]
  };
  var faBullseye = {
    prefix: 'fal',
    iconName: 'bullseye',
    icon: [512, 512, [], "f140", "M256 176C212 176 176 212 176 256S212 336 256 336S336 300 336 256S300 176 256 176ZM256 304C230 304 208 282 208 256S230 208 256 208S304 230 304 256S282 304 256 304ZM256 96C168 96 96 168 96 256S168 416 256 416S416 344 416 256S344 96 256 96ZM256 384C185 384 128 327 128 256S185 128 256 128S384 185 384 256S327 384 256 384ZM256 16C124 16 16 124 16 256S124 496 256 496S496 388 496 256S388 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faBullseyeArrow = {
    prefix: 'fal',
    iconName: 'bullseye-arrow',
    icon: [512, 512, [], "f648", "M459 208C451 209 445 218 446 226C447 236 448 246 448 256C448 371 355 464 240 464C125 464 32 371 32 256S125 48 240 48C250 48 260 49 270 50C278 51 287 45 288 37S283 20 274 18C263 17 251 16 240 16C108 16 0 124 0 256S108 496 240 496C372 496 480 388 480 256C480 245 479 233 478 222C476 213 468 207 459 208ZM216 214C224 210 226 200 222 193C217 185 208 182 200 187C175 201 160 228 160 256C160 300 196 336 240 336C268 336 295 321 309 296C314 288 311 279 303 274C296 270 286 272 282 280C273 295 257 304 240 304C214 304 192 282 192 256C192 239 201 223 216 214ZM256 112C256 103 249 96 240 96C152 96 80 168 80 256S152 416 240 416S400 344 400 256C400 247 393 240 384 240S368 247 368 256C368 327 311 384 240 384S112 327 112 256S169 128 240 128C249 128 256 121 256 112ZM495 107C494 102 489 97 483 96L414 82L400 13C399 7 394 2 389 1C383 -1 377 1 373 5L309 69C305 72 303 78 304 83L319 155L229 245C222 251 222 261 229 267C235 274 245 274 251 267L341 177L413 192C414 192 415 192 416 192C420 192 424 190 427 187L491 123C495 119 497 113 495 107ZM337 85L374 48L383 91L346 128L337 85ZM411 159L368 150L405 113L448 122L411 159Z"]
  };
  var faBullseyePointer = {
    prefix: 'fal',
    iconName: 'bullseye-pointer',
    icon: [512, 512, [], "f649", "M267 245C263 240 256 239 251 241L27 321C20 323 16 329 16 336C16 342 20 349 26 351L107 382L5 485C-2 491 -2 501 5 507C8 510 12 512 16 512S24 510 27 507L130 405L161 486C163 492 169 496 176 496H176C183 496 189 492 191 485L271 261C273 256 272 249 267 245ZM175 434L151 370C149 366 146 363 142 361L78 337L230 282L175 434ZM256 16C124 16 16 124 16 256C16 265 23 272 32 272S48 265 48 256C48 141 141 48 256 48S464 141 464 256S371 464 256 464C247 464 240 471 240 480S247 496 256 496C388 496 496 388 496 256S388 16 256 16ZM288 412C289 412 290 412 292 412C365 395 416 331 416 256C416 168 344 96 256 96C181 96 117 147 100 220C98 229 103 238 112 240C121 241 129 236 131 228C144 169 196 128 256 128C327 128 384 185 384 256C384 316 343 368 284 381C276 383 270 391 272 400C274 407 281 412 288 412ZM303 302C306 303 309 304 311 304C317 304 322 301 325 296C332 284 336 270 336 256C336 212 300 176 256 176C242 176 228 180 216 187C208 191 206 201 210 209C215 216 224 219 232 214C239 210 248 208 256 208C282 208 304 230 304 256C304 264 302 273 298 280C293 288 296 297 303 302Z"]
  };
  var faBurger = {
    prefix: 'fal',
    iconName: 'burger',
    icon: [512, 512, [], "f805", "M352 176C361 176 368 169 368 160S361 144 352 144S336 151 336 160S343 176 352 176ZM256 144C265 144 272 137 272 128S265 112 256 112S240 119 240 128S247 144 256 144ZM160 176C169 176 176 169 176 160S169 144 160 144S144 151 144 160S151 176 160 176ZM512 304C512 281 500 261 482 250C483 248 485 246 487 244C499 222 499 194 487 172C443 97 353 48 256 48C159 48 69 97 25 172C13 194 13 222 25 244C27 246 28 248 30 250C12 261 0 281 0 304C0 323 8 340 21 351C18 356 16 362 16 368V384C16 428 52 464 96 464H416C460 464 496 428 496 384V368C496 362 494 356 491 351C504 340 512 323 512 304ZM53 188C90 124 172 80 256 80C340 80 422 124 459 188C467 202 465 218 459 228C456 232 450 240 440 240H72C62 240 56 232 53 228C47 218 45 202 53 188ZM464 384C464 410 442 432 416 432H96C70 432 48 410 48 384V368H464V384ZM448 336H64C46 336 32 322 32 304S46 272 64 272H448C466 272 480 286 480 304S466 336 448 336Z"]
  };
  var faBurgerCheese = {
    prefix: 'fal',
    iconName: 'burger-cheese',
    icon: [512, 512, [], "f7f1", "M256 144C265 144 272 137 272 128S265 112 256 112S240 119 240 128S247 144 256 144ZM352 176C361 176 368 169 368 160S361 144 352 144S336 151 336 160S343 176 352 176ZM512 304C512 281 500 261 482 250C483 248 485 246 487 244C499 222 499 194 487 172C443 97 353 48 256 48C159 48 69 97 25 172C13 194 13 222 25 244C27 246 28 248 30 250C12 261 0 281 0 304C0 323 8 340 21 351C18 356 16 362 16 368V384C16 428 52 464 96 464H416C460 464 496 428 496 384V368C496 362 494 356 491 351C504 340 512 323 512 304ZM53 188C90 124 172 80 256 80C340 80 422 124 459 188C467 202 465 218 459 228C456 232 450 240 440 240H72C62 240 56 232 53 228C47 218 45 202 53 188ZM377 272L320 329L263 272H377ZM32 304C32 286 46 272 64 272H217L281 336H64C46 336 32 322 32 304ZM464 384C464 410 442 432 416 432H96C70 432 48 410 48 384V368H464V384ZM448 336H359L423 272H448C466 272 480 286 480 304S466 336 448 336ZM160 176C169 176 176 169 176 160S169 144 160 144S144 151 144 160S151 176 160 176Z"]
  };
  var faBurgerFries = {
    prefix: 'fal',
    iconName: 'burger-fries',
    icon: [640, 512, [], "e0b0", "M160 272C169 272 176 265 176 256L176 32L208 48V256C208 265 215 272 224 272S240 265 240 256V48C240 36 233 25 222 19L190 3C181 -2 169 -1 159 5C150 10 144 21 144 32V256C144 265 151 272 160 272ZM96 208C97 208 98 208 99 208C107 206 113 198 112 189L90 64L120 47C128 43 130 33 126 25C122 18 112 15 104 19L64 42C58 45 55 52 56 59L80 195C82 203 88 208 96 208ZM267 63L301 75L272 188C270 197 276 205 284 208C285 208 287 208 288 208C295 208 302 203 304 196L336 68C338 60 333 51 325 49L277 33C269 30 260 35 257 43C254 51 259 60 267 63ZM365 160C366 160 367 160 368 160C376 160 382 154 384 147L392 101C393 93 387 84 378 83C370 82 362 87 360 96L352 141C351 150 357 158 365 160ZM32 192C34 192 35 192 36 192C44 190 50 181 48 173L32 93C30 84 22 79 13 80C4 82 -1 91 0 99L17 179C18 187 25 192 32 192ZM640 376C640 361 634 347 624 337C624 336 624 336 624 336V296C624 272 614 249 594 230C562 197 504 176 448 176H448C392 176 334 197 302 230C282 249 272 272 272 296V336C272 336 272 336 272 337C262 347 256 361 256 376C256 391 262 405 272 415C272 416 272 416 272 416V460C272 489 295 512 324 512H572C601 512 624 489 624 460V416C624 416 624 416 624 415C634 405 640 391 640 376ZM304 296C304 280 311 266 324 252C351 226 400 208 448 208C448 208 448 208 448 208C496 208 545 226 572 252C585 266 592 280 592 296V321C589 320 587 320 584 320H312C309 320 307 320 304 321V296ZM592 460C592 471 583 480 572 480H324C313 480 304 471 304 460V431C307 432 309 432 312 432H584C587 432 589 432 592 431V460ZM584 400H312C299 400 288 389 288 376C288 363 299 352 312 352H584C597 352 608 363 608 376C608 389 597 400 584 400ZM368 288C377 288 384 281 384 272S377 256 368 256S352 263 352 272S359 288 368 288ZM448 272C457 272 464 265 464 256S457 240 448 240S432 247 432 256S439 272 448 272ZM528 288C537 288 544 281 544 272S537 256 528 256S512 263 512 272S519 288 528 288ZM240 480H93L37 256H41L65 280C91 305 123 322 159 330C189 336 213 333 227 330C235 329 240 322 240 314C240 304 231 297 221 299C209 301 192 303 171 299C143 295 104 273 84 253L62 231C56 226 52 224 48 224H16C11 224 6 226 3 230C0 234 -1 239 0 244L64 500C66 507 73 512 80 512H240C249 512 256 505 256 496C256 487 249 480 240 480Z"]
  };
  var faBurgerGlass = {
    prefix: 'fal',
    iconName: 'burger-glass',
    icon: [640, 512, [], "e0b1", "M224 480H83C76 480 70 475 70 468L45 192H272C281 192 288 185 288 176S281 160 272 160H42L32 48C31 40 37 32 45 32H307C315 32 321 40 320 48L310 142C309 151 316 159 324 160C333 161 341 154 342 146L352 51C354 27 337 0 307 0H45C11 0 -2 32 0 51L38 471C40 494 59 512 83 512H224C233 512 240 505 240 496S233 480 224 480ZM528 288C537 288 544 281 544 272S537 256 528 256S512 263 512 272S519 288 528 288ZM368 288C377 288 384 281 384 272S377 256 368 256S352 263 352 272S359 288 368 288ZM448 272C457 272 464 265 464 256S457 240 448 240S432 247 432 256S439 272 448 272ZM640 376C640 361 634 347 624 337C624 336 624 336 624 336V296C624 272 614 249 594 230C523 158 373 158 302 230C282 249 272 272 272 296V336C272 336 272 336 272 337C262 347 256 361 256 376S262 405 272 415C272 416 272 416 272 416V460C272 489 295 512 324 512H572C601 512 624 489 624 460V416C624 416 624 416 624 415C634 405 640 391 640 376ZM304 296C304 280 311 266 324 252C381 196 510 191 572 252C585 266 592 280 592 296V321C589 320 587 320 584 320H312C309 320 307 320 304 321V296ZM592 460C592 471 583 480 572 480H324C313 480 304 471 304 460V431C307 432 309 432 312 432H584C587 432 589 432 592 431V460ZM584 400H312C299 400 288 389 288 376C288 363 299 352 312 352H584C597 352 608 363 608 376C608 389 597 400 584 400Z"]
  };
  var faBurgerSoda = {
    prefix: 'fal',
    iconName: 'burger-soda',
    icon: [640, 512, [], "f858", "M448 272C457 272 464 265 464 256S457 240 448 240S432 247 432 256S439 272 448 272ZM528 288C537 288 544 281 544 272S537 256 528 256S512 263 512 272S519 288 528 288ZM224 480L96 479L64 160H336C345 160 352 153 352 144C352 135 345 128 336 128H212L236 32H272C281 32 288 25 288 16S281 0 272 0H236C222 0 209 10 205 24L179 128H16C7 128 0 135 0 144C0 153 7 160 16 160H32L64 482C65 499 79 512 96 512H224C233 512 240 505 240 496V496C240 487 233 480 224 480ZM368 288C377 288 384 281 384 272S377 256 368 256S352 263 352 272S359 288 368 288ZM640 376C640 361 634 347 624 337C624 336 624 336 624 336V296C624 272 614 249 594 230C523 158 373 158 302 230C282 249 272 272 272 296V336C272 336 272 336 272 337C262 347 256 361 256 376S262 405 272 415C272 416 272 416 272 416V460C272 489 295 512 324 512H572C601 512 624 489 624 460V416C624 416 624 416 624 415C634 405 640 391 640 376ZM304 296C304 280 311 266 324 252C381 196 510 191 572 252C585 266 592 280 592 296V321C589 320 587 320 584 320H312C309 320 307 320 304 321V296ZM592 460C592 471 583 480 572 480H324C313 480 304 471 304 460V431C307 432 309 432 312 432H584C587 432 589 432 592 431V460ZM584 400H312C299 400 288 389 288 376C288 363 299 352 312 352H584C597 352 608 363 608 376C608 389 597 400 584 400Z"]
  };
  var faBurrito = {
    prefix: 'fal',
    iconName: 'burrito',
    icon: [512, 512, [], "f7ed", "M512 123C512 91 491 62 460 52C453 32 439 15 419 7C400 -2 377 -2 358 7C317 -11 270 8 252 48L34 267C-11 312 -11 385 34 431L81 478C127 523 200 523 245 478L464 260C504 242 523 195 505 154C510 144 512 134 512 123ZM267 78C281 103 288 132 288 160C288 257 209 336 112 336C86 336 61 330 37 319C42 308 48 298 57 289L267 78ZM223 455C190 488 137 488 104 455L57 408C42 393 33 373 32 352C58 363 85 368 112 368C202 368 279 310 308 230C350 219 395 224 434 244L223 455ZM480 186C480 201 473 215 462 224C418 197 366 187 317 195C319 184 320 172 320 160C320 121 309 84 288 51C297 39 311 32 326 32C338 32 350 37 359 45C371 33 389 29 405 35C421 42 431 57 431 74C431 77 431 79 430 82C442 79 455 83 465 91C474 99 480 110 480 123C480 134 475 145 467 153C475 162 480 174 480 186Z"]
  };
  var faBus = {
    prefix: 'fal',
    iconName: 'bus',
    icon: [576, 512, [], "f207", "M416 376C429 376 440 365 440 352S429 328 416 328S392 339 392 352S403 376 416 376ZM16 128C7 128 0 135 0 144V240C0 249 7 256 16 256S32 249 32 240V144C32 135 25 128 16 128ZM288 0C163 0 64 51 64 96V384C64 408 77 428 96 439V496C96 505 103 512 112 512S128 505 128 496V448H448V496C448 505 455 512 464 512S480 505 480 496V439C499 428 512 408 512 384V96C512 51 413 0 288 0ZM480 384C480 402 466 416 448 416H128C110 416 96 402 96 384L96 288H480V384ZM96 160H272V256H96L96 160ZM480 256H304V160H480V256ZM480 128H96V96C98 80 169 32 288 32S478 80 480 96V128ZM160 376C173 376 184 365 184 352S173 328 160 328S136 339 136 352S147 376 160 376ZM560 128C551 128 544 135 544 144V240C544 249 551 256 560 256S576 249 576 240V144C576 135 569 128 560 128ZM336 64H240C231 64 224 71 224 80S231 96 240 96H336C345 96 352 89 352 80S345 64 336 64Z"]
  };
  var faBusSchool = {
    prefix: 'fal',
    iconName: 'bus-school',
    icon: [576, 512, [], "f5dd", "M32 128C23 128 16 135 16 144V240C16 249 23 256 32 256S48 249 48 240V144C48 135 41 128 32 128ZM544 128C535 128 528 135 528 144V240C528 249 535 256 544 256S560 249 560 240V144C560 135 553 128 544 128ZM160 328C147 328 136 339 136 352S147 376 160 376S184 365 184 352S173 328 160 328ZM416 328C403 328 392 339 392 352S403 376 416 376S440 365 440 352S429 328 416 328ZM336 64H240C231 64 224 71 224 80S231 96 240 96H336C345 96 352 89 352 80S345 64 336 64ZM496 96C496 51 404 0 288 0S80 51 80 96V299C70 314 64 332 64 352V384C64 408 77 428 96 439V496C96 505 103 512 112 512S128 505 128 496V448H448V496C448 505 455 512 464 512S480 505 480 496V439C499 428 512 408 512 384V352C512 332 506 314 496 299V96ZM112 96C112 81 176 32 288 32S464 81 464 96V128H112V96ZM464 160V269C450 261 434 256 416 256H304V160H464ZM112 160H272V256H160C142 256 126 261 112 269V160ZM480 384C480 402 466 416 448 416H128C110 416 96 402 96 384V352C96 317 125 288 160 288H416C451 288 480 317 480 352V384Z"]
  };
  var faBusSimple = {
    prefix: 'fal',
    iconName: 'bus-simple',
    icon: [448, 512, [], "f55e", "M96 376C109 376 120 365 120 352S109 328 96 328S72 339 72 352S83 376 96 376ZM352 376C365 376 376 365 376 352S365 328 352 328S328 339 328 352S339 376 352 376ZM224 0C99 0 0 51 0 96V384C0 408 13 428 32 439V496C32 505 39 512 48 512C57 512 64 505 64 496V448H384V496C384 505 391 512 400 512C409 512 416 505 416 496V439C435 428 448 408 448 384V96C448 51 349 0 224 0ZM416 384C416 402 402 416 384 416H64C46 416 32 402 32 384L32 288L32 288H416V384ZM416 256H32L32 128H416V256ZM32 96C34 80 105 32 224 32C343 32 414 80 416 96H32Z"]
  };
  var faC = {
    prefix: 'fal',
    iconName: 'c',
    icon: [384, 512, [], "e0b2", "M222 480C163 480 107 457 65 414C-22 327 -22 185 65 98C107 55 163 32 222 32C282 32 337 55 379 98C386 104 386 114 379 120C373 126 363 126 357 120C321 84 273 64 222 64C171 64 124 84 88 120C13 195 13 317 88 392C124 428 171 448 222 448C273 448 321 428 357 392C363 386 373 386 379 392C386 398 386 408 379 414C337 457 282 480 222 480Z"]
  };
  var faCabinetFiling = {
    prefix: 'fal',
    iconName: 'cabinet-filing',
    icon: [448, 512, [], "f64b", "M384 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H384C419 512 448 483 448 448V64C448 29 419 0 384 0ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V272H416V448ZM416 240H32V64C32 46 46 32 64 32H384C402 32 416 46 416 64V240ZM304 96H144C135 96 128 103 128 112V144C128 153 135 160 144 160S160 153 160 144V128H288V144C288 153 295 160 304 160S320 153 320 144V112C320 103 313 96 304 96ZM144 416C153 416 160 409 160 400V384H288V400C288 409 295 416 304 416S320 409 320 400V368C320 359 313 352 304 352H144C135 352 128 359 128 368V400C128 409 135 416 144 416Z"]
  };
  var faCableCar = {
    prefix: 'fal',
    iconName: 'cable-car',
    icon: [512, 512, [], "e0b3", "M511 52C509 43 500 38 492 41L12 169C3 171 -2 180 1 188C3 197 12 202 20 199L240 141V224H96C61 224 32 253 32 288V448C32 483 61 512 96 512H416C451 512 480 483 480 448V288C480 253 451 224 416 224H272V132L500 71C509 69 514 60 511 52ZM64 288C64 270 78 256 96 256H160V352H64V288ZM448 448C448 466 434 480 416 480H96C78 480 64 466 64 448V384H448V448ZM352 256H416C434 256 448 270 448 288V352H352V256ZM320 256V352H192V256H320ZM288 56C301 56 312 45 312 32S301 8 288 8S264 19 264 32S275 56 288 56ZM192 88C205 88 216 77 216 64S205 40 192 40S168 51 168 64S179 88 192 88Z"]
  };
  var faCactus = {
    prefix: 'fal',
    iconName: 'cactus',
    icon: [512, 512, [], "f8a7", "M272 352C263 352 256 359 256 368S263 384 272 384S288 377 288 368S281 352 272 352ZM492 221C479 211 463 206 446 209C419 213 400 239 400 267V296C400 300 396 304 392 304H352V101C352 49 313 3 261 0C235 -1 209 8 190 26C171 45 160 70 160 96V192H120C116 192 112 188 112 184V155C112 127 93 101 66 97C49 94 33 99 20 109S0 135 0 152V184C0 250 54 304 120 304H160V496C160 505 167 512 176 512H336C345 512 352 505 352 496V416H392C458 416 512 362 512 296V264C512 247 505 232 492 221ZM160 272H120C71 272 32 233 32 184V152C32 139 43 128 56 128S80 139 80 152V184C80 206 98 224 120 224H160V272ZM320 480H192V96C192 61 221 32 256 32S320 61 320 96V480ZM480 296C480 345 441 384 392 384H352V336H392C414 336 432 318 432 296V264C432 251 443 240 456 240S480 251 480 264V296ZM240 128C231 128 224 135 224 144S231 160 240 160S256 153 256 144S249 128 240 128Z"]
  };
  var faCakeCandles = {
    prefix: 'fal',
    iconName: 'cake-candles',
    icon: [448, 512, [], "f1fd", "M352 128C378 128 400 106 400 80C400 56 363 8 358 3C357 1 354 0 352 0S347 1 346 3C341 8 304 56 304 80C304 106 326 128 352 128ZM352 49C361 63 367 75 368 80C368 89 361 96 352 96S336 89 336 80C337 75 343 63 352 49ZM224 128C250 128 272 106 272 80C272 56 235 8 230 3C229 1 226 0 224 0S219 1 218 3C213 8 176 56 176 80C176 106 198 128 224 128ZM224 49C233 63 239 75 240 80C240 89 233 96 224 96S208 89 208 80C209 75 215 63 224 49ZM96 128C122 128 144 106 144 80C144 56 107 8 102 3C101 1 98 0 96 0S91 1 90 3C85 8 48 56 48 80C48 106 70 128 96 128ZM96 49C105 63 111 75 112 80C112 89 105 96 96 96S80 89 80 80C81 75 87 63 96 49ZM384 224H368V176C368 167 361 160 352 160S336 167 336 176V224H240V176C240 167 233 160 224 160S208 167 208 176V224H112V176C112 167 105 160 96 160S80 167 80 176V224H64C29 224 0 253 0 288V464C0 490 22 512 48 512H400C426 512 448 490 448 464V288C448 253 419 224 384 224ZM416 464C416 473 409 480 400 480H48C39 480 32 473 32 464V400C58 400 82 384 96 373C110 384 134 400 160 400S210 384 224 373C238 384 262 400 288 400S338 384 352 373C366 384 390 400 416 400V464ZM416 368C395 368 371 348 363 341C357 334 347 334 341 341C333 348 309 368 288 368S243 348 235 341C229 334 219 334 213 341C205 348 181 368 160 368S115 348 107 341C101 334 91 334 85 341C77 348 53 368 32 368V288C32 270 46 256 64 256H80V272C80 281 87 288 96 288S112 281 112 272V256H208V272C208 281 215 288 224 288S240 281 240 272V256H336V272C336 281 343 288 352 288S368 281 368 272V256H384C402 256 416 270 416 288V368Z"]
  };
  var faCalculator = {
    prefix: 'fal',
    iconName: 'calculator',
    icon: [384, 512, [], "f1ec", "M320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V160H352V448ZM352 128H32V64C32 46 46 32 64 32H320C338 32 352 46 352 64V128ZM80 432H208C217 432 224 425 224 416S217 400 208 400H80C71 400 64 407 64 416S71 432 80 432ZM288 440C301 440 312 429 312 416S301 392 288 392S264 403 264 416S275 440 288 440ZM288 344C301 344 312 333 312 320S301 296 288 296S264 307 264 320S275 344 288 344ZM288 248C301 248 312 237 312 224S301 200 288 200S264 211 264 224S275 248 288 248ZM192 344C205 344 216 333 216 320S205 296 192 296S168 307 168 320S179 344 192 344ZM192 248C205 248 216 237 216 224S205 200 192 200S168 211 168 224S179 248 192 248ZM96 344C109 344 120 333 120 320S109 296 96 296S72 307 72 320S83 344 96 344ZM96 248C109 248 120 237 120 224S109 200 96 200S72 211 72 224S83 248 96 248Z"]
  };
  var faCalculatorSimple = {
    prefix: 'fal',
    iconName: 'calculator-simple',
    icon: [512, 512, [], "f64c", "M336 128H384V176C384 185 391 192 400 192S416 185 416 176V128H464C473 128 480 121 480 112S473 96 464 96H416V48C416 39 409 32 400 32S384 39 384 48V96H336C327 96 320 103 320 112S327 128 336 128ZM169 343C162 337 152 337 146 343L112 377L78 343C72 337 62 337 55 343S49 360 55 366L89 400L55 434C49 440 49 450 55 457S72 463 78 457L112 423L146 457C152 463 162 463 169 457S175 440 169 434L135 400L169 366C175 360 175 350 169 343ZM48 128H176C185 128 192 121 192 112S185 96 176 96H48C39 96 32 103 32 112S39 128 48 128ZM496 240H272V16C272 7 265 0 256 0S240 7 240 16V240H16C7 240 0 247 0 256S7 272 16 272H240V496C240 505 247 512 256 512S272 505 272 496V272H496C505 272 512 265 512 256S505 240 496 240ZM464 416H336C327 416 320 423 320 432S327 448 336 448H464C473 448 480 441 480 432S473 416 464 416ZM464 352H336C327 352 320 359 320 368S327 384 336 384H464C473 384 480 377 480 368S473 352 464 352Z"]
  };
  var faCalendar = {
    prefix: 'fal',
    iconName: 'calendar',
    icon: [448, 512, [], "f133", "M384 64H352V16C352 7 345 0 336 0H336C327 0 320 7 320 16V64H128V16C128 7 121 0 112 0H112C103 0 96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM64 96H384C402 96 416 110 416 128V160H32V128C32 110 46 96 64 96ZM384 480H64C46 480 32 466 32 448V192H416V448C416 466 402 480 384 480Z"]
  };
  var faCalendarArrowDown = {
    prefix: 'fal',
    iconName: 'calendar-arrow-down',
    icon: [448, 512, [], "e0b4", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM285 324L240 364V256C240 247 233 240 224 240S208 247 208 256V364L163 324C160 321 156 320 152 320C148 320 143 322 140 325C134 332 135 342 141 348L213 412C219 417 229 417 235 412L307 348C313 342 314 332 308 325C302 319 292 318 285 324Z"]
  };
  var faCalendarArrowUp = {
    prefix: 'fal',
    iconName: 'calendar-arrow-up',
    icon: [448, 512, [], "e0b5", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM163 348L208 308V416C208 425 215 432 224 432S240 425 240 416V308L285 348C288 351 292 352 296 352C300 352 305 350 308 347C314 340 313 330 307 324L235 260C229 255 219 255 213 260L141 324C135 330 134 340 140 347C146 353 156 354 163 348Z"]
  };
  var faCalendarCheck = {
    prefix: 'fal',
    iconName: 'calendar-check',
    icon: [448, 512, [], "f274", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM181 411C184 414 188 416 192 416S200 414 203 411L331 283C338 277 338 267 331 261S315 254 309 261L192 377L139 325C133 318 123 318 117 325S110 341 117 347L181 411Z"]
  };
  var faCalendarClock = {
    prefix: 'fal',
    iconName: 'calendar-clock',
    icon: [576, 512, [], "e0b6", "M432 224C352 224 288 288 288 368S352 512 432 512S576 448 576 368S512 224 432 224ZM432 480C370 480 320 430 320 368S370 256 432 256S544 306 544 368S494 480 432 480ZM480 352H448V304C448 295 441 288 432 288S416 295 416 304V368C416 377 423 384 432 384H480C489 384 496 377 496 368S489 352 480 352ZM301 485C298 482 294 480 289 480H64C46 480 32 466 32 448V192H432C441 192 448 185 448 176V128C448 93 419 64 384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H289C303 512 310 496 301 486C301 486 301 486 301 485ZM32 128C32 110 46 96 64 96H384C402 96 416 110 416 128V160H32V128Z"]
  };
  var faCalendarDay = {
    prefix: 'fal',
    iconName: 'calendar-day',
    icon: [448, 512, [], "f783", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM96 384H192C210 384 224 370 224 352V256C224 238 210 224 192 224H96C78 224 64 238 64 256V352C64 370 78 384 96 384ZM96 256H192V352H96V256Z"]
  };
  var faCalendarDays = {
    prefix: 'fal',
    iconName: 'calendar-days',
    icon: [448, 512, [], "f073", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM32 224H128V288H32V224ZM160 288V224H288V288H160ZM288 320V384H160V320H288ZM32 320H128V384H32V320ZM64 480C46 480 32 466 32 448V416H128V480H64ZM160 480V416H288V480H160ZM416 448C416 466 402 480 384 480H320V416H416V448ZM416 384H320V320H416V384ZM416 288H320V224H416V288ZM416 192H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V192Z"]
  };
  var faCalendarExclamation = {
    prefix: 'fal',
    iconName: 'calendar-exclamation',
    icon: [448, 512, [], "f334", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM224 368C233 368 240 361 240 352V256C240 247 233 240 224 240S208 247 208 256V352C208 361 215 368 224 368ZM224 440C237 440 248 429 248 416C248 403 237 392 224 392S200 403 200 416C200 429 211 440 224 440Z"]
  };
  var faCalendarHeart = {
    prefix: 'fal',
    iconName: 'calendar-heart',
    icon: [448, 512, [], "e0b7", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM214 428C220 433 228 433 234 428L319 342C343 317 342 276 314 253C300 242 267 225 224 268C181 225 148 242 134 253C106 276 105 317 130 342L214 428ZM154 278C168 266 185 274 193 282L224 313L255 282C263 274 280 266 294 278C308 290 306 309 296 320L224 392L152 320C142 309 140 290 154 278Z"]
  };
  var faCalendarImage = {
    prefix: 'fal',
    iconName: 'calendar-image',
    icon: [448, 512, [], "e0b8", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM96 280C109 280 120 269 120 256C120 243 109 232 96 232S72 243 72 256C72 269 83 280 96 280ZM94 448H354C365 448 375 442 380 433C380 433 380 433 380 433C386 423 385 411 379 402L283 268C271 252 244 252 233 268L189 329L182 320C170 306 145 306 133 320L70 401C63 410 62 422 68 432C73 442 83 448 94 448ZM156 340L177 366C181 371 194 377 202 365L257 287L349 416H98L156 340Z"]
  };
  var faCalendarLines = {
    prefix: 'fal',
    iconName: 'calendar-lines',
    icon: [448, 512, [], "e0b9", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM112 304H336C345 304 352 297 352 288S345 272 336 272H112C103 272 96 279 96 288S103 304 112 304ZM112 400H240C249 400 256 393 256 384S249 368 240 368H112C103 368 96 375 96 384S103 400 112 400Z"]
  };
  var faCalendarMinus = {
    prefix: 'fal',
    iconName: 'calendar-minus',
    icon: [448, 512, [], "f272", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM160 352H288C297 352 304 345 304 336S297 320 288 320H160C151 320 144 327 144 336S151 352 160 352Z"]
  };
  var faCalendarPen = {
    prefix: 'fal',
    iconName: 'calendar-pen',
    icon: [448, 512, [], "f333", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM131 448L192 436C195 435 198 433 200 431L322 309C330 301 335 292 336 281C337 268 332 255 323 246L315 238C307 230 298 225 287 224C274 223 261 228 252 237L129 360C127 362 125 365 124 368L112 429C110 440 120 450 131 448ZM275 259C279 255 287 255 291 259L301 269C305 273 305 281 301 285L290 297L263 270L275 259ZM155 379L241 293L267 319L181 405L148 412L155 379Z"]
  };
  var faCalendarPlus = {
    prefix: 'fal',
    iconName: 'calendar-plus',
    icon: [448, 512, [], "f271", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM160 352H208V400C208 409 215 416 224 416S240 409 240 400V352H288C297 352 304 345 304 336S297 320 288 320H240V272C240 263 233 256 224 256S208 263 208 272V320H160C151 320 144 327 144 336S151 352 160 352Z"]
  };
  var faCalendarRange = {
    prefix: 'fal',
    iconName: 'calendar-range',
    icon: [448, 512, [], "e0ba", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM96 320H128C146 320 160 306 160 288V256C160 238 146 224 128 224H96C78 224 64 238 64 256V288C64 306 78 320 96 320ZM96 256H128V288H96V256ZM352 352H320C302 352 288 366 288 384V416C288 434 302 448 320 448H352C370 448 384 434 384 416V384C384 366 370 352 352 352ZM352 416H320V384H352V416ZM208 288H368C377 288 384 281 384 272S377 256 368 256H208C199 256 192 263 192 272S199 288 208 288ZM80 416H240C249 416 256 409 256 400S249 384 240 384H80C71 384 64 391 64 400S71 416 80 416Z"]
  };
  var faCalendarStar = {
    prefix: 'fal',
    iconName: 'calendar-star',
    icon: [448, 512, [], "f736", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM150 369L142 415C140 426 144 436 153 443C162 449 173 450 183 445L224 423L266 445C270 447 274 448 279 448C284 448 290 446 295 443C304 436 308 426 306 415L298 369L332 336C339 329 342 318 339 308C336 297 327 290 316 288L270 282L249 240C244 230 235 224 224 224H224C213 224 204 230 199 240L178 282L132 288L132 288C121 290 112 297 109 308C106 318 109 329 116 336L150 369ZM199 311L224 261L249 311L304 319L264 358L273 413L224 387L175 413L184 358L144 319L199 311Z"]
  };
  var faCalendarWeek = {
    prefix: 'fal',
    iconName: 'calendar-week',
    icon: [448, 512, [], "f784", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM96 384H352C370 384 384 370 384 352V256C384 238 370 224 352 224H96C78 224 64 238 64 256V352C64 370 78 384 96 384ZM96 256H352V352H96V256Z"]
  };
  var faCalendarXmark = {
    prefix: 'fal',
    iconName: 'calendar-xmark',
    icon: [448, 512, [], "f273", "M384 64H352V16C352 7 345 0 336 0S320 7 320 16V64H128V16C128 7 121 0 112 0S96 7 96 16V64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H384C419 512 448 483 448 448V128C448 93 419 64 384 64ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V192H416V448ZM416 160H32V128C32 110 46 96 64 96H384C402 96 416 110 416 128V160ZM157 403C160 406 164 408 168 408S176 406 179 403L224 359L269 403C272 406 276 408 280 408S288 406 291 403C298 397 298 387 291 381L247 336L291 291C298 285 298 275 291 269S275 262 269 269L224 313L179 269C173 262 163 262 157 269S150 285 157 291L201 336L157 381C150 387 150 397 157 403Z"]
  };
  var faCalendars = {
    prefix: 'fal',
    iconName: 'calendars',
    icon: [512, 512, [], "e0bb", "M448 64H416V16C416 7 409 0 400 0S384 7 384 16V64H224V16C224 7 217 0 208 0S192 7 192 16V64H160C125 64 96 93 96 128V352C96 387 125 416 160 416H448C483 416 512 387 512 352V128C512 93 483 64 448 64ZM480 352C480 370 466 384 448 384H160C142 384 128 370 128 352V192H480V352ZM480 160H128V128C128 110 142 96 160 96H448C466 96 480 110 480 128V160ZM400 480H96C61 480 32 451 32 416V176C32 167 25 160 16 160S0 167 0 176V416C0 469 43 512 96 512H400C409 512 416 505 416 496S409 480 400 480Z"]
  };
  var faCamcorder = {
    prefix: 'fal',
    iconName: 'camcorder',
    icon: [576, 512, [], "f8a8", "M304 224H80C71 224 64 231 64 240C64 249 71 256 80 256H304C313 256 320 249 320 240C320 231 313 224 304 224ZM559 164C548 158 535 159 526 166L423 238C416 243 414 253 419 260C424 267 434 269 441 264L544 192V448L441 376C434 371 424 373 419 380C414 387 416 397 423 402L526 474C531 478 538 480 544 480C549 480 554 479 559 476C569 471 576 460 576 448V192C576 180 569 169 559 164ZM320 160H96V112C96 86 118 64 144 64H304C313 64 320 57 320 48C320 39 313 32 304 32H144C100 32 64 68 64 112V160C29 160 0 189 0 224V416C0 451 29 480 64 480H320C355 480 384 451 384 416V224C384 189 355 160 320 160ZM352 416C352 434 338 448 320 448H64C46 448 32 434 32 416V224C32 206 46 192 64 192H320C338 192 352 206 352 224V416Z"]
  };
  var faCamera = {
    prefix: 'fal',
    iconName: 'camera',
    icon: [512, 512, [], "f030", "M448 96H376L368 73C358 49 334 32 308 32H204C178 32 154 49 144 73L136 96H64C29 96 0 125 0 160V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V160C32 142 46 128 64 128H158L174 85C179 72 191 64 204 64H308C321 64 333 72 338 85L354 128H448C466 128 480 142 480 160V416ZM256 168C190 168 136 222 136 288S190 408 256 408S376 354 376 288S322 168 256 168ZM256 376C207 376 168 337 168 288S207 200 256 200S344 239 344 288S305 376 256 376Z"]
  };
  var faCameraCctv = {
    prefix: 'fal',
    iconName: 'camera-cctv',
    icon: [576, 512, [], "f8ac", "M525 194C524 177 513 162 497 156L150 4C144 1 138 0 133 0C114 0 100 12 94 23L6 176C0 188 -2 202 3 215C8 227 17 237 30 241L189 307L149 416H32V368C32 359 25 352 16 352C7 352 0 359 0 368V496C0 505 7 512 16 512C25 512 32 505 32 496V448H160C167 448 173 444 175 438L218 319L290 349C295 351 300 352 306 352C315 352 324 350 331 345L504 237C519 227 527 211 525 194ZM487 209L314 318C311 320 307 321 302 319L41 211C31 208 31 197 34 192L121 39C123 36 129 30 137 33L485 186C495 190 496 204 487 209ZM567 275L519 253C511 250 501 253 497 261C494 269 497 279 505 282L539 298L510 362L422 323C414 320 405 323 401 331C398 339 401 349 410 352L512 397C514 398 516 399 518 399C524 399 530 395 533 389L575 296C578 288 575 279 567 275Z"]
  };
  var faCameraMovie = {
    prefix: 'fal',
    iconName: 'camera-movie',
    icon: [576, 512, [], "f8a9", "M320 256H128C128 256 128 256 128 256H16C7 256 0 263 0 272C0 281 7 288 16 288H73C67 297 64 308 64 320V448C64 483 93 512 128 512H320C355 512 384 483 384 448V320C384 285 355 256 320 256ZM352 448C352 466 338 480 320 480H128C110 480 96 466 96 448V320C96 302 110 288 128 288H176C176 288 176 288 176 288H320C338 288 352 302 352 320V448ZM336 0C295 0 260 22 240 55C220 22 185 0 144 0C82 0 32 50 32 112S82 224 144 224H336C398 224 448 174 448 112S398 0 336 0ZM336 192H144C100 192 64 156 64 112C64 68 100 32 144 32C172 32 198 47 212 71C218 81 229 87 240 87S262 81 268 71C282 47 308 32 336 32C380 32 416 68 416 112C416 156 380 192 336 192ZM553 267C539 258 522 257 507 265L425 306C417 310 414 319 418 327C422 335 431 338 439 334L521 294C528 290 534 293 536 294C539 296 544 300 544 308V460C544 468 539 472 536 474C534 475 528 478 521 475L439 434C431 430 422 433 418 441C414 449 417 458 425 462L507 503C513 507 521 508 528 508C537 508 545 506 553 501C567 492 576 477 576 460V308C576 291 567 276 553 267ZM144 88C131 88 120 99 120 112C120 125 131 136 144 136C157 136 168 125 168 112C168 99 157 88 144 88ZM336 88C323 88 312 99 312 112C312 125 323 136 336 136C349 136 360 125 360 112C360 99 349 88 336 88Z"]
  };
  var faCameraPolaroid = {
    prefix: 'fal',
    iconName: 'camera-polaroid',
    icon: [576, 512, [], "f8aa", "M288 112C244 112 208 148 208 192S244 272 288 272S368 236 368 192S332 112 288 112ZM288 240C262 240 240 218 240 192S262 144 288 144S336 166 336 192S314 240 288 240ZM562 318L512 256V96C512 61 483 32 448 32H128C93 32 64 61 64 96V256L14 318C5 330 0 344 0 358V416C0 451 29 480 64 480H512C547 480 576 451 576 416V358C576 344 571 330 562 318ZM96 267V96C96 78 110 64 128 64H448C466 64 480 78 480 96V267L522 320H54L96 267ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V352L32 352H544C544 352 544 352 544 352V416ZM464 384H112C103 384 96 391 96 400C96 409 103 416 112 416H464C473 416 480 409 480 400C480 391 473 384 464 384ZM416 104C403 104 392 115 392 128C392 141 403 152 416 152C429 152 440 141 440 128C440 115 429 104 416 104Z"]
  };
  var faCameraRetro = {
    prefix: 'fal',
    iconName: 'camera-retro',
    icon: [512, 512, [], "f083", "M80 64H144C153 64 160 57 160 48C160 39 153 32 144 32H80C71 32 64 39 64 48C64 57 71 64 80 64ZM448 32H303C293 32 283 34 274 39L192 80H64C29 80 0 109 0 144V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V288H128C128 359 185 416 256 416S384 359 384 288H480V416ZM160 288C160 235 203 192 256 192S352 235 352 288S309 384 256 384S160 341 160 288ZM480 256H379C365 201 315 160 256 160S147 201 133 256H32V144C32 126 46 112 64 112H184C194 112 204 110 213 105L289 67C293 65 298 64 303 64H448C466 64 480 78 480 96V256Z"]
  };
  var faCameraSecurity = {
    prefix: 'fal',
    iconName: 'camera-security',
    icon: [448, 512, [], "f8fe", "M384 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H108L71 459C63 469 62 482 67 494C72 505 83 512 96 512H352C365 512 376 505 381 494C386 482 385 469 377 460L340 416H384C419 416 448 387 448 352V64C448 29 419 0 384 0ZM352 480H96L149 416H299L352 480ZM416 352C416 370 402 384 384 384H64C46 384 32 370 32 352V64C32 46 46 32 64 32H384C402 32 416 46 416 64V352ZM224 80C153 80 96 137 96 208C96 279 153 336 224 336C295 336 352 279 352 208C352 137 295 80 224 80ZM224 304C171 304 128 261 128 208C128 155 171 112 224 112C277 112 320 155 320 208C320 261 277 304 224 304Z"]
  };
  var faCameraViewfinder = {
    prefix: 'fal',
    iconName: 'camera-viewfinder',
    icon: [512, 512, [], "e0bc", "M496 320C487 320 480 327 480 336V432C480 441 473 448 464 448H368C359 448 352 455 352 464S359 480 368 480H464C490 480 512 458 512 432V336C512 327 505 320 496 320ZM144 448H48C39 448 32 441 32 432V336C32 327 25 320 16 320S0 327 0 336V432C0 458 22 480 48 480H144C153 480 160 473 160 464S153 448 144 448ZM464 32H368C359 32 352 39 352 48S359 64 368 64H464C473 64 480 71 480 80V176C480 185 487 192 496 192S512 185 512 176V80C512 54 490 32 464 32ZM16 192C25 192 32 185 32 176V80C32 71 39 64 48 64H144C153 64 160 57 160 48S153 32 144 32H48C22 32 0 54 0 80V176C0 185 7 192 16 192ZM256 224C238 224 224 238 224 256S238 288 256 288S288 274 288 256S274 224 256 224ZM384 304V208C384 182 362 160 336 160H316L310 144C306 134 297 128 287 128H225C215 128 206 134 202 144L196 160H176C150 160 128 182 128 208V304C128 330 150 352 176 352H336C362 352 384 330 384 304ZM352 304C352 313 345 320 336 320H176C167 320 160 313 160 304V208C160 199 167 192 176 192H218L230 160H282L294 192H336C345 192 352 199 352 208V304Z"]
  };
  var faCameraWeb = {
    prefix: 'fal',
    iconName: 'camera-web',
    icon: [448, 512, [], "f832", "M391 438C388 434 383 432 378 432C365 432 357 448 366 458L384 480H64L82 458C91 448 84 432 70 432H70C65 432 61 434 58 438L41 458C33 468 30 481 35 492C40 504 51 512 64 512H383C395 512 407 506 413 495C419 483 417 469 409 459L391 438ZM224 448C348 448 448 348 448 224C448 100 348 0 224 0C100 0 0 100 0 224C0 348 100 448 224 448ZM224 32C330 32 416 118 416 224S330 416 224 416S32 330 32 224S118 32 224 32ZM224 368C303 368 368 303 368 224S303 80 224 80S80 145 80 224S145 368 224 368ZM224 112C286 112 336 162 336 224S286 336 224 336S112 286 112 224S162 112 224 112Z"]
  };
  var faCameraWebSlash = {
    prefix: 'fal',
    iconName: 'camera-web-slash',
    icon: [640, 512, [], "f833", "M453 279C460 262 464 244 464 224C464 145 399 80 320 80C288 80 259 91 236 108L262 129C279 118 299 112 320 112C382 112 432 162 432 224C432 236 430 247 426 258L453 279ZM104 167C99 185 96 204 96 224C96 348 196 448 320 448C358 448 395 438 426 421L398 399C374 410 348 416 320 416C214 416 128 330 128 224C128 212 129 200 131 189L104 167ZM320 32C426 32 512 118 512 224C512 255 505 284 491 310L517 330C534 299 544 262 544 224C544 100 444 0 320 0C263 0 211 22 171 57L197 77C230 49 273 32 320 32ZM320 368C331 368 343 366 353 364L318 336C267 335 225 300 212 252L176 224C176 224 176 224 176 224C176 303 241 368 320 368ZM496 480H160L178 458C187 448 180 432 166 432H166C161 432 157 434 154 438L137 458C130 467 126 479 130 489C134 503 146 512 160 512C160 512 427 512 496 512C505 512 512 505 512 496C512 487 505 480 496 480ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483Z"]
  };
  var faCampfire = {
    prefix: 'fal',
    iconName: 'campfire',
    icon: [512, 512, [], "f6ba", "M256 320C336 320 400 255 400 176C400 143 367 74 320 32C307 44 295 57 284 70C266 46 245 22 220 0C157 57 112 131 112 176C112 255 177 320 256 320ZM220 44C234 59 247 74 258 89L282 121L308 90C312 86 316 82 319 78C350 114 368 159 368 176C368 238 318 288 256 288S144 238 144 176C144 148 172 94 220 44ZM501 481L302 408L501 335C510 332 514 323 511 314C508 306 499 302 490 305L256 391L21 305C13 302 4 306 1 314C-2 323 2 332 10 335L209 408L10 481C2 484 -2 493 1 502C3 508 9 512 16 512C18 512 20 512 21 511L256 425L490 511C492 512 494 512 496 512C503 512 509 508 511 502C514 493 510 484 501 481Z"]
  };
  var faCampground = {
    prefix: 'fal',
    iconName: 'campground',
    icon: [576, 512, [], "f6bb", "M548 396L309 125L396 27C402 20 401 10 395 4C388 -2 378 -1 372 5L288 101L204 5C198 -1 188 -2 181 4C175 10 174 20 180 27L267 125L28 396C20 405 16 416 16 428V464C16 490 38 512 64 512H512C538 512 560 490 560 464V428C560 416 556 405 548 396ZM176 480L288 331L400 480H176ZM528 464C528 473 521 480 512 480H440L301 294C295 286 281 286 275 294L136 480H64C55 480 48 473 48 464V428C48 424 49 420 52 418L288 149L524 418C527 420 528 424 528 428V464Z"]
  };
  var faCandleHolder = {
    prefix: 'fal',
    iconName: 'candle-holder',
    icon: [448, 512, [], "f6bc", "M160 192C206 192 238 159 238 113C238 83 205 38 160 0C114 38 82 83 82 113C82 159 114 192 160 192ZM160 43C191 74 206 101 206 113C206 142 188 160 160 160S114 142 114 113C114 101 129 74 160 43ZM371 385C347 390 327 409 322 433C318 451 321 467 329 480H256V272C256 246 234 224 208 224H112C86 224 64 246 64 272V480H16C7 480 0 487 0 496C0 505 7 512 16 512H380C413 512 442 490 447 458C454 414 415 377 371 385ZM224 480H96V272C96 263 103 256 112 256H128V304C128 313 135 320 144 320S160 313 160 304V256H208C217 256 224 263 224 272V480ZM384 480C366 480 352 466 352 448S366 416 384 416S416 430 416 448S402 480 384 480Z"]
  };
  var faCandyCane = {
    prefix: 'fal',
    iconName: 'candy-cane',
    icon: [512, 512, [], "f786", "M497 92C470 33 412 0 352 0C324 0 296 7 271 23L243 39C228 48 223 68 232 83L265 138C274 154 294 158 309 149L336 132C372 111 406 165 369 187L16 398C0 407 -5 426 5 442L37 496C43 506 54 512 65 512C70 512 76 510 81 507L429 301C500 258 533 167 497 92ZM292 121L260 66C292 47 313 32 352 32V96C328 96 315 108 292 121ZM383 104H384V36C421 45 452 70 469 106C472 113 475 120 476 128H408V128C408 128 408 127 408 127C402 117 393 109 383 104ZM257 291L339 242L403 279L321 328L257 291ZM289 346L202 398L138 362L225 310L289 346ZM65 480L32 425L106 381L170 417L65 480ZM433 258L371 224L385 215C405 203 416 182 416 160H479C478 197 462 233 433 258Z"]
  };
  var faCandyCorn = {
    prefix: 'fal',
    iconName: 'candy-corn',
    icon: [640, 512, [], "f6bd", "M480 0C314 2 315 39 322 73C352 224 416 416 480 416H480C544 416 608 224 638 72C645 39 646 2 480 0ZM480 384C467 384 441 347 412 275C456 271 504 271 547 275C519 347 493 384 480 384ZM559 244C508 239 452 239 401 244C391 217 382 186 373 152C440 142 520 142 587 152C578 186 569 217 559 244ZM607 66C603 85 599 103 595 120C523 109 437 109 365 120C361 103 357 85 353 66C351 56 352 54 352 53C352 53 365 33 480 32C595 33 608 53 608 53C608 54 609 56 607 66ZM85 206C-31 324 -3 350 24 369C153 454 334 545 379 500H379C424 455 334 274 248 145C229 118 203 90 85 206ZM356 477C347 486 302 479 232 448C260 415 294 381 327 353C358 423 365 468 356 477ZM313 323C274 355 234 395 202 434C176 422 147 407 117 389C157 335 214 277 268 237C286 268 301 297 313 323ZM89 372C74 363 58 353 42 342C34 336 32 334 32 334C32 334 27 311 108 228C190 148 213 153 213 153C213 153 216 155 221 163C232 179 242 195 251 210C193 253 132 314 89 372Z"]
  };
  var faCannabis = {
    prefix: 'fal',
    iconName: 'cannabis',
    icon: [512, 512, [], "f55f", "M256 224C247 224 240 231 240 240V496C240 505 247 512 256 512S272 505 272 496V240C272 231 265 224 256 224ZM494 323C493 323 475 314 446 306C495 241 510 176 511 172C514 162 510 151 503 143C497 137 489 133 480 133C478 133 476 134 473 134C470 135 407 148 343 190C334 92 285 18 283 14C277 5 267 0 256 0S235 5 229 14C227 18 178 92 169 190C105 148 42 135 39 134C36 134 34 133 32 133C23 133 15 137 9 143C2 151 -2 162 1 173C2 176 17 241 66 306C37 314 19 323 18 323C7 329 0 340 0 352C0 364 7 375 18 381C20 382 72 408 138 411C136 417 134 422 134 422C130 434 133 447 143 455C148 461 156 464 164 464C167 464 171 464 174 463C175 462 189 458 208 449V413C183 426 165 432 165 432C168 421 173 411 178 402C183 391 175 378 163 378C159 379 154 379 150 379C85 379 32 352 32 352S58 339 96 331C108 329 114 314 105 305C58 252 36 181 32 165C95 179 145 211 174 233C185 241 200 234 200 220C200 220 200 219 200 219C200 116 256 32 256 32S312 116 312 219C312 219 312 220 312 220C312 234 327 241 338 233C367 211 417 179 480 165C477 180 454 252 407 305C398 314 404 329 416 331C454 339 480 352 480 352S427 379 362 379C358 379 353 379 349 378C336 378 329 391 334 402C339 411 344 421 347 432C347 432 329 426 304 413V449C323 458 337 462 338 463C341 464 344 464 347 464C356 464 364 461 370 454C379 446 382 433 378 422C378 422 376 417 373 411C440 408 492 382 494 381C505 375 512 364 512 352C512 340 505 329 494 323Z"]
  };
  var faCapsules = {
    prefix: 'fal',
    iconName: 'capsules',
    icon: [576, 512, [], "f46b", "M555 302L423 121C402 92 368 75 332 75H332C308 75 286 82 266 96C244 112 230 136 224 161V144C224 82 174 32 112 32S0 82 0 144V368C0 430 50 480 112 480S224 430 224 368V214C227 228 233 241 242 253L373 434C394 463 428 480 464 480C488 480 511 473 530 459C580 422 591 352 555 302ZM192 368C192 412 156 448 112 448C68 448 32 412 32 368V272H192V368ZM192 240H32V144C32 100 68 64 112 64C156 64 192 100 192 144V240ZM285 122C300 112 316 107 332 107C357 107 381 118 397 140L469 238L454 217L324 311L268 234C242 198 250 148 285 122ZM511 433C497 443 480 448 464 448C439 448 415 437 399 415L339 332L343 337L472 243L529 321C555 357 547 407 511 433Z"]
  };
  var faCar = {
    prefix: 'fal',
    iconName: 'car',
    icon: [512, 512, [], "f1b9", "M461 204L429 90C419 56 387 32 352 32H160C125 32 93 56 83 90L51 204C21 220 0 251 0 288V464C0 473 7 480 16 480S32 473 32 464V416H480V464C480 473 487 480 496 480C505 480 512 473 512 464V288C512 251 491 220 461 204ZM114 99C120 78 139 64 160 64H352C373 64 392 78 398 99L425 193C422 193 419 192 416 192H96C93 192 90 193 87 193L114 99ZM480 352C480 370 466 384 448 384H64C46 384 32 370 32 352V288C32 253 61 224 96 224H416C451 224 480 253 480 288V352ZM104 272C91 272 80 283 80 296S91 320 104 320C117 320 128 309 128 296S117 272 104 272ZM408 272C395 272 384 283 384 296S395 320 408 320C421 320 432 309 432 296S421 272 408 272Z"]
  };
  var faCarBattery = {
    prefix: 'fal',
    iconName: 'car-battery',
    icon: [512, 512, [], "f5df", "M448 128H64C29 128 0 157 0 192V384C0 419 29 448 64 448H448C483 448 512 419 512 384V192C512 157 483 128 448 128ZM480 384C480 402 466 416 448 416H64C46 416 32 402 32 384V192C32 174 46 160 64 160H448C466 160 480 174 480 192V384ZM336 96H432C441 96 448 89 448 80C448 71 441 64 432 64H336C327 64 320 71 320 80C320 89 327 96 336 96ZM80 96H176C185 96 192 89 192 80C192 71 185 64 176 64H80C71 64 64 71 64 80C64 89 71 96 80 96ZM416 240H384V208C384 199 377 192 368 192S352 199 352 208V240H320C311 240 304 247 304 256S311 272 320 272H352V304C352 313 359 320 368 320S384 313 384 304V272H416C425 272 432 265 432 256S425 240 416 240ZM192 240H96C87 240 80 247 80 256S87 272 96 272H192C201 272 208 265 208 256S201 240 192 240Z"]
  };
  var faCarBuilding = {
    prefix: 'fal',
    iconName: 'car-building',
    icon: [640, 512, [], "f859", "M120 88H104C95 88 88 95 88 104V120C88 129 95 136 104 136H120C129 136 136 129 136 120V104C136 95 129 88 120 88ZM320 48V112C320 121 327 128 336 128S352 121 352 112V48C352 22 330 0 304 0H48C22 0 0 22 0 48V464C0 473 7 480 16 480S32 473 32 464V48C32 39 39 32 48 32H304C313 32 320 39 320 48ZM120 216H104C95 216 88 223 88 232V248C88 257 95 264 104 264H120C129 264 136 257 136 248V232C136 223 129 216 120 216ZM120 344H104C95 344 88 351 88 360V376C88 385 95 392 104 392H120C129 392 136 385 136 376V360C136 351 129 344 120 344ZM544 352C531 352 520 363 520 376C520 389 531 400 544 400S568 389 568 376C568 363 557 352 544 352ZM248 136C257 136 264 129 264 120V104C264 95 257 88 248 88H232C223 88 216 95 216 104V120C216 129 223 136 232 136H248ZM595 294L579 226C573 197 547 176 517 176H344C314 176 288 197 282 226L265 296C241 309 224 334 224 363V418C224 438 237 455 256 462V496C256 505 263 512 272 512S288 505 288 496V464H576V496C576 505 583 512 592 512S608 505 608 496V462C627 455 640 438 640 418V363C640 333 622 306 595 294ZM313 233C316 218 329 208 344 208H517C532 208 545 218 548 233L561 288H300L313 233ZM608 418C608 426 602 432 594 432H270C262 432 256 426 256 418V363C256 339 275 320 299 320H565C589 320 608 339 608 363V418ZM320 352C307 352 296 363 296 376C296 389 307 400 320 400S344 389 344 376C344 363 333 352 320 352Z"]
  };
  var faCarBump = {
    prefix: 'fal',
    iconName: 'car-bump',
    icon: [576, 512, [], "f5e0", "M97 298C85 303 79 318 85 330C90 342 104 347 116 342C129 336 134 322 128 310C123 298 109 293 97 298ZM374 173C362 178 356 192 362 204C367 216 381 222 393 216S411 197 405 185C400 173 386 167 374 173ZM576 493C565 441 518 403 464 403C410 403 364 441 353 493C351 501 357 510 365 512C374 513 382 508 384 499C392 462 426 435 464 435C503 435 537 462 544 499C546 507 553 512 560 512C561 512 562 512 563 512C572 510 577 501 576 493ZM120 446L469 287L489 331C492 337 498 340 504 340C506 340 508 340 510 339C519 335 522 326 518 318L495 266C508 248 511 224 501 203L475 144C459 109 424 88 387 88C384 88 380 89 377 89L325 28C302 1 264 -8 231 7L57 86C25 101 6 135 11 171L23 254C0 281 -7 320 9 355L35 414C45 435 65 448 87 450L110 503C113 509 119 512 125 512C127 512 129 512 131 511C139 507 143 497 139 489L120 446ZM70 115L245 36C264 27 287 33 301 49L343 99L56 228C55 229 54 230 52 231L42 166C39 145 51 124 70 115ZM106 417C102 418 98 419 93 419C81 419 69 412 64 401L38 342C31 327 30 309 36 293C42 277 54 265 70 258L361 126C370 122 378 120 388 120C413 120 436 135 446 157L472 216C476 224 476 232 473 240C470 248 464 255 456 258L106 417Z"]
  };
  var faCarBus = {
    prefix: 'fal',
    iconName: 'car-bus',
    icon: [640, 512, [], "f85a", "M595 294L579 226C573 197 547 176 517 176H344C314 176 288 197 282 226L265 296C241 309 224 334 224 363V418C224 438 237 455 256 462V496C256 505 263 512 272 512S288 505 288 496V464H576V496C576 505 583 512 592 512S608 505 608 496V462C627 455 640 438 640 418V363C640 333 622 306 595 294ZM313 233C316 218 329 208 344 208H517C532 208 545 218 548 233L561 288H300L313 233ZM608 418C608 426 602 432 594 432H270C262 432 256 426 256 418V363C256 339 275 320 299 320H565C589 320 608 339 608 363V418ZM320 352C307 352 296 363 296 376C296 389 307 400 320 400S344 389 344 376C344 363 333 352 320 352ZM544 352C531 352 520 363 520 376C520 389 531 400 544 400S568 389 568 376C568 363 557 352 544 352ZM80 312C80 325 91 336 104 336S128 325 128 312C128 299 117 288 104 288S80 299 80 312ZM176 384H64C46 384 32 370 32 352V256H224C233 256 240 249 240 240C240 231 233 224 224 224H208V128H352C352 137 359 144 368 144S384 137 384 128V90C384 48 299 0 192 0S0 48 0 90V352C0 376 13 396 32 407V464C32 473 39 480 48 480S64 473 64 464V416H176C185 416 192 409 192 400C192 391 185 384 176 384ZM32 90C33 76 93 32 192 32S351 76 352 90V96H32V90ZM32 128H176V224H32V128Z"]
  };
  var faCarCrash = {
    prefix: 'fal',
    iconName: 'car-crash',
    icon: [640, 512, [], "f5e1", "M179 95C186 96 193 94 198 90L250 47C257 41 258 31 253 24S237 17 230 22L185 59L152 11C147 2 137 -2 126 1C117 3 110 11 109 21L103 80L45 68C35 66 25 70 20 79C15 88 16 99 22 107L60 152L11 184C2 190 -2 200 1 210C3 220 11 227 22 228L80 233L68 291C67 299 72 308 81 310C82 310 83 310 84 310C92 310 98 305 100 297L113 231C115 224 113 217 109 212C105 207 99 203 92 202L48 198L85 173C91 170 94 164 95 157C96 150 94 144 90 138L62 104L106 113C112 114 119 113 124 109C130 105 133 98 134 92L138 47L163 85C167 90 173 94 179 95ZM284 195C272 190 259 196 254 207C249 219 254 232 266 237S291 237 296 225C301 214 295 200 284 195ZM622 272L636 158C641 124 622 91 590 78L423 6C392 -7 355 2 333 28L260 118C228 122 199 143 185 175L164 223C153 250 161 280 182 297L162 346C158 354 162 363 170 367C172 368 174 368 176 368C183 368 189 364 191 358L211 313L505 438L483 490C479 498 483 507 491 511C493 512 495 512 497 512C504 512 509 508 512 502L535 450C541 452 547 453 553 453C578 453 601 438 612 414L632 366C646 334 641 299 622 272ZM358 49C370 33 392 28 410 36L578 107C596 115 607 134 604 154L593 246C589 244 586 242 582 240L311 124C307 123 303 122 299 121L358 49ZM603 353L582 401C577 413 566 421 553 421C548 421 544 420 540 418L211 278C203 274 197 268 193 260C190 252 190 244 194 236L214 188C224 164 248 149 273 149C282 149 290 150 298 154L569 269C602 283 617 321 603 353ZM549 309C538 304 524 309 519 321C514 332 520 345 531 350C543 355 556 350 561 338C566 327 561 314 549 309Z"]
  };
  var faCarGarage = {
    prefix: 'fal',
    iconName: 'car-garage',
    icon: [640, 512, [], "f5e2", "M208 354C195 354 184 365 184 378C184 392 195 402 208 402S232 392 232 378C232 365 221 354 208 354ZM483 297L467 228C461 199 435 178 405 178H232C202 178 176 199 170 228L153 299C129 311 112 336 112 365V420C112 440 125 458 144 464V498C144 507 151 514 160 514S176 507 176 498V466H464V498C464 507 471 514 480 514S496 507 496 498V464C515 458 528 440 528 420V365C528 336 510 309 483 297ZM201 235C204 221 217 210 232 210H405C420 210 433 221 436 235L449 290H188L201 235ZM496 420C496 428 490 434 482 434H158C150 434 144 428 144 420V365C144 342 163 322 187 322H453C477 322 496 342 496 365V420ZM432 354C419 354 408 365 408 378C408 392 419 402 432 402S456 392 456 378C456 365 445 354 432 354ZM633 197L329 5C323 2 317 2 311 5L7 197C0 202 -2 212 2 219C7 227 17 229 25 224L320 37L615 224C618 226 621 226 624 226C629 226 634 224 638 219C642 212 640 202 633 197Z"]
  };
  var faCarRear = {
    prefix: 'fal',
    iconName: 'car-rear',
    icon: [512, 512, [], "f5de", "M461 204L429 90C419 56 387 32 352 32H160C125 32 93 56 83 90L51 204C21 220 0 251 0 288V352C0 376 13 396 32 407V464C32 473 39 480 48 480C57 480 64 473 64 464V416H448V464C448 473 455 480 464 480C473 480 480 473 480 464V407C499 396 512 376 512 352V288C512 251 491 220 461 204ZM114 99C120 78 139 64 160 64H352C373 64 392 78 398 99L425 193C422 193 419 192 416 192H96C93 192 90 193 87 193L114 99ZM320 384H192V352H320V384ZM432 320H480V352C480 370 466 384 448 384H352V352C352 334 338 320 320 320H192C174 320 160 334 160 352V384H64C46 384 32 370 32 352V320H80C89 320 96 313 96 304C96 295 89 288 80 288H32C32 253 61 224 96 224H416C451 224 480 253 480 288H432C423 288 416 295 416 304C416 313 423 320 432 320Z"]
  };
  var faCarSide = {
    prefix: 'fal',
    iconName: 'car-side',
    icon: [640, 512, [], "f5e4", "M520 224L411 88C399 73 381 64 361 64H155C129 64 106 80 96 104L48 226C21 233 0 258 0 288V400C0 418 14 432 32 432H66C73 477 112 512 160 512S247 477 254 432H386C393 477 432 512 480 512S567 477 574 432H608C626 432 640 418 640 400V344C640 278 586 224 520 224ZM361 96C371 96 380 100 386 108L479 224H256V96H361ZM126 116C130 104 142 96 155 96H224V224H83L126 116ZM160 480C125 480 96 451 96 416S125 352 160 352S224 381 224 416S195 480 160 480ZM480 480C445 480 416 451 416 416S445 352 480 352S544 381 544 416S515 480 480 480ZM608 400H574C567 355 528 320 480 320S393 355 386 400H254C247 355 208 320 160 320S73 355 66 400H32V288C32 270 46 256 64 256H520C569 256 608 295 608 344V400Z"]
  };
  var faCarTilt = {
    prefix: 'fal',
    iconName: 'car-tilt',
    icon: [640, 512, [], "f5e5", "M202 173C190 167 176 173 171 185C165 197 170 211 183 216S209 216 214 204C220 192 214 178 202 173ZM491 330C497 318 491 303 479 298S453 298 448 310C442 322 447 336 460 342C472 347 486 342 491 330ZM624 480H476L489 450C511 448 531 435 541 414L568 355C583 320 576 281 553 254L565 171C570 135 551 101 519 86L345 7C312 -8 274 1 251 28L199 89C196 89 192 88 189 88C152 88 117 109 101 144L75 203C65 224 68 248 81 266L58 318C54 326 58 335 66 339C68 340 70 340 72 340C78 340 84 337 87 331L107 287L456 446L441 480H16C7 480 0 487 0 496C0 505 7 512 16 512H624C633 512 640 505 640 496C640 487 633 480 624 480ZM275 49C289 33 312 27 331 36L506 115C525 124 537 145 534 166L524 231C522 230 521 229 520 228L233 99L275 49ZM120 258C112 255 106 248 103 240C100 232 100 224 104 216L130 158C141 135 163 120 189 120C198 120 206 122 215 126L506 258C522 265 534 277 540 293C546 309 545 327 538 342L512 401C507 412 495 419 483 419C478 419 474 418 470 417L120 258Z"]
  };
  var faCarWash = {
    prefix: 'fal',
    iconName: 'car-wash',
    icon: [448, 512, [], "f5e6", "M224 128C250 128 272 106 272 80C272 59 248 22 237 6C231 -2 217 -2 211 6C200 22 176 59 176 80C176 106 198 128 224 128ZM224 45C233 61 240 75 240 80C240 89 233 96 224 96S208 89 208 80C208 75 215 61 224 45ZM368 128C394 128 416 106 416 80C416 59 392 22 381 6C375 -2 361 -2 355 6C344 22 320 59 320 80C320 106 342 128 368 128ZM368 45C377 61 384 75 384 80C384 89 377 96 368 96S352 89 352 80C352 75 359 61 368 45ZM80 128C106 128 128 106 128 80C128 59 104 22 93 6C87 -2 73 -2 67 6C56 22 32 59 32 80C32 106 54 128 80 128ZM80 45C89 61 96 75 96 80C96 89 89 96 80 96S64 89 64 80C64 75 71 61 80 45ZM336 352C323 352 312 363 312 376C312 389 323 400 336 400S360 389 360 376C360 363 349 352 336 352ZM387 295L371 226C365 197 339 176 309 176H136C106 176 80 197 74 226L57 296C33 309 16 334 16 363V418C16 438 29 455 48 462V496C48 505 55 512 64 512S80 505 80 496V464H368V496C368 505 375 512 384 512S400 505 400 496V462C419 455 432 438 432 418V363C432 333 414 306 387 295ZM105 233C108 218 121 208 136 208H309C324 208 337 218 340 233L353 288H92L105 233ZM400 418C400 426 394 432 386 432H62C54 432 48 426 48 418V363C48 339 67 320 91 320H357C381 320 400 339 400 363V418ZM112 352C99 352 88 363 88 376C88 389 99 400 112 400S136 389 136 376C136 363 125 352 112 352Z"]
  };
  var faCarWrench = {
    prefix: 'fal',
    iconName: 'car-wrench',
    icon: [512, 512, [], "f5e3", "M419 294L403 226C397 197 371 176 341 176H168C138 176 112 197 106 226L89 296C65 309 48 334 48 363V418C48 438 61 455 80 462V496C80 505 87 512 96 512S112 505 112 496V464H400V496C400 505 407 512 416 512S432 505 432 496V462C451 455 464 438 464 418V363C464 333 446 306 419 294ZM137 233C140 218 153 208 168 208H341C356 208 369 218 372 233L385 288H124L137 233ZM432 418C432 426 426 432 418 432H94C86 432 80 426 80 418V363C80 339 99 320 123 320H389C413 320 432 339 432 363V418ZM368 352C355 352 344 363 344 376C344 389 355 400 368 400S392 389 392 376C392 363 381 352 368 352ZM144 352C131 352 120 363 120 376C120 389 131 400 144 400S168 389 168 376C168 363 157 352 144 352ZM112 160C138 160 161 147 176 128H336C351 147 374 160 400 160C444 160 480 124 480 80C480 36 444 0 400 0C374 0 351 13 336 32H176C161 13 138 0 112 0C68 0 32 36 32 80C32 124 68 160 112 160ZM67 64C74 45 91 32 112 32C127 32 141 39 150 51C156 59 166 64 176 64H336C346 64 356 59 362 51C371 39 385 32 400 32C421 32 438 45 445 64H400V96H445C438 115 421 128 400 128C385 128 371 121 362 109C356 101 346 96 336 96H176C166 96 156 101 150 109C141 121 127 128 112 128C91 128 74 115 67 96H112V64H67Z"]
  };
  var faCaravan = {
    prefix: 'fal',
    iconName: 'caravan',
    icon: [640, 512, [], "f8ff", "M240 128H112C94 128 80 142 80 160V224C80 242 94 256 112 256H240C258 256 272 242 272 224V160C272 142 258 128 240 128ZM240 224H112V160H240V224ZM624 384H576V192C576 104 504 32 416 32H96C43 32 0 75 0 128V320C0 373 43 416 96 416C96 469 139 512 192 512S288 469 288 416H624C633 416 640 409 640 400V400C640 391 633 384 624 384ZM192 480C157 480 128 451 128 416S157 352 192 352S256 381 256 416S227 480 192 480ZM448 224H416C407 224 400 231 400 240C400 249 407 256 416 256H448V384H352V160H448V224ZM544 384H480V160C480 142 466 128 448 128H352C334 128 320 142 320 160V384H282C269 347 234 320 192 320S115 347 102 384H96C61 384 32 355 32 320V128C32 93 61 64 96 64H416C487 64 544 121 544 192V384Z"]
  };
  var faCaravanSimple = {
    prefix: 'fal',
    iconName: 'caravan-simple',
    icon: [640, 512, [], "e000", "M432 128H368C350 128 336 142 336 160V224C336 242 350 256 368 256H432C450 256 464 242 464 224V160C464 142 450 128 432 128ZM432 224H368V160H432V224ZM240 128H112C94 128 80 142 80 160V224C80 242 94 256 112 256H240C258 256 272 242 272 224V160C272 142 258 128 240 128ZM240 224H112V160H240V224ZM624 384H576V192C576 104 504 32 416 32H96C43 32 0 75 0 128V320C0 373 43 416 96 416C96 469 139 512 192 512S288 469 288 416H624C633 416 640 409 640 400C640 391 633 384 624 384ZM192 480C157 480 128 451 128 416S157 352 192 352S256 381 256 416S227 480 192 480ZM544 384H282C269 347 234 320 192 320S115 347 102 384H96C61 384 32 355 32 320V128C32 93 61 64 96 64H416C487 64 544 121 544 192V384Z"]
  };
  var faCaretDown = {
    prefix: 'fal',
    iconName: 'caret-down',
    icon: [320, 512, [], "f0d7", "M288 192H32C4 192 -11 226 9 247L137 375C150 387 170 387 183 375L311 247C331 226 316 192 288 192ZM160 352L32 224H288L160 352Z"]
  };
  var faCaretLeft = {
    prefix: 'fal',
    iconName: 'caret-left',
    icon: [256, 512, [], "f0d9", "M192 384V128C192 100 158 85 137 105L9 233C-3 246 -3 266 9 279L137 407C158 427 192 412 192 384ZM32 256L160 128V384L32 256Z"]
  };
  var faCaretRight = {
    prefix: 'fal',
    iconName: 'caret-right',
    icon: [256, 512, [], "f0da", "M0 128V384C0 412 34 427 55 407L183 279C195 266 195 246 183 233L55 105C34 85 0 100 0 128ZM160 256L32 384V128L160 256Z"]
  };
  var faCaretUp = {
    prefix: 'fal',
    iconName: 'caret-up',
    icon: [320, 512, [], "f0d8", "M32 320H288C316 320 331 286 311 265L183 137C170 125 150 125 137 137L9 265C-11 286 4 320 32 320ZM160 160L288 288H32L160 160Z"]
  };
  var faCarrot = {
    prefix: 'fal',
    iconName: 'carrot',
    icon: [512, 512, [], "f787", "M505 139C482 111 451 95 418 94C417 62 401 30 373 7C357 -6 339 2 333 7C306 30 290 60 288 93C287 108 290 122 295 135C281 131 268 128 254 128C206 128 160 155 138 201L2 478C-7 498 14 519 34 510L311 374C336 362 358 341 371 314C386 283 387 248 377 217C389 221 401 224 414 224C448 224 481 208 505 179C514 168 514 150 505 139ZM342 301C332 320 317 336 297 345L173 406L139 373C133 367 123 367 117 373C111 379 111 389 117 395L142 421L42 470L154 241L181 267C187 274 197 274 203 267C210 261 210 251 203 245L169 211C186 179 218 160 254 160C269 160 284 163 297 170C320 181 338 201 347 226C355 251 353 277 342 301ZM414 192C392 192 371 183 353 166L346 159C309 122 311 67 353 32C386 60 395 100 378 134C390 128 401 126 413 126C437 126 462 137 480 159C462 181 438 192 414 192Z"]
  };
  var faCars = {
    prefix: 'fal',
    iconName: 'cars',
    icon: [640, 512, [], "f85b", "M72 200C72 213 83 224 96 224S120 213 120 200C120 187 109 176 96 176S72 187 72 200ZM242 256H46C38 256 32 250 32 242V187C32 163 51 144 75 144H341C342 144 342 144 342 144C343 144 343 144 344 144H402C394 133 384 124 371 118L355 50C349 21 323 0 293 0H120C90 0 64 21 58 50L41 120C17 133 0 158 0 187V242C0 262 13 279 32 286V320C32 329 39 336 48 336S64 329 64 320V288H224C228 284 232 279 237 276L242 256ZM89 57C92 42 105 32 120 32H293C308 32 321 42 324 57L337 112H76L89 57ZM544 352C531 352 520 363 520 376C520 389 531 400 544 400S568 389 568 376C568 363 557 352 544 352ZM320 352C307 352 296 363 296 376C296 389 307 400 320 400S344 389 344 376C344 363 333 352 320 352ZM595 294L579 226C573 197 547 176 517 176H344C314 176 288 197 282 226L265 296C241 309 224 334 224 363V418C224 438 237 455 256 462V496C256 505 263 512 272 512S288 505 288 496V464H576V496C576 505 583 512 592 512S608 505 608 496V462C627 455 640 438 640 418V363C640 333 622 306 595 294ZM313 233C316 218 329 208 344 208H517C532 208 545 218 548 233L561 288H300L313 233ZM608 418C608 426 602 432 594 432H270C262 432 256 426 256 418V363C256 339 275 320 299 320H565C589 320 608 339 608 363V418Z"]
  };
  var faCartArrowDown = {
    prefix: 'fal',
    iconName: 'cart-arrow-down',
    icon: [576, 512, [], "f218", "M184 400C153 400 128 425 128 456S153 512 184 512S240 487 240 456S215 400 184 400ZM184 480C171 480 160 469 160 456C160 443 171 432 184 432S208 443 208 456C208 469 197 480 184 480ZM570 77C564 69 554 64 544 64H107L96 12C94 5 87 0 80 0H16C7 0 0 7 0 16S7 32 16 32H67L144 372C146 379 153 384 160 384H496C505 384 512 377 512 368S505 352 496 352H173L166 320H476C498 320 517 306 523 286L575 103C577 94 576 84 570 77ZM492 277C490 284 484 288 476 288H160C159 288 159 288 158 288L115 96L304 95V201L267 165C261 158 251 158 245 165C238 171 238 181 245 187L309 251C312 254 316 256 320 256C324 256 328 254 331 251L395 187C402 181 402 171 395 165C389 158 379 158 373 165L336 201V95L544 94L492 277ZM456 400C425 400 400 425 400 456S425 512 456 512S512 487 512 456S487 400 456 400ZM456 480C443 480 432 469 432 456C432 443 443 432 456 432C469 432 480 443 480 456C480 469 469 480 456 480Z"]
  };
  var faCartFlatbed = {
    prefix: 'fal',
    iconName: 'cart-flatbed',
    icon: [640, 512, [], "f474", "M624 384H96V48C96 22 74 0 48 0H0C-9 0 -16 7 -16 16S-9 32 0 32H48C57 32 64 39 64 48V400C64 409 71 416 80 416H153C147 425 144 436 144 448C144 483 173 512 208 512C243 512 272 483 272 448C272 436 269 425 263 416H441C435 425 432 436 432 448C432 483 461 512 496 512C531 512 560 483 560 448C560 436 557 425 551 416H624C633 416 640 409 640 400S633 384 624 384ZM208 480C190 480 176 466 176 448S190 416 208 416S240 430 240 448S226 480 208 480ZM496 480C478 480 464 466 464 448S478 416 496 416S528 430 528 448S514 480 496 480ZM224 320H512C547 320 576 291 576 256V96C576 61 547 32 512 32H224C189 32 160 61 160 96V256C160 291 189 320 224 320ZM336 64H400V146L377 131C371 127 364 127 359 131L336 146V64ZM192 96C192 78 206 64 224 64H304V176C304 182 307 187 312 190C318 193 324 193 329 189L368 163L407 189C410 191 413 192 416 192C419 192 421 191 424 190C429 187 432 182 432 176V64H512C530 64 544 78 544 96V256C544 274 530 288 512 288H224C206 288 192 274 192 256V96Z"]
  };
  var faCartFlatbedBoxes = {
    prefix: 'fal',
    iconName: 'cart-flatbed-boxes',
    icon: [640, 512, [], "f475", "M624 384H96V48C96 22 74 0 48 0H0C-9 0 -16 7 -16 16S-9 32 0 32H48C57 32 64 39 64 48V400C64 409 71 416 80 416H153C147 425 144 436 144 448C144 483 173 512 208 512C243 512 272 483 272 448C272 436 269 425 263 416H441C435 425 432 436 432 448C432 483 461 512 496 512C531 512 560 483 560 448C560 436 557 425 551 416H624C633 416 640 409 640 400S633 384 624 384ZM208 480C190 480 176 466 176 448S190 416 208 416S240 430 240 448S226 480 208 480ZM496 480C478 480 464 466 464 448S478 416 496 416S528 430 528 448S514 480 496 480ZM192 320H320C338 320 352 306 352 288V64C352 46 338 32 320 32H192C174 32 160 46 160 64V288C160 306 174 320 192 320ZM192 64H320V288H192V64ZM416 320H544C562 320 576 306 576 288V224C576 206 562 192 544 192H416C398 192 384 206 384 224V288C384 306 398 320 416 320ZM416 224H544V288H416V224ZM416 160H480C498 160 512 146 512 128V64C512 46 498 32 480 32H416C398 32 384 46 384 64V128C384 146 398 160 416 160ZM416 64H480V128H416V64Z"]
  };
  var faCartFlatbedEmpty = {
    prefix: 'fal',
    iconName: 'cart-flatbed-empty',
    icon: [640, 512, [], "f476", "M624 384H96V48C96 22 74 0 48 0H0C-9 0 -16 7 -16 16S-9 32 0 32H48C57 32 64 39 64 48V400C64 409 71 416 80 416H153C147 425 144 436 144 448C144 483 173 512 208 512C243 512 272 483 272 448C272 436 269 425 263 416H441C435 425 432 436 432 448C432 483 461 512 496 512C531 512 560 483 560 448C560 436 557 425 551 416H624C633 416 640 409 640 400S633 384 624 384ZM240 448C240 466 226 480 208 480S176 466 176 448S190 416 208 416S240 430 240 448ZM528 448C528 466 514 480 496 480S464 466 464 448S478 416 496 416S528 430 528 448Z"]
  };
  var faCartFlatbedSuitcase = {
    prefix: 'fal',
    iconName: 'cart-flatbed-suitcase',
    icon: [640, 512, [], "f59d", "M624 384H96V48C96 22 74 0 48 0H0C-9 0 -16 7 -16 16S-9 32 0 32H48C57 32 64 39 64 48V400C64 409 71 416 80 416H153C147 425 144 436 144 448C144 483 173 512 208 512C243 512 272 483 272 448C272 436 269 425 263 416H441C435 425 432 436 432 448C432 483 461 512 496 512C531 512 560 483 560 448C560 436 557 425 551 416H624C633 416 640 409 640 400S633 384 624 384ZM208 480C190 480 176 466 176 448S190 416 208 416S240 430 240 448S226 480 208 480ZM496 480C478 480 464 466 464 448S478 416 496 416S528 430 528 448S514 480 496 480ZM256 320H512C547 320 576 291 576 256V128C576 93 547 64 512 64H480V48C480 22 458 0 432 0H336C310 0 288 22 288 48V64H256C221 64 192 93 192 128V256C192 291 221 320 256 320ZM512 96C530 96 544 110 544 128V256C544 274 530 288 512 288V96ZM320 48C320 39 327 32 336 32H432C441 32 448 39 448 48V64H320V48ZM288 96H480V288H288V96ZM224 128C224 110 238 96 256 96V288C238 288 224 274 224 256V128Z"]
  };
  var faCartPlus = {
    prefix: 'fal',
    iconName: 'cart-plus',
    icon: [576, 512, [], "f217", "M184 400C169 400 155 406 144 416C134 427 128 441 128 456C128 471 134 485 144 496C155 506 169 512 184 512S213 506 224 496C234 485 240 471 240 456C240 441 234 427 224 416C213 406 199 400 184 400ZM201 473C196 478 190 480 184 480S172 478 167 473C162 468 160 462 160 456C160 450 162 444 167 439C172 434 178 432 184 432S196 434 201 439S208 450 208 456C208 462 206 468 201 473ZM456 400C441 400 427 406 416 416C406 427 400 441 400 456C400 471 406 485 416 496C427 506 441 512 456 512S485 506 496 496C506 485 512 471 512 456C512 441 506 427 496 416C485 406 471 400 456 400ZM473 473C468 478 462 480 456 480C450 480 444 478 439 473C435 468 432 462 432 456C432 450 435 444 439 439C444 434 450 432 456 432C462 432 468 434 473 439S480 450 480 456C480 462 478 468 473 473ZM569 76C563 68 554 64 544 64H107L96 12C94 5 87 0 80 0H16C7 0 0 7 0 16S7 32 16 32H67L144 372C146 379 153 384 160 384H496C505 384 512 377 512 368S505 352 496 352H173L166 320H476C487 320 497 317 505 311C514 305 520 296 523 286L575 103C578 94 575 83 569 76ZM492 277C491 280 489 283 486 285C484 287 480 288 476 288H160C159 288 159 288 158 288L115 96H320L544 94L492 277ZM304 144V176H272C263 176 256 183 256 192S263 208 272 208H304V240C304 249 311 256 320 256S336 249 336 240V208H368C377 208 384 201 384 192S377 176 368 176H336V144C336 135 329 128 320 128S304 135 304 144Z"]
  };
  var faCartShopping = {
    prefix: 'fal',
    iconName: 'cart-shopping',
    icon: [576, 512, [], "f07a", "M184 400C153 400 128 425 128 456S153 512 184 512S240 487 240 456S215 400 184 400ZM184 480C171 480 160 469 160 456C160 443 171 432 184 432S208 443 208 456C208 469 197 480 184 480ZM570 77C564 69 554 64 544 64H107L96 12C94 5 87 0 80 0H16C7 0 0 7 0 16S7 32 16 32H67L144 372C146 379 153 384 160 384H496C505 384 512 377 512 368S505 352 496 352H173L166 320H476C498 320 517 306 523 286L575 103C577 94 576 84 570 77ZM492 277C490 284 484 288 476 288H160C159 288 159 288 158 288L115 96L544 94L492 277ZM456 400C425 400 400 425 400 456S425 512 456 512S512 487 512 456S487 400 456 400ZM456 480C443 480 432 469 432 456C432 443 443 432 456 432C469 432 480 443 480 456C480 469 469 480 456 480Z"]
  };
  var faCasetteBetamax = {
    prefix: 'fal',
    iconName: 'casette-betamax',
    icon: [576, 512, [], "f8a4", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V160H544V416ZM544 128H32V96C32 78 46 64 64 64H512C530 64 544 78 544 96V128ZM352 384H448C466 384 480 370 480 352V256C480 238 466 224 448 224H352C334 224 320 238 320 256V352C320 370 334 384 352 384ZM352 256H448V352H352V256ZM176 400C229 400 272 357 272 304S229 208 176 208S80 251 80 304S123 400 176 400ZM176 240C211 240 240 269 240 304C240 339 211 368 176 368S112 339 112 304C112 269 141 240 176 240ZM176 328C189 328 200 317 200 304C200 291 189 280 176 280C163 280 152 291 152 304C152 317 163 328 176 328Z"]
  };
  var faCasetteVhs = {
    prefix: 'fal',
    iconName: 'casette-vhs',
    icon: [576, 512, [], "f8ec", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V160H544V416ZM544 128H32V96C32 78 46 64 64 64H512C530 64 544 78 544 96V128ZM125 400H451C456 400 461 398 464 394C485 368 496 337 496 304S485 240 464 214C461 210 456 208 451 208H125C120 208 115 210 112 214C91 240 80 271 80 304S91 368 112 394C115 398 120 400 125 400ZM384 336C402 336 416 322 416 304C416 286 402 272 384 272V240H443C457 259 464 281 464 304S457 349 443 368H384V336ZM224 240H352V368H224V240ZM133 240H192V272C174 272 160 286 160 304C160 322 174 336 192 336V368H133C119 349 112 327 112 304S119 259 133 240Z"]
  };
  var faCashRegister = {
    prefix: 'fal',
    iconName: 'cash-register',
    icon: [512, 512, [], "f788", "M511 379L488 215C483 184 456 160 425 160L192 160V128L288 128H288C306 128 320 114 320 96V32C320 14 306 0 288 0H64C47 0 32 14 32 32V96C32 113 47 128 64 128H160V160H88C56 160 29 183 24 215L1 379C0 382 0 386 0 389V448C0 483 29 512 64 512H448C483 512 512 483 512 448V388C512 385 512 381 511 379ZM64 96V32H288V96L192 96L160 96V96H64ZM56 219C58 204 72 192 88 192H192L425 192C440 192 454 204 456 220L480 382L480 384H32L56 219ZM480 448C480 466 466 480 448 480H64C46 480 32 466 32 448V416H480V448ZM112 232C99 232 88 243 88 256C88 269 99 280 112 280S136 269 136 256C136 243 125 232 112 232ZM208 232C195 232 184 243 184 256C184 269 195 280 208 280S232 269 232 256C232 243 221 232 208 232ZM304 232C291 232 280 243 280 256C280 269 291 280 304 280S328 269 328 256C328 243 317 232 304 232ZM400 232C387 232 376 243 376 256C376 269 387 280 400 280S424 269 424 256C424 243 413 232 400 232ZM352 312C339 312 328 323 328 336C328 349 339 360 352 360S376 349 376 336C376 323 365 312 352 312ZM256 312C243 312 232 323 232 336C232 349 243 360 256 360S280 349 280 336C280 323 269 312 256 312ZM160 312C147 312 136 323 136 336C136 349 147 360 160 360S184 349 184 336C184 323 173 312 160 312Z"]
  };
  var faCassetteTape = {
    prefix: 'fal',
    iconName: 'cassette-tape',
    icon: [576, 512, [], "f8ab", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM134 448L152 395C154 388 160 384 167 384H409C416 384 422 388 424 395L442 448H134ZM544 416C544 434 530 448 512 448H476L454 385C448 365 430 352 409 352H167C146 352 128 365 122 385L100 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H512C530 64 544 78 544 96V416ZM416 160H160C125 160 96 189 96 224S125 288 160 288H416C451 288 480 259 480 224S451 160 416 160ZM160 256C142 256 128 242 128 224S142 192 160 192S192 206 192 224S178 256 160 256ZM361 256H215C221 247 224 236 224 224S221 201 215 192H361C355 201 352 212 352 224S355 247 361 256ZM416 256C398 256 384 242 384 224S398 192 416 192S448 206 448 224S434 256 416 256Z"]
  };
  var faCat = {
    prefix: 'fal',
    iconName: 'cat',
    icon: [576, 512, [], "f6be", "M544 0C535 0 526 4 519 11L476 64H452L409 11C400 1 384 -3 370 3C359 9 352 21 352 34V160H336C232 160 142 218 96 304V176C96 132 60 96 16 96C7 96 0 103 0 112S7 128 16 128C42 128 64 150 64 176V432C64 476 100 512 144 512H351C370 512 384 497 384 479C383 446 358 420 327 416L416 377V464C416 490 438 512 464 512S512 490 512 464V261C550 243 576 205 576 160V32C576 14 562 0 544 0ZM480 464C480 473 473 480 464 480S448 473 448 464V352C448 340 436 333 426 337L303 392C300 357 278 326 246 311C237 307 226 312 224 322C222 329 226 336 232 340C255 351 272 370 272 395L272 448H320C338 448 352 462 352 480L144 480C118 480 96 460 96 435C95 301 203 192 336 192H357C371 238 414 272 464 272C470 272 475 271 480 270V464ZM544 160C544 204 508 240 464 240S384 204 384 160V32L437 96H491L544 32V160ZM432 128C423 128 416 135 416 144S423 160 432 160S448 153 448 144S441 128 432 128ZM480 144C480 153 487 160 496 160S512 153 512 144S505 128 496 128S480 135 480 144Z"]
  };
  var faCatSpace = {
    prefix: 'fal',
    iconName: 'cat-space',
    icon: [640, 512, [], "e001", "M576 33V32L575 32C549 12 516 0 480 0S411 12 385 32L384 32V33C345 62 320 108 320 160C320 160 320 161 320 161C197 168 125 249 96 304V176C96 132 60 96 16 96C7 96 0 103 0 112S7 128 16 128C42 128 64 150 64 176V432C64 476 100 512 144 512H351C370 512 384 497 384 479C383 446 358 420 327 416L416 377V464C416 490 438 512 464 512S512 490 512 464V317C586 302 640 236 640 160C640 108 615 62 576 33ZM480 32C504 32 528 39 549 52L512 80H448L411 52C432 39 456 32 480 32ZM544 96V160C544 195 515 224 480 224S416 195 416 160V96L437 112H523L544 96ZM480 464C480 473 473 480 464 480S448 473 448 464V352C448 340 436 333 426 337L303 392C300 357 278 326 246 311C237 307 226 312 224 322C222 329 226 336 232 340C255 351 272 370 272 395V448H320C338 448 352 462 352 480H144C118 480 96 460 96 435C95 371 141 202 323 193C339 267 404 320 480 320V464ZM480 288C409 288 352 231 352 160C352 128 364 99 384 76V160C384 213 427 256 480 256S576 213 576 160V76C596 99 608 128 608 160C608 231 551 288 480 288ZM432 160C432 169 439 176 448 176S464 169 464 160S457 144 448 144C444 144 440 146 437 149S432 156 432 160ZM512 176C521 176 528 169 528 160S521 144 512 144S496 151 496 160C496 164 498 168 501 171S508 176 512 176ZM176 80H208V112C208 121 215 128 224 128S240 121 240 112V80H272C281 80 288 73 288 64S281 48 272 48H240V16C240 7 233 0 224 0S208 7 208 16V48H176C167 48 160 55 160 64S167 80 176 80Z"]
  };
  var faCauldron = {
    prefix: 'fal',
    iconName: 'cauldron',
    icon: [448, 512, [], "f6bf", "M272 128C298 128 320 106 320 80S298 32 272 32S224 54 224 80S246 128 272 128ZM272 64C281 64 288 71 288 80S281 96 272 96S256 89 256 80S263 64 272 64ZM448 176L448 176C448 167 441 160 432 160H16C7 160 0 167 0 176V176C0 185 7 192 16 192H55C21 238 0 294 0 346C0 385 12 416 32 441L32 495C32 503 38 511 45 512C55 513 64 506 64 496V471C105 499 161 512 224 512S343 499 384 471L384 495C384 503 390 511 397 512C407 513 416 506 416 496V441C436 416 448 385 448 346C448 294 427 238 393 192H432C441 192 448 185 448 176ZM416 346C416 467 282 480 224 480S32 467 32 346C32 293 56 236 96 192H352C392 236 416 293 416 346ZM160 56C173 56 184 45 184 32S173 8 160 8C147 8 136 19 136 32S147 56 160 56Z"]
  };
  var faCediSign = {
    prefix: 'fal',
    iconName: 'cedi-sign',
    icon: [384, 512, [], "e0bd", "M325 363C297 391 262 405 226 407V105C262 107 297 121 325 149C331 155 341 155 347 149C354 142 354 132 347 126C314 92 270 75 226 73V16C226 7 219 0 210 0S194 7 194 16V74C155 79 116 96 86 126C51 161 32 207 32 256S51 351 86 386C116 416 155 433 194 438V496C194 505 201 512 210 512S226 505 226 496V439C270 437 314 420 347 386C354 380 354 370 347 363C341 357 331 357 325 363ZM109 363C80 335 64 297 64 256S80 177 109 149C133 125 163 111 194 106V406C163 401 133 387 109 363Z"]
  };
  var faCentSign = {
    prefix: 'fal',
    iconName: 'cent-sign',
    icon: [320, 512, [], "e0be", "M315 363C322 370 322 380 315 386C281 420 237 437 192 439V496C192 505 185 512 176 512S160 505 160 496V438C121 432 84 416 54 386C19 351 0 305 0 256S19 161 54 126C84 96 121 80 160 74V16C160 7 167 0 176 0S192 7 192 16V73C237 75 281 92 315 126C322 132 322 142 315 149C309 155 299 155 293 149C233 89 136 89 77 149C48 177 32 215 32 256S48 335 77 363C136 423 233 423 293 363C299 357 309 357 315 363Z"]
  };
  var faCertificate = {
    prefix: 'fal',
    iconName: 'certificate',
    icon: [512, 512, [], "f0a3", "M496 272L479 256L496 240C526 211 512 160 472 150L449 144L456 122C467 82 430 45 390 56L368 63L362 40C352 0 301 -14 272 16L256 33L240 16C211 -14 160 0 150 40L144 63L122 56C83 45 45 82 56 122L63 144L40 150C0 160 -14 211 16 240L33 256L16 272C-14 301 0 352 40 362L63 368L56 390C45 430 83 467 122 456L144 449L150 472C160 513 211 526 240 496L256 479L272 496C301 526 352 512 362 472L368 449L390 456C430 467 467 430 456 390L449 368L472 362C512 352 526 301 496 272ZM464 331L409 345L425 399C429 414 415 429 399 425L345 409L331 464C327 480 306 485 295 474L256 433L217 474C206 485 185 481 181 464L167 409L113 425C97 429 83 414 87 399L103 345L48 331C32 327 26 307 38 295L79 256L38 217C26 205 32 185 48 181L103 167L87 113C83 97 97 83 113 87L167 102L181 48C185 32 206 27 217 38L256 79L295 38C307 26 327 32 331 48L345 102L399 87C415 83 429 97 425 113L409 167L464 181C480 185 486 205 474 217L433 256L474 295C486 307 480 327 464 331Z"]
  };
  var faChair = {
    prefix: 'fal',
    iconName: 'chair',
    icon: [448, 512, [], "f6c0", "M444 316L429 284C421 267 404 256 385 256H384V112C384 50 334 0 272 0H176C114 0 64 50 64 112V256H63C44 256 27 267 19 284L4 316C-2 331 -1 348 8 362C13 371 22 377 32 381V496C32 505 39 512 48 512S64 505 64 496V384H384V496C384 505 391 512 400 512S416 505 416 496V381C426 377 435 371 440 362C449 348 450 331 444 316ZM288 34C324 41 352 73 352 112V256H288V34ZM192 32H256V256H192V32ZM96 112C96 73 124 41 160 34V256H96V112ZM400 352H48C36 352 29 340 33 329L48 297C51 292 57 288 63 288H385C391 288 397 292 400 297L414 329C419 340 412 352 400 352Z"]
  };
  var faChairOffice = {
    prefix: 'fal',
    iconName: 'chair-office',
    icon: [448, 512, [], "f6c1", "M48 240C57 240 64 233 64 224V144C64 135 57 128 48 128S32 135 32 144V224C32 233 39 240 48 240ZM397 284C389 267 372 256 353 256H352V80C352 36 316 0 272 0H176C132 0 96 36 96 80L96 256H95C76 256 59 267 51 284L36 316C30 331 31 348 40 362C48 376 64 384 80 384H208V433C162 438 128 464 128 496C128 505 135 512 144 512C153 512 160 505 160 496C160 483 180 469 208 465V496C208 505 215 512 224 512C233 512 240 505 240 496V465C268 469 288 483 288 496C288 505 295 512 304 512C313 512 320 505 320 496C320 464 286 438 240 433V384H368C384 384 400 376 408 362C417 348 418 331 412 316L397 284ZM176 32H272C298 32 320 54 320 80V256H128L128 80C128 54 150 32 176 32ZM381 345C378 349 373 352 368 352H80C75 352 70 349 67 345C64 340 63 334 66 329L80 297C83 292 89 288 95 288H353C359 288 365 292 368 297L382 329C385 334 384 340 381 345ZM400 128C391 128 384 135 384 144V224C384 233 391 240 400 240S416 233 416 224V144C416 135 409 128 400 128Z"]
  };
  var faChalkboard = {
    prefix: 'fal',
    iconName: 'chalkboard',
    icon: [576, 512, [], "f51b", "M560 448H416V400C416 374 394 352 368 352H272C246 352 224 374 224 400V448H16C7 448 0 455 0 464S7 480 16 480H560C569 480 576 473 576 464S569 448 560 448ZM384 448H256V400C256 391 263 384 272 384H368C377 384 384 391 384 400V448ZM45 384C55 385 64 378 64 368V80C64 71 71 64 80 64H496C505 64 512 71 512 80V368C512 377 519 384 528 384S544 377 544 368V80C544 54 522 32 496 32H80C54 32 32 54 32 80V367C32 375 37 382 45 384Z"]
  };
  var faChalkboardUser = {
    prefix: 'fal',
    iconName: 'chalkboard-user',
    icon: [640, 512, [], "f51c", "M160 320C213 320 256 277 256 224C256 171 213 128 160 128C107 128 64 171 64 224C64 277 107 320 160 320ZM160 160C195 160 224 189 224 224S195 288 160 288S96 259 96 224S125 160 160 160ZM192 352H128C57 352 0 409 0 480C0 498 14 512 32 512H288C306 512 320 498 320 480C320 409 263 352 192 352ZM32 480C32 427 75 384 128 384H192C245 384 288 427 288 480H32ZM592 0H208C182 0 160 22 160 48V80C160 89 167 96 176 96S192 89 192 80V48C192 39 199 32 208 32H592C601 32 608 39 608 48V368C608 377 601 384 592 384H576V336C576 310 554 288 528 288H432C406 288 384 310 384 336V384H352C343 384 336 391 336 400S343 416 352 416H592C618 416 640 394 640 368V48C640 22 618 0 592 0ZM544 384H416V336C416 327 423 320 432 320H528C537 320 544 327 544 336V384Z"]
  };
  var faChampagneGlass = {
    prefix: 'fal',
    iconName: 'champagne-glass',
    icon: [256, 512, [], "f79e", "M208 480H144V350C207 342 256 288 256 222C256 187 243 92 223 6C222 3 219 0 215 0H41C37 0 34 3 33 6C13 92 0 187 0 222C0 288 49 342 112 350V480H48C39 480 32 487 32 496C32 505 39 512 48 512H208C217 512 224 505 224 496C224 487 217 480 208 480ZM196 32C203 65 209 98 214 128H42C47 98 53 65 60 32H196ZM32 222C32 209 34 187 38 160H218C222 187 224 209 224 222C224 273 184 316 134 319C127 320 129 320 122 319C72 316 32 273 32 222Z"]
  };
  var faChampagneGlasses = {
    prefix: 'fal',
    iconName: 'champagne-glasses',
    icon: [640, 512, [], "f79f", "M639 435C636 427 626 422 618 425L553 448L516 352C574 323 603 255 579 192C568 161 527 85 481 15C473 2 457 -3 443 2L383 23C374 27 369 38 375 47L375 47C379 54 387 56 394 54L454 33C472 61 490 91 505 118L379 162C374 164 370 169 369 174L369 175C367 187 378 197 390 193L521 146C534 171 544 191 548 203C566 252 543 306 495 327C488 329 491 329 484 331C441 343 395 325 371 289C365 280 353 279 345 287L345 287C341 293 340 301 344 307C374 352 430 375 485 363L522 459L462 481C453 484 449 493 452 501C455 510 465 514 473 511L629 456C638 453 642 443 639 435ZM330 49L197 2C183 -3 167 2 159 14C113 85 72 161 61 192C37 255 66 323 124 352L87 448L22 425C14 422 4 427 1 435C-2 443 2 453 11 456L167 511C175 514 185 510 188 501C191 493 187 484 178 481L118 459L155 363C220 377 287 343 310 280C321 249 340 166 352 84C354 69 345 54 330 49ZM279 269C261 318 207 345 156 331C149 329 152 330 145 327C97 306 74 252 92 203C96 191 106 171 119 146L295 209C289 235 283 257 279 269ZM302 177L135 118C150 91 168 61 186 33L319 80C314 113 308 147 302 177Z"]
  };
  var faChargingStation = {
    prefix: 'fal',
    iconName: 'charging-station',
    icon: [576, 512, [], "f5e7", "M560 128H544V80C544 71 537 64 528 64S512 71 512 80V128H480V80C480 71 473 64 464 64S448 71 448 80V128H432C423 128 416 135 416 144V192C416 231 443 263 480 270V382C480 398 469 413 453 416C433 419 416 403 416 384V336C416 292 380 256 336 256H320V64C320 29 291 0 256 0H96C61 0 32 29 32 64V480H16C7 480 0 487 0 496C0 505 7 512 16 512H336C345 512 352 505 352 496C352 487 345 480 336 480H320V288H336C362 288 384 310 384 336V381C384 414 408 444 442 448C480 451 512 421 512 384V270C549 263 576 231 576 192V144C576 135 569 128 560 128ZM288 480H64V64C64 46 78 32 96 32H256C274 32 288 46 288 64V480ZM544 192C544 218 522 240 496 240S448 218 448 192V160H544V192ZM224 192H150L175 117C178 109 173 100 165 97C157 94 148 99 145 107L113 203C111 208 112 213 115 217C118 222 123 224 128 224H200L161 314C158 322 162 331 170 335C172 336 174 336 176 336C182 336 188 332 191 326L239 214C241 209 240 204 237 199C234 195 229 192 224 192Z"]
  };
  var faChartArea = {
    prefix: 'fal',
    iconName: 'chart-area',
    icon: [512, 512, [], "f1fe", "M496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM144 384H432C458 384 480 362 480 336V253C480 241 475 228 466 219L379 133C373 126 363 126 357 133L305 184L236 102C233 98 229 96 224 96C220 95 215 98 212 101L108 220C100 229 96 240 96 252V336C96 362 118 384 144 384ZM128 252C128 248 129 244 132 241L224 137L292 218C295 222 299 224 303 224C308 224 312 222 315 219L368 167L443 242C446 245 448 249 448 253V336C448 345 441 352 432 352H144C135 352 128 345 128 336V252Z"]
  };
  var faChartBar = {
    prefix: 'fal',
    iconName: 'chart-bar',
    icon: [512, 512, [], "f080", "M144 240H304C313 240 320 233 320 224S313 208 304 208H144C135 208 128 215 128 224S135 240 144 240ZM144 144H368C377 144 384 137 384 128S377 112 368 112H144C135 112 128 119 128 128S135 144 144 144ZM496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM144 336H432C441 336 448 329 448 320S441 304 432 304H144C135 304 128 311 128 320S135 336 144 336Z"]
  };
  var faChartBullet = {
    prefix: 'fal',
    iconName: 'chart-bullet',
    icon: [512, 512, [], "e0bf", "M48 224H128V64H48C22 64 0 86 0 112V176C0 202 22 224 48 224ZM32 112C32 103 39 96 48 96H96V192H48C39 192 32 185 32 176V112ZM464 64H288C288 55 281 48 272 48S256 55 256 64H160V96H256V192H160V224H256C256 233 263 240 272 240S288 233 288 224H464C490 224 512 202 512 176V112C512 86 490 64 464 64ZM480 176C480 185 473 192 464 192H288V96H464C473 96 480 103 480 112V176ZM0 336V400C0 426 22 448 48 448H224V288H48C22 288 0 310 0 336ZM192 416H48C39 416 32 409 32 400V336C32 327 39 320 48 320H192V416ZM464 288H384C384 279 377 272 368 272S352 279 352 288H256V320H352V416H256V448H352C352 457 359 464 368 464S384 457 384 448H464C490 448 512 426 512 400V336C512 310 490 288 464 288ZM480 400C480 409 473 416 464 416H384V320H464C473 320 480 327 480 336V400Z"]
  };
  var faChartCandlestick = {
    prefix: 'fal',
    iconName: 'chart-candlestick',
    icon: [512, 512, [], "e0c0", "M416 320V368C416 377 423 384 432 384S448 377 448 368V320C466 320 480 306 480 288V224C480 206 466 192 448 192V144C448 135 441 128 432 128S416 135 416 144V192C398 192 384 206 384 224V288C384 306 398 320 416 320ZM416 224H448V288H416V224ZM496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM160 320V368C160 377 167 384 176 384S192 377 192 368V320C210 320 224 306 224 288V160C224 142 210 128 192 128V80C192 71 185 64 176 64S160 71 160 80V128C142 128 128 142 128 160V288C128 306 142 320 160 320ZM160 160H192V288H160V160ZM288 256V304C288 313 295 320 304 320S320 313 320 304V256C338 256 352 242 352 224V128C352 110 338 96 320 96V48C320 39 313 32 304 32S288 39 288 48V96C270 96 256 110 256 128V224C256 242 270 256 288 256ZM288 128H320V224H288V128Z"]
  };
  var faChartColumn = {
    prefix: 'fal',
    iconName: 'chart-column',
    icon: [512, 512, [], "e0c1", "M496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM160 368C169 368 176 361 176 352V256C176 247 169 240 160 240S144 247 144 256V352C144 361 151 368 160 368ZM256 368C265 368 272 361 272 352V128C272 119 265 112 256 112S240 119 240 128V352C240 361 247 368 256 368ZM352 368C361 368 368 361 368 352V192C368 183 361 176 352 176S336 183 336 192V352C336 361 343 368 352 368ZM448 368C457 368 464 361 464 352V96C464 87 457 80 448 80S432 87 432 96V352C432 361 439 368 448 368Z"]
  };
  var faChartGantt = {
    prefix: 'fal',
    iconName: 'chart-gantt',
    icon: [512, 512, [], "e0c2", "M352 320C352 329 359 336 368 336H464C473 336 480 329 480 320S473 304 464 304H368C359 304 352 311 352 320ZM192 224C192 233 199 240 208 240H368C377 240 384 233 384 224S377 208 368 208H208C199 208 192 215 192 224ZM496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM144 144H272C281 144 288 137 288 128S281 112 272 112H144C135 112 128 119 128 128S135 144 144 144Z"]
  };
  var faChartLine = {
    prefix: 'fal',
    iconName: 'chart-line',
    icon: [512, 512, [], "f201", "M123 315L224 215L309 299C315 306 325 306 331 299L475 155C482 149 482 139 475 133S459 126 453 133L320 265L235 181C229 174 219 174 213 181L101 293C94 299 94 309 101 315C107 322 117 322 123 315ZM496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448Z"]
  };
  var faChartLineDown = {
    prefix: 'fal',
    iconName: 'chart-line-down',
    icon: [512, 512, [], "f64d", "M496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM213 299C219 306 229 306 235 299L320 215L425 320H336C327 320 320 327 320 336S327 352 336 352H464C473 352 480 345 480 336V208C480 199 473 192 464 192S448 199 448 208V297L331 181C325 174 315 174 309 181L224 265L123 165C117 158 107 158 101 165S94 181 101 187L213 299Z"]
  };
  var faChartLineUp = {
    prefix: 'fal',
    iconName: 'chart-line-up',
    icon: [512, 512, [], "e0c3", "M496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM123 315L224 215L309 299C315 306 325 306 331 299L448 183V272C448 281 455 288 464 288S480 281 480 272V144C480 135 473 128 464 128H336C327 128 320 135 320 144S327 160 336 160H425L320 265L235 181C229 174 219 174 213 181L101 293C94 299 94 309 101 315C107 322 117 322 123 315Z"]
  };
  var faChartMixed = {
    prefix: 'fal',
    iconName: 'chart-mixed',
    icon: [576, 512, [], "f643", "M64 352H32C14 352 0 366 0 384V480C0 498 14 512 32 512H64C82 512 96 498 96 480V384C96 366 82 352 64 352ZM64 480H32V384H64V480ZM544 192H512C494 192 480 206 480 224V480C480 498 494 512 512 512H544C562 512 576 498 576 480V224C576 206 562 192 544 192ZM544 480H512V224H544V480ZM384 320H352C334 320 320 334 320 352V480C320 498 334 512 352 512H384C402 512 416 498 416 480V352C416 334 402 320 384 320ZM384 480H352V352H384V480ZM224 192H192C174 192 160 206 160 224V480C160 498 174 512 192 512H224C242 512 256 498 256 480V224C256 206 242 192 224 192ZM224 480H192V224H224V480ZM505 89C512 93 519 96 528 96C554 96 576 74 576 48S554 0 528 0S480 22 480 48C480 54 482 60 484 65L391 135C384 131 377 128 368 128S352 131 345 135L252 65C254 60 256 54 256 48C256 22 234 0 208 0S160 22 160 48C160 55 162 62 165 68L68 165C62 162 55 160 48 160C22 160 0 182 0 208S22 256 48 256S96 234 96 208C96 201 94 194 91 188L188 91C194 94 201 96 208 96C217 96 224 93 231 89L324 159C322 164 320 170 320 176C320 202 342 224 368 224S416 202 416 176C416 170 414 164 412 159L505 89ZM528 32C537 32 544 39 544 48S537 64 528 64C523 64 520 62 517 60L516 58L514 56C513 53 512 50 512 48C512 39 519 32 528 32ZM48 224C39 224 32 217 32 208S39 192 48 192C51 192 54 193 57 195L59 197L61 199C63 202 64 205 64 208C64 217 57 224 48 224ZM222 56L220 58L218 60C216 62 213 64 208 64C205 64 202 63 199 61L197 59L195 57C193 54 192 51 192 48C192 39 199 32 208 32S224 39 224 48C224 50 223 53 222 56ZM368 192C359 192 352 185 352 176C352 174 353 171 354 168L356 166L357 164C360 162 363 160 368 160S376 162 379 164L380 166L382 168C383 171 384 174 384 176C384 185 377 192 368 192Z"]
  };
  var faChartNetwork = {
    prefix: 'fal',
    iconName: 'chart-network',
    icon: [640, 512, [], "f78a", "M64 240C36 240 0 262 0 304C0 339 29 368 64 368S128 339 128 304C128 262 93 240 64 240ZM64 336C46 336 32 322 32 304S46 272 64 272S96 286 96 304S82 336 64 336ZM184 288H168C159 288 152 295 152 304V304C152 313 159 320 168 320H184C193 320 200 313 200 304V304C200 295 193 288 184 288ZM576 192C604 192 640 170 640 128C640 86 604 64 576 64C548 64 512 86 512 128C512 163 541 192 576 192ZM576 96C594 96 608 110 608 128S594 160 576 160S544 146 544 128S558 96 576 96ZM576 384C563 384 550 388 540 395C537 397 534 400 531 402L439 347C445 334 448 319 448 304C448 242 398 192 336 192C325 192 314 194 304 197L265 113C279 101 288 84 288 64C288 22 253 0 224 0C182 0 160 35 160 64C160 99 189 128 224 128C228 128 232 127 236 127L275 210C244 230 224 265 224 304C224 366 274 416 336 416C371 416 402 400 422 374L515 430C513 436 512 442 512 448C512 483 541 512 576 512C618 512 640 476 640 448C640 420 618 384 576 384ZM224 96C206 96 192 82 192 64S206 32 224 32S256 46 256 64S242 96 224 96ZM336 384C292 384 256 348 256 304S292 224 336 224S416 260 416 304S380 384 336 384ZM576 480C558 480 544 466 544 448S558 416 576 416S608 430 608 448S594 480 576 480ZM478 229L501 212C508 207 509 197 504 190C499 183 489 182 482 187L459 204C452 209 451 219 456 226C461 233 471 234 478 229Z"]
  };
  var faChartPie = {
    prefix: 'fal',
    iconName: 'chart-pie',
    icon: [576, 512, [], "f200", "M528 288L329 288C315 288 308 305 318 315L448 446C453 451 463 454 471 447C509 410 536 361 544 306C545 296 537 288 528 288ZM460 412L368 320H509C500 354 484 386 460 412ZM224 288V51C224 42 217 34 208 34C208 34 207 34 206 35C87 51 -4 156 0 280C4 407 113 512 240 512C241 512 242 512 243 512C293 511 340 495 378 468C386 462 387 451 380 444L224 288ZM243 480C127 480 36 385 32 279C29 179 96 92 192 70V288C192 296 195 305 201 311L343 453C313 470 278 479 243 480ZM512 223C504 104 408 8 289 0C278 0 272 8 272 16V224C272 233 279 240 288 240L496 240C505 240 513 232 512 223ZM304 208V34C393 48 464 119 478 208H304Z"]
  };
  var faChartPieSimple = {
    prefix: 'fal',
    iconName: 'chart-pie-simple',
    icon: [512, 512, [], "f64e", "M464 256H256V48C256 39 249 32 240 32C108 32 0 140 0 272S108 512 240 512S480 404 480 272C480 263 473 256 464 256ZM240 480C125 480 32 387 32 272C32 163 117 73 224 65V272C224 281 231 288 240 288H447C439 395 349 480 240 480ZM304 0C295 0 288 7 288 16V208C288 217 295 224 304 224H496C505 224 512 217 512 208C512 93 419 0 304 0ZM320 192V33C404 40 472 108 479 192H320Z"]
  };
  var faChartPyramid = {
    prefix: 'fal',
    iconName: 'chart-pyramid',
    icon: [512, 512, [], "e0c4", "M506 417L293 53C285 39 270 32 256 32S227 39 219 53L6 417C-11 445 10 480 43 480H469C502 480 523 445 506 417ZM422 336H90L165 208H347L422 336ZM247 69C249 65 254 64 256 64C258 64 263 65 265 69L328 176H184L247 69ZM479 443C478 445 475 448 469 448H43C37 448 35 445 33 443C32 441 31 437 33 433L72 368H440L479 433C481 437 480 441 479 443Z"]
  };
  var faChartRadar = {
    prefix: 'fal',
    iconName: 'chart-radar',
    icon: [512, 512, [], "e0c5", "M320 272C319 272 319 272 318 272L288 196C298 187 304 174 304 160C304 134 282 112 256 112S208 134 208 160C208 170 211 179 216 187L174 242C170 241 165 240 160 240C134 240 112 262 112 288S134 336 160 336C177 336 193 326 201 313L273 327C276 350 296 368 320 368C346 368 368 346 368 320S346 272 320 272ZM160 304C151 304 144 297 144 288S151 272 160 272S176 279 176 288S169 304 160 304ZM256 144C265 144 272 151 272 160S265 176 256 176S240 169 240 160S247 144 256 144ZM279 295L207 281C206 274 204 267 200 261L242 206C246 207 251 208 256 208C257 208 257 208 258 208L288 284C285 287 282 291 279 295ZM320 336C311 336 304 329 304 320S311 304 320 304S336 311 336 320S329 336 320 336ZM506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM478 262L373 441C371 446 366 448 361 448H151C146 448 141 446 139 442L34 262C31 258 31 254 34 250L139 70C141 66 146 64 151 64H361C366 64 371 66 373 70L478 250C481 254 481 258 478 262Z"]
  };
  var faChartScatter = {
    prefix: 'fal',
    iconName: 'chart-scatter',
    icon: [512, 512, [], "f7ee", "M288 280C301 280 312 269 312 256S301 232 288 232S264 243 264 256S275 280 288 280ZM384 344C397 344 408 333 408 320S397 296 384 296S360 307 360 320S371 344 384 344ZM416 152C429 152 440 141 440 128S429 104 416 104S392 115 392 128S403 152 416 152ZM160 344C173 344 184 333 184 320S173 296 160 296S136 307 136 320S147 344 160 344ZM192 184C205 184 216 173 216 160S205 136 192 136S168 147 168 160S179 184 192 184ZM496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448Z"]
  };
  var faChartScatter3d = {
    prefix: 'fal',
    iconName: 'chart-scatter-3d',
    icon: [512, 512, [], "e0c6", "M272 281V48C272 39 265 32 256 32S240 39 240 48V281L38 452C31 458 30 468 36 474C41 481 52 482 58 476L256 309L454 476C457 479 460 480 464 480C469 480 473 478 476 474C482 468 481 458 474 452L272 281ZM32 96C50 96 64 82 64 64S50 32 32 32S0 46 0 64S14 96 32 96ZM64 256C64 238 50 224 32 224S0 238 0 256S14 288 32 288S64 274 64 256ZM128 192C146 192 160 178 160 160S146 128 128 128S96 142 96 160S110 192 128 192ZM256 416C238 416 224 430 224 448S238 480 256 480S288 466 288 448S274 416 256 416ZM384 288C402 288 416 274 416 256S402 224 384 224S352 238 352 256S366 288 384 288ZM480 128C462 128 448 142 448 160S462 192 480 192S512 178 512 160S498 128 480 128ZM384 96C402 96 416 82 416 64S402 32 384 32S352 46 352 64S366 96 384 96Z"]
  };
  var faChartScatterBubble = {
    prefix: 'fal',
    iconName: 'chart-scatter-bubble',
    icon: [512, 512, [], "e0c7", "M384 192C419 192 448 163 448 128S419 64 384 64S320 93 320 128S349 192 384 192ZM384 96C402 96 416 110 416 128S402 160 384 160S352 146 352 128S366 96 384 96ZM496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM240 224C266 224 288 202 288 176S266 128 240 128S192 150 192 176S214 224 240 224ZM240 160C249 160 256 167 256 176S249 192 240 192S224 185 224 176S231 160 240 160ZM176 352C202 352 224 330 224 304S202 256 176 256S128 278 128 304S150 352 176 352ZM176 288C185 288 192 295 192 304S185 320 176 320S160 313 160 304S167 288 176 288ZM352 352C387 352 416 323 416 288S387 224 352 224S288 253 288 288S317 352 352 352ZM352 256C370 256 384 270 384 288S370 320 352 320S320 306 320 288S334 256 352 256Z"]
  };
  var faChartTreeMap = {
    prefix: 'fal',
    iconName: 'chart-tree-map',
    icon: [512, 512, [], "e0c8", "M464 32H304C278 32 256 54 256 80V112C256 138 278 160 304 160H464C490 160 512 138 512 112V80C512 54 490 32 464 32ZM480 112C480 121 473 128 464 128H304C295 128 288 121 288 112V80C288 71 295 64 304 64H464C473 64 480 71 480 80V112ZM176 272H48C22 272 0 294 0 320V432C0 458 22 480 48 480H176C202 480 224 458 224 432V320C224 294 202 272 176 272ZM192 432C192 441 185 448 176 448H48C39 448 32 441 32 432V320C32 311 39 304 48 304H176C185 304 192 311 192 320V432ZM176 32H48C22 32 0 54 0 80V192C0 218 22 240 48 240H176C202 240 224 218 224 192V80C224 54 202 32 176 32ZM192 192C192 201 185 208 176 208H48C39 208 32 201 32 192V80C32 71 39 64 48 64H176C185 64 192 71 192 80V192ZM464 352H304C278 352 256 374 256 400V432C256 458 278 480 304 480H464C490 480 512 458 512 432V400C512 374 490 352 464 352ZM480 432C480 441 473 448 464 448H304C295 448 288 441 288 432V400C288 391 295 384 304 384H464C473 384 480 391 480 400V432ZM464 192H304C278 192 256 214 256 240V272C256 298 278 320 304 320H464C490 320 512 298 512 272V240C512 214 490 192 464 192ZM480 272C480 281 473 288 464 288H304C295 288 288 281 288 272V240C288 231 295 224 304 224H464C473 224 480 231 480 240V272Z"]
  };
  var faChartUser = {
    prefix: 'fal',
    iconName: 'chart-user',
    icon: [640, 512, [], "f6a3", "M160 320C213 320 256 277 256 224C256 171 213 128 160 128C107 128 64 171 64 224C64 277 107 320 160 320ZM160 160C195 160 224 189 224 224S195 288 160 288S96 259 96 224S125 160 160 160ZM592 0H208C182 0 160 22 160 48V80C160 89 167 96 176 96S192 89 192 80V48C192 39 199 32 208 32H592C601 32 608 39 608 48V368C608 377 601 384 592 384H352C343 384 336 391 336 400S343 416 352 416H592C618 416 640 394 640 368V48C640 22 618 0 592 0ZM192 352H128C57 352 0 409 0 480C0 498 14 512 32 512H288C306 512 320 498 320 480C320 409 263 352 192 352ZM32 480C32 427 75 384 128 384H192C245 384 288 427 288 480H32ZM315 165C309 158 299 158 293 165S286 181 293 187L373 267C376 270 380 272 384 272S392 270 395 267L496 167V224C496 233 503 240 512 240S528 233 528 224V128C528 119 521 112 512 112H416C407 112 400 119 400 128S407 144 416 144H473L384 233L315 165Z"]
  };
  var faChartWaterfall = {
    prefix: 'fal',
    iconName: 'chart-waterfall',
    icon: [512, 512, [], "e0c9", "M256 256C265 256 272 249 272 240V144C272 135 265 128 256 128S240 135 240 144V240C240 249 247 256 256 256ZM352 192C361 192 368 185 368 176V80C368 71 361 64 352 64S336 71 336 80V176C336 185 343 192 352 192ZM160 352C169 352 176 345 176 336V240C176 231 169 224 160 224S144 231 144 240V336C144 345 151 352 160 352ZM496 448H80C54 448 32 426 32 400V48C32 39 25 32 16 32S0 39 0 48V400C0 444 36 480 80 480H496C505 480 512 473 512 464S505 448 496 448ZM448 352C457 352 464 345 464 336V80C464 71 457 64 448 64S432 71 432 80V336C432 345 439 352 448 352Z"]
  };
  var faCheck = {
    prefix: 'fal',
    iconName: 'check',
    icon: [512, 512, [], "f00c", "M475 123L203 395C200 398 196 400 192 400S184 398 181 395L37 251C30 245 30 235 37 229S53 222 59 229L192 361L453 101C459 94 469 94 475 101S482 117 475 123Z"]
  };
  var faCheckDouble = {
    prefix: 'fal',
    iconName: 'check-double',
    icon: [512, 512, [], "f560", "M475 165C469 158 459 158 453 165L192 425L59 293C53 286 43 286 37 293S30 309 37 315L181 459C184 462 188 464 192 464S200 462 203 459L475 187C482 181 482 171 475 165ZM181 235C184 238 188 240 192 240S200 238 203 235L379 59C386 53 386 43 379 37S363 30 357 37L192 201L123 133C117 126 107 126 101 133S94 149 101 155L181 235Z"]
  };
  var faCheese = {
    prefix: 'fal',
    iconName: 'cheese',
    icon: [512, 512, [], "f7ef", "M300 32H298C291 32 284 34 279 39L12 246C5 252 0 262 0 272V448C0 466 14 480 32 480H480C498 480 512 466 512 448V256C512 136 418 38 300 32ZM480 448H32V288H480V448ZM52 256L299 64C400 70 480 154 480 256H52Z"]
  };
  var faCheeseSwiss = {
    prefix: 'fal',
    iconName: 'cheese-swiss',
    icon: [512, 512, [], "f7f0", "M176 320C150 320 128 341 128 368S150 416 176 416S224 394 224 368S202 320 176 320ZM187 379C184 382 180 384 176 384V384C167 384 160 377 160 368C160 359 167 352 176 352S192 359 192 368C192 372 190 376 187 379ZM300 32H298C291 32 284 34 279 39L12 246C5 252 0 262 0 272V448C0 466 14 480 32 480H480C498 480 512 466 512 448V256C512 136 418 38 300 32ZM240 128C249 128 256 135 256 144C256 153 249 160 240 160S224 153 224 144C224 135 231 128 240 128ZM480 448H32V288H323C330 307 348 320 368 320S406 307 413 288H480V448ZM352 272C352 263 359 256 368 256S384 263 384 272S377 288 368 288S352 281 352 272ZM413 256C406 237 388 224 368 224S330 237 323 256H52L192 147C194 171 213 190 237 192S283 176 287 153C292 129 278 106 255 98L299 64C400 70 480 154 480 256H413Z"]
  };
  var faChess = {
    prefix: 'fal',
    iconName: 'chess',
    icon: [512, 512, [], "f439", "M499 428L480 419V408C480 395 469 384 456 384H344C331 384 320 395 320 408V419L301 428C293 432 288 441 288 450V488C288 501 299 512 312 512H488C501 512 512 501 512 488V450C512 441 507 432 499 428ZM480 480H320V455L352 439V416H448V439L480 455V480ZM57 224H49C41 224 34 229 32 237C31 247 38 256 48 256H64V285C64 301 63 318 61 334C60 344 67 352 77 352C85 352 92 346 93 338C95 320 96 302 96 285V256H160V285C160 302 161 320 163 338C164 346 171 352 179 352C189 352 196 344 195 334C193 318 192 301 192 285V256H207C215 256 222 251 224 243C225 233 218 224 208 224H199L231 139C236 126 231 110 218 101C213 98 207 96 200 96H144V64H159C167 64 174 59 176 51C177 41 170 32 160 32H144V17C144 9 139 2 131 0C121 -1 112 6 112 16V32H97C89 32 82 37 80 45C79 55 86 64 96 64H112V96H56C49 96 43 98 38 101C25 110 20 126 25 139L57 224ZM201 128L165 224H91L55 128H201ZM243 428L224 419V408C224 395 213 384 200 384H56C43 384 32 395 32 408V419L13 428C5 432 0 441 0 450V488C0 501 11 512 24 512H232C245 512 256 501 256 488V450C256 441 251 432 243 428ZM224 480H32V455L64 439V416H192V439L224 455V480ZM496 160H304C295 160 288 167 288 176V256C288 261 291 266 295 269L336 297V352C336 361 343 368 352 368S368 361 368 352V288C368 283 365 278 361 275L320 247V192H352V208C352 217 359 224 368 224S384 217 384 208V192H416V208C416 217 423 224 432 224S448 217 448 208V192H480V247L439 275C435 278 432 283 432 288V352C432 361 439 368 448 368S464 361 464 352V297L505 269C509 266 512 261 512 256V176C512 167 505 160 496 160Z"]
  };
  var faChessBishop = {
    prefix: 'fal',
    iconName: 'chess-bishop',
    icon: [320, 512, [], "f43a", "M64 372V400C64 409 71 416 80 416S96 409 96 400V360C96 353 91 347 84 345L73 341C53 336 32 317 32 284C32 231 86 137 131 96H189C209 115 231 144 250 176L165 261C158 267 158 277 165 283C168 286 172 288 176 288S184 286 187 283L265 206C279 234 288 263 288 284C288 317 267 336 247 341L236 345C229 347 224 353 224 360V400C224 409 231 416 240 416S256 409 256 400V372C290 362 320 331 320 284C320 217 254 106 201 64H119C66 106 0 217 0 284C0 331 30 362 64 372ZM112 32H208C217 32 224 25 224 16S217 0 208 0H112C103 0 96 7 96 16S103 32 112 32ZM272 448H48C22 448 0 470 0 496C0 505 7 512 16 512S32 505 32 496C32 487 39 480 48 480H272C281 480 288 487 288 496C288 505 295 512 304 512S320 505 320 496C320 470 298 448 272 448Z"]
  };
  var faChessBishopPiece = {
    prefix: 'fal',
    iconName: 'chess-bishop-piece',
    icon: [256, 512, [], "f43b", "M243 428L224 419V408C224 395 213 384 200 384H56C43 384 32 395 32 408V419L13 428C5 432 0 441 0 450V488C0 501 11 512 24 512H232C245 512 256 501 256 488V450C256 441 251 432 243 428ZM224 480H32V455L64 439V416H192V439L224 455V480ZM48 240C48 249 55 256 64 256H80L64 333C63 342 68 350 77 352C78 352 79 352 80 352C87 352 94 347 96 339L112 259C112 258 112 257 112 256H144C144 257 144 258 144 259L160 339C162 347 169 352 176 352C177 352 178 352 179 352C188 350 193 342 192 333L176 256H192C201 256 208 249 208 240C208 231 201 224 193 224C202 209 207 193 208 175C209 131 183 90 163 63C170 62 176 56 176 48C176 39 169 32 160 32H96C87 32 80 39 80 48C80 56 86 62 93 63C73 90 47 131 48 175C49 193 54 209 63 224C55 224 48 231 48 240ZM128 71C136 80 146 94 156 110L125 141C118 147 118 157 125 163C128 166 132 168 136 168S144 166 147 163L170 140C174 151 176 163 176 174C175 193 168 209 152 224H104C88 209 81 193 80 174C79 133 111 91 128 71Z"]
  };
  var faChessBoard = {
    prefix: 'fal',
    iconName: 'chess-board',
    icon: [448, 512, [], "f43c", "M352 112H96C87 112 80 119 80 128V384C80 393 87 400 96 400H352C361 400 368 393 368 384V128C368 119 361 112 352 112ZM144 368H112V336H144V368ZM144 304H112V272H144V304ZM144 240H112V208H144V240ZM144 176H112V144H144V176ZM208 368H176V336H208V368ZM208 304H176V272H208V304ZM208 240H176V208H208V240ZM208 176H176V144H208V176ZM272 368H240V336H272V368ZM272 304H240V272H272V304ZM272 240H240V208H272V240ZM272 176H240V144H272V176ZM336 368H304V336H336V368ZM336 304H304V272H336V304ZM336 240H304V208H336V240ZM336 176H304V144H336V176ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416Z"]
  };
  var faChessClock = {
    prefix: 'fal',
    iconName: 'chess-clock',
    icon: [640, 512, [], "f43d", "M400 96H528C537 96 544 89 544 80S537 64 528 64H400C391 64 384 71 384 80S391 96 400 96ZM464 192C402 192 352 242 352 304S402 416 464 416S576 366 576 304S526 192 464 192ZM521 361C489 392 439 392 407 361S376 279 407 247C435 220 477 217 508 237L453 293C446 299 446 309 453 315C459 322 469 322 475 315L531 260C551 291 548 333 521 361ZM176 192C114 192 64 242 64 304S114 416 176 416S288 366 288 304S238 192 176 192ZM176 384C132 384 96 348 96 304C96 265 124 233 160 226V304C160 313 167 320 176 320S192 313 192 304V226C228 233 256 265 256 304C256 348 220 384 176 384ZM576 128H192V64H240C249 64 256 57 256 48S249 32 240 32H112C103 32 96 39 96 48S103 64 112 64H160V128H64C29 128 0 157 0 192V416C0 451 29 480 64 480H576C611 480 640 451 640 416V192C640 157 611 128 576 128ZM608 416C608 434 594 448 576 448H64C46 448 32 434 32 416V192C32 174 46 160 64 160H576C594 160 608 174 608 192V416Z"]
  };
  var faChessClockFlip = {
    prefix: 'fal',
    iconName: 'chess-clock-flip',
    icon: [640, 512, [], "f43e", "M256 80C256 71 249 64 240 64H112C103 64 96 71 96 80S103 96 112 96H240C249 96 256 89 256 80ZM464 192C402 192 352 242 352 304S402 416 464 416S576 366 576 304S526 192 464 192ZM464 384C420 384 384 348 384 304C384 265 412 233 448 226V304C448 313 455 320 464 320S480 313 480 304V226C516 233 544 265 544 304C544 348 508 384 464 384ZM0 192L0 416C0 451 29 480 64 480H576C611 480 640 451 640 416V192C640 157 611 128 576 128H480V64H528C537 64 544 57 544 48S537 32 528 32H400C391 32 384 39 384 48S391 64 400 64H448V128H64C29 128 0 157 0 192ZM32 192C32 174 46 160 64 160H576C594 160 608 174 608 192V416C608 434 594 448 576 448H64C46 448 32 434 32 416V192ZM176 192C114 192 64 242 64 304S114 416 176 416S288 366 288 304S238 192 176 192ZM233 361C201 392 151 392 119 361S88 279 119 247C147 220 189 217 220 237L165 293C158 299 158 309 165 315C171 322 181 322 187 315L243 260C263 291 260 333 233 361Z"]
  };
  var faChessKing = {
    prefix: 'fal',
    iconName: 'chess-king',
    icon: [448, 512, [], "f43f", "M368 448H80C54 448 32 470 32 496C32 505 39 512 48 512S64 505 64 496C64 487 71 480 80 480H368C377 480 384 487 384 496C384 505 391 512 400 512S416 505 416 496C416 470 394 448 368 448ZM423 180C414 168 400 160 384 160H240V96H288C297 96 304 89 304 80S297 64 288 64H240V16C240 7 233 0 224 0S208 7 208 16V64H160C151 64 144 71 144 80S151 96 160 96H208V160H64C48 160 34 168 25 180C16 193 14 209 19 224L80 405C83 414 92 418 101 415C109 412 114 403 111 395L49 213C45 203 53 192 64 192H384C395 192 403 203 399 213L335 395C332 403 336 412 344 415C356 419 363 410 365 405L429 224C434 209 432 193 423 180Z"]
  };
  var faChessKingPiece = {
    prefix: 'fal',
    iconName: 'chess-king-piece',
    icon: [256, 512, [], "f440", "M57 224H49C41 224 34 229 32 237C31 247 38 256 48 256H64V285C64 301 63 318 61 334C60 344 67 352 77 352C85 352 92 346 93 338C95 320 96 302 96 285V256H160V285C160 302 161 320 163 338C164 346 171 352 179 352C189 352 196 344 195 334C193 318 192 301 192 285V256H207C215 256 222 251 224 243C225 233 218 224 208 224H199L231 139C236 126 231 110 218 101C213 98 207 96 200 96H144V64H159C167 64 174 59 176 51C177 41 170 32 160 32H144V17C144 9 139 2 131 0C121 -1 112 6 112 16V32H97C89 32 82 37 80 45C79 55 86 64 96 64H112V96H56C49 96 43 98 38 101C25 110 20 126 25 139L57 224ZM201 128L165 224H91L55 128H201ZM243 428L224 419V408C224 395 213 384 200 384H56C43 384 32 395 32 408V419L13 428C5 432 0 441 0 450V488C0 501 11 512 24 512H232C245 512 256 501 256 488V450C256 441 251 432 243 428ZM224 480H32V455L64 439V416H192V439L224 455V480Z"]
  };
  var faChessKnight = {
    prefix: 'fal',
    iconName: 'chess-knight',
    icon: [384, 512, [], "f441", "M64 164C64 175 73 184 84 184S104 175 104 164S95 144 84 144S64 153 64 164ZM35 302C74 318 72 318 76 319C29 351 32 387 32 400C32 409 39 416 48 416S64 409 64 400C64 360 75 357 145 316C159 309 168 294 168 279V217L151 226C146 229 142 234 141 240L133 266C130 274 124 281 116 284L105 288C98 291 90 291 84 288L49 272C38 268 32 258 32 247V128C32 118 38 113 46 106L34 81C29 72 35 64 42 64H128C234 64 320 150 320 256V400C320 409 327 416 336 416S352 409 352 400V256C352 132 252 32 128 32H44C23 32 3 47 0 68C-1 78 1 87 5 95L8 101C3 109 0 118 0 128V247C0 271 14 292 35 302ZM336 448H48C22 448 0 470 0 496C0 505 7 512 16 512S32 505 32 496C32 487 39 480 48 480H336C345 480 352 487 352 496C352 505 359 512 368 512S384 505 384 496C384 470 362 448 336 448Z"]
  };
  var faChessKnightPiece = {
    prefix: 'fal',
    iconName: 'chess-knight-piece',
    icon: [320, 512, [], "f442", "M32 277L58 289C48 301 38 315 35 333C32 343 40 352 50 352C58 352 64 347 66 340C76 293 145 281 145 250V207L123 213C119 215 116 218 115 223L109 243C107 250 103 255 97 257L88 260C83 262 77 262 72 260L45 248C37 245 32 237 32 229V145C32 141 34 137 37 134L43 128L33 109C32 107 32 106 32 104C32 100 36 96 40 96H126C198 96 256 154 256 226V336C256 345 263 352 272 352H272C281 352 288 345 288 336V226C288 136 216 64 126 64H42C20 64 1 81 0 103C0 110 1 117 4 123L5 124C2 131 0 138 0 145V229C0 250 12 269 32 277ZM62 171C62 179 69 186 77 186S92 179 92 171C92 162 85 156 77 156C69 156 62 162 62 171ZM307 428L288 419V408C288 395 277 384 264 384H56C43 384 32 395 32 408V419L13 428C5 432 0 441 0 450V488C0 501 11 512 24 512H296C309 512 320 501 320 488V450C320 441 315 432 307 428ZM288 480H32V455L64 439V416H256V439L288 455V480Z"]
  };
  var faChessPawn = {
    prefix: 'fal',
    iconName: 'chess-pawn',
    icon: [320, 512, [], "f443", "M272 448H48C22 448 0 470 0 496C0 505 7 512 16 512S32 505 32 496C32 487 39 480 48 480H272C281 480 288 487 288 496C288 505 295 512 304 512S320 505 320 496C320 470 298 448 272 448ZM80 208C71 208 64 215 64 224S71 240 80 240H100L64 396C62 406 69 416 80 416C87 416 94 411 96 404L133 240H187L224 404C226 411 233 416 240 416C251 416 258 406 256 396L220 240H240C249 240 256 233 256 224S249 208 240 208H235C253 189 264 164 264 136C264 79 217 32 160 32S56 79 56 136C56 164 67 189 85 208H80ZM160 64C200 64 232 96 232 136S200 208 160 208S88 176 88 136S120 64 160 64Z"]
  };
  var faChessPawnPiece = {
    prefix: 'fal',
    iconName: 'chess-pawn-piece',
    icon: [256, 512, [], "f444", "M243 428L224 419V408C224 395 213 384 200 384H56C43 384 32 395 32 408V419L13 428C5 432 0 441 0 450V488C0 501 11 512 24 512H232C245 512 256 501 256 488V450C256 441 251 432 243 428ZM224 480H32V455L64 439V416H192V439L224 455V480ZM48 240C48 249 55 256 64 256H77L64 333C63 342 69 350 77 352C78 352 79 352 80 352C88 352 94 346 96 339L110 256H146L160 339C162 346 168 352 176 352C177 352 178 352 179 352C187 350 193 342 192 333L179 256H192C201 256 208 249 208 240S201 224 192 224H192C202 211 208 194 208 176C208 132 172 96 128 96C84 96 48 132 48 176C48 194 54 211 64 224H64C55 224 48 231 48 240ZM128 128C154 128 176 150 176 176S154 224 128 224S80 202 80 176S102 128 128 128Z"]
  };
  var faChessQueen = {
    prefix: 'fal',
    iconName: 'chess-queen',
    icon: [512, 512, [], "f445", "M400 448H112C86 448 64 470 64 496C64 505 71 512 80 512S96 505 96 496C96 487 103 480 112 480H400C409 480 416 487 416 496C416 505 423 512 432 512S448 505 448 496C448 470 427 448 400 448ZM482 180L458 167C444 157 427 161 417 174C411 182 401 186 391 184C379 182 370 170 370 156C370 140 358 128 342 128H308C295 128 284 137 282 149C279 162 268 171 256 171S233 162 231 150C228 137 217 128 204 128H170C154 128 142 141 142 156C142 171 131 184 118 185C109 186 101 181 96 174C86 161 67 157 55 166L29 181C17 189 12 206 19 219L109 407C113 415 122 418 130 414C138 411 142 401 138 393L49 206L70 193C82 209 100 218 120 217C149 215 172 190 174 160H200C207 185 230 203 256 203C282 203 305 185 312 160H338C340 188 359 211 385 216C406 220 429 211 441 194L464 205L374 393C371 401 374 411 382 414C384 415 387 416 389 416C395 416 401 413 403 407L493 219C500 206 495 189 482 180ZM46 208L46 208L46 208L46 208ZM256 112C287 112 312 87 312 56S287 0 256 0S200 25 200 56S225 112 256 112ZM256 32C269 32 280 43 280 56C280 69 269 80 256 80S232 69 232 56C232 43 243 32 256 32Z"]
  };
  var faChessQueenPiece = {
    prefix: 'fal',
    iconName: 'chess-queen-piece',
    icon: [256, 512, [], "f446", "M128 48C141 48 152 37 152 24S141 0 128 0S104 11 104 24S115 48 128 48ZM243 428L224 419V408C224 395 213 384 200 384H56C43 384 32 395 32 408V419L13 428C5 432 0 441 0 450V488C0 501 11 512 24 512H232C245 512 256 501 256 488V450C256 441 251 432 243 428ZM224 480H32V455L64 439V416H192V439L224 455V480ZM62 224H48C39 224 32 231 32 240C32 249 39 256 48 256H64V285C64 301 63 318 61 334C60 344 67 352 77 352C85 352 92 346 93 338C95 320 96 302 96 285V256H160V285C160 302 161 320 163 338C164 346 171 352 179 352C189 352 196 344 195 334C193 318 192 301 192 285V256H208C217 256 224 249 224 240C224 231 217 224 208 224H194L245 100C246 96 245 92 242 90L231 83C226 80 222 83 221 85C208 102 180 94 180 70C180 66 177 64 174 64H156C153 64 151 66 150 69C148 79 139 86 128 86S108 79 106 69C105 66 103 64 100 64H82C78 64 76 67 76 71C75 93 48 102 35 85C34 83 30 80 25 83L14 90C11 92 10 96 11 100L62 224ZM57 126C71 125 85 118 94 107C114 122 142 122 162 107C174 121 190 125 199 126L159 224H97L57 126H57Z"]
  };
  var faChessRook = {
    prefix: 'fal',
    iconName: 'chess-rook',
    icon: [384, 512, [], "f447", "M336 32H48C22 32 0 54 0 80V192C0 196 2 200 5 203L64 263C64 302 65 327 54 397C52 406 58 414 67 416C75 417 84 411 85 403C97 330 96 303 96 256C96 252 94 248 91 245L32 185V80C32 71 39 64 48 64H112V128C112 137 119 144 128 144S144 137 144 128V64H240V128C240 137 247 144 256 144S272 137 272 128V64H336C345 64 352 71 352 80V185L293 245C290 248 288 252 288 256C288 305 287 330 299 403C301 416 315 416 317 416C326 414 332 406 330 397C319 327 320 301 320 263L379 203C382 200 384 196 384 192V80C384 54 362 32 336 32ZM336 448H48C22 448 0 470 0 496C0 505 7 512 16 512S32 505 32 496C32 487 39 480 48 480H336C345 480 352 487 352 496C352 505 359 512 368 512S384 505 384 496C384 470 362 448 336 448ZM224 320C233 320 240 313 240 304V240C240 214 218 192 192 192S144 214 144 240V304C144 313 151 320 160 320H224ZM176 240C176 231 183 224 192 224S208 231 208 240V288H176V240Z"]
  };
  var faChessRookPiece = {
    prefix: 'fal',
    iconName: 'chess-rook-piece',
    icon: [320, 512, [], "f448", "M307 428L288 419V408C288 395 277 384 264 384H56C43 384 32 395 32 408V419L13 428C5 432 0 441 0 450V488C0 501 11 512 24 512H296C309 512 320 501 320 488V450C320 441 315 432 307 428ZM288 480H32V455L64 439V416H256V439L288 455V480ZM71 232L64 335C63 344 70 351 79 352C79 352 80 352 80 352C88 352 95 346 96 337L104 220L69 184C66 181 64 177 64 173V96H112V128C112 137 119 144 128 144S144 137 144 128V96H176V128C176 137 183 144 192 144S208 137 208 128V96H256V173C256 177 254 181 251 184L216 220L224 337C225 346 233 353 241 352C250 351 257 344 256 335L249 232L274 207C283 198 288 186 288 173V88C288 75 277 64 264 64H56C43 64 32 75 32 88V173C32 186 37 198 46 206L71 232ZM144 224V256H176V224C176 215 169 208 160 208S144 215 144 224Z"]
  };
  var faChevronDown = {
    prefix: 'fal',
    iconName: 'chevron-down',
    icon: [448, 512, [], "f078", "M4 181C7 178 12 176 16 176C20 176 24 177 27 180L224 362L421 180C428 174 438 175 444 181C450 188 449 198 443 204L235 396C229 401 219 401 213 396L5 204C-1 198 -2 188 4 181Z"]
  };
  var faChevronLeft = {
    prefix: 'fal',
    iconName: 'chevron-left',
    icon: [320, 512, [], "f053", "M235 36C238 39 240 44 240 48C240 52 239 56 236 59L54 256L236 453C242 460 241 470 235 476C228 482 218 481 212 475L20 267C15 261 15 251 20 245L212 37C218 31 228 30 235 36Z"]
  };
  var faChevronRight = {
    prefix: 'fal',
    iconName: 'chevron-right',
    icon: [320, 512, [], "f054", "M21 476C18 473 16 468 16 464C16 460 17 456 20 453L202 256L20 59C14 52 15 42 21 36C28 30 38 31 44 37L236 245C241 251 241 261 236 267L44 475C38 481 28 482 21 476Z"]
  };
  var faChevronUp = {
    prefix: 'fal',
    iconName: 'chevron-up',
    icon: [448, 512, [], "f077", "M444 331C441 334 436 336 432 336C428 336 424 335 421 332L224 150L27 332C20 338 10 337 4 331C-2 324 -1 314 5 308L213 116C219 111 229 111 235 116L443 308C449 314 450 324 444 331Z"]
  };
  var faChevronsDown = {
    prefix: 'fal',
    iconName: 'chevrons-down',
    icon: [448, 512, [], "f322", "M421 244L224 426L27 244C24 241 20 240 16 240C12 240 7 242 4 245C-2 252 -1 262 5 268L213 460C219 465 229 465 235 460L443 268C449 262 450 252 444 245C438 239 428 238 421 244ZM213 268C219 273 229 273 235 268L443 76C449 70 450 60 444 53C438 47 428 46 421 52L224 234L27 52C24 49 20 48 16 48C12 48 7 50 4 53C-2 60 -1 70 5 76L213 268Z"]
  };
  var faChevronsLeft = {
    prefix: 'fal',
    iconName: 'chevrons-left',
    icon: [448, 512, [], "f323", "M236 453L54 256L236 59C239 56 240 52 240 48C240 44 238 39 235 36C228 30 218 31 212 37L20 245C15 251 15 261 20 267L212 475C218 481 228 482 235 476C241 470 242 460 236 453ZM212 245C207 251 207 261 212 267L404 475C410 481 420 482 427 476C433 470 434 460 428 453L246 256L428 59C431 56 432 52 432 48C432 44 430 39 427 36C420 30 410 31 404 37L212 245Z"]
  };
  var faChevronsRight = {
    prefix: 'fal',
    iconName: 'chevrons-right',
    icon: [448, 512, [], "f324", "M212 59L394 256L212 453C209 456 208 460 208 464C208 468 210 473 213 476C220 482 230 481 236 475L428 267C433 261 433 251 428 245L236 37C230 31 220 30 213 36C207 42 206 52 212 59ZM236 267C241 261 241 251 236 245L44 37C38 31 28 30 21 36C15 42 14 52 20 59L202 256L20 453C17 456 16 460 16 464C16 468 18 473 21 476C28 482 38 481 44 475L236 267Z"]
  };
  var faChevronsUp = {
    prefix: 'fal',
    iconName: 'chevrons-up',
    icon: [448, 512, [], "f325", "M27 268L224 86L421 268C424 271 428 272 432 272C436 272 441 270 444 267C450 260 449 250 443 244L235 52C229 47 219 47 213 52L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268ZM235 244C229 239 219 239 213 244L5 436C-1 442 -2 452 4 459C10 465 20 466 27 460L224 278L421 460C424 463 428 464 432 464C436 464 441 462 444 459C450 452 449 442 443 436L235 244Z"]
  };
  var faChild = {
    prefix: 'fal',
    iconName: 'child',
    icon: [448, 512, [], "f1ae", "M224 144C264 144 296 112 296 72S264 0 224 0S152 32 152 72S184 144 224 144ZM224 32C246 32 264 50 264 72S246 112 224 112C202 112 184 94 184 72S202 32 224 32ZM408 114C401 110 391 112 386 120C385 123 341 192 224 192C108 192 64 123 62 120C57 112 47 110 40 114S30 129 34 136C36 139 68 190 144 213V496C144 505 151 512 160 512S176 505 176 496V368H272V496C272 505 279 512 288 512S304 505 304 496V213C380 190 412 139 414 136C418 129 416 119 408 114ZM272 336H176V220C191 223 207 224 224 224S257 223 272 220V336Z"]
  };
  var faChimney = {
    prefix: 'fal',
    iconName: 'chimney',
    icon: [448, 512, [], "f78b", "M416 32H32C14 32 0 46 0 64V128C0 146 14 160 32 160L32 463C32 471 37 478 45 480C55 481 64 474 64 464V416H288V464C288 473 295 480 304 480H304C313 480 320 473 320 464V416H384V463C384 471 389 478 397 480C407 481 416 474 416 464V160C434 160 448 146 448 128V64C448 46 434 32 416 32ZM128 256H64V160H128V256ZM64 384V288H192V384H64ZM384 384H224V288H384V384ZM384 256H160V160H384V256ZM416 128H32V64H416V128Z"]
  };
  var faChurch = {
    prefix: 'fal',
    iconName: 'church',
    icon: [640, 512, [], "f51d", "M623 356L512 303V339L607 384C607 385 608 386 608 388V496C608 505 615 512 624 512S640 505 640 496V388C640 374 633 361 623 356ZM0 388V496C0 505 7 512 16 512S32 505 32 496V388C32 386 33 385 33 384L128 339V303L17 356C7 361 0 374 0 388ZM465 247L336 170V112H400C409 112 416 105 416 96C416 87 409 80 400 80H336V16C336 7 329 0 320 0S304 7 304 16V80H240C231 80 224 87 224 96C224 105 231 112 240 112H304V170L175 247C166 253 160 263 160 274V496C160 505 167 512 176 512S192 505 192 496V274L320 197L448 274V496C448 505 455 512 464 512S480 505 480 496V274C480 263 474 253 465 247ZM314 320C280 323 256 353 256 387V496C256 505 263 512 272 512S288 505 288 496V386C288 370 299 355 315 353C335 349 352 365 352 384V496C352 505 359 512 368 512S384 505 384 496V384C384 347 352 317 314 320Z"]
  };
  var faCircle = {
    prefix: 'fal',
    iconName: 'circle',
    icon: [512, 512, [], "f111", "M256 48C371 48 464 141 464 256S371 464 256 464S48 371 48 256S141 48 256 48M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16L256 16Z"]
  };
  var faCircle0 = {
    prefix: 'fal',
    iconName: 'circle-0',
    icon: [512, 512, [], "e0ca", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM256 128C203 128 160 171 160 224V288C160 341 203 384 256 384S352 341 352 288V224C352 171 309 128 256 128ZM320 288C320 323 291 352 256 352S192 323 192 288V224C192 189 221 160 256 160S320 189 320 224V288Z"]
  };
  var faCircle1 = {
    prefix: 'fal',
    iconName: 'circle-1',
    icon: [512, 512, [], "e0cb", "M320 352H272V144C272 138 269 133 264 130C258 127 252 127 247 131L199 163C192 168 190 178 195 185C200 192 209 194 217 189L240 174V352H192C183 352 176 359 176 368S183 384 192 384H320C329 384 336 377 336 368S329 352 320 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircle2 = {
    prefix: 'fal',
    iconName: 'circle-2',
    icon: [512, 512, [], "e0cc", "M336 352H219L306 275C340 245 344 194 315 158C300 141 280 130 257 128C234 126 212 134 195 149L178 164C171 170 170 180 176 186C182 193 192 194 199 188L216 173C227 164 240 159 254 160C269 161 281 168 290 179C309 201 306 233 285 251L165 356C160 360 159 367 161 374C163 380 169 384 176 384H336C345 384 352 377 352 368S345 352 336 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircle3 = {
    prefix: 'fal',
    iconName: 'circle-3',
    icon: [512, 512, [], "e0cd", "M272 224H251L330 156C336 152 337 145 335 138C333 132 327 128 320 128H176C167 128 160 135 160 144S167 160 176 160H277L198 228C193 232 191 239 193 246C195 252 201 256 208 256H272C298 256 320 278 320 304S298 352 272 352H218C206 352 195 344 191 333C188 325 179 320 171 323C163 326 158 335 161 343C169 368 192 384 218 384H272C316 384 352 348 352 304S316 224 272 224ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircle4 = {
    prefix: 'fal',
    iconName: 'circle-4',
    icon: [512, 512, [], "e0ce", "M336 288H320V208C320 199 313 192 304 192S288 199 288 208V288H184L239 150C242 142 238 132 230 129C222 126 212 130 209 138L145 298C143 303 144 309 147 313C150 317 155 320 160 320H288V368C288 377 295 384 304 384S320 377 320 368V320H336C345 320 352 313 352 304S345 288 336 288ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircle5 = {
    prefix: 'fal',
    iconName: 'circle-5',
    icon: [512, 512, [], "e0cf", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM286 233L204 224L220 160H320C329 160 336 153 336 144S329 128 320 128H208C201 128 194 133 193 140L169 233C167 238 168 243 171 246C173 250 178 253 182 253L282 265C304 268 320 287 320 308C320 332 300 352 276 352H218C206 352 195 344 191 332C188 324 179 319 171 322C163 325 158 334 161 343C169 367 192 384 218 384H276C318 384 352 350 352 308C352 271 324 238 286 233Z"]
  };
  var faCircle6 = {
    prefix: 'fal',
    iconName: 'circle-6',
    icon: [640, 512, [], "e0d0", "M1936 128H1776C1767 128 1760 135 1760 144S1767 160 1776 160H1908L1794 360C1790 368 1792 378 1800 382C1803 383 1805 384 1808 384C1814 384 1819 381 1822 376L1950 152C1953 147 1953 141 1950 136C1947 131 1942 128 1936 128ZM1856 16C1723 16 1616 123 1616 256S1723 496 1856 496S2096 389 2096 256S1989 16 1856 16ZM1856 464C1741 464 1648 371 1648 256S1741 48 1856 48S2064 141 2064 256S1971 464 1856 464ZM-1216 16C-1349 16 -1456 123 -1456 256S-1349 496 -1216 496S-976 389 -976 256S-1083 16 -1216 16ZM-1216 464C-1331 464 -1424 371 -1424 256S-1331 48 -1216 48S-1008 141 -1008 256S-1101 464 -1216 464ZM-1186 233L-1268 224L-1252 160H-1152C-1143 160 -1136 153 -1136 144S-1143 128 -1152 128H-1264C-1271 128 -1278 133 -1279 140L-1303 233C-1305 238 -1304 243 -1301 246C-1299 250 -1294 253 -1290 253L-1190 265C-1168 268 -1152 287 -1152 308C-1152 332 -1172 352 -1196 352H-1254C-1266 352 -1277 344 -1281 332C-1284 324 -1293 319 -1301 322C-1309 325 -1314 334 -1311 343C-1303 367 -1280 384 -1254 384H-1196C-1154 384 -1120 350 -1120 308C-1120 271 -1148 238 -1186 233Z"]
  };
  var faCircle7 = {
    prefix: 'fal',
    iconName: 'circle-7',
    icon: [512, 512, [], "e0d1", "M336 128H176C167 128 160 135 160 144S167 160 176 160H308L194 360C190 368 192 378 200 382C203 383 205 384 208 384C214 384 219 381 222 376L350 152C353 147 353 141 350 136C347 131 342 128 336 128ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircle8 = {
    prefix: 'fal',
    iconName: 'circle-8',
    icon: [512, 512, [], "e0d2", "M316 250C328 237 336 219 336 200C336 160 304 128 264 128H248C208 128 176 160 176 200C176 219 184 237 196 250C175 262 160 285 160 312C160 352 192 384 232 384H280C320 384 352 352 352 312C352 285 337 262 316 250ZM248 160H264C286 160 304 178 304 200S286 240 264 240H248C226 240 208 222 208 200S226 160 248 160ZM280 352H232C210 352 192 334 192 312S210 272 232 272H280C302 272 320 290 320 312S302 352 280 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircle9 = {
    prefix: 'fal',
    iconName: 'circle-9',
    icon: [512, 512, [], "e0d3", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM256 128C203 128 160 171 160 224C160 274 198 314 247 319L198 355C191 361 190 371 195 378C198 382 203 384 208 384C211 384 215 383 218 381L307 314C349 282 352 234 352 224C352 171 309 128 256 128ZM256 288C221 288 192 259 192 224C192 189 221 160 256 160S320 189 320 224C320 259 291 288 256 288Z"]
  };
  var faCircleA = {
    prefix: 'fal',
    iconName: 'circle-a',
    icon: [512, 512, [], "e0d4", "M270 121C265 110 247 110 242 121L130 345C126 353 129 362 137 366C145 370 154 367 158 359L178 319C179 320 180 320 181 320H331C332 320 333 320 334 319L354 359C357 365 362 368 368 368C370 368 373 367 375 366C383 362 386 353 382 345L270 121ZM194 288L256 164L318 288H194ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleAmpersand = {
    prefix: 'fal',
    iconName: 'circle-ampersand',
    icon: [512, 512, [], "e0d5", "M329 321L365 270C370 263 368 253 361 248C354 243 344 244 339 252L307 297L257 243L284 221C297 211 304 196 304 180C304 151 280 128 250 128H230C200 128 176 151 176 180C176 196 182 210 192 221L210 240L168 273C153 285 144 303 144 322C144 356 173 384 208 384H244C269 384 293 372 307 352L311 347L340 379C343 382 348 384 352 384C356 384 360 383 363 380C369 374 370 364 364 357L329 321ZM208 180C208 169 218 160 230 160H250C262 160 272 169 272 180C272 186 269 192 264 196L235 220L216 199C211 194 208 187 208 180ZM281 333C281 333 281 333 281 333C273 345 259 352 244 352H208C190 352 176 338 176 322C176 313 180 304 188 298L232 263L288 323L281 333ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleArrowDown = {
    prefix: 'fal',
    iconName: 'circle-arrow-down',
    icon: [512, 512, [], "f0ab", "M341 261L272 329V144C272 135 265 128 256 128S240 135 240 144V329L171 261C165 254 155 254 149 261S142 277 149 283L245 379C248 382 252 384 256 384S264 382 267 379L363 283C370 277 370 267 363 261S347 254 341 261ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleArrowLeft = {
    prefix: 'fal',
    iconName: 'circle-arrow-left',
    icon: [512, 512, [], "f0a8", "M251 341L183 272H368C377 272 384 265 384 256S377 240 368 240H183L251 171C258 165 258 155 251 149S235 142 229 149L133 245C130 248 128 252 128 256S130 264 133 267L229 363C235 370 245 370 251 363S258 347 251 341ZM496 256C496 123 389 16 256 16S16 123 16 256S123 496 256 496S496 389 496 256ZM48 256C48 141 141 48 256 48S464 141 464 256S371 464 256 464S48 371 48 256Z"]
  };
  var faCircleArrowRight = {
    prefix: 'fal',
    iconName: 'circle-arrow-right',
    icon: [512, 512, [], "f0a9", "M261 171L329 240H144C135 240 128 247 128 256S135 272 144 272H329L261 341C254 347 254 357 261 363S277 370 283 363L379 267C382 264 384 260 384 256S382 248 379 245L283 149C277 142 267 142 261 149S254 165 261 171ZM16 256C16 389 123 496 256 496S496 389 496 256S389 16 256 16S16 123 16 256ZM464 256C464 371 371 464 256 464S48 371 48 256S141 48 256 48S464 141 464 256Z"]
  };
  var faCircleArrowUp = {
    prefix: 'fal',
    iconName: 'circle-arrow-up',
    icon: [512, 512, [], "f0aa", "M171 251L240 183V368C240 377 247 384 256 384S272 377 272 368V183L341 251C347 258 357 258 363 251S370 235 363 229L267 133C264 130 260 128 256 128S248 130 245 133L149 229C142 235 142 245 149 251S165 258 171 251ZM256 496C389 496 496 389 496 256S389 16 256 16S16 123 16 256S123 496 256 496ZM256 48C371 48 464 141 464 256S371 464 256 464S48 371 48 256S141 48 256 48Z"]
  };
  var faCircleB = {
    prefix: 'fal',
    iconName: 'circle-b',
    icon: [512, 512, [], "e0d6", "M332 250C344 237 352 219 352 200C352 160 320 128 280 128H192C174 128 160 142 160 160V352C160 370 174 384 192 384H296C336 384 368 352 368 312C368 285 353 262 332 250ZM192 160H280C302 160 320 178 320 200S302 240 280 240H192V160ZM296 352H192V272H296C318 272 336 290 336 312S318 352 296 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleBookOpen = {
    prefix: 'fal',
    iconName: 'circle-book-open',
    icon: [512, 512, [], "e0d7", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM384 157C360 148 338 144 318 144C288 144 267 153 256 158C245 153 224 144 194 144H194C174 144 151 148 129 157C118 160 112 171 112 181V333C112 340 115 347 121 351C125 354 130 356 135 356C137 356 140 355 142 355C157 350 172 348 185 348C208 348 226 354 239 362C244 366 250 368 256 368C262 368 268 366 273 362C286 354 304 348 328 348C341 348 355 350 370 355C372 355 375 356 377 356C382 356 386 354 391 351C397 347 400 340 400 333V181C400 171 394 160 384 157ZM240 327C224 320 205 316 185 316C171 316 158 318 144 321V185C162 179 179 176 194 176C216 176 232 182 240 186V327ZM368 321C354 318 341 316 328 316C307 316 288 320 272 327V186C280 182 296 176 318 176C334 176 351 179 368 185V321Z"]
  };
  var faCircleBookmark = {
    prefix: 'fal',
    iconName: 'circle-bookmark',
    icon: [512, 512, [], "e0d8", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM320 128H192C174 128 160 142 160 160V368C160 374 164 380 169 382C175 385 181 384 186 381L256 324L326 380C329 383 332 384 336 384C338 384 341 383 343 382C348 380 352 374 352 368V160C352 142 338 128 320 128ZM320 335L266 291C263 289 260 288 256 288S249 289 246 291L192 335V160H320V335Z"]
  };
  var faCircleC = {
    prefix: 'fal',
    iconName: 'circle-c',
    icon: [512, 512, [], "e0d9", "M325 188C331 194 341 194 347 188C354 182 354 172 347 165C297 116 216 116 166 165C141 190 128 222 128 256S141 322 166 347C191 371 224 384 256 384S322 371 347 347C354 340 354 330 347 324C341 318 331 318 325 324C287 361 226 361 188 324C170 306 160 282 160 256S170 206 188 188C226 151 287 151 325 188ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleCalendar = {
    prefix: 'fal',
    iconName: 'circle-calendar',
    icon: [512, 512, [], "e0da", "M336 128H320V112C320 103 313 96 304 96S288 103 288 112V128H224V112C224 103 217 96 208 96S192 103 192 112V128H176C150 128 128 150 128 176V336C128 362 150 384 176 384H336C362 384 384 362 384 336V176C384 150 362 128 336 128ZM352 336C352 345 345 352 336 352H176C167 352 160 345 160 336V224H352V336ZM352 192H160V176C160 167 167 160 176 160H336C345 160 352 167 352 176V192ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleCamera = {
    prefix: 'fal',
    iconName: 'circle-camera',
    icon: [512, 512, [], "e0db", "M256 224C238 224 224 238 224 256S238 288 256 288S288 274 288 256S274 224 256 224ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM336 160H316L310 144C306 134 297 128 287 128H225C215 128 206 134 202 144L196 160H176C150 160 128 182 128 208V304C128 330 150 352 176 352H336C362 352 384 330 384 304V208C384 182 362 160 336 160ZM352 304C352 313 345 320 336 320H176C167 320 160 313 160 304V208C160 199 167 192 176 192H218L230 160H282L294 192H336C345 192 352 199 352 208V304Z"]
  };
  var faCircleCaretDown = {
    prefix: 'fal',
    iconName: 'circle-caret-down',
    icon: [512, 512, [], "f32d", "M352 192H160C132 192 117 226 137 247L233 343C246 355 266 355 279 343L375 247C395 226 381 192 352 192ZM256 320L160 224H352L256 320ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleCaretLeft = {
    prefix: 'fal',
    iconName: 'circle-caret-left',
    icon: [512, 512, [], "f32e", "M265 137L169 233C157 246 157 266 169 279L265 375C286 395 320 381 320 352V160C320 132 286 117 265 137ZM288 352L192 256L288 160V352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleCaretRight = {
    prefix: 'fal',
    iconName: 'circle-caret-right',
    icon: [512, 512, [], "f330", "M247 137C226 117 192 131 192 160V352C192 380 226 395 247 375L343 279C355 266 355 246 343 233L247 137ZM224 352V160L320 256L224 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleCaretUp = {
    prefix: 'fal',
    iconName: 'circle-caret-up',
    icon: [512, 512, [], "f331", "M279 169C266 157 246 157 233 169L137 265C117 286 131 320 160 320H352C380 320 395 286 375 265L279 169ZM160 288L256 192L352 288H160ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleCheck = {
    prefix: 'fal',
    iconName: 'circle-check',
    icon: [512, 512, [], "f058", "M341 181L224 297L171 245C165 238 155 238 149 245S142 261 149 267L213 331C216 334 220 336 224 336S232 334 235 331L363 203C370 197 370 187 363 181S347 174 341 181ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleChevronDown = {
    prefix: 'fal',
    iconName: 'circle-chevron-down',
    icon: [512, 512, [], "f13a", "M133 213C126 219 126 229 133 235L245 347C248 350 252 352 256 352S264 350 267 347L379 235C386 229 386 219 379 213S363 206 357 213L256 313L155 213C149 206 139 206 133 213ZM16 256C16 389 123 496 256 496S496 389 496 256S389 16 256 16S16 123 16 256ZM464 256C464 371 371 464 256 464S48 371 48 256S141 48 256 48S464 141 464 256Z"]
  };
  var faCircleChevronLeft = {
    prefix: 'fal',
    iconName: 'circle-chevron-left',
    icon: [512, 512, [], "f137", "M299 133C293 126 283 126 277 133L165 245C162 248 160 252 160 256S162 264 165 267L277 379C283 386 293 386 299 379S306 363 299 357L199 256L299 155C306 149 306 139 299 133ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleChevronRight = {
    prefix: 'fal',
    iconName: 'circle-chevron-right',
    icon: [512, 512, [], "f138", "M235 133C229 126 219 126 213 133S206 149 213 155L313 256L213 357C206 363 206 373 213 379S229 386 235 379L347 267C350 264 352 260 352 256S350 248 347 245L235 133ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleChevronUp = {
    prefix: 'fal',
    iconName: 'circle-chevron-up',
    icon: [512, 512, [], "f139", "M267 165C264 162 260 160 256 160S248 162 245 165L133 277C126 283 126 293 133 299S149 306 155 299L256 199L357 299C363 306 373 306 379 299S386 283 379 277L267 165ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleD = {
    prefix: 'fal',
    iconName: 'circle-d',
    icon: [512, 512, [], "e0dc", "M256 128H176C167 128 160 135 160 144V368C160 377 167 384 176 384H256C327 384 384 327 384 256S327 128 256 128ZM256 352H192V160H256C309 160 352 203 352 256S309 352 256 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleDashed = {
    prefix: 'fal',
    iconName: 'circle-dashed',
    icon: [512, 512, [], "e0dd", "M222 19C182 25 144 40 113 64C105 70 104 81 111 88L111 88C117 94 126 94 132 90C159 69 192 55 227 50C235 49 240 42 240 35C240 25 232 17 222 19ZM227 462C192 457 159 443 132 422C126 418 117 418 111 424L111 424C104 431 105 442 113 448C144 472 182 487 222 493C232 495 240 487 240 477C240 470 235 463 227 462ZM51 286C50 278 43 272 35 272C25 272 18 281 19 290C25 331 41 368 65 400C70 407 82 408 89 401L89 401C94 396 95 387 90 381C70 353 56 321 51 286ZM89 111C82 104 70 105 65 112C41 144 25 181 19 222C18 231 25 240 35 240C43 240 50 234 51 226C56 191 70 159 90 131C95 125 94 116 89 111L89 111ZM402 424C396 418 387 418 381 422C354 443 321 457 286 462C278 463 272 470 272 477C272 487 281 495 291 493C331 488 369 472 400 448C408 442 409 431 402 424L402 424ZM478 272C470 272 463 278 462 286C457 321 443 353 423 381C418 387 419 396 424 401L424 401C431 408 443 407 448 400C472 368 488 331 494 290C495 281 488 272 478 272ZM462 226C463 234 470 240 478 240C488 240 495 231 494 222C488 181 472 144 448 112C443 105 431 104 424 111L424 111C419 116 418 125 423 131C443 159 457 191 462 226ZM291 19C281 17 272 25 272 35C272 42 278 49 286 50C321 55 354 69 381 90C387 94 396 94 402 88L402 88C409 81 408 70 400 64C369 40 331 25 291 19Z"]
  };
  var faCircleDollar = {
    prefix: 'fal',
    iconName: 'circle-dollar',
    icon: [496, 512, [], "f2e8", "M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 464c-119.1 0-216-96.9-216-216S128.9 40 248 40s216 96.9 216 216-96.9 216-216 216zm40.3-221.3l-72-20.2c-12.1-3.4-20.6-14.4-20.6-26.7 0-15.3 12.8-27.8 28.5-27.8h45c11.2 0 21.9 3.6 30.6 10.1 3.2 2.4 7.6 2 10.4-.8l11.3-11.5c3.4-3.4 3-9-.8-12-14.6-11.6-32.6-17.9-51.6-17.9H264v-40c0-4.4-3.6-8-8-8h-16c-4.4 0-8 3.6-8 8v40h-7.8c-33.3 0-60.5 26.8-60.5 59.8 0 26.6 18.1 50.2 43.9 57.5l72 20.2c12.1 3.4 20.6 14.4 20.6 26.7 0 15.3-12.8 27.8-28.5 27.8h-45c-11.2 0-21.9-3.6-30.6-10.1-3.2-2.4-7.6-2-10.4.8l-11.3 11.5c-3.4 3.4-3 9 .8 12 14.6 11.6 32.6 17.9 51.6 17.9h5.2v40c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-40h7.8c33.3 0 60.5-26.8 60.5-59.8-.1-26.6-18.1-50.2-44-57.5z"]
  };
  var faCircleDollarToSlot = {
    prefix: 'fal',
    iconName: 'circle-dollar-to-slot',
    icon: [512, 512, [], "f4b9", "M244 271C236 270 231 268 205 260C197 257 188 261 185 270C182 278 187 287 195 290C224 300 231 301 240 303V320C240 329 247 336 256 336S272 329 272 320V303C302 300 323 284 327 259C335 213 290 201 260 193L253 191C219 181 214 174 216 162C219 146 244 142 268 145C274 146 282 148 293 152C301 154 310 150 313 142C316 133 311 124 303 121C291 117 280 115 272 114V96C272 87 265 80 256 80S240 87 240 96V113C210 116 189 132 185 157C177 202 222 215 244 221L252 223C290 234 298 239 295 254C293 270 268 274 244 271ZM464 352C455 352 448 359 448 368S455 384 464 384C473 384 480 391 480 400V464C480 473 473 480 464 480H48C39 480 32 473 32 464V400C32 391 39 384 48 384C57 384 64 377 64 368S57 352 48 352C22 352 0 374 0 400V464C0 490 22 512 48 512H464C490 512 512 490 512 464V400C512 374 490 352 464 352ZM256 416C371 416 464 323 464 208S371 0 256 0S48 93 48 208S141 416 256 416ZM256 32C353 32 432 111 432 208S353 384 256 384S80 305 80 208S159 32 256 32Z"]
  };
  var faCircleDot = {
    prefix: 'fal',
    iconName: 'circle-dot',
    icon: [512, 512, [], "f192", "M256 16C123 16 16 123 16 256C16 389 123 496 256 496S496 389 496 256C496 123 389 16 256 16ZM256 464C142 464 48 372 48 256C48 142 140 48 256 48C370 48 464 140 464 256C464 370 372 464 256 464ZM256 160C203 160 160 203 160 256C160 309 203 352 256 352S352 309 352 256C352 203 309 160 256 160ZM256 320C221 320 192 291 192 256C192 221 221 192 256 192S320 221 320 256C320 291 291 320 256 320Z"]
  };
  var faCircleDown = {
    prefix: 'fal',
    iconName: 'circle-down',
    icon: [512, 512, [], "f358", "M228 388C243 403 269 404 284 388L377 292C388 281 392 264 386 249C379 234 365 224 349 224H320V152C320 130 302 112 280 112H232C210 112 192 130 192 152V224H163C147 224 133 234 126 249C120 264 124 281 135 292L228 388ZM163 256H224V152C224 148 228 144 232 144H280C284 144 288 148 288 152V256H349C355 256 360 264 354 270L262 366C257 370 252 367 250 366L158 270L158 270C153 265 156 256 163 256ZM256 496C389 496 496 389 496 256S389 16 256 16S16 123 16 256S123 496 256 496ZM256 48C371 48 464 141 464 256S371 464 256 464S48 371 48 256S141 48 256 48Z"]
  };
  var faCircleE = {
    prefix: 'fal',
    iconName: 'circle-e',
    icon: [512, 512, [], "e0de", "M336 160C345 160 352 153 352 144S345 128 336 128H176C167 128 160 135 160 144V368C160 377 167 384 176 384H336C345 384 352 377 352 368S345 352 336 352H192V272H288C297 272 304 265 304 256S297 240 288 240H192V160H336ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleEnvelope = {
    prefix: 'fal',
    iconName: 'circle-envelope',
    icon: [512, 512, [], "e0df", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM352 160H160C142 160 128 174 128 192V320C128 338 142 352 160 352H352C370 352 384 338 384 320V192C384 174 370 160 352 160ZM352 320H160V245L249 287C251 287 254 288 256 288S261 287 263 287L352 245V320ZM352 210L256 254L160 210V192H352V210Z"]
  };
  var faCircleExclamation = {
    prefix: 'fal',
    iconName: 'circle-exclamation',
    icon: [512, 512, [], "f06a", "M256 344C243 344 232 355 232 368S243 392 256 392S280 381 280 368S269 344 256 344ZM256 304C265 304 272 297 272 288V128C272 119 265 112 256 112S240 119 240 128V288C240 297 247 304 256 304ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleF = {
    prefix: 'fal',
    iconName: 'circle-f',
    icon: [512, 512, [], "e0e0", "M336 128H176C167 128 160 135 160 144V368C160 377 167 384 176 384S192 377 192 368V288H304C313 288 320 281 320 272S313 256 304 256H192V160H336C345 160 352 153 352 144S345 128 336 128ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleG = {
    prefix: 'fal',
    iconName: 'circle-g',
    icon: [640, 512, [], "e0e1", "M432 256H357C349 256 341 263 341 272S349 288 357 288H411C406 301 397 314 388 324C352 360 288 360 252 324C234 306 224 282 224 256S234 206 252 188C288 152 346 150 384 184C391 190 401 190 407 183C412 177 412 166 405 161C355 115 278 117 230 165C180 215 180 297 230 346C254 371 286 384 320 384S386 371 410 347C429 328 443 301 448 276C448 275 448 273 448 272C448 263 441 256 432 256ZM320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 464C205 464 112 371 112 256S205 48 320 48S528 141 528 256S435 464 320 464Z"]
  };
  var faCircleH = {
    prefix: 'fal',
    iconName: 'circle-h',
    icon: [640, 512, [], "f47e", "M400 128C391 128 384 135 384 144V240H256V144C256 135 249 128 240 128S224 135 224 144V368C224 377 231 384 240 384S256 377 256 368V272H384V368C384 377 391 384 400 384S416 377 416 368V144C416 135 409 128 400 128ZM320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 464C205 464 112 371 112 256S205 48 320 48S528 141 528 256S435 464 320 464Z"]
  };
  var faCircleHalf = {
    prefix: 'fal',
    iconName: 'circle-half',
    icon: [512, 512, [], "e0e2", "M240 17C240 17 240 17 239 17C114 25 16 129 16 256C16 383 114 487 239 495C240 495 240 495 240 495C249 495 256 488 256 479V33C256 24 249 17 240 17ZM224 462C124 446 48 359 48 256C48 153 124 66 224 50V462Z"]
  };
  var faCircleHalfStroke = {
    prefix: 'fal',
    iconName: 'circle-half-stroke',
    icon: [512, 512, [], "f042", "M256 16C123 16 16 123 16 256C16 389 123 496 256 496S496 389 496 256C496 123 389 16 256 16ZM48 256C48 147 133 57 240 49V463C133 455 48 365 48 256ZM272 463V49C379 57 464 147 464 256S379 455 272 463Z"]
  };
  var faCircleHeart = {
    prefix: 'fal',
    iconName: 'circle-heart',
    icon: [512, 512, [], "f4c7", "M326 144C303 144 281 155 267 169L256 181L245 169C231 155 209 144 186 144C171 144 154 149 140 162C105 192 103 247 134 280L243 394C250 402 262 402 269 394L378 280C409 247 407 192 372 162C358 149 341 144 326 144ZM355 258L256 362L157 258C140 241 137 206 160 186C169 179 178 176 187 176C201 176 214 183 222 192L256 227L290 192C298 183 311 176 325 176C334 176 343 179 351 186C375 206 372 241 355 258ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleI = {
    prefix: 'fal',
    iconName: 'circle-i',
    icon: [512, 512, [], "e0e3", "M352 144C352 135 345 128 336 128H176C167 128 160 135 160 144S167 160 176 160H241C240 161 240 163 240 164V348C240 349 240 351 241 352H176C167 352 160 359 160 368S167 384 176 384H336C345 384 352 377 352 368S345 352 336 352H271C272 351 272 349 272 348V164C272 163 272 161 271 160H336C345 160 352 153 352 144ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleInfo = {
    prefix: 'fal',
    iconName: 'circle-info',
    icon: [512, 512, [], "f05a", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM256 184C269 184 280 173 280 160C280 147 269 136 256 136S232 147 232 160C232 173 243 184 256 184ZM304 352H272V240C272 231 265 224 256 224H224C215 224 208 231 208 240S215 256 224 256H240V352H208C199 352 192 359 192 368C192 377 199 384 208 384H304C313 384 320 377 320 368C320 359 313 352 304 352Z"]
  };
  var faCircleJ = {
    prefix: 'fal',
    iconName: 'circle-j',
    icon: [512, 512, [], "e0e4", "M320 128C311 128 304 135 304 144V293C304 326 275 352 240 352S176 326 176 293V272C176 263 169 256 160 256S144 263 144 272V293C144 343 187 384 240 384S336 343 336 293V144C336 135 329 128 320 128ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleK = {
    prefix: 'fal',
    iconName: 'circle-k',
    icon: [512, 512, [], "e0e5", "M348 133C342 127 332 126 325 132L192 252V144C192 135 185 128 176 128S160 135 160 144V368C160 377 167 384 176 384S192 377 192 368V295L233 258L323 378C326 382 331 384 336 384C339 384 343 383 346 381C353 375 354 365 349 358L257 236L347 156C353 150 354 140 348 133ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleL = {
    prefix: 'fal',
    iconName: 'circle-l',
    icon: [512, 512, [], "e0e6", "M336 352H192V144C192 135 185 128 176 128S160 135 160 144V368C160 377 167 384 176 384H336C345 384 352 377 352 368S345 352 336 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleLeft = {
    prefix: 'fal',
    iconName: 'circle-left',
    icon: [512, 512, [], "f359", "M124 228C109 243 108 269 124 284L220 377C231 388 248 392 263 386C278 379 288 365 288 349V320H360C382 320 400 302 400 280V232C400 210 382 192 360 192H288V163C288 147 278 133 263 126C248 120 231 124 220 135L124 228ZM256 163V224H360C364 224 368 228 368 232V280C368 284 364 288 360 288H256V349C256 355 248 360 242 354L146 262C142 258 145 252 146 251L242 158L242 158C247 153 256 156 256 163ZM16 256C16 389 123 496 256 496S496 389 496 256S389 16 256 16S16 123 16 256ZM464 256C464 371 371 464 256 464S48 371 48 256S141 48 256 48S464 141 464 256Z"]
  };
  var faCircleLocationArrow = {
    prefix: 'fal',
    iconName: 'circle-location-arrow',
    icon: [512, 512, [], "f602", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM338 152C335 152 332 153 329 154L133 238C124 242 118 252 120 262C123 273 132 280 142 280H232V370C232 380 239 390 250 392C251 392 253 392 254 392C263 392 271 387 274 379L358 183V183C362 174 360 165 354 158C349 154 344 152 338 152ZM264 321V248H191L319 193L264 321Z"]
  };
  var faCircleM = {
    prefix: 'fal',
    iconName: 'circle-m',
    icon: [512, 512, [], "e0e7", "M373 129C366 127 359 129 355 135L256 276L157 135C153 129 146 127 139 129C133 131 128 137 128 144V368C128 377 135 384 144 384S160 377 160 368V195L243 313C249 322 263 322 269 313L352 195V368C352 377 359 384 368 384S384 377 384 368V144C384 137 379 131 373 129ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleMicrophone = {
    prefix: 'fal',
    iconName: 'circle-microphone',
    icon: [512, 512, [], "e0e8", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM256 320C291 320 320 291 320 256V160C320 125 291 96 256 96S192 125 192 160V256C192 291 221 320 256 320ZM224 160C224 142 238 128 256 128S288 142 288 160V256C288 274 274 288 256 288S224 274 224 256V160ZM368 224C359 224 352 231 352 240V256C352 309 309 352 256 352S160 309 160 256V240C160 231 153 224 144 224S128 231 128 240V256C128 321 177 374 240 382V400C240 409 247 416 256 416S272 409 272 400V382C335 374 384 321 384 256V240C384 231 377 224 368 224Z"]
  };
  var faCircleMicrophoneLines = {
    prefix: 'fal',
    iconName: 'circle-microphone-lines',
    icon: [512, 512, [], "e0e9", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM256 320C291 320 320 291 320 256V160C320 125 291 96 256 96S192 125 192 160V256C192 291 221 320 256 320ZM224 160C224 142 238 128 256 128S288 142 288 160H272C263 160 256 167 256 176S263 192 272 192H288V224H272C263 224 256 231 256 240S263 256 272 256H288C288 274 274 288 256 288S224 274 224 256V160ZM368 224C359 224 352 231 352 240V256C352 309 309 352 256 352S160 309 160 256V240C160 231 153 224 144 224S128 231 128 240V256C128 321 177 374 240 382V400C240 409 247 416 256 416S272 409 272 400V382C335 374 384 321 384 256V240C384 231 377 224 368 224Z"]
  };
  var faCircleMinus = {
    prefix: 'fal',
    iconName: 'circle-minus',
    icon: [512, 512, [], "f056", "M352 240H160C151 240 144 247 144 256S151 272 160 272H352C361 272 368 265 368 256S361 240 352 240ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleN = {
    prefix: 'fal',
    iconName: 'circle-n',
    icon: [512, 512, [], "e0ea", "M352 128C343 128 336 135 336 144V325L172 134C168 128 161 127 154 129C148 131 144 137 144 144V368C144 377 151 384 160 384S176 377 176 368V187L340 378C343 382 347 384 352 384C354 384 356 384 358 383C364 381 368 375 368 368V144C368 135 361 128 352 128ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleNotch = {
    prefix: 'fal',
    iconName: 'circle-notch',
    icon: [512, 512, [], "f1ce", "M496 256C496 388 388 496 256 496S16 388 16 256C16 151 86 56 187 26C196 23 205 28 207 37C210 45 205 54 197 57C109 83 48 165 48 256C48 371 141 464 256 464S464 371 464 256C464 165 403 83 315 57C307 54 302 45 305 37C307 28 316 23 325 26C426 56 496 151 496 256Z"]
  };
  var faCircleO = {
    prefix: 'fal',
    iconName: 'circle-o',
    icon: [512, 512, [], "e0eb", "M256 128C185 128 128 185 128 256S185 384 256 384S384 327 384 256S327 128 256 128ZM256 352C203 352 160 309 160 256S203 160 256 160S352 203 352 256S309 352 256 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleP = {
    prefix: 'fal',
    iconName: 'circle-p',
    icon: [512, 512, [], "e0ec", "M272 128H176C167 128 160 135 160 144V368C160 377 167 384 176 384S192 377 192 368V320H272C325 320 368 277 368 224S325 128 272 128ZM272 288H192V160H272C307 160 336 189 336 224S307 288 272 288ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleParking = {
    prefix: 'fal',
    iconName: 'circle-parking',
    icon: [512, 512, [], "f615", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM288 128H208C190 128 176 142 176 160V368C176 377 183 384 192 384S208 377 208 368V320H288C341 320 384 277 384 224S341 128 288 128ZM288 288H208V160H288C323 160 352 189 352 224S323 288 288 288Z"]
  };
  var faCirclePause = {
    prefix: 'fal',
    iconName: 'circle-pause',
    icon: [512, 512, [], "f28b", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM304 160C295 160 288 167 288 176V336C288 345 295 352 304 352S320 345 320 336V176C320 167 313 160 304 160ZM208 160C199 160 192 167 192 176V336C192 345 199 352 208 352S224 345 224 336V176C224 167 217 160 208 160Z"]
  };
  var faCirclePhone = {
    prefix: 'fal',
    iconName: 'circle-phone',
    icon: [512, 512, [], "e0ed", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM370 276C370 276 369 276 369 276L322 256C306 249 289 254 278 266L272 275C258 266 247 254 237 240L246 234C258 223 263 206 256 190L236 142C229 126 211 117 193 121L149 131C132 135 120 150 120 167C120 291 221 392 345 392C362 392 377 380 381 363L391 319C395 301 386 283 370 276ZM350 356C349 358 347 360 345 360C238 360 152 274 152 167C152 165 154 163 156 162L200 152C201 152 201 152 201 152C204 152 205 153 206 155L227 203C228 205 227 207 225 209L206 225C200 229 199 238 202 245C217 272 240 295 268 310C274 313 283 312 288 306L303 287C305 285 307 284 309 285L357 306C359 307 360 309 360 312L350 356Z"]
  };
  var faCirclePhoneFlip = {
    prefix: 'fal',
    iconName: 'circle-phone-flip',
    icon: [512, 512, [], "e0ee", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM363 131L319 121C301 117 283 126 276 142L256 190C249 206 254 223 266 234L275 240C265 254 254 266 240 275L234 266C223 254 206 249 190 256L143 276C143 276 142 276 142 276C126 283 117 301 121 319L131 363C135 380 150 392 167 392C291 392 392 291 392 167C392 150 380 135 363 131ZM167 360C165 360 163 358 162 356L152 312C152 309 153 307 155 306L203 285C205 284 207 285 209 287L224 306C229 312 238 313 244 310C272 295 295 272 310 245C313 238 312 229 306 225L287 209C285 207 284 205 285 203L306 155C307 153 309 152 311 152C311 152 311 152 312 152L356 162C358 163 360 165 360 167C360 274 274 360 167 360Z"]
  };
  var faCirclePhoneHangup = {
    prefix: 'fal',
    iconName: 'circle-phone-hangup',
    icon: [512, 512, [], "e0ef", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM415 226C327 138 185 138 97 226C85 238 83 257 92 272L116 310C126 325 145 332 161 325C161 325 161 325 161 325L210 306C225 300 234 284 233 268L232 257C248 254 264 254 280 257L279 268C278 284 287 300 302 306L351 325C367 332 386 326 396 310L420 272C429 257 427 238 415 226ZM393 255L369 293C369 294 368 294 368 294C367 296 364 296 362 295L314 276C312 275 311 273 311 271L313 246C314 239 309 232 302 229C272 221 240 221 210 229C202 232 198 239 198 246L201 271C201 273 200 275 198 276L150 295C147 296 145 295 143 293L119 255C118 253 118 250 120 248C195 173 317 173 392 248C394 250 394 253 393 255Z"]
  };
  var faCirclePlay = {
    prefix: 'fal',
    iconName: 'circle-play',
    icon: [512, 512, [], "f144", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM216 142C214 141 211 140 208 140C205 140 203 141 200 142C195 145 192 150 192 156V356C192 362 195 367 200 370C203 371 205 372 208 372C211 372 214 371 216 370L376 270C381 267 384 262 384 256S381 245 376 242L216 142ZM224 327V185L338 256L224 327Z"]
  };
  var faCirclePlus = {
    prefix: 'fal',
    iconName: 'circle-plus',
    icon: [512, 512, [], "f055", "M352 240H272V160C272 151 265 144 256 144S240 151 240 160V240H160C151 240 144 247 144 256S151 272 160 272H240V352C240 361 247 368 256 368S272 361 272 352V272H352C361 272 368 265 368 256S361 240 352 240ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleQ = {
    prefix: 'fal',
    iconName: 'circle-q',
    icon: [512, 512, [], "e0f0", "M256 128C185 128 128 185 128 256S185 384 256 384C286 384 312 374 334 357L357 379C360 382 364 384 368 384S376 382 379 379C386 373 386 363 379 357L357 334C374 312 384 286 384 256C384 185 327 128 256 128ZM334 311L299 277C293 270 283 270 277 277S270 293 277 299L311 334C296 345 277 352 256 352C203 352 160 309 160 256S203 160 256 160S352 203 352 256C352 277 345 296 334 311ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleQuarter = {
    prefix: 'fal',
    iconName: 'circle-quarter',
    icon: [512, 512, [], "e0f1", "M241 17C240 17 240 17 240 17C121 25 25 120 17 239C16 248 24 256 33 256H240C249 256 256 249 256 240V33C256 24 249 17 241 17ZM224 224H51C65 135 136 64 224 50V224Z"]
  };
  var faCircleQuestion = {
    prefix: 'fal',
    iconName: 'circle-question',
    icon: [512, 512, [], "f059", "M286 128H226C190 128 160 158 160 194V204C160 213 167 220 176 220S192 213 192 204V194C192 175 207 160 226 160H286C305 160 320 175 320 194C320 207 313 218 303 224L242 254C231 261 224 273 224 286V304C224 313 231 320 240 320S256 313 256 304V286C256 284 257 283 257 283L318 252C339 241 352 218 352 194C352 158 322 128 286 128ZM240 344C227 344 216 355 216 368S227 392 240 392S264 381 264 368S253 344 240 344ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleR = {
    prefix: 'fal',
    iconName: 'circle-r',
    icon: [512, 512, [], "e0f2", "M368 208C368 164 332 128 288 128H176C167 128 160 135 160 144V368C160 377 167 384 176 384S192 377 192 368V288H262L340 378C343 382 347 384 352 384C356 384 359 383 362 380C369 374 370 364 364 358L303 286C340 279 368 247 368 208ZM288 256H192V160H288C314 160 336 182 336 208S314 256 288 256ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleRadiation = {
    prefix: 'fal',
    iconName: 'circle-radiation',
    icon: [512, 512, [], "f7ba", "M306 296C302 288 292 286 284 291C277 295 274 305 279 313L321 380C322 382 321 383 320 383C281 405 230 405 192 383C191 383 190 382 191 380L233 312C238 305 235 295 228 290C220 286 210 288 206 296L164 363C159 371 157 380 159 389C162 398 168 406 176 411C200 425 228 432 256 432C284 432 312 425 336 411C344 407 350 398 352 389C355 380 353 371 348 363L306 296ZM212 263C212 254 205 248 195 248L117 250C114 250 114 249 114 248C114 226 120 204 131 184C143 164 159 148 178 137C178 136 180 136 181 138L219 208C223 215 232 218 240 214C248 210 251 200 247 193L210 123C205 115 198 108 189 106C180 103 170 104 162 109C138 123 118 143 103 168C89 192 82 220 82 248C82 257 86 266 92 273C99 279 107 282 116 282H117L197 280C205 279 212 272 212 263ZM409 168C394 144 374 123 350 109C342 104 332 103 323 106C314 108 307 114 302 123L265 193C261 200 264 210 272 214C280 218 289 215 293 208L331 138C332 136 334 136 334 137C353 148 370 164 381 184C392 204 398 226 398 248C398 248 399 251 396 250L316 248C308 249 300 254 300 263C300 272 307 279 315 280L394 282C395 282 395 282 396 282C405 282 413 279 419 273C426 267 430 257 430 248C430 220 423 193 409 168ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM232 256C232 269 243 280 256 280S280 269 280 256C280 243 269 232 256 232S232 243 232 256Z"]
  };
  var faCircleRight = {
    prefix: 'fal',
    iconName: 'circle-right',
    icon: [512, 512, [], "f35a", "M388 284C403 269 404 243 388 228L292 135C281 124 264 120 249 126C234 133 224 147 224 163V192H152C130 192 112 210 112 232V280C112 302 130 320 152 320H224V349C224 365 234 379 249 386C264 392 281 388 292 377L388 284ZM256 349V288H152C148 288 144 284 144 280V232C144 228 148 224 152 224H256V163C256 157 264 152 270 158L366 250C370 255 367 260 366 262L270 354L270 354C265 359 256 356 256 349ZM496 256C496 123 389 16 256 16S16 123 16 256S123 496 256 496S496 389 496 256ZM48 256C48 141 141 48 256 48S464 141 464 256S371 464 256 464S48 371 48 256Z"]
  };
  var faCircleS = {
    prefix: 'fal',
    iconName: 'circle-s',
    icon: [512, 512, [], "e0f3", "M260 241C209 227 188 218 193 190C194 184 197 176 207 170C221 161 249 154 309 169C318 171 327 165 329 157C331 148 326 140 317 138C260 123 217 125 190 143C175 153 164 167 161 185C150 244 209 260 252 272C303 285 324 294 319 322C317 332 312 340 303 344C280 357 233 353 182 334C173 331 164 335 161 343C158 351 162 361 170 364C186 370 227 384 267 384C286 384 304 381 319 372C336 363 347 347 351 328C362 268 303 252 260 241ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleSort = {
    prefix: 'fal',
    iconName: 'circle-sort',
    icon: [512, 512, [], "e030", "M269 101C266 98 261 96 256 96S246 98 243 101L152 193C140 204 148 224 165 224H347C363 224 372 204 360 193L269 101ZM198 192L256 134L314 192H198ZM347 288H165C148 288 140 308 152 319L243 411C246 414 251 416 256 416S266 414 269 411L360 319C372 308 363 288 347 288ZM256 378L198 320H314L256 378ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleSortDown = {
    prefix: 'fal',
    iconName: 'circle-sort-down',
    icon: [512, 512, [], "e031", "M347 288H165C148 288 140 308 152 319L243 411C246 414 251 416 256 416S266 414 269 411L360 319C372 308 364 288 347 288ZM256 378L198 320H314L256 378ZM267 101C261 94 251 94 245 101L149 197C143 203 143 213 149 219C155 225 165 225 171 219L256 135L341 219C347 225 357 225 363 219S369 203 363 197L267 101ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleSortUp = {
    prefix: 'fal',
    iconName: 'circle-sort-up',
    icon: [512, 512, [], "e032", "M165 224H347C363 224 372 204 360 193L269 101C266 98 261 96 256 96S246 98 243 101L152 193C140 204 148 224 165 224ZM256 134L314 192H198L256 134ZM341 293L256 377L171 293C165 287 155 287 149 293S143 309 149 315L245 411C251 417 261 417 267 411L363 315C369 309 369 299 363 293S347 287 341 293ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleStar = {
    prefix: 'fal',
    iconName: 'circle-star',
    icon: [512, 512, [], "e0f4", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM391 200L309 188L272 114C269 107 262 104 256 104C250 104 243 107 240 114L203 188L121 200C106 203 100 221 111 231L170 289L156 371C154 383 164 392 174 392C177 392 180 391 182 390L256 351L330 390C332 391 335 392 338 392C348 392 358 383 356 371L342 289L401 231C412 221 406 203 391 200ZM313 272C310 276 308 281 309 286L319 348L263 319C259 317 253 317 249 319L193 348L203 286C204 281 202 276 199 272L153 228L216 219C221 218 226 215 228 210L256 154L284 210C286 215 291 218 296 219L359 228L313 272Z"]
  };
  var faCircleStop = {
    prefix: 'fal',
    iconName: 'circle-stop',
    icon: [512, 512, [], "f28d", "M256 16C123 16 16 123 16 256C16 389 123 496 256 496S496 389 496 256C496 123 389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM320 160H192C174 160 160 174 160 192V320C160 338 174 352 192 352H320C338 352 352 338 352 320V192C352 174 338 160 320 160ZM320 320H192V192H320V320Z"]
  };
  var faCircleT = {
    prefix: 'fal',
    iconName: 'circle-t',
    icon: [512, 512, [], "e0f5", "M368 160H144C135 160 128 167 128 176S135 192 144 192H240V368C240 377 247 384 256 384S272 377 272 368V192H368C377 192 384 185 384 176S377 160 368 160ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleThreeQuarters = {
    prefix: 'fal',
    iconName: 'circle-three-quarters',
    icon: [512, 512, [], "e0f6", "M479 256H256V33C256 24 249 17 240 17C240 17 240 17 239 17C99 26 -8 156 21 304C39 398 114 473 208 491C224 494 240 496 256 496C383 496 487 398 495 273C496 264 488 256 479 256ZM256 464C242 464 228 463 214 460C133 444 68 379 52 298C40 237 54 177 91 129C124 87 171 59 224 50V256C224 274 238 288 256 288H462C446 388 359 464 256 464Z"]
  };
  var faCircleTrash = {
    prefix: 'fal',
    iconName: 'circle-trash',
    icon: [512, 512, [], "e0f7", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM352 144H304L298 132C297 130 294 128 291 128H221C218 128 215 130 214 132L208 144H160C151 144 144 151 144 160C144 169 151 176 160 176H160L169 350C170 369 186 384 205 384H307C326 384 342 369 343 350L352 176H352C361 176 368 169 368 160C368 151 361 144 352 144ZM311 348C311 350 309 352 307 352H205C203 352 201 350 201 348L192 176H320L311 348Z"]
  };
  var faCircleU = {
    prefix: 'fal',
    iconName: 'circle-u',
    icon: [512, 512, [], "e0f8", "M352 144C343 144 336 151 336 160V290C336 333 300 368 256 368S176 333 176 290V160C176 151 169 144 160 144S144 151 144 160V290C144 351 194 400 256 400S368 351 368 290V160C368 151 361 144 352 144ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleUp = {
    prefix: 'fal',
    iconName: 'circle-up',
    icon: [512, 512, [], "f35b", "M284 124C269 109 243 108 228 124L135 220C124 231 120 248 126 263C133 278 147 288 163 288H192V360C192 382 210 400 232 400H280C302 400 320 382 320 360V288H349C365 288 379 278 386 263C392 248 388 231 377 220L284 124ZM349 256H288V360C288 364 284 368 280 368H232C228 368 224 364 224 360V256H163C157 256 152 248 158 242L250 146C255 142 260 145 262 146L354 242L354 242C359 247 356 256 349 256ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleUser = {
    prefix: 'fal',
    iconName: 'circle-user',
    icon: [512, 512, [], "f2bd", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C205 464 157 445 121 414C137 378 174 352 216 352H296C338 352 375 378 391 414C355 445 307 464 256 464ZM415 390C391 348 347 320 296 320H216C165 320 121 348 97 390C67 354 48 307 48 256C48 141 141 48 256 48S464 141 464 256C464 307 445 354 415 390ZM256 128C212 128 176 164 176 208C176 252 212 288 256 288S336 252 336 208C336 164 300 128 256 128ZM256 256C230 256 208 234 208 208S230 160 256 160S304 182 304 208S282 256 256 256Z"]
  };
  var faCircleV = {
    prefix: 'fal',
    iconName: 'circle-v',
    icon: [512, 512, [], "e0f9", "M375 146C367 142 358 145 354 153L256 348L158 153C154 145 145 142 137 146C129 150 126 159 130 167L242 391C244 397 250 400 256 400S268 397 270 391L382 167C386 159 383 150 375 146ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleVideo = {
    prefix: 'fal',
    iconName: 'circle-video',
    icon: [512, 512, [], "e0fa", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM409 179C405 176 399 175 395 177L320 204V192C320 174 306 160 288 160H160C142 160 128 174 128 192V320C128 338 142 352 160 352H288C306 352 320 338 320 320V308L395 335C396 336 398 336 400 336C403 336 406 335 409 333C413 330 416 325 416 320V192C416 187 413 182 409 179ZM288 320H160V192H288V320ZM384 297L320 274V238L384 215V297Z"]
  };
  var faCircleW = {
    prefix: 'fal',
    iconName: 'circle-w',
    icon: [512, 512, [], "e0fb", "M388 145C380 142 371 147 369 156L320 326L271 156C267 142 245 142 241 156L192 326L143 156C141 147 132 142 124 145C115 147 110 156 113 164L177 388C181 402 203 402 207 388L256 218L305 388C307 395 313 400 320 400S333 395 335 388L399 164C402 156 397 147 388 145ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleWaveformLines = {
    prefix: 'fal',
    iconName: 'circle-waveform-lines',
    icon: [512, 512, [], "e0fc", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM144 160C135 160 128 167 128 176V336C128 345 135 352 144 352S160 345 160 336V176C160 167 153 160 144 160ZM208 200C199 200 192 207 192 216V296C192 305 199 312 208 312S224 305 224 296V216C224 207 217 200 208 200ZM272 136C263 136 256 143 256 152V360C256 369 263 376 272 376S288 369 288 360V152C288 143 281 136 272 136ZM336 184C327 184 320 191 320 200V312C320 321 327 328 336 328S352 321 352 312V200C352 191 345 184 336 184ZM400 224C391 224 384 231 384 240V272C384 281 391 288 400 288S416 281 416 272V240C416 231 409 224 400 224Z"]
  };
  var faCircleX = {
    prefix: 'fal',
    iconName: 'circle-x',
    icon: [512, 512, [], "e0fd", "M362 132C356 126 346 127 340 134L256 231L172 134C166 127 156 126 150 132C143 138 142 148 148 154L235 256L148 358C142 364 143 374 150 380C153 383 156 384 160 384C165 384 169 382 172 378L256 281L340 378C343 382 347 384 352 384C356 384 359 383 362 380C369 374 370 364 364 358L277 256L364 154C370 148 369 138 362 132ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleXmark = {
    prefix: 'fal',
    iconName: 'circle-xmark',
    icon: [512, 512, [], "f057", "M335 177C329 171 319 171 313 177L256 233L199 177C193 171 183 171 177 177C171 183 171 193 177 199L233 256L177 313C171 319 171 329 177 335C183 341 193 341 199 335L256 279L313 335C319 341 329 341 335 335C341 329 341 319 335 313L279 256L335 199C341 193 341 183 335 177ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleY = {
    prefix: 'fal',
    iconName: 'circle-y',
    icon: [512, 512, [], "e0fe", "M356 150L256 266L156 150C150 143 140 142 134 148C127 154 126 164 132 170L240 297V384C240 393 247 400 256 400S272 393 272 384V297L380 170C386 164 385 154 378 148C372 142 362 143 356 150ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCircleZ = {
    prefix: 'fal',
    iconName: 'circle-z',
    icon: [512, 512, [], "e0ff", "M352 352H195L364 154C368 150 369 143 367 137C364 132 358 128 352 128H160C151 128 144 135 144 144S151 160 160 160H317L148 358C144 362 143 369 145 375C148 380 154 384 160 384H352C361 384 368 377 368 368S361 352 352 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCity = {
    prefix: 'fal',
    iconName: 'city',
    icon: [640, 512, [], "f64f", "M592 192H512V48C512 22 490 0 464 0H336C310 0 288 22 288 48V96H224V16C224 7 217 0 208 0S192 7 192 16V96H128V16C128 7 121 0 112 0S96 7 96 16V96H48C22 96 0 118 0 144V496C0 505 7 512 16 512S32 505 32 496V152C32 139 43 128 56 128H320V56C320 43 331 32 344 32H456C469 32 480 43 480 56V224H584C597 224 608 235 608 248V496C608 505 615 512 624 512S640 505 640 496V240C640 214 618 192 592 192ZM128 416H96C78 416 64 430 64 448V480C64 498 78 512 96 512H128C146 512 160 498 160 480V448C160 430 146 416 128 416ZM128 480H96V448H128V480ZM128 288H96C78 288 64 302 64 320V352C64 370 78 384 96 384H128C146 384 160 370 160 352V320C160 302 146 288 128 288ZM128 352H96V320H128V352ZM128 160H96C78 160 64 174 64 192V224C64 242 78 256 96 256H128C146 256 160 242 160 224V192C160 174 146 160 128 160ZM128 224H96V192H128V224ZM256 416H224C206 416 192 430 192 448V480C192 498 206 512 224 512H256C274 512 288 498 288 480V448C288 430 274 416 256 416ZM256 480H224V448H256V480ZM256 288H224C206 288 192 302 192 320V352C192 370 206 384 224 384H256C274 384 288 370 288 352V320C288 302 274 288 256 288ZM256 352H224V320H256V352ZM256 160H224C206 160 192 174 192 192V224C192 242 206 256 224 256H256C274 256 288 242 288 224V192C288 174 274 160 256 160ZM256 224H224V192H256V224ZM544 416H512C494 416 480 430 480 448V480C480 498 494 512 512 512H544C562 512 576 498 576 480V448C576 430 562 416 544 416ZM544 480H512V448H544V480ZM544 288H512C494 288 480 302 480 320V352C480 370 494 384 512 384H544C562 384 576 370 576 352V320C576 302 562 288 544 288ZM544 352H512V320H544V352ZM416 64H384C366 64 352 78 352 96V128C352 146 366 160 384 160H416C434 160 448 146 448 128V96C448 78 434 64 416 64ZM416 128H384V96H416V128ZM416 192H384C366 192 352 206 352 224V256C352 274 366 288 384 288H416C434 288 448 274 448 256V224C448 206 434 192 416 192ZM416 256H384V224H416V256Z"]
  };
  var faClarinet = {
    prefix: 'fal',
    iconName: 'clarinet',
    icon: [640, 512, [], "f8ad", "M272 232C259 232 248 243 248 256C248 269 259 280 272 280S296 269 296 256C296 243 285 232 272 232ZM616 112C611 112 607 113 603 116L537 160H480V128H496C505 128 512 121 512 112C512 103 505 96 496 96H240C231 96 224 103 224 112C224 121 231 128 240 128H256V160H101C98 160 94 161 91 162L22 185C9 189 0 201 0 215V297C0 311 9 323 22 327L91 350C94 351 98 352 101 352H537L603 396C610 401 619 401 627 397C635 393 640 385 640 376V136C640 123 629 112 616 112ZM384 128H448V160H384V128ZM288 128H352V160H288V128ZM608 361L546 320H101L32 297V215L101 192H546L608 151V361ZM368 232C355 232 344 243 344 256C344 269 355 280 368 280S392 269 392 256C392 243 381 232 368 232ZM464 232C451 232 440 243 440 256C440 269 451 280 464 280S488 269 488 256C488 243 477 232 464 232Z"]
  };
  var faClawMarks = {
    prefix: 'fal',
    iconName: 'claw-marks',
    icon: [512, 512, [], "f6c2", "M427 405C424 402 420 400 416 400H368V352C368 348 366 344 363 341L267 245C264 242 260 240 256 240H208V192C208 188 206 184 203 181L27 5C21 -2 11 -2 5 5S-2 21 5 27L176 199V256C176 265 183 272 192 272H249L336 359V416C336 425 343 432 352 432H409L485 507C488 510 492 512 496 512S504 510 507 507C514 501 514 491 507 485L427 405ZM240 39V96C240 105 247 112 256 112H313L368 167V224C368 233 375 240 384 240H441L485 283C488 286 492 288 496 288S504 286 507 283C514 277 514 267 507 261L459 213C456 210 452 208 448 208H400V160C400 156 398 152 395 149L331 85C328 82 324 80 320 80H272V32C272 28 270 24 267 21L251 5C245 -2 235 -2 229 5S222 21 229 27L240 39ZM171 373C168 370 164 368 160 368H112V320C112 316 110 312 107 309L27 229C21 222 11 222 5 229S-2 245 5 251L80 327V384C80 393 87 400 96 400H153L261 507C264 510 268 512 272 512S280 510 283 507C290 501 290 491 283 485L171 373Z"]
  };
  var faClipboard = {
    prefix: 'fal',
    iconName: 'clipboard',
    icon: [384, 512, [], "f328", "M112 128H272C281 128 288 121 288 112S281 96 272 96H247C253 87 256 76 256 64C256 29 227 0 192 0S128 29 128 64C128 76 131 87 137 96H112C103 96 96 103 96 112S103 128 112 128ZM192 32C210 32 224 46 224 64S210 96 192 96S160 82 160 64S174 32 192 32ZM320 64C311 64 304 71 304 80S311 96 320 96C338 96 352 110 352 128V448C352 466 338 480 320 480H64C46 480 32 466 32 448V128C32 110 46 96 64 96C73 96 80 89 80 80S73 64 64 64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64Z"]
  };
  var faClipboardCheck = {
    prefix: 'fal',
    iconName: 'clipboard-check',
    icon: [384, 512, [], "f46c", "M320 64C311 64 304 71 304 80S311 96 320 96C338 96 352 110 352 128V448C352 466 338 480 320 480H64C46 480 32 466 32 448V128C32 110 46 96 64 96C73 96 80 89 80 80S73 64 64 64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM112 128H272C281 128 288 121 288 112S281 96 272 96H247C253 87 256 76 256 64C256 29 227 0 192 0S128 29 128 64C128 76 131 87 137 96H112C103 96 96 103 96 112S103 128 112 128ZM192 32C210 32 224 46 224 64S210 96 192 96S160 82 160 64S174 32 192 32ZM85 299L149 363C152 366 156 368 160 368S168 366 171 363L299 235C306 229 306 219 299 213S283 206 277 213L160 329L107 277C101 270 91 270 85 277S78 293 85 299Z"]
  };
  var faClipboardList = {
    prefix: 'fal',
    iconName: 'clipboard-list',
    icon: [384, 512, [], "f46d", "M112 128H272C281 128 288 121 288 112S281 96 272 96H247C253 87 256 76 256 64C256 29 227 0 192 0S128 29 128 64C128 76 131 87 137 96H112C103 96 96 103 96 112S103 128 112 128ZM192 32C210 32 224 46 224 64S210 96 192 96S160 82 160 64S174 32 192 32ZM320 64C311 64 304 71 304 80S311 96 320 96C338 96 352 110 352 128V448C352 466 338 480 320 480H64C46 480 32 466 32 448V128C32 110 46 96 64 96C73 96 80 89 80 80S73 64 64 64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM72 256C72 269 83 280 96 280C109 280 120 269 120 256C120 243 109 232 96 232C83 232 72 243 72 256ZM96 328C83 328 72 339 72 352C72 365 83 376 96 376C109 376 120 365 120 352C120 339 109 328 96 328ZM304 240H176C167 240 160 247 160 256S167 272 176 272H304C313 272 320 265 320 256S313 240 304 240ZM304 336H176C167 336 160 343 160 352S167 368 176 368H304C313 368 320 361 320 352S313 336 304 336Z"]
  };
  var faClipboardListCheck = {
    prefix: 'fal',
    iconName: 'clipboard-list-check',
    icon: [384, 512, [], "f737", "M304 336H176C167 336 160 343 160 352S167 368 176 368H304C313 368 320 361 320 352S313 336 304 336ZM304 240H208C199 240 192 247 192 256S199 272 208 272H304C313 272 320 265 320 256S313 240 304 240ZM96 328C83 328 72 339 72 352C72 365 83 376 96 376C109 376 120 365 120 352C120 339 109 328 96 328ZM320 64C311 64 304 71 304 80S311 96 320 96C338 96 352 110 352 128V448C352 466 338 480 320 480H64C46 480 32 466 32 448V128C32 110 46 96 64 96C73 96 80 89 80 80S73 64 64 64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM112 128H272C281 128 288 121 288 112S281 96 272 96H247C253 87 256 76 256 64C256 29 227 0 192 0S128 29 128 64C128 76 131 87 137 96H112C103 96 96 103 96 112S103 128 112 128ZM192 32C210 32 224 46 224 64S210 96 192 96S160 82 160 64S174 32 192 32ZM68 229C62 236 63 246 69 252L104 284C107 287 111 288 115 288C119 288 123 286 126 283L188 219C194 213 193 203 187 196C181 190 171 191 164 197L114 250L91 228C84 222 74 223 68 229Z"]
  };
  var faClipboardMedical = {
    prefix: 'fal',
    iconName: 'clipboard-medical',
    icon: [384, 512, [], "e100", "M112 128H272C281 128 288 121 288 112S281 96 272 96H247C253 87 256 76 256 64C256 29 227 0 192 0S128 29 128 64C128 76 131 87 137 96H112C103 96 96 103 96 112S103 128 112 128ZM192 32C210 32 224 46 224 64S210 96 192 96S160 82 160 64S174 32 192 32ZM320 64C311 64 304 71 304 80S311 96 320 96C338 96 352 110 352 128V448C352 466 338 480 320 480H64C46 480 32 466 32 448V128C32 110 46 96 64 96C73 96 80 89 80 80S73 64 64 64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM112 336H160V384C160 393 167 400 176 400H208C217 400 224 393 224 384V336H272C281 336 288 329 288 320V288C288 279 281 272 272 272H224V224C224 215 217 208 208 208H176C167 208 160 215 160 224V272H112C103 272 96 279 96 288V320C96 329 103 336 112 336Z"]
  };
  var faClipboardPrescription = {
    prefix: 'fal',
    iconName: 'clipboard-prescription',
    icon: [384, 512, [], "f5e8", "M112 128H272C281 128 288 121 288 112S281 96 272 96H247C253 87 256 76 256 64C256 29 227 0 192 0S128 29 128 64C128 76 131 87 137 96H112C103 96 96 103 96 112S103 128 112 128ZM192 32C210 32 224 46 224 64S210 96 192 96S160 82 160 64S174 32 192 32ZM320 64C311 64 304 71 304 80S311 96 320 96C338 96 352 110 352 128V448C352 466 338 480 320 480H64C46 480 32 466 32 448V128C32 110 46 96 64 96C73 96 80 89 80 80S73 64 64 64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM80 352C80 361 87 368 96 368S112 361 112 352V304H153L217 368L181 405C174 411 174 421 181 427C184 430 188 432 192 432S200 430 203 427L240 391L277 427C280 430 284 432 288 432S296 430 299 427C306 421 306 411 299 405L263 368L299 331C306 325 306 315 299 309S283 302 277 309L240 345L195 301C221 292 240 269 240 240C240 205 211 176 176 176H96C87 176 80 183 80 192V352ZM112 208H176C194 208 208 222 208 240S194 272 176 272H112V208Z"]
  };
  var faClipboardUser = {
    prefix: 'fal',
    iconName: 'clipboard-user',
    icon: [384, 512, [], "f7f3", "M320 64C311 64 304 71 304 80S311 96 320 96C338 96 352 110 352 128V448C352 466 338 480 320 480H64C46 480 32 466 32 448V128C32 110 46 96 64 96C73 96 80 89 80 80S73 64 64 64C29 64 0 93 0 128V448C0 483 29 512 64 512H320C355 512 384 483 384 448V128C384 93 355 64 320 64ZM112 128H272C281 128 288 121 288 112S281 96 272 96H247C253 87 256 76 256 64C256 29 227 0 192 0S128 29 128 64C128 76 131 87 137 96H112C103 96 96 103 96 112S103 128 112 128ZM192 32C210 32 224 46 224 64S210 96 192 96S160 82 160 64S174 32 192 32ZM80 416C80 425 87 432 96 432S112 425 112 416C112 390 134 368 160 368H224C250 368 272 390 272 416C272 425 279 432 288 432S304 425 304 416C304 372 268 336 224 336H160C116 336 80 372 80 416ZM256 240C256 205 227 176 192 176S128 205 128 240S157 304 192 304S256 275 256 240ZM160 240C160 222 174 208 192 208S224 222 224 240S210 272 192 272S160 258 160 240Z"]
  };
  var faClock = {
    prefix: 'fal',
    iconName: 'clock',
    icon: [512, 512, [], "f017", "M256 16C123 16 16 123 16 256C16 389 123 496 256 496S496 389 496 256C496 123 389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM272 249V128C272 119 265 112 256 112S240 119 240 128V256C240 260 242 264 245 267L325 347C328 350 332 352 336 352S344 350 347 347C354 341 354 331 347 325L272 249Z"]
  };
  var faClockDesk = {
    prefix: 'fal',
    iconName: 'clock-desk',
    icon: [448, 512, [], "e101", "M224 0C100 0 0 100 0 224V432C0 476 36 512 80 512H368C412 512 448 476 448 432V224C448 100 348 0 224 0ZM416 432C416 458 394 480 368 480H80C54 480 32 458 32 432V339C71 404 142 448 224 448S377 404 416 339V432ZM224 416C118 416 32 330 32 224S118 32 224 32S416 118 416 224S330 416 224 416ZM240 232V112C240 103 233 96 224 96S208 103 208 112V240C208 245 210 250 214 253L278 301C281 303 285 304 288 304C293 304 298 302 301 298C306 291 305 281 298 275L240 232Z"]
  };
  var faClockRotateLeft = {
    prefix: 'fal',
    iconName: 'clock-rotate-left',
    icon: [512, 512, [], "f1da", "M256 32C177 32 104 74 64 142V48C64 39 57 32 48 32S32 39 32 48V176C32 185 39 192 48 192H176C185 192 192 185 192 176S185 160 176 160H90C125 101 187 64 256 64C362 64 448 150 448 256S362 448 256 448C197 448 141 421 105 374C99 367 89 366 82 371C75 377 74 387 79 394C122 449 187 480 256 480C380 480 480 379 480 256S380 32 256 32ZM256 128C247 128 240 135 240 144V272C240 277 242 282 246 285L310 333C313 335 317 336 320 336C325 336 330 334 333 330C338 323 337 313 330 307L272 264V144C272 135 265 128 256 128Z"]
  };
  var faClone = {
    prefix: 'fal',
    iconName: 'clone',
    icon: [512, 512, [], "f24d", "M336 384C327 384 320 391 320 400V448C320 466 306 480 288 480H64C46 480 32 466 32 448V224C32 206 46 192 64 192H112C121 192 128 185 128 176C128 167 121 160 112 160H64C29 160 0 189 0 224V448C0 483 29 512 64 512H288C323 512 352 483 352 448V400C352 391 345 384 336 384ZM448 0H224C189 0 160 29 160 64V288C160 323 189 352 224 352H448C483 352 512 323 512 288V64C512 29 483 0 448 0ZM480 288C480 306 466 320 448 320H224C206 320 192 306 192 288V64C192 46 206 32 224 32H448C466 32 480 46 480 64V288Z"]
  };
  var faClosedCaptioning = {
    prefix: 'fal',
    iconName: 'closed-captioning',
    icon: [576, 512, [], "f20a", "M249 211C255 217 265 217 272 211S278 194 272 188C235 152 172 152 136 188C98 226 98 286 136 324C154 342 178 352 204 352S253 342 272 324C278 318 278 307 272 301S255 295 249 301C225 325 183 325 158 301C133 276 133 236 158 211C183 187 225 187 249 211ZM441 211C447 217 457 217 464 211S470 194 464 188C427 152 364 152 328 188C290 226 290 286 328 324C346 342 370 352 396 352C421 352 445 342 464 324C470 318 470 307 464 301S447 295 441 301C417 325 375 325 350 301C325 276 325 236 350 211C375 187 417 187 441 211ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H512C530 64 544 78 544 96V416Z"]
  };
  var faCloud = {
    prefix: 'fal',
    iconName: 'cloud',
    icon: [640, 512, [], "f0c2", "M572 239C574 229 576 219 576 208C576 146 526 96 464 96C447 96 431 100 416 107C384 62 332 32 272 32C178 32 100 106 96 200C39 220 0 274 0 336C0 416 64 480 144 480H512C583 480 640 423 640 352C640 305 614 261 572 239ZM508 448H149C91 448 39 406 33 348C27 291 63 242 114 228C123 226 128 218 128 209C128 209 128 208 128 208C128 147 165 91 223 72C294 48 362 79 395 133C401 143 413 145 423 139C440 129 461 125 483 130C510 136 533 157 540 184C546 203 545 222 538 239C534 249 540 260 550 264C587 280 612 319 607 363C602 412 557 448 508 448Z"]
  };
  var faCloudArrowDown = {
    prefix: 'fal',
    iconName: 'cloud-arrow-down',
    icon: [640, 512, [], "f0ed", "M572 239C574 229 576 219 576 208C576 146 526 96 464 96C447 96 431 100 416 107C384 62 332 32 272 32C178 32 100 106 96 200C39 220 0 274 0 336C0 416 64 480 144 480H512C583 480 640 423 640 352C640 305 614 261 572 239ZM508 448H149C91 448 39 406 33 348C27 291 63 242 114 228C123 226 128 218 128 209C128 209 128 208 128 208C128 147 165 91 223 72C294 48 362 79 395 133C401 143 413 145 423 139C440 129 461 125 483 130C510 136 533 157 540 184C546 203 545 222 538 239C534 249 540 260 550 264C587 280 612 319 607 363C602 412 557 448 508 448ZM389 293L336 345V176C336 167 329 160 320 160S304 167 304 176V345L251 293C245 286 235 286 229 293S222 309 229 315L309 395C312 398 316 400 320 400S328 398 331 395L411 315C418 309 418 299 411 293S395 286 389 293Z"]
  };
  var faCloudArrowUp = {
    prefix: 'fal',
    iconName: 'cloud-arrow-up',
    icon: [640, 512, [], "f0ee", "M572 239C574 229 576 219 576 208C576 146 526 96 464 96C447 96 431 100 416 107C384 62 332 32 272 32C178 32 100 106 96 200C39 220 0 274 0 336C0 416 64 480 144 480H512C583 480 640 423 640 352C640 305 614 261 572 239ZM508 448H149C91 448 39 406 33 348C27 291 63 242 114 228C123 226 128 218 128 209C128 209 128 208 128 208C128 147 165 91 223 72C294 48 362 79 395 133C401 143 413 145 423 139C440 129 461 125 483 130C510 136 533 157 540 184C546 203 545 222 538 239C534 249 540 260 550 264C587 280 612 319 607 363C602 412 557 448 508 448ZM251 267L304 215V384C304 393 311 400 320 400S336 393 336 384V215L389 267C395 274 405 274 411 267S418 251 411 245L331 165C328 162 324 160 320 160S312 162 309 165L229 245C222 251 222 261 229 267S245 274 251 267Z"]
  };
  var faCloudBolt = {
    prefix: 'fal',
    iconName: 'cloud-bolt',
    icon: [512, 512, [], "f76c", "M416 112C412 67 374 32 328 32C310 32 293 37 279 47C245 3 184 -15 128 14C88 34 64 76 64 120V120C20 139 -7 185 2 234C11 285 57 320 108 320H128C137 320 144 313 144 304C144 295 137 288 128 288H106C75 288 46 269 36 240C22 199 46 157 85 147L99 143L97 126C96 124 96 122 96 120C96 71 135 32 184 32C216 32 246 50 261 79L272 99L287 82C302 66 323 60 345 66C366 73 381 93 384 115C384 121 384 120 383 127L381 147L404 145C405 144 407 144 408 144C448 144 480 176 480 216C480 254 450 285 413 288L352 288C343 288 336 295 336 304C336 313 343 320 352 320H404C460 320 509 278 512 222C515 165 471 116 416 112ZM304 336H207L291 217C297 210 295 200 288 195C281 190 271 192 265 199L163 343C160 348 159 354 162 359C165 365 170 368 176 368H273L189 487C183 494 185 504 192 509C195 511 198 512 202 512C207 512 212 510 215 505L317 361C320 356 321 350 318 345C315 339 310 336 304 336Z"]
  };
  var faCloudBoltMoon = {
    prefix: 'fal',
    iconName: 'cloud-bolt-moon',
    icon: [576, 512, [], "f76d", "M571 261C524 318 462 320 444 320C447 310 448 299 448 288V288C478 287 506 277 528 259C457 257 400 200 400 129C400 92 417 56 444 32C391 33 346 65 327 111C318 106 308 102 298 100C322 41 379 0 446 0C456 0 466 1 475 3C485 5 492 11 493 21C495 30 491 39 482 44C451 61 432 94 432 129C432 183 477 227 531 227C544 227 549 225 554 225C562 225 570 230 574 238S576 254 571 261ZM272 320H175L237 233C242 226 240 216 233 211C226 206 216 208 211 215L131 327C127 332 127 338 130 343C133 349 138 352 144 352H241L147 487C142 494 144 504 151 509C154 511 157 512 160 512C165 512 170 510 173 505L285 345C289 340 289 334 286 329C283 323 278 320 272 320ZM351 197C346 158 313 128 272 128C263 128 255 129 247 132C227 109 199 96 168 96C111 96 65 141 64 198C26 211 0 247 0 288C0 341 43 384 96 384C105 384 112 377 112 368C112 360 106 354 98 352L98 352C66 352 37 329 33 296C28 262 51 232 84 225L84 225C92 224 98 216 97 208C96 203 97 206 96 198C97 159 129 128 168 128C192 128 215 140 228 161L229 161C233 168 242 170 249 166L249 166C282 148 320 174 320 207L320 210C320 217 325 224 333 225C363 231 384 258 384 288C384 323 355 352 320 352C311 352 304 359 304 368C304 377 311 384 320 384C373 384 416 341 416 288C416 247 389 210 351 197Z"]
  };
  var faCloudBoltSun = {
    prefix: 'fal',
    iconName: 'cloud-bolt-sun',
    icon: [640, 512, [], "f76e", "M192 140C218 140 240 160 243 186C248 182 253 179 258 176C260 167 262 159 265 151C251 126 223 108 192 108C146 108 108 146 108 192C108 238 146 276 192 276C192 276 193 275 193 275C194 264 197 253 201 243C198 243 195 244 192 244C164 244 140 220 140 192C140 163 163 140 192 140ZM160 292C157 286 150 284 144 285L88 296L99 240C100 234 98 227 92 224L45 192L92 160C98 156 100 150 99 144L88 88L144 99C150 100 157 97 160 92L192 44L224 92C227 97 234 100 240 99L320 83C328 81 334 73 332 64C330 56 322 50 313 52L245 65L205 7C199 -2 185 -2 179 7L140 65L71 51C65 50 60 52 56 56C52 60 51 65 52 70L66 139L7 178C3 182 0 186 0 192S3 202 7 205L66 244L52 313C51 318 52 324 56 328C60 331 65 333 71 332L139 318L179 377C182 382 187 384 192 384C195 384 198 383 201 381C208 376 210 366 205 359L160 292ZM575 197C570 158 537 128 496 128C487 128 479 129 471 132C451 109 423 96 392 96C335 96 289 141 288 198C250 211 224 247 224 288C224 341 267 384 320 384C329 384 336 377 336 368C336 360 330 354 322 352L322 352C290 352 261 329 257 296C252 262 275 232 308 225L308 225C316 224 322 216 321 208C320 203 321 206 320 198C321 159 353 128 392 128C416 128 439 140 452 161L453 161C457 168 466 170 473 166L473 166C506 148 544 174 544 206L544 210C544 217 549 224 557 225C587 231 608 258 608 288C608 323 579 352 544 352C535 352 528 359 528 368C528 377 535 384 544 384C597 384 640 341 640 288C640 247 613 210 575 197ZM496 320H399L461 233C466 226 464 216 457 211C450 206 440 208 435 215L355 327C352 332 351 338 354 343C357 349 362 352 368 352H465L371 487C366 494 368 504 375 509C378 511 381 512 384 512C389 512 394 510 397 505L509 345C513 340 513 334 510 329C507 323 502 320 496 320Z"]
  };
  var faCloudDrizzle = {
    prefix: 'fal',
    iconName: 'cloud-drizzle',
    icon: [512, 512, [], "f738", "M48 360C39 360 32 367 32 376V416C32 425 39 432 48 432S64 425 64 416V376C64 367 57 360 48 360ZM240 360C231 360 224 367 224 376V416C224 425 231 432 240 432S256 425 256 416V376C256 367 249 360 240 360ZM144 440C135 440 128 447 128 456V496C128 505 135 512 144 512S160 505 160 496V456C160 447 153 440 144 440ZM432 360C423 360 416 367 416 376V416C416 425 423 432 432 432S448 425 448 416V376C448 367 441 360 432 360ZM336 440C327 440 320 447 320 456V496C320 505 327 512 336 512S352 505 352 496V456C352 447 345 440 336 440ZM415 112C407 67 368 32 320 32C301 32 283 37 267 48C247 18 213 0 176 0C114 0 64 50 64 112C64 115 64 117 64 120C26 136 0 174 0 216C0 273 47 320 104 320H408C465 320 512 273 512 216C512 161 469 116 415 112ZM408 288H104C64 288 32 256 32 216C32 183 54 155 86 147C94 144 99 136 98 128C97 123 96 117 96 112C96 68 132 32 176 32C207 32 235 50 248 79C251 83 255 87 260 88C265 89 271 87 274 83C287 71 303 64 320 64C355 64 384 93 384 128C384 137 391 144 400 144H408C448 144 480 176 480 216S448 288 408 288Z"]
  };
  var faCloudFog = {
    prefix: 'fal',
    iconName: 'cloud-fog',
    icon: [640, 512, [], "f74e", "M168 320H472C529 320 576 273 576 216C576 161 533 116 480 112C476 67 438 32 392 32C374 32 357 37 343 47C320 18 286 0 248 0C182 0 128 54 128 120V120C90 136 64 174 64 216C64 273 111 320 168 320ZM149 147L149 147C157 145 162 137 161 130C160 124 160 123 160 120C160 71 199 32 248 32C280 32 310 50 325 79L325 79C330 88 344 90 351 82C364 68 382 62 400 65C426 68 445 90 448 115C448 121 448 120 447 127L447 127C446 137 454 146 465 145C470 144 470 144 472 144C512 144 544 176 544 216C544 256 512 288 472 288H168C128 288 96 256 96 216C96 184 118 155 149 147ZM208 480H80C71 480 64 487 64 496S71 512 80 512H208C217 512 224 505 224 496S217 480 208 480ZM624 480H304C295 480 288 487 288 496S295 512 304 512H624C633 512 640 505 640 496S633 480 624 480ZM576 400C576 391 569 384 560 384H16C7 384 0 391 0 400S7 416 16 416H560C569 416 576 409 576 400Z"]
  };
  var faCloudHail = {
    prefix: 'fal',
    iconName: 'cloud-hail',
    icon: [512, 512, [], "f739", "M56 464C43 464 32 475 32 488S43 512 56 512S80 501 80 488S69 464 56 464ZM184 464C171 464 160 475 160 488S171 512 184 512S208 501 208 488S197 464 184 464ZM248 368C235 368 224 379 224 392S235 416 248 416S272 405 272 392S261 368 248 368ZM120 368C107 368 96 379 96 392S107 416 120 416S144 405 144 392S133 368 120 368ZM376 368C363 368 352 379 352 392S363 416 376 416S400 405 400 392S389 368 376 368ZM312 464C299 464 288 475 288 488S299 512 312 512S336 501 336 488S325 464 312 464ZM415 112C407 67 368 32 320 32C301 32 283 37 267 48C247 18 213 0 176 0C114 0 64 50 64 112C64 115 64 117 64 120C26 136 0 174 0 216C0 273 47 320 104 320H408C465 320 512 273 512 216C512 161 469 116 415 112ZM408 288H104C64 288 32 256 32 216C32 183 54 155 86 147C94 144 99 136 98 128C97 123 96 117 96 112C96 68 132 32 176 32C207 32 235 50 248 79C251 83 255 87 260 88C265 89 271 87 274 83C287 71 303 64 320 64C355 64 384 93 384 128C384 137 391 144 400 144H408C448 144 480 176 480 216S448 288 408 288Z"]
  };
  var faCloudHailMixed = {
    prefix: 'fal',
    iconName: 'cloud-hail-mixed',
    icon: [512, 512, [], "f73a", "M184 370C176 366 166 368 162 376L98 488C94 496 96 506 104 510C107 511 109 512 112 512C118 512 123 509 126 504L190 392C194 384 192 374 184 370ZM279 370C271 366 262 369 258 377L242 409C238 417 241 426 249 430C251 432 254 432 256 432C262 432 268 429 270 423L286 391C290 383 287 374 279 370ZM216 464C203 464 192 475 192 488S203 512 216 512S240 501 240 488S229 464 216 464ZM87 370C79 366 70 369 66 377L50 409C46 417 49 426 57 430C59 432 62 432 64 432C70 432 76 429 78 423L94 391C98 383 95 374 87 370ZM24 464C11 464 0 475 0 488S11 512 24 512S48 501 48 488S37 464 24 464ZM471 370C463 366 454 369 450 377L434 409C430 417 433 426 441 430C443 432 446 432 448 432C454 432 460 429 462 423L478 391C482 383 479 374 471 370ZM376 370C368 366 358 368 354 376L290 488C286 496 288 506 296 510C299 511 301 512 304 512C310 512 315 509 318 504L382 392C386 384 384 374 376 370ZM408 464C395 464 384 475 384 488S395 512 408 512S432 501 432 488S421 464 408 464ZM415 112C407 67 368 32 320 32C301 32 283 37 267 48C247 18 213 0 176 0C114 0 64 50 64 112C64 115 64 117 64 120C26 136 0 174 0 216C0 273 47 320 104 320H408C465 320 512 273 512 216C512 161 469 116 415 112ZM408 288H104C64 288 32 256 32 216C32 183 54 155 86 147C94 144 99 136 98 128C97 123 96 117 96 112C96 68 132 32 176 32C207 32 235 50 248 79C251 83 255 87 260 88C265 89 271 87 274 83C287 71 303 64 320 64C355 64 384 93 384 128C384 137 391 144 400 144H408C448 144 480 176 480 216S448 288 408 288Z"]
  };
  var faCloudMeatball = {
    prefix: 'fal',
    iconName: 'cloud-meatball',
    icon: [576, 512, [], "f73b", "M80 352C54 352 32 374 32 400S54 448 80 448S128 426 128 400S106 352 80 352ZM80 416C71 416 64 409 64 400S71 384 80 384S96 391 96 400S89 416 80 416ZM378 294C366 281 349 276 332 277C310 251 266 251 244 277C227 276 210 281 198 294S180 323 181 340C168 351 160 367 160 384S168 417 181 428C179 445 185 462 198 474S228 494 244 491C255 504 271 512 288 512S321 504 332 491C348 494 366 487 378 474S396 445 395 428C408 417 416 401 416 384S408 351 395 340C397 323 391 306 378 294ZM370 407L358 413L362 426C365 435 363 445 356 452C351 457 345 459 338 459C336 459 333 459 330 458L317 454L311 466C302 483 275 483 265 466L259 454L246 458C243 459 241 460 239 460C232 460 225 457 220 452C214 445 211 435 214 426L218 413L207 407C198 402 192 393 192 384S198 366 206 361L218 355L214 342C211 333 214 323 220 316C227 309 237 307 246 310L259 314L265 302C275 285 302 285 311 302L317 314L330 310C339 307 349 309 356 316C363 323 365 333 362 342L358 355L370 361C378 366 384 375 384 384S378 402 370 407ZM544 216C544 161 501 116 448 112C444 67 406 32 360 32C342 32 325 37 311 47C288 18 254 0 216 0C150 0 96 54 96 120V120C52 139 25 185 34 234C42 284 88 320 139 320C139 320 142 320 144 320C153 320 160 313 160 304C160 295 153 288 144 288C142 288 138 288 138 288C105 288 75 267 66 235C56 195 80 157 117 147C125 145 130 137 129 130C129 127 128 120 128 115C131 69 169 32 216 32C248 32 278 50 293 79L293 79C298 88 312 90 319 82C332 68 350 62 368 65C394 68 413 90 416 115C416 121 416 120 415 127C414 137 423 146 433 145C438 144 438 144 439 144C468 144 495 160 506 186C527 238 489 288 440 288C440 288 435 288 432 288C423 288 416 295 416 304C416 313 423 320 432 320C435 320 440 320 440 320C497 320 544 273 544 216ZM496 352C470 352 448 374 448 400S470 448 496 448S544 426 544 400S522 352 496 352ZM496 416C487 416 480 409 480 400S487 384 496 384S512 391 512 400S505 416 496 416Z"]
  };
  var faCloudMoon = {
    prefix: 'fal',
    iconName: 'cloud-moon',
    icon: [576, 512, [], "f6c3", "M352 314C347 272 312 240 269 240C256 240 242 243 230 250C212 234 188 224 163 224C109 224 66 267 64 320C26 334 0 371 0 413C0 467 45 512 99 512H349C404 512 448 467 448 413C448 359 405 315 352 314ZM349 480L102 480C65 480 34 452 32 416C31 383 53 354 84 347C93 344 98 335 96 327C96 326 96 324 96 323C96 286 126 256 163 256C183 256 202 265 215 281L215 281C221 288 231 289 238 284L238 283C253 271 273 268 292 277C308 285 318 301 320 319C320 323 320 323 319 329C319 333 321 350 339 347C343 346 347 345 350 346C387 346 416 376 416 413C416 450 386 480 349 480ZM574 287C569 279 561 273 552 273C550 273 549 273 547 274C539 275 532 276 524 276C457 276 402 221 402 154C402 110 426 70 464 48C473 43 478 33 476 23S467 5 456 3C445 1 433 0 421 0C316 0 230 86 230 192C230 198 230 205 231 211C233 212 234 212 236 213C245 210 254 209 263 208C262 203 262 198 262 192C262 104 333 32 421 32C424 32 427 32 430 32C393 61 370 106 370 154C370 239 439 308 524 308C527 308 529 308 532 308C512 327 488 339 462 346C467 355 471 366 474 376C512 366 545 344 570 313C576 306 578 296 574 287Z"]
  };
  var faCloudMoonRain = {
    prefix: 'fal',
    iconName: 'cloud-moon-rain',
    icon: [576, 512, [], "f73c", "M266 418C259 414 249 416 244 424L208 488C203 496 206 506 214 510C216 511 219 512 222 512C227 512 233 509 236 504L272 440C277 432 274 422 266 418ZM170 418C163 414 153 416 148 424L112 488C107 496 110 506 118 510C120 511 123 512 126 512C131 512 137 509 140 504L176 440C181 432 178 422 170 418ZM74 418C67 414 57 416 52 424L16 488C11 496 14 506 22 510C24 511 27 512 30 512C35 512 41 509 44 504L80 440C85 432 82 422 74 418ZM351 197C346 158 313 128 272 128C263 128 255 129 247 132C227 109 199 96 168 96C111 96 65 141 64 198C26 211 0 247 0 288C0 341 43 384 96 384H320C373 384 416 341 416 288C416 287 416 285 416 284C414 244 388 210 351 197ZM320 352H98C66 352 37 329 33 296C28 262 51 231 84 225L84 225C92 224 98 216 97 208C96 200 96 202 96 199C96 177 105 155 124 143C162 116 207 128 228 161L229 161C233 168 242 170 249 166L249 166C282 148 320 174 320 207L320 210C320 217 325 224 333 225C363 231 384 258 384 288C384 323 355 352 320 352ZM362 418C355 414 345 416 340 424L304 488C299 496 302 506 310 510C312 511 315 512 318 512C323 512 329 509 332 504L368 440C373 432 370 422 362 418ZM574 238C570 230 562 225 554 225C549 225 544 227 531 227C477 227 432 183 432 129C432 94 451 61 482 44C491 39 495 30 493 21C492 11 485 4 475 3C466 1 456 0 446 0C379 0 322 41 298 99C309 102 318 106 327 111C346 65 391 33 444 32C417 56 400 92 400 129C400 199 457 257 528 259C506 277 478 287 448 288V288C448 299 447 310 444 320C462 320 524 318 571 261C576 254 578 245 574 238Z"]
  };
  var faCloudMusic = {
    prefix: 'fal',
    iconName: 'cloud-music',
    icon: [640, 512, [], "f8ae", "M402 189C394 183 383 181 373 185L277 221C264 226 256 238 256 251V325C249 322 241 320 232 320C201 320 176 342 176 368S201 416 232 416S288 394 288 368V251L384 215V293C377 290 369 288 360 288C329 288 304 310 304 336S329 384 360 384S416 362 416 336V215C416 205 411 195 402 189ZM232 384C219 384 208 377 208 368S219 352 232 352S256 359 256 368S245 384 232 384ZM360 352C347 352 336 345 336 336S347 320 360 320S384 327 384 336S373 352 360 352ZM572 239C574 229 576 219 576 208C576 146 526 96 464 96C447 96 431 100 416 107C384 62 332 32 272 32C178 32 100 106 96 200C39 220 0 274 0 336C0 416 64 480 144 480H512C583 480 640 423 640 352C640 305 614 261 572 239ZM508 448H149C91 448 39 406 33 348C27 291 63 242 114 228C123 226 128 218 128 209C128 209 128 208 128 208C128 147 165 91 223 72C294 48 362 79 395 133C401 143 413 145 423 139C440 129 461 125 483 130C510 136 533 157 540 184C546 203 545 222 538 239C534 249 540 260 550 264C587 280 612 319 607 363C602 412 557 448 508 448Z"]
  };
  var faCloudRain = {
    prefix: 'fal',
    iconName: 'cloud-rain',
    icon: [512, 512, [], "f73d", "M118 369C116 359 107 352 96 352C85 353 77 359 74 369C69 385 62 396 55 406C46 419 37 432 37 451C37 485 64 512 96 512S155 485 155 451C155 432 146 419 137 406C130 396 123 386 118 369ZM96 480C81 480 69 467 69 451C69 442 73 436 81 424C86 417 91 409 96 400C101 409 106 417 111 424C118 436 123 442 123 451C123 467 111 480 96 480ZM278 369C276 359 267 352 256 352H256C246 352 237 359 234 369C229 385 222 396 215 406C206 419 197 432 197 451C197 485 224 512 256 512S315 485 315 451C315 432 306 419 297 406C290 396 283 386 278 369ZM256 480C241 480 229 467 229 451C229 442 233 436 241 424C246 417 251 409 256 400C261 409 266 417 271 424C278 436 283 442 283 451C283 467 271 480 256 480ZM438 369C436 359 427 352 416 352C406 353 397 359 394 369C389 385 382 396 375 406C366 419 357 432 357 451C357 485 384 512 416 512S475 485 475 451C475 432 466 419 457 406C450 396 443 386 438 369ZM416 480C401 480 389 467 389 451C389 442 393 436 401 424C406 417 411 409 416 400C421 409 426 417 431 424C438 436 443 442 443 451C443 467 431 480 416 480ZM415 112C407 67 368 32 320 32C301 32 283 37 267 48C247 18 213 0 176 0C114 0 64 50 64 112C64 115 64 117 64 120C26 136 0 174 0 216C0 273 47 320 104 320H408C465 320 512 273 512 216C512 161 469 116 415 112ZM408 288H104C64 288 32 256 32 216C32 183 54 155 86 147C94 144 99 136 98 128C97 123 96 117 96 112C96 68 132 32 176 32C207 32 235 50 248 79C251 83 255 87 260 88C265 89 271 87 274 83C287 71 303 64 320 64C355 64 384 93 384 128C384 137 391 144 400 144H408C448 144 480 176 480 216S448 288 408 288Z"]
  };
  var faCloudRainbow = {
    prefix: 'fal',
    iconName: 'cloud-rainbow',
    icon: [576, 512, [], "f73e", "M415 304C407 259 368 224 320 224C301 224 283 229 267 240C247 210 213 192 176 192C114 192 64 242 64 304C64 307 64 309 64 312C26 328 0 366 0 408C0 465 47 512 104 512H408C465 512 512 465 512 408C512 353 469 308 415 304ZM408 480H104C64 480 32 448 32 408C32 375 54 347 86 339C94 336 99 328 98 320C97 315 96 309 96 304C96 260 132 224 176 224C207 224 235 242 248 271C251 275 255 279 260 280C265 281 271 279 274 275C287 263 303 256 320 256C355 256 384 285 384 320C384 329 391 336 400 336H408C448 336 480 368 480 408S448 480 408 480ZM256 172C261 172 265 170 268 166C341 81 448 32 560 32C569 32 576 25 576 16S569 0 560 0C438 0 323 53 244 146C238 152 239 162 246 168C249 171 252 172 256 172ZM560 96C480 96 403 126 344 180C337 186 337 196 343 203C346 206 350 208 354 208C358 208 362 207 365 204C419 155 488 128 560 128C569 128 576 121 576 112S569 96 560 96ZM560 192C517 192 475 204 439 227C432 232 430 242 435 249C438 254 443 257 448 257C451 257 454 256 457 254C487 234 523 224 560 224C569 224 576 217 576 208S569 192 560 192Z"]
  };
  var faCloudShowers = {
    prefix: 'fal',
    iconName: 'cloud-showers',
    icon: [512, 512, [], "f73f", "M48 368C39 368 32 375 32 384V464C32 473 39 480 48 480S64 473 64 464V384C64 375 57 368 48 368ZM240 368C231 368 224 375 224 384V464C224 473 231 480 240 480S256 473 256 464V384C256 375 249 368 240 368ZM144 400C135 400 128 407 128 416V496C128 505 135 512 144 512S160 505 160 496V416C160 407 153 400 144 400ZM336 400C327 400 320 407 320 416V496C320 505 327 512 336 512S352 505 352 496V416C352 407 345 400 336 400ZM432 368C423 368 416 375 416 384V464C416 473 423 480 432 480S448 473 448 464V384C448 375 441 368 432 368ZM415 112C407 67 368 32 320 32C301 32 283 37 267 48C247 18 213 0 176 0C114 0 64 50 64 112C64 115 64 117 64 120C26 136 0 174 0 216C0 273 47 320 104 320H408C465 320 512 273 512 216C512 161 469 116 415 112ZM408 288H104C64 288 32 256 32 216C32 183 54 155 86 147C94 144 99 136 98 128C97 123 96 117 96 112C96 68 132 32 176 32C207 32 235 50 248 79C251 83 255 87 260 88C265 89 271 87 274 83C287 71 303 64 320 64C355 64 384 93 384 128C384 137 391 144 400 144H408C448 144 480 176 480 216S448 288 408 288Z"]
  };
  var faCloudShowersHeavy = {
    prefix: 'fal',
    iconName: 'cloud-showers-heavy',
    icon: [512, 512, [], "f740", "M280 370C272 366 263 368 258 376L194 488C190 496 192 506 200 510C203 511 205 512 208 512C214 512 219 509 222 504L286 392C290 384 288 374 280 370ZM184 370C176 366 167 368 162 376L98 488C94 496 96 506 104 510C107 511 109 512 112 512C118 512 123 509 126 504L190 392C194 384 192 374 184 370ZM472 370C464 366 455 368 450 376L386 488C382 496 384 506 392 510C395 511 397 512 400 512C406 512 411 509 414 504L478 392C482 384 480 374 472 370ZM376 370C368 366 359 368 354 376L290 488C286 496 288 506 296 510C299 511 301 512 304 512C310 512 315 509 318 504L382 392C386 384 384 374 376 370ZM88 370C80 366 71 368 66 376L2 488C-2 496 0 506 8 510C11 511 13 512 16 512C22 512 27 509 30 504L94 392C98 384 96 374 88 370ZM415 112C407 67 368 32 320 32C301 32 283 37 267 48C247 18 213 0 176 0C114 0 64 50 64 112C64 115 64 117 64 120C26 136 0 174 0 216C0 273 47 320 104 320H408C465 320 512 273 512 216C512 161 469 116 415 112ZM408 288H104C64 288 32 256 32 216C32 183 54 155 86 147C94 144 99 136 98 128C97 123 96 117 96 112C96 68 132 32 176 32C207 32 235 50 248 79C251 83 255 87 260 88C265 89 271 87 274 83C287 71 303 64 320 64C355 64 384 93 384 128C384 137 391 144 400 144H408C448 144 480 176 480 216S448 288 408 288Z"]
  };
  var faCloudSleet = {
    prefix: 'fal',
    iconName: 'cloud-sleet',
    icon: [512, 512, [], "f741", "M512 216C512 161 469 116 415 112C407 67 368 32 320 32C301 32 283 37 267 48C247 18 213 0 176 0C114 0 64 50 64 112C64 115 64 117 64 120C26 136 0 174 0 216C0 273 47 320 104 320H408C465 320 512 273 512 216ZM32 216C32 183 54 155 86 147C94 144 99 136 98 128C97 123 96 117 96 112C96 68 132 32 176 32C207 32 235 50 248 79C251 83 255 87 260 88C265 89 271 87 274 83C287 71 303 64 320 64C355 64 384 93 384 128C384 137 391 144 400 144H408C448 144 480 176 480 216S448 288 408 288H104C64 288 32 256 32 216ZM87 354C79 350 70 353 66 361L2 489C-2 497 1 506 9 510C11 511 14 512 16 512C22 512 27 509 30 503L94 375C98 367 95 358 87 354ZM343 354C335 350 326 353 322 361L258 489C254 497 257 506 265 510C267 511 270 512 272 512C278 512 283 509 286 503L350 375C354 367 351 358 343 354ZM487 384C483 376 473 374 466 378L448 388V368C448 359 441 352 432 352S416 359 416 368V388L398 378C391 374 381 376 377 384C372 392 375 401 382 406L400 416L382 426C375 431 372 440 377 448C380 453 385 456 390 456C393 456 396 455 398 454L416 444V464C416 473 423 480 432 480S448 473 448 464V444L466 454C468 455 471 456 474 456C479 456 484 453 487 448C492 440 489 431 482 426L464 416L482 406C489 401 492 392 487 384ZM231 384C227 376 217 374 210 378L192 388V368C192 359 185 352 176 352S160 359 160 368V388L142 378C135 374 125 376 121 384C116 392 119 401 126 406L144 416L126 426C119 431 116 440 121 448C124 453 129 456 134 456C137 456 140 455 142 454L160 444V464C160 473 167 480 176 480S192 473 192 464V444L210 454C212 455 215 456 218 456C223 456 228 453 231 448C236 440 233 431 226 426L208 416L226 406C233 401 236 392 231 384Z"]
  };
  var faCloudSnow = {
    prefix: 'fal',
    iconName: 'cloud-snow',
    icon: [512, 512, [], "f742", "M104 320H408C465 320 512 273 512 216C512 161 469 116 415 112C407 67 368 32 320 32C301 32 283 37 267 48C247 18 213 0 176 0C114 0 64 50 64 112C64 115 64 117 64 120C26 136 0 174 0 216C0 273 47 320 104 320ZM86 147C94 144 99 136 98 128C97 123 96 117 96 112C96 68 132 32 176 32C207 32 235 50 248 79C251 83 255 87 260 88C265 89 271 87 274 83C287 71 303 64 320 64C355 64 384 93 384 128C384 137 391 144 400 144H408C448 144 480 176 480 216S448 288 408 288H104C64 288 32 256 32 216C32 183 54 155 86 147ZM503 384C499 376 489 374 482 378L464 388V368C464 359 457 352 448 352S432 359 432 368V388L414 378C407 374 397 376 393 384C388 392 391 401 398 406L416 416L398 426C391 431 388 440 393 448C396 453 401 456 406 456C409 456 412 455 414 454L432 444V464C432 473 439 480 448 480S464 473 464 464V444L482 454C484 455 487 456 490 456C495 456 500 453 503 448C508 440 505 431 498 426L480 416L498 406C505 401 508 392 503 384ZM119 384C115 376 105 374 98 378L80 388V368C80 359 73 352 64 352S48 359 48 368V388L30 378C23 374 13 376 9 384C4 392 7 401 14 406L32 416L14 426C7 431 4 440 9 448C12 453 17 456 22 456C25 456 28 455 30 454L48 444V464C48 473 55 480 64 480S80 473 80 464V444L98 454C100 455 103 456 106 456C111 456 116 453 119 448C124 440 121 431 114 426L96 416L114 406C121 401 124 392 119 384ZM313 416C309 408 299 406 291 410L274 420V400C274 391 266 384 258 384S242 391 242 400V420L224 410C216 406 207 408 202 416C198 424 200 433 208 438L226 448L208 458C200 463 198 472 202 480C205 485 210 488 216 488C219 488 221 487 224 486L242 476V496C242 505 249 512 258 512S274 505 274 496V476L291 486C294 487 296 488 299 488C305 488 310 485 313 480C317 472 315 463 307 458L290 448L307 438C315 433 317 424 313 416Z"]
  };
  var faCloudSun = {
    prefix: 'fal',
    iconName: 'cloud-sun',
    icon: [640, 512, [], "f6c4", "M93 323L93 323L106 259C106 253 106 246 99 243L45 208L99 173C106 170 106 163 106 157L93 93L157 106C163 106 170 106 173 99L208 45L243 99C246 106 253 109 259 106L323 93L314 141C310 150 317 157 326 160S342 157 346 147L358 77C358 70 358 67 355 64C352 61 346 58 342 61L266 70L224 6C218 -3 205 -3 198 6L154 70L77 58C70 58 67 58 64 61S54 70 58 74L74 150L10 192C3 198 0 202 0 208S3 218 6 221L70 266L54 342C54 349 54 352 58 355C61 358 64 358 70 358C70 358 74 358 74 358L96 355C102 355 109 346 109 339C112 330 102 320 93 323ZM544 304C541 259 502 224 454 224C435 224 419 230 406 240C384 211 349 192 314 192C246 192 192 246 192 314V314C154 330 128 368 128 410C128 464 176 512 230 512H534C592 512 637 464 637 410C640 352 598 307 544 304ZM538 480H234C202 480 170 458 163 426C154 387 176 349 214 336L214 336C221 336 227 330 224 320C224 314 224 314 224 310C224 262 262 224 314 224C346 224 374 243 390 272L390 272C397 282 410 285 416 275C429 262 448 256 464 259C490 259 512 285 512 310C512 314 512 314 512 317L512 317C512 326 518 336 528 336C534 336 534 336 534 336C573 336 605 368 605 406C608 448 576 480 538 480ZM163 285C166 275 170 262 173 253C160 243 150 227 150 208C150 176 176 150 208 150C227 150 243 160 253 173C262 170 275 166 285 163C269 134 240 118 208 118C160 118 118 157 118 208C118 240 138 269 163 285Z "]
  };
  var faCloudSunRain = {
    prefix: 'fal',
    iconName: 'cloud-sun-rain',
    icon: [640, 512, [], "f743", "M298 418C291 414 281 416 276 424L240 488C235 496 238 506 246 510C248 511 251 512 254 512C259 512 265 509 268 504L304 440C309 432 306 422 298 418ZM192 140C218 140 240 160 243 186C248 182 253 179 258 176C260 167 262 159 265 151C251 126 223 108 192 108C146 108 108 146 108 192C108 238 146 276 192 276C192 276 193 275 193 275C194 264 197 253 201 243C198 243 195 244 192 244C164 244 140 220 140 192C140 163 163 140 192 140ZM160 292C157 286 150 284 144 285L88 296L99 240C100 234 98 227 92 224L45 192L92 160C98 156 100 150 99 144L88 88L144 99C150 100 157 97 160 92L192 44L224 92C227 97 234 100 240 99L320 83C328 81 334 73 332 64C330 56 322 50 313 52L245 65L205 7C199 -2 185 -2 179 7L140 65L71 51C65 50 60 52 56 56C52 60 51 65 52 70L66 139L7 178C3 182 0 186 0 192C0 197 3 202 7 205L66 244L52 313C51 318 52 324 56 328C60 331 65 333 71 332L139 318L179 377C182 382 187 384 192 384C195 384 198 383 201 381C208 376 210 366 205 359L160 292ZM490 418C483 414 473 416 468 424L432 488C427 496 430 506 438 510C440 511 443 512 446 512C451 512 457 509 460 504L496 440C501 432 498 422 490 418ZM575 197C570 158 537 128 496 128C487 128 479 129 471 132C451 109 423 96 392 96C335 96 289 141 288 198C250 211 224 247 224 288C224 341 267 384 320 384H544C597 384 640 341 640 288C640 247 613 210 575 197ZM544 352L322 352C290 352 261 329 257 296C252 262 275 231 308 225L308 225C316 224 322 216 321 208C320 203 321 206 320 198C321 159 353 128 392 128C416 128 439 140 452 161L453 161C457 168 466 170 473 166L473 166C506 148 544 174 544 206L544 210C544 217 549 224 557 225L557 225C587 231 608 258 608 288C608 323 579 352 544 352ZM586 418C579 414 569 416 564 424L528 488C523 496 526 506 534 510C536 511 539 512 542 512C547 512 553 509 556 504L592 440C597 432 594 422 586 418ZM394 418C387 414 377 416 372 424L336 488C331 496 334 506 342 510C344 511 347 512 350 512C355 512 361 509 364 504L400 440C405 432 402 422 394 418Z"]
  };
  var faCloudWord = {
    prefix: 'fal',
    iconName: 'cloud-word',
    icon: [640, 512, [], "e102", "M368 352H272C263 352 256 359 256 368C256 377 263 384 272 384H368C377 384 384 377 384 368C384 359 377 352 368 352ZM288 304C288 295 281 288 272 288H144C135 288 128 295 128 304C128 313 135 320 144 320H272C281 320 288 313 288 304ZM208 352H176C167 352 160 359 160 368C160 377 167 384 176 384H208C217 384 224 377 224 368C224 359 217 352 208 352ZM464 352H432C423 352 416 359 416 368C416 377 423 384 432 384H464C473 384 480 377 480 368C480 359 473 352 464 352ZM572 239C574 229 576 219 576 208C576 146 526 96 464 96C447 96 431 100 416 107C384 62 332 32 272 32C178 32 100 106 96 200C39 220 0 274 0 336C0 416 64 480 144 480H512C583 480 640 423 640 352C640 305 614 261 572 239ZM508 448H149C91 448 39 406 33 348C27 291 63 242 114 228C123 226 128 218 128 209V208C128 147 165 91 223 72C294 48 362 79 395 133C401 143 413 145 423 139C440 129 461 125 483 130C510 136 533 157 540 184C546 203 545 222 538 239C534 249 540 260 550 264C587 280 612 319 607 363C602 412 557 448 508 448ZM496 288H336C327 288 320 295 320 304C320 313 327 320 336 320H496C505 320 512 313 512 304C512 295 505 288 496 288Z"]
  };
  var faClouds = {
    prefix: 'fal',
    iconName: 'clouds',
    icon: [640, 512, [], "f744", "M544 304C540 259 502 224 456 224C438 224 421 229 407 239C384 210 349 192 312 192C246 192 192 246 192 312C192 312 192 312 192 312C154 328 128 366 128 408C128 465 175 512 232 512H536C593 512 640 465 640 408C640 353 597 308 544 304ZM536 480H235C202 480 171 459 162 426C152 387 176 349 213 339C221 337 226 329 225 321C224 314 224 315 224 308C225 277 242 249 270 234C316 211 367 229 389 271C398 287 411 278 414 275C423 266 435 258 448 257C487 251 516 285 511 321L511 322C510 330 517 338 526 337C566 333 604 361 608 401C612 444 578 480 536 480ZM168 272C168 263 161 256 152 256H97C66 256 37 234 33 202C28 169 51 138 84 133C91 132 96 126 97 119L97 119C102 69 143 32 192 32C231 32 267 57 282 94L282 94C285 103 295 107 303 103C314 98 326 96 337 96C358 96 377 107 391 122C410 142 416 160 416 176H416C416 185 423 192 432 192C441 192 448 185 448 176C448 114 398 64 336 64C326 64 315 66 305 69C283 27 239 0 192 0C130 0 78 44 67 104C24 117 -5 158 1 205C6 253 49 288 98 288H152C161 288 168 281 168 272Z"]
  };
  var faCloudsMoon = {
    prefix: 'fal',
    iconName: 'clouds-moon',
    icon: [640, 512, [], "f745", "M446 321C440 284 407 256 368 256C356 256 344 259 334 264C316 239 287 224 256 224C203 224 160 267 160 320C160 322 160 324 160 326C122 339 96 375 96 416C96 469 139 512 192 512H432C485 512 528 469 528 416C528 368 493 328 446 321ZM432 480H194C161 480 132 456 128 423C124 389 148 359 181 353L181 353C190 352 196 343 194 334C193 329 192 324 192 320C192 285 221 256 256 256C281 256 303 270 314 293C318 302 330 305 338 299L338 299C351 288 367 285 383 290C403 297 416 317 416 338V338C416 346 422 352 430 352C462 352 491 375 495 407C501 446 470 480 432 480ZM96 320C59 320 30 289 32 252C34 218 64 192 98 192H114C121 192 128 187 129 179C135 150 162 128 192 128H192C222 128 249 150 255 179C256 187 263 192 270 192H288C313 192 334 206 345 227C352 225 360 224 368 224C371 224 375 225 378 225C365 187 330 160 288 160H282C269 122 233 96 192 96H192C151 96 115 122 102 160H99C48 160 4 198 0 249C-3 300 34 343 82 351C89 339 98 329 108 320H96ZM637 248C632 240 622 235 612 237C581 243 550 235 526 215C502 195 488 166 488 136C488 99 509 64 541 46C550 41 554 32 553 22C551 12 544 5 534 3C524 1 514 0 503 0C421 0 352 59 337 138C348 142 358 148 367 156C374 86 434 31 505 32C475 58 456 95 456 136C456 176 474 214 505 240C530 260 561 272 594 271C573 289 547 301 519 304L497 306C509 314 520 323 530 334C571 328 608 307 635 275C641 267 642 257 637 248Z"]
  };
  var faCloudsSun = {
    prefix: 'fal',
    iconName: 'clouds-sun',
    icon: [640, 512, [], "f746", "M138 314L93 323L105 260C106 254 104 247 98 243L45 208L98 172C104 168 106 162 105 155L93 92L156 105C162 106 169 103 172 98L208 44L244 98C247 103 254 106 260 105L323 92L316 129C314 140 324 150 335 146L335 146C341 145 345 141 346 135L359 75C360 70 359 64 355 61C351 57 346 55 341 56L264 71L221 7C215 -2 201 -2 195 7L151 71L75 56C70 55 65 57 61 61C57 64 55 70 57 75L72 151L7 194C3 197 0 202 0 208C0 213 3 218 7 221L72 264L57 340C56 346 57 351 61 355C65 358 70 360 75 359L145 347C153 345 159 337 158 328V328C157 319 148 312 138 314ZM208 150C237 150 261 171 265 199C267 198 270 197 272 196C277 187 283 179 290 172C276 140 245 118 208 118C158 118 118 158 118 208C118 247 144 280 179 292C179 292 183 276 190 262C167 255 150 233 150 208C150 176 176 150 208 150ZM550 165H550C533 124 495 96 450 96C404 96 364 126 349 170C336 174 324 183 314 193C328 194 342 197 354 203C357 202 359 201 361 200C369 197 376 190 379 182C389 150 417 128 450 128C482 128 509 148 521 178C525 190 537 197 550 197C550 197 550 197 550 197C582 197 608 224 608 258C608 288 588 313 562 318C571 326 579 335 585 344C617 330 640 297 640 258C640 207 600 165 550 165ZM495 321C488 284 455 256 416 256C404 256 392 259 382 264C364 239 335 224 304 224C251 224 208 267 208 320C208 322 208 324 208 326C170 339 144 375 144 416C144 469 187 512 240 512H480C533 512 576 469 576 416C576 368 541 328 495 321ZM480 480L242 480C210 480 180 456 177 423C173 389 196 359 229 353C240 351 244 344 242 336C241 331 240 326 240 320C240 285 269 256 304 256C329 256 351 270 362 293C367 305 376 307 386 299C399 288 416 285 431 290C451 297 464 317 464 338V338C464 346 470 352 478 352H478C510 352 539 375 543 407C549 446 518 480 480 480Z"]
  };
  var faClub = {
    prefix: 'fal',
    iconName: 'club',
    icon: [512, 512, [], "f327", "M374 176C381 161 384 145 384 128C384 57 327 0 256 0S128 57 128 128C128 145 131 161 138 176C60 175 0 238 0 312C0 387 61 448 136 448C178 448 215 428 240 398V480H176C167 480 160 487 160 496C160 505 167 512 176 512H336C345 512 352 505 352 496C352 487 345 480 336 480H272V398C297 428 334 448 376 448C451 448 512 387 512 312C512 238 452 175 374 176ZM376 416C338 416 302 394 284 360C279 349 268 343 256 343S233 349 228 360C210 394 174 416 136 416C75 416 36 367 32 320C28 257 78 208 134 208C135 208 161 208 161 208C173 208 181 197 176 186C169 169 160 151 160 128C160 75 203 32 256 32C309 32 352 75 352 128C352 152 343 168 336 186C331 197 339 208 351 208C351 208 351 208 351 208C379 208 378 208 378 208C429 209 484 252 480 320C476 367 436 416 376 416Z"]
  };
  var faCode = {
    prefix: 'fal',
    iconName: 'code',
    icon: [640, 512, [], "f121", "M172 117C166 111 156 110 149 116L5 244C2 247 0 251 0 256C0 261 2 265 5 268L149 396C152 399 156 400 160 400C164 400 169 398 172 395C178 388 177 378 171 372L40 256L171 140C177 134 178 124 172 117ZM635 244L491 116C484 110 474 111 468 117C462 124 463 134 469 140L600 256L469 372C463 378 462 388 468 395C471 398 476 400 480 400C484 400 488 399 491 396L635 268C638 265 640 261 640 256C640 251 638 247 635 244ZM405 1C397 -2 388 3 385 11L225 491C222 499 227 508 235 511C237 512 238 512 240 512C247 512 253 508 255 501L415 21C418 13 413 4 405 1Z"]
  };
  var faCodeBranch = {
    prefix: 'fal',
    iconName: 'code-branch',
    icon: [384, 512, [], "f126", "M384 144C384 100 348 64 304 64C260 64 224 100 224 144C224 182 251 214 286 222C280 250 254 272 224 272H160C135 272 113 282 96 297V158C133 151 160 119 160 80C160 36 124 0 80 0C36 0 0 36 0 80C0 119 27 151 64 158V354C27 361 0 393 0 432C0 476 36 512 80 512C124 512 160 476 160 432C160 394 133 362 98 354C104 326 130 304 160 304H224C272 304 311 269 319 223C356 216 384 183 384 144ZM32 80C32 54 54 32 80 32S128 54 128 80S106 128 80 128S32 106 32 80ZM128 432C128 458 106 480 80 480S32 458 32 432S54 384 80 384S128 406 128 432ZM304 192C278 192 256 170 256 144S278 96 304 96S352 118 352 144S330 192 304 192Z"]
  };
  var faCodeCommit = {
    prefix: 'fal',
    iconName: 'code-commit',
    icon: [640, 512, [], "f386", "M624 240H446C438 177 385 128 320 128C255 128 202 177 194 240H16C7 240 0 247 0 256S7 272 16 272H194C202 335 255 384 320 384C385 384 438 335 446 272H624C633 272 640 265 640 256S633 240 624 240ZM320 352C267 352 224 309 224 256C224 203 267 160 320 160C373 160 416 203 416 256C416 309 373 352 320 352Z"]
  };
  var faCodeMerge = {
    prefix: 'fal',
    iconName: 'code-merge',
    icon: [384, 512, [], "f387", "M304 192C265 192 233 219 226 256H208C151 256 104 213 97 158C133 150 160 118 160 80C160 36 124 0 80 0C36 0 0 36 0 80C0 119 27 151 64 158V354C27 361 0 393 0 432C0 476 36 512 80 512C124 512 160 476 160 432C160 393 133 361 96 354V233C122 266 163 288 208 288H226C233 325 265 352 304 352C348 352 384 316 384 272C384 228 348 192 304 192ZM32 80C32 54 54 32 80 32S128 54 128 80S106 128 80 128S32 106 32 80ZM128 432C128 458 106 480 80 480S32 458 32 432S54 384 80 384S128 406 128 432ZM304 320C278 320 256 298 256 272S278 224 304 224S352 246 352 272S330 320 304 320Z"]
  };
  var faCoffeeBean = {
    prefix: 'fal',
    iconName: 'coffee-bean',
    icon: [448, 512, [], "e103", "M287 32C220 32 148 70 93 125C-83 301 20 480 161 480C228 480 300 442 355 387C531 211 427 32 287 32ZM116 147C168 95 232 64 287 64C287 64 288 64 288 64C318 64 347 77 368 98C368 99 369 99 369 99C350 161 308 231 215 248C135 263 78 309 49 381C12 334 32 231 116 147ZM332 365C280 417 216 448 161 448C114 448 98 432 74 408C97 338 147 293 221 279C304 264 363 211 394 125C449 189 396 301 332 365Z"]
  };
  var faCoffeeBeans = {
    prefix: 'fal',
    iconName: 'coffee-beans',
    icon: [512, 512, [], "e104", "M0 352C0 566 256 565 256 352C256 138 0 139 0 352ZM125 480C125 480 125 480 125 480C100 480 75 466 60 447C41 421 32 385 32 352C32 283 68 229 100 224C80 273 85 325 114 367C139 403 143 442 125 480ZM160 477C174 435 168 389 140 349C115 312 113 267 136 223C224 225 224 349 224 352C224 397 207 458 160 477ZM452 60C300 -93 132 77 283 228C436 381 604 211 452 60ZM305 207C272 175 240 120 258 76C279 116 316 144 362 154C405 164 438 195 455 241C395 297 307 209 305 207ZM477 217C455 169 416 135 367 124C325 115 294 89 279 51C279 51 279 51 279 51C296 34 321 28 345 32C376 37 408 57 431 81C481 130 495 193 477 217Z"]
  };
  var faCoffeePot = {
    prefix: 'fal',
    iconName: 'coffee-pot',
    icon: [512, 512, [], "e002", "M431 178L473 53C476 43 469 32 458 32H80C36 32 0 68 0 112V208C0 217 7 224 16 224S32 217 32 208V112C32 86 54 64 80 64H107L145 178C95 218 64 278 64 345C64 396 83 429 114 462C124 474 139 480 155 480H421C436 480 451 474 462 463C493 430 512 396 512 345C512 278 481 218 431 178ZM140 64H436L404 160H172L140 64ZM178 192H398C419 209 453 234 471 288H105C123 234 158 208 178 192ZM439 441C434 445 428 448 421 448H155C148 448 142 445 137 440C107 409 96 383 96 345C96 336 97 328 98 320H478C479 328 480 336 480 345C480 383 469 409 439 441Z"]
  };
  var faCoffin = {
    prefix: 'fal',
    iconName: 'coffin',
    icon: [448, 512, [], "f6c6", "M403 113L304 13C295 5 284 0 271 0H177C164 0 153 5 144 14L45 113C34 124 29 141 33 156L113 477C118 498 137 512 158 512H290C311 512 330 498 335 477L415 156C419 141 414 124 403 113ZM304 469C302 476 297 480 290 480H158C151 480 146 476 144 469L64 149C63 144 65 139 68 135L167 36C170 34 173 32 177 32H271C275 32 278 34 281 36L380 135C383 139 385 144 384 149L304 469Z"]
  };
  var faCoffinCross = {
    prefix: 'fal',
    iconName: 'coffin-cross',
    icon: [384, 512, [], "e051", "M371 113L272 13C263 5 252 0 239 0H145C132 0 121 5 112 14L13 113C2 124 -3 141 1 156L81 477C86 498 105 512 126 512H258C279 512 298 498 303 477L383 156C387 141 382 124 371 113ZM272 469C270 476 265 480 258 480H126C119 480 114 476 112 469L32 149C31 144 33 139 36 135L135 36C138 34 141 32 145 32H239C243 32 246 34 249 36L348 135C351 139 353 144 352 149L272 469ZM272 176H208V112C208 103 201 96 192 96S176 103 176 112V176H112C103 176 96 183 96 192S103 208 112 208H176V336C176 345 183 352 192 352S208 345 208 336V208H272C281 208 288 201 288 192S281 176 272 176Z"]
  };
  var faCoin = {
    prefix: 'fal',
    iconName: 'coin',
    icon: [512, 512, [], "f85c", "M256 64C115 64 0 129 0 208V320C0 391 115 448 256 448S512 391 512 320V208C512 129 397 64 256 64ZM64 367C44 352 32 336 32 320V278C42 287 52 296 64 303V367ZM144 402C127 398 111 392 96 385V320C111 327 128 333 144 337V402ZM240 416C218 415 197 413 176 409V345C197 348 218 351 240 351V416ZM336 409C315 413 294 415 272 416V351C294 351 315 348 336 345V409ZM416 385C401 392 385 398 368 402V337C384 333 401 327 416 320V385ZM480 320C480 336 468 352 448 367V303C460 296 470 287 480 278V320ZM256 320C124 320 32 261 32 208S124 96 256 96S480 155 480 208S388 320 256 320Z"]
  };
  var faCoins = {
    prefix: 'fal',
    iconName: 'coins',
    icon: [512, 512, [], "f51e", "M192 169C86 169 0 205 0 249V441C0 485 86 521 192 521S384 485 384 441V249C384 205 298 169 192 169ZM352 441C352 453 297 489 192 489S32 453 32 441V389C66 411 125 425 192 425S318 411 352 389V441ZM352 345C352 357 297 393 192 393S32 357 32 345V293C66 315 125 329 192 329S318 315 352 293V345ZM192 297C87 297 32 261 32 249S87 201 192 201S352 236 352 249S297 297 192 297ZM128 88V120C128 129 135 136 144 136S160 129 160 120V88C160 69 224 40 320 40S480 69 480 88C480 102 441 126 366 134C358 135 351 143 352 151C353 160 360 166 368 166C369 166 369 166 370 166C410 162 452 151 480 134V168C480 177 464 191 427 202C419 205 414 214 417 222C419 229 425 234 432 234C434 234 435 234 437 233C454 228 468 222 480 214V249C480 257 464 272 427 283C419 285 414 294 417 303C419 310 425 314 432 314C434 314 435 314 437 313C485 299 512 276 512 249V88C512 -18 128 -18 128 88Z"]
  };
  var faColonSign = {
    prefix: 'fal',
    iconName: 'colon-sign',
    icon: [384, 512, [], "e105", "M325 363C298 390 264 404 229 407L295 126C305 132 316 139 325 149C331 155 341 155 347 148C354 142 354 132 347 126C334 112 318 102 302 94L320 20C322 11 316 2 308 0C299 -2 290 4 288 12L272 81C258 77 242 74 227 73L240 20C242 11 236 2 228 0C219 -2 210 4 208 12L194 74C155 79 116 96 86 126C51 161 32 207 32 256S51 351 86 386C95 395 105 403 116 410L96 492C94 501 100 510 108 512C110 512 111 512 112 512C119 512 126 507 128 500L145 425C159 431 174 435 189 437L176 492C174 501 180 510 188 512C190 512 191 512 192 512C199 512 206 507 208 500L222 439C267 438 313 421 347 386C354 380 354 370 347 363C341 357 331 357 325 363ZM109 363C80 335 64 297 64 256S80 177 109 149C131 127 158 113 186 107L124 376C119 372 113 368 109 363ZM152 393L220 104C235 105 250 108 265 113L197 406C181 404 167 400 152 393Z"]
  };
  var faComet = {
    prefix: 'fal',
    iconName: 'comet',
    icon: [512, 512, [], "e003", "M505 7C498 1 489 -2 480 1C448 11 371 35 313 60C312 56 309 39 293 32C284 29 275 29 266 34C223 56 116 115 58 173C-19 251 -19 377 58 454C136 531 261 531 339 454C397 396 456 289 479 246C483 238 483 228 480 219C473 203 457 201 452 199C477 141 501 64 511 32C514 23 511 14 505 7ZM408 219L450 231C450 231 371 376 316 431C251 496 146 496 81 431S16 261 81 196C136 141 280 62 280 62L293 105C293 105 354 74 476 36C441 150 408 219 408 219ZM222 174C219 169 214 165 208 165C202 165 197 169 194 174L163 237L93 248C87 248 83 252 81 258C79 264 80 270 85 274L135 323L123 393C122 397 124 402 127 405C130 409 134 411 138 411C141 411 143 410 145 409L208 376L271 409C276 412 282 411 287 408C291 404 294 398 293 393L281 323L331 274C336 270 337 264 335 258C333 252 329 248 323 248L253 237L222 174ZM246 312L255 365L208 340L161 365L170 312L131 274L184 267L208 218L232 267L285 274L246 312Z"]
  };
  var faCommand = {
    prefix: 'fal',
    iconName: 'command',
    icon: [448, 512, [], "e106", "M368 320H320V192H368C412 192 448 156 448 112C448 68 412 32 368 32S288 68 288 112V160H160V112C160 68 124 32 80 32S0 68 0 112C0 156 36 192 80 192H128V320H80C36 320 0 356 0 400C0 444 36 480 80 480S160 444 160 400V352H288V400C288 444 324 480 368 480S448 444 448 400C448 356 412 320 368 320ZM320 112C320 86 342 64 368 64S416 86 416 112S394 160 368 160H320V112ZM128 400C128 426 106 448 80 448S32 426 32 400S54 352 80 352H128V400ZM128 160H80C54 160 32 138 32 112S54 64 80 64S128 86 128 112V160ZM288 320H160V192H288V320ZM368 448C342 448 320 426 320 400V352H368C394 352 416 374 416 400S394 448 368 448Z"]
  };
  var faComment = {
    prefix: 'fal',
    iconName: 'comment',
    icon: [512, 512, [], "f075", "M256 64C380 64 480 143 480 240S380 416 256 416C228 416 200 412 173 403L173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32Z"]
  };
  var faCommentArrowDown = {
    prefix: 'fal',
    iconName: 'comment-arrow-down',
    icon: [512, 512, [], "e107", "M325 229L272 281V144C272 135 265 128 256 128S240 135 240 144V281L187 229C181 222 171 222 165 229S158 245 165 251L245 331C248 334 252 336 256 336S264 334 267 331L347 251C354 245 354 235 347 229S331 222 325 229ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416Z"]
  };
  var faCommentArrowUp = {
    prefix: 'fal',
    iconName: 'comment-arrow-up',
    icon: [512, 512, [], "e108", "M267 133C264 130 260 128 256 128S248 130 245 133L165 213C158 219 158 229 165 235S181 242 187 235L240 183V320C240 329 247 336 256 336S272 329 272 320V183L325 235C331 242 341 242 347 235S354 219 347 213L267 133ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416Z"]
  };
  var faCommentCaptions = {
    prefix: 'fal',
    iconName: 'comment-captions',
    icon: [512, 512, [], "e109", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64S480 143 480 240S380 416 256 416ZM224 240C224 231 217 224 208 224H80C71 224 64 231 64 240S71 256 80 256H208C217 256 224 249 224 240ZM304 288H208C199 288 192 295 192 304S199 320 208 320H304C313 320 320 313 320 304S313 288 304 288ZM144 288H112C103 288 96 295 96 304S103 320 112 320H144C153 320 160 313 160 304S153 288 144 288ZM400 288H368C359 288 352 295 352 304S359 320 368 320H400C409 320 416 313 416 304S409 288 400 288ZM432 224H272C263 224 256 231 256 240S263 256 272 256H432C441 256 448 249 448 240S441 224 432 224Z"]
  };
  var faCommentCheck = {
    prefix: 'fal',
    iconName: 'comment-check',
    icon: [512, 512, [], "f4ac", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64S480 143 480 240S380 416 256 416ZM325 175L229 271L187 229C181 222 171 222 165 229S158 245 165 251L218 305C221 308 225 309 229 309S238 308 241 305L347 198C354 192 354 182 347 175S331 169 325 175Z"]
  };
  var faCommentDollar = {
    prefix: 'fal',
    iconName: 'comment-dollar',
    icon: [512, 512, [], "f651", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64S480 143 480 240S380 416 256 416ZM260 225L253 223C219 213 214 206 217 194C220 178 245 174 268 177C275 178 283 180 293 184C301 186 311 182 313 174C316 165 311 156 303 153C291 149 280 147 272 146V128C272 119 265 112 256 112S240 119 240 128V145C210 148 189 164 185 189C177 234 222 247 244 253L252 255C290 266 298 271 296 286C293 302 268 306 244 303C236 302 231 300 205 292C197 289 188 293 185 302C182 310 187 319 195 322C224 332 232 333 240 335V352C240 361 247 368 256 368S272 361 272 352V335C302 332 323 316 327 291C336 245 290 233 260 225Z"]
  };
  var faCommentDots = {
    prefix: 'fal',
    iconName: 'comment-dots',
    icon: [512, 512, [], "f4ad", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM256 216C243 216 232 227 232 240C232 253 243 264 256 264S280 253 280 240C280 227 269 216 256 216ZM384 216C371 216 360 227 360 240C360 253 371 264 384 264S408 253 408 240C408 227 397 216 384 216ZM128 216C115 216 104 227 104 240C104 253 115 264 128 264S152 253 152 240C152 227 141 216 128 216Z"]
  };
  var faCommentExclamation = {
    prefix: 'fal',
    iconName: 'comment-exclamation',
    icon: [512, 512, [], "f4af", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM256 288C265 288 272 281 272 272V128C272 119 265 112 256 112S240 119 240 128V272C240 281 247 288 256 288ZM256 312C243 312 232 323 232 336C232 349 243 360 256 360S280 349 280 336C280 323 269 312 256 312Z"]
  };
  var faCommentImage = {
    prefix: 'fal',
    iconName: 'comment-image',
    icon: [512, 512, [], "e10a", "M160 184C173 184 184 173 184 160C184 147 173 136 160 136S136 147 136 160C136 173 147 184 160 184ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM314 155C302 141 277 141 266 155L207 227L199 219C188 207 166 207 154 219L104 271C96 280 94 293 99 303C104 314 115 320 126 320H386C397 320 407 314 412 305C418 294 417 282 410 273L314 155ZM131 288L176 241L197 262C200 266 204 267 209 267C213 267 218 265 220 261L289 175L381 288L131 288Z"]
  };
  var faCommentLines = {
    prefix: 'fal',
    iconName: 'comment-lines',
    icon: [512, 512, [], "f4b0", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM272 272H144C135 272 128 279 128 288C128 297 135 304 144 304H272C281 304 288 297 288 288C288 279 281 272 272 272ZM368 176H144C135 176 128 183 128 192C128 201 135 208 144 208H368C377 208 384 201 384 192C384 183 377 176 368 176Z"]
  };
  var faCommentMedical = {
    prefix: 'fal',
    iconName: 'comment-medical',
    icon: [512, 512, [], "f7f5", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM336 208H288V160C288 151 281 144 272 144H240C231 144 224 151 224 160V208H176C167 208 160 215 160 224V256C160 265 167 272 176 272H224V320C224 329 231 336 240 336H272C281 336 288 329 288 320V272H336C345 272 352 265 352 256V224C352 215 345 208 336 208Z"]
  };
  var faCommentMiddle = {
    prefix: 'fal',
    iconName: 'comment-middle',
    icon: [512, 512, [], "e10b", "M256 0C115 0 0 93 0 208C0 304 80 385 189 409L238 502C241 509 249 512 256 512S271 509 274 502L323 409C432 385 512 304 512 208C512 93 397 0 256 0ZM316 377L302 380L256 468L210 380L196 377C99 356 32 286 32 208C32 111 132 32 256 32S480 111 480 208C480 286 413 356 316 377Z"]
  };
  var faCommentMiddleTop = {
    prefix: 'fal',
    iconName: 'comment-middle-top',
    icon: [512, 512, [], "e10c", "M323 103L274 10C271 3 263 0 256 0S241 3 238 10L189 103C80 127 0 208 0 304C0 419 115 512 256 512S512 419 512 304C512 208 432 127 323 103ZM256 480C132 480 32 401 32 304C32 226 99 156 196 135L210 132L256 44L302 131L316 135C413 156 480 226 480 304C480 401 380 480 256 480Z"]
  };
  var faCommentMinus = {
    prefix: 'fal',
    iconName: 'comment-minus',
    icon: [512, 512, [], "f4b1", "M336 224H176C167 224 160 231 160 240S167 256 176 256H336C345 256 352 249 352 240S345 224 336 224ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416Z"]
  };
  var faCommentMusic = {
    prefix: 'fal',
    iconName: 'comment-music',
    icon: [512, 512, [], "f8b0", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM338 125C330 119 319 117 309 121L213 157C200 162 192 174 192 187V261C185 258 177 256 168 256C137 256 112 278 112 304S137 352 168 352S224 330 224 304V187L320 151V229C313 226 305 224 296 224C265 224 240 246 240 272S265 320 296 320S352 298 352 272V151C352 141 347 131 338 125ZM168 320C155 320 144 313 144 304S155 288 168 288S192 295 192 304S181 320 168 320ZM296 288C283 288 272 281 272 272S283 256 296 256S320 263 320 272S309 288 296 288Z"]
  };
  var faCommentPen = {
    prefix: 'fal',
    iconName: 'comment-pen',
    icon: [512, 512, [], "f4ae", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM346 142C338 134 328 129 317 128C304 127 291 132 282 141L158 264C156 266 154 269 154 272L141 333C139 344 149 354 160 352L221 340C224 339 227 337 229 335L353 213C360 206 366 196 366 185C368 172 363 159 354 150L346 142ZM210 309L177 316L184 283L271 197L297 223L210 309ZM331 189L320 201L293 174L305 163C309 159 317 159 322 163L331 173C336 177 336 185 331 189Z"]
  };
  var faCommentPlus = {
    prefix: 'fal',
    iconName: 'comment-plus',
    icon: [512, 512, [], "f4b2", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM336 224H272V160C272 151 265 144 256 144S240 151 240 160V224H176C167 224 160 231 160 240S167 256 176 256H240V320C240 329 247 336 256 336S272 329 272 320V256H336C345 256 352 249 352 240S345 224 336 224Z"]
  };
  var faCommentQuote = {
    prefix: 'fal',
    iconName: 'comment-quote',
    icon: [512, 512, [], "e10d", "M184 144C153 144 128 169 128 200S153 256 184 256C193 256 201 254 208 250V256C208 282 186 304 160 304C151 304 144 311 144 320S151 336 160 336C204 336 240 300 240 256V200C240 169 215 144 184 144ZM184 224C171 224 160 213 160 200C160 187 171 176 184 176C197 176 208 187 208 200C208 213 197 224 184 224ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM328 144C297 144 272 169 272 200S297 256 328 256C337 256 345 254 352 250V256C352 282 330 304 304 304C295 304 288 311 288 320S295 336 304 336C348 336 384 300 384 256V200C384 169 359 144 328 144ZM328 224C315 224 304 213 304 200C304 187 315 176 328 176C341 176 352 187 352 200C352 213 341 224 328 224Z"]
  };
  var faCommentSlash = {
    prefix: 'fal',
    iconName: 'comment-slash',
    icon: [640, 512, [], "f4b3", "M320 416C292 416 264 412 237 403C227 400 217 402 209 408L209 408C186 424 150 443 106 447C118 432 136 407 147 378L147 377C151 366 149 353 140 344L140 344C111 314 96 278 96 240C96 217 102 194 113 174L87 154C73 180 64 209 64 240C64 288 84 331 117 366C102 406 71 439 71 439C64 446 62 457 66 465C70 474 78 480 88 480C149 480 198 454 227 434C256 443 287 448 320 448C361 448 399 440 433 427L403 403C378 411 349 416 320 416ZM320 64C444 64 544 143 544 240C544 272 533 302 514 328L539 347C562 316 576 279 576 240C576 125 461 32 320 32C269 32 222 44 182 65L209 87C242 73 280 64 320 64ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483Z"]
  };
  var faCommentSmile = {
    prefix: 'fal',
    iconName: 'comment-smile',
    icon: [512, 512, [], "f4b4", "M192 216C205 216 216 205 216 192S205 168 192 168S168 179 168 192S179 216 192 216ZM320 216C333 216 344 205 344 192S333 168 320 168S296 179 296 192S307 216 320 216ZM332 285C313 307 285 320 256 320S199 307 180 285C175 279 164 278 158 284C151 289 150 299 156 306C181 335 217 352 256 352S331 335 356 306C362 299 361 289 354 283C348 278 338 279 332 285ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416Z"]
  };
  var faCommentSms = {
    prefix: 'fal',
    iconName: 'comment-sms',
    icon: [512, 512, [], "f7cd", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403L158 398L145 408C122 424 86 443 42 447C54 432 72 407 83 378L90 359L76 344C47 314 32 278 32 240C32 143 133 64 256 64S480 143 480 240S380 416 256 416ZM132 225L128 223C111 218 112 216 112 214C113 209 123 207 134 209C138 209 143 211 147 212C155 215 164 211 167 202C170 194 166 185 157 182C151 180 145 178 139 177C108 172 85 185 81 208C75 241 107 251 119 254L124 255C145 261 144 263 144 266C143 271 134 273 122 271C117 271 110 268 105 266L101 265C93 262 84 266 81 275C78 283 82 292 91 295L94 296C101 299 109 302 117 303C122 304 126 304 130 304C154 304 172 292 175 272C181 239 149 229 132 225ZM388 225L384 223C367 218 368 216 368 214C369 209 379 207 390 209C394 209 399 211 403 212C411 215 420 211 423 202C426 194 422 185 413 182C407 180 401 178 395 177C364 172 341 185 337 208C331 241 363 251 375 254L380 255C401 261 400 263 400 266C399 271 390 273 378 271C373 271 366 268 361 266L357 265C349 262 340 266 337 275C334 283 338 292 347 295L350 296C357 299 365 302 373 303C378 304 382 304 386 304C410 304 428 292 431 272C437 239 405 229 388 225ZM309 177C303 175 295 177 291 182L256 229L221 182C217 177 210 175 203 177C196 179 192 185 192 192V288C192 297 199 304 208 304S224 297 224 288V240L243 266C249 274 263 274 269 266L288 240V288C288 297 295 304 304 304S320 297 320 288V192C320 185 316 179 309 177Z"]
  };
  var faCommentText = {
    prefix: 'fal',
    iconName: 'comment-text',
    icon: [512, 512, [], "e10e", "M256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416ZM336 160H176C167 160 160 167 160 176S167 192 176 192H240V336C240 345 247 352 256 352S272 345 272 336V192H336C345 192 352 185 352 176S345 160 336 160Z"]
  };
  var faCommentXmark = {
    prefix: 'fal',
    iconName: 'comment-xmark',
    icon: [512, 512, [], "f4b5", "M324 172C318 166 307 166 301 172L256 217L211 172C205 166 194 166 188 172C182 178 182 189 188 195L233 240L188 285C182 291 182 302 188 308C194 314 205 314 211 308L256 263L301 308C307 314 318 314 324 308C330 302 330 291 324 285L279 240L324 195C330 188 330 178 324 172ZM256 32C115 32 0 125 0 240C0 288 20 331 53 366C38 406 7 439 7 439C0 446 -2 457 2 465C6 474 14 480 24 480C85 480 134 454 163 434C192 443 223 448 256 448C397 448 512 355 512 240S397 32 256 32ZM256 416C228 416 200 412 173 403C163 400 153 402 145 408L145 408C122 424 86 443 42 447C54 432 72 407 83 378L83 377C87 366 85 353 76 344L76 344C47 314 32 278 32 240C32 143 133 64 256 64C380 64 480 143 480 240S380 416 256 416Z"]
  };
  var faComments = {
    prefix: 'fal',
    iconName: 'comments',
    icon: [576, 512, [], "f086", "M532 386C560 359 576 325 576 288C576 219 518 160 438 138C442 149 445 161 447 174C504 195 544 238 544 288C544 322 525 348 510 363C500 373 497 388 504 401C513 418 525 435 534 447C503 444 472 433 442 415C442 414 432 408 418 410C402 414 385 416 368 416C321 416 279 403 248 381C218 385 202 384 202 384C240 423 300 448 368 448C388 448 407 446 425 442C455 460 498 480 552 480C562 480 570 474 574 466C578 457 576 446 569 440C569 439 548 416 532 386ZM416 192C416 104 323 32 208 32S0 104 0 192C0 229 16 263 44 290C28 320 7 343 7 344C0 351 -2 361 2 370C6 378 14 384 24 384C78 384 121 364 151 346C169 350 188 352 208 352C323 352 416 280 416 192ZM134 319C104 337 74 348 42 351C51 339 63 322 72 305C79 292 76 277 66 267C51 252 32 226 32 192C32 121 111 64 208 64S384 121 384 192C384 263 305 320 208 320C191 320 175 318 158 314C144 312 134 318 134 319Z"]
  };
  var faCommentsDollar = {
    prefix: 'fal',
    iconName: 'comments-dollar',
    icon: [576, 512, [], "f653", "M532 386C560 359 576 325 576 288C576 219 518 160 438 138C442 149 445 161 447 174C504 195 544 238 544 288C544 322 525 348 510 363C500 373 497 388 504 401C513 418 525 435 534 447C503 444 472 433 442 415C442 414 432 408 418 410C402 414 385 416 368 416C321 416 279 403 248 381C218 385 202 384 202 384C240 423 300 448 368 448C388 448 407 446 425 442C455 460 498 480 552 480C562 480 570 474 574 466C578 457 576 446 569 440C569 439 548 416 532 386ZM416 192C416 104 323 32 208 32S0 104 0 192C0 229 16 263 44 290C28 320 7 343 7 344C0 351 -2 361 2 370C6 378 14 384 24 384C78 384 121 364 151 346C169 350 188 352 208 352C323 352 416 280 416 192ZM134 319C104 337 74 348 42 351C51 339 63 322 72 305C79 292 76 277 66 267C51 252 32 226 32 192C32 121 111 64 208 64S384 121 384 192C384 263 305 320 208 320C191 320 175 318 158 314C144 312 134 318 134 319ZM224 280V270C246 266 262 254 266 234C273 194 235 183 212 177L207 175C180 167 181 162 182 156C184 145 201 142 216 145C222 146 229 148 235 150C243 153 252 148 255 140C258 132 254 123 245 120C237 117 230 115 224 114V104C224 95 217 88 208 88C199 88 192 95 192 104V113C169 117 154 130 150 150C143 190 182 201 198 206L204 207C232 216 236 219 234 228C232 239 215 242 200 239C192 238 183 235 175 232L171 230C162 227 153 232 150 240C147 248 152 258 160 260L164 262C173 265 183 268 192 270V280C192 289 199 296 208 296C217 296 224 289 224 280Z"]
  };
  var faCompactDisc = {
    prefix: 'fal',
    iconName: 'compact-disc',
    icon: [512, 512, [], "f51f", "M256 232C243 232 232 243 232 256S243 280 256 280S280 269 280 256S269 232 256 232ZM256 160C203 160 160 203 160 256S203 352 256 352S352 309 352 256S309 160 256 160ZM256 320C221 320 192 291 192 256S221 192 256 192S320 221 320 256S291 320 256 320ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM272 96C272 87 265 80 256 80C159 80 80 159 80 256C80 265 87 272 96 272S112 265 112 256C112 177 177 112 256 112C265 112 272 105 272 96Z"]
  };
  var faCompass = {
    prefix: 'fal',
    iconName: 'compass',
    icon: [512, 512, [], "f14e", "M273 273C282 264 282 248 273 239C264 230 248 230 239 239C230 248 230 264 239 273C248 282 264 282 273 273ZM357 128C355 128 353 128 351 129L199 184C192 186 186 192 184 199L129 351C124 366 139 384 155 384C157 384 159 384 161 383L313 328C320 326 326 320 328 313L383 161C388 146 373 128 357 128ZM299 299L164 348L213 213L348 164L299 299ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faCompassDrafting = {
    prefix: 'fal',
    iconName: 'compass-drafting',
    icon: [512, 512, [], "f568", "M510 488L445 376C441 368 431 366 423 370C416 375 413 384 418 392L482 504C485 509 490 512 496 512C499 512 501 511 504 510C512 505 514 496 510 488ZM492 232C496 224 493 215 486 210C478 206 468 208 464 216C421 290 341 336 256 336C216 336 178 326 143 307L231 156C239 158 247 160 256 160S273 158 281 156L344 264C347 269 352 272 358 272C360 272 363 271 366 270C373 265 376 256 371 248L309 140C325 125 336 104 336 80C336 36 300 0 256 0C212 0 176 36 176 80C176 104 187 125 203 140L116 290C89 271 65 246 48 216C44 208 34 206 26 210C19 215 16 224 20 232C41 267 68 296 100 318L2 488C-2 496 0 505 8 510C11 511 13 512 16 512C22 512 27 509 30 504L127 335C166 356 210 368 256 368C353 368 443 316 492 232ZM256 32C282 32 304 54 304 80S282 128 256 128C230 128 208 106 208 80S230 32 256 32Z"]
  };
  var faCompassSlash = {
    prefix: 'fal',
    iconName: 'compass-slash',
    icon: [640, 512, [], "f5e9", "M320 48C435 48 528 141 528 256C528 281 523 306 515 328L541 349C553 320 560 289 560 256C560 123 453 16 320 16C267 16 218 33 178 63L204 83C237 61 277 48 320 48ZM415 250L447 161C452 146 437 128 421 128C419 128 417 128 415 129L310 167L340 190L412 164L389 229L415 250ZM225 262L193 351C188 366 203 384 219 384C221 384 223 384 225 383L330 345L300 322L228 348L251 283L225 262ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483ZM320 464C205 464 112 371 112 256C112 231 117 206 125 184L99 163C87 192 80 223 80 256C80 389 187 496 320 496C373 496 422 479 462 449L436 429C402 451 363 464 320 464Z"]
  };
  var faCompress = {
    prefix: 'fal',
    iconName: 'compress',
    icon: [448, 512, [], "f066", "M144 320H16C7 320 0 327 0 336S7 352 16 352H128V464C128 473 135 480 144 480S160 473 160 464V336C160 327 153 320 144 320ZM304 192H432C441 192 448 185 448 176S441 160 432 160H320V48C320 39 313 32 304 32S288 39 288 48V176C288 185 295 192 304 192ZM432 320H304C295 320 288 327 288 336V464C288 473 295 480 304 480S320 473 320 464V352H432C441 352 448 345 448 336S441 320 432 320ZM144 32C135 32 128 39 128 48V160H16C7 160 0 167 0 176S7 192 16 192H144C153 192 160 185 160 176V48C160 39 153 32 144 32Z"]
  };
  var faCompressWide = {
    prefix: 'fal',
    iconName: 'compress-wide',
    icon: [512, 512, [], "f326", "M368 224H496C505 224 512 217 512 208S505 192 496 192H384V80C384 71 377 64 368 64S352 71 352 80V208C352 217 359 224 368 224ZM144 288H16C7 288 0 295 0 304S7 320 16 320H128V432C128 441 135 448 144 448S160 441 160 432V304C160 295 153 288 144 288ZM496 288H368C359 288 352 295 352 304V432C352 441 359 448 368 448S384 441 384 432V320H496C505 320 512 313 512 304S505 288 496 288ZM144 64C135 64 128 71 128 80V192H16C7 192 0 199 0 208S7 224 16 224H144C153 224 160 217 160 208V80C160 71 153 64 144 64Z"]
  };
  var faComputerClassic = {
    prefix: 'fal',
    iconName: 'computer-classic',
    icon: [448, 512, [], "f8b1", "M384 0H64C29 0 0 29 0 64V384C0 408 13 428 32 439V480C32 498 46 512 64 512H384C402 512 416 498 416 480V439C435 428 448 408 448 384V64C448 29 419 0 384 0ZM384 480H64V448H384V480ZM416 384C416 402 402 416 384 416H64C46 416 32 402 32 384V64C32 46 46 32 64 32H384C402 32 416 46 416 64V384ZM320 64H128C93 64 64 93 64 128V192C64 227 93 256 128 256H320C355 256 384 227 384 192V128C384 93 355 64 320 64ZM352 192C352 210 338 224 320 224H128C110 224 96 210 96 192V128C96 110 110 96 128 96H320C338 96 352 110 352 128V192ZM96 312C83 312 72 323 72 336C72 349 83 360 96 360S120 349 120 336C120 323 109 312 96 312ZM368 320H240C231 320 224 327 224 336S231 352 240 352H368C377 352 384 345 384 336S377 320 368 320Z"]
  };
  var faComputerMouse = {
    prefix: 'fal',
    iconName: 'computer-mouse',
    icon: [384, 512, [], "f8cc", "M224 0H160C72 0 0 72 0 160V352C0 440 72 512 160 512H224C312 512 384 440 384 352V160C384 72 312 0 224 0ZM32 160C32 89 89 32 160 32H176V192H32V160ZM352 352C352 423 295 480 224 480H160C89 480 32 423 32 352V224H352V352ZM352 192H208V32H224C295 32 352 89 352 160V192Z"]
  };
  var faComputerMouseScrollwheel = {
    prefix: 'fal',
    iconName: 'computer-mouse-scrollwheel',
    icon: [384, 512, [], "f8cd", "M224 0H160C72 0 0 72 0 160V352C0 440 72 512 160 512H224C312 512 384 440 384 352V160C384 72 312 0 224 0ZM352 352C352 423 295 480 224 480H160C89 480 32 423 32 352V160C32 89 89 32 160 32H224C295 32 352 89 352 160V352ZM192 96C183 96 176 103 176 112V176C176 185 183 192 192 192S208 185 208 176V112C208 103 201 96 192 96Z"]
  };
  var faComputerSpeaker = {
    prefix: 'fal',
    iconName: 'computer-speaker',
    icon: [640, 512, [], "f8b2", "M480 192C506 192 528 170 528 144S506 96 480 96S432 118 432 144S454 192 480 192ZM480 128C489 128 496 135 496 144S489 160 480 160S464 153 464 144S471 128 480 128ZM480 224C427 224 384 267 384 320S427 416 480 416S576 373 576 320S533 224 480 224ZM480 384C445 384 416 355 416 320S445 256 480 256S544 285 544 320S515 384 480 384ZM480 296C467 296 456 307 456 320S467 344 480 344S504 333 504 320S493 296 480 296ZM576 32H384C349 32 320 61 320 96V416C320 451 349 480 384 480H576C611 480 640 451 640 416V96C640 61 611 32 576 32ZM608 416C608 434 594 448 576 448H384C366 448 352 434 352 416V96C352 78 366 64 384 64H576C594 64 608 78 608 96V416ZM48 64H272C281 64 288 57 288 48S281 32 272 32H48C22 32 0 54 0 80V336C0 362 22 384 48 384H272C281 384 288 377 288 368S281 352 272 352H48C39 352 32 345 32 336V80C32 71 39 64 48 64ZM272 448H112C103 448 96 455 96 464S103 480 112 480H272C281 480 288 473 288 464S281 448 272 448Z"]
  };
  var faContainerStorage = {
    prefix: 'fal',
    iconName: 'container-storage',
    icon: [640, 512, [], "f4b7", "M368 416C377 416 384 409 384 400V112C384 103 377 96 368 96S352 103 352 112V400C352 409 359 416 368 416ZM464 416C473 416 480 409 480 400V112C480 103 473 96 464 96S448 103 448 112V400C448 409 455 416 464 416ZM272 416C281 416 288 409 288 400V112C288 103 281 96 272 96S256 103 256 112V400C256 409 263 416 272 416ZM624 448H608V64H624C633 64 640 57 640 48S633 32 624 32H16C7 32 0 39 0 48S7 64 16 64H32V448H16C7 448 0 455 0 464S7 480 16 480H624C633 480 640 473 640 464S633 448 624 448ZM576 448H64V64H576V448ZM176 416C185 416 192 409 192 400V112C192 103 185 96 176 96S160 103 160 112V400C160 409 167 416 176 416Z"]
  };
  var faConveyorBelt = {
    prefix: 'fal',
    iconName: 'conveyor-belt',
    icon: [640, 512, [], "f46e", "M544 320H96C43 320 0 363 0 416S43 512 96 512H544C597 512 640 469 640 416S597 320 544 320ZM544 480H96C61 480 32 451 32 416S61 352 96 352H544C579 352 608 381 608 416S579 480 544 480ZM192 288H448C483 288 512 259 512 224V64C512 29 483 0 448 0H192C157 0 128 29 128 64V224C128 259 157 288 192 288ZM272 32H368V102L327 82C323 79 317 79 313 82L272 102V32ZM160 64C160 46 174 32 192 32H240V128C240 134 243 139 248 142C252 144 258 145 263 142L320 114L377 142C379 143 382 144 384 144C387 144 390 143 392 142C397 139 400 134 400 128V32H448C466 32 480 46 480 64V224C480 242 466 256 448 256H192C174 256 160 242 160 224V64ZM128 392C115 392 104 403 104 416C104 429 115 440 128 440S152 429 152 416C152 403 141 392 128 392ZM320 392C307 392 296 403 296 416C296 429 307 440 320 440S344 429 344 416C344 403 333 392 320 392ZM512 392C499 392 488 403 488 416C488 429 499 440 512 440S536 429 536 416C536 403 525 392 512 392Z"]
  };
  var faConveyorBeltBoxes = {
    prefix: 'fal',
    iconName: 'conveyor-belt-boxes',
    icon: [640, 512, [], "f46f", "M128 288H288C323 288 352 259 352 224V64C352 29 323 0 288 0H128C93 0 64 29 64 64V224C64 259 93 288 128 288ZM96 64C96 46 110 32 128 32H288C306 32 320 46 320 64V224C320 242 306 256 288 256H128C110 256 96 242 96 224V64ZM448 288H512C547 288 576 259 576 224V128C576 93 547 64 512 64H448C413 64 384 93 384 128V224C384 259 413 288 448 288ZM416 128C416 110 430 96 448 96H512C530 96 544 110 544 128V224C544 242 530 256 512 256H448C430 256 416 242 416 224V128ZM544 320H96C43 320 0 363 0 416S43 512 96 512H544C597 512 640 469 640 416S597 320 544 320ZM544 480H96C61 480 32 451 32 416S61 352 96 352H544C579 352 608 381 608 416S579 480 544 480ZM128 392C115 392 104 403 104 416C104 429 115 440 128 440S152 429 152 416C152 403 141 392 128 392ZM320 392C307 392 296 403 296 416C296 429 307 440 320 440S344 429 344 416C344 403 333 392 320 392ZM512 392C499 392 488 403 488 416C488 429 499 440 512 440S536 429 536 416C536 403 525 392 512 392Z"]
  };
  var faConveyorBeltEmpty = {
    prefix: 'fal',
    iconName: 'conveyor-belt-empty',
    icon: [640, 512, [], "e10f", "M544 320H96C43 320 0 363 0 416S43 512 96 512H544C597 512 640 469 640 416S597 320 544 320ZM544 480H96C61 480 32 451 32 416S61 352 96 352H544C579 352 608 381 608 416S579 480 544 480ZM128 392C115 392 104 403 104 416C104 429 115 440 128 440S152 429 152 416C152 403 141 392 128 392ZM320 392C307 392 296 403 296 416C296 429 307 440 320 440S344 429 344 416C344 403 333 392 320 392ZM512 392C499 392 488 403 488 416C488 429 499 440 512 440S536 429 536 416C536 403 525 392 512 392Z"]
  };
  var faCookie = {
    prefix: 'fal',
    iconName: 'cookie',
    icon: [576, 512, [], "f563", "M224 328C211 328 200 339 200 352S211 376 224 376S248 365 248 352S237 328 224 328ZM216 192C216 179 205 168 192 168S168 179 168 192S179 216 192 216S216 205 216 192ZM320 232C307 232 296 243 296 256S307 280 320 280S344 269 344 256S333 232 320 232ZM376 128C376 115 365 104 352 104S328 115 328 128S339 152 352 152S376 141 376 128ZM384 328C371 328 360 339 360 352S371 376 384 376S408 365 408 352S397 328 384 328ZM526 255L515 183C511 157 499 134 480 115L429 64C410 45 387 33 361 29L289 18C282 16 276 16 270 16C250 16 231 21 213 29L149 63C125 74 106 93 94 117L62 181C50 205 45 231 50 257L61 329C65 355 77 378 96 397L147 448C166 467 189 479 215 483L287 494C293 496 300 496 306 496C326 496 345 491 363 483L427 450C451 438 470 419 482 395L514 331C526 307 531 281 526 255ZM486 316L453 381C444 398 430 412 413 421L348 454C335 461 321 464 306 464C301 464 297 464 292 463L220 452C201 448 183 440 170 426L118 374C104 361 96 343 92 324L81 252C78 233 81 213 90 196L123 131C132 114 146 100 163 91L228 58C241 51 255 48 270 48C275 48 279 48 284 49L356 60C375 64 393 72 406 86L458 138C472 151 480 169 484 188L495 260C498 279 495 299 486 316Z"]
  };
  var faCookieBite = {
    prefix: 'fal',
    iconName: 'cookie-bite',
    icon: [512, 512, [], "f564", "M184 192C184 179 173 168 160 168S136 179 136 192S147 216 160 216S184 205 184 192ZM288 232C275 232 264 243 264 256S275 280 288 280S312 269 312 256S301 232 288 232ZM192 328C179 328 168 339 168 352S179 376 192 376S216 365 216 352S205 328 192 328ZM352 328C339 328 328 339 328 352S339 376 352 376S376 365 376 352S365 328 352 328ZM495 256C429 255 376 202 376 136C310 136 257 83 256 17C250 16 244 16 237 16C218 16 199 21 181 29L117 62C93 74 74 93 62 117L30 181C18 205 13 231 18 257L29 329C33 355 45 378 64 397L115 448C134 467 157 479 183 483L255 494C261 496 268 496 275 496C294 496 313 491 331 483L395 450C419 438 438 419 450 395L483 331C494 308 498 281 495 256ZM454 316L421 381C412 398 398 412 381 421L316 454C303 461 289 464 275 464C270 464 265 464 260 463L188 452C169 449 151 440 138 426L86 374C72 361 64 343 60 324L49 252C46 233 49 213 58 196L91 131C100 114 114 100 131 91L196 58C206 53 217 50 228 49C241 107 288 154 347 165C358 224 405 271 463 284C462 295 459 306 454 316Z"]
  };
  var faCopy = {
    prefix: 'fal',
    iconName: 'copy',
    icon: [512, 512, [], "f0c5", "M272 416C263 416 256 423 256 432V448C256 466 242 480 224 480H64C46 480 32 466 32 448V192C32 174 46 160 64 160H176C185 160 192 153 192 144C192 135 185 128 176 128H64C29 128 0 157 0 192V448C0 483 29 512 64 512H224C259 512 288 483 288 448V432C288 423 281 416 272 416ZM503 87L425 9C419 3 411 0 403 0H288C253 0 224 29 224 64V320C224 355 253 384 288 384H448C483 384 512 355 512 320V109C512 101 509 93 503 87ZM416 45L467 96H416V45ZM480 320C480 338 466 352 448 352H288C270 352 256 338 256 320V64C256 46 270 32 288 32H384V96C384 114 398 128 416 128H480V320Z"]
  };
  var faCopyright = {
    prefix: 'fal',
    iconName: 'copyright',
    icon: [512, 512, [], "f1f9", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM324 188C330 194 340 194 346 188S353 172 346 166C298 117 214 117 166 166C141 190 128 222 128 256S141 322 166 346C190 371 222 384 256 384S322 371 346 346C353 340 353 330 346 324S330 318 324 324C288 360 224 360 188 324C170 306 160 282 160 256S170 206 188 188C224 152 288 152 324 188Z"]
  };
  var faCorn = {
    prefix: 'fal',
    iconName: 'corn',
    icon: [512, 512, [], "f6c7", "M446 0C433 0 421 4 410 11C395 6 382 9 376 11C365 14 356 20 348 27C342 27 330 27 317 32C307 37 299 43 292 51C282 52 272 55 263 60C254 65 247 72 242 79C250 91 257 103 262 114C262 114 262 114 262 114C263 104 269 94 279 88C295 79 310 86 310 87C312 76 319 66 330 62C343 56 355 60 361 64C365 54 373 45 384 42C387 41 403 37 417 50C422 39 434 32 446 32C447 32 480 31 480 70C479 83 472 94 461 99C469 107 472 119 469 131C465 142 457 150 446 154C452 163 453 175 449 185C444 196 434 203 423 205C428 214 428 226 422 236C418 244 410 249 402 251C412 257 423 263 434 270C440 265 446 259 450 252C455 243 458 233 459 223C467 217 473 208 478 198C482 189 484 178 483 167C491 160 496 151 500 140C503 129 503 117 500 106C528 65 505 0 446 0ZM447 322C377 252 288 256 286 256C275 256 264 257 254 258C255 248 256 237 256 226C256 223 261 137 190 65L168 44C159 35 144 40 141 52L118 171L37 251C17 272 3 298 0 326C-3 361 9 394 34 419L96 481L97 481C124 506 161 517 200 509C223 505 243 492 260 476L341 394L460 371C472 368 477 353 468 344L447 322ZM57 277L147 187L167 88C215 136 232 203 219 265C184 276 151 295 124 322L54 393C24 360 25 309 57 277ZM325 365L235 455C218 472 197 480 175 480C154 480 132 472 116 455L76 416L147 345C185 307 235 288 286 288S386 307 424 345L325 365Z"]
  };
  var faCouch = {
    prefix: 'fal',
    iconName: 'couch',
    icon: [640, 512, [], "f4b8", "M576 224C541 224 512 253 512 288H128C128 253 99 224 64 224S0 253 0 288V448C0 466 14 480 32 480H96C114 480 128 466 128 448H512C512 466 526 480 544 480H608C626 480 640 466 640 448V288C640 253 611 224 576 224ZM96 448H32V288C32 270 46 256 64 256S96 270 96 288V448ZM512 416H128V320H512V416ZM608 448H544V288C544 270 558 256 576 256S608 270 608 288V448ZM80 192C89 192 96 185 96 176V144C96 100 132 64 176 64H464C508 64 544 100 544 144V176C544 185 551 192 560 192S576 185 576 176V144C576 82 526 32 464 32H176C114 32 64 82 64 144V176C64 185 71 192 80 192Z"]
  };
  var faCow = {
    prefix: 'fal',
    iconName: 'cow',
    icon: [640, 512, [], "f6c8", "M634 280L624 266V211C624 191 608 175 589 175C580 175 575 178 565 183L509 104C491 79 462 64 431 64H112C68 64 32 100 32 144V233C13 244 0 264 0 288V320C35 320 64 291 64 256V144C64 120 82 100 105 97C99 106 96 117 96 128V416C96 434 110 448 128 448H176C194 448 208 434 208 416V364C215 367 224 369 232 371V392C232 401 239 408 248 408C257 408 264 401 264 392V375C267 375 269 376 272 376S277 375 280 375V392C280 401 287 408 296 408C305 408 312 401 312 392V371C320 369 329 367 336 364V416C336 434 350 448 368 448H416C434 448 448 434 448 416V272L480 288V330C480 342 483 354 490 365L526 420C537 437 557 448 578 448H578C612 448 640 420 640 386V298C640 292 638 285 634 280ZM213 96H331C349 96 358 116 347 129C307 175 289 176 272 176H271C254 176 237 176 197 129C186 116 195 96 213 96ZM209 330C212 298 239 272 272 272S332 298 335 330C321 336 278 358 209 330ZM608 386C608 402 594 416 578 416C568 416 558 411 553 402L517 347C514 342 512 336 512 330V278C512 272 509 266 503 264L439 232C429 226 416 234 416 246V416H368V336C368 305 342 240 272 240C201 240 176 305 176 336V416H128V128C128 110 142 96 160 96H164C157 114 160 135 173 150C215 199 240 208 271 208C304 208 329 199 371 150C384 135 387 114 380 96H431C451 96 471 106 483 122L561 233C566 215 580 208 584 208C588 208 592 211 592 216V276L608 298V386ZM568 304C559 304 552 311 552 320S559 336 568 336S584 329 584 320S577 304 568 304Z"]
  };
  var faCowbell = {
    prefix: 'fal',
    iconName: 'cowbell',
    icon: [448, 512, [], "f8b3", "M447 456L394 136C390 113 370 96 347 96H320V48C320 22 298 0 272 0H176C150 0 128 22 128 48V96H101C78 96 58 113 54 136L1 456C-4 485 18 512 48 512H400C429 512 452 486 447 456ZM160 48C160 39 167 32 176 32H272C281 32 288 39 288 48V96H160V48ZM400 480H48C35 480 31 468 32 461L86 141C87 134 94 128 101 128H347C355 128 361 134 362 141L416 461C417 468 413 480 400 480Z"]
  };
  var faCowbellCirclePlus = {
    prefix: 'fal',
    iconName: 'cowbell-circle-plus',
    icon: [640, 512, [], "f8b4", "M480 192C392 192 320 264 320 352S392 512 480 512S640 440 640 352S568 192 480 192ZM480 480C409 480 352 423 352 352S409 224 480 224S608 281 608 352S551 480 480 480ZM342 485C339 482 335 480 330 480H48C35 480 31 468 32 461L86 141C87 134 94 128 101 128H347C354 128 361 134 362 141L367 171C369 182 381 187 390 182C390 182 391 182 391 182C397 179 400 172 399 166L394 136C390 113 370 96 347 96H320V48C320 22 298 0 272 0H176C150 0 128 22 128 48V96H101C78 96 58 113 54 136L1 456C-4 485 18 512 48 512H331C345 512 352 495 342 485C342 485 342 485 342 485ZM160 48C160 39 167 32 176 32H272C281 32 288 39 288 48V96H160V48ZM544 336H496V288C496 279 489 272 480 272S464 279 464 288V336H416C407 336 400 343 400 352S407 368 416 368H464V416C464 425 471 432 480 432S496 425 496 416V368H544C553 368 560 361 560 352S553 336 544 336Z"]
  };
  var faCreditCard = {
    prefix: 'fal',
    iconName: 'credit-card',
    icon: [576, 512, [], "f09d", "M240 384H368C377 384 384 377 384 368C384 359 377 352 368 352H240C231 352 224 359 224 368C224 377 231 384 240 384ZM112 384H176C185 384 192 377 192 368C192 359 185 352 176 352H112C103 352 96 359 96 368C96 377 103 384 112 384ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V256H544V416ZM544 224H32V160H544V224ZM544 128H32V96C32 78 46 64 64 64H512C530 64 544 78 544 96V128Z"]
  };
  var faCreditCardBlank = {
    prefix: 'fal',
    iconName: 'credit-card-blank',
    icon: [576, 512, [], "f389", "M176 352H112C103 352 96 359 96 368C96 377 103 384 112 384H176C185 384 192 377 192 368C192 359 185 352 176 352ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H512C530 64 544 78 544 96V416ZM368 352H240C231 352 224 359 224 368C224 377 231 384 240 384H368C377 384 384 377 384 368C384 359 377 352 368 352Z"]
  };
  var faCreditCardFront = {
    prefix: 'fal',
    iconName: 'credit-card-front',
    icon: [576, 512, [], "f38a", "M176 352H112C103 352 96 359 96 368C96 377 103 384 112 384H176C185 384 192 377 192 368C192 359 185 352 176 352ZM176 288H112C103 288 96 295 96 304C96 313 103 320 112 320H176C185 320 192 313 192 304C192 295 185 288 176 288ZM368 352H240C231 352 224 359 224 368C224 377 231 384 240 384H368C377 384 384 377 384 368C384 359 377 352 368 352ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H512C530 64 544 78 544 96V416ZM496 96H368C359 96 352 103 352 112V208C352 217 359 224 368 224H496C505 224 512 217 512 208V112C512 103 505 96 496 96ZM480 192H384V128H480V192ZM464 288H432C423 288 416 295 416 304C416 313 423 320 432 320H464C473 320 480 313 480 304C480 295 473 288 464 288ZM368 288H240C231 288 224 295 224 304C224 313 231 320 240 320H368C377 320 384 313 384 304C384 295 377 288 368 288Z"]
  };
  var faCricketBatBall = {
    prefix: 'fal',
    iconName: 'cricket-bat-ball',
    icon: [512, 512, [], "f449", "M402 202L367 168L507 27C514 21 514 11 507 5S491 -2 485 5L344 145L310 110C300 101 288 96 275 96C263 96 251 101 241 110C224 127 198 153 12 340C3 348 -1 359 0 370C12 499 139 512 145 512C155 512 165 508 172 500L402 271C421 252 421 221 402 202ZM150 478C148 479 146 480 146 480C145 480 42 472 32 367C32 366 33 364 34 362L192 205V288C192 306 206 320 224 320H307L150 478ZM379 248L339 288H224V173L257 140L264 133C267 130 271 128 275 128C280 128 284 130 287 133L379 225C383 229 384 234 384 236C384 241 382 245 379 248ZM432 352C388 352 352 388 352 432S388 512 432 512C476 512 512 476 512 432S476 352 432 352ZM432 480C405 480 384 458 384 432S405 384 432 384S480 405 480 432S458 480 432 480Z"]
  };
  var faCroissant = {
    prefix: 'fal',
    iconName: 'croissant',
    icon: [512, 512, [], "f7f6", "M508 176C497 145 478 119 456 98C456 94 456 89 455 85C453 70 445 55 432 45C394 16 347 0 298 0C279 0 259 3 240 8C230 3 215 -3 196 2C100 26 26 100 2 196C-2 212 0 228 8 241C-9 307 3 377 45 432C55 445 69 453 85 455C94 457 94 455 97 455C118 478 145 496 176 508C218 524 263 488 255 443L241 356C249 347 256 336 258 324C268 322 277 316 284 309L309 284C316 277 322 268 324 258C336 256 347 249 356 241L443 255C488 263 524 218 508 176ZM298 32C340 32 380 46 413 71C427 81 426 100 418 110L334 217C332 219 325 227 324 224L268 42C267 40 266 38 265 36C276 33 287 32 298 32ZM35 265C37 266 40 267 42 268L224 324C227 325 219 333 217 334L110 418C96 429 79 423 71 413C39 371 26 317 35 265ZM187 478C166 470 147 458 130 443L212 379L224 448C227 469 207 486 187 478ZM287 262L262 286C258 290 247 298 234 294L52 238C38 233 29 218 33 204C54 120 120 54 204 33C218 29 233 38 238 52L294 234C296 244 294 254 287 262ZM448 224L379 212L443 130C458 147 470 166 478 187C486 207 469 227 448 224H448Z"]
  };
  var faCrop = {
    prefix: 'fal',
    iconName: 'crop',
    icon: [512, 512, [], "f125", "M512 400C512 409 505 416 496 416H416V496C416 505 409 512 400 512S384 505 384 496V151L151 384H336C345 384 352 391 352 400S345 416 336 416H112C103 416 96 409 96 400V128H16C7 128 0 121 0 112S7 96 16 96H96V16C96 7 103 0 112 0S128 7 128 16V361L361 128H176C167 128 160 121 160 112S167 96 176 96H393L485 5C491 -2 501 -2 507 5S514 21 507 27L416 119V384H496C505 384 512 391 512 400Z"]
  };
  var faCropSimple = {
    prefix: 'fal',
    iconName: 'crop-simple',
    icon: [512, 512, [], "f565", "M496 384H416V112C416 103 409 96 400 96H176C167 96 160 103 160 112S167 128 176 128H384V496C384 505 391 512 400 512S416 505 416 496V416H496C505 416 512 409 512 400S505 384 496 384ZM336 384H128V16C128 7 121 0 112 0S96 7 96 16V96H16C7 96 0 103 0 112S7 128 16 128H96V400C96 409 103 416 112 416H336C345 416 352 409 352 400S345 384 336 384Z"]
  };
  var faCross = {
    prefix: 'fal',
    iconName: 'cross',
    icon: [384, 512, [], "f654", "M352 128H256V32C256 14 242 0 224 0H160C142 0 128 14 128 32V128H32C14 128 0 142 0 160V224C0 242 14 256 32 256H128V480C128 498 142 512 160 512H224C242 512 256 498 256 480V256H352C370 256 384 242 384 224V160C384 142 370 128 352 128ZM352 224H240C231 224 224 231 224 240V480H160V240C160 231 153 224 144 224H32V160H144C153 160 160 153 160 144V32H224V144C224 153 231 160 240 160H352V224Z"]
  };
  var faCrosshairs = {
    prefix: 'fal',
    iconName: 'crosshairs',
    icon: [512, 512, [], "f05b", "M496 240H463C455 138 374 57 272 49V16C272 7 265 0 256 0S240 7 240 16V49C138 57 57 138 49 240H16C7 240 0 247 0 256S7 272 16 272H49C57 374 138 455 240 463V496C240 505 247 512 256 512S272 505 272 496V463C374 455 455 374 463 272H496C505 272 512 265 512 256S505 240 496 240ZM400 272H431C424 356 356 424 272 431V400C272 391 265 384 256 384S240 391 240 400V431C156 424 88 356 81 272H112C121 272 128 265 128 256S121 240 112 240H81C88 156 156 88 240 81V112C240 121 247 128 256 128S272 121 272 112V81C356 88 424 156 431 240H400C391 240 384 247 384 256S391 272 400 272ZM256 232C243 232 232 243 232 256S243 280 256 280S280 269 280 256S269 232 256 232Z"]
  };
  var faCrow = {
    prefix: 'fal',
    iconName: 'crow',
    icon: [640, 512, [], "f520", "M416 72C403 72 392 83 392 96S403 120 416 120S440 109 440 96S429 72 416 72ZM520 64H506C492 26 456 -2 412 0C360 2 320 47 320 99V136L11 394C4 399 0 408 0 418C0 435 14 448 29 448C33 448 37 447 41 445L168 384H278L322 502C325 510 334 514 342 511L342 511C350 508 354 499 351 491L311 384H331C345 384 359 382 372 379L418 502C421 510 430 514 438 511C446 508 450 499 447 491L401 369C466 340 512 272 512 192V161L640 144C640 100 586 64 520 64ZM480 192C480 280 413 352 331 352H274L320 339C368 325 408 292 430 247C434 239 431 230 423 226C415 222 406 225 402 233C383 270 350 297 311 308C119 363 195 336 44 408L352 150V96C352 61 381 32 416 32S480 61 480 96V192ZM512 129V96H520C551 96 577 106 593 118L512 129Z"]
  };
  var faCrown = {
    prefix: 'fal',
    iconName: 'crown',
    icon: [576, 512, [], "f521", "M544 96C526 96 512 110 512 128C512 136 515 142 519 148L415 231C409 236 402 238 395 238C383 238 372 232 366 221L302 92C313 87 320 77 320 64C320 46 306 32 288 32S256 46 256 64C256 77 263 87 274 92L210 221C204 232 193 238 181 238C174 238 167 236 161 231L57 148C61 142 64 136 64 128C64 110 50 96 32 96S0 110 0 128C0 146 14 160 32 160C34 160 36 159 38 159L86 427C92 458 118 480 149 480H427C458 480 484 458 490 427L538 159C540 159 542 160 544 160C562 160 576 146 576 128C576 110 562 96 544 96ZM458 422C455 437 442 448 427 448H149C134 448 121 437 118 422L79 206L141 256C152 265 167 270 181 270C205 270 227 257 238 235L288 136L338 235C349 257 371 270 395 270C409 270 424 265 435 256L497 206L458 422Z"]
  };
  var faCrutch = {
    prefix: 'fal',
    iconName: 'crutch',
    icon: [512, 512, [], "f7f7", "M507 197L315 5C309 -2 299 -2 293 5S287 21 293 27L485 219C488 222 492 224 496 224S504 222 507 219C514 213 514 203 507 197ZM405 213L336 281L231 176L299 107C306 101 306 91 299 85S283 78 277 85L162 199C151 210 144 224 141 240L113 376L5 485C-2 491 -2 501 5 507C8 510 12 512 16 512S24 510 27 507L136 399L272 371C288 368 302 361 313 350L427 235C434 229 434 219 427 213S411 206 405 213ZM290 327C284 334 275 338 266 340L148 364L172 246C174 237 178 228 185 222L208 199L313 304L290 327Z"]
  };
  var faCrutches = {
    prefix: 'fal',
    iconName: 'crutches',
    icon: [640, 512, [], "f7f8", "M219 5C213 -2 203 -2 197 5L5 197C-2 203 -2 213 5 219C8 222 12 224 16 224S24 222 27 219L219 27C226 21 226 11 219 5ZM213 85C206 91 206 101 213 107L261 155C264 158 268 160 272 160S280 158 283 155C290 149 290 139 283 133L235 85C229 78 219 78 213 85ZM208 352C212 352 216 350 219 347C226 341 226 331 219 325L107 213C101 206 91 206 85 213S78 229 85 235L197 347C200 350 204 352 208 352ZM427 405C421 398 411 398 405 405S398 421 405 427L485 507C488 510 492 512 496 512S504 510 507 507C514 501 514 491 507 485L427 405ZM635 197L443 5C437 -2 427 -2 421 5S414 21 421 27L613 219C616 222 620 224 624 224S632 222 635 219C642 213 642 203 635 197ZM533 213L464 281L359 176L427 107C434 101 434 91 427 85S411 78 405 85L290 199C279 210 272 224 268 240L241 376L133 485C126 491 126 501 133 507C136 510 140 512 144 512S152 510 155 507L264 399L400 371C416 368 430 361 441 350L555 235C562 229 562 219 555 213S539 206 533 213ZM418 327C412 334 403 338 394 340L276 364L300 246C302 237 306 228 313 222L336 199L441 304L418 327Z"]
  };
  var faCruzeiroSign = {
    prefix: 'fal',
    iconName: 'cruzeiro-sign',
    icon: [384, 512, [], "e110", "M379 392C385 398 385 408 379 414C337 457 281 480 222 480C222 480 222 480 222 480C163 480 107 457 65 414C-22 327 -22 185 65 98C107 55 163 32 222 32C281 32 337 55 379 98C385 104 385 114 379 120C373 127 363 126 356 120C321 84 273 64 222 64C171 64 124 84 88 120C13 195 13 317 88 392C108 413 133 428 160 437V240C160 231 167 224 176 224S192 231 192 240V256C205 246 222 240 240 240C272 240 301 259 314 289C317 297 313 306 305 310C297 313 288 310 284 301C277 284 259 272 240 272C213 272 192 294 192 320V445C202 447 212 448 222 448C273 448 321 428 356 392C363 386 373 385 379 392Z"]
  };
  var faCube = {
    prefix: 'fal',
    iconName: 'cube',
    icon: [512, 512, [], "f1b2", "M491 85L278 4C271 1 264 0 256 0S241 1 234 4L21 85C8 90 0 102 0 116V396C0 410 8 422 21 427L234 508C241 511 248 512 256 512S271 511 278 508L491 427C504 422 512 410 512 396V116C512 102 504 90 491 85ZM245 34C248 33 252 32 256 32S264 33 267 34L466 110L256 191L45 110L245 34ZM32 396L32 139L240 219V476L32 396ZM272 476V219L480 139L480 397L272 476Z"]
  };
  var faCubes = {
    prefix: 'fal',
    iconName: 'cubes',
    icon: [576, 512, [], "f1b3", "M556 258L440 213V78C440 65 432 54 420 49L300 2C292 -1 284 -1 276 2L156 49C144 54 136 65 136 78V213L20 258C8 263 0 274 0 287V434C0 447 8 458 20 463L141 510C144 511 148 512 152 512S160 511 163 510L288 461L413 510C416 511 420 512 424 512S432 511 435 510L556 463C568 458 576 447 576 434V287C576 274 568 263 556 258ZM152 241L244 277L152 313L60 277L152 241ZM168 341L272 300V433L168 474V341ZM304 300L408 341V474L304 433V300ZM424 313L332 277L424 241L516 277L424 313ZM409 213L304 253V132L408 91L409 213ZM288 32L380 67L288 103L196 68L288 32ZM272 132V253L168 213L167 91L272 132ZM31 300L136 341V474L32 434L31 300ZM440 474V341L544 300L545 433L440 474Z"]
  };
  var faCupTogo = {
    prefix: 'fal',
    iconName: 'cup-togo',
    icon: [448, 512, [], "f6c5", "M432 96H414L393 33C387 13 368 0 348 0H100C80 0 61 13 55 33L34 96H16C7 96 0 103 0 112S7 128 16 128H432C441 128 448 121 448 112S441 96 432 96ZM68 96L85 43C87 36 94 32 100 32H348C355 32 361 36 363 43L380 96H68ZM386 160C377 159 369 166 368 174L363 224H85L80 174C79 166 71 159 62 160C54 161 47 169 48 178L77 469C80 493 100 512 125 512H323C348 512 368 493 371 469L400 178C401 169 394 161 386 160ZM339 466C338 474 331 480 323 480H125C117 480 110 474 109 466L104 416H344L339 466ZM347 384H101L88 256H360L347 384Z"]
  };
  var faCurlingStone = {
    prefix: 'fal',
    iconName: 'curling-stone',
    icon: [576, 512, [], "f44a", "M480 224V208C480 182 458 160 432 160H192V112C192 86 214 64 240 64H400C409 64 416 57 416 48S409 32 400 32H240C196 32 160 68 160 112V160H144C118 160 96 182 96 208V224C43 224 0 267 0 320V384C0 437 43 480 96 480H480C533 480 576 437 576 384V320C576 267 533 224 480 224ZM128 208C128 199 135 192 144 192H432C441 192 448 199 448 208V224H128V208ZM96 256H480C515 256 544 285 544 320V336H32V320C32 285 61 256 96 256ZM480 448H96C61 448 32 419 32 384V368H544V384C544 419 515 448 480 448Z"]
  };
  var faD = {
    prefix: 'fal',
    iconName: 'd',
    icon: [384, 512, [], "e111", "M160 480H16C7 480 0 473 0 464V48C0 39 7 32 16 32H160C284 32 384 133 384 256S284 480 160 480ZM32 448H160C266 448 352 362 352 256S266 64 160 64H32V448Z"]
  };
  var faDagger = {
    prefix: 'fal',
    iconName: 'dagger',
    icon: [384, 512, [], "f6cb", "M320 128H208V16C208 7 201 0 192 0S176 7 176 16V128H64C29 128 0 157 0 192V208C0 217 7 224 16 224S32 217 32 208V192C32 174 46 160 64 160H112V400C112 403 113 406 115 409L179 505C182 509 187 512 192 512S202 509 205 505L269 409C271 406 272 403 272 400V160H320C338 160 352 174 352 192V208C352 217 359 224 368 224S384 217 384 208V192C384 157 355 128 320 128ZM240 395L192 467L144 395V160H240V395Z"]
  };
  var faDatabase = {
    prefix: 'fal',
    iconName: 'database',
    icon: [448, 512, [], "f1c0", "M224 0C100 0 0 36 0 80V432C0 476 100 512 224 512S448 476 448 432V80C448 36 348 0 224 0ZM224 32C347 32 412 67 416 80L416 160C365 180 297 192 224 192C151 192 83 180 32 160L32 81C36 67 101 32 224 32ZM416 193L416 320C365 340 297 352 224 352C151 352 83 340 32 320L32 193C86 213 153 224 224 224C295 224 362 213 416 193ZM224 480C101 480 36 445 32 432L32 353C86 373 153 384 224 384C295 384 362 373 416 353L416 431C412 445 347 480 224 480Z"]
  };
  var faDeer = {
    prefix: 'fal',
    iconName: 'deer',
    icon: [512, 512, [], "f78e", "M400 160C391 160 384 167 384 176S391 192 400 192S416 185 416 176S409 160 400 160ZM489 133L397 107L408 102C420 96 431 86 439 74L452 54C457 47 455 37 448 32C441 27 431 29 426 36L412 57C408 64 401 69 394 73L351 95L317 85L326 75C332 66 336 56 336 45V16C336 7 329 0 320 0S304 7 304 16V45C304 48 303 52 301 55L284 76L268 71C261 69 256 63 256 56V16C256 7 249 0 240 0S224 7 224 16V56C224 77 238 96 259 102L338 124L304 192H96C43 192 0 235 0 288V288C0 306 14 320 32 320H32V347L20 379C15 391 15 405 18 417L37 479C44 498 62 512 83 512H99C130 512 153 483 145 452L133 404L153 352H256V464C256 490 278 512 304 512H336C362 512 384 490 384 464V320L416 256H464C490 256 512 234 512 208V164C512 150 502 137 489 133ZM480 208H480C480 217 473 224 464 224H396L352 312V464C352 473 345 480 336 480H304C295 480 288 473 288 464V320H130L100 402L112 459C116 469 108 480 97 480H83C76 480 70 475 68 469L49 409C47 403 48 396 50 391L64 353V288H32C32 253 61 224 96 224H324L358 157C364 143 380 136 395 140L468 161C475 163 480 169 480 176V208Z"]
  };
  var faDeerRudolph = {
    prefix: 'fal',
    iconName: 'deer-rudolph',
    icon: [576, 512, [], "f78f", "M400 160C391 160 384 167 384 176S391 192 400 192S416 185 416 176S409 160 400 160ZM512 96C494 96 480 110 480 128C480 129 481 130 481 131L397 108L408 102C420 96 431 86 439 74L452 54C457 47 455 37 448 32C441 27 431 29 426 36L412 57C408 64 401 69 394 73L351 95L317 85L326 75C332 66 336 56 336 45V16C336 7 329 0 320 0S304 7 304 16V45C304 48 303 52 301 55L284 76L268 71C261 69 256 63 256 56V16C256 7 249 0 240 0S224 7 224 16V56C224 77 238 96 259 102L338 124L304 192H96C43 192 0 235 0 288C0 306 14 320 32 320V347L20 379C15 391 15 405 18 417L37 478C44 498 62 512 83 512H99C130 512 153 483 145 452L133 404L153 352H256V464C256 490 278 512 304 512H336C362 512 384 490 384 464V320L416 256H464C490 256 512 234 512 208V164C512 163 511 161 511 160C512 160 512 160 512 160C530 160 544 146 544 128C544 110 530 96 512 96ZM480 208H480C480 217 473 224 464 224H396L352 312V464C352 473 345 480 336 480H304C295 480 288 473 288 464V320H130L100 402L112 459C116 469 108 480 97 480H83C76 480 70 475 68 469L49 409C47 403 48 396 50 391L64 353V288H32C32 253 61 224 96 224H324L358 157C364 143 380 136 395 140L468 161C475 163 480 169 480 176V208Z"]
  };
  var faDeleteLeft = {
    prefix: 'fal',
    iconName: 'delete-left',
    icon: [576, 512, [], "f55a", "M503 64H196C179 64 163 71 151 83L0 233C-13 246 -13 266 0 279L151 429C163 441 179 448 196 448H503C538 448 567 419 567 384V128C567 93 538 64 503 64ZM535 384C535 402 520 416 503 416H196C187 416 179 413 173 407L23 256L173 105C179 99 187 96 196 96H503C520 96 535 110 535 128V384ZM418 181C412 174 402 174 395 181L343 233L290 181C284 174 274 174 267 181S261 197 267 203L320 256L267 309C261 315 261 325 267 331C270 334 275 336 279 336S287 334 290 331L343 279L395 331C398 334 403 336 407 336S415 334 418 331C424 325 424 315 418 309L365 256L418 203C424 197 424 187 418 181Z"]
  };
  var faDeleteRight = {
    prefix: 'fal',
    iconName: 'delete-right',
    icon: [576, 512, [], "e112", "M0 128V384C0 419 29 448 64 448H371C388 448 404 441 416 429L567 279C579 266 579 246 567 233L416 83C404 71 388 64 371 64H64C29 64 0 93 0 128ZM32 128C32 110 46 96 64 96H371C379 96 387 99 393 105L544 256L393 407C387 413 379 416 371 416H64C46 416 32 402 32 384V128ZM149 203L201 256L149 309C142 315 142 325 149 331C152 334 156 336 160 336S168 334 171 331L224 279L277 331C280 334 284 336 288 336S296 334 299 331C306 325 306 315 299 309L247 256L299 203C306 197 306 187 299 181S283 174 277 181L224 233L171 181C165 174 155 174 149 181S142 197 149 203Z"]
  };
  var faDemocrat = {
    prefix: 'fal',
    iconName: 'democrat',
    icon: [640, 512, [], "f747", "M639 251C618 187 558 144 491 144H270L225 97C236 72 234 42 218 19C211 7 198 0 184 0C174 0 163 5 156 12L142 26L127 11C119 4 110 0 99 0C86 0 74 7 66 18C51 42 51 73 65 96L12 167C-2 185 -4 209 6 230L19 255C29 275 50 288 73 288H100C115 288 129 283 140 273L160 326V452C160 485 187 512 220 512H244C277 512 304 485 304 452V416H432V452C432 485 459 512 492 512H516C549 512 576 485 576 452V312L576 240C576 227 574 215 569 204C587 219 601 238 609 261C611 268 617 272 624 272C626 272 627 272 629 271C637 268 642 259 639 251ZM544 452C544 467 531 480 516 480H492C477 480 464 467 464 452V384H272V452C272 467 259 480 244 480H220C205 480 192 467 192 452V352H544V452ZM544 312V320H192L153 218L119 248C114 253 107 256 100 256H73C62 256 52 250 48 241L35 216C30 206 31 195 38 186L103 99C104 97 107 96 109 95C105 93 102 91 99 88C84 74 83 51 93 35C95 33 97 32 99 32C101 32 103 33 104 34L142 72L178 35C180 33 182 32 184 32C187 32 190 34 192 36C205 56 203 83 185 101L256 176H480C515 176 544 205 544 240L544 312ZM288 232H272V216C272 207 265 200 256 200S240 207 240 216V232H224C215 232 208 239 208 248S215 264 224 264H240V280C240 289 247 296 256 296S272 289 272 280V264H288C297 264 304 257 304 248S297 232 288 232ZM400 232H384V216C384 207 377 200 368 200C359 200 352 207 352 216V232H336C327 232 320 239 320 248S327 264 336 264H352V280C352 289 359 296 368 296C377 296 384 289 384 280V264H400C409 264 416 257 416 248S409 232 400 232ZM512 232H496V216C496 207 489 200 480 200S464 207 464 216V232H448C439 232 432 239 432 248S439 264 448 264H464V280C464 289 471 296 480 296S496 289 496 280V264H512C521 264 528 257 528 248S521 232 512 232Z"]
  };
  var faDesktop = {
    prefix: 'fal',
    iconName: 'desktop',
    icon: [576, 512, [], "f108", "M512 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H214L194 480H144C135 480 128 487 128 496S135 512 144 512H432C441 512 448 505 448 496S441 480 432 480H382L362 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM228 480L247 416H329L348 480H228ZM544 352C544 370 530 384 512 384H64C46 384 32 370 32 352V288H544V352ZM544 256H32V64C32 46 46 32 64 32H512C530 32 544 46 544 64V256Z"]
  };
  var faDharmachakra = {
    prefix: 'fal',
    iconName: 'dharmachakra',
    icon: [512, 512, [], "f655", "M496 240H463C460 195 442 153 414 121L437 98C443 91 443 81 437 75S421 69 414 75L391 98C359 70 317 52 272 49V16C272 7 265 0 256 0S240 7 240 16V49C195 52 153 70 121 98L98 75C91 69 81 69 75 75S69 91 75 98L98 121C70 153 52 195 49 240H16C7 240 0 247 0 256S7 272 16 272H49C52 317 70 359 98 391L75 414C69 421 69 431 75 437C78 440 82 442 86 442S94 440 98 437L121 414C153 442 195 460 240 463V496C240 505 247 512 256 512S272 505 272 496V463C317 460 359 442 391 414L414 437C418 440 422 442 426 442S434 440 437 437C443 431 443 421 437 414L414 391C442 359 460 317 463 272H496C505 272 512 265 512 256S505 240 496 240ZM431 240H350C348 225 342 212 334 201L391 143C413 170 428 203 431 240ZM256 320C221 320 192 291 192 256S221 192 256 192S320 221 320 256S291 320 256 320ZM369 121L311 178C300 170 287 164 272 162V81C309 84 342 99 369 121ZM240 81V162C225 164 212 170 201 178L143 121C170 99 203 84 240 81ZM121 143L178 201C170 212 164 225 162 240H81C84 203 99 170 121 143ZM81 272H162C164 287 170 300 178 311L121 369C99 342 84 309 81 272ZM143 391L201 334C212 342 225 348 240 350V431C203 428 170 413 143 391ZM272 431V350C287 348 300 342 311 334L369 391C342 413 309 428 272 431ZM391 369L334 311C342 300 348 287 350 272H431C428 309 413 342 391 369Z"]
  };
  var faDiagramStankey = {
    prefix: 'fal',
    iconName: 'diagram-stankey',
    icon: [640, 512, [], "e113", "M48 224H288C294 224 299 221 302 216L388 72C391 67 397 64 402 64H592C601 64 608 57 608 48S601 32 592 32H402C385 32 370 41 361 55L279 192H48C39 192 32 199 32 208S39 224 48 224ZM608 304C608 295 601 288 592 288H48C39 288 32 295 32 304S39 320 48 320H199L281 457C290 471 305 480 322 480H592C601 480 608 473 608 464S601 448 592 448H322C317 448 311 445 308 440L236 320H592C601 320 608 313 608 304Z"]
  };
  var faDiagramVenn = {
    prefix: 'fal',
    iconName: 'diagram-venn',
    icon: [640, 512, [], "e114", "M416 32C382 32 349 40 320 54C291 40 258 32 224 32C100 32 0 132 0 256S100 480 224 480C258 480 291 472 320 458C349 472 382 480 416 480C539 480 640 380 640 256S539 32 416 32ZM390 160H250C267 131 291 107 320 90C349 107 373 131 390 160ZM405 320H235C230 305 226 289 225 272H415C414 289 410 305 405 320ZM415 240H225C226 223 230 207 235 192H405C410 207 414 223 415 240ZM224 448C118 448 32 362 32 256S118 64 224 64C246 64 266 68 286 74C229 115 192 181 192 256S229 397 286 438C266 444 246 448 224 448ZM250 352H390C373 381 349 405 320 422C291 405 267 381 250 352ZM416 448C394 448 374 444 354 438C411 397 448 331 448 256S411 115 354 74C374 68 394 64 416 64C522 64 608 150 608 256S522 448 416 448Z"]
  };
  var faDial = {
    prefix: 'fal',
    iconName: 'dial',
    icon: [576, 512, [], "e115", "M32 256C14 256 0 270 0 288C0 306 14 320 32 320S64 306 64 288C64 270 50 256 32 256ZM84 446C72 459 72 479 84 492C97 504 117 504 130 492C142 479 142 459 130 446C117 434 97 434 84 446ZM130 130C142 117 142 97 130 84C117 72 97 72 84 84C72 97 72 117 84 130C97 142 117 142 130 130ZM288 64C306 64 320 50 320 32C320 14 306 0 288 0C270 0 256 14 256 32C256 50 270 64 288 64ZM446 446C434 459 434 479 446 492C459 504 479 504 492 492C504 479 504 459 492 446S459 434 446 446ZM175 401C237 464 339 464 401 401S464 237 401 175C339 112 237 112 175 175S112 339 175 401ZM198 198C244 151 316 148 366 187L277 277C270 283 270 293 277 299C283 306 293 306 299 299L389 210C428 260 425 332 378 378C329 428 247 428 197 378C148 329 148 247 198 198ZM544 256C526 256 512 270 512 288C512 306 526 320 544 320S576 306 576 288C576 270 562 256 544 256ZM446 84C434 97 434 117 446 130C459 142 479 142 492 130C504 117 504 97 492 84C479 72 459 72 446 84Z"]
  };
  var faDialHigh = {
    prefix: 'fal',
    iconName: 'dial-high',
    icon: [576, 512, [], "e116", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM128 288A160 160 0 1 0 288 128A160 160 0 0 0 128 288ZM288 160A128 128 0 0 1 414 272H288A16 16 0 0 0 288 304H414A128 128 0 1 1 288 160ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84Z"]
  };
  var faDialLow = {
    prefix: 'fal',
    iconName: 'dial-low',
    icon: [576, 512, [], "e117", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM448 288A160 160 0 1 0 288 448A160 160 0 0 0 448 288ZM288 416A128 128 0 0 1 162 304H288A16 16 0 0 0 288 272H162A128 128 0 1 1 288 416ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84Z"]
  };
  var faDialMax = {
    prefix: 'fal',
    iconName: 'dial-max',
    icon: [576, 512, [], "e118", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM401 175A160 160 0 1 0 401 401A160 160 0 0 0 401 175ZM389 366L299 277A16 16 0 1 0 277 299L366 389A128 128 0 1 1 389 366Z"]
  };
  var faDialMed = {
    prefix: 'fal',
    iconName: 'dial-med',
    icon: [576, 512, [], "e119", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84ZM288 128A160 160 0 1 0 448 288A160 160 0 0 0 288 128ZM288 416A128 128 0 0 1 272 162V288A16 16 0 0 0 304 288V162A128 128 0 0 1 288 416ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446Z"]
  };
  var faDialMedLow = {
    prefix: 'fal',
    iconName: 'dial-med-low',
    icon: [576, 512, [], "e11a", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM401 401A160 160 0 1 0 175 401A160 160 0 0 0 401 401ZM198 378A128 128 0 0 1 187 210L277 299A16 16 0 0 0 299 277L210 187A128 128 0 1 1 198 378ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84Z"]
  };
  var faDialMin = {
    prefix: 'fal',
    iconName: 'dial-min',
    icon: [576, 512, [], "e11b", "M32 256A32 32 0 1 0 64 288A32 32 0 0 0 32 256ZM84 446A32 32 0 1 0 130 446A32 32 0 0 0 84 446ZM130 130A32 32 0 1 0 84 130A32 32 0 0 0 130 130ZM288 64A32 32 0 1 0 256 32A32 32 0 0 0 288 64ZM446 446A32 32 0 1 0 492 446A32 32 0 0 0 446 446ZM401 175A160 160 0 1 0 401 401A160 160 0 0 0 401 175ZM378 379A128 128 0 0 1 210 389L299 299A16 16 0 1 0 277 277L187 366A128 128 0 1 1 378 379ZM544 256A32 32 0 1 0 576 288A32 32 0 0 0 544 256ZM446 84A32 32 0 1 0 492 84A32 32 0 0 0 446 84Z"]
  };
  var faDiamond = {
    prefix: 'fal',
    iconName: 'diamond',
    icon: [512, 512, [], "f219", "M496 222L288 14C279 5 267 0 254 0C242 0 230 5 221 14L12 222C-6 241 -6 271 12 290L221 498C230 507 242 512 254 512C267 512 279 507 288 498L496 290C515 271 515 241 496 222ZM474 267L266 475C262 479 257 480 254 480C252 480 247 479 243 475L35 267C29 261 29 251 35 245L243 37C247 33 252 32 254 32C257 32 262 33 266 37L474 245C480 251 480 261 474 267Z"]
  };
  var faDiamondTurnRight = {
    prefix: 'fal',
    iconName: 'diamond-turn-right',
    icon: [512, 512, [], "f5eb", "M496 222L288 14C279 5 267 0 254 0S230 5 221 14L12 222C-6 241 -6 271 12 290L221 498C230 507 242 512 254 512S279 507 288 498L496 290C515 271 515 241 496 222ZM474 267L266 475C262 479 257 480 254 480S247 479 243 475L35 267C29 261 29 251 35 245L243 37C247 33 252 32 254 32S262 33 266 37L474 245C480 251 480 261 474 267ZM314 149C308 142 297 142 291 149S285 165 291 171L344 224H238C212 224 190 246 190 272V336C190 345 198 352 206 352S222 345 222 336V272C222 263 230 256 238 256H344L291 309C285 315 285 325 291 331C294 334 298 336 302 336S311 334 314 331L394 251C400 245 400 235 394 229L314 149Z"]
  };
  var faDice = {
    prefix: 'fal',
    iconName: 'dice',
    icon: [640, 512, [], "f522", "M224 296C211 296 200 307 200 320S211 344 224 344S248 333 248 320S237 296 224 296ZM128 200C115 200 104 211 104 224S115 248 128 248S152 237 152 224S141 200 128 200ZM224 200C211 200 200 211 200 224S211 248 224 248S248 237 248 224S237 200 224 200ZM480 376C493 376 504 365 504 352S493 328 480 328S456 339 456 352S467 376 480 376ZM224 104C211 104 200 115 200 128S211 152 224 152S248 141 248 128S237 104 224 104ZM576 192H473C477 202 479 213 479 224H576C594 224 608 238 608 256V448C608 466 594 480 576 480H384C366 480 352 466 352 448V391L320 423V448C320 483 349 512 384 512H576C611 512 640 483 640 448V256C640 221 611 192 576 192ZM320 200C307 200 296 211 296 224S307 248 320 248S344 237 344 224S333 200 320 200ZM448 224C448 207 441 191 429 178L270 19C257 7 241 0 224 0S191 7 178 19L19 178C7 191 0 207 0 224C0 241 7 257 19 270L178 429C191 441 207 448 224 448S257 441 270 429L429 270C441 257 448 241 448 224ZM406 247L247 406C241 412 233 416 224 416S207 412 201 406L42 247C36 241 32 233 32 224C32 215 36 207 42 201L201 42C207 36 215 32 224 32S241 36 247 42L406 201C412 207 416 215 416 224C416 233 412 241 406 247Z"]
  };
  var faDiceD10 = {
    prefix: 'fal',
    iconName: 'dice-d10',
    icon: [512, 512, [], "f6cd", "M504 261L280 11C274 3 265 0 256 0S239 3 232 11L8 261C-4 274 -2 295 11 306L235 504C241 509 249 512 256 512C264 512 271 509 277 504L501 306C514 295 516 274 504 261ZM256 298L180 247L256 70L332 247L256 298ZM149 240L48 265L221 71L149 240ZM363 240L291 71L465 265L363 240ZM49 298L157 270L240 326V466L49 298ZM272 466V326L355 270L463 298L272 466Z"]
  };
  var faDiceD12 = {
    prefix: 'fal',
    iconName: 'dice-d12',
    icon: [512, 512, [], "f6ce", "M505 178L458 83C451 71 441 61 429 54L334 7C325 2 315 0 305 0H207C197 0 187 2 178 7L83 54C71 61 61 71 54 83L7 178C2 187 0 197 0 207V305C0 315 2 325 7 334L54 429C61 441 71 451 83 458L178 505C187 510 197 512 207 512H305C315 512 325 510 334 505L429 458C441 451 451 441 458 429L505 334C510 325 512 315 512 305V207C512 197 510 187 505 178ZM476 191L380 300L272 246V140L429 97L476 191ZM309 480H203L148 328L256 274L364 328L309 480ZM199 32H312L395 73L256 111L117 73L199 32ZM83 97L240 140V246L132 300L36 191L83 97ZM32 313V235L114 328L162 461L88 424L32 313ZM424 424L350 461L398 328L480 235V313L424 424Z"]
  };
  var faDiceD20 = {
    prefix: 'fal',
    iconName: 'dice-d20',
    icon: [512, 512, [], "f6cf", "M464 116L272 4C262 -1 250 -1 240 4L48 116C38 122 32 133 32 144V368C32 379 38 390 48 396L240 508C250 513 262 513 272 508L464 396C474 390 480 379 480 368V144C480 133 474 122 464 116ZM256 58L351 176H161L256 58ZM157 208H355L256 370L157 208ZM225 380L88 363L132 230L225 380ZM380 230L424 363L287 380L380 230ZM387 170L295 55L433 135L387 170ZM125 170L79 135L218 54L125 170ZM109 198L64 333L64 164L109 198ZM240 414V471L117 399L240 414ZM396 399L272 471V414L396 399ZM403 198L448 164L448 333L403 198ZM256 480H256H256Z"]
  };
  var faDiceD4 = {
    prefix: 'fal',
    iconName: 'dice-d4',
    icon: [512, 512, [], "f6d0", "M505 289L281 12C274 4 265 0 256 0C247 0 237 4 231 12L7 289C-4 303 -2 324 13 334L237 506C242 510 249 512 256 512C263 512 270 510 275 506L499 334C514 324 516 303 505 289ZM32 309L240 52V468L32 309ZM272 468V52L480 309L272 468Z"]
  };
  var faDiceD6 = {
    prefix: 'fal',
    iconName: 'dice-d6',
    icon: [448, 512, [], "f6d1", "M432 116L240 4C230 -1 218 -1 208 4L16 116C6 122 0 133 0 144V368C0 379 6 390 16 396L208 508C218 513 230 513 240 508L432 396C442 390 448 379 448 368V144C448 133 442 122 432 116ZM224 32L400 135L224 238L48 135L224 32ZM32 163L208 265V471L32 368L32 163ZM240 471V265L416 162L416 368L240 471Z"]
  };
  var faDiceD8 = {
    prefix: 'fal',
    iconName: 'dice-d8',
    icon: [512, 512, [], "f6d2", "M502 232L280 10C273 3 265 0 256 0S239 3 232 10L10 232C-3 245 -3 267 10 280L232 502C239 509 247 512 256 512S273 509 280 502L502 280C515 267 515 245 502 232ZM240 465L61 286L240 363V465ZM240 328L44 244L240 47V328ZM272 465V363L451 286L272 465ZM272 328V47L468 244L272 328Z"]
  };
  var faDiceFive = {
    prefix: 'fal',
    iconName: 'dice-five',
    icon: [448, 512, [], "f523", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM128 136C115 136 104 147 104 160S115 184 128 184S152 173 152 160S141 136 128 136ZM224 232C211 232 200 243 200 256C200 269 211 280 224 280S248 269 248 256C248 243 237 232 224 232ZM128 328C115 328 104 339 104 352S115 376 128 376S152 365 152 352S141 328 128 328ZM320 136C307 136 296 147 296 160S307 184 320 184S344 173 344 160S333 136 320 136ZM320 328C307 328 296 339 296 352S307 376 320 376S344 365 344 352S333 328 320 328Z"]
  };
  var faDiceFour = {
    prefix: 'fal',
    iconName: 'dice-four',
    icon: [448, 512, [], "f524", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM128 136C115 136 104 147 104 160S115 184 128 184S152 173 152 160S141 136 128 136ZM128 328C115 328 104 339 104 352S115 376 128 376S152 365 152 352S141 328 128 328ZM320 136C307 136 296 147 296 160S307 184 320 184S344 173 344 160S333 136 320 136ZM320 328C307 328 296 339 296 352S307 376 320 376S344 365 344 352S333 328 320 328Z"]
  };
  var faDiceOne = {
    prefix: 'fal',
    iconName: 'dice-one',
    icon: [448, 512, [], "f525", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM224 232C211 232 200 243 200 256C200 269 211 280 224 280S248 269 248 256C248 243 237 232 224 232Z"]
  };
  var faDiceSix = {
    prefix: 'fal',
    iconName: 'dice-six',
    icon: [448, 512, [], "f526", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM128 136C115 136 104 147 104 160S115 184 128 184S152 173 152 160S141 136 128 136ZM128 232C115 232 104 243 104 256C104 269 115 280 128 280S152 269 152 256C152 243 141 232 128 232ZM320 232C307 232 296 243 296 256C296 269 307 280 320 280S344 269 344 256C344 243 333 232 320 232ZM128 328C115 328 104 339 104 352S115 376 128 376S152 365 152 352S141 328 128 328ZM320 136C307 136 296 147 296 160S307 184 320 184S344 173 344 160S333 136 320 136ZM320 328C307 328 296 339 296 352S307 376 320 376S344 365 344 352S333 328 320 328Z"]
  };
  var faDiceThree = {
    prefix: 'fal',
    iconName: 'dice-three',
    icon: [448, 512, [], "f527", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM128 136C115 136 104 147 104 160S115 184 128 184S152 173 152 160S141 136 128 136ZM224 232C211 232 200 243 200 256C200 269 211 280 224 280S248 269 248 256C248 243 237 232 224 232ZM320 328C307 328 296 339 296 352S307 376 320 376S344 365 344 352S333 328 320 328Z"]
  };
  var faDiceTwo = {
    prefix: 'fal',
    iconName: 'dice-two',
    icon: [448, 512, [], "f528", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM128 136C115 136 104 147 104 160S115 184 128 184S152 173 152 160S141 136 128 136ZM320 328C307 328 296 339 296 352S307 376 320 376S344 365 344 352S333 328 320 328Z"]
  };
  var faDiploma = {
    prefix: 'fal',
    iconName: 'diploma',
    icon: [640, 512, [], "f5ea", "M539 144H477C484 132 488 118 488 104C488 64 460 32 425 32C394 32 373 42 320 129C267 42 246 32 215 32C180 32 152 64 152 104C152 118 156 132 163 144H96C43 144 0 192 0 272S43 416 96 416L240 385V464C240 470 243 475 248 478C252 480 258 481 263 478L320 450L377 478C379 479 382 480 384 480C387 480 390 479 392 478C397 475 400 470 400 464V386L539 416C595 416 640 352 640 272C640 192 595 144 539 144ZM240 352L93 384C64 381 32 336 32 272C32 215 58 176 96 176H240V352ZM215 144C198 144 184 126 184 104S198 64 215 64C229 64 243 64 292 144H215ZM368 438L327 418C323 415 317 415 313 418L272 438V176H368V438ZM348 144C397 64 411 64 425 64C442 64 456 82 456 104S442 144 425 144H348ZM542 384L400 353V176H539C580 176 608 215 608 272C608 331 578 381 542 384Z"]
  };
  var faDiscDrive = {
    prefix: 'fal',
    iconName: 'disc-drive',
    icon: [512, 512, [], "f8b5", "M256 224C238 224 224 238 224 256S238 288 256 288C274 288 288 274 288 256S274 224 256 224ZM496 448H480V96C480 61 451 32 416 32H96C61 32 32 61 32 96V448H16C7 448 0 455 0 464V464C0 473 7 480 16 480H496C505 480 512 473 512 464V464C512 455 505 448 496 448ZM448 448H64V96C64 78 78 64 96 64H416C434 64 448 78 448 96V448ZM256 96C168 96 96 168 96 256S168 416 256 416S416 344 416 256S344 96 256 96ZM256 384C185 384 128 327 128 256S185 128 256 128S384 185 384 256C384 327 327 384 256 384Z"]
  };
  var faDisease = {
    prefix: 'fal',
    iconName: 'disease',
    icon: [512, 512, [], "f7fa", "M160 200C147 200 136 211 136 224C136 237 147 248 160 248S184 237 184 224C184 211 173 200 160 200ZM288 296C275 296 264 307 264 320C264 333 275 344 288 344S312 333 312 320C312 307 301 296 288 296ZM464 185L401 164C388 159 379 150 376 139L361 83C354 60 335 42 309 35C280 27 250 35 231 55L187 99C178 109 164 114 149 112L82 107C51 105 21 119 8 144C-4 165 -2 190 12 210L48 258C55 267 56 278 51 288L25 341C14 362 16 386 31 405C49 428 80 439 111 432L177 418C191 415 207 418 218 426L269 464C283 475 300 480 317 480C329 480 341 478 352 473C375 462 390 442 392 418L396 361C397 350 405 340 416 334L474 304C499 292 514 268 512 243C510 217 492 194 464 185ZM460 276L402 305C380 316 366 336 364 358L360 416C359 432 345 441 338 443C322 451 302 449 288 439L237 401C223 391 206 385 188 385C182 385 176 386 170 387L105 401C82 406 64 396 57 386C52 380 46 369 53 355L80 303C91 282 88 258 74 239L38 190C28 177 32 166 36 160C43 146 61 138 79 139L147 144C171 146 195 138 210 122L254 77C265 66 284 61 301 66C316 70 327 79 330 91L345 147C351 169 368 186 391 194L454 215C469 221 479 232 480 245C481 257 473 269 460 276ZM304 192C295 192 288 199 288 208C288 217 295 224 304 224S320 217 320 208C320 199 313 192 304 192Z"]
  };
  var faDisplay = {
    prefix: 'fal',
    iconName: 'display',
    icon: [576, 512, [], "e11c", "M512 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H214L194 480H144C135 480 128 487 128 496S135 512 144 512H432C441 512 448 505 448 496S441 480 432 480H382L362 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM348 480H228L247 416H329L348 480ZM544 352C544 370 530 384 512 384H64C46 384 32 370 32 352V64C32 46 46 32 64 32H512C530 32 544 46 544 64V352Z"]
  };
  var faDisplayCode = {
    prefix: 'fal',
    iconName: 'display-code',
    icon: [576, 512, [], "e11d", "M512 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H214L194 480H144C135 480 128 487 128 496S135 512 144 512H432C441 512 448 505 448 496S441 480 432 480H382L362 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM228 480L247 416H329L348 480H228ZM544 352C544 370 530 384 512 384H64C46 384 32 370 32 352V64C32 46 46 32 64 32H512C530 32 544 46 544 64V352ZM219 133C213 126 203 126 197 133L133 197C126 203 126 213 133 219L197 283C200 286 204 288 208 288S216 286 219 283C226 277 226 267 219 261L167 208L219 155C226 149 226 139 219 133ZM379 133C373 126 363 126 357 133S350 149 357 155L409 208L357 261C350 267 350 277 357 283C360 286 364 288 368 288S376 286 379 283L443 219C450 213 450 203 443 197L379 133ZM325 97C317 94 308 99 305 107L241 299C238 307 243 316 251 319C253 320 254 320 256 320C263 320 269 316 271 309L335 117C338 109 333 100 325 97Z"]
  };
  var faDisplayMedical = {
    prefix: 'fal',
    iconName: 'display-medical',
    icon: [576, 512, [], "e11e", "M512 0H64C29 0 0 29 0 64V352C0 387 29 416 64 416H214L194 480H144C135 480 128 487 128 496S135 512 144 512H432C441 512 448 505 448 496S441 480 432 480H382L362 416H512C547 416 576 387 576 352V64C576 29 547 0 512 0ZM228 480L247 416H329L348 480H228ZM544 352C544 370 530 384 512 384H64C46 384 32 370 32 352V64C32 46 46 32 64 32H512C530 32 544 46 544 64V352ZM368 176H320V128C320 119 313 112 304 112H272C263 112 256 119 256 128V176H208C199 176 192 183 192 192V224C192 233 199 240 208 240H256V288C256 297 263 304 272 304H304C313 304 320 297 320 288V240H368C377 240 384 233 384 224V192C384 183 377 176 368 176Z"]
  };
  var faDisplaySlash = {
    prefix: 'fal',
    iconName: 'display-slash',
    icon: [640, 512, [], "e11f", "M544 32C562 32 576 46 576 64V352C576 353 575 354 575 356L603 377C606 370 608 361 608 352V64C608 29 579 0 544 0H125L165 32H544ZM464 480H413L395 417L353 384H96C78 384 64 370 64 352V156L32 131V352C32 387 61 416 96 416H246L226 480H176C167 480 160 487 160 496S167 512 176 512H464C473 512 480 505 480 496S473 480 464 480ZM260 480L279 416H361L380 480H260ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483Z"]
  };
  var faDivide = {
    prefix: 'fal',
    iconName: 'divide',
    icon: [448, 512, [], "f529", "M432 240H16C7 240 0 247 0 256S7 272 16 272H432C441 272 448 265 448 256S441 240 432 240ZM224 192C259 192 288 163 288 128S259 64 224 64S160 93 160 128S189 192 224 192ZM224 96C242 96 256 110 256 128S242 160 224 160S192 146 192 128S206 96 224 96ZM224 320C189 320 160 349 160 384S189 448 224 448S288 419 288 384S259 320 224 320ZM224 416C206 416 192 402 192 384S206 352 224 352S256 366 256 384S242 416 224 416Z"]
  };
  var faDna = {
    prefix: 'fal',
    iconName: 'dna',
    icon: [448, 512, [], "f471", "M319 305L297 290C290 284 280 286 275 293C270 300 271 310 279 315L300 331C309 337 317 344 324 352H124C131 344 139 337 148 331L319 207C380 163 416 91 416 16C416 7 409 0 400 0S384 7 384 16C384 21 383 27 383 32H65C65 27 64 21 64 16C64 7 57 0 48 0S32 7 32 16C32 91 68 163 129 207L197 256L129 305C68 349 32 421 32 496C32 505 39 512 48 512S64 505 64 496C64 491 65 485 65 480H383C383 485 384 491 384 496C384 505 391 512 400 512S416 505 416 496C416 421 380 349 319 305ZM378 64C373 87 363 108 350 128H98C85 108 75 87 70 64H378ZM148 181C139 175 131 167 124 160H324C317 167 309 175 300 181L224 236L148 181ZM70 448C75 425 85 404 98 384H350C363 404 373 425 378 448H70Z"]
  };
  var faDoNotEnter = {
    prefix: 'fal',
    iconName: 'do-not-enter',
    icon: [512, 512, [], "f5ec", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM384 208H128C102 208 80 230 80 256S102 304 128 304H384C410 304 432 282 432 256S410 208 384 208ZM384 272H128C119 272 112 265 112 256S119 240 128 240H384C393 240 400 247 400 256S393 272 384 272Z"]
  };
  var faDog = {
    prefix: 'fal',
    iconName: 'dog',
    icon: [576, 512, [], "f6d3", "M512 96H464L457 82C452 72 439 64 428 64H336V48C336 39 329 32 320 32S304 39 304 48V224H192C173 224 155 230 139 240H112C86 240 64 218 64 192C64 183 57 176 48 176S32 183 32 192C32 235 66 270 110 272C101 286 96 303 96 320V464C96 490 118 512 144 512H176C202 512 224 490 224 464V384H320V464C320 490 342 512 368 512H400C426 512 448 490 448 464V240H480C515 240 544 211 544 176V128C544 110 530 96 512 96ZM416 464C416 473 409 480 400 480H368C359 480 352 473 352 464V368C352 359 345 352 336 352H208C199 352 192 359 192 368V464C192 473 185 480 176 480H144C135 480 128 473 128 464V320C128 285 157 256 192 256H317L416 289V464ZM512 176C512 194 498 208 480 208H416V255L336 228V96H428L444 128H512V176ZM400 112C391 112 384 119 384 128S391 144 400 144S416 137 416 128S409 112 400 112Z"]
  };
  var faDogLeashed = {
    prefix: 'fal',
    iconName: 'dog-leashed',
    icon: [576, 512, [], "f6d4", "M400 112C391 112 384 119 384 128S391 144 400 144S416 137 416 128S409 112 400 112ZM512 96H464L457 82C452 72 439 64 428 64H336V48C336 39 329 32 320 32S304 39 304 48V206L58 4C51 -2 41 -1 36 6C30 13 31 23 38 28L275 224H192C173 224 155 230 139 240H112C86 240 64 218 64 192C64 183 57 176 48 176S32 183 32 192C32 235 66 270 110 272C101 286 96 303 96 320V464C96 490 118 512 144 512H176C202 512 224 490 224 464V384H320V464C320 490 342 512 368 512H400C426 512 448 490 448 464V240H480C515 240 544 211 544 176V128C544 110 530 96 512 96ZM288 352H208C199 352 192 359 192 368V464C192 473 185 480 176 480H144C135 480 128 473 128 464V320C128 285 157 256 192 256H288V352ZM416 464C416 473 409 480 400 480H368C359 480 352 473 352 464V368C352 359 345 352 336 352H320V257L416 289V464ZM512 176C512 194 498 208 480 208H416V255L336 228V96H428L444 128H512V176Z"]
  };
  var faDollarSign = {
    prefix: 'fal',
    iconName: 'dollar-sign',
    icon: [320, 512, [], "f155", "M302 366C293 416 245 446 176 448V496C176 505 169 512 160 512C151 512 144 505 144 496V446C138 446 132 446 125 445C97 441 67 431 40 422L27 418C19 415 14 406 17 398C20 389 29 385 37 387L50 392C76 400 104 410 130 413C193 422 261 409 271 360C280 308 234 292 156 271L139 267C88 253 2 230 18 146C27 96 75 67 144 65V16C144 7 151 0 160 0C169 0 176 7 176 16V65C182 66 188 66 195 67C213 70 234 75 261 83C269 86 274 95 271 104C269 112 260 117 251 114C226 106 207 101 190 99C127 90 59 103 49 152C41 198 75 217 147 236L164 240C233 258 318 281 302 366Z"]
  };
  var faDolly = {
    prefix: 'fal',
    iconName: 'dolly',
    icon: [576, 512, [], "f472", "M575 330C572 322 563 318 554 321L331 403C319 373 290 352 256 352C251 352 246 353 241 353L142 55C131 22 100 0 66 0H16C7 0 0 7 0 16S7 32 16 32H66C87 32 105 45 111 65L212 365C190 380 176 404 176 432C176 476 212 512 256 512C299 512 334 478 336 436L566 351C574 348 578 339 575 330ZM256 480C230 480 208 458 208 432S230 384 256 384S304 406 304 432S282 480 256 480ZM287 303C293 322 312 336 332 336C337 336 342 335 347 333L479 289C491 285 501 277 506 265C512 254 513 241 509 229L465 97C459 78 440 64 420 64C415 64 409 65 405 67L273 111C261 115 251 123 246 135C240 146 239 159 243 171L287 303ZM274 149C276 145 279 142 283 141L415 97C416 97 418 96 420 96C427 96 433 101 435 107L479 239C480 243 480 247 478 251C476 255 473 258 469 259L337 303C336 303 334 304 332 304C325 304 319 299 317 293L273 161C272 157 272 153 274 149Z"]
  };
  var faDollyEmpty = {
    prefix: 'fal',
    iconName: 'dolly-empty',
    icon: [576, 512, [], "f473", "M575 330C572 322 563 318 554 321L331 403C319 373 290 352 256 352C251 352 246 353 241 353L142 55C131 22 100 0 66 0H16C7 0 0 7 0 16S7 32 16 32H66C87 32 105 45 111 65L212 365C190 380 176 404 176 432C176 476 212 512 256 512C299 512 334 478 336 436L566 351C574 348 578 339 575 330ZM256 480C230 480 208 458 208 432S230 384 256 384S304 406 304 432S282 480 256 480Z"]
  };
  var faDolphin = {
    prefix: 'fal',
    iconName: 'dolphin',
    icon: [512, 512, [], "e120", "M437 137L428 129C437 108 452 82 474 53C482 41 482 26 473 14C465 3 452 -2 438 0C396 7 355 20 318 38C282 13 254 0 210 0H202C119 0 48 56 34 133C30 157 31 181 39 206L21 217C4 229 -4 250 2 270C8 291 26 304 48 304H400C409 304 416 297 416 288C416 279 409 272 400 272H48C37 272 33 264 33 261C31 256 32 249 39 244L78 218L73 206C64 184 62 161 66 139C77 78 135 32 202 32H210C248 32 271 44 307 69L315 75L323 71C360 52 401 39 442 32C446 32 447 33 448 34C421 71 403 102 393 128L390 138L416 161C439 180 480 215 480 288C480 359 423 416 352 416H297L265 368C258 358 246 352 233 352H172C161 352 151 358 147 367C142 376 143 386 149 394L177 432L149 470C143 478 142 488 147 497C151 506 161 512 172 512H233C246 512 258 506 266 495L297 448H352C440 448 512 376 512 288C512 200 461 157 437 137ZM240 477C238 479 236 480 233 480H182L217 432L182 384H233C236 384 238 385 239 386L269 432L240 477ZM128 152C128 165 139 176 152 176C165 176 176 165 176 152C176 139 165 128 152 128C139 128 128 139 128 152Z"]
  };
  var faDongSign = {
    prefix: 'fal',
    iconName: 'dong-sign',
    icon: [384, 512, [], "e121", "M368 448H16C7 448 0 455 0 464S7 480 16 480H368C377 480 384 473 384 464S377 448 368 448ZM192 400C230 400 265 383 288 356V384C288 393 295 400 304 400S320 393 320 384V112H336C345 112 352 105 352 96S345 80 336 80H320V48C320 39 313 32 304 32S288 39 288 48V80H208C199 80 192 87 192 96S199 112 208 112H288V188C265 161 230 144 192 144C121 144 64 201 64 272S121 400 192 400ZM192 176C245 176 288 219 288 272S245 368 192 368S96 325 96 272S139 176 192 176Z"]
  };
  var faDoorClosed = {
    prefix: 'fal',
    iconName: 'door-closed',
    icon: [576, 512, [], "f52a", "M560 480H480V80C480 36 444 0 400 0H176C132 0 96 36 96 80V480H16C7 480 0 487 0 496C0 505 7 512 16 512H560C569 512 576 505 576 496C576 487 569 480 560 480ZM448 480H128V80C128 54 150 32 176 32H400C426 32 448 54 448 80V480ZM384 232C371 232 360 243 360 256S371 280 384 280S408 269 408 256S397 232 384 232Z"]
  };
  var faDoorOpen = {
    prefix: 'fal',
    iconName: 'door-open',
    icon: [576, 512, [], "f52b", "M232 224C219 224 208 238 208 256S219 288 232 288S256 274 256 256S245 224 232 224ZM260 1L100 41C79 47 64 66 64 88V480H16C7 480 0 487 0 496C0 505 7 512 16 512H288C306 512 320 498 320 480V49C320 39 317 29 311 21C299 4 279 -3 260 1ZM288 480H96V88C96 81 101 74 108 73L268 33C273 31 278 32 282 35C286 38 288 43 288 48V480ZM560 480H512V144C512 100 476 64 432 64H368C359 64 352 71 352 80V80C352 89 359 96 368 96H432C458 96 480 118 480 144V480C480 498 494 512 512 512H560C569 512 576 505 576 496C576 487 569 480 560 480Z"]
  };
  var faDove = {
    prefix: 'fal',
    iconName: 'dove',
    icon: [512, 512, [], "f4ba", "M248 159C243 159 238 157 235 153C221 133 209 111 199 89C196 96 193 103 191 109C188 117 179 122 171 119C163 116 158 107 161 99C168 77 180 52 188 40C192 34 198 31 204 32C210 33 216 38 217 44C226 76 241 106 261 134C266 141 265 151 257 156C255 158 251 159 248 159ZM360 160C360 173 371 184 384 184S408 173 408 160C408 147 397 136 384 136S360 147 360 160ZM512 64L480 160V288C480 377 408 448 320 448H267L203 503C200 505 191 513 178 512C72 508 23 456 3 425C-4 414 1 400 14 397L143 365C42 283 31 196 32 153C32 113 42 75 58 41C63 29 81 29 87 42C144 172 272 197 288 200V160C288 107 331 64 384 64H384C384 64 384 64 384 64H512ZM468 96H384V96H384C349 96 320 125 320 160V238C300 236 156 226 74 87C68 109 64 131 64 153C62 276 165 342 212 380L42 423C63 448 104 477 179 480C180 480 255 416 255 416H320C391 416 448 359 448 288V155L468 96Z"]
  };
  var faDown = {
    prefix: 'fal',
    iconName: 'down',
    icon: [384, 512, [], "f354", "M112 64V240H32C14 240 0 254 0 272C0 280 3 289 9 295L169 471C176 477 184 480 192 480S208 477 215 471L375 295C381 289 384 280 384 272C384 254 370 240 352 240H272V64C272 46 258 32 240 32H144C126 32 112 46 112 64ZM240 64V272L351 273L192 448L32 272H144V64H240Z"]
  };
  var faDownFromLine = {
    prefix: 'fal',
    iconName: 'down-from-line',
    icon: [384, 512, [], "f349", "M314 272H256V157C256 132 236 112 211 112H173C148 112 128 132 128 157V272H70C55 272 41 281 35 295C29 309 32 325 42 335L165 469C172 476 182 480 192 480S212 476 219 468L342 335C352 325 355 309 349 295C343 281 329 272 314 272ZM318 314L196 447C194 448 190 448 188 447L66 313C64 312 64 309 64 307C65 305 67 304 70 304H160V157C160 150 166 144 173 144H211C218 144 224 150 224 157V304H314C317 304 319 305 320 307C320 309 320 312 318 314ZM368 32H16C7 32 0 39 0 48S7 64 16 64H368C377 64 384 57 384 48S377 32 368 32Z"]
  };
  var faDownLeftAndUpRightToCenter = {
    prefix: 'fal',
    iconName: 'down-left-and-up-right-to-center',
    icon: [512, 512, [], "f422", "M304 240H416C429 240 441 232 446 220S448 195 439 185L394 141L491 43C498 37 498 27 491 21C485 14 475 14 469 21L371 118L327 73C320 67 312 64 304 64C300 64 296 65 292 66C280 71 272 83 272 96V208C272 226 286 240 304 240ZM304 96L416 208C416 208 416 208 416 208H304V96ZM208 272H96C83 272 71 280 66 292S64 317 73 327L118 371L21 469C14 475 14 485 21 491C27 498 37 498 43 491L141 394L185 439C192 445 200 448 208 448C212 448 216 447 220 446C232 441 240 429 240 416V304C240 286 226 272 208 272ZM208 416L96 304C96 304 96 304 96 304H208V416Z"]
  };
  var faDownLong = {
    prefix: 'fal',
    iconName: 'down-long',
    icon: [320, 512, [], "f309", "M136 0H184C206 0 224 18 224 40L224 320H264C280 320 294 330 301 344C307 359 304 376 293 388L189 500C182 508 171 512 160 512C149 512 138 508 131 500L27 388C16 376 13 359 19 344C26 330 40 320 56 320H96L96 40C96 18 114 0 136 0ZM160 481C161 481 164 480 166 478L270 366C275 361 271 352 264 352H192L192 40C192 36 188 32 184 32H136C132 32 128 36 128 40L128 352H56C49 352 45 361 50 366L154 478C156 480 159 481 160 481Z"]
  };
  var faDownToLine = {
    prefix: 'fal',
    iconName: 'down-to-line',
    icon: [384, 512, [], "f34a", "M165 389C172 396 182 400 192 400S212 396 219 388L342 255C352 245 355 229 349 215C343 201 329 192 314 192H256V77C256 52 236 32 211 32H173C148 32 128 52 128 77V192H70C55 192 41 201 35 215C29 229 32 245 42 255L165 389ZM64 227C65 225 67 224 70 224H160V77C160 70 166 64 173 64H211C218 64 224 70 224 77V224H314C317 224 319 225 320 227C320 229 320 232 318 234L196 367C194 368 190 368 188 367L66 233C64 232 64 229 64 227ZM368 448H16C7 448 0 455 0 464S7 480 16 480H368C377 480 384 473 384 464S377 448 368 448Z"]
  };
  var faDownload = {
    prefix: 'fal',
    iconName: 'download',
    icon: [512, 512, [], "f019", "M245 380C248 383 252 384 256 384S264 383 267 380L411 252C417 246 418 236 412 229C406 223 396 222 389 228L272 332V16C272 7 265 0 256 0S240 7 240 16V332L123 228C116 222 106 223 100 229C94 236 95 246 101 252L245 380ZM448 320H400C391 320 384 327 384 336C384 345 391 352 400 352H448C466 352 480 366 480 384V448C480 466 466 480 448 480H64C46 480 32 466 32 448V384C32 366 46 352 64 352H112C121 352 128 345 128 336C128 327 121 320 112 320H64C29 320 0 349 0 384V448C0 483 29 512 64 512H448C483 512 512 483 512 448V384C512 349 483 320 448 320ZM440 416C440 403 429 392 416 392S392 403 392 416S403 440 416 440S440 429 440 416Z"]
  };
  var faDragon = {
    prefix: 'fal',
    iconName: 'dragon',
    icon: [640, 512, [], "f6d5", "M536 252C498 230 480 218 480 200V192H497L526 214C534 220 544 224 555 224H584C605 224 624 210 630 190L637 164C643 145 639 123 627 106L570 32C555 12 531 0 506 0H337C324 0 312 9 307 21C303 34 307 48 317 57L335 71L324 76C312 81 304 93 304 106S312 131 324 136L352 147V238C352 255 353 271 354 288H172L234 236C240 232 242 224 239 218S230 208 223 208L95 220L194 132L296 190C304 194 314 192 318 184C322 176 320 166 312 162L200 98C194 95 187 95 181 100L37 228C32 233 31 240 33 246C36 253 42 256 49 256L174 245L118 292C113 296 111 303 113 309C115 316 121 320 128 320H359C365 344 375 366 392 386C329 390 212 403 24 449C9 453 -2 468 0 484C2 500 16 512 32 512H507C549 512 591 492 616 459C639 428 646 390 635 352C620 300 573 273 536 252ZM507 480H32C263 423 385 418 433 416C448 415 454 395 441 387C392 354 384 306 384 238V136C384 129 380 123 374 121L336 106L373 91C378 89 382 84 382 78C383 73 381 67 377 63L337 32H506C521 32 535 39 544 51L601 126C608 134 610 145 607 155L599 181C597 187 591 192 584 192H555C551 192 548 191 545 189L512 163C509 161 506 160 502 160H471L443 133C437 126 427 126 421 133S415 149 421 155L448 182V200C448 239 483 259 520 280C556 300 593 322 604 361C624 431 563 480 507 480ZM481 86L513 102C515 103 518 104 520 104C526 104 532 101 534 95C538 87 535 78 527 74L495 58C487 54 478 57 474 65C470 73 473 82 481 86Z"]
  };
  var faDrawCircle = {
    prefix: 'fal',
    iconName: 'draw-circle',
    icon: [512, 512, [], "f5ed", "M512 256C512 222 486 195 453 193C433 129 383 79 319 59C317 26 290 0 256 0S195 26 193 59C129 79 79 129 59 193C26 195 0 222 0 256S26 317 59 319C79 383 129 433 193 453C195 486 222 512 256 512S317 486 319 453C383 433 433 383 453 319C486 317 512 290 512 256ZM256 32C274 32 288 46 288 64S274 96 256 96C238 96 224 82 224 64S238 32 256 32ZM32 256C32 238 46 224 64 224S96 238 96 256S82 288 64 288S32 274 32 256ZM256 480C238 480 224 466 224 448S238 416 256 416C274 416 288 430 288 448S274 480 256 480ZM314 422C304 399 282 384 256 384C230 384 208 399 198 422C148 404 108 364 91 314C113 304 128 282 128 256S113 208 90 198C108 148 148 108 198 91C208 113 230 128 256 128C282 128 304 113 314 90C364 108 404 148 421 198C399 208 384 230 384 256S399 304 422 314C404 364 364 404 314 422ZM448 288C430 288 416 274 416 256S430 224 448 224S480 238 480 256S466 288 448 288Z"]
  };
  var faDrawPolygon = {
    prefix: 'fal',
    iconName: 'draw-polygon',
    icon: [448, 512, [], "f5ee", "M384 352C378 352 372 353 366 355L334 301C345 289 352 274 352 256S345 223 334 211L366 157C372 159 378 160 384 160C419 160 448 131 448 96S419 32 384 32C354 32 329 53 322 80H126C119 53 94 32 64 32C29 32 0 61 0 96C0 126 21 151 48 158V354C21 361 0 386 0 416C0 451 29 480 64 480C94 480 119 459 126 432H322C329 459 354 480 384 480C419 480 448 451 448 416S419 352 384 352ZM80 354V158C102 152 120 134 126 112H322C325 123 331 133 338 141L306 195C300 193 294 192 288 192C253 192 224 221 224 256S253 320 288 320C294 320 300 319 306 317L338 371C331 379 325 389 322 400H126C120 378 102 360 80 354ZM288 288C270 288 256 274 256 256S270 224 288 224S320 238 320 256S306 288 288 288ZM384 64C402 64 416 78 416 96S402 128 384 128S352 114 352 96S366 64 384 64ZM32 96C32 78 46 64 64 64S96 78 96 96S82 128 64 128S32 114 32 96ZM64 448C46 448 32 434 32 416S46 384 64 384S96 398 96 416S82 448 64 448ZM384 448C366 448 352 434 352 416S366 384 384 384S416 398 416 416S402 448 384 448Z"]
  };
  var faDrawSquare = {
    prefix: 'fal',
    iconName: 'draw-square',
    icon: [448, 512, [], "f5ef", "M400 354V158C427 151 448 126 448 96C448 61 419 32 384 32C354 32 329 53 322 80H126C119 53 94 32 64 32C29 32 0 61 0 96C0 126 21 151 48 158V354C21 361 0 386 0 416C0 451 29 480 64 480C94 480 119 459 126 432H322C329 459 354 480 384 480C419 480 448 451 448 416C448 386 427 361 400 354ZM322 400H126C120 378 102 360 80 354V158C102 152 120 134 126 112H322C328 134 346 152 368 158V354C346 360 328 378 322 400ZM384 64C402 64 416 78 416 96S402 128 384 128S352 114 352 96S366 64 384 64ZM32 96C32 78 46 64 64 64S96 78 96 96S82 128 64 128S32 114 32 96ZM64 448C46 448 32 434 32 416S46 384 64 384S96 398 96 416S82 448 64 448ZM384 448C366 448 352 434 352 416S366 384 384 384S416 398 416 416S402 448 384 448Z"]
  };
  var faDreidel = {
    prefix: 'fal',
    iconName: 'dreidel',
    icon: [448, 512, [], "f792", "M443 37C437 30 427 30 421 37L301 157L218 73C211 67 202 64 194 64C185 64 177 67 170 73L20 224C7 237 0 254 0 271V413C0 450 30 480 67 480H209C226 480 243 473 256 460L407 310C420 297 420 276 407 262L323 179L443 59C450 53 450 43 443 37ZM233 438C227 444 218 448 209 448H67C48 448 32 432 32 413V271C32 262 36 253 42 247L102 187L293 378L233 438ZM384 287L315 356L124 165L193 96C193 96 193 96 194 96L195 96L384 285C385 286 385 287 384 287Z"]
  };
  var faDrone = {
    prefix: 'fal',
    iconName: 'drone',
    icon: [512, 512, [], "f85f", "M371 164L392 142C395 143 397 144 400 144C418 144 432 130 432 112S418 80 400 80S368 94 368 112C368 115 369 117 370 120L348 141C336 153 320 160 303 160H209C192 160 176 153 164 141L142 120C143 117 144 115 144 112C144 94 130 80 112 80S80 94 80 112S94 144 112 144C115 144 117 143 120 142L141 164C153 176 160 192 160 209V303C160 320 153 336 141 348L120 370C117 369 115 368 112 368C94 368 80 382 80 400S94 432 112 432S144 418 144 400C144 397 143 395 142 392L164 371C176 359 192 352 209 352H303C320 352 336 359 348 371L370 392C369 395 368 397 368 400C368 418 382 432 400 432S432 418 432 400S418 368 400 368C397 368 395 369 392 370L371 348C359 336 352 320 352 303V209C352 192 359 176 371 164ZM320 320H192V192H320V320ZM93 222C94 223 95 223 96 223C104 223 110 217 112 209C113 201 107 192 99 191C60 184 32 151 32 112C32 68 68 32 112 32C151 32 184 60 191 99C192 107 201 113 209 112C218 110 224 102 222 93C213 39 167 0 112 0C50 0 0 50 0 112C0 167 39 213 93 222ZM303 112C311 113 320 107 321 99C328 60 361 32 400 32C444 32 480 68 480 112C480 151 452 184 413 191C405 192 399 201 400 209C402 217 408 223 416 223C417 223 418 223 419 222C473 213 512 167 512 112C512 50 462 0 400 0C345 0 299 39 290 93C288 102 294 110 303 112ZM419 290C410 288 402 294 400 303C399 311 405 320 413 321C452 328 480 361 480 400C480 444 444 480 400 480C361 480 328 452 321 413C320 405 311 399 303 400C294 402 288 410 290 419C299 473 345 512 400 512C462 512 512 462 512 400C512 345 473 299 419 290ZM209 400C201 399 192 405 191 413C184 452 151 480 112 480C68 480 32 444 32 400C32 361 60 328 99 321C107 320 113 311 112 303C110 294 102 288 93 290C39 299 0 345 0 400C0 462 50 512 112 512C167 512 213 473 222 419C224 410 218 402 209 400Z"]
  };
  var faDroneFront = {
    prefix: 'fal',
    iconName: 'drone-front',
    icon: [640, 512, [], "f860", "M624 128H512V112C512 103 505 96 496 96S480 103 480 112V128H368C359 128 352 135 352 144C352 153 359 160 368 160H480V239C447 220 384 192 320 192S193 220 160 239V160H272C281 160 288 153 288 144C288 135 281 128 272 128H160V112C160 103 153 96 144 96S128 103 128 112V128H16C7 128 0 135 0 144C0 153 7 160 16 160H128V272C128 290 142 304 160 304H169C153 333 144 366 144 400C144 409 151 416 160 416S176 409 176 400C176 366 187 332 208 304H226L278 348C281 351 284 352 288 352H352C356 352 359 351 362 348L414 304H432C453 332 464 366 464 400C464 409 471 416 480 416S496 409 496 400C496 366 487 333 471 304H480C498 304 512 290 512 272V160H624C633 160 640 153 640 144C640 135 633 128 624 128ZM408 272C404 272 401 273 398 276L346 320H294L242 276C239 273 236 272 232 272H166C193 257 257 224 320 224S447 257 474 272H408Z"]
  };
  var faDroplet = {
    prefix: 'fal',
    iconName: 'droplet',
    icon: [384, 512, [], "f043", "M192 416C148 416 112 380 112 336C112 327 105 320 96 320S80 327 80 336C80 398 130 448 192 448C201 448 208 441 208 432S201 416 192 416ZM221 22C217 7 205 0 192 0C180 0 167 7 163 22C116 180 16 223 16 334C16 432 95 512 192 512S368 432 368 334C368 222 268 181 221 22ZM192 480C113 480 48 414 48 334C48 286 71 253 103 207C132 165 168 113 192 36C216 114 252 165 281 207C313 253 336 285 336 334C336 414 271 480 192 480Z"]
  };
  var faDropletDegree = {
    prefix: 'fal',
    iconName: 'droplet-degree',
    icon: [448, 512, [], "f748", "M192 32C181 32 169 38 165 51C123 189 32 227 32 324C32 410 104 480 192 480S352 410 352 324C352 226 261 190 219 51C215 39 203 32 192 32ZM320 324C320 392 263 448 192 448S64 392 64 324C64 283 85 255 113 216C139 180 170 137 192 73C214 137 245 181 271 216C300 255 320 283 320 324ZM352 32C317 32 288 61 288 96S317 160 352 160S416 131 416 96S387 32 352 32ZM352 128C334 128 320 114 320 96S334 64 352 64S384 78 384 96S370 128 352 128Z"]
  };
  var faDropletPercent = {
    prefix: 'fal',
    iconName: 'droplet-percent',
    icon: [320, 512, [], "f750", "M187 51C183 39 171 32 160 32C149 32 137 38 133 51C91 189 0 227 0 324C0 410 72 480 160 480S320 410 320 324C320 226 229 190 187 51ZM160 448C89 448 32 392 32 324C32 283 53 255 81 216C107 180 138 137 160 73C182 137 213 181 239 216C268 255 288 283 288 324C288 392 231 448 160 448ZM128 264C128 251 117 240 104 240S80 251 80 264S91 288 104 288S128 277 128 264ZM219 261C213 254 203 254 197 261L101 357C94 363 94 373 101 379C104 382 108 384 112 384S120 382 123 379L219 283C226 277 226 267 219 261ZM216 352C203 352 192 363 192 376S203 400 216 400S240 389 240 376S229 352 216 352Z"]
  };
  var faDropletSlash = {
    prefix: 'fal',
    iconName: 'droplet-slash',
    icon: [640, 512, [], "f5c7", "M634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483ZM320 448C329 448 336 441 336 432S329 416 320 416C276 416 240 380 240 336C240 327 233 320 224 320S208 327 208 336C208 398 258 448 320 448ZM320 36C344 114 380 165 409 207C428 234 443 256 453 279L495 312C483 216 393 170 349 22C345 7 333 0 320 0C308 0 295 7 291 22C279 60 265 92 250 119L275 139C292 110 307 77 320 36ZM320 480C241 480 176 414 176 334C176 300 187 274 204 246L179 226C159 259 144 291 144 334C144 432 223 512 320 512C375 512 425 486 457 446L431 425C405 458 365 480 320 480Z"]
  };
  var faDrum = {
    prefix: 'fal',
    iconName: 'drum',
    icon: [512, 512, [], "f569", "M415 118L505 61C512 56 514 47 509 39C505 32 495 30 488 34L372 107C335 99 295 96 256 96C133 96 0 131 0 208V368C0 430 115 480 256 480S512 430 512 368V208C512 165 472 136 415 118ZM96 421C55 405 32 385 32 368V266C49 279 71 289 96 298V421ZM240 448C197 446 159 441 128 432V306C163 314 202 319 240 320V448ZM384 432C353 441 315 446 272 448V320C311 319 349 314 384 306V432ZM480 368C480 385 457 405 416 421V298C442 289 464 279 480 266V368ZM256 288C132 288 32 252 32 208S132 128 256 128C281 128 306 129 331 132L232 194C224 199 222 209 227 216C231 223 241 226 249 221L378 141C439 155 480 180 480 208C480 252 380 288 256 288Z"]
  };
  var faDrumSteelpan = {
    prefix: 'fal',
    iconName: 'drum-steelpan',
    icon: [576, 512, [], "f56a", "M288 32C129 32 0 89 0 160V352C0 423 129 480 288 480S576 423 576 352V160C576 89 447 32 288 32ZM288 64C314 64 338 66 362 68L346 128C342 146 316 160 288 160S234 146 230 128L214 68C238 66 262 64 288 64ZM383 249C354 254 322 256 288 256C254 256 222 254 193 249C213 229 226 204 230 175C246 186 267 192 288 192C309 192 330 186 346 176C349 204 363 230 383 249ZM178 73L195 133C207 176 188 220 150 241C79 224 32 194 32 160C32 122 92 89 178 73ZM544 352C544 391 444 448 288 448S32 391 32 352V218C80 260 176 288 288 288S496 260 544 218V352ZM426 241C390 222 369 181 379 140L394 73C482 88 544 121 544 160C544 194 497 224 426 241Z"]
  };
  var faDrumstick = {
    prefix: 'fal',
    iconName: 'drumstick',
    icon: [512, 512, [], "f6d6", "M471 58C440 22 396 1 348 0C302 -1 256 17 222 50C196 76 160 120 160 191V260L117 303C114 306 107 309 99 305C77 296 52 299 32 313C12 326 0 349 0 373C0 394 16 442 68 444C70 484 102 512 139 512C191 512 226 460 207 413C206 410 203 401 209 395L252 352H322C361 352 395 342 427 321C473 290 504 241 511 187C517 139 503 93 471 58ZM186 373C173 386 170 406 177 425C200 483 103 503 100 443L98 414L69 412C19 410 20 332 73 332C78 332 83 333 88 335C105 342 126 340 139 326L165 300C174 322 191 339 212 347L186 373ZM479 183C473 227 447 269 409 294C383 312 355 320 322 320H240C214 320 192 299 192 272V191C192 145 208 109 245 72C271 46 306 32 343 32C344 32 346 32 347 32C386 33 422 50 447 79C473 107 484 145 479 183Z"]
  };
  var faDrumstickBite = {
    prefix: 'fal',
    iconName: 'drumstick-bite',
    icon: [512, 512, [], "f6d7", "M471 58C440 22 396 1 348 0C301 -1 256 17 222 50C196 76 160 120 160 191V260L117 303C114 306 107 309 99 305C77 296 52 299 32 313C12 326 0 349 0 373C0 394 16 442 68 444C70 484 102 512 139 512C191 512 226 460 207 413C206 410 203 401 209 395L252 352H322C339 352 356 350 373 345C378 344 382 340 383 336C385 331 385 326 382 321C373 307 368 290 368 272C368 219 411 176 464 176C473 176 481 177 491 181C496 182 502 181 506 178C510 175 512 170 512 165C512 125 498 88 471 58ZM186 373C173 386 170 406 177 425C200 483 103 503 100 443L98 414L69 412C19 410 20 332 73 332C78 332 83 333 88 335C105 342 126 340 139 326L165 300C174 322 191 339 212 347L186 373ZM464 144C394 144 336 201 336 272C336 288 339 304 345 318C338 320 330 320 322 320H241C214 320 192 299 192 272V191C192 145 208 109 245 72C271 46 306 32 343 32C344 32 346 32 347 32C386 33 422 50 447 79C464 97 475 120 478 145C474 144 469 144 464 144Z"]
  };
  var faDryer = {
    prefix: 'fal',
    iconName: 'dryer',
    icon: [448, 512, [], "f861", "M352 0H96C43 0 0 43 0 96V448C0 483 29 512 64 512H384C419 512 448 483 448 448V96C448 43 405 0 352 0ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V96C32 61 61 32 96 32H352C387 32 416 61 416 96V448ZM192 120C205 120 216 109 216 96S205 72 192 72C179 72 168 83 168 96S179 120 192 120ZM120 96C120 83 109 72 96 72C83 72 72 83 72 96S83 120 96 120C109 120 120 109 120 96ZM224 160C144 160 80 225 80 304S144 448 224 448S368 383 368 304S304 160 224 160ZM224 416C168 416 121 374 114 320H176C185 320 192 313 192 304S185 288 176 288H114C121 234 168 192 224 192C286 192 336 242 336 304S286 416 224 416Z"]
  };
  var faDryerHeat = {
    prefix: 'fal',
    iconName: 'dryer-heat',
    icon: [448, 512, [], "f862", "M352 0H96C43 0 0 43 0 96V448C0 483 29 512 64 512H384C419 512 448 483 448 448V96C448 43 405 0 352 0ZM416 448C416 466 402 480 384 480H64C46 480 32 466 32 448V96C32 61 61 32 96 32H352C387 32 416 61 416 96V448ZM192 120C205 120 216 109 216 96S205 72 192 72C179 72 168 83 168 96S179 120 192 120ZM120 96C120 83 109 72 96 72C83 72 72 83 72 96S83 120 96 120C109 120 120 109 120 96ZM224 160C144 160 80 225 80 304S144 448 224 448S368 383 368 304S304 160 224 160ZM224 416C162 416 112 366 112 304S162 192 224 192C286 192 336 242 336 304S286 416 224 416ZM213 350C202 340 200 324 206 311C219 286 214 255 194 235L187 229C181 222 171 222 165 229C158 235 158 245 165 251L171 258C182 268 184 284 178 297C165 322 170 353 190 373L197 379C200 382 204 384 208 384S216 382 219 379C226 373 226 363 219 357L213 350ZM277 350C266 340 264 324 270 311C283 286 278 255 258 235L251 229C245 222 235 222 229 229C222 235 222 245 229 251L235 258C246 268 248 284 242 297C229 322 234 353 254 373L261 379C264 382 268 384 272 384S280 382 283 379C290 373 290 363 283 357L277 350Z"]
  };
  var faDuck = {
    prefix: 'fal',
    iconName: 'duck',
    icon: [576, 512, [], "f6d8", "M544 128C544 119 537 112 528 112H485C474 66 433 32 384 32C327 32 280 79 280 136C280 156 288 177 304 198V224C304 233 297 240 288 240H273C244 240 201 228 183 211C174 202 160 199 147 204C135 209 128 220 128 232C128 320 204 391 297 391C306 391 313 384 313 375S306 359 297 359C222 359 160 302 161 234C187 260 243 272 273 272H288C314 272 336 250 336 224V192C336 188 335 185 332 182C319 165 312 150 312 136C312 96 344 64 384 64C422 64 452 92 456 129C456 138 463 144 472 144H510C502 180 469 208 432 208H421C416 208 411 211 408 216C403 224 400 235 400 245C400 262 409 279 424 289C452 308 467 338 463 370C459 411 411 448 363 448H271C163 448 72 370 64 272H88C97 272 104 265 104 256S97 240 88 240H64C55 240 46 244 40 250C34 257 31 265 32 273C41 389 147 480 271 480H363C428 480 489 431 495 373C500 329 480 288 442 263C436 258 432 252 432 245C432 243 432 242 432 240C492 240 544 187 544 128ZM400 128C400 119 393 112 384 112C375 112 368 119 368 128S375 144 384 144C393 144 400 137 400 128Z"]
  };
  var faDumbbell = {
    prefix: 'fal',
    iconName: 'dumbbell',
    icon: [640, 512, [], "f44b", "M624 240H608V160C608 134 586 112 560 112H528C522 112 517 113 512 115V96C512 70 490 48 464 48H432C406 48 384 70 384 96V240H256V96C256 70 234 48 208 48H176C150 48 128 70 128 96V115C123 113 118 112 112 112H80C54 112 32 134 32 160V240H16C7 240 0 247 0 256C0 265 7 272 16 272H32V352C32 378 54 400 80 400H112C118 400 123 399 128 397V416C128 442 150 464 176 464H208C234 464 256 442 256 416V272H384V416C384 442 406 464 432 464H464C490 464 512 442 512 416V397C517 399 522 400 528 400H560C586 400 608 378 608 352V272H624C633 272 640 265 640 256C640 247 633 240 624 240ZM128 352C128 361 121 368 112 368H80C71 368 64 361 64 352V160C64 151 71 144 80 144H112C121 144 128 151 128 160V352ZM224 416C224 425 217 432 208 432H176C167 432 160 425 160 416V96C160 87 167 80 176 80H208C217 80 224 87 224 96V416ZM480 416C480 425 473 432 464 432H432C423 432 416 425 416 416V96C416 87 423 80 432 80H464C473 80 480 87 480 96V416ZM576 352C576 361 569 368 560 368H528C519 368 512 361 512 352V160C512 151 519 144 528 144H560C569 144 576 151 576 160V352Z"]
  };
  var faDumpster = {
    prefix: 'fal',
    iconName: 'dumpster',
    icon: [576, 512, [], "f793", "M560 256H533L537 224H505L484 416H92L71 224H39L43 256H16C7 256 0 263 0 272C0 281 7 288 16 288H46L64 448V464C64 473 71 480 80 480S96 473 96 464V448H480V464C480 473 487 480 496 480S512 473 512 464V448L530 288H560C569 288 576 281 576 272C576 263 569 256 560 256ZM16 192H560C570 192 578 180 575 167L543 47C542 38 535 32 528 32H48C41 32 34 38 33 47L1 167C-2 180 6 192 16 192ZM514 64L541 160H463L443 64H514ZM304 64H411L430 160H304V64ZM165 64H272V160H146L165 64ZM62 64H133L113 160H35L62 64Z"]
  };
  var faDumpsterFire = {
    prefix: 'fal',
    iconName: 'dumpster-fire',
    icon: [640, 512, [], "f794", "M16 192H340C348 181 356 171 365 160H304V64H411L419 104L440 85L449 94L443 64H514L534 135L551 120L567 134L543 47C542 38 535 32 528 32H48C41 32 34 38 33 47L1 167C-2 180 6 192 16 192ZM165 64H272V160H146L165 64ZM62 64H133L113 160H35L62 64ZM92 416L71 224H39L43 256H16C7 256 0 263 0 272C0 281 7 288 16 288H46L64 448V464C64 473 71 480 80 480S96 473 96 464V448H337C328 438 320 427 313 416H92ZM551 163C536 177 523 190 511 204C491 179 467 152 440 128C370 191 320 272 320 322C320 409 392 480 480 480S640 409 640 322C640 285 603 209 551 163ZM494 447C490 447 485 448 480 448S471 447 466 447C434 440 410 412 410 379C410 365 426 333 455 301C462 309 468 316 474 324L498 356L524 325C524 325 524 325 524 325C541 347 550 371 550 379C550 412 526 440 494 447ZM580 400C581 393 582 386 582 379C582 356 558 308 525 278C516 287 507 296 500 305C487 288 472 271 454 256C410 296 378 348 378 379C378 386 379 393 380 400C363 378 352 351 352 322C352 290 384 228 440 172C457 189 472 206 485 224L509 256L535 225C540 219 545 214 550 208C585 248 608 300 608 322C608 351 597 378 580 400Z"]
  };
  var faDungeon = {
    prefix: 'fal',
    iconName: 'dungeon',
    icon: [512, 512, [], "f6d9", "M512 296C512 287 509 278 504 272C509 264 512 255 512 246C510 211 502 177 487 145C482 136 474 129 465 125C466 115 463 105 456 97C435 70 409 48 379 32C373 28 366 27 360 27C356 27 353 27 350 28C344 19 336 13 326 10C303 3 280 0 256 0S209 3 186 10C176 13 168 19 162 28C159 27 156 27 152 27C146 27 139 29 133 32C103 48 77 70 56 97C49 105 46 115 47 125C38 129 30 136 25 145C10 177 2 211 0 246C0 255 3 264 8 272C3 279 0 287 0 296V360C0 369 3 377 8 384C3 391 0 399 0 408V472C0 494 18 512 40 512H104C126 512 144 494 144 472V408C144 399 141 391 136 384C141 377 144 369 144 360V296C144 287 141 279 136 272C141 266 144 258 144 250C145 238 148 225 153 213C156 207 157 200 156 194C162 191 168 188 172 183C179 174 188 167 197 161C203 158 208 153 211 148C214 148 217 149 221 149S227 148 231 147C240 145 248 144 256 144S272 145 281 147C285 148 288 149 291 149S298 148 301 148C304 153 309 158 315 161C324 167 333 174 340 183C344 188 350 191 356 194C355 200 356 207 359 213C364 225 367 238 368 250C368 259 371 266 376 272C371 279 368 287 368 296V360C368 369 371 377 376 384C371 391 368 399 368 408V472C368 494 386 512 408 512H472C494 512 512 494 512 472V408C512 399 509 391 504 384C509 377 512 369 512 360V296ZM112 472C112 476 108 480 104 480H40C36 480 32 476 32 472V408C32 404 36 400 40 400H104C108 400 112 404 112 408V472ZM112 360C112 364 108 368 104 368H40C36 368 32 364 32 360V296C32 292 36 288 40 288H104C108 288 112 292 112 296V360ZM124 200C117 215 113 231 112 248C112 253 109 256 105 256H40C36 256 32 252 32 247C33 216 41 186 54 159C55 156 58 155 61 155C63 155 64 155 66 156L121 190C124 193 125 197 124 200ZM181 134C168 142 158 151 148 162C146 163 144 165 142 165C141 165 139 164 138 163L83 129C79 126 78 121 81 117C99 94 122 74 148 60C150 59 151 59 152 59C155 59 159 61 160 64L184 125C185 128 184 132 181 134ZM299 112C298 115 295 117 291 117C291 117 290 117 289 116C278 114 267 112 256 112S234 114 223 117C222 117 221 117 221 117C217 117 214 115 213 112L189 51C188 47 190 42 195 41C214 35 235 32 256 32S298 35 317 41C322 42 324 47 323 51L299 112ZM374 163C373 164 371 164 370 164C368 164 365 163 364 162C354 151 344 142 331 134C328 132 327 128 328 125L352 64C353 61 357 59 360 59C361 59 362 59 363 60C390 74 413 94 431 117C434 121 433 126 429 129L374 163ZM388 200C387 197 388 193 391 190L446 156C448 155 449 155 451 155C454 155 457 156 458 159C471 186 479 216 480 248C480 252 476 256 472 256H407C403 256 400 253 400 248C399 231 395 215 388 200ZM480 472C480 476 476 480 472 480H408C404 480 400 476 400 472V408C400 404 404 400 408 400H472C476 400 480 404 480 408V472ZM480 360C480 364 476 368 472 368H408C404 368 400 364 400 360V296C400 292 404 288 408 288H472C476 288 480 292 480 296V360ZM256 192C247 192 240 199 240 208V464C240 473 247 480 256 480S272 473 272 464V208C272 199 265 192 256 192ZM320 224C311 224 304 231 304 240V464C304 473 311 480 320 480S336 473 336 464V240C336 231 329 224 320 224ZM192 224C183 224 176 231 176 240V464C176 473 183 480 192 480S208 473 208 464V240C208 231 201 224 192 224Z"]
  };
  var faE = {
    prefix: 'fal',
    iconName: 'e',
    icon: [320, 512, [], "e122", "M320 464C320 473 313 480 304 480H16C7 480 0 473 0 464V48C0 39 7 32 16 32H304C313 32 320 39 320 48S313 64 304 64H32V240H240C249 240 256 247 256 256S249 272 240 272H32V448H304C313 448 320 455 320 464Z"]
  };
  var faEar = {
    prefix: 'fal',
    iconName: 'ear',
    icon: [384, 512, [], "f5f0", "M192 0C86 0 0 86 0 192V368C0 447 65 512 144 512S288 447 288 368V358C345 325 384 263 384 192C384 86 298 0 192 0ZM272 330C262 336 256 347 256 358V368C256 430 206 480 144 480S32 430 32 368V192C32 104 104 32 192 32S352 104 352 192C352 249 321 302 272 330ZM280 99C254 74 220 62 185 64C118 68 64 128 64 199V240C64 249 71 256 80 256H86C100 256 112 268 112 282C112 289 109 295 104 300L66 338C60 345 60 355 66 361C70 364 74 366 78 366S86 364 89 361L127 323C138 312 144 297 144 282C144 253 123 230 96 225V199C96 145 137 99 187 96C213 95 239 104 258 122C277 141 288 165 288 192C288 201 295 208 304 208S320 201 320 192C320 157 306 124 280 99Z"]
  };
  var faEarDeaf = {
    prefix: 'fal',
    iconName: 'ear-deaf',
    icon: [512, 512, [], "f2a4", "M240 64C141 64 64 141 64 240C64 249 71 256 80 256S96 249 96 240C96 159 159 96 240 96C319 96 384 162 384 243C384 293 366 335 330 373L326 377L325 382C319 436 274 480 224 480C215 480 208 487 208 496S215 512 224 512C288 512 346 458 356 391C396 348 416 300 416 243C416 145 337 64 240 64ZM160 240C160 196 196 160 240 160S320 196 320 240C320 249 327 256 336 256S352 249 352 240C352 178 302 128 240 128S128 178 128 240C128 249 135 256 144 256S160 249 160 240ZM165 325L5 485C-2 491 -2 501 5 507C8 510 12 512 16 512S24 510 27 507L187 347C194 341 194 331 187 325S171 318 165 325ZM507 5C501 -2 491 -2 485 5L421 69C414 75 414 85 421 91C424 94 428 96 432 96S440 94 443 91L507 27C514 21 514 11 507 5Z"]
  };
  var faEarListen = {
    prefix: 'fal',
    iconName: 'ear-listen',
    icon: [512, 512, [], "f2a2", "M232 64C133 64 56 141 56 240C56 249 63 256 72 256S88 249 88 240C88 159 151 96 232 96C311 96 376 162 376 243C376 293 358 335 322 373L318 377L317 382C311 436 266 480 216 480C207 480 200 487 200 496S207 512 216 512C280 512 338 458 348 391C388 348 408 300 408 243C408 144 329 64 232 64ZM152 240C152 196 188 160 232 160S312 196 312 240C312 249 319 256 328 256S344 249 344 240C344 178 294 128 232 128S120 178 120 240C120 249 127 256 136 256S152 249 152 240ZM24 456C11 456 0 467 0 480C0 493 11 504 24 504C37 504 48 493 48 480C48 467 37 456 24 456ZM152 328C139 328 128 339 128 352S139 376 152 376C165 376 176 365 176 352S165 328 152 328ZM67 373C61 366 51 366 45 373S38 389 45 395L109 459C112 462 116 464 120 464S128 462 131 459C138 453 138 443 131 437L67 373ZM349 1C341 -2 332 3 329 11C326 19 331 28 339 31C419 58 472 132 472 216V224C472 233 479 240 488 240S504 233 504 224V216C504 118 442 32 349 1Z"]
  };
  var faEarMuffs = {
    prefix: 'fal',
    iconName: 'ear-muffs',
    icon: [640, 512, [], "f795", "M147 224C137 224 127 228 119 235C108 229 94 229 85 233C73 238 64 247 60 258C48 259 37 265 30 274C23 284 19 295 20 307C11 313 4 323 1 335C-1 346 1 358 6 368C1 377 -1 389 1 401C4 413 10 422 20 429C19 440 22 452 29 461C37 470 47 476 59 478C64 489 72 498 83 502C95 507 107 506 119 501C127 508 137 512 147 512C172 512 192 491 192 466C192 456 188 448 185 442C189 434 192 426 192 417C192 408 190 400 185 392C190 385 192 377 192 368S190 351 185 343C190 336 192 328 192 319C192 310 189 302 185 294C189 287 192 278 192 270C192 245 172 224 147 224ZM156 310C159 313 160 316 160 319C160 323 159 326 157 328C149 337 149 350 157 359C159 362 160 365 160 368S159 374 157 377C149 386 149 399 157 408C159 410 160 413 160 417C160 420 159 423 156 426C149 435 149 448 156 457C158 459 160 462 160 466C160 474 154 480 147 480C143 480 140 477 138 475C134 470 127 467 120 467C115 467 111 468 107 471C103 474 99 474 95 473C92 471 89 468 88 464C85 454 76 446 65 446C61 446 57 445 54 441C52 438 51 434 52 429C54 419 49 408 39 403C35 401 33 397 32 394C31 390 32 386 35 383C42 374 42 362 35 353C33 350 32 346 32 342C34 338 36 334 39 332C49 328 54 317 52 306C51 302 52 297 55 294C57 291 61 290 65 290C76 291 86 282 89 272C90 268 92 265 97 263C99 262 104 262 107 265C118 271 131 269 138 260C140 258 143 256 147 256C154 256 160 262 160 270C160 273 159 276 156 279C149 288 149 301 156 310ZM639 335C636 323 630 314 620 307C621 296 618 284 611 275C603 266 593 260 581 258C576 247 568 238 557 234C545 229 533 230 521 235C513 228 503 224 493 224C468 224 448 245 448 270C448 280 452 288 455 294C451 302 448 310 448 319C448 328 450 336 455 344C450 351 448 359 448 368S450 385 455 393C450 400 448 408 448 417C448 426 451 434 455 442C451 449 448 458 448 466C448 492 468 512 493 512C503 512 513 508 521 502C532 507 546 507 555 503C567 498 576 490 580 478C592 477 603 471 610 462C617 453 621 441 620 429C629 423 636 413 639 401C641 390 640 378 634 368C639 359 641 347 639 335ZM605 383C608 386 608 390 608 394C607 399 604 402 601 404C591 408 586 419 588 430C589 434 588 439 585 442C583 445 579 447 575 446C564 446 554 454 551 464C550 468 548 472 543 473C541 474 536 474 533 471C522 465 509 467 502 476C500 478 497 480 493 480C486 480 480 474 480 466C480 463 481 460 484 457C491 448 491 435 484 426C481 423 480 420 480 417C480 413 481 410 483 408C491 399 491 386 483 377C481 374 480 371 480 368S481 362 483 359C491 350 491 337 483 328C481 326 480 323 480 319C480 316 481 313 484 310C491 301 491 288 484 279C482 277 480 274 480 270C480 262 486 256 493 256C497 256 500 259 502 261C510 270 523 272 534 265C538 263 541 262 545 263C548 265 551 268 552 272C555 282 564 290 575 290C579 290 583 291 586 295C588 298 589 302 588 307C586 317 591 328 601 333C605 335 607 339 608 342C609 346 608 350 605 353C598 362 598 374 605 383ZM507 180C509 187 515 192 522 192C524 192 525 192 526 192C535 190 540 181 538 172C514 71 424 0 320 0S126 71 102 172C100 181 105 190 114 192C122 194 131 188 133 180C154 93 231 32 320 32S486 93 507 180Z"]
  };
  var faEarthAfrica = {
    prefix: 'fal',
    iconName: 'earth-africa',
    icon: [512, 512, [], "f57c", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256C496 127 390 16 256 16ZM272 80C288 80 300 68 303 54C363 67 413 107 440 160H431C414 160 400 174 400 191L400 198L388 205C385 205 379 205 373 206C340 207 326 208 320 220L316 230L334 258C340 267 350 272 360 272L368 271L368 282L349 308C346 311 345 316 344 321L339 343C329 353 320 363 312 375L299 395C294 402 282 401 279 393C274 385 272 375 272 365V335C272 318 258 304 241 304H215C204 304 195 300 187 293C180 285 176 276 176 265V251C176 239 182 228 191 220L219 200C224 196 242 187 260 196L275 203C287 209 297 206 299 205L346 189C359 185 368 173 368 159C368 142 354 128 337 128L327 128L320 121C314 115 306 112 298 112L208 113C207 102 228 111 241 92L248 80H272ZM256 464C141 464 48 371 48 256C48 146 134 55 243 49C234 50 226 55 221 63L214 75L200 78C185 81 174 94 176 116C178 132 192 145 208 145H208L298 144L304 151C310 157 318 160 327 160C327 160 327 160 327 160L337 160L289 175L275 167C265 163 254 160 243 160C227 160 212 165 200 174L172 195C155 208 144 229 144 251V265C144 284 151 302 165 315C178 329 196 336 215 336H241L240 365C240 380 243 395 250 408C257 422 272 432 289 432C304 432 318 425 326 413L339 393C345 383 353 374 361 367C366 362 370 356 371 349L375 327L394 302C398 296 400 289 400 282L400 271C400 262 396 254 390 248C384 243 368 239 360 239C355 239 393 236 394 236C397 235 400 234 402 233L415 226C426 221 433 209 432 197L432 192H449C451 192 452 192 454 191C460 212 464 233 464 256C464 371 371 464 256 464Z"]
  };
  var faEarthAmericas = {
    prefix: 'fal',
    iconName: 'earth-americas',
    icon: [512, 512, [], "f57d", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM208 458C116 436 48 354 48 256C48 247 49 239 50 231C55 238 59 245 63 250C69 259 76 267 84 275C95 285 107 293 120 299C133 306 154 317 168 325C173 328 176 333 176 339V371C176 384 181 396 190 405C203 417 209 436 208 445V458ZM301 399L277 463C270 464 263 464 256 464C251 464 245 464 240 463V447C242 428 230 400 213 382C210 379 208 375 208 371V339C208 321 198 305 183 297C169 289 148 277 134 270C124 265 114 259 105 250C99 245 94 239 89 232C81 221 69 203 60 188C84 118 145 64 221 51L265 96L250 111C241 120 241 134 249 144H244C237 144 232 146 227 151L217 161C210 168 208 179 212 188L216 196C209 194 202 193 194 196L163 206C152 210 144 221 144 233C144 243 150 253 159 258L170 263C181 269 193 271 205 272C208 274 211 279 214 283C225 298 228 300 236 304H307C311 304 315 306 318 309L332 322C334 325 336 329 336 333C336 341 333 349 327 354L316 366C304 377 306 386 301 399ZM314 456L331 410C337 393 333 393 340 386L350 377C361 365 368 349 368 333C368 320 363 308 354 300L341 286C332 277 319 272 307 272H246C244 270 241 266 240 264C231 253 222 240 208 240C198 240 191 237 182 233L204 226L214 234C218 238 224 240 229 240H235C243 240 251 236 256 229C260 222 260 213 256 205L244 179C248 175 246 176 253 176C259 176 265 174 270 169L278 161C287 152 287 138 279 128L288 119C294 113 297 105 297 96S294 79 288 73L263 48C333 51 394 88 430 143L415 151C408 154 403 159 399 164L380 194C371 207 371 225 380 238L398 265C403 274 411 279 421 282L461 292C447 370 389 434 314 456ZM429 251C427 250 425 249 424 247L406 220C404 218 404 214 406 211L426 182C426 181 428 180 429 179L446 171C457 197 464 226 464 256C464 257 464 258 464 260L429 251Z"]
  };
  var faEarthAsia = {
    prefix: 'fal',
    iconName: 'earth-asia',
    icon: [512, 512, [], "f57e", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM48 256C48 141 141 48 256 48C272 48 288 50 303 54L259 91C252 96 247 104 248 113C248 121 254 129 261 133L272 138V202C270 202 268 201 267 201C259 201 252 205 248 211L231 240C222 240 214 243 208 249L202 255C198 260 195 266 195 272S198 285 202 289L208 295V304H186L163 259C160 252 153 247 146 246C138 245 130 247 125 253L105 272H49C48 267 48 261 48 256ZM440 353C431 370 419 386 406 400H399C395 400 391 398 388 395L375 382C368 376 359 373 349 375C328 381 328 381 324 381H314C310 381 306 379 303 376L291 365C289 363 288 361 288 359V349C288 345 290 342 294 341L333 325C335 325 337 324 338 322L362 306C364 305 365 304 367 304H379C382 304 385 306 386 309L392 322C392 323 394 324 395 324H399C401 324 402 323 403 321L407 307C408 305 409 304 411 304H417C419 304 421 306 421 308V321C421 323 422 325 423 327L435 338C440 343 440 348 440 353ZM453 311V308C453 288 437 272 417 272H411C406 272 400 273 396 276C390 273 385 272 379 272H367C358 272 350 275 344 279L320 296L282 311C266 318 256 332 256 349V359C256 369 261 379 268 387L280 399C289 408 301 413 314 413H324C328 413 332 413 336 412L354 407L365 418C368 421 372 424 376 426C342 450 301 464 256 464C158 464 76 396 54 304H105C114 304 122 301 128 295L140 283L157 318C163 329 174 336 186 336H208C226 336 240 322 240 304V295C240 286 237 278 231 272L231 272C242 272 253 266 258 257L269 238C272 239 276 240 280 240C293 240 304 229 304 216V138C304 126 297 115 286 109L339 65C412 97 464 171 464 256C464 276 461 295 456 314L453 311Z"]
  };
  var faEarthEuropa = {
    prefix: 'fal',
    iconName: 'earth-europa',
    icon: [512, 512, [], "f7a2", "M192 119C192 112 186 107 179 107H179C176 107 173 108 170 110L142 139C139 141 138 144 138 148V148C138 155 144 160 151 160H169C172 160 175 159 178 157L188 146C191 144 192 141 192 137V119ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM304 458V432C304 406 283 384 256 384H236C232 384 223 381 220 379L197 362C194 359 192 355 192 351V327C192 323 194 318 198 316L241 290C244 289 246 288 248 288H279C283 288 286 289 288 291L341 336H371L388 353C398 363 410 368 423 368H431C402 413 357 446 304 458ZM448 336H424C419 336 414 334 411 331L393 313C387 307 379 304 371 304H353L309 267C301 260 291 256 280 256H248C240 256 232 258 225 262L182 288C168 296 160 311 160 327V351C160 365 167 379 178 388L201 404C209 411 225 416 236 416H256C265 416 272 423 272 432V463C267 464 261 464 256 464C141 464 48 371 48 256C48 146 135 55 243 49L240 51C230 59 224 70 224 82V106C224 112 227 123 230 128C229 130 209 143 205 146C197 155 192 166 192 179V195C192 220 212 240 237 240H263C274 240 284 237 292 230C296 231 300 232 305 232H318C344 232 350 212 354 210C359 219 368 227 377 230C373 244 377 260 388 271L406 291C414 299 426 305 438 305H458C455 315 452 326 448 336ZM439 272C435 272 432 271 429 268L411 249C407 245 407 239 411 235C423 222 421 226 421 217C421 215 420 212 418 210L410 203C409 201 406 200 404 200H390C382 200 378 190 384 184L392 176C393 174 396 174 398 174H407C412 174 416 169 416 164V154C416 149 412 144 407 144H378C371 144 365 150 365 158V163C365 169 361 174 356 176L329 185C325 186 325 190 325 193C325 197 322 200 318 200H305C301 200 298 197 298 193C298 185 285 184 283 190C274 202 271 208 263 208H237C230 208 224 202 224 195V178C224 175 225 171 228 169C247 155 257 151 257 137C257 134 259 132 262 131L296 120C297 119 298 119 299 118L322 95C327 90 325 80 315 80H298L284 99V106C284 109 281 112 278 112H263C259 112 256 109 256 106V82C256 80 257 78 259 77L294 52C391 70 464 154 464 256C464 262 464 267 463 272H439Z"]
  };
  var faEclipse = {
    prefix: 'fal',
    iconName: 'eclipse',
    icon: [640, 512, [], "f749", "M256 467L208 396C205 391 200 389 194 389C193 389 192 389 191 389L107 406L123 321C124 314 122 308 116 304L45 256L116 208C122 204 124 198 123 191L107 107L191 123C198 124 204 121 208 116L256 45L281 82C286 89 297 91 304 85C304 85 304 85 305 84C311 79 312 70 307 64L269 7C266 3 261 0 256 0C251 0 246 3 243 7L187 89L89 71C84 70 79 71 75 75S70 84 71 89L89 187L7 243C3 246 0 251 0 256C0 261 3 266 7 269L89 325L70 423C70 428 71 433 75 437C79 441 84 442 89 441L187 423L243 505C246 509 251 512 256 512C261 512 266 509 269 505L307 449C312 442 310 433 304 427C304 427 304 427 304 427C297 421 286 423 281 431L256 467ZM241 171C241 171 241 171 241 170C246 158 235 145 222 149C205 155 190 164 177 177C139 215 133 271 162 320C170 332 180 342 192 350C202 356 212 360 223 363C235 367 246 354 241 342C241 342 241 342 241 341C239 337 236 334 231 332C224 330 216 327 208 322C201 318 194 311 190 304C164 260 179 220 199 199C208 191 219 184 232 180C236 179 239 175 241 171ZM448 64C342 64 256 150 256 256C256 362 342 448 448 448C554 448 640 362 640 256C640 150 554 64 448 64ZM448 416C360 416 288 344 288 256S360 96 448 96S608 168 608 256S536 416 448 416Z"]
  };
  var faEgg = {
    prefix: 'fal',
    iconName: 'egg',
    icon: [384, 512, [], "f7fb", "M192 16C86 16 0 217 0 316S86 496 192 496C298 496 384 415 384 316S298 16 192 16ZM192 464C104 464 32 398 32 316C32 222 114 48 192 48S352 222 352 316C352 398 280 464 192 464ZM135 118C101 161 64 240 64 304C64 313 71 320 80 320S96 313 96 304C96 250 129 177 160 138C166 131 165 121 158 116C151 110 141 111 135 118Z"]
  };
  var faEggFried = {
    prefix: 'fal',
    iconName: 'egg-fried',
    icon: [512, 512, [], "f7fc", "M224 168V168C184 168 152 200 152 240C152 249 159 256 168 256S184 249 184 240C184 218 202 200 224 200C233 200 240 193 240 184C240 175 233 168 224 168ZM478 150C439 110 378 104 334 68C290 32 256 0 200 0C192 0 184 1 175 2C89 16 64 82 50 159C39 224 -4 286 0 352C5 418 53 481 115 503C133 509 149 512 164 512C229 512 273 461 320 417C364 375 413 379 461 343C517 300 533 202 478 150ZM480 240C478 271 463 300 442 317C424 331 404 338 383 346C357 355 326 366 298 393C292 398 287 404 282 409C244 446 208 480 164 480C152 480 140 478 126 473C75 454 36 403 32 350C30 318 43 283 56 248C66 221 77 194 82 165C97 77 123 43 180 34C187 33 194 32 200 32C240 32 267 54 304 85L314 93C337 112 364 124 389 134C414 145 438 155 456 174C479 195 481 224 480 240ZM224 112C153 112 96 169 96 240C96 311 153 368 224 368S352 311 352 240S295 112 224 112ZM224 336C171 336 128 293 128 240S171 144 224 144S320 187 320 240S277 336 224 336Z"]
  };
  var faEject = {
    prefix: 'fal',
    iconName: 'eject',
    icon: [448, 512, [], "f052", "M48 352H400C442 352 463 302 435 272L259 79C250 69 237 64 224 64C211 64 198 69 189 79L13 272C-15 302 6 352 48 352ZM36 293L212 101C216 97 221 96 224 96C227 96 232 97 236 101L412 293C418 300 416 308 415 310C413 313 409 320 400 320H48C39 320 35 313 33 310C32 308 30 300 36 293ZM432 416H16C7 416 0 423 0 432S7 448 16 448H432C441 448 448 441 448 432S441 416 432 416Z"]
  };
  var faElephant = {
    prefix: 'fal',
    iconName: 'elephant',
    icon: [640, 512, [], "f6da", "M528 32H455C437 13 412 0 384 0S331 13 313 32H176C79 32 0 111 0 208V352C0 361 7 368 16 368S32 361 32 352V208C32 129 97 64 176 64H294C290 74 288 85 288 96C288 137 315 174 353 187C358 208 377 224 400 224H432C441 224 448 217 448 208S441 192 432 192H400C391 192 384 185 384 174C384 167 379 160 371 159C342 153 320 126 320 96C320 61 349 32 384 32S448 61 448 96C448 105 455 112 464 112S480 105 480 96C480 85 478 74 474 64H528C572 64 608 100 608 144V368C608 394 586 416 560 416S512 394 512 368C512 359 505 352 496 352S480 359 480 368C480 412 516 448 560 448S640 412 640 368V144C640 82 590 32 528 32ZM544 144C544 135 537 128 528 128S512 135 512 144C512 153 519 160 528 160S544 153 544 144ZM576 288C576 279 569 272 560 272H432C423 272 416 279 416 288V464C416 473 409 480 400 480H368C359 480 352 473 352 464V389C364 381 374 370 379 359C383 351 379 341 371 337C363 334 354 337 350 345C341 364 306 384 256 384S171 364 162 345C158 337 149 334 141 337C133 341 129 351 133 359C138 370 148 381 160 389V464C160 473 153 480 144 480H112C103 480 96 473 96 464V240C96 231 89 224 80 224S64 231 64 240V464C64 490 86 512 112 512H144C170 512 192 490 192 464V405C211 412 233 416 256 416S301 412 320 405V464C320 490 342 512 368 512H400C426 512 448 490 448 464V304H560C569 304 576 297 576 288Z"]
  };
  var faEllipsis = {
    prefix: 'fal',
    iconName: 'ellipsis',
    icon: [512, 512, [], "f141", "M256 224C238 224 224 238 224 256C224 274 238 288 256 288S288 274 288 256C288 238 274 224 256 224ZM96 224C78 224 64 238 64 256C64 274 78 288 96 288S128 274 128 256C128 238 114 224 96 224ZM416 224C398 224 384 238 384 256C384 274 398 288 416 288S448 274 448 256C448 238 434 224 416 224Z"]
  };
  var faEllipsisStroke = {
    prefix: 'fal',
    iconName: 'ellipsis-stroke',
    icon: [512, 512, [], "f39b", "M256 192C221 192 192 221 192 256S221 320 256 320S320 291 320 256S291 192 256 192ZM256 288C238 288 224 274 224 256S238 224 256 224S288 238 288 256S274 288 256 288ZM448 192C413 192 384 221 384 256S413 320 448 320S512 291 512 256S483 192 448 192ZM448 288C430 288 416 274 416 256S430 224 448 224S480 238 480 256S466 288 448 288ZM64 192C29 192 0 221 0 256S29 320 64 320S128 291 128 256S99 192 64 192ZM64 288C46 288 32 274 32 256S46 224 64 224S96 238 96 256S82 288 64 288Z"]
  };
  var faEllipsisStrokeVertical = {
    prefix: 'fal',
    iconName: 'ellipsis-stroke-vertical',
    icon: [256, 512, [], "f39c", "M128 384C93 384 64 413 64 448S93 512 128 512S192 483 192 448S163 384 128 384ZM128 480C110 480 96 466 96 448S110 416 128 416S160 430 160 448S146 480 128 480ZM128 128C163 128 192 99 192 64S163 0 128 0S64 29 64 64S93 128 128 128ZM128 32C146 32 160 46 160 64S146 96 128 96S96 82 96 64S110 32 128 32ZM128 192C93 192 64 221 64 256S93 320 128 320S192 291 192 256S163 192 128 192ZM128 288C110 288 96 274 96 256S110 224 128 224S160 238 160 256S146 288 128 288Z"]
  };
  var faEllipsisVertical = {
    prefix: 'fal',
    iconName: 'ellipsis-vertical',
    icon: [128, 512, [], "f142", "M64 128C82 128 96 114 96 96S82 64 64 64C46 64 32 78 32 96S46 128 64 128ZM64 224C46 224 32 238 32 256S46 288 64 288C82 288 96 274 96 256S82 224 64 224ZM64 384C46 384 32 398 32 416S46 448 64 448C82 448 96 434 96 416S82 384 64 384Z"]
  };
  var faEmptySet = {
    prefix: 'fal',
    iconName: 'empty-set',
    icon: [512, 512, [], "f656", "M491 16C485 10 475 10 469 16L391 93C355 62 308 43 256 43C141 43 48 136 48 251C48 303 67 350 98 387L21 464C14 470 14 480 21 487C24 490 28 491 32 491S40 490 43 487L121 409C157 440 204 459 256 459C371 459 464 366 464 251C464 200 445 152 414 116L491 39C498 32 498 22 491 16ZM80 251C80 154 159 75 256 75C299 75 338 91 369 116L121 364C95 333 80 294 80 251ZM432 251C432 348 353 427 256 427C213 427 174 412 143 386L391 139C417 169 432 209 432 251Z"]
  };
  var faEngine = {
    prefix: 'fal',
    iconName: 'engine',
    icon: [640, 512, [], "e123", "M608 192H576A32 32 0 0 0 544 224V256H512V208A16 16 0 0 0 506 195L435 139A48 48 0 0 0 405 128H304V96H384A16 16 0 0 0 384 64H192A16 16 0 0 0 192 96H272V128H112A48 48 0 0 0 64 176V240H32V144A16 16 0 0 0 0 144V368A16 16 0 0 0 32 368V272H64V336A48 48 0 0 0 112 384H153L203 434A48 48 0 0 0 237 448H464A48 48 0 0 0 512 400V384H544V416A32 32 0 0 0 576 448H608A32 32 0 0 0 640 416V224A32 32 0 0 0 608 192ZM480 400A16 16 0 0 1 464 416H237A16 16 0 0 1 226 411L171 357A16 16 0 0 0 160 352H112A16 16 0 0 1 96 336V176A16 16 0 0 1 112 160H405A16 16 0 0 1 415 164L480 216ZM608 416H576V368A16 16 0 0 0 560 352H512V288H560A16 16 0 0 0 576 272V224H608ZM192 232A24 24 0 1 0 216 256A24 24 0 0 0 192 232ZM288 232A24 24 0 1 0 312 256A24 24 0 0 0 288 232ZM384 232A24 24 0 1 0 408 256A24 24 0 0 0 384 232Z"]
  };
  var faEngineWarning = {
    prefix: 'fal',
    iconName: 'engine-warning',
    icon: [640, 512, [], "f5f2", "M288 304A16 16 0 0 0 304 288V192A16 16 0 0 0 272 192V288A16 16 0 0 0 288 304ZM288 328A24 24 0 1 0 312 352A24 24 0 0 0 288 328ZM608 192H576A32 32 0 0 0 544 224V256H512V208A16 16 0 0 0 506 195L435 139A48 48 0 0 0 405 128H304V96H384A16 16 0 0 0 384 64H192A16 16 0 0 0 192 96H272V128H112A48 48 0 0 0 64 176V240H32V144A16 16 0 0 0 0 144V368A16 16 0 0 0 32 368V272H64V336A48 48 0 0 0 112 384H153L203 434A48 48 0 0 0 237 448H464A48 48 0 0 0 512 400V384H544V416A32 32 0 0 0 576 448H608A32 32 0 0 0 640 416V224A32 32 0 0 0 608 192ZM480 400A16 16 0 0 1 464 416H237A16 16 0 0 1 226 411L171 357A16 16 0 0 0 160 352H112A16 16 0 0 1 96 336V176A16 16 0 0 1 112 160H405A16 16 0 0 1 415 164L480 216ZM608 416H576V368A16 16 0 0 0 560 352H512V288H560A16 16 0 0 0 576 272V224H608Z"]
  };
  var faEnvelope = {
    prefix: 'fal',
    iconName: 'envelope',
    icon: [512, 512, [], "f0e0", "M448 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H448C483 448 512 419 512 384V128C512 93 483 64 448 64ZM64 96H448C466 96 480 110 480 128V164L285 310C268 323 244 323 227 310L32 164V128C32 110 46 96 64 96ZM480 384C480 402 466 416 448 416H64C46 416 32 402 32 384V204L208 336C222 347 239 352 256 352S290 347 304 336L480 204V384Z"]
  };
  var faEnvelopeDot = {
    prefix: 'fal',
    iconName: 'envelope-dot',
    icon: [576, 512, [], "e124", "M480 0C445 0 416 29 416 64S445 128 480 128S544 99 544 64S515 0 480 0ZM480 96C462 96 448 82 448 64S462 32 480 32S512 46 512 64S498 96 480 96ZM496 164H485C482 164 478 165 476 167L285 310C268 323 244 323 227 310L32 164V128C32 110 46 96 64 96H368C377 96 384 89 384 80C384 71 377 64 368 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H448C483 448 512 419 512 384V180C512 171 505 164 496 164ZM480 384C480 402 466 416 448 416H64C46 416 32 402 32 384V204L208 336C222 347 239 352 256 352S290 347 304 336L480 204V384Z"]
  };
  var faEnvelopeOpen = {
    prefix: 'fal',
    iconName: 'envelope-open',
    icon: [512, 512, [], "f2b6", "M494 163C469 143 448 128 329 41C313 29 280 0 256 0C256 0 256 0 256 0C256 0 256 0 256 0C232 0 199 29 183 41C64 128 43 143 18 163C7 172 0 186 0 201V464C0 490 22 512 48 512H464C490 512 512 490 512 464V201C512 186 505 172 494 163ZM480 464C480 473 473 480 464 480H48C39 480 32 473 32 464V201C32 196 34 191 38 188C62 170 81 155 202 67C204 65 208 62 212 59C221 52 246 33 256 32C266 33 291 52 300 59C304 62 307 65 311 67C431 155 450 170 474 188C478 191 480 196 480 201V464ZM423 259L290 357C270 371 242 371 222 357L89 259C82 254 72 255 67 263C62 270 63 280 71 285L203 383C219 394 237 400 256 400S293 394 309 383L441 285C449 280 450 270 445 263C440 255 430 254 423 259Z"]
  };
  var faEnvelopeOpenDollar = {
    prefix: 'fal',
    iconName: 'envelope-open-dollar',
    icon: [512, 512, [], "f657", "M496 192C487 192 480 199 480 208V464C480 473 473 480 464 480H48C39 480 32 473 32 464V208C32 199 25 192 16 192S0 199 0 208V464C0 490 22 512 48 512H464C490 512 512 490 512 464V208C512 199 505 192 496 192ZM65 276C65 277 65 278 66 279C66 280 67 281 67 282C68 282 69 283 70 284C70 284 70 285 71 285L203 383C219 394 237 400 256 400S293 394 309 383L441 285C442 285 442 284 442 284C443 283 444 282 445 282C445 281 446 280 446 279C447 278 447 277 447 276C447 275 448 274 448 273C448 273 448 272 448 272V48C448 22 426 0 400 0H112C86 0 64 22 64 48V272C64 272 64 273 64 273C64 274 65 275 65 276ZM96 48C96 39 103 32 112 32H400C409 32 416 39 416 48V264L290 357C270 371 242 371 222 357L96 264V48ZM240 272V288C240 297 247 304 256 304S272 297 272 288V272C272 271 272 271 272 270C294 267 310 254 314 234C321 194 283 183 260 177L255 175C228 167 229 162 230 156C232 145 249 142 265 145C270 146 277 148 283 150C291 153 300 148 303 140C306 132 302 123 293 120C285 117 278 115 272 114C272 113 272 113 272 112V96C272 87 265 80 256 80S240 87 240 96V112C240 112 240 113 240 113C218 117 202 130 198 150C191 190 230 201 246 206L252 207C280 216 284 219 282 228C280 239 263 242 247 239C240 238 231 235 223 232L219 230C210 227 201 232 198 240C195 248 200 258 208 260L212 262C221 265 231 268 240 270C240 271 240 271 240 272Z"]
  };
  var faEnvelopeOpenText = {
    prefix: 'fal',
    iconName: 'envelope-open-text',
    icon: [512, 512, [], "f658", "M496 192C487 192 480 199 480 208V464C480 473 473 480 464 480H48C39 480 32 473 32 464V208C32 199 25 192 16 192S0 199 0 208V464C0 490 22 512 48 512H464C490 512 512 490 512 464V208C512 199 505 192 496 192ZM65 276C65 277 65 278 66 279C66 280 67 281 67 282C68 282 69 283 70 284C70 284 70 285 71 285L203 383C219 394 237 400 256 400S293 394 309 383L441 285C442 285 442 284 442 284C443 283 444 282 445 282C445 281 446 280 446 279C447 278 447 277 447 276C447 275 448 274 448 273C448 273 448 272 448 272V48C448 22 426 0 400 0H112C86 0 64 22 64 48V272C64 272 64 273 64 273C64 274 65 275 65 276ZM96 48C96 39 103 32 112 32H400C409 32 416 39 416 48V264L290 357C270 371 242 371 222 357L96 264V48ZM352 240C352 231 345 224 336 224H176C167 224 160 231 160 240C160 249 167 256 176 256H336C345 256 352 249 352 240ZM176 160H336C345 160 352 153 352 144C352 135 345 128 336 128H176C167 128 160 135 160 144C160 153 167 160 176 160Z"]
  };
  var faEnvelopes = {
    prefix: 'fal',
    iconName: 'envelopes',
    icon: [640, 512, [], "e125", "M464 448H96C61 448 32 419 32 384V112C32 103 25 96 16 96S0 103 0 112V384C0 437 43 480 96 480H464C473 480 480 473 480 464S473 448 464 448ZM544 32H160C125 32 96 61 96 96V320C96 355 125 384 160 384H544C579 384 608 355 608 320V96C608 61 579 32 544 32ZM576 320C576 338 562 352 544 352H160C142 352 128 338 128 320V140L304 272C318 283 335 288 352 288S386 283 400 272L576 140V320ZM576 100L381 246C364 259 340 259 323 246L128 100V96C128 78 142 64 160 64H544C562 64 576 78 576 96V100Z"]
  };
  var faEnvelopesBulk = {
    prefix: 'fal',
    iconName: 'envelopes-bulk',
    icon: [640, 512, [], "f674", "M80 160C89 160 96 153 96 144V64C96 46 110 32 128 32H384C402 32 416 46 416 64H448C448 29 419 0 384 0H128C93 0 64 29 64 64V144C64 153 71 160 80 160ZM576 96H256C221 96 192 125 192 160H224C224 142 238 128 256 128H576C594 128 608 142 608 160V352C608 370 594 384 576 384H432C423 384 416 391 416 400C416 409 423 416 432 416H576C611 416 640 387 640 352V160C640 125 611 96 576 96ZM560 256C569 256 576 249 576 240V176C576 167 569 160 560 160H496C487 160 480 167 480 176V240C480 249 487 256 496 256H560ZM512 192H544V224H512V192ZM320 192H64C29 192 0 221 0 256V448C0 483 29 512 64 512H320C355 512 384 483 384 448V256C384 221 355 192 320 192ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V314C45 323 64 339 128 384C141 394 166 416 192 416S243 394 256 384C320 339 339 323 352 314V448ZM352 275C326 294 330 294 237 362C227 365 208 384 192 384S157 365 147 358C54 291 58 291 32 272V256C32 238 46 224 64 224H320C338 224 352 238 352 256V275Z"]
  };
  var faEquals = {
    prefix: 'fal',
    iconName: 'equals',
    icon: [448, 512, [], "f52c", "M16 176H432C441 176 448 169 448 160S441 144 432 144H16C7 144 0 151 0 160S7 176 16 176ZM432 336H16C7 336 0 343 0 352S7 368 16 368H432C441 368 448 361 448 352S441 336 432 336Z"]
  };
  var faEraser = {
    prefix: 'fal',
    iconName: 'eraser',
    icon: [512, 512, [], "f12d", "M496 434L496 434L324 434L498 260C516 241 516 211 498 192L338 32C319 13 289 13 270 32L14 288C-5 307 -5 337 14 356L110 452C119 461 131 466 144 466H496C496 466 496 466 496 466C505 466 512 459 512 450C512 441 505 434 496 434ZM293 55C299 48 309 48 315 55L475 215C481 221 481 231 475 237L358 354L176 171L293 55ZM272 434H144C140 434 136 432 133 429L37 333C30 327 30 317 37 311L153 194L336 377L283 429C280 432 276 434 272 434Z"]
  };
  var faEthernet = {
    prefix: 'fal',
    iconName: 'ethernet',
    icon: [512, 512, [], "f796", "M480 192H448V160C448 142 434 128 416 128H384V96C384 78 370 64 352 64H160C142 64 128 78 128 96V128H96C78 128 64 142 64 160V192H32C14 192 0 206 0 224V416C0 434 14 448 32 448H480C498 448 512 434 512 416V224C512 206 498 192 480 192ZM480 416H416V336C416 327 409 320 400 320S384 327 384 336V416H320V336C320 327 313 320 304 320S288 327 288 336V416H224V336C224 327 217 320 208 320S192 327 192 336V416H128V336C128 327 121 320 112 320S96 327 96 336V416H32V224H96V160H160V96H352V160H416V224H480V416Z"]
  };
  var faEuroSign = {
    prefix: 'fal',
    iconName: 'euro-sign',
    icon: [384, 512, [], "f153", "M351 450C354 458 349 467 341 470C320 477 299 480 277 480C181 480 99 412 73 320H48C39 320 32 313 32 304S39 288 48 288H66C65 278 64 267 64 256C64 246 65 237 66 227H48C39 227 32 220 32 211S39 195 48 195H72C98 101 180 32 277 32C299 32 320 35 341 42C349 45 354 54 351 62S339 75 331 73C314 67 296 64 277 64C197 64 130 119 106 195H288C297 195 304 202 304 211S297 227 288 227H98C97 237 96 246 96 256C96 267 97 278 99 288H272C281 288 288 295 288 304S281 320 272 320H107C132 394 199 448 277 448C296 448 314 445 331 439C339 437 348 441 351 450Z"]
  };
  var faExclamation = {
    prefix: 'fal',
    iconName: 'exclamation',
    icon: [128, 512, [], "f12a", "M64 400C46 400 32 414 32 432S46 464 64 464S96 450 96 432S82 400 64 400ZM64 352C73 352 80 345 80 336V48C80 39 73 32 64 32S48 39 48 48V336C48 345 55 352 64 352Z"]
  };
  var faExpand = {
    prefix: 'fal',
    iconName: 'expand',
    icon: [448, 512, [], "f065", "M144 32H16C7 32 0 39 0 48V176C0 185 7 192 16 192S32 185 32 176V64H144C153 64 160 57 160 48S153 32 144 32ZM144 448H32V336C32 327 25 320 16 320S0 327 0 336V464C0 473 7 480 16 480H144C153 480 160 473 160 464S153 448 144 448ZM432 320C423 320 416 327 416 336V448H304C295 448 288 455 288 464S295 480 304 480H432C441 480 448 473 448 464V336C448 327 441 320 432 320ZM432 32H304C295 32 288 39 288 48S295 64 304 64H416V176C416 185 423 192 432 192S448 185 448 176V48C448 39 441 32 432 32Z"]
  };
  var faExpandWide = {
    prefix: 'fal',
    iconName: 'expand-wide',
    icon: [512, 512, [], "f320", "M144 64H16C7 64 0 71 0 80V208C0 217 7 224 16 224S32 217 32 208V96H144C153 96 160 89 160 80S153 64 144 64ZM144 416H32V304C32 295 25 288 16 288S0 295 0 304V432C0 441 7 448 16 448H144C153 448 160 441 160 432S153 416 144 416ZM496 288C487 288 480 295 480 304V416H368C359 416 352 423 352 432S359 448 368 448H496C505 448 512 441 512 432V304C512 295 505 288 496 288ZM496 64H368C359 64 352 71 352 80S359 96 368 96H480V208C480 217 487 224 496 224S512 217 512 208V80C512 71 505 64 496 64Z"]
  };
  var faEye = {
    prefix: 'fal',
    iconName: 'eye',
    icon: [576, 512, [], "f06e", "M288 128C217 128 160 185 160 256S217 384 288 384H288C359 384 416 327 416 256V256C416 185 359 128 288 128ZM288 352C235 352 192 309 192 256S235 160 288 160C341 160 384 203 384 256C384 309 341 352 288 352ZM573 239C518 116 411 32 288 32S58 116 3 239C2 243 0 251 0 256C0 261 2 269 3 273C58 396 165 480 288 480S518 396 573 273C574 269 576 261 576 256C576 251 574 243 573 239ZM543 260C492 376 395 448 288 448C181 448 84 376 33 261C33 260 32 257 32 256C32 255 33 252 33 252C84 136 181 64 288 64C395 64 492 136 543 251C543 252 544 255 544 256C544 257 543 260 543 260Z"]
  };
  var faEyeDropper = {
    prefix: 'fal',
    iconName: 'eye-dropper',
    icon: [512, 512, [], "f1fb", "M481 30C441 -10 371 -10 331 30L216 145L203 132C197 126 187 126 181 132C174 138 174 148 181 155L357 331C360 334 364 336 368 336S376 334 379 331C386 325 386 315 379 308L366 295L481 180C522 139 522 71 481 30ZM458 158L344 273L239 168L354 53C382 25 430 25 458 53C487 82 487 129 458 158ZM285 324L174 435C166 444 155 448 143 448H100C97 448 94 449 92 450L50 476L36 462L61 420C63 417 64 414 64 412V369C64 357 68 346 77 338L187 227C193 220 193 210 187 204C181 198 171 198 165 204L54 315C40 329 32 349 32 369V407L2 456C-1 462 -1 470 5 476L36 507C39 510 44 512 48 512C51 512 53 511 56 510L105 480H143C163 480 182 472 197 458L307 347C314 341 314 331 307 324C301 318 291 318 285 324Z"]
  };
  var faEyeDropperFull = {
    prefix: 'fal',
    iconName: 'eye-dropper-full',
    icon: [512, 512, [], "e126", "M187 204C181 198 171 198 165 204L54 315C40 329 32 349 32 369V407L2 456C-1 462 -1 470 5 476L36 507C39 510 44 512 48 512C51 512 53 511 56 510L105 480H143C163 480 182 472 197 458L307 347C314 341 314 331 307 324L187 204ZM174 435C166 444 155 448 143 448H100C97 448 94 449 92 450L50 476L36 462L61 420C63 417 64 414 64 412V369C64 357 68 346 77 338L176 238L273 336L174 435ZM481 30C441 -10 371 -10 331 30L216 145L203 132C197 126 187 126 181 132C174 138 174 148 181 155L357 331C360 334 364 336 368 336S376 334 379 331C386 325 386 315 379 308L366 295L481 180C522 139 522 71 481 30ZM458 158L344 273L239 168L354 53C382 25 430 25 458 53C487 82 487 129 458 158Z"]
  };
  var faEyeDropperHalf = {
    prefix: 'fal',
    iconName: 'eye-dropper-half',
    icon: [512, 512, [], "e127", "M481 30C441 -10 371 -10 331 30L216 145L203 132C197 126 187 126 181 132C174 138 174 148 181 155L357 331C360 334 364 336 368 336S376 334 379 331C386 325 386 315 379 308L366 295L481 180C522 139 522 71 481 30ZM458 158L344 273L239 168L354 53C382 25 430 25 458 53C487 82 487 129 458 158ZM294 320H94L187 227C194 220 194 210 187 204C181 198 171 198 165 204L54 315C40 329 32 349 32 369V407L2 456C-1 462 -1 470 5 476L36 507C39 510 44 512 48 512C51 512 53 511 56 510L105 480H143C163 480 182 472 197 458L307 347C314 341 314 331 307 324C304 321 299 319 294 320ZM174 435C166 444 155 448 143 448H100C97 448 94 449 92 450L50 476L36 462L61 420C63 417 64 414 64 412V369C64 363 65 357 67 352H257L174 435Z"]
  };
  var faEyeEvil = {
    prefix: 'fal',
    iconName: 'eye-evil',
    icon: [640, 512, [], "f6db", "M627 239L515 209C510 202 505 195 499 189C500 186 554 100 554 100C563 86 548 69 532 75L412 118C402 113 392 109 381 106L337 11C334 4 327 0 320 0S307 4 303 11L259 106C248 109 238 113 228 118C98 71 106 74 102 74C88 74 78 88 86 100C86 100 140 186 141 189C135 195 130 202 125 209L13 239C-4 244 -4 268 13 273L125 303C130 310 135 317 141 324C140 326 86 412 86 412C77 426 92 443 108 437L228 394C238 399 248 403 259 406L303 501C307 508 313 512 320 512S334 508 337 501L381 406C392 403 402 399 412 394L532 437C548 443 563 426 554 412C554 412 500 326 499 323C505 316 510 310 515 303L627 273C644 268 644 244 627 239ZM496 275C481 296 483 293 459 321L505 393L410 359C385 371 386 371 358 380L320 462L282 380C254 371 255 371 230 359L135 393L181 321C157 293 159 296 144 275L73 256L144 237C159 216 157 219 181 191L135 119L230 153C255 141 254 141 282 132L320 50L358 132C386 141 385 141 410 153L505 119L459 191C483 219 481 216 496 237L567 256L496 275ZM391 201C387 201 384 201 380 203C362 209 342 213 320 213C298 213 278 209 259 203C256 201 253 201 249 201C235 201 222 210 219 224C216 238 215 253 218 268C226 310 260 344 302 351C308 352 314 352 320 352C378 352 424 306 424 248C424 241 423 234 422 227C419 212 405 201 391 201ZM320 320C316 320 312 320 308 319C279 314 255 290 249 262C247 252 248 242 249 233C267 239 285 243 304 244V272C304 281 311 288 320 288S336 281 336 272V244C355 243 374 239 391 234C392 238 392 243 392 248C392 288 360 320 320 320Z"]
  };
  var faEyeLowVision = {
    prefix: 'fal',
    iconName: 'eye-low-vision',
    icon: [640, 512, [], "f2a8", "M634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483ZM273 137L304 162C309 161 314 160 320 160C371 160 412 200 415 250L446 274C447 268 448 262 448 256V256C448 185 391 128 320 128C303 128 287 131 273 137ZM320 64C427 64 524 136 575 251C575 252 576 255 576 256C576 257 575 260 575 260C562 289 547 316 528 339L553 359C573 333 591 304 605 273C606 269 608 261 608 256C608 251 606 243 605 239C550 116 443 32 320 32C272 32 226 45 185 68L213 90C246 73 283 64 320 64ZM106 163C99 158 89 159 83 166C78 173 79 183 86 188L406 444C409 447 412 448 416 448C421 448 425 446 429 442C434 435 433 425 426 419L106 163ZM66 216C59 211 49 212 43 219C38 226 39 236 46 241L334 472C337 474 340 475 344 475C349 475 353 473 356 469C362 462 361 452 354 447L66 216ZM58 298C51 292 41 294 35 300C30 307 31 317 38 323L230 477C233 479 236 480 240 480C245 480 249 478 253 474C258 467 257 457 250 451L58 298Z"]
  };
  var faEyeSlash = {
    prefix: 'fal',
    iconName: 'eye-slash',
    icon: [640, 512, [], "f070", "M273 137L304 162C309 161 314 160 320 160C371 160 412 200 415 250L446 274C447 268 448 262 448 256V256C448 185 391 128 320 128C303 128 287 131 273 137ZM320 448C213 448 116 376 65 261C65 260 64 257 64 256C64 255 65 252 65 252C78 223 93 196 112 173L87 153C67 179 49 208 35 239C34 243 32 251 32 256C32 261 34 269 35 273C90 396 197 480 320 480C368 480 414 467 455 444L427 422C394 439 357 448 320 448ZM320 64C427 64 524 136 575 251C575 252 576 255 576 256C576 257 575 260 575 260C562 289 547 316 528 339L553 359C573 333 591 304 605 273C606 269 608 261 608 256C608 251 606 243 605 239C550 116 443 32 320 32C272 32 226 45 185 68L213 90C246 73 283 64 320 64ZM320 384C337 384 353 381 367 375L336 350C331 351 326 352 320 352C269 352 228 312 225 262L194 238C193 244 192 250 192 256C192 327 249 384 320 384H320ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483Z"]
  };
  var faF = {
    prefix: 'fal',
    iconName: 'f',
    icon: [320, 512, [], "e128", "M320 48C320 57 313 64 304 64H32V256H240C249 256 256 263 256 272S249 288 240 288H32V464C32 473 25 480 16 480S0 473 0 464V48C0 39 7 32 16 32H304C313 32 320 39 320 48Z"]
  };
  var faFaceAngry = {
    prefix: 'fal',
    iconName: 'face-angry',
    icon: [512, 512, [], "f556", "M200 240C200 236 199 233 197 230C203 231 205 232 208 232C215 232 221 228 223 221C226 212 221 203 213 201L133 177C124 174 115 179 113 187C110 196 115 205 123 207L164 220C157 224 152 231 152 240C152 253 163 264 176 264S200 253 200 240ZM256 336C225 336 195 350 175 374C170 381 171 391 177 396C184 402 194 401 200 394C228 361 284 361 312 394C317 401 327 402 334 396C341 391 342 381 337 374C317 350 287 336 256 336ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM379 177L299 201C291 203 286 212 289 221C291 228 297 232 304 232C307 232 309 231 315 230C313 233 312 236 312 240C312 253 323 264 336 264S360 253 360 240C360 231 355 224 348 220L389 207C397 205 402 196 399 187C397 179 388 174 379 177Z"]
  };
  var faFaceDizzy = {
    prefix: 'fal',
    iconName: 'face-dizzy',
    icon: [512, 512, [], "f567", "M227 243C233 237 233 227 227 221L199 192L227 163C233 157 233 147 227 141C221 135 211 135 205 141L176 169L147 141C141 134 131 134 125 141C119 147 119 157 125 163L153 192L125 221C119 227 119 237 125 243C131 249 141 250 147 243L176 215L205 243C211 250 221 250 227 243ZM256 288C221 288 192 317 192 352S221 416 256 416S320 387 320 352S291 288 256 288ZM256 384C238 384 224 370 224 352S238 320 256 320S288 334 288 352S274 384 256 384ZM387 141C381 134 371 134 365 141L336 169L307 141C301 134 291 134 285 141C278 147 278 157 285 163L313 192L285 221C279 227 279 237 285 243C291 249 301 250 307 243L336 215L365 243C371 249 381 250 387 243C393 237 393 227 387 221L359 192L387 163C394 157 394 147 387 141ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceFlushed = {
    prefix: 'fal',
    iconName: 'face-flushed',
    icon: [512, 512, [], "f579", "M240 224C240 180 204 144 160 144S80 180 80 224S116 304 160 304S240 268 240 224ZM160 272C133 272 112 250 112 224S133 176 160 176S208 198 208 224S186 272 160 272ZM320 368H192C183 368 176 375 176 384S183 400 192 400H320C329 400 336 393 336 384S329 368 320 368ZM160 200C147 200 136 211 136 224S147 248 160 248S184 237 184 224S173 200 160 200ZM352 200C339 200 328 211 328 224S339 248 352 248S376 237 376 224S365 200 352 200ZM352 144C308 144 272 180 272 224S308 304 352 304S432 268 432 224S396 144 352 144ZM352 272C326 272 304 250 304 224S326 176 352 176S400 198 400 224S379 272 352 272ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceFrown = {
    prefix: 'fal',
    iconName: 'face-frown',
    icon: [512, 512, [], "f119", "M176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232ZM336 232C349 232 360 221 360 208S349 184 336 184C323 184 312 195 312 208S323 232 336 232ZM256 320C212 320 170 340 141 374C136 381 136 391 143 396C150 402 160 401 166 394C188 368 221 352 256 352S324 368 346 394C351 401 362 402 369 396C375 391 376 381 371 374C342 340 300 320 256 320ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceFrownOpen = {
    prefix: 'fal',
    iconName: 'face-frown-open',
    icon: [512, 512, [], "f57a", "M256 288C216 288 153 312 144 362C143 373 147 385 155 392S175 402 185 399C215 390 242 384 256 384S297 390 327 399C334 401 347 401 357 392C365 385 369 373 368 362C359 312 296 288 256 288ZM256 352C238 352 209 358 176 368C181 338 226 320 256 320S331 338 336 368C303 358 274 352 256 352ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232ZM336 232C349 232 360 221 360 208S349 184 336 184C323 184 312 195 312 208S323 232 336 232Z"]
  };
  var faFaceGrimace = {
    prefix: 'fal',
    iconName: 'face-grimace',
    icon: [512, 512, [], "f57f", "M176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM336 232C349 232 360 221 360 208S349 184 336 184C323 184 312 195 312 208S323 232 336 232ZM368 288H144C126 288 112 302 112 320V352C112 370 126 384 144 384H368C386 384 400 370 400 352V320C400 302 386 288 368 288ZM176 352H144V320H176V352ZM240 352H208V320H240V352ZM304 352H272V320H304V352ZM368 352H336V320H368V352Z"]
  };
  var faFaceGrin = {
    prefix: 'fal',
    iconName: 'face-grin',
    icon: [640, 512, [], "f580", "M443 305C413 315 368 320 320 320S227 315 197 305C192 303 186 304 182 308C177 312 175 317 176 323C185 378 259 416 320 416C381 416 455 378 464 323C465 317 463 312 459 308C454 304 448 303 443 305ZM320 384C285 384 243 368 222 344C279 355 361 355 419 344C397 368 355 384 320 384ZM320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 464C205 464 112 371 112 256S205 48 320 48S528 141 528 256S435 464 320 464ZM240 232C253 232 264 221 264 208S253 184 240 184C227 184 216 195 216 208S227 232 240 232ZM400 232C413 232 424 221 424 208S413 184 400 184C387 184 376 195 376 208S387 232 400 232Z"]
  };
  var faFaceGrinBeam = {
    prefix: 'fal',
    iconName: 'face-grin-beam',
    icon: [512, 512, [], "f582", "M126 232C129 233 133 231 135 228L144 211C152 197 164 189 176 189C188 189 200 197 207 211L217 228C219 232 223 233 226 232C230 231 232 227 232 223C229 181 200 152 176 152C152 152 123 181 120 223C120 227 122 231 126 232ZM379 305C349 314 304 320 256 320S163 314 133 305C128 303 122 304 118 308C113 312 111 317 112 323C121 378 195 416 256 416C317 416 391 378 400 323C401 317 399 312 395 308C390 304 384 303 379 305ZM256 384C221 384 179 368 158 344C215 354 297 354 355 344C333 368 291 384 256 384ZM286 232C289 233 293 231 295 228L305 211C312 197 324 189 336 189C348 189 360 197 368 211L377 228C379 232 383 233 386 232C390 231 392 227 392 223C389 181 360 152 336 152C312 152 283 181 280 223C280 227 282 231 286 232ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceGrinBeamSweat = {
    prefix: 'fal',
    iconName: 'face-grin-beam-sweat',
    icon: [512, 512, [], "f583", "M440 160C471 160 496 133 496 99C496 76 469 32 453 7C450 3 445 0 440 0H440C435 0 430 3 427 7C411 32 384 76 384 99C384 133 409 160 440 160ZM440 46C457 76 464 94 464 99C464 115 453 128 440 128C427 128 416 115 416 99C416 94 423 76 440 46ZM119 228L128 211C136 197 148 189 160 189C172 189 184 197 191 211L201 228C203 232 207 233 210 232C214 231 216 227 216 223C213 181 184 152 160 152C136 152 107 181 104 223C104 227 106 231 110 232C113 233 117 231 119 228ZM363 305C333 314 288 320 240 320S147 314 117 305C112 303 106 304 102 308C97 312 95 317 96 323C105 378 179 416 240 416C301 416 375 378 384 323C385 317 383 312 379 308C374 304 368 303 363 305ZM240 384C205 384 163 368 142 344C199 354 281 354 339 344C317 368 275 384 240 384ZM320 152C296 152 267 181 264 223C264 227 266 231 270 232C273 233 277 231 279 228L289 211C296 197 308 189 320 189C332 189 344 197 352 211L361 228C363 232 367 233 370 232C374 231 376 227 376 223C373 181 344 152 320 152ZM450 177C442 179 437 188 439 197C445 216 448 236 448 256C448 371 355 464 240 464S32 371 32 256S125 48 240 48C278 48 315 58 347 78C355 82 365 80 369 72C374 65 371 55 364 50C326 28 284 16 240 16C108 16 0 124 0 256S108 496 240 496S480 388 480 256C480 233 477 210 470 187C468 179 459 174 450 177Z"]
  };
  var faFaceGrinHearts = {
    prefix: 'fal',
    iconName: 'face-grin-hearts',
    icon: [512, 512, [], "f584", "M194 287C209 291 221 282 225 270L245 196C249 181 247 165 239 152S217 131 202 129C177 124 152 139 143 163C117 160 92 174 83 197C78 211 79 227 86 241S105 264 120 268L194 287ZM113 208C119 195 134 193 142 195L165 201L171 178C174 166 186 158 197 160C210 162 218 175 214 187L196 254L128 237C116 234 109 221 113 208ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM428 197C419 174 394 160 369 163C360 139 335 124 310 129C295 131 282 140 273 153C265 165 263 181 267 196L287 270C291 282 304 291 318 287L392 268C407 264 419 254 426 241C433 227 434 211 428 197ZM384 237L316 254L298 187C294 175 302 162 315 160C329 158 338 169 341 178L347 201L370 195C382 192 395 198 399 208C403 221 396 234 384 237ZM379 305C349 314 304 320 256 320S163 314 133 305C121 301 110 311 112 323C121 378 195 416 256 416S391 378 400 323C402 311 391 301 379 305ZM256 384C221 384 179 368 158 344C215 354 297 354 355 344C333 368 291 384 256 384Z"]
  };
  var faFaceGrinSquint = {
    prefix: 'fal',
    iconName: 'face-grin-squint',
    icon: [512, 512, [], "f585", "M130 247C133 253 138 256 144 256C146 256 149 255 151 254L215 222C221 220 224 214 224 208S221 196 215 194L151 162C143 158 134 161 130 169S129 186 137 190L172 208L137 226C129 230 126 239 130 247ZM297 222L361 254C363 255 366 256 368 256C374 256 380 253 382 247C386 239 383 230 375 226L340 208L375 190C383 186 386 177 382 169C378 161 369 158 361 162L297 194C291 196 288 202 288 208S291 220 297 222ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM379 305C349 314 304 320 256 320S163 314 133 305C128 303 122 304 118 308C113 312 111 317 112 323C121 378 195 416 256 416C317 416 391 378 400 323C401 317 399 312 395 308C390 304 384 303 379 305ZM256 384C221 384 179 368 158 344C215 354 297 354 355 344C333 368 291 384 256 384Z"]
  };
  var faFaceGrinSquintTears = {
    prefix: 'fal',
    iconName: 'face-grin-squint-tears',
    icon: [512, 512, [], "f586", "M384 144C385 144 386 144 386 144C419 139 476 128 494 110C518 85 518 45 493 19C480 7 464 0 446 0C429 0 414 6 402 18C402 18 402 18 402 18C384 36 373 93 368 126C367 131 369 136 373 139C376 142 380 144 384 144ZM425 41C430 35 438 32 447 32C455 32 464 36 470 42C483 55 483 75 471 87C468 91 450 100 404 108C412 62 421 44 425 41ZM126 368C93 373 36 384 18 402C-6 427 -6 467 19 493C32 505 48 512 66 512C82 512 98 506 110 494C110 494 110 494 110 494C128 476 139 419 144 386C145 381 143 376 139 373S131 367 126 368ZM87 471C82 477 74 480 65 480C57 480 48 476 42 470C29 457 29 437 41 425C44 421 62 412 108 404C100 450 91 468 87 471ZM378 203C363 232 335 267 301 301C267 335 232 363 203 378C199 380 195 385 195 391C194 396 197 401 202 405C247 437 326 412 369 369C412 326 437 247 405 201C402 197 396 194 391 195C385 195 380 198 378 203ZM346 346C322 371 281 389 248 388C297 355 355 297 388 248C389 281 371 322 346 346ZM319 150L281 163L294 125C297 117 292 108 284 105C275 102 266 107 263 115L241 183C239 189 240 195 245 199C249 204 255 205 261 203L329 181C331 180 333 179 335 177C339 173 341 166 339 160C336 152 327 148 319 150ZM181 329L203 261C205 255 204 249 199 245S189 239 183 241L115 263C107 266 102 275 105 284C108 292 117 297 125 294L163 281L150 319C148 327 152 336 160 339C166 341 173 339 177 335C179 333 180 331 181 329ZM466 177C458 179 453 188 455 197C461 216 464 236 464 256C464 371 371 464 256 464C236 464 216 461 197 455C188 453 179 458 177 466C174 475 179 484 187 486C210 493 233 496 256 496C388 496 496 388 496 256C496 233 493 210 486 187C484 179 475 174 466 177ZM41 336C43 336 44 336 46 335C54 333 59 324 57 315C51 296 48 276 48 256C48 141 141 48 256 48C276 48 296 51 315 57C324 59 333 54 335 46C338 37 333 28 325 26C302 19 279 16 256 16C124 16 16 124 16 256C16 279 19 302 26 325C28 332 34 336 41 336Z"]
  };
  var faFaceGrinStars = {
    prefix: 'fal',
    iconName: 'face-grin-stars',
    icon: [512, 512, [], "f587", "M256 8C119 8 8 119 8 256S119 504 256 504S504 393 504 256S393 8 256 8ZM256 472C137 472 40 375 40 256S137 40 256 40S472 137 472 256S375 472 256 472ZM379 321C349 330 304 336 256 336S163 330 133 321C121 317 110 327 112 339C121 394 195 432 256 432S391 394 400 339C402 327 391 317 379 321ZM256 400C221 400 179 384 158 360C215 370 297 370 355 360C333 384 291 400 256 400ZM418 148L383 143L367 111C357 92 331 92 321 111L305 143L270 148C264 149 260 152 256 155C252 152 248 149 242 148L207 143L191 111C182 92 155 92 145 111L129 143L94 148C74 151 64 176 80 192L105 217L99 252C96 274 119 289 136 279L168 262L199 278C218 289 240 273 237 252L231 217L256 192L281 217L275 252C272 274 295 289 312 279L344 262L376 278C394 289 416 273 413 252L407 217L433 191C447 177 439 151 418 148ZM196 206L203 244L168 226L133 244L140 205L111 178L151 172L168 137L186 172L225 178L196 206ZM372 206L379 244L344 226L309 244L316 205L287 178L326 172L344 137L361 172L401 178L372 206Z"]
  };
  var faFaceGrinTears = {
    prefix: 'fal',
    iconName: 'face-grin-tears',
    icon: [640, 512, [], "f588", "M624 254C608 238 559 229 531 224C526 223 520 225 517 229S511 237 512 242C517 271 526 320 542 336C552 346 567 352 582 352H582C597 352 612 346 623 335C623 335 623 335 623 335C645 312 646 276 624 254ZM600 312C595 317 589 320 582 320H582C575 320 569 318 565 313C562 310 555 295 548 260C584 267 598 274 601 276C611 286 610 302 600 312ZM123 229C120 225 115 223 109 224C81 229 32 238 16 254L16 254C-6 276 -5 312 17 335C28 346 43 352 58 352H58C74 352 88 346 98 336C114 320 123 271 128 242C129 237 127 232 123 229ZM75 313C71 318 65 320 58 320H58C51 320 45 317 40 312C30 302 29 286 39 276C42 274 57 267 92 260C85 295 78 310 75 313ZM176 323C185 378 259 416 320 416C381 416 455 378 464 323C465 317 463 312 459 308C454 304 448 303 443 305C413 314 368 320 320 320S227 314 197 305C192 303 186 304 182 308C177 312 175 317 176 323ZM419 344C397 368 355 384 320 384S243 368 222 344C279 354 361 354 419 344ZM359 228L369 211C376 197 388 189 400 189C412 189 424 197 432 211L441 228C443 232 447 233 450 232C454 231 456 227 456 223C453 181 424 152 400 152C376 152 347 181 344 223C344 227 346 231 350 232C353 233 357 231 359 228ZM199 228L208 211C216 197 228 189 240 189C252 189 264 197 271 211L281 228C283 232 287 233 290 232C294 231 296 227 296 223C293 181 264 152 240 152C216 152 187 181 184 223C184 227 186 231 190 232C193 233 197 231 199 228ZM520 358C513 353 503 356 498 363C460 426 394 464 320 464S180 426 142 363C137 356 127 353 120 358C112 362 110 372 114 380C158 453 235 496 320 496S482 453 526 380C530 372 528 362 520 358ZM101 207C109 210 118 205 121 197C147 109 229 48 320 48S493 109 519 197C522 204 528 208 535 208C536 208 538 208 539 207C548 205 553 196 550 187C520 86 425 16 320 16S120 86 90 187C87 196 92 205 101 207Z"]
  };
  var faFaceGrinTongue = {
    prefix: 'fal',
    iconName: 'face-grin-tongue',
    icon: [512, 512, [], "f589", "M360 208C360 195 349 184 336 184C323 184 312 195 312 208S323 232 336 232C349 232 360 221 360 208ZM200 208C200 195 189 184 176 184C163 184 152 195 152 208S163 232 176 232C189 232 200 221 200 208ZM256 16C124 16 16 124 16 256C16 334 54 408 119 453C126 458 136 456 141 449C146 442 144 432 137 427C81 388 48 324 48 256C48 141 141 48 256 48S464 141 464 256C464 324 431 388 375 427C368 432 366 442 371 449C374 453 379 456 384 456C387 456 390 455 393 453C458 408 496 334 496 256C496 124 388 16 256 16ZM306 370C304 370 301 370 299 371L256 382L214 371C211 370 209 370 206 370C190 370 176 383 176 400V432C176 476 212 512 256 512C300 512 336 476 336 432V400C336 383 322 370 306 370ZM304 432C304 459 283 480 256 480S208 459 208 432V403L240 410V424C240 433 247 440 256 440S272 433 272 424V410L304 402V432ZM383 373L399 325C401 320 400 313 396 309C392 305 386 303 380 304C299 325 213 325 132 304C126 303 120 305 116 309C112 313 111 320 113 325L129 373C132 381 141 386 149 383C157 380 162 371 159 363L152 342C221 355 291 355 360 342L353 363C350 371 355 380 363 383C365 384 366 384 368 384C375 384 381 380 383 373Z"]
  };
  var faFaceGrinTongueSquint = {
    prefix: 'fal',
    iconName: 'face-grin-tongue-squint',
    icon: [512, 512, [], "f58a", "M130 247C133 253 138 256 144 256C146 256 149 255 151 254L215 222C221 220 224 214 224 208S221 196 215 194L151 162C143 158 134 161 130 169S129 186 137 190L172 208L137 226C129 230 126 239 130 247ZM382 169C378 161 369 158 361 162L297 194C291 196 288 202 288 208S291 220 297 222L361 254C363 255 366 256 368 256C374 256 380 253 382 247C386 239 383 230 375 226L340 208L375 190C383 186 386 177 382 169ZM256 16C124 16 16 124 16 256C16 334 54 408 119 453C126 458 136 456 141 449C146 442 144 432 137 427C81 388 48 324 48 256C48 141 141 48 256 48S464 141 464 256C464 324 431 388 375 427C368 432 366 442 371 449C374 453 379 456 384 456C387 456 390 455 393 453C458 408 496 334 496 256C496 124 388 16 256 16ZM306 370C304 370 301 370 299 371L256 382L214 371C211 370 209 370 206 370C190 370 176 383 176 400V432C176 476 212 512 256 512C300 512 336 476 336 432V400C336 383 322 370 306 370ZM304 432C304 459 283 480 256 480S208 459 208 432V403L240 410V424C240 433 247 440 256 440S272 433 272 424V410L304 402V432ZM383 373L399 325C401 320 400 313 396 309C392 305 386 303 380 304C299 325 213 325 132 304C126 303 120 305 116 309C112 313 111 320 113 325L129 373C132 381 141 386 149 383C157 380 162 371 159 363L152 342C221 355 291 355 360 342L353 363C350 371 355 380 363 383C365 384 366 384 368 384C375 384 381 380 383 373Z"]
  };
  var faFaceGrinTongueWink = {
    prefix: 'fal',
    iconName: 'face-grin-tongue-wink',
    icon: [512, 512, [], "f58b", "M128 229C133 217 146 208 160 208S187 217 192 229C194 236 200 240 207 240C209 240 211 240 213 239C222 236 226 227 223 219C214 193 188 176 160 176S106 193 97 219C94 227 98 236 107 239C116 242 125 238 128 229ZM383 373L399 325C401 320 400 313 396 309C392 305 386 303 380 304C299 325 213 325 132 304C126 303 120 305 116 309C112 313 111 320 113 325L129 373C132 381 141 386 149 383C157 380 162 371 159 363L152 342C221 355 291 355 360 342L353 363C350 371 355 380 363 383C365 384 366 384 368 384C375 384 381 380 383 373ZM256 16C124 16 16 124 16 256C16 334 54 408 119 453C126 458 136 456 141 449C146 442 144 432 137 427C81 388 48 324 48 256C48 141 141 48 256 48S464 141 464 256C464 324 431 388 375 427C368 432 366 442 371 449C374 453 379 456 384 456C387 456 390 455 393 453C458 408 496 334 496 256C496 124 388 16 256 16ZM306 370C304 370 301 370 299 371L256 382L214 371C211 370 209 370 206 370C190 370 176 383 176 400V432C176 476 212 512 256 512C300 512 336 476 336 432V400C336 383 322 370 306 370ZM304 432C304 459 283 480 256 480S208 459 208 432V403L240 410V424C240 433 247 440 256 440S272 433 272 424V410L304 402V432ZM416 208C416 164 380 128 336 128S256 164 256 208S292 288 336 288S416 252 416 208ZM288 208C288 182 310 160 336 160S384 182 384 208S363 256 336 256S288 234 288 208ZM360 208C360 195 349 184 336 184S312 195 312 208S323 232 336 232S360 221 360 208Z"]
  };
  var faFaceGrinWide = {
    prefix: 'fal',
    iconName: 'face-grin-wide',
    icon: [640, 512, [], "f581", "M320 16C187 16 80 123 80 256S187 496 320 496S560 389 560 256S453 16 320 16ZM320 464C205 464 112 371 112 256S205 48 320 48S528 141 528 256S435 464 320 464ZM443 305C413 314 368 320 320 320S227 314 197 305C192 303 186 304 182 308C177 312 175 317 176 323C185 378 259 416 320 416C381 416 455 378 464 323C465 317 463 312 459 308C454 304 448 303 443 305ZM320 384C285 384 243 368 222 344C279 354 361 354 419 344C397 368 355 384 320 384ZM240 256C249 256 256 249 256 240V144C256 135 249 128 240 128S224 135 224 144V240C224 249 231 256 240 256ZM400 256C409 256 416 249 416 240V144C416 135 409 128 400 128S384 135 384 144V240C384 249 391 256 400 256Z"]
  };
  var faFaceGrinWink = {
    prefix: 'fal',
    iconName: 'face-grin-wink',
    icon: [512, 512, [], "f58c", "M384 304C383 304 381 304 379 305C349 314 304 320 256 320S163 314 133 305C131 304 130 304 128 304C119 304 111 313 112 323C121 378 195 416 256 416C317 416 391 378 400 323C402 313 393 304 384 304ZM331 363C308 376 280 384 256 384S204 376 181 363C172 357 164 350 158 344C186 349 221 352 256 352C291 352 325 349 354 344C348 350 340 357 331 363ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM285 239C294 242 303 238 306 229C310 217 322 208 336 208S362 217 366 229C369 236 375 240 381 240C383 240 385 240 387 239C395 236 399 227 396 219C387 193 363 176 336 176S285 193 276 219C273 227 277 236 285 239ZM176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232Z"]
  };
  var faFaceKiss = {
    prefix: 'fal',
    iconName: 'face-kiss',
    icon: [512, 512, [], "f596", "M277 344C299 335 312 321 312 308C312 289 283 266 241 264C237 264 233 266 232 270C231 274 233 278 237 279L254 287C267 292 275 300 275 308S267 324 254 330L237 337C231 339 231 349 237 352L254 359C267 364 275 372 275 380S267 396 254 402L237 409C233 411 231 414 232 418C233 422 236 424 240 424H241C283 422 312 400 312 380C312 367 299 353 277 344ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM176 184C163 184 152 195 152 208S163 232 176 232C189 232 200 221 200 208S189 184 176 184ZM336 184C323 184 312 195 312 208S323 232 336 232C349 232 360 221 360 208S349 184 336 184Z"]
  };
  var faFaceKissBeam = {
    prefix: 'fal',
    iconName: 'face-kiss-beam',
    icon: [512, 512, [], "f597", "M176 152C152 152 123 181 120 223C120 227 122 231 126 232C129 233 133 231 135 228L144 211C152 197 164 189 176 189C188 189 200 197 207 211L217 228C219 232 223 233 226 232C230 231 232 227 232 223C229 181 200 152 176 152ZM277 344C299 335 312 321 312 308C312 289 283 266 241 264C237 264 233 266 232 270C231 274 233 278 237 279L254 287C267 292 275 300 275 308S267 324 254 330L237 337C231 339 231 349 237 352L254 359C267 364 275 372 275 380S267 396 254 402L237 409C233 411 231 414 232 418C233 422 236 424 240 424H241C283 422 312 400 312 380C312 367 299 353 277 344ZM336 152C312 152 283 181 280 223C280 227 282 231 286 232C289 233 293 231 295 228L304 211C312 197 324 189 336 189C348 189 360 197 367 211L377 228C379 232 383 233 386 232C390 231 392 227 392 223C389 181 360 152 336 152ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceKissWinkHeart = {
    prefix: 'fal',
    iconName: 'face-kiss-wink-heart',
    icon: [512, 512, [], "f598", "M492 405C483 379 456 368 433 371C423 347 399 333 374 337C358 339 345 348 337 360C328 373 326 389 330 404L351 478C354 489 364 496 375 496C377 496 379 496 381 495L456 476L456 476C471 472 483 462 490 449C497 435 498 419 492 405ZM462 434C459 440 454 443 448 445L380 463L361 395C359 389 360 383 363 378C367 373 372 369 378 368C380 368 381 368 382 368C393 368 402 377 405 386L411 409L434 403C443 401 458 403 462 416C465 422 464 429 462 434ZM296 308C296 289 267 266 224 264C221 264 217 266 216 270C215 274 217 278 221 279L238 287C251 292 259 300 259 308S251 324 238 330L221 337C215 339 215 349 221 352L238 359C251 364 259 372 259 380S251 396 238 402L221 409C217 411 215 414 216 418C217 422 220 424 224 424H225C267 422 296 400 296 380C296 367 283 353 261 344C283 335 296 321 296 308ZM350 229C353 236 359 240 365 240C367 240 369 240 371 239C379 236 383 227 380 219C371 193 347 176 320 176S269 193 260 219C257 227 261 236 269 239C278 242 287 238 290 229C294 217 306 208 320 208S346 217 350 229ZM136 208C136 221 147 232 160 232C173 232 184 221 184 208S173 184 160 184C147 184 136 195 136 208ZM299 455C280 461 260 464 240 464C125 464 32 371 32 256S125 48 240 48S448 141 448 256C448 276 445 296 439 315C437 324 442 333 450 335C459 338 468 333 470 325C477 302 480 279 480 256C480 124 372 16 240 16S0 124 0 256S108 496 240 496C263 496 286 493 309 486C317 484 322 475 319 466C317 458 308 453 299 455Z"]
  };
  var faFaceLaugh = {
    prefix: 'fal',
    iconName: 'face-laugh',
    icon: [512, 512, [], "f599", "M391 272H121C111 272 104 280 105 290C114 361 174 416 248 416H264C337 416 398 361 407 290C408 280 401 272 391 272ZM264 384H248C198 384 155 351 141 304H371C357 351 314 384 264 384ZM336 232C349 232 360 221 360 208S349 184 336 184C323 184 312 195 312 208S323 232 336 232ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232Z"]
  };
  var faFaceLaughBeam = {
    prefix: 'fal',
    iconName: 'face-laugh-beam',
    icon: [512, 512, [], "f59a", "M135 212L144 195C152 181 164 173 176 173C188 173 200 181 207 195L217 212C221 219 233 216 232 207C229 165 200 136 176 136C152 136 123 165 120 207C119 216 131 219 135 212ZM295 212L305 195C312 181 324 173 336 173C348 173 360 181 368 195L377 212C381 219 393 216 392 207C389 165 360 136 336 136C312 136 283 165 280 207C279 216 291 219 295 212ZM391 272H121C111 272 104 280 105 290C114 361 174 416 248 416H264C337 416 398 361 407 290C408 280 401 272 391 272ZM264 384H248C198 384 155 351 141 304H371C357 351 314 384 264 384ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceLaughSquint = {
    prefix: 'fal',
    iconName: 'face-laugh-squint',
    icon: [512, 512, [], "f59b", "M391 272H121C111 272 104 280 105 290C114 361 174 416 248 416H264C337 416 398 361 407 290C408 280 401 272 391 272ZM264 384H248C198 384 155 351 141 304H371C357 351 314 384 264 384ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM130 215C133 221 138 224 144 224C146 224 149 223 151 222L215 190C221 188 224 182 224 176S221 164 215 162L151 130C143 126 134 129 130 137S129 154 137 158L172 176L137 194C129 198 126 207 130 215ZM297 190L361 222C363 223 366 224 368 224C374 224 380 221 382 215C386 207 383 198 375 194L340 176L375 158C383 154 386 145 382 137C378 129 369 126 361 130L297 162C291 164 288 170 288 176S291 188 297 190Z"]
  };
  var faFaceLaughWink = {
    prefix: 'fal',
    iconName: 'face-laugh-wink',
    icon: [512, 512, [], "f59c", "M176 200C189 200 200 189 200 176S189 152 176 152C163 152 152 163 152 176S163 200 176 200ZM391 272H121C111 272 104 280 105 290C114 361 174 416 248 416H264C337 416 398 361 407 290C408 280 401 272 391 272ZM264 384H248C198 384 155 351 141 304H371C357 351 314 384 264 384ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM285 207C294 210 303 206 306 197C310 185 322 176 336 176S362 185 366 197C369 204 375 208 381 208C383 208 385 208 387 207C395 204 399 195 396 187C387 161 363 144 336 144S285 161 276 187C273 195 277 204 285 207Z"]
  };
  var faFaceMeh = {
    prefix: 'fal',
    iconName: 'face-meh',
    icon: [512, 512, [], "f11a", "M352 336H160C151 336 144 343 144 352S151 368 160 368H352C361 368 368 361 368 352S361 336 352 336ZM176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232ZM336 232C349 232 360 221 360 208S349 184 336 184C323 184 312 195 312 208S323 232 336 232ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceMehBlank = {
    prefix: 'fal',
    iconName: 'face-meh-blank',
    icon: [512, 512, [], "f5a4", "M176 184C163 184 152 195 152 208S163 232 176 232C189 232 200 221 200 208S189 184 176 184ZM336 184C323 184 312 195 312 208S323 232 336 232C349 232 360 221 360 208S349 184 336 184ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceRollingEyes = {
    prefix: 'fal',
    iconName: 'face-rolling-eyes',
    icon: [512, 512, [], "f5a5", "M320 368H192C183 368 176 375 176 384S183 400 192 400H320C329 400 336 393 336 384S329 368 320 368ZM232 224C232 184 200 152 160 152C120 152 88 184 88 224S120 296 160 296C200 296 232 264 232 224ZM160 264C138 264 120 246 120 224C120 210 127 199 138 192C137 194 136 197 136 200C136 213 147 224 160 224S184 213 184 200C184 197 183 194 182 192C193 199 200 210 200 224C200 246 182 264 160 264ZM352 152C312 152 280 184 280 224S312 296 352 296C392 296 424 264 424 224S392 152 352 152ZM352 264C330 264 312 246 312 224C312 210 319 199 330 192C329 194 328 197 328 200C328 213 339 224 352 224S376 213 376 200C376 197 375 194 374 192C385 199 392 210 392 224C392 246 374 264 352 264ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceSadCry = {
    prefix: 'fal',
    iconName: 'face-sad-cry',
    icon: [512, 512, [], "f5b3", "M213 223C222 220 226 211 223 203C214 177 190 160 163 160S111 177 102 203C99 211 104 220 112 223C121 226 130 222 133 213C137 201 149 192 163 192S188 201 193 213C195 220 201 224 208 224C210 224 212 224 213 223ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM368 431V256C368 247 361 240 352 240S336 247 336 256V448C311 458 284 464 256 464S201 458 176 448V256C176 247 169 240 160 240S144 247 144 256V431C86 394 48 329 48 256C48 141 141 48 256 48S464 141 464 256C464 329 426 394 368 431ZM415 203C406 177 382 160 355 160S303 177 294 203C291 211 296 220 304 223C313 226 322 222 325 213C329 201 341 192 355 192S380 201 385 213C387 220 393 224 400 224C402 224 404 224 405 223C414 220 418 211 415 203ZM256 288C229 288 208 316 208 352S229 416 256 416S304 388 304 352S283 288 256 288ZM256 384C250 384 240 371 240 352S250 320 256 320S272 333 272 352S262 384 256 384Z"]
  };
  var faFaceSadTear = {
    prefix: 'fal',
    iconName: 'face-sad-tear',
    icon: [512, 512, [], "f5b4", "M336 232C349 232 360 221 360 208S349 184 336 184C323 184 312 195 312 208S323 232 336 232ZM176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM184 256L184 256C179 256 174 259 171 263C155 288 128 332 128 355C128 389 153 416 184 416S240 389 240 355C240 332 213 288 197 263C194 259 189 256 184 256ZM184 384C171 384 160 371 160 355C160 350 167 332 184 302C201 332 208 350 208 355C208 371 197 384 184 384ZM290 320H272C263 320 256 327 256 336S263 352 272 352H290C318 352 344 362 355 378C358 382 363 384 368 384C371 384 375 383 378 381C385 375 386 365 381 358C363 335 328 320 290 320Z"]
  };
  var faFaceSmile = {
    prefix: 'fal',
    iconName: 'face-smile',
    icon: [512, 512, [], "f118", "M346 326C324 353 291 368 256 368S188 353 166 326C160 319 150 318 143 324C136 330 136 340 141 346C170 380 212 400 256 400S342 380 371 346C376 339 376 329 369 324C362 318 352 319 346 326ZM336 232C349 232 360 221 360 208S349 184 336 184C323 184 312 195 312 208S323 232 336 232ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232Z"]
  };
  var faFaceSmileBeam = {
    prefix: 'fal',
    iconName: 'face-smile-beam',
    icon: [512, 512, [], "f5b8", "M176 189C188 189 200 197 207 211L217 228C219 232 223 233 226 232C230 231 232 227 232 223C229 181 200 152 176 152C152 152 123 181 120 223C120 227 122 231 126 232C129 233 133 231 135 228L144 211C152 197 164 189 176 189ZM336 152C312 152 283 181 280 223C280 227 282 231 286 232C289 233 293 231 295 228L305 211C312 197 324 189 336 189C348 189 360 197 368 211L377 228C379 232 383 233 386 232C390 231 392 227 392 223C389 181 360 152 336 152ZM346 326C324 353 291 368 256 368S188 353 166 326C160 319 150 318 143 324C136 330 136 340 141 346C170 380 212 400 256 400S342 380 371 346C376 339 376 329 369 324C362 318 352 319 346 326ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceSmilePlus = {
    prefix: 'fal',
    iconName: 'face-smile-plus',
    icon: [640, 512, [], "f5b9", "M624 80H560V16C560 7 553 0 544 0S528 7 528 16V80H464C455 80 448 87 448 96S455 112 464 112H528V176C528 185 535 192 544 192S560 185 560 176V112H624C633 112 640 105 640 96S633 80 624 80ZM224 64C100 64 0 164 0 288C0 412 100 512 224 512S448 412 448 288C448 164 348 64 224 64ZM224 480C118 480 32 394 32 288S118 96 224 96S416 182 416 288S330 480 224 480ZM144 264C157 264 168 253 168 240C168 227 157 216 144 216S120 227 120 240C120 253 131 264 144 264ZM304 264C317 264 328 253 328 240C328 227 317 216 304 216S280 227 280 240C280 253 291 264 304 264ZM342 321C334 318 324 322 321 330C305 373 267 400 224 400S143 373 127 330C124 322 115 318 106 321C98 324 94 333 97 342C118 397 168 432 224 432S330 397 351 342C354 333 350 324 342 321Z"]
  };
  var faFaceSmileWink = {
    prefix: 'fal',
    iconName: 'face-smile-wink',
    icon: [512, 512, [], "f4da", "M346 326C324 353 291 368 256 368S188 353 166 326C152 310 128 330 141 346C170 380 212 400 256 400S342 380 371 346C384 330 360 310 346 326ZM176 232C189 232 200 221 200 208S189 184 176 184C163 184 152 195 152 208S163 232 176 232ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM336 176C309 176 285 193 276 219C273 227 277 236 285 239C294 242 303 238 306 229C310 217 322 208 336 208S362 217 366 229C369 236 375 240 381 240C383 240 385 240 387 239C395 236 399 227 396 219C387 193 363 176 336 176Z"]
  };
  var faFaceSurprise = {
    prefix: 'fal',
    iconName: 'face-surprise',
    icon: [512, 512, [], "f5c2", "M256 288C221 288 192 317 192 352S221 416 256 416S320 387 320 352S291 288 256 288ZM256 384C238 384 224 370 224 352S238 320 256 320S288 334 288 352S274 384 256 384ZM200 208C200 195 189 184 176 184C163 184 152 195 152 208S163 232 176 232C189 232 200 221 200 208ZM336 184C323 184 312 195 312 208S323 232 336 232C349 232 360 221 360 208S349 184 336 184ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464Z"]
  };
  var faFaceTired = {
    prefix: 'fal',
    iconName: 'face-tired',
    icon: [512, 512, [], "f5c8", "M297 222L361 254C363 255 366 256 368 256C374 256 380 253 382 247C386 239 383 230 375 226L340 208L375 190C383 186 386 177 382 169C378 161 369 158 361 162L297 194C291 196 288 202 288 208S291 220 297 222ZM130 247C133 253 138 256 144 256C146 256 149 255 151 254L215 222C221 220 224 214 224 208S221 196 215 194L151 162C143 158 134 161 130 169S129 186 137 190L172 208L137 226C129 230 126 239 130 247ZM256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM256 464C141 464 48 371 48 256S141 48 256 48S464 141 464 256S371 464 256 464ZM256 288C210 288 159 317 133 359C126 370 126 385 134 395C140 404 150 408 160 408C163 408 166 408 168 407C193 401 224 397 256 397C288 397 319 401 344 407C346 408 349 408 352 408C362 408 372 404 378 395C386 385 386 370 379 359C353 317 302 288 256 288ZM256 365C222 365 188 369 160 376C181 343 222 320 256 320C290 320 331 343 352 376C324 369 290 365 256 365Z"]
  };
  var faFan = {
    prefix: 'fal',
    iconName: 'fan',
    icon: [512, 512, [], "f863", "M346 120C328 120 310 122 293 126L302 34C303 26 300 17 294 10C288 4 279 0 270 0C269 0 268 0 266 0C183 11 120 82 120 166C120 184 122 202 126 219L34 210H33L31 210C22 210 14 214 8 221C2 227 -1 237 0 246C11 329 82 392 165 392C184 392 202 390 219 386L210 478C209 486 212 495 218 502C225 509 235 513 245 512C329 501 392 430 392 346C392 328 390 310 386 293L478 302H478L481 302C490 302 498 298 504 291C510 285 513 275 512 266C501 183 430 120 346 120ZM340 256L349 280C356 300 360 322 360 346C360 414 309 471 242 481L256 340L232 349C212 356 189 360 165 360C98 360 41 309 31 242L172 256L163 232C156 212 152 190 152 166C152 98 203 41 270 32L256 172L280 163C300 156 322 152 346 152C414 152 471 203 481 270L340 256ZM256 232C243 232 232 243 232 256S243 280 256 280C269 280 280 269 280 256S269 232 256 232Z"]
  };
  var faFanTable = {
    prefix: 'fal',
    iconName: 'fan-table',
    icon: [448, 512, [], "e004", "M448 224C448 100 348 0 224 0S0 100 0 224C0 342 92 439 208 447V480H80C71 480 64 487 64 496C64 505 71 512 80 512H368C377 512 384 505 384 496C384 487 377 480 368 480H240V447C356 439 448 342 448 224ZM224 414C119 414 34 329 34 224S119 34 224 34S414 119 414 224S329 414 224 414ZM224 209C216 209 209 216 209 224S216 239 224 239S239 232 239 224S232 209 224 209ZM383 243C383 209 366 178 338 159C310 140 274 136 243 149L222 93C214 72 188 61 166 73C117 101 101 163 129 212C135 223 144 234 155 242L117 288C109 297 106 308 108 320C110 331 117 341 127 346C143 355 160 360 178 360C207 360 245 347 266 309C273 298 277 285 279 272C291 274 310 277 338 282C359 285 383 270 383 243ZM343 250C342 250 267 237 265 237C264 237 264 237 264 237C254 237 247 246 247 256C248 269 245 282 238 293C219 327 184 328 179 328C166 328 154 325 143 319C140 317 138 312 141 308L190 249C198 239 193 227 184 223C173 217 163 207 156 196C137 163 149 120 182 101C184 99 190 99 192 105L219 177C221 181 225 185 230 186C235 188 240 187 244 185C266 171 293 170 315 182S351 218 351 243C351 247 349 250 343 250Z"]
  };
  var faFarm = {
    prefix: 'fal',
    iconName: 'farm',
    icon: [576, 512, [], "f864", "M32 160V117C32 75 62 37 104 32C139 29 174 49 188 86C191 94 192 103 192 112V118C198 107 209 97 221 92C210 43 170 3 118 0C87 -2 57 10 35 31C13 52 0 81 0 112V496C0 505 7 512 16 512S32 505 32 496V192H155L171 160H32ZM416 384H320C302 384 288 398 288 416V496C288 505 295 512 304 512S320 505 320 496V416H416V496C416 505 423 512 432 512S448 505 448 496V416C448 398 434 384 416 384ZM400 304C418 304 432 290 432 272V208C432 190 418 176 400 176H336C318 176 304 190 304 208V272C304 290 318 304 336 304H400ZM336 208H400V272H336V208ZM573 246L517 135C514 129 508 123 502 120L381 67C373 63 363 63 355 67L234 120C228 123 221 131 219 135L163 246C161 251 160 256 160 261V496C160 505 167 512 176 512S192 505 192 496V261L247 150L368 96L489 150L544 261V496C544 505 551 512 560 512S576 505 576 496V261C576 256 575 251 573 246Z"]
  };
  var faFaucet = {
    prefix: 'fal',
    iconName: 'faucet',
    icon: [512, 512, [], "e005", "M512 416C512 434 498 448 480 448H416C399 448 384 434 384 417C384 399 371 384 354 384H334C312 422 271 448 224 448S136 422 114 384H16C7 384 0 377 0 368C0 359 7 352 16 352H134C147 389 182 416 224 416S301 389 314 352H352C387 352 416 381 416 416H480C480 345 423 288 352 288H314C301 251 266 224 224 224S147 251 134 288H16C7 288 0 281 0 272C0 263 7 256 16 256H114C133 222 168 198 208 193V144H80C71 144 64 137 64 128S71 112 80 112H208V80C208 71 215 64 224 64S240 71 240 80V112H368C377 112 384 119 384 128S377 144 368 144H240V193C280 198 315 222 334 256H352C440 256 512 328 512 416Z"]
  };
  var faFaucetDrip = {
    prefix: 'fal',
    iconName: 'faucet-drip',
    icon: [512, 512, [], "e006", "M435 391C424 406 400 444 400 464C400 490 422 512 448 512S496 490 496 464C496 444 472 406 461 391C455 382 441 382 435 391ZM448 480C439 480 432 473 432 464C432 459 439 445 448 430C457 445 464 459 464 464C464 473 457 480 448 480ZM352 160H334C315 126 280 102 240 97V64H368C377 64 384 57 384 48S377 32 368 32H240V16C240 7 233 0 224 0S208 7 208 16V32H80C71 32 64 39 64 48S71 64 80 64H208V97C168 102 133 126 114 160H16C7 160 0 167 0 176C0 185 7 192 16 192H134C147 155 182 128 224 128S301 155 314 192H352C423 192 480 249 480 320H416C416 285 387 256 352 256H314C301 293 266 320 224 320S147 293 134 256H16C7 256 0 263 0 272C0 281 7 288 16 288H114C136 326 177 352 224 352S312 326 334 288H354C371 288 384 303 384 321C384 338 399 352 416 352H480C498 352 512 338 512 320C512 232 440 160 352 160Z"]
  };
  var faFax = {
    prefix: 'fal',
    iconName: 'fax',
    icon: [512, 512, [], "f1ac", "M464 192H176C170 192 165 193 160 195V64C160 46 174 32 192 32H409L448 71V144C448 153 455 160 464 160S480 153 480 144V71C480 62 477 54 471 48L432 9C426 3 418 0 409 0H192C157 0 128 29 128 64V131C123 129 118 128 112 128H48C22 128 0 150 0 176V464C0 490 22 512 48 512H112C124 512 135 507 144 500C153 507 164 512 176 512H464C490 512 512 490 512 464V240C512 214 490 192 464 192ZM128 464C128 473 121 480 112 480H48C39 480 32 473 32 464V176C32 167 39 160 48 160H112C121 160 128 167 128 176V464ZM480 464C480 473 473 480 464 480H176C167 480 160 473 160 464V240C160 231 167 224 176 224H464C473 224 480 231 480 240V464ZM272 280C259 280 248 291 248 304S259 328 272 328S296 317 296 304S285 280 272 280ZM272 376C259 376 248 387 248 400S259 424 272 424S296 413 296 400S285 376 272 376ZM368 280C355 280 344 291 344 304S355 328 368 328S392 317 392 304S381 280 368 280ZM368 376C355 376 344 387 344 400S355 424 368 424S392 413 392 400S381 376 368 376Z"]
  };
  var faFeather = {
    prefix: 'fal',
    iconName: 'feather',
    icon: [512, 512, [], "f52d", "M467 45C438 16 402 0 362 0C315 0 264 22 215 71L129 156C50 236 57 367 76 414L5 485C2 488 0 492 0 496C0 505 7 512 16 512C20 512 24 510 27 507L98 436C115 443 144 449 178 449C235 449 306 433 356 383L441 297C532 206 530 107 467 45ZM152 179L238 93C278 53 320 32 362 32C393 32 421 44 445 67C487 110 490 168 458 224H310L348 187C354 181 354 171 348 164C341 158 331 158 325 164L101 388C91 345 88 243 152 179ZM178 416C154 416 137 414 124 411L183 352L341 352L333 360C284 409 215 416 178 416ZM373 320H214L278 256H435C430 262 373 320 373 320Z"]
  };
  var faFeatherPointed = {
    prefix: 'fal',
    iconName: 'feather-pointed',
    icon: [512, 512, [], "f56b", "M481 0C480 0 480 0 479 0C361 9 -10 63 77 412L5 485C-2 491 -2 501 5 507C8 510 12 512 16 512S24 510 27 507L100 435C136 444 169 448 199 448C460 448 504 138 512 33C513 15 499 0 481 0ZM199 416C176 416 152 413 127 408L183 352C183 352 184 352 184 352H361C317 394 263 416 199 416ZM388 321C387 320 385 320 384 320H215L279 256C279 256 280 256 280 256H426C425 259 423 263 422 266C412 286 400 304 388 321ZM440 224H311L347 187C354 181 354 171 347 165S331 158 325 165L104 385C87 302 98 232 138 177C220 63 404 38 480 32C477 75 467 151 440 224Z"]
  };
  var faFieldHockeyStickBall = {
    prefix: 'fal',
    iconName: 'field-hockey-stick-ball',
    icon: [512, 512, [], "f44c", "M432 352C388 352 352 388 352 432S388 512 432 512C476 512 512 476 512 432S476 352 432 352ZM432 480C406 480 384 458 384 432C384 405 406 384 432 384C458 384 480 405 480 432C480 458 458 480 432 480ZM511 53C509 41 502 31 491 24L467 7C446 -6 417 0 403 20L159 379C151 391 138 392 132 388C122 382 122 372 122 370C122 365 122 364 132 350L135 347C154 319 147 281 120 262C106 252 91 248 75 251C55 255 40 269 35 277L25 290C11 311 2 335 0 361C-4 416 24 467 72 495C92 506 115 512 139 512C210 512 249 464 259 448L504 88C511 78 514 66 511 53ZM233 430C225 442 194 480 139 480C121 480 103 475 88 467C50 446 29 406 32 363C34 343 40 324 52 308L61 295C63 292 71 284 81 283C82 282 84 282 85 282C90 282 96 284 101 288C114 297 117 315 108 328L106 332C96 346 91 353 90 367C89 383 95 404 116 416C136 427 167 424 185 397L354 149L400 184L233 430ZM478 70L418 157L372 123L430 38C434 32 443 30 449 34L474 51C477 53 479 56 480 60C480 63 480 67 478 70Z"]
  };
  var faFile = {
    prefix: 'fal',
    iconName: 'file',
    icon: [384, 512, [], "f15b", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34C228 36 233 38 236 41L343 148ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448Z"]
  };
  var faFileArrowDown = {
    prefix: 'fal',
    iconName: 'file-arrow-down',
    icon: [384, 512, [], "f56d", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM208 240C208 231 201 224 192 224S176 231 176 240V361L123 309C120 306 116 304 112 304S104 306 101 309C94 315 94 325 101 331L181 411C187 418 197 418 203 411L283 331C290 325 290 315 283 309S267 302 261 309L208 361V240Z"]
  };
  var faFileArrowUp = {
    prefix: 'fal',
    iconName: 'file-arrow-up',
    icon: [384, 512, [], "f574", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM181 229L101 309C94 315 94 325 101 331S117 338 123 331L176 279V400C176 409 183 416 192 416S208 409 208 400V279L261 331C264 334 268 336 272 336S280 334 283 331C290 325 290 315 283 309L203 229C197 222 187 222 181 229Z"]
  };
  var faFileAudio = {
    prefix: 'fal',
    iconName: 'file-audio',
    icon: [384, 512, [], "f1c7", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM183 250C177 247 171 248 166 252L122 288H80C71 288 64 295 64 304V368C64 377 71 384 80 384H122L166 420C169 423 172 424 176 424C178 424 181 423 183 422C188 420 192 414 192 408V264C192 258 188 252 183 250ZM160 374L138 356C135 353 132 352 128 352H96V320H128C132 320 135 319 138 316L160 298V374ZM288 336C288 367 273 397 247 415C240 420 238 430 243 437C246 442 251 444 256 444C259 444 262 443 265 441C299 417 320 378 320 336S299 255 265 231C258 226 248 228 243 235C238 242 240 252 247 257C273 275 288 305 288 336ZM234 288C227 282 217 283 212 290C206 297 207 307 214 312C220 318 224 326 224 336S220 354 214 360C207 365 206 375 212 382C215 386 219 388 224 388C228 388 231 387 234 384C248 373 256 355 256 336S248 299 234 288Z"]
  };
  var faFileCertificate = {
    prefix: 'fal',
    iconName: 'file-certificate',
    icon: [512, 512, [], "f5f3", "M244 339C254 329 258 313 255 299C251 285 251 291 255 277C258 263 254 247 244 237C234 227 235 228 231 215C228 200 216 189 202 185C189 181 191 183 181 172C170 162 155 158 140 161C127 165 129 165 116 161C101 158 86 162 75 172C65 183 67 181 54 185C40 189 28 200 25 215C21 228 22 227 12 237C2 247 -2 263 1 277C5 291 5 285 1 299C-2 313 2 329 12 339C22 349 21 347 25 361C28 376 40 387 54 391C59 392 62 393 64 394V496C64 502 67 507 72 510C76 512 82 513 87 510L128 490L169 510C171 511 174 512 176 512C179 512 182 511 184 510C189 507 192 502 192 496V394C194 393 197 392 202 391C216 387 228 376 231 361C235 347 234 349 244 339ZM160 470L135 458C131 455 125 455 121 458L96 470V415C102 416 109 416 116 415C129 411 127 411 140 415C147 416 154 416 160 415V470ZM222 302C225 311 225 312 218 320C207 331 206 334 201 353C199 359 194 360 190 361C174 365 172 367 160 379C155 384 153 385 145 383C130 378 127 378 111 383C103 385 101 384 96 379C84 367 82 365 66 361C62 360 57 359 55 353C51 334 49 331 38 320C31 312 31 311 34 302C37 289 37 286 34 274C31 266 31 264 37 257C49 245 50 242 55 227C57 218 57 217 66 215C82 211 84 209 96 197C101 192 103 191 111 193C127 198 129 198 145 193C153 191 155 192 160 197C172 209 174 211 190 215C199 217 199 218 201 227C206 242 207 245 219 257C225 264 225 266 222 274C219 286 219 289 222 302ZM493 125L387 19C375 7 358 0 342 0H192C157 0 128 29 128 64V112C128 121 135 128 144 128C153 128 160 121 160 112V64C160 46 174 32 192 32H320V144C320 170 342 192 368 192H480V448C480 466 466 480 448 480H240C231 480 224 487 224 496C224 505 231 512 240 512H448C483 512 512 483 512 448V170C512 154 505 137 493 125ZM368 160C359 160 352 153 352 144V34C356 36 361 38 364 41L471 148C474 151 476 156 478 160H368Z"]
  };
  var faFileChartColumn = {
    prefix: 'fal',
    iconName: 'file-chart-column',
    icon: [384, 512, [], "f659", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM96 352C87 352 80 359 80 368V432C80 441 87 448 96 448S112 441 112 432V368C112 359 105 352 96 352ZM192 224C183 224 176 231 176 240V432C176 441 183 448 192 448S208 441 208 432V240C208 231 201 224 192 224ZM288 448C297 448 304 441 304 432V304C304 295 297 288 288 288S272 295 272 304V432C272 441 279 448 288 448Z"]
  };
  var faFileChartPie = {
    prefix: 'fal',
    iconName: 'file-chart-pie',
    icon: [384, 512, [], "f65a", "M176 224V320C176 329 183 336 192 336H288C297 336 304 329 304 320C304 258 254 208 192 208C183 208 176 215 176 224ZM208 242C239 248 264 273 270 304H208V242ZM184 408C140 408 104 372 104 328C104 295 124 267 152 255V221C106 235 72 277 72 328C72 390 122 440 184 440C235 440 277 406 291 360H257C245 388 217 408 184 408ZM365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448Z"]
  };
  var faFileCheck = {
    prefix: 'fal',
    iconName: 'file-check',
    icon: [384, 512, [], "f316", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM123 319C117 313 107 313 101 319S94 336 101 342L154 395C157 398 161 400 165 400S174 398 177 395L283 289C290 282 290 272 283 266S267 260 261 266L165 361L123 319Z"]
  };
  var faFileCode = {
    prefix: 'fal',
    iconName: 'file-code',
    icon: [384, 512, [], "f1c9", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM139 277C133 270 123 270 117 277L69 325C62 331 62 341 69 347L117 395C120 398 124 400 128 400S136 398 139 395C146 389 146 379 139 373L103 336L139 299C146 293 146 283 139 277ZM245 299L281 336L245 373C238 379 238 389 245 395C248 398 252 400 256 400S264 398 267 395L315 347C322 341 322 331 315 325L267 277C261 270 251 270 245 277S238 293 245 299ZM220 224C211 222 203 228 200 236L152 428C150 437 156 445 164 448C165 448 167 448 168 448C175 448 182 443 184 436L232 244C234 235 228 227 220 224Z"]
  };
  var faFileContract = {
    prefix: 'fal',
    iconName: 'file-contract',
    icon: [384, 512, [], "f56c", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM80 96H144C153 96 160 89 160 80S153 64 144 64H80C71 64 64 71 64 80S71 96 80 96ZM80 160H144C153 160 160 153 160 144S153 128 144 128H80C71 128 64 135 64 144S71 160 80 160ZM181 363L167 322C163 312 154 305 144 305S125 312 121 322L103 376C102 381 97 384 92 384H80C71 384 64 391 64 400S71 416 80 416H92C111 416 128 404 133 386L144 355L161 405C163 411 168 415 175 416H176C182 416 188 413 190 407L198 392C201 386 206 386 208 386S215 386 218 392C226 407 240 416 257 416H304C313 416 320 409 320 400S313 384 304 384H257C253 384 249 382 247 378C235 354 200 347 181 363Z"]
  };
  var faFileCsv = {
    prefix: 'fal',
    iconName: 'file-csv',
    icon: [384, 512, [], "f6dd", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM225 293L257 389C259 396 265 400 272 400S285 396 287 389L319 293C322 285 317 276 309 273C301 270 292 275 289 283L272 333L255 283C252 275 243 270 235 273C227 276 222 285 225 293ZM183 304H192C201 304 208 297 208 288S201 272 192 272H183C161 272 144 289 144 311C144 321 148 331 155 338L174 357C175 358 176 360 176 361C176 365 173 368 169 368H160C151 368 144 375 144 384S151 400 160 400H169C191 400 208 383 208 361C208 351 204 341 197 334L178 315C177 314 176 312 176 311C176 307 179 304 183 304ZM112 304C121 304 128 297 128 288S121 272 112 272C86 272 64 294 64 320V352C64 378 86 400 112 400C121 400 128 393 128 384S121 368 112 368C103 368 96 361 96 352V320C96 311 103 304 112 304Z"]
  };
  var faFileDashedLine = {
    prefix: 'fal',
    iconName: 'file-dashed-line',
    icon: [576, 512, [], "f877", "M160 288C160 279 153 272 144 272H16C7 272 0 279 0 288S7 304 16 304H144C153 304 160 297 160 288ZM240 272C231 272 224 279 224 288S231 304 240 304H336C345 304 352 297 352 288S345 272 336 272H240ZM560 272H432C423 272 416 279 416 288S423 304 432 304H560C569 304 576 297 576 288S569 272 560 272ZM464 352C455 352 448 359 448 368V448C448 466 434 480 416 480H160C142 480 128 466 128 448V368C128 359 121 352 112 352S96 359 96 368V448C96 483 125 512 160 512H416C451 512 480 483 480 448V368C480 359 473 352 464 352ZM112 224C121 224 128 217 128 208V64C128 46 142 32 160 32H288V144C288 170 310 192 336 192H448V208C448 217 455 224 464 224S480 217 480 208V170C480 154 473 137 461 125L355 19C343 7 326 0 310 0H160C125 0 96 29 96 64V208C96 217 103 224 112 224ZM320 34C324 36 329 38 332 41L439 148C442 151 444 156 446 160H336C327 160 320 153 320 144V34Z"]
  };
  var faFileExcel = {
    prefix: 'fal',
    iconName: 'file-excel',
    icon: [384, 512, [], "f1c3", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM192 308L149 247C144 240 134 238 127 243C120 248 118 258 123 265L172 336L123 407C118 414 120 424 127 429C130 431 133 432 136 432C141 432 146 430 149 425L192 364L235 425C238 430 243 432 248 432C251 432 254 431 257 429C264 424 266 414 261 407L212 336L261 265C266 258 264 248 257 243S240 240 235 247L192 308Z"]
  };
  var faFileExclamation = {
    prefix: 'fal',
    iconName: 'file-exclamation',
    icon: [384, 512, [], "f31a", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM192 392C179 392 168 403 168 416S179 440 192 440C205 440 216 429 216 416S205 392 192 392ZM192 368C201 368 208 361 208 352V240C208 231 201 224 192 224S176 231 176 240V352C176 361 183 368 192 368Z"]
  };
  var faFileExport = {
    prefix: 'fal',
    iconName: 'file-export',
    icon: [576, 512, [], "f56e", "M571 309L475 213C469 206 459 206 453 213S446 229 453 235L521 304H208C199 304 192 311 192 320S199 336 208 336H521L453 405C446 411 446 421 453 427C456 430 460 432 464 432S472 430 475 427L571 331C578 325 578 315 571 309ZM368 384C359 384 352 391 352 400V448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V240C352 249 359 256 368 256C377 256 384 249 384 240V170C384 154 377 137 365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V400C384 391 377 384 368 384ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34Z"]
  };
  var faFileHeart = {
    prefix: 'fal',
    iconName: 'file-heart',
    icon: [384, 512, [], "e129", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM192 268L183 259C172 247 155 240 140 240C127 240 114 244 104 253C77 276 75 317 99 342L182 428C185 431 189 432 192 432S199 431 202 428L285 342C309 317 307 276 280 253C270 244 257 240 244 240C228 240 212 247 200 259L192 268ZM223 281C229 275 237 272 244 272C248 272 254 273 260 278C266 283 269 290 270 298C270 306 267 314 262 320L192 392L122 320C117 314 114 306 114 298C115 290 118 283 124 277C130 273 136 272 140 272C147 272 155 275 160 281L169 290L192 314L215 290L223 281Z"]
  };
  var faFileImage = {
    prefix: 'fal',
    iconName: 'file-image',
    icon: [384, 512, [], "f1c5", "M190 286L164 326C152 311 126 313 116 329L69 401C63 410 62 422 67 432C73 442 83 448 94 448H290C301 448 311 442 317 432C322 422 321 410 315 401L240 286C229 269 201 269 190 286ZM287 416L96 416L141 349L151 364C157 373 172 373 177 364L215 306L287 416ZM96 280C109 280 120 269 120 256C120 243 109 232 96 232S72 243 72 256C72 269 83 280 96 280ZM365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448Z"]
  };
  var faFileImport = {
    prefix: 'fal',
    iconName: 'file-import',
    icon: [512, 512, [], "f56f", "M261 405C254 411 254 421 261 427C264 430 268 432 272 432S280 430 283 427L379 331C386 325 386 315 379 309L283 213C277 206 267 206 261 213S254 229 261 235L329 304H16C7 304 0 311 0 320S7 336 16 336H329L261 405ZM493 125L387 19C375 7 358 0 342 0H192C157 0 128 29 128 64V240C128 249 135 256 144 256C153 256 160 249 160 240V64C160 46 174 32 192 32H320V144C320 170 342 192 368 192H480V448C480 466 466 480 448 480H192C174 480 160 466 160 448V400C160 391 153 384 144 384C135 384 128 391 128 400V448C128 483 157 512 192 512H448C483 512 512 483 512 448V170C512 154 505 137 493 125ZM368 160C359 160 352 153 352 144V34C356 36 361 38 364 41L471 148C474 151 476 156 478 160H368Z"]
  };
  var faFileInvoice = {
    prefix: 'fal',
    iconName: 'file-invoice',
    icon: [384, 512, [], "f570", "M80 160H144C153 160 160 153 160 144S153 128 144 128H80C71 128 64 135 64 144S71 160 80 160ZM80 96H144C153 96 160 89 160 80S153 64 144 64H80C71 64 64 71 64 80S71 96 80 96ZM365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM64 272V336C64 354 78 368 96 368H288C306 368 320 354 320 336V272C320 254 306 240 288 240H96C78 240 64 254 64 272ZM288 336H96V272H288V336ZM304 416H240C231 416 224 423 224 432S231 448 240 448H304C313 448 320 441 320 432S313 416 304 416Z"]
  };
  var faFileInvoiceDollar = {
    prefix: 'fal',
    iconName: 'file-invoice-dollar',
    icon: [384, 512, [], "f571", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM80 96H144C153 96 160 89 160 80S153 64 144 64H80C71 64 64 71 64 80S71 96 80 96ZM160 144C160 135 153 128 144 128H80C71 128 64 135 64 144S71 160 80 160H144C153 160 160 153 160 144ZM202 289C209 290 216 292 223 294C232 297 241 292 243 283C246 275 241 266 233 263C223 260 215 258 208 257C208 257 208 257 208 256V240C208 231 201 224 192 224S176 231 176 240V256C176 256 176 257 176 257C151 260 133 273 129 294C121 334 162 345 182 350L188 351C220 360 225 364 224 372C222 381 204 386 182 383C173 382 163 379 154 376L149 374C140 371 131 376 129 385C126 393 131 402 139 405L144 406C154 409 165 413 176 414C176 415 176 415 176 416V432C176 441 183 448 192 448S208 441 208 432V416C208 415 208 415 208 415C233 411 251 399 255 378C263 338 223 327 196 320L190 319C158 311 159 306 160 300C162 291 180 286 202 289Z"]
  };
  var faFileLines = {
    prefix: 'fal',
    iconName: 'file-lines',
    icon: [384, 512, [], "f15c", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM96 272C96 281 103 288 112 288H272C281 288 288 281 288 272S281 256 272 256H112C103 256 96 263 96 272ZM272 320H112C103 320 96 327 96 336S103 352 112 352H272C281 352 288 345 288 336S281 320 272 320ZM272 384H112C103 384 96 391 96 400S103 416 112 416H272C281 416 288 409 288 400S281 384 272 384Z"]
  };
  var faFileMagnifyingGlass = {
    prefix: 'fal',
    iconName: 'file-magnifying-glass',
    icon: [384, 512, [], "f865", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM80 304C80 357 123 400 176 400C197 400 216 393 231 382L293 443C296 446 300 448 304 448S312 446 315 443C322 437 322 427 315 421L254 359C265 344 272 325 272 304C272 251 229 208 176 208S80 251 80 304ZM240 304C240 339 211 368 176 368S112 339 112 304S141 240 176 240S240 269 240 304Z"]
  };
  var faFileMedical = {
    prefix: 'fal',
    iconName: 'file-medical',
    icon: [384, 512, [], "f477", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM224 240C224 231 217 224 208 224H176C167 224 160 231 160 240V288H112C103 288 96 295 96 304V336C96 345 103 352 112 352H160V400C160 409 167 416 176 416H208C217 416 224 409 224 400V352H272C281 352 288 345 288 336V304C288 295 281 288 272 288H224V240Z"]
  };
  var faFileMinus = {
    prefix: 'fal',
    iconName: 'file-minus',
    icon: [384, 512, [], "f318", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM128 320C119 320 112 327 112 336S119 352 128 352H256C265 352 272 345 272 336S265 320 256 320H128Z"]
  };
  var faFileMusic = {
    prefix: 'fal',
    iconName: 'file-music',
    icon: [384, 512, [], "f8b6", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM144 292V357C137 354 129 352 120 352C89 352 64 374 64 400S89 448 120 448S176 426 176 400V292L272 256V325C265 322 257 320 248 320C217 320 192 342 192 368S217 416 248 416S304 394 304 368V256C304 246 299 236 290 230C282 224 271 222 261 226L165 262C152 267 144 279 144 292ZM120 416C107 416 96 409 96 400S107 384 120 384S144 391 144 400S133 416 120 416ZM248 384C235 384 224 377 224 368S235 352 248 352S272 359 272 368S261 384 248 384Z"]
  };
  var faFilePdf = {
    prefix: 'fal',
    iconName: 'file-pdf',
    icon: [384, 512, [], "f1c1", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM203 289C213 257 213 232 213 227C213 208 197 192 178 192S142 208 142 227C142 227 142 257 157 291C149 311 140 330 130 350C107 360 89 373 74 387C68 393 64 402 64 413C64 432 80 448 99 448C111 448 122 443 128 434C134 425 147 407 160 383C178 377 197 371 218 367C230 375 260 393 282 393C303 393 320 376 320 354C320 333 302 316 281 316C265 316 240 319 229 321C218 312 210 301 203 289ZM105 417C102 421 92 420 92 411C92 410 93 408 94 407C104 398 115 390 128 383C118 399 110 411 105 417ZM178 220C182 220 185 223 185 227C185 243 181 263 179 270C171 247 171 229 171 227C171 223 174 220 178 220ZM161 353C168 339 175 324 181 307C188 319 196 330 207 340C192 343 176 347 161 353ZM281 344C287 344 292 349 292 355C292 360 287 365 282 365C273 365 251 354 241 348C242 348 268 344 281 344Z"]
  };
  var faFilePen = {
    prefix: 'fal',
    iconName: 'file-pen',
    icon: [384, 512, [], "f31c", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM97 360C95 362 93 365 92 368L80 429C78 440 88 450 99 448L160 436C163 435 166 433 168 431L290 309C298 302 303 292 304 281C305 268 300 255 291 246L283 238C275 230 266 225 255 224C242 223 229 228 220 237L97 360ZM149 405L116 412L123 379L209 293L235 319L149 405ZM243 259C247 255 255 255 259 259L269 269C273 273 273 281 269 285L258 297L231 270L243 259Z"]
  };
  var faFilePlus = {
    prefix: 'fal',
    iconName: 'file-plus',
    icon: [384, 512, [], "f319", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM208 272C208 263 201 256 192 256S176 263 176 272V320H128C119 320 112 327 112 336S119 352 128 352H176V400C176 409 183 416 192 416S208 409 208 400V352H256C265 352 272 345 272 336S265 320 256 320H208V272Z"]
  };
  var faFilePowerpoint = {
    prefix: 'fal',
    iconName: 'file-powerpoint',
    icon: [384, 512, [], "f1c4", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM128 240C119 240 112 247 112 256V432C112 441 119 448 128 448S144 441 144 432V384H200C240 384 272 352 272 312S240 240 200 240H128ZM240 312C240 334 222 352 200 352H144V272H200C222 272 240 290 240 312Z"]
  };
  var faFilePrescription = {
    prefix: 'fal',
    iconName: 'file-prescription',
    icon: [384, 512, [], "f572", "M193 330C215 319 228 295 223 268C217 242 192 224 166 224H112C103 224 96 231 96 240L96 368C96 377 103 384 112 384C121 384 128 377 128 368V336H153L201 384L165 421C158 427 158 437 165 443C168 446 172 448 176 448S184 446 187 443L224 407L261 443C267 450 277 450 283 443S290 427 283 421L247 384L283 347C290 341 290 331 283 325S267 318 261 325L224 361L193 330ZM168 304H128V256H168C181 256 192 267 192 280S181 304 168 304ZM365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448Z"]
  };
  var faFileSignature = {
    prefix: 'fal',
    iconName: 'file-signature',
    icon: [576, 512, [], "f573", "M561 136L536 111C516 91 483 91 463 111L303 270C273 300 256 341 256 384C252 383 249 381 247 378C235 354 200 347 181 363L167 322C163 312 154 305 144 305S125 312 121 322L103 376C102 381 97 384 92 384H80C71 384 64 391 64 400S71 416 80 416H92C111 416 128 404 133 386L144 355L161 405C165 419 184 420 190 407L198 392C202 384 214 383 218 392C226 407 240 416 256 416H288C355 416 401 370 402 369L561 209C571 199 576 186 576 173C576 159 571 146 561 136ZM379 346C355 370 322 384 288 384C288 350 302 317 326 293L447 173L499 225L379 346ZM538 187L517 208L464 155L485 134C493 126 506 126 513 134L538 159C546 166 546 179 538 187ZM364 448C358 448 351 452 349 458C345 471 333 480 319 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H191V144C191 170 213 192 239 192H303C312 192 319 185 319 176V176C319 167 312 160 303 160H239C230 160 223 153 223 144V34C228 36 232 38 235 41L325 132C331 138 341 138 347 132L348 131C354 125 354 115 348 109L258 19C246 7 230 0 213 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H319C347 512 371 494 379 468C383 458 375 448 364 448Z"]
  };
  var faFileSpreadsheet = {
    prefix: 'fal',
    iconName: 'file-spreadsheet',
    icon: [384, 512, [], "f65b", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM64 256V416C64 434 78 448 96 448H288C306 448 320 434 320 416V256C320 238 306 224 288 224H96C78 224 64 238 64 256ZM128 416H96V384H128V416ZM128 352H96V320H128V352ZM224 416H160V384H224V416ZM224 352H160V320H224V352ZM288 416H256V384H288V416ZM288 352H256V320H288V352ZM288 288H96V256H288V288Z"]
  };
  var faFileUser = {
    prefix: 'fal',
    iconName: 'file-user',
    icon: [384, 512, [], "f65c", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM272 480H112V464C112 438 134 416 160 416H224C250 416 272 438 272 464V480ZM352 448C352 466 338 480 320 480H304V464C304 420 268 384 224 384H160C116 384 80 420 80 464V480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM192 224C157 224 128 253 128 288S157 352 192 352S256 323 256 288S227 224 192 224ZM192 320C174 320 160 306 160 288S174 256 192 256S224 270 224 288S210 320 192 320Z"]
  };
  var faFileVideo = {
    prefix: 'fal',
    iconName: 'file-video',
    icon: [384, 512, [], "f1c8", "M379 146C376 138 371 131 365 125L312 72L259 19C253 13 246 8 238 5C230 2 222 0 214 0H64C46 0 30 7 19 19S0 46 0 64V448C0 466 7 482 19 493S46 512 64 512H320C338 512 354 505 365 493S384 466 384 448V170C384 162 382 154 379 146ZM224 34C226 35 228 36 230 37C232 38 234 40 236 41L343 148C344 150 346 152 347 154C348 156 349 158 350 160H240C236 160 232 158 229 155C226 152 224 148 224 144V34ZM352 448C352 457 348 465 343 471C337 476 329 480 320 480H64C55 480 47 476 41 471C36 465 32 457 32 448V64C32 55 36 47 41 41C47 36 55 32 64 32H192V144C192 157 197 169 206 178S227 192 240 192H352V448ZM231 265C225 260 217 256 208 256H96C87 256 79 260 73 265C68 271 64 279 64 288V384C64 393 68 401 73 407C79 412 87 416 96 416H208C217 416 225 412 231 407C236 402 239 395 239 387L299 407C301 408 302 408 304 408C307 408 311 407 313 405C318 402 320 397 320 392V280C320 275 318 270 313 267C309 264 304 263 299 265L239 285C239 277 236 270 231 265ZM208 384H96V288H208V384ZM240 318L288 302V370L240 354V318Z"]
  };
  var faFileWaveform = {
    prefix: 'fal',
    iconName: 'file-waveform',
    icon: [448, 512, [], "f478", "M179 378C182 382 187 384 192 384C192 384 193 384 193 384C199 383 204 380 206 375L256 276L274 311C276 317 282 320 288 320H352C361 320 368 313 368 304S361 288 352 288H298L270 233C265 222 247 222 242 233L189 338L157 294C154 290 149 288 144 288H16C7 288 0 295 0 304S7 320 16 320H136L179 378ZM429 125L323 19C311 7 294 0 278 0H128C93 0 64 29 64 64V224C64 233 71 240 80 240C89 240 96 233 96 224V64C96 46 110 32 128 32H256V144C256 170 278 192 304 192H416V448C416 466 402 480 384 480H128C110 480 96 466 96 448V384C96 375 89 368 80 368C71 368 64 375 64 384V448C64 483 93 512 128 512H384C419 512 448 483 448 448V170C448 154 441 137 429 125ZM304 160C295 160 288 153 288 144V34C292 36 297 38 300 41L407 148C410 151 412 156 414 160H304Z"]
  };
  var faFileWord = {
    prefix: 'fal',
    iconName: 'file-word',
    icon: [384, 512, [], "f1c2", "M177 250L133 360L112 253C110 244 102 239 93 240C84 242 79 250 80 259L112 419C114 426 119 431 127 432C134 433 140 429 143 422L192 299L241 422C244 428 250 432 256 432C256 432 257 432 257 432C265 431 270 426 272 419L304 259C305 250 300 242 291 240C282 238 274 244 272 253L251 360L207 250C202 238 182 238 177 250ZM365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448Z"]
  };
  var faFileXmark = {
    prefix: 'fal',
    iconName: 'file-xmark',
    icon: [384, 512, [], "f317", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM249 302C255 296 255 286 249 279S232 273 226 279L192 313L158 279C152 273 142 273 135 279S129 296 135 302L169 336L135 370C129 376 129 386 135 393S152 399 158 393L192 359L226 393C232 399 242 399 249 393S255 376 249 370L215 336L249 302Z"]
  };
  var faFileZipper = {
    prefix: 'fal',
    iconName: 'file-zipper',
    icon: [384, 512, [], "f1c6", "M365 125L259 19C247 7 230 0 214 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V170C384 154 377 137 365 125ZM224 34C228 36 233 38 236 41L343 148C346 151 348 156 350 160H240C231 160 224 153 224 144V34ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H192V144C192 170 214 192 240 192H352V448ZM144 128H80C71 128 64 135 64 144S71 160 80 160H144C153 160 160 153 160 144S153 128 144 128ZM144 64H80C71 64 64 71 64 80S71 96 80 96H144C153 96 160 89 160 80S153 64 144 64ZM144 192H80C71 192 64 199 64 208S71 224 80 224H144C153 224 160 217 160 208S153 192 144 192ZM144 256H80C71 256 64 263 64 272V320C64 346 86 368 112 368S160 346 160 320V272C160 263 153 256 144 256ZM128 320C128 329 121 336 112 336S96 329 96 320V288H128V320Z"]
  };
  var faFiles = {
    prefix: 'fal',
    iconName: 'files',
    icon: [448, 512, [], "e12a", "M336 480H96C61 480 32 451 32 416V112C32 103 25 96 16 96S0 103 0 112V416C0 469 43 512 96 512H336C345 512 352 505 352 496S345 480 336 480ZM429 113L335 19C323 7 306 0 290 0H160C125 0 96 29 96 64V352C96 387 125 416 160 416H384C419 416 448 387 448 352V158C448 142 441 125 429 113ZM320 49L399 128H336C327 128 320 121 320 112V49ZM416 352C416 370 402 384 384 384H160C142 384 128 370 128 352V64C128 46 142 32 160 32H288V112C288 138 310 160 336 160H416V352Z"]
  };
  var faFilesMedical = {
    prefix: 'fal',
    iconName: 'files-medical',
    icon: [448, 512, [], "f7fd", "M336 480H96C61 480 32 451 32 416V112C32 103 25 96 16 96S0 103 0 112V416C0 469 43 512 96 512H336C345 512 352 505 352 496S345 480 336 480ZM429 113L335 19C323 7 306 0 290 0H160C125 0 96 29 96 64V352C96 387 125 416 160 416H384C419 416 448 387 448 352V158C448 142 441 125 429 113ZM320 49L399 128H336C327 128 320 121 320 112V49ZM416 352C416 370 402 384 384 384H160C142 384 128 370 128 352V64C128 46 142 32 160 32H288V112C288 138 310 160 336 160H416V352ZM299 189C299 182 293 176 285 176H259C251 176 245 182 245 189V229H205C198 229 192 235 192 243V269C192 277 198 283 205 283H245V323C245 330 251 336 259 336H285C293 336 299 330 299 323V283H339C346 283 352 277 352 269V243C352 235 346 229 339 229H299V189Z"]
  };
  var faFill = {
    prefix: 'fal',
    iconName: 'fill',
    icon: [512, 512, [], "f575", "M503 217L295 9C289 3 281 0 272 0C264 0 256 3 250 9L157 102L63 8C56 2 46 2 40 8L40 8C34 14 34 24 40 31L134 125L28 231C-9 268 -9 329 28 367L145 484C164 503 189 512 213 512C238 512 262 503 281 484L503 262C515 250 515 230 503 217ZM258 461C246 473 230 480 213 480C196 480 180 473 168 461L51 344C44 337 39 329 36 320H400L258 461ZM432 288H33C35 275 41 263 51 254L157 148L245 235C251 242 261 242 267 235C273 229 273 219 267 213L179 125L272 32L480 240L432 288Z"]
  };
  var faFillDrip = {
    prefix: 'fal',
    iconName: 'fill-drip',
    icon: [576, 512, [], "f576", "M525 340C519 330 505 330 499 340C480 370 448 423 448 448C448 483 477 512 512 512S576 483 576 448C576 423 544 370 525 340ZM512 480C494 480 480 466 480 448C480 438 494 410 512 379C530 410 544 438 544 448C544 466 530 480 512 480ZM503 217L295 9C289 3 281 0 272 0C264 0 256 3 250 9L157 102L63 8C56 2 46 2 40 8C34 14 34 24 40 31L134 125L28 231C-9 268 -9 329 28 367L145 484C164 503 189 512 213 512C238 512 262 503 281 484L503 262C515 250 515 230 503 217ZM258 461C246 473 230 480 213 480C196 480 180 473 168 461L51 344C44 337 39 329 36 320H400L258 461ZM432 288H33C35 275 41 263 51 254L157 148L245 235C251 242 261 242 267 235C273 229 273 219 267 213L179 125L272 32L480 240L432 288Z"]
  };
  var faFilm = {
    prefix: 'fal',
    iconName: 'film',
    icon: [512, 512, [], "f008", "M448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM384 64V240H128V64H384ZM32 96C32 78 46 64 64 64H96V144H32V96ZM32 176H96V240H32V176ZM32 272H96V336H32V272ZM64 448C46 448 32 434 32 416V368H96V448H64ZM128 448V272H384V448H128ZM480 416C480 434 466 448 448 448H416V368H480V416ZM480 336H416V272H480V336ZM480 240H416V176H480V240ZM480 144H416V64H448C466 64 480 78 480 96V144Z"]
  };
  var faFilmCanister = {
    prefix: 'fal',
    iconName: 'film-canister',
    icon: [576, 512, [], "f8b7", "M112 32H240C249 32 256 25 256 16C256 7 249 0 240 0H112C103 0 96 7 96 16C96 25 103 32 112 32ZM336 480H320V96H336C345 96 352 89 352 80C352 71 345 64 336 64H16C7 64 0 71 0 80C0 89 7 96 16 96H32V480H16C7 480 0 487 0 496C0 505 7 512 16 512H336C345 512 352 505 352 496C352 487 345 480 336 480ZM288 480H64V96H288V480ZM528 128H368C359 128 352 135 352 144S359 160 368 160H528C537 160 544 167 544 176V304C544 313 537 320 528 320C502 320 480 342 480 368V400C480 409 473 416 464 416H368C359 416 352 423 352 432S359 448 368 448H464C490 448 512 426 512 400V368C512 359 519 352 528 352C554 352 576 330 576 304V176C576 150 554 128 528 128ZM384 376C384 380 388 384 392 384H408C412 384 416 380 416 376V360C416 356 412 352 408 352H392C388 352 384 356 384 360V376ZM504 224C508 224 512 220 512 216V200C512 196 508 192 504 192H488C484 192 480 196 480 200V216C480 220 484 224 488 224H504ZM392 224H408C412 224 416 220 416 216V200C416 196 412 192 408 192H392C388 192 384 196 384 200V216C384 220 388 224 392 224Z"]
  };
  var faFilmSimple = {
    prefix: 'fal',
    iconName: 'film-simple',
    icon: [512, 512, [], "f3a0", "M448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM32 96C32 78 46 64 64 64H96V144H32V96ZM32 176H96V240H32V176ZM32 272H96V336H32V272ZM64 448C46 448 32 434 32 416V368H96V448H64ZM128 448V64H384V448H128ZM480 416C480 434 466 448 448 448H416V368H480V416ZM480 336H416V272H480V336ZM480 240H416V176H480V240ZM480 144H416V64H448C466 64 480 78 480 96V144Z"]
  };
  var faFilms = {
    prefix: 'fal',
    iconName: 'films',
    icon: [576, 512, [], "e12b", "M464 448H96C61 448 32 419 32 384V112C32 103 25 96 16 96S0 103 0 112V384C0 437 43 480 96 480H464C473 480 480 473 480 464S473 448 464 448ZM512 32H160C125 32 96 61 96 96V320C96 355 125 384 160 384H512C547 384 576 355 576 320V96C576 61 547 32 512 32ZM192 352H160C142 352 128 338 128 320V288H192V352ZM192 256H128V160H192V256ZM192 128H128V96C128 78 142 64 160 64H192V128ZM448 352H224V224H448V352ZM448 192H224V64H448V192ZM544 320C544 338 530 352 512 352H480V288H544V320ZM544 256H480V160H544V256ZM544 128H480V64H512C530 64 544 78 544 96V128Z"]
  };
  var faFilter = {
    prefix: 'fal',
    iconName: 'filter',
    icon: [512, 512, [], "f0b0", "M479 32H33C5 32 -10 63 7 84L192 307V400C192 408 196 415 202 420L282 476C287 479 291 480 296 480C308 480 320 470 320 456V307L505 84C522 63 507 32 479 32ZM295 286L288 295V441L224 396V295L217 286L33 64H479L480 64L295 286Z"]
  };
  var faFilterList = {
    prefix: 'fal',
    iconName: 'filter-list',
    icon: [512, 512, [], "e12c", "M330 64H22C4 64 -7 86 5 100L112 226V368C112 376 116 383 122 388L202 444C207 447 211 448 216 448C228 448 240 438 240 424V226L347 100C359 86 348 64 330 64ZM216 205L208 214V409L144 364V214L136 205L44 96H308L216 205ZM432 112H496C505 112 512 105 512 96S505 80 496 80H432C423 80 416 87 416 96S423 112 432 112ZM496 240H336C327 240 320 247 320 256S327 272 336 272H496C505 272 512 265 512 256S505 240 496 240ZM496 400H336C327 400 320 407 320 416S327 432 336 432H496C505 432 512 425 512 416S505 400 496 400Z"]
  };
  var faFilters = {
    prefix: 'fal',
    iconName: 'filters',
    icon: [640, 512, [], "e12d", "M289 276L263 306L256 315V441L192 396V315L185 306L37 128H168C177 128 184 121 184 112C184 103 177 96 168 96H29C5 96 -9 123 6 142L160 327V400C160 408 164 415 170 420L250 476C255 479 259 480 264 480C276 480 288 470 288 456V327L313 296C317 291 318 285 316 279C311 268 296 267 289 276ZM611 32H221C197 32 183 59 198 78L352 263V368C352 376 356 383 362 388L442 444C447 447 451 448 456 448C468 448 480 438 480 424V263L634 78C649 59 635 32 611 32ZM455 242L448 251V409L384 364V251L377 242L229 64H603L455 242Z"]
  };
  var faFingerprint = {
    prefix: 'fal',
    iconName: 'fingerprint',
    icon: [512, 512, [], "f577", "M256 170C228 170 203 180 185 198C167 216 157 240 157 266C158 316 154 366 143 415C142 424 147 432 156 434C164 436 173 430 175 421C185 370 190 318 189 265C189 248 195 233 207 221C226 202 250 202 256 202C293 203 322 232 323 268C324 318 320 369 312 418C310 427 316 435 325 436C326 437 327 437 328 437C335 437 342 431 343 423C352 372 356 320 355 267C354 215 310 171 256 170ZM256 256C247 256 240 263 240 272C241 346 232 417 212 487L211 492C209 498 213 512 227 512C234 512 240 507 242 500L243 496C264 423 273 348 272 272C272 263 264 256 256 256ZM113 150C88 181 74 220 75 260C75 300 72 339 65 378C63 386 69 395 78 396C79 396 80 396 81 396C88 396 95 391 96 383C104 343 107 301 107 260C106 227 117 196 137 170C143 163 142 153 135 148C128 142 118 143 113 150ZM512 253C512 236 510 220 506 204C504 195 496 190 487 192C478 193 473 202 475 211C478 225 480 239 480 253C480 261 480 269 480 276C480 285 487 292 496 292H496C505 292 512 285 512 277C512 269 512 261 512 253ZM253 0C183 -1 118 25 70 73C24 119 -1 181 0 246C0 254 0 261 0 269C0 278 7 285 16 285H16C25 285 32 278 32 270C32 262 32 254 32 246C31 189 53 136 93 96C135 54 192 31 252 32C327 33 397 70 440 131C445 139 455 140 462 135C469 130 471 120 466 113C417 44 338 1 253 0ZM254 85C239 85 223 86 209 90C200 92 195 101 197 109C199 118 208 123 216 121C228 118 241 117 253 117C336 118 405 185 406 265C406 305 404 345 400 384C399 392 405 400 414 401C415 401 415 401 416 401C424 401 431 395 432 387C436 347 438 305 438 264C436 167 354 87 254 85Z"]
  };
  var faFire = {
    prefix: 'fal',
    iconName: 'fire',
    icon: [448, 512, [], "f06d", "M327 215C324 210 320 207 315 207C310 207 305 209 301 212L263 256C240 227 193 167 188 161C185 158 179 155 175 156C171 156 166 158 163 161C123 210 96 245 96 286C96 295 103 302 112 302S128 295 128 286C128 261 143 237 175 197C193 219 226 261 250 291C253 295 257 297 262 297C267 298 271 295 274 292L310 250C330 290 319 338 285 361C278 366 276 376 281 384C284 388 289 391 294 391C297 391 300 390 303 388C351 354 366 287 337 233C334 227 331 221 327 215ZM327 48C321 42 312 42 305 48C291 61 278 75 265 90C241 59 213 28 183 0C177 -6 167 -6 161 0C68 87 0 203 0 276C0 404 100 508 224 508S448 404 448 276C448 222 398 115 327 48ZM224 476C118 476 32 386 32 276C32 215 91 113 172 34C202 63 229 94 251 125C254 129 259 132 264 132C270 132 274 130 277 126C289 110 302 96 316 82C373 141 416 232 416 276C416 386 330 476 224 476Z"]
  };
  var faFireExtinguisher = {
    prefix: 'fal',
    iconName: 'fire-extinguisher',
    icon: [512, 512, [], "f134", "M503 6C499 2 494 0 488 0C487 0 485 0 484 0L308 32C296 34 288 44 288 56V64H192V16C192 7 185 0 176 0C167 0 160 7 160 16V64H112C50 64 0 114 0 176C0 185 7 192 16 192S32 185 32 176C32 132 68 96 112 96H160V130C106 137 64 184 64 240V464C64 490 86 512 112 512H240C266 512 288 490 288 464V240C288 184 246 137 192 130V96H288V104C288 116 296 126 308 128L484 160C485 160 487 160 488 160C494 160 499 158 503 154C509 150 512 143 512 136V24C512 17 509 10 503 6ZM256 464C256 473 249 480 240 480H112C103 480 96 473 96 464V448H256V464ZM256 240V416H96V240C96 196 132 160 176 160C220 160 256 196 256 240ZM480 126L320 97V63L480 34V126Z"]
  };
  var faFireFlame = {
    prefix: 'fal',
    iconName: 'fire-flame',
    icon: [384, 512, [], "f6df", "M214 9C208 3 200 0 192 0S176 3 170 9C69 105 0 226 0 301C0 425 79 512 192 512S384 425 384 301C384 226 314 105 214 9ZM192 480C96 480 32 408 32 301C32 245 88 132 192 32C192 32 192 32 192 32C283 120 352 235 352 301C352 408 288 480 192 480ZM252 213C226 190 201 169 201 135C201 131 197 129 195 128C194 128 193 128 192 128C189 128 187 129 185 132C111 231 224 224 224 296C224 327 199 352 168 352C137 352 112 327 112 296V256C112 254 111 252 110 250C108 249 106 248 104 248S100 249 98 250C90 259 64 286 64 330C64 395 121 448 192 448S320 395 320 330C320 271 286 242 252 213ZM192 416C147 416 109 388 99 350C115 371 140 384 168 384C217 384 256 345 256 296C256 275 250 259 241 246C268 269 288 291 288 330C288 377 245 416 192 416Z"]
  };
  var faFireFlameCurved = {
    prefix: 'fal',
    iconName: 'fire-flame-curved',
    icon: [384, 512, [], "f7e4", "M216 24C216 9 204 0 192 0C185 0 177 3 172 11C48 192 224 200 224 288C224 323 195 352 160 352C160 352 159 352 159 352C124 352 96 322 96 287V202C96 187 84 178 72 178C66 178 60 180 55 185C28 213 0 261 0 320C0 426 86 512 192 512S384 426 384 320C384 150 216 127 216 24ZM192 480C104 480 32 408 32 320C32 277 50 244 64 224V287C64 340 106 383 160 384C213 384 256 341 256 288C256 244 227 216 202 191C165 155 137 128 186 47C195 93 229 125 263 156C307 196 352 238 352 320C352 408 280 480 192 480Z"]
  };
  var faFireFlameSimple = {
    prefix: 'fal',
    iconName: 'fire-flame-simple',
    icon: [384, 512, [], "f46a", "M214 9C202 -3 182 -3 170 9C69 105 0 226 0 301C0 425 79 512 192 512S384 425 384 301C384 226 314 105 214 9ZM213 478C206 479 199 480 192 480S178 479 171 478C128 469 99 434 99 385C99 372 103 324 192 224C281 324 285 372 285 385C285 434 256 469 213 478ZM311 425C315 412 317 399 317 385C317 304 204 190 192 176C179 190 67 304 67 385C67 399 69 413 73 425C47 394 32 351 32 301C32 210 155 73 192 37C229 73 352 210 352 301C352 351 337 394 311 425Z"]
  };
  var faFireSmoke = {
    prefix: 'fal',
    iconName: 'fire-smoke',
    icon: [640, 512, [], "f74b", "M167 252C168 252 170 252 171 252C180 249 185 240 182 231C178 219 176 207 176 194C176 160 212 93 280 33C302 53 322 73 338 94C341 98 346 100 350 100C355 100 360 98 363 95C371 85 381 76 391 67C436 109 464 169 464 194C464 207 462 219 458 231C456 240 460 249 469 251C477 254 486 249 489 241C494 225 496 210 496 194C496 155 457 80 401 33C395 28 387 28 381 33C371 42 361 51 352 60C334 39 313 19 290 0C284 -5 276 -5 270 0C196 62 144 142 144 194C144 210 146 226 151 241C154 248 160 252 167 252ZM396 236C405 238 413 231 415 223C418 200 415 177 406 157C403 152 401 147 398 142C396 137 391 134 385 134C380 133 375 135 371 140L348 170C331 145 301 103 298 99C295 95 291 92 286 92H285C280 92 276 95 273 99C243 138 224 167 224 200C224 208 225 216 226 223C227 231 234 236 242 236C243 236 244 236 245 236C253 234 259 226 258 217C257 212 256 206 256 200C256 182 265 164 285 136C298 154 319 184 334 206C337 210 342 212 347 213C352 213 357 210 360 206L380 180C384 192 385 205 383 218C382 226 387 235 396 236ZM528 284C495 284 464 299 443 323C418 280 371 252 320 252S222 280 197 323C176 299 145 284 112 284C50 284 0 334 0 396S50 508 112 508H528C590 508 640 458 640 396S590 284 528 284ZM528 476H112C68 476 32 440 32 396S68 316 112 316C143 316 171 335 184 363C187 369 194 373 200 372C206 372 212 367 214 361C229 315 272 284 320 284S411 315 426 361C428 367 434 372 440 372C447 373 453 369 456 363C469 335 497 316 528 316C572 316 608 352 608 396S572 476 528 476Z"]
  };
  var faFireplace = {
    prefix: 'fal',
    iconName: 'fireplace',
    icon: [640, 512, [], "f79a", "M342 312C328 293 311 274 291 256C241 302 205 361 205 397C205 460 256 512 320 512S435 460 435 397C435 370 409 315 371 282C361 291 351 301 342 312ZM320 480C274 480 237 443 237 397C237 377 257 338 291 301C301 311 309 321 317 331L341 363L367 332L370 328C391 355 403 385 403 397C403 443 366 480 320 480ZM608 0H32C14 0 0 14 0 32V96C0 114 14 128 32 128H608C626 128 640 114 640 96V32C640 14 626 0 608 0ZM608 96H32V32H608V96ZM592 160C583 160 576 167 576 176V480H512V352C512 246 426 160 320 160S128 246 128 352V480H64V176C64 167 57 160 48 160C39 160 32 167 32 176V480C32 498 46 512 64 512H128C146 512 160 498 160 480V352C160 264 232 192 320 192S480 264 480 352V480C480 498 494 512 512 512H576C594 512 608 498 608 480V176C608 167 601 160 592 160Z"]
  };
  var faFish = {
    prefix: 'fal',
    iconName: 'fish',
    icon: [576, 512, [], "f578", "M325 64C229 64 155 133 123 169L53 104C42 95 28 93 17 100C4 107 -2 121 1 135L27 256L1 377C-2 391 4 405 17 412C28 419 42 417 53 408L123 343C155 379 229 448 325 448C460 448 576 302 576 256S460 64 325 64ZM325 416C249 416 178 361 137 310C134 307 130 305 126 304C125 304 125 304 124 304C120 304 116 306 114 308L32 383L59 259C59 257 59 255 59 253L31 128L114 204C117 207 121 208 126 208C130 207 134 205 137 202C178 151 249 96 325 96C448 96 544 231 544 256S448 416 325 416ZM416 232C403 232 392 243 392 256C392 269 403 280 416 280S440 269 440 256C440 243 429 232 416 232Z"]
  };
  var faFishCooked = {
    prefix: 'fal',
    iconName: 'fish-cooked',
    icon: [576, 512, [], "f7fe", "M325 64C229 64 155 133 123 169L53 104C42 95 28 93 16 100C4 107 -2 121 1 135L27 256L1 377C-2 391 4 405 17 412C28 419 42 417 53 408L123 343C155 379 229 448 325 448C460 448 576 302 576 256S460 64 325 64ZM325 416C249 416 178 361 137 310C134 307 130 305 126 304C125 304 125 304 124 304C120 304 116 306 113 308L32 383L59 259C59 257 59 255 59 253L31 128L114 204C117 207 121 208 126 208C130 207 134 205 137 202C178 151 249 96 325 96C448 96 544 231 544 256S448 416 325 416ZM427 165C421 158 411 158 405 165L245 325C238 331 238 341 245 347C248 350 252 352 256 352S264 350 267 347L427 187C434 181 434 171 427 165ZM251 235L315 171C322 165 322 155 315 149S299 142 293 149L229 213C222 219 222 229 229 235C232 238 236 240 240 240S248 238 251 235ZM421 277L357 341C350 347 350 357 357 363C360 366 364 368 368 368S376 366 379 363L443 299C450 293 450 283 443 277S427 270 421 277Z"]
  };
  var faFistRaised = {
    prefix: 'fal',
    iconName: 'fist-raised',
    icon: [448, 512, [], "f6de", "M383 168C383 165 384 163 384 160V80C384 54 362 32 336 32H320C314 32 308 33 302 35C297 15 278 0 256 0H240C218 0 199 15 194 35C188 33 182 32 176 32H160C138 32 119 47 114 67C108 65 102 64 96 64H80C54 64 32 86 32 112V299C32 337 47 374 74 401L96 423V496C96 505 103 512 112 512H112C121 512 128 505 128 496V416C128 412 126 408 123 405L97 378C76 357 64 329 64 299V253C69 255 74 256 80 256H96C108 256 119 251 128 243C137 251 148 256 160 256H176C189 256 201 251 210 242C210 242 219 257 240 266C223 280 205 305 185 335C180 342 181 351 188 356V356C196 362 206 360 211 352C247 297 267 277 305 273C313 272 320 265 320 256V256C320 247 313 240 304 240H271C245 240 224 219 224 193V192C224 183 231 176 240 176H320C355 176 384 205 384 240V328C384 354 374 378 356 396L325 427C322 430 320 434 320 439V496C320 505 327 512 336 512H336C345 512 352 505 352 496V445L379 419C403 395 416 362 416 328V240C416 211 403 186 383 168ZM112 208C112 217 105 224 96 224H80C71 224 64 217 64 208V112C64 103 71 96 80 96H96C105 96 112 103 112 112V208ZM192 208C192 217 185 224 176 224H160C151 224 144 217 144 208V80C144 71 151 64 160 64H176C185 64 192 71 192 80V208ZM272 144H240C234 144 229 145 224 147V48C224 39 231 32 240 32H256C265 32 272 39 272 48V144ZM352 150C342 146 331 144 320 144H304V80C304 71 311 64 320 64H336C345 64 352 71 352 80V150Z"]
  };
  var faFlag = {
    prefix: 'fal',
    iconName: 'flag',
    icon: [512, 512, [], "f024", "M499 6C479 -6 460 3 457 4C415 23 381 32 349 32C320 32 297 25 273 17C248 9 221 0 185 0C159 0 121 3 32 39V16C32 7 25 0 16 0S0 7 0 16V496C0 505 7 512 16 512S32 505 32 496V391C46 385 110 352 181 352C218 352 248 360 280 368C311 376 343 384 379 384C415 384 451 376 491 361H491C504 356 512 344 512 331L512 32C512 22 507 12 499 6ZM480 331C444 345 411 352 379 352C347 352 318 345 288 337C255 329 222 320 181 320C135 320 87 331 35 355L32 356V73L60 62C109 42 150 32 185 32C216 32 239 40 263 48C289 56 315 64 349 64C419 64 480 32 480 32L480 331Z"]
  };
  var faFlagCheckered = {
    prefix: 'fal',
    iconName: 'flag-checkered',
    icon: [512, 512, [], "f11e", "M472 0C465 0 458 2 451 5C401 27 363 35 332 35C266 35 228 0 151 0C120 0 81 7 32 24V16C32 7 25 0 16 0S0 7 0 16V496C0 505 7 512 16 512S32 505 32 496V404C76 388 114 382 146 382C228 382 284 416 366 416C401 416 441 409 489 391C503 386 512 373 512 360V33C512 13 493 0 472 0ZM464 34C474 30 480 33 480 39V100C450 109 424 115 400 117V57C420 52 441 44 464 34ZM480 188C450 197 424 203 400 205V150C424 147 450 142 480 133V188ZM480 276C450 285 424 290 400 293V238C424 235 450 230 480 221V276ZM368 207C333 208 302 202 272 195V140C301 147 331 152 368 152V207ZM240 188C211 181 180 176 144 177V120C180 120 210 126 240 133V188ZM240 221V276C211 269 180 264 144 264V208C180 208 210 214 240 221ZM272 228C301 235 331 240 368 240V295C333 296 302 290 272 283V228ZM368 64V119C333 120 302 114 272 107V59C290 63 309 67 332 67C344 67 356 66 368 64ZM240 49V100C211 93 180 88 144 89V33C146 33 149 32 151 32C186 32 213 41 240 49ZM32 369V57C61 47 88 40 112 36V90C88 93 62 98 32 107V140C62 130 88 125 112 123V178C88 181 62 186 32 195V228C62 218 88 213 112 211V266C88 269 62 274 32 283V316C62 306 88 301 112 298V352C86 354 60 360 32 369ZM146 350C146 350 145 350 144 350V296C180 296 210 302 240 309V362C211 355 181 350 146 350ZM365 384C332 384 302 377 272 370V316C301 322 331 328 368 327V384C367 384 366 384 365 384ZM480 359C479 361 443 375 400 381V325C424 323 450 318 480 309V359Z"]
  };
  var faFlagPennant = {
    prefix: 'fal',
    iconName: 'flag-pennant',
    icon: [512, 512, [], "f456", "M497 186L32 15C31 6 24 0 16 0C7 0 0 7 0 16V496C0 505 7 512 16 512S32 505 32 496V401L497 230C517 223 517 193 497 186ZM32 367V49L464 208L32 367Z"]
  };
  var faFlagSwallowtail = {
    prefix: 'fal',
    iconName: 'flag-swallowtail',
    icon: [512, 512, [], "f74c", "M401 208L504 85C513 75 514 62 509 50S492 32 480 32H32V16C32 7 25 0 16 0S0 7 0 16V496C0 505 7 512 16 512S32 505 32 496V384H480C492 384 504 377 509 366S513 341 504 331L401 208ZM32 352V64H480L359 208L480 352H32Z"]
  };
  var faFlagUsa = {
    prefix: 'fal',
    iconName: 'flag-usa',
    icon: [512, 512, [], "f74d", "M472 0C465 0 458 2 451 5C401 27 363 35 332 35C266 35 228 0 151 0C120 0 81 7 32 24V16C32 7 25 0 16 0S0 7 0 16V496C0 505 7 512 16 512H16C25 512 32 505 32 496V404C76 388 114 382 146 382C228 382 284 416 366 416C401 416 441 409 489 391C503 386 512 373 512 360V33C512 13 493 0 472 0ZM256 54C314 72 370 76 464 34C474 30 480 33 480 39V92C381 134 327 120 256 108V54ZM256 140C290 146 320 152 355 152C390 152 431 145 480 126V188C376 221 317 206 256 192V140ZM32 57C78 41 117 32 151 32C179 32 202 38 224 45V185C173 174 115 170 32 195V57ZM32 228C133 196 191 209 252 224C310 237 373 254 480 221V276C380 308 321 295 260 280C199 266 135 252 32 283V228ZM365 384C290 384 232 350 146 350C110 350 72 356 32 369V316C132 284 191 297 252 312C311 325 373 342 480 309V359C479 362 421 384 365 384ZM96 64C87 64 80 71 80 80S87 96 96 96S112 89 112 80S105 64 96 64ZM168 96C177 96 184 89 184 80S177 64 168 64S152 71 152 80S159 96 168 96ZM96 120C87 120 80 127 80 136S87 152 96 152S112 145 112 136S105 120 96 120ZM168 152C177 152 184 145 184 136S177 120 168 120S152 127 152 136S159 152 168 152Z"]
  };
  var faFlashlight = {
    prefix: 'fal',
    iconName: 'flashlight',
    icon: [640, 512, [], "f8b8", "M288 208H256C230 208 208 230 208 256S230 304 256 304H288C314 304 336 282 336 256S314 208 288 208ZM288 272H256C247 272 240 265 240 256C240 247 247 240 256 240H288C297 240 304 247 304 256C304 265 297 272 288 272ZM608 96H576C517 96 459 113 409 144H64C29 144 0 173 0 208V304C0 339 29 368 64 368H409C459 399 517 416 576 416H608C626 416 640 402 640 384V128C640 110 626 96 608 96ZM512 377C482 369 453 357 426 341L418 336H64C46 336 32 322 32 304V208C32 190 46 176 64 176H418L426 171C453 155 482 143 512 136V377ZM608 384H576C565 384 555 383 544 382V130C555 129 565 128 576 128H608V384Z"]
  };
  var faFlask = {
    prefix: 'fal',
    iconName: 'flask',
    icon: [448, 512, [], "f0c3", "M437 403L320 215V80C320 71 313 64 304 64S288 71 288 80V144H288V215C288 221 290 227 293 232L348 320H100L155 232C158 227 160 221 160 215V144H160V80C160 71 153 64 144 64S128 71 128 80V215L11 404C-18 451 15 512 71 512H377C433 512 466 450 437 403ZM411 460C408 466 398 480 377 480H71C50 480 40 466 37 460C30 447 30 433 38 420L80 352H368L410 420C418 433 418 447 411 460ZM112 32H336C345 32 352 25 352 16S345 0 336 0H112C103 0 96 7 96 16S103 32 112 32Z"]
  };
  var faFlaskRoundPoison = {
    prefix: 'fal',
    iconName: 'flask-round-poison',
    icon: [448, 512, [], "f6e0", "M184 336C197 336 208 325 208 312S197 288 184 288S160 299 160 312S171 336 184 336ZM264 336C277 336 288 325 288 312S277 288 264 288C251 288 240 299 240 312S251 336 264 336ZM176 448H272C290 448 304 434 304 416V393C334 373 352 344 352 312C352 255 295 208 224 208C153 208 96 255 96 312C96 344 114 373 144 393V416C144 434 158 448 176 448ZM128 312C128 272 171 240 224 240C277 240 320 272 320 312C320 335 305 356 280 370L272 375V416H176V375L168 370C143 356 128 335 128 312ZM320 169V80C320 71 313 64 304 64C295 64 288 71 288 80L288 169C288 181 294 192 305 197C364 229 401 291 400 356C399 398 383 438 355 470C349 476 340 480 331 480H117C108 480 99 476 94 470C64 438 48 396 48 352C48 287 84 227 143 196C153 191 160 180 160 168L160 80C160 71 153 64 144 64H144C135 64 128 71 128 80V168C62 203 16 272 16 352C16 406 36 455 70 492C82 505 99 512 117 512H331C348 512 365 505 377 493C410 457 431 409 432 357C434 277 387 205 320 169ZM112 32H336C345 32 352 25 352 16S345 0 336 0H112C103 0 96 7 96 16S103 32 112 32Z"]
  };
  var faFlaskRoundPotion = {
    prefix: 'fal',
    iconName: 'flask-round-potion',
    icon: [448, 512, [], "f6e1", "M320 169V80C320 71 313 64 304 64C295 64 288 71 288 80L288 169C288 181 294 192 305 197C363 228 400 289 400 352C370 352 331 350 284 322C211 280 132 277 53 314C64 264 96 221 143 196C153 191 160 180 160 168L160 80C160 71 153 64 144 64H144C135 64 128 71 128 80V168C62 203 16 272 16 352C16 406 36 455 70 492C82 505 99 512 117 512H331C348 512 365 505 377 493C410 457 431 409 432 357C434 277 387 205 320 169ZM355 470C349 476 340 480 331 480H117C108 480 99 476 94 470C64 438 48 396 48 352C48 352 48 352 48 352C124 310 198 309 268 350C320 380 365 384 397 384C391 416 377 446 355 470ZM112 32H336C345 32 352 25 352 16S345 0 336 0H112C103 0 96 7 96 16S103 32 112 32Z"]
  };
  var faFlorinSign = {
    prefix: 'fal',
    iconName: 'florin-sign',
    icon: [384, 512, [], "e12e", "M384 48C384 57 377 64 368 64H316C296 64 278 76 271 95L215 240H336C345 240 352 247 352 256S345 272 336 272H203L143 429C131 459 101 480 68 480H16C7 480 0 473 0 464S7 448 16 448H68C88 448 106 436 113 417L169 272H48C39 272 32 265 32 256S39 240 48 240H181L241 83C253 53 283 32 316 32H368C377 32 384 39 384 48Z"]
  };
  var faFlower = {
    prefix: 'fal',
    iconName: 'flower',
    icon: [512, 512, [], "f7ff", "M462 256C492 229 512 190 512 146C512 66 446 0 366 0C322 0 283 20 256 50C229 20 190 0 146 0C66 0 0 66 0 146C0 190 20 229 50 256C20 283 0 322 0 366C0 446 66 512 146 512C190 512 229 492 256 462C283 492 322 512 366 512C446 512 512 446 512 366C512 322 492 283 462 256ZM366 480C333 480 302 466 280 441L256 413L232 440C210 466 179 480 146 480C83 480 32 429 32 366C32 333 46 302 71 280L99 256L71 232C46 210 32 179 32 146C32 83 83 32 146 32C179 32 210 46 232 71L256 99L280 72C302 46 333 32 366 32C429 32 480 83 480 146C480 179 466 210 441 232L413 256L440 280C466 302 480 333 480 366C480 429 429 480 366 480ZM256 160C203 160 160 203 160 256S203 352 256 352S352 309 352 256S309 160 256 160ZM256 320C221 320 192 291 192 256S221 192 256 192S320 221 320 256S291 320 256 320Z"]
  };
  var faFlowerDaffodil = {
    prefix: 'fal',
    iconName: 'flower-daffodil',
    icon: [512, 512, [], "f800", "M288 144C288 126 274 112 256 112S224 126 224 144S238 176 256 176S288 162 288 144ZM496 288H449C380 288 314 320 272 374V278C285 284 299 288 313 288C361 288 400 249 400 201C400 180 393 160 379 144C393 128 400 108 400 87C400 39 361 0 313 0C292 0 272 7 256 21C240 7 220 0 199 0C151 0 112 39 112 87C112 108 119 128 133 144C119 160 112 180 112 201C112 249 151 288 199 288C213 288 227 284 240 278V374C197 320 132 288 63 288H16C7 288 -1 297 0 308C10 422 106 512 224 512H288C406 512 502 422 512 308C513 297 505 288 496 288ZM240 480H224C130 480 49 411 34 320H63C131 320 194 355 228 413C242 436 240 454 240 480ZM256 216L243 234C233 248 216 256 199 256C169 256 144 231 144 201C144 183 152 167 166 157L184 144L166 131C152 121 144 105 144 87C144 57 169 32 199 32C216 32 233 40 243 54L256 72L269 54C279 40 296 32 313 32C343 32 368 57 368 87C368 105 360 121 346 131L328 144L346 157C360 167 368 183 368 201C368 231 343 256 313 256C296 256 279 248 269 234L256 216ZM288 480H272C272 454 270 436 284 413C318 355 381 320 449 320H478C463 411 382 480 288 480Z"]
  };
  var faFlowerTulip = {
    prefix: 'fal',
    iconName: 'flower-tulip',
    icon: [512, 512, [], "f801", "M496 288H449C380 288 314 320 272 374V288C352 288 416 223 416 144V16C416 10 413 5 407 2C402 -1 395 0 391 3L317 57L268 6C265 2 261 0 256 0C251 0 247 2 244 6L195 57L121 3C117 0 110 -1 105 2C99 5 96 10 96 16V144C96 223 160 288 240 288V374C197 320 132 288 63 288H16C7 288 -1 297 0 308C10 422 106 512 224 512H288C406 512 502 422 512 308C513 297 505 288 496 288ZM128 144V47L199 99L256 39L313 99L384 47V144C384 206 334 256 272 256H240C178 256 128 206 128 144ZM240 480H224C130 480 49 411 34 320H63C131 320 194 355 228 413C242 436 240 454 240 480ZM288 480H272C272 454 270 436 284 413C318 355 381 320 449 320H478C463 411 382 480 288 480Z"]
  };
  var faFlute = {
    prefix: 'fal',
    iconName: 'flute',
    icon: [640, 512, [], "f8b9", "M320 232C307 232 296 243 296 256S307 280 320 280S344 269 344 256S333 232 320 232ZM592 160H48C22 160 0 182 0 208V304C0 330 22 352 48 352H592C618 352 640 330 640 304V208C640 182 618 160 592 160ZM112 320H48C39 320 32 313 32 304V208C32 199 39 192 48 192H112V320ZM608 304C608 313 601 320 592 320H144V192H592C601 192 608 199 608 208V304ZM512 232C499 232 488 243 488 256S499 280 512 280S536 269 536 256S525 232 512 232ZM416 232C403 232 392 243 392 256S403 280 416 280S440 269 440 256S429 232 416 232Z"]
  };
  var faFluxCapacitor = {
    prefix: 'fal',
    iconName: 'flux-capacitor',
    icon: [448, 512, [], "f8ba", "M448 112V400C448 444 412 480 368 480H80C36 480 0 444 0 400V112C0 68 36 32 80 32H368C412 32 448 68 448 112ZM416 112C416 86 394 64 368 64H80C54 64 32 86 32 112V400C32 426 54 448 80 448H368C394 448 416 426 416 400V112ZM384 176C384 220 348 256 304 256C300 256 297 255 293 255L338 210C345 202 352 187 352 176C352 150 330 128 304 128C293 128 278 134 270 142L224 188L178 142C170 134 155 128 144 128C118 128 96 150 96 176C96 187 102 202 110 210L155 255C151 255 148 256 144 256C100 256 64 220 64 176S100 96 144 96S224 132 224 176C224 132 260 96 304 96S384 132 384 176ZM208 336V263L133 187C130 184 129 180 128 176C128 172 130 168 133 165C136 162 140 160 144 160C148 161 152 162 155 165L224 233L293 165C296 162 300 160 304 160C308 160 312 162 315 165C318 168 320 172 320 176C320 180 318 184 315 187L240 263V336C240 345 233 352 224 352S208 345 208 336ZM304 336C304 373 278 406 242 414C206 423 168 405 152 371C136 338 145 297 174 274L176 276V336C176 362 198 384 224 384S272 362 272 336V276L274 274C293 289 304 312 304 336Z"]
  };
  var faFolder = {
    prefix: 'fal',
    iconName: 'folder',
    icon: [512, 512, [], "f07b", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM416 192H96C87 192 80 199 80 208S87 224 96 224H416C425 224 432 217 432 208S425 192 416 192Z"]
  };
  var faFolderArrowDown = {
    prefix: 'fal',
    iconName: 'folder-arrow-down',
    icon: [512, 512, [], "e053", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM245 379C251 386 261 386 267 379L347 299C354 293 354 283 347 277S331 270 325 277L272 329V208C272 199 265 192 256 192S240 199 240 208V329L187 277C184 274 180 272 176 272S168 274 165 277C158 283 158 293 165 299L245 379Z"]
  };
  var faFolderArrowUp = {
    prefix: 'fal',
    iconName: 'folder-arrow-up',
    icon: [512, 512, [], "e054", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM267 197C261 190 251 190 245 197L165 277C158 283 158 293 165 299S181 306 187 299L240 247V368C240 377 247 384 256 384S272 377 272 368V247L325 299C328 302 332 304 336 304S344 302 347 299C354 293 354 283 347 277L267 197Z"]
  };
  var faFolderBlank = {
    prefix: 'fal',
    iconName: 'folder-blank',
    icon: [512, 512, [], "e12f", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416Z"]
  };
  var faFolderBookmark = {
    prefix: 'fal',
    iconName: 'folder-bookmark',
    icon: [512, 512, [], "e130", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM384 128V278L343 258C339 255 333 255 329 258L288 278V128H384ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L256 126C256 126 256 127 256 128V304C256 310 259 315 264 318C268 321 274 321 279 318L336 290L393 318C395 319 398 320 400 320C403 320 406 319 408 318C413 315 416 310 416 304V128H448C466 128 480 142 480 160V416Z"]
  };
  var faFolderGear = {
    prefix: 'fal',
    iconName: 'folder-gear',
    icon: [512, 512, [], "e131", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L259 128H448C466 128 480 142 480 160V416ZM353 232C349 224 339 222 331 226L316 235C304 222 289 213 272 210V192C272 183 265 176 256 176S240 183 240 192V210C223 213 208 222 196 235L181 226C173 222 163 224 159 232S157 249 165 254L180 263C178 271 176 279 176 288S178 305 180 313L165 322C157 327 155 336 159 344C162 349 167 352 173 352C176 352 178 351 181 350L196 341C208 354 223 363 240 366V384C240 393 247 400 256 400S272 393 272 384V366C289 363 304 354 316 341L331 350C334 351 336 352 339 352C345 352 350 349 353 344C357 336 355 327 347 322L332 313C334 305 336 297 336 288S334 271 332 263L347 254C355 249 357 240 353 232ZM256 336C230 336 208 314 208 288S230 240 256 240S304 262 304 288S282 336 256 336Z"]
  };
  var faFolderGrid = {
    prefix: 'fal',
    iconName: 'folder-grid',
    icon: [512, 512, [], "e132", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L259 128H448C466 128 480 142 480 160V416ZM152 240H104C91 240 80 251 80 264V312C80 325 91 336 104 336H152C165 336 176 325 176 312V264C176 251 165 240 152 240ZM144 304H112V272H144V304ZM280 240H232C219 240 208 251 208 264V312C208 325 219 336 232 336H280C293 336 304 325 304 312V264C304 251 293 240 280 240ZM272 304H240V272H272V304ZM408 240H360C347 240 336 251 336 264V312C336 325 347 336 360 336H408C421 336 432 325 432 312V264C432 251 421 240 408 240ZM400 304H368V272H400V304Z"]
  };
  var faFolderHeart = {
    prefix: 'fal',
    iconName: 'folder-heart',
    icon: [512, 512, [], "e133", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM256 220C213 177 180 194 166 205C138 228 137 269 161 294L246 380C252 385 260 385 266 380L351 294C375 269 374 228 346 205C332 194 299 177 256 220ZM328 272L256 344L184 272C174 261 172 242 186 230C200 218 217 226 225 234L256 265L287 234C295 226 312 218 326 230C340 242 338 261 328 272Z"]
  };
  var faFolderImage = {
    prefix: 'fal',
    iconName: 'folder-image',
    icon: [512, 512, [], "e134", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM315 204C303 188 276 188 265 204L221 265L214 256C202 242 177 242 165 256L102 337C95 346 94 358 100 368C105 378 115 384 126 384H386C397 384 407 378 412 369C412 369 412 369 412 369C418 359 417 347 411 338L315 204ZM130 352L188 276L209 302C213 307 226 313 234 301L289 223L381 352H130ZM128 216C141 216 152 205 152 192C152 179 141 168 128 168S104 179 104 192C104 205 115 216 128 216Z"]
  };
  var faFolderMagnifyingGlass = {
    prefix: 'fal',
    iconName: 'folder-magnifying-glass',
    icon: [512, 512, [], "e135", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L259 128H448C466 128 480 142 480 160V416ZM318 327C329 312 336 293 336 272C336 219 293 176 240 176S144 219 144 272S187 368 240 368C261 368 280 361 295 350L357 411C360 414 364 416 368 416S376 414 379 411C386 405 386 395 379 389L318 327ZM240 336C205 336 176 307 176 272S205 208 240 208S304 237 304 272S275 336 240 336Z"]
  };
  var faFolderMedical = {
    prefix: 'fal',
    iconName: 'folder-medical',
    icon: [512, 512, [], "e136", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM336 256H288V208C288 199 281 192 272 192H240C231 192 224 199 224 208V256H176C167 256 160 263 160 272V304C160 313 167 320 176 320H224V368C224 377 231 384 240 384H272C281 384 288 377 288 368V320H336C345 320 352 313 352 304V272C352 263 345 256 336 256Z"]
  };
  var faFolderMinus = {
    prefix: 'fal',
    iconName: 'folder-minus',
    icon: [512, 512, [], "f65d", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM320 272H192C183 272 176 279 176 288S183 304 192 304H320C329 304 336 297 336 288S329 272 320 272Z"]
  };
  var faFolderMusic = {
    prefix: 'fal',
    iconName: 'folder-music',
    icon: [512, 512, [], "e137", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM338 177C330 171 319 170 309 174L213 210C200 214 192 226 192 240V313C185 310 177 308 168 308C137 308 112 330 112 356C112 383 137 404 168 404S224 383 224 356V240L320 204V281C313 278 305 276 296 276C265 276 240 298 240 324C240 351 265 372 296 372S352 351 352 324V204C352 193 347 183 338 177ZM168 372C155 372 144 365 144 356S155 340 168 340S192 348 192 356S181 372 168 372ZM296 340C283 340 272 333 272 324S283 308 296 308S320 316 320 324S309 340 296 340Z"]
  };
  var faFolderOpen = {
    prefix: 'fal',
    iconName: 'folder-open',
    icon: [576, 512, [], "f07c", "M567 212C558 199 543 192 528 192H134C114 192 96 205 89 223L32 376V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160H512C512 125 483 96 448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H468C489 480 507 466 514 446L574 254C578 240 576 224 567 212ZM543 245L483 437C481 443 475 448 468 448H64C61 448 58 447 55 446C52 445 51 443 49 441C46 437 45 431 47 426L119 234C122 228 128 224 134 224H528C533 224 538 226 541 231C544 235 545 240 543 245Z"]
  };
  var faFolderPlus = {
    prefix: 'fal',
    iconName: 'folder-plus',
    icon: [512, 512, [], "f65e", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM320 272H272V224C272 215 265 208 256 208S240 215 240 224V272H192C183 272 176 279 176 288S183 304 192 304H240V352C240 361 247 368 256 368S272 361 272 352V304H320C329 304 336 297 336 288S329 272 320 272Z"]
  };
  var faFolderTree = {
    prefix: 'fal',
    iconName: 'folder-tree',
    icon: [576, 512, [], "f802", "M528 32H432L414 14C405 5 393 0 380 0H336C310 0 288 22 288 48V176C288 202 310 224 336 224H528C554 224 576 202 576 176V80C576 54 554 32 528 32ZM544 176C544 185 537 192 528 192H336C327 192 320 185 320 176V48C320 39 327 32 336 32H380C384 32 388 34 391 37L419 64H528C537 64 544 71 544 80V176ZM528 320H432L414 302C405 293 393 288 380 288H336C310 288 288 310 288 336V464C288 490 310 512 336 512H528C554 512 576 490 576 464V368C576 342 554 320 528 320ZM544 464C544 473 537 480 528 480H336C327 480 320 473 320 464V336C320 327 327 320 336 320H380C384 320 388 322 391 325L419 352H528C537 352 544 359 544 368V464ZM240 128C249 128 256 121 256 112S249 96 240 96H32V16C32 7 25 0 16 0S0 7 0 16V368C0 394 22 416 48 416H240C249 416 256 409 256 400S249 384 240 384H48C39 384 32 377 32 368V128H240Z"]
  };
  var faFolderUser = {
    prefix: 'fal',
    iconName: 'folder-user',
    icon: [512, 512, [], "e138", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM256 288C291 288 320 259 320 224S291 160 256 160S192 189 192 224S221 288 256 288ZM256 192C274 192 288 206 288 224S274 256 256 256S224 242 224 224S238 192 256 192ZM288 320H224C180 320 144 356 144 400C144 409 151 416 160 416S176 409 176 400C176 374 198 352 224 352H288C314 352 336 374 336 400C336 409 343 416 352 416S368 409 368 400C368 356 332 320 288 320Z"]
  };
  var faFolderXmark = {
    prefix: 'fal',
    iconName: 'folder-xmark',
    icon: [512, 512, [], "f65f", "M448 96H272L227 51C215 39 198 32 182 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V160C512 125 483 96 448 96ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H182C190 64 198 67 204 73L249 119L259 128H448C466 128 480 142 480 160V416ZM313 322L279 288L313 254C319 248 319 238 313 231S296 225 290 231L256 265L222 231C216 225 206 225 199 231S193 248 199 254L233 288L199 322C193 328 193 338 199 345S216 351 222 345L256 311L290 345C296 351 306 351 313 345S319 328 313 322Z"]
  };
  var faFolders = {
    prefix: 'fal',
    iconName: 'folders',
    icon: [640, 512, [], "f660", "M544 96H368L323 51C311 39 294 32 278 32H160C125 32 96 61 96 96V352C96 387 125 416 160 416H544C579 416 608 387 608 352V160C608 125 579 96 544 96ZM576 352C576 370 562 384 544 384H160C142 384 128 370 128 352V96C128 78 142 64 160 64H278C286 64 294 67 300 73L345 119L355 128H544C562 128 576 142 576 160V352ZM400 480H96C61 480 32 451 32 416V176C32 167 25 160 16 160S0 167 0 176V416C0 469 43 512 96 512H400C409 512 416 505 416 496S409 480 400 480Z"]
  };
  var faFont = {
    prefix: 'fal',
    iconName: 'font',
    icon: [448, 512, [], "f031", "M432 448H411L239 41C234 29 214 29 209 41L37 448H16C7 448 0 455 0 464S7 480 16 480H96C105 480 112 473 112 464S105 448 96 448H72L113 352H335L376 448H352C343 448 336 455 336 464S343 480 352 480H432C441 480 448 473 448 464S441 448 432 448ZM126 320L224 88L322 320H126Z"]
  };
  var faFontAwesomeLogoFull = {
    prefix: 'fal',
    iconName: 'font-awesome-logo-full',
    icon: [3992, 512, ["Font Awesome"], "f4e6", "M454.6 0H57.4C25.9 0 0 25.9 0 57.4v397.3C0 486.1 25.9 512 57.4 512h397.3c31.4 0 57.4-25.9 57.4-57.4V57.4C512 25.9 486.1 0 454.6 0zm-58.9 324.9c0 4.8-4.1 6.9-8.9 8.9-19.2 8.1-39.7 15.7-61.5 15.7-40.5 0-68.7-44.8-163.2 2.5v51.8c0 30.3-45.7 30.2-45.7 0v-250c-9-7-15-17.9-15-30.3 0-21 17.1-38.2 38.2-38.2 21 0 38.2 17.1 38.2 38.2 0 12.2-5.8 23.2-14.9 30.2v21c37.1-12 65.5-34.4 146.1-3.4 26.6 11.4 68.7-15.7 76.5-15.7 5.5 0 10.3 4.1 10.3 8.9v160.4zm432.9-174.2h-137v70.1H825c39.8 0 40.4 62.2 0 62.2H691.6v105.6c0 45.5-70.7 46.4-70.7 0V128.3c0-22 18-39.8 39.8-39.8h167.8c39.6 0 40.5 62.2.1 62.2zm191.1 23.4c-169.3 0-169.1 252.4 0 252.4 169.9 0 169.9-252.4 0-252.4zm0 196.1c-81.6 0-82.1-139.8 0-139.8 82.5 0 82.4 139.8 0 139.8zm372.4 53.4c-17.5 0-31.4-13.9-31.4-31.4v-117c0-62.4-72.6-52.5-99.1-16.4v133.4c0 41.5-63.3 41.8-63.3 0V208c0-40 63.1-41.6 63.1 0v3.4c43.3-51.6 162.4-60.4 162.4 39.3v141.5c.3 30.4-31.5 31.4-31.7 31.4zm179.7 2.9c-44.3 0-68.3-22.9-68.3-65.8V235.2H1488c-35.6 0-36.7-55.3 0-55.3h15.5v-37.3c0-41.3 63.8-42.1 63.8 0v37.5h24.9c35.4 0 35.7 55.3 0 55.3h-24.9v108.5c0 29.6 26.1 26.3 27.4 26.3 31.4 0 52.6 56.3-22.9 56.3zM1992 123c-19.5-50.2-95.5-50-114.5 0-107.3 275.7-99.5 252.7-99.5 262.8 0 42.8 58.3 51.2 72.1 14.4l13.5-35.9H2006l13 35.9c14.2 37.7 72.1 27.2 72.1-14.4 0-10.1 5.3 6.8-99.1-262.8zm-108.9 179.1l51.7-142.9 51.8 142.9h-103.5zm591.3-85.6l-53.7 176.3c-12.4 41.2-72 41-84 0l-42.3-135.9-42.3 135.9c-12.4 40.9-72 41.2-84.5 0l-54.2-176.3c-12.5-39.4 49.8-56.1 60.2-16.9L2213 342l45.3-139.5c10.9-32.7 59.6-34.7 71.2 0l45.3 139.5 39.3-142.4c10.3-38.3 72.6-23.8 60.3 16.9zm275.4 75.1c0-42.4-33.9-117.5-119.5-117.5-73.2 0-124.4 56.3-124.4 126 0 77.2 55.3 126.4 128.5 126.4 31.7 0 93-11.5 93-39.8 0-18.3-21.1-31.5-39.3-22.4-49.4 26.2-109 8.4-115.9-43.8h148.3c16.3 0 29.3-13.4 29.3-28.9zM2571 277.7c9.5-73.4 113.9-68.6 118.6 0H2571zm316.7 148.8c-31.4 0-81.6-10.5-96.6-31.9-12.4-17 2.5-39.8 21.8-39.8 16.3 0 36.8 22.9 77.7 22.9 27.4 0 40.4-11 40.4-25.8 0-39.8-142.9-7.4-142.9-102 0-40.4 35.3-75.7 98.6-75.7 31.4 0 74.1 9.9 87.6 29.4 10.8 14.8-1.4 36.2-20.9 36.2-15.1 0-26.7-17.3-66.2-17.3-22.9 0-37.8 10.5-37.8 23.8 0 35.9 142.4 6 142.4 103.1-.1 43.7-37.4 77.1-104.1 77.1zm266.8-252.4c-169.3 0-169.1 252.4 0 252.4 170.1 0 169.6-252.4 0-252.4zm0 196.1c-81.8 0-82-139.8 0-139.8 82.5 0 82.4 139.8 0 139.8zm476.9 22V268.7c0-53.8-61.4-45.8-85.7-10.5v134c0 41.3-63.8 42.1-63.8 0V268.7c0-52.1-59.5-47.4-85.7-10.1v133.6c0 41.5-63.3 41.8-63.3 0V208c0-40 63.1-41.6 63.1 0v3.4c9.9-14.4 41.8-37.3 78.6-37.3 35.3 0 57.7 16.4 66.7 43.8 13.9-21.8 45.8-43.8 82.6-43.8 44.3 0 70.7 23.4 70.7 72.7v145.3c.5 17.3-13.5 31.4-31.9 31.4 3.5.1-31.3 1.1-31.3-31.3zM3992 291.6c0-42.4-32.4-117.5-117.9-117.5-73.2 0-127.5 56.3-127.5 126 0 77.2 58.3 126.4 131.6 126.4 31.7 0 91.5-11.5 91.5-39.8 0-18.3-21.1-31.5-39.3-22.4-49.4 26.2-110.5 8.4-117.5-43.8h149.8c16.3 0 29.1-13.4 29.3-28.9zm-180.5-13.9c9.7-74.4 115.9-68.3 120.1 0h-120.1z"]
  };
  var faFontCase = {
    prefix: 'fal',
    iconName: 'font-case',
    icon: [640, 512, [], "f866", "M206 72C201 61 183 61 178 72L2 425C-2 433 1 442 9 446C17 450 26 447 30 439L82 336H302L354 439C357 445 362 448 368 448C370 448 373 447 375 446C383 442 386 433 382 425L206 72ZM98 304L192 115L286 304H98ZM624 159C615 159 608 167 608 175V193C588 173 559 159 528 159C466 159 416 210 416 272V336C416 398 466 448 528 448C559 448 588 435 608 414V432C608 441 615 448 624 448C633 448 640 441 640 432V175C640 167 633 159 624 159ZM608 336C608 380 572 416 528 416S448 380 448 336V272C448 227 484 192 528 192S608 227 608 272V336Z"]
  };
  var faFootballBall = {
    prefix: 'fal',
    iconName: 'football-ball',
    icon: [448, 512, [], "f44e", "M435 79C430 63 418 50 401 46C391 43 352 32 300 32C236 32 154 49 85 117C-26 228 -2 374 13 433C18 449 30 462 47 466C57 469 96 480 148 480C212 480 294 463 363 395C474 284 450 138 435 79ZM55 435C50 434 46 430 44 425C39 406 33 377 32 343L137 447C110 446 82 443 55 435ZM340 372C297 415 244 440 181 446L34 299C39 247 59 189 108 140C151 97 204 72 267 66L414 213C409 265 389 323 340 372ZM311 65C338 66 366 69 393 77C398 78 402 82 404 87C409 106 415 135 416 169L311 65ZM203 213C197 206 187 206 181 213S174 229 181 235L245 299C248 302 252 304 256 304S264 302 267 299C274 293 274 283 267 277L203 213ZM229 165C222 171 222 181 229 187L293 251C296 254 300 256 304 256S312 254 315 251C322 245 322 235 315 229L251 165C245 158 235 158 229 165ZM155 261C149 254 139 254 133 261S126 277 133 283L197 347C200 350 204 352 208 352S216 350 219 347C226 341 226 331 219 325L155 261Z"]
  };
  var faFootballHelmet = {
    prefix: 'fal',
    iconName: 'football-helmet',
    icon: [512, 512, [], "f44f", "M480 320H355L340 244L477 226C486 225 492 216 491 207C468 94 368 8 247 8C114 8 18 110 2 220C-8 292 21 359 61 410C64 414 69 416 74 416H128L205 461C214 466 225 468 234 468C281 468 313 419 295 376L286 352H329L338 401C348 449 386 485 434 491C478 496 477 496 480 496C502 496 512 476 512 464V352C512 334 497 320 480 320ZM273 320L263 294C245 249 308 248 308 248L322 320H273ZM284 219C243 224 218 267 233 306L266 390C271 402 268 416 258 426C246 439 229 437 220 432C131 388 137 389 127 384H74C40 338 26 282 34 224C47 131 131 40 247 40C344 40 429 105 455 197L284 219ZM480 464L438 459C412 456 390 438 378 416H480V464ZM480 384H368L361 352H480V384ZM175 312C162 312 151 323 151 336S162 360 175 360S199 349 199 336S189 312 175 312Z"]
  };
  var faFork = {
    prefix: 'fal',
    iconName: 'fork',
    icon: [512, 512, [], "f2e3", "M504 126C496 122 487 124 482 132L425 230C407 256 380 274 348 277C331 279 310 276 294 270L284 267L82 476C80 479 77 480 73 480C70 480 67 479 65 476L36 447C33 445 32 442 32 438C32 435 33 432 36 430L246 228L242 218C236 202 234 181 235 164C239 133 256 105 282 88L381 30C389 25 391 16 387 8C382 0 372 -2 365 2L266 60C231 83 208 120 204 161C202 179 204 200 209 219L14 406C5 415 0 426 0 438C0 450 5 461 13 470L42 499C50 507 62 512 74 512C86 512 97 507 105 498L293 303C312 308 333 310 352 309C393 304 429 282 452 247L510 148C514 140 512 131 504 126ZM309 155C312 158 316 160 320 160S328 158 331 155L427 59C434 53 434 43 427 37S411 30 405 37L309 133C302 139 302 149 309 155ZM357 203C360 206 364 208 368 208S376 206 379 203L475 107C482 101 482 91 475 85S459 78 453 85L357 181C350 187 350 197 357 203Z"]
  };
  var faForkKnife = {
    prefix: 'fal',
    iconName: 'fork-knife',
    icon: [576, 512, [], "f2e6", "M569 101C561 96 551 98 547 106L482 204C455 244 417 256 374 240L364 236L136 475C134 478 130 480 126 480C124 480 121 479 120 478L98 456C97 454 96 452 96 449C96 446 98 442 100 440L340 212L336 202C320 158 332 122 371 95L470 29C478 25 480 15 475 7C470 0 460 -2 453 3L353 68C304 101 287 149 303 203L78 417C70 425 65 436 64 447C63 459 67 470 76 479L97 500C105 508 115 512 126 512C127 512 128 512 128 512C140 511 151 506 159 497L373 273C426 289 475 271 508 222L573 123C578 116 576 106 569 101ZM144 304C150 304 157 300 159 294C162 286 158 276 149 273C70 245 45 179 37 143C25 89 37 43 47 33C48 32 50 32 51 32C54 32 57 34 60 36L235 204C242 210 252 209 258 203C264 197 264 187 257 180L82 14C75 6 64 1 54 0C43 -1 32 3 24 11C2 33 -7 95 6 150C15 193 45 269 138 303C140 304 142 304 144 304ZM391 308C385 302 375 303 369 309C363 315 363 325 369 332L473 430C481 438 482 449 477 455L455 477C452 479 449 480 446 480C440 480 434 477 429 472L331 376C325 370 315 370 308 377C302 383 302 393 309 399L406 494C417 505 431 512 445 512C446 512 446 512 446 512C458 512 469 508 478 499L499 478C518 459 516 428 495 408L391 308ZM376 156C379 160 383 162 387 162C391 162 395 160 398 158L506 61C512 56 513 45 507 39C501 32 491 32 484 38L377 134C370 140 370 150 376 156ZM422 203C425 206 429 207 433 207C437 207 441 205 445 202L541 94C547 87 546 77 540 71C533 66 523 66 517 73L421 180C415 187 415 197 422 203Z"]
  };
  var faForklift = {
    prefix: 'fal',
    iconName: 'forklift',
    icon: [640, 512, [], "f47a", "M416 263C416 256 414 249 411 243L311 28C303 11 286 0 268 0H176C150 0 128 22 128 48V160H48C22 160 0 182 0 208V416C0 469 43 512 96 512S192 469 192 416H256C256 469 299 512 352 512S448 469 448 416C448 388 436 362 416 345V263ZM160 48C160 39 167 32 176 32H268C274 32 279 36 282 41L382 256H263L181 174C175 168 168 164 160 162V48ZM96 480C61 480 32 451 32 416S61 352 96 352S160 381 160 416S131 480 96 480ZM262 384H186C173 347 138 320 96 320C71 320 49 330 32 345V208C32 199 39 192 48 192H147C151 192 155 194 158 197L249 288H384V326C374 322 363 320 352 320C310 320 275 347 262 384ZM352 480C317 480 288 451 288 416S317 352 352 352S416 381 416 416S387 480 352 480ZM624 416H512V16C512 7 505 0 496 0S480 7 480 16V432C480 441 487 448 496 448H624C633 448 640 441 640 432S633 416 624 416Z"]
  };
  var faForward = {
    prefix: 'fal',
    iconName: 'forward',
    icon: [512, 512, [], "f04e", "M182 221C189 227 199 226 204 219C210 212 209 202 202 196L50 71C44 66 37 64 31 64C14 64 0 77 0 96V416C0 435 14 448 31 448C37 448 44 446 50 441L202 316C209 310 210 300 204 293C199 286 189 285 182 291L32 416V96L182 221ZM500 231L306 71C300 66 293 64 287 64C276 64 256 72 256 96V416C256 440 276 448 287 448C293 448 300 446 306 441L500 281C508 275 512 266 512 256S508 237 500 231ZM288 416V96L479 256L288 416Z"]
  };
  var faForwardFast = {
    prefix: 'fal',
    iconName: 'forward-fast',
    icon: [512, 512, [], "f050", "M182 221C189 227 199 226 204 219C210 212 209 202 202 196L50 71C44 66 37 64 31 64C14 64 0 77 0 96V416C0 435 14 448 31 448C37 448 44 446 50 441L202 316C209 310 210 300 204 293C199 286 189 285 182 291L32 416V96L182 221ZM496 64C487 64 480 71 480 80V214L306 71C300 66 293 64 287 64C276 64 256 72 256 96V416C256 440 276 448 287 448C293 448 300 446 306 441L480 298V432C480 441 487 448 496 448S512 441 512 432V80C512 71 505 64 496 64ZM288 416V96L479 256L288 416Z"]
  };
  var faForwardStep = {
    prefix: 'fal',
    iconName: 'forward-step',
    icon: [320, 512, [], "f051", "M272 64C263 64 256 71 256 80V214L82 71C76 66 69 64 63 64C52 64 32 72 32 96V416C32 440 52 448 63 448C69 448 76 446 82 441L256 298V432C256 441 263 448 272 448S288 441 288 432V80C288 71 281 64 272 64ZM64 416V96L255 256L64 416Z"]
  };
  var faFrancSign = {
    prefix: 'fal',
    iconName: 'franc-sign',
    icon: [320, 512, [], "e139", "M320 48C320 57 313 64 304 64H96C87 64 80 71 80 80V192H272C281 192 288 199 288 208S281 224 272 224H80V320H208C217 320 224 327 224 336S217 352 208 352H80V462C80 471 73 478 64 478S48 471 48 462V352H16C7 352 0 345 0 336S7 320 16 320H48V80C48 54 70 32 96 32H304C313 32 320 39 320 48Z"]
  };
  var faFrenchFries = {
    prefix: 'fal',
    iconName: 'french-fries',
    icon: [384, 512, [], "f803", "M156 272C165 272 172 265 172 256L172 32L204 48V256C204 265 211 272 220 272S236 265 236 256V48C236 36 229 25 218 19L187 3C177 -2 165 -1 155 5C146 10 140 21 140 32V256C140 265 147 272 156 272ZM263 63L297 75L269 188C266 197 272 205 280 208C282 208 283 208 284 208C291 208 298 203 300 196L332 68C334 60 329 51 321 49L273 33C265 30 256 35 253 43C250 51 255 60 263 63ZM92 208C93 208 94 208 95 208C104 206 109 198 108 189L86 64L116 47C124 43 126 33 122 25C118 18 108 15 100 19L60 42C54 45 51 52 52 59L76 195C78 203 84 208 92 208ZM368 224H336C331 224 326 226 323 230L315 241C292 272 258 293 219 299C201 302 183 302 165 298C135 292 109 278 88 257L59 229C56 226 52 224 48 224H16C11 224 6 226 3 230C0 234 -1 239 0 244L64 500C66 507 73 512 80 512H304C311 512 318 507 320 500L384 244C385 239 384 234 381 230C378 226 373 224 368 224ZM291 480H93L37 256H41L65 280C91 305 123 322 159 330C181 334 203 334 225 331C271 323 313 298 341 260L344 256H347L291 480ZM371 80C363 79 354 84 353 93L336 173C335 181 340 190 349 192C350 192 351 192 352 192C359 192 366 187 367 179L384 99C385 91 380 82 371 80ZM32 192C34 192 35 192 36 192C44 190 50 181 48 173L32 93C30 84 22 79 13 80C4 82 -1 91 0 99L17 179C18 187 25 192 32 192Z"]
  };
  var faFrog = {
    prefix: 'fal',
    iconName: 'frog',
    icon: [576, 512, [], "f52e", "M560 448H519L409 324L541 253C562 241 576 218 576 194C576 167 560 143 535 132C505 119 476 110 447 104C443 64 409 32 368 32C329 32 297 60 290 97C129 104 0 237 0 400C0 444 36 480 80 480H368C377 480 384 473 384 464S377 448 368 448H80C54 448 32 426 32 400C32 255 146 136 290 129C298 165 330 192 368 192C404 192 434 168 444 136C470 141 495 150 523 162C536 167 544 180 544 194C544 206 537 218 526 224L376 306C372 308 369 312 368 317C367 322 369 327 372 331L500 475C503 478 507 480 512 480H560C569 480 576 473 576 464S569 448 560 448ZM368 128C383 128 398 129 412 131C405 148 388 160 368 160C342 160 320 138 320 112S342 64 368 64C390 64 408 79 414 99C399 97 384 96 368 96C359 96 352 103 352 112S359 128 368 128ZM281 366L247 388C240 393 238 403 243 410C246 415 251 418 256 418C259 418 262 417 265 415L299 392C317 380 330 361 334 339S334 295 322 277S291 246 269 242C247 237 225 242 207 254L176 275C168 280 166 290 171 297S186 306 194 301L225 281C236 273 250 270 263 273C276 276 288 283 295 295S306 320 303 333C300 346 293 358 281 366Z"]
  };
  var faFunction = {
    prefix: 'fal',
    iconName: 'function',
    icon: [640, 512, [], "f661", "M208 32H160C116 32 80 68 80 112V192H16C7 192 0 199 0 208C0 217 7 224 16 224H80V368C80 394 58 416 32 416H16C7 416 0 423 0 432C0 441 7 448 16 448H32C76 448 112 412 112 368V224H176C185 224 192 217 192 208C192 199 185 192 176 192H112V112C112 86 134 64 160 64H208C217 64 224 57 224 48C224 39 217 32 208 32ZM507 245C501 238 491 238 485 245L431 297L379 245C373 238 363 238 357 245C350 251 350 261 357 267L409 320L357 373C350 379 350 389 357 395C363 402 373 402 379 395L431 343L485 395C491 402 501 402 507 395C514 389 514 379 507 373L454 320L507 267C514 261 514 251 507 245ZM298 163C291 158 281 159 275 166C242 208 224 262 224 320S242 432 275 474C279 478 283 480 288 480C291 480 295 479 298 477C305 471 306 461 300 454C272 418 256 371 256 320S272 222 301 186C306 179 305 169 298 163ZM589 166C583 159 573 158 566 164C559 169 558 179 564 186C592 222 608 269 608 320S592 418 563 454C558 461 559 471 566 477C569 479 572 480 576 480C581 480 585 478 589 474C622 432 640 378 640 320S622 208 589 166Z"]
  };
  var faFunnelCircleDollar = {
    prefix: 'fal',
    iconName: 'funnel-circle-dollar',
    icon: [640, 512, [], "f662", "M448 192C360 192 288 264 288 352S360 512 448 512S608 440 608 352S536 192 448 192ZM448 480C377 480 320 423 320 352S377 224 448 224S576 281 576 352S519 480 448 480ZM475 343L430 330C425 328 421 323 421 317C421 310 427 304 433 304H461C466 304 470 305 474 308C477 310 481 310 484 307L496 296C499 292 499 287 495 284C486 277 475 273 464 272V256C464 252 460 248 456 248H440C436 248 432 252 432 256V272C408 273 389 293 389 317C389 337 402 355 421 361L466 374C471 376 475 381 475 387C475 394 469 400 463 400H435C430 400 426 399 422 396C419 394 415 394 412 397L400 408C397 412 397 417 401 420C410 427 421 431 432 432V448C432 452 436 456 440 456H456C460 456 464 452 464 448V432C488 431 507 411 507 387C507 367 494 349 475 343ZM224 364V263L217 254L33 32H479L480 32L352 186C371 175 391 167 412 163L505 52C522 31 507 0 479 0H33C5 0 -10 31 7 52L192 275V368C192 376 196 383 202 388L278 440C269 424 263 407 260 389L224 364Z"]
  };
  var faFutbolBall = {
    prefix: 'fal',
    iconName: 'futbol-ball',
    icon: [512, 512, [], "f1e3", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM272 147V112L337 64C366 77 393 96 413 120L388 196L355 207L272 147ZM333 231L304 321H208L179 231L256 175L333 231ZM256 84L213 52C227 50 241 48 256 48S285 50 299 52L256 84ZM240 112V147L157 207L124 196L99 120C119 96 146 77 175 64L240 112ZM93 203L49 234C52 204 62 177 76 153L93 203ZM114 227L147 238L179 335L158 363L78 364C62 337 52 306 49 273L114 227ZM155 395L171 446C145 434 121 417 102 395L155 395ZM184 382L205 353H307L328 382L303 458C288 462 272 464 256 464S224 462 209 458L184 382ZM354 363L333 335L365 238L398 227L463 273C460 306 450 337 434 364L354 363ZM410 395C391 417 367 434 341 446L357 395L410 395ZM419 203L436 153C450 177 460 204 463 234L419 203Z"]
  };
  var faG = {
    prefix: 'fal',
    iconName: 'g',
    icon: [448, 512, [], "e13a", "M224 480C167 480 109 458 66 414C-22 327 -22 185 66 98C153 10 295 10 382 97C388 103 389 112 384 118C378 126 367 127 360 120C285 45 163 45 88 120C13 195 13 317 88 392C163 467 285 467 360 392C390 362 410 326 416 291L416 288L225 288C217 288 209 283 208 275C207 265 214 256 224 256H432C441 256 448 263 448 272V272C448 292 445 312 438 330C426 361 407 390 382 414C339 458 281 480 224 480Z"]
  };
  var faGalaxy = {
    prefix: 'fal',
    iconName: 'galaxy',
    icon: [512, 512, [], "e008", "M256 192C221 192 192 221 192 256S221 320 256 320S320 291 320 256S291 192 256 192ZM256 288C238 288 224 274 224 256S238 224 256 224S288 238 288 256S274 288 256 288ZM506 267H506C489 194 428 135 355 120C341 117 328 116 314 116C307 116 301 116 294 117C305 97 323 81 344 71C374 58 384 0 314 0C298 0 282 2 267 6C194 23 135 84 120 157C116 178 115 198 117 218C97 207 81 189 71 167C56 133 5 140 1 178C-1 201 0 223 6 245C23 318 84 377 157 392C171 395 184 396 198 396C205 396 211 396 218 395C207 415 189 431 168 441C138 454 128 512 198 512C214 512 230 510 245 506C318 489 377 428 392 355C396 334 397 314 395 294C415 305 431 323 441 345C456 380 507 372 511 334C513 311 512 289 506 267ZM479 331C479 335 472 337 470 332C458 304 437 281 410 266C388 253 360 271 363 297C365 314 364 332 361 348C348 410 299 461 238 475C219 480 200 481 181 479C179 479 177 477 177 475C177 473 178 471 180 470C208 458 231 437 246 411C258 389 243 363 218 363C213 363 193 367 164 361C102 348 51 299 37 238C32 219 31 200 33 181C33 177 40 175 42 180C54 208 75 231 102 246C124 259 152 241 149 215C147 198 148 181 151 164C167 85 242 24 331 33C333 33 334 35 335 37C335 39 334 41 332 42C304 54 281 75 266 101C254 123 269 149 294 149C298 149 318 146 348 151C429 167 488 244 479 331Z"]
  };
  var faGameBoard = {
    prefix: 'fal',
    iconName: 'game-board',
    icon: [448, 512, [], "f867", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM368 176C377 176 384 169 384 160S377 144 368 144H336V112C336 103 329 96 320 96S304 103 304 112V144H240V112C240 103 233 96 224 96S208 103 208 112V144H144V112C144 103 137 96 128 96S112 103 112 112V144H80C71 144 64 151 64 160S71 176 80 176H112V240H80C71 240 64 247 64 256S71 272 80 272H112V336H80C71 336 64 343 64 352S71 368 80 368H112V400C112 409 119 416 128 416S144 409 144 400V368H208V400C208 409 215 416 224 416S240 409 240 400V368H304V400C304 409 311 416 320 416S336 409 336 400V368H368C377 368 384 361 384 352S377 336 368 336H336V272H368C377 272 384 265 384 256S377 240 368 240H336V176H368ZM208 336H144V272H208V336ZM208 240H144V176H208V240ZM304 336H240V272H304V336ZM304 240H240V176H304V240Z"]
  };
  var faGameBoardSimple = {
    prefix: 'fal',
    iconName: 'game-board-simple',
    icon: [448, 512, [], "f868", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H384C402 64 416 78 416 96V416ZM368 240H240V112C240 103 233 96 224 96H80C71 96 64 103 64 112V256C64 265 71 272 80 272H208V400C208 409 215 416 224 416H368C377 416 384 409 384 400V256C384 247 377 240 368 240ZM208 240H96V128H208V240ZM352 384H240V272H352V384Z"]
  };
  var faGameConsoleHandheld = {
    prefix: 'fal',
    iconName: 'game-console-handheld',
    icon: [384, 512, [], "f8bb", "M232 384C245 384 256 373 256 360S245 336 232 336S208 347 208 360S219 384 232 384ZM296 336C309 336 320 325 320 312S309 288 296 288S272 299 272 312S283 336 296 336ZM320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H256C327 512 384 455 384 384V64C384 29 355 0 320 0ZM352 384C352 437 309 480 256 480H64C46 480 32 466 32 448V224H352V384ZM352 192H32V64C32 46 46 32 64 32H320C338 32 352 46 352 64V192ZM80 352H96V368C96 377 103 384 112 384S128 377 128 368V352H144C153 352 160 345 160 336C160 327 153 320 144 320H128V304C128 295 121 288 112 288S96 295 96 304V320H80C71 320 64 327 64 336C64 345 71 352 80 352Z"]
  };
  var faGamepad = {
    prefix: 'fal',
    iconName: 'gamepad',
    icon: [640, 512, [], "f11b", "M448 64H192C86 64 0 150 0 256S86 448 192 448H448C554 448 640 362 640 256S554 64 448 64ZM448 416H192C104 416 32 344 32 256S104 96 192 96H448C536 96 608 168 608 256S536 416 448 416ZM432 280C419 280 408 291 408 304S419 328 432 328S456 317 456 304S445 280 432 280ZM496 184C483 184 472 195 472 208S483 232 496 232S520 221 520 208S509 184 496 184ZM256 240H208V192C208 183 201 176 192 176S176 183 176 192V240H128C119 240 112 247 112 256S119 272 128 272H176V320C176 329 183 336 192 336S208 329 208 320V272H256C265 272 272 265 272 256S265 240 256 240Z"]
  };
  var faGamepadModern = {
    prefix: 'fal',
    iconName: 'gamepad-modern',
    icon: [640, 512, [], "f8bc", "M639 368L605 157C601 131 589 109 571 91S531 60 505 54H505C479 48 446 42 413 38S346 32 320 32C294 32 261 34 227 38S161 48 135 53C109 60 86 73 69 91S39 131 35 157L1 368C-4 398 6 425 24 446C43 467 70 480 102 480C126 480 150 472 169 459C188 446 203 428 211 405L215 395L218 384H422L425 395L429 405C437 428 452 446 471 459C490 473 514 480 538 480C570 480 597 467 616 446C634 425 644 397 639 368ZM592 425C579 440 559 448 538 448C521 448 503 443 489 433C475 423 465 410 459 395L455 384L452 373C447 361 435 352 422 352H218C205 352 193 361 188 373L185 384L181 395C175 410 165 423 151 433C137 443 119 448 102 448C81 448 61 440 48 425C35 410 30 392 33 373L50 267L66 162C70 144 78 127 92 113C105 99 123 89 143 85C166 79 197 74 231 70C265 66 296 64 320 64C344 64 375 66 409 70C443 74 474 79 497 85C497 85 498 85 498 85C517 90 535 99 548 113C562 127 570 144 574 162L590 267L607 374C610 392 605 410 592 425ZM432 248C425 248 419 251 415 255C411 259 408 265 408 272S411 285 415 289C419 293 425 296 432 296C439 296 445 293 449 289C453 285 456 279 456 272S453 259 449 255C445 251 439 248 432 248ZM496 152C489 152 483 155 479 159C475 163 472 169 472 176S475 189 479 193C483 197 489 200 496 200C503 200 509 197 513 193C517 189 520 183 520 176S517 163 513 159C509 155 503 152 496 152ZM256 208H208V160C208 151 201 144 192 144S176 151 176 160V208H128C119 208 112 215 112 224S119 240 128 240H176V288C176 297 183 304 192 304S208 297 208 288V240H256C265 240 272 233 272 224S265 208 256 208Z"]
  };
  var faGarage = {
    prefix: 'fal',
    iconName: 'garage',
    icon: [640, 512, [], "e009", "M368 416H272C263 416 256 423 256 432S263 448 272 448H368C377 448 384 441 384 432S377 416 368 416ZM611 118L339 4C327 -1 313 -1 301 4L29 118C12 126 0 143 0 162V496C0 505 7 512 16 512C25 512 32 505 32 496V162C32 156 36 150 42 148L314 33C318 31 322 31 326 33L598 148C604 150 608 156 608 162V496C608 505 615 512 624 512C633 512 640 505 640 496V162C640 143 628 126 611 118ZM512 192H128C110 192 96 206 96 224V496C96 505 103 512 112 512C121 512 128 505 128 496V352H512V496C512 505 519 512 528 512C537 512 544 505 544 496V224C544 206 530 192 512 192ZM512 320H128V224H512V320Z"]
  };
  var faGarageCar = {
    prefix: 'fal',
    iconName: 'garage-car',
    icon: [640, 512, [], "e00a", "M224 400C215 400 208 407 208 416S215 432 224 432C233 432 240 425 240 416S233 400 224 400ZM447 355L421 290C413 269 393 256 371 256H262C238 256 217 272 210 295L192 355C173 362 160 379 160 400V432C160 453 173 470 192 477V496C192 505 199 512 208 512C217 512 224 505 224 496V480H416V496C416 505 423 512 432 512C441 512 448 505 448 496V477C467 470 480 453 480 432V400C480 379 466 361 447 355ZM241 304C244 295 252 288 262 288H371C380 288 388 294 392 302L412 352H226L241 304ZM448 432C448 441 441 448 432 448H208C199 448 192 441 192 432V400C192 391 199 384 208 384H432C441 384 448 391 448 400V432ZM611 118L339 4C327 -1 313 -1 301 4L29 118C12 126 0 143 0 162V496C0 505 7 512 16 512C25 512 32 505 32 496V162C32 156 36 150 42 148L314 33C318 31 322 31 326 33L598 148C604 150 608 156 608 162V496C608 505 615 512 624 512C633 512 640 505 640 496V162C640 143 628 126 611 118ZM512 192H128C110 192 96 206 96 224V496C96 505 103 512 112 512C121 512 128 505 128 496V224H512V496C512 505 519 512 528 512C537 512 544 505 544 496V224C544 206 530 192 512 192ZM416 400C407 400 400 407 400 416S407 432 416 432C425 432 432 425 432 416S425 400 416 400Z"]
  };
  var faGarageOpen = {
    prefix: 'fal',
    iconName: 'garage-open',
    icon: [640, 512, [], "e00b", "M611 118L339 4C327 -1 313 -1 301 4L29 118C12 126 0 143 0 162V496C0 505 7 512 16 512C25 512 32 505 32 496V162C32 156 36 150 42 148L314 33C318 31 322 31 326 33L598 148C604 150 608 156 608 162V496C608 505 615 512 624 512C633 512 640 505 640 496V162C640 143 628 126 611 118ZM416 400C407 400 400 407 400 416S407 432 416 432C425 432 432 425 432 416S425 400 416 400ZM224 400C215 400 208 407 208 416S215 432 224 432C233 432 240 425 240 416S233 400 224 400ZM512 192H128C110 192 96 206 96 224V496C96 505 103 512 112 512C121 512 128 505 128 496V288H512V496C512 505 519 512 528 512C537 512 544 505 544 496V224C544 206 530 192 512 192ZM512 256H128V224H512V256ZM447 355L433 320H399L412 352H226L236 320H202L192 355C173 362 160 379 160 400V432C160 453 173 470 192 477V496C192 505 199 512 208 512C217 512 224 505 224 496V480H416V496C416 505 423 512 432 512C441 512 448 505 448 496V477C467 470 480 453 480 432V400C480 379 466 361 447 355ZM448 432C448 441 441 448 432 448H208C199 448 192 441 192 432V400C192 391 199 384 208 384H432C441 384 448 391 448 400V432Z"]
  };
  var faGasPump = {
    prefix: 'fal',
    iconName: 'gas-pump',
    icon: [512, 512, [], "f52f", "M503 120L412 30C406 23 396 23 390 30C383 36 383 46 390 52L416 79V160C416 186 438 208 464 208H480V382C480 398 469 413 453 416C433 419 416 403 416 384V336C416 292 380 256 336 256H320V64C320 29 291 0 256 0H96C61 0 32 29 32 64V480H16C7 480 0 487 0 496S7 512 16 512H336C345 512 352 505 352 496S345 480 336 480H320V288H336C362 288 384 310 384 336V381C384 412 405 441 435 447C476 455 512 423 512 384V143C512 134 509 126 503 120ZM288 480H64V224H288V480ZM288 192H64V64C64 46 78 32 96 32H256C274 32 288 46 288 64V192ZM480 176H464C455 176 448 169 448 160V111L480 143V176Z"]
  };
  var faGasPumpSlash = {
    prefix: 'fal',
    iconName: 'gas-pump-slash',
    icon: [640, 512, [], "f5f4", "M400 480H384V388L352 363V480H128V186L96 161V480H80C71 480 64 487 64 496S71 512 80 512H400C409 512 416 505 416 496S409 480 400 480ZM480 79V160C480 186 502 208 528 208H544V351L576 377V143C576 134 573 126 567 120L476 30C470 23 460 23 454 30C447 36 447 46 454 52L480 79ZM512 111L544 143V176H528C519 176 512 169 512 160V111ZM160 32H320C338 32 352 46 352 64V200L384 225V64C384 29 355 0 320 0H160C144 0 130 6 119 16L145 36C150 34 154 32 160 32ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483Z"]
  };
  var faGauge = {
    prefix: 'fal',
    iconName: 'gauge',
    icon: [576, 512, [], "f625", "M120 320C120 333 109 344 96 344S72 333 72 320S83 296 96 296S120 307 120 320ZM288 152C301 152 312 141 312 128S301 104 288 104S264 115 264 128S275 152 288 152ZM152 160C139 160 128 171 128 184S139 208 152 208S176 197 176 184S165 160 152 160ZM434 171C441 177 442 187 436 194L339 314C347 325 352 338 352 352C352 387 323 416 288 416S224 387 224 352S253 288 288 288C298 288 306 290 314 294L411 174C417 167 427 166 434 171ZM320 352C320 334 306 320 288 320S256 334 256 352C256 370 270 384 288 384S320 370 320 352ZM480 296C467 296 456 307 456 320S467 344 480 344C493 344 504 333 504 320S493 296 480 296ZM576 320C576 373 562 422 537 465C531 474 521 480 510 480H66C55 480 45 474 39 465C14 422 0 373 0 320C0 161 129 32 288 32S576 161 576 320ZM544 320C544 179 429 64 288 64S32 179 32 320C32 365 44 409 67 448H510C532 410 544 365 544 320Z"]
  };
  var faGaugeLow = {
    prefix: 'fal',
    iconName: 'gauge-low',
    icon: [576, 512, [], "f627", "M120 320C120 333 109 344 96 344S72 333 72 320S83 296 96 296S120 307 120 320ZM288 152C301 152 312 141 312 128S301 104 288 104S264 115 264 128S275 152 288 152ZM352 352C352 387 323 416 288 416S224 387 224 352C224 338 229 325 237 314L140 194C134 187 135 177 142 171C149 166 159 167 164 174L261 294C270 290 278 288 288 288C323 288 352 317 352 352ZM320 352C320 334 306 320 288 320S256 334 256 352C256 370 270 384 288 384S320 370 320 352ZM576 320C576 373 562 422 537 465C531 474 521 480 510 480H66C55 480 45 474 39 465C14 422 0 373 0 320C0 161 129 32 288 32S576 161 576 320ZM544 320C544 179 429 64 288 64S32 179 32 320C32 365 44 409 67 448H510C532 410 544 365 544 320ZM424 160C411 160 400 171 400 184S411 208 424 208S448 197 448 184S437 160 424 160ZM480 296C467 296 456 307 456 320S467 344 480 344C493 344 504 333 504 320S493 296 480 296Z"]
  };
  var faGaugeMax = {
    prefix: 'fal',
    iconName: 'gauge-max',
    icon: [576, 512, [], "f626", "M120 320C120 333 109 344 96 344S72 333 72 320S83 296 96 296S120 307 120 320ZM288 152C301 152 312 141 312 128S301 104 288 104S264 115 264 128S275 152 288 152ZM424 208C437 208 448 197 448 184S437 160 424 160S400 171 400 184S411 208 424 208ZM496 317C497 326 491 334 483 336L351 358C349 390 321 416 288 416C253 416 224 387 224 352S253 288 288 288C314 288 337 304 346 326L477 304C486 303 494 309 496 317ZM320 352C320 334 306 320 288 320S256 334 256 352C256 370 270 384 288 384S320 370 320 352ZM152 160C139 160 128 171 128 184S139 208 152 208S176 197 176 184S165 160 152 160ZM576 320C576 373 562 422 537 465C531 474 521 480 510 480H66C55 480 45 474 39 465C14 422 0 373 0 320C0 161 129 32 288 32S576 161 576 320ZM544 320C544 179 429 64 288 64S32 179 32 320C32 365 44 409 67 448H510C532 410 544 365 544 320Z"]
  };
  var faGaugeMed = {
    prefix: 'fal',
    iconName: 'gauge-med',
    icon: [576, 512, [], "f624", "M304 290V128C304 119 297 112 288 112S272 119 272 128V290C245 297 224 322 224 352C224 387 253 416 288 416S352 387 352 352C352 322 331 297 304 290ZM288 384C270 384 256 370 256 352C256 334 270 320 288 320S320 334 320 352C320 370 306 384 288 384ZM120 320C120 333 109 344 96 344S72 333 72 320S83 296 96 296S120 307 120 320ZM176 184C176 197 165 208 152 208S128 197 128 184S139 160 152 160S176 171 176 184ZM448 184C448 197 437 208 424 208S400 197 400 184S411 160 424 160S448 171 448 184ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM510 448H67C44 409 32 365 32 320C32 179 147 64 288 64S544 179 544 320C544 365 532 410 510 448ZM504 320C504 333 493 344 480 344C467 344 456 333 456 320S467 296 480 296C493 296 504 307 504 320Z"]
  };
  var faGaugeMin = {
    prefix: 'fal',
    iconName: 'gauge-min',
    icon: [576, 512, [], "f628", "M128 184C128 171 139 160 152 160S176 171 176 184S165 208 152 208S128 197 128 184ZM288 152C301 152 312 141 312 128S301 104 288 104S264 115 264 128S275 152 288 152ZM576 320C576 373 562 422 537 465C531 474 521 480 510 480H66C55 480 45 474 39 465C14 422 0 373 0 320C0 161 129 32 288 32S576 161 576 320ZM544 320C544 179 429 64 288 64S32 179 32 320C32 365 44 409 67 448H510C532 410 544 365 544 320ZM352 352C352 387 323 416 288 416C255 416 227 390 225 358L93 336C85 334 79 326 80 317C82 309 90 303 99 304L230 326C239 304 262 288 288 288C323 288 352 317 352 352ZM320 352C320 334 306 320 288 320S256 334 256 352C256 370 270 384 288 384S320 370 320 352ZM480 296C467 296 456 307 456 320S467 344 480 344C493 344 504 333 504 320S493 296 480 296ZM424 160C411 160 400 171 400 184S411 208 424 208S448 197 448 184S437 160 424 160Z"]
  };
  var faGaugeSimple = {
    prefix: 'fal',
    iconName: 'gauge-simple',
    icon: [576, 512, [], "f62a", "M411 174L314 294C306 290 298 288 288 288C253 288 224 317 224 352S253 416 288 416S352 387 352 352C352 338 347 325 339 314L436 194C442 187 441 177 434 171C427 166 417 167 411 174ZM288 384C270 384 256 370 256 352S270 320 288 320S320 334 320 352S306 384 288 384ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM510 448H67C44 409 32 365 32 320C32 179 147 64 288 64S544 179 544 320C544 365 532 410 510 448Z"]
  };
  var faGaugeSimpleLow = {
    prefix: 'fal',
    iconName: 'gauge-simple-low',
    icon: [576, 512, [], "f62c", "M288 288C278 288 270 290 262 294L165 174C159 167 149 166 142 172C135 177 134 187 140 194L237 314C229 325 224 338 224 352C224 387 253 416 288 416S352 387 352 352S323 288 288 288ZM288 384C270 384 256 370 256 352S270 320 288 320S320 334 320 352S306 384 288 384ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM510 448H67C44 409 32 365 32 320C32 179 147 64 288 64S544 179 544 320C544 365 532 410 510 448Z"]
  };
  var faGaugeSimpleMax = {
    prefix: 'fal',
    iconName: 'gauge-simple-max',
    icon: [576, 512, [], "f62b", "M477 304L346 326C337 304 314 288 288 288C253 288 224 317 224 352S253 416 288 416C321 416 349 390 351 358L483 336C491 334 497 326 496 317C494 309 486 303 477 304ZM288 384C270 384 256 370 256 352S270 320 288 320S320 334 320 352S306 384 288 384ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM510 448H67C44 409 32 365 32 320C32 179 147 64 288 64S544 179 544 320C544 365 532 410 510 448Z"]
  };
  var faGaugeSimpleMed = {
    prefix: 'fal',
    iconName: 'gauge-simple-med',
    icon: [576, 512, [], "f629", "M304 290V128C304 119 297 112 288 112S272 119 272 128V290C245 297 224 322 224 352C224 387 253 416 288 416S352 387 352 352C352 322 331 297 304 290ZM288 384C270 384 256 370 256 352S270 320 288 320S320 334 320 352S306 384 288 384ZM288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM510 448H67C44 409 32 365 32 320C32 179 147 64 288 64S544 179 544 320C544 365 532 410 510 448Z"]
  };
  var faGaugeSimpleMin = {
    prefix: 'fal',
    iconName: 'gauge-simple-min',
    icon: [576, 512, [], "f62d", "M288 32C129 32 0 161 0 320C0 373 14 422 39 465C45 474 55 480 66 480H510C521 480 531 474 537 465C562 422 576 373 576 320C576 161 447 32 288 32ZM510 448H67C44 409 32 365 32 320C32 179 147 64 288 64S544 179 544 320C544 365 532 410 510 448ZM288 288C262 288 239 304 230 326L99 304C90 303 82 309 80 317C79 326 85 334 93 336L225 358C227 390 255 416 288 416C323 416 352 387 352 352S323 288 288 288ZM288 384C270 384 256 370 256 352S270 320 288 320S320 334 320 352S306 384 288 384Z"]
  };
  var faGavel = {
    prefix: 'fal',
    iconName: 'gavel',
    icon: [512, 512, [], "f0e3", "M507 197C501 191 491 191 485 197L472 210L302 40L315 27C321 21 321 11 315 5C309 -2 299 -2 292 5L149 149C142 155 142 165 149 171C152 174 156 176 160 176C164 176 168 174 171 171L184 159L257 232L182 310L172 301L172 301C155 284 128 284 111 301L13 399C-4 416 -4 444 13 460L51 499C60 507 71 512 82 512C94 512 105 507 113 499L211 401C228 384 228 356 211 340L204 333L280 255L353 328L341 341C335 347 335 357 341 364C344 367 348 368 352 368C356 368 360 367 363 364L507 220C514 213 514 203 507 197ZM189 378L90 477C86 481 78 481 74 477L35 438C31 433 31 426 35 422L134 323C136 321 139 320 142 320C145 320 148 321 150 323L189 362C193 367 193 374 189 378ZM206 136L280 63L449 232L376 306L206 136Z"]
  };
  var faGear = {
    prefix: 'fal',
    iconName: 'gear',
    icon: [512, 512, [], "f013", "M256 516C239 516 222 514 205 510C191 508 180 495 180 480V440C165 434 151 426 138 416L104 436C91 443 74 440 65 430C42 404 25 374 14 341C9 327 15 312 28 304L62 284C61 276 60 268 60 260S61 244 62 235L28 216C15 208 9 193 14 179C25 146 42 116 65 90C74 79 91 77 104 84L138 104C151 94 165 86 180 79V40C180 25 191 12 205 9C239 2 273 2 308 9C322 12 332 25 332 40V79C347 86 362 94 375 104L409 84C421 77 438 79 448 90C471 116 488 146 499 179C504 193 498 208 485 216L451 235C452 244 452 252 452 260S452 276 451 284L485 304C498 312 504 327 499 341C488 374 471 404 448 430C438 440 421 443 409 436L375 416C362 426 347 434 332 440V480C332 495 322 508 308 511C291 514 273 516 256 516ZM141 377C177 408 194 412 212 418V480C241 485 271 486 301 479L300 418C316 412 335 408 371 377L425 408C444 386 459 360 468 332L415 301C420 274 423 262 415 219L469 188C459 160 444 134 424 111L371 143C335 112 319 108 300 102V40C272 35 241 34 211 41L212 102C196 107 177 112 141 143L88 112C69 134 54 160 44 189L97 219C92 246 89 258 97 301L44 332C54 360 69 386 89 409L141 377ZM256 356C203 356 160 313 160 260S203 164 256 164S352 207 352 260S309 356 256 356ZM256 196C221 196 192 225 192 260S221 324 256 324S320 295 320 260S292 196 256 196Z"]
  };
  var faGears = {
    prefix: 'fal',
    iconName: 'gears',
    icon: [640, 512, [], "f085", "M307 199L290 189C291 185 291 180 291 176C291 172 291 167 290 163L307 153C318 147 322 134 319 123C312 102 300 82 285 65C277 56 263 54 253 60L236 70C229 65 222 61 214 57V37C214 25 205 15 194 12C171 7 149 7 126 12C115 15 106 25 106 37V57C98 61 91 65 84 70L67 60C57 54 43 56 35 65C20 82 8 102 1 123C-2 134 2 147 13 153L30 163C29 167 29 172 29 176C29 180 29 185 30 189L13 199C2 205 -3 217 1 229C8 250 20 270 35 287C42 296 57 298 67 292L84 282C91 287 98 292 106 295V315C106 327 115 337 126 340C138 342 149 343 160 343S182 342 194 340C205 337 214 327 214 315V295C222 292 229 287 236 282L253 292C263 298 278 296 285 287C300 270 312 250 319 229C323 217 318 205 307 199ZM257 157C258 164 259 170 259 176C259 182 258 189 257 195L255 206L287 224C281 238 274 250 265 262L233 243L225 251C215 259 204 265 193 269L182 273V310C167 312 153 312 138 310V273L127 269C116 265 105 259 95 251L87 243L55 262C46 250 39 238 33 224L65 206L63 195C62 189 61 182 61 176C61 170 62 164 63 157L65 146L33 128C39 114 46 102 55 90L87 109L96 101C105 93 116 87 127 83L138 79V42C153 40 167 40 182 42V79L193 83C204 87 215 93 224 101L233 109L265 90C274 102 281 114 287 128L255 146L257 157ZM628 318C625 307 615 298 603 298H583C579 290 575 283 570 276L580 259C582 255 584 250 584 246C584 239 580 232 575 227C558 212 538 200 517 193C506 190 493 194 487 205L477 222C468 221 460 221 451 222L441 205C435 194 423 189 411 193C390 200 370 212 353 227C348 232 344 239 344 246C344 250 346 255 348 259L358 276C353 283 348 290 345 298H325C313 298 303 307 300 318C298 330 297 341 297 352S298 374 300 386C303 397 313 406 325 406H345C348 414 353 421 358 428L348 445C346 449 344 454 344 458C344 466 348 472 353 477C370 492 390 504 411 511C423 514 435 510 441 499L451 482C460 483 468 483 477 482L487 499C491 507 500 512 509 512C512 512 514 512 517 511C538 504 558 492 575 477C580 472 584 466 584 458C584 454 582 449 580 445L570 428C575 421 579 414 583 406H603C615 406 625 397 628 386C630 374 631 363 631 352S630 330 628 318ZM598 374H561L557 385C553 396 547 407 539 416L531 425L550 457C538 466 526 473 512 479L494 447L483 449C471 452 458 452 445 449L434 447L416 479C402 473 390 466 378 457L397 425L389 416C381 407 375 396 371 385L367 374H330C329 366 329 359 329 352C329 345 329 338 330 330H367L371 319C375 308 381 297 389 287L397 279L378 247C390 238 402 231 416 225L434 257L445 255C457 252 470 252 482 255L494 257L512 225C526 231 538 238 550 247L531 279L539 288C547 297 553 308 557 319L561 330H598C599 337 599 345 599 352C599 359 599 366 598 374ZM160 120C129 120 104 145 104 176S129 232 160 232S216 207 216 176S191 120 160 120ZM160 200C147 200 136 189 136 176S147 152 160 152S184 163 184 176S173 200 160 200ZM464 296C433 296 408 321 408 352S433 408 464 408S520 383 520 352S495 296 464 296ZM464 376C451 376 440 365 440 352S451 328 464 328S488 339 488 352S477 376 464 376Z"]
  };
  var faGem = {
    prefix: 'fal',
    iconName: 'gem',
    icon: [512, 512, [], "f3a5", "M509 199L397 39C394 35 389 32 384 32H128C123 32 118 35 115 39L3 199C-1 205 -1 213 4 219L244 475C247 478 252 480 256 480S265 478 268 475L508 219C513 213 513 205 509 199ZM383 75L465 192H294L383 75ZM256 190L160 64H352L256 190ZM129 75L218 192H47L129 75ZM256 441L53 224H459L256 441Z"]
  };
  var faGenderless = {
    prefix: 'fal',
    iconName: 'genderless',
    icon: [384, 512, [], "f22d", "M192 112C271 112 336 177 336 256S271 400 192 400S48 335 48 256S113 112 192 112M192 80C95 80 16 159 16 256S95 432 192 432S368 353 368 256S289 80 192 80L192 80Z"]
  };
  var faGhost = {
    prefix: 'fal',
    iconName: 'ghost',
    icon: [384, 512, [], "f6e2", "M128 168C115 168 104 179 104 192S115 216 128 216S152 205 152 192S141 168 128 168ZM256 168C243 168 232 179 232 192S243 216 256 216S280 205 280 192S269 168 256 168ZM192 0C190 0 188 0 186 0C81 3 0 95 0 200V464C0 474 8 480 16 480C20 480 24 478 27 475L52 457C55 455 58 454 62 454C66 454 71 455 74 459L117 507C120 510 124 512 128 512S136 510 139 507L180 461C183 458 188 456 192 456S201 458 204 461L245 507C248 510 252 512 256 512S264 510 267 507L310 459C316 453 325 452 332 457L357 475C360 478 364 480 368 480C376 480 384 474 384 464V192C384 86 298 0 192 0ZM352 432L351 431C342 425 333 422 322 422C308 422 295 428 286 438L256 472L228 440C219 430 206 424 192 424S165 430 156 440L128 472L98 438C89 428 76 422 62 422C51 422 42 425 33 431L32 432V200C32 110 102 35 187 32L192 32C280 32 352 104 352 192V432Z"]
  };
  var faGift = {
    prefix: 'fal',
    iconName: 'gift',
    icon: [512, 512, [], "f06b", "M448 128H448C459 112 466 93 463 71C461 48 446 27 427 14C358 -33 291 49 256 106C221 49 154 -33 85 14C66 27 51 48 49 71C46 93 53 112 64 128H64C29 128 0 157 0 192V256C0 274 14 288 32 288V448C32 483 61 512 96 512H416C451 512 480 483 480 448V288C498 288 512 274 512 256V192C512 157 483 128 448 128ZM384 32C410 32 432 54 432 80S410 128 384 128H280C315 69 355 32 384 32ZM128 32C157 32 197 69 232 128H128C102 128 80 106 80 80S102 32 128 32ZM32 256V192C32 174 46 160 64 160H240V256H32ZM96 480C78 480 64 466 64 448V288H240V480H96ZM448 448C448 466 434 480 416 480H272V288H448V448ZM480 256H272V160H448C466 160 480 174 480 192V256Z"]
  };
  var faGiftCard = {
    prefix: 'fal',
    iconName: 'gift-card',
    icon: [576, 512, [], "f663", "M512 128H480C490 115 496 98 496 80C496 36 460 0 416 0C363 0 316 61 288 106C260 61 213 0 160 0C116 0 80 36 80 80C80 98 86 115 96 128H64C29 128 0 157 0 192V448C0 483 29 512 64 512H512C547 512 576 483 576 448V192C576 157 547 128 512 128ZM416 32C442 32 464 54 464 80S442 128 416 128H312C347 69 387 32 416 32ZM160 32C189 32 229 69 264 128H160C134 128 112 106 112 80S134 32 160 32ZM544 448C544 466 530 480 512 480H64C46 480 32 466 32 448V368H544V448ZM544 336H32V192C32 174 46 160 64 160H245L166 228C159 234 158 244 164 250C173 260 184 254 186 252L288 165L390 252C392 254 403 260 412 250C418 244 417 234 410 228L331 160H512C530 160 544 174 544 192V336Z"]
  };
  var faGifts = {
    prefix: 'fal',
    iconName: 'gifts',
    icon: [640, 512, [], "f79c", "M583 225C588 215 592 204 592 192C592 157 563 128 528 128C489 128 454 170 432 204C410 170 375 128 336 128C301 128 272 157 272 192C272 204 276 215 281 225C249 228 224 255 224 288V448C224 483 253 512 288 512H576C611 512 640 483 640 448V288C640 255 615 228 583 225ZM336 160C355 160 382 185 407 224H336C318 224 304 210 304 192S318 160 336 160ZM416 480H288C270 480 256 466 256 448V384H416V480ZM416 352H256V288C256 270 270 256 288 256H416V352ZM528 160C546 160 560 174 560 192S546 224 528 224H457C482 185 509 160 528 160ZM608 448C608 466 594 480 576 480H448V384H608V448ZM608 352H448V256H576C594 256 608 270 608 288V352ZM176 480H64C46 480 32 466 32 448V160C32 142 46 128 64 128H240C249 128 256 121 256 112S249 96 240 96H216L264 66C272 61 274 51 270 44C265 36 255 34 248 38L200 68L222 23C226 15 223 6 215 2C207 -2 198 1 194 9L160 76L126 9C122 1 113 -2 105 2C97 6 94 15 98 23L120 68L72 38C65 34 55 36 50 44C46 51 48 61 56 66L104 96H64C29 96 0 125 0 160V448C0 483 29 512 64 512H176C185 512 192 505 192 496S185 480 176 480Z"]
  };
  var faGingerbreadMan = {
    prefix: 'fal',
    iconName: 'gingerbread-man',
    icon: [448, 512, [], "f79d", "M192 79C183 79 176 86 176 95S183 111 192 111C201 111 208 104 208 95S201 79 192 79ZM224 336C224 336 224 336 224 336C224 336 224 336 224 336C215 336 208 343 208 352C208 360 215 368 224 368C224 368 224 368 224 368S224 368 224 368C233 368 240 360 240 352C240 343 233 336 224 336ZM224 271C224 271 224 271 224 271C224 271 224 271 224 271C215 271 208 279 208 287S215 304 224 304C224 304 224 304 224 304S224 304 224 304C233 304 240 296 240 287S233 271 224 271ZM224 207C224 207 224 207 224 207C224 207 224 207 224 207C215 207 208 215 208 223C208 232 215 239 224 239C224 239 224 239 224 239S224 239 224 239C233 239 240 232 240 223C240 215 233 207 224 207ZM431 227C424 185 386 154 343 154H331C336 141 338 128 338 114C338 84 326 55 305 33C262 -11 186 -11 143 33C122 55 110 84 110 114C110 128 112 141 117 154H105C62 154 24 185 17 227C13 252 20 278 36 298C51 315 72 326 94 328L63 366C48 385 40 410 43 435C45 459 56 479 74 493C108 521 164 516 193 480L224 443L255 481C271 501 295 512 321 512C340 512 359 505 374 493C392 479 403 459 405 435C408 410 400 385 385 366L354 328C376 326 397 315 412 298C428 278 435 252 431 227ZM387 277C387 277 387 277 387 277C377 290 362 297 346 297H323C316 297 310 301 308 307L308 307C305 313 306 320 310 325L360 386C370 399 375 415 373 432C372 447 365 460 354 468C333 486 297 482 279 460L246 420C241 413 233 409 224 409S207 413 202 420L169 460C151 482 116 486 94 468C83 460 76 447 75 432C73 415 78 399 88 386L138 325C141 321 142 315 141 310C141 309 141 308 140 308C138 301 132 297 125 297H102C86 297 71 290 61 277C51 265 46 248 49 232C53 206 77 186 105 186H143C149 186 154 183 157 177C160 172 159 166 156 161C147 147 142 131 142 114C142 92 151 71 166 55C197 24 251 24 282 55C297 71 306 92 306 114C306 131 301 147 292 161C289 166 288 172 291 177C294 183 299 186 305 186H343C371 186 395 206 399 232C402 248 397 265 387 277ZM256 79C247 79 240 86 240 95S247 111 256 111C265 111 272 104 272 95S265 79 256 79Z"]
  };
  var faGlass = {
    prefix: 'fal',
    iconName: 'glass',
    icon: [384, 512, [], "f804", "M375 10C369 4 361 0 352 0H32C23 0 15 4 9 10C3 17 0 25 0 34L32 482C33 499 47 512 64 512H320C337 512 351 499 352 482L384 34C384 25 381 17 375 10ZM352 32L347 96H37L32 32H352ZM320 480L64 480L39 128H345L320 480Z"]
  };
  var faGlassCitrus = {
    prefix: 'fal',
    iconName: 'glass-citrus',
    icon: [512, 512, [], "f869", "M511 128C507 90 488 56 458 32C428 8 390 -3 352 1C309 6 270 30 246 67C242 74 244 84 251 89C259 94 269 92 273 84C292 55 322 36 356 33C386 29 415 38 438 57C461 75 476 102 479 132C485 188 449 240 394 253C385 255 380 264 382 272C384 280 391 284 398 284C399 284 400 284 401 284C472 267 519 200 511 128ZM320 128H32C23 128 14 132 8 139C2 145 -1 154 0 163L32 483C34 499 48 512 64 512H288C305 512 318 499 320 483L352 163C353 154 350 145 344 139C338 132 329 128 320 128ZM288 480H64L45 288H307L288 480ZM310 256H42L32 160H320L310 256Z"]
  };
  var faGlassEmpty = {
    prefix: 'fal',
    iconName: 'glass-empty',
    icon: [384, 512, [], "e13b", "M375 10C369 4 361 0 352 0H32C23 0 15 4 9 10C3 17 0 25 0 34L32 482C33 499 47 512 64 512H320C337 512 351 499 352 482L384 34C384 25 381 17 375 10ZM320 480L64 480L32 32H352L320 480Z"]
  };
  var faGlassHalf = {
    prefix: 'fal',
    iconName: 'glass-half',
    icon: [384, 512, [], "e13c", "M375 10C369 4 361 0 352 0H32C23 0 15 4 9 10C3 17 0 25 0 34L32 482C33 499 47 512 64 512H320C337 512 351 499 352 482L384 34C384 25 381 17 375 10ZM352 32L338 224H46L32 32H352ZM64 480L48 256H336L320 480L64 480Z"]
  };
  var faGlasses = {
    prefix: 'fal',
    iconName: 'glasses',
    icon: [576, 512, [], "f530", "M563 233L533 112C519 57 466 23 413 34C404 36 399 44 400 53C402 62 411 67 419 65C456 58 492 82 502 120L532 241C535 251 536 261 538 272C516 264 485 257 449 257C411 257 368 265 324 288H252C208 265 165 257 127 257C91 257 60 264 38 272C40 261 41 251 44 241L75 120C84 82 120 58 157 65C165 67 174 62 176 53C177 44 172 36 163 34C110 23 57 57 43 112L13 233C4 266 0 301 0 336V369C0 430 50 480 112 480H148C207 480 255 435 260 378L264 320H312L316 378C321 435 369 480 428 480H464C526 480 576 430 576 369V336C576 301 572 266 563 233ZM228 375C225 416 190 448 148 448H112C68 448 32 413 32 369V336C32 326 33 317 34 307C53 299 86 289 127 289C164 289 199 297 232 314L228 375ZM544 369C544 413 508 448 464 448H428C386 448 351 416 348 375L343 314C377 297 412 289 449 289C490 289 523 299 542 307C543 317 544 326 544 336V369Z"]
  };
  var faGlassesRound = {
    prefix: 'fal',
    iconName: 'glasses-round',
    icon: [576, 512, [], "f5f5", "M576 336C576 301 572 266 563 233L533 112C519 57 466 23 413 34C404 36 399 44 400 53C402 62 411 67 419 65C456 58 492 82 502 120L532 241C533 242 533 244 533 245C509 222 476 208 440 208C385 208 338 241 316 288H260C238 241 191 208 136 208C100 208 67 222 43 245C43 244 43 242 44 241L75 120C84 82 120 58 157 65C165 67 174 62 176 53C178 44 172 36 163 34C110 23 57 57 43 112L13 233C4 266 0 301 0 336C0 337 0 338 1 339C0 340 0 342 0 344C0 419 61 480 136 480S272 419 272 344C272 336 271 328 270 320H306C305 328 304 336 304 344C304 419 365 480 440 480S576 419 576 344C576 342 576 340 575 339C576 338 576 337 576 336ZM136 448C79 448 32 401 32 344S79 240 136 240S240 287 240 344S193 448 136 448ZM440 448C383 448 336 401 336 344S383 240 440 240S544 287 544 344S497 448 440 448Z"]
  };
  var faGlobe = {
    prefix: 'fal',
    iconName: 'globe',
    icon: [512, 512, [], "f0ac", "M256 16C123 16 16 123 16 256S123 496 256 496S496 389 496 256S389 16 256 16ZM464 256C464 278 460 300 454 320H379C382 300 384 278 384 256S382 212 379 192H454C460 212 464 234 464 256ZM256 464C224 464 189 421 172 352H341C323 421 288 464 256 464ZM165 320C162 300 160 279 160 256S162 212 165 192H347C350 212 352 233 352 256S350 300 347 320H165ZM48 256C48 234 52 212 58 192H133C130 212 128 234 128 256S130 300 133 320H58C52 300 48 278 48 256ZM256 48C288 48 323 91 340 160H172C189 91 224 48 256 48ZM440 160H373C364 121 350 87 331 62C378 81 417 116 440 160ZM181 62C162 87 148 121 139 160H72C95 116 134 81 181 62ZM72 352H139C148 391 162 425 181 450C134 431 95 396 72 352ZM331 450C350 425 364 391 373 352H440C417 396 378 431 331 450Z"]
  };
  var faGlobeSnow = {
    prefix: 'fal',
    iconName: 'globe-snow',
    icon: [448, 512, [], "f7a3", "M70 365C77 359 78 349 73 342C46 308 32 267 32 224C32 118 118 32 224 32S416 118 416 224C416 267 402 308 375 342C370 349 371 359 378 365C381 367 384 368 388 368C393 368 397 366 401 362C432 322 448 274 448 224C448 101 347 0 224 0S0 101 0 224C0 274 16 322 47 362C53 369 63 370 70 365ZM56 240C56 253 67 264 80 264S104 253 104 240C104 227 93 216 80 216S56 227 56 240ZM336 152C323 152 312 163 312 176C312 189 323 200 336 200S360 189 360 176C360 163 349 152 336 152ZM216 80C216 93 227 104 240 104S264 93 264 80C264 67 253 56 240 56S216 67 216 80ZM373 391C370 387 365 384 360 384H240V295L277 331C280 334 284 336 288 336S296 334 299 331C306 325 306 315 299 309L240 249V215L277 251C280 254 284 256 288 256S296 254 299 251C306 245 306 235 299 229L235 165C229 158 219 158 213 165L149 229C142 235 142 245 149 251S165 258 171 251L208 215V249L149 309C142 315 142 325 149 331S165 338 171 331L208 295V384H88C83 384 78 387 75 391L11 487C7 492 7 498 10 504C13 509 18 512 24 512H424C430 512 435 509 438 504C441 498 441 492 437 487L373 391ZM54 480L97 416H351L394 480H54Z"]
  };
  var faGlobeStand = {
    prefix: 'fal',
    iconName: 'globe-stand',
    icon: [448, 512, [], "f5f6", "M368 475H240V425C290 418 339 396 378 357C465 270 471 132 396 38L411 23C418 16 418 6 411 0C405 -6 395 -6 389 0L318 71C289 44 251 27 208 27C120 27 48 99 48 187C48 230 65 268 92 297L5 384C-2 390 -2 400 5 407C8 410 12 411 16 411S24 410 27 407L59 375C102 410 155 427 208 427V475H80C71 475 64 482 64 491S71 507 80 507H368C377 507 384 500 384 491S377 475 368 475ZM80 187C80 117 137 59 208 59S336 117 336 187S279 315 208 315S80 258 80 187ZM82 352L116 318C142 336 174 347 208 347C296 347 368 276 368 187C368 153 357 121 339 95L373 61C436 142 430 260 355 334C281 409 163 415 82 352Z"]
  };
  var faGolfBallTee = {
    prefix: 'fal',
    iconName: 'golf-ball-tee',
    icon: [384, 512, [], "f450", "M288 336H96C89 336 83 340 81 347C79 353 81 360 86 364L176 439V496C176 505 183 512 192 512S208 505 208 496V439L298 364C303 360 305 353 303 347C301 340 295 336 288 336ZM192 411L140 368H244L192 411ZM192 304C218 304 240 282 240 256C240 247 233 240 224 240S208 247 208 256C208 265 201 272 192 272C183 272 176 279 176 288S183 304 192 304ZM192 0C91 0 8 83 8 184C8 225 22 265 48 298C54 305 64 306 71 301C78 295 79 285 74 278C52 250 40 218 40 184C40 100 108 32 192 32S344 100 344 184C344 218 332 250 310 278C305 285 306 295 313 301C316 303 319 304 323 304C328 304 332 302 336 298C362 265 376 225 376 184C376 83 293 0 192 0ZM192 208C218 208 240 186 240 160C240 151 233 144 224 144S208 151 208 160C208 169 201 176 192 176C183 176 176 183 176 192S183 208 192 208ZM304 176C295 176 288 183 288 192C288 201 281 208 272 208C263 208 256 215 256 224S263 240 272 240C298 240 320 218 320 192C320 183 313 176 304 176Z"]
  };
  var faGolfClub = {
    prefix: 'fal',
    iconName: 'golf-club',
    icon: [512, 512, [], "f451", "M503 2C495 -2 486 1 482 9L295 382L58 329C44 326 29 329 18 338C7 348 0 361 0 376V464C0 490 22 512 48 512H256C262 512 268 509 270 503L318 407C318 407 318 407 318 407L510 23C514 15 511 6 503 2ZM246 480H48C39 480 32 473 32 464H80C89 464 96 457 96 448S89 432 80 432H32V416H80C89 416 96 409 96 400S89 384 80 384H32V376C32 371 34 366 38 363C41 361 44 360 48 360C49 360 50 360 51 360L281 411L246 480Z"]
  };
  var faGopuram = {
    prefix: 'fal',
    iconName: 'gopuram',
    icon: [512, 512, [], "f664", "M277 416H235C211 416 192 435 192 459V496C192 505 199 512 208 512S224 505 224 496V459C224 453 229 448 235 448H277C283 448 288 453 288 459V496C288 505 295 512 304 512S320 505 320 496V459C320 435 301 416 277 416ZM496 352H480V240C480 231 473 224 464 224H448V144C448 135 441 128 432 128H416V16C416 7 409 0 400 0S384 7 384 16V32H320V16C320 7 313 0 304 0S288 7 288 16V32H224V16C224 7 217 0 208 0S192 7 192 16V32H128V16C128 7 121 0 112 0S96 7 96 16V128H80C71 128 64 135 64 144V224H48C39 224 32 231 32 240V352H16C7 352 0 359 0 368V496C0 505 7 512 16 512S32 505 32 496V384H96V496C96 505 103 512 112 512S128 505 128 496V384H384V496C384 505 391 512 400 512S416 505 416 496V384H480V496C480 505 487 512 496 512S512 505 512 496V368C512 359 505 352 496 352ZM128 64H384V128H128V64ZM256 192C247 192 240 199 240 208V224H192V160H320V224H272V208C272 199 265 192 256 192ZM128 352H64V256H128V352ZM160 224H96V160H160V224ZM272 352H240V325C240 322 242 320 245 320H267C270 320 272 322 272 325V352ZM352 352H304V325C304 305 287 288 267 288H245C225 288 208 305 208 325V352H160V256H352V352ZM352 224V160H416V224H352ZM448 352H384V256H448V352Z"]
  };
  var faGraduationCap = {
    prefix: 'fal',
    iconName: 'graduation-cap',
    icon: [640, 512, [], "f19d", "M618 137L331 34C324 31 316 31 308 34L22 137C9 142 0 154 0 168S9 194 22 199L48 209V322L16 460C15 465 16 470 19 474S27 480 32 480H96C101 480 105 478 108 474C112 470 113 465 112 460L80 320V220L309 302C312 303 316 304 320 304C324 304 328 303 332 302L618 199C631 194 640 182 640 168S631 142 618 137ZM52 448L64 395L76 448H52ZM319 272L129 204L325 143C333 141 338 132 335 123C333 115 324 110 315 113L79 186L32 168L321 64L608 168L319 272ZM482 288C474 289 467 297 468 306L480 393C481 402 475 410 465 415C421 435 371 447 322 448H319C269 447 219 435 175 415C165 410 159 402 160 393L172 306C173 297 166 289 158 288C149 287 141 293 140 302L128 389C125 412 138 433 162 444C209 466 263 479 318 480H322C377 479 431 466 478 444C502 433 515 412 512 389L500 302C499 293 491 287 482 288Z"]
  };
  var faGramophone = {
    prefix: 'fal',
    iconName: 'gramophone',
    icon: [384, 512, [], "f8bd", "M368 480H352V416C352 398 338 384 320 384H64C46 384 32 398 32 416V480H16C7 480 0 487 0 496C0 505 7 512 16 512H368C377 512 384 505 384 496C384 487 377 480 368 480ZM320 480H64V416H320V480ZM46 314C57 322 71 322 82 314C142 274 202 248 260 239C262 239 336 229 336 280C336 302 318 320 296 320H176C167 320 160 327 160 336C160 345 167 352 176 352H290C327 352 361 327 367 291C375 245 357 235 278 172C232 135 193 83 162 18C156 7 145 0 133 0C132 0 131 0 130 0C116 1 105 11 102 24L33 280C30 293 34 306 46 314ZM133 32C166 102 208 157 258 197L270 206C265 206 260 207 255 208C192 217 128 244 64 288L133 32Z"]
  };
  var faGreaterThan = {
    prefix: 'fal',
    iconName: 'greater-than',
    icon: [640, 512, [], "f531", "M129 89C132 83 138 80 144 80C146 80 148 80 151 81L503 241C508 244 512 250 512 256C512 262 508 268 503 271L151 431C143 434 133 431 129 423C126 415 129 405 137 401L457 256L137 111C129 107 126 97 129 89Z"]
  };
  var faGreaterThanEqual = {
    prefix: 'fal',
    iconName: 'greater-than-equal',
    icon: [640, 512, [], "f532", "M512 192C512 186 508 180 502 177L150 33C142 30 133 34 129 42C126 50 130 59 138 63L454 192L138 321C130 325 126 334 129 342C132 348 138 352 144 352C146 352 148 352 150 351L502 207C508 204 512 199 512 192ZM96 464C96 473 103 480 112 480H528C537 480 544 473 544 464C544 455 537 448 528 448H112C103 448 96 455 96 464Z"]
  };
  var faGrid = {
    prefix: 'fal',
    iconName: 'grid',
    icon: [512, 512, [], "e13d", "M96 384H32C14 384 0 398 0 416V480C0 498 14 512 32 512H96C114 512 128 498 128 480V416C128 398 114 384 96 384ZM96 480H32V416H96V480ZM288 384H224C206 384 192 398 192 416V480C192 498 206 512 224 512H288C306 512 320 498 320 480V416C320 398 306 384 288 384ZM288 480H224V416H288V480ZM480 384H416C398 384 384 398 384 416V480C384 498 398 512 416 512H480C498 512 512 498 512 480V416C512 398 498 384 480 384ZM480 480H416V416H480V480ZM96 192H32C14 192 0 206 0 224V288C0 306 14 320 32 320H96C114 320 128 306 128 288V224C128 206 114 192 96 192ZM96 288H32V224H96V288ZM288 192H224C206 192 192 206 192 224V288C192 306 206 320 224 320H288C306 320 320 306 320 288V224C320 206 306 192 288 192ZM288 288H224V224H288V288ZM480 192H416C398 192 384 206 384 224V288C384 306 398 320 416 320H480C498 320 512 306 512 288V224C512 206 498 192 480 192ZM480 288H416V224H480V288ZM96 0H32C14 0 0 14 0 32V96C0 114 14 128 32 128H96C114 128 128 114 128 96V32C128 14 114 0 96 0ZM96 96H32V32H96V96ZM288 0H224C206 0 192 14 192 32V96C192 114 206 128 224 128H288C306 128 320 114 320 96V32C320 14 306 0 288 0ZM288 96H224V32H288V96ZM480 0H416C398 0 384 14 384 32V96C384 114 398 128 416 128H480C498 128 512 114 512 96V32C512 14 498 0 480 0ZM480 96H416V32H480V96Z"]
  };
  var faGrid2 = {
    prefix: 'fal',
    iconName: 'grid-2',
    icon: [512, 512, [], "e13e", "M160 0H64C29 0 0 29 0 64V160C0 195 29 224 64 224H160C195 224 224 195 224 160V64C224 29 195 0 160 0ZM192 160C192 178 178 192 160 192H64C46 192 32 178 32 160V64C32 46 46 32 64 32H160C178 32 192 46 192 64V160ZM160 288H64C29 288 0 317 0 352V448C0 483 29 512 64 512H160C195 512 224 483 224 448V352C224 317 195 288 160 288ZM192 448C192 466 178 480 160 480H64C46 480 32 466 32 448V352C32 334 46 320 64 320H160C178 320 192 334 192 352V448ZM448 0H352C317 0 288 29 288 64V160C288 195 317 224 352 224H448C483 224 512 195 512 160V64C512 29 483 0 448 0ZM480 160C480 178 466 192 448 192H352C334 192 320 178 320 160V64C320 46 334 32 352 32H448C466 32 480 46 480 64V160ZM448 288H352C317 288 288 317 288 352V448C288 483 317 512 352 512H448C483 512 512 483 512 448V352C512 317 483 288 448 288ZM480 448C480 466 466 480 448 480H352C334 480 320 466 320 448V352C320 334 334 320 352 320H448C466 320 480 334 480 352V448Z"]
  };
  var faGrid4 = {
    prefix: 'fal',
    iconName: 'grid-4',
    icon: [512, 512, [], "e13f", "M64 0H32C14 0 0 14 0 32V64C0 82 14 96 32 96H64C82 96 96 82 96 64V32C96 14 82 0 64 0ZM64 64H32V32H64V64ZM480 0H448C430 0 416 14 416 32V64C416 82 430 96 448 96H480C498 96 512 82 512 64V32C512 14 498 0 480 0ZM480 64H448V32H480V64ZM341 0H309C292 0 277 14 277 32V64C277 82 292 96 309 96H341C359 96 373 82 373 64V32C373 14 359 0 341 0ZM341 64H309V32H341V64ZM203 0H171C153 0 139 14 139 32V64C139 82 153 96 171 96H203C220 96 235 82 235 64V32C235 14 220 0 203 0ZM203 64H171V32H203V64ZM64 416H32C14 416 0 430 0 448V480C0 498 14 512 32 512H64C82 512 96 498 96 480V448C96 430 82 416 64 416ZM64 480H32V448H64V480ZM480 416H448C430 416 416 430 416 448V480C416 498 430 512 448 512H480C498 512 512 498 512 480V448C512 430 498 416 480 416ZM480 480H448V448H480V480ZM341 416H309C292 416 277 430 277 448V480C277 498 292 512 309 512H341C359 512 373 498 373 480V448C373 430 359 416 341 416ZM341 480H309V448H341V480ZM203 416H171C153 416 139 430 139 448V480C139 498 153 512 171 512H203C220 512 235 498 235 480V448C235 430 220 416 203 416ZM203 480H171V448H203V480ZM64 277H32C14 277 0 292 0 309V341C0 359 14 373 32 373H64C82 373 96 359 96 341V309C96 292 82 277 64 277ZM64 341H32V309H64V341ZM480 277H448C430 277 416 292 416 309V341C416 359 430 373 448 373H480C498 373 512 359 512 341V309C512 292 498 277 480 277ZM480 341H448V309H480V341ZM341 277H309C292 277 277 292 277 309V341C277 359 292 373 309 373H341C359 373 373 359 373 341V309C373 292 359 277 341 277ZM341 341H309V309H341V341ZM203 277H171C153 277 139 292 139 309V341C139 359 153 373 171 373H203C220 373 235 359 235 341V309C235 292 220 277 203 277ZM203 341H171V309H203V341ZM64 139H32C14 139 0 153 0 171V203C0 220 14 235 32 235H64C82 235 96 220 96 203V171C96 153 82 139 64 139ZM64 203H32V171H64V203ZM480 139H448C430 139 416 153 416 171V203C416 220 430 235 448 235H480C498 235 512 220 512 203V171C512 153 498 139 480 139ZM480 203H448V171H480V203ZM341 139H309C292 139 277 153 277 171V203C277 220 292 235 309 235H341C359 235 373 220 373 203V171C373 153 359 139 341 139ZM341 203H309V171H341V203ZM203 139H171C153 139 139 153 139 171V203C139 220 153 235 171 235H203C220 235 235 220 235 203V171C235 153 220 139 203 139ZM203 203H171V171H203V203Z"]
  };
  var faGrid5 = {
    prefix: 'fal',
    iconName: 'grid-5',
    icon: [512, 512, [], "e140", "M160 0H128C119 0 112 7 112 16V48C112 57 119 64 128 64H160C169 64 176 57 176 48V16C176 7 169 0 160 0ZM272 0H240C231 0 224 7 224 16V48C224 57 231 64 240 64H272C281 64 288 57 288 48V16C288 7 281 0 272 0ZM384 0H352C343 0 336 7 336 16V48C336 57 343 64 352 64H384C393 64 400 57 400 48V16C400 7 393 0 384 0ZM496 0H464C455 0 448 7 448 16V48C448 57 455 64 464 64H496C505 64 512 57 512 48V16C512 7 505 0 496 0ZM48 0H16C7 0 0 7 0 16V48C0 57 7 64 16 64H48C57 64 64 57 64 48V16C64 7 57 0 48 0ZM496 448H464C455 448 448 455 448 464V496C448 505 455 512 464 512H496C505 512 512 505 512 496V464C512 455 505 448 496 448ZM384 448H352C343 448 336 455 336 464V496C336 505 343 512 352 512H384C393 512 400 505 400 496V464C400 455 393 448 384 448ZM272 448H240C231 448 224 455 224 464V496C224 505 231 512 240 512H272C281 512 288 505 288 496V464C288 455 281 448 272 448ZM48 448H16C7 448 0 455 0 464V496C0 505 7 512 16 512H48C57 512 64 505 64 496V464C64 455 57 448 48 448ZM160 448H128C119 448 112 455 112 464V496C112 505 119 512 128 512H160C169 512 176 505 176 496V464C176 455 169 448 160 448ZM48 336H16C7 336 0 343 0 352V384C0 393 7 400 16 400H48C57 400 64 393 64 384V352C64 343 57 336 48 336ZM272 336H240C231 336 224 343 224 352V384C224 393 231 400 240 400H272C281 400 288 393 288 384V352C288 343 281 336 272 336ZM160 336H128C119 336 112 343 112 352V384C112 393 119 400 128 400H160C169 400 176 393 176 384V352C176 343 169 336 160 336ZM384 336H352C343 336 336 343 336 352V384C336 393 343 400 352 400H384C393 400 400 393 400 384V352C400 343 393 336 384 336ZM496 336H464C455 336 448 343 448 352V384C448 393 455 400 464 400H496C505 400 512 393 512 384V352C512 343 505 336 496 336ZM272 224H240C231 224 224 231 224 240V272C224 281 231 288 240 288H272C281 288 288 281 288 272V240C288 231 281 224 272 224ZM384 224H352C343 224 336 231 336 240V272C336 281 343 288 352 288H384C393 288 400 281 400 272V240C400 231 393 224 384 224ZM496 224H464C455 224 448 231 448 240V272C448 281 455 288 464 288H496C505 288 512 281 512 272V240C512 231 505 224 496 224ZM48 224H16C7 224 0 231 0 240V272C0 281 7 288 16 288H48C57 288 64 281 64 272V240C64 231 57 224 48 224ZM160 224H128C119 224 112 231 112 240V272C112 281 119 288 128 288H160C169 288 176 281 176 272V240C176 231 169 224 160 224ZM496 112H464C455 112 448 119 448 128V160C448 169 455 176 464 176H496C505 176 512 169 512 160V128C512 119 505 112 496 112ZM384 112H352C343 112 336 119 336 128V160C336 169 343 176 352 176H384C393 176 400 169 400 160V128C400 119 393 112 384 112ZM160 112H128C119 112 112 119 112 128V160C112 169 119 176 128 176H160C169 176 176 169 176 160V128C176 119 169 112 160 112ZM272 112H240C231 112 224 119 224 128V160C224 169 231 176 240 176H272C281 176 288 169 288 160V128C288 119 281 112 272 112ZM48 112H16C7 112 0 119 0 128V160C0 169 7 176 16 176H48C57 176 64 169 64 160V128C64 119 57 112 48 112Z"]
  };
  var faGrip = {
    prefix: 'fal',
    iconName: 'grip',
    icon: [448, 512, [], "f58d", "M80 288H48C22 288 0 310 0 336V368C0 394 22 416 48 416H80C106 416 128 394 128 368V336C128 310 106 288 80 288ZM96 368C96 377 89 384 80 384H48C39 384 32 377 32 368V336C32 327 39 320 48 320H80C89 320 96 327 96 336V368ZM80 96H48C22 96 0 118 0 144V176C0 202 22 224 48 224H80C106 224 128 202 128 176V144C128 118 106 96 80 96ZM96 176C96 185 89 192 80 192H48C39 192 32 185 32 176V144C32 135 39 128 48 128H80C89 128 96 135 96 144V176ZM240 96H208C182 96 160 118 160 144V176C160 202 182 224 208 224H240C266 224 288 202 288 176V144C288 118 266 96 240 96ZM256 176C256 185 249 192 240 192H208C199 192 192 185 192 176V144C192 135 199 128 208 128H240C249 128 256 135 256 144V176ZM400 96H368C342 96 320 118 320 144V176C320 202 342 224 368 224H400C426 224 448 202 448 176V144C448 118 426 96 400 96ZM416 176C416 185 409 192 400 192H368C359 192 352 185 352 176V144C352 135 359 128 368 128H400C409 128 416 135 416 144V176ZM400 288H368C342 288 320 310 320 336V368C320 394 342 416 368 416H400C426 416 448 394 448 368V336C448 310 426 288 400 288ZM416 368C416 377 409 384 400 384H368C359 384 352 377 352 368V336C352 327 359 320 368 320H400C409 320 416 327 416 336V368ZM240 288H208C182 288 160 310 160 336V368C160 394 182 416 208 416H240C266 416 288 394 288 368V336C288 310 266 288 240 288ZM256 368C256 377 249 384 240 384H208C199 384 192 377 192 368V336C192 327 199 320 208 320H240C249 320 256 327 256 336V368Z"]
  };
  var faGripLines = {
    prefix: 'fal',
    iconName: 'grip-lines',
    icon: [448, 512, [], "f7a4", "M432 176H16C7 176 0 183 0 192V192C0 201 7 208 16 208H432C441 208 448 201 448 192V192C448 183 441 176 432 176ZM432 304H16C7 304 0 311 0 320V320C0 329 7 336 16 336H432C441 336 448 329 448 320V320C448 311 441 304 432 304Z"]
  };
  var faGripLinesVertical = {
    prefix: 'fal',
    iconName: 'grip-lines-vertical',
    icon: [256, 512, [], "f7a5", "M48 48V464C48 473 55 480 64 480H64C73 480 80 473 80 464V48C80 39 73 32 64 32H64C55 32 48 39 48 48ZM176 48V464C176 473 183 480 192 480H192C201 480 208 473 208 464V48C208 39 201 32 192 32H192C183 32 176 39 176 48Z"]
  };
  var faGripVertical = {
    prefix: 'fal',
    iconName: 'grip-vertical',
    icon: [320, 512, [], "f58e", "M128 112V80C128 54 106 32 80 32H48C22 32 0 54 0 80V112C0 138 22 160 48 160H80C106 160 128 138 128 112ZM48 128C39 128 32 121 32 112V80C32 71 39 64 48 64H80C89 64 96 71 96 80V112C96 121 89 128 80 128H48ZM320 112V80C320 54 298 32 272 32H240C214 32 192 54 192 80V112C192 138 214 160 240 160H272C298 160 320 138 320 112ZM240 128C231 128 224 121 224 112V80C224 71 231 64 240 64H272C281 64 288 71 288 80V112C288 121 281 128 272 128H240ZM320 272V240C320 214 298 192 272 192H240C214 192 192 214 192 240V272C192 298 214 320 240 320H272C298 320 320 298 320 272ZM240 288C231 288 224 281 224 272V240C224 231 231 224 240 224H272C281 224 288 231 288 240V272C288 281 281 288 272 288H240ZM320 432V400C320 374 298 352 272 352H240C214 352 192 374 192 400V432C192 458 214 480 240 480H272C298 480 320 458 320 432ZM240 448C231 448 224 441 224 432V400C224 391 231 384 240 384H272C281 384 288 391 288 400V432C288 441 281 448 272 448H240ZM128 432V400C128 374 106 352 80 352H48C22 352 0 374 0 400V432C0 458 22 480 48 480H80C106 480 128 458 128 432ZM48 448C39 448 32 441 32 432V400C32 391 39 384 48 384H80C89 384 96 391 96 400V432C96 441 89 448 80 448H48ZM128 272V240C128 214 106 192 80 192H48C22 192 0 214 0 240V272C0 298 22 320 48 320H80C106 320 128 298 128 272ZM48 288C39 288 32 281 32 272V240C32 231 39 224 48 224H80C89 224 96 231 96 240V272C96 281 89 288 80 288H48Z"]
  };
  var faGuaraniSign = {
    prefix: 'fal',
    iconName: 'guarani-sign',
    icon: [384, 512, [], "e141", "M368 240C368 231 361 224 352 224H208V96C251 96 291 113 321 143C327 149 337 149 344 143C350 137 350 126 344 120C307 84 259 64 208 64V16C208 7 201 0 192 0S176 7 176 16V67C137 73 101 92 72 120C-3 195 -3 317 72 392C99 419 136 437 176 445V496C176 505 183 512 192 512S208 505 208 496V449C211 449 214 450 217 450C219 450 220 450 222 450C277 450 328 430 363 395C366 392 368 388 368 384C368 370 368 254 368 240ZM95 369C32 307 32 205 95 143C117 120 145 105 176 99V412C144 405 116 390 95 369ZM336 377C306 404 265 418 218 418C215 418 211 417 208 417V256H336C336 288 336 354 336 377Z"]
  };
  var faGuitar = {
    prefix: 'fal',
    iconName: 'guitar',
    icon: [640, 512, [], "f7a6", "M501 37L474 11C468 4 458 0 448 0H448C439 0 429 4 422 11L381 55C378 58 376 62 375 67L363 126L297 193L291 187C277 176 262 167 244 163C236 161 227 160 218 160C194 160 171 168 154 185C145 194 138 206 134 219C128 237 111 251 92 253C68 255 46 265 30 282C-16 327 -8 409 48 465C79 496 119 512 156 512C184 512 211 502 231 482C248 466 257 444 259 420C261 401 275 384 293 378C306 374 318 367 327 357C350 334 357 301 349 268C345 250 336 235 325 221L319 215L331 203C331 203 331 203 331 203L386 148L445 137C449 136 454 134 457 131L501 89C516 75 516 52 501 37ZM304 335C298 341 291 345 284 347C253 357 230 385 227 417C226 429 222 446 208 460C191 477 170 480 156 480C126 480 95 466 70 442C46 418 32 386 32 356C32 342 36 321 52 304C66 290 83 286 95 285C127 282 155 259 165 228C167 221 171 213 177 208C190 195 207 192 218 192C225 192 231 193 237 194C247 197 258 202 268 210L274 215L229 261C229 261 229 261 229 261C222 258 215 256 208 256C181 256 160 277 160 304S181 352 208 352S256 331 256 304C256 297 254 290 251 283C251 283 251 283 251 283L296 238L302 244C310 254 315 265 318 275C323 299 318 321 304 335ZM224 304C224 313 217 320 208 320S192 313 192 304S199 288 208 288S224 295 224 304ZM479 66L437 106L399 113L406 75L445 34C448 31 451 32 452 33L479 60C480 62 480 65 479 66Z"]
  };
  var faGuitarElectric = {
    prefix: 'fal',
    iconName: 'guitar-electric',
    icon: [512, 512, [], "f8be", "M171 277C165 270 155 270 149 277S142 293 149 299L213 363C216 366 220 368 224 368S232 366 235 363C242 357 242 347 235 341L171 277ZM123 325C117 318 107 318 101 325S94 341 101 347L165 411C168 414 172 416 176 416S184 414 187 411C194 405 194 395 187 389L123 325ZM498 18C487 6 471 0 455 0C446 0 437 2 428 6L384 28C368 37 357 53 357 71V135L274 215L269 210C266 206 265 201 267 197L283 163C291 145 286 123 269 111C253 100 230 102 216 116L181 151C171 161 163 174 159 187C154 199 145 209 134 214L64 246C33 259 9 287 2 321C-5 355 6 390 30 414L98 482C122 506 157 517 191 510C225 503 253 479 266 447L298 378C303 367 313 358 325 353C339 349 351 341 361 331L381 311C397 295 397 268 381 251C373 243 362 239 351 239C346 239 342 240 338 241L316 248C315 248 313 249 312 249C307 249 304 246 302 244L297 238L443 95C450 98 457 100 464 100C477 100 489 95 498 86C507 77 512 64 512 52C512 39 507 27 498 18ZM312 281V281C317 281 321 280 326 278L348 272C349 271 350 271 351 271C354 271 356 272 358 274C360 276 361 279 361 281S360 287 358 289L338 308C331 315 323 320 314 323C294 330 278 345 269 365L237 434L237 435L236 435C228 458 208 474 185 479C161 483 137 476 120 459L53 392C36 375 29 351 33 327C38 304 54 285 75 276L76 276L77 275L147 243C167 234 181 218 189 198C192 189 197 181 204 174L239 139C241 137 243 136 245 136S250 137 252 139C255 142 255 146 254 149L238 183C231 198 233 216 243 229L280 267C291 278 304 281 312 281ZM475 63C472 66 468 68 464 68S456 66 453 63C450 60 446 58 441 58C437 58 433 60 430 63L389 104V71C389 65 393 60 398 57L442 35C446 33 451 32 455 32C463 32 470 35 475 40C482 47 482 57 475 63Z"]
  };
  var faGuitars = {
    prefix: 'fal',
    iconName: 'guitars',
    icon: [512, 512, [], "f8bf", "M144 180V134L169 94C171 90 172 85 172 81V26C172 12 160 0 145 0H111C96 0 84 12 84 26V80C84 85 85 89 87 93L112 134V180C88 182 64 188 43 210C28 225 18 245 18 266C18 278 21 290 27 300C35 316 33 336 22 349C8 366 0 385 0 407C0 465 57 512 128 512C154 512 178 506 198 495C205 491 207 482 204 474C204 474 204 474 204 474C200 466 190 463 182 467C166 475 148 480 128 480C101 480 76 472 58 457C41 443 32 425 32 407C32 390 40 377 46 370C66 346 69 313 55 286C52 280 50 273 50 266C50 241 75 214 112 214L112 275C93 282 80 299 80 320C80 346 102 368 128 368C154 368 176 346 176 320C176 299 163 282 144 275L144 214C163 213 178 219 191 233C198 239 208 240 214 233C221 226 220 217 215 211C190 185 159 182 144 180ZM116 32H140V81L128 103L116 81V32ZM144 320C144 329 137 336 128 336S112 329 112 320S119 304 128 304S144 311 144 320ZM400 336H336C327 336 320 343 320 352C320 361 327 368 336 368H400C409 368 416 361 416 352C416 343 409 336 400 336ZM400 400H336C327 400 320 407 320 416C320 425 327 432 336 432H400C409 432 416 425 416 416C416 407 409 400 400 400ZM505 387L474 336C467 316 463 307 472 287C477 276 480 264 480 252V221C480 212 474 202 464 200C463 200 461 200 459 200C452 200 444 204 441 211L429 234C423 246 417 254 404 256H384V93C404 86 418 66 416 42C413 18 391 0 366 0C346 0 328 14 323 35C316 68 305 115 304 121C302 132 305 143 313 151L352 182V256H332C319 253 314 242 309 229L294 189C291 181 284 176 276 176C270 176 266 178 262 182C258 186 256 190 256 196V252C256 264 259 276 264 287C273 307 269 316 262 336L231 387C206 446 249 512 314 512H422C487 512 530 446 505 387ZM335 128C337 122 347 75 354 42C356 36 361 32 366 32C375 32 383 38 384 46C385 55 379 61 373 63C361 67 352 80 352 93V141L335 128ZM470 454C460 470 442 480 422 480H314C294 480 277 471 266 454C255 438 253 419 260 401L289 353C290 351 291 349 292 347L292 346C300 324 307 305 293 273C291 269 290 265 289 261C296 271 306 282 324 287C326 288 329 288 332 288H404C406 288 408 288 410 287C427 284 438 275 446 266C445 269 444 271 443 273C428 304 436 324 443 345L444 347C445 349 446 351 447 353L476 401C483 419 481 438 470 454Z"]
  };
  var faH = {
    prefix: 'fal',
    iconName: 'h',
    icon: [384, 512, [], "e142", "M384 48V464C384 473 377 480 368 480S352 473 352 464V256H32V464C32 473 25 480 16 480S0 473 0 464V48C0 39 7 32 16 32S32 39 32 48V224H352V48C352 39 359 32 368 32S384 39 384 48Z"]
  };
  var faH1 = {
    prefix: 'fal',
    iconName: 'h1',
    icon: [576, 512, [], "f313", "M256 64C247 64 240 71 240 80V224H48V80C48 71 41 64 32 64S16 71 16 64V416C16 441 23 448 32 448S48 441 48 432V256H240V432C240 441 247 448 256 448S272 441 272 416V64C272 71 265 64 256 64ZM528 416H464V80C464 74 461 69 456 66C452 63 446 63 441 66L377 98C369 102 366 111 370 119C374 127 383 130 391 126L432 106V416H368C359 416 352 423 352 432S359 448 368 448H528C537 448 544 441 544 432S537 416 528 416Z"]
  };
  var faH2 = {
    prefix: 'fal',
    iconName: 'h2',
    icon: [640, 512, [], "f314", "M256 64C247 64 240 71 240 80V224H48V80C48 71 41 64 32 64S16 71 16 64V416C16 441 23 448 32 448S48 441 48 432V256H240V432C240 441 247 448 256 448S272 441 272 416V64C272 71 265 64 256 64ZM592 416H385C391 361 426 313 477 291L546 261C584 245 608 208 608 167C608 110 562 64 505 64C469 64 416 73 373 117C366 123 366 133 373 139S389 146 395 139C424 111 461 96 505 96C544 96 576 128 576 167C576 195 559 221 533 232L465 261C396 291 352 358 352 432C352 441 359 448 368 448H592C601 448 608 441 608 432S601 416 592 416Z"]
  };
  var faH3 = {
    prefix: 'fal',
    iconName: 'h3',
    icon: [640, 512, [], "f315", "M256 64C247 64 240 71 240 80V224H48V80C48 71 41 64 32 64S16 71 16 64V416C16 441 23 448 32 448S48 441 48 432V256H240V432C240 441 247 448 256 448S272 441 272 416V64C272 71 265 64 256 64ZM495 211L589 90C592 85 593 78 590 73S582 64 576 64H352C343 64 336 71 336 80S343 96 352 96H543L451 214C448 219 447 226 450 231S458 240 464 240C526 240 576 279 576 328S526 416 464 416C412 416 366 387 355 348C352 339 343 334 335 337S322 348 324 356C340 410 397 448 464 448C543 448 608 394 608 328C608 271 559 222 495 211Z"]
  };
  var faH4 = {
    prefix: 'fal',
    iconName: 'h4',
    icon: [640, 512, [], "f86a", "M272 64C263 64 256 71 256 80V224H64V80C64 71 57 64 48 64S32 71 32 64V416C32 441 39 448 48 448S64 441 64 432V256H256V432C256 441 263 448 272 448S288 441 288 416V64C288 71 281 64 272 64ZM592 64C583 64 576 71 576 80V256H416V80C416 71 409 64 400 64S384 71 384 80V272C384 281 391 288 400 288H576V432C576 441 583 448 592 448S608 441 608 416V64C608 71 601 64 592 64Z"]
  };
  var faHammer = {
    prefix: 'fal',
    iconName: 'hammer',
    icon: [576, 512, [], "f6e3", "M271 261L78 468C64 483 38 483 23 468C7 453 7 428 22 413L230 220C236 214 237 204 231 197C225 191 215 190 208 196L0 390C-28 418 -28 463 0 491C13 505 31 512 51 512S88 505 102 491L295 283C301 276 300 266 294 260C288 254 277 255 271 261ZM550 197C544 190 534 190 528 197L523 202L476 158C478 134 470 110 452 92L410 50C378 18 335 0 289 0C243 0 199 18 167 50C160 57 154 62 155 72C156 77 159 81 164 83L244 123V126C244 148 253 170 268 185L314 231C331 248 356 257 380 254L427 297L416 309C410 315 410 325 416 331C419 334 423 336 427 336S435 334 438 331L550 219C557 213 557 203 550 197ZM450 274L396 225C392 222 387 221 382 222C366 225 349 220 337 208L291 162C282 153 276 140 276 126V114C276 107 273 102 267 99L199 65C224 44 255 32 289 32C326 32 361 47 388 73L430 115C441 127 447 144 443 161C442 166 444 172 448 175L500 224L450 274Z"]
  };
  var faHammerWar = {
    prefix: 'fal',
    iconName: 'hammer-war',
    icon: [384, 512, [], "f6e4", "M352 32C350 32 349 32 347 33L240 50L208 56V16C208 7 201 0 192 0S176 7 176 16V56L144 50L37 33C35 32 34 32 32 32C15 32 0 46 0 64V256C0 274 15 288 32 288C34 288 35 288 37 287L144 270L192 262L240 270L347 288C349 288 350 288 352 288C369 288 384 274 384 256V64C384 46 369 32 352 32ZM352 256L192 229L32 256V64L192 91L352 64V256ZM192 288C183 288 176 295 176 304V496C176 505 183 512 192 512S208 505 208 496V304C208 295 201 288 192 288Z"]
  };
  var faHamsa = {
    prefix: 'fal',
    iconName: 'hamsa',
    icon: [512, 512, [], "f665", "M256 328C243 328 232 339 232 352S243 376 256 376S280 365 280 352S269 328 256 328ZM452 224H416V96C416 61 387 32 352 32C339 32 327 36 316 43C308 18 284 0 256 0C228 0 204 18 196 43C185 36 173 32 160 32C125 32 96 61 96 96V224H60C19 224 0 261 0 288C0 303 5 318 15 330L105 440C142 486 197 512 256 512S370 486 407 440L497 330C507 318 512 303 512 288C512 261 493 224 452 224ZM472 310L385 417C360 447 326 470 288 477C227 489 167 466 129 420L40 310C32 301 30 287 34 275C39 263 49 256 60 256H128L128 98C128 82 139 67 155 65C175 61 192 77 192 96V208C192 217 199 224 208 224H208C217 224 224 217 224 208L224 66C224 50 235 35 251 33C271 29 288 45 288 64V208C288 217 295 224 304 224H304C313 224 320 217 320 208L320 98C320 82 331 67 347 65C367 61 384 77 384 96V256H452C463 256 473 263 478 275C482 287 480 301 472 310ZM256 272C237 272 198 274 144 342C139 348 139 356 144 362C198 430 237 432 256 432S314 430 368 362C373 356 373 348 368 342C314 274 275 272 256 272ZM256 400C212 400 176 352 176 352S212 304 256 304S336 352 336 352S300 400 256 400Z"]
  };
  var faHandDots = {
    prefix: 'fal',
    iconName: 'hand-dots',
    icon: [512, 512, [], "f461", "M272 320C263 320 256 327 256 336S263 352 272 352S288 345 288 336S281 320 272 320ZM336 320C345 320 352 313 352 304S345 288 336 288S320 295 320 304S327 320 336 320ZM208 416C199 416 192 423 192 432S199 448 208 448S224 441 224 432S217 416 208 416ZM208 288C199 288 192 295 192 304S199 320 208 320S224 313 224 304S217 288 208 288ZM272 384C263 384 256 391 256 400S263 416 272 416S288 409 288 400S281 384 272 384ZM400 288C391 288 384 295 384 304S391 320 400 320S416 313 416 304S409 288 400 288ZM336 416C327 416 320 423 320 432S327 448 336 448S352 441 352 432S345 416 336 416ZM368 352C359 352 352 359 352 368S359 384 368 384S384 377 384 368S377 352 368 352ZM424 79C415 79 407 81 400 85C398 55 374 32 344 32C334 32 325 34 317 39C310 16 289 0 264 0C233 0 208 25 208 56V58C197 46 179 38 161 40C147 42 133 49 124 60C115 72 111 86 112 100C122 193 126 273 127 308L98 269C88 257 74 249 59 248C44 246 29 251 17 262C-3 281 -6 314 12 337L98 450C126 489 171 512 218 512H320C408 512 480 440 480 352V135C480 104 455 79 424 79ZM448 352C448 422 391 480 320 480H218C181 480 146 462 124 431L37 317C30 307 30 293 39 285C43 281 49 279 54 279C55 279 56 279 56 279C63 280 68 283 72 288L107 334C116 345 130 350 143 346C153 342 160 331 160 319C159 294 155 204 144 97C143 91 145 85 149 81C153 76 158 73 165 72C177 71 189 80 190 92C202 210 207 238 208 243C210 251 218 257 226 256C234 255 240 248 240 240V56C240 43 251 32 264 32S288 43 288 56V240C288 249 295 256 304 256C313 256 320 249 320 240V88C320 75 331 64 344 64S368 75 368 88V240C368 248 375 256 384 256C393 256 400 248 400 240V135C400 122 411 111 424 111S448 122 448 135V352Z"]
  };
  var faHandHeart = {
    prefix: 'fal',
    iconName: 'hand-heart',
    icon: [512, 512, [], "f4bc", "M360 300C354 296 342 288 326 288C313 288 300 293 288 301C276 293 263 288 250 288C234 288 222 296 216 300C204 310 196 325 195 341C195 357 201 372 212 384L270 440C275 445 281 448 288 448C295 448 301 446 306 441L364 384C376 372 382 357 381 341C380 325 372 310 360 300ZM342 361L288 413L234 361C226 352 224 335 236 325C240 322 254 311 277 334L288 345L299 334C322 311 336 322 340 325L340 325C352 335 351 352 342 361ZM424 79C415 79 407 81 400 85C398 55 374 32 344 32C334 32 325 34 317 39C310 16 289 0 264 0C233 0 208 25 208 56V58C197 46 179 38 161 40C147 42 133 49 124 60C115 72 111 86 112 100C122 193 126 273 127 308L98 269C88 257 74 249 59 248C44 246 29 251 17 262C-3 281 -6 314 12 337L98 450C126 489 171 512 218 512H320C408 512 480 440 480 352V135C480 104 455 79 424 79ZM448 352C448 422 391 480 320 480H218C181 480 146 462 124 431L37 317C30 307 30 293 39 285C43 281 49 279 54 279C55 279 56 279 56 279C63 280 68 283 72 288L107 334C116 345 130 350 143 346C153 342 160 331 160 319C159 294 155 204 144 97C143 91 145 85 149 81C153 76 158 73 165 72C177 71 189 80 190 92C202 210 207 238 208 243C210 251 218 257 226 256C234 255 240 248 240 240V56C240 43 251 32 264 32S288 43 288 56V240C288 249 295 256 304 256C313 256 320 249 320 240V88C320 75 331 64 344 64S368 75 368 88V240C368 248 375 256 384 256C393 256 400 248 400 240V135C400 122 411 111 424 111S448 122 448 135V352Z"]
  };
  var faHandHolding = {
    prefix: 'fal',
    iconName: 'hand-holding',
    icon: [576, 512, [], "f4bd", "M576 375C575 391 568 405 556 415L455 496C442 506 425 512 408 512H16C7 512 0 505 0 496S7 480 16 480H409C418 480 428 477 435 471L536 390C546 382 547 367 537 357C533 354 528 352 523 352C518 352 513 354 508 357L447 407C439 413 430 416 420 416H240C231 416 224 409 224 400C224 391 231 384 240 384H328C341 384 352 373 352 360S341 336 328 336H181C167 336 154 340 143 349L96 384H16C7 384 0 377 0 368S7 352 16 352H85L124 323C140 311 160 304 181 304H326C354 304 379 324 383 352C385 363 383 374 379 384H420C423 384 425 383 427 382L488 332C498 324 511 320 523 320C536 320 549 325 558 334C570 344 576 359 576 375Z"]
  };
  var faHandHoldingBox = {
    prefix: 'fal',
    iconName: 'hand-holding-box',
    icon: [576, 512, [], "f47b", "M558 334C549 325 536 320 523 320C511 320 498 324 488 332L427 382C425 383 423 384 420 384H379C383 374 385 363 383 352C379 324 354 304 326 304H181C161 304 140 311 124 323L85 352H16C7 352 0 359 0 368S7 384 16 384H96L143 349C154 340 167 336 181 336H328C341 336 352 347 352 360S341 384 328 384H240C231 384 224 391 224 400C224 409 231 416 240 416H420C430 416 439 413 447 407L509 358C513 354 518 352 523 352C528 352 533 354 537 358C547 367 546 382 536 390L435 471C428 477 418 480 409 480H16C7 480 0 487 0 496S7 512 16 512H408C425 512 442 506 455 496L556 415C568 405 575 391 576 375C576 359 570 344 558 334ZM160 256H416C451 256 480 227 480 192V64C480 29 451 0 416 0H160C125 0 96 29 96 64V192C96 227 125 256 160 256ZM240 32H336V102C326 97 312 90 295 82C291 79 285 79 281 82L240 102V32ZM128 64C128 46 142 32 160 32H208V128C208 134 211 139 216 142C218 143 221 144 224 144C226 144 229 143 231 142L288 114C302 121 331 135 341 140C347 146 365 144 368 132C368 128 369 126 368 124C368 105 368 32 368 32H416C434 32 448 46 448 64V192C448 210 434 224 416 224H160C142 224 128 210 128 192V64Z"]
  };
  var faHandHoldingDollar = {
    prefix: 'fal',
    iconName: 'hand-holding-dollar',
    icon: [576, 512, [], "f4c0", "M558 334C549 325 536 320 523 320C511 320 498 324 488 332L427 382C425 383 423 384 420 384H379C383 374 385 363 383 352C379 324 354 304 326 304H181C161 304 140 311 124 323L85 352H16C7 352 0 359 0 368S7 384 16 384H96L143 349C154 340 167 336 181 336H328C341 336 352 347 352 360S341 384 328 384H240C231 384 224 391 224 400C224 409 231 416 240 416H420C430 416 439 413 447 407L509 358C513 354 518 352 523 352C528 352 533 354 537 358C547 367 546 382 536 390L435 471C428 477 418 480 409 480H16C7 480 0 487 0 496S7 512 16 512H408C425 512 442 506 455 496L556 415C568 405 575 391 576 375C576 359 570 344 558 334ZM276 191C268 190 263 188 237 180C229 177 220 181 217 190C214 198 219 207 227 210C256 220 263 221 272 223V240C272 249 279 256 288 256S304 249 304 240V223C334 220 355 204 359 179C367 133 322 121 292 113L285 111C251 101 246 94 248 82C251 66 276 62 300 65C306 66 314 68 325 72C333 74 342 70 345 62C348 53 343 44 335 41C323 37 312 35 304 34V16C304 7 297 0 288 0S272 7 272 16V33C242 36 221 52 217 77C209 122 254 135 276 141L284 143C322 154 330 159 327 174C325 190 300 194 276 191Z"]
  };
  var faHandHoldingDroplet = {
    prefix: 'fal',
    iconName: 'hand-holding-droplet',
    icon: [576, 512, [], "f4c1", "M288 256C341 256 384 214 384 162C384 122 327 41 301 6C298 2 293 0 288 0S278 2 275 6C249 41 192 122 192 162C192 214 235 256 288 256ZM288 43C332 104 352 146 352 162C352 196 323 224 288 224S224 196 224 162C224 146 244 104 288 43ZM558 334C549 325 536 320 523 320C511 320 498 324 488 332L427 382C425 383 423 384 420 384H379C383 374 385 363 383 352C379 324 354 304 326 304H181C161 304 140 311 124 323L85 352H16C7 352 0 359 0 368S7 384 16 384H96L143 349C154 340 167 336 181 336H328C341 336 352 347 352 360S341 384 328 384H240C231 384 224 391 224 400C224 409 231 416 240 416H420C430 416 439 413 447 407L509 358C513 354 518 352 523 352C528 352 533 354 537 358C547 367 546 382 536 390L435 471C428 477 418 480 409 480H16C7 480 0 487 0 496S7 512 16 512H408C425 512 442 506 455 496L556 415C568 405 575 391 576 375C576 359 570 344 558 334Z"]
  };
  var faHandHoldingHeart = {
    prefix: 'fal',
    iconName: 'hand-holding-heart',
    icon: [576, 512, [], "f4be", "M275 250C282 258 294 258 301 250L410 136C441 103 439 48 404 18C369 -13 323 1 299 25L288 37L277 25C254 1 208 -13 172 18C137 48 135 103 166 136L275 250ZM192 42C213 24 241 33 254 48L288 83L322 48C335 33 363 24 384 42C407 62 404 96 387 114L288 218L189 114C172 97 169 62 192 42ZM558 334C549 325 536 320 523 320C511 320 498 324 488 332L427 382C425 383 423 384 420 384H379C383 374 385 363 383 352C379 324 354 304 326 304H181C161 304 140 311 124 323L85 352H16C7 352 0 359 0 368S7 384 16 384H96L143 349C154 340 167 336 181 336H328C341 336 352 347 352 360S341 384 328 384H240C231 384 224 391 224 400C224 409 231 416 240 416H420C430 416 439 413 447 407L509 358C513 354 518 352 523 352C528 352 533 354 537 358C547 367 546 382 536 390L435 471C428 477 418 480 409 480H16C7 480 0 487 0 496S7 512 16 512H408C425 512 442 506 455 496L556 415C568 405 575 391 576 375C576 359 570 344 558 334Z"]
  };
  var faHandHoldingMagic = {
    prefix: 'fal',
    iconName: 'hand-holding-magic',
    icon: [576, 512, [], "f6e5", "M558 334C549 325 536 320 523 320C511 320 498 324 488 332L427 382C425 383 423 384 420 384H379C383 374 385 363 383 352C379 324 354 304 326 304H181C161 304 140 311 124 323L85 352H16C7 352 0 359 0 368S7 384 16 384H96L143 349C154 340 167 336 181 336H328C341 336 352 347 352 360S341 384 328 384H240C231 384 224 391 224 400C224 409 231 416 240 416H420C430 416 439 413 447 407L509 358C513 354 518 352 523 352C528 352 533 354 537 358C547 367 546 382 536 390L435 471C428 477 418 480 409 480H16C7 480 0 487 0 496S7 512 16 512H408C425 512 442 506 455 496L556 415C568 405 575 391 576 375C576 359 570 344 558 334ZM224 192H240C293 192 336 149 336 96C336 87 329 80 320 80S304 87 304 96C304 131 275 160 240 160H224C189 160 160 131 160 96S189 32 224 32H331C378 32 416 70 416 117C416 144 403 170 382 186L326 227C319 233 318 243 323 250C326 254 331 256 336 256C339 256 343 255 346 253L401 211C430 189 448 154 448 117C448 53 395 0 331 0H224C171 0 128 43 128 96S171 192 224 192Z"]
  };
  var faHandHoldingMedical = {
    prefix: 'fal',
    iconName: 'hand-holding-medical',
    icon: [576, 512, [], "e05c", "M558 334C549 325 536 320 523 320C511 320 498 324 488 332L427 382C425 383 423 384 420 384H379C383 374 385 363 383 352C379 324 354 304 326 304H181C161 304 140 311 124 323L85 352H16C7 352 0 359 0 368S7 384 16 384H96L143 349C154 340 167 336 181 336H328C341 336 352 347 352 360S341 384 328 384H240C231 384 224 391 224 400C224 409 231 416 240 416H420C430 416 439 413 447 407L509 358C513 354 518 352 523 352C528 352 533 354 537 358C547 367 546 382 536 390L435 471C428 477 418 480 409 480H16C7 480 0 487 0 496S7 512 16 512H408C425 512 442 506 455 496L556 415C568 405 575 391 576 375C576 359 570 344 558 334ZM192 192H224V224C224 242 238 256 256 256H320C338 256 352 242 352 224V192H384C402 192 416 178 416 160V96C416 78 402 64 384 64H352V32C352 14 338 0 320 0H256C238 0 224 14 224 32V64H192C174 64 160 78 160 96V160C160 178 174 192 192 192ZM192 96H256V32H320V96H384V160H320V224H256V160H192V96Z"]
  };
  var faHandHoldingSeedling = {
    prefix: 'fal',
    iconName: 'hand-holding-seedling',
    icon: [576, 512, [], "f4bf", "M249 192H272V240C272 249 279 256 288 256C297 256 304 249 304 240V192H327C411 192 480 113 480 16C480 7 473 0 464 0H425C365 0 313 40 288 98C263 40 211 0 151 0H112C103 0 96 7 96 16C96 113 165 192 249 192ZM425 32H447C441 104 389 160 327 160H305C311 88 363 32 425 32ZM151 32C213 32 265 88 271 160H249C187 160 135 104 129 32H151ZM558 334C549 325 536 320 523 320C511 320 498 324 488 332L427 382C425 383 423 384 420 384H379C383 374 385 363 383 352C379 324 354 304 326 304H181C161 304 140 311 124 323L85 352H16C7 352 0 359 0 368S7 384 16 384H96L143 349C154 340 167 336 181 336H328C341 336 352 347 352 360S341 384 328 384H240C231 384 224 391 224 400C224 409 231 416 240 416H420C430 416 439 413 447 407L509 358C513 354 518 352 523 352C528 352 533 354 537 358C547 367 546 382 536 390L435 471C428 477 418 480 409 480H16C7 480 0 487 0 496S7 512 16 512H408C425 512 442 506 455 496L556 415C568 405 575 391 576 375C576 359 570 344 558 334Z"]
  };
  var faHandLizard = {
    prefix: 'fal',
    iconName: 'hand-lizard',
    icon: [512, 512, [], "f258", "M496 448C487 448 480 441 480 432V324C480 312 476 301 470 291L349 121C338 105 320 96 300 96H46C39 96 32 102 32 108C32 119 36 130 44 139C52 147 64 152 76 152H244C259 152 273 159 282 171C291 183 293 198 288 212L278 241C272 260 254 272 234 272H136C124 272 112 277 104 285C96 294 92 305 92 316C92 322 99 328 106 328H266C269 328 272 329 275 331L361 387C365 390 368 395 368 400V432C368 441 361 448 352 448S336 441 336 432V409L261 360H106C81 360 61 341 60 317C59 297 67 278 81 263C95 248 115 240 136 240H234C240 240 246 236 248 231L258 201C260 196 257 192 256 190C253 186 249 184 244 184H76C55 184 35 176 21 161C7 146 -1 127 0 107C1 83 21 64 46 64H300C330 64 358 78 375 102L496 273C506 288 512 306 512 324V432C512 441 505 448 496 448Z"]
  };
  var faHandMiddleFinger = {
    prefix: 'fal',
    iconName: 'hand-middle-finger',
    icon: [512, 512, [], "f806", "M431 250L416 246C416 219 398 201 377 197C346 191 345 191 339 191C332 191 326 192 320 195V63C319 28 291 0 256 0C222 0 193 27 192 62V195C186 192 179 191 173 191S164 192 142 196C115 202 96 225 96 253V267L67 282C46 293 32 315 32 339V402C32 419 39 436 51 448L77 474C101 499 134 512 168 512H352C423 512 480 454 480 383V312C480 283 460 257 431 250ZM448 384C448 437 405 480 352 480H168C142 480 118 470 100 452L73 425C67 419 64 411 64 402V339C64 327 71 316 82 310L96 303V335C96 344 103 351 112 351S128 344 128 335V253C128 241 137 230 149 228C168 224 170 223 173 223C183 223 192 232 192 242C192 249 198 255 205 255H211C215 255 218 254 220 251S224 246 224 242V64C224 47 236 32 253 31C262 30 271 33 278 39C284 45 288 54 288 63V242C288 249 294 255 301 255H307C310 255 314 254 316 251S320 246 320 242C320 232 329 223 339 223C342 223 342 223 371 229C378 230 384 237 384 244V271L424 281C438 285 448 298 448 312V384Z"]
  };
  var faHandPaper = {
    prefix: 'fal',
    iconName: 'hand-paper',
    icon: [512, 512, [], "f256", "M424 79C415 79 407 81 400 85C398 55 374 32 344 32C334 32 325 34 317 39C310 16 289 0 264 0C233 0 208 25 208 56V58C197 46 179 38 161 40C147 42 133 49 124 60C115 72 111 86 112 100C122 193 126 273 127 308L98 269C88 257 74 249 59 248C44 246 29 251 17 262C-3 281 -6 314 12 337L98 450C126 489 171 512 218 512H320C408 512 480 440 480 352V135C480 104 455 79 424 79ZM448 352C448 422 391 480 320 480H218C181 480 146 462 124 431L37 317C30 307 30 293 39 285C43 281 49 279 54 279C55 279 56 279 56 279C63 280 68 283 72 288L107 334C116 345 130 350 143 346C153 342 160 331 160 319C159 294 155 204 144 97C143 91 145 85 149 81C153 76 158 73 165 72C177 71 189 80 190 92C202 210 207 238 208 243C210 251 218 257 226 256C234 255 240 248 240 240V56C240 43 251 32 264 32S288 43 288 56V240C288 249 295 256 304 256C313 256 320 249 320 240V88C320 75 331 64 344 64S368 75 368 88V240C368 248 375 256 384 256C393 256 400 248 400 240V135C400 122 411 111 424 111S448 122 448 135V352Z"]
  };
  var faHandPeace = {
    prefix: 'fal',
    iconName: 'hand-peace',
    icon: [448, 512, [], "f25b", "M282 512H164C142 512 120 506 100 495L39 462C15 449 0 423 0 395V345C0 322 10 300 28 286L55 264C56 263 58 262 59 261L4 112C-8 80 8 45 39 34C54 28 71 29 85 35C100 42 111 55 117 70L148 156L155 57C158 23 187 -2 220 0C253 2 278 32 276 65L267 182C272 181 277 180 282 180H297C318 180 338 192 348 210H356C389 210 416 237 416 271V376C416 451 356 512 282 512ZM70 293L48 310C38 319 32 331 32 345V395C32 411 41 426 55 434L115 467C130 476 147 480 164 480H282C338 480 384 433 384 376V271C384 255 371 242 356 242H341C334 243 325 238 323 231C319 220 308 212 297 212H282C274 212 267 215 261 221C257 226 249 228 243 225C237 223 233 216 233 210L244 63C245 47 233 33 217 32C202 31 188 43 187 59L175 234C174 241 169 247 161 248C153 250 146 245 144 238L87 81C84 74 79 68 72 65C65 61 58 61 51 64C36 69 28 86 34 101L127 353C130 361 125 370 117 373C109 376 100 372 97 364L70 293Z"]
  };
  var faHandPointDown = {
    prefix: 'fal',
    iconName: 'hand-point-down',
    icon: [448, 512, [], "f0a7", "M134 512C101 512 74 485 74 451V262L28 227C10 212 0 190 0 167V117C0 89 15 63 39 50L100 17C120 6 142 0 164 0H282C356 0 416 61 416 136V241C416 275 389 302 356 302H348C338 320 318 332 297 332H282C276 332 270 331 265 329C254 341 239 347 223 347H208C203 347 199 346 194 345V451C194 485 167 512 134 512ZM106 451C106 467 119 480 134 480S162 467 162 451V319C162 313 166 307 172 305C178 302 185 303 189 308C193 311 199 315 208 315H223C232 315 241 310 247 302C251 294 261 292 268 296C273 299 277 300 282 300H297C309 300 319 292 323 281C325 274 333 270 339 270L356 270C371 270 384 257 384 241V136C384 79 338 32 282 32H164C147 32 130 36 115 45L55 78C41 86 32 101 32 117V167C32 181 38 193 48 202L74 222V174C74 165 81 158 90 158S106 165 106 174V451Z"]
  };
  var faHandPointLeft = {
    prefix: 'fal',
    iconName: 'hand-point-left',
    icon: [512, 512, [], "f0a5", "M0 198C0 165 27 138 61 138H250L285 92C300 74 322 64 345 64H395C423 64 449 79 462 103L495 164C506 184 512 206 512 228V346C512 420 451 480 376 480H271C237 480 210 453 210 420L210 412C192 402 180 382 180 361V346C180 340 181 334 183 329C171 318 165 303 165 287V272C165 267 166 263 167 258H61C27 258 0 231 0 198ZM61 170C45 170 32 183 32 198S45 226 61 226H193C199 226 205 230 207 236C210 242 209 249 204 253C201 257 197 263 197 272V287C197 296 202 305 210 311C218 315 220 325 216 332C213 337 212 341 212 346V361C212 373 220 383 231 387C238 389 242 397 242 403L242 420C242 435 255 448 271 448H376C433 448 480 402 480 346V228C480 211 476 194 467 179L434 119C426 105 411 96 395 96H345C331 96 319 102 310 112L290 138H338C347 138 354 145 354 154S347 170 338 170H61Z"]
  };
  var faHandPointRight = {
    prefix: 'fal',
    iconName: 'hand-point-right',
    icon: [512, 512, [], "f0a4", "M512 198C512 165 485 138 451 138H262L227 92C212 74 190 64 167 64H117C89 64 63 79 50 103L17 164C6 184 0 206 0 228V346C0 420 61 480 136 480H241C275 480 302 453 302 420V412C320 402 332 382 332 361V346C332 340 331 334 329 329C341 318 347 303 347 287V272C347 267 346 263 345 258H451C485 258 512 231 512 198ZM451 170C467 170 480 183 480 198S467 226 451 226H319C313 226 307 230 305 236C302 242 303 249 307 253C311 257 315 263 315 272V287C315 296 310 305 302 311C294 315 292 325 296 332C299 337 300 341 300 346V361C300 373 292 383 281 387C274 390 270 397 270 403L270 420C270 435 257 448 241 448H136C79 448 32 402 32 346V228C32 211 36 194 45 179L78 119C86 105 101 96 117 96H167C181 96 193 102 202 112L222 138H174C165 138 158 145 158 154S165 170 174 170H451Z"]
  };
  var faHandPointUp = {
    prefix: 'fal',
    iconName: 'hand-point-up',
    icon: [448, 512, [], "f0a6", "M134 0C101 0 74 27 74 61V250L28 285C10 300 0 322 0 345V395C0 423 15 449 39 462L100 495C120 506 142 512 164 512H282C356 512 416 451 416 376V271C416 237 389 210 356 210H348C338 192 318 180 297 180H282C276 180 270 181 265 183C254 171 239 165 223 165H208C203 165 199 166 194 167V61C194 27 167 0 134 0ZM106 61C106 45 119 32 134 32S162 45 162 61V193C162 199 166 205 172 207C178 210 185 209 189 204C193 201 199 197 208 197H223C232 197 241 202 247 210C251 218 261 220 268 216C273 213 277 212 282 212H297C309 212 319 220 323 231C325 238 333 242 339 242L356 242C371 242 384 255 384 271V376C384 433 338 480 282 480H164C147 480 130 476 115 467L55 434C41 426 32 411 32 395V345C32 331 38 319 48 310L74 290V338C74 347 81 354 90 354S106 347 106 338V61Z"]
  };
  var faHandPointer = {
    prefix: 'fal',
    iconName: 'hand-pointer',
    icon: [448, 512, [], "f25a", "M387 210H380C369 192 350 180 328 180H313C307 180 302 181 296 183C285 171 270 165 254 165H239C234 165 230 166 225 167V61C225 27 198 0 165 0C131 0 104 27 104 61V273L102 270C93 258 80 250 65 248C50 246 35 250 23 259C-2 278 -7 314 11 339L96 453C123 490 167 512 213 512H332C337 512 343 511 347 510C374 505 399 491 417 471C437 450 448 421 448 391V271C448 237 421 210 387 210ZM416 391C416 413 408 434 393 449C380 464 362 474 339 479C336 480 334 480 332 480H213C177 480 143 463 122 434L37 320C29 309 31 293 42 285C46 281 51 279 57 279C58 279 59 280 60 280C67 281 73 284 77 290L107 331C111 336 118 338 125 336C132 334 136 328 136 321V61C136 45 149 32 165 32C180 32 193 45 193 61V193C193 199 197 205 203 207C209 210 215 209 220 205C224 201 230 197 239 197H254C263 197 272 202 278 211C282 218 292 220 299 216C304 213 308 212 313 212H328C340 212 351 220 355 231C357 238 365 242 373 242H387C403 242 416 255 416 271V391ZM225 304C216 304 209 311 209 320V416C209 425 216 432 225 432S241 425 241 416V320C241 311 233 304 225 304ZM288 304C279 304 272 311 272 320V416C272 425 279 432 288 432S304 425 304 416V320C304 311 297 304 288 304ZM348 304C339 304 332 311 332 320V416C332 425 339 432 348 432S364 425 364 416V320C364 311 357 304 348 304Z"]
  };
  var faHandRock = {
    prefix: 'fal',
    iconName: 'hand-rock',
    icon: [512, 512, [], "f255", "M343 480H166C143 480 121 474 101 464L40 430C15 417 0 392 0 364V270C0 247 10 225 28 211L75 181V137C75 96 109 62 150 62C156 62 161 62 167 64C177 45 197 32 220 32H250C272 32 291 44 302 62C303 62 304 62 305 62H335C357 62 378 74 388 93C393 92 399 91 404 91C446 91 480 125 480 167L480 287C480 308 476 329 468 348L441 414C425 454 386 480 343 480ZM75 219L47 237C38 244 32 256 32 270V364C32 380 41 395 55 402L116 435C132 444 149 448 166 448H343C373 448 400 430 412 402L438 336C444 320 448 304 448 287L448 167C448 137 415 114 385 128C381 130 376 130 371 128C367 126 364 122 363 117C360 103 348 94 335 94H305C302 94 300 94 297 95C289 97 280 93 277 84C274 72 263 64 250 64H220C206 64 195 74 192 87C191 92 188 96 183 98C179 100 174 100 169 98C140 84 107 107 107 137V278C107 287 99 294 91 294S75 287 75 278V219Z"]
  };
  var faHandScissors = {
    prefix: 'fal',
    iconName: 'hand-scissors',
    icon: [512, 512, [], "f257", "M376 480H271C237 480 210 453 210 420V412C192 402 180 382 180 361V346C180 341 181 336 182 331L65 340C32 342 3 317 0 284C-2 250 23 222 57 219L156 212L70 181C55 175 42 164 35 149C29 135 28 118 34 103C45 72 80 56 112 68L261 123C263 119 283 95 286 92C300 74 322 64 345 64H395C423 64 449 79 462 103L495 164C506 184 512 206 512 228V346C512 420 451 480 376 480ZM211 297C217 297 223 301 225 307C228 313 226 321 221 325C215 331 212 338 212 346V361C212 373 220 383 231 387C238 390 243 396 242 403L242 420C242 435 255 448 271 448H376C433 448 480 402 480 346V228C480 211 476 194 467 180L434 119C426 105 411 96 395 96H345C331 96 319 102 310 112L293 134L364 161C372 164 376 173 373 181C370 189 361 194 353 191L101 98C86 92 69 100 64 115C61 122 61 129 65 136C68 143 74 148 81 151L238 208C245 210 250 218 248 225C247 233 241 238 234 239L59 251C43 252 31 266 32 281C33 297 47 309 63 308L210 297C210 297 210 297 211 297Z"]
  };
  var faHandSparkles = {
    prefix: 'fal',
    iconName: 'hand-sparkles',
    icon: [640, 512, [], "e05d", "M320 416C329 416 336 409 336 400V368H368C377 368 384 361 384 352S377 336 368 336H336V304C336 295 329 288 320 288S304 295 304 304V336H272C263 336 256 343 256 352S263 368 272 368H304V400C304 409 311 416 320 416ZM80 224C89 224 96 217 96 208V160H128C137 160 144 153 144 144S137 128 128 128H96V80C96 71 89 64 80 64S64 71 64 80V128H16C7 128 0 135 0 144S7 160 16 160H64V208C64 217 71 224 80 224ZM624 416H576V368C576 359 569 352 560 352S544 359 544 368V416H496C487 416 480 423 480 432S487 448 496 448H544V496C544 505 551 512 560 512S576 505 576 496V448H624C633 448 640 441 640 432S633 416 624 416ZM512 135V320C512 329 519 336 528 336S544 329 544 320V135C544 104 519 79 488 79C479 79 471 82 464 85C462 56 438 32 408 32C398 32 389 34 381 39C374 16 353 0 328 0C297 0 272 25 272 56V58C261 46 243 38 225 40C211 42 197 49 188 60C179 72 175 86 176 100C187 200 191 282 192 308L162 269C152 257 138 249 123 248C108 246 93 251 81 262C61 281 58 314 76 337L162 450C190 489 235 512 282 512H384C409 512 433 506 455 495C463 491 466 482 462 474C458 466 449 463 441 467C423 476 404 480 384 480H282C245 480 210 462 188 431L101 317C94 307 94 293 103 285C108 281 114 279 120 279C127 280 133 283 136 288L171 334C177 342 187 346 197 346C207 345 216 339 220 331C223 326 224 321 224 316C223 299 220 209 208 97C208 91 209 85 213 81C217 76 222 73 229 72C241 71 253 80 254 92C266 210 271 238 272 243C274 251 282 257 290 256C298 255 304 248 304 240V56C304 43 315 32 328 32S352 43 352 56V240C352 249 359 256 368 256S384 249 384 240V88C384 75 395 64 408 64S432 75 432 88V240C432 248 439 256 448 256S464 248 464 240V135C464 122 475 111 488 111S512 122 512 135Z"]
  };
  var faHandSpock = {
    prefix: 'fal',
    iconName: 'hand-spock',
    icon: [512, 512, [], "f259", "M503 116C495 102 481 92 466 89C454 86 443 87 432 90C432 64 416 40 390 32C344 17 317 56 313 77L291 182L256 45C248 13 215 -6 183 2C151 10 131 43 140 75L143 90C122 83 99 89 83 104S61 143 68 164C109 304 107 296 107 297L101 292C77 269 39 270 16 295C-6 319 -5 357 19 380L117 472C144 498 180 512 218 512H333C388 512 436 474 448 421L510 161C514 146 511 129 503 116ZM479 154L417 414C408 453 373 480 333 480H218C189 480 160 469 139 449L41 356C14 331 52 290 80 315L134 367C140 372 148 368 148 361C148 336 144 310 137 286L98 155C88 119 142 103 153 139L186 253C192 273 221 264 216 245L171 67C161 31 216 17 225 53L276 251C281 269 306 268 310 250L344 84C352 47 407 57 399 97L369 246C365 265 393 272 398 253L424 141C433 104 488 118 479 154Z"]
  };
  var faHands = {
    prefix: 'fal',
    iconName: 'hands',
    icon: [512, 512, [], "f2a7", "M464 128C452 128 442 132 433 139L398 41C391 21 372 8 352 8C349 8 346 8 343 9C335 11 327 15 320 20C311 8 297 0 281 0H281C278 0 275 0 272 1C258 3 246 12 239 24C235 33 232 42 233 52C233 52 232 52 232 52C229 52 226 52 223 53C209 55 197 64 190 76C185 85 183 94 184 104C184 104 183 104 183 104C180 104 177 104 174 105C155 108 140 122 136 141C134 151 135 161 138 170L139 173C143 182 155 186 163 180C171 176 173 166 169 159L168 157C164 148 170 138 180 136C181 136 182 136 183 136C184 136 186 136 187 137C196 140 202 138 205 137C216 133 222 121 218 109L217 105C214 96 219 86 229 84C230 84 231 84 232 84C239 84 245 89 247 95L260 131C262 136 266 139 270 141C283 145 295 133 290 120L266 54C263 44 268 34 278 32C279 32 280 32 281 32C288 32 294 37 296 43L337 155C337 155 340 164 350 165C362 166 371 154 367 143L337 62C334 53 339 42 349 40C350 40 351 40 352 40C359 40 365 45 367 52L421 199C422 202 424 204 427 206C436 212 448 205 448 194V177C448 169 453 162 461 160C471 159 480 166 480 176V304C480 313 487 320 496 320L496 320C505 320 512 313 512 304L512 176C512 150 490 128 464 128ZM360 204L247 167C243 165 237 164 232 164C212 164 193 177 187 196C183 205 183 215 185 224H81C57 224 36 241 33 264C31 273 32 282 35 290C17 295 4 309 1 328C-2 342 2 356 11 367C18 375 26 380 35 382C34 385 33 389 33 392C30 406 34 420 43 431C50 439 58 444 67 446C66 449 65 453 65 456C62 470 66 484 75 495C85 506 98 512 112 512H320C391 512 448 455 448 384V325C448 270 413 221 360 204ZM416 384C416 437 373 480 320 480H112C102 480 95 471 96 461C97 453 105 448 113 448H192C201 448 208 441 208 432C208 423 201 416 192 416H80C70 416 63 407 64 397C65 389 73 384 81 384H192C201 384 208 377 208 368C208 359 201 352 192 352H48C38 352 31 343 32 333C33 325 41 320 49 320H192C201 320 208 313 208 304C208 295 201 288 192 288H80C70 288 63 279 64 269C65 261 73 256 81 256H261C270 256 272 243 263 240L226 227C218 224 214 215 217 207C219 200 225 196 232 196C234 196 235 197 237 197L350 234C389 247 416 284 416 326V384Z"]
  };
  var faHandsAslInterpreting = {
    prefix: 'fal',
    iconName: 'hands-asl-interpreting',
    icon: [640, 512, [], "f2a3", "M311 294C310 290 309 286 307 282C310 278 312 274 314 270C320 258 321 244 316 231C311 216 302 203 292 191L314 185C341 178 358 149 350 122C343 99 322 83 297 84C306 73 319 44 296 18C286 7 271 0 256 0C231 0 221 12 191 38C180 2 145 0 140 0C119 0 100 12 92 30L16 195C5 218 0 242 0 266C0 331 54 384 121 384H212L213 384C249 381 283 362 303 333C311 322 314 308 311 294ZM246 254C240 237 223 226 204 226C180 226 160 245 160 269S180 312 204 312C219 312 233 304 241 293C256 270 292 293 277 315C262 336 237 350 212 352H121C72 352 32 313 32 266C32 246 36 226 45 208L121 43C132 19 170 36 159 60L123 135L242 36C263 19 290 49 269 67L168 151L293 116C320 109 331 148 305 155L208 182L232 190C258 198 277 217 286 241C295 266 255 280 246 254ZM216 268C216 275 211 280 204 280S192 275 192 268S197 256 204 256S216 261 216 268ZM519 128H428L427 128C391 131 357 150 337 179C329 190 326 204 329 218C330 222 331 226 333 230C330 234 328 238 326 242C320 254 319 268 324 281C329 296 337 309 348 321L326 327C299 334 282 363 290 390C297 413 318 429 343 428C334 439 321 468 344 494C354 505 369 512 384 512C409 512 419 500 449 474C460 510 495 512 500 512C521 512 540 500 548 482L624 317C635 294 640 270 640 246C640 181 586 128 519 128ZM595 304L519 469C508 493 470 476 481 452L517 377L398 476C377 493 350 463 371 445L472 361L347 396C320 403 309 364 335 357L432 330L408 322C382 314 363 295 354 271C345 246 385 232 394 258C400 275 417 286 436 286C460 286 480 267 480 243S460 200 436 200C421 200 407 208 399 219C384 242 348 219 363 197C378 176 403 162 428 160H519C568 160 608 199 608 246C608 266 604 286 595 304ZM424 244C424 237 429 232 436 232S448 237 448 244S443 256 436 256S424 251 424 244Z"]
  };
  var faHandsBubbles = {
    prefix: 'fal',
    iconName: 'hands-bubbles',
    icon: [576, 512, [], "e05e", "M112 384C77 384 48 413 48 448S77 512 112 512S176 483 176 448S147 384 112 384ZM112 480C94 480 80 466 80 448S94 416 112 416S144 430 144 448S130 480 112 480ZM464 112C495 112 520 87 520 56S495 0 464 0S408 25 408 56S433 112 464 112ZM464 32C477 32 488 43 488 56S477 80 464 80S440 69 440 56S451 32 464 32ZM496 168C496 181 507 192 520 192S544 181 544 168S533 144 520 144S496 155 496 168ZM509 290C512 282 513 273 511 264C508 241 487 224 463 224H359C361 215 361 205 357 196C350 177 332 164 312 164C307 164 301 165 297 167L184 204C131 221 96 270 96 326V338C96 346 103 354 112 354H112C121 354 128 346 128 338V326C128 284 155 247 194 234L307 197C309 197 310 196 312 196C319 196 325 200 327 207C330 215 326 224 318 227L281 240C272 244 274 256 283 256H463C471 256 478 261 480 269C481 279 474 288 464 288H353C345 288 338 293 336 301C335 311 342 320 352 320L495 320C503 320 510 325 512 333C513 343 506 352 496 352H353C345 352 338 357 336 365C335 375 342 384 352 384L463 384C471 384 478 389 480 397C481 407 474 416 464 416H353C345 416 338 421 336 429C335 439 342 448 352 448L431 448C439 448 446 453 448 461C449 471 442 480 432 480H224C221 480 218 480 214 479C214 479 203 478 198 489C193 498 200 510 211 511C215 512 219 512 224 512L430 512C440 512 450 510 458 504C474 494 482 475 479 456C479 453 478 449 477 446C486 444 494 439 501 431C510 420 514 406 511 392C511 389 510 385 509 382C518 380 526 375 533 367C542 356 546 342 543 328C540 309 526 295 509 290ZM64 304V176C64 166 73 159 83 160C91 162 96 169 96 177V194C96 205 108 212 117 206C120 204 122 202 123 199L177 52C179 45 185 40 192 40C193 40 194 40 195 40C205 42 210 53 207 62L177 143C173 154 182 166 194 165C204 164 207 155 207 155L248 43C250 37 256 32 263 32C264 32 265 32 266 32C276 34 281 44 278 53L254 120C249 133 261 145 274 141C278 139 282 136 284 131L297 95C299 89 305 84 312 84C313 84 314 84 315 84C325 86 330 96 327 105L326 109C322 121 328 133 339 137C341 138 348 140 357 137C358 136 360 136 361 136C362 136 363 136 364 136C374 138 380 148 376 157L375 159C371 166 373 176 381 180C389 186 401 182 405 172L406 170C409 161 410 151 408 141C404 122 389 108 370 105C367 104 364 104 361 104C361 104 360 104 360 104C361 94 359 85 354 76C347 64 335 55 321 53C318 52 315 52 312 52C312 52 311 52 311 52C312 42 309 33 305 24C298 12 286 3 272 1C269 0 266 0 263 0H263C247 0 233 8 224 20C217 15 209 11 201 9C198 8 195 8 192 8C172 8 153 21 146 41L111 139C102 132 92 128 80 128C54 128 32 150 32 176L32 304C32 313 39 320 48 320L48 320C57 320 64 313 64 304Z"]
  };
  var faHandsHolding = {
    prefix: 'fal',
    iconName: 'hands-holding',
    icon: [640, 512, [], "f4c2", "M220 249C206 230 171 217 146 245C130 262 130 288 144 306L172 345C179 354 166 365 158 356L97 283L96 114C96 88 75 64 49 64C22 64 0 85 0 112L1 314C1 325 4 336 11 344L118 478C122 484 126 492 127 500C129 507 135 512 143 512H143C153 512 161 502 158 493C156 480 150 467 143 458L36 324C34 322 33 318 33 314L32 112C32 91 64 90 64 113L65 294L129 372C166 416 226 369 200 329C200 329 199 329 199 329L169 286C164 280 165 270 172 264C179 259 189 260 195 268L237 326C250 343 257 363 257 384V496C256 505 264 512 272 512H273C281 512 288 505 288 496V384C288 356 279 329 263 307L220 249ZM639 112C639 85 617 64 591 64C565 64 543 88 543 114L544 283L482 356C475 364 462 354 468 345L497 306C510 288 510 261 495 245C469 217 434 229 420 249L378 307C361 329 352 356 352 384V496C352 505 359 512 368 512H368C377 512 384 505 384 496V384C384 363 391 343 404 326L446 268C451 260 461 259 468 264C476 270 477 280 472 286L441 329C441 329 441 329 441 329C415 369 475 416 512 372L576 294L575 113C575 90 607 91 607 112L608 314C608 318 607 321 605 324L498 458C490 467 485 480 482 492C480 502 488 512 498 512C505 512 512 507 513 500C515 492 518 483 523 478L630 344C636 336 640 325 640 314L639 112Z"]
  };
  var faHandsHoldingDiamond = {
    prefix: 'fal',
    iconName: 'hands-holding-diamond',
    icon: [640, 512, [], "f47c", "M438 104L344 10C338 4 329 0 320 0H320C311 0 302 4 296 10L202 104C189 117 189 139 202 152L296 246C303 253 311 256 320 256S337 253 344 246L438 152C451 139 451 117 438 104ZM415 129L321 223L319 223L225 129C224 129 224 127 225 127L320 32H320L321 33L415 127C416 127 416 129 415 129ZM220 249C206 230 171 217 146 245C130 262 130 288 144 306L172 345C179 354 166 365 158 356L97 283L96 114C96 88 75 64 49 64C22 64 0 85 0 112L1 314C1 325 4 336 11 344L118 478C122 484 126 492 127 500C129 507 135 512 143 512H143C153 512 161 502 158 493C156 480 150 467 143 458L36 324C34 322 33 318 33 314L32 112C32 91 64 90 64 113L65 294L129 372C166 416 226 369 200 329C200 329 199 329 199 329L169 286C164 280 165 270 172 264C179 259 189 260 195 268L237 326C250 343 257 363 257 384V496C256 505 264 512 272 512H273C281 512 288 505 288 496V384C288 356 279 329 263 307L220 249ZM639 112C639 85 617 64 591 64C565 64 543 88 543 114L544 283L482 356C475 364 462 354 468 345L497 306C510 288 510 261 495 245C469 217 434 229 420 249L378 307C361 329 352 356 352 384V496C352 505 359 512 368 512H368C377 512 384 505 384 496V384C384 363 391 343 404 326L446 268C451 260 461 259 468 264C476 270 477 280 472 286L441 329C441 329 441 329 441 329C415 369 475 416 512 372L576 294L575 113C575 90 607 91 607 112L608 314C608 318 607 321 605 324L498 458C490 467 485 480 482 492C480 502 488 512 498 512C505 512 512 507 513 500C515 492 518 483 523 478L630 344C636 336 640 325 640 314L639 112Z"]
  };
  var faHandsHoldingDollar = {
    prefix: 'fal',
    iconName: 'hands-holding-dollar',
    icon: [640, 512, [], "f4c5", "M220 249C206 230 171 217 146 245C130 262 130 288 144 306L172 345C179 354 166 365 158 356L97 283L96 114C96 88 75 64 49 64C22 64 0 85 0 112L1 314C1 325 4 336 11 344L118 478C122 484 126 492 127 500C129 507 135 512 143 512H143C153 512 161 502 158 493C156 480 150 467 143 458L36 324C34 322 33 318 33 314L32 112C32 91 64 90 64 113L65 294L129 372C166 416 226 369 200 329C200 329 199 329 199 329L169 286C164 280 165 270 172 264C179 259 189 260 195 268L237 326C250 343 257 363 257 384V496C256 505 264 512 272 512H273C281 512 288 505 288 496V384C288 356 279 329 263 307L220 249ZM639 112C639 85 617 64 591 64C565 64 543 88 543 114L544 283L482 356C475 364 462 354 468 345L497 306C510 288 510 261 495 245C469 217 434 229 420 249L378 307C361 329 352 356 352 384V496C352 505 359 512 368 512H368C377 512 384 505 384 496V384C384 363 391 343 404 326L446 268C451 260 461 259 468 264C476 270 477 280 472 286L441 329C441 329 441 329 441 329C415 369 475 416 512 372L576 294L575 113C575 90 607 91 607 112L608 314C608 318 607 321 605 324L498 458C490 467 485 480 482 492C480 502 488 512 498 512C505 512 512 507 513 500C515 492 518 483 523 478L630 344C636 336 640 325 640 314L639 112ZM392 179C400 133 356 121 328 113L321 111C287 101 284 94 286 82C289 66 313 62 334 65C341 66 348 68 358 72C366 74 376 70 378 62C381 53 377 44 369 41C357 37 348 35 339 34C338 33 337 33 336 33V16C336 7 329 0 320 0S304 7 304 16V34C278 38 259 53 255 77C247 122 291 135 312 141L319 143C355 154 363 159 360 174C357 190 334 194 312 191C303 189 291 185 281 182L275 180C267 177 258 181 255 189C252 198 256 207 265 210L270 212C281 215 292 220 304 222V240C304 249 311 256 320 256S336 249 336 240V223C366 221 387 205 392 179Z"]
  };
  var faHandsHoldingHeart = {
    prefix: 'fal',
    iconName: 'hands-holding-heart',
    icon: [640, 512, [], "f4c3", "M436 18C422 5 405 0 390 0C367 0 345 11 331 25L320 37L309 25C295 11 273 0 250 0C234 0 218 5 204 18C169 48 167 103 198 136L307 250C314 258 326 258 333 250L442 136C473 103 471 48 436 18ZM419 114L320 218L221 114C204 97 201 62 224 42C233 35 242 32 251 32C265 32 278 39 286 48L320 83L354 48C362 39 375 32 389 32C398 32 407 35 415 42C439 63 436 96 419 114ZM220 249C206 230 171 217 146 245C130 262 130 288 144 306L172 345C179 354 166 365 158 356L97 283L96 114C96 88 75 64 49 64C22 64 0 85 0 112L1 314C1 325 4 336 11 344L118 478C122 484 126 492 127 500C129 507 135 512 143 512H143C153 512 161 502 158 493C156 480 150 467 143 458L36 324C34 322 33 318 33 314L32 112C32 91 64 90 64 113L65 294L129 372C166 416 226 369 200 329C200 329 199 329 199 329L169 286C164 280 165 270 172 264C179 259 189 260 195 268L237 326C250 343 257 363 257 384V496C256 505 264 512 272 512H273C281 512 288 505 288 496V384C288 356 279 329 263 307L220 249ZM639 112C639 85 617 64 591 64C565 64 543 88 543 114L544 283L482 356C475 364 462 354 468 345L497 306C510 288 510 261 495 245C469 217 434 229 420 249L378 307C361 329 352 356 352 384V496C352 505 359 512 368 512H368C377 512 384 505 384 496V384C384 363 391 343 404 326L446 268C451 260 461 259 468 264C476 270 477 280 472 286L441 329C441 329 441 329 441 329C415 369 475 416 512 372L576 294L575 113C575 90 607 91 607 112L608 314C608 318 607 321 605 324L498 458C490 467 485 480 482 492C480 502 488 512 498 512C505 512 512 507 513 500C515 492 518 483 523 478L630 344C636 336 640 325 640 314L639 112Z"]
  };
  var faHandsPraying = {
    prefix: 'fal',
    iconName: 'hands-praying',
    icon: [640, 512, [], "f684", "M640 496C640 489 635 483 628 481L394 411C360 401 336 370 336 334V248C336 235 347 224 360 224S384 235 384 248V304C384 313 391 320 400 320H400C409 320 416 313 416 304V228C416 211 412 195 403 180L339 68C333 56 337 42 348 35C359 29 374 32 381 44L467 195C476 210 480 226 480 243V310C480 324 489 336 503 340L619 379C630 382 640 375 640 364V364C640 357 635 351 629 348L512 310V243C512 221 506 199 495 180L409 28C399 11 380 0 360 0C345 0 331 6 320 17C309 6 295 0 280 0C260 0 241 11 231 28L145 180C134 199 128 221 128 243V310L11 349C5 351 0 357 0 364V364C0 375 10 382 21 379L137 340C151 336 160 324 160 310V243C160 226 164 210 173 196L259 44C266 32 281 29 292 35C303 42 307 56 301 68L237 180C228 195 224 211 224 228V304C224 313 231 320 240 320H240C249 320 256 313 256 304V248C256 235 267 224 280 224S304 235 304 248V334C304 370 280 401 246 411L12 481C5 483 0 489 0 496V496C0 507 10 514 20 511L254 442C283 434 306 415 320 391C334 415 357 434 386 442L620 511C630 514 640 507 640 496L640 496ZM320 210C311 201 299 194 286 192C279 192 272 192 266 194L320 99L374 194C368 192 361 192 354 192C341 194 329 201 320 210Z"]
  };
  var faHandshake = {
    prefix: 'fal',
    iconName: 'handshake',
    icon: [640, 512, [], "f2b5", "M640 400C640 409 633 416 624 416H576C555 416 538 403 531 384H499C498 388 496 393 493 397L483 408C469 425 445 430 426 420L406 445C388 467 355 470 334 452L327 447C316 456 302 462 287 464C284 464 282 464 279 464C262 464 245 458 231 447L149 384H109C102 403 85 416 64 416H32C23 416 16 409 16 400S23 384 32 384H64C73 384 80 377 80 368V160H16C7 160 0 153 0 144S7 128 16 128H131C164 95 208 73 254 66C262 65 271 71 272 80C273 89 267 97 258 98C217 104 179 124 149 155L145 160L112 160V352H160L251 422C260 429 272 433 284 432C296 431 306 425 314 415L325 405L337 413L354 428C362 434 374 433 381 425L421 376L439 390C445 395 454 394 459 388L468 377C473 371 472 362 466 357L357 268C350 263 349 253 355 246C360 239 370 238 377 244L486 332C493 337 497 344 499 352H528V160H496L491 155C454 118 405 96 356 96H347C344 96 341 97 338 100L244 187C234 197 236 211 243 219C246 222 252 226 259 226C264 227 269 225 274 221L274 221C283 212 302 194 350 150C357 144 367 144 373 151C379 157 378 167 372 173C372 173 317 224 301 240V240L295 244C285 254 273 258 260 258C259 258 258 258 258 258C240 258 227 249 219 241C200 219 201 186 221 165L222 165L316 76C325 68 336 64 347 64H356C411 64 467 87 509 128H624C633 128 640 135 640 144S633 160 624 160H560V368C560 377 567 384 576 384H624C633 384 640 391 640 400Z"]
  };
  var faHandshakeAngle = {
    prefix: 'fal',
    iconName: 'handshake-angle',
    icon: [640, 512, [], "f4c4", "M474 176H384C375 176 368 183 368 192S375 208 384 208H474C477 208 480 211 480 214V259C480 263 477 266 474 266H464C455 266 448 273 448 282V327C448 344 436 356 421 356H416C407 356 400 363 400 372C400 396 380 416 356 416L240 416C237 416 234 417 232 418L120 482C112 486 110 496 114 504C117 509 122 512 128 512C131 512 133 511 136 510L244 448L356 448C393 448 423 422 430 387C459 383 480 358 480 327V297C498 294 512 279 512 259V214C512 193 495 176 474 176ZM126 267C126 223 148 184 184 162C192 157 194 148 190 140C185 132 175 130 168 135C124 161 97 206 94 257L8 306C0 310 -2 320 2 328C5 333 10 336 16 336C19 336 21 335 24 334L126 276V267ZM280 288C311 288 336 263 336 232V154C336 145 329 138 320 138S304 145 304 154V232C304 245 293 256 280 256S256 245 256 232V118C256 113 258 109 263 106C290 89 322 80 354 80H416C416 80 416 80 416 80C416 80 416 80 416 80C416 80 416 80 416 80C419 80 421 79 423 78C424 78 424 78 424 78L504 30C512 25 514 15 510 8C505 0 495 -2 488 2L412 48H354C316 48 278 59 246 79C232 88 224 102 224 118V232C224 263 249 288 280 288ZM638 183C633 176 623 174 615 178L552 219C544 223 542 233 547 241C550 246 555 248 560 248C563 248 566 247 569 246L633 206C640 201 642 191 638 183Z"]
  };
  var faHandshakeSimple = {
    prefix: 'fal',
    iconName: 'handshake-simple',
    icon: [640, 512, [], "f4c6", "M138 160L145 160L149 155C179 124 217 104 258 98C267 97 273 89 272 80C271 71 262 65 254 66C208 73 164 95 131 128H16C7 128 0 135 0 144S7 160 16 160H138ZM221 165C201 186 200 219 219 241C227 249 240 258 258 258C258 258 259 258 260 258C273 258 285 254 295 244L301 240V239C317 224 372 173 372 173C378 167 379 157 373 151C367 144 357 144 350 150C302 194 283 212 274 221L274 221C269 225 264 227 259 226C252 226 246 222 243 219C236 211 234 197 244 187L338 100C340 97 344 96 347 96H356C405 96 454 118 491 155L496 160H624C633 160 640 153 640 144S633 128 624 128H509C467 87 411 64 356 64H347C336 64 325 68 316 76L222 165L221 165ZM624 352H499C497 344 493 337 486 332L377 244C370 238 360 239 355 246C349 253 350 263 357 268L466 357C472 362 473 371 468 377L459 388C454 394 445 395 439 390L421 376L381 425C374 433 362 434 354 428L337 413L325 405L314 415C306 425 296 431 284 432C272 433 260 430 251 422L160 352H32C23 352 16 359 16 368S23 384 32 384H149L231 447C245 458 262 464 279 464C282 464 284 464 287 464C302 462 316 456 327 447L333 452C355 470 388 467 406 445L426 420C445 430 469 425 483 408L493 397C496 393 498 388 499 384H624C633 384 640 377 640 368S633 352 624 352Z"]
  };
  var faHandshakeSimpleSlash = {
    prefix: 'fal',
    iconName: 'handshake-simple-slash',
    icon: [640, 512, [], "e05f", "M258 98C267 97 273 89 272 80C271 71 262 65 254 66C236 69 219 74 202 81L231 104C240 102 249 99 258 98ZM350 150C339 160 330 168 322 176L347 196C361 183 372 173 372 173C378 167 379 157 373 151C367 144 357 144 350 150ZM286 148L338 100C340 97 344 96 347 96H356C405 96 454 118 491 155L496 160H624C633 160 640 153 640 144S633 128 624 128H509C467 87 411 64 356 64H347C336 64 325 68 316 76L261 128L286 148ZM381 425C374 433 362 434 354 428L337 413L325 405L314 415C306 425 296 431 284 432C272 433 260 429 251 422L160 352H32C23 352 16 359 16 368S23 384 32 384H149L231 447C245 458 262 464 279 464C282 464 284 464 287 464C302 462 316 456 327 447L333 452C355 470 388 467 406 445L425 421L400 401L381 425ZM95 160L55 128H16C7 128 0 135 0 144S7 160 16 160H95ZM624 352H545L585 384H624C633 384 640 377 640 368S633 352 624 352ZM26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483L26 3Z"]
  };
  var faHandshakeSlash = {
    prefix: 'fal',
    iconName: 'handshake-slash',
    icon: [640, 512, [], "e060", "M258 98C267 97 273 89 272 80C271 71 262 65 254 66C236 69 219 74 202 81L231 104C240 102 249 99 258 98ZM350 150C339 160 330 168 322 176L347 196C361 183 372 173 372 173C378 167 379 157 373 151C367 144 357 144 350 150ZM286 148L338 100C340 97 344 96 347 96H356C405 96 454 118 491 155L496 160H528V339L560 364V160H624C633 160 640 153 640 144S633 128 624 128H509C467 87 411 64 356 64H347C336 64 325 68 316 76L261 128L286 148ZM381 425C374 433 362 434 354 428L337 413L325 405L314 415C306 425 296 431 284 432C272 433 260 429 251 422L160 352H112V173L55 128H16C7 128 0 135 0 144S7 160 16 160H80V368C80 377 73 384 64 384H32C23 384 16 391 16 400S23 416 32 416H64C85 416 102 403 109 384H149L231 447C245 458 262 464 279 464C282 464 284 464 287 464C302 462 316 456 327 447L333 452C355 470 388 467 406 445L425 421L400 401L381 425ZM624 384H585L626 416C634 415 640 408 640 400C640 391 633 384 624 384ZM26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483L26 3Z"]
  };
  var faHanukiah = {
    prefix: 'fal',
    iconName: 'hanukiah',
    icon: [640, 512, [], "f6e6", "M592 160H592C583 160 576 167 576 176V304C576 325 563 342 544 349V176C544 167 537 160 528 160H528C519 160 512 167 512 176V352H480V176C480 167 473 160 464 160H464C455 160 448 167 448 176V352H416V176C416 167 409 160 400 160S384 167 384 176V352H336V112C336 103 329 96 320 96H320C311 96 304 103 304 112V352H256V176C256 167 249 160 240 160H240C231 160 224 167 224 176V352H192V176C192 167 185 160 176 160H176C167 160 160 167 160 176V352H128V176C128 167 121 160 112 160H112C103 160 96 167 96 176V349C77 342 64 325 64 304V176C64 167 57 160 48 160H48C39 160 32 167 32 176V304C32 348 68 384 112 384H304V480H144C135 480 128 487 128 496V496C128 505 135 512 144 512H496C505 512 512 505 512 496V496C512 487 505 480 496 480H336V384H528C572 384 608 348 608 304V176C608 167 601 160 592 160ZM592 128C601 128 608 121 608 112V80C608 71 601 64 592 64S576 71 576 80V112C576 121 583 128 592 128ZM48 128C57 128 64 121 64 112V80C64 71 57 64 48 64S32 71 32 80V112C32 121 39 128 48 128ZM112 128C121 128 128 121 128 112V80C128 71 121 64 112 64S96 71 96 80V112C96 121 103 128 112 128ZM176 128C185 128 192 121 192 112V80C192 71 185 64 176 64S160 71 160 80V112C160 121 167 128 176 128ZM240 128C249 128 256 121 256 112V80C256 71 249 64 240 64S224 71 224 80V112C224 121 231 128 240 128ZM400 128C409 128 416 121 416 112V80C416 71 409 64 400 64S384 71 384 80V112C384 121 391 128 400 128ZM464 128C473 128 480 121 480 112V80C480 71 473 64 464 64S448 71 448 80V112C448 121 455 128 464 128ZM528 128C537 128 544 121 544 112V80C544 71 537 64 528 64S512 71 512 80V112C512 121 519 128 528 128ZM320 64C329 64 336 57 336 48V16C336 7 329 0 320 0S304 7 304 16V48C304 57 311 64 320 64Z"]
  };
  var faHardDrive = {
    prefix: 'fal',
    iconName: 'hard-drive',
    icon: [512, 512, [], "f0a0", "M448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V320C32 302 46 288 64 288H448C466 288 480 302 480 320V416ZM480 265C471 259 460 256 448 256H64C52 256 41 259 32 265V96C32 78 46 64 64 64H448C466 64 480 78 480 96V265ZM320 344C307 344 296 355 296 368C296 381 307 392 320 392C333 392 344 381 344 368C344 355 333 344 320 344ZM416 344C403 344 392 355 392 368C392 381 403 392 416 392C429 392 440 381 440 368C440 355 429 344 416 344Z"]
  };
  var faHashtag = {
    prefix: 'fal',
    iconName: 'hashtag',
    icon: [448, 512, [], "f292", "M432 144H346L368 52C370 43 364 34 356 32C347 30 338 36 336 44L313 144H186L208 52C210 43 204 34 196 32C187 30 178 36 176 44L153 144H48C39 144 32 151 32 160S39 176 48 176H146L109 336H16C7 336 0 343 0 352S7 368 16 368H102L80 460C78 469 84 478 92 480C94 480 95 480 96 480C103 480 110 475 112 468L135 368H262L240 460C238 469 244 478 252 480C254 480 255 480 256 480C263 480 270 475 272 468L295 368H400C409 368 416 361 416 352S409 336 400 336H302L339 176H432C441 176 448 169 448 160S441 144 432 144ZM269 336H142L179 176H306L269 336Z"]
  };
  var faHatChef = {
    prefix: 'fal',
    iconName: 'hat-chef',
    icon: [512, 512, [], "f86b", "M416 32C395 32 375 39 358 52C335 21 298 0 256 0C214 0 177 21 154 52C125 30 86 26 53 42C20 58 0 91 0 128C0 161 40 281 57 330C61 343 73 352 87 352H425C439 352 451 343 455 330C472 281 512 161 512 128C512 75 469 32 416 32ZM426 320H372L400 179C401 170 396 162 387 160C378 158 370 164 368 173L339 320H272V151C272 142 265 135 256 135S240 142 240 151V320H173L144 173C142 164 134 158 125 160C116 162 111 170 112 179L140 320H86C68 262 32 145 32 128C32 93 61 64 96 64C110 64 123 69 134 77L160 97L179 71C198 46 226 32 256 32S314 46 333 71L352 97L378 77C389 69 402 64 416 64C451 64 480 93 480 128C480 145 444 262 426 320ZM432 384C423 384 416 391 416 400V464C416 473 409 480 400 480H112C103 480 96 473 96 464V400C96 391 89 384 80 384S64 391 64 400V464C64 490 86 512 112 512H400C426 512 448 490 448 464V400C448 391 441 384 432 384Z"]
  };
  var faHatCowboy = {
    prefix: 'fal',
    iconName: 'hat-cowboy',
    icon: [640, 512, [], "f8c0", "M626 226C623 225 619 224 615 224C607 224 600 228 595 234C595 234 572 265 509 289C499 219 466 32 400 32C385 32 371 39 359 50C337 69 303 69 281 50C269 39 255 32 240 32C174 32 141 219 131 289C69 265 46 235 45 234C40 227 33 224 25 224C21 224 17 225 14 226C3 231 -3 243 1 254C2 255 75 448 320 448S638 255 639 254C643 243 637 231 626 226ZM240 64C246 64 252 67 260 74C294 104 346 104 380 74C388 67 394 64 400 64C414 64 444 118 466 225C428 235 380 242 320 242S212 235 174 225C196 118 226 64 240 64ZM169 257C209 267 258 274 320 274C382 274 431 267 472 257C474 270 476 285 478 300C438 311 387 320 320 320S202 311 162 300C164 285 166 270 169 257ZM320 416C169 416 90 337 55 286C97 315 177 352 320 352S544 314 585 286C550 337 471 416 320 416Z"]
  };
  var faHatCowboySide = {
    prefix: 'fal',
    iconName: 'hat-cowboy-side',
    icon: [640, 512, [], "f8c1", "M638 361C619 271 560 208 487 195L468 85C463 55 436 32 405 32C396 32 409 30 201 74C174 80 153 102 150 130L143 197C75 214 20 275 2 361C-3 382 1 403 13 420C24 438 42 448 62 448H578C598 448 615 438 627 420C639 403 643 382 638 361ZM182 133C184 119 194 108 207 105L399 65C418 61 434 74 437 91L466 256H316L287 231C238 191 191 192 176 193L182 133ZM62 416C41 416 28 390 33 367C51 282 111 224 180 224C211 224 241 235 266 255C446 410 429 400 454 416H62ZM385 315L353 288H471L491 400C458 385 433 357 385 315ZM578 416C573 416 549 416 525 412L493 229C548 245 591 296 607 367C613 394 596 416 578 416Z"]
  };
  var faHatSanta = {
    prefix: 'fal',
    iconName: 'hat-santa',
    icon: [640, 512, [], "f7a7", "M640 239C640 228 634 218 625 212C627 202 624 190 617 182C609 174 598 171 587 174C575 155 545 155 533 174C523 171 511 174 503 182C495 190 493 202 495 212C486 218 480 228 480 239S486 261 495 266C493 277 496 288 504 297C512 305 523 308 533 305C539 314 549 320 560 320C571 320 581 314 587 305C595 307 606 307 617 296C625 288 627 277 625 266C634 261 640 251 640 239ZM592 253C590 260 590 268 594 273C588 270 580 269 573 272C567 275 562 280 560 287C558 280 553 275 547 272L541 270H537C533 270 529 271 526 274C530 268 530 260 528 253C525 246 519 241 512 240C512 240 512 240 512 240L512 240C519 237 525 232 528 226C530 219 530 211 526 206C532 209 540 209 546 207C553 204 558 198 560 191C562 198 567 204 573 207C580 209 588 209 594 205C590 211 590 219 592 226C595 232 601 237 608 239C601 241 595 246 592 253ZM464 352H459L383 154C380 146 371 142 362 145C354 148 350 158 353 166L425 352H88L163 164C187 103 245 64 310 64C361 64 410 89 439 130L467 169C472 176 482 178 489 173C496 168 498 158 493 151L465 112C430 62 372 32 310 32C232 32 162 79 133 152L53 352H48C22 352 0 374 0 400V432C0 458 22 480 48 480H464C490 480 512 458 512 432V400C512 374 490 352 464 352ZM480 432C480 441 473 448 464 448H48C39 448 32 441 32 432V400C32 391 39 384 48 384H464C473 384 480 391 480 400V432Z"]
  };
  var faHatWinter = {
    prefix: 'fal',
    iconName: 'hat-winter',
    icon: [512, 512, [], "f7a8", "M191 107C189 117 191 129 199 137C208 145 218 148 229 145C235 154 245 160 256 160C267 160 277 154 283 145C291 147 302 147 313 136C321 129 323 117 321 107C330 101 336 91 336 80S330 59 321 53C323 43 320 31 313 23C305 15 294 13 283 15C271 -3 241 -3 229 15C219 13 207 15 199 23C191 31 189 43 191 53C182 59 176 69 176 80S182 101 191 107ZM208 80L208 80C215 78 221 73 224 66C226 60 226 52 222 46C228 50 236 50 242 48C249 45 254 39 256 32C258 39 263 45 269 47C276 50 284 50 290 46C286 52 286 60 288 66C291 73 297 78 304 80C297 82 291 87 288 94C286 100 286 108 290 114C284 110 276 110 269 113C263 115 258 121 256 128C254 121 249 115 242 113L237 111H233C229 111 225 112 222 114C226 108 226 100 224 94C221 87 215 82 208 80C208 80 208 80 208 80ZM480 403V368C480 199 363 147 358 145C350 142 341 146 337 154C334 162 338 171 346 175C349 176 422 210 443 313L391 289C386 287 381 288 377 290L320 318L263 290C259 287 253 287 249 290L192 318L135 290C131 288 126 287 122 289L69 313C90 210 163 176 166 175C174 171 178 162 175 154C171 146 162 142 154 145C149 147 32 199 32 368V403C13 410 0 427 0 448V464C0 490 22 512 48 512H464C490 512 512 490 512 464V448C512 427 499 410 480 403ZM64 368C64 362 64 356 65 350L128 322L185 350C189 353 195 353 199 350L256 322L313 350C317 353 323 353 327 350L384 322L447 350C448 356 448 362 448 368V400H64V368ZM480 464C480 473 473 480 464 480H48C39 480 32 473 32 464V448C32 439 39 432 48 432H464C473 432 480 439 480 448V464Z"]
  };
  var faHatWitch = {
    prefix: 'fal',
    iconName: 'hat-witch',
    icon: [576, 512, [], "f6e7", "M571 420C565 414 554 415 548 421C528 443 476 480 411 480H165C85 480 33 427 28 421C22 415 11 414 5 420C-1 426 -2 436 4 443C11 450 71 512 165 512H411C487 512 548 469 572 443C578 437 577 426 571 420ZM106 431C114 434 123 431 127 422L144 384H232V400C232 418 246 432 264 432H312C330 432 344 418 344 400V384H434L449 422C452 428 458 432 464 432C466 432 468 432 470 431C478 428 482 418 479 410L399 210C394 198 393 185 398 172L404 154C407 145 415 139 425 139H463C473 139 481 145 484 154L491 174C493 180 499 184 506 185C513 184 518 181 521 174L542 120C547 106 543 91 533 81L466 11C454 -1 435 -4 419 5L260 104C236 118 217 139 205 164L97 410C94 418 97 427 106 431ZM264 400V352H312V400H312H264ZM235 177C243 158 258 142 277 131L436 33C438 31 441 32 443 34L510 103C512 105 513 108 512 109L505 127C495 114 480 107 463 107H425C402 107 381 122 373 144L367 162C360 182 361 204 370 223L421 352H344C344 334 330 320 312 320H264C246 320 232 334 232 352H158L235 177Z"]
  };
  var faHatWizard = {
    prefix: 'fal',
    iconName: 'hat-wizard',
    icon: [512, 512, [], "f6e8", "M75 447C76 448 78 448 80 448C87 448 93 444 95 437L182 193C193 170 210 151 232 138L402 41L352 190C346 207 347 225 354 240L417 437C419 445 428 450 437 447C445 445 450 436 447 427L384 229C380 220 379 210 383 200L439 31C442 22 439 12 431 5C423 -1 413 -2 404 3L216 110C188 127 166 151 153 182L65 427C62 435 66 444 75 447ZM496 432C487 432 480 439 480 448C480 466 466 480 448 480H64C46 480 32 466 32 448C32 439 25 432 16 432S0 439 0 448C0 483 29 512 64 512H448C483 512 512 483 512 448C512 439 505 432 496 432ZM224 416C233 416 240 409 240 400V368H272C281 368 288 361 288 352S281 336 272 336H240V304C240 295 233 288 224 288S208 295 208 304V336H176C167 336 160 343 160 352S167 368 176 368H208V400C208 409 215 416 224 416ZM288 224H304C313 224 320 217 320 208S313 192 304 192H288V176C288 167 281 160 272 160S256 167 256 176V192H240C231 192 224 199 224 208S231 224 240 224H256V240C256 249 263 256 272 256S288 249 288 240V224Z"]
  };
  var faHeadSide = {
    prefix: 'fal',
    iconName: 'head-side',
    icon: [512, 512, [], "f6e9", "M509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335L64 496C64 505 71 512 80 512C89 512 96 505 96 496C96 472 96 346 96 321L85 311C50 279 30 233 32 186C35 101 111 32 200 32H266C323 32 377 60 410 107C423 125 439 173 452 213C462 242 471 269 480 288H432C423 288 416 295 416 304V384C416 402 402 416 384 416H304C295 416 288 423 288 432C288 452 288 484 288 496C288 505 295 512 304 512C313 512 320 505 320 496C320 484 320 460 320 448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275ZM344 224C357 224 368 213 368 200C368 187 357 176 344 176C331 176 320 187 320 200C320 213 331 224 344 224Z"]
  };
  var faHeadSideBrain = {
    prefix: 'fal',
    iconName: 'head-side-brain',
    icon: [512, 512, [], "f808", "M509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335L64 496C64 505 71 512 80 512C89 512 96 505 96 496C96 472 96 346 96 321L85 311C50 279 30 233 32 186C35 101 111 32 200 32H266C323 32 377 60 410 107C423 125 439 173 452 213C462 242 471 269 480 288H432C423 288 416 295 416 304V384C416 402 402 416 384 416H304C295 416 288 423 288 432C288 452 288 484 288 496C288 505 295 512 304 512C313 512 320 505 320 496C320 484 320 460 320 448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275ZM328 224C359 224 384 199 384 168C384 138 360 113 330 112C319 88 291 74 265 82C244 59 204 59 183 82C154 73 123 92 115 120C86 123 64 147 64 176C64 198 77 217 97 226C102 252 125 272 152 272H160V304C160 313 167 320 176 320S192 313 192 304V256C192 247 185 240 176 240H152C139 240 129 230 128 217C128 216 128 216 128 215C129 207 123 200 115 199C104 196 96 187 96 176C96 163 106 152 122 152C122 153 125 153 125 153C130 154 135 153 139 150C143 147 145 142 144 137C144 136 144 135 144 135C145 122 155 112 168 112C172 112 176 113 180 116C184 118 189 119 193 118C197 117 201 114 203 110C211 93 237 93 245 110C247 114 251 117 255 118C259 119 264 118 268 116C272 113 276 112 280 112C291 112 301 121 303 133C304 137 306 141 311 144C315 146 320 147 324 145C327 144 328 144 328 144C341 144 352 155 352 168S341 192 328 192H286C282 192 277 194 274 198C271 202 270 207 271 211C271 212 272 216 272 216C272 229 261 240 248 240C239 240 232 247 232 256S239 272 248 272C276 272 300 251 303 224H328Z"]
  };
  var faHeadSideCough = {
    prefix: 'fal',
    iconName: 'head-side-cough',
    icon: [640, 512, [], "e061", "M477 275C456 228 429 123 404 88C366 34 303 0 234 0L198 0C93 0 4 81 0 185C-2 244 23 298 64 335V496C64 505 71 512 80 512H80C89 512 96 505 96 496V321L91 316C71 298 55 277 45 253C-2 141 88 32 200 32H234C291 32 345 60 378 107C390 124 407 173 420 213C430 241 439 269 448 288H400C391 288 384 295 384 304V336L339 336C313 336 289 355 288 381C287 409 309 432 336 432H384V448C384 466 370 480 352 480H304C295 480 288 487 288 496V496C288 505 295 512 304 512H352C387 512 416 483 416 448V416C416 407 409 400 400 400H337C329 400 322 395 320 387C319 377 326 368 336 368H400C409 368 416 361 416 352V320H448C471 320 487 296 477 275ZM352 200C352 187 341 176 328 176C315 176 304 187 304 200S315 224 328 224C341 224 352 213 352 200ZM608 360C595 360 584 371 584 384S595 408 608 408S632 397 632 384S621 360 608 360ZM480 360C467 360 456 371 456 384S467 408 480 408C493 408 504 397 504 384S493 360 480 360ZM608 312C621 312 632 301 632 288S621 264 608 264S584 275 584 288S595 312 608 312ZM544 312C531 312 520 323 520 336S531 360 544 360S568 349 568 336S557 312 544 312ZM544 408C531 408 520 419 520 432S531 456 544 456S568 445 568 432S557 408 544 408ZM608 456C595 456 584 467 584 480S595 504 608 504S632 493 632 480S621 456 608 456Z"]
  };
  var faHeadSideCoughSlash = {
    prefix: 'fal',
    iconName: 'head-side-cough-slash',
    icon: [640, 512, [], "e062", "M568 336C568 323 557 312 544 312C532 312 522 321 521 333L553 358C562 355 568 346 568 336ZM200 32H234C291 32 345 60 378 107C390 124 407 173 420 213C427 233 434 253 440 270L478 299C481 292 481 283 477 275C456 228 429 123 404 88C366 34 303 0 234 0H198C170 0 144 6 119 16L150 40C166 35 182 32 200 32ZM608 312C621 312 632 301 632 288S621 264 608 264S584 275 584 288S595 312 608 312ZM608 360C595 360 585 370 584 383L614 407C624 404 632 395 632 384C632 371 621 360 608 360ZM634 483L26 3C19 -2 9 -1 3 6C-2 13 -1 23 6 29L614 509C617 511 621 512 624 512C629 512 633 510 637 506C642 499 641 489 634 483ZM45 253C25 207 30 161 49 123L23 103C9 127 1 155 0 185C-2 244 23 298 64 335V496C64 505 71 512 80 512C89 512 96 505 96 496V321L91 316C71 298 55 277 45 253ZM399 400H337C329 400 322 395 320 387C319 377 326 368 336 368H359L322 339C303 345 289 361 288 381C287 409 309 432 336 432H384V448C384 466 370 480 352 480H304C295 480 288 487 288 496C288 505 295 512 304 512H352C387 512 416 483 416 448V416C416 415 416 414 415 413L399 400Z"]
  };
  var faHeadSideGoggles = {
    prefix: 'fal',
    iconName: 'head-side-goggles',
    icon: [512, 512, [], "f6ea", "M480 64H383C345 24 292 0 234 0H200C128 0 62 39 27 97C12 100 0 112 0 128V192C0 210 14 224 32 224H216C217 224 217 223 218 223C237 243 264 256 293 256H480C498 256 512 242 512 224V96C512 78 498 64 480 64ZM32 192V128H198C194 139 191 152 192 165C193 175 195 183 198 192H32ZM217 96C216 96 216 96 216 96H67C98 57 146 32 200 32H234C270 32 305 44 334 64H288C259 64 234 77 217 96ZM384 224H288C253 224 224 195 224 160S253 96 288 96H384V224ZM480 224H416V96H480V224ZM36 256L36 256C24 256 16 269 21 279C32 300 47 319 64 335V496C64 505 71 512 80 512H80C89 512 96 505 96 496V321L85 311C71 298 59 282 51 265C48 260 42 256 36 256ZM384 304V384C384 402 370 416 352 416H304C295 416 288 423 288 432V496C288 505 295 512 304 512H304C313 512 320 505 320 496V448H352C387 448 416 419 416 384V320H464C473 320 480 313 480 304V304C480 295 473 288 464 288H400C391 288 384 295 384 304Z"]
  };
  var faHeadSideHeadphones = {
    prefix: 'fal',
    iconName: 'head-side-headphones',
    icon: [512, 512, [], "f8c2", "M509 275C488 228 461 123 436 88C397 33 334 0 266 0H200C96 0 4 80 0 185C-2 242 21 297 64 335V496C64 505 71 512 80 512H80C89 512 96 505 96 496V321L85 311C50 279 30 233 32 186C35 120 81 64 144 42V116C104 144 87 195 101 242C116 288 159 320 208 320S300 288 315 242C330 195 312 144 272 116V32C327 34 378 62 410 107C423 125 439 173 452 213C462 242 471 269 480 288H432C423 288 416 295 416 304V384C416 402 402 416 384 416H304C295 416 288 423 288 432V496C288 505 295 512 304 512H304C313 512 320 505 320 496V448H384C419 448 448 419 448 384V320H480C491 320 501 314 507 305C513 296 514 285 509 275ZM176 34C184 33 192 32 200 32H240V101C230 98 219 96 208 96S186 98 176 101V34ZM288 208C288 252 252 288 208 288S128 252 128 208S164 128 208 128S288 164 288 208ZM208 160C182 160 160 182 160 208S181 256 208 256S256 234 256 208S235 160 208 160ZM208 224C199 224 192 217 192 208S199 192 208 192S224 199 224 208S217 224 208 224Z"]
  };
  var faHeadSideHeart = {
    prefix: 'fal',
    iconName: 'head-side-heart',
    icon: [512, 512, [], "e143", "M509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335L64 496C64 505 71 512 80 512C89 512 96 505 96 496C96 472 96 346 96 321L85 311C50 279 30 233 32 186C35 101 111 32 200 32H266C323 32 377 60 410 107C423 125 439 173 452 213C462 242 471 269 480 288H432C423 288 416 295 416 304V384C416 402 402 416 384 416H304C295 416 288 423 288 432C288 452 288 484 288 496C288 505 295 512 304 512C313 512 320 505 320 496C320 484 320 460 320 448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275ZM330 109C316 98 283 81 240 124C197 81 164 98 150 109C122 132 121 173 145 198L230 284C235 289 244 289 250 284L334 198C359 173 358 132 330 109ZM312 176L240 248L168 176C158 165 156 146 170 134C184 122 201 130 209 138L240 169L271 138C278 130 296 122 310 134C324 146 322 165 312 176Z"]
  };
  var faHeadSideMask = {
    prefix: 'fal',
    iconName: 'head-side-mask',
    icon: [512, 512, [], "e063", "M512 288C512 284 511 279 509 275C488 228 461 123 436 88C398 34 335 0 266 0H198C94 0 4 81 0 185C-2 244 23 298 64 335V496C64 505 71 512 80 512C89 512 96 505 96 496L96 321L85 311C48 277 28 228 33 178C33 178 33 178 33 178L224 317V496C224 505 231 512 240 512H402C429 512 454 494 463 468L510 325C511 322 512 318 512 315L512 288ZM468 352H336C327 352 320 359 320 368C320 377 327 384 336 384H457L446 416H336C327 416 320 423 320 432C320 441 327 448 336 448H436L432 458C428 471 416 480 402 480H256V320H478L468 352ZM480 288H239L41 144C63 79 126 32 200 32H266C323 32 377 60 410 107C422 124 439 173 452 212C462 241 471 269 480 288V288ZM344 176C331 176 320 187 320 200S331 224 344 224S368 213 368 200S357 176 344 176Z"]
  };
  var faHeadSideMedical = {
    prefix: 'fal',
    iconName: 'head-side-medical',
    icon: [512, 512, [], "f809", "M509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335L64 496C64 505 71 512 80 512C89 512 96 505 96 496C96 472 96 346 96 321L85 311C50 279 30 233 32 186C35 101 111 32 200 32H266C323 32 377 60 410 107C423 125 439 173 452 213C462 242 471 269 480 288H432C423 288 416 295 416 304V384C416 402 402 416 384 416H304C295 416 288 423 288 432C288 452 288 484 288 496C288 505 295 512 304 512C313 512 320 505 320 496C320 484 320 460 320 448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275ZM336 224V192C336 183 329 176 320 176H272V128C272 119 265 112 256 112H224C215 112 208 119 208 128V176H160C151 176 144 183 144 192V224C144 233 151 240 160 240H208V288C208 297 215 304 224 304H256C265 304 272 297 272 288V240H320C329 240 336 233 336 224Z"]
  };
  var faHeadSideVirus = {
    prefix: 'fal',
    iconName: 'head-side-virus',
    icon: [512, 512, [], "e064", "M224 192C215 192 208 199 208 208C208 217 215 224 224 224S240 217 240 208C240 199 233 192 224 192ZM256 224C247 224 240 231 240 240C240 249 247 256 256 256S272 249 272 240C272 231 265 224 256 224ZM311 317L319 326C322 329 326 330 331 330S339 329 342 326C348 320 348 309 342 303L333 295C313 274 327 240 356 240H368C377 240 384 233 384 224S377 208 368 208H356C327 208 313 174 333 153L342 145C348 139 348 128 342 122C339 119 335 118 331 118S322 119 319 122L311 131C304 137 296 140 288 140C272 140 256 127 256 108V96C256 87 249 80 240 80S224 87 224 96V108C224 127 208 140 192 140C184 140 176 137 169 131L161 122C158 119 154 117 149 117S141 119 138 122C132 128 132 139 138 145L147 153C167 174 153 208 124 208H112C103 208 96 215 96 224S103 240 112 240H124C153 240 167 274 147 295L138 303C132 309 132 320 138 326C141 329 145 330 150 330S158 329 161 326L169 317C176 311 184 308 192 308C208 308 224 321 224 340V352C224 361 231 368 240 368S256 361 256 352V340C256 321 272 308 288 308C296 308 304 311 311 317ZM244 293C243 295 241 296 240 298C228 284 211 276 192 276C191 276 189 276 188 276C189 266 187 257 183 247C179 238 174 230 167 224C174 218 179 210 183 200C187 191 189 182 188 172C189 172 191 172 192 172C211 172 228 164 240 150C252 164 269 172 288 172C289 172 291 172 292 172C291 182 293 191 297 201C301 210 306 218 314 224C306 230 301 238 297 248C293 257 291 266 292 276C291 276 289 276 288 276C272 276 256 282 244 293ZM509 275C488 228 461 123 436 88C398 34 335 0 266 0H200C96 0 4 80 0 185C-2 244 23 298 64 335L64 496C64 505 71 512 80 512C89 512 96 505 96 496C96 472 96 346 96 321L85 311C50 279 30 233 32 186C35 101 111 32 200 32H266C323 32 377 60 410 107C423 125 439 173 452 213C462 242 471 269 480 288H432C423 288 416 295 416 304V384C416 402 402 416 384 416H304C295 416 288 423 288 432C288 452 288 484 288 496C288 505 295 512 304 512C313 512 320 505 320 496C320 484 320 460 320 448H384C419 448 448 419 448 384V320H480C503 320 519 296 509 275Z"]
  };
  var faHeading = {
    prefix: 'fal',
    iconName: 'heading',
    icon: [512, 512, [], "f1dc", "M496 464C496 473 489 480 480 480H352C343 480 336 473 336 464C336 455 343 448 352 448H400V272H112V448H160C169 448 176 455 176 464C176 473 169 480 160 480H32C23 480 16 473 16 464C16 455 23 448 32 448H80V64H32C23 64 16 57 16 48C16 39 23 32 32 32H160C169 32 176 39 176 48C176 57 169 64 160 64H112V240H400V64H352C343 64 336 57 336 48C336 39 343 32 352 32H480C489 32 496 39 496 48C496 57 489 64 480 64H432V448H480C489 448 496 455 496 464Z"]
  };
  var faHeadphones = {
    prefix: 'fal',
    iconName: 'headphones',
    icon: [512, 512, [], "f025", "M243 32C106 39 0 158 0 295V416C0 451 29 480 64 480H96C114 480 128 466 128 448V288C128 270 114 256 96 256H64C53 256 43 259 34 264C48 157 135 70 245 64C365 58 466 148 479 264C470 259 459 256 448 256H416C398 256 384 270 384 288V448C384 466 398 480 416 480H448C483 480 512 451 512 416V288C512 143 390 25 243 32ZM64 288H96V448H64C46 448 32 434 32 416V320C32 302 46 288 64 288ZM480 416C480 434 466 448 448 448H416V288H448C466 288 480 302 480 320V416Z"]
  };
  var faHeadphonesSimple = {
    prefix: 'fal',
    iconName: 'headphones-simple',
    icon: [512, 512, [], "f58f", "M384 256H352C334 256 320 270 320 288V448C320 466 334 480 352 480H384C419 480 448 451 448 416V320C448 285 419 256 384 256ZM416 416C416 434 402 448 384 448H352V288H384C402 288 416 303 416 320V416ZM160 256H128C93 256 64 285 64 320V416C64 451 93 480 128 480H160C178 480 192 466 192 448V288C192 270 178 256 160 256ZM160 448H128C110 448 96 434 96 416V320C96 303 110 288 128 288H160V448ZM243 32C106 39 0 158 0 296V400C0 409 7 416 16 416C25 416 32 409 32 400V295C32 174 124 70 245 64C373 58 480 161 480 288V400C480 409 487 416 496 416C505 416 512 409 512 400V288C512 143 390 25 243 32Z"]
  };
  var faHeadset = {
    prefix: 'fal',
    iconName: 'headset',
    icon: [512, 512, [], "f590", "M192 224C192 206 178 192 160 192H128C93 192 64 221 64 256V320C64 355 93 384 128 384H160C178 384 192 369 192 352V224ZM160 352H128C110 352 96 337 96 320V256C96 238 110 224 128 224H160V352ZM384 384C419 384 448 355 448 320V256C448 221 419 192 384 192H352C334 192 320 206 320 224V352C320 369 334 384 352 384H384ZM352 224H384C402 224 416 238 416 256V320C416 337 402 352 384 352H352V224ZM280 1C127 -13 4 110 0 256L0 272C0 281 7 288 16 288H16C25 288 32 281 32 272L32 256C36 129 143 21 277 33C393 44 480 145 480 262V432C480 458 458 480 432 480H349C353 469 354 456 347 443C338 426 319 416 299 416L242 416C219 416 197 432 193 454C187 485 210 512 240 512H432C476 512 512 476 512 432V263C512 130 413 14 280 1ZM304 480H240C231 480 224 473 224 464S231 448 240 448H304C313 448 320 455 320 464S313 480 304 480Z"]
  };
  var faHeart = {
    prefix: 'fal',
    iconName: 'heart',
    icon: [512, 512, [], "f004", "M462 63C408 16 326 24 276 76L256 97L236 76C196 34 113 9 50 63C-13 116 -16 212 40 270L233 470C240 477 248 480 256 480C264 480 272 477 279 470L472 270C528 212 525 116 462 63ZM449 248L256 448L63 248C24 209 16 133 71 87C125 40 190 74 213 99L256 143L299 99C322 75 387 41 442 87C496 133 488 209 449 248Z"]
  };
  var faHeartCrack = {
    prefix: 'fal',
    iconName: 'heart-crack',
    icon: [512, 512, [], "f7a9", "M462 63C408 16 326 24 276 76L256 97L236 76C196 34 113 9 50 63C-13 116 -16 212 40 270L233 470C240 477 248 480 256 480C264 480 272 477 279 470L472 270C528 212 525 116 462 63ZM449 248L256 448L63 248C24 209 16 133 71 87C125 40 190 74 213 99L276 163L170 209C165 211 162 215 160 220C159 225 161 231 164 234L260 346C263 350 267 352 272 352C276 352 279 351 282 348C289 342 290 332 284 326L202 230L310 183C315 181 319 176 320 171C321 166 319 160 315 157L278 120L299 99C322 75 387 41 442 87C496 133 488 209 449 248Z"]
  };
  var faHeartHalf = {
    prefix: 'fal',
    iconName: 'heart-half',
    icon: [512, 512, [], "e144", "M256 109C256 101 252 93 247 87L236 76C196 34 113 9 50 63C-13 116 -16 212 40 270L233 470C233 470 233 470 234 470C242 479 256 472 256 461C256 392 256 166 256 109ZM224 415L63 248C24 209 16 133 71 87C125 40 190 74 213 99L224 110V415Z"]
  };
  var faHeartHalfStroke = {
    prefix: 'fal',
    iconName: 'heart-half-stroke',
    icon: [512, 512, [], "e145", "M462 63C408 16 326 24 276 76L256 97L236 76C196 34 113 9 50 63C-13 116 -16 212 40 270L233 470C240 477 248 480 256 480C264 480 272 477 279 470L472 270C528 212 525 116 462 63ZM240 431L63 248C24 209 16 133 71 87C125 40 190 74 213 99L240 126V431ZM449 248L272 432V126L299 99C322 75 387 41 442 87C496 133 488 209 449 248Z"]
  };
  var faHeartPulse = {
    prefix: 'fal',
    iconName: 'heart-pulse',
    icon: [512, 512, [], "f21e", "M469 76C424 32 375 32 362 32C350 32 301 32 256 76C211 32 163 32 150 32C137 32 88 32 43 76C15 104 0 141 0 180C0 211 10 241 29 266C32 270 37 272 42 272H155L185 200L241 327C247 339 264 339 270 327L320 228L342 272H470C475 272 480 270 483 266C502 241 512 211 512 180C512 141 497 104 469 76ZM463 240H362L334 185C328 173 312 173 306 185L257 283L199 153C193 141 175 141 169 154L133 240H50C40 225 7 157 68 97C90 75 120 64 150 64C184 64 204 70 256 121C311 67 331 64 362 64C392 64 422 75 444 97C505 157 472 225 463 240ZM410 304H410C406 304 402 306 399 309L269 443C263 449 253 449 246 443L114 309C111 306 106 304 102 304C88 304 81 321 91 331L224 466C243 485 273 485 291 466L422 331C432 321 425 304 410 304Z"]
  };
  var faHeat = {
    prefix: 'fal',
    iconName: 'heat',
    icon: [448, 512, [], "e00c", "M192 154V48C192 39 185 32 176 32S160 39 160 48V152C160 202 178 249 210 286C238 318 256 358 256 401V464C256 473 263 480 272 480S288 473 288 464V402C288 353 270 306 238 269C210 237 192 196 192 154ZM64 132V112C64 103 57 96 48 96S32 103 32 112V128C32 183 50 236 82 280C111 319 128 364 128 412V464C128 473 135 480 144 480S160 473 160 464V416C160 361 142 308 110 264C81 225 64 180 64 132ZM366 264C337 225 320 180 320 132V112C320 103 313 96 304 96S288 103 288 112V128C288 183 306 236 338 280C367 319 384 364 384 412V464C384 473 391 480 400 480S416 473 416 464V416C416 361 398 308 366 264Z"]
  };
  var faHelicopter = {
    prefix: 'fal',
    iconName: 'helicopter',
    icon: [640, 512, [], "f533", "M624 416C615 416 608 423 608 432C608 458 586 480 560 480H240C231 480 224 487 224 496S231 512 240 512H560C604 512 640 476 640 432C640 423 633 416 624 416ZM304 400H568C590 400 608 382 608 360C608 232 504 128 376 128H368V32H560C569 32 576 25 576 16S569 0 560 0H144C135 0 128 7 128 16S135 32 144 32H336V128H120L79 74C74 68 67 64 60 64H24C17 64 10 67 5 73C1 79 -1 87 1 94L24 186C27 198 36 209 48 214L187 271L272 384C280 394 291 400 304 400ZM416 164C507 183 576 263 576 360C576 364 572 368 568 368H416V164ZM207 244L199 241L60 184C57 183 55 181 55 178L34 96H56L94 147L104 160H376C379 160 381 160 384 160V368H304C302 368 299 367 298 365L213 251L207 244Z"]
  };
  var faHelmetBattle = {
    prefix: 'fal',
    iconName: 'helmet-battle',
    icon: [576, 512, [], "f6eb", "M508 405C492 380 464 321 464 212C464 97 334 37 294 21C290 19 286 19 282 21C242 37 112 98 112 212C112 225 111 340 67 407C64 411 63 416 65 420C66 425 69 429 73 431L249 511C254 513 260 512 265 509C269 506 272 501 272 496V272C272 265 267 258 260 256L208 243V224H368V243L316 256C309 258 304 265 304 272V496C304 501 307 506 311 509C314 511 317 512 320 512C322 512 325 512 327 511L503 431C510 427 513 420 512 412C511 411 509 407 508 405ZM336 471V284L388 272C395 270 400 263 400 256V208C400 199 393 192 384 192H192C183 192 176 199 176 208V256C176 263 181 270 188 272L240 284V471L103 409C142 336 144 233 144 212C144 123 247 70 288 53C329 70 432 122 432 212C432 312 455 374 473 409L336 471ZM559 206L512 12C509 4 501 -2 492 0C484 3 478 11 480 20L528 213C528 216 528 219 526 221C524 223 522 224 520 224C511 224 504 231 504 240S511 256 520 256C532 256 543 251 551 242C559 232 562 218 559 206ZM72 240C72 231 65 224 56 224C54 224 52 223 50 221C48 219 48 216 48 213L96 20C98 11 92 3 84 0C75 -2 67 4 64 12L17 206C14 218 17 232 25 242C33 251 44 256 56 256C65 256 72 249 72 240Z"]
  };
  var faHelmetSafety = {
    prefix: 'fal',
    iconName: 'helmet-safety',
    icon: [576, 512, [], "f807", "M572 357C569 354 564 352 560 352C485 352 373 352 265 352C171 352 80 352 16 352C16 352 16 352 16 352C12 352 7 354 4 357C1 360 0 365 0 369C4 441 170 480 288 480H291C406 480 572 441 576 369C576 365 575 360 572 357ZM291 448C290 448 289 448 288 448C184 448 72 418 41 384C102 384 183 384 265 384C362 384 462 384 535 384C504 417 393 448 291 448ZM48 320C57 320 64 313 64 304V275C64 186 124 109 208 85V272C208 281 215 288 224 288S240 281 240 272V64C240 55 247 48 256 48H320C329 48 336 55 336 64V272C336 281 343 288 352 288S368 281 368 272V85C452 109 512 186 512 275V304C512 313 519 320 528 320S544 313 544 304V275C544 167 470 75 366 51C360 31 342 16 320 16H256C234 16 216 31 210 51C106 75 32 167 32 275V304C32 313 39 320 48 320Z"]
  };
  var faHexagon = {
    prefix: 'fal',
    iconName: 'hexagon',
    icon: [512, 512, [], "f312", "M506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM478 262L373 441C371 446 366 448 361 448H151C146 448 141 446 139 442L34 262C31 258 31 254 34 250L139 70C141 66 146 64 151 64H361C366 64 371 66 373 70L478 250C481 254 481 258 478 262Z"]
  };
  var faHexagonMinus = {
    prefix: 'fal',
    iconName: 'hexagon-minus',
    icon: [512, 512, [], "f307", "M352 240H160C151 240 144 247 144 256S151 272 160 272H352C361 272 368 265 368 256S361 240 352 240ZM506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM478 262L373 441C371 446 366 448 361 448H151C146 448 141 446 139 442L34 262C31 258 31 254 34 250L139 70C141 66 146 64 151 64H361C366 64 371 66 373 70L478 250C481 254 481 258 478 262Z"]
  };
  var faHexagonPlus = {
    prefix: 'fal',
    iconName: 'hexagon-plus',
    icon: [512, 512, [], "f300", "M506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM478 262L373 441C371 446 366 448 361 448H151C146 448 141 446 139 442L34 262C31 258 31 254 34 250L139 70C141 66 146 64 151 64H361C366 64 371 66 373 70L478 250C481 254 481 258 478 262ZM352 240H272V160C272 151 265 144 256 144S240 151 240 160V240H160C151 240 144 247 144 256S151 272 160 272H240V352C240 361 247 368 256 368S272 361 272 352V272H352C361 272 368 265 368 256S361 240 352 240Z"]
  };
  var faHexagonXmark = {
    prefix: 'fal',
    iconName: 'hexagon-xmark',
    icon: [512, 512, [], "f2ee", "M335 177C329 171 319 171 313 177L256 233L199 177C193 171 183 171 177 177C171 183 171 193 177 199L233 256L177 313C171 319 171 329 177 335C183 341 193 341 199 335L256 279L313 335C319 341 329 341 335 335C341 329 341 319 335 313L279 256L335 199C341 193 341 183 335 177ZM506 233L400 54C392 41 377 32 361 32H151C134 32 120 41 112 54L6 233C-2 247 -2 265 6 279L112 458C120 471 134 480 151 480H361C378 480 392 471 400 458L506 279C514 265 514 247 506 233ZM478 262L373 441C371 446 366 448 361 448H151C146 448 141 446 139 442L34 262C31 258 31 254 34 250L139 70C141 66 146 64 151 64H361C366 64 371 66 373 70L478 250C481 254 481 258 478 262Z"]
  };
  var faHighlighter = {
    prefix: 'fal',
    iconName: 'highlighter',
    icon: [576, 512, [], "f591", "M529 76L468 15C458 5 444 0 431 0C418 0 406 5 396 13L111 262C100 271 96 285 100 298L113 339L76 376C69 383 69 394 76 400L77 401L6 475C-7 489 2 512 22 512H94C99 512 103 510 106 507L143 467L144 468C151 475 162 475 168 468L205 432L246 444C264 450 277 440 282 434L531 148C549 127 548 95 529 76ZM87 480H46L94 430L100 424L121 445L87 480ZM258 413C258 413 257 414 256 414H255L214 401L196 395L156 435L109 388L149 348L143 330L131 289C130 288 131 287 132 286L177 247L297 368L258 413ZM507 127L318 343L201 226L417 37C422 33 435 27 445 38L506 98C514 106 514 118 507 127Z"]
  };
  var faHighlighterLine = {
    prefix: 'fal',
    iconName: 'highlighter-line',
    icon: [576, 512, [], "e146", "M282 434L531 148C549 127 548 95 529 76L468 15C458 5 444 0 431 0C418 0 406 5 396 13L111 262C100 271 96 285 100 298L113 339L76 376C69 383 69 394 76 400L77 401L6 475C-7 489 2 512 22 512H94C99 512 103 510 106 507L143 467L144 468C151 475 162 475 168 468L205 432L246 444C264 450 277 439 282 434ZM417 37C422 33 435 27 445 38L506 98C514 106 514 118 507 127L318 343L201 226L417 37ZM87 480H46L94 430L100 424L121 445L87 480ZM196 395L156 435L109 388L149 348L143 330L131 289C130 288 131 287 132 286L177 247L297 368L258 413C258 413 257 414 256 414H255L214 401L196 395ZM560 480H240C231 480 224 487 224 496C224 505 231 512 240 512H560C569 512 576 505 576 496C576 487 569 480 560 480Z"]
  };
  var faHippo = {
    prefix: 'fal',
    iconName: 'hippo',
    icon: [640, 512, [], "f6ed", "M572 96C562 96 551 98 542 103L505 121C490 87 455 64 416 64C391 64 369 74 352 89V48C352 39 345 32 336 32S320 39 320 48V96C293 75 258 64 224 64H176C79 64 0 143 0 240V432C0 458 22 480 48 480H80C106 480 128 458 128 432V390C151 396 179 400 208 400S265 396 288 390V432C288 458 310 480 336 480H368C394 480 416 458 416 432V288H576V320C576 329 583 336 592 336S608 329 608 320V285C627 278 640 261 640 240V164C640 126 610 96 572 96ZM608 240C608 249 601 256 592 256H400C391 256 384 263 384 272V432C384 441 377 448 368 448H336C327 448 320 441 320 432V378C323 376 326 374 329 373C336 368 338 358 333 350S318 341 311 346C291 359 251 368 208 368S125 359 105 346C98 341 88 343 83 350S80 368 87 372C90 374 93 376 96 378V432C96 441 89 448 80 448H48C39 448 32 441 32 432V240C32 161 97 96 176 96H224C252 96 279 105 301 122L320 136V160C320 169 327 176 336 176S352 169 352 160C352 125 381 96 416 96C447 96 474 118 480 147L484 168L556 132C561 129 567 128 572 128C592 128 608 144 608 164V240ZM432 144C423 144 416 151 416 160C416 169 423 176 432 176S448 169 448 160C448 151 441 144 432 144Z"]
  };
  var faHockeyMask = {
    prefix: 'fal',
    iconName: 'hockey-mask',
    icon: [448, 512, [], "f6ee", "M377 54C335 18 280 0 224 0C168 0 113 18 71 54C7 110 -31 224 33 416C65 512 224 512 224 512S383 512 415 416C479 224 441 110 377 54ZM385 406C365 466 262 480 224 480C186 480 83 466 63 406C-5 203 52 114 92 79C126 49 174 32 224 32S322 49 356 79C396 114 453 203 385 406ZM288 96C297 96 304 89 304 80S297 64 288 64C279 64 272 71 272 80S279 96 288 96ZM160 96C169 96 176 89 176 80C176 71 169 64 160 64C151 64 144 71 144 80C144 89 151 96 160 96ZM160 160H96C70 160 48 182 48 208C48 252 84 288 128 288S208 252 208 208C208 182 186 160 160 160ZM128 256C102 256 80 234 80 208C80 199 87 192 96 192H160C169 192 176 199 176 208C176 234 154 256 128 256ZM176 432C167 432 160 439 160 448C160 457 167 464 176 464C185 464 192 457 192 448C192 439 185 432 176 432ZM176 400C185 400 192 393 192 384S185 368 176 368C167 368 160 375 160 384S167 400 176 400ZM176 336C185 336 192 329 192 320C192 311 185 304 176 304C167 304 160 311 160 320C160 329 167 336 176 336ZM224 112C215 112 208 119 208 128S215 144 224 144S240 137 240 128S233 112 224 112ZM272 432C263 432 256 439 256 448S263 464 272 464C281 464 288 457 288 448S281 432 272 432ZM272 368C263 368 256 375 256 384S263 400 272 400C281 400 288 393 288 384S281 368 272 368ZM272 336C281 336 288 329 288 320C288 311 281 304 272 304C263 304 256 311 256 320C256 329 263 336 272 336ZM352 160H288C262 160 240 182 240 208C240 252 276 288 320 288S400 252 400 208C400 182 378 160 352 160ZM320 256C294 256 272 234 272 208C272 199 279 192 288 192H352C361 192 368 199 368 208C368 234 346 256 320 256Z"]
  };
  var faHockeyPuck = {
    prefix: 'fal',
    iconName: 'hockey-puck',
    icon: [512, 512, [], "f453", "M256 80C129 80 0 113 0 176V336C0 399 129 432 256 432S512 399 512 336V176C512 113 383 80 256 80ZM256 112C393 112 480 150 480 176S393 240 256 240S32 202 32 176S119 112 256 112ZM256 400C119 400 32 362 32 336V225C78 256 167 272 256 272S434 256 480 225V336C480 362 393 400 256 400Z"]
  };
  var faHockeySticks = {
    prefix: 'fal',
    iconName: 'hockey-sticks',
    icon: [640, 512, [], "f454", "M227 215C229 221 235 224 241 224C243 224 246 223 248 222C256 218 259 209 255 201L162 61C157 51 161 39 171 34C180 29 192 33 197 43L269 137C273 144 283 147 291 143C298 139 301 129 297 122L225 28C212 3 181 -7 156 5C131 18 121 50 133 75L227 215ZM592 336H400C391 336 384 343 384 352S391 368 400 368H528V480H424C405 480 389 470 381 453L370 432C366 424 356 421 349 425S337 439 341 447L352 468C366 495 393 512 424 512H592C618 512 640 490 640 464V384C640 358 618 336 592 336ZM608 464C608 473 601 480 592 480H560V368H592C601 368 608 375 608 384V464ZM483 5C458 -7 427 3 414 28L230 336H48C22 336 0 358 0 384V464C0 490 22 512 48 512H216C247 512 274 495 288 468L506 75C519 50 509 18 483 5ZM80 480H48C39 480 32 473 32 464V384C32 375 39 368 48 368H80V480ZM478 61L259 453C251 470 235 480 216 480H112V368H240C246 368 251 365 254 359L442 43C447 33 459 29 469 34C479 39 483 51 478 61Z"]
  };
  var faHollyBerry = {
    prefix: 'fal',
    iconName: 'holly-berry',
    icon: [512, 512, [], "f7aa", "M357 205C373 199 386 188 394 172C401 157 402 139 396 123C390 106 377 92 361 85C352 82 343 86 340 94C336 102 340 111 348 115C357 118 363 125 366 134C369 142 369 151 365 158C361 166 355 172 347 175C330 181 312 172 306 155C303 147 294 142 285 145C277 148 273 157 276 165C285 192 310 208 336 208C343 208 350 207 357 205ZM155 205C162 207 169 208 176 208C202 208 227 192 236 165C239 157 235 148 227 145C218 142 209 146 206 155C200 172 182 180 165 175C157 172 151 166 147 158C143 151 143 142 146 134C149 125 155 118 164 115C172 111 176 102 172 94C169 86 160 82 151 85C135 92 122 106 116 123C110 139 111 157 118 172C126 188 139 199 155 205ZM320 64C320 29 291 0 256 0S192 29 192 64S221 128 256 128S320 99 320 64ZM256 96C238 96 224 82 224 64S238 32 256 32S288 46 288 64S274 96 256 96ZM245 258C246 247 242 237 233 230C224 223 212 222 202 227C170 241 137 248 104 248C103 248 101 248 100 248C91 248 82 252 77 260C71 267 69 277 72 286C76 299 79 312 81 325C82 331 77 337 71 338C58 340 46 341 33 341C32 341 32 341 30 341C20 341 11 346 6 354C0 361 -1 371 2 380C12 410 15 442 11 475C10 487 15 498 24 505C30 510 37 512 45 512C49 512 54 511 58 509C89 496 120 490 152 490C153 490 155 490 155 490C165 490 174 485 179 478C185 470 187 460 184 451C180 439 177 426 175 412C174 406 178 401 185 400C199 397 212 396 226 396C236 397 245 392 250 384C256 376 258 366 255 358C244 327 241 293 245 258ZM100 280C100 280 100 280 100 280L100 280V280ZM179 368C156 372 140 393 143 416C145 431 148 445 152 458C116 458 80 465 43 479C47 442 44 407 33 373C48 373 62 372 77 369C100 365 116 344 113 321C111 307 108 293 104 280H104C141 280 179 272 213 256C209 293 212 330 223 364C209 364 194 366 179 368ZM506 354C501 346 492 341 482 341H482C469 341 454 340 441 338C435 337 430 331 431 325C433 312 436 299 440 286C443 277 441 267 435 260C430 252 421 248 412 248H411C378 249 343 241 310 227C302 223 293 227 289 235C286 243 289 252 298 256C333 272 371 280 408 280H408C404 293 401 307 399 321C396 344 412 365 435 369C450 372 464 373 479 373C468 407 465 442 466 480C432 465 396 458 360 458C364 445 367 431 369 417C370 412 371 397 359 383C348 371 330 364 304 364H304C295 364 288 371 288 380C288 389 295 396 304 396H304C319 396 330 399 335 404C338 408 337 412 337 412C335 426 332 439 328 451C325 460 327 470 333 478C338 485 347 490 357 490C390 490 422 496 454 509C458 511 463 512 467 512C475 512 482 510 488 505C497 498 502 487 501 475C497 442 500 410 511 380C513 371 512 361 506 354ZM359 461L359 461L359 461L359 461Z"]
  };
  var faHome = {
    prefix: 'fal',
    iconName: 'home',
    icon: [576, 512, [], "f015", "M571 244L299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V464C64 490 86 512 112 512H192C218 512 240 490 240 464V352H336V464C336 490 358 512 384 512H464C490 512 512 490 512 464V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244ZM480 208V464C480 473 473 480 464 480H384C375 480 368 473 368 464V352C368 334 354 320 336 320H240C222 320 208 334 208 352V464C208 473 201 480 192 480H112C103 480 96 473 96 464V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208Z"]
  };
  var faHomeHeart = {
    prefix: 'fal',
    iconName: 'home-heart',
    icon: [576, 512, [], "f4c9", "M299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V432C64 476 100 512 144 512H432C476 512 512 476 512 432V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244L299 4ZM480 208V432C480 458 458 480 432 480H144C118 480 96 458 96 432V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208ZM198 237C170 260 169 301 193 326L278 412C284 417 292 417 298 412L383 326C407 301 406 260 378 237C364 226 331 209 288 252C245 209 212 226 198 237ZM257 266L288 297L319 266C327 258 344 250 358 262C372 274 370 293 360 304L288 376L216 304C206 293 204 274 218 262C232 250 249 258 257 266Z"]
  };
  var faHomeSimple = {
    prefix: 'fal',
    iconName: 'home-simple',
    icon: [576, 512, [], "f80a", "M571 244L299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V432C64 476 100 512 144 512H432C476 512 512 476 512 432V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244ZM480 208V432C480 458 458 480 432 480H144C118 480 96 458 96 432V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208Z"]
  };
  var faHomeUser = {
    prefix: 'fal',
    iconName: 'home-user',
    icon: [576, 512, [], "e147", "M256 352C212 352 176 388 176 432C176 441 183 448 192 448C201 448 208 441 208 432C208 406 230 384 256 384H320C347 384 368 406 368 432C368 441 375 448 384 448S400 441 400 432C400 388 364 352 320 352H256ZM224 256C224 291 253 320 288 320S352 291 352 256S323 192 288 192S224 221 224 256ZM320 256C320 274 306 288 288 288C270 288 256 274 256 256S270 224 288 224C306 224 320 238 320 256ZM299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V432C64 476 100 512 144 512H432C476 512 512 476 512 432V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244L299 4ZM480 208V432C480 458 458 480 432 480H144C118 480 96 458 96 432V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208Z"]
  };
  var faHoodCloak = {
    prefix: 'fal',
    iconName: 'hood-cloak',
    icon: [576, 512, [], "f6ef", "M570 461C512 384 512 320 512 320V256C512 172 466 133 411 73L451 34C463 21 454 0 437 0H288C192 0 64 110 64 256V320C64 320 64 384 6 461C-9 482 6 512 32 512H544C570 512 585 482 570 461ZM192 480V320C192 267 235 224 288 224C341 224 384 267 384 320V480H192ZM416 480V320C416 249 359 192 288 192C217 192 160 249 160 320V480H32C95 395 96 323 96 320V256C96 126 211 32 288 32H407L367 72C367 72 399 108 405 114C450 162 480 194 480 256V320C480 323 481 395 544 480H416Z"]
  };
  var faHorizontalRule = {
    prefix: 'fal',
    iconName: 'horizontal-rule',
    icon: [640, 512, [], "f86c", "M624 272H16C7 272 0 265 0 256S7 240 16 240H624C633 240 640 247 640 256S633 272 624 272Z"]
  };
  var faHorse = {
    prefix: 'fal',
    iconName: 'horse',
    icon: [576, 512, [], "f6f0", "M480 80C471 80 464 87 464 96S471 112 480 112S496 105 496 96S489 80 480 80ZM567 64C573 54 576 42 575 30C575 13 560 0 543 0L432 0C363 0 307 55 304 124V128H160C125 128 94 148 77 176C34 178 0 213 0 256V304C0 313 7 320 16 320S32 313 32 304V256C32 235 46 217 65 211C64 221 64 223 64 224C64 256 73 275 89 293L66 367C63 378 63 389 66 400L84 475C89 497 108 512 131 512H155C186 512 209 483 201 452L185 387L204 333L288 351V464C288 490 310 512 336 512H368C394 512 416 490 416 464V324C437 302 448 274 448 244V194L462 216C482 244 512 236 518 234L543 226C563 219 576 201 576 180V86C576 77 572 70 567 64ZM544 180C544 187 540 193 533 195L508 204C498 207 491 201 489 198L464 160L416 144V244C416 271 403 294 384 310V464C384 473 377 480 368 480H336C327 480 320 473 320 464V326L184 295L151 385L170 460C173 470 165 480 155 480H131C123 480 117 475 115 468L97 392C96 387 96 381 97 376L125 282C107 270 96 256 96 224C96 189 125 160 160 160H336V128C336 75 379 32 432 32H543C543 45 535 57 524 62L544 86V180Z"]
  };
  var faHorseHead = {
    prefix: 'fal',
    iconName: 'horse-head',
    icon: [512, 512, [], "f7ab", "M509 321L449 165C437 131 410 103 377 88C391 73 402 53 393 18C391 12 386 6 380 3C376 1 373 0 369 0C366 0 363 1 360 2C328 14 298 24 269 34C96 93 0 125 0 394V448C0 483 29 512 64 512H268C303 512 326 475 310 444L286 393C283 387 278 384 272 384C269 384 267 385 265 386C257 390 254 400 258 407L281 458C286 469 279 480 268 480H64C46 480 32 466 32 448V394C32 148 110 121 280 64C306 56 334 46 364 35C367 62 351 71 337 80L318 91L300 102L320 106L341 110C377 117 407 142 419 177L479 333C481 338 480 345 476 349L440 379C437 382 433 384 429 384H381C376 384 371 382 368 378L329 333C329 333 330 332 330 332C337 326 337 316 331 309C328 306 324 304 319 304C316 304 312 305 309 308C294 321 275 328 256 328C215 328 180 296 176 255C176 246 169 240 161 240H160L159 240C155 240 151 242 148 246C145 249 144 253 144 257C149 315 198 360 256 360C271 360 287 357 302 350L343 397C351 409 365 416 381 416H429C442 416 454 411 462 403L498 372C512 358 516 338 509 321ZM360 208C360 195 349 184 336 184S312 195 312 208C312 221 323 232 336 232S360 221 360 208Z"]
  };
  var faHorseSaddle = {
    prefix: 'fal',
    iconName: 'horse-saddle',
    icon: [576, 512, [], "f8c3", "M480 80C471 80 464 87 464 96S471 112 480 112S496 105 496 96S489 80 480 80ZM567 64C573 54 576 42 575 30C575 13 560 0 543 0L432 0C363 0 307 55 304 124V128H160C125 128 94 148 77 176C34 178 0 213 0 256V304C0 313 7 320 16 320S32 313 32 304V256C32 235 46 217 65 211C64 221 64 223 64 224C64 256 73 275 89 293L66 367C63 378 63 389 66 400L84 475C89 497 108 512 131 512H155C186 512 209 483 201 452L185 387L204 333L288 351V464C288 490 310 512 336 512H368C394 512 416 490 416 464V324C437 302 448 274 448 244V194L462 216C482 244 512 236 518 234L543 226C563 219 576 201 576 180V86C576 77 572 70 567 64ZM224 304L184 295L151 385L170 460C173 470 165 480 155 480H131C123 480 117 475 115 468L97 392C96 387 96 381 97 376L125 282C107 270 96 256 96 224C96 200 110 179 130 168C137 215 176 251 224 255V304ZM161 160H303C299 196 269 224 232 224S165 196 161 160ZM544 180C544 187 540 193 533 195L508 204C498 207 491 201 489 198L464 160L416 144V244C416 271 403 294 384 310V464C384 473 377 480 368 480H336C327 480 320 473 320 464V326L256 312V253C302 242 336 201 336 152V128C336 75 379 32 432 32H543C543 45 535 57 524 62L544 86V180Z"]
  };
  var faHospital = {
    prefix: 'fal',
    iconName: 'hospital',
    icon: [448, 512, [], "f0f8", "M432 480H416V48C416 22 394 0 368 0H80C54 0 32 22 32 48V480H16C7 480 0 487 0 496S7 512 16 512H176C185 512 192 505 192 496V384H256V496C256 505 263 512 272 512H432C441 512 448 505 448 496S441 480 432 480ZM384 480H288V384C288 366 274 352 256 352H192C174 352 160 366 160 384V480H64V288H384V480ZM384 256H64V48C64 39 71 32 80 32H368C377 32 384 39 384 48V256ZM277 107H245V75C245 69 241 64 235 64H213C207 64 203 69 203 75V107H171C165 107 160 111 160 117V139C160 145 165 149 171 149H203V181C203 187 207 192 213 192H235C241 192 245 187 245 181V149H277C283 149 288 145 288 139V117C288 111 283 107 277 107Z"]
  };
  var faHospitalUser = {
    prefix: 'fal',
    iconName: 'hospital-user',
    icon: [640, 512, [], "f80d", "M304 320H32V256H304C313 256 320 249 320 240C320 231 313 224 304 224H32V48C32 39 39 32 48 32H336C345 32 352 39 352 48V112C352 121 359 128 368 128S384 121 384 112C384 103 384 48 384 48C384 22 362 0 336 0H48C22 0 0 22 0 48V496C0 505 7 512 16 512S32 505 32 496V448H272C281 448 288 441 288 432C288 423 281 416 272 416H32V352H304C313 352 320 345 320 336C320 327 313 320 304 320ZM480 320C533 320 576 277 576 224C576 171 533 128 480 128C427 128 384 171 384 224C384 277 427 320 480 320ZM480 160C515 160 544 189 544 224S515 288 480 288S416 259 416 224S445 160 480 160ZM181 192H203C209 192 213 187 213 181V149H245C251 149 256 145 256 139V117C256 111 251 107 245 107H213V75C213 69 209 64 203 64H181C175 64 171 69 171 75V107H139C133 107 128 111 128 117V139C128 145 133 149 139 149H171V181C171 187 175 192 181 192ZM512 352H448C377 352 320 409 320 480C320 498 334 512 352 512H608C626 512 640 498 640 480C640 409 583 352 512 352ZM352 480C352 427 395 384 448 384H512C565 384 608 427 608 480H352Z"]
  };
  var faHospitalWide = {
    prefix: 'fal',
    iconName: 'hospital-wide',
    icon: [576, 512, [], "f47d", "M528 96H448V48C448 22 426 0 400 0H176C150 0 128 22 128 48V96H48C22 96 0 118 0 144V496C0 505 7 512 16 512S32 505 32 496V352H544V496C544 505 551 512 560 512S576 505 576 496V144C576 118 554 96 528 96ZM544 320H32V256H544V320ZM544 224H32V144C32 135 39 128 48 128H144C153 128 160 121 160 112V48C160 39 167 32 176 32H400C409 32 416 39 416 48V112C416 121 423 128 432 128H528C537 128 544 135 544 144V224ZM320 384H256C238 384 224 398 224 416V496C224 505 231 512 240 512S256 505 256 496V416H320V496C320 505 327 512 336 512S352 505 352 496V416C352 398 338 384 320 384ZM341 107H309V75C309 69 305 64 299 64H277C271 64 267 69 267 75V107H235C229 107 224 111 224 117V139C224 145 229 149 235 149H267V181C267 187 271 192 277 192H299C305 192 309 187 309 181V149H341C347 149 352 145 352 139V117C352 111 347 107 341 107Z"]
  };
  var faHospitals = {
    prefix: 'fal',
    iconName: 'hospitals',
    icon: [640, 512, [], "f80e", "M213 107H181V75C181 69 177 64 171 64H149C143 64 139 69 139 75V107H107C101 107 96 111 96 117V139C96 145 101 149 107 149H139V181C139 187 143 192 149 192H171C177 192 181 187 181 181V149H213C219 149 224 145 224 139V117C224 111 219 107 213 107ZM272 0H48C22 0 0 22 0 48V496C0 505 7 512 16 512S32 505 32 496V448H288V496C288 505 295 512 304 512S320 505 320 496V48C320 22 298 0 272 0ZM288 416H32V352H288V416ZM288 320H32V256H288V320ZM288 224H32V48C32 39 39 32 48 32H272C281 32 288 39 288 48V224ZM592 0H368C359 0 352 7 352 16S359 32 368 32H592C601 32 608 39 608 48V224H368C359 224 352 231 352 240C352 249 359 256 368 256H608V320H368C359 320 352 327 352 336C352 345 359 352 368 352H608V416H368C359 416 352 423 352 432C352 441 359 448 368 448H608V496C608 505 615 512 624 512S640 505 640 496V48C640 22 618 0 592 0ZM491 64H469C463 64 459 69 459 75V107H427C421 107 416 111 416 117V139C416 145 421 149 427 149H459V181C459 187 463 192 469 192H491C497 192 501 187 501 181V149H533C539 149 544 145 544 139V117C544 111 539 107 533 107H501V75C501 69 497 64 491 64Z"]
  };
  var faHotTubPerson = {
    prefix: 'fal',
    iconName: 'hot-tub-person',
    icon: [512, 512, [], "f593", "M96 128C131 128 160 99 160 64S131 0 96 0C61 0 32 29 32 64S61 128 96 128ZM96 32C114 32 128 46 128 64S114 96 96 96S64 82 64 64S78 32 96 32ZM282 111C305 124 320 149 320 176C320 185 327 192 336 192S352 185 352 176C352 137 331 102 294 81C271 68 256 43 256 16C256 7 249 0 240 0S224 7 224 16C224 55 245 90 282 111ZM410 111C433 124 448 149 448 176C448 185 455 192 464 192S480 185 480 176C480 137 459 102 422 81C399 68 384 43 384 16C384 7 377 0 368 0S352 7 352 16C352 55 373 90 410 111ZM48 240C57 240 64 233 64 224C64 206 78 192 96 192H147C152 192 158 194 163 197L232 238C234 239 237 240 240 240C245 240 251 237 254 232C258 225 256 215 248 210L180 169C170 163 158 160 147 160H96C61 160 32 189 32 224C32 233 39 240 48 240ZM480 272H32C14 272 0 286 0 304V448C0 483 29 512 64 512H448C483 512 512 483 512 448V304C512 286 498 272 480 272ZM480 448C480 466 466 480 448 480H64C46 480 32 466 32 448V304H480V448ZM112 448C121 448 128 441 128 432V352C128 343 121 336 112 336S96 343 96 352V432C96 441 103 448 112 448ZM208 448C217 448 224 441 224 432V352C224 343 217 336 208 336S192 343 192 352V432C192 441 199 448 208 448ZM400 448C409 448 416 441 416 432V352C416 343 409 336 400 336S384 343 384 352V432C384 441 391 448 400 448ZM304 448C313 448 320 441 320 432V352C320 343 313 336 304 336S288 343 288 352V432C288 441 295 448 304 448Z"]
  };
  var faHotdog = {
    prefix: 'fal',
    iconName: 'hotdog',
    icon: [512, 512, [], "f80f", "M439 96C445 102 445 112 439 119C419 138 401 141 387 144C374 146 364 148 352 160S338 182 336 195C333 209 330 227 311 247S273 269 259 272C246 274 236 276 224 288S210 310 208 323C205 337 202 355 183 375S145 397 131 400C118 402 108 404 96 416C93 419 89 421 85 421C81 421 76 419 73 416C67 410 67 400 73 393C93 374 111 371 125 368C138 366 148 364 160 352S174 330 176 317C179 303 182 285 201 265S239 243 253 240C266 238 276 236 288 224S302 202 304 189C307 175 310 157 329 137S367 115 381 112C394 110 404 108 416 96C422 90 432 90 439 96ZM484 166L166 484C147 502 123 512 97 512S47 502 28 484C10 465 0 441 0 415S10 365 28 346L346 28C365 10 389 0 415 0S465 10 484 28C502 47 512 71 512 97S502 147 484 166ZM461 51C436 26 394 26 369 51L51 369C26 394 26 436 51 461S118 486 143 461L461 143C486 118 486 76 461 51ZM468 229C462 235 462 245 468 251C483 266 484 288 471 300L300 471C288 484 266 483 251 468C245 462 235 462 229 468S222 485 229 491C243 505 261 512 279 512C295 512 311 506 323 494L494 323C519 298 518 255 491 229C485 222 475 222 468 229ZM32 288C36 288 41 286 44 283C50 277 50 267 44 261C29 246 28 224 41 212L212 41C224 28 246 29 261 44C267 50 277 50 283 44S290 27 283 21C256 -6 214 -7 189 18L18 189C-7 214 -6 257 21 283C24 286 28 288 32 288Z"]
  };
  var faHotel = {
    prefix: 'fal',
    iconName: 'hotel',
    icon: [576, 512, [], "f594", "M272 288H304C322 288 336 274 336 256V224C336 206 322 192 304 192H272C254 192 240 206 240 224V256C240 274 254 288 272 288ZM272 224H304V256H272V224ZM272 160H304C322 160 336 146 336 128V96C336 78 322 64 304 64H272C254 64 240 78 240 96V128C240 146 254 160 272 160ZM272 96H304V128H272V96ZM144 160H176C194 160 208 146 208 128V96C208 78 194 64 176 64H144C126 64 112 78 112 96V128C112 146 126 160 144 160ZM144 96H176V128H144V96ZM144 288H176C194 288 208 274 208 256V224C208 206 194 192 176 192H144C126 192 112 206 112 224V256C112 274 126 288 144 288ZM144 224H176V256H144V224ZM400 160H432C450 160 464 146 464 128V96C464 78 450 64 432 64H400C382 64 368 78 368 96V128C368 146 382 160 400 160ZM400 96H432V128H400V96ZM400 288H432C450 288 464 274 464 256V224C464 206 450 192 432 192H400C382 192 368 206 368 224V256C368 274 382 288 400 288ZM400 224H432V256H400V224ZM560 480H544V32H560C569 32 576 25 576 16C576 7 569 0 560 0H16C7 0 0 7 0 16C0 25 7 32 16 32H32V480H16C7 480 0 487 0 496C0 505 7 512 16 512H256C265 512 272 505 272 496V416H304V496C304 505 311 512 320 512H560C569 512 576 505 576 496C576 487 569 480 560 480ZM512 480H336V416C336 398 322 384 304 384H272C254 384 240 398 240 416V480H64V32H512V480ZM200 398C208 402 218 399 222 392C236 367 261 352 288 352S340 367 354 392C357 397 362 400 368 400C371 400 373 399 376 398C384 394 386 384 382 376C363 342 327 320 288 320S213 342 194 376C190 384 193 394 200 398Z"]
  };
  var faHourglass = {
    prefix: 'fal',
    iconName: 'hourglass',
    icon: [384, 512, [], "f254", "M352 80C352 71 345 64 336 64S320 71 320 80C320 107 311 135 294 157L227 246C223 252 223 260 227 266L294 355C311 377 320 405 320 432C320 441 327 448 336 448S352 441 352 432C352 398 341 364 320 336L260 256L320 176C341 148 352 114 352 80ZM32 432C32 441 39 448 48 448S64 441 64 432C64 405 73 377 90 355L157 266C161 260 161 252 157 246L90 157C73 135 64 107 64 80C64 71 57 64 48 64S32 71 32 80C32 114 43 148 64 176L124 256L64 336C43 364 32 398 32 432ZM368 480H16C7 480 0 487 0 496S7 512 16 512H368C377 512 384 505 384 496S377 480 368 480ZM16 32H368C377 32 384 25 384 16S377 0 368 0H16C7 0 0 7 0 16S7 32 16 32ZM112 448H272C281 448 288 441 288 432C288 407 282 382 269 360C267 355 261 352 255 352H129C123 352 117 355 115 360C102 382 96 407 96 432C96 441 103 448 112 448ZM139 384H246C250 394 253 405 255 416H129C131 405 134 394 139 384ZM180 234C183 238 187 240 192 240S201 238 204 234L254 175C259 168 264 161 269 152C272 147 272 141 269 136S261 128 255 128H129C123 128 118 131 115 136S112 147 115 152C120 161 125 168 130 175L180 234ZM225 160L192 199L159 160H225Z"]
  };
  var faHourglassEmpty = {
    prefix: 'fal',
    iconName: 'hourglass-empty',
    icon: [384, 512, [], "f252", "M16 32H368C377 32 384 25 384 16S377 0 368 0H16C7 0 0 7 0 16S7 32 16 32ZM352 80C352 71 345 64 336 64S320 71 320 80C320 107 311 135 294 157L227 246C223 252 223 260 227 266L294 355C311 377 320 405 320 432C320 441 327 448 336 448S352 441 352 432C352 398 341 364 320 336L260 256L320 176C341 148 352 114 352 80ZM32 432C32 441 39 448 48 448S64 441 64 432C64 405 73 377 90 355L157 266C161 260 161 252 157 246L90 157C73 135 64 107 64 80C64 71 57 64 48 64S32 71 32 80C32 114 43 148 64 176L124 256L64 336C43 364 32 398 32 432ZM368 480H16C7 480 0 487 0 496S7 512 16 512H368C377 512 384 505 384 496S377 480 368 480Z"]
  };
  var faHourglassEnd = {
    prefix: 'fal',
    iconName: 'hourglass-end',
    icon: [384, 512, [], "f253", "M32 432C32 441 39 448 48 448S64 441 64 432C64 405 73 377 90 355L157 266C161 260 161 252 157 246L90 157C73 135 64 107 64 80C64 71 57 64 48 64S32 71 32 80C32 114 43 148 64 176L124 256L64 336C43 364 32 398 32 432ZM16 32H368C377 32 384 25 384 16S377 0 368 0H16C7 0 0 7 0 16S7 32 16 32ZM352 80C352 71 345 64 336 64S320 71 320 80C320 107 311 135 294 157L227 246C223 252 223 260 227 266L294 355C311 377 320 405 320 432C320 441 327 448 336 448S352 441 352 432C352 398 341 364 320 336L260 256L320 176C341 148 352 114 352 80ZM368 480H16C7 480 0 487 0 496S7 512 16 512H368C377 512 384 505 384 496S377 480 368 480ZM112 448H272C281 448 288 441 288 432C288 397 276 363 254 337L204 278C198 270 186 270 180 278L130 337C108 363 96 397 96 432C96 441 103 448 112 448ZM155 357L192 313L229 357C243 374 252 395 255 416H129C132 395 141 374 155 357Z"]
  };
  var faHourglassStart = {
    prefix: 'fal',
    iconName: 'hourglass-start',
    icon: [384, 512, [], "f251", "M32 432C32 441 39 448 48 448S64 441 64 432C64 405 73 377 90 355L157 266C161 260 161 252 157 246L90 157C73 135 64 107 64 80C64 71 57 64 48 64S32 71 32 80C32 114 43 148 64 176L124 256L64 336C43 364 32 398 32 432ZM16 32H368C377 32 384 25 384 16S377 0 368 0H16C7 0 0 7 0 16S7 32 16 32ZM352 80C352 71 345 64 336 64S320 71 320 80C320 107 311 135 294 157L227 246C223 252 223 260 227 266L294 355C311 377 320 405 320 432C320 441 327 448 336 448S352 441 352 432C352 398 341 364 320 336L260 256L320 176C341 148 352 114 352 80ZM368 480H16C7 480 0 487 0 496S7 512 16 512H368C377 512 384 505 384 496S377 480 368 480ZM192 240C197 240 201 238 204 234L254 175C276 149 288 115 288 80C288 71 281 64 272 64H112C103 64 96 71 96 80C96 115 108 149 130 175L180 234C183 238 187 240 192 240ZM129 96H255C252 117 243 138 229 155L192 199L155 155C141 138 132 117 129 96Z"]
  };
  var faHouse = {
    prefix: 'fal',
    iconName: 'house',
    icon: [576, 512, [], "e00d", "M571 244L512 192C512 192 512 192 512 192V48C512 39 505 32 496 32H400C391 32 384 39 384 48V79L299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V432C64 476 100 512 144 512H432C476 512 512 476 512 432V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244ZM416 64H480V164L416 108V64ZM480 208V432C480 458 458 480 432 480H144C118 480 96 458 96 432V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208ZM208 219V325C208 340 220 352 235 352H342C356 352 368 340 368 325V219C368 204 356 192 342 192H235C220 192 208 204 208 219ZM240 224H336V320H240V224Z"]
  };
  var faHouseCrack = {
    prefix: 'fal',
    iconName: 'house-crack',
    icon: [576, 512, [], "f6f1", "M285 247C280 240 270 238 263 243C256 248 254 258 259 265L311 343L235 369C230 370 227 374 225 378C223 383 224 388 226 392L290 504C293 509 298 512 304 512C307 512 309 511 312 510C320 506 322 496 318 488L264 393L341 367C346 366 350 362 351 357C353 352 352 347 349 343L285 247ZM571 244L512 192C512 192 512 192 512 192V48C512 39 505 32 496 32H400C391 32 384 39 384 48V79L299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V432C64 476 100 512 144 512H208C217 512 224 505 224 496S217 480 208 480H144C118 480 96 458 96 432V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208V432C480 458 458 480 432 480H400C391 480 384 487 384 496S391 512 400 512H432C476 512 512 476 512 432V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244ZM480 164L416 108V64H480V164Z"]
  };
  var faHouseDay = {
    prefix: 'fal',
    iconName: 'house-day',
    icon: [640, 512, [], "e00e", "M336 277V363C336 374 346 384 358 384H443C455 384 464 374 464 363V277C464 266 455 256 443 256H358C346 256 336 265 336 277ZM368 288H432V352H368V288ZM635 296L576 245V144C576 135 569 128 560 128S544 135 544 144V217L411 100C405 95 396 95 390 100L166 296C159 302 158 312 164 319C170 325 180 326 187 320L224 287V448C224 483 253 512 288 512H512C548 512 576 483 576 448V287L614 320C621 326 630 325 636 318C642 312 641 302 635 296ZM544 448C544 466 530 480 512 480H288C270 480 256 466 256 448V264C256 263 256 261 255 260L400 133L544 259V448ZM175 227C178 218 174 209 165 206C153 202 144 190 144 176C144 158 158 144 176 144C190 144 202 153 206 165C209 174 218 178 227 175C235 172 239 163 236 155C227 129 203 112 176 112C141 112 112 141 112 176C112 203 129 227 155 236C156 237 158 237 160 237C167 237 173 233 175 227ZM176 80C185 80 192 73 192 64V16C192 7 185 0 176 0S160 7 160 16V64C160 73 167 80 176 80ZM80 176C80 167 73 160 64 160H16C7 160 0 167 0 176S7 192 16 192H64C73 192 80 185 80 176ZM85 108C89 111 93 113 97 113S105 111 108 108C114 102 114 92 108 86L74 52C68 45 58 45 52 52S45 68 52 74L85 108ZM85 244L52 278C45 284 45 294 52 300C55 304 59 305 63 305S71 304 74 300L108 266C114 260 114 250 108 244S92 238 85 244ZM255 113C259 113 263 111 267 108L300 74C307 68 307 58 300 52S284 45 278 52L244 86C238 92 238 102 244 108C247 111 251 113 255 113Z"]
  };
  var faHouseFlood = {
    prefix: 'fal',
    iconName: 'house-flood',
    icon: [576, 512, [], "f74f", "M562 479C534 475 509 461 493 439C487 430 473 430 467 439C449 465 418 480 384 480C351 480 319 465 301 439C295 430 281 430 275 439C257 465 226 480 192 480C159 480 127 465 109 439C106 434 101 432 96 432C91 432 86 434 83 439C67 461 42 475 14 479C5 480 -1 488 0 497C1 506 9 512 18 511C48 507 76 493 96 473C121 498 155 512 192 512C229 512 263 498 288 473C313 498 347 512 384 512C421 512 455 498 480 473C500 493 528 507 558 511C567 512 575 506 576 497C577 488 571 480 562 479ZM235 192C220 192 208 204 208 219V325C208 340 220 352 235 352H342C356 352 368 340 368 325V219C368 204 356 192 342 192H235ZM336 320H240V224H336V320ZM27 268L64 235V368C64 377 71 384 80 384S96 377 96 368V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208V368C480 377 487 384 496 384C505 384 512 377 512 368V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244L512 192C512 192 512 192 512 192V48C512 39 505 32 496 32H400C391 32 384 39 384 48V79L299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268ZM416 64H480V164L416 108V64Z"]
  };
  var faHouseHeart = {
    prefix: 'fal',
    iconName: 'house-heart',
    icon: [576, 512, [], "e148", "M571 244L512 192C512 192 512 192 512 192V48C512 39 505 32 496 32H400C391 32 384 39 384 48V79L299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V432C64 476 100 512 144 512H432C476 512 512 476 512 432V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244ZM416 64H480V164L416 108V64ZM480 208V432C480 458 458 480 432 480H144C118 480 96 458 96 432V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208ZM198 237C170 260 169 301 193 326L278 412C284 417 292 417 298 412L383 326C407 301 406 260 378 237C364 226 331 209 288 252C245 209 212 226 198 237ZM257 266L288 297L319 266C327 258 344 250 358 262C372 274 370 293 360 304L288 376L216 304C206 293 204 274 218 262C232 250 249 258 257 266Z"]
  };
  var faHouseLaptop = {
    prefix: 'fal',
    iconName: 'house-laptop',
    icon: [640, 512, [], "e066", "M272 304V432C272 441 279 448 288 448S304 441 304 432V304C304 295 311 288 320 288H544C553 288 560 295 560 304V432C560 441 567 448 576 448S592 441 592 432V304C592 278 570 256 544 256H320C294 256 272 278 272 304ZM608 480H256C247 480 240 487 240 496S247 512 256 512H608C617 512 624 505 624 496S617 480 608 480ZM192 384H96C87 384 80 377 80 368L80 171L224 38L421 220C424 223 428 224 432 224C436 224 441 222 444 219C450 212 449 202 443 196L400 157V64C400 55 393 48 384 48S368 55 368 64V127L235 4C229 -1 219 -1 213 4L5 196C-1 202 -2 212 4 219C10 225 20 226 27 220L48 200V368C48 394 69 416 96 416H192C201 416 208 409 208 400V400C208 391 201 384 192 384ZM224 272H192V208H256C256 217 263 224 272 224S288 217 288 208V192C288 183 281 176 272 176H176C167 176 160 183 160 192V288C160 297 167 304 176 304H224C233 304 240 297 240 288C240 279 233 272 224 272Z"]
  };
  var faHouseMedical = {
    prefix: 'fal',
    iconName: 'house-medical',
    icon: [576, 512, [], "f7f2", "M571 244L512 192C512 192 512 192 512 192V48C512 39 505 32 496 32H400C391 32 384 39 384 48V79L299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V432C64 476 100 512 144 512H432C476 512 512 476 512 432V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244ZM416 64H480V164L416 108V64ZM480 208V432C480 458 458 480 432 480H144C118 480 96 458 96 432V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208ZM256 208V256H208C199 256 192 263 192 272V304C192 313 199 320 208 320H256V368C256 377 263 384 272 384H304C313 384 320 377 320 368V320H368C377 320 384 313 384 304V272C384 263 377 256 368 256H320V208C320 199 313 192 304 192H272C263 192 256 199 256 208Z"]
  };
  var faHouseNight = {
    prefix: 'fal',
    iconName: 'house-night',
    icon: [640, 512, [], "e010", "M112 224C146 224 178 209 199 182C204 176 205 166 201 159C196 152 188 148 179 150C151 155 122 139 113 112C102 85 114 54 139 40C146 36 150 27 149 19C147 10 141 3 132 2C126 1 119 0 112 0C50 0 0 50 0 112S50 224 112 224ZM34 94C41 63 66 39 98 33C77 58 71 92 82 123S120 176 152 181C125 197 90 195 65 176C39 157 27 125 34 94ZM336 277V363C336 374 346 384 358 384H443C455 384 464 374 464 363V277C464 266 455 256 443 256H358C346 256 336 265 336 277ZM368 288H432V352H368V288ZM635 296L576 245V144C576 135 569 128 560 128S544 135 544 144V217L411 100C405 95 396 95 390 100L166 296C159 302 158 312 164 319C170 325 180 326 187 320L224 287V448C224 483 253 512 288 512H512C548 512 576 483 576 448V287L614 320C621 326 630 325 636 318C642 312 641 302 635 296ZM544 448C544 466 530 480 512 480H288C270 480 256 466 256 448V264C256 263 256 261 255 260L400 133L544 259V448ZM208 80H240V112C240 121 247 128 256 128S272 121 272 112V80H304C313 80 320 73 320 64S313 48 304 48H272V16C272 7 265 0 256 0S240 7 240 16V48H208C199 48 192 55 192 64S199 80 208 80ZM144 368H112V336C112 327 105 320 96 320S80 327 80 336V368H48C39 368 32 375 32 384S39 400 48 400H80V432C80 441 87 448 96 448S112 441 112 432V400H144C153 400 160 393 160 384S153 368 144 368Z"]
  };
  var faHousePersonLeave = {
    prefix: 'fal',
    iconName: 'house-person-leave',
    icon: [640, 512, [], "e00f", "M341 107L341 107C347 101 347 90 340 84L250 4C244 -1 235 -1 229 4L5 200C-1 206 -2 216 4 223C10 229 20 230 26 224L64 191V368C64 395 85 416 112 416H288C297 416 304 409 304 400V400C304 391 297 384 288 384H112C103 384 96 377 96 368L96 163L240 37L319 108C325 114 335 113 341 107ZM181 160C169 160 160 170 160 181V267C160 278 170 288 181 288H267C278 288 288 279 288 267V181C288 170 278 160 267 160H181ZM256 256H192V192H256V256ZM438 353C429 350 420 354 417 362L395 422L325 484C319 490 318 500 324 507C327 510 332 512 336 512C340 512 344 511 347 508L419 443C421 441 423 439 424 437L447 374C450 365 446 356 438 353ZM634 275L576 232V202C576 170 552 143 521 138L475 132C456 129 437 131 419 138L392 149C369 158 351 179 345 204L337 236C334 245 340 253 348 256C357 258 365 252 368 244L376 212C379 197 390 184 404 179L431 168C436 166 441 165 446 164L426 245C419 275 430 307 454 326L533 390C535 393 537 396 538 399L560 499C562 507 569 512 576 512C577 512 578 512 579 512C588 510 594 501 592 493L569 392C567 382 561 372 553 366L474 301C459 290 453 270 457 252L479 165L516 170C532 172 544 186 544 202V240C544 245 546 250 550 253L614 301C617 303 621 304 624 304C629 304 634 302 637 298C642 291 641 281 634 275ZM536 112C567 112 592 87 592 56S567 0 536 0S480 25 480 56S505 112 536 112ZM536 32C549 32 560 43 560 56S549 80 536 80S512 69 512 56S523 32 536 32Z"]
  };
  var faHousePersonReturn = {
    prefix: 'fal',
    iconName: 'house-person-return',
    icon: [640, 512, [], "e011", "M181 160C169 160 160 170 160 181V267C160 278 170 288 181 288H267C278 288 288 279 288 267V181C288 170 278 160 267 160H181ZM256 256H192V192H256V256ZM341 107L341 107C347 101 347 90 340 84L250 4C244 -1 235 -1 229 4L5 200C-1 206 -2 216 4 223C10 229 20 230 26 224L64 191V368C64 395 85 416 112 416H288C297 416 304 409 304 400V400C304 391 297 384 288 384H112C103 384 96 377 96 368L96 163L240 37L319 108C325 114 335 113 341 107ZM424 112C455 112 480 87 480 56S455 0 424 0S368 25 368 56S393 112 424 112ZM424 32C437 32 448 43 448 56S437 80 424 80S400 69 400 56S411 32 424 32ZM635 484L565 422L543 362C540 354 531 350 522 353C514 356 510 365 513 374L536 437C537 439 539 441 541 443L613 508C616 511 620 512 624 512C628 512 633 510 636 507C642 500 641 490 635 484ZM534 245L514 164C519 165 524 166 529 168L556 179C570 184 581 197 584 212L592 244C595 252 603 258 612 256C620 253 626 245 624 236L615 204C609 179 591 159 568 149L541 138C523 131 504 129 485 132L439 138C408 143 384 170 384 202V232L326 275C319 281 318 291 323 298C326 302 331 304 336 304C339 304 343 303 346 301L410 253C414 250 416 245 416 240V202C416 186 428 172 443 170L481 165L503 252C507 270 501 290 486 301L407 366C399 372 393 382 391 392L368 493C366 501 372 510 381 512C382 512 383 512 384 512C391 512 398 507 400 499L422 399C423 396 425 393 427 390L506 326C530 307 541 275 534 245Z"]
  };
  var faHouseSignal = {
    prefix: 'fal',
    iconName: 'house-signal',
    icon: [640, 512, [], "e012", "M16 412C7 412 0 419 0 428S7 444 16 444C42 444 64 466 64 492C64 501 71 508 80 508S96 501 96 492C96 448 60 412 16 412ZM16 220C7 220 0 227 0 236S7 252 16 252C148 252 256 360 256 492C256 501 263 508 272 508S288 501 288 492C288 342 166 220 16 220ZM16 316C7 316 0 323 0 332S7 348 16 348C95 348 160 413 160 492C160 501 167 508 176 508S192 501 192 492C192 395 113 316 16 316ZM635 196L576 145V45C576 37 571 29 563 28C553 27 544 34 544 44V117L411 0C405 -5 396 -5 390 0L224 145L166 196C161 200 159 206 160 211C161 217 165 222 171 223C176 225 182 224 187 220L224 187L224 236C224 245 231 252 240 252C249 252 256 245 256 236L256 164C256 163 256 161 255 160L400 33L544 159V364C544 373 537 380 528 380H336C327 380 320 387 320 396V396C320 405 327 412 336 412H528C555 412 576 391 576 364V187L614 220C620 226 630 225 636 218C642 212 641 202 635 196ZM443 284C455 284 464 274 464 263V177C464 166 455 156 443 156H358C346 156 336 166 336 177V263C336 275 346 284 358 284H443ZM368 188H432V252H368V188Z"]
  };
  var faHouseUser = {
    prefix: 'fal',
    iconName: 'house-user',
    icon: [576, 512, [], "e065", "M256 352C212 352 176 388 176 432C176 441 183 448 192 448C201 448 208 441 208 432C208 405 230 384 256 384H320C347 384 368 406 368 432C368 441 375 448 384 448S400 441 400 432C400 388 364 352 320 352H256ZM224 256C224 291 253 320 288 320S352 291 352 256S323 192 288 192S224 221 224 256ZM320 256C320 274 306 288 288 288S256 274 256 256S270 224 288 224S320 238 320 256ZM571 244L512 192C512 192 512 192 512 192V48C512 39 505 32 496 32H400C391 32 384 39 384 48V79L299 4C293 -1 283 -1 277 4L5 244C-1 250 -2 260 4 267C10 273 20 274 27 268L64 235V432C64 476 100 512 144 512H432C476 512 512 476 512 432V235L549 268C552 271 556 272 560 272C564 272 569 270 572 267C578 260 577 250 571 244ZM416 64H480V164L416 108V64ZM480 208V432C480 458 458 480 432 480H144C118 480 96 458 96 432V208C96 208 96 207 96 207L288 37L480 207C480 207 480 208 480 208Z"]
  };
  var faHryvniaSign = {
    prefix: 'fal',
    iconName: 'hryvnia-sign',
    icon: [384, 512, [], "f6f2", "M384 304C384 313 377 320 368 320H133L103 342C89 353 80 371 80 389C80 422 106 448 139 448H198C233 448 266 438 295 419C302 414 312 416 317 423C322 430 320 440 313 445C279 468 239 480 198 480H139C89 480 48 439 48 389C48 363 60 337 81 320H16C7 320 0 313 0 304S7 288 16 288H123L208 224H16C7 224 0 217 0 208S7 192 16 192H251L281 170C295 159 304 141 304 123C304 90 278 64 245 64H186C151 64 118 74 89 93C81 98 72 96 67 89C62 82 64 72 71 67C105 44 145 32 186 32H245C295 32 336 73 336 123C336 149 324 175 303 192H368C377 192 384 199 384 208S377 224 368 224H261L176 288H368C377 288 384 295 384 304Z"]
  };
  var faHurricane = {
    prefix: 'fal',
    iconName: 'hurricane',
    icon: [448, 512, [], "f751", "M256 400C256 391 249 384 240 384C143 384 64 305 64 208C64 118 131 42 219 32C228 31 234 23 233 14C232 5 223 -1 215 0C111 13 32 102 32 208C32 323 125 416 240 416C249 416 256 409 256 400ZM208 96C199 96 192 103 192 112C192 121 199 128 208 128C305 128 384 207 384 304C384 394 317 470 229 480C220 481 214 489 215 498C216 506 223 512 231 512C232 512 232 512 233 512C337 499 416 410 416 304C416 189 323 96 208 96ZM224 336C267 336 303 300 303 256C303 212 267 176 224 176S145 212 145 256C145 300 181 336 224 336ZM224 208C250 208 271 230 271 256C271 282 250 304 224 304S177 282 177 256C177 230 198 208 224 208Z"]
  };
  var faI = {
    prefix: 'fal',
    iconName: 'i',
    icon: [320, 512, [], "e149", "M320 464C320 473 313 480 304 480H16C7 480 0 473 0 464S7 448 16 448H144V64H16C7 64 0 57 0 48S7 32 16 32H304C313 32 320 39 320 48S313 64 304 64H176V448H304C313 448 320 455 320 464Z"]
  };
  var faICursor = {
    prefix: 'fal',
    iconName: 'i-cursor',
    icon: [256, 512, [], "f246", "M256 496C256 505 249 512 240 512C191 512 150 485 128 445C106 485 65 512 16 512C7 512 0 505 0 496S7 480 16 480C69 480 112 437 112 384V272H64C55 272 48 265 48 256S55 240 64 240H112V128C112 75 69 32 16 32C7 32 0 25 0 16S7 0 16 0C65 0 106 27 128 67C150 27 191 0 240 0C249 0 256 7 256 16S249 32 240 32C187 32 144 75 144 128V240H192C201 240 208 247 208 256S201 272 192 272H144V384C144 437 187 480 240 480C249 480 256 487 256 496Z"]
  };
  var faIceCream = {
    prefix: 'fal',
    iconName: 'ice-cream',
    icon: [448, 512, [], "f810", "M381 129C367 56 302 0 224 0S81 56 67 129C26 136 -3 173 0 215S38 288 80 288H86H121H327H362H368C410 288 444 256 448 215S422 136 381 129ZM368 256H80C55 256 34 237 32 212C30 187 47 165 72 161L94 157L98 135C110 75 163 32 224 32S338 75 350 135L354 157L376 161C401 165 418 187 416 212C414 237 393 256 368 256ZM334 343L265 484C256 501 241 512 224 512S192 501 183 484L114 343C110 335 113 326 121 322C129 318 138 321 142 329L212 470C218 483 230 483 236 470L306 329C310 321 319 318 327 322C335 326 338 335 334 343Z"]
  };
  var faIceSkate = {
    prefix: 'fal',
    iconName: 'ice-skate',
    icon: [576, 512, [], "f7ac", "M560 416C551 416 544 423 544 432C544 458 522 480 496 480H416V464C416 455 409 448 400 448S384 455 384 464V480H128V464C128 455 121 448 112 448S96 455 96 464V480H16C7 480 0 487 0 496S7 512 16 512H496C540 512 576 476 576 432C576 423 569 416 560 416ZM96 416H448C483 416 512 387 512 352V315C512 271 482 233 439 222L320 192V16C320 7 313 0 304 0C295 0 288 7 288 16V32H282C223 32 164 43 109 65L62 84C44 91 32 109 32 129V352C32 387 61 416 96 416ZM64 129C64 122 68 116 74 114L114 98C170 75 229 64 288 64V128H240C231 128 224 135 224 144S231 160 240 160H288V192H240C231 192 224 199 224 208S231 224 240 224H316L432 253C460 260 480 286 480 315V352C480 370 466 384 448 384H96C78 384 64 370 64 352V129Z"]
  };
  var faIcicles = {
    prefix: 'fal',
    iconName: 'icicles',
    icon: [512, 512, [], "f7ad", "M466 0H46C16 0 -7 29 2 60L91 309C93 316 99 321 106 320C113 320 120 315 121 308L145 231L180 403C182 411 188 416 196 416C204 416 210 411 212 403L248 222L270 308C272 315 278 320 286 320H286C293 320 300 315 301 308L334 189L390 499C392 506 398 512 406 512H406C414 512 420 507 422 499L511 55V54C517 26 494 0 466 0ZM407 411L352 109C349 92 325 92 321 108L287 246L262 141C259 124 235 124 231 141L196 323L163 157C159 139 136 141 132 156L104 261L33 50C30 41 36 32 46 32H466C477 32 481 42 480 49L407 411Z"]
  };
  var faIcons = {
    prefix: 'fal',
    iconName: 'icons',
    icon: [512, 512, [], "f86d", "M107 215C112 221 120 224 128 224S144 221 149 215L234 130C249 114 257 94 256 72C255 51 245 31 229 17C200 -7 156 -5 128 21C100 -5 56 -7 27 17C11 31 1 51 0 72C-1 94 7 114 22 130L107 215ZM48 42C55 36 65 32 74 32C87 32 99 38 108 46L128 67L148 46C165 30 191 28 208 42C218 50 223 61 224 74C225 86 220 98 211 107L130 193L45 107C36 98 31 86 32 74C33 61 38 50 48 42ZM485 0C483 0 482 0 481 0L344 23C330 26 320 39 320 55V167C310 162 299 160 288 160C252 160 224 181 224 208C224 235 252 256 288 256S352 235 352 208V54L480 33V135C470 131 459 128 448 128C413 128 384 150 384 176S413 224 448 224S512 203 512 176V32C512 14 499 0 485 0ZM288 224C269 224 256 215 256 208C256 202 269 192 288 192S320 202 320 208C320 215 307 224 288 224ZM448 192C428 192 416 182 416 176C416 171 428 160 448 160S480 171 480 176C480 182 468 192 448 192ZM144 336C109 336 80 365 80 400S109 464 144 464S208 435 208 400S179 336 144 336ZM144 432C126 432 112 418 112 400S126 368 144 368S176 382 176 400S162 432 144 432ZM261 288H213L206 274C202 263 191 256 180 256H108C97 256 86 263 82 274L75 288H27C12 288 0 300 0 315V485C0 500 12 512 27 512H261C276 512 288 500 288 485V315C288 300 276 288 261 288ZM256 480H32V320H95L104 302L111 288H177L184 302L193 320H256V480ZM464 368H378L423 279C426 271 423 262 415 258C407 254 398 257 394 265L338 377C332 388 340 400 352 400H437L384 488C382 492 382 496 383 500C384 504 387 508 390 510C393 511 395 512 398 512C404 512 409 509 412 504L478 392C484 381 476 368 464 368Z"]
  };
  var faIdBadge = {
    prefix: 'fal',
    iconName: 'id-badge',
    icon: [384, 512, [], "f2c1", "M320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H320C338 32 352 46 352 64V448ZM192 288C227 288 256 259 256 224S227 160 192 160S128 189 128 224S157 288 192 288ZM192 192C210 192 224 206 224 224S210 256 192 256S160 242 160 224S174 192 192 192ZM224 320H160C116 320 80 356 80 400C80 409 87 416 96 416C105 416 112 409 112 400C112 374 134 352 160 352H224C250 352 272 374 272 400C272 409 279 416 288 416C297 416 304 409 304 400C304 356 268 320 224 320ZM144 96H240C249 96 256 89 256 80S249 64 240 64H144C135 64 128 71 128 80S135 96 144 96Z"]
  };
  var faIdCard = {
    prefix: 'fal',
    iconName: 'id-card',
    icon: [576, 512, [], "f2c2", "M352 352H480C489 352 496 345 496 336S489 320 480 320H352C343 320 336 327 336 336S343 352 352 352ZM512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM544 416C544 434 530 448 512 448H64C46 448 32 434 32 416V128H544V416ZM32 96C32 78 46 64 64 64H512C530 64 544 78 544 96H32ZM352 224H480C489 224 496 217 496 208S489 192 480 192H352C343 192 336 199 336 208S343 224 352 224ZM352 288H480C489 288 496 281 496 272S489 256 480 256H352C343 256 336 263 336 272S343 288 352 288ZM192 288C227 288 256 259 256 224S227 160 192 160S128 189 128 224S157 288 192 288ZM192 192C210 192 224 206 224 224S210 256 192 256S160 242 160 224S174 192 192 192ZM96 416C105 416 112 409 112 400C112 374 134 352 160 352H224C250 352 272 374 272 400C272 409 279 416 288 416S304 409 304 400C304 356 268 320 224 320H160C116 320 80 356 80 400C80 409 87 416 96 416Z"]
  };
  var faIdCardClip = {
    prefix: 'fal',
    iconName: 'id-card-clip',
    icon: [576, 512, [], "f47f", "M256 128H320C338 128 352 114 352 96V32C352 14 338 0 320 0H256C238 0 224 14 224 32V96C224 114 238 128 256 128ZM256 32H320V96H256V32ZM288 320C323 320 352 291 352 256S323 192 288 192S224 221 224 256S253 320 288 320ZM288 224C306 224 320 238 320 256S306 288 288 288S256 274 256 256S270 224 288 224ZM512 64H400C391 64 384 71 384 80V80C384 89 391 96 400 96H512C530 96 544 110 544 128V448C544 466 530 480 512 480H64C46 480 32 466 32 448V128C32 110 46 96 64 96H176C185 96 192 89 192 80V80C192 71 185 64 176 64H64C29 64 0 93 0 128V448C0 483 29 512 64 512H512C547 512 576 483 576 448V128C576 93 547 64 512 64ZM192 448C201 448 208 441 208 432C208 406 230 384 256 384H320C346 384 368 406 368 432C368 441 375 448 384 448S400 441 400 432C400 388 364 352 320 352H256C212 352 176 388 176 432C176 441 183 448 192 448Z"]
  };
  var faIgloo = {
    prefix: 'fal',
    iconName: 'igloo',
    icon: [576, 512, [], "f7ae", "M288 32C128 32 0 160 0 320V448C0 466 14 480 32 480H160C178 480 192 466 192 448V387C192 334 233 289 286 288C340 287 384 330 384 384V448C384 466 398 480 416 480H544C562 480 576 466 576 448V320C576 160 448 32 288 32ZM352 72C406 86 454 118 487 160H352V72ZM288 64C299 64 310 65 320 66V160H89C135 102 207 64 288 64ZM67 192H96V320H32C32 273 45 230 67 192ZM160 384V448H32V352H165C162 362 160 373 160 384ZM288 256C241 256 200 282 178 320H128V192H448V320H398C376 282 335 256 288 256ZM544 448H416V384C416 373 414 362 411 352H544V448ZM480 320V192H509C531 230 544 273 544 320H480Z"]
  };
  var faImage = {
    prefix: 'fal',
    iconName: 'image',
    icon: [512, 512, [], "f03e", "M325 158C314 140 285 141 274 158L200 268L184 246C173 230 146 230 134 246L70 335C63 344 62 357 67 367C73 378 83 384 95 384H417C429 384 439 378 444 368C450 358 449 346 443 336L325 158ZM96 352L158 265L188 306C191 310 196 313 201 313C207 312 212 310 214 305L298 175L415 352H96ZM448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H448C466 64 480 78 480 96V416ZM144 192C170 192 192 170 192 144S170 96 144 96S96 118 96 144S118 192 144 192ZM144 128C153 128 160 135 160 144S153 160 144 160S128 153 128 144S135 128 144 128Z"]
  };
  var faImageLandscape = {
    prefix: 'fal',
    iconName: 'image-landscape',
    icon: [576, 512, [], "e14a", "M160 184C173 184 184 173 184 160S173 136 160 136C147 136 136 147 136 160S147 184 160 184ZM347 172C335 156 308 156 297 172L253 233L246 224C234 210 209 210 197 224L134 305C127 314 126 326 132 336C137 346 147 352 158 352H418C429 352 439 346 444 337C444 337 444 337 444 337C450 327 449 315 443 306L347 172ZM162 320L220 244L241 270C245 275 258 281 266 269L321 191L413 320H162ZM512 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H512C547 448 576 419 576 384V128C576 93 547 64 512 64ZM544 384C544 402 530 416 512 416H64C46 416 32 402 32 384V128C32 110 46 96 64 96H512C530 96 544 110 544 128V384Z"]
  };
  var faImagePolaroid = {
    prefix: 'fal',
    iconName: 'image-polaroid',
    icon: [448, 512, [], "f8c4", "M96 152C109 152 120 141 120 128S109 104 96 104C83 104 72 115 72 128S83 152 96 152ZM283 140C271 124 244 124 233 140L189 201L182 192C170 178 145 178 133 192L70 273C63 282 62 294 68 304C73 314 83 320 94 320H354C365 320 375 314 380 305C380 305 380 305 380 305C386 295 385 283 379 274L283 140ZM98 288L156 212L177 238C181 243 194 249 202 237L257 159L349 288H98ZM384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V384H416V416ZM416 352H32V96C32 78 46 64 64 64H384C402 64 416 78 416 96V352Z"]
  };
  var faImagePolaroidUser = {
    prefix: 'fal',
    iconName: 'image-polaroid-user',
    icon: [448, 512, [], "e14b", "M384 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H384C419 480 448 451 448 416V96C448 61 419 32 384 32ZM416 416C416 434 402 448 384 448H64C46 448 32 434 32 416V384H416V416ZM147 352C154 333 171 320 192 320H256C277 320 294 333 301 352H147ZM416 352H334C327 315 295 288 256 288H192C153 288 121 315 114 352H32V96C32 78 46 64 64 64H384C402 64 416 78 416 96V352ZM224 128C189 128 160 157 160 192S189 256 224 256S288 227 288 192S259 128 224 128ZM224 224C206 224 192 210 192 192S206 160 224 160S256 174 256 192S242 224 224 224Z"]
  };
  var faImagePortrait = {
    prefix: 'fal',
    iconName: 'image-portrait',
    icon: [384, 512, [], "f3e0", "M192 256C227 256 256 227 256 192S227 128 192 128S128 157 128 192S157 256 192 256ZM192 160C210 160 224 174 224 192S210 224 192 224S160 210 160 192S174 160 192 160ZM224 288H160C116 288 80 324 80 368C80 377 87 384 96 384S112 377 112 368C112 342 134 320 160 320H224C250 320 272 342 272 368C272 377 279 384 288 384S304 377 304 368C304 324 268 288 224 288ZM320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 384 448V64C384 29 355 0 320 0ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V64C32 46 46 32 64 32H320C338 32 352 46 352 64V448Z"]
  };
  var faImageUser = {
    prefix: 'fal',
    iconName: 'image-user',
    icon: [512, 512, [], "e14c", "M256 256C291 256 320 227 320 192S291 128 256 128S192 157 192 192S221 256 256 256ZM256 160C274 160 288 174 288 192S274 224 256 224S224 210 224 192S238 160 256 160ZM288 288H224C180 288 144 324 144 368C144 377 151 384 160 384S176 377 176 368C176 342 198 320 224 320H288C314 320 336 342 336 368C336 377 343 384 352 384S368 377 368 368C368 324 332 288 288 288ZM448 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H448C483 480 512 451 512 416V96C512 61 483 32 448 32ZM480 416C480 434 466 448 448 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H448C466 64 480 78 480 96V416Z"]
  };
  var faImages = {
    prefix: 'fal',
    iconName: 'images',
    icon: [576, 512, [], "f302", "M464 448H96C61 448 32 419 32 384V112C32 103 25 96 16 96S0 103 0 112V384C0 437 43 480 96 480H464C473 480 480 473 480 464S473 448 464 448ZM224 152C237 152 248 141 248 128S237 104 224 104C211 104 200 115 200 128S211 152 224 152ZM411 140C399 124 372 124 361 140L317 201L310 192C298 178 273 178 261 192L198 273C191 282 190 294 196 304C201 314 211 320 222 320H482C493 320 503 314 508 305C508 305 508 305 508 305C514 295 513 283 507 274L411 140ZM226 288L284 212L305 238C309 243 322 249 330 237L385 159L477 288H226ZM512 32H160C125 32 96 61 96 96V320C96 355 125 384 160 384H512C547 384 576 355 576 320V96C576 61 547 32 512 32ZM544 320C544 338 530 352 512 352H160C142 352 128 338 128 320V96C128 78 142 64 160 64H512C530 64 544 78 544 96V320Z"]
  };
  var faImagesUser = {
    prefix: 'fal',
    iconName: 'images-user',
    icon: [576, 512, [], "e14d", "M464 448H96C61 448 32 419 32 384V112C32 103 25 96 16 96S0 103 0 112V384C0 437 43 480 96 480H464C473 480 480 473 480 464S473 448 464 448ZM512 32H160C125 32 96 61 96 96V320C96 355 125 384 160 384H512C547 384 576 355 576 320V96C576 61 547 32 512 32ZM416 352H256V336C256 310 278 288 304 288H368C394 288 416 310 416 336V352ZM544 320C544 338 530 352 512 352H448V336C448 292 412 256 368 256H304C260 256 224 292 224 336V352H160C142 352 128 338 128 320V96C128 78 142 64 160 64H512C530 64 544 78 544 96V320ZM336 96C301 96 272 125 272 160S301 224 336 224S400 195 400 160S371 96 336 96ZM336 192C318 192 304 178 304 160S318 128 336 128S368 142 368 160S354 192 336 192Z"]
  };
  var faInbox = {
    prefix: 'fal',
    iconName: 'inbox',
    icon: [512, 512, [], "f01c", "M508 305L447 56C443 42 431 32 416 32H96C81 32 69 42 65 56L4 305C1 315 0 325 0 336V432C0 458 22 480 48 480H464C490 480 512 458 512 432V336C512 325 511 315 508 305ZM96 64H416L471 288H368C362 288 356 291 354 297L326 352H186L158 297C156 291 150 288 144 288H41L96 64ZM480 432C480 441 473 448 464 448H48C39 448 32 441 32 432V336C32 330 33 325 34 320H134L162 375C164 381 170 384 176 384H336C342 384 348 381 350 375L378 320H478C479 325 480 330 480 336V432Z"]
  };
  var faInboxFull = {
    prefix: 'fal',
    iconName: 'inbox-full',
    icon: [512, 512, [], "e14e", "M508 305L447 56C443 42 431 32 416 32H96C81 32 69 42 65 56L4 305C1 315 0 325 0 336V432C0 458 22 480 48 480H464C490 480 512 458 512 432V336C512 325 511 315 508 305ZM96 64H416L471 288H368C362 288 356 291 354 297L326 352H186L158 297C156 291 150 288 144 288H41L96 64ZM480 432C480 441 473 448 464 448H48C39 448 32 441 32 432V336C32 330 33 325 34 320H134L162 375C164 381 170 384 176 384H336C342 384 348 381 350 375L378 320H478C479 325 480 330 480 336V432ZM368 256C377 256 384 249 384 240S377 224 368 224H144C135 224 128 231 128 240S135 256 144 256H368ZM176 176H336C345 176 352 169 352 160S345 144 336 144H176C167 144 160 151 160 160S167 176 176 176Z"]
  };
  var faInboxIn = {
    prefix: 'fal',
    iconName: 'inbox-in',
    icon: [512, 512, [], "f310", "M245 315C248 318 252 320 256 320S264 318 267 315L379 203C386 197 386 187 379 181S363 174 357 181L272 265V16C272 7 265 0 256 0S240 7 240 16V265L155 181C149 174 139 174 133 181S126 197 133 203L245 315ZM464 320H384C378 320 372 323 370 329L342 384H170L142 329C140 323 134 320 128 320H48C22 320 0 342 0 368V464C0 490 22 512 48 512H464C490 512 512 490 512 464V368C512 342 490 320 464 320ZM480 464C480 473 473 480 464 480H48C39 480 32 473 32 464V368C32 359 39 352 48 352H118L146 407C148 413 154 416 160 416H352C358 416 364 413 366 407L394 352H464C473 352 480 359 480 368V464Z"]
  };
  var faInboxOut = {
    prefix: 'fal',
    iconName: 'inbox-out',
    icon: [512, 512, [], "f311", "M155 139L240 55V304C240 313 247 320 256 320S272 313 272 304V55L357 139C363 146 373 146 379 139S386 123 379 117L267 5C264 2 260 0 256 0S248 2 245 5L133 117C126 123 126 133 133 139S149 146 155 139ZM464 320H384C378 320 372 323 370 329L342 384H170L142 329C140 323 134 320 128 320H48C22 320 0 342 0 368V464C0 490 22 512 48 512H464C490 512 512 490 512 464V368C512 342 490 320 464 320ZM480 464C480 473 473 480 464 480H48C39 480 32 473 32 464V368C32 359 39 352 48 352H118L146 407C148 413 154 416 160 416H352C358 416 364 413 366 407L394 352H464C473 352 480 359 480 368V464Z"]
  };
  var faInboxes = {
    prefix: 'fal',
    iconName: 'inboxes',
    icon: [512, 512, [], "e14f", "M508 181L446 20C441 8 429 0 416 0H96C83 0 71 8 66 20L4 181C1 188 0 196 0 204V272C0 298 22 320 48 320H464C490 320 512 298 512 272V204C512 196 511 188 508 181ZM96 32H416L416 32L465 160H384C378 160 372 163 370 169L342 224H170L142 169C140 163 134 160 128 160H47L96 32ZM480 272C480 281 473 288 464 288H48C39 288 32 281 32 272V204C32 200 33 196 34 192L34 192H118L146 247C148 253 154 256 160 256H352C358 256 364 253 366 247L394 192H478L478 192C479 196 480 200 480 204V272ZM464 352H384C378 352 372 355 370 361L342 416H170L142 361C140 355 134 352 128 352H48C22 352 0 374 0 400V464C0 490 22 512 48 512H464C490 512 512 490 512 464V400C512 374 490 352 464 352ZM480 464C480 473 473 480 464 480H48C39 480 32 473 32 464V400C32 391 39 384 48 384H118L146 439C148 445 154 448 160 448H352C358 448 364 445 366 439L394 384H464C473 384 480 391 480 400V464Z"]
  };
  var faIndent = {
    prefix: 'fal',
    iconName: 'indent',
    icon: [448, 512, [], "f03c", "M9 350C11 351 14 352 16 352C20 352 23 351 26 348L122 268C126 265 128 261 128 256S126 247 122 244L26 164C23 161 20 160 16 160C14 160 11 161 9 162C4 164 0 170 0 176V336C0 342 4 348 9 350ZM32 210L87 256L32 302V210ZM16 80H432C441 80 448 73 448 64S441 48 432 48H16C7 48 0 55 0 64S7 80 16 80ZM432 176H208C199 176 192 183 192 192S199 208 208 208H432C441 208 448 201 448 192S441 176 432 176ZM432 304H208C199 304 192 311 192 320S199 336 208 336H432C441 336 448 329 448 320S441 304 432 304ZM432 432H16C7 432 0 439 0 448S7 464 16 464H432C441 464 448 457 448 448S441 432 432 432Z"]
  };
  var faIndianRupeeSign = {
    prefix: 'fal',
    iconName: 'indian-rupee-sign',
    icon: [320, 512, [], "e150", "M320 160C320 169 313 176 304 176H255C251 247 192 304 120 304H65L265 451C273 456 274 466 269 473C266 478 261 480 256 480C253 480 249 479 247 477L7 301C1 297 -1 290 1 283C3 276 9 272 16 272H120C175 272 219 230 223 176H16C7 176 0 169 0 160S7 144 16 144H221C210 98 169 64 120 64H16C7 64 0 57 0 48S7 32 16 32H304C313 32 320 39 320 48S313 64 304 64H207C231 84 248 112 254 144H304C313 144 320 151 320 160Z"]
  };
  var faIndustry = {
    prefix: 'fal',
    iconName: 'industry',
    icon: [512, 512, [], "f275", "M128 64V224V284L178 251L304 167V224V284L354 251L480 167V448H32V64H128M128 32H32C14 32 0 46 0 64V448C0 466 14 480 32 480H480C498 480 512 466 512 448V152C512 138 500 128 488 128C484 128 479 129 475 132L336 224V152C336 138 324 128 312 128C308 128 303 129 299 132L160 224V64C160 46 146 32 128 32L128 32Z"]
  };
  var faIndustryWindows = {
    prefix: 'fal',
    iconName: 'industry-windows',
    icon: [512, 512, [], "f3b3", "M488 128C484 128 479 129 475 132L336 224V152C336 138 324 128 312 128C308 128 303 129 299 132L160 224V64C160 46 146 32 128 32H32C14 32 0 46 0 64V448C0 466 14 480 32 480H480C498 480 512 466 512 448V152C512 138 500 128 488 128ZM480 448H32V64H128V284L178 251L304 167V284L354 251L480 167V448ZM160 320H96C87 320 80 327 80 336V400C80 409 87 416 96 416H160C169 416 176 409 176 400V336C176 327 169 320 160 320ZM144 384H112V352H144V384ZM288 320H224C215 320 208 327 208 336V400C208 409 215 416 224 416H288C297 416 304 409 304 400V336C304 327 297 320 288 320ZM272 384H240V352H272V384ZM336 336V400C336 409 343 416 352 416H416C425 416 432 409 432 400V336C432 327 425 320 416 320H352C343 320 336 327 336 336ZM368 352H400V384H368V352Z"]
  };
  var faInfinity = {
    prefix: 'fal',
    iconName: 'infinity',
    icon: [640, 512, [], "f534", "M489 96C406 96 346 178 320 222C294 178 234 96 151 96C68 96 0 168 0 256S68 416 151 416C234 416 294 334 320 290C346 334 406 416 489 416C572 416 640 344 640 256S572 96 489 96ZM151 384C86 384 32 327 32 256S86 128 151 128C229 128 288 229 302 256C288 283 229 384 151 384ZM489 384C411 384 352 283 338 256C352 229 411 128 489 128C554 128 608 185 608 256S554 384 489 384Z"]
  };
  var faInfo = {
    prefix: 'fal',
    iconName: 'info',
    icon: [256, 512, [], "f129", "M112 128C138 128 160 106 160 80S138 32 112 32S64 54 64 80S86 128 112 128ZM112 64C121 64 128 71 128 80S121 96 112 96S96 89 96 80S103 64 112 64ZM208 448H144V208C144 199 137 192 128 192H80C71 192 64 199 64 208S71 224 80 224H112V448H48C39 448 32 455 32 464S39 480 48 480H208C217 480 224 473 224 464S217 448 208 448Z"]
  };
  var faInhaler = {
    prefix: 'fal',
    iconName: 'inhaler',
    icon: [576, 512, [], "f5f9", "M24 232C11 232 0 243 0 256S11 280 24 280S48 269 48 256S37 232 24 232ZM24 328C11 328 0 339 0 352C0 365 11 376 24 376S48 365 48 352C48 339 37 328 24 328ZM24 424C11 424 0 435 0 448C0 461 11 472 24 472S48 461 48 448C48 435 37 424 24 424ZM120 376C107 376 96 387 96 400C96 413 107 424 120 424C133 424 144 413 144 400C144 387 133 376 120 376ZM120 280C107 280 96 291 96 304C96 317 107 328 120 328C133 328 144 317 144 304C144 291 133 280 120 280ZM355 117C351 113 345 111 340 113C334 114 330 118 329 124L300 224H232C206 224 184 246 184 272V432C184 458 206 480 232 480H424C460 480 491 457 501 423L535 309C537 303 535 297 531 293L355 117ZM470 414C464 434 446 448 424 448H232C223 448 216 441 216 432V272C216 263 223 256 232 256H312C319 256 325 251 327 244L352 159L502 309L470 414ZM555 64L411 32C403 31 395 35 393 43L377 91C374 99 379 108 387 111C395 114 404 109 407 101L419 67L533 92L504 221C502 229 508 238 516 240C518 240 519 240 520 240C527 240 534 235 536 227L568 83C570 75 564 66 555 64Z"]
  };
  var faInputNumeric = {
    prefix: 'fal',
    iconName: 'input-numeric',
    icon: [640, 512, [], "e151", "M576 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM608 384C608 402 594 416 576 416H64C46 416 32 402 32 384V128C32 110 46 96 64 96H576C594 96 608 110 608 128V384ZM176 320H160V176C160 167 153 160 144 160H112C103 160 96 167 96 176S103 192 112 192H128V320H112C103 320 96 327 96 336S103 352 112 352H176C185 352 192 345 192 336S185 320 176 320ZM336 320H277L327 265C345 247 349 221 339 197C329 174 307 160 282 160C261 160 242 173 231 194C227 202 230 211 238 215C246 219 256 216 260 208C272 184 301 190 309 210C313 219 314 233 304 244L228 325C224 330 223 337 225 342C228 348 234 352 240 352H336C345 352 352 345 352 336S345 320 336 320Z"]
  };
  var faInputPipe = {
    prefix: 'fal',
    iconName: 'input-pipe',
    icon: [640, 512, [], "e152", "M112 160C103 160 96 167 96 176V336C96 345 103 352 112 352S128 345 128 336V176C128 167 121 160 112 160ZM576 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM608 384C608 402 594 416 576 416H64C46 416 32 402 32 384V128C32 110 46 96 64 96H576C594 96 608 110 608 128V384Z"]
  };
  var faInputText = {
    prefix: 'fal',
    iconName: 'input-text',
    icon: [640, 512, [], "e153", "M576 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM608 384C608 402 594 416 576 416H64C46 416 32 402 32 384V128C32 110 46 96 64 96H576C594 96 608 110 608 128V384ZM406 248C412 239 416 228 416 216C416 185 391 160 360 160H304C295 160 288 167 288 176V336C288 345 295 352 304 352H376C407 352 432 327 432 296C432 276 421 258 406 248ZM320 192H360C373 192 384 203 384 216S373 240 360 240H320V192ZM376 320H320V272H376C389 272 400 283 400 296C400 309 389 320 376 320ZM191 170C186 158 166 158 161 170L97 330C94 338 98 348 106 351C114 354 124 350 127 342L142 304C143 304 143 304 144 304H208C209 304 209 304 210 304L225 342C228 348 234 352 240 352C242 352 244 352 246 351C254 348 258 338 255 330L191 170ZM155 272L176 219L197 272H155Z"]
  };
  var faIntegral = {
    prefix: 'fal',
    iconName: 'integral',
    icon: [384, 512, [], "f667", "M379 123C373 130 363 130 357 123L305 72C292 59 268 65 262 82L152 439C145 464 123 480 97 480C82 480 67 474 56 463L5 411C-2 405 -2 395 5 389S21 382 27 389L79 441C92 453 116 447 122 430L232 73C239 48 261 32 287 32C302 32 317 38 327 49L379 101C386 107 386 117 379 123Z"]
  };
  var faIntersection = {
    prefix: 'fal',
    iconName: 'intersection',
    icon: [384, 512, [], "f668", "M384 224V464C384 473 377 480 368 480S352 473 352 464V224C352 136 280 64 192 64S32 136 32 224V464C32 473 25 480 16 480S0 473 0 464V224C0 118 86 32 192 32S384 118 384 224Z"]
  };
  var faIslandTropical = {
    prefix: 'fal',
    iconName: 'island-tropical',
    icon: [448, 512, [], "f811", "M258 353C292 306 298 251 272 201C267 193 258 190 250 194C242 198 239 208 243 215C267 261 257 311 217 352H131C59 352 0 411 0 484C0 499 13 512 29 512H355C371 512 384 499 384 484C384 413 328 355 258 353ZM32 480C34 426 78 384 131 384H253C306 384 350 426 352 480H32ZM299 32C284 32 269 34 256 38C228 15 191 0 149 0C73 0 11 47 0 109C-1 114 1 119 4 122C7 126 12 128 17 128H90C58 178 55 238 85 281C92 291 105 289 110 283L233 160H431C436 160 441 158 444 154C447 151 449 146 448 141C437 79 375 32 299 32ZM220 128L102 246C85 200 107 134 163 102C170 98 173 89 170 82C166 73 155 69 147 74C136 80 126 87 117 96H37C54 58 98 32 149 32C181 32 212 43 235 62L247 73C258 71 279 64 299 64C350 64 394 90 411 128H220Z"]
  };
  var faItalic = {
    prefix: 'fal',
    iconName: 'italic',
    icon: [320, 512, [], "f033", "M320 48C320 57 313 64 304 64H221L132 448H208C217 448 224 455 224 464S217 480 208 480H16C7 480 0 473 0 464S7 448 16 448H99L188 64H112C103 64 96 57 96 48S103 32 112 32H304C313 32 320 39 320 48Z"]
  };
  var faJ = {
    prefix: 'fal',
    iconName: 'j',
    icon: [320, 512, [], "e154", "M160 480C72 480 0 408 0 320V272C0 263 7 256 16 256S32 263 32 272V320C32 391 89 448 160 448S288 391 288 320V48C288 39 295 32 304 32S320 39 320 48V320C320 408 248 480 160 480Z"]
  };
  var faJackOLantern = {
    prefix: 'fal',
    iconName: 'jack-o-lantern',
    icon: [576, 512, [], "f30e", "M244 114C246 115 248 115 250 115C256 115 262 111 265 105L293 35L320 49V96C320 105 327 112 336 112S352 105 352 96V44C352 35 347 26 339 22L299 3C293 0 286 -1 280 2C274 4 269 9 266 15L235 93C232 101 236 110 244 114ZM256 432C265 432 272 425 272 416V399C277 400 283 400 288 400C378 400 451 368 454 367C463 363 466 354 463 346C459 337 450 334 442 337C441 338 371 368 288 368C205 368 135 338 134 337C126 334 117 338 113 346S113 363 122 367C124 368 174 389 240 397V416C240 425 247 432 256 432ZM204 190C221 171 253 160 288 160C323 160 355 171 372 190C375 193 380 195 384 195C388 195 392 193 395 191C401 185 402 174 396 168C372 143 332 128 288 128C244 128 204 143 180 168C174 174 175 185 181 191C187 197 198 196 204 190ZM550 211C521 157 471 126 415 128C407 128 400 136 400 145C400 153 407 160 417 160C459 158 498 183 522 226C557 290 557 390 474 461C446 485 398 486 369 462C360 455 347 455 338 463C324 474 308 480 288 480C268 480 252 474 239 463C230 455 217 455 207 462C179 486 130 485 102 461C20 390 19 290 54 227C78 183 116 159 160 160C168 161 176 153 176 145C176 136 169 128 161 128C106 126 55 158 26 211C-15 286 -15 403 81 486C119 518 181 520 223 491C241 505 263 512 288 512C314 512 335 505 354 491C395 520 457 518 495 486C591 403 591 286 550 211ZM189 297L208 269L227 297C230 302 235 304 240 304C243 304 246 303 249 301C256 296 258 286 253 279L221 231C215 222 201 222 195 231L163 279C158 286 160 296 167 301C174 306 184 304 189 297ZM381 231C375 222 361 222 355 231L323 279C318 286 320 296 327 301C334 306 344 304 349 297L368 269L387 297C390 302 395 304 400 304C403 304 406 303 409 301C416 296 418 286 413 279L381 231Z"]
  };
  var faJedi = {
    prefix: 'fal',
    iconName: 'jedi',
    icon: [576, 512, [], "f669", "M445 20C441 18 437 16 432 16C424 16 416 20 412 27C407 33 406 42 409 49C415 64 418 80 418 96C418 137 399 174 366 199C360 204 356 210 356 218C355 225 358 232 364 237C388 258 401 288 401 320C401 342 387 419 304 430V359L325 379C331 385 341 385 347 379C353 373 353 363 347 357L327 336H352C361 336 368 329 368 320S361 304 352 304H327L347 283C353 277 353 267 347 261C341 255 331 255 325 261L304 281V16C304 7 297 0 288 0C279 0 272 7 272 16V281L251 261C245 254 235 254 229 261C222 267 223 277 229 283L249 304H224C215 304 208 311 208 320S215 336 224 336H249L229 357C223 363 222 373 229 379C235 386 245 386 251 379L272 359V430C217 422 175 377 175 320C175 288 188 258 212 237C218 232 221 225 220 218S216 204 210 199C177 174 158 137 158 96C158 80 161 64 167 49C170 42 169 33 164 27C160 20 152 16 144 16C139 16 135 18 131 21C55 74 12 161 16 254C23 395 142 512 288 512C438 512 560 390 560 241C560 153 517 71 445 20ZM288 480C143 480 61 362 50 269L86 300C92 306 102 305 108 298S113 282 107 276L49 225C50 213 51 201 54 189L85 219C91 225 101 225 107 219S114 203 107 197L65 154C79 119 101 87 129 62C127 73 126 84 126 95V96C126 143 147 189 184 219C158 246 143 282 143 319C143 399 208 464 288 464C360 464 433 408 433 320C433 282 418 246 392 219C429 189 450 143 450 96C450 84 449 73 447 62C475 87 497 119 511 154L469 197C462 203 462 213 469 219C475 225 485 225 491 219L522 189C525 201 526 213 527 225L470 276C463 282 462 292 468 298C474 305 484 306 491 300L526 269C513 387 411 480 288 480Z"]
  };
  var faJetFighter = {
    prefix: 'fal',
    iconName: 'jet-fighter',
    icon: [640, 512, [], "f0fb", "M629 241L472 184C458 179 443 176 428 176H407L276 32H304C313 32 320 25 320 16S313 0 304 0H208C199 0 192 7 192 16V176H167L132 134C129 130 125 128 120 128H48C39 128 32 135 32 144V208H16C7 208 0 215 0 224V288C0 297 7 304 16 304H32V368C32 377 39 384 48 384H120C125 384 129 382 132 378L168 336H192V496C192 505 199 512 208 512H304C313 512 320 505 320 496S313 480 304 480H276L407 336H428C443 336 458 333 472 328L629 271C636 269 640 263 640 256S636 243 629 241ZM224 32H233L364 176H224V32ZM233 480H224V336H364L233 480ZM456 300C449 303 441 304 434 304H160C155 304 151 306 148 310L113 352H64V288C64 279 57 272 48 272H32V240H48C57 240 64 233 64 224V160H113L148 202C151 206 155 208 160 208H434C441 208 449 209 456 212L577 256L456 300ZM160 240H96C87 240 80 247 80 256S87 272 96 272H160C169 272 176 265 176 256S169 240 160 240Z"]
  };
  var faJoint = {
    prefix: 'fal',
    iconName: 'joint',
    icon: [640, 512, [], "f595", "M584 352H255C166 352 78 375 0 418C-11 424 -11 440 0 446C78 489 166 512 255 512H584C610 512 632 490 632 464V400C632 374 610 352 584 352ZM255 480C181 480 109 463 43 432C103 403 168 388 235 385L316 480H255ZM359 480L276 384H392L475 480H359ZM600 464C600 473 593 480 584 480H517L435 384H584C593 384 600 391 600 400V464ZM446 157C482 184 504 227 504 272C504 281 511 288 520 288S536 281 536 272C536 217 510 164 466 131C430 104 408 61 408 16C408 7 401 0 392 0S376 7 376 16C376 71 402 124 446 157ZM542 157C578 184 600 227 600 272C600 281 607 288 616 288S632 281 632 272C632 217 606 164 562 131C526 104 504 61 504 16C504 7 497 0 488 0S472 7 472 16C472 71 498 124 542 157Z"]
  };
  var faJoystick = {
    prefix: 'fal',
    iconName: 'joystick',
    icon: [448, 512, [], "f8c5", "M400 352H240V222C294 215 336 168 336 112C336 50 286 0 224 0S112 50 112 112C112 168 154 215 208 222V352H48C22 352 0 374 0 400V464C0 490 22 512 48 512H400C426 512 448 490 448 464V400C448 374 426 352 400 352ZM144 112C144 68 180 32 224 32S304 68 304 112S268 192 224 192S144 156 144 112ZM416 464C416 473 409 480 400 480H48C39 480 32 473 32 464V400C32 391 39 384 48 384H400C409 384 416 391 416 400V464ZM232 80C232 67 221 56 208 56S184 67 184 80C184 93 195 104 208 104S232 93 232 80ZM64 320H128C137 320 144 313 144 304S137 288 128 288H64C55 288 48 295 48 304S55 320 64 320Z"]
  };
  var faJug = {
    prefix: 'fal',
    iconName: 'jug',
    icon: [448, 512, [], "f8c6", "M112 32H272C281 32 288 25 288 16C288 7 281 0 272 0H112C103 0 96 7 96 16C96 25 103 32 112 32ZM416 160C416 125 387 96 352 96C328 96 307 110 296 130L279 109C274 103 272 96 272 89V80C272 71 265 64 256 64S240 71 240 80V89C240 103 245 117 254 129L331 225C345 242 352 263 352 285V288H32V285C32 263 39 242 53 225L130 129C139 117 144 103 144 89V80C144 71 137 64 128 64S112 71 112 80V89C112 96 110 103 105 109L28 205C10 228 0 256 0 285V448C0 483 29 512 64 512H320C355 512 384 483 384 448V285C384 263 378 241 367 222C395 215 416 190 416 160ZM352 448C352 466 338 480 320 480H64C46 480 32 466 32 448V416H352V448ZM352 384H32V320H352V384ZM352 192H346L320 160C320 142 334 128 352 128S384 142 384 160S370 192 352 192Z"]
  };
  var faK = {
    prefix: 'fal',
    iconName: 'k',
    icon: [320, 512, [], "e155", "M317 455C322 462 321 472 313 477C311 479 307 480 304 480C299 480 294 478 291 473L125 247L32 338V464C32 473 25 480 16 480S0 473 0 464V48C0 39 7 32 16 32S32 39 32 48V293L293 37C299 30 309 30 315 37C322 43 322 53 315 59L148 224L317 455Z"]
  };
  var faKaaba = {
    prefix: 'fal',
    iconName: 'kaaba',
    icon: [576, 512, [], "f66b", "M252 170L172 192C163 194 158 203 161 212C163 219 169 223 176 223C177 223 179 223 180 223L260 200C269 198 274 189 271 181C269 172 260 167 252 170ZM316 200L396 223C397 223 399 224 400 224C407 224 413 219 415 212C418 203 413 195 404 192L324 170C316 167 307 172 305 181C302 189 307 198 316 200ZM554 83L318 5C309 2 298 0 288 0S267 2 258 5L22 83C9 88 0 100 0 114V425C0 440 10 453 25 456L267 510C274 511 281 512 288 512S302 511 309 510L551 456C566 453 576 440 576 425V114C576 100 567 88 554 83ZM544 231L468 210C460 208 451 213 449 221C446 230 451 239 460 241L544 264V425L302 478C297 479 293 480 288 480S279 479 274 478L32 425V264L116 241C125 238 130 230 127 221C125 213 116 208 108 210L32 231V187L274 114C279 113 283 112 288 112S297 113 302 114L544 187V231ZM544 153L311 83C303 81 296 80 288 80C280 80 273 81 265 83L32 153V114L268 35C272 34 279 32 288 32C297 32 304 34 308 35L544 114V153Z"]
  };
  var faKazoo = {
    prefix: 'fal',
    iconName: 'kazoo',
    icon: [640, 512, [], "f8c7", "M608 128H481C461 118 439 112 416 112S371 118 351 128H242C230 128 218 130 207 133L23 185C10 189 0 202 0 216V296C0 310 10 323 23 327L207 379C218 382 230 384 242 384H351C371 394 393 400 416 400S461 394 481 384H608C626 384 640 370 640 352V160C640 142 626 128 608 128ZM242 352C233 352 224 351 216 348L32 296V216L215 164C224 161 233 160 242 160H309C260 215 260 297 309 352H242ZM416 368C354 368 304 318 304 256S354 144 416 144S528 194 528 256C528 318 478 368 416 368ZM608 352H523C572 297 572 215 523 160H608V352ZM467 205C461 198 451 198 445 205L416 233L387 205C381 198 371 198 365 205S358 221 365 227L393 256L365 285C358 291 358 301 365 307C368 310 372 312 376 312S384 310 387 307L416 279L445 307C448 310 452 312 456 312S464 310 467 307C474 301 474 291 467 285L439 256L467 227C474 221 474 211 467 205Z"]
  };
  var faKerning = {
    prefix: 'fal',
    iconName: 'kerning',
    icon: [640, 512, [], "f86f", "M294 97C286 94 277 97 273 106L160 361L47 106C43 97 34 94 26 97C17 101 14 110 17 118L145 406C148 412 154 416 160 416C166 416 172 412 175 406L303 118C306 110 303 101 294 97ZM623 394L495 106C489 94 471 94 465 106L337 394C334 402 337 411 346 415C354 418 363 415 367 406L405 320H555L593 406C596 412 602 416 608 416C610 416 612 416 614 415C623 411 626 402 623 394ZM419 288L480 151L541 288H419ZM422 1C414 -2 404 2 401 10L209 490C206 498 210 508 218 511C220 512 222 512 224 512C230 512 236 508 239 502L431 22C434 14 430 4 422 1Z"]
  };
  var faKey = {
    prefix: 'fal',
    iconName: 'key',
    icon: [512, 512, [], "f084", "M336 0C239 0 160 79 160 176C160 191 162 206 166 221L7 380C2 384 0 390 0 397V488C0 501 11 512 24 512H136C149 512 160 501 160 488V448H200C213 448 224 437 224 424V384H243C250 384 256 382 260 377L291 346C306 350 321 352 336 352C433 352 512 273 512 176C512 79 433 0 336 0ZM336 320C317 320 299 316 282 310L240 352H192V416H128V480H32V400L202 230C196 213 192 195 192 176C192 97 257 32 336 32S480 97 480 176S415 320 336 320ZM384 104C371 104 360 115 360 128C360 141 371 152 384 152S408 141 408 128C408 115 397 104 384 104Z"]
  };
  var faKeySkeleton = {
    prefix: 'fal',
    iconName: 'key-skeleton',
    icon: [512, 512, [], "f6f3", "M416 0H320C267 0 224 43 224 96V192C224 213 231 232 242 247L5 485C-2 491 -2 501 5 507C8 510 12 512 16 512S24 510 27 507L76 459L119 503C126 509 134 512 142 512S158 509 165 503L214 453C227 441 227 420 214 408L170 364L265 270C280 281 299 288 320 288H416C469 288 512 245 512 192V96C512 43 469 0 416 0ZM191 431L142 480L98 436L148 387L191 431ZM480 192C480 227 451 256 416 256H320C285 256 256 227 256 192V96C256 61 285 32 320 32H416C451 32 480 61 480 96V192ZM397 115C395 87 371 64 342 64C312 64 288 88 288 118C288 147 311 171 339 173C341 201 365 224 394 224C424 224 448 200 448 170C448 141 425 117 397 115ZM394 192C381 192 371 182 371 170C371 155 357 141 342 141C330 141 320 131 320 118S330 96 342 96S365 106 365 118C365 133 379 147 394 147C406 147 416 157 416 170S406 192 394 192Z"]
  };
  var faKeyboard = {
    prefix: 'fal',
    iconName: 'keyboard',
    icon: [576, 512, [], "f11c", "M180 184H204C211 184 216 179 216 172V148C216 141 211 136 204 136H180C173 136 168 141 168 148V172C168 179 173 184 180 184ZM276 280H300C307 280 312 275 312 268V244C312 237 307 232 300 232H276C269 232 264 237 264 244V268C264 275 269 280 276 280ZM180 280H204C211 280 216 275 216 268V244C216 237 211 232 204 232H180C173 232 168 237 168 244V268C168 275 173 280 180 280ZM372 184H396C403 184 408 179 408 172V148C408 141 403 136 396 136H372C365 136 360 141 360 148V172C360 179 365 184 372 184ZM276 184H300C307 184 312 179 312 172V148C312 141 307 136 300 136H276C269 136 264 141 264 148V172C264 179 269 184 276 184ZM108 328H84C77 328 72 333 72 340V364C72 371 77 376 84 376H108C115 376 120 371 120 364V340C120 333 115 328 108 328ZM372 280H396C403 280 408 275 408 268V244C408 237 403 232 396 232H372C365 232 360 237 360 244V268C360 275 365 280 372 280ZM108 136H84C77 136 72 141 72 148V172C72 179 77 184 84 184H108C115 184 120 179 120 172V148C120 141 115 136 108 136ZM492 232H468C461 232 456 237 456 244V268C456 275 461 280 468 280H492C499 280 504 275 504 268V244C504 237 499 232 492 232ZM108 232H84C77 232 72 237 72 244V268C72 275 77 280 84 280H108C115 280 120 275 120 268V244C120 237 115 232 108 232ZM512 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H512C547 448 576 419 576 384V128C576 93 547 64 512 64ZM544 384C544 402 530 416 512 416H64C46 416 32 402 32 384V128C32 110 46 96 64 96H512C530 96 544 110 544 128V384ZM492 136H468C461 136 456 141 456 148V172C456 179 461 184 468 184H492C499 184 504 179 504 172V148C504 141 499 136 492 136ZM400 336H176C167 336 160 343 160 352S167 368 176 368H400C409 368 416 361 416 352S409 336 400 336ZM492 328H468C461 328 456 333 456 340V364C456 371 461 376 468 376H492C499 376 504 371 504 364V340C504 333 499 328 492 328Z"]
  };
  var faKeyboardDown = {
    prefix: 'fal',
    iconName: 'keyboard-down',
    icon: [576, 512, [], "e156", "M512 0H64C29 0 0 29 0 64V224C0 259 29 288 64 288H512C547 288 576 259 576 224V64C576 29 547 0 512 0ZM544 224C544 242 530 256 512 256H64C46 256 32 242 32 224V64C32 46 46 32 64 32H512C530 32 544 46 544 64V224ZM180 120H204C211 120 216 115 216 108V84C216 77 211 72 204 72H180C173 72 168 77 168 84V108C168 115 173 120 180 120ZM108 168H84C77 168 72 173 72 180V204C72 211 77 216 84 216H108C115 216 120 211 120 204V180C120 173 115 168 108 168ZM372 120H396C403 120 408 115 408 108V84C408 77 403 72 396 72H372C365 72 360 77 360 84V108C360 115 365 120 372 120ZM276 120H300C307 120 312 115 312 108V84C312 77 307 72 300 72H276C269 72 264 77 264 84V108C264 115 269 120 276 120ZM492 72H468C461 72 456 77 456 84V108C456 115 461 120 468 120H492C499 120 504 115 504 108V84C504 77 499 72 492 72ZM492 168H468C461 168 456 173 456 180V204C456 211 461 216 468 216H492C499 216 504 211 504 204V180C504 173 499 168 492 168ZM400 176H176C167 176 160 183 160 192S167 208 176 208H400C409 208 416 201 416 192S409 176 400 176ZM108 72H84C77 72 72 77 72 84V108C72 115 77 120 84 120H108C115 120 120 115 120 108V84C120 77 115 72 108 72ZM388 357L288 472L188 357C182 351 172 350 165 356C159 362 158 372 164 379L276 507C279 510 283 512 288 512S297 510 300 507L412 379C418 372 417 362 411 356C404 350 394 351 388 357Z"]
  };
  var faKeyboardLeft = {
    prefix: 'fal',
    iconName: 'keyboard-left',
    icon: [640, 512, [], "e157", "M340 280H364C371 280 376 275 376 268V244C376 237 371 232 364 232H340C333 232 328 237 328 244V268C328 275 333 280 340 280ZM436 184H460C467 184 472 179 472 172V148C472 141 467 136 460 136H436C429 136 424 141 424 148V172C424 179 429 184 436 184ZM268 328H244C237 328 232 333 232 340V364C232 371 237 376 244 376H268C275 376 280 371 280 364V340C280 333 275 328 268 328ZM436 280H460C467 280 472 275 472 268V244C472 237 467 232 460 232H436C429 232 424 237 424 244V268C424 275 429 280 436 280ZM268 232H244C237 232 232 237 232 244V268C232 275 237 280 244 280H268C275 280 280 275 280 268V244C280 237 275 232 268 232ZM340 184H364C371 184 376 179 376 172V148C376 141 371 136 364 136H340C333 136 328 141 328 148V172C328 179 333 184 340 184ZM556 232H532C525 232 520 237 520 244V268C520 275 525 280 532 280H556C563 280 568 275 568 268V244C568 237 563 232 556 232ZM556 136H532C525 136 520 141 520 148V172C520 179 525 184 532 184H556C563 184 568 179 568 172V148C568 141 563 136 556 136ZM268 136H244C237 136 232 141 232 148V172C232 179 237 184 244 184H268C275 184 280 179 280 172V148C280 141 275 136 268 136ZM576 64H224C189 64 160 93 160 128V384C160 419 189 448 224 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM608 384C608 402 594 416 576 416H224C206 416 192 402 192 384V128C192 110 206 96 224 96H576C594 96 608 110 608 128V384ZM556 328H532C525 328 520 333 520 340V364C520 371 525 376 532 376H556C563 376 568 371 568 364V340C568 333 563 328 556 328ZM464 336H336C327 336 320 343 320 352S327 368 336 368H464C473 368 480 361 480 352S473 336 464 336ZM124 157C118 151 108 150 101 156L5 244C2 247 0 252 0 256S2 265 5 268L101 356C104 359 108 360 112 360C116 360 121 358 124 355C130 348 129 338 123 332L40 256L123 180C129 174 130 164 124 157Z"]
  };
  var faKeynote = {
    prefix: 'fal',
    iconName: 'keynote',
    icon: [512, 512, [], "f66c", "M505 274L457 178C451 167 440 160 428 160H128V144C128 104 157 71 195 65C202 83 220 96 240 96H304C330 96 352 74 352 48S330 0 304 0H240C219 0 201 14 194 33C139 40 96 87 96 144V160H84C72 160 61 167 55 178L7 274C2 283 0 293 0 303V352C0 370 14 384 32 384H240V480H144C135 480 128 487 128 496C128 505 135 512 144 512H368C377 512 384 505 384 496C384 487 377 480 368 480H272V384H480C498 384 512 370 512 352V303C512 293 510 283 505 274ZM240 32H304C313 32 320 39 320 48S313 64 304 64H240C231 64 224 57 224 48S231 32 240 32ZM84 192H428L476 288H36L84 192ZM480 352H32V320H480V352Z"]
  };
  var faKhanda = {
    prefix: 'fal',
    iconName: 'khanda',
    icon: [512, 512, [], "f66d", "M416 66C413 65 411 64 408 64C404 64 399 66 396 69C391 74 391 82 394 88C411 115 420 145 420 176C419 229 393 279 348 308L272 362V342L316 305C320 301 321 295 319 290L311 273C345 254 368 218 368 176C368 135 346 100 313 80L318 69C321 64 320 57 315 53L256 0L197 53C192 57 191 64 193 69L198 80C166 100 144 135 144 176C144 218 167 254 201 273L193 290C191 295 192 301 196 306L240 342V362L163 308C119 279 92 229 92 176C92 145 101 115 117 89C121 82 120 75 115 70C112 66 107 65 103 65C100 65 97 65 95 67C16 110 -22 205 13 296C20 314 31 330 44 345L100 410C103 414 107 416 112 416C114 416 117 415 119 414L199 372L228 392L181 425C179 425 178 424 176 424C163 424 152 435 152 448S163 472 176 472C188 472 198 463 199 451L240 423V453C230 459 224 468 224 480C224 498 238 512 256 512S288 498 288 480C288 468 281 459 272 453V423L313 451C314 463 324 472 336 472C349 472 360 461 360 448S349 424 336 424C334 424 333 425 331 425L284 392L313 372L392 414C395 415 397 416 400 416C405 416 409 414 412 410L465 349C484 327 499 302 506 274C528 190 489 106 416 66ZM116 380L68 324C57 311 48 298 43 284C22 231 32 173 65 132C62 146 60 161 60 176C60 240 92 299 145 334L169 351L116 380ZM300 109C321 124 336 148 336 176C336 205 320 230 298 244L285 217C277 192 277 166 285 141L300 109ZM256 43L284 68L256 128L256 129L255 128L228 68L256 43ZM214 244C191 230 176 205 176 176C176 148 190 124 212 109L226 141C235 166 235 193 226 217L214 244ZM256 313L228 290L255 230L256 229L256 230L284 290L256 313ZM475 266C469 287 458 308 440 328L396 380L343 351L366 335C419 299 451 240 452 176C452 161 450 147 447 132C476 169 487 217 475 266Z"]
  };
  var faKidneys = {
    prefix: 'fal',
    iconName: 'kidneys',
    icon: [640, 512, [], "f5fb", "M244 216L203 195C208 186 215 176 224 168C243 151 254 127 256 102C257 75 248 50 230 30C212 11 186 0 160 0C136 0 114 9 96 24C15 97 -18 204 10 303L13 314C25 357 60 384 103 384C135 384 165 369 184 345C201 322 206 292 198 262L195 250C192 243 192 234 193 226L229 245C246 253 256 269 256 288V496C256 505 263 512 272 512S288 505 288 496V288C288 257 271 230 244 216ZM164 259L167 271C181 320 142 352 103 352C78 352 53 338 44 306L41 294C16 207 45 113 117 48C129 38 144 32 160 32C196 32 226 63 224 100C223 117 215 132 203 144C167 176 152 219 164 259ZM544 24C526 9 504 0 480 0C454 0 428 11 410 30C392 50 383 75 384 102C386 127 397 151 416 168C425 176 432 186 437 195L396 216C369 230 352 257 352 288V496C352 505 359 512 368 512S384 505 384 496V288C384 269 394 253 411 245L447 226C448 234 448 243 445 250L442 262C434 292 439 322 456 345C475 369 505 384 537 384C580 384 615 357 627 314L630 303C658 204 625 97 544 24ZM599 294L596 306C587 338 562 352 537 352C498 352 459 320 473 271L476 259C488 219 473 176 437 144C425 132 417 117 416 100C414 63 444 32 480 32C496 32 511 38 523 48C595 113 624 207 599 294Z"]
  };
  var faKipSign = {
    prefix: 'fal',
    iconName: 'kip-sign',
    icon: [384, 512, [], "e158", "M384 256C384 265 377 272 368 272H125L330 435C337 441 338 451 333 458C329 462 325 464 320 464C317 464 313 463 310 461L96 290V464C96 473 89 480 80 480S64 473 64 464V272H16C7 272 0 265 0 256S7 240 16 240H64V48C64 39 71 32 80 32S96 39 96 48V223L310 52C317 46 327 47 332 54C338 61 337 71 330 76L126 240H368C377 240 384 247 384 256Z"]
  };
  var faKitMedical = {
    prefix: 'fal',
    iconName: 'kit-medical',
    icon: [576, 512, [], "f479", "M512 32H64C29 32 0 61 0 96V416C0 451 29 480 64 480H512C547 480 576 451 576 416V96C576 61 547 32 512 32ZM96 448H64C46 448 32 434 32 416V96C32 78 46 64 64 64H96V448ZM448 448H128V64H448V448ZM544 416C544 434 530 448 512 448H480V64H512C530 64 544 78 544 96V416ZM208 288H256V336C256 345 263 352 272 352H304C313 352 320 345 320 336V288H368C377 288 384 281 384 272V240C384 231 377 224 368 224H320V176C320 167 313 160 304 160H272C263 160 256 167 256 176V224H208C199 224 192 231 192 240V272C192 281 199 288 208 288Z"]
  };
  var faKite = {
    prefix: 'fal',
    iconName: 'kite',
    icon: [640, 512, [], "f6f4", "M592 0H361C339 0 320 15 314 36L225 394L139 475C132 482 124 480 122 479C119 478 112 474 112 464L112 316L168 350C170 351 173 352 176 352C181 352 187 349 190 344C194 337 192 327 184 322L127 288L184 254C192 249 194 239 190 232C185 224 175 222 168 226L112 260L112 208C112 164 76 128 32 128H16C7 128 0 135 0 144S7 160 16 160H32C58 160 80 182 80 208L80 260L24 226C17 222 7 224 2 232C-2 239 0 249 8 254L65 288L8 322C0 327 -2 337 2 344C5 349 11 352 16 352C19 352 22 351 24 350L80 316L80 464C80 484 91 501 109 508C115 511 122 512 128 512C140 512 152 507 161 498L250 414L604 326C625 320 640 301 640 279V48C640 22 618 0 592 0ZM585 32L480 137L375 32H585ZM345 47L457 160L270 348L345 47ZM292 370L480 183L593 295L292 370ZM608 265L503 160L608 55V265Z"]
  };
  var faKiwiBird = {
    prefix: 'fal',
    iconName: 'kiwi-bird',
    icon: [576, 512, [], "f535", "M464 200C451 200 440 211 440 224S451 248 464 248S488 237 488 224S477 200 464 200ZM563 276C572 259 577 239 576 218C573 157 518 112 458 112H448C395 112 344 96 300 66C270 45 232 32 192 32C177 32 163 34 147 37C76 53 20 111 4 182C-14 270 28 350 96 390V464C96 473 103 480 112 480S128 473 128 464V405C148 412 170 416 192 416C203 416 214 415 224 413V464C224 473 231 480 240 480C249 480 256 473 256 464V405C271 399 285 393 298 384C343 354 395 336 449 336H464C467 336 469 335 471 335L546 472C549 477 554 480 560 480C561 480 563 480 564 479C572 477 576 470 576 463L563 276ZM504 328C515 324 524 318 533 312L539 392L504 328ZM522 279C507 295 486 304 464 304H448C391 304 334 322 279 358C253 375 223 384 192 384C144 384 98 362 68 325C37 287 26 237 36 189C48 130 96 81 154 68C167 66 179 64 192 64C225 64 256 74 282 92C332 126 389 144 448 144H458C503 144 542 178 544 220C545 242 537 263 522 279Z"]
  };
  var faKnife = {
    prefix: 'fal',
    iconName: 'knife',
    icon: [512, 512, [], "f2e4", "M74 512C62 512 50 507 42 499L13 470C5 462 0 450 0 438C0 426 5 415 14 407L408 14C427 -4 459 -4 478 14L478 14C478 14 478 14 478 14C507 44 528 133 495 212C473 267 418 332 286 332H266L105 498C97 507 86 512 74 512ZM443 32C438 32 434 34 431 37L36 430C33 432 32 435 32 439C32 442 33 445 36 447L65 476C67 479 70 480 73 480C77 480 80 479 82 476L248 305C251 302 255 300 259 300H286C400 300 447 246 466 200C495 130 474 56 455 37C455 37 455 37 455 37C452 34 448 32 443 32Z"]
  };
  var faKnifeKitchen = {
    prefix: 'fal',
    iconName: 'knife-kitchen',
    icon: [576, 512, [], "f6f5", "M366 322C360 328 360 339 367 345C368 346 368 347 368 348C368 350 368 351 367 352L313 404C262 453 194 480 122 480C93 480 64 475 36 467C34 466 33 464 32 462C32 461 32 459 34 458L265 235C271 229 272 219 266 213C259 206 249 206 243 212L12 435C2 444 -2 457 1 470C4 482 13 493 26 497C57 507 90 512 122 512C202 512 278 482 335 427L389 375C396 368 400 359 400 349C400 338 396 329 389 322C383 316 372 316 366 322ZM561 43L531 14C511 -5 479 -5 459 14L295 172C291 176 288 182 288 188C288 194 291 200 295 205L390 297C395 301 400 303 406 303C412 303 417 301 421 298L452 273C462 264 467 251 467 237V209L561 115C571 105 576 92 576 79C576 65 571 52 561 43ZM538 92L435 196V237C435 242 433 246 431 249L407 268L324 188L481 37C488 30 501 30 509 37L538 66C542 70 544 74 544 79C544 84 542 88 538 92ZM496 64C487 64 480 71 480 80C480 89 487 96 496 96S512 89 512 80C512 71 505 64 496 64ZM432 128C423 128 416 135 416 144C416 153 423 160 432 160S448 153 448 144C448 135 441 128 432 128Z"]
  };
  var faL = {
    prefix: 'fal',
    iconName: 'l',
    icon: [320, 512, [], "e159", "M272 480H16C7 480 0 473 0 464V48C0 39 7 32 16 32S32 39 32 48V448H272C281 448 288 455 288 464S281 480 272 480Z"]
  };
  var faLambda = {
    prefix: 'fal',
    iconName: 'lambda',
    icon: [448, 512, [], "f66e", "M448 464C448 473 441 480 432 480H362C350 480 338 473 333 461L178 125L31 470C28 476 22 480 16 480C14 480 12 480 10 479C2 475 -2 466 1 458L160 86L152 69C151 66 148 64 145 64H16C7 64 0 57 0 48C0 39 7 32 16 32H150C162 32 174 39 179 51L360 443C361 446 364 448 367 448H432C441 448 448 455 448 464Z"]
  };
  var faLamp = {
    prefix: 'fal',
    iconName: 'lamp',
    icon: [448, 512, [], "f4ca", "M445 211L368 19C363 8 352 0 340 0H121C109 0 99 7 94 18L3 210C-7 231 8 256 30 256H208V288H198C171 288 146 302 131 324C109 357 96 395 96 425C96 452 107 479 127 499C135 507 146 512 158 512H290C302 512 313 507 321 499C341 478 352 452 352 425C352 395 339 357 317 324C302 302 277 288 250 288H240V256H418C439 256 454 233 445 211ZM250 320C266 320 281 328 290 342C308 369 320 402 320 425C320 444 312 462 298 477C296 479 293 480 290 480H158C155 480 152 479 150 477C136 462 128 444 128 425C128 402 140 369 158 342C167 328 182 320 198 320H250ZM32 224C32 224 32 224 32 223L122 32H339L416 224H32Z"]
  };
  var faLampDesk = {
    prefix: 'fal',
    iconName: 'lamp-desk',
    icon: [512, 512, [], "e014", "M494 64H369L329 23C297 -8 247 -8 215 23S184 105 215 137L220 141L117 245C113 249 111 255 113 260L175 480H16C7 480 0 487 0 496S7 512 16 512H368C377 512 384 505 384 496S377 480 368 480H208C208 479 208 477 207 476L146 261L243 164L256 177V302C256 307 258 312 261 315C265 318 269 320 274 320S283 318 286 315L346 255C359 265 374 272 392 272C432 272 464 240 464 200C464 182 457 167 447 154L507 94C518 83 510 64 494 64ZM392 240C384 240 375 237 369 232L424 177C429 183 432 192 432 200C432 222 414 240 392 240ZM288 267V164L238 114C220 95 220 65 238 46S287 28 306 46L356 96H459L288 267Z"]
  };
  var faLampFloor = {
    prefix: 'fal',
    iconName: 'lamp-floor',
    icon: [384, 512, [], "e015", "M381 179L313 19C308 8 296 0 283 0H101C88 0 76 8 71 19L3 179C-2 189 -1 201 5 210C11 219 21 224 32 224H176V480H80C71 480 64 487 64 496S71 512 80 512H304C313 512 320 505 320 496S313 480 304 480H208V224H352C363 224 373 219 379 210C385 201 386 189 381 179ZM32 192L101 32H283L352 192L32 192Z"]
  };
  var faLandmark = {
    prefix: 'fal',
    iconName: 'landmark',
    icon: [512, 512, [], "f66f", "M496 480H16C7 480 0 487 0 496C0 505 7 512 16 512H496C505 512 512 505 512 496C512 487 505 480 496 480ZM497 98L265 2C262 1 259 0 256 0S250 1 247 2L15 98C6 102 0 110 0 120V168C0 181 11 192 24 192H64V352C55 352 48 359 48 368C48 377 55 384 64 384H448C457 384 464 377 464 368C464 359 457 352 448 352V192H488C501 192 512 181 512 168V120C512 110 506 102 497 98ZM176 352H96V192H176V352ZM304 352H208V192H304V352ZM416 352H336V192H416V352ZM480 160H32V125L256 33L480 125V160ZM472 448C481 448 488 441 488 432C488 423 481 416 472 416H40C31 416 24 423 24 432C24 441 31 448 40 448H472Z"]
  };
  var faLandmarkDome = {
    prefix: 'fal',
    iconName: 'landmark-dome',
    icon: [512, 512, [], "f752", "M496 480H16C7 480 0 487 0 496C0 505 7 512 16 512H496C505 512 512 505 512 496C512 487 505 480 496 480ZM40 448H472C481 448 488 441 488 432C488 423 481 416 472 416H40C31 416 24 423 24 432C24 441 31 448 40 448ZM48 256H80V352H64C55 352 48 359 48 368C48 377 55 384 64 384H448C457 384 464 377 464 368C464 359 457 352 448 352H432V256H464C473 256 480 249 480 240C480 231 473 224 464 224H448C448 124 370 41 272 33V16C272 7 265 0 256 0S240 7 240 16V33C142 41 64 124 64 224H48C39 224 32 231 32 240C32 249 39 256 48 256ZM240 352H112V256H240V352ZM400 352H272V256H400V352ZM256 64C344 64 416 136 416 224H96C96 136 168 64 256 64Z"]
  };
  var faLanguage = {
    prefix: 'fal',
    iconName: 'language',
    icon: [640, 512, [], "f1ab", "M560 192H496V176C496 167 489 160 480 160S464 167 464 176V192H400C391 192 384 199 384 208S391 224 400 224H514C508 241 496 259 481 276C473 267 466 258 459 248C456 243 449 241 443 245L436 249C430 252 429 260 433 266C440 276 448 287 458 299C448 307 437 316 426 323C421 326 419 333 422 339L426 346C429 352 437 354 443 350C456 342 469 332 481 322C492 332 504 342 517 350C523 354 531 352 534 346L538 339C541 333 540 326 534 323C524 316 513 308 503 299C525 275 541 249 548 224H560C569 224 576 217 576 208S569 192 560 192ZM576 64H64C29 64 0 93 0 128V384C0 419 29 448 64 448H576C611 448 640 419 640 384V128C640 93 611 64 576 64ZM304 416H64C46 416 32 402 32 384V128C32 110 46 96 64 96H304V416ZM608 384C608 402 594 416 576 416H336V96H576C594 96 608 110 608 128V384ZM73 350C81 354 90 351 94 343L114 304H206L226 343C229 349 234 352 240 352C242 352 245 351 247 350C255 346 258 337 254 329L174 169C169 158 151 158 146 169L66 329C62 337 65 346 73 350ZM160 212L190 272H130L160 212Z"]
  };
  var faLaptop = {
    prefix: 'fal',
    iconName: 'laptop',
    icon: [640, 512, [], "f109", "M624 384H16C7 384 0 391 0 400V416C0 451 29 480 64 480H576C611 480 640 451 640 416V400C640 391 633 384 624 384ZM576 448H64C46 448 32 434 32 416H608C608 434 594 448 576 448ZM80 352C89 352 96 345 96 336V96C96 78 110 64 128 64H512C530 64 544 78 544 96V336C544 345 551 352 560 352S576 345 576 336V96C576 61 547 32 512 32H128C93 32 64 61 64 96V336C64 345 71 352 80 352Z"]
  };
  var faLaptopCode = {
    prefix: 'fal',
    iconName: 'laptop-code',
    icon: [640, 512, [], "f5fc", "M389 299C392 302 396 304 400 304S408 302 411 299L475 235C482 229 482 219 475 213L411 149C405 142 395 142 389 149S382 165 389 171L441 224L389 277C382 283 382 293 389 299ZM251 149C245 142 235 142 229 149L165 213C158 219 158 229 165 235L229 299C232 302 236 304 240 304S248 302 251 299C258 293 258 283 251 277L199 224L251 171C258 165 258 155 251 149ZM80 352C89 352 96 345 96 336V96C96 78 110 64 128 64H512C530 64 544 78 544 96V336C544 345 551 352 560 352S576 345 576 336V96C576 61 547 32 512 32H128C93 32 64 61 64 96V336C64 345 71 352 80 352ZM624 384H16C7 384 0 391 0 400V416C0 451 29 480 64 480H576C611 480 640 451 640 416V400C640 391 633 384 624 384ZM576 448H64C46 448 32 434 32 416H608C608 434 594 448 576 448ZM337 123L273 315C270 323 275 332 283 335C285 336 286 336 288 336C295 336 301 332 303 325L367 133C370 125 365 116 357 113C349 110 340 115 337 123Z"]
  };
  var faLaptopMedical = {
    prefix: 'fal',
    iconName: 'laptop-medical',
    icon: [640, 512, [], "f812", "M80 352C89 352 96 345 96 336V96C96 78 110 64 128 64H512C530 64 544 78 544 96V336C544 345 551 352 560 352S576 345 576 336V96C576 61 547 32 512 32H128C93 32 64 61 64 96V336C64 345 71 352 80 352ZM624 384H16C7 384 0 391 0 400V416C0 451 29 480 64 480H576C611 480 640 451 640 416V400C640 391 633 384 624 384ZM576 448H64C46 448 32 434 32 416H608C608 434 594 448 576 448ZM304 320H336C345 320 352 313 352 304V256H400C409 256 416 249 416 240V208C416 199 409 192 400 192H352V144C352 135 345 128 336 128H304C295 128 288 135 288 144V192H240C231 192 224 199 224 208V240C224 249 231 256 240 256H288V304C288 313 295 320 304 320Z"]
  };
  var faLaptopMobile = {
    prefix: 'fal',
    iconName: 'laptop-mobile',
    icon: [640, 512, [], "f87a", "M576 128H448C413 128 384 157 384 192V448C384 483 413 512 448 512H576C611 512 640 483 640 448V192C640 157 611 128 576 128ZM608 448C608 466 594 480 576 480H448C430 480 416 466 416 448V192C416 174 430 160 448 160H576C594 160 608 174 608 192V448ZM96 64C96 46 110 32 128 32H448C466 32 480 46 480 64V80C480 89 487 96 496 96H496C505 96 512 89 512 80V64C512 29 483 0 448 0H128C93 0 64 29 64 64V288H16C7 288 0 295 0 304V320C0 355 29 384 64 384H336C345 384 352 377 352 368V368C352 359 345 352 336 352H64C46 352 32 338 32 320H336C345 320 352 313 352 304V304C352 295 345 288 336 288H96V64Z"]
  };
  var faLaptopSlash = {
    prefix: 'fal',
    iconName: 'laptop-slash',
    icon: [640, 512, [], "e15a", "M512 64A32 32 0 0 1 544 96V331L568 350A16 16 0 0 0 576 336V96A64 64 0 0 0 512 32H165L206 64ZM64 448A32 32 0 0 1 32 416H394L353 384H16A16 16 0 0 0 0 400V416A64 64 0 0 0 64 480H475L434 448ZM96 336V181L64 156V336A16 16 0 0 0 96 336ZM634 483L26 3A16 16 0 1 0 6 29L614 509A16 16 0 0 0 634 483Z"]
  };
  var faLariSign = {
    prefix: 'fal',
    iconName: 'lari-sign',
    icon: [384, 512, [], "e15b", "M384 464C384 473 377 480 368 480H16C7 480 0 473 0 464S7 448 16 448H86C34 414 0 355 0 288C0 205 54 134 128 107V48C128 39 135 32 144 32S160 39 160 48V99C170 97 181 96 192 96S214 97 224 99V48C224 39 231 32 240 32S256 39 256 48V107C330 134 384 205 384 288C384 297 377 304 368 304S352 297 352 288C352 223 312 166 256 142V272C256 281 249 288 240 288S224 281 224 272V131C214 129 203 128 192 128S170 129 160 131V272C160 281 153 288 144 288S128 281 128 272V142C72 166 32 223 32 288C32 376 104 448 192 448H368C377 448 384 455 384 464Z"]
  };
  var faLasso = {
    prefix: 'fal',
    iconName: 'lasso',
    icon: [576, 512, [], "f8c8", "M288 0C129 0 0 79 0 176C0 244 63 303 156 332C223 358 209 420 203 433C192 462 163 480 132 480H48C39 480 32 487 32 496S39 512 48 512H130C178 512 223 482 237 436C246 404 239 372 223 347C244 350 266 352 288 352C447 352 576 273 576 176C576 79 447 0 288 0ZM288 320C149 320 32 254 32 176S149 32 288 32C427 32 544 98 544 176S427 320 288 320Z"]
  };
  var faLassoSparkles = {
    prefix: 'fal',
    iconName: 'lasso-sparkles',
    icon: [576, 512, [], "e15c", "M576 176C576 104 505 42 404 15C394 12 384 20 384 31V31C384 38 389 45 396 46C482 70 544 119 544 176C544 254 427 320 288 320C149 320 32 254 32 176C32 113 108 58 211 39C218 38 224 31 224 23C224 13 215 6 205 8C86 29 0 96 0 176C0 244 63 303 156 332C223 358 209 420 203 433C192 462 163 480 132 480H49C41 480 34 485 32 493C31 503 38 512 48 512H132C180 512 224 481 237 435C246 403 239 372 223 347C244 350 266 352 288 352C447 352 576 273 576 176ZM560 416H512V368C512 359 505 352 496 352S480 359 480 368V416H432C423 416 416 423 416 432S423 448 432 448H480V496C480 505 487 512 496 512S512 505 512 496V448H560C569 448 576 441 576 432S569 416 560 416ZM240 96H288V144C288 153 295 160 304 160S320 153 320 144V96H368C377 96 384 89 384 80S377 64 368 64H320V16C320 7 313 0 304 0S288 7 288 16V64H240C231 64 224 71 224 80S231 96 240 96Z"]
  };
  var faLayers = {
    prefix: 'fal',
    iconName: 'layers',
    icon: [512, 512, [], "f5fd", "M9 142L249 254C251 255 254 256 256 256S261 255 263 254L503 142C508 140 512 134 512 128S508 116 503 114L263 2C258 0 254 0 249 2L9 114C4 116 0 122 0 128S4 140 9 142ZM256 34L458 128L256 222L54 128L256 34ZM503 242L434 210C426 206 417 209 413 217C409 225 413 235 421 239L458 256L256 350L54 256L91 238C99 235 103 225 99 217C95 209 86 206 78 210L9 242C4 244 0 250 0 256S4 268 9 270L249 382C251 383 254 384 256 384S261 383 263 382L503 270C508 268 512 262 512 256S508 244 503 242ZM503 370L434 338C426 334 417 337 413 345C409 353 413 363 421 367L458 384L256 478L54 384L91 366C99 363 103 353 99 345C95 337 86 334 78 337L9 369C4 372 0 378 0 384S4 396 9 398L249 510C251 511 254 512 256 512S261 511 263 510L503 398C508 396 512 390 512 384S508 372 503 370Z"]
  };
  var faLayersMinus = {
    prefix: 'fal',
    iconName: 'layers-minus',
    icon: [512, 512, [], "f5fe", "M503 242L263 130C258 128 254 128 249 130L9 242C4 244 0 250 0 256S4 268 9 270L249 382C251 383 254 384 256 384S261 383 263 382L503 270C508 268 512 262 512 256S508 244 503 242ZM256 350L54 256L256 162L458 256L256 350ZM503 370L434 338C426 334 417 337 413 345C409 353 413 363 421 367L458 384L256 478L54 384L91 366C99 363 103 353 99 345C95 337 86 334 78 337L9 369C4 372 0 378 0 384S4 396 9 398L249 510C251 511 254 512 256 512S261 511 263 510L503 398C508 396 512 390 512 384S508 372 503 370ZM368 96H496C505 96 512 89 512 80S505 64 496 64H368C359 64 352 71 352 80S359 96 368 96Z"]
  };
  var faLayersPlus = {
    prefix: 'fal',
    iconName: 'layers-plus',
    icon: [512, 512, [], "f5ff", "M503 242L263 130C258 128 254 128 249 130L9 242C4 244 0 250 0 256S4 268 9 270L249 382C251 383 254 384 256 384S261 383 263 382L503 270C508 268 512 262 512 256S508 244 503 242ZM256 350L54 256L256 162L458 256L256 350ZM503 370L434 338C426 334 417 337 413 345C409 353 413 363 421 367L458 384L256 478L54 384L91 366C99 363 103 353 99 345C95 337 86 334 78 337L9 369C4 372 0 378 0 384S4 396 9 398L249 510C251 511 254 512 256 512S261 511 263 510L503 398C508 396 512 390 512 384S508 372 503 370ZM368 96H416V144C416 153 423 160 432 160S448 153 448 144V96H496C505 96 512 89 512 80S505 64 496 64H448V16C448 7 441 0 432 0S416 7 416 16V64H368C359 64 352 71 352 80S359 96 368 96Z"]
  };
  var faLeaf = {
    prefix: 'fal',
    iconName: 'leaf',
    icon: [512, 512, [], "f06c", "M486 41C485 40 484 37 482 36C478 33 474 31 469 32C464 33 460 36 457 40C432 86 386 112 331 112H263C171 112 96 188 96 281C96 287 96 292 97 298C49 339 14 396 0 461C-1 469 4 478 13 480C14 480 15 480 16 480C23 480 30 475 32 467C43 415 69 370 105 334C108 343 111 352 116 360C116 360 116 360 116 360C145 414 201 448 263 448C269 448 275 448 280 447C414 437 512 319 512 167C512 124 503 78 486 41ZM277 415C272 416 268 416 263 416C213 416 168 389 144 345C138 333 134 322 131 311C177 277 233 256 293 256H336C345 256 352 249 352 240S345 224 336 224H293C233 224 176 242 129 274C133 203 192 144 263 144H331C386 144 434 121 467 82C475 109 480 138 480 167C480 302 395 407 277 415Z"]
  };
  var faLeafHeart = {
    prefix: 'fal',
    iconName: 'leaf-heart',
    icon: [512, 512, [], "f4cb", "M304 204C261 161 228 178 214 189C186 212 185 253 209 278L294 364C300 369 308 369 314 364L399 278C423 253 422 212 394 189C380 178 346 161 304 204ZM376 256L304 328L232 256C222 245 220 226 234 214C248 202 265 210 273 217L304 249L335 217C343 210 360 202 374 214C388 226 386 245 376 256ZM486 41C485 40 484 37 482 36C478 33 474 31 469 32C464 33 460 36 457 40C432 86 386 112 331 112H263C171 112 96 188 96 281C96 287 96 292 97 298C49 340 14 396 0 461C-1 469 4 478 13 480C14 480 15 480 16 480C23 480 30 475 32 467C43 416 69 371 105 335C108 344 111 352 116 360C116 360 116 360 116 360C145 414 201 448 263 448C269 448 275 448 280 447C414 437 512 319 512 167C512 124 503 78 486 41ZM277 415C272 416 268 416 263 416C213 416 168 389 144 345C131 320 128 297 128 281C128 207 190 144 263 144H331C386 144 434 121 467 82C475 109 480 138 480 167C480 302 395 407 277 415Z"]
  };
  var faLeafMaple = {
    prefix: 'fal',
    iconName: 'leaf-maple',
    icon: [512, 512, [], "f6f6", "M466 175L442 161L449 94C451 78 439 62 421 62C420 62 419 62 418 63L351 70L337 46C332 37 323 32 313 32C303 32 293 37 288 45L251 104C245 90 233 85 223 85C219 85 216 86 213 88L201 94L171 59C165 52 157 49 148 49C139 49 131 52 126 59L95 94L83 88C80 86 77 85 73 85C58 85 40 100 45 120L70 245L49 254C26 264 26 297 49 307L143 347L37 453C30 459 30 469 37 475C40 478 44 480 48 480S56 478 59 475L165 369L205 463C210 473 220 480 232 480S253 473 258 463L267 442L392 467C394 468 396 468 398 468C416 468 433 450 426 432L418 417L453 386C467 375 467 353 453 342L418 311L424 299C430 288 425 268 408 261L467 224C485 212 484 186 466 175ZM390 234L336 269L393 290L390 296L378 318L397 335L430 364L397 393L378 409L389 431L391 435L273 410L248 405L238 429L232 443L194 355C193 352 191 349 188 346L315 219C322 213 322 203 315 197C309 190 299 190 293 197L166 324C163 321 160 319 157 318L69 280L83 274L107 264L102 239L77 121L80 122L102 134L119 115L148 82L177 115L194 134L216 122L222 119L243 176L277 122L312 67L324 86L335 104L355 102L417 95L410 157L408 177L426 188L445 200L390 234Z"]
  };
  var faLeafOak = {
    prefix: 'fal',
    iconName: 'leaf-oak',
    icon: [512, 512, [], "f6f7", "M480 213C476 180 447 166 441 162C453 119 437 96 426 86C423 83 400 57 350 72C346 65 332 36 299 32C259 28 243 58 224 91C217 86 198 71 173 76C108 89 124 179 125 189C93 180 60 201 60 246C60 280 86 310 79 327C68 358 69 387 82 408L37 453C30 459 30 469 37 475C40 478 44 480 48 480C52 480 56 478 59 475L104 430C116 437 129 441 144 441C157 441 171 438 185 433C202 426 231 451 266 451C313 451 331 417 323 387C326 387 339 389 355 389C386 389 428 381 436 339C437 333 440 313 421 288C453 270 484 254 480 213ZM408 259C404 261 410 258 372 279L396 308C401 315 406 324 405 333C403 340 400 357 355 357C344 357 335 356 330 355C325 355 332 355 280 350C293 397 296 402 290 411C286 416 277 419 266 419C255 419 243 415 231 410C216 404 194 395 174 403C145 413 129 406 129 406L315 219C322 213 322 203 315 197S299 190 293 197L106 384C102 371 103 356 109 338C117 318 109 299 102 281C97 269 92 257 92 246C92 236 95 228 99 224C109 214 122 221 162 232C155 164 146 114 179 107C190 105 201 114 204 116L233 140C254 102 251 108 253 104C271 74 278 64 291 64H291C307 64 315 74 323 88L336 109L359 102C386 94 398 103 404 109C410 114 417 127 410 153L403 176C427 191 423 189 426 190C436 196 446 204 448 217C449 232 443 239 408 259Z"]
  };
  var faLeft = {
    prefix: 'fal',
    iconName: 'left',
    icon: [448, 512, [], "f355", "M416 176H240V96C240 78 226 64 208 64C200 64 191 67 185 73L9 233C3 240 0 248 0 256S3 272 9 279L185 439C191 445 200 448 208 448C226 448 240 434 240 416V336H416C434 336 448 322 448 304V208C448 190 434 176 416 176ZM416 304H208L207 415L32 256L208 96V208H416V304Z"]
  };
  var faLeftFromLine = {
    prefix: 'fal',
    iconName: 'left-from-line',
    icon: [448, 512, [], "f348", "M432 64C423 64 416 71 416 80V432C416 441 423 448 432 448S448 441 448 432V80C448 71 441 64 432 64ZM323 192H208V134C208 119 199 105 185 99C171 93 155 96 145 106L11 229C4 236 0 246 0 256S4 276 12 283L145 406C155 416 171 419 185 413C199 407 208 393 208 378V320H323C348 320 368 300 368 275V237C368 212 348 192 323 192ZM336 275C336 282 330 288 323 288H176V378C176 381 175 383 173 384C171 384 168 384 166 382L33 260C32 258 32 254 33 252L167 130C168 128 171 128 173 128C175 129 176 131 176 134V224H323C330 224 336 230 336 237V275Z"]
  };
  var faLeftLong = {
    prefix: 'fal',
    iconName: 'left-long',
    icon: [512, 512, [], "f30a", "M512 232V280C512 302 494 320 472 320L192 320V360C192 376 182 390 168 397C153 403 136 400 124 389L12 285C4 278 0 267 0 256C0 245 4 234 12 227L124 123C136 112 153 109 168 115C182 122 192 136 192 152V192L472 192C494 192 512 210 512 232ZM31 256C31 257 32 260 34 262L146 366C151 371 160 367 160 360V288L472 288C476 288 480 284 480 280V232C480 228 476 224 472 224L160 224V152C160 145 151 141 146 146L34 250C32 252 31 255 31 256Z"]
  };
  var faLeftRight = {
    prefix: 'fal',
    iconName: 'left-right',
    icon: [512, 512, [], "f337", "M504 238L392 134C385 128 375 126 366 130S352 142 352 152V240H160V152C160 142 154 134 146 130S127 128 120 134L8 238C3 243 0 250 0 256S3 269 8 274L120 378C127 384 137 386 146 382S160 370 160 360V272H352V360C352 370 358 378 366 382S385 384 392 378L504 274C509 269 512 262 512 256S509 243 504 238ZM128 342L36 256L128 170V342ZM384 342V170L476 256L384 342Z"]
  };
  var faLeftToLine = {
    prefix: 'fal',
    iconName: 'left-to-line',
    icon: [448, 512, [], "f34b", "M91 229C84 236 80 246 80 256S84 276 92 283L225 406C235 416 251 419 265 413C279 407 288 393 288 378V320H403C428 320 448 300 448 275V237C448 212 428 192 403 192H288V134C288 119 279 105 265 99C251 93 235 96 225 106L91 229ZM253 128C255 129 256 131 256 134V224H403C410 224 416 230 416 237V275C416 282 410 288 403 288H256V378C256 381 255 383 253 384C251 384 248 384 246 382L113 260C112 258 112 254 113 252L247 130C248 128 251 128 253 128ZM32 432V80C32 71 25 64 16 64S0 71 0 80V432C0 441 7 448 16 448S32 441 32 432Z"]
  };
  var faLemon = {
    prefix: 'fal',
    iconName: 'lemon',
    icon: [448, 512, [], "f094", "M428 52C415 39 398 32 383 32C376 32 368 34 362 37C336 52 297 41 248 41C199 41 142 52 81 113C-41 236 35 343 5 394C-5 412 0 440 20 460C33 473 50 480 65 480C72 480 80 478 86 475C112 460 151 471 200 471C249 471 306 460 367 399C489 276 413 169 443 118C453 100 448 72 428 52ZM415 102C400 128 402 158 405 190C410 244 415 306 344 376C288 432 238 439 200 439C172 439 146 435 122 435C109 435 88 436 70 447C67 449 55 449 43 437C31 426 31 414 33 410C48 384 46 354 43 322C38 268 33 206 104 136C160 80 210 73 248 73C276 73 302 77 326 77C339 77 360 76 378 65C381 63 393 63 405 75C417 86 417 98 415 102ZM228 105C165 120 88 197 73 260C70 269 75 277 84 280C91 282 101 278 104 268C116 217 185 148 236 136C244 133 250 125 248 116C246 111 239 101 228 105Z"]
  };
  var faLessThan = {
    prefix: 'fal',
    iconName: 'less-than',
    icon: [640, 512, [], "f536", "M511 423C508 429 502 432 496 432C494 432 492 432 489 431L137 271C132 268 128 262 128 256C128 250 132 244 137 241L489 81C497 78 507 81 511 89C514 97 511 107 503 111L183 256L503 401C511 405 514 415 511 423Z"]
  };
  var faLessThanEqual = {
    prefix: 'fal',
    iconName: 'less-than-equal',
    icon: [448, 512, [], "f537", "M42 207L394 351C396 352 398 352 400 352C406 352 412 348 415 342C418 334 414 325 406 321L90 192L406 63C414 60 418 50 415 42C411 34 402 30 394 33L42 177C36 180 32 186 32 192C32 199 36 204 42 207ZM432 448H16C7 448 0 455 0 464C0 473 7 480 16 480H432C441 480 448 473 448 464C448 455 441 448 432 448Z"]
  };
  var faLifeRing = {
    prefix: 'fal',
    iconName: 'life-ring',
    icon: [512, 512, [], "f1cd", "M436 414C473 372 496 317 496 256S473 140 436 98L443 91C450 85 450 75 443 69S427 62 421 69L414 76C372 39 317 16 256 16S140 39 98 76L91 69C85 62 75 62 69 69S62 85 69 91L76 98C39 140 16 195 16 256S39 372 76 414L69 421C62 427 62 437 69 443C72 446 76 448 80 448S88 446 91 443L98 436C140 473 195 496 256 496S372 473 414 436L421 443C424 446 428 448 432 448S440 446 443 443C450 437 450 427 443 421L436 414ZM464 256C464 308 445 355 414 391L334 311C345 296 352 277 352 256S345 216 334 201L414 121C445 157 464 204 464 256ZM192 256C192 221 221 192 256 192S320 221 320 256S291 320 256 320S192 291 192 256ZM256 48C308 48 355 67 391 98L311 178C296 167 277 160 256 160S216 167 201 178L121 98C157 67 204 48 256 48ZM48 256C48 204 67 157 98 121L178 201C167 216 160 235 160 256S167 296 178 311L98 391C67 355 48 308 48 256ZM256 464C204 464 157 445 121 414L201 334C216 345 235 352 256 352S296 345 311 334L391 414C355 445 308 464 256 464Z"]
  };
  var faLightCeiling = {
    prefix: 'fal',
    iconName: 'light-ceiling',
    icon: [512, 512, [], "e016", "M272 161V16C272 7 265 0 256 0S240 7 240 16V161C117 168 18 260 0 378C-3 398 12 416 32 416H480C499 416 515 399 512 380C495 261 395 168 272 161ZM32 384C48 275 144 192 256 192S464 275 480 384L32 384ZM324 433C316 430 307 435 304 444C299 465 279 480 256 480S213 465 207 444C205 435 196 430 188 433C179 435 174 444 176 452C186 487 219 512 256 512S326 487 335 452C338 444 333 435 324 433Z"]
  };
  var faLightSwitch = {
    prefix: 'fal',
    iconName: 'light-switch',
    icon: [384, 512, [], "e017", "M240 96H144C118 96 96 118 96 144V368C96 394 118 416 144 416H240C266 416 288 394 288 368V144C288 118 266 96 240 96ZM256 368C256 377 249 384 240 384H144C135 384 128 377 128 368V272H256V368ZM256 240H128V144C128 135 135 128 144 128H240C249 128 256 135 256 144V240ZM320 0H64C29 0 0 29 0 64V448C0 483 29 512 64 512H320C355 512 384 483 38